import requests

from source.config import *
from source.monitoring.monitoring import SimpleYTBasedCollector
from source.utils import exc_thread_wrapper

logger = logging.getLogger(__name__)

MONITOR_MAPPING = {'U2414H': 'actual', 'P24h-10 (F16238QP1)': 'actual',
                  'U2515H': 'actual', 'U2312HM': 'actual',
                  'P27u-10 (A16270UP0)': 'actual', 'P2715Q': 'actual',
                  '2007FP': 'non_actual', 'U2518D': 'actual',
                  'U2718Q': 'actual',
                  'Thunderbolt Display 27 (MC914ZE/B)': 'actual',
                  'P2717H': 'actual', '1970NXp': 'non_actual',
                  'P2314H': 'actual', 'U2715H': 'actual',
                  'Cinema Display 27 (MC007ZE/A)': 'actual',
                  'U2412M': 'actual',
                  'Thunderbolt Display 27 (MC914ZE/A)': 'actual',
                  'M2470SWH': 'actual', 'P2415Qb': 'actual',
                  'S24C450B': 'non_actual', 'P2250': 'non_actual',
                  'P2414H': 'actual', 'U2713HM': 'actual',
                  'Thunderbolt Display 27 (MC914LL/A)': 'actual',
                  'Thunderbolt Display 27 (MC914ZM/A)': 'actual',
                  '2693HM': 'non_actual', 'P2412H': 'non_actual',
                  '72VM': 'non_actual', 'PA279Q': 'non_actual',
                  'F2380': 'non_actual', '92VM': 'non_actual',
                  'U2410': 'non_actual', '2007WFP': 'non_actual',
                  '2408WFP': 'non_actual', 'P2018H': 'non_actual',
                  'P2017H': 'non_actual', 'P2418HZ': 'non_actual',
                  '1704M': 'non_actual', '940FN': 'non_actual',
                  'UP2414Q': 'non_actual', '71VM': 'non_actual',
                  'P2417H': 'non_actual', 'U2417H': 'non_actual',
                  'K192HQL': 'non_actual', 'Nitro RG240Ybmiix': 'non_actual',
                  'Thunderbolt Display 27 (MC914LL/B)': 'actual',
                  'Thunderbolt Display 27 (MC914)': 'actual',
                  'BL902M': 'non_actual', 'G2420HD': 'non_actual',
                  'GL2450HM': 'non_actual', 'E1715S': 'non_actual',
                  'E2218HN': 'non_actual', 'P2217H': 'non_actual',
                  'P2815Q': 'non_actual', 'UP3216Q': 'non_actual',
                  'LP2475w': 'non_actual', 'P27h-10 (A16270QP1)': 'non_actual',
                  '1970NX': 'non_actual', '273V5LSB': 'non_actual',
                  '278E8Q': 'non_actual', 'B1930': 'non_actual',
                  'B1940R': 'non_actual', 'C24F390FHI': 'non_actual',
                   '1970NXP':'non_actual',"A16270UP0":"actual",
                   "F16238QP1":"actual","MC914ZE/B":"actual",
                   "MC007ZE/A":"actual","MC914ZE/A":"actual",
                   "P2415QB":"actual","MC914LL/A":"actual",
                   "MC914ZM/A":"actual"}

YT_CLIENT = make_hahn_client()

class OebsEquipsYTCollector(SimpleYTBasedCollector):
    def __init__(self):
        super().__init__(yt_table_name='cmdb/equipment', recreate=False, client=YT_CLIENT)
        self.schema = [{'name': 'instance_number', 'type': 'string','sort_order': 'ascending'},
                       {'name': 'SN', 'type': 'string'},
                       {'name': 'ext_login', 'type': 'string'},
                       {'name': 'MACs', 'type': 'string'},
                       {'name': 'hw_type', 'type': 'string'},
                       {'name': 'status_name', 'type': 'string'},
                       {'name': 'oebs_login', 'type': 'string'},
                       {'name': 'org_name', 'type': 'string'},
                       {'name': 'loc_segment1', 'type': 'string'},
                       {'name': 'loc_segment2', 'type': 'string'},
                       {'name': 'loc_segment3', 'type': 'string'},
                       {'name': 'loc_segment4', 'type': 'string'},
                       {'name': 'loc_segment5', 'type': 'string'},
                       {'name': 'loc_segment6', 'type': 'string'},
                       {'name': 'loc_segment7', 'type': 'string'},
                       {'name': 'segment1', 'type': 'string'},
                       {'name': 'segment2', 'type': 'string'},
                       {'name': 'creation_date', 'type': 'string'},
                       {'name': 'active_start_date', 'type': 'string'},
                       {'name': 'active_end_date', 'type': 'string'},
                       {'name': 'last_ticket_number', 'type': 'string'},
                       {'name': 'last_assign_date', 'type': 'string'},
                       {'name': 'fqdn', 'type': 'string'},
                       {'name': 'tech_support_date', 'type': 'string'},
                       {'name': 'vendor', 'type': 'string'},
                       {'name': 'model', 'type': 'string'},
                       {'name': 'eq_status', 'type': 'string'}
                       ]

    def _additional_fields(self, record):
        eq_status = MONITOR_MAPPING.get(record["model"])
        if not eq_status and record['hw_type'] == "USR.DISPLAYS":
            eq_status = "unknown"
        return {"eq_status": eq_status}

    def _analyze_one_record(self, record):
        if record['hw_type'] in ['USR.NOTEBOOKS', 'USR.DESKTOPS']: return None
        result = self._additional_fields(record)

        for item in record:
            lower_item = item.lower()
            if lower_item in [x["name"] for x in self.schema]:
                result[lower_item] = record[item]
        return result

    def _fetch_data(self):
        result = []
        data = requests.get(
            'https://bot.yandex-team.ru/api/view.php?name=view_hd_hardware&format=json',
            headers=AUTH_HEADERS_BOT).json()

        for count, item in enumerate(data):
            analyzed_item = self._analyze_one_record(item)
            if analyzed_item: result.append(analyzed_item)
        return result

    def main(self):
        data = self._fetch_data()
        logger.info("Start upload to YT")
        self.write_data_to_yt(data)


@exc_thread_wrapper
def main_cmdb_equip():
    logger.info('CMDB Equip sync started')
    OebsEquipsYTCollector().main()
