from source.safe_schedule import SafeScheduler, run_threaded

from source.cmdb.staff.offices import main_staff_offices
from source.cmdb.staff.rooms import main_staff_rooms
from source.cmdb.staff.persons import main_staff_persons
from source.cmdb.st import sync_st_to_static
from source.cmdb.jss.mobile_devices import main_jss_mobile_devices
from source.cmdb.jss.mobile_other_nodes import main_different_mobile_devices
from source.cmdb.soft_oebs import main_cmdb_soft
from source.cmdb.oebs.equipment import main_cmdb_equip

from source.cmdb.cmdb import (
    main_nanimator,
    main_certificator,
    main_cmdb_notebooks,
    main_sync_st_from_markov,
    main_hypercube_yt,
    main_sccm_soft_yt,
    main_repair_collector
)

scheduler = SafeScheduler()

scheduler.every(3).hours.do(run_threaded, main_staff_offices)
scheduler.every(3).hours.do(run_threaded, main_cmdb_soft)
scheduler.every(6).hours.do(run_threaded, sync_st_to_static)
scheduler.every(6).hours.do(run_threaded, main_staff_rooms)
scheduler.every().day.at("4:00").do(run_threaded, main_jss_mobile_devices)
scheduler.every().day.at("4:00").do(run_threaded, main_different_mobile_devices)
scheduler.every().day.at("3:00").do(run_threaded, main_nanimator)
scheduler.every().day.at("3:00").do(run_threaded, main_certificator)
scheduler.every(3).hours.do(run_threaded, main_cmdb_notebooks)
scheduler.every(3).hours.do(run_threaded, main_cmdb_equip)
scheduler.every().day.at("5:00").do(run_threaded, main_sync_st_from_markov)
scheduler.every().day.at("5:00").do(run_threaded, main_hypercube_yt)
scheduler.every().day.at("5:10").do(run_threaded, main_sccm_soft_yt)
scheduler.every(3).hours.do(run_threaded, main_staff_persons)
scheduler.every().day.at("5:15").do(run_threaded, main_repair_collector)

jobs_cmdb = scheduler.jobs