import requests

from source.monitoring.monitoring import SimpleYTBasedCollector, computeMD5hash
from source.utils import exc_thread_wrapper
from source.config import *

logger = logging.getLogger(__name__)

YT_CLIENT = make_hahn_client()

class OebsSoftYTCollector(SimpleYTBasedCollector):
    def __init__(self):
        super().__init__(yt_table_name='cmdb/soft_oebs', recreate=False, client=YT_CLIENT)
        self.schema = [
            {'name': 'hash', 'type': 'string',
             'sort_order': 'ascending'},
            {'name': 'inv_num_lic', 'type': 'string'},
            {'name': 'lic_type', 'type': 'string'},
            {'name': 'org_table', 'type': 'string'},
            {'name': 'inv_number', 'type': 'string'},
            {'name': 'login_oebs', 'type': 'string'},
            {'name': 'segment1', 'type': 'string'},
            {'name': 'segment2', 'type': 'string'},
            {'name': 'timestamp', 'type': 'string'},
            {'name': 'status_name', 'type': 'string'},
            {'name': 'cfo', 'type': 'string'},
            {'name': 'can_be_negative', 'type': 'string'},
            {'name': 'sublicensing_to_bu', 'type': 'string'},
            {'name': 'operatingsystem', 'type': 'string'},
            {'name': 'active_end_date', 'type': 'string'},
            {'name': 'description', 'type': 'string'},
            {'name': 'tech_end_date', 'type': 'string'}
        ]

    def _delete_old_records(self, new_data_raw):
        old_data = list(YT_HAHN_CLIENT.select_rows(
            'hash from [{}]'.format(
                '//home/helpdesk/cmdb/soft_oebs'),
            format=yt.JsonFormat(attributes={"encode_utf8": False})
        ))
        new_data = [x["hash"] for x in new_data_raw]

        diff = [x for x in old_data if x["hash"] not in new_data]
        YT_HAHN_CLIENT.delete_rows(self.yt_table,
                                    diff,
                                    format=yt.JsonFormat(attributes={"encode_utf8": False})
                                    )

    def _fetch_data(self):
        result = []
        results = requests.get(
            'https://bot.yandex-team.ru/api/view.php?name=view_hd_soft&format=json',
            headers=AUTH_HEADERS_BOT).json()
        approved_keys = [x['name'] for x in self.schema]

        for record in results:
            midd_dict = {key: record[key] for key in record if
                         key in approved_keys}
            midd_dict["hash"] = computeMD5hash('{}{}{}{}'.format(
                record['inv_num_lic'],
                record['inv_number'],
                record['login_oebs'],
                record['timestamp']
            ))
            result.append(midd_dict)
        return result

    def main(self):
        data = self._fetch_data()
        self._delete_old_records(data)

        self.check_or_create_table()
        self.write_data_to_yt(data)

@exc_thread_wrapper
def main_cmdb_soft():
    logger.info('CMDB Soft sync started')
    OebsSoftYTCollector().main()
