import os
import sys
import logging.config
import yt.wrapper as yt
from startrek_client import Startrek, exceptions

#MACROS ID
MACROS_ID_KRAKEN = '448'
WSDL_URL = 'https://miracle.yandex.ru/FolderCheck/Service.asmx?WSDL'
STAFF_URL = 'https://staff-api.yandex-team.ru/v3/'
ST_URL = 'https://st-api.yandex-team.ru/v2/'
OAUTH_TOOLS = os.environ['toolsoauth']
BOT_OAUTH = os.environ['botoauth']
OAUTH_CREATIVE_TOOLS = os.environ['robotcreativeoauthst']
STAT_USER = os.environ['statuser']
STAT_PWD = os.environ['statpwd']
MIRACLE_USER = os.environ['miracleuser']
MIRACLE_PASSWORD = os.environ['miraclepassword']
VM_ZOO_OFR_USER = os.environ['vmzooofruser']
VM_ZOO_OFR_PWD = os.environ['vmzooofrpwd']
YT_OAUTH = os.environ['yttoken']
CRT_OAUTH = os.environ.get('crtoauth')
TEMP_OAUTH = os.environ.get('tmpoauth')
ROBOT_HELP_PWD = os.environ.get('robothelppwd')
PRIVATE_KEY = '/etc/ssh/robot-help/id_rsa'

AUTH_HEADERS_TOOLS = {
            "Authorization": 'OAuth {}'.format(OAUTH_TOOLS)
        }
AUTH_HEADERS_BOT = {
            "Authorization": 'OAuth {}'.format(BOT_OAUTH)
        }
AUTH_HEADERS_CRT = {
            "Authorization": 'OAuth {}'.format(CRT_OAUTH)
        }

LOG_FORMAT = os.environ.get('QLOUD_LOGGER_STDOUT_PARSER', 'default')

yt.config["proxy"]["url"] = "freud"
yt.config["token"] = YT_OAUTH

userag = 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.12785 YaBrowser/13.12.1599.12785 Safari/537.36'

st_client = Startrek(useragent=userag,
                  base_url='https://st-api.yandex-team.ru',
                  token=OAUTH_TOOLS)
YT_MARKOV_CLIENT = yt.client.YtClient(proxy=None, token=None, config=None)
YT_MARKOV_CLIENT.config["proxy"]["url"] = "markov"
YT_MARKOV_CLIENT.config["token"] = YT_OAUTH

YT_VANGA_CLIENT = yt.client.YtClient(proxy=None, token=None, config=None)
YT_VANGA_CLIENT.config["proxy"]["url"] = "vanga"
YT_VANGA_CLIENT.config["token"] = YT_OAUTH

YT_HAHN_CLIENT = yt.client.YtClient(proxy=None, token=None, config=None)
YT_HAHN_CLIENT.config["proxy"]["url"] = "hahn"
YT_HAHN_CLIENT.config["token"] = YT_OAUTH

LOGGING = {
    'version': 1,
    'disable_existing_loggers': True,
    'formatters': {
        'default': {
            '()': 'ylog.context.ContextFormatter',
            'datefmt': '%Y-%m-%d %H:%M:%S',
            'format': '[%(asctime)s][%(name)s] - %(levelname)s - %(message)s',
        },
        'json': {
            '()': 'ylog.format.QloudJsonFormatter',
         },
    },
    'handlers': {
        'stdout': {
            'class': 'logging.StreamHandler',
            'formatter': LOG_FORMAT,
            'stream': sys.stdout,
        },
        'mail': {
            'level': 'ERROR',
            'class': 'logging.handlers.SMTPHandler',
            'mailhost': ('outbound-relay.yandex.net', 25),
            'fromaddr': 'django-alarm@yandex-team.ru',
            'toaddrs': ['techadmin-reccur@yandex-team.ru', ] if os.environ.get(
                'type') == "production" else [
                'techadmin-reccur-dev@yandex-team.ru', ],
            'subject': 'Error on hdportal_reccur',
        }
    },
    'loggers':{
        'startrek_client.connection': {
                        'handlers': ['stdout'],
                        'level':'CRITICAL'
                },
        'googleapiclient': {
                        'handlers': [],
                        'level':'ERROR'
                },
        'schedule': {
                        'handlers': ['mail'],
                        'level':'ERROR'
                        },
        '': {
                        'handlers': ['stdout'],
                        'level': 'INFO',
                    },
    }

}

logging.config.dictConfig(LOGGING)

def make_hahn_client():
    client = yt.client.YtClient(proxy=None, token=None, config=None)
    client.config["proxy"]["url"] = "hahn"
    client.config["token"] = YT_OAUTH
    return client
