import requests
import logging
import re
import time

from source.utils import (OtherUtils,
                   StartrekUtils,
                   get_staff_office_id_by_login,
                   )

from source.config import *

logger = logging.getLogger(__name__)

MACROS_ID = 149 # ST macros MIR_FileDisUser

def processing_task_miracle_folder(task):
    time.sleep(1)
    # search login in description task
    line_with_login = re.search('https://staff.yandex-team.ru/[a-z0-9-]*', task.description)
    login = re.split('/', line_with_login.group())
    login = login[-1]
    if login:
        office_id = get_staff_office_id_by_login(login) # get office_id by login
        fix_version = OtherUtils().get_fix_version_by_office_id(office_id) # get fixVersion by office_id
        macros_actions = StartrekUtils().get_st_macros_actions(MACROS_ID) # get actions for macros MIR_FileDisUser
        fix_version.update(macros_actions["Result"]) # Merge fix_version and macros_actions
        try:
            task.update(**fix_version)
        except Exception as error:    
            logger.error('Cannot set fixVersion {} for task: {}'.format(fix_version, task.key))
        logger.info('Check what user: {} will be dismissal'.format(login))
        # check that the employee is fired on staff.
        check_dismiss = OtherUtils().login_is_dismissed(login)
        if check_dismiss:
            logger.info('Need check folder for {}'.format(login))
            # check miracle user folder
            check_folder = OtherUtils().check_miracle_users_folder(login)
            if check_folder:
                logger.info('Folder \\\\miracle.yandex.ru\\Users\\{} exist'.format(login))
            else:
                logger.info('Folder \\\\miracle.yandex.ru\\Users\\{} not exist'.format(login))
                task.comments.create(
                    text = 'Личной папки %%\\\\miracle.yandex.ru\\Users\\{}%% не существует.'.format(login)
                )
                try:
                    task.transitions['resolved'].execute()
                except exceptions.NotFound as error:
                    logger.warning('Can not close issue {}. Possible already close. STError: {}'.format(task.key, error))
        else:
            logger.info('Staff api return "is_dismissed False"')
            task.comments.create(
                text = 'Сотрудник {}@ не уволен по стаффу.'.format(login)
            )
            try:
                task.transitions['resolved'].execute()
            except exceptions.NotFound as error:
                logger.warning('Can not close issue {}. Possible already close. STError: {}'.format(task.key, error))
            
    else:
        logger.error('Not found login in task: {}'.format(task.key))
        raise Exception('Dismissal user in task {} not found'.format(task.key))
