from source.config import st_client, exceptions, AUTH_HEADERS_BOT
from bs4 import BeautifulSoup
import re
import requests
import json
import logging
from source.utils import StartrekUtils, OtherUtils, exc_thread_wrapper

logger = logging.getLogger('Dismissal Pinger')

# фикс версии где пользователи сами приносят оборудование
fv_with_self_return = {
    53070,
    53053,
    53063
}

# fv где есть грузчик
fv_with_loaders = {
    53060,
    60938
}

# список актуального оборудования
actual_hardware = {
    'NOTEBOOKS': {
        'APPLE - MACBOOK PRO 13 RETINA': {'Z0QP000C1', 'Z0QN000CK', 'Z0QM002RV'},
        'APPLE - MACBOOK PRO 15 RETINA': {'MJLT2RU/A', 'MJLT2RU/A', 'MJLQ2RU/A', 'Z0RF000E9'},
        'APPLE - MACBOOK PRO 13 RETINA TOUCH': {},
        'APPLE - MACBOOK PRO 15 RETINA TOUCH': {},
        'DELL - LATITUDE': {'E7270', 'E7280', 'E7380', 'E7470', 'E7480', '7280', '7380'},
        'LENOVO - THINKPAD': {'T550', 'T560', 'T570 (20HAS20T00)', 'T580 (20LASV0Y00)',
                              'X1 Carbon 4th Gen (20FCS1DW00)', 'X1 Carbon 4th Gen (20FCS52M00)',
                              'X1 Carbon 5th Gen (20HQ-S47H00)', 'X1 Carbon 5th Gen (20HQS6Y800)',
                              'X1 Carbon 6th Gen (20KGS6PC00)', 'X1 Carbon 6th Gen (20KGS4JC00)'},
        'DELL - XPS': {}
    },
    'DISPLAYS': {
        'LENOVO': {'P24h-10 (F16238QP1)', 'P27u-10 (A16270UP0)'},
        'DELL': {'U2718Q', 'U2518D', 'U2515H', 'U2414H', 'P2715Q'},
        'APPLE': {}
    }
}


class User(object):
    def __init__(self, login):
        self.login = login
        self.fix_version = None
        self.head = None
        self.table = None
        self.business_unit = None
        self.dismissal_date = ''
        self.current_office = None
        self.hw_dictionary = {
            'may_take_by_loaders_template': [],
            'mobile_template': [],
            'self_delivery_template': [],
            'buying_template': [],
            'zmb_and_plasma_template': []
        }
        self.hardware_count = 0
        self.error = None

    def get_info_from_staff(self):
        logger.info('Запрос информации со staff о {}'.format(self.login))
        fields = {
            'business_unit': 'department_group.ancestors.name',
            'office_id': 'location.office.id',
            'table': 'location.table.number'
        }
        staff_info = OtherUtils().extract_data_from_staff_by_login(self.login, fields)

        self.head = OtherUtils().get_head_by_login(self.login)

        self.fix_version = OtherUtils().get_fix_version_by_office_id(staff_info['office_id'])

        self.current_office = staff_info['office_id']

        self.table = staff_info['table']

        try:
            self.business_unit = staff_info['business_unit'][0]["name"]
        except TypeError:
            self.business_unit = None

    # получение списка оборудования из бота
    def get_hardware_bot(self):
        logger.info('Запрос оборудования пользователя {} из bot'.format(self.login))
        staff_api = "https://bot.yandex-team.ru/api/"
        api_url = staff_api + "sat/inventory_by_login.php?login=" + self.login

        head_json = requests.get(api_url, headers=AUTH_HEADERS_BOT)
        data = json.loads(head_json.text)
        self.hardware_count = len(data['result'])
        for instance in data['result']:
            inventory_number = instance['instance_number']
            hw_type = instance['item_segment3']
            vendor = instance['item_segment2']
            model = instance['item_segment1']

            switch_template = {
                'NOTEBOOKS': 'self_delivery_template',
                'MOBILE': 'mobile_template'
            }
            try:
                template = switch_template[hw_type]
            except KeyError:
                template = 'may_take_by_loaders_template'

            if (hw_type == 'PRESENTATION' or hw_type == 'DESKTOPS') and (vendor == 'INTEL' or vendor == 'PLASMA'):
                template = 'zmb_and_plasma_template'

            try:
                list_of_models = actual_hardware[hw_type][vendor]
            except KeyError:
                list_of_models = None

            # если список моделей по актуальному оборудования пуст или список моделей не пуст но самой модели нет,
            # то добавляем оборудование в шаблон для выкупа
            if (hw_type == 'NOTEBOOKS' or hw_type == 'DISPLAYS') and \
                    ((list_of_models is None) or (list_of_models != {} and model not in list_of_models)):
                self.hw_dictionary['buying_template'].append([inventory_number, vendor, model])

            self.hw_dictionary[template].append([inventory_number, vendor, model])

    # достает из тела тикету дату увольнения сотрудника
    def get_dismissal_date(self, issue_description):
        # достает из тела тикета дату увольнения сотрудника
        soup = BeautifulSoup(issue_description, 'html.parser')
        possible_set = soup.find_all('b')

        for element in possible_set:
            possible_date = element.text
            date_parser = re.match(r'\d+\.\d+\.\d+', possible_date)
            # мы нашли дату в теле тикета приводим ее к виду для st
            if date_parser is not None:
                possible_date = possible_date.split('.', 3)
                self.dismissal_date = '{year}-{month}-{day}'.format(year=possible_date[2],
                                                                    month=possible_date[1],
                                                                    day=possible_date[0])

    def get_hw_for_send(self, template):
        answer = ''
        for hardware in self.hw_dictionary[template]:
            answer += '{inv} {vendor} {model}\r\n'.format(inv=hardware[0], vendor=hardware[1], model=hardware[2])
        return answer


# генерация сообщения для ответа в тикет
def generate_and_send_mess(current_issue, user, debug):
    start_template = "Привет, напоминаем что в последний день до 18:00 нужно сдать рабочее оборудование в " \
                     "HelpDesk, в том числе зарядные устройства и переходники.\r\n" \
                     "Напоминаем, что перед сдачей нужно снять все наклейки c оборудования. " \
                     "На тебе числится следующее оборудование:\r\n<[{}]>"
    buying_template = "\r\nПри желании ты можешь выкупить следующее оборудование:\r\n" \
                      "<[{}]>\r\nПодробнее с процедурой выкупа можно ознакомиться " \
                      "((https://wiki.yandex-team.ru/pokupka/ здесь))\r\n"
    zmb_and_plasma_template = "\r\nТак же на тебе числятся следующие зомбики и/или телевизоры:" \
                              "\r\n<[{}]>\r\n" \
                              "подскажи пожалуйста кто за них будет ответственный или мы их забираем?"
    mobile_template = "\r\n\r\nА еще, на тебе числятся мобильные устройства, если они были взять из гиперкуба, " \
                      "их необходимо туда вернуть, если нет - пожалуйста, " \
                      "подскажи они перейдут другому сотруднику или ты их сдашь в HelpDesk?\r\n<[{}]>"
    delivery_template = ''

    finalize_template = "\r\n\r\nЕсли у вас остались вопросы, пожалуйста позвоните на номер 444 " \
                        "и скажите номер тикета {}".format(current_issue.key)
    if debug is False:
        st_client.issues[current_issue.key].update(followers={"add": user.login})

    # фоормирование сообщения для ответа
    if int(user.fix_version['fixVersions'][0]['id']) != 53054:
        all_hardware = ''
        for template in user.hw_dictionary:
            if len(user.hw_dictionary[template]) > 0 and template != 'buying_template':
                all_hardware += user.get_hw_for_send(template)

        if len(user.hw_dictionary['buying_template']) == 0:
            buying_template = ''
        if len(user.hw_dictionary['zmb_and_plasma_template']) == 0:
            zmb_and_plasma_template = ''
        if len(user.hw_dictionary['mobile_template']) == 0:
            mobile_template = ''

        if int(user.fix_version['fixVersions'][0]['id']) in fv_with_self_return:
            delivery_template = '\r\nВсе оборудование нужно принести в HelpDesk, ' \
                                       'корзинку для этого можно взять в HelpDesk\'е своего офиса.'
        else:
            # формирование сообщения для всех остальных если не указан рабочий стол
            table_url = "рабочего места"
            message_if_not_table = "\r\nТак же мы заметили, что у тебя не указано рабочее место, " \
                                   "укажи его пожалуйста в комментариях"
            if user.table is not None:
                table_url = "((https://staff.yandex-team.ru/map/table/{table} рабочего места))".format(table=user.table)
                message_if_not_table = ''

            delivery_template += "\r\nОборудование из списка ниже, а также клавиатуру, докстанцию и мышку, " \
                                 "если они есть, мы заберем сами с твоего {table}." \
                                 "{final}".format(table=table_url,
                                                  final=message_if_not_table)

            if len(user.hw_dictionary['may_take_by_loaders_template']) > 0:
                delivery_template += '\r\n<[' + user.get_hw_for_send('may_take_by_loaders_template') + ']>'
            else:
                delivery_template = ''

        # пока не начнутся продажи
        buying_template = ''

        result_message = start_template.format(all_hardware) + \
            buying_template.format(user.get_hw_for_send('buying_template')) + \
            zmb_and_plasma_template.format(user.get_hw_for_send('zmb_and_plasma_template')) + \
            mobile_template.format(user.get_hw_for_send('mobile_template')) + \
            delivery_template + finalize_template

        if user.hardware_count == 0:
            result_message = 'Ничего не числится за {}'.format(user.login)
        if debug is False:
            current_issue.comments.create(text=result_message, summonees=user.login)
        else:
            return result_message

    else:
        homework_template = "Привет, сотрудник может сдать свой ноутбук самостоятельно в любом из офисов указаных " \
                            "под катом \"График работы\" ((https://wiki.yandex-team.ru/diy/#grafikraboty здесь)), " \
                            "если пользователь этого сделать не может, пожалуйста, заполни " \
                            "((https://forms.yandex-team.ru/surveys/1308/ форму на отправку оборудования)) " \
                            "в московский офис и привяжи тикет к текущему." \
                            "\r\nЕсли у сотрудника был токен, его так же необходимо отправить.\r\n" \
                            "Как заполнять поля:\r\n" \
                            "ЦФО: указать бизнес-юнит запрашивающего отправку.\r\n" \
                            "ФИО получателя, название организации: HelpDesk.\r\n" \
                            "Адрес получателя: г. Москва, ул. Льва Толстого, 16.\r\n" \
                            "Телефон получателя: +79154476993."
        logger.info("Sending Homework message")

        if debug is False:
            current_issue.comments.create(text=homework_template + finalize_template, summonees=user.head)
        else:
            return homework_template + finalize_template

    if debug is False:
        try:
            current_issue.transitions['scheduled'].execute()
        except exceptions.NotFound:
            pass


# в зависимости от бизнес юнита проставляем нужные тэги и компоненты
def issue_mark(current_issue, user, debug):
    st = StartrekUtils()
    # по умолчанию штатный сотрудник
    macros_id = 559

    if user.business_unit == 'Команда поддержки бизнеса':
        macros_id = 560
    if user.business_unit == 'Внешние консультанты':
        macros_id = 561

    answer = st.get_st_macros_actions(macros_id)

    update_field = {
        'deadline': user.dismissal_date,
        'currentOffice': user.current_office,
        'replyBefore': user.dismissal_date+'T13:00:00Z'
    }

    logger.info('Изменения: Установка FV {fv}, применение макроса {macros}, '
                'установка дедлайна, отложено до и текущего офиса'.
                format(fv=user.fix_version['fixVersions'][0]['id'],
                       macros=macros_id))
    if debug is False:
        current_issue.update(**{**answer['Result'], **update_field, **user.fix_version})

        try:
            current_issue.transitions['treated'].execute()
        except exceptions.NotFound:
            pass


@exc_thread_wrapper
def mark_and_ping(debug=False):
    """Run every 10 min
    Searching not marked issue and mark them and then
    invite user or users head or invite loader when they exist
    """
    logger.info("Старт маркировки тикетов")
    # ищем тикеты для того чтобы разметить
    issues = st_client.issues.find('Queue: HDRFS Author: zomb-prj-191 Deadline: empty() Resolution: empty()')
    logger.info("Найдено неразмеченных тикетов: {}".format(len(issues)))
    for issue in issues:
        # issue = st_client.issues['HDRFS-353234']
        if re.search(r'Запланировано увольнение', issue.summary) is not None:
            logger.info("Обработка тикета: {}".format(issue.key))
            login = (issue.summary.split(' '))[-1]
            user_info = User(login)
            user_info.get_info_from_staff()
            user_info.get_dismissal_date(issue.description)

            logger.info('Маркировка тикета: {}'.format(issue.key))
            issue_mark(issue, user_info, debug)

    logger.info("Конец маркировки тикетов")
    logger.info("Старт призыв в тикет")
    # ищем размеченые тикеты чтобы в них ответить
    issues = st_client.issues.find('Queue: HDRFS Components: "DISMISSAL" Tags: ! "DISMISSAL_Mon" Assignee: empty() '
                                   'Resolution: empty()')

    logger.info("Найдено тикетов: {}".format(len(issues)))
    for issue in issues:
        # issue = st_client.issues['HDRFS-353234']
        if re.search(r'Запланировано увольнение', issue.summary) is not None:
            logger.info("Обработка тикета: {}".format(issue.key))
            login = (issue.summary.split(' '))[-1]
            user_info = User(login)
            user_info.get_hardware_bot()
            user_info.get_info_from_staff()
            need_ping_user = True
            need_invite_loaders = True
            logger.info("Поиск шаблонов в комментариях")
            for comment in issue.comments:
                office_template = re.match(r'Привет, напоминаем что в последний день до 18:00 нужно сдат', comment.text)
                home_template = re.search(r'форму на отправку оборудования', comment.text)
                invited_loaders_template = re.search(r'Задача передана грузчикам', comment.text)
                not_have_hw_template = re.search(r'Ничего не числится', comment.text)

                if office_template is not None or home_template is not None or not_have_hw_template is not None:
                    need_ping_user = False

                user_info.get_dismissal_date(issue.description)
                if invited_loaders_template is not None:
                    need_invite_loaders = False
            if need_ping_user:
                logger.info('Формирование сообщения для пользователя или руководитилея')
                generate_and_send_mess(issue, user_info, debug)

            if need_invite_loaders and (int(user_info.fix_version['fixVersions'][0]['id']) in fv_with_loaders) and \
                    len(user_info.hw_dictionary['may_take_by_loaders_template']) > 0:
                logger.info('Призыв грузчиков')
                if debug is False:
                    # answer = StartrekUtils().get_st_macros_actions(1267)
                    st_client.issues[issue.key].update(components={'add': 'Loader'})
                    issue.comments.create(text='<[====Задача передана грузчикам, '
                                               'оборудование скоро будет перемещено====]>'
                                               '\r\n<[**Заметка для грузчиков:**]>\r\n'
                                               'Коллеги, прошу забрать оборудование:\r\n<[' +
                                          user_info.get_hw_for_send('may_take_by_loaders_template') + ']>')
    logger.info("Конец призыв в тикет")


@exc_thread_wrapper
def find_without_hw(debug=False):
    """Running every hour
    search issues when where user doesn't have hardware
    """
    logger.info("Старт поиска тикетов где все списано")
    # ищем тикеты в которых ничего не числится и пишем об этом
    issues = st_client.issues.find('Queue: HDRFS Components: "DISMISSAL" Tags: ! "DISMISSAL_Mon" Assignee: empty() '
                                   '(Resolution: empty() or (Resolution: Позже and Status: ! Решен ))')
    logger.info("Найдено тикетов: {}".format(len(issues)))
    for issue in issues:
        if re.search(r'Запланировано увольнение', issue.summary) is not None:
            logger.info("Обработка тикета: {}".format(issue.key))
            login = (issue.summary.split(' '))[-1]
            user_info = User(login)
            user_info.get_hardware_bot()
            if user_info.hardware_count == 0:
                need_comment = True
                message = 'Ничего не числится за ' + login
                for comment in issue.comments:
                    template = re.match(r'Если у сотрудника был токен, его так же необходимо', comment.text)
                    if template is None or comment.text == message:
                        need_comment = False
                if need_comment:
                    logger.info("Нет оборудования пишем в тикет: {}".format(user_info.login))
                    if debug is False:
                        issue.comments.create(text=message)
                    logger.info('Без оборудования https://st.yandex-team.ru/{}'.format(issue.key))
    logger.info("Конец поиска тикетов где все списано")

