import logging

import yt.wrapper as yt
import copy
from source.config import *
from source.utils import StartrekUtils

logger = logging.getLogger(__name__)
YT_CLIENT = YT_VANGA_CLIENT
ST_MACROS_ID = 406 # COMP_LaptopMon (Мониторинг по использованию чужого ноутбука)

def find_empty_oebs_login():
    """ Return asset where exist ext_login without oebs_login
    """
    logger.info('Search asset where where exist ext_login without oebs_login')
    yt_data = YT_CLIENT.select_rows(
        'oebs.instance_number, oebs.last_ticket_number, oebs.ext_login, oebs.segment2 \
        FROM [{}] as oebs \
        WHERE oebs.ext_login != "" \
        AND oebs.ext_login != null \
        AND oebs.oebs_login = null \
        AND oebs.status_name = "OPERATION"'.format(
            '//home/helpdesk/cmdb/notebooks'
        ),
        format=yt.JsonFormat(attributes={"encode_utf8": False}))

    return list(yt_data)

def issue_for_instance_exist(instance_number):
    """ Find issue for instance with wrong owner
    """
    filter_for_wrong_owner = 'Queue: HDRFS AND components: 52286 AND tags: "COMP_LaptopMon_Ext" AND tags:"inv:{}" AND Resolution: empty()'.format(instance_number)
    issue = st_client.issues.find(filter_for_wrong_owner)
    if issue:
        return True
    else:
        return False

def get_data_for_issue(instance_info, actions_for_laptop):
    """ Return data for issue
        https://st.yandex-team.ru/TECHADMIN-1859
    """
    descr_dict = {
            'instance_number': instance_info['oebs.instance_number'],
            'oebs_ext_login': instance_info['oebs.ext_login'],
            'model': instance_info['oebs.segment2'],
            'last_ticket': instance_info['oebs.last_ticket_number'],
        }
        
    description = """
Привет!
Зафиксировали, что у инв.:{instance_number} есть связь с {oebs_ext_login}@, но отсутствует ответственный со стороны Яндекса.
Необходимо выяснить кого указать ответственным и провести оборудование.
#|
|| Inv | Model | OeBS (ext_login) | Последний тикет ||
|| !!Я.!!**{instance_number}** | {oebs_ext_login}@ | {model} ||
|#""".format(**descr_dict)
    actions_laptop = copy.deepcopy(actions_for_laptop)
    actions_laptop['tags'].append('inv:{}'.format(descr_dict['instance_number']))
    issue_data = {
            "summary":"Мониторинг оборудования c ext_login без oebs_login (инв.{})".format(descr_dict['instance_number']),
            "description": description,
            "queue":"HDRFS",
            **actions_laptop
    }
    
    return issue_data

def main():

    macros_id = 995 # COMP_LaptopMon_Ext (Мониторинг по использованию чужого ноутбука)
    actions_for_laptop_mon = StartrekUtils().get_st_macros_actions(macros_id)['Result']
    # All asserts with oebs_login != jss_login
    instance_without_oebs_login = find_empty_oebs_login()

    for asset in instance_without_oebs_login:
        issue_data = get_data_for_issue(asset, actions_for_laptop_mon)
        
        if not issue_for_instance_exist(asset['oebs.instance_number']):
            try:
                logger.info('Try create issue for asset: inv: {}'.format(asset['oebs.instance_number']))
                st_client.issues.create(**issue_data)
            except Exception as error:
                logger.error('Issues for asset on help not created. Error: {}'.format(error))
