from source.config import OAUTH_CREATIVE_TOOLS
from startrek_client import Startrek, exceptions
import datetime
import time
import logging

logger = logging.getLogger(__name__)

userag = 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.12785 YaBrowser/13.12.1599.12785 Safari/537.36'

st_client_creative = Startrek(useragent=userag,
                  base_url='https://st-api.yandex-team.ru',
                  token=OAUTH_CREATIVE_TOOLS)

def get_last_real_comment(issue):
    for log in reversed(list(issue.changelog)):
        a = [(x.get('field')) for x in log.fields]
        if not a:
            return log
        else:
            if 'sprint' not in [x.id for x in a if hasattr(x,'id')]:
                return log

def need_info_closer():
    if datetime.datetime.now().weekday() in [5,6]:
        return
    text = u"""Привет!

Эта задача находится в статусе "Требуется информация" и по ней в течение 3 дней не производились никакие действия.
Пожалуйста, предоставьте запрошенную информацию, если задача еще актуальна.

В противном случае задача будет закрыта автоматически через некоторое время.

Если у вас возникли вопросы - пожалуйста, обратитесь к руководителю проекта. 
Если вы не знаете, кто руководитель на данном проекте, пожалуйста, обратитесь к @mitya-m
"""

    all_issues = st_client_creative.issues.find('Queue: CREATIVETAXI AND Status: "Требуется информация"')

    count = 0

    for issue in all_issues:
        log = get_last_real_comment(issue)
        diff_days = (datetime.datetime.now() - datetime.datetime.strptime(
            log.updatedAt[0:10], '%Y-%m-%d')).days
        log_author = log.updatedBy.id
        if diff_days > 3 and log_author != 'robot-creative':
            logger.info('Create comment on task: {}'.format(issue.key))
            count += 1
            issue.comments.create(
                text=text)
            time.sleep(1)
        elif diff_days > 2 and log_author == 'robot-creative':
            logger.info('Closed task: {}'.format(issue.key))
            count += 1
            time.sleep(1)
            issue.transitions['closed'].execute(resolution='declined')