import logging

import requests
from source.config import OAUTH_TOOLS
from startrek_client import Startrek
import traceback

USERAG = "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.12785 YaBrowser/13.12.1599.12785 Safari/537.36'"
logging.basicConfig(
    format=u'%(filename)s[LINE:%(lineno)d]# %(levelname)-8s [%(asctime)s]  %(message)s',
    level=logging.INFO)
AUTH_HEADERS_TOOLS = {
            "Authorization": 'OAuth {}'.format(OAUTH_TOOLS)
        }

logger = logging.getLogger(__name__)

def get_yamoney():
    r = requests.get(
        'http://staff-api.yandex-team.ru/v3/persons?_limit=2500&department_group.ancestors.department.heads.person.official.affiliation=yamoney&_fields=login',
        headers=AUTH_HEADERS_TOOLS)
    data = r.json()
    result_set = {item['login'] for item in data['result']}
    return result_set

def hdrfs_filter(issues):
    unique_keys = set()
    data = requests.get('https://abc-back.yandex-team.ru/api/v3/services/members/?service=1048&page_size=1000', headers=AUTH_HEADERS_TOOLS).json()['results']
    helps = {x['person']['login'] for x in data}
    helps.add('zomb-prj-191')
    helps.add('robot-bot-prod')
    yamoney = get_yamoney()

    result_list = set()
    for issue in issues:
        ticket_logins = {x.id for x in issue.followers}
        ticket_logins.add(issue.createdBy.id)

        ticket_logins_without_helps = ticket_logins.difference(helps).difference(yamoney)
        if ticket_logins_without_helps and issue.key not in unique_keys:
            result_list.add(issue)
            unique_keys.add(issue.key)
    return result_list


class FeedbackClass(object):
    def __init__(self, queue, text, add_filter=None, token=OAUTH_TOOLS, **kwargs):
        self.token = token
        self.client = Startrek(useragent=USERAG,
                               base_url='https://st-api.yandex-team.ru',
                               token=self.token)
        self.queue = queue
        self.comment_text = text
        self.add_filter = add_filter
        self.all_comments = kwargs.get('old_texts', [])
        self.all_comments.append(text)
        self.unique_keys = set()

    def _check_comment(self, text, key):
        for item in self.all_comments:
            if text == item.format(key=key) : return True
        return False

    def collect_issues(self):
        unanswered_issues = set()
        issues = self.client.issues.find(self.queue)
        for issue in issues:
            answered = False
            comments = issue.comments
            for comment in comments:
                if comment.createdBy.id == 'robot-help' and self._check_comment(comment.text, issue.key):
                    answered = True
                    logger.info('Success find answer in {}'.format(issue.key))
            if not answered and issue.key not in self.unique_keys:
                unanswered_issues.add(issue)
                self.unique_keys.add(issue.key)

        if self.add_filter: unanswered_issues = self.add_filter(unanswered_issues)

        return unanswered_issues

    def create_comment(self, issues):
        for issue in issues:
            logger.info('Comment created at ticket: {}'.format(issue.key))
            issue.comments.create(text=self.comment_text.format(key=issue.key))

    def main(self):
        issues = self.collect_issues()
        logger.info('Successfuly find {} unanswered tickets'.format(issues))
        self.create_comment(issues)

FEEDBACK_CONFIG = {
    'HDRFS':{
        'text': """Коллеги, пожалуйста, заполните форму обратной связи по решению этого тикета, это займет меньше минуты: https://hd.yandex-team.ru/feedback/?t={key}
Если есть какие-то вещи, которые хочется обсудить, вы всегда можете написать/позвонить/дойти до укого:fastunov.
Спасибо.""",
        'queue': 'Queue: "Helpdesk Requests" AND Resolved: today() - 2d .. today() AND Resolution: Fixed',
        'add_filter':hdrfs_filter,
        'old_texts': ["""Коллеги, пожалуйста, заполните форму обратной связи по решению этого тикета, это займет меньше минуты: https://hd.yandex-team.ru/feedback/?t={key}
Если есть какие-то вещи, которые хочется обсудить, вы всегда можете написать/позвонить/дойти до укого:meidji или укого:ekaritskiy.
Спасибо.""", """Коллеги, пожалуйста, заполните форму обратной связи по решению этого тикета, это займет меньше минуты: https://hd.yandex-team.ru/feedback/?t={key}
Если есть какие-то вещи, которые хочется обсудить, вы всегда можете написать/позвонить/дойти до укого:agrebenyuk или укого:chist-anton.
Спасибо.""","""Коллеги, пожалуйста, заполните форму обратной связи по решению этого тикета, это займет меньше минуты: https://hd.yandex-team.ru/feedback/?t={key}
Если есть какие-то вещи, которые хочется обсудить, вы всегда можете написать/позвонить/дойти до укого:meidji.
Спасибо."""]
    },
    'COMDEPANALYSIS':{
                'text': """Коллеги, пожалуйста, заполните форму обратной связи по решению этого тикета. Это займет у вас меньше минуты.
Сделать это можно по ссылке - https://hd.yandex-team.ru/feedback/?t={key}
Спасибо""",
                'queue': 'Queue: COMDEPANALYSIS AND (Components: Подр_Агрегаторы OR Components: Подр_Внешние OR Components: Подр_КУБ OR Components: Подр_МКС OR Components: Подр_ОКО OR Components: Подр_ПК OR Components: Подр_СА OR Components: Подр_СК) AND Resolution: notEmpty() AND Resolved: today() - 5d .. today()',
    }
}

def main():
    logger.info('Start FeedBack')
    for config in FEEDBACK_CONFIG:
        config_unit = FEEDBACK_CONFIG[config]
        worker = FeedbackClass(queue=config_unit['queue'],
                               add_filter=config_unit.get('add_filter'),
                               text=config_unit['text'],
                               token=config_unit.get('token',OAUTH_TOOLS),
                               old_texts=config_unit.get('old_texts'))
        try:
            worker.main()
        except Exception as error:
            logging.warning('Error while running {config_name} {error}'.format(
                config_name = config,
                error = traceback.print_exc()
            ))