import logging
import requests
import re
import time

from source.config import *
from source.utils import (
        StartrekUtils, OtherUtils, BotApiUtils
    )

logger = logging.getLogger(__name__)

MACROS_ID = 438 # macros for task with PRINTER_DOWN

def set_attributes_for_printer_mon(task):
    # find fqdn in task
    time.sleep(1)
    prn_fqdn = re.search('prn-[0-9]*.yandex-team.ru', task.description)
    if prn_fqdn:
        prn_fqdn = prn_fqdn.group()
    else:
        logger.error('Not found fqdn for prn in task: {}'.format(task.key))
        return False
    
    # find location for fqdn
    oebs_path = BotApiUtils().fetch_osinfo('fqdn', prn_fqdn, ['loc_segment2', 'loc_segment3'])
    for loc_segment in oebs_path['os']:
        loc = '{}>{}'.format(loc_segment["loc_segment2"],loc_segment["loc_segment3"])

    # find what do macros : type, components, tags
    macros_action = StartrekUtils().get_st_macros_actions(MACROS_ID)
    if macros_action["Error"]:
        logger.error((macros_action["Result"]))
        return False
    else:
        macros_action = macros_action["Result"]

    # find fixVersion and currentOffice
    fix_version = OtherUtils().get_office_for_location(loc)
    fix_version.update(macros_action)
    fix_version.update(channel = 'ST API')

    # change currentOffice, type, fixVersions, components, tags
    try:
        task.update(**fix_version)
        task.transitions['treated'].execute()
        logger.info('Apply {} for task: {}'.format(fix_version, task.key))
    except Exception as error:
        logger.error('"Error: {}" Cannot apply {} for task: {}'.format(error, fix_version, task.key))
