import logging
from collections import defaultdict

import yt.wrapper as yt

from source.cmdb.soft_oebs import main_cmdb_soft
from source.utils import (YT_HAHN_CLIENT, BotApiUtils, exc_thread_wrapper)

APPROVED_TITLES = ['Cloud Productivity S1 From SA USL']
YT_CLIENT = YT_HAHN_CLIENT

logger = logging.getLogger(__name__)

class DuplicateRemover():
    def __init__(self):
        self.bot_client = BotApiUtils()

    def _fetch_data_from_yt(self):
        held_licenses = YT_CLIENT.select_rows(
            'segment1, inv_num_lic, inv_number FROM [{}] where not is_null(inv_number)'.format(
                "//home/helpdesk/cmdb/soft_oebs"),
            format=yt.JsonFormat(attributes={"encode_utf8": False}))
        return held_licenses

    def _self_delete_and_pass_license(self, **kwargs):
        pass

    def _find_counts(self, data):
        all_entities = defaultdict(int)
        for item in data:
            all_entities["{segment1};{inv_num_lic};{inv_number}".format(**item)] += 1

        result = {x:all_entities[x] for x in all_entities if all_entities[x] > 1}

        return result

    def _remove_license(self, info):
        lic_inv = info[1]
        obj_inv = info[2]
        res = self.bot_client.remove_license(
            hadrwares=obj_inv,
            softwares=lic_inv
        )
        if res:
            logger.info('Successfuly remove lic {} from inv {}'.format(
                lic_inv, obj_inv))
            return True

    def _add_license(self, info):
        lic_inv = info[1]
        obj_inv = info[2]
        res = self.bot_client.add_license(
            hadrwares=obj_inv,
            softwares=lic_inv
        )
        if res:
            logger.info('Successfuly added lic {} to inv {}'.format(
                lic_inv, obj_inv))
            return True

    def _analyze_license(self, data):
        logger.info('Find {} duplicates'.format(len(data)))
        for item in data:
            info = item.split(';')
            lic_title = info[0]

            if lic_title in APPROVED_TITLES:
                rem_res = self._remove_license(info)
                if rem_res:
                    if not self._add_license(info):
                        logger.error('Remove, but not install debug {}'.format(
                            info
                        ))

    def process(self):
        mac_data = list(self._fetch_data_from_yt())
        counts = self._find_counts(mac_data)
        self._analyze_license(counts)
        main_cmdb_soft()

@exc_thread_wrapper
def main_duplicate_remover():
    DuplicateRemover().process()