import logging

import yt.wrapper as yt

from source.utils import (YT_HAHN_CLIENT, BotApiUtils, exc_thread_wrapper)
from source.cmdb.soft_oebs import main_cmdb_soft

APPROVED_TITLES = ['Cloud Productivity S1 From SA USL']
YT_CLIENT = YT_HAHN_CLIENT

logger = logging.getLogger(__name__)

class NonOperationComps():
    def __init__(self):
        self.bot_client = BotApiUtils()

    def _fetch_license_data_from_yt(self, notebooks):
        licenses = YT_CLIENT.select_rows(
            'segment1, inv_num_lic, inv_number FROM [{}] where not is_null(inv_number)'.format(
                "//home/helpdesk/cmdb/soft_oebs"),
            format=yt.JsonFormat(attributes={"encode_utf8": False}))
        return [x for x in licenses if x["inv_number"] in notebooks]

    def _fetch_notebooks_data_from_yt(self):
        select_query = "instance_number, status_name from [{table}] where status_name != 'OPERATION'".format(
            table="//home/helpdesk/cmdb/notebooks")

        retired_logins = YT_CLIENT.select_rows(select_query,
                                               format=yt.JsonFormat(
                                                   attributes={
                                                       "encode_utf8": False}))
        return {x["instance_number"] for x in retired_logins}

    def _remove_license(self, lic_inv, obj):
        res = self.bot_client.remove_license(
            hadrwares=obj,
            softwares=lic_inv
        )
        if res:
            logger.info('Successfuly remove lic {} from inv {}'.format(
                lic_inv, obj))
            return True

    def process(self):
        non_operational_notebooks = self._fetch_notebooks_data_from_yt()
        licenses_data = self._fetch_license_data_from_yt(non_operational_notebooks)
        logger.info('Found {} licenses on non-operational comps'.format(len(licenses_data)))
        for count, item in enumerate(licenses_data):
            res = self._remove_license(item["inv_num_lic"], item["inv_number"])
            if not res:
                logger.warning('Error when remove license {inv_num_lic} {inv_number}'.format(**item))
        main_cmdb_soft()

@exc_thread_wrapper
def main_non_operaional_remover():
    NonOperationComps().process()