import datetime
import logging

import yt.wrapper as yt

from source.utils import (YT_HAHN_CLIENT, BotApiUtils, exc_thread_wrapper)

APPROVED_TITLES = ['Cloud Productivity S1 From SA USL']
YT_CLIENT = YT_HAHN_CLIENT

logger = logging.getLogger(__name__)

class RetiredEmployees():
    def __init__(self):
        self.bot_client = BotApiUtils()

    def _fetch_license_data_from_yt(self, logins):
        licenses = YT_CLIENT.select_rows(
            'segment1, inv_num_lic, login_oebs FROM [{}] where not is_null(login_oebs)'.format(
                "//home/helpdesk/cmdb/soft_oebs"),
            format=yt.JsonFormat(attributes={"encode_utf8": False}))
        return [x for x in licenses if x["login_oebs"] in logins]

    def _fetch_login_data_from_yt(self):
        today = datetime.datetime.now().strftime('%Y-%m-%d')
        select_query = "login from [{table}] where is_dismissed=true".format(
            table="//home/helpdesk/cmdb/staff",
            quit=today)

        retired_logins = YT_CLIENT.select_rows(select_query,
                                               format=yt.JsonFormat(
                                                   attributes={
                                                       "encode_utf8": False}))
        return {x["login"] for x in retired_logins}

    def _remove_license(self, lic_inv, obj):
        res = self.bot_client.remove_license(
            login=obj,
            softwares=lic_inv
        )
        if res:
            logger.info('Successfuly remove lic {} from inv {}'.format(
                lic_inv, obj))
            return True

    def process(self):
        retired_logins = self._fetch_login_data_from_yt()
        licenses_data = self._fetch_license_data_from_yt(retired_logins)

        for item in licenses_data:
            res = self._remove_license(item["inv_num_lic"], item["login"])
            if not res:
                logger.warning('Error where remove license {inv_num_lic} {login}').format(**item)

@exc_thread_wrapper
def main_retired_employees():
    RetiredEmployees().process()