"""Add JupyTicket and related tables

Revision ID: 06c0ba0d6ded
Revises: e93183fcc25e
Create Date: 2021-07-06 16:24:10.896183

"""
import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = '06c0ba0d6ded'
down_revision = 'e93183fcc25e'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        'jupyticket',
        sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
        sa.Column('user_name', sa.Text(), nullable=False),
        sa.Column('created', sa.DateTime(), nullable=False),
        sa.Column('updated', sa.DateTime(), nullable=False),
        sa.Column('title', sa.UnicodeText(), nullable=False),
        sa.Column('description', sa.UnicodeText(), nullable=True),
        sa.ForeignKeyConstraint(['user_name'], ['users.name'], ondelete='RESTRICT'),
        sa.PrimaryKeyConstraint('id'),
    )
    op.create_table(
        'jupyticket_arcadia',
        sa.Column('jupyticket_id', sa.Integer(), nullable=False),
        sa.Column('user_name', sa.Text(), nullable=False),
        sa.Column('path', sa.Text(), nullable=False),
        sa.Column('revision', sa.Text(), nullable=False),
        sa.Column('shared', sa.DateTime(), nullable=False),
        sa.Column('message', sa.UnicodeText(), nullable=True),
        sa.ForeignKeyConstraint(['jupyticket_id'], ['jupyticket.id'], ondelete='CASCADE'),
        sa.ForeignKeyConstraint(['user_name'], ['users.name'], ondelete='RESTRICT'),
        sa.PrimaryKeyConstraint('jupyticket_id', 'path', 'revision'),
    )
    op.create_table(
        'jupyticket_nirvana',
        sa.Column('jupyticket_id', sa.Integer(), nullable=False),
        sa.Column('workflow_id', postgresql.UUID(), nullable=False),
        sa.Column('instance_id', postgresql.UUID(), nullable=False),
        sa.Column('created', sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(['jupyticket_id'], ['jupyticket.id'], ondelete='CASCADE'),
        sa.PrimaryKeyConstraint('jupyticket_id', 'workflow_id', 'instance_id'),
    )
    op.create_table(
        'jupyticket_startrek',
        sa.Column('jupyticket_id', sa.Integer(), nullable=False),
        sa.Column('startrek_id', sa.Text(), nullable=False),
        sa.Column('created', sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(['jupyticket_id'], ['jupyticket.id'], ondelete='CASCADE'),
        sa.PrimaryKeyConstraint('jupyticket_id', 'startrek_id'),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('jupyticket_startrek')
    op.drop_table('jupyticket_nirvana')
    op.drop_table('jupyticket_arcadia')
    op.drop_table('jupyticket')
    # ### end Alembic commands ###
