"""Add pillars table

Revision ID: f96a31a74bff
Revises: eab2ab022148
Create Date: 2019-08-08 19:20:41.516019

"""
import sqlalchemy as sa
from alembic import op


# revision identifiers, used by Alembic.
revision = 'f96a31a74bff'
down_revision = 'eab2ab022148'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        'pillars',
        sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
        sa.Column('minion_id', sa.Unicode(length=255), nullable=True),
        sa.Column('name', sa.Unicode(length=255), nullable=True),
        sa.Column('value', sa.Text(), nullable=True),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('minion_id', 'name'),
    )
    op.create_index(op.f('ix_pillars_minion_id'), 'pillars', ['minion_id'], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_pillars_minion_id'), table_name='pillars')
    op.drop_table('pillars')
    # ### end Alembic commands ###
