CREATE SEQUENCE IF NOT EXISTS $TABLE_NAME$_version_seq OWNED BY NONE;
ALTER TABLE $TABLE_NAME$ ADD COLUMN IF NOT EXISTS version bigint NOT NULL DEFAULT nextval('$TABLE_NAME$_version_seq');
ALTER SEQUENCE $TABLE_NAME$_version_seq OWNED BY $TABLE_NAME$.version;
ALTER TABLE $TABLE_NAME$ ALTER COLUMN version TYPE bigint;
DO $$
BEGIN
IF (SELECT contype FROM _$TABLE_NAME$_join WHERE conname='$TABLE_NAME$_version_key') <> 'u' THEN
    ALTER TABLE $TABLE_NAME$ DROP CONSTRAINT IF EXISTS $TABLE_NAME$_version_key;
    ALTER TABLE $TABLE_NAME$ ADD CONSTRAINT $TABLE_NAME$_version_key UNIQUE (version);
END IF;

IF 'p' <> (SELECT contype FROM _$TABLE_NAME$_pkey) OR
   (SELECT attname FROM _$TABLE_NAME$_pkey) <> ARRAY['key', 'version'] THEN
    ALTER TABLE $TABLE_NAME$ DROP CONSTRAINT IF EXISTS $TABLE_NAME$_pkey CASCADE;
    ALTER TABLE $TABLE_NAME$ ADD PRIMARY KEY (key, version);
END IF;
END
$$