TIdxRandomBundle
========================

## Что бандл делает

Основная задача бандла - выбирать случайную позицию в соответствии с заданным распределением. Распределение может быть фиксированным на всем потоке, а может зависеть от позиции, которую выбирает продовая формула. Кроме этого, бандл умеет выбирать другие фичи (ViewType, Place) из равномерного распределения

## Глобальный и локальный рандом

Рандом, в котором распределение фиксированно на всем потоке, называется глобальным. В данный момент заведение сборов с такими рандомами нежелательно, поскольку они сильно портят выдачу. Вместо этого есть возможность завести рандом, где распределение зависит от позиции, выбранной продакшн формулой. Например, если прод выбрал 4-ю позицию, значит с наибольшей вероятностью в сборе колдунщик окажется на 4-й позции, у нулевой и девятой позиции вероятности будут самые низкие, а в целом график распределения выглядит [примерно так](https://jing.yandex-team.ru/files/onaga/locrandom_distribution.png). Такой рандом называется локальным, поскольку колдунщик размещается преимущественно в локальной окрестности продакшн позиции. Сейчас (июнь 2021) это наиболее распространенная версия рандомного сбора для колдунщиков.

## Основные параметры
* **ProbabilitiesByPos** - табличка, в которой строка с индексом ind задает распределение вероятностей позиций для случая, когда продакшн формула выбрала позицию ind.
  * Основной параметр для локального рандома.
  * Сумма чисел по строке не обязана равняться единице, бандл отнормирует все числа в стоке на их сумму.
* **Probabilities** - распределение вероятностей в случае, если продовая позиция не определена или она больше, чем число строк в **ProbabilitiesByPos**.
  * Основной параметр для глобального рандома.
  * В локальном рандоме это распределение в основном используется, когда продакшн формула выбрала непоказ, то есть позицию 100. 
* **Idx2Pos** - это список позиций в том же порядке, в котором для них указаны вероятности в **Probabilities** и в строках **ProbabilitiesByPos**. Иными словами маппинг из столбцов матрицы **ProbabilitiesByPos** в позиции. Значение по умолчанию - список от 0 до длины Probabilities не включая

Пример:
- **ProbabilitiesByPos**: [[0.7, 0.2, 0.1], [0.1, 0.75, 0.15]]
- **Probabilities**: [0.01, 0.19, 0.8]
- **Idx2Pos**: [0, 1, 100]

Если продакшн позиция равна 1, то в сборе вероятность нулевой позиции будет 0.1, вероятность первой - 0.75, а вероятность 100-й (непоказа) - 0.15. Если же продакшн выберет 100-ю позицию, то будет использовано распределение укзанное в Probabilities, то есть у нулевой позиции будет вероятность 0.01, у первой - 0.19, у непоказа - 0.8.

## Дополнительные параметры
* **AdditionalFeatures** - какие фичи нужно дополнительно рандомить, например ViewType или Place.
  * Указывается списком словарей с тремя ключами
    * Name - название фичи (ViewType/Place),
    * Values - возможные значения,
    * Binary - артефакт, просто указывайте 0.
  * Бандл будет для указанной фичи  выбирать одно значение из Values, семплируя из равномерного распределения.
  * В контекст бандлу можно передать AvailibleValues - доступные на этом запросе значения вашей фичи. В этом случае бандл будет выбирать только из тех, что указаны и в Values и в доступных. В Values можно указать `["*"]`, тогда значение будет выбираться из всех доступных значений. Передать AvailibleValues можно:
    * через conf.json ([пример: вьютайп доступен всегда](https://a.yandex-team.ru/arc/trunk/arcadia/search/web/rearrs_upper/conf/conf.json?rev=r8095370#L2695), [пример: вьютайп доступен, если условие выполнилось](https://a.yandex-team.ru/arc/trunk/arcadia/search/web/rearrs_upper/conf/conf.json?rev=r8095370#L6337))
    * из кода вашего переранжирвоания ([пример](https://a.yandex-team.ru/arc/trunk/arcadia/search/web/rearrange/org_wizard/org_wizard.cpp?rev=r9387871#L1168)).
  * **Важно**: чтобы AvailibleValues оказались в контексте, бандл должен их запросить. Для этого в бандл нужно добавить ключ Meta со значением `{"FeaturesInfo": 1}`, как это сделано в positional_local_random_hard_viewtype_noshow в примерах.
  * **Важно**: этот бандл не использует AvailableCombinations, только AvailibleValues. Если вы хотите, чтобы в зависимости от вьютайпа были разные доступные Place или Pos - вам нужен другой бандл, например TMultiFeatureLocalRandom.
* **ShowProbaMultiplierIfFiltered** - внутрь некоторых блендерных бандлов встроен фильтр - классификатор, который может забанить показ колдунщика. Если этот параметр не выставлен, то бан фильтра трактуется рандомным бандлом как обычный непоказ. Если же **ShowProbaMultiplierIfFiltered** выставлен, тогда в случае срабатывания фильтра вероятность всех вариантов показа умножиться на этот параметр.
  * Пример: пусть у нас **Probabilities** равны [0.01, 0.19, 0.8] и **Idx2Pos** - [0, 1, 100], как в примере выше, а **ShowProbaMultiplierIfFiltered** равен 0.1. Тогда при срабатывании фильтра распределение будет такое: [0.001, 0.019, 0.98].

## Технические параметры
* **AdditionalSeed** - можно задать дополнительную соль. Строка указанная тут будет добавлена к дефолтной соли составленной из запроса, uid'a и timestamp'a ([код](https://a.yandex-team.ru/arc/trunk/arcadia/search/web/util/random/random.cpp?rev=r8114827#L21)).
* **DoNotShowPos** - какую позицию считать непоказом, по умолчанию 100. Нужно для логирования вероятности непоказа, которая в свою очередь используется для симуляции непоказов в графе обучения
* **FeatureName** - эта штука равна "Pos", вам либо не нужно это менять, либо вы и без этой доки понимаете, что делаете)

## Как работает бандл
1. Если в бандле указан параметр **ProbabilitiesByPos**, то из правила ApplyBlender достаём текущий предикт продакшн формулы и через PredictedFeaturesInfo передаём его в бандл.
2. Достаем из PredictedFeaturesInfo предсказанную продакшн формулой позицию predictedPos. Если её там нет, то считаем, что predictedPos - непоказ (DoNotShowPos).
3. Если predictedPos больше, чем число строк в **ProbabilitiesByPos**, то берем в качестве распределения **Probabilities**. Иначе распределение равно `ProbabilitiesByPos[predictedPos]`
4. Семплируем позицию из выбранного распределения
5. Логируем выбранную позицию, вероятность, с которой её выбрали, и вероятность выбора непоказа. Последнее необходимо для симуляции непоказов в конвейерном графе
6. Если указан **AdditionalFeatures**, выбираем независимым образом значение каждой фичи
    1. Достаем AvailibleValues из контекста, пересекаем их со значениями фичи, указанными в AdditionalFeatures, получаем validFeats
    2. Из validFeats выбираем случайное значение
    3. Логируем validFeats и выбранное значение

## Примеры бандлов
| Описание | Пример в ya.make | Содержимое |
|---|---|---|
| глобальный рандом | positional_random  | [link](https://paste.yandex-team.ru/4570252) |
| глобальный рандом по топ5 | positional_top_random | [link](https://paste.yandex-team.ru/4570459) |
| глобальный рандом на конкретном наборе позиций | positional_random_01248_noshow_market_viewtypes | [link](https://paste.yandex-team.ru/4570543) |
| глобальный рандом с непоказом | positional_random_noshow | [link](https://paste.yandex-team.ru/4570256) |
| глобальный рандом с выбором ViewType из списка | positional_random_noshow_market_viewtypes | [link](https://paste.yandex-team.ru/4570439) |
| локальный рандом | positional_local_random_hard_with_noshow | [link](https://paste.yandex-team.ru/4570299) |
| локальный рандом с выбором ViewType из всех доступных | positional_local_random_hard_viewtype_noshow | [link](https://paste.yandex-team.ru/4570354) |
| локальный рандом с выбором ViewType и Place из всех доступных | positional_local_random_hard_place_viewtype_noshow | [link](https://paste.yandex-team.ru/4570393) |
| локальный рандом на конкретном наборе позиций | positional_local_random_market_viewtypes_touch_01248 | [link](https://paste.yandex-team.ru/4571892) |
| локальный рандом с ShowProbaMultiplierIfFiltered | positional_local_random_hard_with_noshow_decrease_if_filtered_0.5 | [link](https://paste.yandex-team.ru/4571913) |

TMultiFeatureLocalRandom
========================

## Понятия:
* Фича (Feature) - то, что предсказывает формула (позиция, вьютайп, колонка или еще что-то)
* Комбинация (Combination) - набор фичей, определяющий показ (например позиция+вьютайп)

## Как устроен бандл:
* Для каждой фичи есть название (Name), вектор её возможных значений (Values), матрица вероятностей перехода из Value[i] в Value[j] при рандоме (TransitionMatrix, не обязательно нормированная на 1), и индекс DefaultValueIdx в Values, который используется, если этой фичи раньше не было (например, можно указать для фичи Place дефолтное значение Main, и тогда можно из обычной формулы начать локрандомить в правую колонку).
* Бандл состоит из вектора фичей и веса непоказа
* Внутри кода Combination - это вектор индексов из каждой из фичей в Values. То есть не тапл (Pos=0, Place="right", ViewType="viewtype"), а индексы этих значений в Values, предположим (0, 1, 1).

## Как это работает:
 0. Всего данный бандлик поддерживает 1 + f1.Values.size() * f2.Values.size() * ... * fn.Values.size() комбинаций, то есть все возможные сочетания фичей плюс одна комбинация для непоказа. Мы можем посчитать веса перехода из iй комбинации в jю, перемножив веса перехода каждой отдельной фичи из состояния комбинации i в состояние комбинации j. Таким образом мы получаем большую матрицу перехода между комбинациями. Эту матрицу мы считаем один раз при инициализации бандлика. Вес перехода в непоказ всегда равен NoShowWeight.
 1. Из правила ApplyBlender достаём текущий предикт и через PredictedFeaturesInfo передаём его в бандлик.
 2. В бандлике определяем, в какой комбинации мы находимся сейчас, используем DefaultValueIdx когда что-то не удаётся определить, определяем строчку в матрице переходов, которая соответствует текущей комбинации.
 3. Из контекста определяем, какие комбинации нам сейчас доступны.
 4. Рандомно с весом выбираем какую-то из доступных комбинаций.
 5. Возвращаем её как результат.
