## Процессор пакетных замен


### Как работает процессор


При создании процессору передают конфигурацию-словарь, каждый элемент которого задаёт один так называемый "пакет замен".
В дальнейшем каждый такой пакет может быть активирован в отдельности по его уникальному имени.


Каждый пакет представляет собой массив (список) единичных операций замены.
Каждая операция выполняет то или иное преобразование (замену) над текстовой строкой.
При запуске пакета операции из него исполняются последовательно.
При этом очередная операция получает на вход строку, полученную в результате работы предыдущей по списку операции.


Реализованы следующие операции замены над текстовой строкой:

- `no operation` - отсутствие преобразования. Используется для отключения отдельных выражений в пакете в случае, если их полное удаление из конфигурационного файла нежелательно
- `shrink spaces` - удаление повторяющихся пробелов с заменой на один пробел (сжатие пробельных символов) в середине строки и удаление ведущих и заключительных пробелов соответственно в начале и конце строки
- `replace by pattern` - замена всех непересекающихся вхождений искомого шаблона (подстроки) в тексте на другой фиксированный текст
  - параметры:
    - `pattern` - искомый заменяемый текст (шаблон)
    - `replacement` - замещающий текст. Если этот параметр не задан, то искомый текст вырезается из входной строки (по сути заменяется на пустые строки)
  - режимы:
    - `global` - замена всех непересекающихся совпадений текста с регулярным выражением. Важно, используемый здесь диалект RE2 (в отличие от PCRE) не поддерживает lookahead и lookbehind
    - `repeated` - замена первого совпавшего участка с последующим рестартом сканера на модифицированной строке до тех пор, пока совпадение более не будет обнаруживаться или не будет достигнут предел количества повторов (задан равным 100)
    - `first` - замена только первого совпавшего участка
- `replace by regex` - замена текста при помощи регулярных выражений и выражений подстановки. Использована библиотека RE2
  - параметры:
    - `regex` - регулярное выражение для определения заменяемой части входного текста
    - `replacement` - выражение подстановки
  - режимы:
    - `global`, `repeated`, `first` - описание см. выше


Процессор модифицирует переданную ему текстовую строку in-place и возвращает бинарный статус, была ли строка модифицирована хотя бы в одной из операций активированного пакета.


### Формат конфигурационного файла


Схема данных задана файлом [batch_replacer_config.sc](https://a.yandex-team.ru/arc/trunk/arcadia/kernel/facts/batch_replacer/batch_replacer_config.sc).


Файл должен быть в формате JSON. Структура файла следующая:
- верхний уровень - объект. Ключи элементов объекта - названия пакетов замен (строки). Ключи должны быть уникальны. Значения элементов объекта - описания пакетов замен
- описание пакета замен - массив. Элементы массива - описания единичных операций замены
- описание единичной операции замены - объект. Элементы объекта - параметры операции замены


В объекте-описании операции замены могут быть использованы следующие параметры:
- параметры, определяющие тип операции:
  - `"nop": bool (default = false)` - признак операции "нет операции". Активен, когда установлен в true. Имеет безусловный приоритет над всеми остальными признаками, определяющими тип операции, - т.е. может быть указан вместе с ними и будет форсить "нет операции"
  - `"shrink_spaces": bool (default = false)` - признак операции "сжатие пробельных символов". Активен, когда установлен в true. Имеет приоритет над признаками, перечисленными ниже
  - `"pattern": string (default = "")` - признак операции "замена по шаблону". Задаёт искомый заменяемый текст (шаблон). Активен, когда равен непустой строке. Имеет приоритет над признаками, перечисленными ниже
  - `"regex": string (default = "")` - признак операции "замена по регулярному выражению". Задаёт регулярное выражение для определения заменяемой части входного текста. Активен, когда равен непустой строке. Имеет приоритет над признаками, перечисленными ниже
  - если ни один из этих параметров не указан, это эквивалентно случаю "нет операции"
- дополнительные параметры операций замены текста по шаблону или регулярному выражению:
  - `"replacement": string (default = "")` - замещающий текст для опреации замены по шаблону или выражение подстановки для операции замены по регулярному выражению. Если не задан вообще (или задан как пустая строка), искомое выражение будет вырезаться из обрабатываемой строки
- параметры, определяющие режим работы операций замены текста по шаблону или регулярному выражению:
  - `"global": bool (default = false)` - активирует т.н. "глобальную замену", т.е. замену всех непересекающихся вхождений искомой подстроки. Активен, когда установлен в true. Работает за линейное время (за один проход). Имеет приоритет над признаком `"repeated"`
  - `"repeated": bool (default = false)` - повторяет данную операцию замены, если на предыдущей её итерации была выполнена замена (т.е. было найдено совпадение с искомым шаблоном или регулярным выражением). Активен, когда установлен в true. Асимптотически хуже, чем режим "глобальной замены" (может работать за квадратичное время), и введён только по той причине, что используемая библиотека RE2 не поддерживает функционал lookahead и lookbehind. Имеет жёсткое ограничение в 100 повторов, предотвращающее бесконечное зацикливание операции
  - при отсутствии данных параметров включается режим замены первого найденного вхождения искомой строки


Текст в параметрах типа `string` должен быть в кодировка UTF-8.


Примеры конфигурации - см. [unit-test-ы](https://a.yandex-team.ru/arc/trunk/arcadia/kernel/facts/batch_replacer/ut/batch_replacer_ut.cpp).


Диалект RE2 описан в [официальной документации](https://github.com/google/re2/wiki/Syntax).
