## Составной фильтр фактов


### Как работает составной фильтр фактов


При создании фильтру передают конфигурацию, включающую:

- `blacklist` - дескриптор запрещённых фактов, определяемый через:
    - `types` - список проверяемых типов факта
    - `sources` - список проверяемых источников факта
    - `substrings` - список запрещённых паттернов (подстрок) в содержимом факта
- `whitelist` - дескриптор безусловно доверенных источников, определяемый через:
    - `sources` - список доверенных источников фактов
    - `hostnames` - список доверенных хостов
    - `source_and_hostnames` - список доверенных сочетаний источника факта и хоста, каждое из которых определяется парой:
        - `source` - имя источника факта
        - `hostname` - имя хоста


Обязательным является поле `blacklist/substrings`. Остальные поля - опциональные.


Для каждого проверяемого факта фильтр получает на вход четыре строки:

- `type` - название типа проверяемого факта
- `source` - название источника факта - модуля, сформировавшего проверяемый факт
- `hostname` - полное имя хоста (FQDN), с которого был взят документ, из которого был получен проверяемый факт
- `text` - текст, адекватно представляющий содержимое факта, подлежащее проверке


Фильтр работает в такой последовательности:

1. Если задано хотя бы одно из полей `blacklist/types` или `blacklist/sources`, то проверяют совпадение данных `type` или `source` с одним из `blacklist/types` или `blacklist/sources`. Используют точное (бинарное) сравнение строк
    - если `type` не совпадает ни с одним из `blacklist/types`, и если `source` не совпадает ни с одним из `blacklist/sources`, то факт считают *успешно* прошедшим проверку
    - если хотя бы один из признаков, тип или источник, совпал с заданным множеством, то факт подлежит дальнейшей проверке - см. п. 2
    - если же оба поля `blacklist/types` и `blacklist/sources` не заданы (или заданы как пустые списки), то все факты, независимо от их типа и источника, подлежат проверке - см. п. 2
2. Проверяют совпадение данного `source` с одним из `whitelist/sources` из конфигурации. Используют точное (бинарное) сравнение строк
    - если `source` совпал с одним из доверенных источников, то факт считают *успешно* прошедшим проверку
    - иначе продолжают проверку по `whitelist` - см. п. 3
3. Проверяют совпадение данного `hostname` с одним из `whitelist/hostnames` из конфигурации. Используют точное (бинарное) сравнение строк
    - если `hostname` совпал с одним из доверенных хостов, то факт считают *успешно* прошедшим проверку
    - иначе продолжают проверку по `whitelist` - см. п. 4
4. Проверяют совпадение пары данных `{source, hostname}` с одной из таких пар в `whitelist/source_and_hostnames` из конфигурации. Используют точное (бинарное) сравнение строк
    - если `{source, hostname}` совпал с одним из доверенных сочетаний источника факта и хоста, то факт считают *успешно* прошедшим проверку
    - иначе продолжают проверку по `blacklist` - см. п. 5
5. Проверяют наличие в данном `text` хотя бы одного паттерна из `blacklist/substrings` из конфигурации. Паттерн ищут как подстроку в `text` (см. метод `std::string::find`))
    - если не найдено ни одного совпадения, факт считают *успешно* прошедшим проверку
    - если найден хотя бы один паттерн, считают *забаненным*


Фильтр возвращает значение первого `substring`, по которому факт был забанен, либо empty-объект класса `TStringBuf`, если факт успешно прошёл проверку.


### Формат конфигурационного файла


Схема данных задана файлом [compound_filter_config.sc](https://a.yandex-team.ru/arc/trunk/arcadia/kernel/facts/compound_filter/compound_filter_config.sc).


Имена типов и источников фактов в `blacklist/types`, `blacklist/sources`, `whitelist/sources` и `whitelist/source_and_hostnames/source` должны быть полными идентификаторами источников, как они введены в коде noapacheupper.


Имена хостов в `whitelist/hostnames` и `whitelist/source_and_hostnames/hostname` должны задавать полное имя хоста (FQDN) с использованием, где необходимо, Punycode.
Фильтр не выполняет никакой нормализации ни конфигурационных значений этих полей, ни передаваемых в параметрах вызова фильтра.


Все паттерны в `substrings` должны быть нормализованы следующим образом:

- кодировка UTF-8
- все алфавитные символы приведены к нижнему регистру
- буква 'ё' заменена на букву 'е'
- в остальном - формально допустимы любые символы, кроме пробела и табуляции
