#include "extract_answer.h"
#include <library/cpp/resource/resource.h>
#include <library/cpp/scheme/scheme.h>
#include <library/cpp/testing/unittest/registar.h>

namespace NFactsSerpParser {

    static void CheckFactAnswer(const TStringBuf& resourceKey, const TStringBuf& expectedAnswer) {
        const TString json = NResource::Find(resourceKey);
        const NSc::TValue value = NSc::TValue::FromJsonThrow(json);

        const TString answer = ExtractAnswer(value);
        UNIT_ASSERT_EQUAL(answer, expectedAnswer);
    }

    Y_UNIT_TEST_SUITE(ExtractAnswer) {
            Y_UNIT_TEST(CheckAnswers) {
                CheckFactAnswer("calories_fact", "52 ккал (на 100 грамм)");
                CheckFactAnswer("dict_fact", "Род мужской обуви с голенищем до колен.; Человек неловкий, неумелый в работе.");
                CheckFactAnswer("entity_fact", "Пётр Алексеевич Порошенко (Президент), Владимир Борисович Гройсман (Премьер-министр)");
                CheckFactAnswer("math_fact", "cir_pl");
                CheckFactAnswer("poetry_lover", "Послание к Евреям");
                CheckFactAnswer("rich_fact", "Настройка приложения для фильтрации и определения телефонного спама Откройте магазин App Store и  загрузите приложение  для определения и блокировки телефонного спама. Можно загрузить и установить несколько таких приложений от разных разработчиков. Перейдите в меню «Настройки» > «Телефон». Нажмите «Блок. и идентиф. вызова». Включите или отключите нужное приложение в разделе «Разрешить этим приложениям блокировать и представлять ID абонента». Можно изменить порядок приложений в зависимости от их приоритета. Для этого достаточно нажать «Править» и перетащить приложения в нужные места.");
                CheckFactAnswer("suggest_fact", "На материке Южная Америка.Образуется слиянием \u0007[рек\u0007] Мараньон и Укаяли. Большая часть \u0007[реки\u0007] приходится на территорию Бразилии, юго западные и западные районы захватывают также Боливию, Перу, Эквадор и Колумбию");
                CheckFactAnswer("table_fact", "Пустыни площадью более 50 000 км²; Название пустыни, Тип пустыни; Антарктическая пустыня, Полярная; Сахара, Субтропическая; Арктическая пустыня, Полярная; Пустыня Аравийского полуострова, Субтропическая; Гоби, ; Калахари, Субтропическая");
                CheckFactAnswer("znatoki_fact", "Словом “Вселенная” обозначают много разных вещей. Например, иногда говорят, что в воображении человека помещается целая вселенная. И в ней существует всё, о чем мы думаем и мечтаем. , Для астрономов (то есть, для людей, изучающих звёзды), Вселенная — это всё, что мы видим вокруг себя или же можем “почувствовать” с помощью приборов. Она вмещает всё: и Луну, и вулкан на Земле, и чёрную дыру в другой галактике, и манную кашу., У астрономов нет уверенности, что мы можем увидеть всю Вселенную до конца. Поэтому они говорят, что изучают “наблюдаемую Вселенную”. Мощные телескопы помогают разглядеть очень далекие...");
                CheckFactAnswer("list_featured_snippet", "Лучшие соборы Санкт-Петербурга: названия, фото и описания; Казанский кафедральный собор, Исаакиевский собор, Спас на Крови, Смольный собор");
            }
    }

} // namespace NFactsSerpParser
