## Фильтр фактов по списку источников


### Как работает фильтр


При создании фильтру передают конфигурацию, включающую:

- `sources` - список источников факта
- `serp_types` - список типов факта в терминах фронтэнда (см. структуру `serp_data`)
- `fact_types` - список типов факта в терминах бекэнда
- `hostnames` - список хостов (FQDN)


Формально все списки являются опциональными.


Конфигурация может быть представлена в виде одного или нескольких JSON-объектов.
Во втором случае результирующая конфигурация получается объединением одноимённых списков по всем JSON-объектам.


Фильтр может быть создан для работы в одном из двух режимов:

- `Whitelist` - список разрешённых источников
- `Blacklist` - список запрещённых источников


Для каждого проверяемого факта фильтр получает на вход:

- `TStringBuf source` - название источника факта
- `TStringBuf serpType` - название фронтэндового типа проверяемого факта
- `TStringBuf factType` - название бекэндового типа проверяемого факта
- `TVector<TString> hostnames` - список полных имён хостов (FQDN), с которых были взяты документы, из которых был получен проверяемый факт


Алгоритм работы фильтра по отношению к проверяемому факту:

- если `source` или `serpType`, или `factType` у проверяемого факта (хотя бы один или несколько из них) содержится в соответствующем списке, заданном в конфигурации фильтра, то фильтр возвращает `true`
- далее выполняется проверка всех элементов массива `hostnames`. Способ проверки задан режимом работы фильтра:
  - в режиме `Whitelist`:
    - если массив `hostnames` не пуст, и все его элементы содержатся в списке `hostnames`, заданном в конфигурации фильтра, то фильтр возвращает `true`
  - в режиме `Blacklist`: 
    - если хотя бы один элемент массива `hostnames` содержится в списке `hostnames`, заданном в конфигурации фильтра, то фильтр возвращает `true`
- в противном случае фильтр возвращает `false`


Примечания:

- режим работы фильтра (`Whitelist` или `Blacklist`) не влияет на способ проверки `source`, `serpType`, `factType`
- в режиме `Whitelist` факт считается авторизованным-по-hostname только в том случае, если все его `hostnames` перечислены в whitelist, заданном в конфигурации
- в режиме `Blacklist` факт считается забаненным-по-hostname, если хотя бы один из его `hostnames` упомянут в blacklist, заданном в конфигурации


### Формат конфигурационного файла


Схема данных конфигурационного файла задана файлом-схемой [source_list_filter_config.sc](https://a.yandex-team.ru/arc/trunk/arcadia/kernel/facts/source_list_filter/source_list_filter_config.sc).


Имена типов и источников фактов в `sources`, `serp_types` и `fact_types` должны быть полными идентификаторами источников, как они сохраняются в `search_props`.
В частности, это означает, что они должны быть нормализованы при помощи функции [TSearcherProps::ConvertToValidKey](https://a.yandex-team.ru/arc/trunk/arcadia/search/session/searcherprops.h?rev=r9456152#L63) с заменой запрещённых символов на '_' (подчёркивание).
Фильтр самостоятельно выполняет нормализацию передаваемых ему параметров `source`, `serpType` и `factType` по данной схеме, но не выполняет нормализацию конфигурационного файла (т.е. вот именно конфигурационный файл уже должен быть нормализован).


Имена хостов в `hostnames` должны задавать полное имя хоста (FQDN) с использованием, где необходимо, Punycode.
Фильтр не выполняет никакой нормализации ни конфигурационных значений этих полей, ни передаваемых в параметрах вызова фильтра.
