#include "factor_names.h"

// autogenerated code
#include <kernel/generated_factors_info/simple_factors_info.h>

namespace NItdItpUserHistory {

class TItdItpUserHistoryFactorsInfo: public TSimpleSearchFactorsInfo<NItdItpUserHistory::TFactorInfo> {
public:
    TItdItpUserHistoryFactorsInfo()
        : TSimpleSearchFactorsInfo<NItdItpUserHistory::TFactorInfo>(FI_FACTOR_COUNT, GetFactorsInfo())
    {
    }

    TItdItpUserHistoryFactorsInfo(size_t begin, size_t end, const NItdItpUserHistory::TFactorInfo* factors)
        : TSimpleSearchFactorsInfo<NItdItpUserHistory::TFactorInfo>(end - begin, factors + begin)
    {
    }
};

const IFactorsInfo* GetItdItpUserHistoryFactorsInfo() {
    return Singleton<TItdItpUserHistoryFactorsInfo>();
}

// This function is declared in code-generated header factors_gen.h
TAutoPtr<IFactorsInfo> GetFactorsInfoIf(size_t begin, size_t end) {
    Y_ASSERT(begin <= end);
    Y_ASSERT(end <= N_FACTOR_COUNT);
    return new TItdItpUserHistoryFactorsInfo(begin, end, GetFactorsInfo());
}

}  // namespace NItdItpUserHistory
