#pragma once

#include "protos.h"

#include <util/generic/vector.h>
#include <util/datetime/base.h>

namespace NMango
{

struct TQuotesComparer {
    bool operator()(const NMango::TIndexQuote* a, const NMango::TIndexQuote* b) const;
    bool operator()(const NMango::TIndexQuote& a, const NMango::TIndexQuote& b) const;
};

class TQuotesFilterer
{
    bool Hardcore;
    size_t MaxQuotes;
    bool FastIndex; // actual only if Hardcore is true
    TInstant TimeNow;
private:
    bool FilterHardcore(TVector<const TIndexQuote*>& quotes) const;
public:
    TQuotesFilterer(bool hardcore = false, size_t maxQuotes = 4000, bool fastIndex = false, time_t now = 0)
        : Hardcore(hardcore)
        , MaxQuotes(maxQuotes)
        , FastIndex(fastIndex)
        , TimeNow(now ? TInstant::Seconds(now) : Now())
    {}
    void SortAndFilter(const TIndexQuotes &source, TVector<const TIndexQuote*>& dest) const;
    void SortAndFilter(TIndexQuotes &quotes) const;
};

bool IsRepost(NMango::TQuoteExtractionType type);
bool QuoteHasNoText(NMango::TQuoteExtractionType type);
void FixHtmlAuthority(TIndexQuotes& indexRecord);
TString GetQuoteDelId(const NMango::TQuote& q);
TString GetQuoteDelId(const NMango::TQuoteData& q);
TString GetShortTweetId(const TString& url);
// Tries to find and delete the quote text fragment that was auto-generated.
// For instance, the part marked with curly braces in "{Grand Theft Auto V: Official Gameplay Video}: GOTY 2013 ЭТО БОЖЕСТВЕННО!" most probably was not typed by the quote author, and we need to detect and erase it from the quote text.
// We do that by finding the longest common substring between the quote text and the resource annotation. If the LCS is long enough, it is very likely to have been auto-generated.
class TAutogeneratedTextRemover {
public:
    void SetAnnotation(const TUtf16String& annotationText);
    void RemoveFrom(TUtf16String& quoteText) const;

private:
    TUtf16String AnnotationText;
    mutable TVector<size_t> PrevDp;
    mutable TVector<size_t> Dp;
};

void CountReposts(NMango::TIndexQuotes& indexQuotes);

} // NMango
