#pragma once

#include "constraints.h"
#include <library/cpp/packedtypes/packedfloat.h>

#include <util/system/defaults.h>
#include <util/stream/output.h>

#define MANGO_TR_DIVERSITY_SIZE 20

struct TMangoDiversitySerializeData {
    char Data[MANGO_TR_DIVERSITY_SIZE];
};

struct TMangoWeightyWordWeights {
    float Weights[MAX_RELEVANCE_WEIGHTY_WORDS];
};

template<>
inline void Out<TMangoWeightyWordWeights>(IOutputStream& out, TTypeTraits<TMangoWeightyWordWeights>::TFuncParam cfs)
{
    out << '[' << cfs.Weights[0] << ',' << cfs.Weights[1] << ',' << cfs.Weights[2] << ',' << cfs.Weights[3] << ']';
}

template<>
inline void Out<TMangoDiversitySerializeData>(IOutputStream& out, TTypeTraits<TMangoDiversitySerializeData>::TFuncParam cfs)
{
    out << "[" << (int)(unsigned char)cfs.Data[0];
    for (size_t i = 1; i < Y_ARRAY_SIZE(cfs.Data); ++i) {
        out << "," << (int)(unsigned char)cfs.Data[i]; // i want print 255. not -1 and not 4294967295.
    }
    out << "]";
}


/// Autogenerated structures
#include <kernel/mango/common/types_format_gen.h>
