// * in patterns matches zero or more characters.
static const std::pair<TString, TString> DEPRECATED_DOC_PATTERNS_RAW[] = {
    std::make_pair("*.fixmeplz.ru", "*"),
    std::make_pair("*.wikipedia.org", "*"),
    std::make_pair("1love.ru", "*"),
    std::make_pair("3ke.ru", "*"),
    std::make_pair("8go.ru", "*"),
    std::make_pair("altergeo.ru", "*"),
    std::make_pair("anekdot.ru", "*"),
    std::make_pair("ask.fm", "*"),
    std::make_pair("bbattle.ru", "*"),
    std::make_pair("bezformata.ru", "*"),
    std::make_pair("citaty.info", "*"),
    std::make_pair("deck.ly", "*"),
    std::make_pair("dlvr.it", "*"),
    std::make_pair("erlanger.ru", "*"),
    std::make_pair("fllwrs.com", "*"),
    std::make_pair("facebook.com", "/event.php*"),
    std::make_pair("facebook.com", "/login.php*"),
    std::make_pair("facebook.com", "/pages/*"),
    std::make_pair("facebook.com", "/photo.php*"),
    std::make_pair("facebook.com", "/profile.php*"),
    std::make_pair("facebook.com", "/questions/*"),
    std::make_pair("facebook.com", "/video.php*"),
    std::make_pair("feedproxy.google.com", "*"),
    std::make_pair("feeds.feedburner.com", "*"),
    std::make_pair("fizy.com", "*"),
    std::make_pair("flickr.com", "*"),
    std::make_pair("flickr.com", "*"),
    std::make_pair("formspring.me", "*"),
    std::make_pair("fotki.yandex.ru", "*"),
    std::make_pair("funclubbattle.ru", "*"),
    std::make_pair("gallery.ru", "*"),
    std::make_pair("grooveshark.com", "*"),
    std::make_pair("howlonghaveyoubeentweeting.com", "*"),
    std::make_pair("img-fotki.yandex.ru", "*"),
    std::make_pair("instagr.am", "*"),
    std::make_pair("juick.com", "*"),
    std::make_pair("kiniska.com", "*"),
    std::make_pair("livejournal.com", "*"),
    std::make_pair("lockerz.com", "*"),
    std::make_pair("love-planet.znacomstva.name", "*"),
    std::make_pair("love.yakunin.net", "*"),
    std::make_pair("loveplanet.ru", "*"),
    std::make_pair("m.tmi.me", "*"),
    std::make_pair("m.tweete.net", "*"),
    std::make_pair("mtw.tl", "*"),
    std::make_pair("music.yandex.ru", "*"),
    std::make_pair("myloc.me", "*"),
    std::make_pair("mytwitfans.com", "*"),
    std::make_pair("mytwitterfans.com", "*"),
    std::make_pair("nblo.gs", "*"),
    std::make_pair("networkedblogs.com", "*"),
    std::make_pair("news.google.com", "*"),
    std::make_pair("news.mail.ru", "*"),
    std::make_pair("news.rambler.ru", "*"),
    std::make_pair("news.yandex.*", "*"),
    std::make_pair("*.news.yandex.*", "*"),
    std::make_pair("novoteka.ru", "*"),
    std::make_pair("photo.qip.ru", "*"),
    std::make_pair("picasaweb.google.com", "*"),
    std::make_pair("pics.livejournal.com", "*"),
    std::make_pair("plixi.com", "*"),
    std::make_pair("radikal.ru", "*"),
    std::make_pair("randevy.info", "*"),
    std::make_pair("rutracker.org", "*"),
    std::make_pair("spletni.ru", "*"),
    std::make_pair("sprashivai.ru", "*"),
    std::make_pair("status.writelonger.com", "*"),
    std::make_pair("stock.tjournal.ru", "*"),
    std::make_pair("*.thatcan.be", "*"),
    std::make_pair("thatcan.be", "*"),
    std::make_pair("*battleofbrands.*", "*"),
    std::make_pair("timespent.info", "*"),
    std::make_pair("tinypic.com", "*"),
    std::make_pair("tmi.me", "*"),
    std::make_pair("top-loveplanet.ru", "*"),
    std::make_pair("top.rbc.ru", "/"), // баним только морду
    std::make_pair("toptwit.ru", "*"),
    std::make_pair("tweetdeck.com", "*"),
    std::make_pair("twentyfeet.com", "*"),
    std::make_pair("twipiska.com", "*"),
    std::make_pair("twipremia.ru", "*"),
    std::make_pair("twitrbackgrounds.com", "*"),
    std::make_pair("twitcuties.com", "*"),
    std::make_pair("twitlonger.com", "*"),
    std::make_pair("twitpic.com", "*"),
    std::make_pair("twitter.com", "*"),
    std::make_pair("twitvid.com", "*"),
    std::make_pair("twiwar.ru", "*"),
    std::make_pair("twocation.com", "*"),
    std::make_pair("twtgoo.com", "*"),
    std::make_pair("vfotostrana.ru", "*"),
    std::make_pair("vk.com", "/album*"),
    std::make_pair("vk.com", "/club*"),
    std::make_pair("vk.com", "/eventwww.formspring.me*"),
    std::make_pair("vk.com", "/login.php*"),
    std::make_pair("vk.com", "/photo*"),
    std::make_pair("vkontakte.ru", "/album*"),
    std::make_pair("vkontakte.ru", "/club*"),
    std::make_pair("vkontakte.ru", "/eventwww.formspring.me*"),
    std::make_pair("vkontakte.ru", "/photo*"),
    std::make_pair("wl.tl", "*"),
    std::make_pair("yaushev.com", "*"),
    std::make_pair("yfrog.com", "*"),
};

static const std::pair<TString, TString> TRASH_DOC_PATTERNS_RAW[] = {
    std::make_pair("*.tk", "*"),
    std::make_pair("*.in", "*"),
    std::make_pair("4sq.com", "*"),
    std::make_pair("4ms.me", "*"),
    std::make_pair("addthis.com", "/bookmark.php*"),
    std::make_pair("bigsauron.ru", "*"),
    std::make_pair("blogger.com", "/blog_this.pyra*"),
    std::make_pair("connect.mail.ru", "/share*"),
    std::make_pair("facebook.com", "/sharer*"),
    std::make_pair("foursquare.com", "*"),
    std::make_pair("linkedin.com", "/shareArticle*"),
    std::make_pair("liveinternet.ru", "click*"),
    std::make_pair("livejournal.ru", "/themes*"),
    std::make_pair("livejournal.com", "/misc/latestqotd.bml*"),
    std::make_pair("livejournal.com", "/poll/*"),
    std::make_pair("livejournal.com", "/shop/*"),
    std::make_pair("livejournal.com", "/update.bml*"),
    std::make_pair("m.livejournal.com", "*"),
    std::make_pair("my.ya.ru", "/posts_add_link.xml*"),
    std::make_pair("rss2lj.net", "*"),
    std::make_pair("share.yandex.ru", "*"),
    std::make_pair("twitter.com", "/intent/tweet*"),
    std::make_pair("twitter.com", "/search/*"),
    std::make_pair("twitter.com", "/share*"),
    std::make_pair("vk.com", "/share.php*"),
    std::make_pair("vkontakte.ru", "/share.php*"),
    std::make_pair("www.bigsauron.ru", "*"),
};

static const std::pair<TString, TString> URL_MANGLER_PATTERNS_RAW[] = {
    std::make_pair("*", "/~r/*"),
    std::make_pair("rss.feedsportal.com", "*"),
};

static const TString IMAGE_EXTENSIONS_RAW[] = {
    "jpg",
    "jpeg",
    "gif",
    "png",
    "bmp",
    "tif",
    "tiff",
    "swf",
};

static const TString SHORTENERS_RAW[] = {
    "bit.ly",
    "t.co",
    "vk.cc",
    "tinyurl.com",
    "youtu.be",
    "twurl.nl",
    "tumblr.com",
    "goo.gl",
    "ff.im",
    "fb.me",
    "j.mp",
    "dlvr.it",
    "tl.gd",
    "ow.ly",
    "is.gd",
    "v.gd",
    "ping.fm",
    "lnk.ms",
    "migre.me",
    "0rq.ru",
    "post.ly",
    "bbc.in",
    "rly.cc",
    "su.pr",
    "tr.im",
    "nxy.in",
    "b23.ru",
    "clck.ru",
    "amzn.to",
    "wp.me",
    "ht.ly",
    "dld.bz",
    "huff.to",
};

#define DECLARE_VECTOR(x) x(std::begin(x##_RAW), std::end(x##_RAW));

static const TVector<std::pair<TString, TString> > DECLARE_VECTOR(DEPRECATED_DOC_PATTERNS);
static const TVector<std::pair<TString, TString> > DECLARE_VECTOR(TRASH_DOC_PATTERNS);
static const TVector<std::pair<TString, TString> > DECLARE_VECTOR(URL_MANGLER_PATTERNS);
static const TVector<TString> DECLARE_VECTOR(SHORTENERS);
static const TVector<TString> DECLARE_VECTOR(IMAGE_EXTENSIONS);

#undef DECLARE_VECTOR
