#include "calc_static.h"
#include <kernel/externalrelev/relev_descr_saver.h>

#include <library/cpp/deprecated/dater_old/structs.h>

#include <kernel/region2country/countries.h>
#include <kernel/remap/remap_adultness.h>
#include <kernel/remap/remap_table.h>
#include <kernel/factor_storage/factor_storage.h>
#include <kernel/relevfml/relev_fml.h>
#include <ysite/yandex/erf/erf_manager.h>
#include <ysite/yandex/relevance/util.h>
#include <ysite/yandex/dates/docdate.h>

#include <kernel/relevstatic/static.fml.inc>

const SRelevanceFormula& GetStaticRankRelForm() {
    return fmlstaticRank;
}

float StaticRank(const TConstFactorView& webFactors) {
    return staticRank(webFactors.GetConstFactors());
}

static const float fRT_Rank[] = {
    2000, 2371, 2795, 3159, 3523, 3887, 4252, 4630, 5055, 5547, 6062, 6708, 7487, 8416, 9619, 11623, 65000
};
static const TRemapTable remapRank(fRT_Rank, Y_ARRAY_SIZE(fRT_Rank));

static const float fNumLinks_Rank[] = {
    0, 371, 795, 1159, 1523, 1887, 2252, 2630, 3055, 3547, 4062, 4708, 5487, 6416, 7619, 9623, 6500000
};
static const TRemapTable remapNumLinks(fNumLinks_Rank, Y_ARRAY_SIZE(fNumLinks_Rank));

// used in .sfdl
#define DEBUG_DESCR(str) if (Y_UNLIKELY(csfp.DebugHandler)) csfp.DebugHandler->AddDescr(str)

// static float Ui162Float(ui16 value) {
//     return static_cast<float>(value) / 65535.0f;
// }

static float Log10Remap(const float value, const float max) {
    if (value > 0) {
        return Min<float>(log10f(value + 1.0f) / max, 1.0f);
    }
    return 0;
}

// tmp workaround
using TErfManagerType = TBasesearchErfManager;

// autogenerated from static_factors.sfdl:
// CalcStaticFeaturesAutoGenerated() and IFastStaticFeaturesCalculator for each fastrank formula
#include <kernel/relevstatic/static_factors.inc>

void CalcStaticFeatures(ui32 docId, TFactorView& webFactors, const TErfManager& em, const TCalcStaticFeaturesParams& csfp) {
    CalcStaticFeaturesAutoGenerated(docId, webFactors, em, nullptr, nullptr, csfp);
}

void CalcStaticFeatures(ui32 docId, TFactorView& webFactors, const TCompactErfManager& em, const TCalcStaticFeaturesParams& csfp) {
    CalcStaticFeaturesAutoGenerated(docId, webFactors, em, nullptr, nullptr, csfp);
}

void CalcStaticFeatures(ui32 docId, TFactorView& webFactors, const TCompactErfManagerP& em, const TCalcStaticFeaturesParams& csfp) {
    CalcStaticFeaturesAutoGenerated(docId, webFactors, em, nullptr, nullptr, csfp);
}

void CalcStaticFeatures(ui32 docId, TFactorView& webFactors, const TBasesearchErfManager& em, TBasesearchErfAccessor* accessor, THostErfAccessor* herfAccessor, const TCalcStaticFeaturesParams& csfp) {
    CalcStaticFeaturesAutoGenerated(docId, webFactors, em, accessor, herfAccessor, csfp);
}

void CalcStaticFeatures(ui32 docId, TFactorView& webFactors, const TOneDocErfData& em, const TCalcStaticFeaturesParams& csfp) {
    CalcStaticFeaturesAutoGenerated(docId, webFactors, em, nullptr, nullptr, csfp);
}

void CalcStaticFeaturesNoClear(ui32 docId, TFactorView& webFactors, const TErfManager& em, const TCalcStaticFeaturesParams& csfp) {
    CalcStaticFeaturesAutoGeneratedNoClear(docId, webFactors, em, nullptr, nullptr, csfp);
}

void CalcStaticFeaturesNoClear(ui32 docId, TFactorView& webFactors, const TBasesearchErfManager& em, TBasesearchErfAccessor* accessor, THostErfAccessor* herfAccessor, const TCalcStaticFeaturesParams& csfp) {
    CalcStaticFeaturesAutoGeneratedNoClear(docId, webFactors, em, accessor, herfAccessor, csfp);
}


template <class TErfManagerType>
float CalcSingleStaticFeatureImpl(ui32 docId, EFactorId factorId, const TErfManagerType& em, const TCalcStaticFeaturesParams& csfp) {
    TFactorStorage factors{TFactorDomain(EFactorSlice::WEB_PRODUCTION)};
    TFactorView fv = factors.CreateViewFor(EFactorSlice::WEB_PRODUCTION);
    CalcStaticFeatures(docId, fv, em, csfp);

    return fv[factorId];
}

float CalcSingleStaticFeatureImpl(ui32 docId, EFactorId factorId, const TBasesearchErfManager& em, TBasesearchErfAccessor* erfAccessor, THostErfAccessor* herfAccessor, const TCalcStaticFeaturesParams& csfp) {
    TFactorStorage factors{TFactorDomain(EFactorSlice::WEB_PRODUCTION)};
    TFactorView fv = factors.CreateViewFor(EFactorSlice::WEB_PRODUCTION);
    CalcStaticFeatures(docId, fv, em, erfAccessor, herfAccessor, csfp);

    return fv[factorId];
}



float CalcSingleStaticFeature(ui32 docId, EFactorId factorId, const TErfManager& em, const TCalcStaticFeaturesParams& csfp) {
    return CalcSingleStaticFeatureImpl(docId, factorId, em, csfp);
}

float CalcSingleStaticFeature(ui32 docId, EFactorId factorId, const TBasesearchErfManager& em, TBasesearchErfAccessor* erfAccessor, THostErfAccessor* herfAccessor, const TCalcStaticFeaturesParams& csfp) {
    return CalcSingleStaticFeatureImpl(docId, factorId, em, erfAccessor, herfAccessor, csfp);
}
