#pragma once

#include <util/system/defaults.h>
#include <kernel/web_factors_info/factor_names.h>
#include <ysite/yandex/dates/docdate.h>
#include <ysite/yandex/relevance/langstat.h>
#include <ysite/yandex/erf/erf_manager.h>

class TFactorStorage;

class TErfManager;
class TBasesearchErfManager;

struct SRelevanceFormula;
class TRemapTable;
class IRelevDescrSaver;

struct TErfValue;
struct TErfValueCache;

/**
 * This structure contains some data that basically should NOT bed used in static factors.
 * For example, CurrentDate.
 *
 * Some options are experimental only and should NOT be used in production (PageRank options)
 **/

struct TCalcStaticFeaturesParams {
    IRelevDescrSaver* DebugHandler = nullptr;
    const NDater::TCurrentDateParams* CurrentDate = nullptr;

    bool UseIndexPR = false; // For SEARCH-1028 only
    bool UseIndexUkrPR = false; // For SEARCH-1028 only
};

// clear factors and fill static features
void CalcStaticFeatures(ui32 docId, TFactorView& webFactors, const TErfManager& em, const TCalcStaticFeaturesParams& csfp);
void CalcStaticFeatures(ui32 docId, TFactorView& webFactors, const TCompactErfManager& em, const TCalcStaticFeaturesParams& csfp);
void CalcStaticFeatures(ui32 docId, TFactorView& webFactors, const TCompactErfManagerP& em, const TCalcStaticFeaturesParams& csfp);
void CalcStaticFeatures(ui32 docId, TFactorView& webFactors, const TBasesearchErfManager& em, TBasesearchErfAccessor* accessor, THostErfAccessor* herfAccessor, const TCalcStaticFeaturesParams& csfp);
void CalcStaticFeatures(ui32 docId, TFactorView& webFactors, const TOneDocErfData& em, const TCalcStaticFeaturesParams& csfp);

// does not clear factors and fill static features
void CalcStaticFeaturesNoClear(ui32 docId, TFactorView& webFactors, const TErfManager& em, const TCalcStaticFeaturesParams& csfp);
void CalcStaticFeaturesNoClear(ui32 docId, TFactorView& webFactors, const TBasesearchErfManager& em, TBasesearchErfAccessor* accessor, THostErfAccessor* herfAccessor, const TCalcStaticFeaturesParams& csfp);

class IFastStaticFeaturesCalculator {
public:
    // clear factors
    virtual void PreFastRank(ui32 docId, TFactorView& webFactors, const TBasesearchErfManager& em, TBasesearchErfAccessor* erfAccessor, const TCalcStaticFeaturesParams& csfp) const = 0;

    virtual void PostFastRank(ui32 docId, TFactorView& webFactors, const TBasesearchErfManager& em, TBasesearchErfAccessor* erfAccessor, const TCalcStaticFeaturesParams& csfp) const = 0;
    virtual const char* GetName() = 0;

    // impl autogenerated from static_factors.sfdl
    static IFastStaticFeaturesCalculator* GetInstance(const char* formula);
};

float CalcSingleStaticFeature(ui32 docId, EFactorId factorId, const TErfManager& em, const TCalcStaticFeaturesParams& csfp);
float CalcSingleStaticFeature(ui32 docId, EFactorId factorId, const TBasesearchErfManager& em, TBasesearchErfAccessor* erfAccessor, THostErfAccessor* herfAccessor, const TCalcStaticFeaturesParams& csfp);

const SRelevanceFormula& GetStaticRankRelForm();
float StaticRank(const TConstFactorView& webFactors);
