#include "factor_names.h"
// autogenerated code
#include <kernel/robot_selectionrank_factors_info/factors_gen.cpp>

#include <kernel/generated_factors_info/simple_factors_info.h>

#include <util/generic/singleton.h>

namespace NSelectionRank {
    namespace NFactors {
        class TSelectionRankFactorsInfo : public TSimpleSearchFactorsInfo<NSelectionRank::NFactors::TFactorInfo> {
        public:
            TSelectionRankFactorsInfo()
                : TSimpleSearchFactorsInfo<NSelectionRank::NFactors::TFactorInfo>(NSelectionRank::NFactors::FI_FACTOR_COUNT, NSelectionRank::NFactors::GetFactorsInfo())
            {}

            TSelectionRankFactorsInfo(size_t begin, size_t end, const TFactorInfo* factorInfo)
                : TSimpleSearchFactorsInfo<NSelectionRank::NFactors::TFactorInfo>(end - begin, factorInfo + begin)
            {}
        };

        const IFactorsInfo* GetSelectionRankFactorsInfo() {
            return Singleton<TSelectionRankFactorsInfo>();
        }

        TAutoPtr<IFactorsInfo> GetFactorsInfoIf(size_t begin, size_t end) {
            Y_ASSERT(begin <= end);
            Y_ASSERT(end <= NSelectionRank::NFactors::FI_FACTOR_COUNT);
            return new TSelectionRankFactorsInfo(begin, end, GetFactorsInfo());
        }

    } // NFactors
} // NSelectionRank
