#include "enums_impl.h"

namespace NSe
{
    TVector< std::pair<const char*, ESearchEngine> > GetSearchEngineNames()
    {
        const std::pair<const char*, ESearchEngine> SearchEngineNames[] =
        {
            std::make_pair("yandex", SE_YANDEX),
            std::make_pair("google", SE_GOOGLE),
            std::make_pair("rambler", SE_RAMBLER),
            std::make_pair("mail.ru", SE_MAIL),
            std::make_pair("baidu", SE_BAIDU),
            std::make_pair("gogo", SE_GOGO),
            std::make_pair("bing", SE_BING),
            std::make_pair("yahoo", SE_YAHOO),
            std::make_pair("nigma", SE_NIGMA),
            std::make_pair("aport", SE_APORT),
            std::make_pair("all.by", SE_ALL_BY),
            std::make_pair("tut.by", SE_TUT_BY),
            std::make_pair("bigmir", SE_BIGMIR),
            std::make_pair("meta.ua", SE_META_UA),
            std::make_pair("search.com", SE_SEARCH_COM),
            std::make_pair("aol", SE_AOL),
            std::make_pair("lycos", SE_LYCOS),
            std::make_pair("qip", SE_QIP),
            std::make_pair("exalead", SE_EXALEAD),
            std::make_pair("alexa", SE_ALEXA),
            std::make_pair("webalta", SE_WEBALTA),
            std::make_pair("quintura", SE_QUINTURA),
            std::make_pair("metabot.ru", SE_METABOT_RU),
            std::make_pair("conduit", SE_CONDUIT),
            std::make_pair("i.ua", SE_I_UA),
            std::make_pair("daemon-search", SE_DAEMON_SEARCH),
            std::make_pair("incredimail", SE_INCREDIMAIL),
            std::make_pair("gde.ru", SE_GDE_RU),
            std::make_pair("mywebsearch", SE_MY_WEB_SEARCH),
            std::make_pair("search.babylon", SE_SEARCH_BABYLON),
            std::make_pair("seznam.cz", SE_SEZNAM_CZ),
            std::make_pair("mapy.cz", SE_MAPY_CZ),
            std::make_pair("zbozi.cz", SE_ZBOZI_CZ),
            std::make_pair("obrazky.cz", SE_OBRAZKY_CZ),
            std::make_pair("firmy.cz", SE_FIRMY_CZ),
            std::make_pair("gbg.bg", SE_GBG_BG),
            std::make_pair("nur.kz", SE_NUR_KZ),
            std::make_pair("kazakh.ru", SE_KAZAKH_RU),
            std::make_pair("duckduckgo", SE_DUCKDUCKGO),
            std::make_pair("km.ru", SE_GO_KM_RU),
            std::make_pair("gigabase.ru", SE_GIGABASE_RU),
            std::make_pair("search.kaz.kz", SE_SEARCH_KAZ_KZ),
            std::make_pair("poisk.ru", SE_POISK_RU),
            std::make_pair("icq.com", SE_ICQ_COM),
            std::make_pair("ask.com", SE_ASK_COM),
            std::make_pair("blekko", SE_BLEKKO),
            std::make_pair("topsy", SE_TOPSY),
            std::make_pair("youtube", SE_YOUTUBE),
            std::make_pair("tineye", SE_TINEYE),
            std::make_pair("lemoteur", SE_LEMOTEUR),
            std::make_pair("naver", SE_NAVER),
            std::make_pair("liveinternet", SE_LIVEINTERNET),
            std::make_pair("handycafe", SE_HANDYCAFE),
            std::make_pair("searchya", SE_SEARCHYA),
            std::make_pair("sogou", SE_SOGOU),
            std::make_pair("ria", SE_RIA),
            std::make_pair("lenta", SE_LENTA_RU),
            std::make_pair("gazeta", SE_GAZETA_RU),
            std::make_pair("newsru", SE_NEWSRU),
            std::make_pair("vesti", SE_VESTI_RU),
            std::make_pair("rbc", SE_RBC_RU),
            std::make_pair("vz", SE_VZ_RU),
            std::make_pair("kp", SE_KP_RU),
            std::make_pair("regnum", SE_REGNUM),
            std::make_pair("dni", SE_DNI_RU),
            std::make_pair("utro", SE_UTRO_RU),
            std::make_pair("mk", SE_MK_RU),
            std::make_pair("aif", SE_AIF_RU),
            std::make_pair("rg", SE_RG_RU),
            std::make_pair("vedomosti", SE_VEDOMOSTI),
            std::make_pair("rb", SE_RB_RU),
            std::make_pair("trud", SE_TRUD_RU),
            std::make_pair("rin", SE_RIN_RU),
            std::make_pair("izvestia", SE_IZVESTIA),
            std::make_pair("kommersant", SE_KOMMERSANT),
            std::make_pair("expert", SE_EXPERT_RU),
            std::make_pair("interfax", SE_INTERFAX),
            std::make_pair("echo.msk", SE_ECHO_MSK),
            std::make_pair("newizv", SE_NEWIZV),
            std::make_pair("rbcdaily", SE_RBC_DAILY),
            std::make_pair("argumenti", SE_ARGUMENTI),
            std::make_pair("vk", SE_VKONTAKTE),
            std::make_pair("facebook", SE_FACEBOOK),
            std::make_pair("twitter", SE_TWITTER),
            std::make_pair("odnoklassniki.ru", SE_ODNOKLASSNIKI),
            std::make_pair("livejournal", SE_LIVEJOURNAL),
            std::make_pair("ya", SE_YA_RU),
            std::make_pair("linkedin", SE_LINKEDIN),
            std::make_pair("mamba", SE_MAMBA),
            std::make_pair("sprashivai.ru", SE_SPRASHIVAI_RU),
            std::make_pair("tumblr", SE_TUMBLR),
            std::make_pair("myspace", SE_MYSPACE),
            std::make_pair("itunes", SE_ITUNES),
            std::make_pair("zvooq", SE_ZVOOQ),
            std::make_pair("grooveshark", SE_GROOVESHARK),
            std::make_pair("lastfm", SE_LAST_FM),
            std::make_pair("prostopleer", SE_PROSTOPLEER),
            std::make_pair("soundcloud", SE_SOUNDCLOUD),
            std::make_pair("muzebra", SE_MUZEBRA),
            std::make_pair("weborama", SE_WEBORAMA),
            std::make_pair("101", SE_101_RU),
            std::make_pair("deezer", SE_DEEZER),
            std::make_pair("pandora", SE_PANDORA),
            std::make_pair("moikrug", SE_MOIKRUG),
            std::make_pair("hh", SE_HH),
            std::make_pair("rabota", SE_RABOTA_RU),
            std::make_pair("superjob", SE_SUPERJOB),
            std::make_pair("job.ru", SE_JOB_RU),
            std::make_pair("rutracker.org", SE_RUTRACKER_ORG),
            std::make_pair("rutor.org", SE_RUTOR_ORG),
            std::make_pair("torrentino.com", SE_TORRENTINO_COM),
            std::make_pair("fast-torrent.ru", SE_FAST_TORRENT_RU),
            std::make_pair("tfile.me", SE_TFILE_ME),
            std::make_pair("kinozal.tv", SE_KINOZAL_TV),
            std::make_pair("nnm-club.ru", SE_NNM_CLUB_RU),
            std::make_pair("ex.ua", SE_EX_UA),
            std::make_pair("torrent-games.net", SE_TORRENT_GAMES_NET),
            std::make_pair("my-hit.ru", SE_MY_HIT_RU),
            std::make_pair("retre.org", SE_RETRE_ORG),
            std::make_pair("torrentino.ru", SE_TORRENTINO_RU),
            std::make_pair("x-torrents.org", SE_X_TORRENTS_ORG),
            std::make_pair("mix.sibnet.ru", SE_MIX_SIBNET_RU),
            std::make_pair("torrentfilms.net", SE_TORRENTFILMS_NET),
            std::make_pair("seedoff.net", SE_SEEDOFF_NET),
            std::make_pair("pornoshara.tv", SE_PORNOSHARA_TV),
            std::make_pair("tfile.org", SE_TFILE_ORG),
            std::make_pair("torrentszona.com", SE_TORRENTSZONA_COM),
            std::make_pair("xxx-tracker.com", SE_XXX_TRACKER_COM),
            std::make_pair("kubalibre.com", SE_KUBALIBRE_COM),
            std::make_pair("imhonet.ru", SE_FILMS_IMHONET_RU),
            std::make_pair("torrentsmd.com", SE_TORRENTSMD_COM),
            std::make_pair("torrnado.ru", SE_TORRNADO_RU),
            std::make_pair("riper.am", SE_RIPER_AM),
            std::make_pair("kinovit.ru", SE_KINOVIT_RU),
            std::make_pair("katushka.net", SE_KATUSHKA_NET),
            std::make_pair("kat.ph", SE_KAT_PH),
            std::make_pair("weburg.net", SE_WEBURG_NET),
            std::make_pair("kinokopilka.tv", SE_KINOKOPILKA_TV),
            std::make_pair("filebase.ws", SE_FILEBASE_WS),
            std::make_pair("evrl.to", SE_EVRL_TO),
            std::make_pair("arenabg.com", SE_ARENABG_COM),
            std::make_pair("4fun.mksat.net", SE_4FUN_MKSAT_NET),
            std::make_pair("beetor.org", SE_BEETOR_ORG),
            std::make_pair("extratorrent.com", SE_EXTRATORRENT_COM),
            std::make_pair("isohunt.com", SE_ISOHUNT_COM),
            std::make_pair("newtorr.org", SE_NEWTORR_ORG),
            std::make_pair("rarbg.com", SE_RARBG_COM),
            std::make_pair("tracker.name", SE_TRACKER_NAME),
            std::make_pair("bigfangroup.org", SE_BIGFANGROUP_ORG),
            std::make_pair("file.lu", SE_FILE_LU),
            std::make_pair("linkomanija.net", SE_LINKOMANIJA_NET),
            std::make_pair("omgtorrent.com", SE_OMGTORRENT_COM),
            std::make_pair("smartorrent.com", SE_SMARTORRENT_COM),
            std::make_pair("t411.me", SE_T411_ME),
            std::make_pair("torrent.ai", SE_TORRENT_AI),
            std::make_pair("torrentdownloads.me", SE_TORRENTDOWNLOADS_ME),
            std::make_pair("torrentreactor.net", SE_TORRENTREACTOR_NET),
            std::make_pair("zamunda.net", SE_ZAMUNDA_NET),
            std::make_pair("myvi", SE_MYVI_RU),
            std::make_pair("rutube", SE_RUTUBE),
            std::make_pair("kinostok", SE_KINOSTOK_TV),
            std::make_pair("ukrhome", SE_UKRHOME_NET),
            std::make_pair("namba", SE_NAMBA_NET),
            std::make_pair("bigcinema", SE_BIGCINEMA_TV),
            std::make_pair("kaztube", SE_KAZTUBE_KZ),
            std::make_pair("kiwi.kz", SE_KIWI_KZ),
            std::make_pair("now.ru", SE_NOW_RU),
            std::make_pair("vimeo", SE_VIMEO),
            std::make_pair("akilli", SE_AKILLI_TV),
            std::make_pair("dailymotion", SE_DAILYMOTION_COM),
            std::make_pair("izlemex", SE_IZLEMEX_ORG),
            std::make_pair("kuzu", SE_KUZU_TV),
            std::make_pair("tekniktv", SE_TEKNIKTV_COM),
            std::make_pair("izlesene", SE_IZLESENE_COM),
            std::make_pair("live.com", SE_LIVE_COM),
            std::make_pair("ngs.ru", SE_NGS_RU),
            std::make_pair("bannersbroker.com", SE_BANNERSBROKER_COM),
            std::make_pair("adcash.com", SE_ADCASH_COM),
            std::make_pair("yieldmanager.com", SE_YIELDMANAGER_COM),
            std::make_pair("luxup.ru", SE_LUXUP_RU),
            std::make_pair("adonweb.ru", SE_ADONWEB_RU),
            std::make_pair("advertlink.ru", SE_ADVERTLINK_RU),
            std::make_pair("adnxs.com", SE_ADNXS_COM),
            std::make_pair("exoclick.com", SE_EXOCLICK_COM),
            std::make_pair("recreativ.ru", SE_RECREATIV_RU),
            std::make_pair("ruclicks.com", SE_RUCLICKS_COM),
            std::make_pair("ladycenter.ru", SE_LADYCENTER_RU),
            std::make_pair("medialand.ru", SE_MEDIALAND_RU),
            std::make_pair("admitad.com", SE_ADMITAD_COM),
            std::make_pair("rmbn.net", SE_RMBN_NET),
            std::make_pair("tbn.ru", SE_TBN_RU),
            std::make_pair("adnetwork.pro", SE_ADNETWORK_PRO),
            std::make_pair("dt00.net", SE_DT00_NET),
            std::make_pair("yadro.ru", SE_YADRO_RU),
            std::make_pair("kavanga.ru", SE_KAVANGA_RU),
            std::make_pair("adwolf.ru", SE_ADWOLF_RU),
            std::make_pair("magna.ru", SE_MAGNA_RU),
            std::make_pair("goodadvert.ru", SE_GOODADVERT_RU),
            std::make_pair("adriver.ru", SE_ADRIVER_RU),
            std::make_pair("adfox.ru", SE_ADFOX_RU),
            std::make_pair("adblender.ru", SE_ADBLENDER_RU),
            std::make_pair("begun.ru", SE_BEGUN_RU),
            std::make_pair("directadvert.ru", SE_DIRECTADVERT_RU),
            std::make_pair("gameleads.ru", SE_GAMELEADS_RU),
            std::make_pair("buysellads.com", SE_BUYSELLADS_COM),
            std::make_pair("cityads.ru", SE_CITYADS_RU),
            std::make_pair("marketgid.com", SE_MARKETGID_COM),
            // Popular porno hostings
            std::make_pair("sex.com", SE_SEX_COM),
            std::make_pair("redtube", SE_REDTUBE),
            std::make_pair("pornhub", SE_PORNHUB),
            std::make_pair("porn.com", SE_PORN_COM),
            std::make_pair("porntube", SE_PORNTUBE),
            std::make_pair("xhamster", SE_XHAMSTER),
            std::make_pair("xvideos", SE_XVIDEOS),
            std::make_pair("youporn", SE_YOUPORN),
            std::make_pair("tube8", SE_TUBE8),
            std::make_pair("xnxx", SE_XNXX),
            std::make_pair("pornmd", SE_PORNMD),
            // Sputnik.ru
            std::make_pair("sputnik.ru", SE_SPUTNIK_RU),
            // Istella.it
            std::make_pair("istella", SE_ISTELLA),
            // Popular online shops
            std::make_pair("avito", SE_AVITO),
            std::make_pair("aliexpress", SE_ALIEXPRESS),
            std::make_pair("ozon", SE_OZON),
            std::make_pair("wildberries", SE_WILDBERRIES),
            std::make_pair("lamoda", SE_LAMODA),
            std::make_pair("ulmart", SE_ULMART),
            std::make_pair("asos", SE_ASOS),
            std::make_pair("003", SE_003_RU),
            std::make_pair("booking", SE_BOOKING_COM),
            std::make_pair("afisha", SE_AFISHA_RU),
            std::make_pair("doubleclick", SE_IMPL_DOUBLECLICK),
            // Ads.
            std::make_pair("criteo", SE_CRITEO),
        };
        return TVector< std::pair<const char*, ESearchEngine> >(
            SearchEngineNames,
            SearchEngineNames + Y_ARRAY_SIZE(SearchEngineNames)
        );
    }

    TVector< std::pair<const char*, ESearchType> > GetSearchTypeNames()
    {
        static const std::pair<const char*, ESearchType> SearchTypeNames[] =
        {
            std::make_pair("web", ST_WEB),
            std::make_pair("images", ST_IMAGES),
            std::make_pair("video", ST_VIDEO),
            std::make_pair("blog", ST_BLOGS),
            std::make_pair("forum", ST_FORUM),
            std::make_pair("social", ST_SOCIAL),
            std::make_pair("news", ST_NEWS),
            std::make_pair("events", ST_EVENTS),
            std::make_pair("music", ST_MUSIC),
            std::make_pair("com", ST_COM),     // shopping, boards, advertisement
            std::make_pair("tv", ST_TV),
            std::make_pair("games", ST_GAMES),
            std::make_pair("answer", ST_ANSWER),
            std::make_pair("cat", ST_CATALOG),
            std::make_pair("apps", ST_APPS),
            std::make_pair("int", ST_INTERESTS),
            std::make_pair("books", ST_BOOKS),
            std::make_pair("people", ST_PEOPLE),
            std::make_pair("adr", ST_ADRESSES),
            std::make_pair("maps", ST_MAPS),
            std::make_pair("encyc", ST_ENCYC),
            std::make_pair("science", ST_SCIENCE),
            std::make_pair("cars", ST_CARS),
            std::make_pair("sport", ST_SPORT),
            std::make_pair("rec", ST_RECIPES),
            std::make_pair("abs", ST_ABSTRACTS),
            std::make_pair("job", ST_JOB),
            std::make_pair("byimage", ST_BYIMAGE),
            std::make_pair("magazines", ST_MAGAZINES),
            std::make_pair("torrent", ST_TORRENTS),
            std::make_pair("adv_serp", ST_ADV_SERP),
            std::make_pair("adv_web", ST_ADV_WEB),
        };
        return TVector< std::pair<const char*, ESearchType> >(
            SearchTypeNames,
            SearchTypeNames + Y_ARRAY_SIZE(SearchTypeNames)
        );
    }

    TVector< std::pair<const char*, ESearchFlags> > GetSearchFlagNames()
    {
        static const std::pair<const char*, ESearchFlags> SearchFlagsNames[] =
        {
            std::make_pair("mobile", SF_MOBILE),
            std::make_pair("logined", SF_LOGINED), // search url available only for logined users
            std::make_pair("fsocial", SF_SOCIAL),  // search inside social network
            std::make_pair("local", SF_LOCAL),
            std::make_pair("fpeople", SF_PEOPLE),
            std::make_pair("redirect", SF_REDIRECT),
            std::make_pair("mail", SF_MAIL),
            std::make_pair("search", SF_SEARCH),
            std::make_pair("fake_search", SF_FAKE_SEARCH),
        };
        return TVector< std::pair<const char*, ESearchFlags> >(
            SearchFlagsNames,
            SearchFlagsNames + Y_ARRAY_SIZE(SearchFlagsNames)
        );
    }

    TVector< std::pair<const char*, EPlatform> > GetPlatformNames()
    {
        const std::pair<const char*, EPlatform> PlatformNames[] =
        {
            std::make_pair("android", P_ANDROID),
            std::make_pair("iphone",  P_IPHONE),
            std::make_pair("ipad",    P_IPAD),
            std::make_pair("wp",      P_WINDOWS_PHONE),
            std::make_pair("winrt",   P_WINDOWS_RT),
        };
        return TVector< std::pair<const char*, EPlatform> >(
            PlatformNames,
            PlatformNames + Y_ARRAY_SIZE(PlatformNames)
        );
    }
};
