#include "sent_lens_data_trie.h"

#include <library/cpp/archive/yarchive.h>

namespace {
    const unsigned char ArchiveData[] = {
        #include <kernel/sent_lens/trie_blob.inc> // autogenerated
    };

    const TArchiveReader TestDataArchive(TBlob::NoCopy(ArchiveData, sizeof(ArchiveData)));
} // namespace // anonymous

TSentLensDataCollectionTrie::TSentLensDataCollectionTrie()
    : Trie(TestDataArchive.ObjectBlobByKey("/sent_lens_data_trie_blob.inc"))
{}

size_t TSentLensDataCollectionTrie::FindLongestPrefix(const ui8* begin, size_t size, ui16* index) {
    size_t len = 0;
    bool found = Trie.FindLongestPrefix(begin, size, &len, index);

    if (!found) {
        len = 0;
        *index = 0;
    }
    return len;
}
