#include "abbrev_words.h"

#include <util/charset/wide.h>
#include <util/generic/singleton.h>
#include <util/stream/file.h>
#include <util/stream/mem.h>
#include <util/memory/blob.h>

#include <library/cpp/containers/comptrie/chunked_helpers_trie.h>

// something like cat svn+ssh://arcadia/arc/trunk/data/snippets/decapitalization/abbrevs.txt | contrib/tools/file2c/file2c
const unsigned char AbbrevContainerDefault[] = {
82,78,20,94,181,183,74,78,89,13,175,73,77,7,43,128,70,0,201,73,14,25,0,
72,82,6,128,70,0,128,73,0,72,70,6,128,65,0,64,67,128,79,0,136,75,4,0,64,
74,64,65,128,83,0,73,83,11,35,136,85,4,0,128,65,0,72,82,6,128,80,0,64,80,
201,67,8,11,0,128,80,0,128,66,0,64,68,128,70,0,192,84,0,128,80,0,202,71,
125,9,83,0,137,78,5,66,0,73,73,9,35,64,84,128,83,0,73,68,9,20,64,76,128,
67,0,64,67,72,77,6,128,83,0,128,73,0,192,70,0,128,76,0,72,77,12,72,84,6,
128,73,0,128,78,0,192,76,0,72,84,6,128,70,0,64,67,128,67,0,137,84,5,39,
0,73,80,9,17,64,69,128,83,0,192,79,0,64,83,128,83,0,64,83,72,77,10,64,73,
64,80,128,83,0,64,67,128,66,0,72,87,6,128,83,0,192,86,0,64,67,128,75,0,
74,68,177,6,225,73,77,11,122,136,83,4,0,128,80,0,73,69,13,72,72,82,6,128,
70,0,128,80,0,73,67,27,43,137,69,5,14,0,136,67,4,0,64,66,128,85,0,72,76,
6,128,65,0,128,71,0,192,65,0,73,82,7,10,128,67,0,128,67,0,128,83,0,192,
68,0,73,73,7,10,128,67,0,128,70,0,128,79,0,73,73,19,32,73,73,9,12,64,80,
128,80,0,128,65,0,128,83,0,64,70,137,70,5,8,0,128,66,0,128,80,0,64,76,64,
84,128,68,0,73,84,7,35,128,80,0,73,82,7,12,128,67,0,64,80,128,83,0,192,
83,0,137,76,5,10,0,64,69,128,71,0,128,85,0,137,87,5,10,0,64,86,128,73,0,
64,89,128,80,0,74,66,151,3,186,73,78,7,93,128,90,0,73,70,9,49,64,83,128,
78,0,201,68,8,35,0,128,67,0,200,67,21,0,137,82,5,14,0,136,70,4,0,64,65,
128,77,0,128,85,0,192,65,0,128,82,0,64,69,128,82,0,73,76,15,28,72,83,6,
128,65,0,64,67,128,65,0,64,73,137,73,5,8,0,128,67,0,128,77,0,64,77,136,
69,4,0,128,65,0,73,83,13,34,136,66,4,0,64,65,128,80,0,73,80,9,16,64,84,
128,83,0,64,79,64,84,128,66,0,64,82,128,66,0,137,85,5,14,0,64,84,136,73,
4,0,128,65,0,64,87,128,70,0,64,65,74,77,44,1,125,137,77,5,24,0,72,67,12,
72,89,6,128,65,0,128,83,0,64,66,64,76,128,65,0,72,87,10,64,79,64,76,128,
70,0,64,83,128,65,0,73,70,65,250,73,73,9,40,64,80,128,83,0,73,68,9,23,64,
65,128,67,0,200,67,7,0,128,67,0,64,66,64,80,128,79,0,192,69,0,64,77,128,
83,0,73,83,7,12,128,65,0,64,76,128,68,0,64,84,136,67,4,0,128,65,0,73,67,
64,139,73,69,7,39,128,69,0,73,67,17,22,72,82,8,64,82,128,65,0,64,65,128,
77,0,64,65,128,69,0,64,68,192,76,0,64,71,128,77,0,73,77,9,14,64,67,128,
70,0,64,72,128,65,0,64,85,64,66,128,79,0,72,66,22,73,79,7,16,128,82,0,136,
74,4,0,64,73,128,83,0,128,80,0,64,65,73,76,9,40,64,80,128,79,0,73,68,7,
26,128,80,0,64,67,73,76,7,14,128,83,0,64,72,64,72,128,83,0,128,80,0,64,
70,128,65,0,72,82,6,128,77,0,64,81,128,83,0,72,69,27,73,83,7,19,128,66,
0,200,80,7,0,128,80,0,64,67,128,65,0,64,89,128,67,0,64,68,73,67,9,14,64,
65,128,80,0,64,65,128,67,0,128,87,0,73,73,36,80,73,76,9,21,64,66,128,65,
0,200,67,7,0,128,83,0,64,65,128,83,0,72,82,6,128,85,0,64,79,128,78,0,72,
72,35,73,73,7,18,128,67,0,72,69,8,64,77,128,83,0,128,66,0,200,85,7,0,128,
67,0,64,83,64,69,128,80,0,64,71,64,80,64,82,128,65,0,64,74,64,74,128,80,
0,202,83,125,1,24,0,137,76,5,73,0,201,68,8,45,0,128,78,0,200,66,11,0,136,
69,4,0,128,65,0,192,65,0,137,70,5,14,0,136,68,4,0,64,67,128,84,0,136,82,
4,0,64,77,128,83,0,72,73,12,72,79,6,128,67,0,128,71,0,64,72,136,80,4,0,
64,73,128,65,0,201,85,18,43,0,72,87,6,128,84,0,64,76,64,71,128,67,0,72,
83,18,137,73,5,12,0,64,67,64,79,128,77,0,128,77,0,64,82,64,68,128,65,0,
128,87,0,201,80,54,96,0,137,80,5,28,0,73,76,9,20,64,65,128,78,0,72,70,6,
128,65,0,64,66,128,83,0,128,77,0,73,86,7,18,128,73,0,136,84,4,0,64,83,64,
76,128,79,0,128,87,0,72,79,12,72,83,6,128,72,0,128,74,0,192,78,0,73,79,
19,24,72,87,12,64,82,64,73,64,77,128,79,0,128,71,0,64,66,128,70,0,128,80,
0,64,82,73,73,11,42,136,80,4,0,128,67,0,73,68,9,26,64,65,128,67,0,72,67,
8,64,65,128,80,0,64,65,136,76,4,0,128,67,0,64,72,128,65,0,73,83,7,10,128,
84,0,128,77,0,64,84,128,72,0,73,86,37,105,73,83,9,28,64,69,128,65,0,72,
80,16,64,69,64,82,64,83,64,67,64,79,128,77,0,128,72,0,64,84,128,65,0,72,
85,18,73,75,9,12,64,77,128,65,0,128,73,0,128,78,0,192,84,0,73,70,7,30,128,
65,0,73,68,7,18,128,65,0,72,67,6,128,65,0,64,65,128,80,0,64,69,128,70,0,
137,79,5,12,0,64,71,64,69,128,79,0,64,80,128,69,0,64,87,73,67,7,20,128,
67,0,72,66,6,128,79,0,64,65,64,80,128,65,0,72,77,8,64,66,128,65,0,64,73,
128,67,0,192,67,0,202,77,17,1,128,0,72,72,6,128,68,0,64,69,128,67,0,73,
71,15,250,72,85,6,128,66,0,64,76,128,69,0,73,68,17,159,137,69,5,8,0,128,
67,0,64,79,128,84,0,73,66,15,70,72,84,8,64,77,128,66,0,128,73,0,64,65,201,
73,10,31,0,64,70,128,65,0,73,69,7,16,128,82,0,72,68,6,128,86,0,128,65,0,
64,71,128,84,0,73,84,7,17,128,69,0,200,82,7,0,128,66,0,128,77,0,64,86,128,
67,0,64,67,73,77,7,47,128,72,0,201,68,12,29,0,64,80,64,72,128,80,0,72,67,
6,128,79,0,64,65,72,79,6,128,77,0,128,77,0,72,76,6,128,83,0,64,69,128,82,
0,73,84,7,16,128,71,0,72,82,6,128,73,0,128,78,0,64,85,64,83,128,76,0,72,
70,14,72,84,6,128,65,0,64,65,128,67,0,64,69,73,76,7,30,128,65,0,73,69,9,
20,64,69,128,82,0,72,67,6,128,65,0,64,65,128,83,0,128,72,0,137,83,5,25,
0,200,80,13,0,72,79,6,128,68,0,128,72,0,64,77,64,80,128,65,0,64,85,128,
83,0,73,74,13,94,136,87,4,0,64,82,128,83,0,200,73,35,0,73,73,7,22,128,65,
0,73,68,7,10,128,81,0,128,67,0,64,69,128,67,0,136,83,4,0,64,82,128,68,0,
192,72,0,73,70,7,30,128,65,0,73,67,9,16,64,70,128,65,0,64,65,64,68,128,
83,0,64,69,64,77,128,83,0,137,83,5,10,0,64,82,128,80,0,128,85,0,200,76,
18,0,137,68,5,11,0,192,66,0,128,65,0,128,82,0,64,75,128,85,0,73,83,42,160,
73,72,7,22,128,65,0,73,66,7,10,128,78,0,128,65,0,64,69,128,84,0,137,83,
5,13,0,192,80,0,64,65,128,69,0,128,85,0,73,80,41,73,73,73,7,26,128,69,0,
73,67,7,14,128,82,0,64,65,64,67,128,69,0,64,68,128,80,0,72,82,6,128,73,
0,64,79,128,67,0,72,79,20,137,72,5,8,0,128,67,0,64,73,136,76,4,0,128,67,
0,64,78,136,87,4,0,192,68,0,128,65,0,200,82,33,0,73,70,7,18,128,87,0,72,
69,8,64,73,128,70,0,128,66,0,72,82,6,128,78,0,64,80,128,79,0,192,81,0,72,
76,6,128,80,0,128,65,0,73,86,23,64,137,85,5,14,0,136,79,4,0,64,72,128,83,
0,64,89,128,83,0,72,85,22,137,69,5,12,0,136,66,4,0,128,65,0,64,83,64,73,
128,70,0,64,84,137,83,5,14,0,136,77,4,0,64,65,128,70,0,128,85,0,72,89,12,
72,80,6,128,69,0,128,77,0,64,87,64,82,128,82,0,72,70,168,73,77,7,80,128,
69,0,73,70,9,49,64,84,128,89,0,201,67,16,27,0,137,68,5,8,0,128,67,0,128,
82,0,64,65,136,83,4,0,64,65,128,83,0,64,69,72,83,6,128,67,0,64,76,128,67,
0,200,76,15,0,72,80,6,128,65,0,64,73,128,83,0,64,73,136,80,4,0,128,66,0,
73,84,11,72,136,89,4,0,128,76,0,201,82,12,17,0,136,75,4,0,128,67,0,64,80,
128,65,0,192,83,0,73,77,7,26,128,87,0,137,67,5,10,0,64,65,128,84,0,64,72,
136,83,4,0,128,80,0,137,85,5,10,0,64,80,128,85,0,64,87,128,79,0,72,89,6,
128,68,0,64,87,64,66,128,79,0,64,69,73,74,7,141,128,77,0,73,69,9,78,64,
77,128,79,0,73,67,23,52,73,83,7,16,128,65,0,136,66,4,0,64,65,128,72,0,128,
85,0,72,66,6,128,83,0,64,65,73,82,11,16,64,78,64,69,128,84,0,64,67,128,
80,0,64,83,128,67,0,64,68,73,76,9,12,64,65,128,67,0,128,67,0,128,79,0,73,
71,21,28,73,73,9,12,64,77,128,65,0,128,70,0,64,80,128,67,0,64,70,64,67,
128,79,0,192,72,0,73,82,7,20,128,80,0,72,71,6,128,83,0,64,65,64,87,128,
85,0,64,84,128,65,0,201,83,34,97,0,73,68,9,18,64,73,128,83,0,72,67,6,128,
73,0,128,66,0,136,86,4,0,64,72,64,65,128,80,0,73,79,11,44,64,83,64,69,128,
67,0,72,78,18,72,87,12,64,79,64,66,64,72,128,77,0,128,82,0,64,76,73,77,
7,10,128,72,0,128,72,0,128,80,0,192,80,0,73,82,7,13,128,85,0,192,65,0,128,
68,0,128,83,0,73,88,15,88,136,73,4,0,64,65,64,70,128,83,0,64,84,137,76,
5,48,0,73,66,25,32,73,73,9,16,64,79,128,83,0,64,69,64,85,128,73,0,64,76,
128,84,0,64,65,64,80,128,80,0,64,67,136,70,4,0,64,68,128,70,0,72,83,14,
64,69,64,84,64,77,64,65,128,78,0,64,80,64,69,64,82,128,70,0,64,89,128,79,
0,74,75,60,2,183,73,77,7,28,128,85,0,73,70,11,16,64,85,64,83,128,84,0,64,
65,128,79,0,64,74,128,86,0,73,82,11,18,136,73,4,0,128,65,0,64,79,64,84,
128,66,0,64,85,64,68,64,73,128,67,0,82,73,1,128,2,77,73,77,37,245,201,72,
8,26,0,128,69,0,72,66,6,128,89,0,192,65,0,72,83,6,128,84,0,128,67,0,136,
83,4,0,128,82,0,73,70,13,160,136,84,4,0,64,70,128,70,0,73,67,49,104,73,
77,9,30,64,79,128,83,0,73,69,7,16,128,84,0,64,65,136,80,4,0,128,68,0,64,
72,128,68,0,137,85,5,10,0,64,84,128,65,0,64,87,128,65,0,72,66,19,73,83,
7,13,128,67,0,192,82,0,128,83,0,128,84,0,192,65,0,73,73,7,24,128,68,0,73,
68,7,12,128,80,0,64,65,128,65,0,64,71,128,83,0,136,80,4,0,64,77,128,83,
0,72,69,18,137,79,5,10,0,64,72,128,83,0,64,83,128,82,0,64,68,73,82,7,20,
128,82,0,72,68,10,136,77,4,0,128,75,0,128,65,0,128,83,0,137,74,5,31,0,72,
73,6,128,72,0,192,72,0,73,82,7,12,128,68,0,64,70,128,87,0,64,83,128,83,
0,64,76,72,77,10,64,68,64,84,128,83,0,64,73,128,70,0,73,83,40,87,137,79,
5,25,0,73,67,7,12,128,67,0,64,65,128,67,0,192,71,0,64,85,128,65,0,136,84,
4,0,64,80,64,79,128,77,0,73,80,21,42,201,67,8,14,0,128,67,0,192,65,0,128,
83,0,128,83,0,72,79,16,72,83,10,136,84,4,0,128,72,0,128,67,0,64,78,128,
82,0,64,82,128,86,0,73,87,9,39,64,65,128,82,0,200,86,7,0,128,85,0,64,84,
73,76,7,14,128,69,0,64,67,64,77,128,66,0,64,84,64,84,128,82,0,64,89,64,
79,128,87,0,192,72,0,201,76,22,99,0,73,70,7,12,128,69,0,64,66,128,73,0,
64,80,128,65,0,73,69,19,60,137,74,5,12,0,64,69,64,82,128,76,0,128,83,0,
73,66,9,34,64,82,128,67,0,64,65,73,78,9,18,64,69,128,83,0,136,73,4,0,64,
71,128,69,0,64,80,128,83,0,64,68,64,82,128,79,0,73,73,7,14,128,78,0,64,
71,64,82,128,73,0,128,75,0,73,82,22,61,201,80,8,15,0,128,76,0,136,67,4,
0,128,65,0,128,84,0,73,78,9,16,64,69,128,83,0,64,77,64,82,128,67,0,64,80,
137,73,5,16,0,72,67,6,128,79,0,64,65,128,85,0,64,82,128,67,0,72,84,20,73,
82,7,12,128,67,0,64,67,128,85,0,64,83,128,65,0,192,83,0,73,76,7,16,128,
83,0,72,68,6,128,65,0,128,67,0,128,85,0,192,74,0,73,72,7,28,128,83,0,73,
68,9,16,64,79,128,84,0,64,65,64,71,128,67,0,64,69,128,65,0,73,80,7,12,128,
87,0,64,73,128,84,0,128,87,0,200,77,173,0,73,77,11,85,136,85,4,0,128,65,
0,73,70,11,46,136,83,4,0,128,67,0,73,68,11,30,136,67,4,0,128,65,0,72,67,
14,137,73,5,8,0,128,66,0,128,80,0,64,65,128,80,0,64,69,128,65,0,201,73,
14,23,0,136,84,4,0,64,68,128,66,0,72,72,6,128,71,0,128,71,0,64,76,128,73,
0,201,83,26,54,0,73,81,7,18,128,84,0,72,77,6,128,65,0,64,68,128,67,0,128,
85,0,73,80,7,18,128,65,0,72,79,6,128,65,0,64,78,128,83,0,192,82,0,136,73,
4,0,128,71,0,73,85,7,15,128,78,0,192,84,0,64,67,128,66,0,64,86,72,84,8,
64,73,128,83,0,64,79,128,67,0,64,76,73,74,7,84,128,68,0,73,69,21,48,73,
83,7,14,128,79,0,64,67,64,84,128,67,0,128,88,0,201,66,10,15,0,64,72,128,
65,0,64,65,128,87,0,192,68,0,72,84,6,128,70,0,128,83,0,73,72,11,22,64,73,
64,71,128,65,0,64,71,72,74,6,128,65,0,128,73,0,64,73,64,72,128,67,0,137,
81,5,35,0,73,79,7,18,128,83,0,64,78,136,71,4,0,64,65,128,67,0,192,80,0,
72,73,6,128,68,0,128,67,0,201,83,14,35,0,136,80,4,0,64,77,128,87,0,64,82,
137,67,5,12,0,136,66,4,0,128,65,0,136,73,4,0,128,68,0,128,87,0,74,85,128,
4,147,73,77,17,52,137,76,5,8,0,128,65,0,64,77,128,73,0,73,69,9,22,64,89,
128,83,0,72,67,8,64,65,128,83,0,64,66,128,67,0,72,74,6,128,80,0,64,70,64,
65,128,78,0,73,83,29,56,137,80,5,18,0,72,79,6,128,74,0,64,75,64,73,128,
78,0,64,84,64,65,128,82,0,72,82,8,64,66,128,83,0,64,80,73,83,9,12,64,65,
128,87,0,128,76,0,64,84,128,75,0,72,87,8,64,83,128,83,0,64,84,64,65,128,
73,0,74,82,184,2,66,73,77,15,84,72,76,6,128,65,0,64,67,128,65,0,73,69,29,
46,137,77,5,14,0,136,76,4,0,64,71,128,65,0,72,86,8,64,83,128,83,0,128,78,
0,73,67,7,12,128,83,0,64,65,128,79,0,64,68,128,67,0,73,72,15,20,137,77,
5,8,0,128,72,0,128,80,0,64,70,128,68,0,128,73,0,201,84,36,76,0,73,80,7,
16,128,83,0,136,76,4,0,64,69,128,69,0,72,86,8,64,66,128,82,0,64,82,64,68,
128,69,0,73,80,13,25,136,78,4,0,64,71,128,77,0,192,79,0,72,84,6,128,67,
0,128,67,0,64,83,73,82,7,10,128,79,0,128,73,0,128,86,0,73,87,11,16,136,
87,4,0,128,84,0,64,86,128,79,0,128,90,0,74,80,164,1,133,201,79,16,95,0,
136,86,4,0,64,69,64,83,128,83,0,73,73,13,54,136,86,4,0,64,65,128,83,0,73,
68,13,24,136,73,4,0,64,69,128,83,0,136,67,4,0,64,65,64,80,128,73,0,64,70,
73,77,7,10,128,67,0,128,76,0,64,80,128,67,0,73,76,7,12,128,67,0,64,75,128,
90,0,64,77,72,83,8,64,82,128,80,0,128,76,0,201,84,12,36,0,136,78,4,0,128,
76,0,201,82,8,15,0,128,87,0,64,80,64,69,128,83,0,64,83,136,78,4,0,128,72,
0,201,86,8,15,0,128,82,0,64,85,64,83,128,84,0,64,87,137,83,5,8,0,128,80,
0,128,84,0,64,79,73,75,9,89,64,85,128,84,0,73,70,7,57,128,88,0,73,67,21,
42,73,79,7,12,128,76,0,64,70,128,76,0,64,84,128,73,0,72,66,6,128,65,0,64,
65,73,69,7,10,128,76,0,128,65,0,128,79,0,64,68,192,67,0,128,67,0,73,72,
9,18,64,83,128,67,0,64,71,64,65,64,80,128,83,0,64,73,128,86,0,73,82,39,
101,73,73,11,24,64,78,64,67,128,79,0,137,67,5,10,0,64,65,128,68,0,128,68,
0,72,82,6,128,65,0,64,77,128,76,0,73,79,9,46,64,83,128,82,0,72,77,16,72,
70,8,64,69,128,84,0,64,66,128,90,0,64,76,137,82,5,16,0,72,72,8,64,71,128,
65,0,128,70,0,128,83,0,192,80,0,72,76,8,64,65,128,84,0,64,65,128,84,0,73,
84,9,28,64,80,128,77,0,64,83,72,83,10,64,68,64,65,128,86,0,64,68,64,82,
128,65,0,64,87,128,67,0,64,81,128,70,0,72,84,144,73,77,7,83,128,83,0,73,
70,13,40,72,84,6,128,82,0,128,83,0,73,68,9,22,64,84,128,86,0,72,67,8,64,
82,128,65,0,64,65,128,65,0,64,69,128,69,0,73,73,11,16,136,83,4,0,128,65,
0,64,72,128,85,0,64,76,201,77,12,15,0,64,83,64,83,128,80,0,128,67,0,128,
80,0,73,83,7,31,128,66,0,201,80,8,13,0,128,67,0,64,79,128,85,0,64,82,72,
87,6,128,66,0,128,80,0,73,85,17,20,73,83,7,10,128,84,0,128,65,0,128,84,
0,128,84,0,64,86,64,68,128,77,0,192,83,0,73,77,11,188,136,68,4,0,128,65,
0,201,70,26,112,0,73,78,9,18,64,69,128,84,0,136,71,4,0,64,65,128,83,0,128,
87,0,73,67,20,59,137,68,5,11,0,192,65,0,128,65,0,64,76,128,67,0,72,66,10,
136,77,4,0,128,69,0,192,65,0,201,80,12,23,0,136,73,4,0,128,65,0,72,73,6,
128,68,0,64,66,128,80,0,128,85,0,72,69,10,64,69,64,82,128,83,0,64,68,137,
76,5,10,0,64,65,128,82,0,64,85,128,72,0,73,73,19,58,73,80,7,12,128,83,0,
64,68,128,67,0,128,83,0,72,72,16,72,83,6,128,83,0,64,77,64,66,128,65,0,
64,71,73,78,11,16,64,83,64,78,128,79,0,64,73,128,67,0,64,82,128,80,0,64,
76,64,68,128,83,0,73,84,32,97,137,80,5,21,0,73,68,7,13,128,65,0,192,65,
0,128,67,0,128,73,0,136,86,4,0,128,85,0,73,82,15,35,136,73,4,0,64,68,64,
69,128,67,0,200,80,17,0,137,68,5,10,0,64,67,128,67,0,128,69,0,128,78,0,
64,83,73,69,7,16,128,65,0,72,68,6,128,67,0,128,65,0,136,79,4,0,192,76,0,
64,72,128,65,0,201,87,19,26,0,72,77,6,128,65,0,192,67,0,64,68,128,68,0,
136,86,4,0,128,85,0,64,89,64,83,128,85,0,73,88,7,236,128,69,0,72,87,132,
137,71,5,51,0,73,67,15,29,72,73,6,128,77,0,64,69,128,84,0,72,66,8,64,72,
128,77,0,192,65,0,128,68,0,72,70,14,137,68,5,8,0,128,66,0,128,80,0,128,
68,0,201,79,42,67,0,73,71,15,30,72,84,6,128,77,0,64,72,128,77,0,72,66,8,
64,72,128,77,0,64,65,64,72,128,77,0,64,83,64,66,128,77,0,72,73,8,64,67,
128,79,0,64,72,73,73,7,10,128,67,0,128,67,0,64,82,128,67,0,72,87,6,128,
76,0,64,84,128,70,0,64,86,73,77,11,53,64,72,64,67,128,73,0,137,72,5,27,
0,73,69,9,19,64,83,128,68,0,192,67,0,136,67,4,0,128,65,0,128,71,0,72,76,
8,64,65,128,80,0,64,73,64,67,128,80,0,201,82,10,31,0,64,65,128,77,0,136,
81,4,0,64,79,73,67,7,12,128,67,0,64,65,128,68,0,128,68,0,72,87,6,128,65,
0,64,86,128,66,0,200,90,62,0,137,72,5,37,0,73,67,11,24,64,67,64,83,128,
83,0,72,66,8,64,65,128,85,0,64,65,128,78,0,192,68,0,64,77,128,79,0,73,83,
7,18,128,76,0,72,81,6,128,65,0,64,80,128,79,0,128,90,0,192,89,0,73,76,9,
124,64,80,128,73,0,73,69,13,62,136,87,4,0,64,66,128,78,0,201,67,37,44,0,
73,79,9,27,64,83,128,72,0,72,76,12,136,85,4,0,64,65,128,87,0,192,66,0,128,
73,0,64,80,128,68,0,64,66,64,79,128,84,0,64,68,128,74,0,73,72,7,26,128,
65,0,64,70,137,69,5,14,0,72,67,6,128,79,0,128,65,0,128,87,0,64,73,73,76,
9,20,64,70,128,70,0,72,71,6,128,70,0,64,65,128,83,0,64,83,128,79,0,73,83,
70,97,73,71,11,57,64,88,64,82,128,67,0,73,68,13,26,64,79,136,84,4,0,128,
72,0,64,65,72,73,8,64,70,128,65,0,128,65,0,192,69,0,72,83,10,64,76,64,65,
128,84,0,64,82,64,68,128,65,0,136,78,4,0,64,72,128,80,0,73,80,15,22,137,
68,5,8,0,128,67,0,128,76,0,64,77,64,69,128,88,0,64,82,128,80,0,200,85,9,
0,64,83,128,84,0,128,84,0,82,71,9,83,98,163,202,77,205,5,165,0,73,76,9,
121,64,82,128,83,0,73,69,11,87,136,83,4,0,128,65,0,73,67,25,57,137,73,5,
12,0,136,72,4,0,128,66,0,72,76,6,128,67,0,128,74,0,192,65,0,73,80,7,22,
128,67,0,73,73,7,10,128,76,0,128,68,0,64,75,128,69,0,136,87,4,0,128,84,
0,64,68,73,83,7,14,128,83,0,136,78,4,0,128,72,0,128,84,0,72,73,20,137,73,
5,14,0,136,68,4,0,64,67,128,83,0,128,79,0,64,72,128,67,0,201,82,24,51,0,
137,80,5,16,0,72,79,6,128,73,0,64,69,128,83,0,128,83,0,200,80,21,0,73,76,
7,12,128,83,0,64,67,128,83,0,64,84,128,69,0,192,79,0,128,68,0,136,86,4,
0,64,83,137,75,5,12,0,136,67,4,0,128,65,0,136,83,4,0,64,77,128,66,0,74,
71,81,3,68,73,79,7,42,128,83,0,137,75,5,26,0,137,67,5,16,0,64,66,136,83,
4,0,64,70,128,83,0,64,71,128,69,0,72,77,6,128,77,0,128,76,0,73,84,9,22,
64,65,128,77,0,72,83,10,136,78,4,0,128,66,0,128,80,0,200,88,7,0,128,88,
0,64,87,128,65,0,74,68,114,1,249,73,78,7,41,128,70,0,73,69,7,25,128,77,
0,201,67,8,13,0,128,72,0,64,65,128,76,0,64,68,128,83,0,136,77,4,0,64,74,
128,66,0,73,83,25,55,137,73,5,14,0,136,70,4,0,64,66,128,83,0,136,83,4,0,
128,78,0,200,80,15,0,72,84,8,64,82,128,87,0,128,83,0,64,79,137,73,5,10,
0,64,67,128,83,0,128,80,0,72,87,8,64,65,128,77,0,64,84,128,82,0,74,66,59,
1,21,201,73,8,41,0,128,70,0,73,66,7,18,128,65,0,64,65,136,83,4,0,64,68,
128,83,0,64,67,73,83,7,10,128,65,0,128,73,0,128,84,0,72,80,8,64,76,128,
70,0,64,79,128,66,0,64,65,73,77,27,117,73,78,9,16,64,65,128,65,0,64,76,
64,83,128,83,0,64,83,64,65,128,84,0,73,70,9,57,64,84,128,65,0,137,67,5,
37,0,72,66,13,192,65,0,64,82,64,65,128,80,0,64,65,137,82,5,12,0,136,80,
4,0,128,67,0,64,84,128,87,0,64,69,64,82,136,70,4,0,128,67,0,73,74,9,18,
64,65,128,84,0,64,73,136,81,4,0,128,71,0,64,76,72,76,8,64,83,128,65,0,64,
67,128,75,0,73,84,25,66,73,79,7,14,128,83,0,136,70,4,0,128,66,0,136,84,
4,0,128,83,0,73,82,9,24,64,66,128,67,0,72,81,6,128,76,0,64,80,136,80,4,
0,128,73,0,64,83,137,81,5,8,0,128,66,0,64,84,64,80,128,69,0,73,86,13,24,
136,73,4,0,64,68,128,80,0,64,85,136,73,4,0,64,68,128,73,0,64,87,136,82,
4,0,128,75,0,64,67,137,76,5,70,0,201,69,10,52,0,64,80,128,71,0,201,67,12,
37,0,136,83,4,0,128,70,0,64,65,73,82,7,14,128,68,0,136,76,4,0,128,65,0,
72,84,6,128,84,0,128,83,0,64,68,128,84,0,72,75,6,128,83,0,64,73,64,68,128,
69,0,201,80,8,19,0,128,81,0,72,78,6,128,78,0,64,77,128,86,0,72,83,12,136,
69,4,0,64,65,128,65,0,64,82,72,77,6,128,78,0,128,65,0,72,70,116,73,74,7,
54,128,73,0,73,68,7,32,128,76,0,73,66,9,20,64,79,128,80,0,64,65,136,80,
4,0,64,65,128,83,0,64,67,128,73,0,137,70,5,12,0,64,69,64,66,128,83,0,128,
73,0,73,82,7,30,128,67,0,73,79,7,16,128,80,0,64,77,136,83,4,0,128,69,0,
64,80,64,65,128,65,0,73,84,7,24,128,78,0,64,83,137,82,5,12,0,136,77,4,0,
128,75,0,128,89,0,64,87,128,76,0,192,69,0,73,79,25,74,73,72,9,16,64,79,
128,84,0,64,68,64,83,128,83,0,64,83,128,83,0,137,70,5,34,0,73,67,19,24,
73,67,7,12,128,79,0,64,65,128,83,0,128,70,0,64,65,128,66,0,64,68,128,67,
0,72,77,10,136,66,4,0,128,65,0,64,76,128,67,0,73,82,13,34,136,68,4,0,64,
65,128,77,0,72,81,6,128,79,0,64,80,73,79,7,10,128,78,0,128,78,0,128,84,
0,72,85,6,128,85,0,64,83,73,72,7,12,128,73,0,64,67,128,73,0,128,73,0,74,
74,12,1,19,64,69,64,80,128,67,0,72,73,206,73,79,7,97,128,80,0,73,70,13,
63,136,67,4,0,64,65,128,83,0,73,67,25,38,73,69,7,18,128,67,0,72,68,6,128,
70,0,64,65,128,78,0,128,83,0,64,65,72,73,6,128,83,0,64,72,128,83,0,192,
68,0,136,76,4,0,64,69,128,80,0,73,72,10,15,192,69,0,128,68,0,64,71,128,
79,0,64,77,192,80,0,136,83,4,0,128,65,0,73,84,33,83,73,69,13,22,136,88,
4,0,64,87,128,83,0,136,68,4,0,64,65,128,77,0,136,83,4,0,128,70,0,73,82,
9,20,64,79,128,65,0,64,80,136,71,4,0,64,67,128,65,0,192,83,0,137,83,5,20,
0,136,78,4,0,64,65,72,73,6,128,68,0,128,67,0,64,84,64,68,128,65,0,73,88,
9,16,64,82,128,68,0,64,86,64,65,128,83,0,64,89,64,85,128,83,0,64,72,73,
82,13,40,136,72,4,0,64,67,128,66,0,137,71,5,20,0,64,67,136,78,4,0,64,74,
64,77,64,83,128,65,0,64,73,64,70,128,84,0,73,84,7,10,128,70,0,128,83,0,
64,87,128,84,0,72,76,118,73,73,21,73,73,66,7,12,128,67,0,64,65,128,67,0,
64,67,128,83,0,73,67,7,49,128,70,0,72,66,25,137,80,5,8,0,128,65,0,192,84,
0,72,82,6,128,84,0,64,73,128,81,0,64,65,73,83,7,12,128,84,0,64,65,128,68,
0,128,84,0,128,70,0,73,83,13,35,136,83,4,0,64,69,128,78,0,200,80,11,0,136,
85,4,0,128,75,0,64,79,64,78,64,65,64,83,128,83,0,64,84,64,83,128,68,0,64,
75,72,77,6,128,80,0,128,73,0,74,84,107,3,16,73,72,7,56,128,84,0,201,68,
8,38,0,128,73,0,72,66,6,128,83,0,192,65,0,73,76,7,14,128,75,0,136,73,4,
0,128,71,0,136,87,4,0,128,80,0,72,71,6,128,69,0,64,70,128,79,0,73,77,7,
29,128,79,0,200,76,11,0,136,83,4,0,128,68,0,64,73,72,83,6,128,67,0,128,
78,0,72,85,12,136,71,4,0,64,66,128,69,0,64,82,128,69,0,138,81,6,1,157,0,
73,79,119,213,73,75,11,74,64,65,64,82,128,84,0,73,70,9,44,64,65,128,73,
0,73,68,9,30,64,65,128,69,0,64,65,73,82,7,12,128,78,0,64,76,128,73,0,64,
83,64,84,128,84,0,64,69,128,80,0,72,73,8,64,69,128,70,0,64,71,136,67,4,
0,64,65,128,89,0,137,80,5,24,0,72,79,12,72,79,6,128,72,0,128,67,0,64,77,
64,79,128,83,0,72,87,8,64,82,128,82,0,64,84,136,89,4,0,128,86,0,64,78,73,
77,7,42,128,65,0,73,70,7,25,128,83,0,201,67,8,13,0,128,67,0,64,66,128,68,
0,64,69,128,80,0,200,73,7,0,128,83,0,128,72,0,73,85,9,37,64,80,128,71,0,
201,80,12,19,0,136,68,4,0,128,67,0,64,79,64,77,128,69,0,64,83,136,83,4,
0,128,79,0,72,89,8,64,68,128,77,0,64,86,128,81,0,192,80,0,73,77,15,104,
137,69,5,8,0,128,67,0,128,71,0,73,71,9,42,64,80,128,85,0,137,69,5,27,0,
72,67,10,136,82,4,0,128,73,0,192,65,0,64,82,64,84,64,69,128,68,0,192,70,
0,128,83,0,73,73,28,41,137,72,5,8,0,128,66,0,192,79,0,72,83,6,128,82,0,
64,82,64,73,128,83,0,64,72,136,82,4,0,64,79,64,78,128,69,0,192,76,0,128,
67,0,201,83,20,57,0,73,67,7,10,128,89,0,128,65,0,64,73,128,84,0,73,79,17,
22,137,69,5,10,0,64,66,128,65,0,128,78,0,64,78,128,89,0,64,82,73,77,7,10,
128,67,0,128,65,0,128,83,0,201,85,12,25,0,136,90,4,0,128,65,0,192,84,0,
192,77,0,64,73,64,77,128,82,0,64,87,128,83,0,72,83,157,73,73,13,78,136,
83,4,0,64,68,128,73,0,73,69,7,36,128,82,0,73,67,13,24,72,83,6,128,65,0,
128,80,0,72,66,6,128,78,0,64,65,128,75,0,64,68,128,73,0,73,71,7,18,128,
80,0,64,70,72,77,6,128,79,0,128,67,0,64,72,136,80,4,0,64,72,128,83,0,73,
80,9,55,64,68,128,65,0,73,77,11,31,136,80,4,0,128,65,0,192,76,0,73,73,11,
14,136,83,4,0,128,66,0,128,66,0,128,86,0,64,79,73,69,7,10,128,80,0,128,
67,0,128,80,0,73,84,7,16,128,78,0,64,83,64,65,64,80,128,73,0,64,86,128,
68,0,64,82,201,73,26,84,0,73,76,7,18,128,65,0,72,72,6,128,65,0,64,67,128,
83,0,128,79,0,73,68,17,41,137,73,5,10,0,64,68,128,76,0,128,80,0,64,65,73,
86,13,19,64,65,64,84,64,65,128,82,0,192,83,0,128,83,0,128,87,0,64,69,72,
84,6,128,76,0,64,65,64,68,64,69,128,82,0,73,82,9,16,64,69,128,77,0,64,78,
64,68,128,83,0,64,85,128,82,0,73,87,52,131,137,80,5,30,0,137,75,5,20,0,
72,69,10,136,83,4,0,128,67,0,64,65,128,83,0,64,79,128,84,0,137,84,5,12,
0,64,82,64,82,128,65,0,192,85,0,128,80,0,72,86,35,73,83,7,22,128,69,0,72,
82,10,136,80,4,0,128,68,0,64,72,128,68,0,200,87,7,0,128,82,0,128,86,0,64,
85,73,77,7,25,128,72,0,73,69,7,12,128,85,0,64,67,128,72,0,192,73,0,128,
68,0,72,85,12,136,71,4,0,64,65,128,77,0,64,82,128,84,0,72,90,14,72,83,6,
128,90,0,64,73,128,80,0,64,89,64,83,128,68,0,82,68,11,204,64,99,202,77,
188,6,227,0,201,73,18,124,0,137,70,5,8,0,128,65,0,64,80,128,83,0,201,68,
8,69,0,128,69,0,137,66,5,52,0,192,65,0,73,82,7,22,128,68,0,73,73,7,10,128,
67,0,128,67,0,64,80,128,73,0,200,84,9,0,64,67,128,82,0,64,83,72,84,8,64,
69,128,82,0,128,83,0,64,67,136,67,4,0,128,65,0,73,70,13,32,136,67,4,0,64,
65,128,83,0,64,69,73,80,9,12,64,79,128,83,0,128,77,0,64,82,128,67,0,64,
71,128,84,0,73,84,17,46,137,70,5,10,0,64,67,128,83,0,128,83,0,73,80,15,
18,72,79,8,64,82,128,84,0,128,77,0,128,76,0,64,83,136,80,4,0,64,79,128,
67,0,136,88,4,0,192,86,0,64,80,128,78,0,74,71,46,4,26,73,78,9,30,64,83,
128,83,0,73,71,7,14,128,69,0,64,66,64,65,128,83,0,64,76,64,65,128,80,0,
72,83,6,128,69,0,64,80,128,83,0,74,68,149,2,128,73,77,7,87,128,71,0,201,
69,12,56,0,136,88,4,0,128,67,0,73,67,15,33,72,77,6,128,80,0,64,76,128,67,
0,72,66,6,128,74,0,64,65,136,84,4,0,192,77,0,128,77,0,64,68,136,83,4,0,
64,65,128,83,0,137,75,5,18,0,72,73,8,64,83,128,77,0,64,71,128,83,0,192,
76,0,128,79,0,73,83,7,39,128,82,0,73,80,7,24,128,83,0,72,79,12,136,83,4,
0,64,66,128,74,0,64,78,128,83,0,192,82,0,64,65,128,77,0,201,85,8,13,0,128,
71,0,64,84,128,67,0,64,87,128,71,0,74,66,85,1,30,73,77,7,51,128,83,0,73,
70,9,31,64,79,128,84,0,73,67,11,17,136,83,4,0,128,77,0,192,65,0,128,78,
0,64,69,128,70,0,72,76,8,64,72,128,67,0,64,75,128,90,0,73,83,7,20,128,75,
0,72,80,8,64,83,128,75,0,64,78,128,83,0,136,90,4,0,64,87,128,79,0,64,65,
73,77,13,93,72,79,6,128,80,0,128,76,0,73,70,7,51,128,73,0,201,67,18,27,
0,137,76,5,10,0,64,65,128,87,0,128,82,0,64,65,136,80,4,0,128,68,0,64,68,
137,70,5,12,0,64,65,64,68,128,65,0,128,84,0,73,72,15,22,72,76,6,128,73,
0,64,68,128,73,0,64,71,64,79,128,67,0,64,76,64,82,128,79,0,73,82,22,59,
73,78,7,12,128,78,0,64,65,128,77,0,192,80,0,128,65,0,73,79,19,24,73,68,
9,12,64,65,128,83,0,128,67,0,128,83,0,64,78,128,76,0,64,80,136,76,4,0,64,
67,64,69,128,80,0,201,84,10,33,0,64,67,128,80,0,64,83,73,70,9,18,64,65,
128,65,0,136,68,4,0,64,67,128,72,0,128,80,0,192,87,0,72,73,6,128,65,0,64,
71,128,83,0,64,67,73,77,7,122,128,73,0,201,70,16,72,0,64,73,64,78,64,68,
64,69,128,82,0,73,67,24,47,137,80,5,17,0,192,67,0,72,73,6,128,73,0,128,
68,0,128,84,0,72,66,10,64,87,64,70,128,81,0,64,65,137,67,5,8,0,128,65,0,
128,80,0,64,69,136,82,4,0,128,70,0,73,73,21,38,73,80,11,14,136,83,4,0,128,
67,0,128,69,0,128,83,0,136,72,4,0,64,71,137,75,5,8,0,128,73,0,128,83,0,
64,76,128,71,0,73,83,13,54,136,70,4,0,64,67,128,77,0,73,80,21,32,73,68,
7,12,128,83,0,64,67,128,85,0,64,73,128,77,0,72,79,6,128,77,0,64,78,128,
77,0,64,82,136,74,4,0,128,73,0,73,85,13,22,136,71,4,0,64,67,128,68,0,64,
84,136,83,4,0,128,73,0,64,87,128,86,0,72,70,134,137,74,5,65,0,201,68,14,
37,0,72,83,6,128,83,0,128,82,0,73,66,9,20,64,72,128,68,0,64,65,136,83,4,
0,64,73,128,84,0,128,67,0,73,72,9,18,64,83,128,77,0,64,69,136,83,4,0,128,
72,0,64,73,128,68,0,73,84,9,52,64,66,128,65,0,73,77,9,14,64,69,128,65,0,
64,76,128,80,0,64,83,73,77,13,20,64,83,64,72,64,83,128,77,0,136,71,4,0,
128,65,0,136,83,4,0,128,82,0,200,87,11,0,64,77,64,65,128,67,0,128,85,0,
64,69,73,78,7,112,128,82,0,73,70,9,58,64,82,128,65,0,73,67,7,42,128,84,
0,72,66,20,72,85,14,64,71,64,68,64,73,64,65,128,71,0,128,81,0,64,65,72,
71,8,64,76,128,69,0,64,69,128,84,0,64,69,64,87,128,82,0,73,76,17,42,64,
65,72,82,8,64,85,128,69,0,128,67,0,72,75,12,64,82,64,65,64,70,128,84,0,
64,73,72,83,6,128,65,0,64,65,128,82,0,64,77,128,70,0,73,84,21,59,73,73,
7,10,128,67,0,128,67,0,64,75,64,73,128,66,0,137,81,5,23,0,200,80,13,0,72,
69,6,128,68,0,128,66,0,64,79,128,76,0,64,83,137,88,5,10,0,64,80,128,84,
0,128,89,0,73,87,7,52,128,65,0,64,86,73,70,7,28,128,83,0,72,69,16,64,88,
64,80,64,82,64,69,64,83,128,83,0,64,65,128,87,0,64,84,64,79,64,79,64,76,
64,66,64,65,128,82,0,64,88,128,65,0,74,74,28,1,120,73,84,7,18,128,65,0,
72,83,6,128,73,0,64,73,128,65,0,64,85,128,65,0,80,73,1,4,73,77,33,153,137,
77,5,18,0,72,73,6,128,65,0,64,72,64,82,128,83,0,72,86,6,128,65,0,64,82,
128,83,0,73,70,23,79,72,70,16,72,83,10,64,69,64,82,128,86,0,128,65,0,128,
67,0,73,67,16,47,72,79,6,128,77,0,192,69,0,128,67,0,72,66,18,72,69,8,64,
76,128,83,0,64,67,64,73,128,80,0,64,65,72,83,8,64,69,128,82,0,128,67,0,
64,68,64,77,64,67,128,65,0,73,73,9,36,64,83,128,82,0,72,72,16,137,82,5,
8,0,128,70,0,64,84,128,65,0,64,71,64,73,64,77,64,79,128,78,0,64,76,128,
71,0,73,85,7,84,128,83,0,73,83,35,66,137,77,5,20,0,73,69,9,12,64,81,128,
67,0,128,65,0,128,73,0,72,80,8,64,69,128,90,0,128,78,0,72,82,22,72,69,12,
64,67,64,84,64,84,128,86,0,64,67,64,79,128,77,0,64,80,64,73,64,70,128,82,
0,64,84,136,89,4,0,64,69,128,71,0,73,87,11,16,136,79,4,0,128,65,0,64,86,
128,83,0,128,89,0,64,72,73,81,7,55,128,80,0,201,69,12,31,0,136,88,4,0,128,
84,0,73,66,7,14,128,84,0,64,65,64,65,128,68,0,64,67,128,80,0,72,80,12,136,
83,4,0,64,76,128,67,0,64,72,128,83,0,201,84,10,22,0,64,77,128,76,0,200,
83,9,0,64,77,128,86,0,128,82,0,136,88,4,0,64,87,128,71,0,200,76,118,0,137,
79,5,66,0,73,72,13,36,72,87,6,128,67,0,128,80,0,73,67,13,20,72,77,6,128,
73,0,128,73,0,64,66,64,67,128,76,0,128,69,0,137,76,5,20,0,64,73,72,78,6,
128,75,0,64,70,64,76,128,67,0,64,78,128,65,0,73,84,11,33,136,83,4,0,128,
73,0,201,81,8,13,0,128,73,0,64,80,128,73,0,64,83,136,87,4,0,128,85,0,73,
86,7,12,128,65,0,64,85,128,82,0,128,90,0,64,75,73,78,11,22,136,89,4,0,128,
70,0,72,77,6,128,83,0,64,73,128,77,0,64,85,64,72,128,68,0,82,83,1,6,3,106,
73,76,17,128,137,82,5,10,0,64,65,128,77,0,128,90,0,73,69,21,79,137,75,5,
14,0,136,69,4,0,64,65,128,82,0,128,79,0,73,67,15,42,137,80,5,8,0,128,65,
0,128,84,0,72,66,16,73,71,7,10,128,65,0,128,66,0,128,77,0,64,65,136,80,
4,0,64,69,128,75,0,192,68,0,73,78,7,10,128,65,0,128,77,0,128,83,0,73,73,
9,27,64,67,128,83,0,72,72,8,64,69,128,65,0,192,71,0,136,88,4,0,128,69,0,
64,75,128,69,0,73,82,36,87,137,77,5,23,0,72,69,12,64,80,64,65,64,73,128,
82,0,192,67,0,128,84,0,136,86,4,0,64,78,128,65,0,73,79,17,43,136,80,4,0,
64,70,64,73,64,76,128,69,0,200,78,7,0,128,71,0,64,77,73,73,7,14,128,84,
0,136,69,4,0,128,66,0,128,76,0,192,80,0,64,67,128,65,0,73,86,7,36,128,68,
0,200,84,15,0,137,75,5,8,0,128,67,0,128,77,0,64,83,200,83,7,0,128,76,0,
64,67,128,73,0,64,87,128,68,0,74,80,162,1,175,73,78,13,82,72,83,6,128,83,
0,128,77,0,201,73,14,44,0,136,86,4,0,64,67,128,77,0,73,68,7,24,128,84,0,
72,66,6,128,79,0,64,65,72,80,6,128,73,0,128,77,0,192,70,0,128,69,0,73,76,
7,12,128,76,0,64,74,128,90,0,64,77,137,76,5,8,0,128,73,0,128,83,0,73,83,
25,52,137,75,5,14,0,136,70,4,0,64,69,128,65,0,136,84,4,0,128,83,0,73,80,
9,18,64,69,128,74,0,64,79,136,70,4,0,128,67,0,64,82,136,76,4,0,128,75,0,
73,85,7,14,128,71,0,64,84,64,73,128,80,0,64,87,136,78,4,0,128,72,0,72,79,
182,137,74,5,114,0,137,69,5,86,0,73,67,35,48,73,80,13,24,64,82,64,73,64,
78,128,84,0,72,75,8,64,73,128,84,0,128,71,0,64,83,64,73,128,83,0,64,65,
137,80,5,8,0,128,74,0,128,88,0,192,68,0,73,73,9,22,64,83,128,83,0,72,68,
6,128,83,0,64,65,64,65,128,67,0,192,83,0,64,83,128,80,0,73,71,13,16,136,
86,4,0,64,73,128,84,0,128,70,0,64,73,64,84,128,84,0,73,79,13,44,72,77,6,
128,68,0,128,72,0,73,77,7,18,128,83,0,64,76,72,73,6,128,82,0,128,69,0,64,
78,64,78,136,85,4,0,64,84,128,85,0,72,86,8,64,66,128,83,0,64,84,137,67,
5,8,0,128,65,0,128,87,0,192,78,0,73,76,7,44,128,67,0,73,70,9,24,64,83,128,
66,0,72,68,6,128,73,0,64,65,136,84,4,0,128,83,0,64,73,137,69,5,8,0,128,
67,0,128,83,0,73,84,7,35,128,85,0,200,83,17,0,137,69,5,10,0,64,67,128,80,
0,128,79,0,64,79,136,80,4,0,64,67,128,83,0,64,85,128,71,0,72,82,150,73,
75,11,93,136,87,4,0,128,66,0,73,68,15,54,137,77,5,8,0,128,65,0,128,79,0,
73,66,23,34,73,70,7,16,128,77,0,72,69,6,128,77,0,128,68,0,128,71,0,64,65,
72,82,6,128,80,0,128,77,0,64,67,128,86,0,73,70,13,22,136,77,4,0,64,69,128,
71,0,64,69,64,73,64,79,128,82,0,192,73,0,128,73,0,73,79,7,28,128,68,0,137,
77,5,8,0,128,76,0,64,78,72,79,8,64,78,128,65,0,128,68,0,73,83,7,16,128,
90,0,64,80,136,72,4,0,128,68,0,64,87,64,69,192,66,0,128,68,0,64,81,73,76,
7,18,128,73,0,72,68,6,128,66,0,64,65,128,70,0,72,80,8,64,83,128,75,0,128,
77,0,202,86,70,1,29,0,73,77,13,51,136,84,4,0,64,82,128,80,0,73,70,7,33,
128,83,0,72,68,10,64,83,64,67,128,82,0,192,66,0,72,73,10,136,68,4,0,128,
67,0,128,69,0,64,76,128,65,0,73,79,7,10,128,77,0,128,78,0,128,82,0,72,85,
85,73,77,19,54,72,69,10,64,84,64,69,128,82,0,64,66,128,79,0,137,73,5,22,
0,136,67,4,0,64,66,72,84,6,128,86,0,64,69,128,65,0,72,76,6,128,68,0,64,
75,64,80,128,84,0,73,83,9,25,64,67,128,67,0,72,80,10,136,85,4,0,128,68,
0,192,78,0,128,83,0,128,84,0,64,84,73,76,7,65,128,83,0,201,69,8,38,0,128,
68,0,201,67,16,27,0,137,67,5,8,0,128,66,0,128,80,0,64,65,72,67,6,128,75,
0,128,65,0,128,68,0,137,72,5,10,0,64,70,128,84,0,192,73,0,136,77,4,0,128,
67,0,201,82,12,47,0,136,84,4,0,128,65,0,73,79,11,20,64,79,64,76,128,83,
0,64,77,136,76,4,0,128,70,0,64,80,72,82,6,128,79,0,64,77,64,80,128,65,0,
201,86,10,13,0,64,83,128,80,0,128,83,0,128,89,0,72,89,18,72,87,6,128,75,
0,64,79,136,84,4,0,128,77,0,64,87,73,79,7,35,128,77,0,201,70,8,19,0,128,
81,0,72,68,6,128,77,0,64,65,128,70,0,136,77,4,0,64,73,128,77,0,73,83,9,
24,64,82,128,70,0,200,82,9,0,64,69,128,68,0,192,80,0,128,73,0,64,84,137,
83,5,8,0,128,67,0,128,84,0,82,66,10,75,30,249,74,77,125,5,249,73,78,7,65,
128,72,0,73,72,7,36,128,82,0,73,68,7,22,128,79,0,72,66,10,136,73,4,0,128,
69,0,64,65,128,87,0,64,69,64,87,128,83,0,137,74,5,17,0,192,73,0,136,84,
4,0,64,67,128,72,0,64,75,128,71,0,73,84,7,27,128,72,0,201,82,10,13,0,64,
67,128,76,0,128,80,0,64,83,64,84,128,85,0,201,87,20,25,0,137,71,5,12,0,
64,67,64,67,128,65,0,128,85,0,64,85,128,70,0,128,89,0,74,71,66,3,217,73,
70,9,33,64,79,128,80,0,73,67,7,19,128,65,0,72,66,6,128,77,0,192,65,0,128,
78,0,64,69,128,65,0,201,80,8,23,0,128,65,0,72,77,12,136,80,4,0,64,69,128,
65,0,128,76,0,64,83,128,85,0,74,68,63,2,131,73,80,7,42,128,65,0,73,77,17,
26,137,77,5,10,0,64,76,128,82,0,128,86,0,72,73,6,128,84,0,128,69,0,64,78,
136,83,4,0,128,70,0,201,85,8,11,0,128,70,0,128,83,0,64,86,128,66,0,74,66,
108,1,174,137,74,5,57,0,73,70,7,33,128,67,0,200,67,11,0,136,83,4,0,128,
71,0,64,66,137,79,5,10,0,64,69,128,69,0,128,83,0,72,73,16,64,65,137,77,
5,8,0,128,72,0,128,83,0,128,72,0,137,85,5,35,0,200,83,21,0,137,79,5,12,
0,136,77,4,0,128,73,0,64,82,128,67,0,64,80,136,71,4,0,128,65,0,72,87,6,
128,67,0,64,86,128,65,0,64,65,73,79,11,158,136,82,4,0,128,67,0,73,70,21,
100,137,83,5,12,0,64,73,64,67,128,73,0,64,84,128,65,0,73,67,23,72,73,83,
7,16,128,65,0,136,80,4,0,64,69,128,69,0,128,84,0,72,66,34,73,79,7,22,128,
75,0,136,77,4,0,64,73,136,80,4,0,64,67,128,77,0,72,87,6,128,79,0,128,84,
0,64,65,72,81,8,64,77,128,68,0,64,80,128,83,0,64,69,64,82,128,83,0,73,77,
21,38,137,83,5,14,0,136,78,4,0,64,66,128,76,0,128,90,0,72,76,10,64,80,64,
69,128,88,0,64,71,64,69,128,86,0,64,78,64,69,64,83,128,69,0,73,85,13,139,
64,68,64,67,64,79,128,78,0,201,83,46,101,0,137,72,5,28,0,73,69,11,18,64,
69,64,70,128,65,0,64,68,64,65,128,73,0,64,70,128,73,0,72,77,6,128,76,0,
64,73,64,67,128,80,0,72,82,24,137,84,5,14,0,64,82,64,78,64,69,128,84,0,
64,87,64,65,128,78,0,64,80,137,73,5,16,0,136,69,4,0,64,67,64,80,128,65,
0,72,80,6,128,73,0,64,77,64,65,128,70,0,64,84,73,78,9,14,64,65,128,83,0,
64,70,128,69,0,64,84,64,69,64,83,128,84,0,73,87,9,14,64,83,128,73,0,64,
86,128,67,0,64,90,64,78,64,65,128,83,0,64,67,201,76,14,87,0,136,79,4,0,
64,65,128,68,0,73,68,7,46,128,87,0,73,66,13,24,72,83,6,128,65,0,128,71,
0,64,65,72,84,6,128,65,0,128,65,0,64,67,137,73,5,8,0,128,72,0,64,76,128,
65,0,137,71,5,18,0,64,69,137,73,5,8,0,128,65,0,128,76,0,64,73,136,84,4,
0,128,77,0,73,80,13,32,72,87,6,128,65,0,128,76,0,73,78,7,14,128,76,0,64,
77,64,83,128,78,0,64,79,128,66,0,73,84,7,20,128,73,0,64,82,72,69,6,128,
65,0,64,65,128,78,0,64,87,136,83,4,0,128,80,0,200,70,124,0,73,72,7,63,128,
73,0,73,69,11,39,64,71,64,84,128,66,0,73,66,7,12,128,83,0,64,65,128,82,
0,192,67,0,137,80,5,10,0,64,69,128,67,0,128,82,0,200,71,11,0,136,83,4,0,
128,70,0,192,70,0,128,77,0,73,79,15,34,137,80,5,8,0,128,69,0,128,81,0,73,
77,11,14,136,86,4,0,128,69,0,128,73,0,64,78,128,84,0,72,84,12,64,71,64,
70,64,79,128,80,0,64,83,72,83,6,128,86,0,128,76,0,64,69,73,76,23,80,72,
76,12,64,67,64,79,64,82,128,69,0,64,73,64,80,128,79,0,73,71,11,36,64,73,
64,67,128,67,0,73,69,9,20,64,80,128,83,0,64,67,72,84,6,128,65,0,128,78,
0,64,70,128,85,0,72,73,8,64,68,128,83,0,64,72,64,79,64,76,64,68,64,84,128,
86,0,73,83,19,59,73,82,7,10,128,65,0,128,77,0,64,85,128,71,0,73,80,21,28,
72,90,6,128,65,0,64,82,64,69,64,77,64,73,128,88,0,64,77,64,73,128,80,0,
192,82,0,72,84,6,128,76,0,128,82,0,72,88,8,64,67,128,79,0,128,86,0,74,74,
36,1,41,73,71,7,20,128,65,0,73,67,7,10,128,80,0,128,65,0,128,68,0,137,80,
5,8,0,128,74,0,128,84,0,200,73,223,0,201,77,10,100,0,64,67,128,79,0,73,
69,7,52,128,67,0,73,67,19,38,72,83,10,136,73,4,0,128,65,0,64,82,128,65,
0,64,65,73,84,7,12,128,83,0,64,76,128,76,0,64,90,128,65,0,64,68,64,77,128,
67,0,73,71,11,27,64,83,64,83,128,83,0,64,70,201,83,8,11,0,128,65,0,128,
65,0,128,89,0,64,73,136,80,4,0,64,67,128,76,0,73,82,15,67,136,84,4,0,64,
67,64,87,128,72,0,73,79,27,47,136,83,4,0,64,68,64,73,64,86,64,69,64,82,
64,83,64,73,64,84,128,89,0,64,78,137,68,5,10,0,64,65,128,67,0,192,76,0,
64,79,128,71,0,64,80,128,77,0,73,84,21,41,73,78,9,14,64,69,128,84,0,64,
69,128,67,0,128,83,0,64,83,137,74,5,15,0,200,68,7,0,128,78,0,128,67,0,128,
84,0,64,88,64,69,64,78,64,79,128,78,0,64,72,73,80,7,25,128,72,0,73,76,7,
12,128,72,0,64,65,128,71,0,192,79,0,128,80,0,72,83,8,64,69,128,79,0,128,
82,0,72,76,101,73,73,11,66,136,88,4,0,128,83,0,73,69,11,38,136,82,4,0,128,
67,0,73,66,7,18,128,86,0,64,65,136,83,4,0,64,67,128,83,0,64,67,136,85,4,
0,128,82,0,72,71,6,128,80,0,64,70,136,83,4,0,64,65,128,81,0,73,79,7,19,
128,66,0,200,77,7,0,128,67,0,64,76,128,66,0,72,86,8,64,68,128,83,0,64,83,
128,82,0,64,75,73,75,9,14,64,66,128,78,0,64,70,128,75,0,64,80,128,77,0,
74,85,56,3,162,73,69,7,26,128,84,0,73,66,7,16,128,65,0,64,65,136,86,4,0,
128,80,0,128,67,0,73,76,11,16,64,65,64,84,128,83,0,64,73,128,83,0,64,77,
136,78,4,0,128,68,0,74,82,142,2,43,73,78,7,96,128,65,0,73,70,15,62,72,83,
6,128,83,0,64,70,128,82,0,73,68,7,28,128,70,0,64,65,137,67,5,10,0,64,65,
128,67,0,64,86,64,79,64,84,128,86,0,64,69,73,73,7,14,128,78,0,64,69,64,
65,128,77,0,128,87,0,201,73,13,18,0,192,67,0,64,85,128,80,0,64,71,128,78,
0,64,77,136,83,4,0,128,67,0,73,84,7,32,128,73,0,137,80,5,16,0,64,79,64,
78,64,67,64,85,128,83,0,64,82,136,80,4,0,128,78,0,136,87,4,0,64,85,128,
70,0,74,79,225,1,42,73,76,23,126,136,82,4,0,64,76,64,70,64,73,64,76,64,
84,64,69,128,82,0,73,70,21,66,73,73,7,14,128,84,0,136,72,4,0,128,65,0,128,
84,0,73,68,13,38,72,84,6,128,70,0,128,67,0,72,67,20,73,76,7,12,128,69,0,
64,69,128,83,0,64,89,128,76,0,64,65,128,67,0,64,69,64,80,128,68,0,73,73,
9,34,64,78,128,67,0,72,72,10,64,73,64,67,128,65,0,64,71,73,79,7,10,128,
70,0,128,76,0,128,84,0,128,74,0,73,82,9,49,64,68,128,67,0,73,79,9,20,64,
84,128,80,0,72,78,6,128,89,0,64,77,128,65,0,64,80,201,83,8,11,0,128,89,
0,128,68,0,64,84,64,69,128,71,0,137,86,5,40,0,72,84,18,73,79,7,12,128,88,
0,64,68,128,70,0,128,89,0,64,83,72,84,8,64,73,128,68,0,64,73,64,69,128,
84,0,64,87,128,87,0,64,78,73,79,9,42,64,66,128,67,0,137,70,5,18,0,72,69,
6,128,80,0,64,68,64,69,128,83,0,72,73,6,128,66,0,64,72,136,83,4,0,128,73,
0,137,85,5,20,0,72,83,10,136,70,4,0,128,67,0,64,80,128,80,0,136,89,4,0,
64,87,128,84,0,192,80,0,201,77,12,55,0,136,78,4,0,128,76,0,73,69,7,24,128,
76,0,137,67,5,12,0,64,65,64,65,128,83,0,64,68,128,85,0,73,73,11,14,136,
79,4,0,128,65,0,128,72,0,64,76,128,82,0,73,83,7,36,128,75,0,73,80,13,23,
136,86,4,0,64,66,128,77,0,192,79,0,136,83,4,0,128,78,0,192,82,0,128,83,
0,73,85,11,16,64,80,64,75,128,73,0,64,84,128,73,0,64,86,128,67,0,200,84,
97,0,201,77,8,62,0,128,85,0,73,70,7,34,128,69,0,73,66,9,14,64,65,128,77,
0,64,65,128,65,0,64,67,137,83,5,8,0,128,67,0,128,86,0,200,76,11,0,136,90,
4,0,128,83,0,64,71,64,70,64,79,128,80,0,73,83,7,20,128,65,0,136,79,4,0,
64,78,136,83,4,0,128,72,0,72,86,6,128,83,0,64,84,128,66,0,64,83,73,75,9,
127,64,89,128,66,0,73,69,10,81,192,67,0,128,79,0,201,67,34,61,0,137,73,
5,20,0,73,67,7,12,128,79,0,64,65,128,73,0,128,72,0,136,82,4,0,64,79,128,
76,0,72,66,12,136,68,4,0,64,67,128,67,0,64,65,137,77,5,8,0,128,65,0,64,
86,128,65,0,192,68,0,136,76,4,0,128,70,0,73,71,7,12,128,86,0,64,70,128,
70,0,64,73,73,72,11,18,64,79,64,82,128,76,0,136,71,4,0,128,67,0,64,77,128,
77,0,73,82,16,43,72,85,6,128,78,0,192,73,0,128,65,0,73,79,7,18,128,68,0,
64,77,72,84,6,128,80,0,128,69,0,64,80,136,73,4,0,128,67,0,73,84,24,45,73,
70,9,15,64,65,128,68,0,192,68,0,128,66,0,64,85,128,78,0,64,83,137,82,5,
14,0,136,72,4,0,64,70,128,80,0,64,83,128,67,0,64,85,128,78,0,73,88,9,116,
64,77,128,83,0,72,87,32,137,82,5,18,0,73,69,7,10,128,65,0,128,65,0,128,
79,0,72,84,6,128,67,0,64,83,128,76,0,64,86,73,77,7,32,128,83,0,73,68,7,
18,128,86,0,72,67,6,128,80,0,64,66,128,65,0,136,73,4,0,128,72,0,73,81,7,
24,128,73,0,72,80,12,136,90,4,0,64,69,128,70,0,64,79,128,86,0,72,83,8,64,
80,128,82,0,64,82,64,65,64,65,128,77,0,72,90,10,64,70,64,79,128,83,0,64,
89,73,83,9,36,64,72,128,82,0,72,79,22,137,76,5,14,0,136,67,4,0,64,66,128,
87,0,64,78,128,68,0,64,67,128,82,0,192,85,0,128,84,0,64,65,74,78,231,12,
149,73,80,15,137,136,82,4,0,64,65,64,67,128,84,0,73,69,9,81,64,69,128,76,
0,73,66,9,29,64,80,128,82,0,192,65,0,137,79,5,10,0,64,65,128,67,0,64,84,
64,69,128,76,0,64,67,137,80,5,30,0,73,76,7,18,128,65,0,64,65,136,80,4,0,
64,70,128,69,0,64,79,64,86,128,65,0,72,89,6,128,76,0,64,83,128,65,0,73,
78,19,28,72,80,8,64,84,128,82,0,64,70,64,83,128,85,0,64,76,64,80,64,65,
128,82,0,64,79,72,86,6,128,65,0,64,83,128,82,0,73,85,11,58,64,73,64,69,
128,83,0,73,83,21,28,137,73,5,14,0,136,70,4,0,64,69,128,70,0,128,80,0,64,
82,64,80,128,67,0,64,84,137,77,5,14,0,64,65,136,77,4,0,128,68,0,128,84,
0,73,87,7,16,128,82,0,64,86,64,73,64,83,128,65,0,64,90,72,85,6,128,83,0,
64,83,64,80,128,77,0,74,71,124,7,228,137,76,5,67,0,73,68,7,33,128,83,0,
73,66,7,18,128,85,0,64,65,64,84,64,69,64,78,128,89,0,192,67,0,64,65,128,
83,0,73,70,7,24,128,73,0,64,69,64,83,73,67,7,10,128,73,0,128,65,0,128,84,
0,64,73,128,70,0,73,82,7,35,128,73,0,73,79,7,14,128,65,0,64,77,64,82,128,
67,0,192,80,0,137,77,5,8,0,128,76,0,128,83,0,136,87,4,0,64,84,137,66,5,
8,0,128,65,0,128,72,0,82,68,1,85,5,152,73,77,15,203,137,84,5,8,0,128,83,
0,128,85,0,201,70,14,129,0,136,83,4,0,64,69,128,67,0,201,67,64,89,0,137,
81,5,29,0,73,73,9,14,64,83,128,67,0,64,67,128,80,0,192,80,0,64,83,64,83,
128,73,0,72,83,22,137,82,5,10,0,64,65,128,67,0,64,83,64,80,64,82,128,73,
0,192,82,0,64,73,128,83,0,136,66,4,0,64,65,137,71,5,16,0,72,67,6,128,72,
0,64,65,128,71,0,128,87,0,72,69,14,72,83,6,128,70,0,64,65,128,82,0,192,
68,0,136,77,4,0,64,65,128,81,0,73,74,7,48,128,76,0,72,73,36,137,72,5,18,
0,73,69,7,10,128,67,0,128,65,0,128,70,0,72,82,10,136,85,4,0,128,83,0,64,
77,128,83,0,64,72,128,68,0,64,76,136,77,4,0,64,68,128,83,0,73,84,7,101,
128,82,0,73,80,21,59,73,75,7,12,128,68,0,64,67,128,77,0,64,76,128,76,0,
200,79,21,0,73,68,7,12,128,67,0,64,67,128,69,0,64,83,128,72,0,64,78,137,
72,5,10,0,64,69,128,67,0,64,79,128,67,0,72,83,14,137,76,5,8,0,128,73,0,
128,77,0,64,82,73,77,7,16,128,83,0,136,75,4,0,64,72,128,65,0,128,84,0,73,
87,13,26,136,83,4,0,64,69,128,65,0,72,86,8,64,70,128,83,0,64,85,128,67,
0,64,90,128,85,0,74,66,178,2,134,73,75,7,95,128,67,0,73,69,25,53,73,83,
7,18,128,84,0,72,76,6,128,76,0,64,68,128,65,0,128,84,0,73,67,7,22,128,80,
0,72,66,8,64,78,128,82,0,64,65,64,82,128,69,0,192,68,0,128,67,0,73,73,23,
30,73,76,9,14,64,76,128,83,0,64,73,128,84,0,64,83,128,83,0,64,70,64,83,
128,85,0,64,74,128,68,0,201,83,18,57,0,136,75,4,0,64,73,136,83,4,0,128,
80,0,73,80,13,24,136,71,4,0,64,66,128,72,0,72,78,6,128,70,0,64,77,128,83,
0,64,82,72,83,6,128,77,0,64,67,64,77,128,83,0,73,86,7,12,128,65,0,64,84,
128,65,0,64,87,136,82,4,0,128,72,0,64,65,74,77,28,1,22,137,67,5,14,0,136,
66,4,0,64,65,128,83,0,136,83,4,0,64,79,128,70,0,73,71,21,171,137,78,5,10,
0,64,65,128,68,0,64,80,64,66,128,76,0,73,68,15,120,72,77,6,128,79,0,64,
65,128,86,0,200,67,49,0,201,82,10,29,0,64,65,128,79,0,73,67,9,14,64,85,
128,80,0,64,65,128,80,0,64,79,128,77,0,72,84,6,128,69,0,192,83,0,136,82,
4,0,128,66,0,64,65,73,76,9,36,64,65,128,67,0,137,69,5,16,0,136,67,4,0,64,
65,64,83,128,70,0,64,73,72,70,6,128,73,0,128,68,0,73,82,9,12,64,71,128,
72,0,128,78,0,192,83,0,128,83,0,64,70,201,80,10,25,0,64,82,128,83,0,72,
69,6,128,83,0,64,67,136,83,4,0,128,79,0,128,85,0,73,75,15,56,72,83,8,64,
73,128,83,0,128,71,0,72,73,16,73,70,7,10,128,70,0,128,66,0,128,77,0,64,
72,73,79,7,14,128,65,0,136,69,4,0,128,65,0,136,85,4,0,64,83,128,65,0,64,
76,73,73,9,14,64,69,128,78,0,64,65,128,83,0,64,84,64,67,128,73,0,73,83,
31,139,73,72,13,18,72,84,6,128,79,0,128,69,0,64,67,128,85,0,64,76,136,72,
4,0,128,68,0,73,80,40,71,201,77,8,17,0,128,76,0,136,71,4,0,64,69,128,88,
0,72,80,14,137,81,5,8,0,128,79,0,128,83,0,64,79,128,82,0,72,79,26,73,77,
7,20,128,82,0,72,73,8,64,70,128,73,0,64,72,128,78,0,128,83,0,64,78,128,
82,0,64,82,137,73,5,26,0,72,71,6,128,77,0,64,68,72,86,10,64,65,64,82,128,
67,0,128,65,0,72,84,6,128,79,0,128,80,0,73,85,11,28,136,87,4,0,128,73,0,
64,84,73,83,7,12,128,82,0,64,67,128,66,0,128,87,0,64,86,73,77,7,10,128,
65,0,128,69,0,64,83,136,79,4,0,128,66,0,192,67,0,73,77,29,239,73,73,7,14,
128,83,0,136,68,4,0,128,65,0,72,77,8,64,65,128,88,0,128,76,0,73,70,27,136,
73,84,11,20,136,85,4,0,128,65,0,72,73,6,128,67,0,128,69,0,128,87,0,73,67,
53,80,73,79,13,32,64,66,64,65,64,77,128,83,0,73,74,7,14,128,67,0,136,67,
4,0,128,65,0,64,77,128,69,0,73,83,7,12,128,72,0,64,82,128,67,0,64,84,128,
73,0,72,66,12,72,83,6,128,80,0,128,77,0,64,65,73,74,7,10,128,69,0,128,66,
0,128,80,0,72,69,24,137,80,5,16,0,64,76,136,83,4,0,64,65,128,66,0,64,86,
128,79,0,64,68,128,82,0,73,73,29,52,73,78,11,22,64,84,64,69,128,78,0,72,
67,6,128,83,0,64,65,128,82,0,128,80,0,136,72,4,0,64,71,73,77,7,12,128,69,
0,64,73,128,72,0,64,82,128,67,0,200,76,19,0,137,83,5,12,0,136,74,4,0,128,
69,0,128,85,0,128,74,0,73,84,27,155,73,70,7,14,128,76,0,136,68,4,0,128,
65,0,72,87,6,128,85,0,128,71,0,73,80,17,58,137,73,5,10,0,64,69,128,84,0,
128,79,0,72,79,22,73,82,7,12,128,69,0,64,80,128,83,0,64,83,64,79,128,71,
0,64,78,137,83,5,10,0,64,73,128,83,0,64,85,64,68,128,72,0,72,83,37,137,
73,5,18,0,73,69,7,10,128,67,0,128,65,0,128,72,0,137,77,5,10,0,64,76,128,
83,0,192,82,0,128,84,0,64,82,73,79,13,26,64,82,64,69,64,65,128,68,0,136,
76,4,0,192,73,0,192,83,0,128,83,0,64,87,128,67,0,73,87,11,41,136,80,4,0,
128,73,0,72,86,8,64,73,128,77,0,192,85,0,73,76,7,12,128,65,0,64,67,128,
65,0,64,80,64,67,128,67,0,64,89,64,80,128,76,0,80,70,1,69,73,77,15,176,
72,83,6,128,65,0,64,79,128,65,0,73,70,33,124,137,79,5,16,0,137,67,5,8,0,
128,65,0,128,70,0,137,83,5,8,0,128,80,0,64,84,128,67,0,73,68,11,80,136,
67,4,0,128,66,0,72,67,30,73,69,15,22,72,83,6,128,65,0,64,82,128,84,0,64,
65,64,82,128,83,0,64,79,128,77,0,64,65,73,80,7,22,128,73,0,73,73,7,12,128,
75,0,64,65,128,68,0,128,79,0,72,84,8,64,68,128,83,0,64,82,64,84,128,69,
0,64,69,136,87,4,0,64,83,128,68,0,201,73,20,32,0,137,83,5,10,0,64,80,128,
83,0,64,84,128,65,0,192,72,0,136,85,4,0,64,83,128,83,0,64,76,128,80,0,73,
83,43,109,73,79,7,28,128,67,0,137,72,5,16,0,64,67,72,77,6,128,69,0,128,
65,0,64,77,128,73,0,72,83,6,128,65,0,64,80,128,65,0,73,80,9,44,64,70,128,
76,0,72,79,28,73,82,9,16,64,69,128,88,0,136,77,4,0,128,76,0,64,83,136,82,
4,0,128,73,0,64,78,64,79,128,82,0,192,82,0,137,76,5,14,0,64,73,64,78,64,
73,128,67,0,64,82,128,73,0,73,85,13,31,136,69,4,0,64,68,128,67,0,64,84,
137,78,5,11,0,192,65,0,128,76,0,64,82,128,65,0,64,86,128,65,0,64,69,73,
74,9,82,64,77,128,67,0,73,70,11,50,64,83,64,68,128,82,0,73,67,17,32,73,
82,7,10,128,85,0,128,76,0,128,84,0,72,66,8,64,80,128,82,0,64,65,64,82,128,
85,0,64,68,64,80,128,65,0,73,72,11,18,136,73,4,0,128,70,0,64,71,64,69,128,
69,0,64,73,128,76,0,73,80,11,40,64,76,64,65,128,67,0,73,77,9,24,64,69,128,
84,0,72,76,6,128,70,0,64,75,64,77,64,65,128,80,0,64,78,128,65,0,137,83,
5,10,0,64,82,128,65,0,64,84,128,78,0,74,75,40,2,92,73,70,13,22,136,71,4,
0,64,69,128,68,0,72,68,6,128,78,0,128,67,0,72,79,6,128,79,0,64,77,64,69,
128,75,0,82,73,1,78,1,251,137,75,5,194,0,73,69,19,120,73,80,7,10,128,82,
0,128,69,0,64,83,128,68,0,73,67,39,76,73,80,7,26,128,65,0,72,72,10,136,
82,4,0,128,69,0,64,65,64,67,64,89,128,80,0,72,84,6,128,69,0,128,82,0,72,
66,12,64,69,136,80,4,0,128,67,0,64,65,137,71,5,14,0,72,67,6,128,82,0,128,
65,0,64,84,64,83,64,73,128,83,0,64,68,137,83,5,18,0,136,71,4,0,64,69,64,
83,64,69,128,80,0,64,87,128,65,0,73,72,23,61,73,82,7,16,128,67,0,136,77,
4,0,64,69,128,67,0,128,87,0,200,71,20,0,73,76,7,13,128,88,0,192,65,0,128,
67,0,128,80,0,64,70,73,76,7,13,128,68,0,192,70,0,128,85,0,128,77,0,64,73,
192,77,0,128,83,0,201,82,10,101,0,64,67,128,67,0,73,79,22,74,137,71,5,15,
0,192,67,0,136,80,4,0,128,68,0,128,85,0,200,77,43,0,201,80,12,30,0,136,
82,4,0,128,70,0,137,76,5,11,0,192,68,0,128,77,0,64,77,64,80,128,69,0,72,
87,6,128,65,0,128,82,0,64,76,136,68,4,0,128,65,0,64,80,137,67,5,10,0,64,
65,128,67,0,64,69,128,83,0,73,84,13,26,72,85,6,128,67,0,128,68,0,64,83,
137,73,5,8,0,128,67,0,128,84,0,64,85,64,83,128,65,0,64,72,137,76,5,89,0,
73,69,19,61,73,76,7,10,128,79,0,128,67,0,64,82,128,65,0,73,67,22,35,137,
73,5,13,0,192,67,0,64,67,128,83,0,64,80,128,82,0,72,66,8,64,65,128,73,0,
64,65,128,77,0,64,68,64,82,128,65,0,73,73,13,20,136,80,4,0,64,77,128,65,
0,64,70,64,77,128,82,0,128,74,0,73,83,9,56,64,71,128,69,0,73,80,11,24,64,
67,64,82,128,67,0,72,79,6,128,78,0,64,77,64,65,128,67,0,64,82,137,80,5,
14,0,136,78,4,0,64,77,128,65,0,136,83,4,0,128,81,0,201,85,10,21,0,64,82,
128,73,0,64,84,136,83,4,0,64,69,128,71,0,64,87,128,82,0,64,74,73,74,9,36,
64,68,128,67,0,73,67,7,22,128,67,0,64,65,73,84,7,10,128,84,0,128,67,0,128,
88,0,64,71,128,65,0,72,87,6,128,83,0,64,80,137,83,5,8,0,128,79,0,128,87,
0,72,77,196,73,79,29,129,73,82,7,20,128,67,0,72,76,8,64,69,128,68,0,64,
67,128,79,0,64,86,128,65,0,73,70,9,63,64,65,128,82,0,201,68,22,39,0,73,
73,9,14,64,83,128,65,0,64,65,128,76,0,128,75,0,72,67,12,136,67,4,0,64,65,
128,83,0,64,66,128,65,0,64,69,137,80,5,10,0,64,68,128,68,0,128,88,0,73,
76,9,28,64,67,128,68,0,64,73,73,68,7,14,128,69,0,64,66,64,67,128,80,0,128,
80,0,64,78,136,72,4,0,128,70,0,73,83,11,41,136,83,4,0,128,68,0,73,81,7,
14,128,80,0,64,80,64,65,128,83,0,192,82,0,72,69,6,128,70,0,64,65,64,65,
128,77,0,73,85,9,20,64,82,128,84,0,64,84,72,83,6,128,79,0,128,76,0,128,
86,0,64,76,201,77,14,93,0,136,83,4,0,64,68,128,83,0,73,69,11,46,64,67,64,
83,128,79,0,73,67,13,30,136,77,4,0,64,65,128,82,0,64,65,73,68,7,10,128,
73,0,128,67,0,64,82,128,65,0,64,68,128,67,0,73,72,17,20,72,84,6,128,75,
0,64,68,64,73,128,65,0,128,71,0,64,73,72,80,6,128,82,0,64,67,128,79,0,73,
83,29,53,73,69,7,18,128,80,0,72,67,8,64,79,128,78,0,128,65,0,64,80,64,65,
128,67,0,73,79,9,16,64,65,128,66,0,64,78,64,65,128,67,0,192,80,0,64,83,
128,80,0,200,85,7,0,128,65,0,64,84,73,67,7,10,128,83,0,128,66,0,128,77,
0,74,85,121,6,175,201,80,18,58,0,72,69,6,128,88,0,64,65,64,73,128,82,0,
73,77,7,31,128,70,0,73,67,7,18,128,65,0,64,66,72,67,6,128,68,0,128,65,0,
192,73,0,128,83,0,136,79,4,0,64,78,128,67,0,73,83,17,28,64,65,72,82,6,128,
84,0,64,73,128,68,0,72,82,6,128,80,0,64,81,128,65,0,200,86,9,0,64,83,128,
73,0,64,84,72,79,16,72,83,8,64,65,128,82,0,64,71,128,75,0,128,77,0,82,82,
1,20,3,195,73,78,7,150,128,71,0,73,69,37,102,73,73,7,20,128,77,0,72,68,
6,128,83,0,64,65,64,69,128,82,0,72,85,8,64,69,128,65,0,64,79,128,70,0,73,
67,29,54,73,83,9,22,64,72,128,83,0,72,72,8,64,80,128,82,0,64,67,128,73,
0,128,86,0,72,66,6,128,82,0,64,65,137,80,5,12,0,64,67,64,73,128,80,0,64,
84,128,83,0,64,68,136,83,4,0,64,77,128,83,0,73,75,9,26,64,69,128,83,0,72,
73,10,136,78,4,0,128,67,0,64,70,64,67,128,78,0,64,77,137,68,5,10,0,64,67,
128,73,0,128,77,0,73,84,21,99,73,67,7,12,128,67,0,64,66,128,65,0,64,70,
128,76,0,73,82,11,65,136,76,4,0,128,65,0,200,80,37,0,73,75,7,20,128,68,
0,137,67,5,8,0,128,65,0,64,68,128,68,0,137,82,5,10,0,64,80,128,85,0,128,
85,0,64,79,73,80,7,10,128,73,0,128,70,0,64,84,128,67,0,64,83,72,83,6,128,
67,0,64,70,128,69,0,73,86,11,16,136,79,4,0,128,73,0,64,85,128,71,0,64,87,
128,85,0,82,80,1,177,2,100,74,77,35,1,3,73,69,7,20,128,88,0,72,67,10,64,
72,64,85,128,68,0,128,65,0,200,80,7,0,128,65,0,128,76,0,73,70,31,141,73,
73,7,16,128,67,0,72,69,6,128,74,0,128,67,0,136,84,4,0,64,83,64,68,128,83,
0,201,67,26,55,0,137,82,5,16,0,136,79,4,0,64,67,64,65,128,83,0,64,83,128,
83,0,200,66,7,0,128,84,0,64,65,73,76,7,13,128,67,0,192,67,0,128,84,0,64,
77,64,83,128,65,0,72,69,26,73,73,7,16,128,68,0,136,67,4,0,64,65,128,76,
0,64,75,64,83,128,73,0,64,68,73,82,7,24,128,80,0,72,72,6,128,65,0,64,70,
136,82,4,0,64,80,128,82,0,128,85,0,73,74,9,64,64,73,128,73,0,200,73,30,
0,73,78,9,21,64,68,128,79,0,72,69,6,128,76,0,192,67,0,128,83,0,64,80,128,
65,0,64,72,73,73,7,16,128,83,0,72,69,6,128,68,0,128,65,0,136,79,4,0,128,
76,0,72,76,6,128,85,0,64,75,72,87,6,128,83,0,64,71,128,75,0,73,83,17,125,
137,76,5,10,0,64,73,128,83,0,128,87,0,73,80,36,70,137,78,5,29,0,72,77,6,
128,65,0,192,67,0,64,79,64,78,64,84,64,82,64,79,64,76,128,83,0,128,84,0,
72,79,16,137,68,5,10,0,64,66,128,83,0,128,78,0,192,78,0,73,73,7,10,128,
67,0,128,71,0,64,83,128,65,0,72,82,33,73,79,11,18,64,68,64,69,128,72,0,
136,77,4,0,128,67,0,136,85,4,0,192,83,0,64,65,128,70,0,64,81,128,80,0,73,
87,17,40,137,71,5,8,0,128,65,0,64,76,128,68,0,136,85,4,0,192,84,0,137,78,
5,10,0,64,77,128,65,0,192,84,0,128,80,0,128,89,0,64,79,73,80,15,91,137,
66,5,8,0,128,65,0,128,82,0,73,71,9,57,64,69,128,65,0,73,69,23,43,137,82,
5,16,0,72,80,6,128,82,0,64,68,128,82,0,128,83,0,72,68,14,137,82,5,8,0,128,
66,0,128,86,0,192,67,0,128,73,0,64,70,128,82,0,137,76,5,14,0,64,72,136,
82,4,0,128,79,0,64,78,128,66,0,73,84,15,59,137,80,5,8,0,128,65,0,128,83,
0,73,82,7,12,128,78,0,64,81,128,76,0,192,83,0,73,82,7,20,128,65,0,73,73,
7,10,128,83,0,128,68,0,128,80,0,72,84,6,128,72,0,128,83,0,73,87,7,18,128,
68,0,64,85,72,83,6,128,67,0,128,80,0,64,88,64,80,64,80,128,82,0,64,81,73,
82,7,49,128,77,0,201,76,8,20,0,128,81,0,72,73,6,128,83,0,192,72,0,128,65,
0,192,77,0,137,69,5,12,0,136,68,4,0,128,65,0,136,80,4,0,128,73,0,73,84,
11,18,136,83,4,0,128,70,0,64,83,64,73,128,81,0,192,87,0,128,65,0,72,84,
188,201,76,8,113,0,128,83,0,73,71,15,82,136,77,4,0,64,65,64,84,128,84,0,
73,69,17,58,72,83,8,64,69,128,65,0,64,69,128,76,0,72,67,22,137,69,5,12,
0,136,67,4,0,128,65,0,136,82,4,0,128,81,0,64,65,137,70,5,12,0,64,67,64,
77,128,83,0,64,80,128,73,0,64,70,136,77,4,0,128,67,0,73,73,13,18,72,84,
6,128,68,0,128,67,0,64,72,128,70,0,64,75,128,75,0,73,82,23,43,137,80,5,
14,0,136,68,4,0,64,65,128,67,0,64,82,128,83,0,73,79,7,13,128,84,0,192,77,
0,128,80,0,64,80,64,67,128,79,0,73,84,7,24,128,83,0,64,83,73,68,7,10,128,
82,0,128,67,0,64,73,128,67,0,64,87,128,84,0,64,83,74,77,27,1,4,201,69,8,
19,0,128,65,0,72,67,6,128,65,0,64,66,128,83,0,128,90,0,201,70,14,178,0,
136,86,4,0,64,73,128,83,0,73,67,57,137,73,71,9,28,64,69,128,78,0,137,68,
5,16,0,72,67,6,128,80,0,64,65,128,80,0,128,69,0,201,82,8,20,0,128,80,0,
200,79,7,0,128,66,0,64,73,128,73,0,64,83,128,65,0,72,66,39,137,79,5,23,
0,73,68,7,12,128,67,0,64,65,128,72,0,192,77,0,128,82,0,137,82,5,10,0,64,
80,128,69,0,128,85,0,64,65,73,73,9,20,64,72,128,76,0,72,68,6,128,69,0,64,
66,128,69,0,72,80,10,136,83,4,0,128,77,0,64,76,136,72,4,0,128,65,0,72,69,
16,137,69,5,10,0,64,65,128,78,0,128,77,0,64,68,136,77,4,0,64,65,128,72,
0,73,73,15,42,137,79,5,8,0,128,67,0,128,84,0,72,72,18,137,80,5,8,0,128,
73,0,64,82,64,65,128,69,0,64,71,64,73,64,83,128,65,0,72,76,6,128,82,0,64,
75,64,73,128,82,0,73,83,21,111,73,83,7,10,128,65,0,128,77,0,64,89,64,83,
128,84,0,73,80,39,58,73,82,7,24,128,83,0,137,73,5,10,0,64,67,128,65,0,64,
76,64,79,128,83,0,72,84,6,128,77,0,64,83,128,77,0,72,79,12,136,84,4,0,64,
78,128,80,0,64,78,64,65,128,80,0,72,82,22,137,83,5,16,0,136,77,4,0,64,65,
64,65,128,77,0,128,89,0,192,81,0,64,76,64,80,128,82,0,73,86,21,53,137,68,
5,10,0,64,65,128,66,0,64,79,64,70,128,70,0,72,85,12,136,71,4,0,64,65,128,
71,0,64,84,137,78,5,15,0,136,77,4,0,192,68,0,128,68,0,128,80,0,64,87,137,
77,5,8,0,128,70,0,128,80,0,74,89,51,1,71,73,69,7,31,128,83,0,73,66,13,18,
64,65,64,66,64,84,128,85,0,64,65,128,68,0,192,67,0,128,74,0,137,80,5,10,
0,64,79,128,82,0,64,83,128,79,0,74,87,136,1,13,137,77,5,72,0,73,69,7,39,
128,65,0,73,67,13,26,72,72,6,128,67,0,128,67,0,72,66,6,128,90,0,64,65,64,
67,128,83,0,192,68,0,128,80,0,73,73,11,23,136,77,4,0,128,68,0,200,71,7,
0,128,78,0,64,70,128,84,0,64,76,128,70,0,201,83,10,40,0,64,80,128,83,0,
73,80,7,24,128,82,0,72,79,14,72,84,6,128,69,0,64,77,128,79,0,128,78,0,192,
82,0,128,67,0,73,85,9,14,64,70,128,72,0,64,84,128,67,0,64,87,128,65,0,64,
86,73,77,7,61,128,65,0,73,71,7,34,128,78,0,73,68,9,21,64,84,128,80,0,192,
67,0,136,83,4,0,64,72,128,68,0,192,70,0,128,83,0,200,73,9,0,64,69,128,78,
0,64,72,136,83,4,0,64,82,128,82,0,73,82,27,45,73,79,9,20,64,83,128,80,0,
72,68,6,128,67,0,64,67,128,80,0,128,83,0,200,80,15,0,137,77,5,8,0,128,70,
0,128,82,0,128,78,0,72,86,8,64,73,128,68,0,64,83,73,77,7,12,128,80,0,64,
65,128,66,0,128,84,0,64,88,64,65,128,70,0,72,208,8,64,161,128,83,0,64,90,
73,73,7,18,128,82,0,72,69,6,128,76,0,64,66,128,79,0,64,80,128,82,0,64,67,
74,78,203,13,59,137,74,5,100,0,137,68,5,57,0,73,66,11,39,136,86,4,0,128,
66,0,64,65,73,77,7,19,128,69,0,200,68,9,0,64,78,128,82,0,128,65,0,136,86,
4,0,128,80,0,64,67,72,69,8,64,73,128,80,0,128,67,0,201,72,10,23,0,64,84,
128,67,0,64,69,72,87,6,128,65,0,64,73,128,67,0,64,73,137,76,5,8,0,128,66,
0,64,83,128,70,0,201,82,16,64,0,137,80,5,8,0,128,73,0,128,83,0,201,78,8,
25,0,128,78,0,64,77,73,82,7,12,128,71,0,64,69,128,71,0,128,86,0,64,80,73,
77,11,18,64,73,64,69,128,67,0,136,74,4,0,128,70,0,128,83,0,73,84,13,29,
64,84,64,84,64,83,128,86,0,192,83,0,73,76,7,10,128,68,0,128,68,0,128,85,
0,64,90,128,85,0,74,71,126,8,87,73,78,9,57,64,80,128,71,0,73,70,13,34,136,
83,4,0,64,78,128,83,0,72,69,12,136,89,4,0,64,83,128,77,0,64,65,136,80,4,
0,128,76,0,72,77,6,128,80,0,192,73,0,64,65,128,82,0,73,83,15,53,72,73,6,
128,67,0,64,71,128,73,0,72,82,19,201,79,8,13,0,128,77,0,64,65,128,77,0,
128,80,0,64,80,137,74,5,12,0,136,73,4,0,128,65,0,64,77,128,69,0,64,87,72,
73,6,128,67,0,128,66,0,74,68,243,5,114,73,75,9,136,64,69,128,89,0,73,69,
16,78,200,82,7,0,128,65,0,64,77,128,65,0,201,67,20,39,0,72,78,10,64,80,
64,73,128,78,0,64,73,128,82,0,72,66,6,128,71,0,64,65,72,82,6,128,83,0,64,
73,128,68,0,64,68,137,73,5,12,0,136,66,4,0,128,65,0,72,82,6,128,76,0,128,
76,0,73,72,17,30,72,69,6,128,83,0,64,65,64,67,128,75,0,136,71,4,0,64,70,
136,83,4,0,128,73,0,64,73,73,73,7,12,128,78,0,64,65,128,67,0,64,83,128,
67,0,73,83,15,79,137,67,5,8,0,128,65,0,128,77,0,201,80,28,50,0,73,72,7,
14,128,69,0,136,69,4,0,128,68,0,64,79,64,75,64,69,128,82,0,200,78,7,0,128,
65,0,64,77,73,82,7,10,128,80,0,128,65,0,128,83,0,192,82,0,137,72,5,8,0,
128,70,0,128,76,0,73,86,11,20,136,84,4,0,128,67,0,64,85,64,83,64,67,128,
67,0,128,87,0,74,66,211,2,208,73,78,9,123,64,82,128,77,0,73,70,7,87,128,
80,0,201,68,22,53,0,72,89,8,64,65,128,71,0,64,82,136,82,4,0,128,77,0,72,
67,10,136,84,4,0,128,80,0,64,65,137,80,5,14,0,72,77,6,128,82,0,128,67,0,
64,83,128,80,0,64,69,73,77,7,16,128,65,0,136,73,4,0,64,67,128,83,0,72,84,
6,128,65,0,128,82,0,73,73,15,20,137,69,5,8,0,128,68,0,128,82,0,64,72,128,
68,0,64,77,64,73,128,68,0,201,82,16,42,0,137,69,5,8,0,128,67,0,128,78,0,
201,80,14,23,0,72,87,6,128,80,0,128,80,0,64,79,136,84,4,0,128,69,0,128,
81,0,73,84,7,26,128,67,0,64,83,137,83,5,12,0,136,69,4,0,128,68,0,64,87,
128,77,0,64,87,72,82,8,64,69,128,68,0,64,70,128,81,0,192,65,0,74,77,38,
1,29,73,72,7,24,128,83,0,72,70,10,136,84,4,0,128,65,0,64,67,64,65,128,72,
0,72,82,6,128,65,0,128,76,0,73,70,34,115,201,79,8,21,0,128,87,0,136,77,
4,0,64,67,64,65,64,83,128,83,0,72,84,6,128,65,0,128,82,0,73,67,9,46,64,
70,128,80,0,72,66,22,73,69,7,16,128,73,0,136,67,4,0,64,65,128,67,0,128,
71,0,64,65,72,84,6,128,69,0,64,72,64,69,128,80,0,200,69,9,0,64,70,128,83,
0,192,68,0,73,78,7,20,128,65,0,72,73,6,128,69,0,64,68,64,69,128,84,0,128,
82,0,73,73,13,49,136,82,4,0,64,68,128,65,0,72,72,21,73,82,7,15,128,79,0,
192,73,0,64,73,128,77,0,128,85,0,64,71,137,80,5,10,0,64,78,128,89,0,128,
82,0,192,76,0,73,80,19,46,72,72,8,64,65,128,68,0,64,69,64,82,128,83,0,73,
69,7,22,128,65,0,72,67,6,128,77,0,64,65,64,82,64,84,128,83,0,64,71,128,
66,0,73,84,21,31,72,82,10,64,65,64,78,128,83,0,64,69,64,67,128,72,0,192,
83,0,64,84,64,82,128,83,0,128,85,0,73,82,23,135,73,73,11,14,64,67,64,79,
128,77,0,128,66,0,64,80,128,67,0,73,80,60,103,73,82,9,33,64,73,128,69,0,
201,77,10,19,0,64,65,128,83,0,72,69,6,128,88,0,128,68,0,64,80,128,80,0,
137,84,5,10,0,64,83,128,69,0,64,87,72,73,6,128,80,0,64,65,128,80,0,72,79,
6,128,73,0,64,78,137,78,5,24,0,73,66,11,16,64,82,64,80,128,69,0,64,65,128,
67,0,128,70,0,72,83,6,128,79,0,64,82,128,65,0,64,81,64,68,64,65,128,83,
0,73,86,13,79,64,65,64,84,64,65,128,83,0,72,84,29,73,82,7,23,128,67,0,72,
79,10,64,66,64,65,128,82,0,192,73,0,128,65,0,128,87,0,64,83,73,82,7,24,
128,79,0,72,77,12,136,79,4,0,64,73,128,73,0,64,68,128,73,0,136,86,4,0,64,
83,64,67,128,70,0,64,87,64,83,128,83,0,64,67,73,76,21,243,72,82,6,128,67,
0,64,69,64,65,64,78,64,69,128,82,0,73,70,18,116,137,79,5,8,0,128,76,0,192,
84,0,128,65,0,73,67,17,50,137,83,5,8,0,128,80,0,64,84,128,66,0,72,66,16,
136,83,4,0,64,80,136,77,4,0,128,73,0,64,65,73,82,7,12,128,72,0,64,77,128,
80,0,128,87,0,200,69,24,0,201,77,10,15,0,64,84,128,80,0,64,65,128,83,0,
64,78,128,84,0,192,68,0,73,72,9,18,64,82,128,78,0,72,66,6,128,71,0,128,
65,0,128,80,0,201,73,53,94,0,137,77,5,25,0,137,70,5,15,0,200,69,7,0,128,
69,0,128,66,0,64,73,128,80,0,73,84,9,18,64,83,128,69,0,72,82,6,128,78,0,
128,80,0,64,86,128,83,0,72,72,26,73,69,7,20,128,82,0,72,66,6,128,67,0,64,
65,64,80,128,83,0,128,82,0,64,71,137,83,5,10,0,64,65,128,65,0,128,84,0,
72,75,9,192,77,0,128,80,0,128,74,0,73,83,42,155,137,80,5,23,0,72,68,10,
136,83,4,0,128,78,0,192,65,0,64,82,128,80,0,72,83,10,136,79,4,0,128,69,
0,64,82,128,68,0,201,79,22,54,0,72,72,12,72,84,6,128,65,0,128,83,0,64,68,
128,67,0,72,78,23,73,70,11,17,64,83,64,68,128,85,0,192,65,0,128,66,0,128,
80,0,64,77,136,83,4,0,128,69,0,72,82,32,73,69,7,18,128,76,0,72,68,6,128,
85,0,64,65,128,83,0,72,80,6,128,67,0,64,77,128,65,0,64,80,137,77,5,16,0,
72,73,6,128,84,0,64,67,128,74,0,64,82,64,79,64,88,128,89,0,73,86,11,26,
136,85,4,0,128,80,0,72,85,8,64,83,128,65,0,64,84,64,76,128,68,0,64,87,128,
70,0,200,70,158,0,137,79,5,90,0,73,72,7,50,128,84,0,201,68,8,36,0,128,65,
0,192,65,0,73,83,7,16,128,84,0,72,67,6,128,84,0,128,65,0,64,84,136,83,4,
0,128,70,0,64,69,64,84,128,83,0,72,77,16,73,69,7,10,128,85,0,128,68,0,128,
85,0,64,73,73,68,7,14,128,83,0,136,66,4,0,128,65,0,128,84,0,73,83,21,38,
137,80,5,14,0,64,65,136,78,4,0,128,67,0,128,84,0,72,82,12,136,80,4,0,64,
79,128,73,0,64,80,128,80,0,72,208,6,128,144,0,64,84,73,71,9,12,64,69,128,
67,0,128,67,0,192,82,0,128,73,0,64,69,73,76,37,240,137,80,5,22,0,72,68,
10,136,84,4,0,128,70,0,64,65,64,82,128,71,0,64,84,72,89,6,128,76,0,128,
65,0,73,70,21,132,73,73,7,12,128,82,0,64,67,128,79,0,64,84,128,65,0,73,
67,21,54,73,67,9,14,64,65,128,82,0,64,65,128,73,0,128,87,0,72,66,18,73,
82,9,12,64,65,128,80,0,128,80,0,128,83,0,64,65,72,77,8,64,83,128,69,0,64,
67,128,82,0,72,69,26,72,79,6,128,65,0,64,77,72,69,6,128,65,0,64,65,136,
82,4,0,128,78,0,64,68,73,70,7,16,128,65,0,136,67,4,0,64,65,128,87,0,72,
79,6,128,76,0,64,73,64,80,128,84,0,73,73,51,64,73,79,9,34,64,80,128,83,
0,137,69,5,20,0,72,66,10,136,83,4,0,128,67,0,64,65,128,71,0,64,71,128,69,
0,137,82,5,8,0,128,80,0,64,84,128,70,0,136,72,4,0,64,71,136,80,4,0,128,
72,0,64,74,64,73,128,76,0,73,81,7,111,128,65,0,201,79,14,69,0,72,82,6,128,
71,0,128,80,0,72,78,30,137,78,5,18,0,136,76,4,0,64,69,64,83,64,69,128,88,
0,64,84,64,67,64,79,128,77,0,64,77,73,69,11,18,136,86,4,0,128,65,0,64,65,
64,67,128,72,0,64,74,128,80,0,64,80,73,80,13,26,64,87,64,65,64,87,128,85,
0,72,77,8,64,76,128,80,0,64,65,128,76,0,136,83,4,0,128,82,0,73,84,7,97,
128,75,0,200,83,39,0,73,79,11,26,64,80,64,83,128,78,0,72,73,8,64,65,128,
75,0,64,68,64,73,128,83,0,136,82,4,0,64,80,128,84,0,64,82,73,72,7,26,128,
82,0,73,67,9,12,64,76,128,65,0,128,65,0,64,68,64,73,128,80,0,73,78,9,20,
64,69,128,84,0,64,73,136,70,4,0,64,65,128,83,0,128,84,0,64,85,64,77,128,
69,0,202,75,31,2,182,0,73,71,7,16,128,82,0,72,69,6,128,77,0,128,68,0,136,
89,4,0,64,76,128,83,0,82,73,1,219,2,112,201,76,10,246,0,64,73,128,80,0,
201,70,40,183,0,73,79,7,26,128,82,0,73,73,7,12,128,84,0,64,70,128,84,0,
64,78,64,69,128,84,0,72,84,6,128,65,0,128,83,0,73,67,25,66,137,83,5,16,
0,72,80,6,128,67,0,64,71,128,70,0,64,85,128,80,0,72,66,30,73,73,7,16,128,
69,0,136,67,4,0,64,65,128,77,0,72,84,6,128,77,0,64,82,128,65,0,64,65,72,
80,6,128,69,0,128,67,0,72,69,43,201,72,8,19,0,128,73,0,137,68,5,8,0,128,
67,0,128,69,0,72,83,14,72,73,6,128,78,0,64,65,128,83,0,64,80,64,65,128,
67,0,64,68,73,76,7,18,128,73,0,137,66,5,8,0,128,65,0,128,71,0,72,83,6,128,
79,0,192,82,0,64,65,128,80,0,73,73,11,46,136,83,4,0,128,65,0,72,72,22,73,
82,7,16,128,83,0,136,73,4,0,64,66,128,69,0,128,83,0,64,71,136,83,4,0,64,
82,64,69,128,70,0,64,74,64,87,128,83,0,73,82,17,138,136,82,4,0,64,67,64,
65,64,77,128,80,0,201,79,16,69,0,72,77,6,128,83,0,64,65,128,67,0,72,78,
24,73,68,9,16,64,79,128,67,0,64,65,64,72,128,76,0,64,73,128,67,0,64,77,
201,73,12,21,0,136,83,4,0,128,69,0,72,69,6,128,66,0,128,65,0,192,79,0,128,
77,0,64,80,73,70,7,27,128,65,0,137,68,5,15,0,136,67,4,0,192,65,0,128,86,
0,64,69,128,84,0,137,82,5,18,0,72,80,8,64,73,128,67,0,64,76,128,65,0,64,
83,128,73,0,73,86,15,70,72,80,8,64,79,128,76,0,128,67,0,72,84,14,72,82,
8,64,73,128,83,0,128,77,0,64,83,137,79,5,21,0,137,71,5,13,0,192,67,0,64,
68,128,82,0,128,77,0,200,83,11,0,136,80,4,0,128,68,0,64,80,64,69,128,83,
0,64,87,73,77,7,10,128,66,0,128,70,0,128,83,0,64,72,73,77,9,88,64,83,128,
76,0,73,69,31,58,137,68,5,10,0,64,65,128,67,0,64,77,72,84,10,64,82,64,69,
128,67,0,64,65,128,88,0,73,67,7,22,128,73,0,64,65,137,80,5,10,0,64,78,128,
80,0,128,81,0,64,68,128,75,0,73,73,11,16,64,80,64,82,128,65,0,64,70,128,
67,0,64,76,128,71,0,73,82,13,34,136,87,4,0,64,73,128,69,0,73,79,9,14,64,
71,128,77,0,64,78,128,77,0,64,80,64,80,128,77,0,73,84,13,20,72,77,6,128,
76,0,128,70,0,64,83,64,87,128,67,0,64,85,128,81,0,64,74,137,75,5,24,0,73,
67,9,16,64,83,128,67,0,64,65,64,83,128,78,0,128,68,0,72,83,6,128,67,0,64,
80,64,77,128,69,0,72,77,202,137,74,5,122,0,73,69,13,79,72,78,6,128,67,0,
128,65,0,73,67,20,49,73,69,7,10,128,67,0,128,67,0,192,83,0,128,82,0,72,
66,10,136,83,4,0,128,82,0,64,65,137,77,5,12,0,136,75,4,0,128,74,0,64,83,
128,70,0,64,68,73,67,7,10,128,65,0,128,66,0,64,82,128,82,0,73,72,7,19,128,
67,0,72,71,6,128,73,0,192,70,0,128,73,0,64,73,137,80,5,14,0,72,73,6,128,
87,0,128,71,0,128,83,0,201,83,20,56,0,73,77,7,12,128,83,0,64,73,128,83,
0,128,83,0,201,79,8,27,0,128,83,0,72,78,6,128,83,0,64,77,137,73,5,8,0,128,
68,0,128,83,0,64,82,136,82,4,0,128,65,0,73,86,7,18,128,82,0,64,84,136,83,
4,0,64,80,128,76,0,128,89,0,64,76,73,79,11,99,136,83,4,0,128,66,0,73,70,
7,65,128,83,0,73,68,17,45,137,67,5,10,0,64,65,128,80,0,128,82,0,192,65,
0,73,71,7,20,128,83,0,72,69,6,128,83,0,64,67,64,83,128,79,0,64,73,128,84,
0,64,69,137,73,5,8,0,128,67,0,128,80,0,136,78,4,0,64,73,137,82,5,12,0,136,
76,4,0,128,68,0,64,83,128,80,0,73,85,7,37,128,87,0,73,83,11,25,136,85,4,
0,128,80,0,192,82,0,72,84,8,64,65,128,80,0,128,78,0,64,84,128,86,0,72,89,
6,128,87,0,64,86,136,83,4,0,128,77,0,74,85,143,7,72,73,77,9,73,64,69,128,
88,0,73,70,16,43,72,79,6,128,83,0,192,73,0,128,78,0,73,67,7,12,128,77,0,
64,65,128,69,0,64,68,73,69,7,10,128,83,0,128,65,0,128,78,0,73,72,7,10,128,
75,0,128,71,0,64,76,136,86,4,0,64,77,128,65,0,73,83,21,48,73,83,7,12,128,
77,0,64,65,128,84,0,64,85,128,77,0,73,79,7,12,128,68,0,64,78,128,89,0,64,
80,73,80,7,10,128,83,0,128,69,0,128,83,0,73,87,11,14,136,78,4,0,128,76,
0,128,86,0,128,88,0,74,82,221,4,155,201,77,18,130,0,73,80,7,10,128,71,0,
128,70,0,128,87,0,73,69,11,48,64,68,64,65,128,73,0,137,67,5,32,0,72,66,
6,128,84,0,64,65,73,70,9,14,64,83,128,83,0,64,68,128,65,0,64,82,128,71,
0,64,68,128,70,0,73,75,7,58,128,84,0,136,74,4,0,64,73,73,80,7,28,128,65,
0,72,77,6,128,84,0,64,67,72,85,8,64,87,128,82,0,64,79,128,83,0,64,83,72,
84,12,64,65,64,67,64,69,128,82,0,128,77,0,192,76,0,128,70,0,73,85,7,67,
128,68,0,73,83,19,54,137,80,5,10,0,64,71,128,83,0,64,82,128,83,0,72,82,
18,137,68,5,8,0,128,65,0,64,85,64,83,128,84,0,64,80,137,71,5,12,0,136,70,
4,0,128,68,0,128,83,0,192,84,0,128,80,0,73,87,13,16,136,83,4,0,64,82,128,
67,0,128,86,0,128,88,0,82,80,1,59,3,167,73,77,7,184,128,80,0,73,71,7,108,
128,66,0,73,68,24,78,137,77,5,14,0,72,76,6,128,67,0,128,72,0,192,82,0,128,
67,0,200,67,25,0,73,83,7,18,128,78,0,72,82,6,128,65,0,64,67,128,83,0,128,
85,0,64,65,137,78,5,18,0,137,67,5,10,0,64,66,128,67,0,128,76,0,72,85,6,
128,71,0,128,80,0,72,70,12,72,83,6,128,75,0,128,82,0,64,69,136,69,4,0,64,
67,128,67,0,137,74,5,56,0,200,73,40,0,137,81,5,22,0,73,67,7,12,128,72,0,
64,65,128,73,0,64,76,128,83,0,200,84,7,0,128,78,0,64,83,64,82,128,65,0,
64,72,72,86,6,128,65,0,128,83,0,64,76,137,82,5,8,0,128,68,0,128,83,0,73,
83,21,83,73,73,7,14,128,65,0,136,69,4,0,128,67,0,128,85,0,73,80,25,47,137,
76,5,16,0,72,73,6,128,66,0,64,67,128,71,0,64,78,128,77,0,72,79,14,137,76,
5,8,0,128,69,0,128,83,0,64,78,192,83,0,128,68,0,64,82,73,71,7,10,128,83,
0,128,70,0,128,77,0,137,86,5,37,0,200,85,15,0,137,84,5,8,0,128,69,0,128,
90,0,64,84,72,69,10,136,68,4,0,128,67,0,64,68,128,67,0,64,87,128,68,0,64,
79,73,73,19,206,64,78,64,84,64,69,64,76,64,80,64,82,128,79,0,73,69,11,94,
64,83,64,80,128,85,0,73,67,11,57,64,79,64,77,128,79,0,200,66,29,0,137,76,
5,14,0,72,72,6,128,67,0,128,69,0,72,83,6,128,69,0,64,79,128,76,0,64,65,
137,71,5,10,0,64,68,128,83,0,64,80,128,80,0,192,68,0,73,73,7,16,128,83,
0,64,65,64,83,64,89,128,76,0,64,87,64,65,128,87,0,73,71,21,81,73,73,7,14,
128,67,0,64,69,64,78,128,84,0,128,83,0,64,70,73,69,29,46,137,83,5,18,0,
72,80,10,64,82,64,73,128,83,0,128,69,0,64,84,64,69,128,76,0,72,68,6,128,
77,0,64,65,136,76,4,0,64,73,128,69,0,72,79,6,128,71,0,192,70,0,128,79,0,
192,72,0,72,82,6,128,69,0,128,70,0,74,80,30,1,39,73,79,7,18,128,77,0,72,
73,8,64,78,128,72,0,128,68,0,64,80,64,65,128,83,0,73,78,103,244,73,76,11,
84,64,65,64,78,128,71,0,73,67,13,64,64,65,64,67,64,65,128,70,0,64,65,73,
70,9,28,64,79,128,82,0,73,67,9,12,64,89,128,84,0,128,66,0,64,68,64,73,128,
83,0,73,80,7,14,128,79,0,64,71,64,85,128,65,0,64,84,64,69,128,76,0,64,69,
64,76,64,69,128,67,0,72,85,6,128,83,0,64,83,64,77,64,73,128,78,0,72,77,
104,73,80,11,80,64,84,64,73,128,65,0,73,73,27,66,73,80,11,16,64,69,64,77,
128,83,0,64,78,128,84,0,64,83,64,65,128,70,0,72,70,14,72,69,6,128,82,0,
64,65,128,82,0,64,69,73,83,7,20,128,65,0,72,76,8,64,69,128,67,0,64,68,128,
75,0,128,88,0,128,76,0,73,83,9,16,64,69,128,67,0,64,82,64,79,128,83,0,64,
84,128,73,0,64,76,137,80,5,24,0,72,71,12,64,82,64,79,64,85,128,80,0,64,
65,64,71,128,69,0,72,84,8,64,65,128,78,0,128,82,0,64,79,64,76,64,80,64,
82,64,69,64,86,64,73,64,69,64,87,128,83,0,73,83,85,98,137,77,5,56,0,73,
72,7,40,128,72,0,72,69,26,73,82,9,16,64,82,128,67,0,64,80,64,85,128,80,
0,64,87,64,73,128,67,0,64,65,64,84,128,85,0,136,76,4,0,64,73,64,68,128,
65,0,73,83,11,22,64,65,64,67,128,83,0,72,80,8,64,65,128,82,0,128,79,0,128,
88,0,64,82,72,87,6,128,77,0,64,66,128,65,0,64,84,137,83,5,14,0,136,82,4,
0,64,72,128,77,0,128,89,0,64,81,73,82,7,16,128,83,0,72,70,6,128,80,0,128,
66,0,64,87,128,80,0,72,84,157,73,73,20,102,73,67,7,10,128,67,0,128,65,0,
192,79,0,128,83,0,73,69,11,46,64,70,64,76,128,65,0,73,66,13,18,72,85,6,
128,72,0,128,84,0,64,65,128,78,0,64,67,137,82,5,10,0,64,65,128,69,0,64,
83,128,83,0,73,71,7,29,128,70,0,192,70,0,137,75,5,16,0,72,69,8,64,65,128,
84,0,128,65,0,128,80,0,64,72,64,67,128,77,0,73,82,9,30,64,76,128,68,0,73,
78,13,16,72,83,6,128,80,0,128,65,0,128,77,0,64,81,128,73,0,73,84,7,17,128,
80,0,192,83,0,136,84,4,0,128,83,0,64,89,128,73,0,192,83,0,73,78,17,182,
137,80,5,10,0,64,69,128,84,0,128,89,0,73,70,11,95,136,86,4,0,128,66,0,73,
68,15,72,72,76,6,128,68,0,64,71,128,77,0,72,67,34,73,77,7,20,128,80,0,137,
70,5,10,0,64,65,128,80,0,128,73,0,137,87,5,8,0,128,78,0,128,90,0,64,65,
137,82,5,18,0,64,67,136,83,4,0,64,69,64,76,128,80,0,128,86,0,64,69,136,
87,4,0,192,76,0,128,84,0,73,76,9,59,64,73,128,80,0,72,73,38,73,69,7,21,
128,84,0,72,68,6,128,83,0,192,67,0,64,79,128,80,0,136,83,4,0,192,82,0,136,
84,4,0,128,79,0,192,72,0,72,67,6,128,78,0,128,65,0,64,77,72,69,6,128,69,
0,128,65,0,201,83,36,105,0,137,70,5,18,0,72,68,8,64,67,128,65,0,64,65,128,
68,0,72,78,6,128,80,0,64,73,64,84,128,79,0,73,81,7,39,128,69,0,72,80,18,
137,73,5,10,0,64,70,128,65,0,64,76,128,65,0,192,79,0,72,83,6,128,65,0,64,
77,128,65,0,64,82,137,71,5,19,0,200,70,7,0,128,70,0,64,69,64,69,128,83,
0,72,83,6,128,83,0,128,80,0,73,85,40,79,73,77,7,22,128,66,0,72,76,10,136,
66,4,0,128,65,0,64,68,128,72,0,72,83,6,128,66,0,192,78,0,64,69,128,84,0,
64,84,137,79,5,22,0,73,73,9,14,64,78,128,68,0,64,66,128,84,0,128,78,0,72,
82,10,64,73,64,75,128,69,0,64,80,128,86,0,192,86,0,73,80,7,10,128,78,0,
128,73,0,128,82,0,73,89,45,226,73,83,9,28,64,69,128,67,0,73,78,7,14,128,
69,0,64,70,64,65,128,82,0,64,79,128,65,0,72,86,6,128,79,0,64,84,64,69,128,
68,0,200,87,111,0,73,79,7,52,128,84,0,73,76,7,30,128,70,0,73,68,7,12,128,
77,0,64,65,128,66,0,64,73,136,81,4,0,64,72,128,80,0,72,78,10,136,80,4,0,
128,65,0,64,77,128,73,0,73,83,18,40,137,80,5,8,0,128,73,0,192,82,0,128,
70,0,73,81,7,12,128,67,0,64,80,128,84,0,192,82,0,136,85,4,0,128,69,0,200,
85,9,0,64,83,128,65,0,192,84,0,128,65,0,192,86,0,73,78,7,32,128,69,0,137,
69,5,14,0,136,68,4,0,64,67,128,67,0,72,71,8,64,73,128,80,0,128,70,0,201,
83,8,20,0,128,83,0,72,82,6,128,68,0,192,80,0,128,82,0,200,86,7,0,128,84,
0,192,84,0,64,67,128,83,0,72,208,26,73,160,9,16,64,208,128,145,0,64,145,
64,79,128,80,0,64,161,64,80,128,73,0,64,90,73,73,7,20,128,80,0,72,69,8,
64,82,128,79,0,64,67,128,83,0,136,87,4,0,128,75,0,80,70,11,42,202,78,45,
7,31,0,73,77,13,24,72,79,6,128,67,0,128,65,0,72,73,8,64,67,128,79,0,128,
66,0,72,82,10,136,83,4,0,128,73,0,64,80,128,84,0,74,70,120,3,243,73,77,
13,66,136,83,4,0,64,73,128,65,0,73,68,15,30,72,76,6,128,67,0,64,67,128,
65,0,72,67,8,64,72,128,83,0,64,65,64,80,128,73,0,72,73,16,137,73,5,10,0,
64,69,128,67,0,128,88,0,64,69,64,76,128,80,0,73,83,7,23,128,74,0,200,79,
11,0,136,87,4,0,128,76,0,64,78,128,78,0,200,88,16,0,192,73,0,136,86,4,0,
64,73,128,73,0,192,84,0,136,82,4,0,128,76,0,202,67,201,2,53,0,137,76,5,
85,0,201,69,12,55,0,136,86,4,0,128,83,0,201,67,8,38,0,128,78,0,72,66,14,
72,83,6,128,76,0,64,71,128,65,0,192,65,0,137,84,5,10,0,64,80,128,83,0,128,
87,0,64,68,128,76,0,73,72,7,16,128,86,0,64,70,136,83,4,0,128,70,0,64,73,
136,86,4,0,128,77,0,73,82,16,77,72,73,6,128,83,0,192,65,0,128,77,0,73,79,
19,46,137,69,5,12,0,64,67,64,69,128,69,0,128,74,0,72,78,18,137,77,5,12,
0,136,76,4,0,128,68,0,128,82,0,64,77,64,73,64,83,128,67,0,64,80,137,70,
5,8,0,128,65,0,64,71,128,65,0,73,84,7,22,128,67,0,64,83,137,77,5,10,0,64,
67,128,82,0,128,82,0,64,85,136,75,4,0,64,66,128,69,0,72,66,95,73,76,7,55,
128,65,0,73,68,15,32,136,76,4,0,64,73,64,77,128,77,0,72,67,8,64,67,128,
73,0,64,65,136,79,4,0,128,73,0,200,73,11,0,136,83,4,0,128,75,0,64,71,128,
65,0,73,84,7,24,128,67,0,72,83,12,136,82,4,0,64,79,128,65,0,64,77,128,69,
0,72,87,10,136,70,4,0,128,67,0,128,86,0,64,65,73,78,17,155,72,76,8,64,89,
128,67,0,64,70,128,69,0,73,70,9,70,64,83,128,65,0,73,67,29,42,137,83,5,
16,0,72,68,6,128,76,0,64,67,128,72,0,64,84,136,69,4,0,128,65,0,72,66,6,
128,80,0,64,65,64,73,128,83,0,72,69,8,64,67,128,65,0,64,68,136,78,4,0,64,
69,128,67,0,73,73,23,46,73,70,7,12,128,65,0,64,65,128,84,0,64,77,64,77,
128,83,0,72,72,16,136,85,4,0,64,67,64,83,64,73,128,65,0,64,71,64,67,128,
65,0,200,77,13,0,64,73,64,67,64,79,128,77,0,64,76,64,71,64,66,128,84,0,
201,84,8,76,0,128,70,0,201,81,8,25,0,128,76,0,72,80,14,72,73,8,64,73,128,
83,0,128,69,0,128,79,0,72,83,28,73,69,7,14,128,66,0,136,68,4,0,128,66,0,
72,83,6,128,84,0,64,73,128,69,0,64,82,136,67,4,0,64,65,64,80,64,69,128,
74,0,201,87,8,25,0,128,85,0,72,86,12,64,73,64,67,64,79,128,78,0,64,85,128,
68,0,64,89,136,84,4,0,64,77,128,69,0,72,69,209,73,72,17,85,72,69,8,64,77,
128,67,0,64,66,128,80,0,73,68,9,31,64,69,128,65,0,73,66,7,16,128,69,0,64,
65,64,82,64,69,128,68,0,192,67,0,128,78,0,73,70,17,30,73,73,7,10,128,65,
0,128,67,0,128,79,0,64,69,136,77,4,0,64,76,64,84,128,65,0,64,71,64,76,128,
73,0,73,78,13,80,64,65,64,77,64,65,128,67,0,73,76,39,44,73,84,9,32,64,79,
128,77,0,72,71,8,64,84,128,66,0,64,65,136,80,4,0,64,70,64,65,64,67,128,
83,0,128,86,0,64,73,128,80,0,64,77,137,80,5,14,0,72,68,6,128,73,0,128,65,
0,64,89,64,83,128,79,0,73,83,9,38,64,67,128,79,0,64,82,73,80,11,18,136,
73,4,0,128,65,0,136,70,4,0,128,67,0,72,89,6,128,80,0,128,83,0,128,84,0,
64,68,201,76,8,74,0,128,69,0,73,69,7,41,128,80,0,73,67,13,29,72,80,6,128,
65,0,128,67,0,136,66,4,0,192,65,0,136,70,4,0,64,67,128,83,0,64,68,128,73,
0,201,73,17,22,0,136,83,4,0,192,67,0,64,73,128,65,0,64,70,128,68,0,128,
74,0,73,80,9,22,64,73,128,82,0,137,78,5,10,0,64,77,128,65,0,128,79,0,73,
83,9,14,64,79,128,73,0,64,81,128,77,0,64,84,128,68,0,82,73,1,43,1,183,73,
77,15,153,136,76,4,0,64,66,64,82,128,65,0,201,70,26,106,0,137,71,5,12,0,
136,69,4,0,128,65,0,72,82,6,128,65,0,128,79,0,73,67,32,65,137,76,5,17,0,
200,67,7,0,128,73,0,64,65,128,71,0,136,83,4,0,64,79,64,82,128,65,0,72,66,
26,137,71,5,14,0,136,67,4,0,64,65,128,65,0,72,85,6,128,65,0,128,73,0,64,
65,64,73,128,80,0,64,68,73,80,7,10,128,65,0,128,77,0,128,83,0,73,73,9,21,
64,78,128,65,0,200,72,7,0,128,67,0,64,71,128,67,0,64,76,64,69,64,77,64,
79,128,78,0,73,83,31,121,73,73,7,16,128,77,0,72,69,6,128,67,0,128,65,0,
72,84,6,128,70,0,64,77,128,65,0,73,80,31,60,137,75,5,20,0,73,70,7,10,128,
71,0,128,66,0,64,74,128,80,0,136,83,4,0,128,82,0,72,79,10,136,72,4,0,128,
69,0,64,78,137,71,5,12,0,64,67,64,69,128,78,0,64,82,128,65,0,64,82,200,
82,9,0,64,69,128,65,0,64,69,64,85,64,80,64,76,64,79,64,65,64,68,64,69,128,
82,0,73,87,7,12,128,67,0,64,84,128,87,0,64,89,64,84,128,79,0,72,72,80,201,
77,8,46,0,128,65,0,73,70,11,20,136,66,4,0,128,65,0,72,69,6,128,81,0,128,
65,0,72,76,15,72,77,6,128,67,0,192,66,0,128,66,0,128,73,0,73,82,9,22,64,
67,128,79,0,72,80,8,64,67,128,65,0,64,79,128,71,0,192,83,0,192,83,0,128,
84,0,64,71,201,70,8,35,0,128,65,0,73,67,7,22,128,85,0,72,66,10,64,77,64,
70,128,73,0,64,65,128,67,0,64,68,128,67,0,73,84,11,20,136,83,4,0,128,72,
0,136,77,4,0,64,73,128,83,0,128,86,0,72,77,163,73,75,7,94,128,69,0,73,70,
9,67,64,73,128,65,0,73,68,7,41,128,86,0,200,67,25,0,73,83,7,14,128,65,0,
136,71,4,0,128,65,0,136,87,4,0,128,84,0,64,66,136,77,4,0,128,65,0,64,69,
73,67,7,10,128,65,0,128,65,0,64,68,128,65,0,73,73,11,17,64,65,64,84,128,
72,0,192,71,0,128,83,0,128,74,0,73,82,7,48,128,73,0,73,78,7,28,128,86,0,
72,77,8,64,85,128,71,0,64,76,72,89,8,64,72,128,77,0,128,65,0,64,80,72,82,
6,128,69,0,64,80,128,69,0,201,86,10,15,0,64,83,128,83,0,64,83,128,81,0,
128,89,0,192,76,0,73,79,23,111,73,83,7,12,128,83,0,64,76,128,83,0,64,84,
64,85,128,83,0,73,73,27,76,137,82,5,16,0,72,80,6,128,73,0,64,70,128,70,
0,64,83,64,79,128,76,0,73,67,9,19,64,65,128,83,0,64,65,192,67,0,64,83,128,
79,0,64,69,201,71,8,23,0,128,84,0,64,70,136,70,4,0,64,65,64,85,64,67,128,
72,0,64,84,128,67,0,200,78,7,0,128,71,0,64,77,128,73,0,137,86,5,32,0,73,
84,15,20,136,75,4,0,64,67,64,73,128,80,0,64,83,128,65,0,64,85,64,84,128,
68,0,72,89,8,64,70,128,70,0,64,87,136,82,4,0,64,79,128,82,0,74,84,129,3,
73,73,78,9,63,64,77,128,82,0,73,68,7,39,128,73,0,73,66,9,22,64,70,128,83,
0,192,65,0,136,77,4,0,192,65,0,128,80,0,192,67,0,136,76,4,0,128,65,0,72,
73,6,128,82,0,64,71,64,70,64,79,128,80,0,73,83,11,22,136,78,4,0,128,75,
0,136,80,4,0,64,79,64,80,128,83,0,136,90,4,0,64,84,137,80,5,20,0,137,72,
5,12,0,136,67,4,0,128,66,0,128,79,0,73,83,7,10,128,65,0,128,82,0,128,90,
0,74,81,16,1,104,72,80,6,128,65,0,64,68,128,78,0,72,80,128,73,77,25,87,
73,80,9,18,64,77,128,73,0,136,76,4,0,64,73,128,83,0,128,84,0,73,71,7,39,
128,65,0,73,67,22,29,201,77,8,13,0,128,83,0,64,67,128,73,0,64,79,128,78,
0,64,66,64,71,128,65,0,128,68,0,72,76,18,137,76,5,8,0,128,67,0,64,77,64,
84,128,83,0,64,74,128,81,0,73,84,7,31,128,80,0,200,83,21,0,73,76,9,14,64,
73,128,67,0,64,67,128,82,0,128,79,0,128,80,0,136,86,4,0,128,85,0,64,79,
73,78,19,132,72,83,6,128,73,0,64,76,64,73,64,78,128,69,0,73,71,11,51,64,
65,64,83,128,65,0,73,69,17,33,137,73,5,8,0,128,69,0,64,77,128,69,0,200,
66,7,0,128,84,0,64,65,136,75,4,0,128,70,0,64,70,64,73,128,88,0,73,76,17,
47,72,69,6,128,68,0,64,68,64,79,128,67,0,64,73,137,68,5,14,0,72,67,6,128,
65,0,128,65,0,72,82,6,128,76,0,192,80,0,64,80,128,65,0,64,77,137,66,5,10,
0,64,65,128,85,0,128,67,0,73,84,9,57,64,65,128,81,0,73,82,9,20,64,69,128,
88,0,72,81,6,128,65,0,64,80,128,69,0,64,83,73,72,7,18,128,85,0,72,69,6,
128,69,0,64,67,128,82,0,192,83,0,64,69,128,73,0,137,86,5,18,0,64,85,72,
82,8,64,67,128,67,0,128,79,0,64,87,64,76,128,82,0,72,83,223,73,77,7,148,
128,79,0,201,72,10,109,0,64,67,128,67,0,73,67,31,67,136,83,4,0,64,65,72,
80,12,64,84,64,85,64,82,128,69,0,64,76,64,76,64,69,128,82,0,200,66,7,0,
128,79,0,192,65,0,137,80,5,19,0,137,68,5,8,0,128,65,0,192,78,0,128,90,0,
136,86,4,0,128,82,0,200,70,15,0,72,82,8,64,69,128,65,0,128,69,0,64,69,73,
81,7,12,128,67,0,64,79,128,71,0,128,86,0,201,75,8,21,0,128,65,0,136,74,
4,0,64,73,136,83,4,0,128,80,0,64,76,136,78,4,0,64,73,128,67,0,73,82,7,38,
128,77,0,73,80,7,28,128,70,0,72,79,16,137,76,5,8,0,128,69,0,64,83,128,83,
0,64,78,128,78,0,128,81,0,73,86,7,31,128,67,0,200,85,11,0,136,85,4,0,128,
69,0,64,83,72,82,6,128,80,0,64,77,128,67,0,128,88,0,64,82,73,78,7,76,128,
67,0,73,69,17,56,72,82,6,128,80,0,64,77,64,69,128,67,0,73,66,13,30,136,
82,4,0,64,78,128,89,0,64,65,73,78,7,10,128,68,0,128,68,0,64,86,128,77,0,
64,67,136,83,4,0,128,80,0,72,77,8,64,79,128,76,0,64,76,128,65,0,73,84,7,
42,128,83,0,73,82,9,16,64,80,128,80,0,64,80,64,65,128,65,0,64,83,137,78,
5,12,0,64,73,64,82,128,84,0,64,83,128,69,0,72,87,6,128,84,0,128,85,0,73,
87,50,151,73,70,7,31,128,84,0,73,66,7,18,128,79,0,64,65,72,89,6,128,83,
0,128,66,0,192,68,0,128,73,0,73,73,7,12,128,87,0,64,72,128,77,0,128,81,
0,72,86,38,73,80,13,22,72,83,6,128,65,0,128,70,0,72,69,6,128,75,0,128,68,
0,72,84,8,64,80,128,76,0,64,83,128,83,0,64,85,73,78,9,36,64,68,128,80,0,
73,68,11,22,64,67,64,79,128,78,0,72,67,6,128,83,0,64,65,128,74,0,64,73,
128,66,0,73,83,7,20,128,69,0,64,82,72,89,8,64,77,128,79,0,128,66,0,64,84,
128,72,0,64,89,137,73,5,24,0,73,69,11,14,136,79,4,0,128,71,0,128,66,0,64,
70,128,86,0,72,82,8,64,79,128,77,0,64,80,128,77,0,64,69,74,78,120,7,250,
73,79,11,61,136,69,4,0,128,66,0,73,70,9,35,64,83,128,73,0,73,68,7,18,128,
65,0,64,65,136,72,4,0,64,69,128,69,0,64,69,192,77,0,128,79,0,72,77,8,64,
77,128,67,0,64,73,64,83,128,65,0,73,83,21,37,73,72,9,14,64,80,128,79,0,
64,68,128,70,0,128,79,0,200,82,11,0,136,83,4,0,128,67,0,64,80,128,73,0,
72,86,6,128,71,0,64,85,72,83,6,128,80,0,128,70,0,74,71,114,5,44,73,76,7,
61,128,77,0,73,69,7,38,128,69,0,73,66,13,28,72,68,6,128,70,0,128,65,0,64,
65,136,84,4,0,64,83,64,80,64,73,128,78,0,128,68,0,72,73,6,128,82,0,192,
70,0,136,82,4,0,128,80,0,137,82,5,33,0,200,80,21,0,73,82,7,12,128,83,0,
64,67,128,83,0,64,87,128,83,0,64,78,64,79,128,83,0,72,84,10,64,82,64,82,
128,65,0,64,83,128,77,0,202,68,179,3,93,0,73,78,9,99,64,79,128,83,0,73,
69,17,44,72,82,8,64,69,128,88,0,64,72,128,78,0,137,66,5,22,0,64,65,137,
73,5,10,0,64,67,128,83,0,64,78,128,65,0,64,68,128,76,0,201,73,30,35,0,73,
70,11,20,64,65,64,67,128,84,0,64,68,64,69,64,83,128,84,0,64,84,128,84,0,
64,70,128,65,0,64,77,136,83,4,0,64,65,128,67,0,73,83,22,53,73,72,9,15,64,
69,128,68,0,192,65,0,128,67,0,128,83,0,73,81,7,19,128,77,0,64,80,200,82,
7,0,128,83,0,128,67,0,192,82,0,136,67,4,0,64,65,128,77,0,73,86,9,14,64,
65,128,67,0,64,84,128,65,0,64,88,64,82,128,70,0,74,66,111,1,114,73,80,7,
67,128,80,0,73,71,7,32,128,65,0,73,67,11,22,64,68,64,73,128,67,0,64,65,
72,89,6,128,67,0,128,78,0,128,68,0,73,77,7,23,128,76,0,64,73,200,84,9,0,
64,68,128,65,0,64,65,128,84,0,64,78,128,70,0,137,85,5,22,0,73,83,7,12,128,
68,0,64,82,128,68,0,64,84,128,71,0,73,87,7,10,128,65,0,128,86,0,64,88,64,
77,128,76,0,192,65,0,73,74,7,138,128,67,0,73,69,19,79,137,85,5,10,0,64,
80,128,69,0,64,89,128,68,0,201,67,22,45,0,73,69,7,10,128,65,0,128,68,0,
64,76,64,80,128,80,0,72,66,8,64,73,128,83,0,64,65,137,75,5,10,0,64,67,128,
73,0,128,84,0,64,68,73,84,7,10,128,85,0,128,83,0,128,86,0,73,72,7,34,128,
71,0,72,71,6,128,84,0,64,70,137,84,5,14,0,72,82,6,128,68,0,128,69,0,64,
85,128,83,0,192,73,0,137,69,5,10,0,64,68,128,67,0,64,84,128,70,0,73,82,
21,76,73,79,7,12,128,77,0,64,76,128,73,0,64,83,128,83,0,201,80,28,44,0,
137,76,5,12,0,136,73,4,0,128,68,0,72,80,6,128,73,0,64,79,128,76,0,72,78,
8,64,84,128,67,0,192,77,0,64,84,128,77,0,64,81,64,85,64,65,64,76,128,83,
0,73,84,27,37,73,77,7,16,128,80,0,136,71,4,0,64,67,128,83,0,136,88,4,0,
128,80,0,64,83,192,68,0,64,65,128,81,0,64,85,128,78,0,64,67,73,76,19,149,
137,82,5,10,0,64,65,128,67,0,64,83,128,83,0,73,70,19,97,73,77,7,10,128,
71,0,128,65,0,64,86,128,71,0,73,67,20,38,201,72,8,13,0,128,82,0,64,65,128,
83,0,128,86,0,200,66,7,0,128,69,0,64,65,72,84,6,128,84,0,128,82,0,200,69,
13,0,72,83,6,128,71,0,128,70,0,64,68,137,76,5,14,0,72,73,6,128,83,0,128,
72,0,72,83,6,128,65,0,64,80,128,77,0,73,73,7,24,128,85,0,72,72,6,128,76,
0,64,71,72,82,6,128,67,0,128,68,0,72,75,6,128,77,0,128,74,0,201,83,30,127,
0,73,69,7,14,128,69,0,136,68,4,0,128,67,0,72,84,6,128,79,0,64,83,128,82,
0,73,79,27,74,73,83,9,16,64,79,128,67,0,136,71,4,0,128,65,0,64,87,64,65,
128,83,0,200,78,17,0,137,72,5,10,0,64,69,128,67,0,128,85,0,192,77,0,73,
81,7,18,128,86,0,137,76,5,8,0,128,65,0,128,80,0,72,87,6,128,70,0,128,83,
0,72,82,10,136,82,4,0,128,69,0,64,80,137,85,5,8,0,128,65,0,128,86,0,73,
86,13,26,64,65,136,77,4,0,128,65,0,72,85,8,64,83,128,65,0,64,84,128,83,
0,192,87,0,64,67,128,83,0,72,70,162,73,78,9,81,64,69,128,80,0,137,70,5,
42,0,73,67,19,26,73,69,9,12,64,76,128,84,0,128,67,0,128,73,0,64,65,64,77,
128,65,0,64,68,72,83,6,128,83,0,128,73,0,201,76,8,11,0,128,67,0,128,73,
0,64,77,137,73,5,14,0,72,72,6,128,65,0,128,68,0,128,80,0,201,83,14,40,0,
72,73,6,128,83,0,128,65,0,73,81,7,18,128,77,0,64,80,136,84,4,0,64,73,128,
65,0,192,82,0,64,65,128,71,0,136,86,4,0,192,84,0,73,80,13,26,136,83,4,0,
64,79,128,83,0,72,69,10,136,77,4,0,128,67,0,128,65,0,64,83,128,76,0,64,
69,73,78,9,121,64,69,128,69,0,73,70,7,61,128,76,0,73,67,25,40,73,77,7,18,
128,89,0,72,67,6,128,65,0,64,66,128,71,0,128,83,0,72,66,10,136,79,4,0,128,
68,0,64,65,128,83,0,72,69,6,128,83,0,64,68,192,65,0,128,82,0,73,76,21,40,
73,81,9,14,64,77,128,83,0,64,68,128,67,0,128,86,0,72,73,10,136,73,4,0,128,
71,0,64,71,136,70,4,0,128,65,0,64,77,64,69,136,68,4,0,128,65,0,73,83,13,
41,72,83,6,128,73,0,128,67,0,73,81,7,23,128,84,0,72,80,10,64,82,64,79,128,
77,0,192,79,0,128,67,0,64,82,128,73,0,73,87,9,20,64,82,128,67,0,72,86,6,
128,76,0,64,84,128,84,0,128,90,0,74,75,24,1,50,137,68,5,16,0,72,67,6,128,
84,0,64,66,128,79,0,128,81,0,73,73,174,246,73,77,9,86,64,73,128,67,0,73,
70,13,60,136,83,4,0,64,69,128,76,0,73,67,17,42,136,66,4,0,64,65,136,83,
4,0,128,82,0,72,66,10,136,71,4,0,128,65,0,64,65,137,74,5,8,0,128,65,0,64,
83,128,77,0,64,68,128,69,0,137,73,5,12,0,64,71,64,82,128,80,0,64,76,128,
67,0,201,82,16,43,0,137,79,5,8,0,128,69,0,128,82,0,73,79,7,20,128,80,0,
64,78,136,75,4,0,64,69,64,67,128,83,0,64,80,64,82,128,83,0,73,84,23,38,
137,73,5,12,0,136,70,4,0,128,67,0,136,79,4,0,128,77,0,64,83,73,73,7,10,
128,76,0,128,65,0,128,84,0,128,85,0,64,72,73,76,7,40,128,76,0,73,69,13,
24,72,68,6,128,71,0,128,65,0,72,68,6,128,73,0,64,67,128,73,0,64,73,136,
83,4,0,128,67,0,201,82,14,25,0,136,67,4,0,64,65,128,67,0,64,80,136,73,4,
0,64,72,128,68,0,64,83,128,65,0,64,74,73,67,7,21,128,67,0,200,66,9,0,64,
67,128,65,0,64,65,128,83,0,72,79,6,128,77,0,64,70,64,66,128,83,0,72,77,
166,73,78,9,95,64,76,128,80,0,73,69,17,77,73,67,7,10,128,87,0,128,65,0,
128,80,0,73,67,21,55,73,68,9,14,64,68,128,65,0,64,67,128,68,0,128,71,0,
64,66,137,77,5,19,0,201,73,8,11,0,128,71,0,128,65,0,128,76,0,72,82,10,64,
65,64,80,128,65,0,128,79,0,64,68,128,82,0,136,72,4,0,64,71,128,70,0,73,
84,15,59,136,78,4,0,64,65,64,76,128,65,0,201,82,14,39,0,136,68,4,0,64,67,
128,80,0,64,79,137,80,5,18,0,72,68,10,64,78,64,69,128,84,0,128,67,0,64,
84,128,65,0,64,83,128,75,0,72,87,6,128,65,0,128,86,0,64,76,73,73,35,90,
73,78,13,26,136,84,4,0,64,67,128,83,0,72,68,6,128,90,0,64,67,64,79,128,
83,0,64,83,128,80,0,73,68,17,38,137,75,5,8,0,128,68,0,64,82,128,83,0,72,
67,16,137,66,5,8,0,128,65,0,64,73,128,67,0,64,66,128,69,0,72,70,8,64,65,
128,65,0,64,69,64,83,64,71,128,79,0,137,80,5,21,0,200,79,9,0,64,75,128,
65,0,64,77,64,65,128,72,0,72,83,8,64,80,128,65,0,64,82,128,82,0,74,85,176,
4,197,73,77,13,83,136,77,4,0,64,65,128,80,0,73,70,21,56,72,79,6,128,82,
0,64,73,72,77,6,128,66,0,128,67,0,72,68,12,72,80,6,128,68,0,128,67,0,64,
67,73,79,7,16,128,77,0,72,76,6,128,65,0,128,68,0,64,89,128,83,0,72,76,9,
192,65,0,128,82,0,64,73,128,68,0,73,82,47,71,73,73,13,24,136,68,4,0,64,
65,128,83,0,72,69,6,128,83,0,64,65,128,77,0,64,79,72,78,10,64,67,64,65,
128,80,0,64,68,64,65,128,68,0,200,80,17,0,72,82,10,64,69,64,82,128,65,0,
128,76,0,64,79,64,79,128,84,0,72,85,6,128,71,0,64,83,136,80,4,0,64,65,128,
75,0,74,82,136,2,0,73,79,9,79,64,69,128,73,0,73,69,21,51,137,67,5,14,0,
64,65,64,68,64,69,128,82,0,128,87,0,73,67,19,24,73,73,7,10,128,83,0,128,
68,0,64,79,128,84,0,64,65,128,68,0,192,68,0,128,70,0,72,77,12,136,83,4,
0,64,69,128,83,0,64,73,64,83,128,65,0,73,84,25,37,73,80,7,18,128,83,0,72,
77,6,128,83,0,64,69,128,67,0,128,82,0,72,82,6,128,67,0,192,80,0,128,83,
0,136,87,4,0,64,85,72,78,6,128,84,0,128,70,0,74,80,204,1,83,73,73,39,116,
137,70,5,20,0,73,67,7,10,128,83,0,128,65,0,64,69,128,84,0,72,82,10,136,
66,4,0,128,65,0,64,76,128,73,0,73,69,13,54,136,76,4,0,64,65,128,84,0,201,
67,24,36,0,137,77,5,10,0,64,73,128,83,0,64,82,136,83,4,0,128,65,0,192,65,
0,64,67,136,84,4,0,128,65,0,64,68,128,77,0,137,71,5,14,0,64,70,136,82,4,
0,128,76,0,64,72,136,74,4,0,128,73,0,73,83,33,70,73,82,7,20,128,67,0,72,
68,6,128,84,0,64,67,64,79,128,82,0,72,88,6,128,69,0,128,83,0,73,79,13,16,
72,84,6,128,89,0,128,78,0,128,75,0,64,82,137,73,5,14,0,72,68,6,128,70,0,
128,66,0,64,79,128,77,0,72,87,10,136,80,4,0,128,78,0,128,85,0,64,79,73,
79,7,75,128,67,0,73,72,15,41,72,83,6,128,73,0,64,72,128,83,0,137,68,5,16,
0,72,66,6,128,84,0,64,65,128,84,0,192,70,0,136,84,4,0,128,66,0,73,76,9,
18,64,83,128,83,0,64,73,136,80,4,0,128,79,0,64,77,64,80,64,76,128,83,0,
73,83,15,37,136,76,4,0,64,68,64,73,128,83,0,137,81,5,10,0,64,80,128,70,
0,192,82,0,72,84,6,128,67,0,128,73,0,73,87,11,16,136,71,4,0,128,65,0,64,
84,128,83,0,64,89,128,67,0,64,81,73,73,9,18,64,84,128,83,0,136,70,4,0,64,
65,128,82,0,72,85,12,64,73,64,77,64,65,128,82,0,64,84,128,76,0,72,84,167,
73,78,7,93,128,90,0,201,70,18,63,0,137,69,5,8,0,128,65,0,64,84,128,80,0,
73,68,15,30,72,82,6,128,83,0,64,77,128,80,0,72,67,8,64,73,128,77,0,64,65,
64,67,128,77,0,64,69,72,89,6,128,65,0,64,69,64,65,128,80,0,73,76,7,20,128,
68,0,64,73,72,82,6,128,67,0,64,67,128,83,0,128,77,0,73,84,15,56,137,72,
5,8,0,128,66,0,128,85,0,73,82,13,32,72,84,6,128,79,0,128,73,0,72,81,6,128,
87,0,64,79,137,77,5,8,0,128,76,0,128,83,0,64,83,136,73,4,0,128,71,0,73,
86,7,12,128,69,0,64,85,128,67,0,128,87,0,64,83,73,77,15,178,72,84,6,128,
80,0,64,65,128,82,0,73,70,21,123,137,81,5,12,0,136,71,4,0,128,70,0,64,82,
128,73,0,73,67,35,75,73,79,7,20,128,78,0,137,66,5,10,0,64,65,128,80,0,128,
68,0,72,87,6,128,65,0,64,82,128,79,0,200,66,15,0,72,80,8,64,67,128,83,0,
128,76,0,64,65,73,73,9,18,64,69,128,71,0,64,65,64,77,64,76,128,71,0,64,
84,128,65,0,72,69,18,72,84,10,64,67,64,73,128,68,0,64,69,128,77,0,64,68,
136,80,4,0,128,77,0,73,73,19,32,73,67,7,10,128,77,0,128,65,0,64,73,128,
67,0,72,72,8,64,82,128,69,0,64,71,128,79,0,192,76,0,64,65,128,87,0,201,
83,26,130,0,137,78,5,14,0,136,70,4,0,64,65,128,80,0,64,83,64,65,128,84,
0,201,80,18,80,0,137,78,5,10,0,64,70,128,73,0,128,80,0,72,79,48,73,77,9,
24,64,65,128,82,0,73,67,9,12,64,65,128,80,0,128,65,0,128,76,0,73,82,11,
14,64,73,64,67,128,83,0,128,80,0,64,85,64,78,128,68,0,192,78,0,72,77,6,
128,80,0,64,69,128,84,0,64,82,137,68,5,12,0,136,67,4,0,128,66,0,200,73,
7,0,128,70,0,128,70,0,201,86,10,43,0,64,69,128,77,0,72,85,8,64,73,128,84,
0,64,84,73,73,13,18,136,70,4,0,64,69,128,77,0,64,67,128,80,0,64,84,128,
80,0,64,87,137,76,5,8,0,128,67,0,128,84,0,73,88,67,223,73,70,9,32,64,65,
128,84,0,73,66,11,18,136,83,4,0,128,66,0,64,65,64,70,128,83,0,64,67,128,
65,0,73,83,7,28,128,79,0,64,73,73,77,13,16,64,66,64,65,64,78,128,75,0,128,
70,0,128,78,0,128,87,0,72,87,81,73,77,11,45,136,72,4,0,128,65,0,201,71,
10,23,0,64,76,128,73,0,72,69,6,128,65,0,64,65,64,82,128,77,0,72,76,6,128,
82,0,64,73,128,77,0,73,83,7,18,128,65,0,72,82,6,128,77,0,64,81,128,76,0,
72,85,6,128,66,0,64,84,136,78,4,0,128,68,0,64,86,73,73,11,36,136,80,4,0,
128,67,0,73,67,11,20,136,73,4,0,128,65,0,136,66,4,0,64,65,128,84,0,64,70,
128,85,0,201,80,12,23,0,136,76,4,0,128,68,0,72,79,6,128,79,0,64,77,128,
83,0,192,82,0,72,83,8,64,73,128,71,0,128,68,0,72,90,8,64,76,128,78,0,64,
89,73,79,7,20,128,70,0,72,70,6,128,83,0,64,65,64,78,128,79,0,64,80,128,
83,0,82,75,3,133,39,215,74,77,53,2,53,73,77,7,30,128,71,0,73,73,11,16,136,
80,4,0,128,65,0,64,68,128,70,0,64,75,64,83,128,90,0,73,84,9,15,64,83,128,
65,0,192,83,0,128,83,0,128,87,0,74,71,26,1,40,73,78,7,16,128,69,0,72,73,
6,128,68,0,128,68,0,64,84,128,67,0,73,68,41,135,73,80,15,26,64,76,64,65,
64,89,64,69,128,82,0,137,69,5,8,0,128,67,0,128,70,0,72,83,6,128,83,0,64,
82,128,84,0,73,66,20,83,200,82,7,0,128,73,0,64,66,136,73,4,0,128,69,0,64,
65,137,72,5,34,0,73,68,11,24,64,69,64,87,128,69,0,72,67,8,64,83,128,84,
0,64,65,128,77,0,64,69,128,67,0,73,85,9,24,64,83,128,84,0,72,77,8,64,77,
128,73,0,64,73,64,83,128,84,0,128,86,0,64,67,64,69,136,84,4,0,128,75,0,
72,70,52,137,77,5,28,0,73,68,7,18,128,83,0,136,67,4,0,64,65,64,69,128,68,
0,64,70,128,67,0,73,85,9,18,64,80,128,77,0,136,81,4,0,64,79,128,82,0,128,
87,0,64,69,73,82,7,38,128,83,0,73,73,7,24,128,67,0,72,71,12,72,79,6,128,
67,0,128,71,0,64,70,128,77,0,64,80,64,67,128,79,0,137,84,5,12,0,64,83,64,
83,128,89,0,64,89,73,76,15,22,64,79,64,71,64,71,64,69,128,82,0,64,71,64,
69,128,78,0,64,77,64,65,128,78,0,73,74,11,105,136,87,4,0,128,86,0,72,73,
57,73,80,16,35,200,80,9,0,64,82,128,65,0,128,65,0,73,67,7,14,128,67,0,64,
65,64,68,128,66,0,64,68,128,80,0,73,84,11,14,136,84,4,0,128,76,0,128,83,
0,64,86,128,83,0,64,72,73,78,15,26,72,85,8,64,82,128,69,0,128,80,0,136,
68,4,0,64,66,64,66,128,83,0,72,88,6,128,67,0,128,82,0,72,76,66,73,79,9,
44,64,71,128,68,0,73,67,17,24,72,79,10,64,68,64,69,128,67,0,128,67,0,64,
65,64,65,128,67,0,64,73,72,85,6,128,67,0,128,65,0,72,85,6,128,71,0,64,83,
136,69,4,0,64,67,64,65,128,72,0,64,75,137,75,5,24,0,73,69,7,16,128,66,0,
64,66,136,83,4,0,128,65,0,128,70,0,137,82,5,10,0,64,78,128,68,0,64,83,136,
78,4,0,128,75,0,73,83,35,231,137,78,5,18,0,137,72,5,10,0,64,68,128,69,0,
128,76,0,72,85,8,64,65,128,69,0,64,83,128,78,0,73,80,62,181,73,74,11,45,
64,65,64,89,128,73,0,73,68,7,24,128,69,0,72,67,12,72,77,6,128,83,0,128,
66,0,64,65,128,73,0,192,73,0,136,90,4,0,128,68,0,137,84,5,10,0,64,80,128,
85,0,128,85,0,72,79,58,73,83,9,30,64,80,128,73,0,137,70,5,14,0,64,69,136,
82,4,0,128,79,0,64,73,64,67,128,65,0,72,87,10,64,65,64,78,128,73,0,64,84,
137,72,5,8,0,128,70,0,64,79,128,82,0,64,78,73,82,7,32,128,80,0,73,73,7,
20,128,80,0,72,67,8,64,65,128,80,0,64,65,128,66,0,64,76,128,65,0,73,85,
15,22,72,83,6,128,84,0,64,82,128,69,0,64,83,64,68,128,71,0,64,86,128,66,
0,72,82,8,64,67,128,76,0,64,81,64,77,128,76,0,73,86,23,82,73,77,7,14,128,
65,0,64,69,64,82,128,84,0,64,80,128,89,0,72,85,38,73,76,9,20,64,85,128,
65,0,72,73,6,128,80,0,64,69,128,84,0,72,82,10,64,73,64,77,128,83,0,64,78,
128,65,0,64,84,73,84,7,16,128,83,0,72,83,6,128,80,0,128,70,0,128,85,0,72,
89,6,128,67,0,64,87,72,73,6,128,67,0,128,70,0,82,73,21,232,31,22,82,77,
1,45,13,13,73,76,7,156,128,83,0,201,69,34,95,0,73,77,11,20,136,83,4,0,128,
67,0,136,73,4,0,64,71,128,65,0,136,84,4,0,64,82,128,69,0,73,67,18,44,72,
79,6,128,77,0,192,73,0,64,78,128,69,0,72,66,6,128,65,0,64,65,201,80,8,13,
0,128,73,0,64,70,128,80,0,64,84,128,83,0,64,68,137,78,5,12,0,136,72,4,0,
128,71,0,128,83,0,73,72,11,37,136,83,4,0,128,79,0,72,71,16,137,67,5,8,0,
128,65,0,64,77,128,73,0,192,70,0,136,84,4,0,128,67,0,64,73,73,78,7,10,128,
84,0,128,68,0,64,83,128,80,0,73,82,15,72,137,67,5,8,0,128,66,0,128,84,0,
73,79,7,36,128,78,0,72,78,10,64,83,64,72,128,79,0,64,77,72,66,6,128,73,
0,64,65,136,80,4,0,64,67,128,67,0,64,80,73,80,7,16,128,65,0,72,69,6,128,
83,0,128,66,0,128,90,0,73,84,27,62,73,70,7,20,128,69,0,136,67,4,0,64,65,
64,66,64,76,128,69,0,128,83,0,192,83,0,201,77,8,21,0,128,65,0,137,73,5,
8,0,128,71,0,64,76,128,80,0,72,86,6,128,65,0,64,80,128,72,0,64,87,128,79,
0,74,71,179,9,73,73,76,17,102,72,84,6,128,65,0,64,72,64,82,128,67,0,73,
68,7,48,128,65,0,73,66,11,24,136,84,4,0,128,80,0,64,65,136,68,4,0,64,67,
64,79,128,83,0,64,67,137,67,5,10,0,64,65,128,82,0,64,83,128,69,0,73,70,
23,30,73,69,7,16,128,84,0,72,66,6,128,80,0,128,65,0,128,77,0,64,69,64,84,
128,67,0,64,71,64,79,128,83,0,201,80,10,47,0,64,65,128,83,0,73,78,19,30,
137,78,5,10,0,64,67,128,65,0,64,79,128,85,0,64,77,136,80,4,0,64,73,128,
68,0,64,79,64,76,128,68,0,72,83,12,72,83,6,128,69,0,128,68,0,64,82,137,
80,5,8,0,128,70,0,128,84,0,74,68,239,6,206,201,76,22,127,0,73,84,7,14,128,
77,0,136,79,4,0,128,72,0,128,87,0,201,69,18,60,0,72,78,8,64,69,128,68,0,
64,77,128,65,0,73,67,17,37,73,69,7,10,128,69,0,128,67,0,128,84,0,72,66,
6,128,73,0,64,65,200,80,7,0,128,73,0,64,65,128,78,0,64,68,128,80,0,73,73,
25,34,137,81,5,18,0,72,77,6,128,67,0,64,67,64,83,128,79,0,128,83,0,136,
71,4,0,64,70,128,84,0,64,74,72,77,6,128,71,0,128,67,0,73,82,17,73,137,67,
5,10,0,64,65,128,67,0,128,80,0,73,79,15,51,64,83,136,73,4,0,64,69,128,82,
0,200,78,21,0,137,70,5,14,0,72,68,6,128,82,0,128,65,0,128,86,0,192,77,0,
72,69,6,128,70,0,192,65,0,128,78,0,64,80,128,70,0,73,85,7,29,128,71,0,200,
84,7,0,128,82,0,64,83,137,76,5,8,0,128,70,0,64,80,128,83,0,64,87,128,71,
0,202,66,237,3,4,0,137,77,5,122,0,73,69,11,77,136,88,4,0,128,87,0,201,67,
34,61,0,137,79,5,24,0,72,67,10,64,82,64,73,128,77,0,64,65,136,79,4,0,128,
77,0,64,83,128,71,0,72,66,6,128,70,0,64,65,137,78,5,14,0,136,69,4,0,64,
67,128,67,0,64,83,128,73,0,64,68,128,81,0,73,75,7,29,128,65,0,200,71,11,
0,136,80,4,0,128,69,0,64,70,136,84,4,0,64,65,128,78,0,64,76,136,70,4,0,
64,67,128,69,0,73,82,14,56,200,82,7,0,128,67,0,128,68,0,201,80,16,37,0,
72,84,8,64,83,128,69,0,128,80,0,72,79,12,136,88,4,0,64,84,128,89,0,64,78,
136,83,4,0,128,82,0,64,81,128,76,0,137,84,5,44,0,192,83,0,137,71,5,16,0,
72,70,6,128,67,0,64,69,128,82,0,72,84,14,72,82,6,128,71,0,64,80,128,73,
0,192,83,0,128,65,0,64,87,136,84,4,0,128,65,0,64,65,74,77,45,1,28,73,79,
7,30,128,84,0,73,67,11,16,136,82,4,0,128,80,0,64,65,128,84,0,64,69,64,82,
128,83,0,136,88,4,0,192,84,0,128,78,0,73,70,17,145,137,70,5,8,0,128,67,
0,64,73,128,83,0,73,67,35,81,73,69,7,18,128,84,0,72,67,6,128,80,0,64,66,
128,69,0,72,85,6,128,67,0,64,83,64,73,128,84,0,200,66,16,0,72,83,6,128,
69,0,192,67,0,128,65,0,64,65,137,70,5,16,0,72,69,6,128,82,0,64,67,128,77,
0,72,84,6,128,83,0,192,83,0,128,66,0,72,69,28,73,70,7,14,128,76,0,136,69,
4,0,128,65,0,64,83,72,84,6,128,69,0,128,66,0,64,68,73,73,7,14,128,83,0,
136,67,4,0,128,66,0,128,82,0,201,73,22,69,0,73,77,7,14,128,83,0,64,65,64,
66,128,67,0,128,83,0,72,72,30,137,67,5,18,0,72,66,6,128,69,0,64,65,64,73,
128,79,0,136,85,4,0,64,80,128,67,0,64,71,73,79,7,10,128,68,0,128,73,0,64,
84,128,79,0,64,76,137,67,5,16,0,64,65,72,78,6,128,65,0,128,70,0,64,69,64,
73,128,65,0,201,83,38,173,0,73,80,13,26,136,77,4,0,64,69,128,73,0,72,73,
10,136,71,4,0,128,65,0,128,66,0,64,83,64,73,128,68,0,73,80,39,91,137,78,
5,22,0,73,76,7,12,128,67,0,64,65,128,67,0,64,77,128,79,0,137,86,5,8,0,128,
80,0,64,87,128,83,0,72,79,20,73,77,7,14,128,84,0,136,67,4,0,128,66,0,128,
80,0,64,78,73,71,7,19,128,86,0,72,68,6,128,83,0,192,65,0,128,76,0,72,84,
6,128,68,0,64,83,128,65,0,72,82,24,73,80,7,16,128,65,0,72,69,6,128,80,0,
128,67,0,64,83,128,69,0,192,81,0,73,79,7,14,128,67,0,136,71,4,0,128,67,
0,128,83,0,73,86,25,67,137,73,5,16,0,136,69,4,0,64,67,64,69,128,73,0,64,
82,128,84,0,200,85,13,0,72,87,6,128,83,0,128,80,0,64,84,73,69,9,18,64,70,
128,76,0,72,66,6,128,82,0,128,65,0,72,83,6,128,69,0,128,80,0,64,87,64,65,
64,67,128,83,0,192,67,0,74,77,43,1,197,73,77,7,22,128,71,0,73,74,7,12,128,
69,0,64,67,128,73,0,128,76,0,72,83,6,128,70,0,192,80,0,136,68,4,0,128,65,
0,202,70,23,1,38,0,137,74,5,12,0,136,70,4,0,128,69,0,64,84,128,85,0,73,
67,71,216,73,73,10,41,192,68,0,128,68,0,73,67,7,22,128,77,0,72,66,6,128,
83,0,64,65,136,84,4,0,128,68,0,136,71,4,0,64,70,128,65,0,201,82,8,19,0,
128,71,0,72,80,6,128,82,0,64,78,128,67,0,64,86,64,65,128,77,0,72,66,20,
137,79,5,12,0,136,76,4,0,128,67,0,64,83,128,83,0,64,65,73,78,7,68,128,78,
0,73,72,7,39,128,68,0,73,66,7,21,128,82,0,192,65,0,137,78,5,8,0,128,67,
0,128,80,0,64,69,136,87,4,0,64,82,128,68,0,72,76,16,72,84,6,128,68,0,64,
82,64,82,128,68,0,192,73,0,128,67,0,73,83,29,40,137,79,5,14,0,72,69,6,128,
80,0,128,65,0,72,83,6,128,80,0,64,82,128,68,0,72,82,8,64,68,128,65,0,128,
79,0,72,87,8,64,80,128,73,0,64,84,64,65,128,68,0,72,69,34,73,76,7,24,128,
84,0,72,73,10,136,83,4,0,128,77,0,64,67,64,82,128,68,0,64,83,64,67,128,
82,0,64,68,73,67,7,16,128,83,0,136,66,4,0,64,65,128,82,0,128,68,0,73,73,
51,97,73,77,9,32,64,79,128,68,0,73,70,7,18,128,73,0,72,69,6,128,80,0,64,
68,128,72,0,64,72,128,83,0,137,82,5,10,0,64,80,128,69,0,64,83,128,70,0,
72,72,40,73,72,9,26,64,84,128,79,0,72,69,12,136,80,4,0,64,73,128,67,0,64,
65,128,84,0,72,82,6,128,80,0,64,77,128,84,0,192,71,0,128,78,0,72,76,16,
72,69,6,128,73,0,64,65,64,82,128,77,0,128,74,0,201,84,30,240,0,137,82,5,
12,0,136,80,4,0,128,74,0,136,89,4,0,64,83,136,73,4,0,128,68,0,201,80,34,
108,0,73,73,7,20,128,71,0,137,67,5,10,0,64,65,128,75,0,128,68,0,72,83,6,
128,82,0,128,79,0,72,79,46,73,77,9,30,64,79,128,83,0,137,67,5,12,0,64,66,
64,84,128,69,0,64,76,136,68,4,0,128,67,0,72,84,6,128,89,0,64,82,64,73,128,
65,0,64,78,73,73,9,23,64,82,128,80,0,136,68,4,0,192,65,0,136,83,4,0,128,
70,0,128,76,0,72,83,53,73,76,7,20,128,80,0,137,71,5,8,0,128,67,0,64,73,
128,68,0,201,80,8,13,0,128,80,0,64,79,128,77,0,64,83,73,80,7,12,128,69,
0,64,73,128,83,0,128,82,0,64,82,73,73,21,32,137,78,5,10,0,64,69,128,82,
0,64,83,64,65,128,84,0,137,70,5,8,0,128,67,0,128,71,0,137,80,5,10,0,64,
77,128,87,0,64,83,128,69,0,73,87,11,22,136,77,4,0,128,69,0,136,86,4,0,64,
85,64,77,128,84,0,72,90,6,128,77,0,64,89,64,69,128,80,0,80,70,1,28,73,77,
27,191,73,73,11,20,136,83,4,0,128,70,0,72,67,6,128,65,0,128,65,0,128,83,
0,73,72,9,131,64,77,128,67,0,73,69,27,85,73,69,7,18,128,83,0,72,66,6,128,
65,0,64,65,128,68,0,64,84,128,83,0,200,67,29,0,73,77,7,16,128,80,0,72,69,
6,128,66,0,128,67,0,136,80,4,0,64,78,128,82,0,64,65,73,78,9,20,64,67,128,
65,0,137,67,5,8,0,128,66,0,128,68,0,136,87,4,0,128,86,0,64,70,73,73,7,22,
128,80,0,73,70,7,10,128,83,0,128,68,0,64,72,128,83,0,137,82,5,10,0,64,76,
128,65,0,128,84,0,137,74,5,24,0,64,73,137,75,5,14,0,72,67,6,128,83,0,128,
65,0,128,80,0,64,76,136,76,4,0,128,65,0,73,82,29,66,73,82,7,18,128,79,0,
72,73,6,128,67,0,64,67,128,83,0,136,87,4,0,128,83,0,73,80,25,32,73,82,7,
16,128,73,0,72,77,6,128,65,0,128,73,0,64,85,128,71,0,64,79,64,65,128,77,
0,64,81,128,67,0,73,85,11,20,64,79,64,67,128,78,0,64,83,136,82,4,0,128,
76,0,128,86,0,192,69,0,73,78,7,82,128,83,0,73,69,21,55,137,77,5,8,0,128,
69,0,64,80,136,79,4,0,128,65,0,201,67,10,26,0,64,68,128,77,0,192,65,0,137,
75,5,8,0,128,67,0,64,82,128,78,0,64,68,192,77,0,128,83,0,72,76,13,200,84,
7,0,128,83,0,128,83,0,64,73,64,67,128,69,0,73,83,30,57,73,78,7,16,128,65,
0,136,71,4,0,64,66,128,65,0,136,83,4,0,192,79,0,128,76,0,72,82,14,72,82,
6,128,79,0,64,69,128,83,0,64,80,72,82,8,64,69,128,80,0,128,73,0,72,88,17,
64,80,64,76,64,79,64,82,192,69,0,128,82,0,64,84,137,70,5,8,0,128,65,0,128,
80,0,74,74,94,1,181,137,77,5,60,0,73,68,9,34,64,65,128,82,0,72,67,18,73,
73,7,12,128,83,0,64,65,128,73,0,128,86,0,64,65,64,66,128,73,0,72,73,18,
72,83,8,64,76,128,77,0,64,67,64,73,128,67,0,128,71,0,73,83,13,26,136,79,
4,0,64,66,128,65,0,72,82,8,64,84,128,69,0,64,78,128,76,0,128,87,0,72,73,
238,73,74,7,124,128,83,0,73,69,22,79,137,76,5,12,0,136,70,4,0,128,68,0,
192,80,0,128,84,0,73,67,37,52,73,73,7,24,128,83,0,72,67,10,64,77,64,69,
128,82,0,64,65,64,80,128,83,0,72,82,6,128,67,0,128,77,0,72,66,8,64,76,128,
80,0,64,65,64,83,128,65,0,64,68,128,72,0,73,72,11,30,136,83,4,0,128,70,
0,136,71,4,0,64,70,137,80,5,8,0,128,77,0,64,83,128,79,0,64,73,192,77,0,
128,70,0,73,80,11,37,136,85,4,0,128,65,0,73,78,7,21,128,83,0,72,77,6,128,
71,0,192,76,0,64,80,128,83,0,64,79,128,80,0,73,84,7,53,128,69,0,72,83,30,
73,69,13,20,136,82,4,0,64,80,128,82,0,136,68,4,0,128,67,0,136,83,4,0,128,
73,0,64,82,200,79,7,0,128,67,0,64,73,64,82,128,65,0,64,85,137,71,5,16,0,
72,69,8,64,80,128,83,0,128,67,0,128,77,0,64,72,73,80,9,46,64,86,128,65,
0,73,75,9,22,64,73,128,66,0,73,69,7,10,128,85,0,128,68,0,128,71,0,72,79,
6,128,80,0,64,77,136,76,4,0,128,70,0,137,84,5,48,0,72,83,12,136,71,4,0,
64,66,128,77,0,64,82,73,82,7,18,128,65,0,72,78,6,128,65,0,64,76,128,71,
0,72,84,6,128,80,0,64,83,128,65,0,72,87,6,128,79,0,128,86,0,72,76,179,73,
73,9,84,64,65,128,67,0,73,69,11,48,136,67,4,0,128,65,0,73,66,15,30,72,79,
8,64,71,128,77,0,128,67,0,64,65,73,68,7,10,128,83,0,128,67,0,128,69,0,64,
67,64,79,128,82,0,73,71,13,18,72,87,6,128,85,0,128,65,0,64,70,128,67,0,
64,72,64,73,64,77,128,65,0,73,84,22,63,137,77,5,13,0,192,67,0,64,73,128,
80,0,64,80,128,69,0,73,82,7,12,128,73,0,64,79,128,77,0,64,83,73,72,15,24,
64,73,64,66,64,65,64,77,128,70,0,136,67,4,0,64,65,128,67,0,128,82,0,73,
87,13,22,136,84,4,0,64,73,128,83,0,64,85,136,67,4,0,128,65,0,64,90,64,83,
128,71,0,64,75,137,74,5,28,0,137,69,5,18,0,72,66,8,64,76,128,67,0,64,65,
128,71,0,64,73,128,77,0,73,85,7,12,128,69,0,64,77,128,70,0,64,87,128,67,
0,202,84,203,7,32,0,73,77,11,87,136,85,4,0,128,83,0,73,70,13,50,136,83,
4,0,64,69,128,84,0,73,67,7,28,128,90,0,72,66,6,128,69,0,64,65,73,67,7,10,
128,71,0,128,65,0,128,82,0,64,69,136,83,4,0,128,82,0,73,73,15,18,137,76,
5,8,0,128,70,0,128,78,0,128,71,0,64,76,192,66,0,128,86,0,73,83,24,76,201,
77,12,17,0,136,70,4,0,128,65,0,64,66,128,73,0,128,80,0,73,80,22,31,200,
79,9,0,64,69,128,83,0,64,71,64,82,64,70,128,65,0,64,79,64,85,64,67,128,
72,0,64,82,137,73,5,12,0,136,70,4,0,128,69,0,136,84,4,0,128,83,0,201,85,
18,29,0,137,67,5,10,0,64,65,128,77,0,128,80,0,64,84,136,79,4,0,64,70,128,
65,0,64,87,128,84,0,202,81,19,3,117,0,72,85,10,64,69,64,82,128,89,0,128,
83,0,74,79,177,2,70,73,77,13,89,136,80,4,0,64,77,128,85,0,73,69,7,55,128,
72,0,201,67,24,37,0,137,80,5,14,0,72,79,6,128,73,0,128,67,0,64,82,128,73,
0,64,65,136,84,4,0,64,80,64,73,128,67,0,64,68,136,80,4,0,64,69,128,70,0,
73,72,7,14,128,69,0,64,71,64,75,128,70,0,64,76,64,84,128,65,0,201,84,12,
70,0,136,80,4,0,128,67,0,73,82,7,18,128,69,0,64,80,72,83,6,128,65,0,128,
76,0,192,83,0,73,68,7,20,128,67,0,137,66,5,8,0,128,65,0,64,67,128,79,0,
73,79,7,10,128,84,0,128,72,0,64,83,64,75,128,65,0,72,87,8,64,77,128,69,
0,64,86,128,83,0,64,78,73,77,13,217,136,78,4,0,64,69,128,84,0,73,70,13,
159,64,79,64,83,64,69,128,67,0,73,68,27,112,137,84,5,16,0,72,79,6,128,84,
0,64,69,128,70,0,64,85,64,82,128,69,0,72,67,60,73,73,9,26,64,84,128,83,
0,137,66,5,10,0,64,65,128,65,0,64,69,64,73,128,70,0,73,81,7,26,128,67,0,
64,79,72,84,12,64,69,64,82,64,77,128,83,0,64,83,128,69,0,64,83,128,82,0,
64,65,73,77,9,18,64,72,128,73,0,136,72,4,0,64,69,128,83,0,64,83,128,80,
0,64,69,73,71,7,25,128,73,0,201,67,8,13,0,128,69,0,64,65,128,83,0,64,69,
128,76,0,136,78,4,0,128,73,0,73,75,11,36,64,83,64,78,128,65,0,64,73,73,
70,9,16,64,65,128,80,0,64,66,64,65,128,80,0,64,84,64,82,128,68,0,64,76,
136,68,4,0,128,65,0,73,82,15,67,72,77,6,128,80,0,64,69,128,86,0,73,80,22,
41,201,69,8,13,0,128,65,0,64,65,128,83,0,64,70,128,76,0,72,79,12,64,71,
64,65,64,84,128,69,0,64,78,64,85,128,65,0,64,81,64,65,64,65,64,72,128,69,
0,73,84,73,114,137,72,5,32,0,73,66,9,16,64,65,128,85,0,64,65,64,83,128,
67,0,64,69,64,82,64,78,64,73,128,67,0,73,82,11,20,64,73,64,67,128,84,0,
64,79,64,83,64,65,128,73,0,64,83,72,80,8,64,69,128,73,0,64,69,64,82,128,
86,0,64,83,73,78,7,22,128,65,0,137,71,5,12,0,64,67,64,79,128,77,0,128,77,
0,72,84,8,64,79,128,82,0,64,80,64,65,64,83,128,83,0,64,89,128,83,0,192,
80,0,73,77,17,137,73,66,7,10,128,65,0,128,65,0,128,73,0,201,71,10,86,0,
64,82,128,73,0,73,68,7,35,128,83,0,72,67,20,137,73,5,14,0,72,68,6,128,78,
0,128,67,0,128,80,0,192,66,0,64,65,128,83,0,72,70,16,136,85,4,0,64,83,64,
65,64,80,128,72,0,64,69,73,69,7,16,128,67,0,72,68,6,128,83,0,128,65,0,64,
80,64,65,128,67,0,73,75,7,25,128,70,0,72,73,10,64,69,64,67,128,65,0,64,
72,192,67,0,128,65,0,64,76,64,80,64,68,128,78,0,73,82,17,84,72,69,10,136,
77,4,0,128,68,0,128,65,0,201,80,45,62,0,73,80,9,25,64,83,128,72,0,137,70,
5,11,0,192,67,0,128,82,0,64,78,128,87,0,73,84,7,10,128,70,0,128,82,0,64,
85,128,67,0,136,79,4,0,64,78,137,73,5,8,0,128,71,0,128,86,0,64,81,128,80,
0,201,85,10,57,0,64,77,128,83,0,72,84,26,137,70,5,14,0,72,69,6,128,75,0,
128,67,0,64,79,64,79,64,76,128,83,0,192,83,0,73,77,7,15,128,79,0,64,65,
192,83,0,128,66,0,128,78,0,128,89,0,80,83,2,21,74,76,28,1,51,137,82,5,16,
0,72,76,6,128,67,0,64,73,128,83,0,64,83,64,67,128,80,0,201,70,24,213,0,
73,73,7,12,128,84,0,64,69,128,84,0,64,76,64,83,128,72,0,73,67,45,124,73,
83,7,32,128,73,0,73,69,13,18,136,68,4,0,64,66,128,83,0,64,67,128,80,0,64,
82,64,65,128,84,0,136,87,4,0,64,84,128,73,0,72,66,18,137,78,5,12,0,136,
68,4,0,128,67,0,128,80,0,192,65,0,73,71,11,33,136,79,4,0,128,65,0,73,67,
11,16,136,70,4,0,128,65,0,64,65,128,65,0,192,70,0,128,80,0,73,80,11,18,
136,79,4,0,128,73,0,64,75,64,77,128,80,0,64,84,64,65,128,80,0,72,69,36,
137,70,5,22,0,72,68,10,136,78,4,0,128,67,0,64,67,64,79,128,77,0,136,87,
4,0,64,83,64,67,128,79,0,64,68,73,69,7,20,128,70,0,137,66,5,8,0,128,65,
0,64,67,128,84,0,136,82,4,0,128,78,0,73,73,24,45,137,78,5,15,0,136,70,4,
0,192,67,0,128,67,0,64,82,128,73,0,72,72,12,136,83,4,0,64,82,128,83,0,64,
71,64,79,64,84,128,84,0,72,75,16,72,77,6,128,69,0,64,67,64,79,128,78,0,
64,74,128,80,0,73,83,79,178,73,81,7,42,128,78,0,73,73,7,26,128,68,0,73,
67,11,16,136,82,4,0,128,67,0,64,65,128,70,0,128,70,0,72,80,6,128,68,0,128,
78,0,137,85,5,20,0,72,84,6,128,65,0,64,83,64,69,64,69,128,77,0,72,87,8,
64,83,128,72,0,64,86,128,68,0,73,79,13,40,72,68,6,128,69,0,128,67,0,72,
78,12,136,83,4,0,64,73,128,69,0,64,77,72,82,6,128,77,0,64,70,64,79,128,
70,0,72,82,33,137,79,5,21,0,201,67,10,13,0,64,84,128,78,0,128,66,0,128,
69,0,136,84,4,0,64,83,128,69,0,192,80,0,73,79,7,18,128,82,0,72,78,6,128,
79,0,64,76,128,67,0,64,82,128,83,0,201,86,8,37,0,128,67,0,72,85,6,128,80,
0,64,84,73,81,7,16,128,66,0,72,77,6,128,65,0,128,67,0,64,84,128,70,0,64,
87,64,65,128,75,0,64,82,137,76,5,141,0,73,69,17,93,137,71,5,10,0,64,68,
128,73,0,128,77,0,201,67,30,64,0,73,78,7,18,128,83,0,72,72,8,64,83,128,
83,0,128,70,0,64,83,64,69,128,84,0,200,66,7,0,128,77,0,64,65,73,84,9,22,
64,68,128,69,0,72,80,6,128,77,0,64,68,64,73,128,79,0,128,87,0,64,68,200,
83,7,0,128,78,0,128,80,0,73,71,9,22,64,83,128,80,0,64,70,136,83,4,0,64,
67,64,65,128,77,0,64,73,137,71,5,14,0,72,69,6,128,67,0,128,66,0,64,83,128,
76,0,201,82,14,40,0,72,82,6,128,76,0,128,73,0,73,78,9,15,64,83,128,83,0,
192,77,0,128,67,0,64,79,136,83,4,0,64,77,128,65,0,73,84,7,15,128,70,0,192,
83,0,64,69,128,83,0,64,85,128,65,0,74,87,135,1,88,73,76,15,74,72,80,6,128,
67,0,64,65,128,78,0,73,70,7,28,128,65,0,73,66,9,16,64,84,128,71,0,64,65,
64,65,128,67,0,64,67,128,79,0,73,72,15,26,136,67,4,0,64,66,64,89,128,68,
0,64,71,136,80,4,0,64,73,128,65,0,64,74,128,71,0,73,83,19,44,137,82,5,12,
0,136,67,4,0,128,65,0,128,83,0,73,80,11,20,136,82,4,0,128,77,0,64,77,136,
73,4,0,128,67,0,64,82,128,77,0,200,87,7,0,128,69,0,64,85,128,70,0,72,86,
70,73,72,7,46,128,83,0,73,68,7,28,128,67,0,72,67,10,136,77,4,0,128,69,0,
64,65,136,87,4,0,64,67,128,71,0,136,70,4,0,64,69,64,67,128,79,0,73,79,7,
18,128,83,0,72,77,6,128,68,0,64,76,128,80,0,128,82,0,192,85,0,73,73,13,
63,72,80,6,128,67,0,128,68,0,73,70,11,35,136,83,4,0,128,77,0,73,67,11,18,
136,86,4,0,128,78,0,64,66,64,77,128,66,0,192,69,0,128,70,0,72,72,6,128,
70,0,64,71,136,83,4,0,128,71,0,73,82,7,54,128,68,0,73,79,13,30,72,77,6,
128,65,0,128,69,0,64,77,137,68,5,10,0,64,65,128,66,0,64,82,128,83,0,64,
80,72,85,6,128,73,0,64,65,136,80,4,0,128,67,0,72,87,8,64,78,128,69,0,64,
83,136,87,4,0,64,84,128,73,0,72,90,10,64,79,64,78,128,69,0,64,89,73,73,
7,42,128,69,0,73,68,13,24,136,85,4,0,64,69,128,89,0,72,67,6,128,69,0,64,
65,128,70,0,72,72,6,128,70,0,64,70,128,69,0,73,80,13,28,136,84,4,0,64,65,
128,69,0,72,77,6,128,69,0,64,75,64,87,64,73,128,77,0,72,84,6,128,67,0,64,
83,128,69,0,64,72,74,78,63,5,203,73,80,7,36,128,80,0,73,76,7,22,128,67,
0,72,66,6,128,65,0,64,65,136,83,4,0,128,80,0,64,79,64,68,128,83,0,73,87,
7,19,128,73,0,136,84,4,0,192,83,0,64,67,128,67,0,128,89,0,74,71,72,3,77,
73,76,7,38,128,77,0,73,70,7,24,128,83,0,73,67,7,12,128,65,0,64,65,128,65,
0,64,69,128,67,0,136,73,4,0,128,72,0,73,83,7,20,128,84,0,72,80,10,136,83,
4,0,128,80,0,128,77,0,136,86,4,0,64,84,128,69,0,202,68,156,1,253,0,73,77,
15,82,137,73,5,8,0,128,70,0,128,76,0,73,69,7,41,128,77,0,73,67,11,28,136,
80,4,0,128,68,0,192,65,0,137,79,5,8,0,128,68,0,192,80,0,128,83,0,192,68,
0,128,67,0,73,72,7,12,128,80,0,64,70,128,67,0,192,76,0,137,68,5,8,0,128,
67,0,128,77,0,201,83,24,46,0,136,80,4,0,64,69,64,78,64,84,64,73,64,78,64,
69,128,76,0,73,80,7,12,128,67,0,64,79,128,80,0,192,82,0,136,76,4,0,128,
73,0,200,86,11,0,136,80,4,0,128,77,0,64,84,136,86,4,0,64,68,128,82,0,73,
66,79,237,73,73,12,52,192,71,0,64,68,128,65,0,73,68,7,35,128,73,0,72,67,
22,137,73,5,12,0,136,69,4,0,128,68,0,136,85,4,0,128,84,0,192,65,0,128,79,
0,64,70,128,76,0,73,79,7,20,128,83,0,72,77,6,128,67,0,64,76,64,69,128,68,
0,128,86,0,64,65,73,78,15,95,64,65,64,75,64,73,64,77,128,73,0,73,69,11,
55,136,83,4,0,128,68,0,201,67,26,39,0,73,82,7,18,128,80,0,72,77,6,128,80,
0,64,67,128,80,0,128,85,0,64,65,72,82,6,128,80,0,64,68,128,70,0,64,68,128,
83,0,73,75,7,12,128,73,0,64,70,128,67,0,64,77,137,80,5,8,0,128,76,0,128,
82,0,73,86,7,34,128,80,0,73,83,15,20,72,84,8,64,65,128,67,0,128,76,0,64,
82,128,79,0,64,84,64,73,128,73,0,72,90,22,73,77,9,14,64,65,128,84,0,64,
73,128,68,0,64,79,128,80,0,64,87,128,88,0,192,67,0,73,73,9,57,64,77,128,
65,0,73,69,9,35,64,82,128,65,0,73,67,11,20,136,73,4,0,128,66,0,64,66,136,
86,4,0,128,83,0,192,68,0,128,71,0,136,71,4,0,64,70,136,66,4,0,128,65,0,
73,85,7,44,128,80,0,73,82,13,32,136,80,4,0,64,68,128,73,0,64,77,137,76,
5,12,0,136,71,4,0,128,67,0,64,84,128,73,0,64,83,128,66,0,72,87,6,128,72,
0,192,86,0,128,70,0,72,70,102,73,76,7,58,128,69,0,73,70,7,28,128,83,0,73,
68,7,12,128,83,0,64,67,128,83,0,64,69,136,84,4,0,128,65,0,72,73,18,136,
82,4,0,64,78,64,84,64,79,64,83,128,67,0,64,72,128,73,0,73,82,7,27,128,82,
0,137,79,5,10,0,64,77,128,68,0,192,80,0,136,80,4,0,128,65,0,136,87,4,0,
192,83,0,136,83,4,0,128,67,0,64,69,73,78,7,83,128,69,0,73,73,9,50,64,83,
128,66,0,73,70,13,32,64,67,136,87,4,0,128,69,0,72,69,10,64,65,64,67,128,
84,0,64,67,136,83,4,0,128,77,0,64,71,136,79,4,0,128,65,0,73,76,9,18,64,
79,128,67,0,64,75,64,65,64,83,128,73,0,64,77,192,84,0,128,84,0,73,84,9,
62,64,65,128,67,0,73,82,9,30,64,70,128,80,0,72,80,12,72,67,6,128,65,0,128,
65,0,64,79,136,80,4,0,128,65,0,64,83,137,68,5,14,0,72,67,6,128,65,0,128,
65,0,136,80,4,0,128,72,0,137,86,5,8,0,128,85,0,64,88,64,84,128,69,0,202,
75,112,1,130,0,73,77,7,54,128,71,0,73,70,9,28,64,82,128,83,0,136,68,4,0,
64,67,137,82,5,10,0,64,69,128,67,0,128,85,0,72,76,8,64,85,128,71,0,64,73,
72,70,6,128,70,0,128,65,0,73,84,13,45,72,68,6,128,67,0,128,66,0,72,83,27,
137,69,5,19,0,72,67,6,128,83,0,64,65,192,82,0,128,71,0,64,84,128,80,0,64,
78,128,67,0,64,85,64,83,128,84,0,72,73,242,73,73,19,105,137,68,5,12,0,64,
67,64,65,128,80,0,128,84,0,73,68,21,70,72,84,6,128,65,0,64,69,64,77,64,
89,64,73,128,80,0,201,66,31,44,0,201,77,10,19,0,64,73,128,83,0,72,73,6,
128,77,0,128,71,0,64,82,64,73,128,83,0,64,65,136,83,4,0,64,82,64,67,128,
83,0,64,67,128,80,0,200,71,7,0,128,90,0,64,70,136,85,4,0,128,79,0,73,82,
27,112,73,82,7,18,128,83,0,72,73,8,64,83,128,69,0,128,70,0,64,83,128,80,
0,73,78,27,48,73,68,11,18,64,82,64,65,128,70,0,64,65,64,82,128,73,0,64,
70,128,79,0,64,77,73,83,7,14,128,83,0,64,65,64,82,128,83,0,64,89,128,77,
0,64,80,73,73,7,20,128,80,0,137,67,5,10,0,64,65,128,65,0,128,71,0,73,80,
7,12,128,73,0,64,77,128,73,0,128,83,0,200,86,11,0,64,67,64,79,128,69,0,
64,84,72,69,6,128,88,0,128,66,0,64,72,137,73,5,16,0,72,72,8,64,79,128,70,
0,128,68,0,200,83,9,0,64,82,128,83,0,64,77,128,73,0,72,77,105,201,79,16,
66,0,64,78,64,73,64,84,64,79,128,82,0,73,71,7,31,128,66,0,200,67,7,0,128,
87,0,64,65,73,84,7,10,128,87,0,128,67,0,64,85,128,83,0,72,77,16,137,82,
5,8,0,128,70,0,64,87,128,86,0,128,73,0,73,83,15,30,137,73,5,8,0,128,65,
0,128,79,0,72,82,10,136,71,4,0,128,67,0,64,80,128,67,0,192,86,0,128,67,
0,192,76,0,73,77,7,56,128,86,0,73,68,17,40,137,83,5,8,0,128,73,0,64,86,
128,84,0,72,67,10,64,67,64,65,128,68,0,64,65,137,69,5,8,0,128,65,0,128,
72,0,192,72,0,192,83,0,128,82,0,73,83,15,18,137,83,5,8,0,128,76,0,128,87,
0,128,82,0,64,85,64,82,128,66,0,74,85,85,2,195,73,76,7,49,128,67,0,73,67,
7,24,128,69,0,72,66,12,64,90,64,79,64,78,128,69,0,64,65,128,67,0,72,75,
6,128,77,0,192,68,0,136,70,4,0,64,67,128,67,0,73,84,9,24,64,73,128,76,0,
72,80,6,128,79,0,64,77,64,73,64,78,128,84,0,64,86,64,69,128,67,0,202,82,
138,1,120,0,73,79,11,61,136,86,4,0,128,83,0,201,69,10,32,0,64,79,128,67,
0,73,67,7,12,128,80,0,64,65,128,70,0,192,68,0,136,81,4,0,128,67,0,73,76,
7,12,128,78,0,64,73,128,83,0,192,77,0,128,83,0,201,84,14,49,0,136,70,4,
0,64,69,128,77,0,73,81,13,18,72,79,6,128,76,0,128,76,0,64,80,128,69,0,64,
83,137,71,5,12,0,136,67,4,0,128,65,0,128,85,0,200,87,11,0,64,76,64,82,128,
70,0,64,85,72,80,6,128,80,0,128,71,0,201,80,164,223,0,201,76,14,95,0,72,
73,6,128,80,0,128,67,0,73,70,7,56,128,83,0,73,68,11,44,136,82,4,0,128,79,
0,200,67,19,0,73,83,7,10,128,65,0,128,82,0,64,85,128,83,0,64,65,72,78,6,
128,65,0,192,73,0,128,82,0,64,69,128,84,0,73,72,11,22,136,84,4,0,128,68,
0,64,71,136,76,4,0,64,66,128,67,0,128,75,0,73,83,15,46,72,83,6,128,83,0,
64,67,128,71,0,73,80,19,24,137,68,5,10,0,64,65,128,69,0,64,73,128,77,0,
64,77,128,77,0,64,82,64,80,128,83,0,201,86,8,13,0,128,79,0,64,85,128,83,
0,64,87,128,80,0,64,79,73,80,7,34,128,79,0,73,77,17,24,136,77,4,0,64,69,
64,80,64,78,128,65,0,64,76,64,65,128,80,0,128,78,0,137,86,5,16,0,64,84,
136,85,4,0,64,65,128,83,0,64,87,64,73,128,83,0,64,81,73,84,7,10,128,83,
0,128,76,0,128,86,0,200,84,54,0,73,72,7,29,128,83,0,201,67,12,19,0,64,80,
64,67,128,80,0,136,66,4,0,128,65,0,128,70,0,73,80,7,18,128,67,0,72,76,6,
128,86,0,64,73,128,66,0,128,86,0,64,83,73,79,13,99,72,80,6,128,65,0,128,
71,0,73,69,15,59,72,83,6,128,67,0,64,69,128,80,0,73,67,10,25,192,83,0,128,
68,0,72,66,6,128,67,0,64,65,64,82,64,80,128,65,0,64,68,137,76,5,12,0,136,
68,4,0,128,66,0,64,80,128,65,0,73,76,13,22,72,68,6,128,65,0,128,65,0,72,
73,6,128,76,0,128,72,0,64,77,128,80,0,73,84,19,72,137,82,5,12,0,136,80,
4,0,128,67,0,128,83,0,73,82,7,40,128,80,0,72,81,6,128,76,0,64,80,137,72,
5,20,0,72,68,12,72,80,6,128,65,0,128,65,0,128,65,0,64,86,128,65,0,64,83,
137,71,5,8,0,128,69,0,128,73,0,137,86,5,16,0,64,85,136,83,4,0,64,80,128,
65,0,128,87,0,73,88,15,117,72,87,8,64,88,128,68,0,128,72,0,72,87,25,73,
73,11,16,136,77,4,0,128,67,0,64,68,128,80,0,192,77,0,128,80,0,192,86,0,
73,73,18,42,72,71,8,64,66,128,84,0,192,67,0,128,67,0,201,68,8,19,0,128,
67,0,72,67,6,128,67,0,64,65,128,67,0,64,71,128,78,0,73,83,11,27,136,80,
4,0,128,67,0,200,80,7,0,128,83,0,64,76,136,83,4,0,128,80,0,64,84,128,78,
0,72,208,18,64,152,64,208,64,152,64,208,64,161,64,208,128,164,0,64,89,73,
73,7,14,128,80,0,64,67,64,79,128,77,0,64,86,64,69,128,84,0,64,74,74,76,
43,3,49,137,79,5,23,0,73,73,9,12,64,67,128,65,0,128,65,0,192,76,0,128,77,
0,137,82,5,10,0,64,80,128,84,0,64,84,128,86,0,74,70,42,2,29,73,74,7,24,
128,79,0,73,69,7,12,128,84,0,64,68,128,80,0,64,73,128,70,0,73,82,7,10,128,
83,0,128,75,0,128,83,0,74,67,87,1,102,201,77,8,57,0,128,84,0,73,73,13,46,
136,70,4,0,64,67,128,83,0,72,69,10,136,79,4,0,128,77,0,64,65,73,72,7,16,
128,79,0,136,68,4,0,64,67,128,83,0,64,83,128,65,0,128,75,0,73,86,11,22,
136,77,4,0,128,68,0,64,79,64,84,136,89,4,0,128,68,0,128,87,0,72,66,55,73,
77,9,33,64,73,128,65,0,73,70,9,14,64,67,128,83,0,64,65,128,82,0,192,73,
0,136,83,4,0,128,67,0,73,80,9,16,64,72,128,72,0,64,79,64,87,128,83,0,128,
82,0,64,65,73,77,13,110,72,79,6,128,78,0,128,65,0,201,71,8,58,0,128,77,
0,73,69,7,41,128,65,0,72,67,11,192,83,0,64,69,128,83,0,64,65,73,79,7,18,
128,83,0,72,77,6,128,73,0,64,67,128,84,0,128,83,0,64,70,136,90,4,0,128,
73,0,73,75,9,34,64,73,128,77,0,72,74,6,128,67,0,64,73,73,77,7,12,128,65,
0,64,68,128,83,0,64,83,128,84,0,64,76,128,84,0,73,84,17,70,137,79,5,10,
0,64,73,128,77,0,128,80,0,73,82,7,18,128,78,0,72,80,6,128,87,0,64,79,128,
83,0,64,83,73,83,15,26,137,79,5,8,0,128,77,0,128,83,0,72,77,6,128,65,0,
64,69,128,84,0,64,87,64,73,128,67,0,73,86,11,17,64,65,64,67,128,67,0,192,
85,0,128,83,0,64,88,137,80,5,12,0,136,77,4,0,128,66,0,128,82,0,72,69,84,
73,79,11,50,136,83,4,0,128,76,0,73,68,19,26,72,87,10,64,65,64,82,128,68,
0,64,69,128,67,0,64,67,64,70,128,65,0,64,73,72,84,6,128,65,0,64,68,128,
65,0,72,84,12,72,82,6,128,79,0,128,80,0,64,83,137,67,5,12,0,64,65,64,69,
128,88,0,64,78,128,65,0,64,68,137,76,5,30,0,137,70,5,16,0,72,68,6,128,77,
0,64,65,128,77,0,136,75,4,0,64,73,128,67,0,73,82,7,16,128,70,0,136,79,4,
0,64,77,128,75,0,72,87,6,128,80,0,128,84,0,73,73,135,204,73,76,7,61,128,
84,0,73,69,11,41,64,88,64,80,128,79,0,73,67,11,18,136,84,4,0,128,65,0,64,
65,64,69,128,65,0,192,68,0,72,80,6,128,79,0,128,70,0,72,71,8,64,68,128,
79,0,64,70,128,69,0,73,82,11,36,64,67,64,65,128,83,0,72,80,14,72,83,6,128,
65,0,64,65,128,77,0,64,78,72,83,6,128,65,0,128,82,0,200,84,10,0,192,67,
0,128,79,0,192,83,0,73,72,7,16,128,65,0,136,67,4,0,64,65,128,79,0,64,80,
128,65,0,72,72,36,73,80,11,28,64,83,64,83,128,76,0,72,77,8,64,67,128,83,
0,64,72,64,69,64,83,128,65,0,64,83,128,86,0,64,71,73,83,9,22,64,68,128,
70,0,72,79,8,64,70,128,83,0,64,68,128,83,0,64,84,64,82,64,82,128,65,0,72,
75,16,137,66,5,8,0,128,65,0,64,76,128,70,0,64,74,72,71,6,128,77,0,64,65,
128,67,0,74,83,103,1,101,73,78,10,37,192,65,0,128,67,0,73,68,7,18,128,75,
0,136,67,4,0,64,65,64,80,128,73,0,72,75,6,128,65,0,128,70,0,201,82,8,40,
0,128,70,0,200,80,11,0,136,83,4,0,128,77,0,64,79,73,78,7,16,128,80,0,72,
70,6,128,84,0,128,67,0,128,87,0,72,84,16,72,79,6,128,82,0,64,73,64,73,128,
70,0,64,83,128,69,0,73,79,33,131,73,80,9,24,64,69,128,83,0,72,73,10,64,
68,64,69,128,83,0,64,67,128,86,0,64,84,128,73,0,72,78,64,73,76,13,32,72,
87,6,128,68,0,128,80,0,73,68,7,16,128,73,0,72,67,6,128,73,0,128,66,0,128,
73,0,73,84,11,26,136,85,4,0,128,79,0,72,80,6,128,84,0,64,78,64,85,64,82,
128,77,0,128,85,0,64,77,73,77,7,18,128,83,0,136,70,4,0,64,67,64,66,128,
73,0,200,83,9,0,64,68,128,70,0,64,82,128,73,0,72,82,42,201,69,8,21,0,128,
70,0,72,67,10,64,69,64,82,128,84,0,128,65,0,200,79,13,0,72,84,6,128,67,
0,128,67,0,64,77,128,80,0,64,80,137,76,5,36,0,73,69,13,26,72,80,6,128,65,
0,128,71,0,72,68,6,128,65,0,64,65,64,76,128,83,0,64,70,128,79,0,73,81,7,
40,128,76,0,72,80,6,128,73,0,64,77,73,73,7,16,128,77,0,136,69,4,0,64,67,
128,66,0,64,83,136,76,4,0,128,73,0,128,82,0,73,86,22,113,201,77,10,15,0,
64,80,128,73,0,64,67,128,76,0,128,84,0,72,85,20,72,78,8,64,69,128,84,0,
64,71,64,69,64,78,128,69,0,64,84,73,79,11,42,64,79,64,84,128,70,0,137,70,
5,17,0,72,68,6,128,73,0,192,65,0,128,71,0,200,73,9,0,64,68,128,83,0,64,
72,128,77,0,73,82,7,16,128,83,0,136,81,4,0,64,80,128,65,0,72,87,6,128,73,
0,64,84,128,70,0,72,88,6,128,76,0,64,87,73,82,7,20,128,67,0,137,77,5,8,
0,128,71,0,64,79,128,87,0,73,84,7,18,128,77,0,64,83,136,84,4,0,64,68,128,
80,0,64,87,128,65,0,80,77,14,115,74,78,75,8,98,201,72,12,39,0,64,83,64,
65,128,65,0,73,68,7,16,128,80,0,136,67,4,0,64,65,128,79,0,136,71,4,0,64,
69,64,80,128,82,0,137,80,5,20,0,72,76,6,128,70,0,64,73,136,84,4,0,128,75,
0,136,85,4,0,64,82,64,65,128,83,0,74,71,66,4,243,73,76,9,33,64,67,128,67,
0,137,72,5,15,0,192,67,0,136,80,4,0,128,70,0,64,73,136,70,4,0,128,66,0,
73,82,11,21,136,83,4,0,128,69,0,192,77,0,136,80,4,0,128,65,0,64,83,64,68,
128,80,0,74,68,138,3,73,73,77,15,72,137,80,5,8,0,128,72,0,128,81,0,201,
71,10,44,0,64,76,128,83,0,201,67,18,29,0,73,83,7,10,128,85,0,128,75,0,128,
85,0,64,65,72,80,6,128,73,0,128,67,0,64,69,128,81,0,136,76,4,0,64,73,136,
83,4,0,128,79,0,73,80,11,32,136,84,4,0,128,83,0,72,79,14,136,80,4,0,64,
76,64,83,128,82,0,64,78,64,73,128,69,0,72,86,6,128,77,0,64,82,137,73,5,
18,0,136,68,4,0,64,65,136,77,4,0,128,73,0,128,84,0,74,66,137,1,196,73,79,
15,78,72,78,8,64,69,128,68,0,128,65,0,137,71,5,35,0,73,67,7,19,128,84,0,
192,65,0,72,82,6,128,73,0,128,69,0,64,70,72,87,6,128,66,0,128,82,0,73,76,
9,23,64,65,128,81,0,64,73,72,84,6,128,65,0,192,83,0,128,84,0,64,77,128,
83,0,73,85,9,45,64,83,128,65,0,73,83,17,23,73,70,7,10,128,78,0,128,65,0,
128,82,0,192,82,0,128,68,0,64,84,137,71,5,8,0,128,65,0,128,73,0,136,90,
4,0,64,87,128,65,0,64,65,73,74,11,146,64,73,64,73,128,67,0,73,70,11,101,
64,73,64,65,128,65,0,73,67,25,45,73,82,7,18,128,83,0,72,77,8,64,72,128,
80,0,128,68,0,128,86,0,64,65,73,82,7,12,128,83,0,64,79,128,77,0,192,87,
0,128,71,0,64,68,73,82,7,28,128,83,0,137,68,5,14,0,64,67,64,65,64,80,128,
83,0,64,77,64,69,128,67,0,72,87,10,64,73,64,70,128,73,0,64,84,128,86,0,
73,72,7,29,128,85,0,192,71,0,73,76,9,14,64,69,128,86,0,64,65,128,80,0,64,
84,128,70,0,64,73,128,68,0,137,81,5,63,0,73,78,17,31,72,79,8,64,86,128,
65,0,64,69,128,84,0,64,76,200,68,7,0,128,73,0,64,66,128,65,0,64,80,73,78,
9,16,64,65,128,86,0,136,75,4,0,128,73,0,136,80,4,0,64,79,128,87,0,73,83,
34,73,73,73,9,21,64,78,128,84,0,200,67,7,0,128,67,0,64,65,128,67,0,72,84,
6,128,67,0,128,80,0,64,82,73,73,7,18,128,68,0,72,67,6,128,83,0,64,66,128,
67,0,72,83,10,64,83,64,73,128,77,0,64,80,136,73,4,0,128,65,0,64,84,73,84,
9,26,64,69,128,88,0,72,73,10,136,87,4,0,128,70,0,64,72,64,77,128,76,0,128,
87,0,64,67,73,75,7,124,128,75,0,201,69,10,77,0,64,69,128,82,0,73,67,19,
51,73,77,7,10,128,69,0,128,66,0,64,85,128,85,0,72,66,10,64,77,64,83,128,
83,0,64,65,201,83,8,17,0,128,68,0,136,68,4,0,64,67,128,67,0,128,84,0,64,
68,137,77,5,8,0,128,69,0,192,83,0,128,84,0,201,72,8,29,0,128,67,0,72,71,
12,136,84,4,0,64,65,128,77,0,64,70,136,69,4,0,128,67,0,64,73,72,84,6,128,
80,0,128,68,0,73,82,15,90,137,69,5,8,0,128,68,0,128,83,0,73,79,21,42,137,
72,5,14,0,136,68,4,0,64,67,128,65,0,128,79,0,72,78,6,128,80,0,64,77,137,
71,5,10,0,64,65,128,80,0,128,83,0,64,80,137,71,5,20,0,137,68,5,10,0,64,
67,128,66,0,64,70,128,69,0,72,79,6,128,78,0,64,76,128,83,0,201,84,14,27,
0,136,83,4,0,64,70,128,84,0,64,83,137,68,5,8,0,128,65,0,128,69,0,192,85,
0,64,83,128,82,0,72,70,113,73,77,13,62,136,85,4,0,64,69,128,82,0,73,73,
13,34,136,80,4,0,64,70,128,67,0,137,67,5,12,0,64,65,64,81,128,76,0,64,71,
136,77,4,0,128,71,0,72,76,10,64,79,64,80,128,83,0,64,75,128,82,0,73,83,
23,34,137,76,5,12,0,136,66,4,0,128,65,0,136,88,4,0,128,85,0,72,80,8,64,
69,128,68,0,128,78,0,72,90,6,128,66,0,192,84,0,64,66,128,67,0,64,69,73,
77,21,142,137,83,5,14,0,72,82,6,128,73,0,128,67,0,128,85,0,73,70,7,82,128,
80,0,73,67,15,26,72,77,6,128,65,0,64,68,128,65,0,64,65,136,80,4,0,64,68,
128,83,0,64,68,73,80,9,40,64,65,128,67,0,73,73,13,22,64,71,64,65,64,77,
128,65,0,64,69,64,86,64,65,128,67,0,64,79,64,67,64,65,128,80,0,136,86,4,
0,128,84,0,73,73,15,28,72,82,6,128,71,0,64,77,128,83,0,64,71,136,84,4,0,
64,65,64,67,128,79,0,64,76,136,80,4,0,64,65,128,66,0,73,83,11,80,64,70,
64,69,128,84,0,73,80,9,22,64,72,128,73,0,64,78,136,68,4,0,64,65,64,83,128,
65,0,64,82,73,73,11,36,136,83,4,0,128,65,0,72,72,10,64,82,64,79,128,77,
0,64,67,64,79,64,83,64,85,136,82,4,0,128,76,0,136,86,4,0,64,76,128,78,0,
72,85,10,64,83,64,79,128,67,0,64,84,137,84,5,8,0,128,73,0,128,85,0,202,
75,65,2,12,0,137,76,5,38,0,73,74,7,28,128,86,0,72,68,16,73,75,7,10,128,
65,0,128,65,0,128,85,0,64,66,128,66,0,64,75,128,66,0,73,85,13,18,64,76,
64,84,64,82,128,65,0,64,77,128,70,0,128,90,0,82,73,1,64,1,170,73,76,17,
161,72,78,8,64,69,128,84,0,64,65,128,82,0,73,69,13,101,136,86,4,0,64,83,
128,67,0,73,67,28,52,73,80,9,14,64,69,128,76,0,64,69,128,88,0,192,82,0,
64,79,64,83,128,68,0,200,66,17,0,137,82,5,10,0,64,73,128,68,0,128,84,0,
64,65,64,67,128,82,0,192,68,0,137,76,5,22,0,136,73,4,0,64,67,72,79,6,128,
77,0,64,65,128,66,0,72,85,8,64,86,128,73,0,128,80,0,73,73,7,36,128,83,0,
72,71,14,72,69,8,64,68,128,67,0,128,65,0,64,70,136,83,4,0,64,73,136,68,
4,0,128,67,0,64,75,64,69,128,89,0,73,82,19,89,137,82,5,8,0,128,78,0,64,
83,64,65,128,80,0,73,79,11,44,64,83,64,72,128,65,0,72,78,14,64,73,64,83,
64,68,64,72,128,67,0,64,77,137,69,5,14,0,136,68,4,0,64,67,128,82,0,128,
79,0,64,80,137,73,5,15,0,200,67,7,0,128,68,0,128,66,0,136,83,4,0,64,80,
128,65,0,73,85,7,55,128,80,0,200,84,41,0,137,77,5,28,0,73,69,13,20,136,
88,4,0,64,67,128,83,0,64,65,64,67,128,83,0,128,73,0,72,89,6,128,67,0,128,
83,0,64,83,64,80,128,67,0,64,87,136,85,4,0,128,68,0,64,72,137,73,5,50,0,
73,70,7,40,128,85,0,72,69,18,73,77,7,10,128,84,0,128,71,0,64,83,128,79,
0,64,65,136,81,4,0,64,77,64,77,64,69,128,82,0,64,71,128,67,0,73,82,33,47,
73,70,7,18,128,70,0,137,67,5,8,0,128,65,0,128,68,0,72,83,6,128,68,0,64,
77,128,73,0,200,80,9,0,64,67,128,67,0,64,76,128,87,0,64,83,64,87,128,65,
0,64,74,73,72,7,18,128,84,0,72,70,6,128,70,0,64,68,128,72,0,72,84,6,128,
73,0,64,80,64,69,128,71,0,72,77,157,73,80,11,107,136,67,4,0,128,65,0,201,
73,18,40,0,73,70,7,10,128,70,0,128,67,0,128,79,0,72,69,14,137,76,5,8,0,
128,71,0,128,86,0,192,65,0,64,80,128,73,0,200,79,51,0,137,71,5,28,0,72,
70,14,64,80,64,82,64,80,64,83,128,71,0,64,65,64,82,64,84,128,83,0,72,83,
6,128,71,0,64,82,72,84,6,128,83,0,64,80,128,71,0,64,78,128,65,0,73,86,7,
42,128,87,0,200,83,14,0,136,73,4,0,192,69,0,128,65,0,64,82,137,70,5,16,
0,72,68,6,128,65,0,64,67,128,65,0,128,80,0,64,87,128,82,0,64,76,201,77,
10,70,0,64,73,128,65,0,201,72,8,35,0,128,82,0,201,67,8,22,0,128,75,0,200,
66,9,0,64,65,128,77,0,64,65,128,83,0,64,71,128,87,0,137,75,5,10,0,64,73,
128,65,0,64,76,137,82,5,10,0,64,66,128,83,0,128,87,0,201,83,8,34,0,128,
69,0,201,80,10,15,0,64,80,128,80,0,64,78,128,86,0,64,82,136,83,4,0,64,72,
128,82,0,73,86,9,14,64,83,128,83,0,64,84,128,82,0,128,87,0,74,85,72,5,40,
137,73,5,36,0,137,68,5,16,0,72,67,8,64,84,128,82,0,128,65,0,64,70,137,71,
5,8,0,128,69,0,64,79,128,78,0,73,84,13,26,136,86,4,0,64,67,128,68,0,72,
79,6,128,83,0,64,77,64,67,128,73,0,64,87,128,71,0,74,82,152,2,193,73,77,
9,99,64,82,128,65,0,73,70,23,56,72,82,14,64,69,64,69,64,77,64,65,128,78,
0,64,73,128,84,0,73,67,7,22,128,80,0,64,65,137,80,5,8,0,128,77,0,64,87,
128,83,0,192,69,0,64,67,192,73,0,128,67,0,201,73,24,31,0,137,70,5,16,0,
72,69,6,128,77,0,64,67,128,83,0,128,77,0,64,72,64,68,128,68,0,128,74,0,
73,81,7,23,128,69,0,201,79,8,13,0,128,73,0,64,78,128,65,0,128,80,0,73,84,
11,22,136,71,4,0,128,69,0,64,83,72,69,6,128,67,0,128,65,0,128,85,0,74,80,
187,2,24,73,78,9,101,64,83,128,84,0,73,72,9,52,64,80,128,84,0,201,68,8,
29,0,128,85,0,136,67,4,0,64,65,73,74,7,10,128,65,0,128,65,0,64,83,128,73,
0,64,69,136,73,4,0,192,71,0,64,73,128,70,0,201,76,26,35,0,136,83,4,0,64,
65,72,89,10,64,69,64,82,128,67,0,64,68,128,83,0,64,73,136,79,4,0,128,78,
0,64,77,128,68,0,201,83,18,60,0,72,83,6,128,69,0,64,65,64,70,128,69,0,73,
81,7,30,128,67,0,72,80,14,137,69,5,8,0,128,67,0,128,84,0,64,79,136,66,4,
0,128,65,0,192,82,0,136,73,4,0,64,68,128,65,0,73,85,7,16,128,73,0,64,84,
136,83,4,0,128,73,0,64,86,128,71,0,64,79,73,76,27,196,73,76,13,18,72,85,
6,128,83,0,128,69,0,64,65,128,80,0,64,83,128,65,0,73,69,17,111,137,70,5,
8,0,128,65,0,64,89,128,83,0,73,67,29,76,72,86,6,128,68,0,192,65,0,137,80,
5,11,0,192,68,0,128,65,0,64,83,128,69,0,72,66,42,73,76,9,36,64,73,128,78,
0,72,73,24,72,77,6,128,66,0,64,76,64,69,72,88,6,128,84,0,64,80,128,67,0,
128,68,0,128,79,0,64,65,128,67,0,64,68,201,73,8,13,0,128,83,0,64,69,128,
71,0,128,76,0,73,72,29,51,73,76,9,20,64,84,128,67,0,72,70,6,128,87,0,64,
65,128,65,0,64,80,128,65,0,192,70,0,73,70,9,14,64,79,128,77,0,64,69,128,
68,0,64,78,128,80,0,64,73,64,67,128,69,0,73,83,57,104,73,79,7,38,128,80,
0,73,70,9,24,64,69,128,84,0,72,68,8,64,65,128,76,0,64,65,64,83,128,79,0,
64,77,64,73,128,67,0,137,83,5,10,0,64,80,128,70,0,64,84,128,76,0,73,80,
21,44,73,73,9,12,64,84,128,84,0,128,65,0,64,86,128,73,0,72,79,12,72,84,
6,128,87,0,128,82,0,64,77,72,83,6,128,78,0,128,65,0,128,81,0,201,85,12,
31,0,136,84,4,0,128,83,0,64,84,73,73,7,14,128,83,0,136,71,4,0,128,68,0,
128,85,0,192,86,0,72,80,6,128,69,0,64,73,64,76,128,72,0,64,81,73,83,7,10,
128,65,0,128,73,0,64,84,128,84,0,72,84,209,73,76,11,111,136,83,4,0,128,
68,0,73,70,7,72,128,71,0,73,67,19,54,137,82,5,12,0,136,78,4,0,128,68,0,
128,84,0,72,66,26,137,70,5,14,0,136,69,4,0,64,67,128,70,0,72,80,6,128,83,
0,128,73,0,64,65,136,80,4,0,128,78,0,64,69,72,83,6,128,69,0,128,70,0,73,
72,13,23,136,82,4,0,64,69,128,76,0,192,71,0,136,83,4,0,128,79,0,64,73,128,
69,0,73,83,11,70,136,85,4,0,128,79,0,73,80,17,48,73,68,7,10,128,80,0,128,
65,0,128,76,0,72,79,24,137,82,5,12,0,136,77,4,0,128,71,0,136,87,4,0,64,
83,128,73,0,64,77,64,83,128,78,0,64,82,136,82,4,0,64,67,128,66,0,137,85,
5,20,0,64,84,137,70,5,10,0,64,68,128,76,0,128,82,0,64,88,128,84,0,64,83,
73,75,9,168,64,67,128,67,0,201,69,16,116,0,136,87,4,0,64,72,64,80,128,65,
0,73,67,43,69,137,73,5,28,0,73,69,9,16,64,73,128,84,0,64,65,64,83,128,73,
0,64,72,64,79,128,65,0,72,85,6,128,71,0,64,77,128,76,0,72,66,14,137,71,
5,8,0,128,68,0,128,84,0,64,65,200,84,7,0,128,65,0,128,80,0,64,68,73,82,
7,22,128,76,0,73,78,9,12,64,65,128,65,0,128,69,0,128,80,0,136,85,4,0,128,
83,0,73,72,7,23,128,65,0,192,70,0,73,72,7,10,128,82,0,128,71,0,128,80,0,
192,73,0,73,71,7,14,128,72,0,136,66,4,0,128,65,0,128,79,0,73,83,34,116,
73,80,7,19,128,79,0,200,77,9,0,64,83,128,69,0,128,71,0,72,86,6,128,68,0,
64,82,128,70,0,73,80,23,44,137,68,5,12,0,136,66,4,0,128,65,0,136,83,4,0,
128,80,0,72,77,12,136,83,4,0,64,80,128,82,0,64,76,136,84,4,0,128,81,0,64,
82,137,78,5,18,0,137,68,5,8,0,128,67,0,64,69,128,70,0,73,83,9,12,64,65,
128,84,0,128,80,0,192,84,0,128,67,0,73,85,13,41,136,68,4,0,64,67,128,69,
0,64,84,137,78,5,14,0,136,76,4,0,64,73,128,82,0,200,85,9,0,64,67,128,65,
0,128,80,0,64,87,64,67,128,84,0,73,88,9,100,64,68,128,87,0,72,87,14,72,
73,8,64,80,128,83,0,128,67,0,64,86,73,78,11,48,136,79,4,0,128,69,0,73,69,
9,24,64,77,128,83,0,200,67,7,0,128,67,0,192,65,0,64,67,128,83,0,72,76,10,
136,83,4,0,128,72,0,128,73,0,73,83,9,16,64,83,128,65,0,136,82,4,0,128,80,
0,72,86,6,128,77,0,64,84,128,83,0,72,90,8,64,65,128,80,0,64,89,73,73,7,
68,128,69,0,73,68,13,24,136,66,4,0,64,65,128,67,0,72,67,6,128,67,0,64,66,
128,65,0,72,70,32,64,73,64,82,64,83,64,84,64,83,64,69,64,88,64,84,64,69,
64,65,64,67,64,72,64,69,128,82,0,64,69,128,77,0,73,82,9,32,64,69,128,83,
0,72,80,6,128,68,0,64,79,73,68,9,12,64,66,128,67,0,128,66,0,128,71,0,72,
87,8,64,69,128,68,0,64,83,64,67,64,69,64,78,128,69,0,64,76,74,77,83,5,78,
73,82,23,52,137,80,5,10,0,64,68,128,65,0,64,87,64,83,64,65,128,67,0,137,
69,5,16,0,72,68,6,128,83,0,64,66,128,83,0,72,73,8,64,82,128,76,0,64,72,
128,67,0,137,86,5,21,0,72,84,10,136,86,4,0,128,80,0,192,83,0,128,75,0,64,
87,128,72,0,74,71,75,3,108,73,73,11,33,64,83,64,77,128,83,0,137,67,5,19,
0,72,66,9,192,84,0,128,73,0,64,65,128,84,0,128,68,0,73,83,11,32,136,80,
4,0,128,76,0,72,80,6,128,76,0,64,77,73,70,7,10,128,80,0,128,68,0,128,82,
0,64,84,128,66,0,74,68,111,2,87,73,79,9,56,64,67,128,69,0,73,73,11,28,136,
73,4,0,128,70,0,73,68,7,12,128,77,0,64,65,128,80,0,64,69,128,70,0,200,77,
13,0,72,79,6,128,83,0,128,76,0,192,76,0,128,67,0,73,84,7,40,128,82,0,201,
82,16,26,0,72,80,6,128,83,0,64,65,128,83,0,192,80,0,136,82,4,0,128,67,0,
64,83,64,83,128,65,0,136,90,4,0,192,87,0,128,83,0,74,66,100,1,85,73,78,
11,59,136,76,4,0,128,69,0,73,71,7,31,128,84,0,73,67,11,21,64,65,64,83,128,
84,0,192,65,0,136,77,4,0,128,67,0,128,68,0,73,73,7,12,128,79,0,64,72,128,
73,0,64,77,128,65,0,73,85,9,29,64,82,128,80,0,73,82,7,14,128,80,0,64,79,
64,84,128,69,0,192,83,0,128,73,0,136,88,4,0,128,86,0,64,65,73,77,11,110,
136,83,4,0,128,80,0,73,70,19,76,137,68,5,10,0,64,67,128,65,0,64,77,128,
83,0,73,67,29,42,73,77,13,22,72,84,6,128,65,0,128,65,0,64,67,136,70,4,0,
128,68,0,128,80,0,72,66,8,64,83,128,65,0,64,65,128,82,0,64,68,72,83,8,64,
80,128,65,0,64,69,128,69,0,73,72,9,14,64,83,128,79,0,64,71,128,81,0,64,
76,64,85,64,78,128,65,0,73,84,9,96,64,79,128,82,0,73,82,16,62,72,84,6,128,
67,0,192,80,0,128,71,0,72,80,34,137,68,5,24,0,137,66,5,12,0,64,65,64,67,
128,75,0,64,67,64,65,128,84,0,136,84,4,0,128,77,0,192,78,0,136,76,4,0,64,
67,128,80,0,64,83,73,79,9,20,64,73,128,83,0,72,71,6,128,82,0,64,70,128,
76,0,128,82,0,73,86,11,26,64,80,64,69,128,83,0,64,85,72,84,8,64,82,128,
79,0,64,83,128,68,0,64,87,64,75,128,83,0,64,67,73,79,11,84,136,83,4,0,128,
66,0,201,68,12,47,0,64,74,64,70,128,83,0,73,66,7,22,128,79,0,64,65,73,82,
7,10,128,83,0,128,67,0,128,83,0,64,67,136,84,4,0,64,73,64,69,128,66,0,201,
76,8,13,0,128,83,0,64,73,128,65,0,64,77,137,69,5,8,0,128,67,0,128,83,0,
73,85,7,45,128,80,0,201,82,16,19,0,72,79,8,64,83,128,83,0,128,65,0,128,
80,0,64,83,137,84,5,14,0,136,72,4,0,64,65,128,74,0,128,87,0,72,89,8,64,
84,128,70,0,192,86,0,64,67,128,82,0,72,70,90,73,73,19,46,72,78,12,64,84,
64,79,64,83,128,67,0,128,66,0,137,69,5,20,0,72,67,8,64,83,128,80,0,64,66,
64,71,128,65,0,136,71,4,0,128,70,0,73,82,7,19,128,77,0,72,80,6,128,82,0,
192,79,0,128,83,0,72,84,16,136,82,4,0,64,65,64,73,64,80,128,71,0,192,83,
0,128,82,0,64,69,73,77,7,77,128,86,0,201,68,24,51,0,73,66,9,14,64,65,128,
84,0,64,65,128,67,0,64,67,128,82,0,72,67,14,72,84,8,64,65,128,67,0,128,
71,0,64,66,72,82,8,64,85,128,78,0,128,80,0,72,76,10,64,70,64,65,128,83,
0,64,69,136,80,4,0,128,68,0,73,84,9,26,64,65,128,67,0,72,83,12,64,77,64,
85,64,85,128,71,0,64,78,128,82,0,64,88,64,73,128,68,0,73,74,23,219,73,68,
9,14,64,65,128,77,0,64,66,128,70,0,64,77,128,85,0,72,73,154,73,77,15,104,
137,79,5,8,0,128,67,0,128,83,0,73,68,19,44,73,73,7,12,128,76,0,64,65,128,
82,0,128,83,0,73,66,13,18,136,84,4,0,64,79,128,82,0,64,65,128,70,0,64,67,
64,85,128,83,0,73,72,17,40,72,84,6,128,67,0,64,69,64,65,128,80,0,64,70,
73,70,7,18,128,69,0,72,69,6,128,77,0,64,65,128,68,0,128,79,0,64,76,128,
79,0,73,82,11,36,136,82,4,0,128,67,0,73,79,7,12,128,85,0,64,78,128,81,0,
192,80,0,136,85,4,0,192,73,0,128,68,0,72,86,6,128,67,0,64,83,128,78,0,192,
72,0,73,83,7,28,128,73,0,73,79,13,16,136,78,4,0,64,72,128,65,0,128,67,0,
64,82,128,72,0,136,87,4,0,64,84,64,69,128,67,0,72,76,129,73,78,11,84,136,
76,4,0,128,65,0,73,69,15,45,72,84,6,128,90,0,64,66,128,71,0,201,67,16,21,
0,137,70,5,8,0,128,68,0,128,79,0,64,66,128,80,0,64,68,136,80,4,0,128,65,
0,72,77,19,137,69,5,11,0,192,68,0,128,65,0,64,78,128,82,0,64,76,136,84,
4,0,128,80,0,73,84,7,33,128,68,0,201,81,10,20,0,64,82,128,77,0,192,80,0,
136,87,4,0,128,69,0,192,82,0,128,86,0,72,86,6,128,77,0,128,85,0,64,75,73,
73,11,34,136,83,4,0,128,82,0,73,67,7,18,128,68,0,64,65,136,83,4,0,64,69,
128,77,0,64,71,128,67,0,136,81,4,0,64,77,72,80,6,128,71,0,128,76,0,74,84,
112,2,52,73,76,7,59,128,70,0,201,69,8,37,0,128,82,0,73,67,17,24,137,73,
5,10,0,64,67,128,80,0,128,77,0,64,65,64,84,128,87,0,64,68,128,68,0,72,73,
12,136,80,4,0,64,70,128,82,0,128,72,0,73,82,11,30,136,85,4,0,128,75,0,137,
79,5,14,0,64,78,136,84,4,0,128,83,0,64,80,128,83,0,72,84,6,128,69,0,192,
83,0,72,83,6,128,76,0,128,80,0,73,81,13,252,72,84,6,128,83,0,128,77,0,73,
79,131,159,201,73,8,54,0,128,67,0,201,70,10,33,0,64,65,128,82,0,72,67,16,
72,75,8,64,83,128,83,0,64,69,128,65,0,64,65,64,69,128,76,0,72,72,8,64,65,
128,83,0,64,71,128,68,0,73,82,23,45,73,69,9,14,64,65,128,76,0,64,67,128,
83,0,64,82,128,73,0,72,79,16,72,82,8,64,82,128,83,0,64,67,128,86,0,192,
76,0,128,80,0,72,84,17,201,82,8,11,0,128,79,0,128,69,0,128,87,0,64,83,136,
87,4,0,64,65,128,80,0,64,78,73,67,7,23,128,83,0,72,66,6,128,80,0,192,65,
0,136,73,4,0,128,72,0,128,80,0,64,80,201,71,8,41,0,128,65,0,201,68,10,21,
0,64,68,128,82,0,72,67,6,128,77,0,64,65,128,82,0,200,70,7,0,128,77,0,64,
69,128,71,0,137,78,5,26,0,72,77,12,64,67,136,82,4,0,128,76,0,64,73,136,
75,4,0,128,67,0,72,82,6,128,76,0,64,80,128,76,0,72,83,108,201,79,8,56,0,
128,82,0,137,69,5,31,0,137,66,5,20,0,64,65,73,83,7,10,128,83,0,128,80,0,
128,84,0,192,68,0,128,74,0,72,77,6,128,87,0,64,72,72,84,6,128,77,0,128,
70,0,73,84,7,36,128,73,0,73,82,7,18,128,82,0,64,80,136,80,4,0,64,79,128,
82,0,64,83,136,84,4,0,64,65,128,72,0,72,90,6,128,72,0,64,89,64,80,128,69,
0,64,82,73,76,9,60,64,65,128,80,0,201,69,10,36,0,64,82,128,73,0,72,68,14,
72,73,8,64,77,128,77,0,128,71,0,192,65,0,72,83,6,128,77,0,128,68,0,72,73,
10,136,84,4,0,128,80,0,64,70,128,68,0,73,82,11,20,136,83,4,0,128,80,0,72,
81,6,128,65,0,128,79,0,136,85,4,0,192,84,0,128,73,0,73,87,23,209,73,77,
7,16,128,65,0,64,67,136,76,4,0,128,70,0,128,84,0,200,86,133,0,137,78,5,
85,0,73,69,11,67,136,70,4,0,128,69,0,73,67,35,40,73,83,15,26,72,84,8,64,
69,128,73,0,128,82,0,72,77,8,64,79,128,83,0,128,66,0,64,86,128,65,0,64,
65,128,68,0,192,68,0,137,83,5,10,0,64,67,128,82,0,128,84,0,200,77,7,0,128,
72,0,192,76,0,128,80,0,201,83,8,29,0,128,67,0,72,82,8,64,84,128,67,0,64,
80,136,83,4,0,64,69,64,67,128,76,0,72,86,8,64,87,128,83,0,64,84,64,84,128,
76,0,64,85,73,75,7,26,128,83,0,73,68,7,16,128,86,0,64,67,136,84,4,0,128,
70,0,128,71,0,73,82,7,22,128,84,0,64,76,72,85,8,64,67,128,70,0,64,65,128,
67,0,128,84,0,72,90,6,128,87,0,64,89,72,70,6,128,67,0,64,67,64,76,64,83,
128,85,0,82,85,13,3,82,34,74,77,173,5,195,73,74,7,99,128,67,0,73,69,7,58,
128,88,0,73,67,9,29,64,79,128,82,0,72,66,6,128,67,0,192,65,0,72,83,6,128,
83,0,64,67,128,79,0,192,68,0,73,78,7,14,128,74,0,136,72,4,0,128,70,0,64,
83,128,90,0,137,72,5,27,0,200,71,7,0,128,73,0,64,70,72,80,6,128,83,0,64,
67,64,67,128,73,0,64,73,64,83,128,84,0,73,83,17,50,73,78,7,10,128,72,0,
128,71,0,128,82,0,73,80,16,28,72,84,6,128,78,0,192,67,0,128,83,0,72,78,
6,128,79,0,192,76,0,128,83,0,64,82,128,75,0,73,85,7,16,128,67,0,64,84,136,
86,4,0,128,83,0,128,89,0,74,71,52,3,140,73,78,7,28,128,69,0,73,75,7,16,
128,75,0,136,67,4,0,64,66,128,69,0,64,76,128,69,0,137,86,5,16,0,72,80,6,
128,80,0,64,79,128,85,0,128,89,0,74,68,133,2,115,137,75,5,64,0,137,70,5,
42,0,73,68,7,20,128,73,0,72,67,6,128,73,0,64,65,64,80,128,69,0,64,69,137,
71,5,8,0,128,70,0,64,76,64,65,128,82,0,73,72,7,10,128,82,0,128,71,0,64,
73,64,77,128,77,0,73,82,7,40,128,80,0,73,77,11,23,136,82,4,0,128,65,0,64,
76,136,68,4,0,192,65,0,128,80,0,192,80,0,136,80,4,0,128,77,0,201,86,8,19,
0,128,77,0,64,85,136,66,4,0,64,65,128,76,0,64,87,128,82,0,74,66,69,1,21,
73,73,7,38,128,71,0,73,67,21,28,73,72,9,12,64,69,128,65,0,128,68,0,64,73,
128,77,0,64,65,64,67,128,83,0,128,70,0,201,82,16,21,0,137,76,5,8,0,128,
68,0,128,82,0,64,77,128,71,0,64,84,128,73,0,64,65,137,74,5,93,0,201,69,
8,51,0,128,72,0,201,67,14,34,0,72,82,6,128,82,0,128,74,0,72,66,8,64,74,
128,79,0,192,65,0,136,71,4,0,64,65,128,78,0,64,68,136,89,4,0,128,69,0,73,
72,7,34,128,85,0,72,71,6,128,67,0,64,70,73,79,9,12,64,83,128,83,0,128,65,
0,64,80,64,85,128,71,0,128,73,0,73,82,42,69,137,83,5,8,0,128,76,0,192,84,
0,72,82,14,72,83,6,128,82,0,64,73,128,83,0,64,73,136,77,4,0,64,76,64,80,
128,82,0,73,79,7,18,128,67,0,72,78,6,128,76,0,64,77,128,83,0,64,80,64,82,
64,79,128,70,0,137,86,5,41,0,136,84,4,0,64,83,137,73,5,21,0,73,67,7,13,
128,82,0,192,66,0,128,78,0,128,68,0,136,80,4,0,64,76,128,80,0,128,87,0,
192,67,0,73,79,9,139,64,78,128,78,0,73,73,23,91,73,80,7,10,128,82,0,128,
70,0,64,84,136,83,4,0,128,65,0,73,67,33,48,137,69,5,18,0,72,66,6,128,84,
0,64,65,64,83,128,83,0,64,74,72,69,6,128,65,0,128,65,0,64,65,73,73,7,10,
128,68,0,128,70,0,128,83,0,192,69,0,73,80,7,12,128,83,0,64,68,128,68,0,
64,81,128,65,0,72,77,10,136,74,4,0,128,69,0,192,76,0,137,71,5,17,0,72,69,
6,128,83,0,192,65,0,128,78,0,72,78,6,128,68,0,128,72,0,73,84,11,64,136,
73,4,0,128,69,0,72,83,36,137,70,5,20,0,73,67,9,12,64,65,128,77,0,128,66,
0,128,68,0,72,82,10,136,67,4,0,128,66,0,128,74,0,64,80,72,70,10,64,80,64,
73,128,75,0,64,69,128,76,0,72,89,8,64,77,128,79,0,128,86,0,72,70,135,201,
79,12,69,0,136,80,4,0,128,67,0,137,68,5,32,0,201,66,8,17,0,128,65,0,64,
65,136,87,4,0,128,77,0,192,67,0,136,87,4,0,128,71,0,73,74,7,10,128,70,0,
128,71,0,64,77,73,73,7,10,128,80,0,128,71,0,128,76,0,137,84,5,50,0,73,82,
23,32,137,74,5,16,0,72,71,6,128,83,0,64,65,128,87,0,128,78,0,64,80,136,
74,4,0,128,69,0,64,83,137,68,5,8,0,128,67,0,128,77,0,72,87,8,64,79,128,
67,0,64,86,128,65,0,64,69,73,77,9,51,64,79,128,65,0,73,70,17,31,73,69,7,
10,128,82,0,128,65,0,128,73,0,200,67,11,0,136,69,4,0,128,67,0,128,65,0,
72,72,6,128,82,0,64,71,128,79,0,73,83,7,30,128,66,0,72,82,6,128,69,0,64,
80,73,76,9,12,64,65,128,67,0,128,71,0,128,83,0,72,87,6,128,82,0,64,84,128,
65,0,73,74,21,204,73,77,7,12,128,80,0,64,65,128,84,0,64,84,128,76,0,200,
73,105,0,73,76,9,46,64,68,128,77,0,137,68,5,24,0,73,66,7,12,128,69,0,64,
65,128,77,0,64,67,64,69,128,69,0,72,71,8,64,69,128,65,0,64,70,128,78,0,
73,84,7,45,128,84,0,201,80,12,22,0,136,84,4,0,128,73,0,192,77,0,136,80,
4,0,128,65,0,64,83,137,84,5,11,0,192,65,0,128,80,0,128,85,0,136,88,4,0,
192,85,0,128,67,0,64,72,201,80,14,52,0,72,76,6,128,67,0,128,68,0,73,69,
9,25,64,67,128,82,0,200,68,7,0,128,86,0,64,67,136,76,4,0,128,73,0,72,77,
10,136,87,4,0,128,83,0,128,70,0,137,84,5,16,0,72,83,8,64,76,128,67,0,128,
81,0,192,86,0,64,68,128,67,0,72,76,93,73,76,7,47,128,73,0,73,69,7,29,128,
86,0,200,67,17,0,137,72,5,8,0,128,67,0,64,80,128,67,0,64,65,128,87,0,72,
72,6,128,83,0,64,70,128,65,0,73,82,9,20,64,77,128,67,0,136,78,4,0,64,77,
64,65,128,65,0,136,86,4,0,64,83,137,73,5,12,0,136,70,4,0,128,68,0,64,90,
128,72,0,192,75,0,73,73,13,62,72,82,6,128,84,0,128,80,0,73,67,11,36,64,
73,64,83,128,65,0,72,66,6,128,65,0,64,65,73,69,7,14,128,65,0,64,66,64,73,
128,70,0,128,83,0,72,72,6,128,79,0,64,69,64,69,128,80,0,73,83,13,27,64,
65,64,84,64,83,128,69,0,72,80,8,64,68,128,83,0,192,76,0,128,65,0,64,84,
128,73,0,74,84,88,6,179,201,80,14,57,0,136,76,4,0,64,66,128,65,0,73,72,
17,40,72,83,10,64,67,64,83,128,65,0,128,77,0,72,69,12,72,83,6,128,65,0,
128,69,0,64,65,72,84,6,128,85,0,128,82,0,128,73,0,73,83,7,21,128,65,0,72,
82,9,192,65,0,128,78,0,64,81,128,71,0,64,84,128,79,0,74,80,151,3,41,73,
78,7,90,128,80,0,73,69,21,46,73,78,7,12,128,78,0,64,67,128,79,0,64,80,128,
69,0,73,66,7,14,128,79,0,64,65,64,69,128,80,0,64,68,72,82,6,128,83,0,128,
68,0,73,72,7,14,128,67,0,64,71,64,77,128,65,0,64,77,73,73,9,16,64,70,128,
65,0,136,67,4,0,128,65,0,64,82,128,67,0,201,83,8,35,0,128,84,0,73,80,15,
22,72,71,6,128,72,0,64,67,128,76,0,64,79,64,70,128,67,0,64,82,128,72,0,
73,87,7,12,128,80,0,64,84,128,85,0,64,89,136,68,4,0,128,65,0,200,79,34,
0,137,77,5,20,0,72,73,6,128,84,0,64,70,136,84,4,0,128,76,0,136,88,4,0,192,
87,0,128,68,0,64,78,74,77,70,1,186,73,73,25,42,137,76,5,14,0,136,72,4,0,
64,66,128,72,0,136,83,4,0,128,78,0,72,69,6,128,69,0,64,65,136,83,4,0,64,
67,128,67,0,72,83,6,128,77,0,64,79,72,86,8,64,73,128,67,0,64,71,64,73,128,
80,0,74,70,38,1,15,137,70,5,20,0,72,68,8,64,65,128,67,0,64,67,64,67,128,
67,0,72,84,8,64,65,128,82,0,64,83,128,65,0,201,67,89,118,0,73,73,13,44,
64,84,64,82,64,65,128,76,0,73,69,7,24,128,68,0,73,67,7,12,128,68,0,64,65,
128,67,0,64,68,128,70,0,136,71,4,0,128,70,0,73,83,7,28,128,68,0,72,82,14,
72,80,6,128,68,0,64,79,128,67,0,64,76,64,79,128,83,0,136,87,4,0,192,84,
0,64,65,128,68,0,136,66,4,0,64,65,73,79,7,16,128,67,0,136,77,4,0,64,65,
128,70,0,64,83,64,85,128,82,0,72,69,66,137,80,5,28,0,73,67,11,20,136,69,
4,0,128,65,0,64,65,64,82,64,84,128,69,0,128,68,0,72,84,16,64,66,64,79,64,
79,64,84,64,73,128,78,0,64,83,137,82,5,14,0,136,80,4,0,64,67,128,79,0,128,
83,0,64,68,73,79,7,30,128,70,0,137,71,5,18,0,72,69,8,64,83,128,65,0,64,
65,128,70,0,64,77,128,84,0,73,82,9,12,64,73,128,80,0,128,80,0,64,83,128,
83,0,73,73,81,96,73,77,15,54,72,69,6,128,80,0,64,65,128,83,0,73,68,13,26,
136,79,4,0,64,73,128,82,0,64,67,64,80,64,79,64,76,64,79,128,83,0,64,70,
72,73,6,128,76,0,64,69,128,73,0,73,83,7,16,128,65,0,64,79,64,83,64,73,128,
76,0,64,86,64,65,128,67,0,72,72,8,64,82,128,67,0,64,71,64,69,128,73,0,64,
76,128,86,0,73,84,15,149,72,83,6,128,79,0,64,69,128,65,0,73,80,22,63,72,
82,12,64,69,64,68,64,69,128,80,0,192,79,0,128,67,0,72,79,34,137,78,5,22,
0,137,71,5,10,0,64,68,128,67,0,64,77,64,73,128,71,0,136,83,4,0,64,80,128,
83,0,64,78,64,69,128,83,0,72,83,45,137,68,5,31,0,200,67,21,0,73,79,7,14,
128,80,0,64,69,64,65,128,82,0,128,82,0,64,65,128,70,0,136,87,4,0,64,80,
64,83,128,67,0,192,82,0,73,82,7,18,128,65,0,64,73,72,83,6,128,68,0,128,
67,0,64,87,128,65,0,73,87,17,26,72,84,6,128,79,0,64,71,64,65,128,68,0,136,
86,4,0,64,85,128,68,0,64,89,128,80,0,80,83,2,227,74,77,34,1,244,73,77,7,
22,128,65,0,73,69,7,10,128,70,0,128,67,0,64,76,128,69,0,136,84,4,0,128,
83,0,74,70,41,1,110,137,75,5,18,0,73,68,7,10,128,65,0,128,65,0,128,70,0,
201,83,10,13,0,64,80,128,65,0,128,76,0,64,87,128,83,0,73,67,49,247,73,73,
7,32,128,83,0,73,67,17,22,137,66,5,10,0,64,65,128,78,0,128,85,0,64,65,128,
80,0,128,71,0,72,83,8,64,83,128,65,0,64,82,128,73,0,200,66,85,0,73,70,13,
64,64,83,64,69,64,79,128,70,0,72,69,26,64,80,64,67,72,82,8,64,73,128,83,
0,64,73,72,83,6,128,67,0,128,77,0,64,68,72,82,18,72,82,8,64,73,128,83,0,
64,73,64,83,128,67,0,64,76,128,77,0,72,76,12,64,83,64,69,64,79,128,70,0,
64,73,128,80,0,192,65,0,73,76,11,57,136,83,4,0,128,73,0,73,68,7,24,128,
65,0,72,67,12,136,69,4,0,64,66,128,73,0,64,65,128,70,0,72,73,6,128,68,0,
192,70,0,137,69,5,8,0,128,65,0,64,70,128,69,0,73,82,7,30,128,84,0,72,80,
6,128,65,0,64,77,64,82,72,73,8,64,67,128,68,0,64,65,128,65,0,72,84,10,136,
85,4,0,128,70,0,64,83,72,79,6,128,67,0,64,70,128,67,0,72,69,20,73,80,7,
10,128,65,0,128,66,0,64,82,64,82,128,65,0,192,68,0,137,77,5,20,0,72,76,
6,128,65,0,64,65,136,87,4,0,128,65,0,136,84,4,0,64,79,137,84,5,12,0,136,
74,4,0,128,69,0,64,87,64,78,64,76,64,79,64,65,64,68,64,69,128,82,0,73,73,
31,81,137,71,5,14,0,72,66,6,128,67,0,128,65,0,64,84,137,83,5,8,0,128,67,
0,128,84,0,72,72,18,73,77,7,10,128,77,0,128,76,0,64,80,128,68,0,64,71,73,
67,9,18,64,82,128,80,0,72,66,6,128,67,0,128,65,0,200,83,7,0,128,67,0,64,
80,128,69,0,72,76,8,64,66,128,65,0,64,74,64,70,64,67,64,79,128,77,0,201,
83,63,160,0,73,80,17,43,64,65,64,67,64,69,64,67,64,79,128,77,0,201,70,10,
17,0,64,84,128,65,0,136,68,4,0,128,66,0,64,79,64,67,64,79,128,77,0,137,
83,5,8,0,128,82,0,64,84,64,65,128,70,0,73,80,43,58,73,82,7,25,128,65,0,
73,72,7,13,128,83,0,192,65,0,128,80,0,64,73,128,83,0,72,84,6,128,79,0,192,
83,0,64,84,128,70,0,72,79,10,136,77,4,0,128,67,0,64,78,128,79,0,72,82,36,
137,77,5,24,0,73,68,7,12,128,83,0,64,66,128,67,0,64,73,64,69,128,80,0,72,
83,6,128,70,0,128,80,0,128,81,0,73,86,11,64,136,80,4,0,128,73,0,72,85,24,
137,70,5,16,0,72,67,6,128,69,0,64,66,128,67,0,64,82,128,84,0,64,84,73,79,
7,24,128,65,0,72,70,12,64,67,64,67,64,67,128,65,0,64,68,128,65,0,128,82,
0,72,89,6,128,68,0,64,87,128,71,0,64,82,137,76,5,41,0,73,69,9,24,64,83,
128,85,0,72,68,8,64,65,128,68,0,64,67,64,65,128,77,0,136,74,4,0,192,73,
0,64,83,128,65,0,73,80,7,23,128,70,0,72,79,10,64,87,64,73,128,68,0,192,
78,0,128,71,0,72,84,6,128,73,0,64,83,64,65,128,66,0,201,87,52,120,0,73,
73,7,22,128,67,0,73,67,7,10,128,67,0,128,66,0,64,71,128,66,0,72,79,14,136,
80,4,0,64,76,64,65,128,65,0,64,77,72,84,6,128,65,0,128,83,0,200,86,31,0,
73,76,7,20,128,79,0,137,68,5,8,0,128,67,0,64,72,128,84,0,136,83,4,0,128,
80,0,64,85,137,76,5,28,0,73,71,9,18,64,82,128,78,0,64,67,136,87,4,0,128,
80,0,64,73,128,68,0,136,84,4,0,128,77,0,72,90,8,64,80,128,67,0,64,88,64,
71,128,65,0,82,82,11,101,36,93,74,78,98,6,227,73,72,9,48,64,67,128,73,0,
73,67,7,24,128,77,0,72,66,8,64,68,128,74,0,64,65,136,80,4,0,128,73,0,136,
71,4,0,64,68,136,83,4,0,64,73,128,83,0,73,79,9,20,64,65,128,70,0,72,76,
6,128,73,0,64,73,128,66,0,72,90,12,136,73,4,0,64,65,128,70,0,64,80,136,
79,4,0,64,67,64,83,128,83,0,74,71,97,4,141,73,80,7,75,128,80,0,73,71,11,
61,136,85,4,0,128,73,0,200,66,17,0,137,69,5,10,0,64,67,128,89,0,128,77,
0,64,65,73,76,7,16,128,73,0,136,69,4,0,64,68,128,65,0,72,83,8,64,80,128,
73,0,64,78,64,84,128,68,0,64,77,64,73,128,73,0,73,84,7,12,128,82,0,64,83,
128,67,0,64,86,128,65,0,74,68,143,2,174,73,74,7,75,128,66,0,73,69,15,42,
136,77,4,0,64,67,64,79,128,77,0,73,67,11,18,64,77,64,65,128,78,0,64,66,
64,77,128,83,0,64,68,136,80,4,0,128,76,0,73,71,13,21,64,82,64,79,64,85,
128,80,0,192,70,0,64,82,128,83,0,64,73,128,71,0,73,81,7,33,128,76,0,201,
78,11,23,0,192,83,0,128,83,0,64,77,136,66,4,0,192,65,0,128,80,0,128,80,
0,200,83,11,0,136,73,4,0,128,72,0,64,82,137,70,5,10,0,64,65,128,77,0,64,
79,64,77,128,83,0,74,66,101,1,127,137,73,5,39,0,73,69,7,25,128,82,0,73,
67,7,13,128,84,0,192,65,0,128,67,0,64,68,128,68,0,72,71,6,128,72,0,128,
70,0,73,82,7,31,128,67,0,201,78,14,19,0,136,90,4,0,64,69,128,84,0,64,77,
128,65,0,64,79,128,67,0,136,84,4,0,192,83,0,73,79,7,16,128,65,0,136,77,
4,0,64,67,128,80,0,128,85,0,64,65,201,77,30,173,0,73,73,9,22,64,78,128,
80,0,72,68,8,64,65,128,67,0,64,65,128,67,0,128,80,0,201,70,22,108,0,137,
70,5,10,0,64,65,128,67,0,64,80,64,85,128,71,0,201,67,22,37,0,137,72,5,14,
0,72,71,6,128,80,0,128,70,0,128,80,0,64,65,73,80,7,10,128,65,0,128,70,0,
128,90,0,192,68,0,137,82,5,29,0,73,73,9,16,64,85,128,83,0,64,69,64,88,128,
84,0,192,77,0,64,73,128,78,0,73,85,7,12,128,71,0,64,83,128,76,0,64,86,128,
68,0,73,75,9,28,64,73,128,65,0,64,73,137,77,5,12,0,136,73,4,0,128,68,0,
64,78,128,78,0,64,76,64,85,128,83,0,73,83,37,80,73,77,9,22,64,66,128,83,
0,72,70,6,128,70,0,64,68,64,65,128,81,0,72,85,6,128,77,0,64,83,128,70,0,
73,80,15,24,136,68,4,0,64,67,64,65,128,78,0,64,78,64,90,64,67,128,82,0,
64,82,136,80,4,0,64,79,72,82,8,64,65,128,67,0,128,67,0,73,86,7,22,128,73,
0,64,84,72,84,10,64,76,64,82,128,83,0,128,77,0,64,87,128,65,0,192,67,0,
73,77,15,91,137,80,5,8,0,128,72,0,128,82,0,73,68,11,39,136,76,4,0,128,68,
0,73,66,7,15,128,70,0,192,65,0,64,83,128,84,0,64,67,137,71,5,8,0,128,66,
0,128,76,0,73,72,17,26,137,76,5,10,0,64,67,128,67,0,128,80,0,64,70,136,
83,4,0,128,69,0,64,73,72,69,6,128,68,0,128,65,0,73,83,17,46,72,71,8,64,
83,128,79,0,64,66,128,80,0,73,80,15,20,72,84,6,128,65,0,64,83,128,80,0,
64,79,128,77,0,64,82,136,70,4,0,128,65,0,73,85,7,14,128,75,0,64,84,64,80,
128,65,0,192,87,0,128,86,0,72,70,92,73,77,11,53,136,79,4,0,128,68,0,201,
67,16,27,0,72,79,8,64,77,128,77,0,128,77,0,72,66,6,128,82,0,64,65,128,76,
0,72,76,6,128,80,0,64,73,136,79,4,0,128,68,0,137,81,5,23,0,136,80,4,0,192,
79,0,64,78,64,76,64,73,64,78,128,69,0,136,87,4,0,64,82,136,70,4,0,128,65,
0,64,69,73,76,7,169,128,73,0,73,69,21,92,73,78,9,14,64,73,128,67,0,64,69,
128,80,0,128,82,0,73,67,19,64,72,79,8,64,66,128,83,0,64,73,64,83,128,84,
0,72,66,24,73,78,7,18,128,89,0,72,67,6,128,79,0,64,65,128,67,0,128,84,0,
64,65,64,76,72,80,14,64,76,64,65,64,89,64,69,128,82,0,128,79,0,64,68,64,
79,128,88,0,73,73,11,67,136,87,4,0,128,84,0,72,71,43,73,69,18,33,200,88,
7,0,128,80,0,64,68,64,73,128,84,0,64,67,64,76,64,69,64,65,64,78,64,69,128,
82,0,64,77,64,79,128,78,0,64,70,64,82,64,69,64,83,64,69,128,82,0,128,74,
0,73,83,40,86,73,77,9,27,64,65,128,78,0,72,72,15,64,65,64,67,192,75,0,64,
69,128,82,0,128,66,0,136,84,4,0,64,80,128,65,0,73,80,17,35,72,69,10,136,
77,4,0,128,67,0,128,68,0,72,78,10,64,67,64,65,128,80,0,192,77,0,64,73,128,
67,0,64,82,72,84,6,128,82,0,128,80,0,137,85,5,10,0,64,84,128,83,0,64,86,
73,79,9,14,64,76,128,84,0,64,67,128,79,0,64,80,64,65,128,82,0,74,75,21,
1,22,136,73,4,0,192,69,0,64,69,64,80,64,69,128,82,0,73,73,135,235,73,76,
9,70,64,79,128,69,0,73,69,9,47,64,84,128,83,0,201,66,12,33,0,136,78,4,0,
128,65,0,192,65,0,137,74,5,15,0,200,71,7,0,128,69,0,128,65,0,128,82,0,64,
67,128,83,0,72,73,9,192,65,0,128,76,0,64,72,128,68,0,73,80,13,29,72,78,
6,128,71,0,128,65,0,72,79,10,136,85,4,0,128,83,0,192,77,0,128,77,0,200,
83,27,0,73,70,9,16,64,83,128,80,0,136,68,4,0,128,67,0,64,83,64,80,128,65,
0,64,82,128,65,0,64,72,73,73,15,78,137,67,5,8,0,128,66,0,128,84,0,73,69,
11,52,136,86,4,0,128,76,0,72,67,36,73,72,7,20,128,80,0,73,68,7,10,128,83,
0,128,65,0,128,69,0,137,84,5,8,0,128,80,0,64,86,128,65,0,64,65,128,84,0,
64,72,136,73,4,0,64,67,128,67,0,201,78,10,15,0,64,77,128,68,0,64,76,128,
71,0,64,80,128,83,0,192,74,0,73,76,7,16,128,73,0,136,69,4,0,64,67,128,78,
0,128,82,0,72,77,128,73,74,7,63,128,77,0,73,70,11,38,136,70,4,0,128,67,
0,73,67,13,22,64,65,64,84,64,79,128,83,0,64,65,136,83,4,0,128,78,0,64,68,
128,83,0,73,72,7,12,128,67,0,64,71,128,67,0,192,73,0,128,73,0,73,83,14,
43,200,69,7,0,128,65,0,128,68,0,73,79,15,20,137,83,5,8,0,128,78,0,128,87,
0,64,76,128,76,0,64,80,136,84,4,0,128,83,0,73,86,7,14,128,66,0,64,84,64,
83,128,67,0,64,88,128,80,0,192,76,0,73,77,7,49,128,83,0,73,68,7,28,128,
85,0,72,67,8,64,73,128,80,0,64,65,64,78,64,86,64,73,64,69,128,87,0,72,70,
6,128,65,0,192,69,0,64,84,128,73,0,201,83,12,33,0,136,69,4,0,128,68,0,72,
80,6,128,83,0,64,79,72,83,6,128,67,0,64,71,64,73,128,78,0,64,85,64,73,64,
80,128,65,0,74,85,142,3,239,73,76,9,62,64,65,128,67,0,73,70,11,36,64,79,
64,82,128,83,0,72,69,16,137,70,5,10,0,64,67,128,66,0,128,84,0,64,68,136,
80,4,0,128,78,0,72,73,6,128,80,0,64,71,136,80,4,0,64,66,128,67,0,137,80,
5,20,0,72,78,10,64,78,64,69,128,84,0,64,77,128,77,0,72,84,6,128,70,0,64,
83,137,73,5,30,0,73,67,11,18,64,73,64,67,128,79,0,64,65,64,82,128,84,0,
64,69,64,70,128,70,0,72,83,8,64,73,128,82,0,64,78,64,65,64,78,128,79,0,
74,82,104,1,182,73,78,7,56,128,65,0,201,71,8,40,0,128,70,0,201,68,14,23,
0,64,84,64,79,64,79,128,76,0,64,65,136,83,4,0,128,77,0,64,69,136,70,4,0,
128,67,0,136,74,4,0,64,73,128,70,0,73,83,13,36,136,80,4,0,64,72,128,66,
0,73,80,11,16,136,80,4,0,128,70,0,64,79,128,68,0,64,82,64,70,128,82,0,136,
87,4,0,128,84,0,74,80,96,1,65,137,78,5,47,0,137,71,5,29,0,73,68,7,19,128,
79,0,192,67,0,136,83,4,0,64,78,128,65,0,64,69,128,84,0,72,75,6,128,73,0,
64,74,64,80,128,68,0,73,82,11,22,136,71,4,0,128,65,0,72,80,6,128,82,0,64,
79,128,65,0,200,84,7,0,128,86,0,64,83,137,76,5,10,0,64,71,128,66,0,128,
85,0,64,79,73,76,21,117,72,76,12,64,66,64,65,64,67,128,75,0,64,65,128,80,
0,137,71,5,51,0,73,68,7,41,128,67,0,200,67,13,0,72,79,6,128,82,0,128,69,
0,64,65,73,68,7,16,128,77,0,72,67,6,128,69,0,128,65,0,128,69,0,64,70,128,
82,0,201,73,12,26,0,136,80,4,0,128,67,0,192,72,0,137,79,5,8,0,128,67,0,
128,83,0,64,75,73,77,7,12,128,67,0,64,65,128,70,0,64,83,128,79,0,201,82,
14,38,0,136,79,4,0,64,65,128,67,0,73,79,7,17,128,65,0,192,77,0,64,77,64,
79,128,78,0,64,80,64,73,128,68,0,73,84,35,60,73,72,7,26,128,82,0,200,70,
16,0,192,76,0,64,65,64,83,64,84,128,67,0,128,67,0,64,83,128,69,0,64,83,
137,73,5,14,0,72,69,6,128,80,0,128,67,0,64,83,64,80,64,69,128,78,0,192,
86,0,64,83,128,70,0,64,81,136,80,4,0,64,68,64,80,128,67,0,72,84,212,73,
76,7,107,128,83,0,73,69,9,79,64,67,128,83,0,201,67,32,49,0,73,83,7,20,128,
82,0,73,73,7,10,128,83,0,128,67,0,128,80,0,136,89,4,0,128,87,0,72,66,6,
128,70,0,64,65,72,80,6,128,73,0,128,73,0,64,68,137,73,5,14,0,72,72,6,128,
67,0,128,67,0,64,78,128,65,0,73,72,7,16,128,75,0,72,71,6,128,83,0,128,70,
0,64,75,128,70,0,73,82,7,51,128,73,0,73,79,11,41,136,83,4,0,128,71,0,72,
78,8,64,68,128,65,0,192,77,0,73,80,7,16,128,69,0,136,77,4,0,64,70,128,80,
0,128,84,0,128,80,0,73,86,13,44,136,84,4,0,64,66,128,82,0,200,84,17,0,137,
82,5,8,0,128,78,0,64,84,128,76,0,192,83,0,137,74,5,8,0,128,69,0,128,80,
0,64,87,64,80,128,66,0,64,83,73,76,9,130,64,73,128,67,0,73,69,7,78,128,
73,0,73,67,13,63,72,79,6,128,83,0,128,67,0,72,66,19,201,73,8,13,0,128,65,
0,64,65,128,67,0,128,89,0,64,65,73,77,11,22,136,68,4,0,128,65,0,72,68,6,
128,87,0,64,65,128,68,0,136,84,4,0,128,80,0,192,68,0,64,76,128,80,0,137,
72,5,28,0,72,71,12,72,72,6,128,72,0,128,66,0,64,70,72,83,6,128,82,0,128,
81,0,64,73,137,80,5,10,0,64,65,128,84,0,128,84,0,73,82,7,50,128,66,0,73,
79,11,22,136,86,4,0,128,80,0,72,78,6,128,65,0,64,77,128,85,0,64,80,73,67,
7,16,128,65,0,136,66,4,0,64,65,128,78,0,128,79,0,73,85,11,27,136,72,4,0,
128,68,0,72,84,6,128,80,0,192,83,0,136,85,4,0,128,73,0,192,86,0,128,80,
0,73,88,17,118,73,84,7,10,128,69,0,128,82,0,128,86,0,72,87,56,73,80,9,30,
64,80,128,73,0,73,73,7,16,128,78,0,72,71,6,128,86,0,128,68,0,64,74,128,
70,0,137,83,5,18,0,72,82,6,128,72,0,64,81,64,67,128,66,0,64,84,128,72,0,
64,86,73,79,7,28,128,69,0,73,70,7,16,128,70,0,136,68,4,0,64,67,128,80,0,
64,77,128,83,0,137,82,5,10,0,64,80,128,78,0,64,83,128,77,0,72,90,14,72,
87,6,128,83,0,64,73,128,77,0,64,89,136,76,4,0,128,65,0,82,80,13,121,22,
150,74,78,76,7,215,73,77,7,40,128,65,0,73,69,7,26,128,86,0,72,66,6,128,
76,0,64,65,137,68,5,8,0,128,67,0,128,83,0,136,76,4,0,128,71,0,73,84,7,26,
128,82,0,72,82,10,136,80,4,0,128,67,0,64,78,136,76,4,0,128,73,0,64,86,128,
83,0,74,71,103,4,137,73,76,11,59,136,79,4,0,128,76,0,73,70,7,27,128,78,
0,200,68,15,0,72,76,8,64,65,128,78,0,128,71,0,64,65,128,68,0,72,74,12,136,
69,4,0,64,68,128,70,0,64,73,64,77,64,69,128,82,0,73,79,11,23,136,85,4,0,
128,77,0,200,78,9,0,64,73,128,71,0,128,77,0,72,83,6,128,77,0,192,80,0,136,
80,4,0,128,79,0,74,68,154,3,4,73,76,7,80,128,67,0,201,70,12,55,0,64,83,
64,65,128,77,0,73,68,9,38,64,82,128,77,0,72,67,19,137,67,5,13,0,192,65,
0,64,65,128,83,0,128,70,0,192,65,0,136,83,4,0,128,70,0,64,69,128,65,0,137,
72,5,13,0,64,71,192,70,0,128,82,0,64,73,128,80,0,73,82,11,43,136,89,4,0,
128,75,0,73,79,7,20,128,80,0,200,78,7,0,128,65,0,192,77,0,128,83,0,192,
80,0,72,84,6,128,65,0,128,65,0,201,85,10,19,0,64,70,128,65,0,64,83,136,
78,4,0,128,65,0,64,86,64,83,128,65,0,74,66,103,1,133,73,77,7,60,128,82,
0,73,69,7,29,128,77,0,73,67,10,15,192,67,0,128,72,0,64,65,128,80,0,64,68,
64,68,128,82,0,201,71,12,17,0,136,67,4,0,128,65,0,64,70,128,68,0,64,76,
64,65,128,83,0,137,82,5,24,0,73,79,11,16,136,84,4,0,128,67,0,64,78,128,
85,0,128,80,0,72,85,6,128,72,0,64,83,192,67,0,128,84,0,64,65,201,78,18,
155,0,72,89,8,64,78,128,74,0,64,83,128,83,0,137,69,5,94,0,73,67,52,84,73,
79,7,28,128,77,0,73,66,7,18,128,73,0,64,65,64,76,64,72,64,79,128,85,0,128,
76,0,72,85,10,64,67,64,79,128,65,0,192,83,0,64,76,64,65,128,67,0,72,66,
16,73,71,7,10,128,73,0,128,65,0,128,80,0,64,65,200,83,9,0,64,67,128,85,
0,64,69,128,84,0,64,68,128,73,0,73,73,15,38,72,67,8,64,69,128,88,0,128,
65,0,72,72,6,128,79,0,64,71,137,71,5,12,0,64,65,64,83,128,65,0,128,80,0,
64,76,128,67,0,73,84,22,101,137,84,5,15,0,136,83,4,0,192,65,0,128,67,0,
128,87,0,73,82,27,39,137,67,5,16,0,64,65,64,75,64,73,64,83,128,83,0,64,
84,64,65,128,68,0,200,80,7,0,128,82,0,64,79,128,68,0,64,83,137,77,5,21,
0,201,73,8,13,0,128,67,0,64,71,128,84,0,128,74,0,137,82,5,10,0,64,80,128,
71,0,64,83,64,79,128,80,0,73,87,7,12,128,65,0,64,85,128,68,0,64,89,137,
69,5,8,0,128,68,0,192,71,0,128,79,0,64,67,73,74,9,136,64,83,128,83,0,73,
69,15,90,72,77,6,128,80,0,64,72,128,82,0,73,67,27,70,73,67,7,18,128,72,
0,136,66,4,0,64,65,64,82,128,68,0,64,84,128,83,0,200,66,13,0,72,83,6,128,
68,0,128,65,0,64,65,73,83,11,22,64,84,64,82,128,68,0,72,80,6,128,65,0,64,
79,128,66,0,192,84,0,128,73,0,64,68,128,85,0,73,72,7,18,128,82,0,72,71,
6,128,71,0,64,70,128,70,0,192,73,0,200,69,9,0,64,82,128,68,0,64,68,64,83,
128,83,0,201,82,12,72,0,136,77,4,0,128,69,0,73,79,13,43,136,78,4,0,64,73,
128,80,0,72,78,9,192,65,0,128,66,0,64,77,73,67,9,14,64,73,128,65,0,64,65,
128,86,0,64,79,128,83,0,64,80,73,66,7,10,128,84,0,128,65,0,64,73,128,82,
0,137,85,5,12,0,64,83,64,73,128,82,0,64,86,64,67,128,82,0,72,70,101,73,
78,7,59,128,76,0,73,73,19,34,137,70,5,10,0,64,65,128,66,0,64,76,128,69,
0,73,70,7,10,128,83,0,128,67,0,64,71,128,69,0,200,77,7,0,128,65,0,64,76,
136,80,4,0,64,65,128,71,0,73,85,11,26,136,82,4,0,128,74,0,72,84,12,136,
87,4,0,64,65,128,67,0,128,82,0,72,87,10,136,82,4,0,128,65,0,128,86,0,64,
69,73,77,21,97,72,70,12,136,67,4,0,64,65,128,82,0,64,69,128,88,0,73,70,
17,57,73,67,7,10,128,79,0,128,65,0,128,82,0,73,67,30,35,201,83,10,21,0,
64,82,128,76,0,136,73,4,0,64,69,64,82,128,65,0,64,86,128,68,0,64,65,128,
80,0,64,68,128,67,0,72,74,6,128,69,0,64,71,72,83,8,64,67,128,79,0,128,73,
0,201,83,8,75,0,128,81,0,73,80,17,22,72,70,8,64,65,128,82,0,64,65,128,78,
0,64,79,128,67,0,64,82,137,76,5,34,0,73,68,9,20,64,67,128,65,0,64,65,72,
68,6,128,73,0,128,66,0,64,70,64,77,64,79,128,78,0,136,84,4,0,64,79,128,
77,0,72,90,6,128,65,0,64,84,128,65,0,74,75,64,1,186,73,78,7,34,128,83,0,
73,70,13,24,136,90,4,0,64,65,128,68,0,72,67,6,128,83,0,64,66,128,73,0,128,
73,0,73,83,7,12,128,70,0,64,80,128,85,0,64,89,64,90,64,73,64,86,64,65,128,
84,0,74,73,214,1,103,73,74,9,109,64,65,128,67,0,73,69,9,69,64,80,128,82,
0,73,67,23,44,73,77,7,16,128,71,0,64,75,64,85,64,80,128,83,0,128,85,0,200,
66,9,0,64,65,128,67,0,192,65,0,136,83,4,0,64,68,128,67,0,192,68,0,73,82,
7,10,128,65,0,128,70,0,128,83,0,73,72,17,26,72,77,6,128,83,0,64,75,64,65,
128,76,0,64,70,136,67,4,0,128,65,0,64,73,128,73,0,73,79,15,44,72,80,8,64,
69,128,68,0,128,74,0,73,77,13,26,136,70,4,0,64,67,128,79,0,72,76,8,64,80,
128,71,0,64,75,128,84,0,128,78,0,73,82,19,41,73,76,7,10,128,83,0,128,71,
0,64,79,128,77,0,192,80,0,73,72,7,14,128,79,0,64,69,64,68,128,65,0,64,83,
128,67,0,64,83,73,67,7,10,128,76,0,128,65,0,128,78,0,64,72,73,77,9,72,64,
83,128,65,0,73,69,13,36,136,86,4,0,64,77,128,84,0,137,66,5,18,0,64,65,72,
83,6,128,82,0,64,67,128,84,0,64,67,128,78,0,72,76,8,64,65,128,75,0,64,73,
72,86,12,64,79,64,76,64,67,128,83,0,64,71,128,83,0,201,82,20,55,0,137,73,
5,10,0,64,70,128,67,0,64,77,128,65,0,72,80,20,73,80,7,14,128,79,0,64,73,
64,68,128,83,0,128,86,0,64,79,72,82,6,128,67,0,64,78,64,69,128,88,0,72,
89,10,64,76,64,73,128,80,0,192,83,0,128,73,0,64,74,137,76,5,12,0,64,65,
64,76,128,83,0,64,84,128,70,0,72,77,165,137,75,5,86,0,73,68,7,59,128,67,
0,201,66,10,37,0,64,79,128,75,0,64,65,73,80,7,20,128,73,0,72,74,6,128,79,
0,64,71,64,73,128,67,0,64,82,128,80,0,64,67,72,80,6,128,65,0,64,77,64,70,
128,65,0,137,71,5,16,0,64,69,72,84,6,128,66,0,128,71,0,192,73,0,128,73,
0,73,80,7,49,128,77,0,73,78,7,20,128,83,0,64,77,137,76,5,8,0,128,73,0,128,
77,0,192,79,0,137,78,5,16,0,72,76,8,64,69,128,68,0,128,71,0,128,80,0,72,
84,18,73,83,7,12,128,65,0,64,67,128,84,0,128,85,0,64,82,136,70,4,0,128,
67,0,64,76,137,76,5,100,0,73,70,7,66,128,65,0,73,68,11,54,136,83,4,0,128,
73,0,72,67,10,136,80,4,0,128,67,0,64,65,72,78,26,64,84,64,83,64,86,64,83,
64,90,64,79,64,77,64,66,64,73,64,69,128,83,0,64,65,128,70,0,64,69,128,88,
0,73,73,19,24,73,78,7,12,128,81,0,64,68,128,65,0,128,80,0,64,71,128,83,
0,64,75,128,78,0,73,84,15,42,137,83,5,8,0,128,78,0,128,85,0,73,79,7,21,
128,83,0,72,78,8,64,76,128,80,0,192,77,0,128,78,0,192,82,0,128,85,0,73,
87,9,14,64,72,128,65,0,64,85,128,82,0,64,90,128,84,0,74,85,98,4,161,73,
72,9,56,64,67,128,65,0,73,67,17,44,73,77,7,10,128,77,0,128,76,0,128,80,
0,72,66,24,73,80,9,14,64,65,128,84,0,64,65,128,84,0,64,83,64,85,128,66,
0,128,65,0,128,69,0,73,83,15,30,64,80,72,69,6,128,77,0,128,65,0,72,82,8,
64,66,128,76,0,64,75,64,65,128,82,0,64,87,64,69,128,82,0,202,82,238,2,199,
0,73,77,21,106,137,76,5,14,0,72,73,6,128,65,0,128,68,0,128,77,0,73,71,15,
42,137,77,5,8,0,128,70,0,128,84,0,73,67,7,14,128,83,0,64,66,64,79,128,77,
0,64,69,64,81,64,86,64,69,64,67,128,65,0,72,73,32,72,78,24,64,67,64,69,
64,79,64,70,64,80,64,69,64,82,64,83,64,73,128,65,0,64,65,128,69,0,64,72,
72,73,6,128,82,0,128,67,0,73,83,25,85,137,73,5,12,0,136,71,4,0,128,65,0,
72,83,6,128,65,0,128,80,0,73,79,41,52,73,70,11,30,64,69,64,67,128,79,0,
72,67,10,64,77,64,79,128,78,0,64,65,64,84,64,73,128,65,0,64,85,64,78,128,
73,0,64,78,136,71,4,0,64,68,128,76,0,64,82,192,83,0,128,86,0,72,87,10,64,
79,64,82,128,65,0,64,84,73,77,7,22,128,73,0,137,71,5,10,0,64,67,128,77,
0,64,76,128,73,0,136,86,4,0,128,82,0,74,80,209,1,162,73,77,11,121,136,86,
4,0,128,69,0,201,69,10,54,0,64,82,128,65,0,201,67,10,41,0,64,82,128,86,
0,136,66,4,0,64,65,137,80,5,14,0,136,73,4,0,64,67,128,65,0,72,84,6,128,
75,0,64,82,128,67,0,128,68,0,201,73,28,49,0,73,73,9,20,64,78,128,65,0,72,
72,6,128,67,0,64,65,128,70,0,128,80,0,72,71,16,137,66,5,8,0,128,65,0,64,
69,128,65,0,64,70,128,73,0,64,76,64,80,128,73,0,73,83,7,56,128,87,0,201,
80,26,44,0,73,73,7,12,128,80,0,64,70,128,65,0,64,79,136,69,4,0,128,65,0,
200,79,13,0,72,80,6,128,80,0,128,75,0,64,78,128,73,0,64,82,128,75,0,201,
85,10,19,0,64,77,128,80,0,64,84,136,86,4,0,128,80,0,192,86,0,64,80,128,
78,0,64,79,73,74,7,95,128,79,0,73,70,9,42,64,65,128,75,0,73,68,7,21,128,
67,0,200,67,9,0,64,72,128,80,0,64,65,128,71,0,192,69,0,72,80,6,128,82,0,
128,65,0,73,72,15,26,64,77,64,69,64,76,64,70,128,83,0,64,71,72,73,6,128,
76,0,128,67,0,192,73,0,64,78,64,84,64,79,64,70,64,86,64,73,64,69,128,87,
0,201,83,30,77,0,73,77,9,20,64,69,128,68,0,72,73,6,128,80,0,64,67,128,72,
0,64,208,128,156,0,73,79,7,35,128,77,0,200,78,19,0,137,82,5,12,0,64,65,
64,82,128,83,0,128,86,0,64,77,64,82,64,65,128,67,0,192,80,0,136,76,4,0,
64,65,128,73,0,137,86,5,30,0,64,84,137,70,5,14,0,136,67,4,0,64,66,128,83,
0,72,85,6,128,83,0,128,83,0,64,89,128,73,0,64,81,201,73,10,36,0,64,74,128,
80,0,201,70,8,21,0,128,80,0,64,67,137,68,5,8,0,128,67,0,128,84,0,64,71,
128,80,0,73,82,7,12,128,73,0,64,76,128,83,0,64,83,128,87,0,72,84,147,73,
78,9,99,64,78,128,84,0,73,68,7,47,128,83,0,137,66,5,14,0,64,65,136,84,4,
0,128,77,0,192,67,0,73,80,9,18,64,82,128,69,0,72,79,6,128,77,0,128,65,0,
64,82,128,66,0,73,72,31,36,73,82,13,16,64,69,64,65,64,68,128,83,0,128,73,
0,64,85,64,66,64,69,64,82,128,84,0,64,70,128,66,0,64,76,64,76,128,83,0,
73,83,11,29,136,78,4,0,128,68,0,137,80,5,11,0,192,79,0,128,77,0,64,82,64,
85,128,69,0,73,86,7,13,128,83,0,192,84,0,128,71,0,128,90,0,64,83,73,78,
25,136,137,73,5,18,0,72,69,8,64,88,128,84,0,64,67,128,82,0,128,82,0,73,
72,7,72,128,69,0,73,67,11,40,64,65,64,66,128,73,0,72,66,10,136,82,4,0,128,
68,0,64,65,137,80,5,14,0,72,77,6,128,80,0,128,66,0,128,83,0,64,69,73,68,
7,12,128,83,0,64,67,128,85,0,64,76,64,70,64,69,64,88,128,84,0,73,76,7,31,
128,86,0,200,75,7,0,128,67,0,64,73,72,82,10,136,85,4,0,128,84,0,64,80,128,
67,0,64,77,192,83,0,128,76,0,73,84,7,55,128,78,0,73,82,19,37,73,69,7,12,
128,70,0,64,65,128,77,0,128,82,0,200,80,13,0,72,86,6,128,67,0,128,82,0,
64,79,128,67,0,64,83,72,78,6,128,89,0,128,77,0,73,89,15,33,72,79,8,64,80,
128,83,0,128,66,0,72,86,6,128,73,0,192,85,0,136,86,4,0,64,66,128,71,0,128,
90,0,73,89,39,226,73,80,7,26,128,73,0,73,76,7,14,128,76,0,64,71,64,84,128,
75,0,64,77,128,69,0,136,84,4,0,64,82,128,79,0,201,87,96,180,0,73,76,13,
43,136,66,4,0,64,65,128,78,0,73,69,7,16,128,73,0,72,67,6,128,84,0,128,66,
0,200,73,7,0,128,83,0,64,71,64,83,128,67,0,73,83,9,39,64,69,128,88,0,72,
78,6,128,83,0,192,77,0,73,77,7,14,128,67,0,64,73,64,83,128,67,0,64,82,64,
73,128,83,0,64,84,136,84,4,0,128,67,0,64,86,137,73,5,47,0,73,69,7,25,128,
67,0,73,67,9,15,64,72,128,82,0,192,65,0,128,67,0,128,68,0,73,71,7,12,128,
79,0,64,70,128,83,0,64,72,128,79,0,73,83,7,28,128,84,0,201,80,10,13,0,64,
71,128,78,0,128,77,0,192,82,0,64,83,128,84,0,136,89,4,0,128,85,0,64,88,
64,79,128,77,0,72,208,18,72,157,8,64,208,128,157,0,64,156,64,208,128,156,
0,64,90,64,69,128,86,0,64,79,74,77,135,4,241,201,72,8,62,0,128,79,0,201,
69,14,33,0,72,82,6,128,83,0,128,77,0,201,66,10,13,0,64,79,128,75,0,128,
65,0,192,68,0,128,66,0,136,71,4,0,64,70,137,79,5,10,0,64,71,128,71,0,64,
85,128,71,0,73,83,13,57,136,73,4,0,64,72,128,82,0,73,76,7,25,128,84,0,192,
73,0,137,73,5,12,0,64,71,64,83,128,65,0,128,77,0,64,78,73,79,7,14,128,77,
0,64,69,64,82,128,67,0,128,82,0,72,86,6,128,67,0,64,84,128,80,0,74,71,59,
3,5,137,74,5,25,0,73,68,7,17,128,73,0,200,67,7,0,128,70,0,128,65,0,128,
70,0,73,83,19,24,137,73,5,12,0,136,69,4,0,128,65,0,128,77,0,64,75,128,77,
0,64,84,128,84,0,74,68,126,1,253,73,76,9,66,64,81,128,67,0,73,69,9,32,64,
80,128,79,0,73,66,7,18,128,79,0,64,65,72,84,6,128,65,0,128,67,0,64,67,128,
73,0,73,73,17,22,73,72,7,10,128,82,0,128,70,0,128,82,0,64,70,128,87,0,128,
75,0,73,82,7,44,128,76,0,73,78,15,31,137,73,5,8,0,128,70,0,128,82,0,64,
77,137,71,5,8,0,128,65,0,192,82,0,128,80,0,192,80,0,128,77,0,72,86,6,128,
65,0,64,83,128,84,0,73,66,82,223,73,77,11,51,136,77,4,0,128,76,0,73,69,
7,17,128,88,0,200,68,7,0,128,82,0,128,67,0,72,73,18,73,82,7,12,128,78,0,
64,69,128,69,0,128,83,0,64,71,128,75,0,137,86,5,22,0,72,83,12,136,69,4,
0,64,65,128,73,0,64,82,128,77,0,64,89,128,79,0,64,65,73,76,11,53,136,74,
4,0,128,68,0,73,70,7,25,128,66,0,73,68,7,13,128,77,0,192,66,0,128,83,0,
64,69,128,80,0,72,73,12,136,83,4,0,64,70,128,65,0,64,71,128,67,0,201,83,
22,64,0,73,76,7,12,128,77,0,64,68,128,73,0,64,79,128,83,0,73,80,25,35,73,
69,11,16,136,78,4,0,128,67,0,64,65,128,83,0,64,83,128,69,0,192,77,0,136,
67,4,0,128,65,0,64,82,64,68,128,67,0,200,85,7,0,128,71,0,64,84,72,69,8,
64,76,128,83,0,64,65,128,71,0,64,67,201,73,16,86,0,72,83,6,128,83,0,64,
77,128,70,0,201,68,12,49,0,64,69,64,84,128,70,0,73,66,9,20,64,79,128,65,
0,64,65,72,77,6,128,76,0,128,68,0,64,67,137,77,5,10,0,64,68,128,79,0,64,
82,128,80,0,73,71,7,12,128,84,0,64,70,128,83,0,64,72,136,80,4,0,128,65,
0,201,83,21,43,0,137,80,5,13,0,64,76,192,65,0,128,67,0,128,87,0,73,77,9,
19,64,76,128,80,0,192,76,0,136,86,4,0,128,67,0,128,82,0,73,85,11,24,136,
82,4,0,128,80,0,64,84,136,71,4,0,64,65,64,86,128,69,0,64,87,128,82,0,72,
70,120,73,73,7,72,128,68,0,73,69,11,50,136,84,4,0,128,68,0,201,67,22,31,
0,73,68,7,12,128,77,0,64,67,128,80,0,64,79,128,77,0,64,65,136,83,4,0,128,
67,0,64,68,192,77,0,128,65,0,72,72,8,64,69,128,79,0,64,71,64,69,128,77,
0,73,83,15,36,72,84,8,64,69,128,68,0,128,65,0,73,77,11,16,64,68,64,70,128,
77,0,64,76,128,67,0,64,78,128,80,0,136,87,4,0,64,84,128,80,0,192,69,0,137,
76,5,43,0,201,69,8,27,0,128,67,0,73,66,7,10,128,83,0,128,65,0,64,67,136,
83,4,0,128,68,0,72,72,8,64,72,128,65,0,128,70,0,201,82,8,20,0,128,73,0,
72,80,6,128,69,0,192,77,0,128,75,0,72,86,6,128,67,0,64,83,137,68,5,8,0,
128,65,0,128,70,0,73,74,40,251,73,77,7,26,128,83,0,73,72,7,12,128,76,0,
64,69,128,85,0,64,74,64,68,128,80,0,136,84,4,0,192,83,0,128,67,0,72,73,
114,73,73,9,74,64,65,128,73,0,201,67,22,53,0,73,86,7,14,128,77,0,64,69,
64,84,128,83,0,128,87,0,72,66,22,73,69,7,12,128,67,0,64,68,128,65,0,64,
73,64,68,128,65,0,64,65,136,77,4,0,128,71,0,136,71,4,0,192,68,0,64,67,128,
65,0,201,82,8,23,0,128,72,0,72,80,12,72,76,6,128,67,0,128,70,0,128,78,0,
136,84,4,0,192,83,0,136,83,4,0,128,70,0,64,72,73,75,7,51,128,79,0,73,67,
17,31,73,72,7,10,128,82,0,128,65,0,128,73,0,72,66,6,128,77,0,192,65,0,64,
83,128,68,0,72,73,6,128,77,0,64,72,64,68,128,76,0,73,83,19,33,73,77,7,12,
128,83,0,64,72,128,67,0,128,85,0,72,77,8,64,83,128,65,0,192,76,0,128,67,
0,72,87,6,128,83,0,64,84,128,83,0,72,76,66,73,80,11,33,136,70,4,0,128,67,
0,201,69,8,13,0,128,68,0,64,65,128,80,0,64,72,64,73,64,71,128,65,0,73,84,
11,23,136,80,4,0,128,76,0,192,83,0,136,82,4,0,64,65,128,83,0,64,86,64,87,
128,77,0,64,75,201,67,10,25,0,64,65,128,71,0,72,66,6,128,67,0,64,65,64,
73,64,70,128,65,0,72,73,8,64,79,128,67,0,64,71,128,79,0,74,84,131,3,129,
73,73,13,76,72,83,6,128,84,0,128,70,0,73,68,17,46,73,79,7,10,128,65,0,128,
77,0,128,82,0,137,66,5,21,0,192,65,0,137,80,5,8,0,128,78,0,64,83,128,80,
0,192,67,0,64,66,128,66,0,73,70,7,14,128,69,0,64,69,64,73,128,80,0,128,
71,0,73,82,7,27,128,83,0,73,79,7,10,128,72,0,128,78,0,192,80,0,64,82,64,
79,128,77,0,72,84,14,72,79,8,64,77,128,72,0,128,68,0,64,83,136,73,4,0,128,
70,0,202,81,17,1,111,0,72,80,8,64,83,128,75,0,128,76,0,73,79,109,196,137,
70,5,51,0,201,67,8,24,0,128,76,0,200,66,7,0,128,69,0,64,65,136,75,4,0,128,
68,0,72,69,8,64,77,128,67,0,192,68,0,137,66,5,8,0,128,65,0,128,84,0,73,
84,18,47,137,68,5,8,0,128,66,0,192,76,0,128,84,0,200,83,7,0,128,69,0,192,
80,0,137,80,5,12,0,64,65,64,82,128,84,0,64,83,64,76,128,65,0,64,88,64,77,
128,76,0,64,78,73,71,7,50,128,67,0,73,68,13,30,136,68,4,0,64,67,128,80,
0,72,67,8,64,67,128,65,0,64,65,64,77,64,69,128,84,0,72,70,6,128,73,0,64,
69,64,70,128,65,0,73,85,11,28,64,77,64,85,128,78,0,72,84,6,128,68,0,64,
76,72,85,6,128,83,0,128,70,0,64,86,64,73,128,70,0,64,80,73,76,9,97,64,73,
128,78,0,73,71,7,69,128,65,0,201,67,8,23,0,128,87,0,64,65,73,77,7,10,128,
80,0,128,67,0,128,84,0,64,69,73,78,17,30,72,84,8,64,84,128,68,0,64,67,128,
76,0,137,67,5,8,0,128,66,0,64,73,128,85,0,136,83,4,0,128,80,0,73,73,11,
16,136,84,4,0,128,67,0,64,72,128,84,0,128,75,0,73,82,9,40,64,69,128,84,
0,73,79,7,24,128,83,0,64,77,137,76,5,12,0,64,73,64,65,128,83,0,128,84,0,
64,80,64,80,128,83,0,72,87,10,136,84,4,0,128,65,0,64,86,128,66,0,80,83,
1,31,73,77,13,188,72,84,6,128,72,0,128,70,0,73,70,7,87,128,77,0,73,67,35,
75,137,76,5,20,0,137,69,5,12,0,64,67,64,79,128,78,0,128,73,0,72,79,6,128,
78,0,64,77,128,83,0,200,66,19,0,73,68,9,12,64,67,128,78,0,128,67,0,128,
70,0,64,65,73,72,7,16,128,83,0,72,68,6,128,76,0,128,67,0,128,80,0,64,68,
128,76,0,201,73,30,75,0,73,78,15,20,136,84,4,0,64,76,64,67,128,80,0,64,
77,128,77,0,64,82,128,77,0,72,72,30,73,82,7,16,128,67,0,72,80,6,128,68,
0,128,65,0,72,84,6,128,67,0,64,83,128,66,0,64,71,137,70,5,10,0,64,69,128,
79,0,128,73,0,64,76,72,84,6,128,70,0,64,69,128,67,0,73,83,43,75,137,80,
5,20,0,73,73,7,10,128,77,0,128,68,0,64,76,128,84,0,137,83,5,12,0,64,82,
64,69,128,65,0,64,84,64,77,128,77,0,73,80,7,23,128,70,0,72,79,10,136,82,
4,0,128,69,0,192,78,0,128,82,0,64,82,136,77,4,0,128,68,0,201,85,8,13,0,
128,77,0,64,84,128,80,0,64,87,64,69,128,82,0,64,82,201,77,10,59,0,64,81,
128,76,0,73,68,11,32,64,66,64,77,128,83,0,201,66,8,16,0,128,68,0,64,65,
192,67,0,128,65,0,64,67,128,70,0,72,76,6,128,77,0,64,69,136,87,4,0,64,76,
128,65,0,73,83,17,34,72,84,8,64,79,128,77,0,64,65,128,83,0,72,80,12,136,
71,4,0,64,65,128,83,0,64,78,128,76,0,72,86,6,128,82,0,64,84,72,73,6,128,
65,0,128,70,0,73,87,62,150,137,75,5,35,0,137,67,5,23,0,136,66,4,0,192,65,
0,72,83,6,128,80,0,64,77,128,80,0,136,72,4,0,128,68,0,73,83,7,18,128,73,
0,72,82,6,128,83,0,64,76,128,69,0,64,87,128,65,0,72,86,60,73,76,7,35,128,
79,0,137,70,5,23,0,72,67,8,64,82,128,68,0,192,65,0,136,69,4,0,128,66,0,
64,75,128,83,0,201,83,8,19,0,128,70,0,136,80,4,0,64,77,64,83,128,84,0,128,
87,0,64,85,137,78,5,18,0,72,77,8,64,87,128,65,0,64,66,128,83,0,192,80,0,
64,83,128,68,0,72,89,14,72,80,6,128,68,0,64,77,128,67,0,64,88,128,77,0,
64,81,74,77,40,1,31,73,82,7,26,128,83,0,137,72,5,12,0,64,67,64,83,128,79,
0,64,74,64,72,128,76,0,72,84,6,128,80,0,128,83,0,73,70,23,148,73,73,7,14,
128,73,0,136,69,4,0,128,68,0,64,82,128,83,0,201,67,26,82,0,137,79,5,14,
0,72,73,6,128,70,0,128,65,0,64,83,64,66,128,83,0,72,66,16,136,69,4,0,64,
65,64,83,64,73,128,67,0,192,65,0,73,76,7,24,128,89,0,73,68,7,14,128,67,
0,64,65,64,87,128,83,0,128,70,0,72,82,10,64,65,64,78,128,67,0,128,77,0,
72,69,12,136,72,4,0,64,69,128,71,0,192,68,0,137,81,5,23,0,72,79,6,128,83,
0,64,73,200,83,7,0,128,67,0,128,73,0,64,82,128,79,0,73,73,56,72,73,78,7,
33,128,81,0,201,71,12,21,0,64,79,64,78,128,71,0,136,70,4,0,64,68,128,82,
0,64,77,128,82,0,73,84,9,16,64,77,128,70,0,136,83,4,0,128,80,0,128,86,0,
200,72,9,0,64,83,128,69,0,64,71,64,73,128,83,0,72,76,18,72,86,10,64,78,
64,67,128,72,0,64,76,128,67,0,64,75,136,68,4,0,128,66,0,73,83,64,219,73,
78,9,33,64,67,128,67,0,73,70,7,19,128,80,0,72,66,6,128,79,0,192,65,0,128,
82,0,64,76,128,68,0,73,81,7,24,128,84,0,192,80,0,137,73,5,11,0,192,69,0,
128,67,0,128,78,0,128,85,0,73,80,38,94,137,73,5,16,0,72,67,6,128,82,0,64,
65,128,73,0,200,83,15,0,137,75,5,8,0,128,73,0,128,84,0,128,76,0,72,79,37,
73,81,9,16,64,65,128,77,0,136,76,4,0,128,69,0,72,84,12,72,83,6,128,65,0,
128,68,0,192,83,0,128,77,0,64,78,137,67,5,10,0,64,65,128,78,0,64,85,64,
80,128,83,0,72,82,44,201,70,8,22,0,128,67,0,200,68,7,0,128,82,0,64,66,64,
71,128,83,0,72,83,12,136,83,4,0,64,65,128,77,0,64,79,64,80,128,83,0,64,
81,72,81,10,64,86,64,71,128,65,0,64,73,128,67,0,73,86,37,73,73,71,7,20,
128,65,0,73,68,7,10,128,80,0,128,66,0,128,70,0,73,77,7,10,128,84,0,128,
76,0,128,79,0,72,85,18,137,77,5,12,0,64,65,64,73,128,65,0,128,84,0,64,84,
73,72,7,13,128,76,0,192,69,0,128,76,0,128,76,0,72,90,8,64,83,128,83,0,64,
87,73,73,7,14,128,80,0,64,65,64,86,128,69,0,64,83,128,67,0,80,84,10,218,
74,77,157,6,104,73,73,7,77,128,73,0,73,69,21,46,73,73,7,12,128,67,0,64,
69,128,67,0,64,83,128,69,0,73,67,7,12,128,77,0,64,66,128,71,0,64,68,137,
76,5,8,0,128,69,0,128,83,0,201,71,12,15,0,136,85,4,0,128,69,0,128,70,0,
64,72,136,85,4,0,128,66,0,73,82,10,48,192,67,0,128,65,0,201,78,16,33,0,
137,80,5,8,0,128,75,0,128,84,0,64,77,137,82,5,12,0,136,75,4,0,128,65,0,
128,84,0,64,81,128,76,0,73,84,17,22,72,84,6,128,67,0,64,69,64,67,128,72,
0,64,83,128,73,0,64,85,128,75,0,74,71,69,4,37,73,71,7,41,128,69,0,73,67,
9,22,64,83,128,65,0,72,66,8,64,79,128,80,0,64,65,128,76,0,192,70,0,72,79,
6,128,80,0,128,66,0,137,84,5,18,0,72,82,8,64,69,128,80,0,64,73,128,70,0,
64,87,128,85,0,202,68,149,2,168,0,73,79,7,90,128,65,0,73,70,13,45,72,70,
6,128,65,0,128,66,0,201,68,8,17,0,128,66,0,64,67,136,86,4,0,128,74,0,64,
69,73,82,7,10,128,77,0,128,69,0,128,83,0,201,77,22,27,0,137,70,5,12,0,136,
67,4,0,128,65,0,64,79,128,69,0,64,73,128,67,0,64,78,136,84,4,0,64,65,128,
77,0,73,84,7,32,128,79,0,201,82,11,14,0,192,83,0,128,83,0,128,80,0,64,83,
136,66,4,0,64,65,128,84,0,73,86,9,12,64,73,128,80,0,128,85,0,64,87,136,
80,4,0,128,73,0,74,66,87,1,110,73,77,13,57,136,73,4,0,64,67,128,83,0,73,
71,7,20,128,65,0,200,68,7,0,128,77,0,192,66,0,128,84,0,72,76,6,128,84,0,
192,73,0,73,78,9,12,64,68,128,67,0,128,76,0,128,85,0,137,83,5,14,0,72,82,
6,128,71,0,128,78,0,72,89,6,128,66,0,64,84,128,70,0,64,65,73,76,13,146,
72,73,6,128,80,0,128,70,0,73,70,21,104,137,69,5,10,0,64,65,128,83,0,64,
73,64,83,128,65,0,73,68,9,74,64,73,128,71,0,72,67,40,137,79,5,28,0,72,73,
6,128,83,0,64,65,137,78,5,10,0,64,67,128,83,0,64,82,128,69,0,72,84,6,128,
73,0,128,83,0,64,66,73,76,9,18,64,65,128,84,0,136,69,4,0,64,68,128,67,0,
64,80,128,73,0,64,69,136,71,4,0,128,67,0,73,73,17,24,72,84,8,64,82,128,
65,0,64,69,128,88,0,64,71,64,65,128,80,0,64,75,128,83,0,73,82,21,96,136,
80,4,0,64,68,72,73,6,128,83,0,64,69,128,67,0,137,79,5,56,0,72,78,44,137,
70,5,16,0,72,69,6,128,84,0,64,67,128,83,0,72,83,14,64,84,64,65,64,65,64,
70,128,76,0,64,75,64,82,64,65,64,67,128,69,0,64,77,64,77,128,83,0,64,80,
73,77,7,14,128,73,0,136,73,4,0,128,67,0,128,86,0,73,84,13,30,136,87,4,0,
64,82,128,67,0,64,83,73,73,7,10,128,83,0,128,70,0,64,83,128,82,0,64,87,
128,83,0,64,67,73,78,11,84,136,74,4,0,128,71,0,73,72,9,38,64,82,128,68,
0,73,68,9,24,64,82,128,83,0,72,67,6,128,78,0,64,65,136,77,4,0,128,76,0,
64,69,128,81,0,201,76,16,25,0,136,80,4,0,64,69,64,82,128,77,0,64,73,64,
68,64,78,128,78,0,192,77,0,136,82,4,0,128,80,0,73,82,13,49,64,67,64,67,
64,69,128,83,0,201,80,21,33,0,137,73,5,11,0,192,65,0,128,77,0,64,77,128,
80,0,192,79,0,72,89,6,128,68,0,128,83,0,128,81,0,73,84,7,25,128,76,0,192,
83,0,73,69,7,10,128,67,0,128,66,0,64,80,128,67,0,64,85,128,80,0,72,70,134,
73,77,9,84,64,67,128,67,0,73,70,7,44,128,67,0,73,67,23,28,73,83,7,16,128,
69,0,136,68,4,0,64,66,128,84,0,128,84,0,64,65,128,72,0,64,68,64,79,64,83,
128,77,0,73,73,11,28,136,77,4,0,128,66,0,64,72,72,80,8,64,83,128,65,0,64,
65,64,79,128,84,0,128,76,0,73,82,7,27,128,67,0,73,79,9,14,64,68,128,69,
0,64,78,128,67,0,192,80,0,128,73,0,201,84,8,14,0,128,80,0,192,83,0,128,
65,0,192,87,0,128,65,0,64,69,73,77,9,97,64,69,128,80,0,73,70,27,57,137,
76,5,18,0,136,67,4,0,64,65,136,80,4,0,128,70,0,64,82,128,65,0,201,68,8,
19,0,128,83,0,64,67,64,72,64,73,64,78,128,84,0,64,69,136,66,4,0,64,65,128,
76,0,73,73,9,18,64,68,128,69,0,64,71,136,77,4,0,128,65,0,64,76,72,77,8,
64,69,128,88,0,128,67,0,73,83,31,70,73,79,7,18,128,76,0,72,68,6,128,65,
0,64,67,128,73,0,64,84,64,68,64,65,128,70,0,73,80,15,24,72,74,6,128,70,
0,64,67,128,79,0,64,78,64,79,64,82,128,77,0,64,82,72,78,8,64,76,128,73,
0,64,76,128,83,0,72,89,6,128,76,0,128,85,0,74,74,16,1,42,72,77,6,128,71,
0,64,76,128,80,0,200,73,197,0,73,76,9,118,64,77,128,65,0,73,70,22,73,201,
70,8,13,0,128,69,0,64,65,128,67,0,64,73,128,65,0,73,66,17,30,136,82,4,0,
64,73,64,65,64,77,128,69,0,64,65,72,67,6,128,65,0,64,66,128,77,0,64,67,
73,77,7,14,128,73,0,136,70,4,0,128,67,0,64,79,128,77,0,73,72,19,31,73,75,
9,12,64,65,128,76,0,128,71,0,128,76,0,192,71,0,72,84,6,128,65,0,128,80,
0,64,73,128,69,0,73,82,9,60,64,70,128,77,0,73,79,9,14,64,83,128,70,0,64,
77,128,73,0,64,80,73,72,9,20,64,79,128,78,0,137,67,5,8,0,128,65,0,128,68,
0,72,82,6,128,65,0,64,73,64,75,64,79,128,82,0,72,85,6,128,83,0,64,83,64,
68,64,65,128,71,0,64,72,73,73,11,52,64,77,64,85,128,78,0,73,69,17,28,137,
76,5,10,0,64,67,128,66,0,128,83,0,136,68,4,0,64,65,64,65,128,68,0,64,72,
72,75,8,64,70,128,67,0,128,70,0,73,80,19,26,137,73,5,12,0,136,71,4,0,128,
68,0,128,83,0,64,77,64,77,128,83,0,64,83,128,82,0,72,76,96,73,70,15,74,
136,77,4,0,64,70,64,82,128,65,0,73,67,9,35,64,65,128,78,0,200,66,11,0,136,
86,4,0,128,71,0,64,65,137,77,5,8,0,128,68,0,64,80,128,68,0,72,69,14,137,
70,5,8,0,128,66,0,128,82,0,192,68,0,136,77,4,0,128,66,0,137,83,5,16,0,72,
80,6,128,73,0,64,71,128,80,0,128,86,0,64,75,137,84,5,21,0,72,73,6,128,80,
0,192,68,0,136,76,4,0,128,69,0,64,86,128,71,0,74,83,223,2,238,201,77,30,
117,0,73,85,11,20,64,88,64,69,128,82,0,72,73,6,128,80,0,128,67,0,64,208,
128,161,0,73,71,9,48,64,76,128,73,0,73,69,9,34,64,82,128,83,0,72,67,10,
136,67,4,0,128,65,0,192,65,0,200,80,7,0,128,73,0,64,71,128,87,0,64,70,128,
67,0,73,74,13,28,136,77,4,0,64,67,128,86,0,72,73,10,136,80,4,0,128,71,0,
64,72,128,80,0,64,76,72,82,6,128,80,0,128,70,0,73,83,31,72,73,79,7,16,128,
80,0,136,68,4,0,64,65,128,77,0,72,87,8,64,67,128,66,0,128,84,0,73,81,11,
34,136,77,4,0,128,76,0,72,80,10,136,86,4,0,128,69,0,64,79,137,77,5,8,0,
128,76,0,128,80,0,64,82,64,71,128,68,0,137,86,5,12,0,64,85,64,66,128,65,
0,64,87,73,84,9,12,64,67,128,77,0,128,65,0,128,86,0,74,80,83,1,69,73,73,
7,40,128,85,0,73,67,7,18,128,65,0,72,66,6,128,77,0,64,65,128,65,0,136,71,
4,0,64,69,136,71,4,0,64,67,128,83,0,73,80,11,27,136,76,4,0,128,67,0,200,
77,7,0,128,83,0,64,76,64,73,64,78,128,75,0,72,83,8,64,68,128,65,0,128,82,
0,72,79,167,73,77,17,104,72,72,6,128,83,0,64,65,64,67,128,83,0,73,69,23,
72,73,70,7,14,128,76,0,136,69,4,0,128,65,0,64,73,128,67,0,73,67,31,36,137,
76,5,12,0,64,73,64,67,128,79,0,64,84,72,84,8,64,79,128,85,0,64,79,128,85,
0,64,66,128,66,0,64,68,64,79,64,76,64,73,64,83,128,84,0,72,76,8,64,69,128,
83,0,64,71,64,65,128,70,0,73,87,7,45,128,67,0,201,83,16,33,0,72,76,6,128,
72,0,64,69,128,77,0,64,82,73,70,7,12,128,76,0,64,67,128,83,0,128,76,0,64,
84,128,80,0,72,89,6,128,80,0,64,88,64,78,64,69,128,84,0,192,78,0,73,77,
11,47,136,77,4,0,128,75,0,201,70,8,31,0,128,65,0,72,69,14,136,70,4,0,64,
67,64,78,128,78,0,64,66,136,77,4,0,128,65,0,64,73,128,86,0,137,83,5,20,
0,72,82,8,64,73,128,83,0,64,80,64,83,128,67,0,64,87,128,65,0,72,82,175,
73,73,15,105,72,83,6,128,76,0,64,76,128,76,0,137,68,5,71,0,73,66,13,58,
72,82,6,128,70,0,128,69,0,64,65,137,73,5,32,0,72,68,12,72,79,6,128,67,0,
128,65,0,64,67,72,69,8,64,67,128,65,0,64,67,128,67,0,64,79,72,82,6,128,
73,0,128,68,0,192,67,0,64,82,128,70,0,72,72,8,64,67,128,65,0,64,70,72,76,
6,128,80,0,128,67,0,137,81,5,44,0,73,78,11,20,136,67,4,0,128,65,0,64,77,
136,83,4,0,128,77,0,64,79,73,76,9,14,64,79,128,86,0,64,67,128,75,0,128,
77,0,72,83,6,128,77,0,64,82,137,68,5,10,0,64,65,128,77,0,64,83,128,77,0,
64,81,73,73,7,16,128,84,0,72,70,6,128,84,0,128,67,0,72,87,6,128,84,0,128,
77,0,73,86,71,254,73,79,21,42,72,85,6,128,84,0,64,78,64,76,64,73,64,78,
128,69,0,73,69,7,16,128,84,0,72,67,6,128,73,0,128,65,0,64,77,128,73,0,73,
82,9,14,64,73,128,80,0,64,80,128,65,0,64,83,136,83,4,0,64,79,128,80,0,72,
85,88,73,72,7,42,128,70,0,73,67,9,30,64,83,128,82,0,72,66,12,64,73,64,84,
64,65,128,75,0,64,65,136,87,4,0,128,86,0,64,68,128,77,0,73,82,21,36,72,
83,8,64,65,128,66,0,64,75,64,83,64,73,128,66,0,64,76,72,83,10,64,83,64,
65,128,65,0,128,70,0,64,83,64,79,128,77,0,64,84,73,76,7,62,128,83,0,201,
70,22,44,0,137,70,5,14,0,136,66,4,0,64,65,128,70,0,128,78,0,73,66,11,16,
64,79,64,77,128,75,0,64,65,128,71,0,192,68,0,128,73,0,72,72,6,128,68,0,
64,71,128,76,0,73,83,7,18,128,72,0,72,82,6,128,84,0,64,78,128,84,0,72,89,
6,128,76,0,64,88,64,86,128,78,0,72,89,32,73,76,9,24,64,67,128,86,0,64,70,
64,89,72,70,8,64,73,128,77,0,128,67,0,64,86,128,77,0,64,87,137,77,5,63,
0,73,72,7,27,128,80,0,73,68,7,15,128,89,0,192,65,0,64,77,128,80,0,64,69,
128,83,0,72,76,10,64,79,64,72,128,65,0,64,73,72,83,6,128,67,0,64,77,72,
84,8,64,66,128,80,0,128,67,0,73,83,7,22,128,82,0,72,79,8,64,87,128,83,0,
64,78,64,83,128,79,0,72,87,6,128,67,0,64,84,128,67,0,64,83,74,78,171,13,
244,73,79,13,106,72,84,6,128,69,0,128,67,0,73,72,7,51,128,85,0,201,67,8,
18,0,128,67,0,136,66,4,0,192,65,0,128,70,0,72,69,13,192,83,0,64,83,64,85,
128,71,0,64,68,72,83,6,128,83,0,64,67,128,80,0,73,77,16,31,136,83,4,0,192,
80,0,64,84,128,78,0,136,76,4,0,64,73,72,69,6,128,67,0,128,65,0,64,78,136,
83,4,0,64,80,128,82,0,73,84,7,31,128,80,0,201,82,8,19,0,128,83,0,72,81,
6,128,80,0,64,80,128,80,0,64,83,128,70,0,73,87,7,24,128,65,0,72,86,10,136,
84,4,0,128,83,0,64,85,64,65,128,85,0,64,89,128,80,0,74,71,114,9,124,73,
76,7,62,128,73,0,73,68,7,36,128,70,0,73,66,11,17,136,86,4,0,128,80,0,192,
65,0,128,69,0,192,67,0,136,80,4,0,64,73,128,66,0,73,72,9,14,64,70,128,68,
0,64,70,128,67,0,64,73,128,68,0,73,82,13,32,136,70,4,0,64,65,128,77,0,73,
79,7,12,128,84,0,64,77,128,76,0,64,80,64,73,128,79,0,72,84,10,136,83,4,
0,128,67,0,64,83,128,78,0,202,68,235,6,77,0,201,76,20,136,0,137,84,5,12,
0,136,80,4,0,128,67,0,128,86,0,73,69,13,66,136,84,4,0,64,65,128,83,0,137,
67,5,36,0,72,66,8,64,73,128,80,0,64,65,73,79,7,16,128,76,0,72,71,6,128,
67,0,128,67,0,64,82,128,83,0,64,68,137,76,5,8,0,128,67,0,64,80,64,67,128,
77,0,73,73,17,47,73,73,7,10,128,73,0,128,67,0,128,79,0,200,72,20,0,73,76,
7,13,128,82,0,192,67,0,128,73,0,128,87,0,64,70,64,83,192,67,0,128,65,0,
128,75,0,201,82,16,51,0,72,73,6,128,70,0,64,65,128,77,0,137,79,5,23,0,72,
78,10,136,83,4,0,128,80,0,64,77,192,73,0,128,83,0,192,80,0,136,83,4,0,64,
82,128,80,0,73,86,12,35,192,79,0,64,83,128,66,0,72,84,6,128,88,0,64,83,
137,83,5,12,0,136,73,4,0,128,67,0,128,85,0,64,87,64,82,128,82,0,74,66,152,
3,99,73,79,7,99,128,68,0,73,68,13,48,72,70,6,128,82,0,128,67,0,73,66,9,
14,64,79,128,68,0,64,65,128,83,0,64,67,137,83,5,16,0,136,76,4,0,64,67,64,
79,128,77,0,128,84,0,73,76,7,29,128,67,0,64,73,137,73,5,14,0,136,71,4,0,
64,70,128,70,0,192,82,0,128,84,0,64,77,137,76,5,8,0,128,65,0,64,83,128,
69,0,201,83,12,33,0,64,84,64,84,128,65,0,137,81,5,12,0,64,80,64,79,128,
65,0,64,82,64,69,64,70,128,65,0,136,89,4,0,64,84,72,86,6,128,68,0,128,71,
0,64,65,74,77,63,1,180,73,80,7,28,128,65,0,73,72,9,18,64,83,128,65,0,64,
68,136,80,4,0,128,73,0,128,76,0,201,83,16,25,0,64,85,64,78,64,71,64,71,
128,84,0,64,82,136,79,4,0,128,65,0,64,87,128,85,0,73,70,49,255,73,73,9,
32,64,80,128,65,0,73,69,7,18,128,65,0,64,67,72,69,6,128,67,0,128,67,0,64,
72,128,69,0,72,83,8,64,73,128,65,0,64,80,128,65,0,73,67,78,168,201,76,10,
47,0,64,79,128,83,0,73,67,15,26,136,72,4,0,64,65,64,87,128,85,0,72,66,6,
128,67,0,64,65,128,65,0,72,69,8,64,85,128,82,0,128,68,0,73,84,15,24,72,
87,6,128,85,0,64,82,128,65,0,136,80,4,0,64,79,128,66,0,128,85,0,72,66,42,
201,77,8,28,0,128,69,0,72,68,6,128,67,0,192,67,0,136,83,4,0,64,79,64,72,
128,65,0,72,85,8,64,68,128,73,0,128,83,0,64,65,137,74,5,26,0,137,70,5,14,
0,64,67,64,85,64,82,128,72,0,64,72,64,83,128,80,0,73,82,11,17,136,70,4,
0,128,67,0,192,80,0,128,83,0,128,83,0,72,69,14,72,70,6,128,76,0,64,67,128,
83,0,64,68,201,84,12,19,0,136,85,4,0,128,65,0,136,68,4,0,128,67,0,128,88,
0,73,73,70,101,73,70,7,43,128,73,0,201,67,20,29,0,137,77,5,8,0,128,65,0,
64,83,64,73,128,84,0,64,66,136,84,4,0,128,68,0,64,68,64,83,128,65,0,73,
80,7,16,128,65,0,64,75,64,65,64,78,128,79,0,64,82,64,65,128,67,0,72,72,
12,72,82,6,128,67,0,128,77,0,64,71,137,68,5,14,0,64,65,64,82,64,80,128,
65,0,128,76,0,64,76,73,71,7,12,128,65,0,64,68,128,70,0,128,87,0,73,84,22,
235,201,67,10,13,0,64,79,128,77,0,128,65,0,64,73,128,66,0,73,81,7,104,128,
65,0,72,80,44,73,79,7,22,128,65,0,137,68,5,12,0,64,65,64,82,128,68,0,128,
73,0,73,83,9,14,64,67,128,77,0,64,82,128,82,0,64,84,128,71,0,64,78,137,
69,5,34,0,73,66,7,18,128,83,0,64,65,72,86,6,128,65,0,128,67,0,64,68,72,
82,6,128,80,0,128,70,0,72,80,12,64,65,64,82,64,75,128,83,0,64,70,128,76,
0,72,83,41,73,82,9,22,64,73,128,65,0,137,76,5,10,0,64,68,128,75,0,128,78,
0,200,85,9,0,64,83,128,71,0,64,83,64,68,128,65,0,64,82,137,71,5,34,0,73,
69,9,24,64,69,128,67,0,72,67,6,128,67,0,64,65,64,67,64,67,128,65,0,64,70,
128,84,0,73,84,9,27,64,82,128,69,0,200,83,9,0,64,65,128,84,0,64,80,64,67,
64,67,128,79,0,64,85,128,65,0,201,87,12,36,0,64,70,64,76,128,65,0,200,86,
9,0,64,82,128,89,0,64,85,72,86,8,64,67,128,65,0,64,74,128,83,0,192,88,0,
128,83,0,192,67,0,202,77,21,1,37,0,73,68,7,12,128,77,0,64,65,128,68,0,128,
83,0,73,70,11,199,136,86,4,0,128,81,0,73,67,33,102,137,77,5,22,0,73,71,
7,10,128,69,0,128,65,0,64,73,64,80,128,65,0,136,83,4,0,128,80,0,72,66,18,
73,67,7,10,128,68,0,128,65,0,64,87,128,73,0,64,65,73,77,7,28,128,67,0,73,
68,13,18,72,84,6,128,65,0,128,65,0,64,66,128,66,0,128,69,0,73,83,11,18,
64,72,64,82,128,77,0,64,81,64,77,128,68,0,128,87,0,200,69,41,0,137,74,5,
20,0,137,69,5,12,0,136,67,4,0,128,65,0,128,73,0,137,79,5,14,0,64,78,64,
73,64,72,128,82,0,128,80,0,64,68,73,79,7,24,128,84,0,73,74,9,12,64,87,128,
83,0,128,65,0,64,77,128,65,0,72,87,14,64,82,64,73,64,84,64,69,128,82,0,
64,80,128,77,0,73,73,23,46,137,77,5,14,0,136,66,4,0,64,65,128,70,0,64,82,
128,73,0,72,72,20,72,73,6,128,80,0,64,65,64,78,64,78,64,69,128,76,0,128,
71,0,72,76,18,136,67,4,0,64,65,64,72,64,73,64,71,128,65,0,64,74,136,80,
4,0,128,65,0,73,84,46,176,73,73,11,33,64,77,64,83,128,84,0,73,69,11,17,
136,88,4,0,128,80,0,192,68,0,128,65,0,64,70,128,76,0,72,83,6,128,82,0,128,
80,0,73,80,26,81,201,73,8,17,0,128,69,0,72,69,6,128,67,0,128,67,0,64,82,
128,79,0,72,79,49,137,77,5,21,0,73,68,7,13,128,77,0,192,65,0,128,78,0,128,
73,0,73,82,13,18,136,77,4,0,64,65,128,68,0,64,80,128,80,0,64,84,64,85,128,
83,0,192,78,0,128,84,0,72,83,14,137,72,5,8,0,128,70,0,128,73,0,64,82,73,
71,9,26,64,83,128,80,0,72,70,6,128,65,0,64,65,64,77,64,74,64,69,128,84,
0,64,89,64,69,128,68,0,73,87,13,32,136,85,4,0,64,67,128,68,0,72,86,8,64,
77,128,77,0,64,85,136,84,4,0,64,77,128,77,0,64,88,64,77,128,76,0,72,70,
174,73,77,15,104,72,79,8,64,77,128,65,0,128,76,0,73,69,13,58,64,68,136,
85,4,0,128,73,0,73,67,7,28,128,75,0,72,66,10,64,65,64,68,128,82,0,64,65,
136,83,4,0,64,82,128,73,0,64,68,137,73,5,12,0,136,72,4,0,128,65,0,128,82,
0,73,73,17,26,72,78,8,64,65,128,69,0,64,71,128,70,0,72,72,6,128,65,0,128,
70,0,64,76,128,67,0,201,83,16,44,0,137,71,5,8,0,128,70,0,128,85,0,201,80,
8,23,0,128,68,0,72,79,6,128,82,0,64,78,136,77,4,0,128,66,0,64,82,128,89,
0,73,87,9,18,64,77,128,68,0,136,85,4,0,64,84,128,80,0,64,89,128,77,0,64,
69,74,77,74,1,84,73,78,7,32,128,69,0,137,67,5,22,0,64,65,72,84,6,128,65,
0,64,82,64,78,64,65,128,80,0,128,68,0,73,80,21,34,136,79,4,0,64,69,64,82,
64,79,64,80,64,69,128,82,0,64,79,64,78,64,73,64,84,64,79,128,82,0,128,90,
0,73,70,21,197,137,80,5,14,0,136,77,4,0,64,73,128,67,0,128,83,0,73,67,59,
123,73,79,9,34,64,81,128,67,0,73,69,11,18,136,88,4,0,128,67,0,64,68,64,
69,128,68,0,64,78,64,65,128,86,0,73,84,9,14,64,85,128,82,0,64,83,128,72,
0,64,85,64,76,128,84,0,200,66,15,0,72,82,8,64,65,128,69,0,128,73,0,64,65,
73,79,7,24,128,67,0,73,72,7,10,128,79,0,128,68,0,64,73,64,83,128,73,0,73,
86,11,14,64,82,64,79,128,67,0,128,81,0,64,87,64,73,64,70,128,83,0,72,69,
32,73,68,11,18,136,87,4,0,128,65,0,64,66,64,66,128,69,0,64,77,136,79,4,
0,64,69,128,65,0,64,68,73,79,7,14,128,80,0,64,69,64,85,128,82,0,64,85,128,
69,0,73,73,25,48,73,81,9,18,64,79,128,76,0,72,79,6,128,77,0,128,67,0,128,
85,0,136,72,4,0,64,71,73,73,7,12,128,66,0,64,65,128,76,0,64,79,128,66,0,
64,76,73,80,7,16,128,65,0,64,73,64,78,64,85,128,88,0,128,86,0,73,84,33,
152,73,69,7,18,128,67,0,72,68,6,128,65,0,64,65,128,67,0,64,85,64,80,64,
73,64,78,128,71,0,73,80,17,76,73,73,7,10,128,67,0,128,65,0,128,77,0,136,
79,4,0,64,78,73,80,15,46,64,76,64,65,64,68,64,69,128,83,0,72,69,8,64,65,
128,77,0,64,65,73,77,7,14,128,73,0,64,67,64,89,128,84,0,64,84,64,69,128,
76,0,64,84,64,65,128,67,0,64,82,137,80,5,20,0,136,76,4,0,64,68,136,80,4,
0,64,69,128,83,0,64,86,72,81,10,64,85,64,65,128,76,0,64,73,64,83,64,69,
128,71,0,73,87,9,30,64,83,128,83,0,72,86,16,72,78,8,64,84,128,85,0,64,73,
128,83,0,64,85,128,83,0,128,90,0,74,75,50,2,39,73,77,7,28,128,83,0,73,67,
11,16,136,75,4,0,128,71,0,64,65,128,69,0,64,73,128,65,0,136,85,4,0,64,79,
136,83,4,0,64,70,64,71,128,65,0,82,73,1,91,1,233,73,76,7,177,128,67,0,73,
70,21,96,137,82,5,14,0,72,77,6,128,65,0,128,69,0,128,83,0,73,67,13,26,72,
83,6,128,82,0,128,80,0,72,66,8,64,85,128,67,0,64,65,128,69,0,72,69,28,137,
77,5,18,0,72,76,8,64,69,128,73,0,64,68,128,79,0,64,84,64,65,128,82,0,64,
68,73,79,7,16,128,82,0,136,78,4,0,64,66,128,73,0,128,83,0,73,73,9,67,64,
83,128,69,0,72,72,10,136,79,4,0,128,72,0,192,71,0,73,73,9,28,64,78,128,
84,0,136,69,4,0,64,67,72,79,8,64,77,128,80,0,64,72,128,73,0,72,84,10,64,
82,64,65,128,78,0,64,83,64,65,128,67,0,64,75,64,73,128,66,0,73,83,25,121,
73,83,7,16,128,76,0,72,78,6,128,73,0,128,68,0,64,87,128,71,0,73,79,11,56,
136,69,4,0,128,65,0,72,78,12,136,82,4,0,64,65,128,68,0,64,77,73,79,9,16,
64,67,128,79,0,136,77,4,0,128,68,0,72,83,8,64,68,128,73,0,64,82,64,65,128,
67,0,72,82,14,72,84,6,128,70,0,64,68,128,83,0,192,80,0,73,79,7,14,128,67,
0,136,67,4,0,128,66,0,136,83,4,0,64,82,128,73,0,137,86,5,37,0,72,85,8,64,
80,128,76,0,64,84,73,82,9,17,64,69,128,80,0,192,67,0,64,79,128,77,0,64,
83,128,65,0,192,87,0,128,73,0,64,72,73,76,13,91,136,88,4,0,64,65,128,65,
0,73,69,17,59,137,80,5,10,0,64,70,128,67,0,128,81,0,73,66,13,33,72,73,6,
128,69,0,128,71,0,192,65,0,73,69,7,10,128,70,0,128,67,0,64,70,64,70,128,
69,0,64,67,136,80,4,0,128,65,0,73,73,9,14,64,67,128,67,0,64,71,128,67,0,
64,75,128,71,0,73,82,11,40,136,77,4,0,128,70,0,73,79,9,20,64,77,128,69,
0,64,77,136,83,4,0,64,73,128,81,0,64,80,136,69,4,0,128,68,0,136,86,4,0,
64,83,128,77,0,64,74,192,83,0,136,85,4,0,128,78,0,72,77,246,73,76,13,140,
72,72,6,128,76,0,128,69,0,73,69,20,107,73,82,7,13,128,85,0,192,68,0,128,
80,0,128,83,0,73,67,7,74,128,80,0,200,66,24,0,73,73,9,15,64,79,128,83,0,
192,67,0,128,69,0,64,85,128,83,0,64,65,73,83,19,32,64,72,64,73,64,78,64,
71,64,77,64,65,128,71,0,72,82,10,64,84,64,84,128,86,0,128,72,0,136,87,4,
0,64,84,128,86,0,64,68,137,82,5,8,0,128,73,0,128,83,0,73,71,9,15,64,67,
128,83,0,192,70,0,128,71,0,64,73,128,76,0,201,83,19,80,0,137,69,5,11,0,
192,67,0,128,66,0,128,84,0,73,80,23,56,137,83,5,14,0,136,80,4,0,64,69,128,
71,0,64,84,128,69,0,72,79,20,73,76,9,14,64,69,128,68,0,64,67,128,65,0,128,
83,0,64,77,137,83,5,8,0,128,69,0,128,84,0,64,81,128,80,0,73,85,11,16,136,
79,4,0,128,68,0,64,84,128,80,0,64,87,64,73,128,65,0,64,76,73,72,7,117,128,
65,0,201,68,8,70,0,128,78,0,73,66,7,59,128,77,0,192,65,0,73,77,13,32,64,
82,64,65,64,65,128,77,0,137,67,5,16,0,64,65,64,77,64,82,64,65,128,77,0,
128,70,0,72,83,12,64,83,64,67,64,79,128,77,0,64,80,128,80,0,128,67,0,136,
71,4,0,192,69,0,73,82,7,26,128,84,0,73,69,9,12,64,80,128,82,0,128,68,0,
64,76,64,84,128,65,0,136,88,4,0,128,83,0,73,79,13,43,72,82,6,128,67,0,128,
67,0,72,78,6,128,66,0,192,73,0,137,80,5,14,0,72,77,6,128,70,0,128,75,0,
64,82,64,66,128,77,0,72,85,8,64,82,128,77,0,192,82,0,128,82,0,74,85,181,
6,58,73,80,21,112,73,83,7,10,128,73,0,128,76,0,64,84,64,69,128,76,0,73,
76,13,50,136,73,4,0,64,69,128,86,0,73,71,13,32,136,86,4,0,64,69,128,78,
0,64,66,72,77,8,64,65,128,78,0,64,76,64,86,64,68,128,83,0,64,74,128,85,
0,72,78,14,136,89,4,0,64,82,64,80,128,67,0,64,77,73,84,9,20,64,69,128,76,
0,136,79,4,0,64,66,64,65,128,82,0,64,85,128,84,0,73,83,29,52,73,69,7,18,
128,80,0,72,68,6,128,80,0,64,65,128,84,0,64,79,64,82,128,80,0,72,82,16,
72,80,8,64,65,128,84,0,64,66,128,76,0,64,81,64,87,128,84,0,136,86,4,0,192,
84,0,64,82,128,83,0,74,82,172,3,85,73,76,7,93,128,71,0,73,69,20,59,73,67,
7,13,128,83,0,192,66,0,128,80,0,128,71,0,73,67,13,28,72,79,6,128,78,0,128,
70,0,72,66,6,128,84,0,64,65,136,77,4,0,128,69,0,64,68,72,82,6,128,83,0,
128,70,0,73,72,7,12,128,69,0,64,71,128,83,0,64,73,72,79,6,128,86,0,64,68,
64,69,128,67,0,137,82,5,28,0,73,78,11,18,136,72,4,0,128,68,0,64,77,64,85,
128,71,0,64,79,128,73,0,73,84,15,40,137,80,5,8,0,128,77,0,128,84,0,64,83,
137,71,5,16,0,72,70,6,128,70,0,64,67,128,77,0,136,84,4,0,128,82,0,192,87,
0,128,68,0,210,80,1,77,2,137,0,73,76,15,192,137,67,5,8,0,128,65,0,128,77,
0,73,70,27,122,73,77,13,20,64,67,64,69,64,87,128,76,0,64,73,64,76,128,69,
0,128,87,0,73,67,23,52,137,80,5,14,0,72,69,6,128,88,0,128,65,0,64,83,128,
80,0,72,66,6,128,84,0,64,65,73,67,9,14,64,69,128,88,0,64,65,128,71,0,64,
82,64,67,128,76,0,72,69,32,72,69,24,72,82,12,64,77,64,73,64,78,128,84,0,
64,68,64,73,64,83,128,75,0,64,67,128,84,0,64,68,136,84,4,0,64,73,128,70,
0,73,73,25,44,73,72,7,12,128,84,0,64,66,128,65,0,64,73,64,82,64,65,128,
83,0,72,72,10,136,82,4,0,128,69,0,64,71,136,77,4,0,128,65,0,64,75,136,73,
4,0,64,65,128,67,0,73,82,9,70,64,78,128,71,0,73,80,9,54,64,79,128,78,0,
72,79,14,137,70,5,8,0,128,67,0,128,74,0,64,77,137,68,5,26,0,72,67,12,72,
83,6,128,82,0,128,82,0,64,66,136,84,4,0,128,78,0,128,76,0,64,81,64,79,128,
83,0,137,86,5,59,0,72,84,17,201,73,8,11,0,128,71,0,128,68,0,128,83,0,64,
83,201,83,8,22,0,128,73,0,201,77,8,11,0,128,65,0,128,74,0,128,79,0,72,85,
10,64,65,64,67,128,69,0,128,84,0,64,89,128,77,0,64,79,73,76,23,176,73,70,
9,14,64,69,128,68,0,64,65,128,83,0,64,86,128,68,0,73,70,31,107,137,77,5,
14,0,136,67,4,0,64,65,128,68,0,136,83,4,0,64,79,136,77,4,0,128,76,0,201,
67,39,61,0,73,78,9,23,64,65,128,86,0,72,71,8,64,69,128,78,0,192,65,0,128,
68,0,72,80,6,128,65,0,64,79,128,77,0,72,66,8,64,85,128,84,0,192,65,0,137,
80,5,8,0,128,68,0,128,83,0,72,69,6,128,65,0,64,68,64,73,64,77,128,77,0,
201,73,8,37,0,128,67,0,72,72,20,137,82,5,14,0,136,79,4,0,64,76,128,65,0,
128,84,0,64,71,136,83,4,0,128,80,0,64,74,136,83,4,0,128,65,0,73,83,29,89,
137,76,5,20,0,72,73,6,128,71,0,64,69,64,87,64,73,128,78,0,64,85,128,83,
0,73,80,22,41,73,69,7,10,128,80,0,128,67,0,192,77,0,64,79,128,68,0,72,78,
14,72,69,6,128,84,0,64,65,128,83,0,64,77,128,83,0,64,82,73,73,7,12,128,
69,0,64,66,128,83,0,64,78,128,65,0,137,88,5,44,0,72,87,6,128,70,0,64,84,
137,76,5,24,0,73,72,9,14,64,79,128,67,0,64,65,128,82,0,64,73,128,83,0,136,
89,4,0,128,84,0,64,89,128,76,0,64,81,137,73,5,12,0,136,69,4,0,128,67,0,
192,76,0,73,68,7,12,128,65,0,64,67,128,65,0,128,74,0,72,84,209,201,78,10,
102,0,64,83,128,65,0,73,69,19,57,64,80,64,66,64,89,64,83,64,84,64,69,128,
80,0,73,67,11,35,136,85,4,0,128,67,0,200,66,11,0,136,68,4,0,128,67,0,64,
65,72,80,6,128,83,0,64,73,128,70,0,128,68,0,137,74,5,30,0,72,71,6,128,73,
0,64,70,137,85,5,14,0,136,67,4,0,64,65,128,80,0,128,87,0,64,77,128,67,0,
73,84,7,79,128,84,0,73,82,41,61,73,79,13,20,64,78,64,71,64,68,128,67,0,
136,77,4,0,128,71,0,72,84,8,64,79,128,68,0,64,82,64,73,64,68,128,69,0,200,
80,13,0,72,82,6,128,77,0,128,73,0,64,79,64,86,128,76,0,64,83,136,77,4,0,
64,67,128,73,0,73,86,7,20,128,77,0,64,85,72,82,6,128,80,0,64,65,128,83,
0,64,87,128,75,0,64,83,73,77,38,217,137,77,5,20,0,73,69,9,12,64,83,128,
73,0,128,65,0,128,76,0,136,84,4,0,192,83,0,136,69,4,0,128,67,0,73,70,17,
101,72,70,8,64,77,128,80,0,64,68,128,67,0,73,67,19,56,73,76,7,10,128,73,
0,128,68,0,64,79,128,80,0,72,66,6,128,66,0,64,65,137,80,5,20,0,73,70,7,
12,128,65,0,64,68,128,77,0,128,79,0,136,83,4,0,64,82,128,83,0,72,69,18,
73,69,7,12,128,83,0,64,67,128,85,0,128,77,0,192,68,0,136,84,4,0,128,80,
0,201,73,38,54,0,73,77,9,18,64,73,128,83,0,72,73,6,128,77,0,128,68,0,136,
83,4,0,64,82,136,80,4,0,64,73,128,83,0,200,72,9,0,64,82,128,67,0,64,71,
64,82,128,82,0,192,76,0,73,86,9,14,64,80,128,78,0,64,85,128,71,0,64,89,
64,66,128,89,0,73,83,19,89,73,68,7,12,128,72,0,64,67,128,65,0,128,73,0,
73,80,25,49,73,68,7,14,128,70,0,136,67,4,0,128,65,0,136,83,4,0,128,73,0,
72,79,12,136,80,4,0,64,76,128,69,0,192,78,0,72,82,6,128,73,0,128,67,0,64,
82,137,78,5,14,0,72,77,6,128,83,0,128,73,0,64,84,128,80,0,73,87,7,36,128,
70,0,72,85,14,136,86,4,0,64,65,64,67,128,69,0,64,84,137,80,5,10,0,64,69,
128,68,0,128,86,0,64,89,64,80,128,67,0,74,88,10,1,11,64,82,128,68,0,72,
87,147,201,77,15,80,0,136,85,4,0,192,77,0,128,80,0,73,70,7,36,128,73,0,
73,68,7,24,128,71,0,136,66,4,0,64,65,72,76,8,64,83,128,67,0,128,75,0,64,
69,128,79,0,73,73,13,18,72,82,6,128,71,0,128,71,0,64,71,128,66,0,64,75,
64,79,64,84,64,79,128,82,0,137,83,5,40,0,73,81,7,20,128,83,0,72,79,6,128,
84,0,64,78,64,67,128,67,0,64,82,137,76,5,10,0,64,67,128,66,0,128,84,0,137,
86,5,19,0,192,84,0,72,79,6,128,82,0,64,70,128,85,0,64,89,128,78,0,64,86,
73,76,9,71,64,85,128,71,0,201,71,8,33,0,128,65,0,73,67,11,22,136,79,4,0,
128,68,0,64,65,136,87,4,0,64,83,128,69,0,128,68,0,73,73,13,22,136,68,4,
0,64,67,128,67,0,64,72,136,83,4,0,128,67,0,64,74,64,85,128,71,0,73,83,7,
26,128,80,0,73,80,9,12,64,87,128,77,0,128,77,0,64,82,64,69,128,80,0,72,
89,6,128,84,0,64,86,128,80,0,72,90,24,137,67,5,16,0,64,65,64,66,64,73,64,
83,128,84,0,64,83,128,78,0,64,89,73,80,9,50,64,84,128,69,0,73,77,13,24,
64,76,64,73,64,78,128,75,0,72,70,6,128,77,0,64,68,128,86,0,72,79,10,64,
84,64,79,128,83,0,64,78,64,82,128,71,0,73,84,11,90,64,89,64,67,128,68,0,
72,83,72,73,84,23,48,64,69,64,77,64,79,64,70,64,65,64,68,64,79,64,87,128,
78,0,73,69,7,18,128,88,0,64,65,64,68,64,77,64,73,128,78,0,64,75,64,69,128,
89,0,72,86,8,64,79,128,76,0,64,85,64,80,64,84,64,73,64,77,128,69,0,64,82,
64,67,128,76,0,64,86,64,65,128,80,0,82,89,1,227,22,42,74,78,22,1,30,73,
72,7,12,128,72,0,64,65,128,66,0,64,87,128,65,0,73,71,11,168,64,68,64,65,
128,73,0,73,67,25,142,137,76,5,16,0,72,73,8,64,65,128,83,0,128,67,0,64,
83,128,71,0,72,66,26,73,75,7,18,128,66,0,72,72,6,128,75,0,64,67,128,65,
0,64,85,128,76,0,64,65,73,76,9,46,64,83,128,65,0,73,70,13,22,72,70,6,128,
83,0,128,67,0,136,67,4,0,64,65,128,73,0,72,75,10,64,73,64,68,128,65,0,64,
72,128,77,0,73,82,9,26,64,80,128,80,0,72,80,12,72,84,6,128,85,0,128,67,
0,64,77,128,74,0,72,84,6,128,69,0,64,83,136,84,4,0,64,68,128,78,0,72,70,
10,136,85,4,0,128,67,0,64,68,128,76,0,73,75,9,34,64,67,128,76,0,72,73,12,
64,66,136,83,4,0,128,79,0,64,72,72,82,6,128,77,0,64,65,128,82,0,200,77,
23,0,73,77,7,16,128,86,0,64,67,136,79,4,0,128,65,0,128,79,0,64,76,73,75,
7,28,128,73,0,137,69,5,12,0,64,66,64,72,128,73,0,64,72,64,67,64,83,128,
68,0,136,84,4,0,64,79,128,68,0,73,84,17,112,137,77,5,8,0,128,68,0,64,83,
128,79,0,73,81,7,66,128,76,0,72,80,36,73,76,7,24,128,73,0,73,70,7,12,128,
66,0,64,65,128,79,0,64,72,128,65,0,72,86,6,128,83,0,128,78,0,64,79,73,78,
9,14,64,75,128,65,0,64,68,128,76,0,64,89,64,79,128,87,0,72,83,18,73,79,
9,12,64,80,128,80,0,128,76,0,128,90,0,64,82,72,75,6,128,73,0,128,70,0,73,
87,19,64,72,67,6,128,65,0,64,65,136,77,4,0,128,69,0,72,86,8,64,77,128,76,
0,64,85,73,77,11,24,64,65,64,84,128,85,0,136,73,4,0,64,71,64,73,64,79,128,
72,0,64,78,64,84,64,69,64,67,128,72,0,64,208,72,159,6,128,65,0,64,146,64,
208,128,154,0,82,87,11,141,18,81,202,77,131,6,227,0,137,76,5,77,0,73,69,
9,53,64,65,128,84,0,137,67,5,28,0,192,65,0,137,80,5,15,0,192,78,0,64,83,
64,68,128,79,0,64,84,128,65,0,192,68,0,137,77,5,8,0,128,67,0,64,82,128,
77,0,201,71,8,13,0,128,76,0,64,70,128,87,0,192,73,0,128,75,0,201,81,8,33,
0,128,67,0,201,79,8,11,0,128,83,0,128,77,0,192,80,0,64,76,64,65,64,89,64,
69,128,82,0,200,86,7,0,128,65,0,192,83,0,64,72,128,80,0,74,71,62,4,1,73,
73,7,32,128,71,0,73,69,9,22,64,73,128,68,0,136,67,4,0,64,65,136,87,4,0,
128,86,0,128,70,0,73,80,9,20,64,83,128,78,0,72,77,6,128,83,0,64,76,128,
67,0,64,82,128,80,0,202,68,116,2,195,0,73,79,7,48,128,76,0,201,70,10,27,
0,64,80,128,70,0,73,68,7,12,128,77,0,64,67,128,83,0,64,69,128,67,0,137,
75,5,11,0,192,73,0,128,71,0,128,77,0,73,84,15,49,72,77,6,128,82,0,64,67,
128,82,0,137,82,5,14,0,64,80,64,76,64,65,128,67,0,192,83,0,73,83,9,14,64,
80,128,82,0,64,72,128,69,0,128,84,0,72,88,8,64,82,128,70,0,64,86,128,76,
0,74,66,107,1,186,73,77,7,66,128,83,0,73,69,23,48,137,77,5,14,0,64,69,64,
66,64,69,128,69,0,64,78,128,67,0,73,67,9,22,64,83,128,68,0,64,65,72,77,
6,128,67,0,64,70,128,67,0,128,68,0,72,71,6,128,83,0,64,70,128,83,0,137,
83,5,18,0,72,80,8,64,83,128,65,0,64,79,128,67,0,72,88,8,64,77,128,76,0,
192,84,0,136,67,4,0,128,66,0,64,65,73,77,17,198,137,80,5,10,0,64,77,128,
65,0,128,85,0,201,70,8,97,0,128,83,0,73,67,17,47,137,67,5,10,0,64,65,128,
80,0,128,76,0,200,66,11,0,136,79,4,0,128,65,0,64,65,137,68,5,10,0,64,65,
128,77,0,64,83,64,65,128,77,0,72,69,29,73,77,7,19,128,85,0,72,68,6,128,
67,0,192,65,0,128,67,0,64,84,64,65,128,71,0,64,68,136,76,4,0,64,71,64,80,
128,83,0,201,73,24,51,0,73,80,7,16,128,65,0,136,75,4,0,64,70,128,65,0,128,
83,0,72,72,14,137,77,5,8,0,128,68,0,128,85,0,64,71,72,71,8,64,71,128,83,
0,128,67,0,72,76,14,72,72,6,128,73,0,64,71,128,65,0,64,75,136,79,4,0,64,
69,64,79,64,78,64,76,64,65,128,78,0,137,85,5,112,0,73,82,13,57,72,68,6,
128,67,0,128,67,0,200,80,38,0,73,69,9,25,64,82,128,83,0,137,67,5,11,0,192,
66,0,128,76,0,64,68,128,65,0,72,79,6,128,82,0,128,73,0,192,78,0,128,79,
0,136,84,4,0,64,83,73,68,7,27,128,69,0,73,66,7,14,128,69,0,64,65,64,80,
128,73,0,192,67,0,128,69,0,73,79,7,12,128,71,0,64,76,128,73,0,64,80,128,
65,0,73,90,7,18,128,65,0,72,89,6,128,78,0,64,88,128,83,0,64,208,128,156,
0,64,67,201,77,12,75,0,136,83,4,0,128,67,0,137,71,5,42,0,73,69,13,34,72,
84,6,128,84,0,128,68,0,72,68,8,64,77,128,65,0,64,65,137,82,5,8,0,128,71,
0,128,84,0,128,70,0,73,73,7,14,128,83,0,64,72,64,83,128,66,0,64,76,64,65,
128,67,0,73,82,11,53,136,70,4,0,128,65,0,201,79,27,33,0,201,80,8,17,0,128,
65,0,72,79,6,128,80,0,128,76,0,64,84,128,89,0,192,78,0,128,67,0,64,80,64,
83,64,68,128,70,0,73,84,7,16,128,85,0,64,83,136,84,4,0,128,67,0,128,87,
0,200,70,117,0,137,77,5,54,0,73,69,13,36,136,83,4,0,64,79,128,80,0,73,66,
7,12,128,83,0,64,65,128,78,0,64,68,72,73,6,128,70,0,128,66,0,72,76,8,64,
85,128,71,0,64,71,128,66,0,137,81,5,28,0,73,79,7,14,128,86,0,64,78,64,78,
128,66,0,64,80,136,70,4,0,128,67,0,72,84,12,136,85,4,0,64,68,128,65,0,64,
83,73,71,7,12,128,73,0,64,66,128,80,0,64,79,128,80,0,64,69,73,75,10,81,
192,65,0,128,70,0,73,69,7,54,128,69,0,73,66,29,38,73,80,7,20,128,73,0,72,
68,8,64,65,128,86,0,64,67,128,84,0,64,82,128,67,0,64,65,136,86,4,0,128,
77,0,64,67,136,70,4,0,128,65,0,200,72,7,0,128,79,0,192,70,0,136,84,4,0,
128,79,0,137,79,5,40,0,73,77,13,18,64,69,64,82,64,69,128,67,0,64,76,128,
83,0,64,78,137,76,5,12,0,64,66,64,73,128,84,0,128,79,0,72,85,8,64,83,128,
65,0,192,80,0,64,79,128,83,0,74,74,10,1,223,64,82,128,79,0,80,73,1,105,
73,76,9,82,64,80,128,70,0,73,69,7,40,128,79,0,73,67,13,28,72,80,6,128,65,
0,128,66,0,72,66,12,72,82,6,128,79,0,128,70,0,128,65,0,64,68,128,73,0,73,
73,9,14,64,70,128,77,0,64,70,128,77,0,64,75,64,73,64,67,64,79,64,77,64,
77,64,79,64,78,128,83,0,73,84,13,253,72,83,6,128,65,0,128,73,0,201,80,12,
190,0,136,79,4,0,128,73,0,72,79,10,64,77,64,83,128,65,0,64,78,73,77,7,102,
128,79,0,73,69,7,52,128,80,0,73,67,11,16,136,69,4,0,128,67,0,64,65,128,
67,0,64,68,72,79,12,64,87,64,83,64,77,128,69,0,64,69,64,70,64,69,64,78,
64,68,64,69,128,82,0,72,72,22,72,84,8,64,84,128,80,0,64,69,72,76,6,128,
80,0,128,67,0,64,70,73,79,11,16,64,82,64,77,128,83,0,64,76,128,80,0,128,
83,0,201,83,26,41,0,73,78,9,14,64,65,128,80,0,64,65,128,84,0,64,79,64,67,
128,75,0,72,82,10,136,77,4,0,128,69,0,64,80,128,69,0,72,88,6,128,80,0,64,
86,72,73,10,64,83,64,84,128,65,0,64,69,128,82,0,64,83,137,77,5,20,0,73,
68,7,12,128,75,0,64,67,128,79,0,128,69,0,73,81,15,21,136,76,4,0,64,65,64,
82,128,83,0,192,80,0,128,83,0,64,84,64,82,128,65,0,73,87,9,14,64,69,128,
88,0,64,86,128,80,0,192,88,0,64,80,128,65,0,64,72,137,76,5,57,0,73,69,11,
38,136,68,4,0,128,65,0,73,67,9,18,64,82,128,65,0,64,65,64,84,64,87,128,
71,0,64,68,136,73,4,0,128,67,0,200,73,9,0,64,80,128,83,0,64,71,128,73,0,
73,81,7,28,128,76,0,72,79,14,72,80,8,64,69,128,83,0,128,73,0,64,77,64,73,
128,83,0,72,84,6,128,73,0,192,83,0,200,68,7,0,128,69,0,64,67,128,67,0,72,
76,102,201,77,16,68,0,136,66,4,0,64,65,64,73,128,76,0,73,73,15,45,72,86,
6,128,69,0,64,70,128,87,0,73,67,13,21,72,83,6,128,80,0,128,71,0,64,65,192,
78,0,128,83,0,64,69,136,70,4,0,128,68,0,136,76,4,0,128,75,0,73,85,9,24,
64,77,128,76,0,72,83,10,136,77,4,0,128,69,0,64,78,128,80,0,136,90,4,0,128,
87,0,64,75,201,84,8,18,0,128,84,0,136,70,4,0,192,66,0,128,74,0,192,85,0,
128,75,0,74,84,126,3,68,137,77,5,78,0,137,68,5,30,0,137,66,5,10,0,64,65,
128,73,0,192,67,0,72,77,6,128,77,0,192,67,0,128,67,0,201,73,12,37,0,64,
84,64,89,128,66,0,64,70,73,83,9,18,64,75,128,70,0,72,80,6,128,76,0,128,
67,0,64,89,128,87,0,192,76,0,128,83,0,73,82,7,28,128,79,0,137,79,5,10,0,
64,78,128,70,0,64,80,64,79,64,84,64,85,128,83,0,72,87,10,64,65,64,82,128,
69,0,64,84,128,67,0,74,81,24,1,85,73,77,7,14,128,80,0,136,76,4,0,128,65,
0,64,84,128,67,0,73,79,195,248,201,77,27,97,0,73,69,7,16,128,88,0,64,65,
136,68,4,0,128,67,0,192,77,0,128,65,0,73,70,7,54,128,70,0,73,67,29,40,137,
69,5,18,0,72,67,6,128,85,0,64,65,64,84,128,73,0,136,81,4,0,128,71,0,64,
65,64,77,64,84,64,69,128,67,0,64,69,64,73,128,68,0,200,76,7,0,128,75,0,
64,73,64,80,64,70,128,71,0,201,84,20,82,0,73,76,7,10,128,75,0,128,70,0,
64,77,128,69,0,201,82,36,43,0,136,77,4,0,64,76,64,68,64,79,64,70,72,84,
12,64,65,64,78,64,75,128,83,0,64,71,64,79,128,79,0,64,79,64,72,128,80,0,
64,83,73,67,11,14,64,79,64,80,128,83,0,128,65,0,128,77,0,72,90,6,128,65,
0,192,87,0,128,80,0,64,78,73,73,21,36,73,76,7,10,128,83,0,128,67,0,64,83,
64,69,128,70,0,72,68,6,128,83,0,64,66,136,82,4,0,128,65,0,72,84,6,128,83,
0,64,80,136,83,4,0,128,80,0,64,80,73,80,13,54,72,83,6,128,73,0,128,73,0,
73,66,9,35,64,83,128,65,0,192,65,0,137,78,5,14,0,72,70,6,128,66,0,128,68,
0,72,84,6,128,72,0,128,82,0,192,70,0,128,67,0,200,84,7,0,128,69,0,192,83,
0,128,73,0,80,83,1,20,137,76,5,133,0,73,70,7,76,128,76,0,73,67,15,37,137,
70,5,8,0,128,67,0,128,73,0,72,66,14,137,73,5,8,0,128,70,0,128,83,0,192,
65,0,64,86,128,65,0,200,69,13,0,136,84,4,0,64,65,128,83,0,64,68,137,77,
5,12,0,136,76,4,0,128,71,0,64,79,128,84,0,73,73,23,39,137,83,5,12,0,136,
77,4,0,128,76,0,64,87,64,89,128,71,0,200,72,11,0,136,86,4,0,128,72,0,64,
71,128,73,0,72,75,10,136,70,4,0,128,65,0,128,74,0,201,82,30,88,0,137,77,
5,18,0,137,70,5,10,0,64,69,128,70,0,128,73,0,136,87,4,0,128,80,0,73,79,
18,37,137,78,5,8,0,128,68,0,192,80,0,128,69,0,136,78,4,0,64,77,137,82,5,
8,0,128,79,0,64,83,128,83,0,136,81,4,0,64,80,137,82,5,12,0,136,80,4,0,128,
65,0,128,83,0,201,85,12,42,0,136,83,4,0,128,80,0,72,84,6,128,83,0,64,83,
73,82,7,19,128,65,0,200,68,7,0,128,70,0,64,67,128,67,0,128,86,0,136,88,
4,0,64,86,128,71,0,64,82,73,77,7,65,128,83,0,73,68,7,37,128,70,0,136,67,
4,0,64,65,73,82,9,21,64,73,128,83,0,200,77,7,0,128,67,0,64,73,128,82,0,
128,84,0,136,73,4,0,64,69,137,76,5,12,0,136,68,4,0,128,67,0,128,78,0,73,
83,7,21,128,82,0,200,82,9,0,64,65,128,80,0,64,79,128,76,0,64,84,128,72,
0,74,87,139,1,3,73,77,11,69,64,67,64,67,128,83,0,201,69,8,32,0,128,65,0,
73,67,7,12,128,82,0,64,65,128,78,0,192,68,0,72,82,6,128,65,0,128,67,0,72,
73,19,201,73,8,13,0,128,73,0,64,71,128,79,0,128,75,0,64,71,64,66,128,80,
0,73,83,11,28,64,65,64,80,128,73,0,201,80,8,11,0,128,78,0,128,78,0,192,
82,0,128,70,0,72,87,14,64,79,64,70,64,70,64,76,128,69,0,64,84,137,80,5,
12,0,64,66,64,65,128,77,0,64,86,64,80,64,82,128,65,0,200,86,46,0,137,73,
5,27,0,136,68,4,0,192,65,0,73,71,7,12,128,84,0,64,70,128,80,0,128,78,0,
72,83,12,64,83,64,65,64,77,128,84,0,128,79,0,64,85,73,74,7,46,128,83,0,
137,70,5,30,0,72,68,12,136,84,4,0,64,83,128,83,0,64,65,137,80,5,8,0,128,
67,0,128,83,0,64,71,64,78,64,69,128,84,0,73,83,7,19,128,66,0,200,79,7,0,
128,76,0,64,75,128,70,0,64,87,64,72,128,83,0,72,90,14,137,79,5,8,0,128,
67,0,128,83,0,64,89,137,79,5,12,0,64,72,64,73,128,77,0,64,83,72,87,8,64,
89,128,71,0,64,73,73,83,9,28,64,89,128,71,0,72,77,10,64,87,64,89,128,71,
0,64,65,64,87,64,89,128,71,0,64,87,72,89,18,137,78,5,12,0,136,77,4,0,128,
71,0,128,87,0,64,73,128,83,0,64,86,74,78,46,4,77,73,78,7,20,128,73,0,136,
67,4,0,64,65,136,86,4,0,128,84,0,72,85,8,64,77,128,76,0,64,84,137,82,5,
8,0,128,77,0,128,85,0,74,71,50,2,73,73,72,7,30,128,68,0,73,69,7,16,128,
69,0,72,67,6,128,83,0,128,65,0,64,71,64,73,128,83,0,73,82,7,12,128,83,0,
64,76,128,73,0,128,84,0,74,68,77,1,126,73,76,11,41,136,84,4,0,128,67,0,
73,71,7,20,128,71,0,136,67,4,0,64,65,136,84,4,0,128,70,0,136,74,4,0,192,
73,0,128,77,0,73,81,7,20,128,83,0,72,80,8,64,65,128,85,0,64,79,128,84,0,
72,84,6,128,83,0,64,82,128,76,0,201,66,77,191,0,73,80,7,40,128,74,0,73,
76,9,24,64,72,128,69,0,200,73,9,0,64,69,128,68,0,192,65,0,128,67,0,72,79,
6,128,84,0,128,77,0,73,84,7,29,128,84,0,200,83,19,0,136,83,4,0,64,67,64,
82,64,73,64,80,128,84,0,128,82,0,128,86,0,64,65,73,77,7,58,128,84,0,73,
69,9,32,64,82,128,83,0,73,67,7,18,128,77,0,64,65,72,80,6,128,73,0,128,73,
0,64,68,128,84,0,137,71,5,14,0,64,70,136,67,4,0,128,66,0,64,72,128,85,0,
201,84,12,41,0,64,82,64,85,128,83,0,73,82,9,20,64,84,128,77,0,64,78,136,
82,4,0,64,79,128,67,0,64,83,64,73,64,77,128,82,0,72,87,10,136,84,4,0,128,
65,0,128,86,0,192,67,0,201,76,8,58,0,128,67,0,73,69,11,33,136,77,4,0,128,
71,0,137,66,5,10,0,64,65,128,68,0,192,68,0,136,83,4,0,64,72,128,68,0,73,
71,7,12,128,69,0,64,70,128,83,0,64,74,128,68,0,73,83,13,34,136,79,4,0,64,
69,128,76,0,201,80,12,18,0,136,82,4,0,128,73,0,192,79,0,128,83,0,128,82,
0,73,85,9,14,64,72,128,83,0,64,84,128,70,0,64,86,128,65,0,72,70,54,73,73,
15,30,137,80,5,8,0,128,73,0,128,82,0,137,68,5,10,0,64,65,128,84,0,64,70,
128,83,0,73,79,13,18,64,88,64,80,64,82,128,79,0,64,77,128,80,0,128,87,0,
64,69,73,77,7,50,128,83,0,73,70,9,30,64,65,128,67,0,72,67,16,137,68,5,10,
0,64,67,128,73,0,128,77,0,64,66,128,65,0,72,76,8,64,75,128,68,0,64,71,128,
70,0,73,83,11,22,136,67,4,0,128,65,0,72,82,6,128,80,0,64,80,128,65,0,72,
86,10,64,82,64,65,128,65,0,64,84,64,65,64,83,64,83,64,69,64,83,128,83,0,
73,75,48,228,73,79,19,32,72,80,6,128,84,0,64,78,64,80,64,73,128,67,0,72,
76,10,64,73,64,70,128,69,0,128,71,0,64,83,192,65,0,64,86,64,69,128,82,0,
72,73,123,201,80,24,71,0,73,80,7,14,128,83,0,136,78,4,0,128,71,0,64,82,
128,69,0,73,73,13,34,72,82,6,128,83,0,128,70,0,73,68,15,18,64,69,64,79,
64,67,64,65,128,84,0,128,67,0,128,72,0,72,79,10,136,83,4,0,128,77,0,128,
78,0,73,84,7,40,128,67,0,72,83,8,64,83,128,82,0,64,82,64,84,64,85,64,65,
72,76,8,64,80,128,67,0,64,71,64,73,64,82,128,76,0,72,89,6,128,77,0,128,
88,0,64,72,137,70,5,21,0,201,68,8,13,0,128,76,0,64,65,128,73,0,128,69,0,
73,79,9,14,64,77,128,69,0,64,76,128,76,0,192,83,0,73,73,7,10,128,67,0,128,
66,0,64,83,64,67,128,82,0,200,77,109,0,201,76,8,57,0,128,73,0,73,69,9,34,
64,67,128,67,0,73,67,17,20,137,66,5,10,0,64,65,128,83,0,128,73,0,128,65,
0,64,68,128,81,0,72,73,6,128,83,0,64,70,136,83,4,0,128,77,0,73,83,7,37,
128,83,0,73,80,7,15,128,83,0,192,77,0,64,67,128,65,0,192,82,0,192,67,0,
64,80,64,76,64,85,128,83,0,72,85,6,128,71,0,64,84,128,78,0,192,76,0,137,
74,5,84,0,73,68,11,56,136,76,4,0,128,66,0,201,66,20,32,0,137,86,5,12,0,
136,73,4,0,128,65,0,128,87,0,64,65,200,78,7,0,128,83,0,128,75,0,64,67,137,
68,5,8,0,128,67,0,128,77,0,137,70,5,8,0,128,69,0,64,73,73,84,7,10,128,69,
0,128,82,0,128,87,0,137,82,5,22,0,73,79,7,10,128,67,0,128,75,0,64,80,64,
71,128,79,0,200,84,7,0,128,73,0,64,83,137,73,5,12,0,136,68,4,0,128,67,0,
128,77,0,74,85,14,1,234,64,77,136,69,4,0,128,67,0,74,82,74,1,6,73,76,7,
46,128,65,0,73,67,7,28,128,65,0,72,66,12,136,79,4,0,64,67,128,80,0,64,65,
136,89,4,0,128,77,0,72,73,6,128,73,0,64,68,128,66,0,201,82,8,20,0,128,80,
0,72,81,6,128,65,0,192,77,0,128,76,0,128,86,0,201,80,96,177,0,73,77,7,52,
128,83,0,137,72,5,22,0,73,67,7,12,128,67,0,64,65,128,84,0,64,68,128,78,
0,72,76,12,136,83,4,0,64,77,128,78,0,64,73,136,77,4,0,64,65,128,73,0,201,
83,8,30,0,128,83,0,73,79,7,13,128,84,0,192,78,0,128,77,0,64,82,136,84,4,
0,128,78,0,72,87,6,128,83,0,128,85,0,64,79,73,73,19,44,136,80,4,0,64,67,
64,69,64,88,64,77,128,76,0,73,70,13,20,136,82,4,0,64,68,128,77,0,136,68,
4,0,128,65,0,64,71,128,69,0,73,87,15,30,72,76,8,64,65,128,78,0,128,68,0,
72,83,10,136,66,4,0,128,65,0,64,79,128,84,0,64,89,128,80,0,64,81,136,80,
4,0,64,69,128,71,0,72,84,58,73,77,7,32,128,66,0,73,69,7,22,128,67,0,72,
68,6,128,80,0,64,65,136,77,4,0,128,65,0,128,76,0,137,80,5,18,0,64,79,137,
67,5,8,0,128,65,0,128,76,0,64,86,128,76,0,64,83,73,77,9,93,64,77,128,67,
0,73,68,11,39,136,67,4,0,128,65,0,73,66,7,25,128,75,0,192,65,0,137,78,5,
12,0,136,77,4,0,128,67,0,128,84,0,128,67,0,73,70,15,40,72,84,8,64,80,128,
68,0,128,69,0,64,69,73,80,7,16,128,82,0,136,79,4,0,64,76,128,80,0,64,87,
64,83,128,83,0,64,73,128,65,0,201,84,25,50,0,201,79,10,17,0,64,86,128,76,
0,136,69,4,0,128,65,0,128,83,0,73,80,11,16,136,68,4,0,128,67,0,64,78,128,
76,0,64,83,136,72,4,0,128,67,0,72,87,6,128,82,0,64,85,128,75,0,73,88,9,
86,64,77,128,76,0,72,87,26,137,80,5,16,0,72,73,6,128,67,0,64,65,128,80,
0,64,82,64,65,128,80,0,64,86,73,80,9,32,64,65,128,84,0,73,71,7,18,128,65,
0,72,69,6,128,76,0,64,65,128,87,0,64,73,128,80,0,137,84,5,12,0,64,83,64,
79,128,80,0,64,86,128,70,0,72,90,26,73,80,9,20,64,82,128,80,0,72,75,6,128,
79,0,64,73,128,71,0,128,86,0,64,89,137,80,5,18,0,136,77,4,0,64,67,64,72,
64,65,128,84,0,64,83,64,79,128,83,0,64,88,74,78,8,1,33,128,83,0,73,70,26,
169,137,73,5,15,0,200,69,7,0,128,76,0,128,65,0,136,83,4,0,128,78,0,73,67,
9,85,64,65,128,80,0,72,66,53,201,76,14,31,0,72,67,6,128,71,0,128,65,0,73,
67,7,12,128,68,0,64,65,128,80,0,64,69,128,76,0,137,82,5,14,0,64,77,136,
80,4,0,128,67,0,64,84,128,70,0,64,65,137,76,5,12,0,64,68,64,69,128,83,0,
64,83,64,84,64,73,128,82,0,72,69,28,137,82,5,20,0,72,78,10,64,68,64,79,
128,83,0,64,73,128,71,0,64,83,128,83,0,64,68,201,77,14,23,0,136,82,4,0,
64,67,128,80,0,136,75,4,0,64,68,128,77,0,64,84,128,79,0,73,75,9,33,64,77,
128,83,0,72,73,19,200,77,9,0,64,83,128,83,0,64,67,64,69,128,67,0,64,72,
128,69,0,72,77,34,73,69,7,20,128,78,0,137,66,5,8,0,128,65,0,64,67,128,68,
0,72,82,6,128,86,0,64,76,128,65,0,64,76,73,80,7,24,128,79,0,73,70,7,10,
128,68,0,128,68,0,64,73,64,70,128,70,0,72,83,6,128,83,0,64,82,64,69,64,
80,64,79,64,82,128,84,0,73,84,28,167,73,69,9,19,64,82,128,77,0,200,67,7,
0,128,83,0,128,66,0,64,82,128,66,0,73,81,19,82,72,85,12,64,83,64,69,64,
77,128,69,0,128,76,0,72,80,58,137,77,5,28,0,137,71,5,14,0,136,69,4,0,64,
68,128,76,0,64,76,64,73,64,70,128,69,0,73,82,11,24,64,73,64,78,128,84,0,
64,79,64,73,64,78,64,84,64,69,128,82,0,128,83,0,64,79,128,84,0,72,83,32,
73,76,7,20,128,84,0,72,68,6,128,76,0,64,65,64,80,128,73,0,136,85,4,0,64,
80,128,70,0,64,82,137,68,5,20,0,72,67,10,136,69,4,0,128,67,0,64,65,128,
89,0,128,70,0,73,87,11,36,136,68,4,0,128,66,0,72,86,14,72,77,6,128,67,0,
64,70,128,66,0,64,85,136,76,4,0,64,65,128,82,0,192,89,0,64,83,128,67,0,
88,208,3,60,229,83,158,39,171,1,230,33,64,208,74,158,251,23,56,64,208,137,
157,5,113,0,73,151,9,44,64,208,128,163,0,73,146,13,28,64,208,136,151,4,
0,128,148,0,72,145,8,64,208,128,148,0,64,144,64,208,128,147,0,64,147,64,
208,128,161,0,73,155,25,57,64,208,72,160,8,64,208,128,160,0,64,152,64,208,
64,161,64,208,128,146,0,192,152,0,64,208,137,159,5,16,0,72,158,8,64,208,
128,162,0,128,147,0,64,163,64,208,64,159,64,208,128,144,0,64,156,64,208,
128,166,0,73,162,29,104,64,208,137,165,5,8,0,128,164,0,64,173,64,208,64,
160,64,208,64,146,64,208,128,161,0,201,159,23,31,0,64,208,137,161,5,13,
0,192,154,0,64,208,128,158,0,128,162,0,192,158,0,64,208,128,159,0,64,161,
64,208,73,158,9,20,64,208,128,152,0,72,156,8,64,208,128,158,0,128,147,0,
72,163,12,64,208,64,145,64,208,128,148,0,192,159,0,64,208,128,157,0,73,
174,9,20,64,208,128,155,0,64,164,64,208,64,154,64,208,128,154,0,64,175,
64,208,128,159,0,74,149,109,10,63,64,208,73,159,13,49,64,208,64,145,64,
208,128,158,0,201,155,14,21,0,64,208,64,166,64,208,128,147,0,136,152,4,
0,128,148,0,72,158,8,64,208,128,163,0,64,157,64,208,128,152,0,73,162,9,
37,64,208,128,161,0,72,161,17,64,208,200,160,9,0,64,208,128,159,0,128,148,
0,64,160,64,208,64,149,64,208,128,161,0,64,173,64,208,200,161,9,0,64,208,
128,160,0,128,159,0,82,145,2,199,4,50,64,208,74,159,60,1,254,64,208,73,
159,18,25,64,208,200,161,9,0,64,208,128,156,0,128,147,0,136,155,4,0,128,
152,0,192,161,0,64,208,73,159,9,16,64,208,128,160,0,64,146,64,208,128,162,
0,64,162,64,208,128,155,0,73,152,38,150,64,208,137,154,5,20,0,64,145,64,
208,64,144,64,208,64,157,64,208,128,154,0,192,157,0,64,208,64,154,64,208,
128,158,0,73,147,13,56,64,208,64,160,64,208,128,159,0,73,145,25,32,64,208,
72,165,16,64,208,64,164,64,208,64,144,64,208,128,161,0,128,164,0,64,144,
64,208,128,154,0,64,146,64,208,136,168,4,0,128,159,0,136,150,4,0,64,148,
64,208,137,156,5,29,0,201,148,10,21,0,64,208,128,151,0,136,147,4,0,64,145,
64,208,128,145,0,128,151,0,137,165,5,16,0,72,159,8,64,208,128,161,0,128,
158,0,128,174,0,73,156,22,240,64,208,136,159,4,0,192,158,0,64,208,64,165,
64,208,128,163,0,72,155,180,64,208,73,158,13,100,64,208,64,157,64,208,128,
158,0,73,148,17,80,64,208,64,163,64,208,64,156,64,208,128,171,0,64,147,
64,208,64,158,64,208,64,161,64,208,64,144,64,208,64,148,64,208,64,156,64,
208,64,152,64,208,64,157,64,208,64,152,64,208,64,161,64,208,64,162,64,208,
64,160,64,208,64,144,64,208,64,166,64,208,64,152,64,208,128,175,0,64,151,
64,208,128,163,0,73,164,9,64,64,208,128,158,0,64,161,64,208,73,163,9,36,
64,208,128,148,0,72,162,12,64,208,64,144,64,208,128,162,0,64,158,64,208,
64,146,64,208,64,149,64,208,128,162,0,72,174,8,64,208,128,162,0,64,173,
64,208,128,161,0,64,166,64,208,64,152,64,208,128,162,0,192,154,0,64,208,
73,158,9,25,64,208,128,156,0,136,157,4,0,192,152,0,64,208,64,173,64,208,
128,159,0,192,161,0,64,208,128,156,0,72,158,40,64,208,73,158,13,32,64,208,
64,146,64,208,128,154,0,64,154,64,208,72,161,8,64,208,128,156,0,64,159,
64,208,128,158,0,128,159,0,64,157,64,208,64,158,64,208,136,162,4,0,192,
157,0,64,208,128,144,0,73,165,17,125,64,208,72,161,8,64,208,128,161,0,128,
151,0,201,162,22,77,0,64,208,137,159,5,12,0,136,154,4,0,128,152,0,128,166,
0,72,161,28,64,208,73,156,9,12,64,208,128,173,0,128,149,0,64,160,64,208,
64,162,64,208,128,158,0,64,160,64,208,137,159,5,12,0,136,158,4,0,128,146,
0,64,161,64,208,64,159,64,208,128,157,0,72,164,8,64,208,128,163,0,64,163,
64,208,73,152,13,16,64,208,64,164,64,208,128,173,0,128,146,0,128,159,0,
73,170,25,52,64,208,64,149,64,208,64,145,64,208,64,144,64,208,64,157,64,
208,128,154,0,72,169,20,64,208,64,149,64,208,64,159,64,208,64,152,64,208,
128,162,0,64,167,64,208,128,160,0,136,174,4,0,192,173,0,64,208,136,159,
4,0,128,144,0,73,134,37,40,64,208,73,161,9,24,64,208,128,146,0,72,159,12,
64,208,64,159,64,208,128,158,0,128,154,0,64,175,64,208,128,148,0,128,129,
0,64,144,64,208,73,159,21,164,64,208,137,146,5,12,0,64,145,64,208,128,156,
0,128,149,0,201,152,30,87,0,64,208,137,146,5,16,0,136,145,4,0,64,144,64,
208,128,158,0,136,173,4,0,128,147,0,201,147,14,54,0,64,208,136,145,4,0,
128,144,0,72,146,20,64,208,137,161,5,8,0,128,159,0,64,163,64,208,128,154,
0,64,144,64,208,200,166,9,0,64,208,128,156,0,64,157,64,208,128,154,0,128,
149,0,73,157,25,53,64,208,72,160,8,64,208,128,157,0,64,154,64,208,64,158,
64,208,128,158,0,136,156,4,0,192,154,0,64,208,73,159,9,12,64,208,128,158,
0,128,145,0,64,162,64,208,128,161,0,128,158,0,73,164,9,127,64,208,128,164,
0,201,162,30,111,0,64,208,137,159,5,16,0,137,152,5,8,0,128,145,0,128,154,
0,136,163,4,0,128,162,0,72,161,61,64,208,137,160,5,36,0,73,157,17,20,64,
208,72,162,8,64,208,128,152,0,128,154,0,128,145,0,64,159,64,208,64,162,
64,208,128,163,0,72,173,8,64,208,128,157,0,192,163,0,64,208,136,162,4,0,
128,159,0,192,160,0,64,208,72,152,8,64,208,128,162,0,64,144,64,208,128,
148,0,64,163,64,208,128,154,0,137,168,5,16,0,136,166,4,0,64,165,64,208,
128,154,0,192,173,0,64,208,136,164,4,0,128,152,0,82,147,2,109,4,19,64,208,
74,157,10,1,52,64,208,128,151,0,73,148,9,146,64,208,128,159,0,201,146,35,
106,0,64,208,137,154,5,17,0,136,151,4,0,192,146,0,64,208,128,151,0,136,
157,4,0,64,156,64,208,128,161,0,72,145,28,64,208,72,163,20,64,208,64,146,
64,208,64,159,64,208,64,152,64,208,128,161,0,128,156,0,64,144,64,208,137,
163,5,28,0,72,161,16,64,208,72,152,8,64,208,128,144,0,128,144,0,64,159,
64,208,128,162,0,72,167,8,64,208,128,158,0,128,165,0,64,147,64,208,137,
154,5,24,0,72,152,8,64,208,128,161,0,64,147,64,208,64,147,64,208,128,157,
0,128,157,0,73,155,17,104,64,208,136,161,4,0,64,156,64,208,128,162,0,200,
154,13,0,64,208,136,156,4,0,128,155,0,192,152,0,64,208,137,161,5,50,0,137,
156,5,34,0,200,154,9,0,64,208,128,156,0,192,152,0,64,208,137,154,5,12,0,
64,152,64,208,128,154,0,128,162,0,64,160,64,208,64,164,64,208,128,155,0,
137,166,5,12,0,64,164,64,208,128,154,0,64,173,64,208,128,162,0,192,156,
0,64,208,137,152,5,28,0,137,148,5,12,0,136,146,4,0,128,144,0,64,149,64,
208,136,165,4,0,128,162,0,137,163,5,8,0,128,155,0,64,173,64,208,128,154,
0,201,162,59,221,0,64,208,137,161,5,20,0,137,154,5,8,0,128,152,0,64,160,
64,208,128,154,0,201,163,14,17,0,64,208,64,144,64,208,128,173,0,128,162,
0,64,173,64,208,64,152,64,208,64,156,64,208,128,162,0,73,160,43,107,64,
208,201,157,22,30,0,64,208,72,174,8,64,208,128,155,0,64,152,64,208,128,
159,0,192,146,0,64,208,128,159,0,64,174,64,208,128,155,0,200,159,37,0,64,
208,73,162,9,20,64,208,128,163,0,137,157,5,8,0,128,151,0,128,161,0,72,173,
8,64,208,128,154,0,128,163,0,64,158,64,208,73,157,9,20,64,208,128,145,0,
136,154,4,0,64,152,64,208,128,157,0,128,163,0,64,161,64,208,73,159,9,36,
64,208,128,148,0,137,148,5,20,0,136,146,4,0,64,145,64,208,64,173,64,208,
128,159,0,136,158,4,0,128,151,0,137,163,5,12,0,136,162,4,0,128,160,0,128,
173,0,73,166,9,68,64,208,128,159,0,200,164,18,0,64,208,200,161,9,0,64,208,
128,158,0,128,149,0,192,163,0,64,208,201,159,14,25,0,64,208,136,161,4,0,
128,160,0,136,154,4,0,64,146,64,208,128,148,0,64,161,64,208,136,159,4,0,
128,158,0,192,173,0,64,208,136,163,4,0,64,154,64,208,128,163,0,64,146,64,
208,202,158,20,1,10,0,64,208,200,161,9,0,64,208,128,161,0,128,159,0,201,
151,14,135,0,64,208,64,159,64,208,128,156,0,73,146,61,72,64,208,137,159,
5,44,0,137,151,5,28,0,64,144,64,208,72,163,8,64,208,128,155,0,64,154,64,
208,64,163,64,208,128,155,0,64,154,64,208,64,163,64,208,128,161,0,137,161,
5,8,0,128,160,0,128,173,0,136,145,4,0,64,144,64,208,128,158,0,200,148,26,
0,64,208,137,159,5,17,0,136,146,4,0,192,145,0,64,208,128,160,0,128,162,
0,64,147,64,208,137,151,5,12,0,64,146,64,208,128,151,0,64,161,64,208,128,
158,0,73,155,13,78,64,208,136,160,4,0,128,144,0,72,154,29,64,208,201,158,
10,17,0,64,208,128,157,0,136,147,4,0,128,146,0,64,163,64,208,128,147,0,
64,152,64,208,73,158,9,20,64,208,128,148,0,72,156,8,64,208,128,163,0,128,
148,0,192,160,0,64,208,64,163,64,208,128,147,0,72,157,17,64,208,200,161,
9,0,64,208,128,161,0,128,159,0,64,156,64,208,200,161,9,0,64,208,128,145,
0,128,148,0,201,164,14,121,0,64,208,136,154,4,0,128,148,0,73,161,13,58,
64,208,136,167,4,0,128,149,0,72,160,20,64,208,72,154,12,64,208,64,161,64,
208,128,161,0,128,144,0,192,159,0,64,208,137,158,5,17,0,136,151,4,0,192,
145,0,64,208,128,163,0,128,164,0,72,163,12,64,208,136,162,4,0,128,144,0,
192,162,0,64,208,73,154,9,25,64,208,128,163,0,200,152,9,0,64,208,128,163,
0,64,144,64,208,128,173,0,64,162,64,208,128,163,0,73,168,9,20,64,208,128,
156,0,136,167,4,0,64,166,64,208,128,161,0,64,173,64,208,136,161,4,0,128,
159,0,192,148,0,64,208,73,157,13,214,64,208,136,162,4,0,128,160,0,201,151,
18,133,0,64,208,72,161,8,64,208,128,162,0,128,154,0,201,146,30,63,0,64,
208,137,162,5,20,0,136,158,4,0,64,151,64,208,64,175,64,208,128,152,0,128,
164,0,200,145,13,0,64,208,136,167,4,0,128,160,0,64,144,64,208,137,163,5,
13,0,192,145,0,64,208,128,144,0,128,165,0,72,149,40,64,208,73,160,21,32,
64,208,64,147,64,208,64,163,64,208,64,144,64,208,128,156,0,72,154,8,64,
208,128,163,0,128,151,0,128,163,0,192,148,0,64,208,136,174,4,0,128,161,
0,73,155,9,45,64,208,128,159,0,72,154,20,64,208,137,159,5,12,0,136,147,
4,0,128,145,0,128,161,0,192,152,0,64,208,136,161,4,0,64,154,64,208,128,
145,0,64,156,64,208,137,158,5,12,0,136,154,4,0,128,147,0,136,163,4,0,128,
161,0,73,164,13,125,64,208,136,158,4,0,128,154,0,201,161,26,101,0,64,208,
137,156,5,12,0,136,146,4,0,128,145,0,64,158,64,208,128,158,0,72,159,36,
64,208,137,157,5,24,0,73,146,9,12,64,208,128,158,0,128,145,0,64,152,64,
208,128,164,0,136,164,4,0,128,163,0,64,158,64,208,73,159,9,24,64,208,128,
159,0,72,158,12,64,208,136,166,4,0,128,161,0,128,148,0,136,162,4,0,64,160,
64,208,128,144,0,64,163,64,208,64,146,64,208,128,161,0,73,173,21,42,64,
208,137,147,5,12,0,64,145,64,208,128,166,0,128,166,0,72,168,13,64,208,192,
145,0,64,208,128,160,0,192,166,0,64,208,128,145,0,64,174,64,208,136,161,
4,0,128,145,0,82,154,3,78,6,216,64,208,74,158,46,1,171,64,208,73,157,9,
24,64,208,128,165,0,137,151,5,12,0,64,147,64,208,128,163,0,128,154,0,136,
164,4,0,64,159,64,208,136,164,4,0,128,148,0,73,150,17,190,64,208,137,159,
5,8,0,128,148,0,128,162,0,201,147,22,128,0,64,208,137,160,5,12,0,64,150,
64,208,128,148,0,128,162,0,201,145,42,57,0,64,208,137,158,5,16,0,137,150,
5,8,0,128,144,0,128,156,0,73,162,9,12,64,208,128,156,0,128,161,0,64,163,
64,208,128,157,0,64,144,64,208,64,145,64,208,64,158,64,208,128,157,0,192,
146,0,64,208,73,154,9,33,64,208,128,163,0,73,147,13,16,64,208,64,163,64,
208,128,156,0,128,144,0,192,148,0,64,208,128,159,0,72,173,8,64,208,128,
148,0,128,161,0,72,149,8,64,208,128,152,0,192,148,0,64,208,73,158,9,20,
64,208,128,160,0,136,150,4,0,64,146,64,208,128,144,0,136,166,4,0,192,162,
0,64,208,128,162,0,73,155,13,103,64,208,64,158,64,208,128,157,0,201,152,
42,82,0,64,208,73,159,9,16,64,208,128,160,0,136,157,4,0,128,145,0,64,161,
64,208,72,151,8,64,208,128,157,0,64,144,64,208,128,160,0,192,151,0,64,208,
73,152,9,28,64,208,128,166,0,73,148,13,16,64,208,136,165,4,0,128,159,0,
128,145,0,128,149,0,136,156,4,0,128,154,0,192,154,0,64,208,128,173,0,200,
157,49,0,64,208,73,159,9,24,64,208,128,158,0,137,148,5,12,0,64,145,64,208,
128,163,0,128,154,0,137,165,5,16,0,64,160,64,208,64,152,64,208,128,162,
0,128,168,0,64,156,64,208,137,152,5,24,0,72,148,16,64,208,137,154,5,8,0,
128,148,0,128,157,0,128,145,0,136,158,4,0,64,157,64,208,128,159,0,74,165,
10,1,112,64,208,128,164,0,74,162,50,1,58,64,208,137,158,5,20,0,137,154,
5,8,0,128,145,0,64,156,64,208,128,158,0,137,162,5,8,0,128,161,0,64,173,
64,208,72,161,8,64,208,128,159,0,128,159,0,201,160,100,182,0,64,208,137,
155,5,48,0,137,148,5,36,0,72,146,28,64,208,64,157,64,208,64,163,64,208,
64,162,64,208,64,158,64,208,64,160,64,208,128,147,0,128,145,0,64,151,64,
208,128,163,0,137,160,5,20,0,64,158,64,208,72,157,8,64,208,128,158,0,128,
155,0,64,163,64,208,200,161,9,0,64,208,128,165,0,192,156,0,64,208,64,162,
64,208,128,161,0,192,159,0,64,208,73,154,13,44,64,208,136,152,4,0,128,151,
0,137,148,5,12,0,136,145,4,0,128,144,0,72,152,16,64,208,64,152,64,208,64,
159,64,208,128,146,0,128,151,0,137,161,5,21,0,136,158,4,0,192,155,0,64,
208,64,146,64,208,128,159,0,136,164,4,0,192,162,0,64,208,128,161,0,64,161,
64,208,201,159,10,55,0,64,208,128,160,0,201,156,14,38,0,64,208,136,162,
4,0,128,161,0,72,154,8,64,208,128,148,0,192,146,0,64,208,72,157,8,64,208,
128,154,0,128,144,0,136,158,4,0,128,157,0,137,163,5,16,0,72,162,8,64,208,
128,163,0,128,161,0,64,173,64,208,128,152,0,200,164,17,0,64,208,137,159,
5,8,0,128,144,0,128,161,0,64,163,64,208,137,157,5,16,0,72,149,8,64,208,
128,161,0,128,148,0,64,175,64,208,128,157,0,73,168,9,24,64,208,128,160,
0,72,167,12,64,208,136,161,4,0,128,157,0,128,166,0,72,174,8,64,208,128,
160,0,64,173,64,208,136,160,4,0,128,148,0,82,151,1,145,1,221,64,208,73,
157,13,196,64,208,64,159,64,208,128,158,0,137,150,5,106,0,73,145,30,70,
64,208,72,173,8,64,208,128,154,0,192,152,0,64,208,136,158,4,0,64,154,64,
208,128,158,0,72,144,33,64,208,137,148,5,16,0,72,147,8,64,208,128,161,0,
128,144,0,200,162,9,0,64,208,128,173,0,128,159,0,64,134,64,208,128,158,
0,72,148,16,64,208,136,161,4,0,64,158,64,208,128,157,0,64,147,64,208,72,
159,8,64,208,128,152,0,128,144,0,201,154,10,26,0,64,208,128,156,0,72,152,
8,64,208,128,151,0,192,151,0,64,208,128,150,0,72,156,32,64,208,137,157,
5,16,0,136,156,4,0,64,152,64,208,128,160,0,136,164,4,0,64,159,64,208,128,
163,0,64,155,64,208,73,156,9,12,64,208,128,154,0,128,154,0,128,159,0,137,
163,5,141,0,201,160,30,100,0,64,208,137,152,5,12,0,136,151,4,0,128,150,
0,72,161,8,64,208,128,161,0,128,154,0,200,159,50,0,64,208,137,154,5,20,
0,72,152,12,64,208,64,155,64,208,128,159,0,128,146,0,200,159,21,0,64,208,
72,161,8,64,208,128,161,0,64,158,64,208,128,163,0,128,156,0,64,158,64,208,
137,152,5,8,0,128,150,0,192,154,0,64,208,128,157,0,72,162,24,64,208,73,
158,9,16,64,208,128,161,0,136,156,4,0,128,152,0,128,159,0,192,161,0,64,
208,136,159,4,0,128,156,0,137,166,5,37,0,200,165,13,0,64,208,136,158,4,
0,128,156,0,64,164,64,208,137,152,5,8,0,128,151,0,64,156,64,208,128,168,
0,72,173,12,64,208,136,161,4,0,128,156,0,64,168,64,208,128,146,0,64,150,
64,208,73,156,9,49,64,208,128,161,0,201,148,10,29,0,64,208,128,147,0,72,
147,8,64,208,128,145,0,64,146,64,208,64,155,64,208,128,161,0,64,154,64,
208,136,165,4,0,128,151,0,137,166,5,16,0,72,161,8,64,208,128,161,0,128,
159,0,64,173,64,208,128,154,0,64,152,64,208,73,158,9,208,64,208,128,161,
0,73,150,9,102,64,208,128,154,0,201,146,15,70,0,64,208,192,162,0,64,208,
128,144,0,72,145,20,64,208,73,152,9,12,64,208,128,163,0,128,148,0,128,163,
0,64,144,64,208,73,161,9,20,64,208,128,154,0,137,154,5,8,0,128,151,0,128,
157,0,136,173,4,0,64,162,64,208,128,173,0,72,148,12,64,208,136,160,4,0,
128,152,0,64,147,64,208,64,147,64,208,128,156,0,201,156,18,86,0,64,208,
137,161,5,8,0,128,148,0,128,173,0,200,154,21,0,64,208,72,158,12,64,208,
64,158,64,208,128,157,0,128,145,0,64,152,64,208,73,164,9,32,64,208,128,
164,0,73,158,9,16,64,208,128,161,0,64,156,64,208,128,164,0,64,163,64,208,
128,161,0,137,167,5,8,0,128,166,0,128,175,0,64,157,64,208,136,167,4,0,128,
165,0,73,163,25,190,64,208,73,159,9,16,64,208,128,144,0,136,157,4,0,128,
154,0,128,166,0,201,161,51,117,0,64,208,137,151,5,16,0,137,146,5,8,0,128,
145,0,128,147,0,73,161,9,17,64,208,128,158,0,192,154,0,64,208,128,159,0,
64,163,64,208,64,148,64,208,128,148,0,72,160,29,64,208,137,163,5,21,0,136,
159,4,0,192,158,0,64,208,136,161,4,0,128,156,0,128,168,0,64,159,64,208,
201,152,10,25,0,64,208,128,164,0,64,148,64,208,64,157,64,208,64,162,64,
208,128,159,0,192,162,0,64,208,128,148,0,64,162,64,208,73,152,9,32,64,208,
128,160,0,72,146,8,64,208,128,161,0,64,144,64,208,64,159,64,208,64,158,
64,208,128,157,0,200,161,9,0,64,208,128,159,0,128,154,0,137,166,5,20,0,
72,165,8,64,208,128,164,0,64,164,64,208,128,157,0,64,175,64,208,128,152,
0,82,156,2,96,3,67,64,208,73,157,21,241,64,208,73,157,9,12,64,208,128,158,
0,128,154,0,128,158,0,137,150,5,136,0,73,147,51,111,64,208,73,159,9,25,
64,208,128,163,0,72,156,8,64,208,128,144,0,192,144,0,64,208,128,163,0,200,
163,13,0,64,208,64,159,64,208,128,161,0,64,162,64,208,128,163,0,73,145,
29,53,64,208,73,159,9,20,64,208,128,166,0,64,144,64,208,64,163,64,208,128,
161,0,128,160,0,64,144,64,208,72,165,13,64,208,192,160,0,64,208,128,160,
0,64,160,64,208,128,161,0,64,146,64,208,128,154,0,72,149,12,64,208,64,148,
64,208,128,145,0,192,148,0,64,208,128,161,0,201,154,30,57,0,64,208,137,
161,5,12,0,136,154,4,0,128,145,0,136,164,4,0,64,162,64,208,128,164,0,72,
152,24,64,208,73,154,9,16,64,208,128,152,0,136,148,4,0,128,145,0,128,157,
0,128,151,0,72,156,16,64,208,72,160,8,64,208,128,164,0,128,151,0,64,155,
64,208,64,148,64,208,128,166,0,202,163,27,1,68,0,64,208,72,160,12,64,208,
136,167,4,0,128,159,0,64,155,64,208,128,165,0,73,160,17,135,64,208,137,
148,5,8,0,128,146,0,128,159,0,200,159,46,0,64,208,73,156,9,25,64,208,128,
145,0,137,154,5,13,0,192,152,0,64,208,128,160,0,128,155,0,73,161,9,12,64,
208,128,165,0,128,158,0,128,162,0,64,158,64,208,201,161,10,37,0,64,208,
128,158,0,137,157,5,12,0,136,148,4,0,128,145,0,64,160,64,208,64,161,64,
208,64,145,64,208,128,160,0,73,167,9,24,64,208,128,161,0,64,164,64,208,
64,163,64,208,64,154,64,208,128,166,0,64,173,64,208,128,152,0,72,162,50,
64,208,201,161,10,34,0,64,208,128,145,0,137,158,5,16,0,64,152,64,208,64,
165,64,208,128,158,0,192,159,0,64,208,128,159,0,137,163,5,8,0,128,162,0,
128,166,0,192,161,0,64,208,137,155,5,100,0,73,148,13,24,64,208,64,158,64,
208,128,157,0,64,145,64,208,64,158,64,208,128,157,0,64,154,64,208,64,162,
64,208,72,160,28,64,208,64,144,64,208,64,157,64,208,64,161,64,208,64,156,
64,208,64,144,64,208,128,168,0,64,149,64,208,64,165,64,208,64,163,64,208,
64,147,64,208,64,155,64,208,64,149,64,208,64,160,64,208,64,158,64,208,128,
148,0,136,163,4,0,128,157,0,137,167,5,12,0,136,166,4,0,128,165,0,72,174,
8,64,208,128,152,0,64,173,64,208,136,161,4,0,64,146,64,208,128,156,0,192,
155,0,64,208,73,156,9,102,64,208,128,161,0,73,149,17,53,64,208,64,147,64,
208,64,162,64,208,128,152,0,73,146,9,29,64,208,128,156,0,200,145,9,0,64,
208,128,161,0,64,144,64,208,64,147,64,208,128,144,0,64,148,64,208,128,159,
0,73,154,13,32,64,208,136,161,4,0,128,160,0,64,152,64,208,73,154,9,12,64,
208,128,158,0,128,152,0,128,159,0,192,155,0,64,208,128,161,0,73,162,30,
89,64,208,72,163,12,64,208,64,147,64,208,128,144,0,192,154,0,64,208,64,
147,64,208,128,144,0,73,160,13,44,64,208,136,160,4,0,128,152,0,72,159,24,
64,208,73,163,13,16,64,208,64,156,64,208,128,147,0,128,157,0,128,173,0,
64,157,64,208,128,159,0,64,161,64,208,136,154,4,0,64,144,64,208,128,144,
0,137,165,5,20,0,64,163,64,208,64,146,64,208,64,148,64,208,128,162,0,64,
175,64,208,64,155,64,208,128,175,0,64,157,64,208,74,158,34,1,58,64,208,
73,152,9,16,64,208,128,159,0,136,151,4,0,128,148,0,72,164,8,64,208,128,
144,0,128,155,0,73,152,33,148,64,208,72,155,12,64,208,64,146,64,208,128,
156,0,64,152,64,208,72,162,8,64,208,128,156,0,128,159,0,73,148,29,88,64,
208,73,154,9,20,64,208,128,159,0,64,134,64,208,64,161,64,208,128,149,0,
128,159,0,72,147,16,64,208,136,156,4,0,64,154,64,208,128,156,0,64,144,64,
208,73,154,9,20,64,208,128,158,0,136,151,4,0,64,148,64,208,128,144,0,136,
161,4,0,64,159,64,208,136,162,4,0,64,158,64,208,128,161,0,72,151,16,64,
208,136,162,4,0,64,152,64,208,128,161,0,64,149,64,208,64,157,64,208,128,
156,0,73,156,29,125,64,208,137,154,5,16,0,137,145,5,8,0,128,144,0,128,148,
0,136,166,4,0,128,163,0,72,155,16,64,208,137,148,5,8,0,128,146,0,128,161,
0,192,154,0,64,208,137,154,5,16,0,72,149,8,64,208,128,152,0,128,148,0,64,
158,64,208,72,166,20,64,208,64,149,64,208,64,157,64,208,64,162,64,208,128,
160,0,64,148,64,208,64,152,64,208,64,161,64,208,64,159,64,208,64,144,64,
208,64,157,64,208,64,161,64,208,64,149,64,208,128,160,0,64,157,64,208,128,
157,0,201,163,14,118,0,64,208,64,162,64,208,128,166,0,201,161,18,79,0,64,
208,137,155,5,8,0,128,148,0,128,162,0,200,160,26,0,64,208,137,161,5,17,
0,192,152,0,64,208,64,173,64,208,128,154,0,128,164,0,64,159,64,208,137,
163,5,20,0,137,155,5,12,0,136,151,4,0,128,144,0,128,161,0,137,166,5,8,0,
128,164,0,128,173,0,192,162,0,64,208,137,154,5,17,0,200,152,9,0,64,208,
128,151,0,128,148,0,128,159,0,73,173,13,40,64,208,136,163,4,0,128,154,0,
72,166,12,64,208,64,154,64,208,128,156,0,64,165,64,208,64,165,64,208,64,
166,64,208,128,163,0,64,174,64,208,128,144,0,82,166,1,95,14,108,64,208,
201,156,22,158,0,64,208,137,159,5,12,0,136,158,4,0,128,154,0,128,162,0,
73,149,13,92,64,208,136,161,4,0,128,154,0,201,146,30,58,0,64,208,73,152,
9,16,64,208,128,154,0,64,146,64,208,128,160,0,64,156,64,208,128,144,0,200,
145,9,0,64,208,128,162,0,64,144,64,208,137,161,5,8,0,128,147,0,64,166,64,
208,128,161,0,64,148,64,208,200,174,9,0,64,208,128,162,0,192,158,0,64,208,
128,148,0,73,152,17,28,64,208,136,162,4,0,64,154,64,208,128,160,0,64,151,
64,208,136,161,4,0,128,157,0,192,154,0,64,208,137,154,5,8,0,128,145,0,128,
159,0,73,161,25,135,64,208,73,159,9,12,64,208,128,159,0,128,156,0,64,161,
64,208,128,156,0,201,159,30,87,0,64,208,137,154,5,20,0,64,145,64,208,64,
161,64,208,64,152,64,208,128,151,0,128,157,0,200,158,25,0,64,208,137,159,
5,8,0,128,148,0,64,161,64,208,64,163,64,208,128,160,0,64,157,64,208,137,
154,5,12,0,64,152,64,208,128,162,0,192,162,0,64,208,72,173,8,64,208,128,
152,0,128,152,0,64,160,64,208,73,148,9,16,64,208,128,158,0,136,146,4,0,
128,145,0,128,161,0,201,165,14,42,0,64,208,64,146,64,208,128,149,0,192,
162,0,64,208,73,160,13,16,64,208,64,161,64,208,128,156,0,128,152,0,64,162,
64,208,128,163,0,192,173,0,64,208,128,146,0,82,162,1,164,10,64,64,208,73,
157,21,240,64,208,136,154,4,0,64,152,64,208,64,159,64,208,128,162,0,73,
151,17,120,64,208,72,158,8,64,208,128,161,0,128,152,0,73,147,29,92,64,208,
137,154,5,16,0,64,152,64,208,64,157,64,208,128,159,0,64,157,64,208,128,
159,0,72,146,56,64,208,73,159,9,48,64,208,128,158,0,64,149,64,208,64,162,
64,208,64,165,64,208,64,160,64,208,64,144,64,208,64,157,64,208,64,149,64,
208,64,157,64,208,64,152,64,208,128,149,0,128,161,0,64,145,64,208,128,160,
0,64,148,64,208,136,156,4,0,128,150,0,73,155,9,72,64,208,128,154,0,72,154,
24,64,208,73,161,9,12,64,208,128,149,0,128,145,0,64,168,64,208,128,163,
0,64,152,64,208,73,158,9,16,64,208,128,161,0,136,154,4,0,128,152,0,72,162,
8,64,208,128,145,0,64,159,64,208,136,155,4,0,128,145,0,64,156,64,208,137,
161,5,16,0,72,156,8,64,208,128,159,0,128,154,0,64,166,64,208,128,159,0,
73,162,17,121,64,208,137,151,5,8,0,128,147,0,128,161,0,73,160,17,69,64,
208,137,154,5,8,0,128,146,0,128,165,0,72,159,16,64,208,64,152,64,208,64,
162,64,208,128,154,0,64,158,64,208,73,152,21,24,64,208,72,173,8,64,208,
128,154,0,64,162,64,208,128,154,0,128,147,0,192,161,0,64,208,128,145,0,
64,161,64,208,137,159,5,20,0,137,156,5,12,0,64,152,64,208,128,144,0,128,
158,0,72,163,8,64,208,128,159,0,128,161,0,137,168,5,24,0,136,166,4,0,64,
163,64,208,72,162,8,64,208,128,152,0,128,159,0,64,173,64,208,137,156,5,
12,0,64,154,64,208,128,158,0,64,160,64,208,64,144,64,208,128,162,0,82,160,
2,160,5,60,64,208,74,158,50,1,131,64,208,73,154,9,24,64,208,128,161,0,72,
152,8,64,208,128,154,0,64,146,64,208,128,148,0,72,161,12,64,208,64,152,
64,208,128,160,0,64,159,64,208,128,159,0,201,151,14,192,0,64,208,64,173,
64,208,128,159,0,73,146,41,61,64,208,137,151,5,20,0,73,146,9,12,64,208,
128,151,0,128,145,0,128,148,0,73,158,9,12,64,208,128,147,0,128,152,0,128,
162,0,200,145,9,0,64,208,128,161,0,64,144,64,208,64,147,64,208,128,161,
0,200,148,14,0,64,208,192,161,0,64,208,128,146,0,64,147,64,208,73,160,13,
48,64,208,64,173,64,208,128,161,0,72,156,8,64,208,128,144,0,64,154,64,208,
64,158,64,208,64,156,64,208,64,152,64,208,64,162,64,208,64,149,64,208,128,
162,0,64,161,64,208,72,165,16,64,208,64,149,64,208,64,156,64,208,128,144,
0,64,162,64,208,64,160,64,208,64,163,64,208,64,154,64,208,64,162,64,208,
64,163,64,208,64,160,64,208,128,144,0,73,155,9,97,64,208,128,161,0,72,154,
48,64,208,73,158,13,36,64,208,64,160,64,208,128,164,0,72,152,20,64,208,
72,161,8,64,208,128,173,0,64,156,64,208,128,148,0,128,148,0,64,161,64,208,
128,173,0,64,152,64,208,137,154,5,20,0,72,148,8,64,208,128,152,0,64,147,
64,208,128,163,0,200,162,9,0,64,208,128,157,0,64,161,64,208,128,161,0,72,
157,12,64,208,136,154,4,0,128,151,0,192,156,0,64,208,137,158,5,20,0,137,
151,5,12,0,64,149,64,208,128,151,0,128,156,0,136,163,4,0,64,159,64,208,
128,152,0,73,165,17,187,64,208,137,155,5,8,0,128,144,0,128,157,0,73,161,
45,84,64,208,73,159,9,20,64,208,128,157,0,136,152,4,0,64,146,64,208,128,
158,0,72,163,12,64,208,64,145,64,208,128,148,0,64,162,64,208,128,147,0,
72,160,20,64,208,72,157,12,64,208,64,173,64,208,128,158,0,128,145,0,64,
159,64,208,137,161,5,12,0,64,152,64,208,128,154,0,128,165,0,200,163,42,
0,64,208,137,159,5,29,0,72,152,12,64,208,136,152,4,0,128,145,0,192,148,
0,64,208,64,148,64,208,128,154,0,64,162,64,208,128,173,0,192,162,0,64,208,
137,163,5,28,0,73,159,13,16,64,208,136,166,4,0,128,159,0,128,145,0,64,160,
64,208,128,154,0,72,173,8,64,208,128,154,0,128,166,0,201,173,38,70,0,64,
208,137,160,5,16,0,137,154,5,8,0,128,152,0,128,156,0,137,163,5,12,0,64,
161,64,208,128,158,0,128,173,0,200,167,9,0,64,208,128,148,0,64,166,64,208,
73,152,9,12,64,208,128,162,0,128,145,0,64,161,64,208,128,152,0,200,175,
9,0,64,208,128,161,0,64,174,64,208,136,160,4,0,128,152,0,64,159,64,208,
74,156,34,1,12,64,208,73,159,9,24,64,208,128,154,0,72,156,12,64,208,64,
159,64,208,128,163,0,128,145,0,128,161,0,73,149,25,106,64,208,64,160,64,
208,64,145,64,208,64,155,64,208,64,158,64,208,128,154,0,73,146,25,49,64,
208,137,159,5,12,0,136,154,4,0,128,148,0,136,162,4,0,128,160,0,73,144,9,
17,64,208,128,145,0,192,134,0,64,208,128,146,0,64,145,64,208,128,163,0,
72,148,12,64,208,136,159,4,0,128,157,0,192,147,0,64,208,73,160,9,12,64,
208,128,162,0,128,154,0,128,161,0,73,152,58,91,64,208,73,161,9,28,64,208,
128,165,0,136,158,4,0,64,144,64,208,137,159,5,8,0,128,154,0,128,164,0,200,
164,21,0,64,208,137,158,5,8,0,128,144,0,64,161,64,208,128,152,0,128,163,
0,200,151,21,0,64,208,72,159,8,64,208,128,159,0,64,147,64,208,128,152,0,
192,150,0,64,208,136,162,4,0,128,160,0,72,155,21,64,208,200,156,9,0,64,
208,128,162,0,64,146,64,208,128,159,0,192,154,0,64,208,72,146,8,64,208,
128,154,0,128,145,0,202,163,23,1,57,0,64,208,136,162,4,0,64,149,64,208,
64,162,64,208,128,161,0,73,160,77,173,64,208,73,163,9,48,64,208,128,161,
0,137,156,5,20,0,73,149,9,12,64,208,128,165,0,128,148,0,128,151,0,72,162,
8,64,208,128,163,0,64,157,64,208,64,158,64,208,128,145,0,137,167,5,12,0,
136,166,4,0,128,164,0,72,173,8,64,208,128,165,0,128,168,0,201,158,31,52,
0,64,208,137,159,5,17,0,200,157,9,0,64,208,128,164,0,128,148,0,64,175,64,
208,128,151,0,192,157,0,64,208,137,148,5,8,0,128,145,0,192,160,0,64,208,
128,156,0,192,159,0,64,208,137,155,5,28,0,137,146,5,12,0,64,145,64,208,
128,144,0,64,147,64,208,64,144,64,208,128,162,0,137,164,5,8,0,128,160,0,
128,168,0,72,162,73,64,208,73,152,17,44,64,208,64,156,64,208,64,149,64,
208,128,148,0,137,148,5,20,0,64,145,64,208,64,144,64,208,64,157,64,208,
128,154,0,64,149,64,208,128,155,0,137,166,5,12,0,64,163,64,208,128,161,
0,192,173,0,64,208,64,154,64,208,128,161,0,192,161,0,64,208,137,161,5,20,
0,73,158,9,12,64,208,128,161,0,128,146,0,128,159,0,137,164,5,12,0,64,163,
64,208,128,160,0,64,173,64,208,128,154,0,73,166,17,46,64,208,136,159,4,
0,64,157,64,208,128,161,0,136,165,4,0,192,164,0,64,208,137,159,5,12,0,64,
156,64,208,128,154,0,192,160,0,64,208,128,164,0,200,173,26,0,64,208,137,
158,5,12,0,136,156,4,0,128,145,0,192,161,0,64,208,128,154,0,64,167,64,208,
136,163,4,0,128,158,0,192,161,0,64,208,74,158,79,1,222,64,208,73,159,9,
48,64,208,128,159,0,137,155,5,32,0,72,154,8,64,208,128,158,0,64,148,64,
208,136,163,4,0,64,156,64,208,64,152,64,208,128,155,0,64,158,64,208,128,
152,0,137,168,5,17,0,136,163,4,0,192,162,0,64,208,128,154,0,64,174,64,208,
128,161,0,201,151,22,224,0,64,208,73,154,9,12,64,208,128,158,0,128,151,
0,128,157,0,73,147,38,154,64,208,201,158,10,21,0,64,208,128,159,0,137,152,
5,8,0,128,144,0,128,157,0,136,163,4,0,64,159,64,208,128,158,0,201,145,46,
65,0,64,208,73,154,9,20,64,208,128,159,0,72,152,8,64,208,128,161,0,128,
148,0,72,163,16,64,208,64,156,64,208,64,156,64,208,128,156,0,128,161,0,
64,144,64,208,137,158,5,12,0,64,147,64,208,128,158,0,128,173,0,64,146,64,
208,137,154,5,32,0,73,146,9,16,64,208,128,159,0,64,144,64,208,128,160,0,
64,150,64,208,64,161,64,208,128,155,0,72,158,12,64,208,136,154,4,0,128,
148,0,128,155,0,72,150,12,64,208,136,157,4,0,128,148,0,64,148,64,208,201,
159,10,17,0,64,208,128,163,0,136,158,4,0,128,156,0,64,174,64,208,64,168,
64,208,64,158,64,208,128,160,0,73,155,9,73,64,208,128,157,0,200,154,45,
0,64,208,137,157,5,24,0,73,152,9,16,64,208,128,159,0,136,148,4,0,128,145,
0,128,154,0,137,161,5,8,0,128,159,0,64,168,64,208,128,163,0,64,152,64,208,
73,159,9,12,64,208,128,155,0,128,146,0,128,166,0,72,157,57,64,208,73,152,
9,36,64,208,128,148,0,73,145,9,24,64,208,128,158,0,64,144,64,208,137,146,
5,8,0,128,144,0,128,151,0,128,146,0,137,162,5,13,0,192,158,0,64,208,128,
161,0,128,165,0,192,156,0,64,208,73,157,9,29,64,208,128,163,0,73,150,9,
12,64,208,128,148,0,128,148,0,192,154,0,64,208,128,161,0,137,161,5,8,0,
128,159,0,128,167,0,74,165,14,1,35,64,208,64,158,64,208,128,162,0,201,162,
67,222,0,64,208,137,156,5,48,0,73,149,37,40,64,208,64,158,64,208,64,161,
64,208,64,144,64,208,64,160,64,208,64,154,64,208,64,158,64,208,64,156,64,
208,128,144,0,128,148,0,128,154,0,200,159,9,0,64,208,128,159,0,128,157,
0,73,160,25,82,64,208,137,148,5,12,0,136,146,4,0,128,144,0,136,166,4,0,
128,159,0,192,159,0,64,208,73,158,13,24,64,208,64,160,64,208,128,145,0,
137,148,5,8,0,128,147,0,128,154,0,201,161,14,21,0,64,208,64,152,64,208,
128,148,0,64,159,64,208,128,154,0,64,163,64,208,128,160,0,64,161,64,208,
73,156,13,40,64,208,136,159,4,0,128,152,0,73,152,9,24,64,208,128,157,0,
72,147,12,64,208,64,145,64,208,128,156,0,128,146,0,128,154,0,137,159,5,
26,0,200,158,9,0,64,208,128,162,0,192,157,0,64,208,64,144,64,208,128,144,
0,128,168,0,72,164,24,64,208,72,160,16,64,208,72,163,8,64,208,128,156,0,
128,161,0,128,159,0,64,163,64,208,73,158,9,16,64,208,128,157,0,136,157,
4,0,128,148,0,136,161,4,0,64,160,64,208,128,161,0,201,168,10,34,0,64,208,
128,160,0,200,167,13,0,64,208,136,157,4,0,128,148,0,64,166,64,208,64,159,
64,208,128,146,0,72,174,12,64,208,136,162,4,0,128,157,0,64,173,64,208,137,
156,5,20,0,137,151,5,8,0,128,150,0,64,154,64,208,128,158,0,136,160,4,0,
192,159,0,64,208,64,161,64,208,64,158,64,208,128,157,0,82,164,1,76,2,35,
64,208,73,156,21,154,64,208,137,161,5,8,0,128,157,0,64,164,64,208,128,144,
0,73,149,9,69,64,208,128,154,0,73,146,9,32,64,208,128,173,0,72,145,16,64,
208,137,163,5,8,0,128,154,0,128,167,0,64,144,64,208,128,159,0,200,148,25,
0,64,208,137,148,5,12,0,64,146,64,208,128,134,0,64,161,64,208,128,152,0,
128,147,0,137,154,5,57,0,72,152,36,64,208,73,161,9,24,64,208,128,159,0,
72,159,8,64,208,128,161,0,64,146,64,208,128,159,0,64,175,64,208,128,161,
0,192,151,0,64,208,136,162,4,0,64,159,64,208,128,148,0,64,155,64,208,128,
154,0,201,162,38,130,0,64,208,137,157,5,24,0,64,148,64,208,64,152,64,208,
64,163,64,208,64,148,64,208,128,161,0,64,159,64,208,128,173,0,73,160,9,
57,64,208,128,147,0,200,159,25,0,64,208,73,156,9,16,64,208,128,159,0,136,
155,4,0,128,154,0,128,161,0,64,158,64,208,73,156,9,12,64,208,128,161,0,
128,144,0,64,158,64,208,128,159,0,64,161,64,208,73,159,9,24,64,208,128,
157,0,72,158,8,64,208,128,158,0,64,155,64,208,128,144,0,64,161,64,208,128,
159,0,137,167,5,20,0,72,165,8,64,208,128,145,0,64,163,64,208,128,157,0,
64,173,64,208,72,160,8,64,208,128,159,0,192,154,0,64,208,128,162,0,192,
163,0,64,208,73,159,13,126,64,208,64,148,64,208,128,161,0,201,152,18,53,
0,64,208,136,161,4,0,64,146,64,208,128,159,0,73,148,17,32,64,208,136,165,
4,0,64,158,64,208,128,148,0,136,145,4,0,64,144,64,208,136,154,4,0,128,145,
0,128,151,0,201,157,18,53,0,64,208,72,161,8,64,208,128,148,0,128,145,0,
64,156,64,208,73,162,17,28,64,208,64,152,64,208,64,146,64,208,128,161,0,
136,160,4,0,64,146,64,208,128,159,0,128,166,0,64,158,64,208,128,159,0,73,
163,13,57,64,208,136,157,4,0,128,156,0,73,161,17,29,64,208,136,166,4,0,
64,151,64,208,128,157,0,192,160,0,64,208,64,150,64,208,128,159,0,64,162,
64,208,137,151,5,8,0,128,145,0,128,159,0,73,165,13,24,64,208,136,158,4,
0,128,148,0,64,164,64,208,64,156,64,208,128,161,0,128,166,0,64,165,64,208,
201,156,50,78,0,64,208,137,154,5,40,0,136,151,4,0,64,144,64,208,72,162,
16,64,208,64,148,64,208,64,149,64,208,128,162,0,64,148,64,208,64,149,64,
208,128,162,0,128,162,0,73,152,9,21,64,208,128,162,0,200,146,9,0,64,208,
128,163,0,128,145,0,64,154,64,208,128,164,0,201,162,22,85,0,64,208,73,158,
9,12,64,208,128,161,0,128,151,0,128,161,0,72,159,8,64,208,128,154,0,64,
158,64,208,64,162,64,208,72,156,28,64,208,64,152,64,208,64,157,64,208,64,
152,64,208,64,156,64,208,64,163,64,208,128,156,0,64,145,64,208,64,152,64,
208,64,155,64,208,64,149,64,208,128,162,0,128,173,0,74,173,231,1,166,64,
208,73,157,9,120,64,208,128,162,0,201,151,26,59,0,64,208,137,159,5,12,0,
64,152,64,208,128,161,0,64,160,64,208,128,163,0,201,146,15,26,0,64,208,
192,160,0,64,208,128,151,0,64,145,64,208,64,166,64,208,128,163,0,64,147,
64,208,128,154,0,73,155,13,25,64,208,64,152,64,208,128,148,0,192,154,0,
64,208,136,162,4,0,128,160,0,64,156,64,208,73,156,13,16,64,208,64,159,64,
208,128,163,0,128,154,0,64,159,64,208,128,151,0,201,162,10,77,0,64,208,
128,159,0,73,160,13,52,64,208,136,161,4,0,128,157,0,64,159,64,208,73,160,
13,32,64,208,64,157,64,208,128,154,0,72,152,8,64,208,128,161,0,64,146,64,
208,64,144,64,208,128,175,0,128,164,0,64,161,64,208,137,160,5,8,0,128,157,
0,128,162,0,137,165,5,24,0,64,164,64,208,64,159,64,208,136,157,4,0,64,152,
64,208,128,158,0,128,173,0,73,168,61,156,64,208,137,151,5,36,0,73,146,13,
24,64,208,64,161,64,208,128,156,0,136,145,4,0,64,144,64,208,128,159,0,64,
147,64,208,128,163,0,73,159,9,12,64,208,128,163,0,128,156,0,64,161,64,208,
128,145,0,64,167,64,208,73,157,9,56,64,208,128,156,0,73,148,9,28,64,208,
128,159,0,72,146,12,64,208,136,160,4,0,128,159,0,64,145,64,208,128,160,
0,72,156,12,64,208,136,162,4,0,128,161,0,64,149,64,208,128,161,0,137,162,
5,24,0,72,161,12,64,208,64,146,64,208,128,173,0,64,160,64,208,128,157,0,
72,173,8,64,208,128,161,0,128,166,0,64,169,64,208,137,164,5,28,0,64,144,
64,208,64,148,64,208,64,145,64,208,64,144,64,208,64,157,64,208,128,154,
0,128,167,0,72,175,41,64,208,73,161,9,24,64,208,128,156,0,136,159,4,0,64,
145,64,208,64,152,64,208,128,157,0,136,164,4,0,192,162,0,64,208,128,166,
0,64,174,64,208,137,152,5,12,0,136,151,4,0,128,145,0,64,168,64,208,64,156,
64,208,64,152,64,208,64,157,64,208,64,144,64,208,64,155,64,208,64,172,64,
208,128,148,0,82,150,4,221,212,145,80,208,4,208,74,156,69,2,121,64,208,
201,159,10,43,0,64,208,128,163,0,137,151,5,16,0,136,148,4,0,64,146,64,208,
128,148,0,200,157,9,0,64,208,128,159,0,192,154,0,64,208,128,158,0,73,173,
9,16,64,208,128,152,0,136,162,4,0,128,161,0,128,174,0,74,149,10,1,31,64,
208,128,155,0,73,146,45,163,64,208,137,158,5,24,0,72,157,12,64,208,64,155,
64,208,128,161,0,64,155,64,208,128,161,0,72,165,8,64,208,128,158,0,64,160,
64,208,128,148,0,73,144,53,60,64,208,73,161,9,32,64,208,128,158,0,73,152,
13,16,64,208,136,161,4,0,128,154,0,128,148,0,64,154,64,208,128,162,0,137,
163,5,12,0,64,162,64,208,128,161,0,128,164,0,64,129,64,208,128,155,0,192,
145,0,64,208,201,158,10,38,0,64,208,128,162,0,201,152,14,21,0,64,208,64,
152,64,208,128,154,0,136,149,4,0,128,148,0,136,155,4,0,128,154,0,137,162,
5,12,0,136,160,4,0,128,159,0,128,164,0,200,148,34,0,64,208,137,161,5,16,
0,72,159,8,64,208,128,154,0,128,144,0,136,175,4,0,192,162,0,64,208,128,
163,0,64,147,64,208,201,159,10,45,0,64,208,128,151,0,73,154,9,20,64,208,
128,155,0,72,152,8,64,208,128,151,0,128,146,0,72,158,8,64,208,128,154,0,
64,156,64,208,128,154,0,73,165,9,28,64,208,128,154,0,72,163,12,64,208,64,
152,64,208,128,164,0,64,162,64,208,128,163,0,128,173,0,73,152,97,161,64,
208,64,155,64,208,73,156,29,64,64,208,64,144,64,208,64,161,64,208,64,161,
64,208,64,152,64,208,64,146,64,208,128,171,0,64,152,64,208,64,157,64,208,
64,161,64,208,64,159,64,208,64,149,64,208,64,154,64,208,64,166,64,208,64,
152,64,208,128,175,0,64,164,64,208,64,152,64,208,64,157,64,208,64,144,64,
208,64,157,64,208,128,161,0,72,151,32,64,208,73,159,9,16,64,208,128,156,
0,136,155,4,0,128,154,0,72,162,8,64,208,128,156,0,128,160,0,192,150,0,64,
208,72,174,8,64,208,128,154,0,64,163,64,208,64,160,64,208,64,157,64,208,
64,144,64,208,128,155,0,72,155,16,64,208,136,164,4,0,64,146,64,208,128,
151,0,192,154,0,64,208,73,154,13,49,64,208,64,145,64,208,128,159,0,137,
148,5,25,0,201,146,10,13,0,64,208,128,148,0,128,145,0,64,147,64,208,128,
173,0,136,152,4,0,64,151,64,208,128,158,0,137,163,5,26,0,201,160,10,13,
0,64,208,128,164,0,128,155,0,192,162,0,64,208,128,156,0,136,166,4,0,192,
165,0,64,208,64,152,64,208,136,162,4,0,128,145,0,74,163,39,1,176,64,208,
73,160,17,24,64,208,64,147,64,208,64,144,64,208,128,151,0,64,150,64,208,
128,163,0,192,161,0,64,208,128,161,0,74,160,120,1,32,64,208,201,161,10,
58,0,64,208,128,163,0,137,154,5,37,0,201,148,14,21,0,64,208,64,156,64,208,
128,162,0,64,144,64,208,128,158,0,64,151,64,208,64,159,64,208,128,151,0,
136,158,4,0,64,156,64,208,128,158,0,73,165,9,28,64,208,128,158,0,72,164,
16,64,208,72,165,8,64,208,128,158,0,128,156,0,128,162,0,72,173,24,64,208,
137,159,5,12,0,136,158,4,0,128,154,0,136,163,4,0,128,162,0,128,166,0,73,
158,57,116,64,208,137,163,5,28,0,73,158,9,16,64,208,128,161,0,64,147,64,
208,128,162,0,64,160,64,208,128,165,0,72,166,20,64,208,64,158,64,208,64,
151,64,208,64,156,64,208,128,160,0,128,165,0,64,157,64,208,73,158,9,44,
64,208,128,147,0,137,154,5,28,0,72,146,16,64,208,64,155,64,208,136,161,
4,0,128,159,0,64,144,64,208,128,163,0,64,155,64,208,128,161,0,137,164,5,
8,0,128,162,0,128,165,0,64,159,64,208,201,159,10,33,0,64,208,128,147,0,
73,157,9,20,64,208,128,157,0,136,155,4,0,64,151,64,208,128,155,0,128,158,
0,137,165,5,8,0,128,160,0,64,173,64,208,128,162,0,72,162,33,64,208,137,
164,5,21,0,192,154,0,64,208,64,156,64,208,64,158,64,208,128,148,0,64,173,
64,208,128,154,0,64,161,64,208,73,159,9,29,64,208,128,154,0,137,145,5,8,
0,128,144,0,192,154,0,64,208,136,165,4,0,128,162,0,73,162,17,36,64,208,
136,155,4,0,64,152,64,208,128,151,0,64,161,64,208,137,154,5,8,0,128,144,
0,64,160,64,208,128,151,0,128,164,0,201,166,56,115,0,64,208,137,161,5,29,
0,137,158,5,16,0,136,152,4,0,64,145,64,208,128,154,0,192,159,0,64,208,128,
161,0,137,163,5,17,0,192,162,0,64,208,64,149,64,208,128,165,0,128,164,0,
72,165,28,64,208,137,159,5,20,0,136,158,4,0,64,146,64,208,136,160,4,0,128,
148,0,128,163,0,64,164,64,208,73,161,9,20,64,208,128,152,0,72,156,8,64,
208,128,151,0,128,154,0,136,173,4,0,128,165,0,136,175,4,0,64,173,64,208,
201,162,10,25,0,64,208,128,164,0,137,160,5,12,0,136,158,4,0,128,154,0,128,
161,0,137,165,5,12,0,64,163,64,208,128,154,0,128,166,0,64,90,64,208,128,
155,0,82,146,44,78,115,229,80,208,44,65,82,159,1,100,31,140,64,208,201,
159,18,214,0,64,208,136,157,4,0,64,156,64,208,128,158,0,73,151,9,75,64,
208,128,160,0,201,147,14,50,0,64,208,136,161,4,0,128,159,0,73,145,17,29,
64,208,137,161,5,8,0,128,151,0,128,167,0,64,144,64,208,192,160,0,64,208,
128,162,0,64,146,64,208,128,161,0,72,150,8,64,208,128,162,0,192,148,0,64,
208,128,160,0,73,156,29,89,64,208,137,158,5,16,0,137,148,5,8,0,128,146,
0,128,151,0,136,166,4,0,128,162,0,200,154,53,0,64,208,73,158,9,36,64,208,
128,161,0,64,152,64,208,64,155,64,208,64,149,64,208,64,161,64,208,64,156,
64,208,64,144,64,208,128,168,0,64,162,64,208,64,152,64,208,128,156,0,64,
152,64,208,128,147,0,200,158,9,0,64,208,128,160,0,64,157,64,208,137,151,
5,8,0,128,148,0,64,160,64,208,136,156,4,0,128,154,0,201,165,10,103,0,64,
208,128,160,0,73,162,46,81,64,208,201,152,30,37,0,64,208,64,162,64,208,
64,175,64,208,64,150,64,208,64,156,64,208,64,144,64,208,128,168,0,136,147,
4,0,128,145,0,128,161,0,136,161,4,0,64,160,64,208,72,161,12,64,208,64,165,
64,208,128,144,0,64,158,64,208,64,161,64,208,64,144,64,208,128,154,0,136,
164,4,0,192,163,0,64,208,128,151,0,73,173,9,16,64,208,128,161,0,136,168,
4,0,128,167,0,72,175,8,64,208,128,156,0,64,174,64,208,128,147,0,74,150,
55,12,93,64,208,73,155,9,29,64,208,128,164,0,73,146,9,12,64,208,128,160,
0,128,145,0,192,154,0,64,208,128,154,0,137,158,5,16,0,64,157,64,208,64,
148,64,208,128,158,0,128,165,0,210,146,2,87,5,211,0,64,208,74,158,30,1,
173,64,208,73,160,17,20,64,208,64,166,64,208,64,144,64,208,128,156,0,128,
158,0,128,163,0,201,148,14,180,0,64,208,64,154,64,208,128,163,0,73,145,
13,107,64,208,64,146,64,208,128,163,0,72,144,87,64,208,137,159,5,45,0,73,
152,22,29,64,208,200,163,13,0,64,208,64,160,64,208,128,173,0,128,152,0,
64,147,64,208,128,161,0,64,154,64,208,64,152,64,208,128,163,0,73,162,9,
12,64,208,128,163,0,128,161,0,192,163,0,64,208,73,160,9,17,64,208,128,173,
0,192,155,0,64,208,128,168,0,128,168,0,64,134,64,208,128,160,0,72,147,8,
64,208,128,154,0,64,146,64,208,73,161,13,32,64,208,64,154,64,208,128,163,
0,64,144,64,208,72,163,8,64,208,128,168,0,64,152,64,208,128,163,0,64,163,
64,208,136,162,4,0,64,152,64,208,128,158,0,201,155,14,111,0,64,208,136,
161,4,0,128,144,0,200,154,26,0,64,208,137,158,5,12,0,64,152,64,208,128,
163,0,192,163,0,64,208,128,161,0,64,152,64,208,73,156,9,36,64,208,128,163,
0,73,154,9,16,64,208,128,163,0,136,147,4,0,128,144,0,64,155,64,208,64,173,
64,208,128,156,0,73,163,9,28,64,208,128,161,0,72,161,8,64,208,128,163,0,
64,158,64,208,64,146,64,208,128,160,0,128,168,0,72,157,12,64,208,136,160,
4,0,128,145,0,64,156,64,208,73,152,21,48,64,208,136,163,4,0,64,160,64,208,
64,162,64,208,128,163,0,73,147,9,16,64,208,128,163,0,64,146,64,208,128,
148,0,64,148,64,208,64,161,64,208,128,158,0,137,160,5,12,0,64,159,64,208,
128,163,0,192,163,0,64,208,73,159,9,20,64,208,128,159,0,72,152,8,64,208,
128,158,0,128,151,0,64,160,64,208,128,173,0,201,164,18,120,0,64,208,136,
163,4,0,64,161,64,208,128,163,0,201,161,18,58,0,64,208,137,161,5,8,0,128,
154,0,128,162,0,72,160,24,64,208,137,161,5,12,0,136,151,4,0,128,148,0,64,
166,64,208,128,155,0,192,159,0,64,208,136,167,4,0,64,159,64,208,128,154,
0,72,163,32,64,208,73,160,9,20,64,208,128,173,0,72,152,8,64,208,128,158,
0,128,151,0,136,162,4,0,128,161,0,192,162,0,64,208,136,163,4,0,128,161,
0,73,168,9,25,64,208,128,159,0,200,166,13,0,64,208,136,163,4,0,128,161,
0,128,165,0,64,173,64,208,136,160,4,0,192,159,0,64,208,128,160,0,82,144,
2,144,2,220,64,208,74,157,22,1,24,64,208,72,154,8,64,208,128,145,0,64,152,
64,208,128,154,0,73,149,9,140,64,208,128,161,0,73,146,29,72,64,208,137,
161,5,20,0,72,160,8,64,208,128,159,0,64,154,64,208,128,158,0,128,162,0,
73,144,21,28,64,208,137,159,5,12,0,64,152,64,208,128,148,0,128,164,0,64,
134,64,208,128,162,0,64,145,64,208,137,154,5,8,0,128,149,0,128,161,0,72,
148,24,64,208,73,156,13,16,64,208,64,152,64,208,128,165,0,128,144,0,128,
161,0,64,147,64,208,137,161,5,24,0,137,152,5,16,0,64,147,64,208,64,147,
64,208,128,161,0,128,159,0,136,168,4,0,128,162,0,201,154,39,71,0,64,208,
137,155,5,21,0,201,151,10,13,0,64,208,128,158,0,128,148,0,128,154,0,136,
160,4,0,64,159,64,208,128,154,0,72,152,29,64,208,73,160,9,21,64,208,128,
159,0,136,159,4,0,192,152,0,64,208,128,148,0,128,163,0,128,151,0,72,156,
24,64,208,137,156,5,16,0,72,150,8,64,208,128,165,0,128,148,0,128,163,0,
64,155,64,208,73,158,13,16,64,208,64,146,64,208,128,161,0,128,151,0,128,
162,0,74,163,10,1,43,64,208,128,155,0,73,160,97,214,64,208,73,155,9,72,
64,208,128,152,0,73,152,45,60,64,208,64,158,64,208,64,158,64,208,64,145,
64,208,64,170,64,208,64,149,64,208,64,154,64,208,64,162,64,208,64,152,64,
208,64,146,64,208,128,171,0,72,146,12,64,208,64,161,64,208,128,157,0,128,
145,0,128,154,0,73,165,13,16,64,208,64,145,64,208,128,151,0,128,159,0,128,
166,0,72,159,89,64,208,137,158,5,36,0,137,154,5,16,0,64,152,64,208,64,167,
64,208,128,159,0,64,155,64,208,64,152,64,208,64,162,64,208,128,149,0,73,
160,29,37,64,208,73,173,9,16,64,208,128,165,0,64,149,64,208,128,165,0,64,
175,64,208,128,155,0,192,159,0,64,208,128,157,0,64,163,64,208,64,160,64,
208,128,157,0,192,158,0,64,208,72,158,20,64,208,64,157,64,208,64,146,64,
208,136,162,4,0,128,161,0,128,157,0,72,162,36,64,208,137,157,5,20,0,136,
152,4,0,64,144,64,208,64,147,64,208,128,144,0,64,163,64,208,64,147,64,208,
128,144,0,64,161,64,208,73,159,13,28,64,208,136,173,4,0,128,158,0,73,155,
9,12,64,208,128,174,0,128,151,0,128,158,0,136,163,4,0,128,162,0,73,168,
29,53,64,208,137,155,5,12,0,64,147,64,208,128,148,0,64,159,64,208,64,158,
64,208,128,155,0,72,167,8,64,208,128,152,0,192,165,0,64,208,136,151,4,0,
64,145,64,208,128,158,0,136,174,4,0,192,173,0,64,208,64,164,64,208,128,
159,0,64,134,64,208,137,155,5,41,0,73,149,9,25,64,208,128,156,0,192,144,
0,64,208,64,162,64,208,64,161,64,208,128,158,0,64,154,64,208,64,157,64,
208,128,163,0,137,161,5,20,0,64,157,64,208,64,134,64,208,64,162,64,208,
128,134,0,64,162,64,208,136,157,4,0,128,134,0,192,145,0,64,208,137,157,
5,89,0,137,152,5,49,0,73,146,25,32,64,208,73,157,9,16,64,208,128,154,0,
64,156,64,208,128,162,0,128,159,0,136,145,4,0,128,144,0,192,148,0,64,208,
64,159,64,208,128,159,0,73,155,9,24,64,208,128,154,0,64,154,64,208,137,
152,5,8,0,128,146,0,128,159,0,64,156,64,208,136,159,4,0,128,154,0,73,165,
9,42,64,208,128,168,0,73,162,13,21,64,208,64,160,64,208,128,164,0,192,160,
0,64,208,128,160,0,192,163,0,64,208,64,147,64,208,128,157,0,201,168,14,
17,0,64,208,64,154,64,208,128,144,0,128,166,0,64,173,64,208,128,160,0,82,
148,1,39,3,56,64,208,73,156,9,107,64,208,128,161,0,137,149,5,75,0,201,146,
26,41,0,64,208,73,158,13,16,64,208,64,149,64,208,128,156,0,128,152,0,128,
161,0,72,145,8,64,208,128,160,0,64,144,64,208,128,163,0,200,148,13,0,64,
208,64,155,64,208,128,150,0,192,147,0,64,208,137,154,5,8,0,128,145,0,128,
158,0,137,152,5,16,0,136,151,4,0,64,150,64,208,128,159,0,64,154,64,208,
128,157,0,201,162,18,140,0,64,208,137,145,5,8,0,128,144,0,128,163,0,73,
159,38,77,64,208,201,159,14,21,0,64,208,64,159,64,208,128,159,0,136,158,
4,0,128,145,0,136,167,4,0,64,164,64,208,128,145,0,72,158,28,64,208,137,
147,5,20,0,72,145,8,64,208,128,162,0,64,144,64,208,128,156,0,128,161,0,
64,157,64,208,136,165,4,0,128,147,0,200,161,30,0,64,208,137,159,5,12,0,
136,158,4,0,128,154,0,136,163,4,0,192,160,0,64,208,128,157,0,64,160,64,
208,136,165,4,0,64,144,64,208,128,158,0,73,167,9,37,64,208,128,160,0,72,
166,12,64,208,136,159,4,0,128,145,0,64,164,64,208,64,161,64,208,192,158,
0,64,208,128,159,0,128,173,0,64,147,80,208,2,12,74,156,51,1,37,64,208,137,
161,5,25,0,201,152,10,13,0,64,208,128,154,0,128,144,0,64,158,64,208,128,
158,0,73,164,9,12,64,208,128,154,0,128,163,0,64,165,64,208,128,144,0,201,
148,10,105,0,64,208,128,151,0,73,145,21,80,64,208,137,154,5,12,0,64,152,
64,208,128,155,0,128,163,0,72,144,44,64,208,73,161,13,28,64,208,136,163,
4,0,128,144,0,136,152,4,0,64,146,64,208,136,162,4,0,128,156,0,72,164,8,
64,208,128,154,0,128,163,0,64,134,64,208,64,160,64,208,64,164,64,208,128,
158,0,72,147,8,64,208,128,163,0,64,146,64,208,128,156,0,73,154,41,113,64,
208,137,161,5,24,0,137,157,5,16,0,136,154,4,0,64,144,64,208,128,151,0,128,
158,0,137,165,5,8,0,128,162,0,128,168,0,72,152,61,64,208,73,159,21,41,64,
208,137,154,5,12,0,136,152,4,0,128,144,0,128,163,0,136,154,4,0,192,152,
0,64,208,136,154,4,0,64,152,64,208,128,154,0,72,164,8,64,208,128,154,0,
64,161,64,208,128,154,0,64,149,64,208,64,156,64,208,128,155,0,192,155,0,
64,208,73,162,9,16,64,208,128,144,0,136,154,4,0,128,144,0,128,163,0,73,
162,29,167,64,208,137,154,5,12,0,136,148,4,0,128,144,0,136,163,4,0,64,160,
64,208,128,154,0,201,159,68,103,0,64,208,73,159,9,32,64,208,128,154,0,73,
146,9,16,64,208,128,161,0,64,145,64,208,128,151,0,64,147,64,208,128,154,
0,200,163,17,0,64,208,64,152,64,208,64,156,64,208,128,154,0,192,162,0,64,
208,136,154,4,0,128,152,0,72,158,12,64,208,136,158,4,0,128,154,0,64,157,
64,208,73,152,13,16,64,208,64,152,64,208,128,150,0,128,144,0,128,166,0,
72,161,28,64,208,137,159,5,16,0,137,154,5,8,0,128,146,0,128,158,0,136,167,
4,0,128,163,0,64,160,64,208,128,161,0,137,166,5,41,0,136,165,4,0,192,163,
0,64,208,72,173,16,64,208,136,161,4,0,64,152,64,208,128,161,0,64,152,64,
208,64,155,64,208,128,163,0,64,173,64,208,137,161,5,8,0,128,154,0,64,162,
64,208,128,154,0,128,71,0,64,149,64,208,202,158,15,1,26,0,64,208,64,159,
64,208,128,163,0,73,149,9,68,64,208,128,161,0,73,147,13,48,64,208,136,154,
4,0,128,152,0,64,145,64,208,72,160,8,64,208,128,160,0,64,156,64,208,64,
144,64,208,64,161,64,208,64,162,64,208,64,149,64,208,128,160,0,64,148,64,
208,136,166,4,0,128,154,0,73,154,41,48,64,208,72,166,8,64,208,128,144,0,
64,158,64,208,136,157,4,0,64,156,64,208,64,145,64,208,64,144,64,208,64,
157,64,208,128,154,0,64,152,64,208,128,159,0,64,157,64,208,72,162,136,64,
208,73,161,29,92,64,208,64,152,64,208,64,161,64,208,64,162,64,208,64,149,
64,208,64,156,64,208,128,144,0,72,154,48,64,208,72,158,20,64,208,64,160,
64,208,64,158,64,208,64,145,64,208,128,144,0,64,144,64,208,64,157,64,208,
64,144,64,208,64,155,64,208,64,158,64,208,128,146,0,64,145,64,208,64,155,
64,208,64,158,64,208,128,154,0,72,168,20,64,208,64,144,64,208,64,165,64,
208,64,162,64,208,128,171,0,64,164,64,208,64,144,64,208,64,161,64,208,64,
144,64,208,128,148,0,64,161,64,208,64,152,64,208,128,161,0,74,164,18,1,
218,64,208,137,154,5,8,0,128,144,0,128,157,0,73,161,9,92,64,208,128,154,
0,64,160,64,208,64,165,64,208,64,157,64,208,64,149,64,208,64,146,64,208,
64,158,64,208,64,155,64,208,64,150,64,208,64,161,64,208,64,154,64,208,64,
157,64,208,64,149,64,208,64,164,64,208,64,162,64,208,64,149,64,208,64,159,
64,208,64,160,64,208,64,158,64,208,64,146,64,208,64,158,64,208,128,148,
0,64,162,64,208,73,155,77,185,64,208,72,149,32,64,208,64,167,64,208,64,
149,64,208,64,145,64,208,64,157,64,208,64,152,64,208,64,166,64,208,128,
144,0,64,144,64,208,64,145,64,208,64,158,64,208,64,160,64,208,64,144,64,
208,64,162,64,208,64,158,64,208,64,160,64,208,64,152,64,208,128,175,0,73,
151,41,81,64,208,64,146,64,208,64,149,64,208,64,160,64,208,64,158,64,208,
64,166,64,208,64,149,64,208,64,157,64,208,64,162,64,208,128,160,0,72,146,
16,64,208,64,160,64,208,64,144,64,208,128,167,0,192,144,0,64,208,64,159,
64,208,64,162,64,208,64,149,64,208,64,154,64,208,128,144,0,64,154,64,208,
64,155,64,208,64,152,64,208,64,157,64,208,64,152,64,208,64,154,64,208,128,
144,0,73,161,73,152,64,208,72,155,20,64,208,64,163,64,208,64,150,64,208,
64,145,64,208,128,171,0,64,144,64,208,64,157,64,208,64,173,64,208,64,154,
64,208,64,161,64,208,64,159,64,208,64,149,64,208,64,160,64,208,64,162,64,
208,64,152,64,208,64,151,64,208,128,144,0,72,159,56,64,208,72,160,32,64,
208,64,149,64,208,64,159,64,208,64,144,64,208,64,160,64,208,64,144,64,208,
64,162,64,208,128,171,0,64,158,64,208,64,156,64,208,64,158,64,208,64,169,
64,208,128,172,0,64,157,64,208,64,144,64,208,64,148,64,208,64,151,64,208,
64,158,64,208,128,160,0,64,163,64,208,64,161,64,208,64,155,64,208,64,163,
64,208,64,147,64,208,128,152,0,73,166,13,20,64,208,64,159,64,208,128,152,
0,64,165,64,208,128,155,0,64,169,64,208,64,148,64,208,64,158,64,208,128,
154,0,82,155,1,3,7,164,64,208,137,156,5,164,0,73,147,21,116,64,208,73,162,
9,12,64,208,128,163,0,128,148,0,128,163,0,73,144,81,88,64,208,64,148,64,
208,72,152,56,64,208,64,156,64,208,64,152,64,208,64,160,64,208,64,173,64,
208,64,157,64,208,64,149,64,208,64,160,64,208,64,147,64,208,64,158,64,208,
64,161,64,208,64,145,64,208,64,171,64,208,128,162,0,64,144,64,208,64,146,
64,208,64,152,64,208,128,144,0,64,134,64,208,128,161,0,64,146,64,208,128,
161,0,73,151,17,24,64,208,72,159,8,64,208,128,159,0,128,157,0,64,148,64,
208,128,164,0,64,154,64,208,72,161,8,64,208,128,156,0,64,160,64,208,128,
161,0,73,162,13,58,64,208,136,168,4,0,128,152,0,73,160,9,37,64,208,128,
159,0,64,159,64,208,201,163,14,21,0,64,208,64,156,64,208,128,147,0,64,148,
64,208,128,161,0,128,168,0,192,161,0,64,208,128,163,0,73,165,9,12,64,208,
128,152,0,128,164,0,192,173,0,64,208,200,159,9,0,64,208,128,159,0,128,154,
0,82,152,2,193,4,137,80,208,2,184,74,157,30,1,92,64,208,73,152,13,20,64,
208,64,162,64,208,128,152,0,64,144,64,208,128,159,0,128,154,0,73,150,9,
142,64,208,128,148,0,73,147,21,98,64,208,136,154,4,0,64,152,64,208,64,163,
64,208,128,161,0,73,145,37,65,64,208,72,160,28,64,208,64,158,64,208,64,
158,64,208,64,159,64,208,64,158,64,208,64,160,64,208,128,171,0,128,152,
0,192,144,0,64,208,137,156,5,16,0,64,154,64,208,64,158,64,208,128,156,0,
64,159,64,208,128,152,0,192,146,0,64,208,136,162,4,0,128,155,0,72,149,8,
64,208,128,162,0,64,148,64,208,64,149,64,208,64,158,64,208,64,163,64,208,
64,160,64,208,64,158,64,208,128,154,0,73,154,49,105,64,208,73,158,21,36,
64,208,64,157,64,208,64,160,64,208,64,158,64,208,128,145,0,72,157,8,64,
208,128,163,0,64,152,64,208,128,151,0,64,165,64,208,128,154,0,72,152,37,
64,208,137,166,5,20,0,72,160,8,64,208,128,173,0,64,147,64,208,128,165,0,
192,175,0,64,208,64,154,64,208,128,144,0,64,151,64,208,72,160,8,64,208,
128,163,0,64,144,64,208,128,161,0,72,156,40,64,208,137,162,5,32,0,136,158,
4,0,64,144,64,208,64,152,64,208,64,146,64,208,64,152,64,208,64,146,64,208,
128,161,0,128,173,0,64,155,64,208,137,160,5,24,0,72,152,12,64,208,64,158,
64,208,128,160,0,64,149,64,208,128,157,0,128,161,0,201,163,14,228,0,64,
208,136,160,4,0,128,145,0,73,160,50,159,64,208,73,165,13,28,64,208,64,145,
64,208,128,151,0,72,159,12,64,208,64,152,64,208,128,155,0,128,158,0,200,
173,13,0,64,208,64,152,64,208,128,163,0,128,166,0,72,159,93,64,208,137,
161,5,60,0,73,158,13,48,64,208,64,157,64,208,128,148,0,72,154,20,64,208,
72,160,8,64,208,128,158,0,64,158,64,208,128,156,0,64,145,64,208,64,152,
64,208,64,157,64,208,128,154,0,64,159,64,208,128,154,0,73,164,17,25,64,
208,64,149,64,208,64,161,64,208,128,162,0,192,162,0,64,208,128,168,0,128,
173,0,192,158,0,64,208,136,160,4,0,64,156,64,208,128,161,0,72,162,12,64,
208,136,163,4,0,128,161,0,64,161,64,208,73,157,9,24,64,208,128,165,0,73,
155,9,12,64,208,128,161,0,128,145,0,128,156,0,136,163,4,0,64,162,64,208,
64,149,64,208,128,165,0,137,167,5,20,0,136,166,4,0,64,164,64,208,136,161,
4,0,128,154,0,72,174,8,64,208,128,157,0,192,173,0,64,208,137,157,5,44,0,
73,152,13,32,64,208,136,159,4,0,128,156,0,72,147,16,64,208,64,157,64,208,
64,163,64,208,128,159,0,128,146,0,64,156,64,208,128,161,0,73,163,9,36,64,
208,128,159,0,72,161,12,64,208,136,163,4,0,128,159,0,64,159,64,208,136,
159,4,0,64,152,64,208,128,159,0,128,164,0,128,68,0,64,151,64,208,73,157,
29,228,64,208,137,161,5,16,0,64,154,64,208,64,152,64,208,128,164,0,64,163,
64,208,128,152,0,73,150,21,65,64,208,72,159,8,64,208,128,158,0,64,145,64,
208,128,152,0,73,146,13,28,64,208,136,162,4,0,128,144,0,72,145,8,64,208,
128,162,0,64,144,64,208,128,161,0,200,148,9,0,64,208,128,159,0,64,147,64,
208,128,144,0,73,154,29,91,64,208,137,158,5,16,0,72,155,8,64,208,128,161,
0,128,147,0,64,161,64,208,128,156,0,72,152,51,64,208,73,159,9,21,64,208,
128,159,0,136,158,4,0,192,152,0,64,208,128,162,0,200,162,13,0,64,208,64,
155,64,208,128,159,0,192,161,0,64,208,136,162,4,0,128,152,0,64,151,64,208,
136,145,4,0,128,144,0,72,156,32,64,208,137,162,5,16,0,137,154,5,8,0,128,
152,0,128,159,0,72,173,8,64,208,128,158,0,128,168,0,64,155,64,208,64,162,
64,208,128,152,0,201,163,14,139,0,64,208,64,154,64,208,128,162,0,73,160,
30,65,64,208,201,162,10,21,0,64,208,128,144,0,136,159,4,0,64,154,64,208,
128,163,0,128,163,0,72,159,16,64,208,137,158,5,8,0,128,152,0,128,159,0,
64,158,64,208,73,156,9,12,64,208,128,162,0,128,152,0,128,162,0,72,162,49,
64,208,137,154,5,32,0,73,148,17,20,64,208,136,157,4,0,64,152,64,208,128,
157,0,128,144,0,64,150,64,208,128,162,0,136,163,4,0,192,156,0,64,208,128,
148,0,64,161,64,208,64,144,64,208,128,154,0,73,169,9,40,64,208,128,144,
0,72,168,12,64,208,64,152,64,208,128,162,0,64,164,64,208,137,162,5,8,0,
128,152,0,64,173,64,208,128,152,0,192,173,0,64,208,137,159,5,25,0,137,154,
5,13,0,192,152,0,64,208,128,161,0,64,156,64,208,128,162,0,137,162,5,12,
0,64,161,64,208,128,158,0,128,164,0,64,154,64,208,74,157,46,1,36,64,208,
137,156,5,28,0,137,147,5,8,0,128,146,0,64,152,64,208,64,152,64,208,64,155,
64,208,128,159,0,137,161,5,8,0,128,158,0,128,173,0,73,148,9,125,64,208,
128,159,0,73,146,37,73,64,208,137,161,5,20,0,73,158,9,12,64,208,128,161,
0,128,154,0,128,159,0,136,168,4,0,64,162,64,208,128,158,0,72,145,8,64,208,
128,161,0,64,144,64,208,137,159,5,21,0,192,145,0,64,208,64,144,64,208,64,
157,64,208,128,154,0,128,161,0,64,147,64,208,73,162,9,32,64,208,128,163,
0,137,157,5,8,0,128,149,0,64,159,64,208,136,151,4,0,64,145,64,208,128,151,
0,136,173,4,0,128,163,0,201,155,10,90,0,64,208,128,160,0,200,154,33,0,64,
208,137,151,5,16,0,137,145,5,8,0,128,144,0,128,148,0,137,161,5,8,0,128,
154,0,128,162,0,64,152,64,208,137,159,5,24,0,73,154,9,12,64,208,128,161,
0,128,150,0,64,156,64,208,128,158,0,73,173,13,16,64,208,136,165,4,0,128,
156,0,128,163,0,128,175,0,64,156,64,208,137,154,5,16,0,72,152,8,64,208,
128,154,0,128,148,0,72,161,8,64,208,128,148,0,128,156,0,73,162,21,187,64,
208,137,159,5,12,0,136,147,4,0,128,146,0,128,160,0,201,160,38,106,0,64,
208,73,160,13,24,64,208,64,147,64,208,128,145,0,137,152,5,8,0,128,149,0,
128,156,0,136,173,4,0,128,163,0,72,159,28,64,208,137,156,5,12,0,136,147,
4,0,128,145,0,72,160,8,64,208,128,159,0,128,158,0,192,158,0,64,208,72,168,
8,64,208,128,159,0,64,155,64,208,64,147,64,208,64,158,64,208,64,162,64,
208,64,154,64,208,64,144,64,208,128,165,0,64,161,64,208,73,159,9,36,64,
208,128,157,0,137,156,5,16,0,136,154,4,0,64,152,64,208,128,160,0,64,158,
64,208,64,160,64,208,128,161,0,137,162,5,17,0,192,160,0,64,208,136,161,
4,0,128,151,0,128,173,0,137,169,5,21,0,72,166,8,64,208,128,154,0,192,165,
0,64,208,128,159,0,192,173,0,64,208,73,159,9,24,64,208,128,146,0,72,156,
8,64,208,128,159,0,64,152,64,208,128,144,0,128,162,0,82,157,4,175,6,103,
64,208,202,158,23,4,44,0,64,208,137,162,5,12,0,136,161,4,0,128,154,0,128,
163,0,137,151,5,61,0,73,147,21,49,64,208,72,154,8,64,208,128,156,0,64,148,
64,208,128,163,0,200,146,9,0,64,208,128,152,0,64,144,64,208,73,152,9,12,
64,208,128,151,0,128,146,0,128,163,0,136,150,4,0,128,148,0,74,156,14,3,
209,64,208,136,166,4,0,128,163,0,200,154,21,0,64,208,136,166,4,0,64,161,
64,208,136,164,4,0,128,154,0,64,152,64,208,202,159,15,3,30,0,64,208,64,
152,64,208,128,156,0,74,154,10,2,244,64,208,128,152,0,73,147,13,33,64,208,
64,157,64,208,128,152,0,72,146,13,64,208,192,152,0,64,208,128,159,0,64,
144,64,208,128,156,0,192,152,0,64,208,74,157,22,1,54,64,208,137,156,5,8,
0,128,154,0,64,162,64,208,128,156,0,201,150,18,137,0,64,208,137,159,5,8,
0,128,147,0,128,162,0,201,146,22,79,0,64,208,136,161,4,0,64,146,64,208,
64,152,64,208,128,156,0,200,145,25,0,64,208,137,159,5,16,0,72,151,8,64,
208,128,160,0,128,148,0,128,162,0,192,144,0,64,208,136,168,4,0,64,167,64,
208,64,149,64,208,64,160,64,208,64,156,64,208,64,149,64,208,128,162,0,200,
148,13,0,64,208,64,152,64,208,128,161,0,64,147,64,208,73,152,9,16,64,208,
128,156,0,136,148,4,0,128,145,0,136,162,4,0,128,161,0,201,154,38,103,0,
64,208,137,160,5,24,0,136,159,4,0,64,152,64,208,64,156,64,208,64,144,64,
208,128,168,0,136,165,4,0,128,161,0,200,152,17,0,64,208,137,161,5,8,0,128,
156,0,128,162,0,192,151,0,64,208,137,154,5,36,0,73,149,21,28,64,208,64,
156,64,208,64,156,64,208,64,144,64,208,128,168,0,64,145,64,208,128,154,
0,128,150,0,136,165,4,0,128,160,0,200,156,37,0,64,208,137,160,5,16,0,137,
154,5,8,0,128,151,0,128,159,0,137,162,5,8,0,128,161,0,64,173,64,208,128,
162,0,64,155,64,208,136,165,4,0,128,154,0,202,164,15,1,74,0,64,208,136,
159,4,0,128,154,0,73,161,84,226,64,208,201,159,14,43,0,64,208,136,154,4,
0,128,146,0,201,152,14,21,0,64,208,64,156,64,208,128,161,0,136,151,4,0,
128,146,0,192,158,0,64,208,128,162,0,73,162,29,32,64,208,64,144,64,208,
64,157,64,208,64,148,64,208,64,144,64,208,64,160,64,208,128,162,0,128,161,
0,128,173,0,72,159,122,64,208,137,157,5,33,0,137,146,5,21,0,200,145,9,0,
64,208,128,162,0,64,144,64,208,128,146,0,136,156,4,0,128,152,0,137,161,
5,81,0,72,160,32,64,208,73,152,21,24,64,208,64,160,64,208,64,158,64,208,
64,148,64,208,128,171,0,128,145,0,128,165,0,192,158,0,64,208,136,163,4,
0,64,155,64,208,64,152,64,208,64,147,64,208,64,160,64,208,64,144,64,208,
64,164,64,208,64,156,64,208,64,144,64,208,128,168,0,128,162,0,192,158,0,
64,208,137,162,5,8,0,128,161,0,64,164,64,208,128,152,0,72,163,8,64,208,
128,161,0,192,162,0,64,208,201,160,30,61,0,64,208,64,144,64,208,64,157,
64,208,64,161,64,208,64,156,64,208,64,144,64,208,128,168,0,73,156,13,28,
64,208,64,144,64,208,128,168,0,72,152,8,64,208,128,159,0,64,146,64,208,
128,167,0,128,159,0,137,164,5,12,0,136,162,4,0,128,161,0,128,173,0,201,
173,26,57,0,64,208,73,162,9,16,64,208,128,158,0,64,161,64,208,128,165,0,
128,164,0,72,168,8,64,208,128,159,0,64,165,64,208,73,161,13,16,64,208,64,
151,64,208,128,160,0,128,159,0,128,162,0,64,175,64,208,64,147,64,208,128,
147,0,73,156,9,20,64,208,128,161,0,64,155,64,208,64,162,64,208,128,173,
0,64,158,64,208,128,151,0,73,165,13,92,64,208,64,164,64,208,128,152,0,73,
161,13,16,64,208,64,156,64,208,128,156,0,128,160,0,64,162,64,208,200,158,
30,0,64,208,73,161,9,21,64,208,128,161,0,192,156,0,64,208,64,144,64,208,
128,168,0,128,173,0,192,152,0,64,208,192,159,0,64,208,64,160,64,208,64,
152,64,208,64,145,64,208,64,158,64,208,128,160,0,73,173,13,41,64,208,64,
160,64,208,128,165,0,192,166,0,64,208,72,162,12,64,208,64,157,64,208,128,
156,0,64,161,64,208,64,152,64,208,128,161,0,64,175,64,208,128,152,0,64,
157,64,208,128,147,0,137,164,5,91,0,73,161,21,50,64,208,137,158,5,12,0,
64,156,64,208,128,156,0,128,162,0,200,160,13,0,64,208,136,163,4,0,128,148,
0,192,159,0,64,208,137,151,5,8,0,128,145,0,128,158,0,136,163,4,0,192,162,
0,64,208,137,159,5,20,0,137,155,5,12,0,64,152,64,208,128,166,0,128,158,
0,136,166,4,0,128,163,0,73,168,9,25,64,208,128,162,0,72,167,8,64,208,128,
161,0,192,166,0,64,208,128,165,0,64,173,64,208,128,163,0,64,156,64,208,
201,157,14,229,0,64,208,64,163,64,208,128,166,0,73,149,13,101,64,208,64,
148,64,208,128,144,0,73,146,9,42,64,208,128,161,0,136,145,4,0,192,144,0,
64,208,201,154,10,17,0,64,208,128,146,0,64,144,64,208,128,161,0,64,162,
64,208,128,163,0,200,148,31,0,64,208,192,159,0,64,208,72,157,8,64,208,128,
152,0,192,152,0,64,208,64,157,64,208,128,152,0,64,147,64,208,137,154,5,
8,0,128,145,0,128,159,0,201,154,39,87,0,64,208,137,162,5,29,0,200,161,17,
0,64,208,136,161,4,0,64,152,64,208,128,161,0,64,156,64,208,128,161,0,128,
166,0,72,152,36,64,208,73,158,9,16,64,208,128,157,0,136,154,4,0,128,152,
0,136,163,4,0,64,160,64,208,136,173,4,0,128,149,0,192,151,0,64,208,64,154,
64,208,128,158,0,64,156,64,208,73,162,13,20,64,208,64,144,64,208,128,163,
0,136,159,4,0,128,144,0,128,164,0,201,162,30,153,0,64,208,137,159,5,16,
0,137,151,5,8,0,128,144,0,128,158,0,136,164,4,0,128,162,0,201,160,14,87,
0,64,208,136,159,4,0,128,154,0,200,159,21,0,64,208,137,163,5,8,0,128,161,
0,64,175,64,208,128,146,0,192,158,0,64,208,137,160,5,20,0,73,155,9,12,64,
208,128,144,0,128,148,0,128,158,0,72,163,12,64,208,136,152,4,0,128,147,
0,64,161,64,208,64,154,64,208,64,146,64,208,128,149,0,192,161,0,64,208,
137,158,5,24,0,73,152,9,12,64,208,128,161,0,128,145,0,64,154,64,208,128,
166,0,136,163,4,0,128,161,0,73,165,9,46,64,208,128,144,0,200,164,9,0,64,
208,128,145,0,192,163,0,64,208,137,159,5,8,0,128,151,0,64,160,64,208,72,
158,8,64,208,128,155,0,128,155,0,192,173,0,64,208,128,162,0,64,158,64,208,
74,156,22,1,252,64,208,73,160,9,12,64,208,128,154,0,128,151,0,128,161,0,
73,148,13,139,64,208,136,156,4,0,128,148,0,73,145,13,53,64,208,64,146,64,
208,128,163,0,200,144,33,0,64,208,73,161,9,20,64,208,128,159,0,72,159,8,
64,208,128,159,0,128,154,0,64,173,64,208,128,161,0,64,134,64,208,128,146,
0,200,147,49,0,64,208,137,161,5,28,0,73,152,9,16,64,208,128,161,0,64,146,
64,208,128,164,0,64,160,64,208,128,144,0,72,173,8,64,208,128,154,0,64,162,
64,208,128,163,0,192,146,0,64,208,137,148,5,12,0,64,147,64,208,128,158,
0,64,152,64,208,128,161,0,201,152,18,86,0,64,208,137,160,5,8,0,128,151,
0,128,161,0,200,151,29,0,64,208,72,159,20,64,208,136,159,4,0,64,156,64,
208,64,161,64,208,128,145,0,128,150,0,64,149,64,208,64,157,64,208,72,154,
12,64,208,64,158,64,208,128,156,0,64,152,64,208,64,151,64,208,64,148,64,
208,64,144,64,208,128,162,0,72,155,194,64,208,201,159,10,145,0,64,208,128,
158,0,73,148,25,128,64,208,64,149,64,208,64,156,64,208,64,158,64,208,64,
160,64,208,128,162,0,64,147,64,208,73,158,49,92,64,208,64,163,64,208,64,
160,64,208,64,144,64,208,64,155,64,208,64,157,64,208,64,152,64,208,64,159,
64,208,64,152,64,208,64,147,64,208,64,144,64,208,128,151,0,72,156,8,64,
208,128,163,0,64,147,64,208,73,156,9,24,64,208,128,163,0,64,144,64,208,
64,161,64,208,136,163,4,0,128,144,0,64,162,64,208,128,163,0,64,162,64,208,
128,163,0,64,150,64,208,128,148,0,73,162,13,25,64,208,64,173,64,208,128,
154,0,192,161,0,64,208,64,157,64,208,128,165,0,64,172,64,208,64,164,64,
208,64,152,64,208,64,155,64,208,128,144,0,64,154,64,208,73,155,13,48,64,
208,136,154,4,0,128,144,0,73,148,9,20,64,208,128,166,0,136,145,4,0,64,144,
64,208,128,162,0,64,154,64,208,136,152,4,0,64,148,64,208,128,166,0,137,
163,5,12,0,136,159,4,0,128,156,0,128,173,0,74,162,23,1,95,64,208,72,162,
8,64,208,128,161,0,192,152,0,64,208,128,151,0,73,159,29,109,64,208,137,
159,5,12,0,136,148,4,0,128,147,0,136,162,4,0,64,161,64,208,128,168,0,72,
158,57,64,208,73,156,9,28,64,208,128,159,0,73,147,13,16,64,208,64,156,64,
208,128,146,0,128,146,0,128,151,0,136,161,4,0,192,159,0,64,208,64,152,64,
208,136,154,4,0,64,152,64,208,128,154,0,64,157,64,208,137,161,5,8,0,128,
148,0,64,162,64,208,64,162,64,208,128,154,0,200,161,171,0,64,208,137,158,
5,41,0,137,148,5,21,0,200,146,13,0,64,208,64,158,64,208,128,148,0,128,144,
0,72,156,8,64,208,128,154,0,64,155,64,208,128,161,0,73,161,9,21,64,208,
128,163,0,136,160,4,0,192,159,0,64,208,128,152,0,64,162,64,208,73,157,21,
40,64,208,64,152,64,208,64,147,64,208,64,160,64,208,128,152,0,72,152,8,
64,208,128,158,0,64,147,64,208,64,158,64,208,128,154,0,64,161,64,208,64,
152,64,208,64,145,64,208,64,162,64,208,64,160,64,208,64,144,64,208,64,157,
64,208,64,161,64,208,64,154,64,208,64,158,64,208,64,156,64,208,64,145,64,
208,64,144,64,208,64,157,64,208,128,154,0,64,160,64,208,137,155,5,24,0,
72,152,12,64,208,64,159,64,208,128,148,0,64,147,64,208,128,163,0,72,162,
12,64,208,64,159,64,208,128,166,0,192,159,0,64,208,128,164,0,73,165,17,
78,64,208,64,152,64,208,64,156,64,208,128,163,0,72,164,33,64,208,73,158,
13,16,64,208,64,156,64,208,128,161,0,128,154,0,192,159,0,64,208,64,156,
64,208,128,159,0,192,163,0,64,208,137,158,5,20,0,72,157,8,64,208,128,145,
0,64,155,64,208,128,165,0,128,164,0,72,173,8,64,208,128,154,0,64,168,64,
208,64,158,64,208,128,157,0,202,167,81,10,36,0,64,208,73,157,9,41,64,208,
128,147,0,73,155,9,25,64,208,128,165,0,200,154,13,0,64,208,64,155,64,208,
128,145,0,128,148,0,64,156,64,208,128,145,0,73,161,13,25,64,208,64,160,
64,208,128,145,0,136,160,4,0,192,159,0,64,208,128,152,0,64,168,64,208,128,
147,0,82,163,1,10,7,22,64,208,73,157,25,131,64,208,137,163,5,16,0,72,156,
8,64,208,128,166,0,128,144,0,128,166,0,73,149,9,44,64,208,128,160,0,73,
147,9,24,64,208,128,163,0,136,146,4,0,64,144,64,208,136,154,4,0,128,145,
0,64,148,64,208,64,158,64,208,128,161,0,201,152,10,34,0,64,208,128,156,
0,200,151,13,0,64,208,136,148,4,0,128,146,0,64,150,64,208,64,154,64,208,
128,147,0,64,156,64,208,201,158,14,21,0,64,208,64,160,64,208,128,164,0,
136,155,4,0,128,154,0,128,171,0,73,162,13,104,64,208,64,160,64,208,128,
154,0,73,160,21,72,64,208,72,165,12,64,208,64,145,64,208,128,151,0,128,
161,0,72,159,16,64,208,72,151,8,64,208,128,147,0,128,147,0,64,158,64,208,
137,160,5,28,0,72,155,16,64,208,64,159,64,208,64,159,64,208,128,159,0,64,
144,64,208,128,159,0,128,161,0,64,161,64,208,73,156,9,12,64,208,128,158,
0,128,152,0,128,158,0,137,166,5,16,0,64,165,64,208,64,152,64,208,128,157,
0,64,173,64,208,128,156,0,82,161,3,40,4,193,64,208,74,156,22,1,127,64,208,
137,157,5,12,0,136,154,4,0,128,151,0,128,161,0,73,149,85,248,64,208,73,
161,33,72,64,208,64,159,64,208,64,152,64,208,64,167,64,208,64,159,64,208,
64,160,64,208,64,158,64,208,128,156,0,64,160,64,208,64,158,64,208,64,147,
64,208,64,155,64,208,64,144,64,208,64,146,64,208,64,168,64,208,64,162,64,
208,64,144,64,208,128,145,0,64,165,64,208,128,145,0,201,146,26,57,0,64,
208,137,158,5,16,0,136,148,4,0,64,147,64,208,128,158,0,128,160,0,73,144,
17,24,64,208,136,162,4,0,64,161,64,208,128,148,0,64,134,64,208,128,161,
0,64,145,64,208,128,144,0,200,148,26,0,64,208,137,156,5,13,0,192,148,0,
64,208,128,149,0,64,160,64,208,128,154,0,64,147,64,208,137,154,5,41,0,73,
151,9,33,64,208,128,158,0,136,148,4,0,64,144,64,208,136,158,4,0,64,154,
64,208,192,152,0,64,208,128,152,0,128,152,0,73,162,17,28,64,208,136,163,
4,0,64,159,64,208,128,163,0,64,158,64,208,64,161,64,208,128,162,0,64,165,
64,208,128,154,0,73,152,41,65,64,208,73,160,9,24,64,208,128,152,0,136,158,
4,0,64,152,64,208,64,161,64,208,128,152,0,72,173,8,64,208,128,159,0,128,
162,0,200,151,17,0,64,208,136,155,4,0,64,147,64,208,128,166,0,64,150,64,
208,128,148,0,72,155,12,64,208,64,159,64,208,128,154,0,192,154,0,64,208,
137,159,5,20,0,137,154,5,12,0,64,145,64,208,128,162,0,128,155,0,137,165,
5,8,0,128,161,0,128,166,0,74,163,34,1,68,64,208,137,159,5,20,0,73,151,9,
12,64,208,128,152,0,128,150,0,128,156,0,136,173,4,0,128,160,0,73,160,21,
221,64,208,137,159,5,12,0,136,156,4,0,128,145,0,128,164,0,73,158,74,146,
64,208,137,159,5,48,0,137,154,5,24,0,72,152,16,64,208,64,160,64,208,64,
147,64,208,128,158,0,128,147,0,64,158,64,208,72,161,8,64,208,128,162,0,
64,157,64,208,128,155,0,137,167,5,17,0,192,162,0,64,208,64,160,64,208,128,
154,0,128,168,0,64,157,64,208,73,156,9,44,64,208,128,156,0,73,152,13,20,
64,208,64,162,64,208,128,158,0,136,148,4,0,128,145,0,72,155,12,64,208,64,
144,64,208,128,148,0,128,154,0,73,162,9,21,64,208,128,158,0,200,159,9,0,
64,208,128,158,0,128,158,0,128,165,0,192,159,0,64,208,137,162,5,30,0,201,
154,10,13,0,64,208,128,151,0,128,152,0,192,161,0,64,208,64,156,64,208,128,
152,0,137,168,5,12,0,64,163,64,208,128,160,0,64,173,64,208,128,154,0,72,
162,29,64,208,137,158,5,17,0,200,154,9,0,64,208,128,145,0,128,152,0,136,
161,4,0,128,159,0,192,161,0,64,208,137,148,5,24,0,137,146,5,8,0,128,144,
0,64,147,64,208,64,163,64,208,128,148,0,136,162,4,0,64,152,64,208,128,162,
0,201,166,42,74,0,64,208,73,160,9,20,64,208,128,158,0,64,152,64,208,64,
160,64,208,128,158,0,64,165,64,208,64,146,64,208,64,149,64,208,128,159,
0,200,165,21,0,64,208,72,161,12,64,208,64,158,64,208,128,157,0,128,146,
0,64,164,64,208,136,161,4,0,128,154,0,72,174,12,64,208,136,160,4,0,128,
158,0,64,173,64,208,128,152,0,64,160,64,208,74,158,76,1,22,64,208,201,158,
27,38,0,64,208,72,161,12,64,208,64,148,64,208,128,152,0,192,152,0,64,208,
128,160,0,64,148,64,208,64,158,64,208,128,161,0,64,162,64,208,64,156,64,
208,64,157,64,208,64,149,64,208,64,157,64,208,64,158,64,208,64,147,64,208,
128,152,0,73,149,13,112,64,208,64,154,64,208,128,157,0,201,146,18,61,0,
64,208,136,161,4,0,64,156,64,208,128,162,0,73,144,29,36,64,208,64,151,64,
208,64,146,64,208,64,149,64,208,64,148,64,208,64,154,64,208,128,149,0,64,
134,64,208,128,162,0,64,145,64,208,128,161,0,200,148,9,0,64,208,128,159,
0,192,147,0,64,208,201,157,14,21,0,64,208,64,144,64,208,128,163,0,64,152,
64,208,128,161,0,128,161,0,73,154,22,47,64,208,72,161,8,64,208,128,161,
0,192,158,0,64,208,128,161,0,72,152,17,64,208,192,148,0,64,208,64,155,64,
208,128,158,0,192,151,0,64,208,128,144,0,72,157,12,64,208,136,161,4,0,128,
147,0,64,156,64,208,73,158,13,20,64,208,136,159,4,0,128,158,0,136,151,4,
0,128,145,0,64,163,64,208,128,156,0,201,165,14,79,0,64,208,64,145,64,208,
128,160,0,201,162,18,37,0,64,208,72,162,8,64,208,128,151,0,128,151,0,72,
161,16,64,208,137,151,5,8,0,128,145,0,128,159,0,128,159,0,72,164,16,64,
208,137,160,5,8,0,128,159,0,128,168,0,192,163,0,64,208,64,175,64,208,128,
164,0,137,168,5,41,0,200,167,9,0,64,208,128,154,0,64,166,64,208,72,158,
12,64,208,64,175,64,208,128,158,0,64,134,64,208,64,160,64,208,128,158,0,
136,174,4,0,128,169,0,64,162,64,208,73,157,13,142,64,208,64,156,64,208,
128,144,0,137,151,5,58,0,201,147,14,46,0,64,208,136,160,4,0,128,154,0,72,
145,8,64,208,128,157,0,192,144,0,64,208,137,158,5,16,0,72,156,8,64,208,
128,158,0,128,154,0,128,159,0,64,150,64,208,128,162,0,73,155,9,52,64,208,
128,150,0,72,154,12,64,208,136,161,4,0,128,154,0,64,152,64,208,73,152,9,
20,64,208,128,162,0,72,151,8,64,208,128,152,0,128,146,0,64,155,64,208,128,
159,0,64,156,64,208,137,159,5,8,0,128,152,0,64,173,64,208,128,152,0,201,
162,14,127,0,64,208,136,173,4,0,128,146,0,73,160,13,101,64,208,64,146,64,
208,128,151,0,72,159,8,64,208,128,159,0,192,158,0,64,208,73,159,13,24,64,
208,64,144,64,208,128,161,0,136,158,4,0,64,134,64,208,128,154,0,64,160,
64,208,72,166,28,64,208,64,146,64,208,64,149,64,208,64,162,64,208,64,156,
64,208,64,149,64,208,128,162,0,64,161,64,208,64,171,64,208,64,160,64,208,
64,172,64,208,128,149,0,192,161,0,64,208,136,161,4,0,128,159,0,137,166,
5,21,0,192,163,0,64,208,137,151,5,8,0,128,145,0,128,154,0,192,173,0,64,
208,137,159,5,21,0,137,154,5,13,0,192,152,0,64,208,128,159,0,128,156,0,
136,168,4,0,64,161,64,208,128,165,0,74,165,102,1,185,64,208,73,157,13,33,
64,208,64,160,64,208,128,166,0,201,152,10,17,0,64,208,128,155,0,136,151,
4,0,128,144,0,128,155,0,73,162,18,30,64,208,200,163,9,0,64,208,128,151,
0,128,155,0,200,161,9,0,64,208,128,163,0,128,160,0,192,163,0,64,208,64,
162,64,208,64,149,64,208,72,156,12,64,208,64,144,64,208,128,161,0,64,152,
64,208,128,157,0,64,164,64,208,73,158,25,191,64,208,73,158,9,16,64,208,
128,159,0,136,147,4,0,128,144,0,128,159,0,73,149,9,95,64,208,128,163,0,
201,147,14,74,0,64,208,64,145,64,208,128,154,0,200,146,17,0,64,208,64,144,
64,208,64,162,64,208,128,162,0,64,144,64,208,73,159,9,24,64,208,128,159,
0,72,151,12,64,208,64,154,64,208,128,145,0,128,145,0,64,161,64,208,64,158,
64,208,64,158,64,208,128,157,0,192,148,0,64,208,136,159,4,0,128,156,0,73,
156,25,64,64,208,137,161,5,16,0,136,158,4,0,64,156,64,208,128,154,0,128,
168,0,72,155,16,64,208,137,159,5,8,0,128,144,0,128,164,0,64,154,64,208,
72,157,12,64,208,64,162,64,208,128,163,0,64,152,64,208,128,151,0,64,157,
64,208,128,160,0,137,163,5,108,0,73,161,27,80,64,208,201,162,10,18,0,64,
208,128,152,0,192,158,0,64,208,128,144,0,128,165,0,200,160,33,0,64,208,
73,145,9,20,64,208,128,152,0,64,144,64,208,64,147,64,208,128,161,0,64,162,
64,208,128,144,0,192,159,0,64,208,137,154,5,12,0,136,150,4,0,128,147,0,
128,161,0,64,162,64,208,137,159,5,12,0,136,156,4,0,128,145,0,136,168,4,
0,128,161,0,137,168,5,21,0,72,167,8,64,208,128,154,0,192,165,0,64,208,128,
147,0,64,173,64,208,137,152,5,8,0,128,144,0,128,163,0,192,166,0,64,208,
73,157,21,153,64,208,64,152,64,208,64,152,64,208,64,158,64,208,128,162,
0,73,147,13,45,64,208,64,159,64,208,128,165,0,73,145,9,16,64,208,128,151,
0,64,144,64,208,128,148,0,192,146,0,64,208,136,154,4,0,64,147,64,208,128,
148,0,73,154,33,68,64,208,137,159,5,24,0,136,158,4,0,64,157,64,208,72,162,
8,64,208,128,144,0,128,144,0,128,161,0,64,152,64,208,73,158,9,20,64,208,
128,156,0,136,154,4,0,64,146,64,208,128,149,0,64,173,64,208,64,161,64,208,
128,162,0,64,156,64,208,137,158,5,12,0,136,154,4,0,128,152,0,128,159,0,
73,162,9,70,64,208,128,159,0,201,159,19,42,0,64,208,136,158,4,0,192,144,
0,64,208,128,163,0,64,158,64,208,73,159,9,16,64,208,128,162,0,136,154,4,
0,128,152,0,128,162,0,64,161,64,208,137,156,5,8,0,128,152,0,64,159,64,208,
128,161,0,137,165,5,13,0,192,163,0,64,208,128,150,0,64,173,64,208,73,160,
9,12,64,208,128,156,0,128,156,0,128,161,0,74,173,248,2,70,64,208,73,156,
17,152,64,208,72,162,8,64,208,128,158,0,128,151,0,73,150,9,66,64,208,128,
165,0,73,147,13,45,64,208,136,163,4,0,128,152,0,72,146,12,64,208,64,163,
64,208,128,161,0,64,145,64,208,200,160,9,0,64,208,128,158,0,64,152,64,208,
128,161,0,192,148,0,64,208,64,160,64,208,128,158,0,73,154,13,50,64,208,
64,144,64,208,128,164,0,200,152,9,0,64,208,128,151,0,192,151,0,64,208,73,
156,9,16,64,208,128,154,0,64,148,64,208,128,161,0,64,161,64,208,128,154,
0,64,155,64,208,72,162,8,64,208,128,158,0,64,154,64,208,128,158,0,73,161,
9,52,64,208,128,154,0,73,159,13,32,64,208,136,162,4,0,128,152,0,72,158,
12,64,208,136,158,4,0,128,156,0,64,157,64,208,128,148,0,64,160,64,208,136,
161,4,0,128,151,0,201,164,10,34,0,64,208,128,155,0,200,163,13,0,64,208,
64,156,64,208,128,156,0,64,162,64,208,136,162,4,0,128,151,0,128,168,0,74,
169,18,1,27,64,208,136,163,4,0,64,144,64,208,128,160,0,64,168,64,208,201,
156,26,106,0,64,208,73,160,9,16,64,208,128,145,0,136,159,4,0,128,145,0,
128,161,0,137,150,5,53,0,73,147,21,41,64,208,137,159,5,12,0,136,148,4,0,
128,144,0,128,163,0,72,146,8,64,208,128,156,0,192,145,0,64,208,136,156,
4,0,128,152,0,64,149,64,208,128,161,0,73,152,9,12,64,208,128,152,0,128,
151,0,64,154,64,208,137,162,5,8,0,128,144,0,128,163,0,73,161,17,114,64,
208,137,156,5,8,0,128,152,0,128,158,0,201,159,34,85,0,64,208,73,152,9,20,
64,208,128,159,0,136,148,4,0,64,146,64,208,128,151,0,136,159,4,0,128,154,
0,72,158,36,64,208,73,159,9,16,64,208,128,164,0,64,156,64,208,128,158,0,
64,161,64,208,64,173,64,208,64,163,64,208,128,157,0,64,157,64,208,137,152,
5,8,0,128,145,0,128,163,0,192,160,0,64,208,136,156,4,0,128,144,0,73,163,
17,25,64,208,137,159,5,8,0,128,145,0,128,164,0,192,162,0,64,208,128,147,
0,192,173,0,64,208,136,161,4,0,64,152,64,208,128,161,0,64,171,64,208,72,
167,16,64,208,64,156,64,208,64,144,64,208,128,162,0,64,160,64,208,64,144,
64,208,64,161,64,208,64,162,64,208,64,144,64,208,64,153,64,208,64,154,64,
208,128,144,0,72,175,56,64,208,73,161,9,20,64,208,128,163,0,137,148,5,8,
0,128,144,0,128,156,0,136,163,4,0,64,162,64,208,64,147,64,208,73,162,9,
16,64,208,128,163,0,64,147,64,208,128,163,0,128,163,0,64,174,64,208,136,
162,4,0,64,151,64,208,128,152,0,64,79,64,208,128,151,0,82,144,44,14,45,
229,80,208,44,1,210,157,1,159,21,87,0,64,208,73,159,42,242,64,208,137,154,
5,16,0,137,148,5,8,0,128,144,0,128,152,0,73,161,9,12,64,208,128,154,0,128,
160,0,192,166,0,64,208,128,147,0,73,152,33,115,64,208,73,156,9,20,64,208,
128,152,0,64,152,64,208,64,165,64,208,128,162,0,64,160,64,208,128,160,0,
201,146,14,39,0,64,208,64,163,64,208,128,151,0,200,145,14,0,64,208,192,
158,0,64,208,128,159,0,64,144,64,208,64,154,64,208,128,144,0,72,151,12,
64,208,64,144,64,208,128,154,0,64,147,64,208,73,161,13,24,64,208,64,158,
64,208,128,166,0,136,154,4,0,64,145,64,208,128,154,0,128,166,0,73,157,13,
40,64,208,64,173,64,208,128,152,0,136,156,4,0,64,154,64,208,72,158,16,64,
208,137,161,5,8,0,128,155,0,128,163,0,128,145,0,192,158,0,64,208,73,159,
9,29,64,208,128,161,0,136,158,4,0,192,154,0,64,208,72,149,8,64,208,128,
152,0,128,144,0,136,164,4,0,64,161,64,208,128,144,0,137,164,5,107,0,73,
162,34,95,64,208,73,159,9,20,64,208,128,152,0,64,154,64,208,64,158,64,208,
128,156,0,192,173,0,64,208,128,155,0,72,161,20,64,208,137,163,5,12,0,64,
148,64,208,128,163,0,128,166,0,64,160,64,208,137,154,5,21,0,72,152,8,64,
208,128,163,0,192,146,0,64,208,128,163,0,200,163,9,0,64,208,128,160,0,64,
161,64,208,128,154,0,64,163,64,208,128,148,0,73,167,9,29,64,208,128,160,
0,72,166,12,64,208,64,173,64,208,128,144,0,192,165,0,64,208,128,154,0,64,
173,64,208,73,159,9,12,64,208,128,158,0,128,154,0,192,161,0,64,208,64,156,
64,208,128,152,0,74,150,63,10,156,64,208,73,158,9,32,64,208,128,151,0,73,
152,13,16,64,208,136,164,4,0,128,154,0,128,148,0,64,154,64,208,128,145,
0,137,160,5,17,0,192,159,0,64,208,136,160,4,0,128,154,0,64,163,64,208,128,
160,0,82,146,4,119,6,137,64,208,202,156,39,1,24,0,64,208,137,158,5,20,0,
72,152,12,64,208,64,158,64,208,128,157,0,128,147,0,136,161,4,0,64,159,64,
208,128,162,0,201,147,18,130,0,64,208,64,158,64,208,64,163,64,208,128,160,
0,73,145,17,76,64,208,136,161,4,0,64,159,64,208,128,156,0,72,144,44,64,
208,73,163,9,32,64,208,128,155,0,72,162,8,64,208,128,163,0,64,160,64,208,
64,154,64,208,64,158,64,208,128,156,0,64,168,64,208,128,159,0,64,134,64,
208,64,160,64,208,64,161,64,208,128,163,0,64,146,64,208,137,156,5,25,0,
72,147,8,64,208,128,159,0,192,144,0,64,208,64,163,64,208,128,155,0,136,
163,4,0,128,159,0,73,152,81,96,64,208,73,156,9,64,64,208,128,159,0,73,145,
9,44,64,208,128,144,0,64,144,64,208,72,151,20,64,208,64,144,64,208,64,146,
64,208,64,158,64,208,128,148,0,64,147,64,208,64,161,64,208,128,156,0,64,
154,64,208,64,158,64,208,128,161,0,72,162,8,64,208,128,152,0,128,157,0,
72,151,12,64,208,136,163,4,0,128,154,0,128,150,0,64,155,64,208,64,163,64,
208,64,147,64,208,128,144,0,73,161,13,109,64,208,136,157,4,0,128,154,0,
73,159,39,84,64,208,137,158,5,17,0,200,154,9,0,64,208,128,158,0,128,148,
0,200,160,13,0,64,208,136,164,4,0,128,152,0,128,159,0,200,158,17,0,64,208,
72,160,8,64,208,128,161,0,128,156,0,192,157,0,64,208,137,159,5,20,0,72,
158,8,64,208,128,174,0,64,146,64,208,128,174,0,128,160,0,192,160,0,64,208,
64,167,64,208,128,156,0,74,166,10,2,219,64,208,128,159,0,64,162,64,208,
72,160,16,64,208,64,144,64,208,64,157,64,208,128,161,0,64,158,64,208,74,
157,26,1,110,64,208,64,158,64,208,64,156,64,208,64,149,64,208,64,160,64,
208,128,144,0,73,148,26,173,64,208,64,158,64,208,192,160,0,64,208,64,158,
64,208,64,147,64,208,128,144,0,73,146,65,136,64,208,64,152,64,208,64,148,
64,208,64,149,64,208,64,158,64,208,64,160,64,208,64,149,64,208,64,147,64,
208,64,152,64,208,64,161,64,208,64,162,64,208,64,160,64,208,64,144,64,208,
64,162,64,208,64,158,64,208,128,160,0,64,144,64,208,64,154,64,208,72,163,
24,64,208,64,161,64,208,64,162,64,208,64,152,64,208,64,154,64,208,128,144,
0,64,154,64,208,64,163,64,208,64,156,64,208,64,163,64,208,64,155,64,208,
64,175,64,208,64,162,64,208,64,158,64,208,64,160,64,208,128,171,0,64,147,
64,208,64,144,64,208,128,151,0,73,154,129,148,64,208,72,160,32,64,208,72,
149,16,64,208,64,161,64,208,64,155,64,208,128,158,0,64,144,64,208,136,157,
4,0,128,151,0,64,158,64,208,73,156,33,48,64,208,64,159,64,208,64,160,64,
208,64,149,64,208,64,161,64,208,64,161,64,208,64,158,64,208,128,160,0,64,
146,64,208,64,160,64,208,64,152,64,208,128,154,0,64,157,64,208,64,148,64,
208,64,152,64,208,64,166,64,208,64,152,64,208,64,158,64,208,64,157,64,208,
64,149,64,208,64,160,64,208,128,171,0,64,151,64,208,64,144,64,208,64,146,
64,208,64,158,64,208,128,148,0,64,156,64,208,64,144,64,208,64,161,64,208,
64,155,64,208,128,144,0,73,164,21,240,64,208,64,158,64,208,64,160,64,208,
64,163,64,208,128,156,0,73,161,49,184,64,208,64,152,64,208,64,147,64,208,
64,157,64,208,64,144,64,208,64,155,64,208,64,152,64,208,64,151,64,208,64,
144,64,208,64,166,64,208,64,152,64,208,128,152,0,64,159,64,208,73,158,45,
88,64,208,72,155,12,64,208,64,152,64,208,128,146,0,64,148,64,208,64,170,
64,208,64,149,64,208,64,156,64,208,64,157,64,208,64,152,64,208,128,154,
0,72,149,32,64,208,64,160,64,208,64,149,64,208,64,146,64,208,64,158,64,
208,64,151,64,208,64,154,64,208,128,144,0,64,144,64,208,64,160,64,208,128,
154,0,72,171,24,64,208,64,155,64,208,64,149,64,208,64,161,64,208,64,158,
64,208,128,161,0,64,160,64,208,64,152,64,208,64,166,64,208,64,149,64,208,
128,159,0,64,162,64,208,64,149,64,208,64,155,64,208,64,149,64,208,64,146,
64,208,64,152,64,208,64,151,64,208,64,158,64,208,128,160,0,72,167,48,64,
208,72,149,24,64,208,64,165,64,208,64,155,64,208,136,171,4,0,64,144,64,
208,128,156,0,64,144,64,208,64,153,64,208,64,157,64,208,64,152,64,208,128,
154,0,64,165,64,208,64,158,64,208,64,155,64,208,64,158,64,208,64,148,64,
208,64,152,64,208,64,155,64,208,64,172,64,208,64,157,64,208,64,152,64,208,
128,154,0,64,173,64,208,136,164,4,0,64,154,64,208,128,161,0,201,144,162,
190,0,64,208,73,157,13,64,64,208,64,152,64,208,128,152,0,73,151,9,24,64,
208,128,154,0,72,148,8,64,208,128,154,0,64,146,64,208,128,162,0,72,156,
12,64,208,136,163,4,0,128,160,0,64,152,64,208,137,162,5,8,0,128,160,0,128,
175,0,73,161,25,68,64,208,73,159,9,12,64,208,128,161,0,128,156,0,64,160,
64,208,128,157,0,72,160,20,64,208,72,159,8,64,208,128,167,0,64,154,64,208,
128,158,0,64,159,64,208,137,156,5,16,0,72,154,8,64,208,128,159,0,128,148,
0,128,157,0,72,173,20,64,208,137,159,5,12,0,64,152,64,208,128,159,0,128,
161,0,128,166,0,64,134,64,208,73,159,9,16,64,208,128,161,0,64,145,64,208,
128,161,0,192,161,0,64,208,128,162,0,64,145,64,208,73,158,37,203,64,208,
73,161,21,28,64,208,64,160,64,208,64,163,64,208,64,161,64,208,128,172,0,
136,159,4,0,128,158,0,128,164,0,73,148,30,86,64,208,73,159,9,21,64,208,
128,154,0,200,156,9,0,64,208,128,147,0,128,148,0,128,162,0,73,145,17,37,
64,208,136,168,4,0,64,146,64,208,128,163,0,72,144,13,64,208,192,158,0,64,
208,128,155,0,64,134,64,208,128,161,0,72,147,8,64,208,128,168,0,64,146,
64,208,136,161,4,0,128,152,0,73,152,34,53,64,208,137,156,5,21,0,200,147,
9,0,64,208,128,152,0,64,144,64,208,128,161,0,136,161,4,0,128,159,0,136,
151,4,0,64,149,64,208,64,154,64,208,64,158,64,208,128,160,0,72,156,12,64,
208,136,164,4,0,128,158,0,64,154,64,208,137,159,5,8,0,128,156,0,128,160,
0,73,164,13,106,64,208,136,164,4,0,128,152,0,73,161,29,66,64,208,137,159,
5,16,0,136,151,4,0,64,146,64,208,128,162,0,136,163,4,0,128,160,0,200,160,
29,0,64,208,73,158,17,20,64,208,64,154,64,208,64,149,64,208,128,162,0,128,
145,0,128,160,0,192,159,0,64,208,128,152,0,72,163,8,64,208,128,166,0,64,
162,64,208,137,158,5,12,0,136,152,4,0,128,145,0,128,164,0,137,168,5,20,
0,72,166,8,64,208,128,160,0,64,165,64,208,128,156,0,64,173,64,208,128,161,
0,210,148,1,98,3,100,0,64,208,73,157,13,191,64,208,64,161,64,208,128,154,
0,73,150,9,94,64,208,128,154,0,201,147,14,41,0,64,208,136,163,4,0,128,159,
0,72,145,8,64,208,128,154,0,64,144,64,208,72,161,8,64,208,128,173,0,64,
152,64,208,128,160,0,72,149,36,64,208,64,156,64,208,64,149,64,208,64,162,
64,208,64,152,64,208,64,158,64,208,64,157,64,208,64,152,64,208,128,157,
0,192,148,0,64,208,128,154,0,73,155,9,37,64,208,128,146,0,72,154,8,64,208,
128,156,0,192,152,0,64,208,73,154,9,12,64,208,128,156,0,128,145,0,128,162,
0,64,156,64,208,137,161,5,40,0,136,154,4,0,64,152,64,208,64,157,64,208,
64,160,64,208,64,149,64,208,64,161,64,208,64,163,64,208,64,160,64,208,128,
161,0,128,162,0,73,164,13,107,64,208,64,165,64,208,128,148,0,201,160,14,
62,0,64,208,64,154,64,208,128,155,0,72,159,33,64,208,201,158,10,25,0,64,
208,128,167,0,136,152,4,0,64,144,64,208,64,166,64,208,128,164,0,128,162,
0,64,158,64,208,136,154,4,0,64,151,64,208,128,158,0,200,162,9,0,64,208,
128,168,0,64,161,64,208,137,159,5,16,0,72,152,8,64,208,128,166,0,128,146,
0,128,161,0,73,171,29,44,64,208,72,160,12,64,208,64,161,64,208,128,163,
0,64,155,64,208,64,161,64,208,128,163,0,72,166,8,64,208,128,163,0,64,165,
64,208,128,144,0,128,173,0,192,147,0,64,208,74,159,50,1,50,64,208,137,156,
5,20,0,137,152,5,12,0,136,151,4,0,128,144,0,128,154,0,137,163,5,16,0,136,
161,4,0,64,159,64,208,128,154,0,64,173,64,208,128,154,0,201,152,87,156,
0,64,208,73,162,29,61,64,208,64,159,64,208,64,155,64,208,64,144,64,208,
64,154,64,208,64,144,64,208,128,162,0,73,154,18,25,64,208,136,161,4,0,192,
152,0,64,208,128,152,0,64,152,64,208,128,154,0,64,156,64,208,128,161,0,
73,164,9,16,64,208,128,154,0,64,163,64,208,128,146,0,128,166,0,73,147,17,
46,64,208,72,162,8,64,208,128,154,0,128,161,0,200,146,13,0,64,208,136,162,
4,0,128,159,0,64,144,64,208,136,163,4,0,192,154,0,64,208,128,152,0,72,151,
16,64,208,137,161,5,8,0,128,159,0,128,163,0,64,150,64,208,128,148,0,73,
157,30,77,64,208,201,154,10,21,0,64,208,128,161,0,72,152,8,64,208,128,156,
0,128,144,0,128,161,0,72,156,20,64,208,137,159,5,12,0,136,154,4,0,128,144,
0,128,163,0,64,154,64,208,73,159,9,20,64,208,128,162,0,136,156,4,0,64,147,
64,208,128,157,0,128,166,0,64,158,64,208,137,161,5,12,0,64,158,64,208,128,
160,0,64,166,64,208,128,144,0,137,166,5,155,0,201,162,51,143,0,64,208,73,
155,9,16,64,208,128,159,0,136,148,4,0,128,144,0,72,173,12,64,208,136,161,
4,0,128,154,0,192,163,0,64,208,64,158,64,208,64,158,64,208,128,161,0,200,
161,17,0,64,208,137,159,5,8,0,128,146,0,128,167,0,64,160,64,208,73,158,
65,68,64,208,72,159,32,64,208,64,160,64,208,64,158,64,208,64,156,64,208,
64,145,64,208,64,144,64,208,64,157,64,208,128,154,0,64,154,64,208,64,158,
64,208,64,156,64,208,64,145,64,208,64,144,64,208,64,157,64,208,128,154,
0,128,147,0,128,161,0,64,164,64,208,128,163,0,73,174,17,45,64,208,136,160,
4,0,64,146,64,208,128,144,0,72,173,16,64,208,137,163,5,8,0,128,161,0,128,
166,0,192,168,0,64,208,136,168,4,0,128,154,0,128,175,0,64,149,64,208,201,
157,14,53,0,64,208,64,158,64,208,128,154,0,73,154,13,32,64,208,136,161,
4,0,128,148,0,73,146,13,16,64,208,64,152,64,208,128,161,0,128,145,0,128,
152,0,136,156,4,0,128,155,0,73,161,13,28,64,208,64,145,64,208,128,152,0,
136,160,4,0,64,159,64,208,136,160,4,0,128,144,0,72,173,12,64,208,64,154,
64,208,128,163,0,64,162,64,208,64,161,64,208,64,157,64,208,128,147,0,82,
154,2,69,5,181,64,208,74,158,46,1,65,64,208,73,161,13,28,64,208,64,159,
64,208,128,158,0,72,160,12,64,208,136,164,4,0,128,162,0,128,158,0,136,173,
4,0,64,162,64,208,128,158,0,73,151,13,127,64,208,136,162,4,0,128,161,0,
201,147,18,66,0,64,208,72,163,8,64,208,128,159,0,128,161,0,201,145,22,33,
0,64,208,137,155,5,12,0,64,152,64,208,128,161,0,128,158,0,64,144,64,208,
136,160,4,0,128,152,0,64,146,64,208,136,162,4,0,64,161,64,208,128,159,0,
72,149,12,64,208,136,175,4,0,128,146,0,64,148,64,208,137,159,5,21,0,200,
158,9,0,64,208,128,157,0,64,148,64,208,128,144,0,72,174,8,64,208,128,166,
0,128,162,0,201,155,18,94,0,64,208,136,164,4,0,64,163,64,208,128,160,0,
72,154,49,64,208,73,159,13,29,64,208,136,159,4,0,128,145,0,72,158,13,64,
208,192,160,0,64,208,128,154,0,128,145,0,72,163,12,64,208,64,154,64,208,
128,161,0,128,160,0,64,152,64,208,136,164,4,0,64,159,64,208,136,161,4,0,
64,154,64,208,64,160,64,208,128,158,0,200,157,21,0,64,208,73,158,9,12,64,
208,128,159,0,128,148,0,128,159,0,192,156,0,64,208,201,157,10,25,0,64,208,
128,161,0,72,152,12,64,208,64,144,64,208,128,166,0,128,151,0,128,160,0,
73,164,25,191,64,208,137,154,5,16,0,72,146,8,64,208,128,162,0,128,145,0,
128,165,0,73,161,71,106,64,208,73,157,9,40,64,208,128,148,0,73,152,21,24,
64,208,137,162,5,12,0,64,158,64,208,128,154,0,128,173,0,128,150,0,64,154,
64,208,128,162,0,201,159,10,18,0,64,208,128,154,0,192,158,0,64,208,128,
160,0,64,161,64,208,128,160,0,72,160,16,64,208,137,161,5,8,0,128,145,0,
128,164,0,64,159,64,208,137,160,5,12,0,136,159,4,0,128,155,0,128,162,0,
72,163,32,64,208,73,158,9,24,64,208,128,160,0,72,157,8,64,208,128,145,0,
64,154,64,208,128,161,0,128,160,0,64,162,64,208,201,160,10,21,0,64,208,
128,163,0,72,149,8,64,208,128,165,0,128,147,0,128,162,0,201,168,10,50,0,
64,208,128,163,0,72,166,32,64,208,73,158,9,20,64,208,128,162,0,64,152,64,
208,64,162,64,208,128,160,0,64,159,64,208,128,145,0,192,165,0,64,208,128,
146,0,136,174,4,0,64,173,64,208,128,163,0,82,152,1,217,3,49,64,208,73,157,
29,200,64,208,137,154,5,16,0,72,152,8,64,208,128,147,0,128,147,0,64,173,
64,208,128,161,0,137,151,5,69,0,73,146,13,45,64,208,136,162,4,0,128,155,
0,72,145,20,64,208,137,161,5,8,0,128,152,0,64,173,64,208,128,154,0,192,
144,0,64,208,136,165,4,0,128,161,0,72,150,8,64,208,128,154,0,64,148,64,
208,136,162,4,0,128,161,0,73,155,21,95,64,208,136,166,4,0,64,158,64,208,
64,146,64,208,128,162,0,72,154,45,64,208,137,161,5,29,0,73,152,9,12,64,
208,128,159,0,128,145,0,192,158,0,64,208,136,161,4,0,128,148,0,72,174,8,
64,208,128,160,0,128,166,0,64,152,64,208,200,162,13,0,64,208,64,144,64,
208,128,156,0,192,161,0,64,208,64,154,64,208,128,163,0,64,156,64,208,128,
155,0,73,163,14,216,64,208,192,161,0,64,208,128,158,0,73,160,21,90,64,208,
72,173,8,64,208,128,158,0,64,159,64,208,128,159,0,200,159,50,0,64,208,137,
158,5,24,0,73,152,9,12,64,208,128,154,0,128,145,0,64,154,64,208,128,159,
0,201,163,14,17,0,64,208,64,164,64,208,128,158,0,128,161,0,128,173,0,64,
158,64,208,136,160,4,0,64,156,64,208,64,161,64,208,128,163,0,200,162,25,
0,64,208,73,158,13,16,64,208,64,157,64,208,128,154,0,128,149,0,128,159,
0,192,161,0,64,208,73,159,9,46,64,208,128,159,0,137,152,5,25,0,200,147,
9,0,64,208,128,151,0,64,145,64,208,136,163,4,0,128,159,0,192,154,0,64,208,
64,147,64,208,128,157,0,73,162,13,20,64,208,64,149,64,208,128,155,0,64,
161,64,208,128,162,0,192,163,0,64,208,136,159,4,0,64,151,64,208,128,163,
0,73,167,9,33,64,208,128,161,0,72,166,16,64,208,136,157,4,0,64,146,64,208,
128,162,0,192,164,0,64,208,128,158,0,192,173,0,64,208,72,162,8,64,208,128,
163,0,128,161,0,64,151,64,208,73,156,13,176,64,208,64,158,64,208,128,155,
0,201,148,10,86,0,64,208,128,144,0,73,145,17,40,64,208,137,160,5,8,0,128,
158,0,128,165,0,72,144,12,64,208,136,161,4,0,128,155,0,64,134,64,208,64,
151,64,208,128,163,0,200,147,29,0,64,208,137,163,5,16,0,136,158,4,0,64,
157,64,208,128,144,0,64,173,64,208,128,163,0,64,146,64,208,128,164,0,201,
152,14,41,0,64,208,64,159,64,208,128,152,0,136,150,4,0,64,149,64,208,136,
161,4,0,64,160,64,208,64,160,64,208,64,158,64,208,128,161,0,72,155,8,64,
208,128,154,0,192,154,0,64,208,73,152,13,16,64,208,64,158,64,208,128,161,
0,128,151,0,64,159,64,208,128,158,0,73,162,29,137,64,208,137,157,5,16,0,
136,156,4,0,64,152,64,208,128,156,0,136,173,4,0,128,161,0,73,159,25,72,
64,208,137,162,5,12,0,136,159,4,0,128,152,0,64,173,64,208,128,157,0,72,
158,28,64,208,137,161,5,16,0,64,152,64,208,64,152,64,208,128,162,0,64,166,
64,208,128,156,0,64,157,64,208,137,162,5,12,0,64,154,64,208,128,163,0,128,
165,0,200,161,25,0,64,208,137,159,5,12,0,136,154,4,0,128,144,0,64,161,64,
208,128,161,0,64,160,64,208,136,154,4,0,128,152,0,73,165,13,20,64,208,136,
161,4,0,128,158,0,136,164,4,0,128,163,0,64,168,64,208,128,146,0,64,153,
64,208,72,161,36,64,208,64,152,64,208,72,162,16,64,208,64,149,64,208,64,
154,64,208,128,161,0,64,154,64,208,64,172,64,208,128,174,0,64,145,64,208,
64,158,64,208,64,155,64,208,64,152,64,208,64,162,64,208,128,163,0,80,156,
2,31,64,208,74,158,22,1,21,64,208,73,152,9,12,64,208,128,158,0,128,147,
0,128,160,0,73,151,9,104,64,208,128,152,0,73,147,21,56,64,208,136,163,4,
0,64,159,64,208,64,147,64,208,128,163,0,73,145,21,32,64,208,72,163,12,64,
208,64,155,64,208,128,172,0,128,157,0,64,144,64,208,136,163,4,0,128,151,
0,128,146,0,72,149,16,64,208,136,163,4,0,64,147,64,208,128,144,0,64,148,
64,208,137,156,5,12,0,136,154,4,0,128,151,0,64,159,64,208,128,160,0,201,
155,10,95,0,64,208,128,160,0,72,154,42,64,208,137,160,5,30,0,201,154,10,
17,0,64,208,128,162,0,64,152,64,208,128,160,0,192,158,0,64,208,128,161,
0,136,164,4,0,128,163,0,64,152,64,208,137,154,5,20,0,72,147,8,64,208,128,
173,0,64,146,64,208,128,161,0,72,161,16,64,208,137,158,5,8,0,128,145,0,
128,159,0,128,158,0,200,157,25,0,64,208,137,163,5,16,0,72,162,8,64,208,
128,154,0,128,161,0,128,167,0,64,156,64,208,137,161,5,12,0,136,159,4,0,
128,154,0,72,163,8,64,208,128,160,0,64,162,64,208,128,159,0,73,164,21,200,
64,208,137,160,5,12,0,136,159,4,0,128,146,0,128,163,0,73,161,62,110,64,
208,73,152,9,29,64,208,128,162,0,201,147,10,17,0,64,208,128,160,0,136,146,
4,0,128,145,0,128,151,0,73,161,13,24,64,208,136,160,4,0,128,158,0,64,154,
64,208,64,158,64,208,128,156,0,128,163,0,72,160,17,64,208,136,159,4,0,192,
158,0,64,208,128,161,0,64,159,64,208,73,161,13,24,64,208,136,157,4,0,128,
154,0,136,160,4,0,64,157,64,208,128,160,0,128,166,0,72,163,25,64,208,192,
160,0,64,208,64,161,64,208,64,158,64,208,64,173,64,208,128,161,0,64,162,
64,208,137,161,5,16,0,137,157,5,8,0,128,152,0,128,159,0,72,163,8,64,208,
128,160,0,192,162,0,64,208,136,159,4,0,64,155,64,208,128,159,0,73,168,17,
45,64,208,136,159,4,0,64,158,64,208,128,151,0,72,167,12,64,208,64,152,64,
208,128,164,0,192,166,0,64,208,136,160,4,0,64,151,64,208,128,157,0,72,174,
8,64,208,128,147,0,64,173,64,208,128,163,0,64,155,64,208,73,160,21,129,
64,208,136,161,4,0,64,158,64,208,64,161,64,208,128,144,0,73,156,29,73,64,
208,137,151,5,16,0,64,144,64,208,136,162,4,0,128,154,0,64,152,64,208,128,
145,0,73,147,13,37,64,208,64,162,64,208,128,163,0,72,146,16,64,208,72,161,
8,64,208,128,160,0,128,151,0,192,145,0,64,208,128,152,0,64,148,64,208,128,
149,0,73,158,17,24,64,208,64,146,64,208,64,148,64,208,128,162,0,64,157,
64,208,128,161,0,64,159,64,208,64,163,64,208,128,148,0,137,165,5,152,0,
201,163,18,140,0,64,208,64,146,64,208,64,148,64,208,128,162,0,200,162,98,
0,64,208,73,162,29,89,64,208,72,160,16,64,208,64,144,64,208,64,157,64,208,
128,161,0,64,159,64,208,128,159,0,200,154,17,0,64,208,64,144,64,208,64,
146,64,208,128,161,0,64,147,64,208,73,159,9,28,64,208,128,144,0,72,156,
8,64,208,128,154,0,64,144,64,208,64,154,64,208,128,152,0,136,163,4,0,64,
162,64,208,128,163,0,128,163,0,64,161,64,208,137,157,5,12,0,64,152,64,208,
128,145,0,192,173,0,64,208,128,157,0,64,164,64,208,128,154,0,73,173,13,
24,64,208,136,161,4,0,128,156,0,64,168,64,208,64,149,64,208,128,152,0,64,
174,64,208,64,166,64,208,64,152,64,208,64,157,64,208,128,154,0,74,165,123,
19,199,64,208,73,159,13,72,64,208,136,163,4,0,128,154,0,137,154,5,42,0,
201,148,27,34,0,64,208,136,159,4,0,192,152,0,64,208,64,156,64,208,64,161,
64,208,128,165,0,64,145,64,208,128,154,0,128,152,0,200,158,9,0,64,208,128,
146,0,192,155,0,64,208,128,150,0,73,162,13,33,64,208,136,162,4,0,128,159,
0,200,161,13,0,64,208,64,161,64,208,128,158,0,64,160,64,208,128,160,0,136,
167,4,0,64,164,64,208,128,148,0,210,161,6,183,15,167,0,64,208,74,158,186,
3,242,64,208,73,157,25,132,64,208,72,162,8,64,208,128,152,0,64,152,64,208,
64,154,64,208,128,144,0,201,152,35,71,0,64,208,73,152,9,21,64,208,128,163,
0,200,151,9,0,64,208,128,144,0,128,145,0,136,163,4,0,128,160,0,201,148,
10,21,0,64,208,128,163,0,64,146,64,208,136,162,4,0,128,154,0,64,151,64,
208,137,148,5,8,0,128,146,0,128,162,0,73,155,9,25,64,208,128,164,0,64,154,
64,208,192,163,0,64,208,64,159,64,208,128,173,0,64,156,64,208,64,161,64,
208,128,173,0,73,163,9,28,64,208,128,159,0,137,159,5,12,0,64,158,64,208,
128,148,0,64,162,64,208,128,159,0,72,173,12,64,208,136,160,4,0,128,152,
0,64,165,64,208,128,165,0,74,150,10,1,87,64,208,128,163,0,73,147,33,226,
64,208,137,161,5,16,0,137,158,5,8,0,128,156,0,128,159,0,137,163,5,8,0,128,
162,0,128,173,0,201,145,111,135,0,64,208,73,152,9,24,64,208,128,161,0,137,
148,5,8,0,128,144,0,64,151,64,208,128,158,0,73,158,69,72,64,208,73,162,
21,48,64,208,64,154,64,208,64,144,64,208,64,157,64,208,128,172,0,136,157,
4,0,64,154,64,208,64,144,64,208,64,160,64,208,64,162,64,208,64,158,64,208,
128,157,0,64,168,64,208,64,157,64,208,64,163,64,208,128,160,0,128,154,0,
192,160,0,64,208,128,164,0,64,144,64,208,73,158,9,17,64,208,128,144,0,192,
154,0,64,208,128,160,0,128,160,0,192,146,0,64,208,73,152,9,16,64,208,128,
175,0,136,151,4,0,128,148,0,200,158,17,0,64,208,64,156,64,208,64,149,64,
208,128,148,0,192,154,0,64,208,137,160,5,8,0,128,145,0,64,163,64,208,128,
152,0,72,149,8,64,208,128,144,0,64,148,64,208,73,158,9,62,64,208,128,163,
0,73,149,13,20,64,208,64,156,64,208,128,158,0,136,148,4,0,128,147,0,72,
157,8,64,208,128,160,0,192,154,0,64,208,73,152,9,12,64,208,128,163,0,128,
151,0,192,163,0,64,208,128,146,0,201,162,10,17,0,64,208,128,163,0,136,160,
4,0,128,159,0,72,173,8,64,208,128,148,0,192,163,0,64,208,128,148,0,74,154,
245,1,105,64,208,137,155,5,96,0,73,147,9,40,64,208,128,148,0,73,145,13,
28,64,208,64,157,64,208,128,163,0,72,144,8,64,208,128,146,0,64,134,64,208,
128,158,0,128,146,0,73,152,21,40,64,208,137,148,5,8,0,128,145,0,64,162,
64,208,128,162,0,72,151,8,64,208,128,144,0,64,148,64,208,136,162,4,0,128,
160,0,64,154,64,208,136,173,4,0,128,146,0,73,161,9,82,64,208,128,156,0,
201,159,14,62,0,64,208,136,161,4,0,128,146,0,72,158,45,64,208,73,157,13,
24,64,208,64,154,64,208,128,158,0,72,156,8,64,208,128,159,0,128,149,0,136,
161,4,0,192,159,0,64,208,136,156,4,0,128,146,0,128,157,0,64,160,64,208,
136,158,4,0,128,145,0,73,163,38,53,64,208,73,159,9,16,64,208,128,173,0,
136,148,4,0,128,147,0,200,173,9,0,64,208,128,160,0,64,162,64,208,128,173,
0,64,162,64,208,137,159,5,8,0,128,145,0,128,162,0,64,168,64,208,128,144,
0,200,152,93,0,64,208,73,158,13,64,64,208,64,159,64,208,128,154,0,73,148,
17,28,64,208,72,157,8,64,208,128,160,0,128,154,0,136,146,4,0,64,145,64,
208,128,162,0,72,157,16,64,208,64,154,64,208,64,158,64,208,128,156,0,64,
152,64,208,128,163,0,137,162,5,16,0,72,160,8,64,208,128,152,0,128,159,0,
136,166,4,0,128,163,0,64,151,64,208,137,154,5,16,0,136,152,4,0,64,144,64,
208,128,144,0,128,157,0,72,157,52,64,208,137,161,5,36,0,137,154,5,8,0,128,
152,0,64,158,64,208,73,158,9,16,64,208,128,160,0,64,146,64,208,128,144,
0,128,163,0,136,163,4,0,64,162,64,208,128,152,0,64,156,64,208,73,158,13,
45,64,208,136,160,4,0,128,154,0,73,152,9,29,64,208,128,161,0,200,145,9,
0,64,208,128,160,0,64,144,64,208,136,160,4,0,128,159,0,128,156,0,137,161,
5,16,0,72,160,8,64,208,128,159,0,128,159,0,128,162,0,202,164,39,2,79,0,
64,208,137,160,5,16,0,137,154,5,8,0,128,149,0,128,158,0,137,162,5,8,0,128,
161,0,64,173,64,208,128,163,0,73,161,91,242,64,208,201,160,14,54,0,64,208,
64,157,64,208,128,159,0,137,156,5,17,0,136,148,4,0,192,144,0,64,208,128,
148,0,64,158,64,208,137,162,5,8,0,128,152,0,64,163,64,208,64,159,64,208,
128,158,0,73,168,9,24,64,208,128,156,0,72,163,8,64,208,128,151,0,64,161,
64,208,128,144,0,64,173,64,208,128,162,0,200,160,43,0,64,208,137,157,5,
30,0,200,154,14,0,64,208,192,161,0,64,208,128,163,0,64,147,64,208,64,158,
64,208,128,144,0,64,173,64,208,128,159,0,64,159,64,208,201,158,10,53,0,
64,208,128,157,0,73,154,13,28,64,208,64,161,64,208,128,151,0,137,147,5,
8,0,128,134,0,64,148,64,208,128,151,0,136,157,4,0,64,156,64,208,64,158,
64,208,128,158,0,73,162,17,40,64,208,137,159,5,8,0,128,148,0,128,160,0,
73,160,13,16,64,208,64,175,64,208,128,155,0,128,159,0,64,161,64,208,128,
148,0,136,173,4,0,64,167,64,208,128,157,0,200,163,202,0,64,208,73,158,9,
95,64,208,128,159,0,73,150,9,57,64,208,128,162,0,73,147,9,37,64,208,128,
161,0,200,146,13,0,64,208,136,158,4,0,128,148,0,64,145,64,208,137,159,5,
8,0,128,148,0,128,161,0,64,148,64,208,136,159,4,0,128,148,0,201,156,18,
21,0,64,208,137,162,5,8,0,128,158,0,128,166,0,128,151,0,192,157,0,64,208,
128,158,0,73,162,9,57,64,208,128,159,0,73,160,21,41,64,208,137,147,5,8,
0,128,146,0,64,173,64,208,128,158,0,192,159,0,64,208,137,161,5,12,0,136,
159,4,0,128,146,0,128,162,0,64,161,64,208,128,173,0,73,164,21,37,64,208,
137,160,5,8,0,128,152,0,64,165,64,208,128,148,0,192,163,0,64,208,136,159,
4,0,64,157,64,208,128,154,0,64,173,64,208,128,160,0,64,162,64,208,73,156,
13,60,64,208,64,161,64,208,128,163,0,137,148,5,40,0,136,146,4,0,64,144,
64,208,64,155,64,208,64,144,64,208,64,146,64,208,64,152,64,208,64,161,64,
208,64,162,64,208,128,144,0,64,155,64,208,128,163,0,73,163,13,24,64,208,
136,173,4,0,128,161,0,136,162,4,0,64,159,64,208,128,159,0,192,173,0,64,
208,136,161,4,0,64,154,64,208,64,158,64,208,128,156,0,73,168,9,49,64,208,
128,163,0,200,166,13,0,64,208,136,158,4,0,128,157,0,64,165,64,208,137,154,
5,20,0,72,152,12,64,208,64,159,64,208,128,160,0,128,146,0,128,165,0,72,
175,8,64,208,128,161,0,64,173,64,208,73,156,9,33,64,208,128,159,0,137,152,
5,17,0,200,148,9,0,64,208,128,148,0,128,146,0,64,154,64,208,128,158,0,137,
160,5,8,0,128,158,0,64,162,64,208,128,163,0,82,159,3,90,4,204,64,208,74,
156,59,1,163,64,208,73,154,9,37,64,208,128,162,0,73,148,18,21,64,208,200,
159,9,0,64,208,128,160,0,128,151,0,128,145,0,64,151,64,208,128,157,0,137,
159,5,8,0,128,158,0,64,161,64,208,128,145,0,73,149,9,143,64,208,128,164,
0,201,146,36,103,0,64,208,73,160,9,21,64,208,128,148,0,192,149,0,64,208,
64,155,64,208,128,158,0,192,162,0,64,208,128,157,0,73,144,33,44,64,208,
73,157,9,16,64,208,128,154,0,136,155,4,0,128,146,0,72,173,8,64,208,128,
161,0,128,165,0,64,134,64,208,64,162,64,208,128,163,0,64,145,64,208,137,
163,5,16,0,136,162,4,0,64,158,64,208,128,159,0,128,173,0,72,148,24,64,208,
73,163,9,12,64,208,128,160,0,128,154,0,64,165,64,208,128,164,0,64,147,64,
208,128,162,0,201,152,97,113,0,64,208,201,156,10,46,0,64,208,128,165,0,
73,148,9,16,64,208,128,157,0,136,147,4,0,128,145,0,200,154,13,0,64,208,
64,158,64,208,128,157,0,64,152,64,208,128,162,0,73,162,9,24,64,208,128,
163,0,72,160,8,64,208,128,154,0,64,158,64,208,128,157,0,192,163,0,64,208,
64,156,64,208,64,174,64,208,64,160,64,208,128,164,0,200,151,9,0,64,208,
128,161,0,64,150,64,208,128,162,0,200,155,9,0,64,208,128,144,0,64,154,64,
208,73,158,9,56,64,208,128,160,0,73,152,21,32,64,208,136,162,4,0,64,159,
64,208,64,160,64,208,128,158,0,136,146,4,0,64,144,64,208,128,162,0,72,156,
8,64,208,128,154,0,64,155,64,208,128,154,0,73,161,9,20,64,208,128,156,0,
72,160,8,64,208,128,158,0,128,159,0,136,168,4,0,64,163,64,208,64,152,64,
208,128,162,0,202,163,31,1,85,0,64,208,73,152,13,16,64,208,64,161,64,208,
128,159,0,128,147,0,64,160,64,208,128,157,0,73,160,107,232,64,208,73,157,
13,61,64,208,64,161,64,208,128,159,0,73,152,17,32,64,208,136,156,4,0,64,
154,64,208,128,162,0,72,147,12,64,208,64,158,64,208,128,144,0,128,145,0,
136,156,4,0,192,154,0,64,208,64,161,64,208,128,157,0,201,164,14,29,0,64,
208,64,165,64,208,128,156,0,72,161,8,64,208,128,161,0,64,158,64,208,128,
154,0,72,175,8,64,208,128,156,0,128,173,0,73,158,21,28,64,208,72,160,12,
64,208,64,160,64,208,128,161,0,128,152,0,64,157,64,208,128,159,0,64,159,
64,208,73,155,9,62,64,208,128,159,0,137,151,5,20,0,73,146,9,12,64,208,128,
156,0,128,145,0,128,147,0,200,154,25,0,64,208,137,159,5,12,0,64,145,64,
208,128,165,0,64,163,64,208,128,159,0,192,152,0,64,208,128,156,0,137,161,
5,24,0,72,159,12,64,208,64,159,64,208,128,145,0,64,158,64,208,128,161,0,
136,163,4,0,128,162,0,72,162,12,64,208,136,164,4,0,128,146,0,192,161,0,
64,208,137,159,5,34,0,201,154,14,26,0,64,208,64,155,64,208,128,148,0,136,
150,4,0,192,145,0,64,208,128,154,0,128,157,0,73,162,17,24,64,208,64,156,
64,208,64,152,64,208,128,144,0,64,160,64,208,128,162,0,128,166,0,201,167,
22,47,0,64,208,73,152,9,12,64,208,128,164,0,128,147,0,128,162,0,200,165,
13,0,64,208,136,159,4,0,128,148,0,192,164,0,64,208,136,160,4,0,128,148,
0,72,174,12,64,208,136,160,4,0,128,154,0,64,173,64,208,137,159,5,16,0,136,
154,4,0,64,144,64,208,128,159,0,136,162,4,0,64,161,64,208,128,146,0,192,
158,0,64,208,201,157,22,187,0,64,208,137,160,5,8,0,128,145,0,64,161,64,
208,128,145,0,73,151,9,85,64,208,128,162,0,73,147,17,64,64,208,72,159,8,
64,208,128,160,0,128,154,0,72,146,40,64,208,137,158,5,16,0,137,148,5,8,
0,128,146,0,128,154,0,72,166,12,64,208,64,146,64,208,128,149,0,64,161,64,
208,128,149,0,64,145,64,208,128,161,0,192,148,0,64,208,64,154,64,208,128,
145,0,201,155,10,69,0,64,208,128,161,0,72,154,32,64,208,137,156,5,12,0,
136,152,4,0,128,145,0,136,162,4,0,64,158,64,208,136,148,4,0,128,145,0,64,
152,64,208,73,159,13,20,64,208,64,159,64,208,128,154,0,136,156,4,0,128,
145,0,128,161,0,64,156,64,208,136,173,4,0,128,151,0,73,162,9,101,64,208,
128,161,0,73,160,21,56,64,208,72,160,12,64,208,64,156,64,208,128,159,0,
128,156,0,72,159,28,64,208,137,159,5,12,0,136,157,4,0,128,154,0,136,162,
4,0,64,161,64,208,128,149,0,64,158,64,208,128,162,0,192,161,0,64,208,137,
154,5,20,0,137,146,5,12,0,64,145,64,208,128,161,0,128,148,0,137,159,5,8,
0,128,158,0,128,161,0,201,166,38,65,0,64,208,73,160,9,24,64,208,128,159,
0,72,159,8,64,208,128,154,0,64,156,64,208,128,159,0,64,173,64,208,128,173,
0,72,165,12,64,208,136,154,4,0,128,146,0,64,164,64,208,64,158,64,208,64,
156,64,208,128,161,0,64,173,64,208,192,152,0,64,208,128,173,0,64,160,64,
208,74,157,23,2,54,64,208,200,163,13,0,64,208,64,146,64,208,128,158,0,128,
160,0,201,149,19,246,0,64,208,192,156,0,64,208,64,151,64,208,128,154,0,
73,146,29,138,64,208,137,154,5,16,0,137,146,5,8,0,128,145,0,128,148,0,136,
162,4,0,128,156,0,73,144,45,60,64,208,73,161,17,32,64,208,64,161,64,208,
64,146,64,208,128,144,0,136,157,4,0,64,148,64,208,64,149,64,208,128,161,
0,136,163,4,0,128,162,0,64,134,64,208,64,164,64,208,64,160,64,208,128,163,
0,192,145,0,64,208,137,159,5,37,0,200,152,17,0,64,208,64,154,64,208,64,
158,64,208,128,157,0,64,144,64,208,64,154,64,208,64,158,64,208,128,156,
0,136,162,4,0,128,160,0,200,148,66,0,64,208,137,157,5,36,0,73,149,13,24,
64,208,64,154,64,208,128,158,0,136,146,4,0,64,144,64,208,128,156,0,64,152,
64,208,128,151,0,73,162,9,17,64,208,128,163,0,192,161,0,64,208,128,159,
0,64,173,64,208,128,154,0,64,147,64,208,73,161,9,16,64,208,128,157,0,136,
154,4,0,128,152,0,128,163,0,201,154,39,163,0,64,208,201,158,10,21,0,64,
208,128,160,0,72,156,8,64,208,128,159,0,128,145,0,136,166,4,0,64,159,64,
208,128,166,0,201,151,15,30,0,64,208,192,152,0,64,208,128,155,0,64,150,
64,208,72,151,8,64,208,128,161,0,128,147,0,64,152,64,208,73,158,13,45,64,
208,64,157,64,208,128,158,0,201,151,10,25,0,64,208,128,158,0,72,150,8,64,
208,128,154,0,64,147,64,208,128,152,0,136,157,4,0,128,156,0,137,163,5,33,
0,72,161,12,64,208,64,152,64,208,128,156,0,192,159,0,64,208,72,159,8,64,
208,128,161,0,128,154,0,64,164,64,208,192,160,0,64,208,128,163,0,200,156,
115,0,64,208,73,152,13,61,64,208,136,162,4,0,128,154,0,73,149,9,40,64,208,
128,151,0,136,145,4,0,64,144,64,208,72,154,12,64,208,64,158,64,208,128,
156,0,64,146,64,208,64,152,64,208,128,144,0,192,151,0,64,208,128,154,0,
137,165,5,37,0,72,161,16,64,208,72,161,8,64,208,128,160,0,128,159,0,192,
158,0,64,208,64,154,64,208,64,158,64,208,128,156,0,64,173,64,208,64,158,
64,208,128,158,0,64,155,64,208,136,154,4,0,64,147,64,208,64,161,64,208,
128,157,0,74,164,30,1,123,64,208,137,159,5,16,0,72,152,8,64,208,128,161,
0,128,148,0,64,173,64,208,128,152,0,73,161,53,225,64,208,73,156,9,36,64,
208,128,152,0,136,155,4,0,64,152,64,208,137,158,5,16,0,72,157,8,64,208,
128,162,0,128,152,0,128,159,0,72,173,8,64,208,128,159,0,128,161,0,73,159,
82,165,64,208,137,159,5,56,0,201,152,10,26,0,64,208,128,154,0,200,145,9,
0,64,208,128,159,0,64,144,64,208,128,162,0,200,158,13,0,64,208,64,152,64,
208,128,161,0,192,156,0,64,208,64,162,64,208,128,154,0,137,165,5,17,0,136,
162,4,0,192,161,0,64,208,128,161,0,128,166,0,64,158,64,208,73,159,9,60,
64,208,128,161,0,73,152,13,20,64,208,64,150,64,208,128,154,0,64,145,64,
208,128,158,0,64,156,64,208,136,152,4,0,64,144,64,208,64,156,64,208,64,
144,64,208,64,161,64,208,64,155,64,208,128,144,0,73,165,9,12,64,208,128,
160,0,128,161,0,64,167,64,208,128,160,0,64,160,64,208,128,154,0,200,163,
37,0,64,208,137,154,5,16,0,136,151,4,0,64,146,64,208,128,148,0,64,162,64,
208,64,149,64,208,64,158,64,208,128,151,0,64,162,64,208,73,159,21,52,64,
208,136,159,4,0,64,158,64,208,64,155,64,208,128,154,0,136,158,4,0,64,155,
64,208,64,149,64,208,64,145,64,208,64,149,64,208,64,148,64,208,64,149,64,
208,128,146,0,136,166,4,0,64,161,64,208,64,154,64,208,64,146,64,208,64,
144,64,208,64,150,64,208,64,152,64,208,128,157,0,73,168,9,96,64,208,128,
163,0,73,166,13,80,64,208,64,148,64,208,128,158,0,64,165,64,208,72,157,
20,64,208,64,152,64,208,64,152,64,208,64,161,64,208,128,165,0,64,156,64,
208,64,158,64,208,64,160,64,208,64,162,64,208,64,158,64,208,64,160,64,208,
64,147,64,208,64,159,64,208,64,158,64,208,64,160,64,208,128,162,0,64,167,
64,208,128,149,0,72,173,12,64,208,136,156,4,0,128,154,0,128,169,0,82,163,
1,60,2,134,64,208,73,158,25,170,64,208,73,159,9,16,64,208,128,161,0,64,
157,64,208,128,150,0,128,161,0,73,150,9,80,64,208,128,148,0,201,146,27,
51,0,64,208,73,149,9,12,64,208,128,160,0,128,148,0,192,159,0,64,208,128,
161,0,200,145,9,0,64,208,128,144,0,64,144,64,208,72,161,8,64,208,128,159,
0,128,159,0,72,148,12,64,208,64,173,64,208,128,148,0,192,147,0,64,208,128,
159,0,73,154,22,54,64,208,137,151,5,13,0,192,145,0,64,208,128,163,0,128,
154,0,72,152,25,64,208,200,159,13,0,64,208,64,152,64,208,128,154,0,64,146,
64,208,128,159,0,64,151,64,208,128,154,0,64,156,64,208,64,159,64,208,128,
162,0,137,163,5,90,0,73,161,14,70,64,208,192,161,0,64,208,128,156,0,72,
160,24,64,208,137,145,5,12,0,64,134,64,208,128,163,0,64,152,64,208,128,
163,0,192,159,0,64,208,137,161,5,24,0,72,160,8,64,208,128,145,0,64,159,
64,208,64,160,64,208,128,145,0,128,167,0,64,162,64,208,137,146,5,8,0,128,
145,0,128,166,0,73,173,17,45,64,208,64,155,64,208,64,145,64,208,128,163,
0,200,166,9,0,64,208,128,144,0,64,164,64,208,73,160,9,12,64,208,128,163,
0,128,152,0,128,162,0,128,175,0,64,162,64,208,73,156,13,168,64,208,64,146,
64,208,128,145,0,73,149,21,78,64,208,72,160,12,64,208,64,158,64,208,128,
146,0,128,155,0,201,146,10,46,0,64,208,128,154,0,200,145,9,0,64,208,128,
163,0,64,144,64,208,72,160,8,64,208,128,162,0,64,159,64,208,64,160,64,208,
64,175,64,208,128,155,0,64,148,64,208,136,162,4,0,128,159,0,73,154,9,70,
64,208,128,154,0,200,152,45,0,64,208,73,160,21,32,64,208,64,159,64,208,
136,165,4,0,64,152,64,208,128,165,0,136,156,4,0,64,146,64,208,128,162,0,
64,161,64,208,128,161,0,64,151,64,208,136,162,4,0,192,161,0,64,208,128,
162,0,64,155,64,208,128,144,0,201,161,34,94,0,64,208,137,161,5,20,0,73,
152,9,12,64,208,128,173,0,128,150,0,128,158,0,136,166,4,0,128,163,0,73,
159,37,52,64,208,137,160,5,20,0,72,157,8,64,208,128,148,0,64,152,64,208,
128,159,0,136,164,4,0,64,161,64,208,128,154,0,72,158,12,64,208,136,159,
4,0,128,158,0,128,157,0,192,160,0,64,208,128,159,0,137,166,5,36,0,72,164,
20,64,208,73,151,9,12,64,208,128,156,0,128,145,0,128,154,0,64,162,64,208,
136,161,4,0,128,154,0,64,173,64,208,137,162,5,17,0,200,161,9,0,64,208,128,
152,0,128,156,0,136,166,4,0,128,163,0,64,164,64,208,73,159,37,137,64,208,
137,155,5,20,0,137,145,5,12,0,64,144,64,208,128,154,0,128,147,0,136,163,
4,0,64,156,64,208,128,159,0,73,149,9,64,64,208,128,161,0,73,146,9,36,64,
208,128,163,0,72,145,16,64,208,136,160,4,0,64,147,64,208,128,163,0,64,144,
64,208,136,161,4,0,128,160,0,72,148,8,64,208,128,162,0,64,147,64,208,64,
152,64,208,128,160,0,137,155,5,29,0,200,154,9,0,64,208,128,163,0,64,152,
64,208,72,159,8,64,208,128,161,0,128,154,0,64,157,64,208,128,156,0,73,164,
9,105,64,208,128,144,0,73,162,13,84,64,208,136,163,4,0,128,156,0,72,161,
24,64,208,137,156,5,16,0,72,154,8,64,208,128,145,0,128,145,0,128,159,0,
64,160,64,208,136,166,4,0,64,158,64,208,64,154,64,208,64,158,64,208,64,
161,64,208,64,152,64,208,64,167,64,208,72,154,8,64,208,128,152,0,64,149,
64,208,128,154,0,192,163,0,64,208,136,160,4,0,128,157,0,73,168,9,30,64,
208,128,154,0,72,167,8,64,208,128,165,0,192,165,0,64,208,192,148,0,64,208,
128,159,0,64,173,64,208,136,156,4,0,128,152,0,74,173,239,2,160,64,208,201,
159,10,111,0,64,208,128,154,0,73,152,17,46,64,208,137,160,5,8,0,128,157,
0,128,161,0,201,146,10,26,0,64,208,128,162,0,200,145,13,0,64,208,64,163,
64,208,128,160,0,128,144,0,128,148,0,73,157,29,44,64,208,73,159,9,20,64,
208,128,148,0,64,154,64,208,64,158,64,208,128,156,0,128,163,0,64,156,64,
208,64,145,64,208,64,145,64,208,128,162,0,64,158,64,208,64,155,64,208,128,
160,0,201,163,14,94,0,64,208,64,163,64,208,128,158,0,201,161,14,57,0,64,
208,136,154,4,0,128,144,0,64,160,64,208,64,158,64,208,72,162,20,64,208,
64,160,64,208,64,163,64,208,64,145,64,208,128,144,0,64,157,64,208,64,144,
64,208,64,162,64,208,128,166,0,64,162,64,208,137,161,5,12,0,136,159,4,0,
128,151,0,64,163,64,208,128,161,0,73,173,9,16,64,208,128,161,0,64,165,64,
208,128,154,0,64,174,64,208,136,154,4,0,128,152,0,74,167,97,1,134,64,208,
137,160,5,53,0,137,154,5,37,0,72,152,20,64,208,136,163,4,0,64,156,64,208,
64,161,64,208,128,165,0,192,147,0,64,208,64,144,64,208,128,144,0,136,157,
4,0,64,156,64,208,128,165,0,137,165,5,30,0,200,162,17,0,64,208,137,163,
5,8,0,128,146,0,128,167,0,192,161,0,64,208,128,154,0,64,173,64,208,128,
152,0,192,166,0,64,208,73,156,17,130,64,208,137,152,5,8,0,128,148,0,128,
162,0,73,149,9,76,64,208,128,165,0,73,147,21,48,64,208,137,154,5,8,0,128,
145,0,64,160,64,208,128,161,0,72,146,20,64,208,137,156,5,12,0,136,154,4,
0,128,152,0,128,161,0,64,145,64,208,128,154,0,64,148,64,208,137,162,5,12,
0,136,156,4,0,128,149,0,128,163,0,201,154,14,29,0,64,208,136,154,4,0,128,
145,0,72,152,8,64,208,128,144,0,64,150,64,208,128,147,0,192,155,0,64,208,
128,148,0,201,161,38,107,0,64,208,73,157,9,24,64,208,128,152,0,137,154,
5,8,0,128,147,0,64,156,64,208,128,161,0,136,162,4,0,128,161,0,201,159,22,
54,0,64,208,137,154,5,12,0,64,147,64,208,128,158,0,128,163,0,72,158,12,
64,208,64,158,64,208,128,157,0,64,157,64,208,72,162,8,64,208,128,152,0,
192,161,0,64,208,128,152,0,64,160,64,208,137,159,5,8,0,128,145,0,128,162,
0,73,166,9,40,64,208,128,159,0,72,164,8,64,208,128,152,0,64,162,64,208,
137,162,5,8,0,128,154,0,64,173,64,208,64,173,64,208,128,162,0,64,173,64,
208,64,162,64,208,128,159,0,64,168,64,208,73,162,9,28,64,208,128,160,0,
73,156,9,12,64,208,128,145,0,128,154,0,64,159,64,208,128,152,0,72,168,8,
64,208,128,152,0,128,164,0,72,175,40,64,208,137,160,5,16,0,137,154,5,8,
0,128,147,0,128,156,0,73,167,9,16,64,208,128,158,0,64,162,64,208,128,154,
0,128,173,0,64,174,64,208,137,162,5,16,0,136,160,4,0,64,151,64,208,128,
160,0,128,163,0,64,73,64,208,128,162,0,64,134,64,208,73,156,46,202,64,208,
201,162,10,29,0,64,208,128,159,0,72,149,8,64,208,128,156,0,64,146,64,208,
64,146,64,208,128,161,0,136,166,4,0,64,164,64,208,128,149,0,73,148,13,113,
64,208,64,159,64,208,128,163,0,73,146,13,76,64,208,64,145,64,208,128,147,
0,72,145,40,64,208,73,149,13,24,64,208,64,134,64,208,128,162,0,136,146,
4,0,64,134,64,208,128,161,0,64,161,64,208,64,149,64,208,128,148,0,64,134,
64,208,72,162,12,64,208,64,151,64,208,128,158,0,64,159,64,208,128,158,0,
64,147,64,208,201,155,10,17,0,64,208,128,161,0,64,134,64,208,128,156,0,
128,158,0,73,154,9,36,64,208,128,162,0,72,151,12,64,208,64,158,64,208,128,
148,0,64,149,64,208,64,161,64,208,136,163,4,0,128,154,0,64,155,64,208,128,
160,0,73,161,61,185,64,208,73,159,17,36,64,208,136,160,4,0,64,159,64,208,
128,160,0,137,148,5,8,0,128,134,0,64,151,64,208,64,151,64,208,128,134,0,
73,164,9,16,64,208,128,159,0,64,160,64,208,128,159,0,128,166,0,73,159,58,
97,64,208,73,159,9,32,64,208,128,158,0,73,156,13,20,64,208,64,156,64,208,
128,161,0,64,134,64,208,128,162,0,128,157,0,200,161,13,0,64,208,136,168,
4,0,128,148,0,64,160,64,208,128,134,0,72,158,12,64,208,136,166,4,0,128,
145,0,64,157,64,208,73,148,9,16,64,208,128,151,0,64,144,64,208,128,163,
0,64,162,64,208,128,158,0,64,160,64,208,73,157,9,16,64,208,128,154,0,64,
155,64,208,128,159,0,64,160,64,208,128,159,0,73,164,25,61,64,208,64,157,
64,208,64,162,64,208,64,163,64,208,64,157,64,208,128,147,0,72,163,20,64,
208,72,157,8,64,208,128,156,0,64,146,64,208,128,160,0,192,162,0,64,208,
137,162,5,8,0,128,154,0,128,163,0,64,165,64,208,137,164,5,8,0,128,161,0,
64,165,64,208,128,162,0,64,145,64,208,82,158,1,159,16,148,64,208,201,159,
26,244,0,64,208,137,159,5,12,0,136,158,4,0,128,151,0,64,165,64,208,128,
158,0,73,153,13,77,64,208,64,145,64,208,128,158,0,73,147,25,49,64,208,137,
162,5,12,0,64,144,64,208,128,151,0,64,173,64,208,128,161,0,200,146,9,0,
64,208,128,158,0,64,144,64,208,72,156,8,64,208,128,155,0,128,151,0,72,152,
8,64,208,128,160,0,64,151,64,208,128,159,0,73,157,25,101,64,208,73,156,
9,12,64,208,128,151,0,128,146,0,64,163,64,208,128,145,0,72,156,53,64,208,
201,161,10,33,0,64,208,128,173,0,73,157,13,16,64,208,64,152,64,208,128,
157,0,128,150,0,64,158,64,208,128,158,0,72,173,8,64,208,128,151,0,64,163,
64,208,128,154,0,64,154,64,208,137,154,5,16,0,136,151,4,0,64,145,64,208,
128,144,0,128,162,0,192,158,0,64,208,137,160,5,28,0,137,148,5,8,0,128,146,
0,64,159,64,208,72,164,8,64,208,128,175,0,128,145,0,136,164,4,0,128,162,
0,73,164,25,124,64,208,137,161,5,16,0,64,159,64,208,64,156,64,208,128,159,
0,128,164,0,73,162,25,92,64,208,137,159,5,8,0,128,150,0,64,161,64,208,64,
144,64,208,128,148,0,72,161,52,64,208,73,160,9,28,64,208,128,154,0,72,147,
8,64,208,128,152,0,64,146,64,208,64,144,64,208,128,168,0,72,173,12,64,208,
136,161,4,0,128,148,0,64,161,64,208,128,162,0,64,160,64,208,64,145,64,208,
64,152,64,208,128,166,0,64,163,64,208,128,159,0,73,173,17,32,64,208,72,
160,8,64,208,128,151,0,128,151,0,136,167,4,0,64,165,64,208,136,160,4,0,
128,151,0,64,174,64,208,128,155,0,74,150,39,8,83,64,208,201,163,10,25,0,
64,208,128,154,0,73,160,9,12,64,208,128,154,0,128,148,0,128,161,0,136,173,
4,0,128,164,0,74,146,173,3,127,64,208,73,161,9,105,64,208,128,144,0,137,
155,5,56,0,137,152,5,44,0,64,146,64,208,73,158,13,32,64,208,64,154,64,208,
128,163,0,72,156,8,64,208,128,163,0,64,144,64,208,64,163,64,208,128,155,
0,128,163,0,64,154,64,208,128,161,0,201,158,14,33,0,64,208,64,154,64,208,
128,163,0,64,156,64,208,137,152,5,12,0,136,148,4,0,128,145,0,128,154,0,
64,160,64,208,128,151,0,73,165,9,42,64,208,128,147,0,137,163,5,25,0,192,
162,0,64,208,64,154,64,208,136,163,4,0,64,154,64,208,128,163,0,192,164,
0,64,208,128,145,0,72,173,12,64,208,64,161,64,208,128,161,0,64,168,64,208,
128,148,0,82,144,2,66,2,81,64,208,74,158,18,1,13,64,208,137,161,5,8,0,128,
155,0,128,162,0,73,152,9,85,64,208,128,159,0,73,148,25,57,64,208,137,154,
5,16,0,64,144,64,208,64,156,64,208,128,152,0,128,159,0,72,147,16,64,208,
72,161,8,64,208,128,163,0,128,146,0,192,146,0,64,208,136,160,4,0,64,149,
64,208,128,159,0,72,151,16,64,208,64,173,64,208,64,155,64,208,128,149,0,
128,150,0,201,156,35,147,0,64,208,137,154,5,21,0,137,148,5,13,0,192,144,
0,64,208,128,159,0,128,151,0,136,173,4,0,128,160,0,72,155,92,64,208,72,
162,84,64,208,73,156,17,64,64,208,64,152,64,208,64,158,64,208,128,157,0,
64,152,64,208,64,157,64,208,72,164,8,64,208,128,158,0,64,146,64,208,64,
149,64,208,64,161,64,208,64,162,64,208,64,145,64,208,64,144,64,208,64,157,
64,208,128,154,0,64,164,64,208,64,155,64,208,64,158,64,208,128,162,0,128,
151,0,192,154,0,64,208,72,145,8,64,208,128,159,0,64,144,64,208,128,148,
0,64,157,64,208,136,158,4,0,64,145,64,208,64,144,64,208,128,161,0,73,163,
17,150,64,208,136,158,4,0,64,148,64,208,128,160,0,73,161,45,109,64,208,
73,160,9,24,64,208,128,151,0,72,145,8,64,208,128,159,0,64,144,64,208,128,
162,0,64,161,64,208,136,160,4,0,64,149,64,208,128,161,0,72,160,16,64,208,
136,151,4,0,64,147,64,208,128,163,0,64,159,64,208,137,155,5,24,0,137,146,
5,8,0,128,145,0,64,152,64,208,64,158,64,208,128,162,0,136,166,4,0,192,160,
0,64,208,72,175,8,64,208,128,155,0,128,164,0,192,162,0,64,208,137,156,5,
16,0,64,152,64,208,136,159,4,0,128,151,0,128,173,0,73,168,117,144,64,208,
73,157,33,68,64,208,64,149,64,208,64,164,64,208,64,162,64,208,64,149,64,
208,64,165,64,208,64,152,64,208,128,156,0,72,147,8,64,208,128,163,0,64,
146,64,208,64,162,64,208,64,158,64,208,64,160,64,208,64,156,64,208,64,149,
64,208,128,162,0,72,162,12,64,208,64,158,64,208,128,160,0,64,159,64,208,
64,160,64,208,64,158,64,208,64,156,64,208,64,145,64,208,64,144,64,208,64,
157,64,208,128,154,0,72,165,12,64,208,64,159,64,208,128,152,0,64,164,64,
208,64,158,64,208,64,160,64,208,128,161,0,64,173,64,208,128,161,0,64,134,
64,208,64,157,64,208,64,134,64,208,128,156,0,64,145,64,208,201,155,10,62,
0,64,208,128,144,0,137,150,5,36,0,73,145,9,20,64,208,128,161,0,64,144,64,
208,64,161,64,208,128,163,0,64,146,64,208,64,161,64,208,128,144,0,201,152,
10,13,0,64,208,128,156,0,128,151,0,128,154,0,201,160,10,43,0,64,208,128,
144,0,73,158,9,21,64,208,128,161,0,192,156,0,64,208,136,154,4,0,128,145,
0,192,159,0,64,208,136,154,4,0,128,149,0,201,162,14,17,0,64,208,136,163,
4,0,128,161,0,128,161,0,128,166,0,202,148,227,2,181,0,64,208,73,155,9,111,
64,208,128,154,0,73,149,9,53,64,208,128,163,0,137,145,5,28,0,72,144,8,64,
208,128,163,0,64,134,64,208,64,159,64,208,136,167,4,0,128,155,0,200,148,
13,0,64,208,136,164,4,0,128,161,0,128,147,0,73,152,17,37,64,208,136,160,
4,0,64,159,64,208,128,167,0,200,151,13,0,64,208,136,163,4,0,128,159,0,64,
150,64,208,128,148,0,192,154,0,64,208,136,162,4,0,128,161,0,201,162,22,
75,0,64,208,64,144,64,208,64,159,64,208,64,147,64,208,128,154,0,201,159,
18,45,0,64,208,137,162,5,8,0,128,158,0,128,163,0,72,158,20,64,208,64,158,
64,208,64,159,64,208,64,152,64,208,128,154,0,64,157,64,208,128,161,0,192,
160,0,64,208,128,146,0,201,165,10,25,0,64,208,128,168,0,72,164,8,64,208,
128,144,0,64,163,64,208,128,161,0,192,168,0,64,208,128,152,0,192,147,0,
64,208,73,157,17,220,64,208,136,162,4,0,64,152,64,208,128,152,0,137,148,
5,102,0,137,146,5,82,0,192,144,0,64,208,137,161,5,41,0,73,157,13,29,64,
208,64,162,64,208,128,148,0,200,156,13,0,64,208,64,155,64,208,128,152,0,
128,152,0,64,160,64,208,128,164,0,73,164,9,24,64,208,128,154,0,136,163,
4,0,64,162,64,208,136,163,4,0,128,148,0,64,173,64,208,128,154,0,64,147,
64,208,137,156,5,8,0,128,144,0,128,173,0,73,154,21,65,64,208,137,159,5,
12,0,64,150,64,208,128,162,0,128,162,0,64,152,64,208,137,161,5,25,0,72,
156,8,64,208,128,161,0,192,154,0,64,208,136,152,4,0,128,151,0,72,163,8,
64,208,128,146,0,64,162,64,208,128,144,0,64,156,64,208,137,154,5,25,0,200,
152,17,0,64,208,64,146,64,208,64,158,64,208,128,146,0,128,144,0,136,163,
4,0,128,159,0,73,162,54,147,64,208,73,160,9,37,64,208,128,154,0,137,152,
5,16,0,64,144,64,208,64,161,64,208,128,156,0,192,158,0,64,208,64,152,64,
208,128,145,0,72,165,8,64,208,128,152,0,128,163,0,73,159,50,65,64,208,137,
154,5,16,0,137,151,5,8,0,128,144,0,128,152,0,201,163,14,21,0,64,208,64,
152,64,208,128,156,0,64,159,64,208,128,154,0,64,173,64,208,128,154,0,64,
158,64,208,64,152,64,208,64,164,64,208,128,154,0,192,161,0,64,208,137,158,
5,12,0,136,157,4,0,128,144,0,136,161,4,0,64,159,64,208,128,144,0,73,164,
9,83,64,208,128,144,0,192,163,0,64,208,137,162,5,46,0,201,154,15,34,0,64,
208,192,152,0,64,208,128,152,0,64,152,64,208,136,160,4,0,64,144,64,208,
64,152,64,208,128,159,0,64,157,64,208,128,145,0,72,173,16,64,208,136,159,
4,0,64,152,64,208,128,159,0,64,164,64,208,128,154,0,64,173,64,208,136,163,
4,0,128,161,0,64,149,64,208,74,161,26,1,200,64,208,72,154,12,64,208,64,
158,64,208,128,156,0,64,152,64,208,128,154,0,74,157,62,1,163,64,208,72,
152,20,64,208,64,155,64,208,64,174,64,208,64,154,64,208,128,161,0,64,151,
64,208,64,144,64,208,64,155,64,208,64,172,64,208,64,148,64,208,64,149,64,
208,64,147,64,208,64,152,64,208,128,148,0,80,155,1,94,64,208,73,156,17,
197,64,208,64,144,64,208,64,159,64,208,128,158,0,73,150,9,145,64,208,128,
148,0,73,147,102,113,64,208,73,160,29,72,64,208,64,144,64,208,64,157,64,
208,64,154,64,208,64,158,64,208,64,160,64,208,128,156,0,72,152,24,64,208,
73,161,9,16,64,208,128,161,0,136,156,4,0,128,154,0,128,173,0,64,144,64,
208,64,151,64,208,64,149,64,208,64,162,64,208,128,144,0,200,163,9,0,64,
208,128,162,0,64,162,64,208,64,144,64,208,64,161,64,208,128,156,0,64,144,
64,208,136,174,4,0,128,151,0,64,148,64,208,64,158,64,208,64,160,64,208,
64,157,64,208,64,152,64,208,128,152,0,72,154,20,64,208,64,158,64,208,64,
156,64,208,64,163,64,208,128,160,0,64,152,64,208,64,152,64,208,64,150,64,
208,128,162,0,73,162,33,108,64,208,73,159,9,20,64,208,128,159,0,72,152,
8,64,208,128,151,0,128,144,0,64,173,64,208,128,154,0,72,158,28,64,208,73,
156,9,12,64,208,128,158,0,128,152,0,64,161,64,208,64,162,64,208,128,158,
0,64,157,64,208,64,152,64,208,72,166,12,64,208,64,173,64,208,128,148,0,
64,152,64,208,137,161,5,16,0,64,148,64,208,64,144,64,208,128,148,0,64,162,
64,208,128,158,0,72,166,24,64,208,64,157,64,208,72,156,8,64,208,128,152,
0,64,152,64,208,128,162,0,64,164,64,208,64,160,64,208,64,149,64,208,128,
151,0,64,145,64,208,128,161,0,64,160,64,208,64,162,64,208,128,152,0,201,
163,10,37,0,64,208,128,154,0,64,162,64,208,72,158,16,64,208,64,159,64,208,
64,158,64,208,128,155,0,64,144,64,208,128,145,0,64,164,64,208,128,158,0,
74,155,186,4,126,72,208,176,73,157,13,101,64,208,64,159,64,208,128,147,
0,73,152,13,65,64,208,64,154,64,208,128,161,0,73,147,9,41,64,208,128,160,
0,72,146,12,64,208,136,161,4,0,128,151,0,192,144,0,64,208,64,147,64,208,
64,145,64,208,64,144,64,208,128,151,0,64,148,64,208,136,164,4,0,128,160,
0,73,155,9,16,64,208,128,156,0,64,154,64,208,128,159,0,64,156,64,208,128,
151,0,73,162,9,44,64,208,128,145,0,73,160,9,28,64,208,128,161,0,64,159,
64,208,73,162,9,12,64,208,128,144,0,128,154,0,128,165,0,64,161,64,208,128,
173,0,201,173,10,21,0,64,208,128,161,0,64,163,64,208,64,147,64,208,128,
144,0,64,174,64,208,128,161,0,64,68,128,84,0,82,152,1,207,2,183,64,208,
73,158,17,229,64,208,64,164,64,208,64,144,64,208,128,154,0,73,152,49,140,
64,208,137,157,5,20,0,64,156,64,208,64,156,64,208,64,144,64,208,128,159,
0,64,175,64,208,72,156,8,64,208,128,161,0,64,152,64,208,64,156,64,208,128,
161,0,73,147,45,72,64,208,73,158,9,32,64,208,128,160,0,72,156,8,64,208,
128,163,0,64,145,64,208,64,158,64,208,64,160,64,208,128,148,0,64,163,64,
208,128,160,0,72,145,24,64,208,72,156,8,64,208,128,156,0,64,152,64,208,
64,161,64,208,128,152,0,128,144,0,64,151,64,208,64,154,64,208,136,162,4,
0,64,158,64,208,128,157,0,73,156,17,53,64,208,137,162,5,8,0,128,159,0,128,
166,0,192,154,0,64,208,73,158,13,20,64,208,136,160,4,0,128,156,0,136,152,
4,0,128,151,0,64,166,64,208,64,152,64,208,128,156,0,64,157,64,208,73,162,
9,12,64,208,128,152,0,128,161,0,128,165,0,201,163,14,154,0,64,208,136,161,
4,0,128,157,0,73,161,26,97,64,208,137,158,5,17,0,136,157,4,0,192,147,0,
64,208,128,160,0,128,162,0,72,160,48,64,208,137,158,5,36,0,73,147,17,20,
64,208,64,161,64,208,64,159,64,208,128,144,0,128,146,0,64,151,64,208,64,
161,64,208,128,162,0,136,166,4,0,128,159,0,64,159,64,208,137,162,5,16,0,
64,154,64,208,64,160,64,208,128,158,0,128,166,0,64,162,64,208,137,159,5,
20,0,136,156,4,0,64,145,64,208,64,158,64,208,128,152,0,136,166,4,0,64,162,
64,208,136,163,4,0,64,152,64,208,128,163,0,201,166,18,33,0,64,208,64,161,
64,208,64,158,64,208,128,162,0,64,164,64,208,136,154,4,0,64,152,64,208,
128,162,0,64,173,64,208,73,159,17,28,64,208,136,159,4,0,64,152,64,208,128,
159,0,137,152,5,8,0,128,145,0,128,156,0,136,164,4,0,128,162,0,64,151,64,
208,73,157,9,124,64,208,128,161,0,137,150,5,56,0,73,146,9,40,64,208,128,
156,0,72,145,16,64,208,137,158,5,8,0,128,154,0,128,159,0,64,144,64,208,
72,162,8,64,208,128,152,0,128,155,0,64,148,64,208,136,161,4,0,128,154,0,
73,155,9,40,64,208,128,156,0,72,154,24,64,208,73,159,9,16,64,208,128,148,
0,136,156,4,0,128,152,0,128,162,0,64,151,64,208,128,148,0,64,156,64,208,
137,154,5,8,0,128,152,0,64,162,64,208,128,158,0,73,162,29,81,64,208,137,
156,5,16,0,64,148,64,208,64,152,64,208,128,144,0,64,160,64,208,128,159,
0,73,160,13,41,64,208,136,159,4,0,128,152,0,72,159,20,64,208,137,156,5,
8,0,128,152,0,64,162,64,208,128,155,0,192,158,0,64,208,128,154,0,64,161,
64,208,136,162,4,0,128,154,0,73,165,9,16,64,208,128,154,0,136,164,4,0,128,
163,0,64,173,64,208,128,156,0,64,154,64,208,73,157,13,156,64,208,136,161,
4,0,128,155,0,73,150,9,85,64,208,128,162,0,73,147,13,56,64,208,136,160,
4,0,128,158,0,72,146,16,64,208,72,148,8,64,208,128,163,0,128,144,0,64,145,
64,208,73,158,9,16,64,208,128,159,0,136,157,4,0,128,145,0,64,161,64,208,
128,154,0,136,149,4,0,192,148,0,64,208,137,159,5,8,0,128,154,0,128,166,
0,201,154,10,22,0,64,208,128,159,0,200,152,9,0,64,208,128,163,0,128,151,
0,200,156,29,0,64,208,137,158,5,16,0,137,151,5,8,0,128,150,0,128,154,0,
136,163,4,0,128,161,0,64,155,64,208,128,156,0,73,163,9,90,64,208,128,163,
0,73,160,17,45,64,208,137,161,5,8,0,128,154,0,128,163,0,72,159,12,64,208,
136,159,4,0,128,151,0,192,158,0,64,208,136,159,4,0,64,146,64,208,128,160,
0,72,162,21,64,208,137,158,5,8,0,128,156,0,192,159,0,64,208,128,145,0,64,
161,64,208,137,155,5,8,0,128,154,0,128,156,0,137,168,5,16,0,136,167,4,0,
64,164,64,208,128,154,0,128,175,0,72,157,213,64,208,73,158,21,123,64,208,
137,157,5,12,0,136,154,4,0,128,144,0,128,159,0,73,151,9,42,64,208,128,162,
0,73,147,9,25,64,208,128,161,0,200,144,9,0,64,208,128,163,0,64,134,64,208,
128,159,0,192,148,0,64,208,128,163,0,73,155,9,53,64,208,128,144,0,72,154,
8,64,208,128,146,0,64,152,64,208,73,162,9,20,64,208,128,158,0,64,152,64,
208,64,161,64,208,128,165,0,192,166,0,64,208,64,162,64,208,128,158,0,64,
157,64,208,128,161,0,137,164,5,61,0,73,161,13,41,64,208,136,162,4,0,128,
160,0,200,160,17,0,64,208,136,161,4,0,64,146,64,208,128,162,0,64,159,64,
208,136,158,4,0,128,144,0,64,162,64,208,137,152,5,8,0,128,148,0,128,163,
0,73,167,9,21,64,208,128,161,0,136,166,4,0,192,165,0,64,208,128,154,0,128,
173,0,64,156,64,208,73,156,22,137,64,208,201,162,10,13,0,64,208,128,159,
0,128,154,0,128,166,0,73,150,9,84,64,208,128,154,0,73,146,26,58,64,208,
137,152,5,12,0,136,148,4,0,128,145,0,192,154,0,64,208,128,163,0,72,145,
12,64,208,136,160,4,0,128,154,0,64,144,64,208,200,161,13,0,64,208,64,161,
64,208,128,160,0,128,154,0,200,148,9,0,64,208,128,161,0,192,147,0,64,208,
128,166,0,73,154,9,24,64,208,128,154,0,72,152,12,64,208,136,162,4,0,128,
159,0,128,151,0,64,155,64,208,128,148,0,73,162,29,142,64,208,137,160,5,
16,0,137,158,5,8,0,128,154,0,128,159,0,136,162,4,0,128,161,0,201,159,30,
73,0,64,208,137,154,5,20,0,64,147,64,208,64,173,64,208,64,162,64,208,128,
161,0,128,162,0,72,158,32,64,208,73,158,13,20,64,208,64,161,64,208,128,
159,0,64,152,64,208,128,159,0,64,160,64,208,128,154,0,64,157,64,208,136,
163,4,0,128,159,0,72,161,16,64,208,137,163,5,8,0,128,154,0,128,173,0,192,
160,0,64,208,137,156,5,12,0,136,154,4,0,128,151,0,136,166,4,0,128,162,0,
73,166,17,44,64,208,72,173,8,64,208,128,152,0,128,161,0,136,164,4,0,64,
163,64,208,72,162,12,64,208,64,162,64,208,128,159,0,64,159,64,208,128,147,
0,192,173,0,64,208,128,161,0,202,166,107,7,204,0,64,208,73,154,9,48,64,
208,128,148,0,73,147,9,36,64,208,128,145,0,72,146,20,64,208,137,161,5,12,
0,136,156,4,0,128,154,0,128,163,0,64,145,64,208,128,154,0,128,151,0,73,
165,13,44,64,208,64,146,64,208,128,149,0,72,162,8,64,208,128,158,0,64,158,
64,208,137,156,5,16,0,64,147,64,208,64,154,64,208,128,150,0,128,162,0,64,
168,64,208,128,154,0,74,162,242,4,231,72,208,234,201,159,22,123,0,64,208,
137,161,5,12,0,64,152,64,208,128,159,0,128,165,0,137,149,5,28,0,73,147,
9,20,64,208,128,160,0,72,144,8,64,208,128,154,0,128,134,0,128,148,0,201,
156,22,66,0,64,208,73,158,9,12,64,208,128,148,0,128,154,0,128,163,0,200,
152,37,0,64,208,73,159,9,20,64,208,128,145,0,136,151,4,0,64,146,64,208,
128,162,0,136,173,4,0,64,161,64,208,128,156,0,64,150,64,208,128,162,0,64,
158,64,208,128,164,0,73,164,17,54,64,208,64,158,64,208,64,156,64,208,128,
161,0,201,162,14,30,0,64,208,136,161,4,0,128,152,0,200,161,9,0,64,208,128,
160,0,64,160,64,208,128,151,0,64,163,64,208,128,158,0,137,168,5,25,0,200,
166,13,0,64,208,64,160,64,208,128,154,0,64,165,64,208,128,146,0,192,173,
0,64,208,137,162,5,12,0,136,158,4,0,128,154,0,192,163,0,64,208,64,159,64,
208,128,154,0,128,73,0,82,160,1,226,2,212,64,208,73,157,13,236,64,208,136,
161,4,0,128,145,0,73,148,21,125,64,208,137,156,5,8,0,128,148,0,64,159,64,
208,128,158,0,73,145,9,73,64,208,128,151,0,72,144,57,64,208,137,159,5,29,
0,201,151,10,13,0,64,208,128,144,0,128,146,0,64,156,64,208,64,158,64,208,
128,161,0,72,174,8,64,208,128,154,0,64,161,64,208,64,159,64,208,64,158,
64,208,128,162,0,64,134,64,208,128,154,0,72,147,24,64,208,137,163,5,12,
0,64,162,64,208,128,163,0,64,166,64,208,128,164,0,64,146,64,208,128,151,
0,73,154,13,69,64,208,136,164,4,0,128,144,0,72,152,49,64,208,201,152,10,
33,0,64,208,128,154,0,64,147,64,208,64,144,64,208,64,148,64,208,64,156,
64,208,64,152,64,208,128,155,0,64,154,64,208,64,158,64,208,128,156,0,64,
151,64,208,128,147,0,200,156,17,0,64,208,137,151,5,8,0,128,148,0,128,158,
0,192,155,0,64,208,136,161,4,0,128,154,0,201,163,22,145,0,64,208,72,161,
8,64,208,128,159,0,64,154,64,208,128,154,0,137,160,5,64,0,72,159,36,64,
208,137,159,5,16,0,137,155,5,8,0,128,154,0,128,158,0,72,166,8,64,208,128,
157,0,64,161,64,208,128,161,0,64,158,64,208,73,158,13,16,64,208,64,158,
64,208,128,158,0,128,154,0,128,163,0,200,162,34,0,64,208,201,159,14,21,
0,64,208,136,166,4,0,128,159,0,136,152,4,0,128,144,0,136,162,4,0,128,161,
0,192,161,0,64,208,201,148,10,17,0,64,208,128,159,0,64,145,64,208,128,161,
0,128,156,0,73,166,17,56,64,208,136,154,4,0,64,152,64,208,128,154,0,72,
165,12,64,208,64,161,64,208,128,161,0,64,164,64,208,137,161,5,16,0,72,156,
8,64,208,128,154,0,128,154,0,64,164,64,208,128,152,0,192,173,0,64,208,137,
158,5,20,0,137,152,5,8,0,128,144,0,64,155,64,208,128,155,0,136,166,4,0,
192,161,0,64,208,128,159,0,192,159,0,64,208,137,156,5,105,0,73,148,9,68,
64,208,128,159,0,73,146,25,48,64,208,136,161,4,0,64,155,64,208,64,157,64,
208,64,159,64,208,128,147,0,72,145,8,64,208,128,154,0,64,144,64,208,72,
162,8,64,208,128,159,0,128,161,0,64,147,64,208,136,163,4,0,128,154,0,73,
152,13,24,64,208,64,157,64,208,128,164,0,136,151,4,0,64,150,64,208,128,
162,0,192,154,0,64,208,128,144,0,73,161,25,89,64,208,137,157,5,16,0,136,
156,4,0,64,146,64,208,128,162,0,128,158,0,73,159,17,48,64,208,137,159,5,
8,0,128,147,0,128,163,0,72,158,12,64,208,64,146,64,208,128,166,0,64,157,
64,208,73,159,9,12,64,208,128,147,0,128,154,0,128,164,0,64,160,64,208,136,
161,4,0,192,156,0,64,208,128,155,0,73,165,9,36,64,208,128,158,0,136,164,
4,0,64,162,64,208,72,158,16,64,208,64,152,64,208,64,154,64,208,128,158,
0,128,147,0,64,173,64,208,128,154,0,192,161,0,64,208,73,157,9,143,64,208,
128,157,0,73,150,13,77,64,208,136,154,4,0,128,146,0,73,146,21,49,64,208,
137,160,5,12,0,136,147,4,0,128,146,0,128,162,0,72,145,20,64,208,72,161,
12,64,208,64,159,64,208,128,144,0,128,151,0,192,144,0,64,208,128,156,0,
64,148,64,208,137,154,5,8,0,128,147,0,128,159,0,201,154,18,26,0,64,208,
137,148,5,8,0,128,146,0,128,151,0,192,151,0,64,208,128,160,0,64,156,64,
208,137,159,5,16,0,72,157,8,64,208,128,160,0,128,151,0,136,173,4,0,64,162,
64,208,128,161,0,73,162,29,130,64,208,73,157,9,16,64,208,128,146,0,136,
156,4,0,128,146,0,64,161,64,208,128,145,0,201,160,26,78,0,64,208,137,151,
5,12,0,136,150,4,0,128,147,0,136,164,4,0,128,157,0,72,159,32,64,208,137,
158,5,20,0,73,154,9,12,64,208,128,144,0,128,148,0,128,157,0,136,162,4,0,
128,161,0,192,158,0,64,208,72,158,12,64,208,64,160,64,208,128,161,0,128,
148,0,64,161,64,208,137,160,5,12,0,136,158,4,0,128,154,0,64,161,64,208,
128,160,0,137,164,5,8,0,128,163,0,128,173,0,202,164,197,2,24,0,64,208,73,
159,34,120,64,208,137,154,5,25,0,200,147,13,0,64,208,64,162,64,208,128,
163,0,64,145,64,208,128,150,0,128,159,0,201,154,22,54,0,64,208,137,159,
5,12,0,64,145,64,208,128,154,0,128,161,0,73,146,17,29,64,208,137,154,5,
8,0,128,152,0,128,161,0,192,144,0,64,208,136,157,4,0,128,152,0,128,151,
0,201,156,14,25,0,64,208,136,161,4,0,128,144,0,64,155,64,208,136,145,4,
0,128,144,0,64,157,64,208,128,165,0,137,164,5,54,0,201,161,26,41,0,64,208,
137,159,5,16,0,136,158,4,0,64,147,64,208,128,163,0,128,161,0,64,160,64,
208,136,151,4,0,64,147,64,208,128,162,0,192,162,0,64,208,128,161,0,72,173,
12,64,208,136,154,4,0,128,144,0,128,165,0,192,163,0,64,208,73,160,13,153,
64,208,136,161,4,0,128,157,0,73,152,21,76,64,208,137,159,5,12,0,64,144,
64,208,128,160,0,128,161,0,73,146,17,48,64,208,72,173,8,64,208,128,161,
0,128,160,0,72,145,8,64,208,128,148,0,64,144,64,208,73,146,9,12,64,208,
128,160,0,128,144,0,64,152,64,208,128,144,0,64,148,64,208,128,151,0,73,
158,9,40,64,208,128,154,0,72,157,8,64,208,128,161,0,64,156,64,208,72,156,
12,64,208,64,144,64,208,128,168,0,64,152,64,208,128,145,0,192,159,0,64,
208,137,158,5,12,0,136,157,4,0,128,154,0,136,162,4,0,128,161,0,73,165,102,
154,64,208,72,163,37,64,208,72,167,13,64,208,192,149,0,64,208,128,162,0,
64,161,64,208,64,155,64,208,64,163,64,208,64,147,64,208,128,152,0,64,158,
64,208,64,145,64,208,72,161,40,64,208,64,155,64,208,64,163,64,208,64,150,
64,208,64,152,64,208,64,146,64,208,64,144,64,208,64,157,64,208,64,152,64,
208,128,149,0,64,155,64,208,64,134,64,208,128,154,0,201,163,14,45,0,64,
208,64,160,64,208,128,147,0,72,162,16,64,208,137,162,5,8,0,128,145,0,128,
166,0,64,161,64,208,137,157,5,8,0,128,146,0,128,159,0,64,164,64,208,128,
158,0,73,168,9,16,64,208,128,148,0,64,166,64,208,128,151,0,64,173,64,208,
136,161,4,0,128,159,0,64,165,64,208,201,156,10,58,0,64,208,128,162,0,73,
147,13,32,64,208,64,159,64,208,128,167,0,72,146,16,64,208,136,162,4,0,64,
146,64,208,128,162,0,128,144,0,136,154,4,0,192,148,0,64,208,136,159,4,0,
128,151,0,73,163,9,28,64,208,128,166,0,72,162,12,64,208,64,156,64,208,128,
156,0,64,160,64,208,128,144,0,192,164,0,64,208,128,151,0,74,173,202,1,39,
64,208,201,159,26,118,0,64,208,137,159,5,12,0,136,154,4,0,128,152,0,64,
163,64,208,128,161,0,73,154,9,45,64,208,128,156,0,73,151,13,29,64,208,64,
160,64,208,128,154,0,192,144,0,64,208,136,158,4,0,64,147,64,208,128,156,
0,64,152,64,208,128,151,0,73,156,21,36,64,208,137,161,5,12,0,136,158,4,
0,128,151,0,128,162,0,64,155,64,208,72,156,8,64,208,128,151,0,128,151,0,
64,157,64,208,136,159,4,0,128,151,0,137,164,5,54,0,201,161,35,42,0,64,208,
201,156,10,25,0,64,208,128,159,0,72,154,12,64,208,64,152,64,208,128,162,
0,128,151,0,128,159,0,64,160,64,208,128,154,0,64,162,64,208,128,158,0,73,
173,9,12,64,208,128,156,0,128,166,0,64,174,64,208,136,162,4,0,128,155,0,
73,168,62,86,64,208,137,158,5,29,0,137,152,5,17,0,136,148,4,0,192,147,0,
64,208,128,154,0,136,155,4,0,128,154,0,73,164,9,24,64,208,128,164,0,72,
161,8,64,208,128,163,0,64,159,64,208,128,148,0,128,173,0,192,167,0,64,208,
137,165,5,16,0,72,162,8,64,208,128,159,0,128,160,0,128,173,0,64,169,64,
208,128,163,0,72,175,16,64,208,136,161,4,0,64,160,64,208,128,161,0,64,174,
64,208,73,160,9,16,64,208,128,156,0,136,152,4,0,128,144,0,128,162,0,82,
148,29,61,75,103,64,208,82,158,2,226,19,93,64,208,73,156,33,205,64,208,
73,150,13,20,64,208,64,163,64,208,128,160,0,64,145,64,208,128,162,0,64,
160,64,208,128,163,0,73,148,9,88,64,208,128,157,0,73,146,17,72,64,208,136,
166,4,0,64,161,64,208,128,149,0,72,145,44,64,208,73,148,9,16,64,208,128,
148,0,64,146,64,208,128,155,0,64,160,64,208,64,158,64,208,64,164,64,208,
64,155,64,208,64,158,64,208,128,162,0,64,144,64,208,136,161,4,0,128,158,
0,64,147,64,208,128,156,0,73,154,41,64,64,208,73,158,9,16,64,208,128,157,
0,136,157,4,0,128,145,0,72,162,12,64,208,64,156,64,208,128,158,0,64,161,
64,208,128,152,0,64,151,64,208,137,151,5,16,0,64,144,64,208,64,154,64,208,
128,155,0,128,157,0,192,155,0,64,208,64,152,64,208,64,164,64,208,64,156,
64,208,128,159,0,74,161,70,1,225,64,208,137,148,5,48,0,72,146,8,64,208,
128,149,0,64,144,64,208,73,147,9,20,64,208,128,158,0,136,146,4,0,64,144,
64,208,128,164,0,136,164,4,0,64,160,64,208,128,156,0,72,158,8,64,208,128,
150,0,64,157,64,208,128,159,0,74,159,74,1,104,64,208,73,161,41,60,64,208,
64,158,64,208,64,147,64,208,64,155,64,208,64,144,64,208,64,168,64,208,64,
149,64,208,64,157,64,208,64,152,64,208,128,175,0,73,157,9,12,64,208,128,
146,0,128,156,0,64,158,64,208,128,147,0,136,166,4,0,128,162,0,72,158,60,
64,208,137,157,5,28,0,137,154,5,16,0,137,147,5,8,0,128,145,0,128,152,0,
136,156,4,0,128,155,0,137,161,5,12,0,136,159,4,0,128,158,0,136,166,4,0,
64,163,64,208,64,161,64,208,128,156,0,64,157,64,208,73,154,29,126,64,208,
64,158,64,208,64,156,64,208,64,145,64,208,64,144,64,208,64,157,64,208,128,
154,0,201,148,14,86,0,64,208,64,163,64,208,128,163,0,72,147,57,64,208,73,
162,9,36,64,208,128,163,0,72,152,12,64,208,64,152,64,208,128,152,0,64,144,
64,208,136,163,4,0,64,161,64,208,128,144,0,192,163,0,64,208,72,173,8,64,
208,128,162,0,128,163,0,64,146,64,208,64,163,64,208,64,147,64,208,128,134,
0,64,152,64,208,64,150,64,208,128,162,0,73,163,21,85,64,208,72,173,8,64,
208,128,159,0,64,147,64,208,128,152,0,72,162,20,64,208,64,144,64,208,64,
145,64,208,64,144,64,208,128,154,0,64,157,64,208,73,162,9,28,64,208,128,
163,0,72,156,8,64,208,128,163,0,64,144,64,208,64,161,64,208,128,144,0,192,
163,0,64,208,64,173,64,208,128,162,0,64,164,64,208,64,162,64,208,128,152,
0,64,160,64,208,73,156,25,36,64,208,72,158,12,64,208,64,161,64,208,128,
162,0,64,144,64,208,128,168,0,64,146,64,208,64,173,64,208,128,154,0,64,
163,64,208,64,160,64,208,128,161,0,201,163,18,29,0,64,208,136,159,4,0,64,
157,64,208,128,145,0,64,162,64,208,136,163,4,0,128,156,0,64,164,64,208,
136,161,4,0,64,160,64,208,128,145,0,74,150,84,8,194,64,208,137,156,5,45,
0,73,152,21,33,64,208,64,173,64,208,64,156,64,208,64,161,64,208,128,152,
0,136,148,4,0,192,146,0,64,208,128,159,0,64,154,64,208,128,165,0,201,159,
26,29,0,64,208,72,152,12,64,208,64,150,64,208,128,164,0,64,150,64,208,128,
164,0,128,157,0,128,160,0,82,146,1,13,3,143,64,208,73,156,17,149,64,208,
137,162,5,8,0,128,161,0,128,166,0,73,151,25,97,64,208,72,175,8,64,208,128,
152,0,64,152,64,208,64,175,64,208,128,158,0,73,146,50,65,64,208,201,159,
10,41,0,64,208,128,163,0,72,154,8,64,208,128,163,0,64,144,64,208,72,154,
12,64,208,64,152,64,208,128,163,0,64,152,64,208,128,163,0,128,161,0,72,
145,8,64,208,128,160,0,64,144,64,208,128,162,0,64,147,64,208,128,154,0,
73,154,17,32,64,208,72,159,8,64,208,128,154,0,128,148,0,64,152,64,208,72,
156,8,64,208,128,163,0,128,144,0,128,155,0,201,161,18,81,0,64,208,72,162,
8,64,208,128,158,0,128,147,0,201,159,23,51,0,64,208,201,161,10,13,0,64,
208,128,147,0,128,158,0,128,164,0,200,158,17,0,64,208,136,163,4,0,64,154,
64,208,128,163,0,64,157,64,208,64,159,64,208,128,161,0,192,160,0,64,208,
136,159,4,0,128,151,0,73,163,17,24,64,208,64,160,64,208,64,144,64,208,128,
154,0,64,162,64,208,128,160,0,64,164,64,208,128,154,0,82,144,1,186,1,249,
64,208,74,155,114,1,45,64,208,64,172,64,208,73,154,29,64,64,208,64,158,
64,208,64,156,64,208,64,145,64,208,64,144,64,208,64,157,64,208,128,154,
0,73,146,9,24,64,208,128,158,0,64,144,64,208,64,146,64,208,64,152,64,208,
128,144,0,64,147,64,208,64,144,64,208,128,163,0,72,162,8,64,208,128,144,
0,64,157,64,208,64,152,64,208,64,152,64,208,72,155,8,64,208,128,165,0,64,
147,64,208,64,152,64,208,128,156,0,73,150,13,96,64,208,64,154,64,208,128,
147,0,73,147,33,80,64,208,137,161,5,20,0,64,151,64,208,64,173,64,208,64,
162,64,208,128,158,0,64,163,64,208,128,157,0,72,145,16,64,208,137,154,5,
8,0,128,134,0,128,167,0,64,144,64,208,73,161,9,16,64,208,128,159,0,136,
159,4,0,128,151,0,72,173,8,64,208,128,161,0,128,162,0,128,148,0,73,153,
29,52,64,208,64,146,64,208,64,166,64,208,64,149,64,208,64,157,64,208,64,
162,64,208,128,160,0,64,152,64,208,137,147,5,12,0,64,145,64,208,128,148,
0,64,162,64,208,128,161,0,64,154,64,208,72,154,20,64,208,64,154,64,208,
136,156,4,0,64,134,64,208,128,156,0,64,147,64,208,64,158,64,208,64,156,
64,208,128,151,0,73,160,9,77,64,208,128,151,0,73,158,18,53,64,208,192,158,
0,64,208,136,162,4,0,128,161,0,64,157,64,208,73,149,17,24,64,208,64,162,
64,208,64,154,64,208,128,152,0,64,146,64,208,128,166,0,64,174,64,208,128,
152,0,64,159,64,208,72,161,8,64,208,128,159,0,128,159,0,73,162,13,45,64,
208,136,155,4,0,128,150,0,64,161,64,208,137,157,5,12,0,136,154,4,0,128,
146,0,72,161,8,64,208,128,160,0,192,158,0,64,208,128,144,0,64,163,64,208,
64,145,64,208,128,159,0,64,134,64,208,73,157,13,36,64,208,64,144,64,208,
128,163,0,137,146,5,20,0,72,144,8,64,208,128,166,0,64,134,64,208,128,162,
0,128,149,0,137,163,5,12,0,64,162,64,208,128,145,0,64,164,64,208,64,154,
64,208,128,163,0,64,145,64,208,73,156,9,72,64,208,128,159,0,73,148,9,44,
64,208,128,148,0,73,146,17,24,64,208,136,163,4,0,64,161,64,208,128,144,
0,64,144,64,208,128,159,0,64,147,64,208,64,162,64,208,128,161,0,72,154,
16,64,208,72,162,8,64,208,128,155,0,128,154,0,128,151,0,73,161,17,46,64,
208,137,160,5,8,0,128,159,0,128,162,0,72,160,8,64,208,128,157,0,192,158,
0,64,208,192,159,0,64,208,136,162,4,0,64,152,64,208,128,162,0,72,173,12,
64,208,64,154,64,208,128,159,0,128,168,0,74,148,222,2,175,64,208,73,156,
21,89,64,208,136,161,4,0,64,152,64,208,64,152,64,208,128,161,0,137,151,
5,44,0,73,146,9,24,64,208,128,164,0,72,144,8,64,208,128,163,0,64,134,64,
208,128,146,0,64,148,64,208,136,162,4,0,64,152,64,208,128,152,0,73,154,
9,17,64,208,128,162,0,192,152,0,64,208,128,162,0,64,155,64,208,128,150,
0,201,163,26,106,0,64,208,72,159,12,64,208,64,146,64,208,128,159,0,64,146,
64,208,128,161,0,73,161,29,57,64,208,136,162,4,0,64,145,64,208,72,152,8,
64,208,128,162,0,64,149,64,208,128,151,0,72,160,12,64,208,136,159,4,0,128,
146,0,192,158,0,64,208,137,159,5,8,0,128,158,0,128,163,0,64,162,64,208,
137,162,5,16,0,136,155,4,0,64,152,64,208,128,161,0,128,163,0,137,167,5,
12,0,64,164,64,208,128,144,0,192,174,0,64,208,128,162,0,64,147,64,208,73,
158,13,197,64,208,136,154,4,0,128,152,0,201,152,62,124,0,64,208,73,157,
9,32,64,208,128,165,0,72,152,8,64,208,128,152,0,64,151,64,208,64,164,64,
208,64,146,64,208,128,161,0,72,164,16,64,208,64,154,64,208,64,152,64,208,
128,161,0,64,159,64,208,128,157,0,73,147,9,54,64,208,128,163,0,136,145,
4,0,192,144,0,64,208,137,163,5,21,0,200,161,13,0,64,208,136,154,4,0,128,
144,0,128,152,0,72,173,8,64,208,128,161,0,64,164,64,208,128,154,0,192,151,
0,64,208,128,152,0,201,156,26,49,0,64,208,73,161,9,16,64,208,128,152,0,
136,152,4,0,128,144,0,128,163,0,72,155,12,64,208,64,144,64,208,128,159,
0,64,154,64,208,136,155,4,0,128,145,0,64,157,64,208,64,161,64,208,128,161,
0,201,163,55,194,0,64,208,137,163,5,25,0,200,159,13,0,64,208,136,161,4,
0,128,159,0,64,146,64,208,128,148,0,64,173,64,208,64,152,64,208,64,162,
64,208,64,152,64,208,64,156,64,208,128,162,0,73,161,53,124,64,208,137,157,
5,28,0,137,148,5,16,0,64,145,64,208,64,173,64,208,128,159,0,64,151,64,208,
128,157,0,73,165,9,12,64,208,128,144,0,128,163,0,64,173,64,208,128,157,
0,72,160,32,64,208,73,158,13,24,64,208,64,146,64,208,128,148,0,64,146,64,
208,64,173,64,208,128,148,0,128,173,0,64,159,64,208,137,154,5,16,0,137,
150,5,8,0,128,145,0,128,152,0,137,163,5,16,0,64,160,64,208,64,160,64,208,
128,147,0,128,165,0,64,162,64,208,136,163,4,0,64,160,64,208,128,163,0,73,
166,21,46,64,208,64,159,64,208,64,152,64,208,64,154,64,208,128,146,0,200,
165,13,0,64,208,64,162,64,208,128,163,0,192,164,0,64,208,136,161,4,0,128,
144,0,192,173,0,64,208,137,159,5,12,0,136,154,4,0,128,152,0,64,162,64,208,
128,162,0,64,149,64,208,73,155,57,177,64,208,73,158,17,40,64,208,64,157,
64,208,64,147,64,208,128,152,0,64,144,64,208,64,147,64,208,64,144,64,208,
64,160,64,208,64,148,64,208,128,152,0,64,161,64,208,64,158,64,208,128,162,
0,73,148,25,36,64,208,64,156,64,208,64,158,64,208,64,160,64,208,64,158,
64,208,128,151,0,72,147,8,64,208,128,134,0,128,145,0,200,151,69,0,64,208,
73,154,29,36,64,208,64,158,64,208,64,146,64,208,64,160,64,208,64,152,64,
208,64,154,64,208,128,152,0,136,151,4,0,128,144,0,64,161,64,208,64,160,
64,208,64,149,64,208,64,148,64,208,64,161,64,208,64,162,64,208,128,146,
0,64,150,64,208,64,144,64,208,64,146,64,208,128,174,0,73,159,37,144,64,
208,73,162,13,24,64,208,64,173,64,208,128,165,0,64,158,64,208,64,155,64,
208,128,152,0,64,163,64,208,128,160,0,72,157,48,64,208,72,151,16,64,208,
64,157,64,208,64,144,64,208,128,154,0,64,148,64,208,64,160,64,208,64,158,
64,208,64,159,64,208,64,144,64,208,64,160,64,208,128,154,0,64,156,64,208,
73,159,9,36,64,208,128,163,0,64,158,64,208,64,146,64,208,64,149,64,208,
64,160,64,208,64,161,64,208,64,152,64,208,128,175,0,64,161,64,208,64,158,
64,208,72,174,8,64,208,128,151,0,128,161,0,72,162,60,64,208,73,156,13,36,
64,208,64,144,64,208,128,168,0,72,148,12,64,208,64,158,64,208,128,156,0,
64,147,64,208,64,152,64,208,128,151,0,72,163,8,64,208,128,162,0,64,161,
64,208,64,144,64,208,128,148,0,64,160,64,208,72,152,16,64,208,64,145,64,
208,64,144,64,208,128,161,0,64,150,64,208,73,156,37,128,64,208,64,152,64,
208,64,162,64,208,64,161,64,208,64,155,64,208,64,163,64,208,64,150,64,208,
64,145,64,208,128,144,0,64,154,64,208,64,158,64,208,64,156,64,208,73,161,
17,44,64,208,64,162,64,208,64,144,64,208,128,162,0,64,155,64,208,64,134,
64,208,64,161,64,208,64,147,64,208,64,158,64,208,64,161,64,208,128,159,
0,64,162,64,208,64,149,64,208,64,155,64,208,64,149,64,208,64,160,64,208,
64,144,64,208,64,148,64,208,64,134,64,208,128,158,0,64,161,64,208,64,155,
64,208,64,163,64,208,64,150,64,208,64,145,64,208,128,152,0,74,155,80,5,
104,64,208,73,161,9,49,64,208,128,144,0,73,157,9,28,64,208,128,159,0,72,
155,8,64,208,128,160,0,64,144,64,208,136,164,4,0,128,163,0,200,160,9,0,
64,208,128,151,0,128,158,0,137,165,5,21,0,72,164,8,64,208,128,158,0,192,
162,0,64,208,128,145,0,128,168,0,82,152,2,131,3,188,64,208,74,157,30,1,
95,64,208,64,144,64,208,64,156,64,208,64,152,64,208,64,162,64,208,64,164,
64,208,128,156,0,74,151,158,1,5,64,208,137,158,5,120,0,72,149,104,64,208,
64,155,64,208,64,172,64,208,72,173,56,64,208,64,155,64,208,64,149,64,208,
64,154,64,208,64,162,64,208,64,160,64,208,64,158,64,208,64,161,64,208,64,
162,64,208,64,144,64,208,64,157,64,208,64,166,64,208,64,152,64,208,128,
152,0,64,147,64,208,64,149,64,208,64,157,64,208,64,149,64,208,64,160,64,
208,64,144,64,208,64,162,64,208,64,158,64,208,128,160,0,64,144,64,208,64,
152,64,208,128,157,0,64,162,64,208,64,158,64,208,64,159,64,208,64,155,64,
208,64,152,64,208,64,146,64,208,136,158,4,0,128,144,0,73,147,17,84,64,208,
72,173,8,64,208,128,161,0,128,156,0,72,146,20,64,208,137,162,5,12,0,136,
161,4,0,128,148,0,128,166,0,64,144,64,208,73,160,13,28,64,208,64,161,64,
208,128,158,0,72,156,12,64,208,64,144,64,208,128,162,0,128,146,0,136,166,
4,0,64,162,64,208,64,149,64,208,128,165,0,64,148,64,208,72,160,8,64,208,
128,152,0,64,158,64,208,128,163,0,73,154,22,49,64,208,137,155,5,8,0,128,
145,0,192,156,0,64,208,128,158,0,64,152,64,208,73,158,9,20,64,208,128,148,
0,136,157,4,0,64,150,64,208,128,162,0,128,162,0,64,156,64,208,64,161,64,
208,128,152,0,74,164,82,1,1,64,208,73,156,33,64,64,208,64,144,64,208,64,
157,64,208,64,158,64,208,64,156,64,208,64,149,64,208,64,162,64,208,128,
160,0,64,144,64,208,64,146,64,208,64,162,64,208,64,158,64,208,64,156,64,
208,64,144,64,208,64,162,64,208,128,171,0,64,163,64,208,64,160,64,208,128,
171,0,73,161,41,148,64,208,137,158,5,28,0,72,152,12,64,208,64,159,64,208,
128,144,0,64,145,64,208,64,144,64,208,128,162,0,64,162,64,208,128,162,0,
72,160,28,64,208,73,152,13,16,64,208,64,161,64,208,128,159,0,128,144,0,
64,161,64,208,128,159,0,64,159,64,208,137,158,5,56,0,73,152,9,40,64,208,
128,159,0,64,144,64,208,64,154,64,208,64,144,64,208,64,148,64,208,64,149,
64,208,64,156,64,208,64,152,64,208,128,175,0,64,154,64,208,64,159,64,208,
128,154,0,137,161,5,16,0,64,160,64,208,64,152,64,208,128,161,0,128,162,
0,64,162,64,208,137,160,5,12,0,136,156,4,0,128,145,0,136,166,4,0,64,163,
64,208,128,148,0,73,168,9,12,64,208,128,161,0,128,166,0,64,173,64,208,64,
151,64,208,64,159,64,208,128,158,0,64,151,64,208,201,157,31,191,0,64,208,
201,152,18,21,0,64,208,64,152,64,208,64,161,64,208,128,165,0,128,144,0,
128,162,0,137,151,5,93,0,73,146,17,52,64,208,72,158,8,64,208,128,157,0,
128,144,0,72,145,8,64,208,128,158,0,64,144,64,208,73,159,9,16,64,208,128,
154,0,136,158,4,0,128,154,0,64,161,64,208,128,158,0,200,148,9,0,64,208,
128,161,0,64,147,64,208,137,163,5,16,0,72,162,8,64,208,128,152,0,128,144,
0,64,168,64,208,128,158,0,73,155,13,44,64,208,136,154,4,0,128,144,0,72,
154,16,64,208,72,156,8,64,208,128,161,0,128,152,0,64,152,64,208,137,155,
5,8,0,128,146,0,128,158,0,64,156,64,208,137,152,5,12,0,136,151,4,0,128,
150,0,136,163,4,0,128,158,0,73,164,9,82,64,208,128,161,0,201,160,10,50,
0,64,208,128,148,0,72,159,28,64,208,137,159,5,12,0,136,156,4,0,128,154,
0,136,162,4,0,64,160,64,208,128,156,0,192,158,0,64,208,136,161,4,0,128,
155,0,72,163,12,64,208,64,159,64,208,128,146,0,64,161,64,208,136,162,4,
0,128,156,0,201,168,10,29,0,64,208,128,144,0,72,167,12,64,208,64,160,64,
208,128,165,0,64,165,64,208,128,160,0,64,173,64,208,128,167,0,192,154,0,
64,208,73,157,17,171,64,208,137,156,5,8,0,128,145,0,128,159,0,73,149,13,
106,64,208,64,146,64,208,128,160,0,73,146,13,53,64,208,136,159,4,0,128,
148,0,200,145,21,0,64,208,137,160,5,12,0,136,158,4,0,128,144,0,128,164,
0,64,144,64,208,137,162,5,12,0,64,144,64,208,128,164,0,128,164,0,200,148,
25,0,64,208,73,156,9,12,64,208,128,166,0,128,144,0,64,162,64,208,128,161,
0,64,147,64,208,64,161,64,208,64,173,64,208,128,157,0,73,152,13,28,64,208,
64,161,64,208,128,163,0,72,151,12,64,208,64,165,64,208,128,152,0,128,150,
0,72,156,8,64,208,128,164,0,192,154,0,64,208,136,159,4,0,128,145,0,73,163,
9,107,64,208,128,148,0,73,160,21,61,64,208,73,150,9,12,64,208,128,164,0,
128,144,0,128,161,0,200,159,25,0,64,208,137,162,5,12,0,136,147,4,0,128,
144,0,64,163,64,208,128,159,0,64,158,64,208,72,164,8,64,208,128,163,0,128,
152,0,200,162,13,0,64,208,136,161,4,0,128,145,0,192,161,0,64,208,137,152,
5,16,0,72,145,8,64,208,128,162,0,128,144,0,128,162,0,137,168,5,33,0,72,
166,16,64,208,64,159,64,208,64,164,64,208,128,160,0,192,165,0,64,208,64,
159,64,208,128,159,0,72,175,13,64,208,192,160,0,64,208,128,163,0,64,173,
64,208,136,165,4,0,64,159,64,208,64,158,64,208,128,159,0,80,157,1,58,64,
208,73,158,13,202,64,208,64,152,64,208,128,152,0,73,149,37,114,64,208,72,
159,24,64,208,64,160,64,208,64,158,64,208,64,147,64,208,64,173,64,208,128,
161,0,64,146,64,208,128,162,0,201,147,10,41,0,64,208,128,163,0,72,146,12,
64,208,64,174,64,208,128,144,0,64,144,64,208,72,158,8,64,208,128,159,0,
64,145,64,208,128,145,0,192,148,0,64,208,73,149,13,28,64,208,64,154,64,
208,128,166,0,64,134,64,208,64,144,64,208,64,161,64,208,128,145,0,128,154,
0,73,156,13,68,64,208,136,173,4,0,128,163,0,72,155,8,64,208,128,150,0,64,
152,64,208,137,154,5,36,0,72,152,28,64,208,73,161,9,16,64,208,128,173,0,
64,156,64,208,128,164,0,64,162,64,208,128,158,0,128,147,0,64,159,64,208,
128,159,0,64,157,64,208,128,155,0,137,164,5,71,0,201,162,22,54,0,64,208,
73,162,9,12,64,208,128,156,0,128,145,0,128,163,0,72,161,16,64,208,137,152,
5,8,0,128,151,0,128,154,0,192,159,0,64,208,72,174,8,64,208,128,144,0,128,
159,0,192,163,0,64,208,64,150,64,208,128,162,0,73,173,9,24,64,208,128,161,
0,136,168,4,0,64,166,64,208,64,155,64,208,128,151,0,64,175,64,208,136,158,
4,0,128,151,0,64,156,64,208,73,158,17,114,64,208,72,160,8,64,208,128,154,
0,128,158,0,201,150,10,58,0,64,208,128,159,0,137,146,5,28,0,72,145,12,64,
208,64,162,64,208,128,152,0,64,144,64,208,64,152,64,208,128,160,0,72,149,
12,64,208,64,162,64,208,128,152,0,192,148,0,64,208,128,154,0,73,154,13,
28,64,208,136,166,4,0,128,152,0,72,152,8,64,208,128,161,0,64,151,64,208,
128,159,0,64,157,64,208,136,154,4,0,128,145,0,73,164,29,129,64,208,73,159,
13,20,64,208,64,156,64,208,128,159,0,64,150,64,208,128,161,0,128,166,0,
201,161,14,49,0,64,208,136,163,4,0,128,159,0,72,160,20,64,208,137,156,5,
8,0,128,146,0,64,161,64,208,128,163,0,64,159,64,208,137,152,5,8,0,128,151,
0,128,159,0,72,163,20,64,208,72,173,8,64,208,128,161,0,64,160,64,208,128,
145,0,64,162,64,208,137,161,5,16,0,72,159,8,64,208,128,159,0,128,158,0,
72,174,8,64,208,128,144,0,128,163,0,137,168,5,16,0,136,166,4,0,64,165,64,
208,128,168,0,192,173,0,64,208,137,154,5,8,0,128,151,0,128,164,0,74,165,
75,7,99,64,208,201,161,10,45,0,64,208,128,168,0,73,156,13,28,64,208,136,
162,4,0,128,151,0,72,155,8,64,208,128,150,0,64,146,64,208,128,148,0,64,
159,64,208,128,168,0,137,166,5,20,0,136,165,4,0,64,162,64,208,136,163,4,
0,128,152,0,128,168,0,202,162,243,5,162,0,64,208,73,156,9,110,64,208,128,
158,0,73,150,9,60,64,208,128,162,0,73,146,9,24,64,208,128,161,0,72,145,
8,64,208,128,144,0,64,144,64,208,128,162,0,72,148,20,64,208,137,156,5,12,
0,64,152,64,208,128,156,0,128,174,0,64,147,64,208,128,144,0,73,154,9,38,
64,208,128,162,0,72,152,22,64,208,200,161,9,0,64,208,128,160,0,192,151,
0,64,208,128,157,0,64,151,64,208,128,154,0,128,155,0,137,164,5,94,0,73,
160,30,58,64,208,73,154,9,17,64,208,128,156,0,192,148,0,64,208,128,164,
0,64,173,64,208,128,162,0,200,159,21,0,64,208,137,158,5,12,0,136,154,4,
0,128,144,0,128,159,0,64,158,64,208,128,150,0,136,163,4,0,64,161,64,208,
137,160,5,20,0,136,154,4,0,64,144,64,208,64,144,64,208,128,164,0,128,168,
0,73,173,17,28,64,208,137,162,5,8,0,128,154,0,128,165,0,136,168,4,0,64,
167,64,208,128,154,0,128,174,0,82,160,1,117,3,21,64,208,73,157,9,214,64,
208,128,158,0,73,151,21,135,64,208,72,173,8,64,208,128,162,0,64,144,64,
208,128,163,0,201,146,26,102,0,64,208,137,163,5,12,0,136,162,4,0,128,148,
0,64,173,64,208,128,148,0,200,145,9,0,64,208,128,162,0,64,144,64,208,73,
147,33,40,64,208,64,156,64,208,64,149,64,208,64,162,64,208,64,144,64,208,
64,155,64,208,64,155,64,208,128,171,0,64,144,64,208,128,148,0,64,156,64,
208,64,162,64,208,64,149,64,208,64,144,64,208,64,162,64,208,128,160,0,192,
147,0,64,208,136,165,4,0,128,154,0,201,155,23,59,0,64,208,192,158,0,64,
208,136,163,4,0,64,152,64,208,128,163,0,200,154,13,0,64,208,136,154,4,0,
128,145,0,64,152,64,208,72,147,8,64,208,128,163,0,64,146,64,208,64,157,
64,208,128,160,0,64,156,64,208,136,156,4,0,128,146,0,73,163,13,92,64,208,
64,147,64,208,128,147,0,73,161,37,72,64,208,137,159,5,20,0,136,154,4,0,
64,147,64,208,64,163,64,208,128,159,0,136,163,4,0,64,162,64,208,128,159,
0,72,159,20,64,208,137,155,5,8,0,128,148,0,64,157,64,208,128,159,0,64,158,
64,208,136,166,4,0,64,157,64,208,128,148,0,64,162,64,208,128,161,0,73,173,
13,52,64,208,136,163,4,0,128,162,0,72,166,24,64,208,72,160,8,64,208,128,
159,0,64,158,64,208,64,156,64,208,128,148,0,64,164,64,208,137,159,5,8,0,
128,158,0,128,166,0,64,174,64,208,128,144,0,64,159,64,208,201,158,27,234,
0,64,208,73,158,9,17,64,208,128,161,0,192,147,0,64,208,128,144,0,128,163,
0,73,150,9,69,64,208,128,161,0,73,146,9,36,64,208,128,154,0,73,144,9,12,
64,208,128,163,0,128,134,0,64,145,64,208,64,146,64,208,64,159,64,208,128,
162,0,200,148,21,0,64,208,137,160,5,8,0,128,151,0,64,161,64,208,128,157,
0,128,147,0,73,155,21,71,64,208,73,154,9,12,64,208,128,160,0,128,144,0,
128,161,0,200,154,21,0,64,208,137,156,5,12,0,136,148,4,0,128,146,0,128,
160,0,192,152,0,64,208,73,158,13,16,64,208,64,158,64,208,128,161,0,128,
154,0,192,160,0,64,208,128,162,0,72,157,48,64,208,137,154,5,20,0,73,150,
9,12,64,208,128,154,0,128,145,0,128,152,0,73,162,9,16,64,208,128,160,0,
64,161,64,208,128,152,0,64,163,64,208,128,161,0,64,156,64,208,73,157,9,
12,64,208,128,149,0,128,154,0,128,159,0,201,166,10,142,0,64,208,128,155,
0,201,162,22,121,0,64,208,73,157,9,12,64,208,128,146,0,128,155,0,128,173,
0,201,160,43,83,0,64,208,137,159,5,25,0,200,156,17,0,64,208,72,161,8,64,
208,128,159,0,128,159,0,128,146,0,136,163,4,0,64,160,64,208,128,159,0,64,
159,64,208,73,160,9,24,64,208,128,156,0,72,157,8,64,208,128,157,0,64,148,
64,208,128,146,0,192,162,0,64,208,64,157,64,208,128,159,0,192,161,0,64,
208,137,161,5,8,0,128,151,0,128,163,0,136,164,4,0,64,163,64,208,128,161,
0,73,173,9,29,64,208,128,147,0,200,168,9,0,64,208,128,163,0,64,167,64,208,
136,161,4,0,128,154,0,136,175,4,0,128,174,0,64,161,64,208,73,157,25,194,
64,208,137,156,5,12,0,136,154,4,0,128,147,0,136,164,4,0,128,159,0,73,150,
9,104,64,208,128,160,0,73,147,13,73,64,208,136,158,4,0,128,154,0,201,145,
14,45,0,64,208,64,149,64,208,128,151,0,64,144,64,208,73,157,17,24,64,208,
64,159,64,208,64,134,64,208,128,157,0,64,147,64,208,128,158,0,128,163,0,
64,146,64,208,137,160,5,8,0,128,159,0,128,163,0,200,149,14,0,64,208,192,
154,0,64,208,128,163,0,192,148,0,64,208,128,155,0,137,154,5,37,0,72,152,
16,64,208,137,158,5,8,0,128,151,0,128,159,0,192,151,0,64,208,137,157,5,
8,0,128,156,0,128,167,0,72,156,16,64,208,137,157,5,8,0,128,145,0,128,159,
0,192,155,0,64,208,136,163,4,0,128,148,0,73,165,9,165,64,208,128,159,0,
201,161,42,116,0,64,208,137,154,5,24,0,137,147,5,8,0,128,145,0,64,151,64,
208,64,151,64,208,128,134,0,137,167,5,8,0,128,162,0,128,168,0,201,159,34,
63,0,64,208,73,156,9,16,64,208,128,154,0,136,154,4,0,128,144,0,64,162,64,
208,136,161,4,0,128,158,0,192,158,0,64,208,201,155,14,21,0,64,208,64,154,
64,208,128,148,0,64,150,64,208,128,162,0,128,161,0,64,160,64,208,136,166,
4,0,128,157,0,200,163,9,0,64,208,128,159,0,64,162,64,208,73,161,13,20,64,
208,64,151,64,208,128,152,0,136,159,4,0,128,158,0,136,166,4,0,128,163,0,
137,168,5,16,0,136,167,4,0,64,166,64,208,128,162,0,72,174,8,64,208,128,
168,0,64,173,64,208,73,156,9,12,64,208,128,159,0,128,152,0,64,160,64,208,
128,147,0,72,164,149,64,208,137,155,5,87,0,73,148,9,55,64,208,128,154,0,
73,146,9,21,64,208,128,144,0,192,145,0,64,208,136,154,4,0,128,152,0,192,
147,0,64,208,72,163,8,64,208,128,159,0,64,161,64,208,192,151,0,64,208,128,
157,0,73,152,9,16,64,208,128,156,0,64,149,64,208,128,161,0,64,154,64,208,
136,156,4,0,128,148,0,73,164,9,46,64,208,128,148,0,201,158,14,17,0,64,208,
136,161,4,0,128,159,0,128,157,0,192,161,0,64,208,137,158,5,12,0,64,147,
64,208,128,144,0,128,161,0,136,173,4,0,64,166,64,208,128,162,0,64,163,64,
208,73,157,13,166,64,208,64,152,64,208,128,144,0,73,149,9,44,64,208,128,
159,0,73,146,9,20,64,208,128,155,0,64,134,64,208,64,154,64,208,128,162,
0,64,148,64,208,136,161,4,0,64,146,64,208,128,159,0,73,154,13,24,64,208,
136,156,4,0,128,154,0,64,152,64,208,136,175,4,0,128,166,0,64,156,64,208,
137,159,5,40,0,73,149,9,24,64,208,128,160,0,136,148,4,0,64,144,64,208,64,
167,64,208,128,160,0,72,157,8,64,208,128,158,0,128,154,0,73,162,9,30,64,
208,128,158,0,200,161,13,0,64,208,136,158,4,0,128,154,0,192,160,0,64,208,
128,162,0,64,166,64,208,64,149,64,208,128,160,0,73,167,13,28,64,208,136,
160,4,0,128,159,0,137,162,5,12,0,64,161,64,208,128,154,0,128,163,0,72,173,
20,64,208,137,154,5,12,0,64,152,64,208,128,159,0,128,159,0,64,169,64,208,
128,150,0,74,173,204,1,180,64,208,73,157,9,100,64,208,128,161,0,73,148,
9,41,64,208,128,157,0,137,146,5,25,0,200,145,9,0,64,208,128,166,0,64,144,
64,208,64,159,64,208,128,161,0,64,147,64,208,128,152,0,201,154,23,43,0,
64,208,201,158,10,13,0,64,208,128,161,0,128,156,0,128,166,0,72,152,8,64,
208,128,160,0,192,151,0,64,208,64,152,64,208,128,161,0,64,156,64,208,128,
159,0,73,162,13,74,64,208,136,166,4,0,128,161,0,73,160,29,49,64,208,73,
152,9,12,64,208,128,162,0,128,144,0,64,163,64,208,64,156,64,208,128,152,
0,200,159,13,0,64,208,136,160,4,0,128,155,0,64,158,64,208,128,166,0,192,
161,0,64,208,136,154,4,0,128,146,0,137,166,5,16,0,136,165,4,0,64,163,64,
208,128,154,0,64,175,64,208,128,160,0,201,167,14,167,0,64,208,136,161,4,
0,128,155,0,64,166,64,208,201,159,18,94,0,64,208,136,161,4,0,64,159,64,
208,128,159,0,73,154,13,45,64,208,64,145,64,208,128,145,0,73,145,9,20,64,
208,128,161,0,64,144,64,208,136,175,4,0,128,154,0,192,148,0,64,208,64,154,
64,208,128,154,0,73,157,13,24,64,208,64,162,64,208,128,152,0,64,156,64,
208,136,168,4,0,128,154,0,64,158,64,208,128,144,0,73,163,9,36,64,208,128,
159,0,73,161,9,16,64,208,128,161,0,64,160,64,208,128,161,0,64,162,64,208,
136,161,4,0,128,158,0,72,165,8,64,208,128,158,0,64,164,64,208,64,162,64,
208,128,158,0,64,168,64,208,137,152,5,29,0,137,147,5,17,0,136,146,4,0,192,
145,0,64,208,128,160,0,136,151,4,0,128,148,0,73,157,9,25,64,208,128,154,
0,72,156,8,64,208,128,147,0,192,154,0,64,208,128,156,0,136,161,4,0,128,
158,0,72,175,8,64,208,128,144,0,64,174,64,208,137,159,5,69,0,73,154,25,
36,64,208,73,164,9,16,64,208,128,159,0,64,145,64,208,128,152,0,128,166,
0,72,145,8,64,208,128,155,0,128,134,0,72,158,8,64,208,128,158,0,64,156,
64,208,192,158,0,64,208,64,160,64,208,64,172,64,208,128,149,0,73,164,14,
80,64,208,192,155,0,64,208,128,163,0,72,162,8,64,208,128,166,0,64,161,64,
208,73,162,14,34,64,208,192,168,0,64,208,128,144,0,200,154,13,0,64,208,
64,164,64,208,128,159,0,64,144,64,208,128,168,0,200,168,17,0,64,208,72,
158,8,64,208,128,160,0,128,152,0,128,166,0,72,173,12,64,208,64,161,64,208,
128,158,0,192,166,0,64,208,137,149,5,8,0,128,148,0,64,162,64,208,128,162,
0,64,147,64,208,210,158,7,233,28,128,0,64,208,202,157,27,1,17,0,64,208,
73,166,9,12,64,208,128,148,0,128,156,0,64,173,64,208,128,161,0,201,151,
14,65,0,64,208,64,145,64,208,128,158,0,73,146,17,36,64,208,136,148,4,0,
64,144,64,208,128,159,0,72,145,12,64,208,64,156,64,208,128,159,0,64,144,
64,208,128,158,0,72,150,8,64,208,128,158,0,64,147,64,208,128,163,0,73,155,
81,122,64,208,73,158,65,72,64,208,136,165,4,0,64,146,64,208,72,154,12,64,
208,64,160,64,208,128,163,0,64,148,64,208,64,149,64,208,64,160,64,208,64,
150,64,208,64,161,64,208,64,155,64,208,64,163,64,208,64,150,64,208,64,145,
64,208,128,152,0,64,144,64,208,128,151,0,128,161,0,200,154,13,0,64,208,
136,163,4,0,128,158,0,64,152,64,208,137,162,5,17,0,192,157,0,64,208,64,
160,64,208,128,158,0,64,167,64,208,128,161,0,64,156,64,208,137,161,5,44,
0,137,154,5,28,0,136,151,4,0,64,149,64,208,64,158,64,208,64,162,64,208,
64,158,64,208,128,157,0,64,158,64,208,64,160,64,208,128,158,0,137,165,5,
8,0,128,163,0,128,166,0,74,162,22,6,126,64,208,73,158,9,12,64,208,128,145,
0,128,146,0,128,165,0,74,160,199,1,10,64,208,73,158,17,84,64,208,136,158,
4,0,64,157,64,208,128,158,0,73,150,9,40,64,208,128,148,0,72,148,20,64,208,
72,163,12,64,208,64,156,64,208,128,171,0,128,154,0,64,147,64,208,64,152,
64,208,128,163,0,72,156,12,64,208,64,144,64,208,128,168,0,64,154,64,208,
72,158,8,64,208,128,156,0,128,154,0,73,162,37,101,64,208,64,149,64,208,
64,155,64,208,64,149,64,208,64,154,64,208,64,144,64,208,64,157,64,208,64,
144,64,208,128,155,0,72,161,44,64,208,73,163,9,32,64,208,128,148,0,72,158,
16,64,208,64,146,64,208,64,149,64,208,128,162,0,64,144,64,208,128,148,0,
64,173,64,208,128,161,0,192,159,0,64,208,72,162,12,64,208,64,163,64,208,
128,161,0,128,158,0,64,163,64,208,128,158,0,72,159,48,64,208,73,156,9,32,
64,208,128,151,0,136,145,4,0,64,144,64,208,72,159,8,64,208,128,158,0,64,
157,64,208,128,158,0,136,165,4,0,64,160,64,208,128,152,0,64,158,64,208,
136,165,4,0,64,157,64,208,64,146,64,208,128,160,0,64,161,64,208,74,156,
14,2,140,64,208,64,173,64,208,128,159,0,74,149,10,1,87,64,208,128,162,0,
73,146,17,205,64,208,64,163,64,208,64,151,64,208,128,171,0,72,145,36,64,
208,72,174,20,64,208,64,148,64,208,64,150,64,208,64,149,64,208,128,162,
0,64,144,64,208,64,157,64,208,128,154,0,192,144,0,64,208,73,148,85,132,
64,208,64,156,64,208,72,162,36,64,208,64,149,64,208,64,165,64,208,64,157,
64,208,64,144,64,208,64,148,64,208,64,151,64,208,64,158,64,208,128,160,
0,64,152,64,208,64,157,64,208,64,152,64,208,64,161,64,208,64,162,64,208,
64,160,64,208,64,144,64,208,64,166,64,208,64,152,64,208,128,152,0,64,146,
64,208,64,162,64,208,64,158,64,208,64,152,64,208,64,157,64,208,64,161,64,
208,64,159,64,208,64,149,64,208,64,154,64,208,64,166,64,208,64,152,64,208,
128,175,0,64,160,64,208,64,165,64,208,64,152,64,208,128,146,0,72,148,64,
64,208,72,163,20,64,208,64,156,64,208,137,163,5,8,0,128,144,0,128,171,0,
64,149,64,208,64,159,64,208,64,144,64,208,64,160,64,208,64,162,64,208,64,
144,64,208,64,156,64,208,64,149,64,208,64,157,64,208,128,162,0,192,147,
0,64,208,72,160,24,64,208,64,144,64,208,64,157,64,208,64,152,64,208,64,
166,64,208,128,171,0,64,149,64,208,64,158,64,208,64,157,64,208,64,144,64,
208,64,148,64,208,64,151,64,208,64,158,64,208,64,160,64,208,128,144,0,73,
152,65,152,64,208,72,157,44,64,208,72,161,28,64,208,64,159,64,208,64,149,
64,208,64,154,64,208,64,166,64,208,64,152,64,208,128,175,0,64,154,64,208,
64,158,64,208,128,160,0,64,151,64,208,64,148,64,208,64,144,64,208,128,162,
0,72,151,40,64,208,72,157,12,64,208,64,144,64,208,128,154,0,64,144,64,208,
64,154,64,208,64,163,64,208,64,159,64,208,64,154,64,208,128,152,0,64,150,
64,208,64,152,64,208,64,155,64,208,64,152,64,208,64,157,64,208,64,161,64,
208,64,159,64,208,64,149,64,208,64,154,64,208,64,166,64,208,64,152,64,208,
128,152,0,64,154,64,208,72,158,96,64,208,72,157,24,64,208,64,162,64,208,
64,160,64,208,64,144,64,208,64,154,64,208,128,162,0,64,156,64,208,73,155,
25,52,64,208,64,149,64,208,64,161,64,208,64,165,64,208,64,158,64,208,128,
151,0,72,152,16,64,208,64,162,64,208,64,149,64,208,128,162,0,64,151,64,
208,64,149,64,208,128,156,0,64,166,64,208,64,149,64,208,128,157,0,64,144,
64,208,64,151,64,208,64,157,64,208,64,144,64,208,64,167,64,208,64,149,64,
208,64,153,64,208,64,161,64,208,64,162,64,208,64,146,64,208,128,158,0,202,
162,51,2,55,0,64,208,64,144,64,208,136,160,4,0,64,156,64,208,64,158,64,
208,64,150,64,208,64,161,64,208,64,155,64,208,64,163,64,208,64,150,64,208,
64,145,64,208,128,144,0,74,159,106,1,29,64,208,72,160,12,64,208,64,158,
64,208,128,156,0,64,158,64,208,72,168,20,64,208,64,155,64,208,64,152,64,
208,64,157,64,208,128,144,0,64,150,64,208,72,157,24,64,208,64,144,64,208,
64,148,64,208,64,151,64,208,64,158,64,208,128,160,0,64,144,64,208,64,160,
64,208,64,157,64,208,64,144,64,208,64,148,64,208,64,151,64,208,64,158,64,
208,64,160,64,208,128,144,0,72,158,48,64,208,72,165,20,64,208,64,160,64,
208,64,144,64,208,64,157,64,208,128,171,0,64,160,64,208,64,147,64,208,64,
144,64,208,64,157,64,208,64,158,64,208,128,146,0,64,157,64,208,72,152,72,
64,208,72,166,16,64,208,64,152,64,208,64,159,64,208,128,160,0,64,152,64,
208,73,156,13,36,64,208,64,144,64,208,128,168,0,137,146,5,16,0,64,144,64,
208,136,168,4,0,128,161,0,64,147,64,208,128,144,0,72,165,8,64,208,128,159,
0,128,160,0,64,144,64,208,72,155,36,64,208,64,158,64,208,64,147,64,208,
64,161,64,208,64,155,64,208,64,163,64,208,64,150,64,208,64,145,64,208,128,
144,0,64,148,64,208,64,151,64,208,64,158,64,208,128,160,0,72,161,208,64,
208,73,156,13,116,64,208,64,173,64,208,128,159,0,73,149,21,68,64,208,64,
154,64,208,64,162,64,208,64,158,64,208,128,160,0,64,144,64,208,64,157,64,
208,64,173,64,208,64,159,64,208,64,152,64,208,64,148,64,208,64,161,64,208,
64,155,64,208,64,163,64,208,64,150,64,208,64,145,64,208,128,171,0,64,155,
64,208,64,163,64,208,64,150,64,208,72,145,8,64,208,128,144,0,64,144,64,
208,64,169,64,208,64,152,64,208,128,153,0,73,159,33,72,64,208,64,149,64,
208,64,166,64,208,64,161,64,208,64,146,64,208,64,175,64,208,64,151,64,208,
128,152,0,64,158,64,208,72,146,12,64,208,64,149,64,208,128,162,0,64,145,
64,208,64,160,64,208,64,144,64,208,64,157,64,208,64,152,64,208,128,175,
0,64,162,64,208,64,160,64,208,64,144,64,208,128,165,0,64,160,64,208,64,
149,64,208,64,149,64,208,64,161,64,208,64,162,64,208,128,160,0,73,166,21,
124,64,208,64,152,64,208,64,160,64,208,64,154,64,208,128,144,0,72,164,48,
64,208,72,152,36,64,208,64,155,64,208,64,144,64,208,64,160,64,208,64,156,
64,208,64,158,64,208,64,157,64,208,64,152,64,208,128,175,0,64,144,64,208,
128,159,0,64,163,64,208,72,161,16,64,208,64,155,64,208,64,163,64,208,128,
147,0,64,159,64,208,64,160,64,208,64,144,64,208,64,146,64,208,64,155,64,
208,64,149,64,208,64,157,64,208,64,152,64,208,128,149,0,64,173,64,208,64,
154,64,208,64,151,64,208,64,144,64,208,64,156,64,208,64,149,64,208,128,
157,0,73,167,9,62,64,208,128,161,0,72,164,12,64,208,136,161,4,0,128,159,
0,192,163,0,64,208,137,154,5,25,0,73,148,14,17,64,208,192,158,0,64,208,
128,148,0,128,145,0,128,151,0,72,162,8,64,208,128,159,0,128,159,0,64,173,
64,208,136,161,4,0,64,155,64,208,64,160,64,208,128,158,0,202,150,71,9,9,
0,64,208,137,161,5,40,0,137,152,5,12,0,136,148,4,0,128,144,0,136,158,4,
0,64,154,64,208,137,162,5,12,0,136,159,4,0,128,152,0,128,163,0,137,165,
5,20,0,136,164,4,0,64,162,64,208,64,156,64,208,128,161,0,128,173,0,82,146,
1,47,5,114,64,208,201,159,26,182,0,64,208,137,154,5,16,0,136,148,4,0,64,
146,64,208,128,148,0,128,159,0,73,151,25,81,64,208,72,160,12,64,208,64,
154,64,208,128,163,0,64,159,64,208,128,156,0,73,147,13,45,64,208,64,161,
64,208,128,161,0,200,146,25,0,64,208,72,163,8,64,208,128,162,0,64,161,64,
208,64,154,64,208,128,163,0,64,145,64,208,128,164,0,72,150,8,64,208,128,
164,0,128,148,0,73,155,9,40,64,208,128,146,0,72,154,12,64,208,136,161,4,
0,128,147,0,64,152,64,208,73,154,9,12,64,208,128,164,0,128,151,0,128,163,
0,72,157,24,64,208,64,158,64,208,64,158,64,208,64,157,64,208,64,152,64,
208,128,159,0,64,156,64,208,136,163,4,0,128,145,0,201,165,10,61,0,64,208,
128,163,0,73,162,9,34,64,208,128,163,0,200,161,17,0,64,208,136,163,4,0,
64,159,64,208,128,161,0,192,160,0,64,208,128,161,0,200,164,9,0,64,208,128,
148,0,192,163,0,64,208,128,166,0,73,171,21,49,64,208,72,162,8,64,208,128,
156,0,64,160,64,208,128,156,0,136,167,4,0,192,166,0,64,208,73,154,9,16,
64,208,128,159,0,64,147,64,208,128,144,0,128,173,0,128,173,0,82,144,3,125,
3,156,64,208,74,158,111,1,230,64,208,73,159,49,85,64,208,73,152,21,32,64,
208,72,154,8,64,208,128,158,0,64,146,64,208,128,158,0,64,148,64,208,64,
154,64,208,128,158,0,64,158,64,208,64,162,64,208,128,158,0,73,157,9,16,
64,208,128,152,0,64,151,64,208,128,162,0,192,158,0,64,208,136,161,4,0,64,
160,64,208,64,148,64,208,128,152,0,137,161,5,16,0,64,160,64,208,64,161,
64,208,128,161,0,128,163,0,73,150,19,161,64,208,192,154,0,64,208,192,165,
0,64,208,128,163,0,73,147,17,90,64,208,136,163,4,0,64,159,64,208,128,154,
0,73,145,13,49,64,208,136,162,4,0,128,161,0,64,144,64,208,201,158,14,25,
0,64,208,64,161,64,208,128,158,0,72,157,8,64,208,128,162,0,128,154,0,64,
160,64,208,128,154,0,64,146,64,208,137,161,5,12,0,136,158,4,0,128,156,0,
192,162,0,64,208,128,163,0,72,149,12,64,208,64,144,64,208,128,158,0,64,
148,64,208,73,155,18,21,64,208,192,161,0,64,208,64,161,64,208,128,158,0,
128,145,0,64,159,64,208,64,160,64,208,64,159,64,208,128,158,0,201,154,38,
135,0,64,208,137,154,5,16,0,136,151,4,0,64,144,64,208,128,163,0,72,167,
8,64,208,128,160,0,64,158,64,208,128,160,0,200,152,38,0,64,208,201,160,
10,25,0,64,208,128,162,0,137,157,5,12,0,64,156,64,208,128,154,0,128,158,
0,136,168,4,0,128,161,0,64,151,64,208,73,159,21,52,64,208,64,155,64,208,
64,152,64,208,64,162,64,208,128,144,0,72,155,16,64,208,64,152,64,208,64,
164,64,208,128,162,0,64,146,64,208,64,158,64,208,64,148,64,208,128,171,
0,128,161,0,72,157,48,64,208,73,152,25,28,64,208,72,161,8,64,208,128,158,
0,64,152,64,208,64,161,64,208,128,165,0,128,147,0,64,159,64,208,64,152,
64,208,64,157,64,208,128,158,0,64,156,64,208,73,161,9,20,64,208,128,164,
0,72,160,8,64,208,128,159,0,128,154,0,136,166,4,0,128,162,0,74,164,18,1,
68,64,208,72,154,8,64,208,128,173,0,128,152,0,201,161,149,231,0,64,208,
201,159,18,74,0,64,208,64,151,64,208,64,157,64,208,128,158,0,137,155,5,
40,0,73,148,21,28,64,208,72,157,8,64,208,128,158,0,64,144,64,208,128,158,
0,64,145,64,208,128,163,0,64,152,64,208,128,161,0,200,157,13,0,64,208,64,
162,64,208,128,152,0,128,156,0,201,163,10,61,0,64,208,128,144,0,73,161,
9,12,64,208,128,160,0,128,160,0,64,162,64,208,64,160,64,208,64,158,64,208,
64,129,64,208,64,156,64,208,64,154,64,208,64,158,64,208,64,161,64,208,64,
162,64,208,128,152,0,136,173,4,0,128,167,0,72,160,45,64,208,137,158,5,29,
0,72,154,17,64,208,64,154,64,208,192,152,0,64,208,128,152,0,64,148,64,208,
128,162,0,72,165,8,64,208,128,152,0,128,164,0,192,159,0,64,208,137,158,
5,25,0,137,154,5,8,0,128,152,0,192,156,0,64,208,64,173,64,208,128,160,0,
136,163,4,0,128,161,0,72,163,24,64,208,137,158,5,16,0,136,154,4,0,64,147,
64,208,128,157,0,128,159,0,64,162,64,208,137,157,5,28,0,73,155,9,20,64,
208,128,144,0,72,154,8,64,208,128,145,0,128,152,0,128,156,0,137,160,5,16,
0,136,159,4,0,64,158,64,208,128,145,0,128,161,0,73,167,9,48,64,208,128,
158,0,72,166,12,64,208,64,162,64,208,128,154,0,64,165,64,208,137,157,5,
20,0,72,156,12,64,208,64,144,64,208,128,158,0,128,154,0,128,158,0,72,175,
20,64,208,136,158,4,0,64,157,64,208,64,144,64,208,128,158,0,64,173,64,208,
128,161,0,64,134,64,208,73,158,9,16,64,208,128,166,0,136,156,4,0,128,154,
0,64,160,64,208,64,164,64,208,128,158,0,64,145,64,208,201,160,10,70,0,64,
208,128,154,0,73,156,13,44,64,208,64,161,64,208,128,173,0,73,152,13,24,
64,208,136,161,4,0,128,155,0,136,150,4,0,64,144,64,208,128,158,0,64,154,
64,208,128,151,0,137,158,5,8,0,128,157,0,192,159,0,64,208,128,167,0,201,
166,14,74,0,64,208,64,147,64,208,128,152,0,73,163,25,57,64,208,136,154,
4,0,64,146,64,208,64,159,64,208,64,152,64,208,128,161,0,72,162,16,64,208,
136,161,4,0,64,152,64,208,128,157,0,192,161,0,64,208,136,158,4,0,64,156,
64,208,128,159,0,128,164,0,73,173,13,16,64,208,136,161,4,0,128,159,0,128,
168,0,128,174,0,82,148,1,2,1,232,64,208,201,156,18,132,0,64,208,64,160,
64,208,64,162,64,208,128,163,0,73,149,9,65,64,208,128,151,0,201,146,18,
37,0,64,208,137,161,5,8,0,128,156,0,128,166,0,72,144,12,64,208,136,162,
4,0,128,158,0,64,134,64,208,128,159,0,64,148,64,208,137,166,5,8,0,128,162,
0,64,174,64,208,128,162,0,201,154,14,46,0,64,208,136,162,4,0,128,145,0,
72,152,20,64,208,137,159,5,12,0,64,154,64,208,128,145,0,128,161,0,192,151,
0,64,208,136,161,4,0,128,154,0,128,155,0,73,161,9,62,64,208,128,159,0,201,
159,10,37,0,64,208,128,146,0,72,158,20,64,208,136,163,4,0,64,152,64,208,
64,164,64,208,128,154,0,64,157,64,208,128,162,0,192,160,0,64,208,72,161,
8,64,208,128,159,0,128,151,0,201,164,10,45,0,64,208,128,156,0,72,163,24,
64,208,72,152,8,64,208,128,157,0,64,146,64,208,64,152,64,208,128,157,0,
64,162,64,208,136,174,4,0,128,163,0,64,174,64,208,64,161,64,208,128,168,
0,64,147,64,208,73,159,43,157,64,208,137,159,5,34,0,200,154,13,0,64,208,
64,148,64,208,128,166,0,192,152,0,64,208,136,160,4,0,64,152,64,208,128,
175,0,128,163,0,73,154,13,57,64,208,136,158,4,0,128,154,0,73,148,13,32,
64,208,64,161,64,208,128,162,0,72,147,12,64,208,64,147,64,208,128,163,0,
64,144,64,208,128,163,0,192,152,0,64,208,64,144,64,208,128,162,0,73,157,
26,49,64,208,73,159,9,17,64,208,128,159,0,192,152,0,64,208,128,163,0,128,
161,0,64,156,64,208,73,156,13,16,64,208,64,148,64,208,128,148,0,128,154,
0,128,163,0,192,158,0,64,208,128,154,0,73,163,9,41,64,208,128,159,0,73,
161,9,20,64,208,128,146,0,64,160,64,208,64,173,64,208,128,161,0,192,162,
0,64,208,136,163,4,0,128,144,0,73,166,9,21,64,208,128,163,0,64,165,64,208,
192,159,0,64,208,128,152,0,64,173,64,208,128,148,0,64,149,64,208,73,157,
217,248,64,208,73,159,117,184,64,208,73,158,21,32,64,208,64,148,64,208,
64,160,64,208,64,175,64,208,128,148,0,64,155,64,208,64,144,64,208,128,157,
0,64,160,64,208,64,158,64,208,72,154,32,64,208,64,163,64,208,64,160,64,
208,64,144,64,208,64,162,64,208,64,163,64,208,64,160,64,208,128,144,0,64,
149,64,208,64,154,64,208,64,162,64,208,64,152,64,208,64,160,64,208,64,158,
64,208,64,146,64,208,64,169,64,208,64,152,64,208,128,154,0,73,147,21,56,
64,208,64,158,64,208,64,160,64,208,64,154,64,208,128,144,0,64,144,64,208,
64,161,64,208,64,161,64,208,64,144,64,208,64,156,64,208,64,145,64,208,64,
155,64,208,64,149,64,208,128,152,0,64,148,64,208,64,152,64,208,128,160,
0,72,168,16,64,208,64,162,64,208,64,144,64,208,128,145,0,64,161,64,208,
64,149,64,208,128,154,0,73,145,13,20,64,208,64,154,64,208,128,158,0,64,
144,64,208,128,156,0,64,156,64,208,64,158,64,208,128,161,0,73,160,13,101,
64,208,136,166,4,0,128,165,0,64,158,64,208,73,162,37,64,64,208,64,144,64,
208,64,160,64,208,64,147,64,208,64,149,64,208,64,162,64,208,64,152,64,208,
64,157,64,208,128,147,0,72,157,12,64,208,64,144,64,208,128,166,0,64,155,
64,208,64,154,64,208,64,158,64,208,128,156,0,72,173,8,64,208,128,161,0,
192,164,0,64,208,64,144,64,208,128,154,0,64,161,64,208,128,161,0,82,155,
2,89,8,5,64,208,74,159,26,2,16,64,208,137,163,5,12,0,136,161,4,0,128,148,
0,64,167,64,208,128,161,0,74,152,14,1,210,64,208,136,166,4,0,128,157,0,
74,146,14,1,193,64,208,64,161,64,208,128,173,0,136,145,4,0,64,144,64,208,
136,163,4,0,64,146,64,208,73,159,29,200,64,208,64,160,64,208,64,158,64,
208,64,164,64,208,64,158,64,208,64,145,64,208,128,160,0,73,154,21,88,64,
208,72,173,8,64,208,128,163,0,64,160,64,208,128,163,0,72,146,16,64,208,
64,160,64,208,64,144,64,208,128,167,0,64,144,64,208,72,160,40,64,208,64,
165,64,208,64,152,64,208,64,162,64,208,64,149,64,208,64,154,64,208,64,162,
64,208,64,163,64,208,64,160,64,208,128,171,0,64,159,64,208,128,163,0,72,
157,44,64,208,64,158,64,208,64,146,64,208,64,165,64,208,64,155,64,208,64,
158,64,208,64,159,64,208,64,159,64,208,64,160,64,208,64,158,64,208,128,
156,0,64,156,64,208,64,149,64,208,64,145,64,208,64,149,64,208,64,155,64,
208,64,172,64,208,64,159,64,208,64,160,64,208,64,158,64,208,128,156,0,73,
164,53,188,64,208,72,173,8,64,208,128,163,0,64,144,64,208,64,157,64,208,
64,161,64,208,64,159,64,208,64,152,64,208,64,167,64,208,64,159,64,208,64,
160,64,208,64,158,64,208,128,156,0,72,163,48,64,208,137,158,5,24,0,72,154,
8,64,208,128,161,0,64,152,64,208,64,150,64,208,128,162,0,72,160,8,64,208,
128,161,0,64,159,64,208,64,148,64,208,128,154,0,64,161,64,208,72,159,28,
64,208,64,152,64,208,64,167,64,208,64,159,64,208,64,160,64,208,64,158,64,
208,128,156,0,64,149,64,208,72,155,20,64,208,64,172,64,208,64,156,64,208,
64,144,64,208,128,168,0,64,146,64,208,64,156,64,208,64,158,64,208,64,160,
64,208,64,159,64,208,64,163,64,208,64,162,64,208,128,152,0,64,168,64,208,
64,146,64,208,64,149,64,208,64,153,64,208,64,159,64,208,64,160,64,208,64,
158,64,208,128,156,0,128,150,0,137,157,5,13,0,192,156,0,64,208,128,164,
0,64,158,64,208,136,165,4,0,64,157,64,208,64,144,64,208,64,161,64,208,128,
161,0,73,165,9,41,64,208,128,163,0,201,161,10,17,0,64,208,128,154,0,64,
160,64,208,128,160,0,64,163,64,208,64,146,64,208,64,148,64,208,128,162,
0,137,168,5,8,0,128,166,0,192,173,0,64,208,64,148,64,208,64,152,64,208,
128,161,0,82,152,2,247,3,118,64,208,74,158,23,1,131,64,208,137,146,5,8,
0,128,144,0,192,159,0,64,208,128,154,0,73,152,33,227,64,208,137,156,5,16,
0,136,152,4,0,64,146,64,208,128,162,0,136,159,4,0,64,157,64,208,128,161,
0,201,146,22,107,0,64,208,73,163,9,12,64,208,128,161,0,128,154,0,128,166,
0,200,145,37,0,64,208,73,148,9,24,64,208,128,148,0,64,144,64,208,72,175,
8,64,208,128,162,0,128,173,0,64,175,64,208,128,162,0,192,144,0,64,208,73,
157,9,28,64,208,128,158,0,73,155,9,12,64,208,128,158,0,128,145,0,64,156,
64,208,128,158,0,73,162,9,12,64,208,128,161,0,128,159,0,128,166,0,72,148,
64,64,208,73,163,9,56,64,208,128,146,0,64,160,64,208,64,158,64,208,72,160,
20,64,208,64,149,64,208,64,151,64,208,64,154,64,208,128,144,0,64,145,64,
208,64,158,64,208,64,154,64,208,64,161,64,208,128,171,0,128,166,0,64,147,
64,208,73,157,9,12,64,208,128,147,0,128,156,0,64,165,64,208,128,161,0,201,
156,30,73,0,64,208,137,161,5,16,0,137,152,5,8,0,128,151,0,128,160,0,136,
166,4,0,128,163,0,72,155,8,64,208,128,154,0,64,154,64,208,73,156,9,24,64,
208,128,151,0,72,152,12,64,208,64,156,64,208,128,159,0,128,145,0,136,159,
4,0,128,158,0,64,157,64,208,73,165,13,33,64,208,64,163,64,208,128,154,0,
72,155,17,64,208,192,158,0,64,208,64,158,64,208,128,163,0,128,152,0,64,
166,64,208,64,146,64,208,64,149,64,208,64,162,64,208,64,156,64,208,64,149,
64,208,128,162,0,202,163,23,1,47,0,64,208,137,146,5,8,0,128,144,0,64,161,
64,208,128,162,0,201,161,70,219,0,64,208,73,160,9,44,64,208,128,161,0,137,
157,5,20,0,72,156,8,64,208,128,163,0,64,148,64,208,128,152,0,72,159,12,
64,208,64,159,64,208,128,160,0,128,158,0,73,163,9,16,64,208,128,162,0,136,
162,4,0,128,161,0,128,173,0,72,160,29,64,208,137,162,5,17,0,200,161,9,0,
64,208,128,156,0,128,148,0,64,164,64,208,128,155,0,192,159,0,64,208,137,
159,5,48,0,73,155,9,16,64,208,128,152,0,136,154,4,0,128,145,0,72,158,24,
64,208,136,160,4,0,64,159,64,208,64,160,64,208,64,158,64,208,128,156,0,
128,157,0,137,166,5,64,0,136,165,4,0,64,160,64,208,64,158,64,208,73,156,
13,32,64,208,64,149,64,208,128,151,0,72,152,8,64,208,128,146,0,64,147,64,
208,64,158,64,208,128,160,0,64,162,64,208,64,149,64,208,64,159,64,208,128,
161,0,128,173,0,192,162,0,64,208,73,156,9,41,64,208,128,158,0,73,152,22,
29,64,208,200,161,13,0,64,208,64,173,64,208,128,152,0,128,160,0,64,144,
64,208,128,159,0,128,154,0,137,160,5,12,0,64,158,64,208,128,161,0,128,161,
0,137,166,5,33,0,72,165,8,64,208,128,155,0,64,164,64,208,201,154,10,13,
0,64,208,128,163,0,128,144,0,128,158,0,192,173,0,64,208,137,163,5,12,0,
136,152,4,0,128,146,0,64,164,64,208,64,159,64,208,128,162,0,64,151,64,208,
73,161,13,92,64,208,136,161,4,0,128,144,0,73,152,13,40,64,208,64,154,64,
208,128,156,0,137,150,5,16,0,64,144,64,208,136,161,4,0,128,144,0,64,151,
64,208,64,159,64,208,128,156,0,73,158,17,20,64,208,72,166,8,64,208,128,
156,0,128,161,0,128,154,0,64,159,64,208,137,158,5,12,0,136,148,4,0,128,
145,0,128,163,0,137,165,5,20,0,137,163,5,8,0,128,162,0,64,164,64,208,128,
161,0,137,168,5,8,0,128,167,0,128,173,0,192,154,0,64,208,202,157,57,1,4,
0,64,208,73,159,18,37,64,208,200,166,9,0,64,208,128,165,0,128,159,0,72,
152,16,64,208,64,159,64,208,64,144,64,208,128,161,0,128,145,0,136,166,4,
0,192,162,0,64,208,128,166,0,137,150,5,111,0,73,146,25,69,64,208,137,148,
5,12,0,136,147,4,0,128,146,0,136,160,4,0,128,152,0,73,144,25,28,64,208,
137,162,5,12,0,136,159,4,0,128,155,0,64,173,64,208,128,161,0,128,134,0,
192,145,0,64,208,64,161,64,208,64,156,64,208,128,159,0,200,148,29,0,64,
208,137,163,5,20,0,136,159,4,0,64,145,64,208,64,146,64,208,128,159,0,128,
166,0,192,147,0,64,208,128,148,0,73,154,29,64,64,208,137,158,5,20,0,72,
147,8,64,208,128,151,0,64,145,64,208,128,146,0,128,159,0,72,152,32,64,208,
73,157,9,24,64,208,128,159,0,72,151,8,64,208,128,160,0,64,144,64,208,128,
173,0,128,175,0,128,151,0,200,156,17,0,64,208,72,167,8,64,208,128,159,0,
128,146,0,64,155,64,208,136,158,4,0,128,146,0,73,164,13,218,64,208,136,
163,4,0,128,162,0,201,161,27,173,0,64,208,137,161,5,12,0,64,154,64,208,
128,158,0,192,173,0,64,208,128,157,0,201,159,46,87,0,64,208,137,151,5,24,
0,137,148,5,16,0,136,146,4,0,64,145,64,208,128,147,0,128,150,0,137,166,
5,12,0,136,163,4,0,128,161,0,128,167,0,192,158,0,64,208,137,157,5,25,0,
137,148,5,12,0,64,147,64,208,128,147,0,192,151,0,64,208,128,159,0,136,162,
4,0,64,158,64,208,128,157,0,64,160,64,208,137,164,5,40,0,137,161,5,32,0,
72,160,20,64,208,137,161,5,8,0,128,158,0,64,164,64,208,128,163,0,64,154,
64,208,128,160,0,128,163,0,137,167,5,12,0,64,166,64,208,128,145,0,128,173,
0,200,163,17,0,64,208,136,159,4,0,64,147,64,208,128,152,0,64,162,64,208,
136,163,4,0,64,152,64,208,128,163,0,201,167,14,59,0,64,208,136,161,4,0,
128,159,0,200,166,42,0,64,208,137,156,5,29,0,192,145,0,64,208,72,164,8,
64,208,128,160,0,64,152,64,208,64,164,64,208,128,160,0,64,159,64,208,128,
161,0,128,165,0,72,175,13,64,208,192,160,0,64,208,128,163,0,64,173,64,208,
136,162,4,0,128,161,0,80,157,1,238,64,208,202,158,31,1,55,0,64,208,137,
159,5,20,0,64,154,64,208,72,148,8,64,208,128,166,0,128,145,0,128,163,0,
137,151,5,46,0,73,146,9,38,64,208,128,159,0,200,145,9,0,64,208,128,161,
0,192,144,0,64,208,72,166,12,64,208,64,161,64,208,128,159,0,128,163,0,128,
147,0,137,155,5,215,0,72,154,46,64,208,201,158,14,30,0,64,208,64,151,64,
208,128,168,0,137,152,5,13,0,192,144,0,64,208,128,160,0,128,154,0,137,162,
5,8,0,128,160,0,128,166,0,192,152,0,64,208,73,157,13,119,64,208,64,147,
64,208,128,152,0,73,154,13,99,64,208,136,159,4,0,128,152,0,192,152,0,64,
208,73,156,13,44,64,208,136,173,4,0,128,159,0,137,152,5,24,0,72,147,8,64,
208,128,144,0,64,144,64,208,136,162,4,0,128,161,0,64,155,64,208,128,166,
0,201,161,10,26,0,64,208,128,158,0,192,160,0,64,208,64,144,64,208,64,157,
64,208,128,161,0,64,164,64,208,64,154,64,208,128,161,0,64,156,64,208,128,
144,0,201,166,18,29,0,64,208,64,146,64,208,64,158,64,208,128,154,0,64,158,
64,208,64,156,64,208,128,156,0,64,173,64,208,64,154,64,208,128,166,0,64,
156,64,208,73,156,9,12,64,208,128,166,0,128,146,0,128,166,0,201,164,15,
108,0,64,208,192,144,0,64,208,128,160,0,201,161,14,61,0,64,208,136,163,
4,0,128,161,0,136,160,4,0,64,159,64,208,73,160,13,28,64,208,64,154,64,208,
128,166,0,137,158,5,12,0,136,154,4,0,128,145,0,128,159,0,137,164,5,8,0,
128,161,0,128,166,0,192,162,0,64,208,137,161,5,16,0,137,152,5,8,0,128,145,
0,128,159,0,137,166,5,8,0,128,163,0,128,173,0,201,167,10,62,0,64,208,128,
168,0,192,166,0,64,208,73,155,9,24,64,208,128,161,0,73,146,9,12,64,208,
128,145,0,128,144,0,128,154,0,73,159,9,12,64,208,128,156,0,128,157,0,64,
161,64,208,64,161,64,208,128,159,0,64,173,64,208,128,163,0,64,156,64,208,
73,157,17,226,64,208,136,163,4,0,64,151,64,208,128,152,0,73,149,21,88,64,
208,72,162,12,64,208,64,144,64,208,128,163,0,128,160,0,73,146,17,48,64,
208,137,158,5,8,0,128,154,0,128,166,0,72,145,8,64,208,128,154,0,64,144,
64,208,73,157,9,12,64,208,128,158,0,128,145,0,64,161,64,208,128,161,0,72,
148,8,64,208,128,162,0,64,147,64,208,136,161,4,0,128,154,0,73,154,29,94,
64,208,137,159,5,12,0,64,152,64,208,128,157,0,64,173,64,208,64,148,64,208,
128,152,0,200,152,45,0,64,208,137,158,5,32,0,73,155,17,20,64,208,64,152,
64,208,64,154,64,208,128,144,0,128,152,0,64,157,64,208,128,146,0,136,166,
4,0,128,160,0,192,151,0,64,208,73,160,9,12,64,208,128,154,0,128,149,0,128,
168,0,72,156,16,64,208,64,162,64,208,64,162,64,208,128,163,0,64,155,64,
208,136,152,4,0,128,150,0,73,166,17,150,64,208,72,152,8,64,208,128,162,
0,128,145,0,73,161,47,85,64,208,137,157,5,24,0,137,152,5,12,0,64,145,64,
208,128,145,0,64,154,64,208,128,166,0,200,161,14,0,64,208,192,145,0,64,
208,128,145,0,128,159,0,200,159,22,0,64,208,201,159,10,13,0,64,208,128,
154,0,128,152,0,128,160,0,192,158,0,64,208,136,162,4,0,64,152,64,208,128,
166,0,200,163,21,0,64,208,72,173,12,64,208,64,148,64,208,128,152,0,128,
159,0,64,162,64,208,73,162,9,20,64,208,128,161,0,136,161,4,0,64,144,64,
208,128,159,0,128,163,0,73,169,9,16,64,208,128,159,0,136,168,4,0,128,167,
0,64,173,64,208,72,157,8,64,208,128,160,0,128,154,0,82,166,1,194,16,37,
64,208,201,157,30,254,0,64,208,73,156,9,16,64,208,128,145,0,136,154,4,0,
128,144,0,136,162,4,0,128,160,0,73,150,9,113,64,208,128,161,0,73,146,13,
69,64,208,136,160,4,0,128,159,0,200,145,25,0,64,208,137,162,5,12,0,136,
161,4,0,128,152,0,64,164,64,208,128,160,0,64,144,64,208,137,161,5,12,0,
136,154,4,0,128,147,0,64,165,64,208,64,152,64,208,64,162,64,208,128,158,
0,72,148,20,64,208,137,162,5,12,0,64,159,64,208,128,158,0,128,163,0,64,
147,64,208,64,161,64,208,64,173,64,208,128,157,0,201,154,22,75,0,64,208,
137,161,5,12,0,136,151,4,0,128,148,0,128,163,0,72,152,41,64,208,73,162,
9,25,64,208,128,158,0,72,159,13,64,208,192,154,0,64,208,128,161,0,128,152,
0,72,164,8,64,208,128,154,0,128,163,0,192,151,0,64,208,136,167,4,0,128,
157,0,64,156,64,208,201,159,10,21,0,64,208,128,159,0,72,156,8,64,208,128,
154,0,128,152,0,64,161,64,208,64,152,64,208,128,160,0,73,163,29,160,64,
208,73,156,9,16,64,208,128,161,0,64,154,64,208,128,161,0,64,160,64,208,
128,161,0,73,160,37,94,64,208,137,159,5,24,0,73,154,9,16,64,208,128,159,
0,64,148,64,208,128,158,0,128,158,0,136,162,4,0,128,160,0,200,159,30,0,
64,208,201,159,14,21,0,64,208,64,146,64,208,128,148,0,136,152,4,0,128,146,
0,128,162,0,64,158,64,208,73,155,17,20,64,208,64,152,64,208,64,164,64,208,
128,154,0,128,152,0,128,160,0,200,162,9,0,64,208,128,156,0,192,161,0,64,
208,137,161,5,16,0,72,156,8,64,208,128,161,0,128,152,0,64,173,64,208,128,
157,0,137,173,5,21,0,200,165,13,0,64,208,64,160,64,208,128,156,0,128,164,
0,64,175,64,208,128,157,0,74,162,222,7,28,64,208,201,157,10,95,0,64,208,
128,144,0,201,152,18,51,0,64,208,136,162,4,0,64,152,64,208,128,175,0,201,
150,10,22,0,64,208,128,162,0,200,148,9,0,64,208,128,163,0,128,147,0,64,
151,64,208,136,158,4,0,128,144,0,201,155,10,18,0,64,208,128,154,0,192,154,
0,64,208,128,151,0,192,156,0,64,208,72,161,8,64,208,128,165,0,128,158,0,
201,163,26,96,0,64,208,72,146,12,64,208,64,154,64,208,128,161,0,64,144,
64,208,128,173,0,73,160,9,42,64,208,128,154,0,72,159,25,64,208,73,151,9,
17,64,208,128,161,0,192,144,0,64,208,128,163,0,128,158,0,192,158,0,64,208,
128,158,0,192,161,0,64,208,73,161,9,20,64,208,128,162,0,136,154,4,0,64,
145,64,208,128,162,0,128,163,0,137,167,5,8,0,128,166,0,192,173,0,64,208,
137,161,5,8,0,128,159,0,128,163,0,82,160,2,119,3,254,64,208,74,159,22,1,
196,64,208,137,161,5,12,0,136,152,4,0,128,151,0,128,162,0,74,152,22,1,22,
64,208,72,159,12,64,208,64,158,64,208,128,156,0,128,152,0,73,147,17,216,
64,208,136,163,4,0,64,156,64,208,128,163,0,73,145,9,180,64,208,128,161,
0,64,144,64,208,73,157,21,116,64,208,64,168,64,208,64,155,64,208,64,144,
64,208,128,154,0,137,151,5,56,0,72,148,44,64,208,72,161,20,64,208,64,158,
64,208,64,146,64,208,64,149,64,208,128,162,0,64,159,64,208,64,155,64,208,
64,144,64,208,64,157,64,208,128,163,0,64,146,64,208,128,162,0,64,156,64,
208,64,159,64,208,64,155,64,208,64,144,64,208,64,161,64,208,64,162,64,208,
64,152,64,208,64,157,64,208,64,154,64,208,128,144,0,137,163,5,32,0,72,161,
20,64,208,72,152,8,64,208,128,161,0,64,149,64,208,128,162,0,64,159,64,208,
128,152,0,64,164,64,208,64,157,64,208,64,152,64,208,64,154,64,208,128,152,
0,64,146,64,208,137,155,5,12,0,136,151,4,0,128,134,0,128,166,0,200,151,
13,0,64,208,64,162,64,208,128,161,0,64,148,64,208,137,159,5,20,0,72,157,
8,64,208,128,162,0,64,150,64,208,128,146,0,128,162,0,201,156,18,41,0,64,
208,137,164,5,8,0,128,158,0,128,166,0,136,155,4,0,64,154,64,208,137,160,
5,12,0,136,159,4,0,128,145,0,128,166,0,72,158,80,64,208,73,158,9,60,64,
208,128,156,0,73,151,37,44,64,208,72,158,20,64,208,64,162,64,208,64,160,
64,208,64,158,64,208,128,161,0,64,157,64,208,64,152,64,208,128,152,0,64,
146,64,208,128,148,0,64,157,64,208,128,163,0,137,163,5,12,0,64,160,64,208,
128,158,0,128,166,0,64,157,64,208,73,160,9,16,64,208,128,156,0,136,156,
4,0,128,151,0,136,163,4,0,64,162,64,208,128,152,0,73,165,9,106,64,208,128,
160,0,73,162,13,29,64,208,136,163,4,0,128,161,0,200,161,13,0,64,208,136,
152,4,0,128,145,0,128,160,0,72,164,12,64,208,136,159,4,0,128,155,0,192,
163,0,64,208,72,158,12,64,208,64,146,64,208,128,148,0,64,151,64,208,72,
161,12,64,208,64,161,64,208,128,160,0,64,158,64,208,64,159,64,208,64,158,
64,208,64,162,64,208,64,158,64,208,128,154,0,137,169,5,37,0,72,167,12,64,
208,136,166,4,0,128,161,0,192,166,0,64,208,72,160,8,64,208,128,164,0,64,
144,64,208,128,161,0,72,174,8,64,208,128,145,0,192,173,0,64,208,137,161,
5,8,0,128,159,0,64,162,64,208,128,162,0,64,159,64,208,73,158,17,204,64,
208,72,164,8,64,208,128,152,0,128,148,0,73,150,9,85,64,208,128,159,0,73,
146,29,60,64,208,73,160,9,16,64,208,128,148,0,136,154,4,0,128,148,0,136,
166,4,0,128,161,0,72,145,20,64,208,137,163,5,12,0,136,151,4,0,128,144,0,
128,173,0,64,144,64,208,136,148,4,0,128,145,0,200,148,9,0,64,208,128,151,
0,64,147,64,208,128,163,0,201,154,34,53,0,64,208,137,158,5,20,0,73,152,
9,12,64,208,128,158,0,128,151,0,128,154,0,136,163,4,0,128,159,0,72,152,
12,64,208,136,146,4,0,128,145,0,64,151,64,208,128,163,0,200,157,25,0,64,
208,73,162,9,16,64,208,128,145,0,136,159,4,0,128,148,0,128,163,0,192,156,
0,64,208,73,159,9,16,64,208,128,154,0,136,154,4,0,128,144,0,128,162,0,201,
164,30,152,0,64,208,137,154,5,16,0,64,152,64,208,64,152,64,208,128,160,
0,64,161,64,208,128,147,0,201,161,39,86,0,64,208,137,159,5,16,0,137,152,
5,8,0,128,146,0,128,154,0,137,163,5,13,0,192,161,0,64,208,128,147,0,128,
167,0,72,160,24,64,208,137,163,5,8,0,128,154,0,64,173,64,208,136,163,4,
0,128,159,0,64,159,64,208,73,150,9,16,64,208,128,162,0,64,144,64,208,128,
162,0,128,167,0,72,163,8,64,208,128,146,0,192,162,0,64,208,137,152,5,16,
0,136,148,4,0,64,146,64,208,128,161,0,136,159,4,0,128,154,0,73,167,9,16,
64,208,128,149,0,136,166,4,0,128,165,0,136,175,4,0,64,173,64,208,136,163,
4,0,128,161,0,64,161,64,208,202,157,47,1,38,0,64,208,137,154,5,20,0,137,
147,5,12,0,136,146,4,0,128,145,0,128,151,0,137,161,5,12,0,136,158,4,0,128,
156,0,64,162,64,208,128,152,0,73,149,9,129,64,208,128,151,0,73,146,45,85,
64,208,73,159,9,24,64,208,128,159,0,73,151,9,12,64,208,128,159,0,128,147,
0,128,158,0,137,166,5,12,0,64,161,64,208,128,154,0,128,167,0,72,145,28,
64,208,73,162,9,16,64,208,128,158,0,64,148,64,208,128,148,0,64,173,64,208,
128,159,0,192,144,0,64,208,136,163,4,0,128,148,0,72,148,20,64,208,73,158,
9,12,64,208,128,163,0,128,145,0,128,165,0,64,147,64,208,137,147,5,8,0,128,
144,0,128,162,0,201,154,44,68,0,64,208,73,155,9,21,64,208,128,161,0,136,
154,4,0,192,145,0,64,208,128,146,0,192,162,0,64,208,137,145,5,8,0,128,144,
0,128,152,0,72,152,12,64,208,136,152,4,0,128,151,0,192,151,0,64,208,136,
157,4,0,128,152,0,200,156,39,0,64,208,201,160,10,26,0,64,208,128,158,0,
72,158,8,64,208,128,161,0,192,154,0,64,208,128,160,0,64,161,64,208,128,
173,0,64,155,64,208,136,158,4,0,128,144,0,201,163,14,234,0,64,208,64,161,
64,208,128,158,0,73,160,37,136,64,208,73,156,9,16,64,208,128,151,0,136,
154,4,0,128,151,0,72,159,8,64,208,128,144,0,64,157,64,208,128,152,0,72,
159,54,64,208,201,154,10,29,0,64,208,128,145,0,73,151,9,16,64,208,128,156,
0,136,148,4,0,128,147,0,128,152,0,137,161,5,13,0,192,159,0,64,208,128,161,
0,64,162,64,208,128,161,0,192,158,0,64,208,201,154,10,29,0,64,208,128,158,
0,137,148,5,12,0,64,146,64,208,128,147,0,64,149,64,208,128,152,0,137,159,
5,8,0,128,158,0,128,163,0,72,162,20,64,208,137,162,5,12,0,64,144,64,208,
128,154,0,128,163,0,192,161,0,64,208,73,156,9,36,64,208,128,159,0,137,148,
5,16,0,136,146,4,0,64,145,64,208,128,162,0,136,154,4,0,64,151,64,208,128,
147,0,137,160,5,12,0,136,158,4,0,128,157,0,136,167,4,0,64,161,64,208,128,
148,0,73,173,21,37,64,208,137,161,5,12,0,136,157,4,0,128,148,0,128,163,
0,200,167,9,0,64,208,128,161,0,64,165,64,208,128,156,0,64,174,64,208,128,
162,0,74,164,199,7,12,64,208,73,158,25,95,64,208,136,162,4,0,64,156,64,
208,64,163,64,208,64,160,64,208,128,167,0,201,152,10,46,0,64,208,128,160,
0,73,149,9,29,64,208,128,157,0,200,147,9,0,64,208,128,161,0,64,144,64,208,
136,159,4,0,128,154,0,64,151,64,208,128,157,0,73,156,9,21,64,208,128,152,
0,192,154,0,64,208,136,163,4,0,128,145,0,128,157,0,201,163,10,78,0,64,208,
128,159,0,73,160,13,33,64,208,64,156,64,208,128,159,0,64,159,64,208,64,
156,64,208,192,159,0,64,208,64,146,64,208,128,158,0,64,161,64,208,137,158,
5,20,0,136,157,4,0,64,156,64,208,64,150,64,208,128,161,0,72,162,8,64,208,
128,156,0,128,161,0,137,166,5,12,0,64,164,64,208,128,152,0,64,173,64,208,
128,163,0,192,163,0,64,208,74,158,88,3,247,64,208,201,159,10,37,0,64,208,
128,158,0,137,151,5,16,0,136,146,4,0,64,145,64,208,128,160,0,64,158,64,
208,136,161,4,0,128,159,0,201,162,26,41,0,64,208,72,158,16,64,208,64,152,
64,208,64,162,64,208,128,154,0,128,154,0,136,161,4,0,64,160,64,208,136,
157,4,0,128,148,0,128,168,0,202,151,57,2,68,0,64,208,73,156,9,36,64,208,
128,158,0,64,144,64,208,73,158,9,16,64,208,128,158,0,64,156,64,208,128,
158,0,64,161,64,208,128,158,0,192,160,0,64,208,192,158,0,64,208,128,158,
0,74,147,136,1,199,64,208,73,156,13,65,64,208,136,161,4,0,128,160,0,73,
147,13,37,64,208,136,159,4,0,128,157,0,137,145,5,17,0,192,144,0,64,208,
136,154,4,0,128,152,0,64,146,64,208,128,164,0,137,151,5,12,0,64,148,64,
208,128,159,0,128,154,0,73,161,21,53,64,208,137,154,5,12,0,64,151,64,208,
128,157,0,128,158,0,73,158,13,16,64,208,64,167,64,208,128,161,0,128,157,
0,192,159,0,64,208,137,158,5,8,0,128,145,0,128,161,0,136,168,4,0,64,162,
64,208,128,154,0,73,145,160,199,64,208,73,158,30,90,64,208,73,157,9,12,
64,208,128,158,0,128,151,0,192,159,0,64,208,64,152,64,208,128,154,0,73,
152,13,32,64,208,64,151,64,208,128,152,0,73,148,9,12,64,208,128,148,0,128,
145,0,64,151,64,208,128,163,0,72,157,12,64,208,64,158,64,208,128,157,0,
192,154,0,64,208,72,158,8,64,208,128,156,0,128,154,0,73,165,13,29,64,208,
64,161,64,208,128,161,0,137,161,5,8,0,128,159,0,192,162,0,64,208,128,155,
0,72,174,12,64,208,64,161,64,208,128,162,0,64,173,64,208,136,159,4,0,64,
154,64,208,64,158,64,208,64,161,64,208,128,158,0,64,144,64,208,137,154,
5,20,0,137,148,5,8,0,128,147,0,64,152,64,208,128,147,0,137,161,5,8,0,128,
159,0,64,162,64,208,128,159,0,64,146,64,208,137,158,5,76,0,201,148,19,51,
0,64,208,192,162,0,64,208,64,152,64,208,128,161,0,200,146,21,0,64,208,137,
160,5,8,0,128,158,0,64,163,64,208,128,151,0,64,145,64,208,64,152,64,208,
128,164,0,200,154,13,0,64,208,136,158,4,0,128,146,0,64,150,64,208,128,148,
0,73,161,13,24,64,208,64,152,64,208,128,157,0,136,160,4,0,64,159,64,208,
128,161,0,72,168,8,64,208,128,173,0,192,163,0,64,208,128,151,0,72,150,16,
64,208,137,158,5,8,0,128,144,0,128,165,0,64,148,64,208,73,161,13,37,64,
208,136,160,4,0,128,159,0,137,154,5,16,0,64,152,64,208,64,162,64,208,128,
165,0,192,158,0,64,208,128,148,0,72,173,8,64,208,128,159,0,128,165,0,73,
155,81,226,64,208,73,152,13,52,64,208,64,162,64,208,128,163,0,73,147,21,
28,64,208,72,162,8,64,208,128,161,0,64,156,64,208,128,159,0,64,144,64,208,
128,147,0,64,150,64,208,64,148,64,208,128,161,0,73,159,13,20,64,208,136,
161,4,0,128,159,0,64,155,64,208,128,159,0,128,164,0,72,154,57,64,208,137,
159,5,41,0,73,156,13,29,64,208,64,144,64,208,128,168,0,72,152,8,64,208,
128,161,0,192,146,0,64,208,128,146,0,64,158,64,208,128,161,0,137,161,5,
8,0,128,160,0,128,165,0,64,152,64,208,137,157,5,38,0,73,154,9,26,64,208,
128,162,0,200,152,14,0,64,208,192,152,0,64,208,128,152,0,128,151,0,64,156,
64,208,128,166,0,201,161,10,26,0,64,208,128,160,0,200,159,9,0,64,208,128,
159,0,64,158,64,208,128,157,0,192,162,0,64,208,73,155,9,12,64,208,128,154,
0,128,154,0,128,163,0,200,157,49,0,64,208,137,159,5,36,0,137,145,5,16,0,
64,144,64,208,64,160,64,208,128,145,0,64,152,64,208,72,159,8,64,208,128,
162,0,128,158,0,136,166,4,0,128,160,0,64,156,64,208,73,159,13,41,64,208,
64,146,64,208,128,158,0,73,156,13,25,64,208,64,144,64,208,128,168,0,136,
151,4,0,192,146,0,64,208,128,161,0,128,158,0,73,167,9,24,64,208,128,161,
0,72,162,12,64,208,136,161,4,0,128,158,0,128,160,0,128,174,0,74,164,64,
1,234,64,208,73,161,21,37,64,208,72,161,8,64,208,128,159,0,64,152,64,208,
128,157,0,72,160,8,64,208,128,161,0,192,154,0,64,208,128,161,0,64,162,64,
208,192,148,0,64,208,64,152,64,208,64,162,64,208,128,160,0,74,161,126,1,
80,64,208,73,154,9,49,64,208,128,144,0,73,148,9,20,64,208,128,161,0,136,
145,4,0,64,144,64,208,128,148,0,72,152,12,64,208,64,156,64,208,128,151,
0,192,151,0,64,208,128,157,0,201,165,10,47,0,64,208,128,159,0,72,162,20,
64,208,136,156,4,0,64,144,64,208,64,162,64,208,128,162,0,192,156,0,64,208,
192,159,0,64,208,64,146,64,208,128,158,0,136,173,4,0,64,168,64,208,64,158,
64,208,64,148,64,208,64,158,64,208,128,160,0,200,160,81,0,64,208,73,160,
13,56,64,208,64,161,64,208,128,161,0,73,154,17,32,64,208,136,156,4,0,64,
154,64,208,128,144,0,72,146,12,64,208,136,158,4,0,128,148,0,128,145,0,64,
158,64,208,64,157,64,208,128,166,0,137,168,5,12,0,64,161,64,208,128,159,
0,64,173,64,208,128,159,0,192,159,0,64,208,137,158,5,61,0,73,147,9,37,64,
208,128,145,0,137,145,5,12,0,64,144,64,208,128,158,0,192,146,0,64,208,137,
152,5,8,0,128,146,0,128,158,0,72,152,12,64,208,64,154,64,208,128,161,0,
64,148,64,208,128,158,0,73,162,25,48,64,208,73,156,13,16,64,208,64,144,
64,208,128,168,0,128,152,0,128,160,0,137,160,5,16,0,64,159,64,208,64,154,
64,208,128,144,0,64,161,64,208,128,158,0,72,173,12,64,208,64,157,64,208,
128,156,0,128,164,0,200,163,17,0,64,208,136,160,4,0,64,144,64,208,128,156,
0,192,162,0,64,208,73,157,21,44,64,208,136,160,4,0,64,152,64,208,64,162,
64,208,128,158,0,73,152,9,16,64,208,128,148,0,64,144,64,208,128,159,0,64,
156,64,208,128,158,0,73,160,9,12,64,208,128,148,0,128,158,0,192,161,0,64,
208,64,151,64,208,128,157,0,73,167,9,48,64,208,128,161,0,72,166,36,64,208,
73,156,13,20,64,208,64,152,64,208,128,151,0,136,152,4,0,128,145,0,72,173,
8,64,208,128,152,0,128,160,0,128,165,0,72,174,12,64,208,64,157,64,208,128,
158,0,64,173,64,208,73,160,17,24,64,208,72,152,8,64,208,128,162,0,128,146,
0,136,159,4,0,128,152,0,136,164,4,0,128,161,0,64,165,64,208,73,162,9,44,
64,208,128,162,0,73,156,17,20,64,208,136,161,4,0,64,144,64,208,128,154,
0,128,154,0,64,159,64,208,137,151,5,8,0,128,144,0,128,154,0,72,173,8,64,
208,128,173,0,128,167,0,74,173,230,1,86,64,208,73,157,21,122,64,208,136,
152,4,0,64,144,64,208,64,151,64,208,128,156,0,137,151,5,24,0,137,146,5,
12,0,136,145,4,0,128,144,0,64,147,64,208,128,165,0,73,155,13,70,64,208,
64,163,64,208,128,148,0,200,154,45,0,64,208,73,160,9,16,64,208,128,161,
0,136,156,4,0,128,154,0,136,166,4,0,64,162,64,208,64,149,64,208,64,156,
64,208,64,144,64,208,128,161,0,192,152,0,64,208,64,162,64,208,128,152,0,
64,156,64,208,128,151,0,201,162,10,80,0,64,208,128,161,0,73,160,9,48,64,
208,128,145,0,72,159,8,64,208,128,148,0,64,158,64,208,72,156,8,64,208,128,
166,0,64,155,64,208,64,159,64,208,64,148,64,208,64,152,64,208,128,154,0,
192,161,0,64,208,200,157,9,0,64,208,128,159,0,192,154,0,64,208,128,158,
0,137,164,5,13,0,192,163,0,64,208,128,162,0,192,173,0,64,208,128,152,0,
201,168,62,97,0,64,208,137,157,5,32,0,73,152,9,24,64,208,128,161,0,72,146,
12,64,208,64,161,64,208,128,156,0,128,145,0,128,154,0,73,159,13,16,64,208,
64,158,64,208,128,154,0,128,158,0,64,161,64,208,128,144,0,64,167,64,208,
137,160,5,16,0,136,159,4,0,64,144,64,208,128,160,0,64,167,64,208,64,152,
64,208,64,151,64,208,128,156,0,64,169,64,208,136,163,4,0,64,146,64,208,
128,163,0,72,175,36,64,208,73,160,13,24,64,208,64,157,64,208,128,154,0,
136,159,4,0,64,151,64,208,128,145,0,64,173,64,208,128,159,0,64,174,64,208,
128,154,0,64,149,64,208,74,157,163,9,136,64,208,201,159,14,112,0,64,208,
64,161,64,208,128,156,0,73,152,17,49,64,208,137,159,5,8,0,128,158,0,128,
160,0,73,146,9,25,64,208,128,148,0,64,144,64,208,200,158,9,0,64,208,128,
164,0,128,154,0,64,148,64,208,128,146,0,73,156,9,33,64,208,128,166,0,64,
154,64,208,137,156,5,13,0,192,144,0,64,208,128,160,0,64,159,64,208,128,
160,0,192,157,0,64,208,136,162,4,0,64,146,64,208,128,148,0,201,164,10,25,
0,64,208,128,154,0,137,162,5,12,0,64,161,64,208,128,151,0,128,163,0,137,
168,5,12,0,64,165,64,208,128,154,0,64,173,64,208,128,161,0,74,149,31,5,
70,64,208,73,161,9,21,64,208,128,161,0,200,154,9,0,64,208,128,146,0,128,
144,0,128,164,0,82,146,1,113,3,44,64,208,73,158,9,65,64,208,128,164,0,73,
148,9,41,64,208,128,161,0,137,145,5,16,0,64,144,64,208,64,154,64,208,128,
163,0,64,146,64,208,64,144,64,208,192,163,0,64,208,128,155,0,72,157,12,
64,208,64,156,64,208,128,158,0,128,151,0,74,162,10,1,25,64,208,128,162,
0,73,160,225,242,64,208,73,152,17,56,64,208,64,173,64,208,64,156,64,208,
128,152,0,64,144,64,208,72,151,28,64,208,72,173,8,64,208,128,154,0,64,145,
64,208,64,144,64,208,64,157,64,208,128,154,0,64,144,64,208,128,161,0,64,
158,64,208,73,159,37,108,64,208,64,144,64,208,64,160,64,208,64,155,64,208,
64,144,64,208,64,156,64,208,64,149,64,208,64,157,64,208,128,162,0,73,147,
29,40,64,208,64,144,64,208,64,151,64,208,64,145,64,208,64,144,64,208,64,
157,64,208,128,154,0,64,145,64,208,64,144,64,208,128,154,0,64,154,64,208,
64,158,64,208,64,156,64,208,64,152,64,208,64,161,64,208,64,161,64,208,64,
152,64,208,128,175,0,72,162,12,64,208,64,144,64,208,128,161,0,64,161,64,
208,72,163,8,64,208,128,148,0,64,158,64,208,72,174,8,64,208,128,151,0,64,
146,64,208,64,149,64,208,64,162,64,208,128,144,0,192,159,0,64,208,192,158,
0,64,208,64,167,64,208,128,175,0,192,161,0,64,208,72,159,8,64,208,128,148,
0,192,154,0,64,208,72,162,8,64,208,128,156,0,128,156,0,72,173,12,64,208,
136,161,4,0,128,147,0,128,164,0,82,144,1,92,1,99,64,208,73,156,21,127,64,
208,64,162,64,208,136,159,4,0,64,155,64,208,128,166,0,73,149,13,57,64,208,
136,157,4,0,128,154,0,73,146,9,24,64,208,128,148,0,72,145,8,64,208,128,
160,0,64,144,64,208,128,144,0,200,148,13,0,64,208,136,158,4,0,128,154,0,
64,147,64,208,128,158,0,201,154,14,42,0,64,208,136,162,4,0,128,161,0,72,
152,21,64,208,72,163,8,64,208,128,159,0,192,161,0,64,208,128,162,0,64,151,
64,208,128,144,0,64,155,64,208,128,144,0,73,162,37,178,64,208,137,161,5,
12,0,136,160,4,0,128,144,0,72,173,8,64,208,128,154,0,64,163,64,208,64,147,
64,208,128,144,0,73,159,9,34,64,208,128,145,0,200,158,9,0,64,208,128,161,
0,192,157,0,64,208,72,162,8,64,208,128,154,0,128,152,0,72,161,78,64,208,
137,159,5,49,0,137,152,5,41,0,200,148,25,0,64,208,72,158,8,64,208,128,163,
0,64,154,64,208,64,152,64,208,128,163,0,64,144,64,208,64,159,64,208,128,
160,0,128,154,0,137,162,5,8,0,128,161,0,192,163,0,64,208,136,159,4,0,64,
148,64,208,128,161,0,192,160,0,64,208,73,155,9,21,64,208,128,161,0,192,
144,0,64,208,64,151,64,208,128,144,0,128,158,0,73,165,9,24,64,208,128,155,
0,136,164,4,0,64,163,64,208,64,152,64,208,128,147,0,64,166,64,208,64,161,
64,208,128,152,0,64,134,64,208,128,161,0,64,145,64,208,137,157,5,48,0,73,
149,21,40,64,208,64,155,64,208,64,148,64,208,64,158,64,208,128,161,0,72,
146,16,64,208,137,160,5,8,0,128,144,0,128,163,0,128,144,0,128,150,0,137,
165,5,29,0,192,160,0,64,208,137,161,5,16,0,136,160,4,0,64,152,64,208,128,
160,0,128,164,0,64,166,64,208,128,163,0,72,148,106,64,208,73,158,9,53,64,
208,128,164,0,73,148,13,28,64,208,136,166,4,0,128,161,0,136,146,4,0,64,
144,64,208,64,159,64,208,128,161,0,72,157,8,64,208,128,164,0,192,154,0,
64,208,128,161,0,73,163,9,36,64,208,128,156,0,72,161,8,64,208,128,148,0,
64,160,64,208,72,159,12,64,208,64,158,64,208,128,163,0,128,158,0,64,166,
64,208,192,163,0,64,208,128,159,0,64,147,64,208,73,159,17,143,64,208,137,
160,5,8,0,128,152,0,128,163,0,201,154,10,86,0,64,208,128,158,0,201,148,
14,61,0,64,208,136,161,4,0,128,146,0,72,145,12,64,208,64,148,64,208,128,
157,0,64,144,64,208,73,159,9,20,64,208,128,161,0,136,158,4,0,64,152,64,
208,128,161,0,136,164,4,0,64,160,64,208,128,155,0,64,152,64,208,72,162,
8,64,208,128,161,0,128,156,0,73,156,17,24,64,208,137,154,5,8,0,128,151,
0,128,163,0,64,155,64,208,128,163,0,192,157,0,64,208,72,158,8,64,208,128,
154,0,128,154,0,201,163,14,221,0,64,208,64,173,64,208,128,161,0,201,161,
84,192,0,64,208,137,156,5,38,0,201,148,14,25,0,64,208,64,158,64,208,128,
163,0,72,146,8,64,208,128,166,0,128,145,0,192,154,0,64,208,128,162,0,73,
163,13,32,64,208,64,159,64,208,128,148,0,72,158,16,64,208,64,157,64,208,
64,159,64,208,128,158,0,128,157,0,64,173,64,208,128,156,0,192,160,0,64,
208,201,158,26,62,0,64,208,73,154,9,16,64,208,128,161,0,64,147,64,208,128,
148,0,128,157,0,137,154,5,24,0,72,152,16,64,208,72,161,8,64,208,128,152,
0,128,159,0,128,151,0,200,157,9,0,64,208,128,152,0,128,155,0,137,166,5,
34,0,72,161,8,64,208,128,149,0,192,159,0,64,208,200,158,9,0,64,208,128,
163,0,64,157,64,208,128,152,0,64,174,64,208,128,155,0,64,162,64,208,137,
154,5,8,0,128,152,0,128,161,0,73,166,13,21,64,208,64,151,64,208,128,157,
0,192,164,0,64,208,128,148,0,192,173,0,64,208,64,159,64,208,128,148,0,82,
154,1,14,2,126,64,208,73,158,45,178,64,208,72,161,36,64,208,72,158,8,64,
208,128,160,0,64,152,64,208,64,161,64,208,64,162,64,208,64,149,64,208,64,
156,64,208,128,144,0,128,145,0,137,151,5,82,0,73,147,25,70,64,208,137,161,
5,16,0,72,159,8,64,208,128,160,0,128,144,0,128,164,0,200,146,17,0,64,208,
64,146,64,208,64,154,64,208,128,144,0,192,144,0,64,208,137,152,5,8,0,128,
148,0,64,161,64,208,64,163,64,208,64,162,64,208,128,160,0,64,148,64,208,
128,166,0,73,154,21,36,64,208,137,161,5,8,0,128,144,0,64,162,64,208,128,
158,0,64,152,64,208,137,161,5,8,0,128,151,0,128,163,0,64,156,64,208,137,
154,5,8,0,128,151,0,128,162,0,137,164,5,64,0,73,161,25,48,64,208,137,148,
5,12,0,64,146,64,208,128,163,0,64,162,64,208,128,158,0,72,160,8,64,208,
128,166,0,64,159,64,208,137,161,5,8,0,128,159,0,128,167,0,64,163,64,208,
64,147,64,208,128,152,0,201,168,10,13,0,64,208,128,146,0,128,165,0,64,174,
64,208,128,163,0,73,151,71,86,64,208,201,157,10,41,0,64,208,128,159,0,73,
154,9,20,64,208,128,152,0,64,144,64,208,64,162,64,208,128,152,0,64,156,
64,208,136,159,4,0,128,158,0,137,160,5,16,0,64,158,64,208,64,166,64,208,
128,156,0,192,161,0,64,208,128,154,0,64,150,64,208,64,154,64,208,136,161,
4,0,128,146,0,64,152,64,208,137,157,5,93,0,73,151,9,45,64,208,128,161,0,
73,146,9,24,64,208,128,166,0,136,145,4,0,64,144,64,208,136,166,4,0,128,
161,0,64,148,64,208,192,159,0,64,208,128,167,0,73,155,9,36,64,208,128,145,
0,72,154,16,64,208,136,166,4,0,64,151,64,208,128,160,0,64,152,64,208,136,
161,4,0,128,159,0,64,156,64,208,128,158,0,73,162,21,133,64,208,73,154,9,
12,64,208,128,161,0,128,144,0,128,161,0,73,160,17,58,64,208,136,166,4,0,
64,154,64,208,128,166,0,200,159,25,0,64,208,73,162,9,16,64,208,128,161,
0,64,157,64,208,128,145,0,128,164,0,192,158,0,64,208,137,161,5,8,0,128,
159,0,128,162,0,192,161,0,64,208,201,159,14,29,0,64,208,136,159,4,0,128,
148,0,73,156,9,12,64,208,128,152,0,128,151,0,128,157,0,137,162,5,8,0,128,
161,0,192,163,0,64,208,64,160,64,208,128,159,0,137,166,5,32,0,136,164,4,
0,64,163,64,208,136,161,4,0,64,145,64,208,136,159,4,0,64,152,64,208,128,
159,0,192,173,0,64,208,136,158,4,0,64,156,64,208,64,159,64,208,128,151,
0,72,156,224,64,208,73,157,17,99,64,208,136,166,4,0,64,152,64,208,128,159,
0,73,150,9,42,64,208,128,154,0,137,147,5,26,0,200,145,13,0,64,208,64,152,
64,208,128,160,0,192,144,0,64,208,128,159,0,64,148,64,208,128,161,0,73,
154,9,37,64,208,128,159,0,72,152,25,64,208,137,152,5,12,0,64,145,64,208,
128,148,0,192,161,0,64,208,128,161,0,128,151,0,128,156,0,73,162,9,93,64,
208,128,163,0,73,160,13,40,64,208,64,159,64,208,128,162,0,72,159,20,64,
208,137,161,5,12,0,136,159,4,0,128,145,0,128,162,0,64,158,64,208,128,164,
0,192,161,0,64,208,73,159,9,24,64,208,128,145,0,137,156,5,12,0,64,144,64,
208,128,156,0,128,158,0,72,173,8,64,208,128,148,0,64,162,64,208,128,161,
0,73,166,13,24,64,208,64,161,64,208,128,161,0,136,164,4,0,64,163,64,208,
128,159,0,128,173,0,64,155,64,208,137,161,5,37,0,73,148,17,24,64,208,136,
160,4,0,64,157,64,208,128,162,0,64,146,64,208,128,151,0,192,159,0,64,208,
128,145,0,200,166,17,0,64,208,137,160,5,8,0,128,152,0,128,164,0,64,162,
64,208,128,145,0,74,164,145,5,133,64,208,73,157,13,68,64,208,64,161,64,
208,128,154,0,73,147,21,40,64,208,72,166,12,64,208,64,161,64,208,128,152,
0,128,151,0,137,145,5,12,0,64,144,64,208,128,164,0,64,146,64,208,128,161,
0,136,150,4,0,64,148,64,208,64,159,64,208,128,148,0,201,161,14,58,0,64,
208,64,159,64,208,128,158,0,73,159,17,24,64,208,72,158,8,64,208,128,158,
0,128,154,0,64,158,64,208,128,162,0,192,160,0,64,208,137,160,5,12,0,64,
157,64,208,128,162,0,128,162,0,200,163,9,0,64,208,128,154,0,128,162,0,210,
161,2,34,4,21,0,64,208,202,157,11,1,19,0,64,208,128,150,0,73,149,9,135,
64,208,128,158,0,201,146,26,53,0,64,208,73,158,9,16,64,208,128,159,0,136,
152,4,0,128,146,0,128,163,0,72,145,8,64,208,128,160,0,64,144,64,208,72,
154,8,64,208,128,159,0,64,152,64,208,128,173,0,200,148,45,0,64,208,137,
159,5,16,0,136,158,4,0,64,154,64,208,128,155,0,72,163,16,64,208,64,154,
64,208,64,161,64,208,128,161,0,64,160,64,208,128,159,0,192,147,0,64,208,
137,161,5,12,0,136,159,4,0,128,154,0,64,163,64,208,64,154,64,208,128,159,
0,73,154,73,113,64,208,137,148,5,44,0,73,146,13,32,64,208,64,157,64,208,
128,158,0,72,145,8,64,208,128,163,0,64,144,64,208,64,162,64,208,128,158,
0,64,147,64,208,128,164,0,73,160,13,20,64,208,64,134,64,208,128,157,0,64,
154,64,208,128,154,0,128,163,0,72,152,28,64,208,73,162,9,16,64,208,128,
158,0,136,161,4,0,128,158,0,64,173,64,208,128,161,0,64,151,64,208,192,154,
0,64,208,128,161,0,192,156,0,64,208,137,158,5,8,0,128,144,0,128,168,0,73,
163,37,200,64,208,73,148,13,20,64,208,64,144,64,208,128,159,0,64,146,64,
208,128,148,0,64,158,64,208,136,162,4,0,128,144,0,73,160,13,95,64,208,136,
157,4,0,128,155,0,72,159,45,64,208,73,154,9,20,64,208,128,161,0,137,146,
5,8,0,128,145,0,128,148,0,137,161,5,17,0,192,159,0,64,208,136,167,4,0,128,
160,0,128,167,0,64,158,64,208,73,154,9,21,64,208,128,158,0,136,152,4,0,
192,148,0,64,208,128,163,0,200,162,9,0,64,208,128,160,0,128,157,0,72,162,
25,64,208,137,161,5,17,0,200,159,9,0,64,208,128,159,0,128,148,0,128,163,
0,64,161,64,208,137,157,5,28,0,73,145,9,20,64,208,128,144,0,64,144,64,208,
64,161,64,208,128,163,0,128,146,0,72,168,8,64,208,128,156,0,128,158,0,73,
166,9,29,64,208,128,145,0,136,165,4,0,192,164,0,64,208,64,158,64,208,64,
145,64,208,128,148,0,192,173,0,64,208,137,154,5,25,0,72,152,8,64,208,128,
161,0,192,148,0,64,208,136,158,4,0,128,148,0,128,160,0,74,159,143,1,7,64,
208,201,154,10,50,0,64,208,128,162,0,73,146,9,28,64,208,128,158,0,72,145,
16,64,208,136,158,4,0,64,146,64,208,128,160,0,128,144,0,136,151,4,0,192,
148,0,64,208,128,161,0,73,163,30,70,64,208,73,159,9,16,64,208,128,166,0,
64,157,64,208,128,166,0,192,161,0,64,208,128,148,0,72,162,8,64,208,128,
154,0,64,161,64,208,137,158,5,20,0,72,146,12,64,208,64,146,64,208,128,159,
0,128,145,0,192,160,0,64,208,128,154,0,200,173,9,0,64,208,128,162,0,64,
164,64,208,128,155,0,64,158,64,208,73,158,13,59,64,208,64,156,64,208,128,
158,0,201,152,10,34,0,64,208,128,161,0,201,145,10,13,0,64,208,128,161,0,
128,144,0,64,151,64,208,136,160,4,0,128,159,0,136,156,4,0,192,154,0,64,
208,128,154,0,73,163,9,41,64,208,128,161,0,73,160,9,16,64,208,128,163,0,
64,159,64,208,128,166,0,192,161,0,64,208,72,173,8,64,208,128,156,0,128,
151,0,72,173,8,64,208,128,152,0,192,166,0,64,208,128,156,0,192,160,0,64,
208,201,157,26,142,0,64,208,136,159,4,0,64,152,64,208,64,152,64,208,64,
156,64,208,128,156,0,137,150,5,48,0,73,147,13,36,64,208,136,163,4,0,128,
158,0,72,145,12,64,208,64,158,64,208,128,160,0,64,144,64,208,136,151,4,
0,128,144,0,64,149,64,208,128,160,0,73,154,21,45,64,208,73,157,9,12,64,
208,128,156,0,128,145,0,128,166,0,64,152,64,208,201,161,14,17,0,64,208,
136,159,4,0,128,158,0,128,159,0,128,166,0,64,156,64,208,137,151,5,16,0,
64,145,64,208,64,152,64,208,128,160,0,128,152,0,73,161,25,49,64,208,73,
159,9,12,64,208,128,148,0,128,155,0,64,164,64,208,128,148,0,201,159,14,
21,0,64,208,136,152,4,0,128,151,0,64,158,64,208,128,144,0,128,160,0,73,
163,9,16,64,208,128,154,0,64,162,64,208,128,161,0,192,166,0,64,208,137,
160,5,12,0,64,158,64,208,128,146,0,64,162,64,208,128,154,0,72,163,76,64,
208,73,157,9,20,64,208,128,148,0,137,154,5,8,0,128,152,0,128,156,0,73,161,
17,20,64,208,136,159,4,0,64,158,64,208,128,162,0,128,159,0,64,164,64,208,
64,152,64,208,72,161,16,64,208,64,156,64,208,64,152,64,208,128,145,0,64,
156,64,208,128,145,0,64,162,64,208,73,158,13,64,64,208,64,157,64,208,128,
157,0,73,149,9,28,64,208,128,155,0,73,144,9,16,64,208,128,147,0,64,134,
64,208,128,156,0,128,145,0,72,154,16,64,208,136,161,4,0,64,145,64,208,128,
161,0,64,150,64,208,128,162,0,201,162,18,68,0,64,208,136,163,4,0,64,162,
64,208,128,161,0,201,160,10,18,0,64,208,128,161,0,192,159,0,64,208,128,
154,0,192,161,0,64,208,73,161,9,20,64,208,128,173,0,72,157,8,64,208,128,
147,0,128,145,0,64,173,64,208,128,156,0,72,173,8,64,208,128,162,0,128,168,
0,73,168,13,211,64,208,64,154,64,208,128,158,0,201,166,144,179,0,64,208,
73,156,25,71,64,208,73,157,9,12,64,208,128,157,0,128,151,0,64,160,64,208,
128,154,0,201,146,10,26,0,64,208,128,154,0,200,145,13,0,64,208,136,160,
4,0,128,154,0,128,144,0,200,148,17,0,64,208,136,163,4,0,64,154,64,208,128,
161,0,128,147,0,201,160,10,43,0,64,208,128,161,0,200,159,17,0,64,208,137,
152,5,8,0,128,150,0,128,160,0,192,158,0,64,208,136,160,4,0,64,154,64,208,
128,159,0,72,173,8,64,208,128,161,0,64,161,64,208,72,161,8,64,208,128,173,
0,128,152,0,64,165,64,208,137,162,5,24,0,137,145,5,8,0,128,144,0,64,156,
64,208,136,162,4,0,128,161,0,136,166,4,0,128,164,0,64,167,64,208,137,160,
5,8,0,128,151,0,64,163,64,208,128,159,0,72,174,25,64,208,201,158,10,17,
0,64,208,128,164,0,64,145,64,208,128,155,0,128,159,0,64,173,64,208,137,
159,5,55,0,137,151,5,16,0,72,146,8,64,208,128,161,0,128,144,0,200,156,17,
0,64,208,72,162,8,64,208,128,159,0,128,154,0,192,154,0,64,208,192,158,0,
64,208,64,158,64,208,128,157,0,73,162,13,33,64,208,136,159,4,0,128,154,
0,200,161,13,0,64,208,136,163,4,0,128,154,0,64,160,64,208,128,151,0,72,
173,12,64,208,136,161,4,0,128,154,0,128,165,0,82,154,49,123,99,117,64,208,
82,158,4,251,30,176,64,208,82,156,1,8,2,227,64,208,73,155,13,124,64,208,
64,148,64,208,128,158,0,137,151,5,60,0,72,148,28,64,208,64,160,64,208,64,
144,64,208,64,147,64,208,64,156,64,208,64,149,64,208,128,162,0,64,145,64,
208,72,149,8,64,208,128,148,0,64,144,64,208,64,157,64,208,64,154,64,208,
128,144,0,72,154,12,64,208,64,158,64,208,128,160,0,64,152,64,208,73,157,
21,32,64,208,64,162,64,208,64,149,64,208,64,160,64,208,128,157,0,136,152,
4,0,64,144,64,208,128,166,0,128,160,0,73,161,34,101,64,208,73,152,9,16,
64,208,128,161,0,64,149,64,208,128,162,0,192,159,0,64,208,64,149,64,208,
128,154,0,72,159,56,64,208,73,158,9,28,64,208,128,158,0,64,144,64,208,64,
160,64,208,64,162,64,208,64,152,64,208,128,175,0,64,160,64,208,64,158,64,
208,136,161,4,0,64,156,64,208,64,144,64,208,128,162,0,64,156,64,208,64,
144,64,208,128,168,0,72,163,8,64,208,128,167,0,64,162,64,208,72,160,16,
64,208,64,144,64,208,64,157,64,208,128,161,0,128,144,0,73,148,45,205,64,
208,73,159,9,24,64,208,128,154,0,72,151,8,64,208,128,161,0,64,146,64,208,
128,158,0,64,166,64,208,64,173,64,208,64,158,64,208,128,162,0,201,145,34,
105,0,64,208,137,157,5,20,0,136,156,4,0,64,146,64,208,64,149,64,208,128,
160,0,64,158,64,208,128,157,0,72,144,52,64,208,73,159,9,32,64,208,128,159,
0,72,158,12,64,208,64,152,64,208,128,148,0,64,157,64,208,64,160,64,208,
128,152,0,72,162,12,64,208,64,163,64,208,128,163,0,128,161,0,64,134,64,
208,64,159,64,208,64,158,64,208,64,159,64,208,128,154,0,72,147,36,64,208,
72,163,16,64,208,72,161,8,64,208,128,158,0,128,159,0,64,152,64,208,72,152,
8,64,208,128,168,0,128,151,0,64,146,64,208,72,148,8,64,208,128,159,0,64,
147,64,208,128,151,0,73,152,62,142,64,208,73,157,9,29,64,208,128,158,0,
201,145,14,17,0,64,208,64,144,64,208,128,161,0,128,144,0,128,152,0,73,160,
9,24,64,208,128,158,0,64,159,64,208,64,154,64,208,64,160,64,208,128,158,
0,128,161,0,72,151,8,64,208,128,148,0,64,150,64,208,72,161,20,64,208,64,
171,64,208,64,160,64,208,64,172,64,208,128,149,0,64,146,64,208,64,149,64,
208,192,157,0,64,208,64,148,64,208,64,152,64,208,64,161,64,208,64,159,64,
208,64,144,64,208,64,157,64,208,64,161,64,208,64,149,64,208,128,160,0,72,
155,112,64,208,73,152,17,72,64,208,64,157,64,208,136,162,4,0,128,151,0,
73,148,29,36,64,208,64,158,64,208,64,147,64,208,64,158,64,208,64,146,64,
208,64,158,64,208,128,160,0,64,146,64,208,128,152,0,64,149,64,208,64,157,
64,208,64,146,64,208,64,144,64,208,128,155,0,136,161,4,0,64,158,64,208,
64,156,64,208,64,151,64,208,64,144,64,208,64,146,64,208,64,158,64,208,64,
148,64,208,128,149,0,64,154,64,208,200,159,9,0,64,208,128,145,0,128,145,
0,74,162,30,1,180,64,208,137,160,5,8,0,128,154,0,64,164,64,208,64,158,64,
208,64,156,64,208,128,161,0,73,159,57,212,64,208,73,162,9,40,64,208,128,
173,0,72,160,8,64,208,128,164,0,64,152,64,208,64,166,64,208,64,149,64,208,
64,157,64,208,64,162,64,208,128,160,0,136,173,4,0,64,164,64,208,128,147,
0,72,158,44,64,208,73,158,13,24,64,208,64,152,64,208,128,162,0,64,157,64,
208,64,159,64,208,128,154,0,64,159,64,208,64,165,64,208,64,158,64,208,128,
151,0,64,157,64,208,73,162,17,64,64,208,72,173,8,64,208,128,157,0,128,159,
0,137,160,5,36,0,72,158,12,64,208,64,160,64,208,128,148,0,64,144,64,208,
64,160,64,208,64,156,64,208,64,152,64,208,128,175,0,64,161,64,208,64,144,
64,208,128,160,0,73,166,29,40,64,208,64,155,64,208,64,144,64,208,64,147,
64,208,64,149,64,208,64,160,64,208,128,172,0,64,164,64,208,64,158,64,208,
128,159,0,128,167,0,72,161,86,64,208,201,160,10,58,0,64,208,128,154,0,73,
150,9,37,64,208,128,154,0,72,147,8,64,208,128,163,0,64,144,64,208,192,160,
0,64,208,64,162,64,208,64,158,64,208,128,159,0,64,159,64,208,64,144,64,
208,128,161,0,73,163,9,16,64,208,128,160,0,64,161,64,208,128,154,0,64,164,
64,208,128,158,0,64,160,64,208,73,158,17,45,64,208,64,157,64,208,64,144,
64,208,128,161,0,73,152,9,21,64,208,128,161,0,136,151,4,0,192,145,0,64,
208,128,161,0,64,156,64,208,128,151,0,73,165,9,56,64,208,128,161,0,72,162,
12,64,208,64,173,64,208,128,161,0,64,161,64,208,72,167,20,64,208,64,149,
64,208,64,162,64,208,64,144,64,208,128,156,0,64,161,64,208,64,152,64,208,
128,161,0,128,173,0,73,173,37,81,64,208,73,156,9,16,64,208,128,151,0,136,
154,4,0,128,151,0,136,161,4,0,64,160,64,208,64,161,64,208,128,158,0,72,
164,29,64,208,200,159,17,0,64,208,64,156,64,208,64,161,64,208,128,159,0,
64,144,64,208,128,151,0,64,163,64,208,136,162,4,0,64,157,64,208,128,145,
0,64,174,64,208,136,156,4,0,128,151,0,74,150,100,13,120,64,208,73,158,9,
58,64,208,128,152,0,137,149,5,28,0,73,147,13,20,64,208,64,163,64,208,128,
152,0,64,145,64,208,128,152,0,128,148,0,200,157,9,0,64,208,128,162,0,192,
154,0,64,208,136,165,4,0,128,154,0,137,166,5,24,0,72,161,12,64,208,136,
162,4,0,128,152,0,64,160,64,208,128,154,0,136,175,4,0,64,173,64,208,128,
159,0,82,146,2,42,7,232,64,208,74,156,10,1,95,64,208,128,164,0,201,148,
14,193,0,64,208,136,160,4,0,128,159,0,73,145,9,32,64,208,128,156,0,72,144,
16,64,208,72,162,8,64,208,128,163,0,128,152,0,64,134,64,208,128,160,0,72,
147,12,64,208,136,159,4,0,128,155,0,64,146,64,208,73,159,13,99,64,208,64,
144,64,208,128,163,0,201,154,39,67,0,64,208,200,163,17,0,64,208,72,165,
8,64,208,128,151,0,128,161,0,64,152,64,208,64,163,64,208,64,160,64,208,
128,146,0,72,152,8,64,208,128,163,0,64,144,64,208,200,163,9,0,64,208,128,
155,0,64,152,64,208,128,163,0,136,158,4,0,64,156,64,208,136,163,4,0,64,
159,64,208,128,163,0,137,163,5,21,0,136,162,4,0,192,161,0,64,208,64,154,
64,208,128,163,0,64,164,64,208,64,161,64,208,128,163,0,73,152,57,101,64,
208,137,158,5,24,0,72,156,8,64,208,128,163,0,64,144,64,208,64,146,64,208,
128,163,0,72,163,16,64,208,136,161,4,0,64,152,64,208,128,146,0,64,160,64,
208,64,162,64,208,128,163,0,200,151,37,0,64,208,73,159,17,20,64,208,72,
152,8,64,208,128,145,0,128,145,0,128,146,0,64,160,64,208,64,152,64,208,
128,163,0,64,150,64,208,128,148,0,72,155,16,64,208,64,163,64,208,64,147,
64,208,128,144,0,64,154,64,208,137,158,5,12,0,136,148,4,0,128,147,0,136,
164,4,0,64,163,64,208,64,160,64,208,128,173,0,73,162,33,151,64,208,137,
161,5,24,0,72,154,12,64,208,64,154,64,208,128,163,0,64,152,64,208,128,163,
0,128,163,0,73,159,42,82,64,208,73,159,9,24,64,208,128,163,0,72,158,8,64,
208,128,148,0,64,134,64,208,128,144,0,192,163,0,64,208,64,146,64,208,128,
162,0,72,158,28,64,208,73,154,9,20,64,208,128,163,0,72,152,8,64,208,128,
162,0,128,146,0,128,163,0,192,157,0,64,208,136,158,4,0,128,152,0,72,161,
20,64,208,73,152,9,12,64,208,128,162,0,128,151,0,128,156,0,192,160,0,64,
208,72,163,8,64,208,128,161,0,128,145,0,73,168,13,29,64,208,64,158,64,208,
128,154,0,200,167,9,0,64,208,128,147,0,64,165,64,208,128,162,0,64,173,64,
208,137,151,5,8,0,128,148,0,128,161,0,82,144,4,27,4,75,64,208,74,157,82,
2,155,64,208,73,148,21,48,64,208,64,144,64,208,64,148,64,208,64,151,64,
208,128,175,0,136,146,4,0,64,144,64,208,72,160,16,64,208,64,161,64,208,
64,159,64,208,128,152,0,128,151,0,64,166,64,208,64,162,64,208,64,158,64,
208,64,146,64,208,64,144,64,208,64,160,64,208,128,171,0,74,151,231,1,94,
64,208,137,161,5,132,0,73,147,37,72,64,208,137,163,5,20,0,64,144,64,208,
64,161,64,208,136,163,4,0,128,144,0,64,174,64,208,136,163,4,0,128,144,0,
72,145,12,64,208,64,144,64,208,128,162,0,64,144,64,208,64,162,64,208,136,
154,4,0,64,152,64,208,64,161,64,208,128,158,0,72,157,40,64,208,73,159,9,
24,64,208,128,163,0,72,156,8,64,208,128,163,0,64,144,64,208,128,163,0,136,
166,4,0,64,162,64,208,128,163,0,64,156,64,208,64,152,64,208,64,160,64,208,
128,160,0,73,165,33,85,64,208,72,162,8,64,208,128,152,0,64,152,64,208,64,
156,64,208,64,157,64,208,64,152,64,208,128,152,0,72,163,24,64,208,64,156,
64,208,64,158,64,208,64,152,64,208,64,156,64,208,128,175,0,192,162,0,64,
208,72,152,16,64,208,64,161,64,208,64,152,64,208,128,151,0,64,144,64,208,
128,147,0,64,173,64,208,128,163,0,73,146,53,92,64,208,73,157,13,40,64,208,
64,158,64,208,128,165,0,72,156,24,64,208,64,152,64,208,64,157,64,208,64,
146,64,208,64,158,64,208,128,148,0,128,151,0,64,163,64,208,128,162,0,72,
145,28,64,208,72,156,12,64,208,64,152,64,208,128,157,0,64,154,64,208,64,
152,64,208,128,161,0,64,144,64,208,136,151,4,0,128,148,0,72,148,20,64,208,
72,157,8,64,208,128,154,0,64,146,64,208,128,152,0,64,147,64,208,128,162,
0,73,155,33,60,64,208,72,162,16,64,208,136,163,4,0,64,149,64,208,128,165,
0,64,156,64,208,64,147,64,208,128,163,0,72,154,8,64,208,128,159,0,64,152,
64,208,137,145,5,12,0,64,144,64,208,128,161,0,128,164,0,64,156,64,208,73,
159,17,108,64,208,72,160,8,64,208,128,151,0,128,152,0,73,149,13,84,64,208,
64,156,64,208,128,146,0,72,147,60,64,208,73,159,9,44,64,208,128,152,0,72,
152,12,64,208,64,164,64,208,128,154,0,64,144,64,208,64,164,64,208,64,154,
64,208,64,161,64,208,64,152,64,208,128,162,0,64,173,64,208,136,161,4,0,
128,154,0,64,145,64,208,64,146,64,208,128,163,0,64,152,64,208,128,161,0,
73,162,21,24,64,208,64,152,64,208,64,161,64,208,64,152,64,208,128,151,0,
128,160,0,64,167,64,208,64,144,64,208,64,162,64,208,72,157,16,64,208,64,
152,64,208,64,160,64,208,128,158,0,64,147,64,208,64,162,64,208,128,163,
0,74,162,26,1,73,64,208,137,160,5,12,0,136,159,4,0,128,145,0,64,173,64,
208,128,154,0,73,160,73,168,64,208,73,155,13,60,64,208,64,144,64,208,128,
147,0,72,148,32,64,208,64,152,64,208,64,158,64,208,64,166,64,208,64,149,
64,208,64,157,64,208,64,162,64,208,128,160,0,64,147,64,208,136,163,4,0,
64,162,64,208,128,163,0,64,157,64,208,128,166,0,72,159,72,64,208,73,159,
13,28,64,208,64,161,64,208,128,144,0,137,155,5,12,0,64,154,64,208,128,161,
0,128,158,0,136,166,4,0,64,160,64,208,137,158,5,24,0,64,149,64,208,64,156,
64,208,64,158,64,208,64,157,64,208,128,162,0,64,175,64,208,128,155,0,64,
158,64,208,73,155,13,16,64,208,64,146,64,208,128,152,0,128,152,0,128,157,
0,64,161,64,208,73,159,33,80,64,208,64,157,64,208,64,152,64,208,72,160,
8,64,208,128,165,0,64,152,64,208,64,160,64,208,128,165,0,73,156,9,36,64,
208,128,158,0,72,154,12,64,208,64,158,64,208,128,156,0,64,151,64,208,64,
152,64,208,64,158,64,208,128,156,0,64,158,64,208,64,145,64,208,128,157,
0,73,162,9,36,64,208,128,162,0,72,161,8,64,208,128,160,0,64,160,64,208,
136,160,4,0,64,152,64,208,64,160,64,208,128,147,0,64,163,64,208,72,162,
8,64,208,128,161,0,128,159,0,73,166,17,40,64,208,72,167,8,64,208,128,160,
0,128,146,0,72,165,8,64,208,128,161,0,64,163,64,208,136,161,4,0,64,160,
64,208,128,168,0,64,173,64,208,128,173,0,64,134,64,208,201,161,14,33,0,
64,208,136,166,4,0,128,149,0,72,151,8,64,208,128,160,0,64,134,64,208,64,
166,64,208,128,144,0,136,164,4,0,64,163,64,208,128,161,0,192,145,0,64,208,
73,158,17,190,64,208,137,160,5,8,0,128,156,0,128,163,0,201,152,26,108,0,
64,208,137,160,5,16,0,72,148,8,64,208,128,165,0,128,145,0,128,161,0,73,
147,9,58,64,208,128,163,0,200,146,25,0,64,208,137,158,5,16,0,64,152,64,
208,64,159,64,208,128,161,0,128,163,0,64,144,64,208,137,158,5,8,0,128,155,
0,192,161,0,64,208,64,161,64,208,128,160,0,200,150,9,0,64,208,128,148,0,
64,148,64,208,137,163,5,8,0,128,157,0,128,165,0,73,156,21,49,64,208,72,
162,12,64,208,136,161,4,0,128,158,0,128,158,0,72,155,20,64,208,64,154,64,
208,64,145,64,208,64,157,64,208,128,167,0,192,154,0,64,208,128,164,0,192,
157,0,64,208,136,166,4,0,64,158,64,208,128,157,0,73,165,17,145,64,208,137,
151,5,8,0,128,144,0,128,156,0,73,161,35,68,64,208,137,159,5,21,0,200,156,
9,0,64,208,128,159,0,64,144,64,208,128,156,0,192,160,0,64,208,128,154,0,
200,160,17,0,64,208,137,154,5,8,0,128,148,0,128,163,0,192,159,0,64,208,
137,156,5,8,0,128,144,0,128,160,0,72,164,24,64,208,73,159,13,16,64,208,
64,152,64,208,128,154,0,128,147,0,128,161,0,192,162,0,64,208,137,163,5,
16,0,137,156,5,8,0,128,154,0,128,158,0,72,173,8,64,208,128,156,0,64,165,
64,208,128,156,0,137,174,5,24,0,72,173,8,64,208,128,160,0,64,167,64,208,
64,157,64,208,128,146,0,64,175,64,208,128,163,0,82,148,1,54,4,16,64,208,
201,158,35,174,0,64,208,137,156,5,21,0,72,155,8,64,208,128,150,0,192,152,
0,64,208,128,152,0,64,165,64,208,128,163,0,73,152,13,81,64,208,136,160,
4,0,128,159,0,73,147,9,48,64,208,128,145,0,72,146,12,64,208,136,166,4,0,
128,158,0,64,144,64,208,73,152,9,16,64,208,128,161,0,64,146,64,208,128,
162,0,64,160,64,208,128,149,0,136,150,4,0,192,148,0,64,208,136,159,4,0,
64,155,64,208,128,150,0,73,156,13,30,64,208,64,154,64,208,128,161,0,200,
155,9,0,64,208,128,161,0,192,154,0,64,208,128,144,0,192,157,0,64,208,73,
152,13,20,64,208,64,151,64,208,128,159,0,64,151,64,208,128,159,0,128,154,
0,73,165,17,88,64,208,136,162,4,0,64,159,64,208,128,156,0,201,161,26,59,
0,64,208,137,159,5,16,0,136,156,4,0,64,152,64,208,128,156,0,128,160,0,72,
160,8,64,208,128,148,0,192,159,0,64,208,201,152,10,13,0,64,208,128,168,
0,128,147,0,64,159,64,208,128,154,0,192,163,0,64,208,136,160,4,0,128,159,
0,73,173,9,29,64,208,128,161,0,136,167,4,0,192,166,0,64,208,137,148,5,8,
0,128,144,0,128,156,0,64,174,64,208,64,161,64,208,128,168,0,64,147,64,208,
74,158,27,1,146,64,208,137,146,5,8,0,128,145,0,192,154,0,64,208,64,158,
64,208,128,160,0,73,151,17,195,64,208,64,154,64,208,64,158,64,208,128,160,
0,73,147,25,155,64,208,73,156,9,16,64,208,128,154,0,136,152,4,0,128,144,
0,128,158,0,201,145,18,123,0,64,208,72,163,8,64,208,128,151,0,128,151,0,
192,144,0,64,208,73,160,9,61,64,208,128,164,0,73,156,17,41,64,208,136,162,
4,0,64,152,64,208,128,162,0,72,154,13,64,208,192,152,0,64,208,128,152,0,
64,146,64,208,136,162,4,0,128,156,0,136,158,4,0,64,157,64,208,128,152,0,
73,164,9,24,64,208,128,154,0,136,163,4,0,64,161,64,208,136,163,4,0,128,
144,0,64,166,64,208,64,156,64,208,64,152,64,208,128,151,0,64,146,64,208,
128,152,0,72,150,12,64,208,64,160,64,208,128,154,0,64,148,64,208,136,173,
4,0,128,163,0,201,155,14,132,0,64,208,136,163,4,0,128,161,0,200,154,33,
0,64,208,137,156,5,16,0,137,145,5,8,0,128,144,0,128,147,0,136,163,4,0,64,
159,64,208,128,151,0,64,152,64,208,73,162,17,54,64,208,136,152,4,0,64,145,
64,208,128,152,0,73,154,9,29,64,208,128,151,0,200,152,9,0,64,208,128,154,
0,64,144,64,208,64,156,64,208,128,151,0,192,159,0,64,208,128,163,0,137,
166,5,12,0,64,164,64,208,128,154,0,64,173,64,208,72,152,8,64,208,128,159,
0,128,144,0,72,157,12,64,208,136,163,4,0,128,154,0,192,156,0,64,208,73,
161,9,20,64,208,128,152,0,137,158,5,8,0,128,154,0,128,159,0,136,163,4,0,
64,162,64,208,128,163,0,74,165,14,1,21,64,208,136,155,4,0,128,152,0,73,
162,42,149,64,208,137,161,5,17,0,200,152,9,0,64,208,128,154,0,128,144,0,
72,173,8,64,208,128,152,0,64,162,64,208,64,148,64,208,128,158,0,201,160,
26,78,0,64,208,137,159,5,16,0,72,154,8,64,208,128,158,0,128,152,0,128,162,
0,64,159,64,208,137,157,5,24,0,137,152,5,16,0,72,145,8,64,208,128,151,0,
128,144,0,128,154,0,137,162,5,21,0,72,161,8,64,208,128,158,0,192,159,0,
64,208,128,154,0,128,173,0,192,161,0,64,208,201,157,10,21,0,64,208,128,
148,0,72,154,8,64,208,128,157,0,128,148,0,128,163,0,72,164,16,64,208,72,
173,8,64,208,128,152,0,128,152,0,192,163,0,64,208,73,162,9,45,64,208,128,
148,0,137,159,5,21,0,72,154,13,64,208,192,152,0,64,208,128,152,0,128,151,
0,64,161,64,208,72,162,8,64,208,128,144,0,128,159,0,73,166,17,41,64,208,
64,156,64,208,64,152,64,208,128,151,0,64,164,64,208,192,154,0,64,208,64,
161,64,208,136,162,4,0,64,152,64,208,128,162,0,64,173,64,208,128,161,0,
137,168,5,28,0,136,167,4,0,64,166,64,208,72,161,12,64,208,64,156,64,208,
128,159,0,128,151,0,72,174,8,64,208,128,144,0,64,173,64,208,136,163,4,0,
128,152,0,64,149,64,208,138,163,6,1,5,0,201,158,14,147,0,64,208,136,160,
4,0,128,144,0,72,156,126,64,208,73,160,17,69,64,208,64,152,64,208,64,159,
64,208,128,154,0,136,158,4,0,64,147,64,208,73,159,13,32,64,208,64,159,64,
208,128,154,0,72,156,8,64,208,128,144,0,64,144,64,208,64,154,64,208,128,
152,0,192,163,0,64,208,64,154,64,208,128,152,0,200,162,17,0,64,208,64,152,
64,208,64,159,64,208,128,159,0,64,161,64,208,64,158,64,208,64,166,64,208,
64,152,64,208,64,157,64,208,64,145,64,208,64,144,64,208,64,157,64,208,128,
154,0,64,154,64,208,128,146,0,200,161,9,0,64,208,128,158,0,64,160,64,208,
72,158,24,64,208,137,160,5,12,0,64,158,64,208,128,160,0,64,161,64,208,128,
158,0,64,144,64,208,64,156,64,208,72,158,28,64,208,64,147,64,208,64,160,
64,208,64,144,64,208,64,157,64,208,64,152,64,208,128,162,0,64,151,64,208,
64,152,64,208,64,162,64,208,64,158,64,208,64,145,64,208,64,155,64,208,64,
158,64,208,64,154,64,208,128,152,0,137,167,5,16,0,136,166,4,0,64,165,64,
208,128,163,0,128,173,0,74,155,250,7,154,64,208,73,156,30,152,64,208,73,
156,9,21,64,208,128,160,0,192,151,0,64,208,64,158,64,208,128,161,0,128,
157,0,73,148,21,73,64,208,72,158,8,64,208,128,150,0,64,148,64,208,128,148,
0,73,146,9,45,64,208,128,151,0,200,145,9,0,64,208,128,152,0,64,144,64,208,
73,151,13,20,64,208,64,154,64,208,128,158,0,64,148,64,208,128,160,0,128,
168,0,64,147,64,208,128,161,0,201,154,10,41,0,64,208,128,144,0,72,152,28,
64,208,73,157,9,16,64,208,128,173,0,64,146,64,208,128,162,0,64,161,64,208,
128,164,0,128,150,0,192,155,0,64,208,128,144,0,201,162,10,45,0,64,208,128,
160,0,73,160,13,28,64,208,136,160,4,0,128,148,0,72,159,8,64,208,128,161,
0,64,157,64,208,128,145,0,64,161,64,208,128,156,0,201,173,14,39,0,64,208,
136,159,4,0,128,151,0,200,168,17,0,64,208,64,163,64,208,64,147,64,208,128,
144,0,192,164,0,64,208,128,151,0,64,174,64,208,128,165,0,82,152,3,42,4,
238,64,208,74,157,22,1,194,64,208,136,165,4,0,64,154,64,208,64,158,64,208,
128,156,0,73,150,13,234,64,208,136,162,4,0,128,154,0,73,146,42,131,64,208,
137,161,5,24,0,72,155,12,64,208,64,152,64,208,128,159,0,64,146,64,208,128,
161,0,192,166,0,64,208,64,173,64,208,128,162,0,200,145,41,0,64,208,137,
158,5,16,0,72,152,8,64,208,128,162,0,128,145,0,72,173,12,64,208,64,146,
64,208,128,161,0,64,159,64,208,128,158,0,64,144,64,208,137,162,5,37,0,73,
158,9,12,64,208,128,151,0,128,154,0,192,161,0,64,208,72,163,8,64,208,128,
158,0,64,159,64,208,128,147,0,136,173,4,0,128,164,0,72,148,24,64,208,73,
163,13,16,64,208,64,173,64,208,128,159,0,128,154,0,128,166,0,192,147,0,
64,208,201,152,26,41,0,64,208,73,156,9,16,64,208,128,161,0,64,152,64,208,
128,162,0,128,162,0,137,145,5,8,0,128,144,0,64,147,64,208,128,152,0,72,
160,12,64,208,64,173,64,208,128,161,0,192,156,0,64,208,128,161,0,73,154,
13,82,64,208,136,147,4,0,128,145,0,72,152,58,64,208,137,156,5,29,0,137,
148,5,16,0,72,147,8,64,208,128,144,0,128,145,0,192,152,0,64,208,128,148,
0,137,166,5,21,0,72,163,8,64,208,128,162,0,192,162,0,64,208,128,160,0,128,
175,0,64,151,64,208,136,158,4,0,128,144,0,72,156,101,64,208,137,158,5,40,
0,73,149,9,28,64,208,128,159,0,73,147,9,16,64,208,128,151,0,64,146,64,208,
128,152,0,128,148,0,136,155,4,0,128,151,0,137,163,5,37,0,72,161,16,64,208,
72,164,8,64,208,128,158,0,128,152,0,192,159,0,64,208,136,156,4,0,64,152,
64,208,128,156,0,72,173,16,64,208,136,159,4,0,64,152,64,208,128,145,0,128,
166,0,64,155,64,208,64,156,64,208,128,151,0,202,163,43,1,17,0,64,208,137,
161,5,20,0,137,156,5,12,0,64,152,64,208,128,159,0,128,159,0,72,173,8,64,
208,128,161,0,64,164,64,208,128,159,0,73,160,25,114,64,208,72,163,16,64,
208,136,173,4,0,64,152,64,208,128,173,0,128,146,0,72,159,78,64,208,73,156,
13,45,64,208,136,158,4,0,128,156,0,201,154,14,21,0,64,208,136,161,4,0,128,
144,0,64,152,64,208,128,161,0,64,155,64,208,136,159,4,0,128,144,0,201,166,
10,17,0,64,208,128,154,0,64,162,64,208,128,161,0,64,173,64,208,64,146,64,
208,128,144,0,64,158,64,208,64,146,64,208,128,160,0,72,162,37,64,208,73,
152,13,16,64,208,136,161,4,0,128,144,0,128,145,0,64,161,64,208,200,164,
9,0,64,208,128,151,0,128,158,0,64,161,64,208,137,159,5,36,0,137,157,5,24,
0,72,156,12,64,208,136,158,4,0,128,152,0,64,154,64,208,128,161,0,64,158,
64,208,128,160,0,73,163,13,20,64,208,136,160,4,0,128,159,0,64,161,64,208,
128,144,0,64,173,64,208,72,159,8,64,208,128,152,0,64,152,64,208,128,159,
0,137,168,5,68,0,72,166,32,64,208,73,161,13,24,64,208,64,156,64,208,128,
152,0,72,160,8,64,208,128,159,0,128,156,0,128,166,0,64,164,64,208,73,161,
13,20,64,208,64,152,64,208,128,157,0,64,152,64,208,128,160,0,64,173,64,
208,128,152,0,64,173,64,208,64,165,64,208,128,159,0,192,151,0,64,208,74,
159,51,1,16,64,208,137,156,5,24,0,137,146,5,12,0,136,145,4,0,128,144,0,
136,152,4,0,128,147,0,137,161,5,17,0,200,159,9,0,64,208,128,163,0,128,157,
0,128,162,0,73,152,13,101,64,208,136,162,4,0,128,158,0,73,147,21,73,64,
208,137,159,5,8,0,128,156,0,64,173,64,208,128,156,0,72,146,12,64,208,136,
158,4,0,128,144,0,192,144,0,64,208,73,161,9,24,64,208,128,154,0,136,155,
4,0,64,154,64,208,64,146,64,208,128,158,0,136,173,4,0,64,165,64,208,128,
155,0,136,150,4,0,64,148,64,208,136,161,4,0,128,156,0,73,156,29,65,64,208,
137,158,5,16,0,137,152,5,8,0,128,144,0,128,154,0,136,161,4,0,128,159,0,
72,155,16,64,208,72,156,8,64,208,128,154,0,128,154,0,192,154,0,64,208,137,
161,5,12,0,136,156,4,0,128,152,0,128,162,0,72,158,44,64,208,73,160,9,28,
64,208,128,161,0,137,152,5,16,0,64,145,64,208,64,161,64,208,128,158,0,128,
156,0,72,166,8,64,208,128,156,0,128,162,0,64,157,64,208,136,158,4,0,128,
156,0,73,165,9,130,64,208,128,158,0,73,162,42,106,64,208,137,161,5,25,0,
137,156,5,17,0,136,152,4,0,192,144,0,64,208,128,144,0,128,158,0,137,168,
5,8,0,128,163,0,128,173,0,72,161,32,64,208,73,156,9,16,64,208,128,152,0,
136,154,4,0,128,144,0,72,161,8,64,208,128,156,0,128,159,0,192,160,0,64,
208,73,152,9,20,64,208,128,151,0,136,151,4,0,64,148,64,208,128,159,0,64,
162,64,208,128,144,0,136,164,4,0,64,163,64,208,136,163,4,0,128,159,0,73,
168,9,26,64,208,128,146,0,136,167,4,0,192,166,0,64,208,192,156,0,64,208,
128,151,0,64,173,64,208,73,161,9,12,64,208,128,158,0,128,144,0,128,162,
0,64,154,64,208,201,157,22,206,0,64,208,137,152,5,12,0,64,144,64,208,128,
163,0,128,156,0,73,149,13,77,64,208,136,160,4,0,128,159,0,73,146,21,49,
64,208,136,166,4,0,64,151,64,208,64,152,64,208,128,152,0,200,145,17,0,64,
208,72,156,8,64,208,128,154,0,128,154,0,64,144,64,208,64,145,64,208,128,
146,0,72,148,8,64,208,128,166,0,64,147,64,208,128,155,0,73,154,42,91,64,
208,73,157,9,21,64,208,128,162,0,200,156,9,0,64,208,128,162,0,128,152,0,
72,163,12,64,208,64,154,64,208,128,161,0,128,159,0,200,152,42,0,64,208,
73,159,18,33,64,208,192,154,0,64,208,64,160,64,208,128,158,0,72,156,8,64,
208,128,154,0,64,154,64,208,128,159,0,128,164,0,64,150,64,208,128,148,0,
200,156,9,0,64,208,128,152,0,64,155,64,208,128,159,0,201,163,26,140,0,64,
208,137,159,5,12,0,64,154,64,208,128,161,0,64,162,64,208,128,162,0,73,160,
21,50,64,208,137,163,5,8,0,128,157,0,64,173,64,208,128,163,0,72,159,12,
64,208,136,167,4,0,128,148,0,192,158,0,64,208,200,158,9,0,64,208,128,157,
0,128,157,0,200,162,17,0,64,208,136,154,4,0,64,152,64,208,128,159,0,64,
161,64,208,73,160,13,24,64,208,64,156,64,208,128,162,0,136,158,4,0,64,156,
64,208,128,162,0,72,173,16,64,208,64,152,64,208,64,152,64,208,128,162,0,
128,162,0,73,173,21,77,64,208,137,162,5,12,0,136,159,4,0,128,148,0,128,
163,0,200,166,17,0,64,208,64,158,64,208,64,156,64,208,128,148,0,64,164,
64,208,73,158,13,24,64,208,64,156,64,208,128,161,0,136,157,4,0,64,150,64,
208,128,161,0,72,163,8,64,208,128,157,0,128,159,0,64,174,64,208,128,161,
0,80,157,2,85,64,208,74,158,38,1,79,64,208,73,162,13,28,64,208,64,158,64,
208,128,154,0,72,154,8,64,208,128,161,0,64,148,64,208,128,151,0,128,166,
0,201,149,10,135,0,64,208,128,145,0,73,146,17,82,64,208,136,168,4,0,64,
146,64,208,128,162,0,200,145,13,0,64,208,136,158,4,0,128,154,0,192,144,
0,64,208,73,147,21,36,64,208,72,162,8,64,208,128,163,0,64,159,64,208,128,
163,0,64,144,64,208,72,159,8,64,208,128,158,0,128,151,0,64,159,64,208,136,
158,4,0,128,152,0,72,148,24,64,208,137,146,5,16,0,64,134,64,208,64,161,
64,208,128,149,0,128,160,0,64,147,64,208,72,156,8,64,208,128,148,0,64,154,
64,208,128,156,0,73,155,9,106,64,208,128,163,0,72,154,8,64,208,128,144,
0,192,152,0,64,208,73,152,45,57,64,208,137,156,5,24,0,136,154,4,0,64,147,
64,208,64,152,64,208,64,156,64,208,128,161,0,72,161,8,64,208,128,173,0,
64,159,64,208,128,159,0,136,148,4,0,192,144,0,64,208,128,162,0,72,161,12,
64,208,136,154,4,0,128,147,0,64,160,64,208,72,162,8,64,208,128,152,0,128,
161,0,72,157,33,64,208,137,154,5,21,0,136,151,4,0,64,146,64,208,192,161,
0,64,208,128,160,0,64,156,64,208,128,154,0,64,156,64,208,137,155,5,8,0,
128,152,0,64,161,64,208,64,152,64,208,128,158,0,137,164,5,201,0,201,161,
14,58,0,64,208,136,159,4,0,128,145,0,200,160,21,0,64,208,72,161,12,64,208,
64,159,64,208,128,175,0,128,144,0,64,159,64,208,137,166,5,8,0,128,154,0,
64,173,64,208,64,156,64,208,128,151,0,200,163,110,0,64,208,73,154,22,57,
64,208,200,152,9,0,64,208,128,152,0,64,134,64,208,128,156,0,73,146,9,24,
64,208,128,148,0,64,145,64,208,136,144,4,0,64,134,64,208,128,144,0,64,152,
64,208,64,162,64,208,128,168,0,72,162,32,64,208,73,154,13,24,64,208,64,
152,64,208,128,162,0,72,152,8,64,208,128,148,0,128,148,0,128,168,0,64,161,
64,208,72,152,8,64,208,128,144,0,128,144,0,192,162,0,64,208,137,163,5,12,
0,136,162,4,0,128,161,0,72,173,8,64,208,128,163,0,128,166,0,137,167,5,12,
0,136,166,4,0,128,165,0,72,173,40,64,208,73,161,9,32,64,208,128,154,0,64,
146,64,208,64,146,64,208,64,148,64,208,64,161,64,208,64,149,64,208,128,
173,0,128,163,0,128,168,0,64,156,64,208,74,157,10,1,43,64,208,128,161,0,
73,148,17,173,64,208,137,152,5,8,0,128,148,0,128,157,0,201,145,43,112,0,
64,208,137,162,5,29,0,72,159,21,64,208,192,167,0,64,208,64,152,64,208,64,
161,64,208,128,151,0,128,144,0,136,168,4,0,128,166,0,200,144,62,0,64,208,
201,159,22,37,0,64,208,137,159,5,8,0,128,158,0,64,160,64,208,128,160,0,
72,156,8,64,208,128,154,0,64,147,64,208,128,173,0,136,165,4,0,64,164,64,
208,64,144,64,208,64,157,64,208,128,156,0,64,134,64,208,128,161,0,72,147,
8,64,208,128,161,0,192,146,0,64,208,73,160,9,20,64,208,128,161,0,72,156,
8,64,208,128,161,0,128,145,0,64,173,64,208,64,160,64,208,128,161,0,73,152,
65,77,64,208,137,160,5,32,0,137,151,5,20,0,72,146,8,64,208,128,166,0,64,
144,64,208,128,166,0,64,154,64,208,128,156,0,137,162,5,8,0,128,161,0,64,
163,64,208,64,163,64,208,64,152,64,208,64,145,64,208,128,147,0,136,151,
4,0,192,150,0,64,208,128,154,0,72,155,12,64,208,64,148,64,208,128,158,0,
64,154,64,208,137,158,5,16,0,137,152,5,8,0,128,151,0,128,154,0,136,175,
4,0,128,164,0,201,163,22,224,0,64,208,72,147,8,64,208,128,144,0,64,145,
64,208,128,160,0,73,160,38,85,64,208,137,154,5,25,0,136,152,4,0,192,146,
0,64,208,72,161,8,64,208,128,149,0,128,149,0,136,159,4,0,128,158,0,72,159,
36,64,208,137,158,5,28,0,72,154,8,64,208,128,146,0,64,152,64,208,64,146,
64,208,64,158,64,208,128,158,0,128,166,0,64,158,64,208,64,155,64,208,128,
151,0,72,162,44,64,208,73,155,9,24,64,208,128,166,0,137,152,5,12,0,136,
151,4,0,128,144,0,128,154,0,137,161,5,8,0,128,159,0,64,162,64,208,128,161,
0,192,161,0,64,208,73,158,21,48,64,208,72,163,8,64,208,128,159,0,64,157,
64,208,128,159,0,137,149,5,16,0,64,145,64,208,136,163,4,0,128,158,0,64,
152,64,208,64,157,64,208,128,159,0,73,164,9,17,64,208,128,158,0,192,163,
0,64,208,128,148,0,128,167,0,73,166,17,60,64,208,137,159,5,8,0,128,155,
0,128,162,0,72,165,8,64,208,128,166,0,64,164,64,208,73,156,9,24,64,208,
128,154,0,137,152,5,8,0,128,145,0,64,155,64,208,128,155,0,136,163,4,0,128,
160,0,128,167,0,82,166,1,45,16,69,64,208,73,160,21,185,64,208,137,162,5,
12,0,136,151,4,0,128,145,0,128,163,0,73,154,21,85,64,208,137,154,5,12,0,
64,145,64,208,128,144,0,128,159,0,73,147,25,48,64,208,137,152,5,12,0,136,
148,4,0,128,145,0,64,156,64,208,128,161,0,72,145,16,64,208,137,154,5,8,
0,128,145,0,128,162,0,64,144,64,208,128,145,0,64,148,64,208,192,161,0,64,
208,64,152,64,208,128,157,0,73,158,21,68,64,208,137,152,5,12,0,64,148,64,
208,128,159,0,128,159,0,72,157,28,64,208,73,158,9,16,64,208,128,159,0,136,
154,4,0,128,148,0,64,160,64,208,128,158,0,64,156,64,208,137,160,5,8,0,128,
152,0,64,161,64,208,128,154,0,64,159,64,208,64,152,64,208,128,154,0,73,
166,9,85,64,208,128,161,0,73,164,9,57,64,208,128,149,0,72,162,12,64,208,
136,155,4,0,128,154,0,64,161,64,208,73,159,9,25,64,208,128,156,0,200,158,
13,0,64,208,136,157,4,0,128,156,0,128,156,0,136,162,4,0,128,160,0,64,165,
64,208,64,152,64,208,64,148,64,208,64,157,64,208,128,152,0,73,173,9,16,
64,208,128,173,0,64,168,64,208,128,154,0,64,175,64,208,128,159,0,210,162,
1,202,10,153,0,64,208,201,156,26,238,0,64,208,137,158,5,12,0,136,154,4,
0,128,151,0,136,168,4,0,128,163,0,201,148,10,62,0,64,208,128,163,0,73,145,
9,28,64,208,128,152,0,72,144,8,64,208,128,161,0,64,134,64,208,64,165,64,
208,128,159,0,72,147,12,64,208,136,165,4,0,128,163,0,192,146,0,64,208,136,
161,4,0,128,160,0,73,152,97,113,64,208,73,157,9,36,64,208,128,159,0,137,
151,5,20,0,72,146,8,64,208,128,162,0,64,144,64,208,128,156,0,64,155,64,
208,128,159,0,73,161,17,48,64,208,136,156,4,0,64,151,64,208,128,157,0,72,
160,20,64,208,64,159,64,208,136,165,4,0,64,152,64,208,128,165,0,64,159,
64,208,136,159,4,0,128,156,0,64,162,64,208,128,163,0,72,151,8,64,208,128,
157,0,192,150,0,64,208,128,161,0,200,155,17,0,64,208,137,159,5,8,0,128,
144,0,128,160,0,192,154,0,64,208,137,156,5,8,0,128,155,0,64,159,64,208,
128,160,0,73,162,18,156,64,208,136,164,4,0,192,159,0,64,208,128,159,0,201,
159,49,88,0,64,208,137,156,5,21,0,137,148,5,13,0,192,147,0,64,208,128,161,
0,128,154,0,137,159,5,13,0,192,157,0,64,208,128,163,0,192,161,0,64,208,
128,157,0,72,158,24,64,208,73,148,9,16,64,208,128,161,0,64,144,64,208,128,
159,0,128,161,0,64,157,64,208,72,173,8,64,208,128,163,0,128,148,0,200,161,
26,0,64,208,201,158,10,17,0,64,208,128,159,0,64,151,64,208,128,157,0,128,
160,0,64,160,64,208,137,159,5,12,0,136,150,4,0,128,146,0,192,173,0,64,208,
128,161,0,137,167,5,28,0,72,164,20,64,208,136,162,4,0,64,158,64,208,64,
156,64,208,128,161,0,128,163,0,64,173,64,208,73,161,9,16,64,208,128,164,
0,136,159,4,0,128,154,0,136,163,4,0,128,162,0,82,160,3,146,5,185,64,208,
74,157,26,2,56,64,208,73,162,9,16,64,208,128,160,0,136,161,4,0,128,145,
0,128,163,0,74,149,54,1,118,64,208,72,161,32,64,208,64,162,64,208,64,152,
64,208,64,157,64,208,64,162,64,208,64,149,64,208,64,160,64,208,128,157,
0,64,148,64,208,64,156,64,208,64,144,64,208,128,168,0,74,146,10,1,5,64,
208,128,145,0,72,145,12,64,208,136,161,4,0,128,148,0,64,144,64,208,137,
158,5,36,0,73,151,9,20,64,208,128,144,0,72,149,8,64,208,128,161,0,128,147,
0,64,156,64,208,136,161,4,0,128,151,0,73,164,13,192,64,208,64,162,64,208,
128,158,0,72,163,12,64,208,64,157,64,208,128,166,0,64,161,64,208,73,157,
21,92,64,208,64,152,64,208,64,152,64,208,64,160,64,208,128,165,0,137,151,
5,48,0,72,150,8,64,208,128,148,0,64,147,64,208,73,156,13,28,64,208,136,
163,4,0,128,144,0,64,144,64,208,136,163,4,0,64,161,64,208,128,144,0,128,
163,0,64,155,64,208,64,149,64,208,64,161,64,208,64,156,64,208,64,144,64,
208,128,168,0,73,162,25,44,64,208,64,175,64,208,64,150,64,208,64,156,64,
208,64,144,64,208,128,168,0,72,160,12,64,208,64,144,64,208,128,145,0,64,
159,64,208,128,158,0,64,166,64,208,64,146,64,208,64,149,64,208,64,162,64,
208,64,156,64,208,64,149,64,208,128,162,0,64,173,64,208,128,156,0,72,148,
48,64,208,137,161,5,20,0,137,154,5,8,0,128,144,0,64,156,64,208,128,161,
0,72,174,20,64,208,64,168,64,208,64,168,64,208,64,161,64,208,128,168,0,
128,162,0,64,147,64,208,136,165,4,0,128,154,0,73,154,25,124,64,208,137,
154,5,12,0,136,151,4,0,128,147,0,136,166,4,0,128,158,0,72,152,92,64,208,
73,160,17,72,64,208,72,159,8,64,208,128,158,0,128,158,0,137,157,5,12,0,
64,144,64,208,128,162,0,64,159,64,208,72,162,36,64,208,64,158,64,208,64,
161,64,208,64,152,64,208,64,161,64,208,64,162,64,208,64,149,64,208,64,156,
64,208,128,144,0,128,158,0,136,166,4,0,64,163,64,208,64,173,64,208,128,
159,0,64,151,64,208,128,162,0,200,156,33,0,64,208,73,158,9,16,64,208,128,
158,0,136,151,4,0,128,145,0,72,173,8,64,208,128,158,0,128,162,0,64,155,
64,208,136,151,4,0,128,148,0,201,163,26,224,0,64,208,73,157,9,16,64,208,
128,154,0,64,156,64,208,128,157,0,128,173,0,73,160,25,133,64,208,73,159,
13,16,64,208,64,158,64,208,128,173,0,128,158,0,128,162,0,200,159,25,0,64,
208,72,159,16,64,208,136,158,4,0,64,152,64,208,128,162,0,128,144,0,192,
158,0,64,208,73,159,9,42,64,208,128,160,0,73,156,13,21,64,208,136,161,4,
0,128,158,0,192,148,0,64,208,128,144,0,192,158,0,64,208,136,160,4,0,128,
152,0,73,164,13,25,64,208,64,161,64,208,128,161,0,192,163,0,64,208,64,164,
64,208,128,160,0,64,173,64,208,64,159,64,208,128,145,0,200,162,41,0,64,
208,73,159,9,24,64,208,128,166,0,137,154,5,12,0,136,152,4,0,128,148,0,128,
155,0,137,161,5,8,0,128,160,0,128,162,0,192,161,0,64,208,73,162,9,16,64,
208,128,158,0,136,148,4,0,128,145,0,128,163,0,73,166,38,67,64,208,72,161,
12,64,208,64,161,64,208,128,156,0,64,148,64,208,72,174,8,64,208,128,162,
0,192,158,0,64,208,128,148,0,200,165,9,0,64,208,128,161,0,192,164,0,64,
208,72,156,12,64,208,64,155,64,208,128,152,0,128,154,0,72,175,12,64,208,
64,154,64,208,128,154,0,64,173,64,208,73,157,13,24,64,208,64,154,64,208,
128,158,0,64,156,64,208,136,161,4,0,128,151,0,64,158,64,208,128,158,0,64,
159,80,208,2,32,202,158,55,1,75,0,64,208,73,154,9,28,64,208,128,156,0,72,
147,8,64,208,128,144,0,64,146,64,208,64,162,64,208,128,157,0,72,159,12,
64,208,64,144,64,208,128,162,0,64,158,64,208,128,161,0,73,151,37,171,64,
208,73,159,9,24,64,208,128,159,0,137,145,5,8,0,128,144,0,64,148,64,208,
128,152,0,136,163,4,0,128,161,0,201,147,14,114,0,64,208,136,146,4,0,128,
145,0,201,145,14,53,0,64,208,136,163,4,0,128,156,0,64,144,64,208,137,160,
5,16,0,137,151,5,8,0,128,146,0,128,158,0,73,162,9,16,64,208,128,159,0,64,
161,64,208,128,158,0,128,173,0,64,146,64,208,137,158,5,28,0,72,152,8,64,
208,128,152,0,64,146,64,208,64,152,64,208,64,154,64,208,128,163,0,136,162,
4,0,64,161,64,208,64,156,64,208,128,152,0,136,149,4,0,192,148,0,64,208,
137,160,5,8,0,128,157,0,128,166,0,73,155,21,74,64,208,137,158,5,12,0,136,
154,4,0,128,146,0,128,160,0,200,154,29,0,64,208,137,147,5,16,0,137,145,
5,8,0,128,144,0,128,146,0,136,162,4,0,128,156,0,192,152,0,64,208,137,162,
5,16,0,64,161,64,208,64,156,64,208,128,152,0,128,173,0,72,157,12,64,208,
136,164,4,0,128,152,0,64,156,64,208,137,158,5,8,0,128,148,0,64,173,64,208,
128,161,0,73,166,9,152,64,208,128,158,0,73,161,26,90,64,208,137,160,5,12,
0,136,151,4,0,128,144,0,192,161,0,64,208,128,151,0,72,160,40,64,208,73,
161,17,32,64,208,72,165,8,64,208,128,144,0,128,144,0,72,158,12,64,208,64,
158,64,208,128,161,0,128,149,0,128,164,0,192,159,0,64,208,73,157,9,12,64,
208,128,148,0,128,156,0,64,162,64,208,128,159,0,200,163,17,0,64,208,136,
147,4,0,64,145,64,208,128,146,0,64,162,64,208,73,160,9,25,64,208,128,155,
0,137,158,5,8,0,128,145,0,192,159,0,64,208,128,162,0,136,164,4,0,128,161,
0,201,173,22,45,0,64,208,137,161,5,12,0,136,158,4,0,128,144,0,128,163,0,
72,168,12,64,208,136,161,4,0,128,155,0,64,167,64,208,136,156,4,0,128,148,
0,136,175,4,0,192,174,0,64,208,128,144,0,64,67,128,67,0,64,161,64,208,74,
157,18,1,112,64,208,72,159,8,64,208,128,163,0,128,148,0,73,150,13,192,64,
208,136,164,4,0,128,148,0,73,147,33,139,64,208,73,156,9,16,64,208,128,147,
0,136,151,4,0,128,148,0,64,159,64,208,64,166,64,208,128,160,0,201,145,26,
86,0,64,208,137,160,5,16,0,72,159,8,64,208,128,161,0,128,158,0,128,163,
0,192,144,0,64,208,73,158,9,32,64,208,128,164,0,137,151,5,20,0,136,147,
4,0,64,146,64,208,136,158,4,0,128,151,0,128,156,0,73,160,9,16,64,208,128,
156,0,64,159,64,208,128,158,0,64,161,64,208,128,161,0,192,146,0,64,208,
137,162,5,12,0,136,159,4,0,128,157,0,128,163,0,200,149,9,0,64,208,128,159,
0,64,148,64,208,73,159,9,20,64,208,128,158,0,137,155,5,8,0,128,152,0,128,
157,0,136,161,4,0,128,160,0,201,154,38,122,0,64,208,73,162,9,20,64,208,
128,159,0,72,159,8,64,208,128,162,0,128,154,0,136,166,4,0,64,163,64,208,
128,151,0,72,152,49,64,208,137,158,5,37,0,137,151,5,12,0,64,144,64,208,
128,161,0,192,152,0,64,208,72,156,8,64,208,128,154,0,64,147,64,208,128,
165,0,136,160,4,0,128,159,0,64,151,64,208,137,152,5,20,0,72,151,12,64,208,
64,159,64,208,128,167,0,128,134,0,72,159,8,64,208,128,158,0,128,157,0,200,
156,29,0,64,208,137,156,5,16,0,137,152,5,8,0,128,145,0,128,154,0,136,162,
4,0,128,160,0,64,155,64,208,128,159,0,74,164,14,1,92,64,208,136,154,4,0,
128,145,0,73,161,29,248,64,208,73,159,9,16,64,208,128,151,0,136,146,4,0,
128,145,0,64,160,64,208,128,151,0,201,159,92,166,0,64,208,137,157,5,40,
0,73,154,9,24,64,208,128,159,0,137,148,5,12,0,64,144,64,208,128,148,0,128,
151,0,136,156,4,0,64,155,64,208,128,158,0,201,161,10,34,0,64,208,128,160,
0,200,159,13,0,64,208,136,173,4,0,128,158,0,64,158,64,208,64,146,64,208,
128,158,0,72,173,8,64,208,128,159,0,128,163,0,192,158,0,64,208,137,158,
5,41,0,73,151,9,21,64,208,128,157,0,200,148,9,0,64,208,128,148,0,128,145,
0,64,157,64,208,64,158,64,208,64,156,64,208,128,152,0,201,160,14,25,0,64,
208,136,161,4,0,128,160,0,64,159,64,208,136,162,4,0,128,159,0,128,162,0,
64,160,64,208,73,161,18,42,64,208,136,173,4,0,192,157,0,64,208,128,175,
0,201,154,10,13,0,64,208,128,161,0,128,151,0,64,157,64,208,136,161,4,0,
128,159,0,136,166,4,0,128,164,0,72,163,67,64,208,73,158,9,42,64,208,128,
162,0,201,148,10,17,0,64,208,128,161,0,64,144,64,208,128,160,0,192,154,
0,64,208,72,161,8,64,208,128,159,0,128,159,0,137,160,5,13,0,192,159,0,64,
208,128,160,0,64,175,64,208,128,159,0,64,162,64,208,73,161,9,12,64,208,
128,159,0,128,159,0,128,163,0,137,169,5,20,0,72,166,8,64,208,128,161,0,
64,165,64,208,128,161,0,72,174,8,64,208,128,152,0,192,173,0,64,208,201,
152,10,26,0,64,208,128,161,0,201,148,10,13,0,64,208,128,158,0,128,144,0,
128,151,0,72,162,8,64,208,128,158,0,128,158,0,82,164,1,10,4,45,64,208,73,
157,9,138,64,208,128,159,0,73,151,9,77,64,208,128,158,0,73,147,21,53,64,
208,73,152,9,12,64,208,128,154,0,128,148,0,128,163,0,72,145,20,64,208,72,
163,12,64,208,64,159,64,208,128,154,0,128,159,0,192,144,0,64,208,64,173,
64,208,128,160,0,72,149,8,64,208,128,157,0,64,148,64,208,128,152,0,73,155,
9,44,64,208,128,155,0,72,154,28,64,208,72,161,16,64,208,136,162,4,0,64,
152,64,208,128,162,0,64,152,64,208,128,161,0,64,152,64,208,128,158,0,192,
156,0,64,208,128,155,0,137,163,5,73,0,73,160,9,32,64,208,128,148,0,72,159,
8,64,208,128,166,0,64,158,64,208,72,156,8,64,208,128,161,0,128,145,0,72,
162,12,64,208,136,152,4,0,128,145,0,192,161,0,64,208,137,157,5,12,0,136,
154,4,0,128,145,0,64,161,64,208,128,160,0,73,167,13,28,64,208,64,162,64,
208,128,152,0,72,166,12,64,208,64,156,64,208,128,155,0,128,165,0,64,173,
64,208,137,154,5,12,0,136,152,4,0,128,148,0,128,173,0,64,163,64,208,74,
155,14,1,152,64,208,136,159,4,0,128,151,0,73,149,29,168,64,208,73,164,9,
20,64,208,128,144,0,64,134,64,208,64,162,64,208,128,163,0,128,173,0,73,
146,29,90,64,208,73,157,13,20,64,208,64,144,64,208,128,161,0,64,148,64,
208,128,162,0,128,162,0,72,145,44,64,208,72,163,8,64,208,128,159,0,64,147,
64,208,73,162,9,24,64,208,128,163,0,72,156,8,64,208,128,163,0,64,144,64,
208,128,163,0,128,163,0,192,144,0,64,208,200,159,9,0,64,208,128,164,0,128,
152,0,72,148,16,64,208,72,152,8,64,208,128,160,0,128,148,0,192,147,0,64,
208,136,165,4,0,192,152,0,64,208,72,152,12,64,208,64,151,64,208,128,160,
0,64,151,64,208,128,160,0,201,152,59,195,0,64,208,73,159,13,36,64,208,64,
159,64,208,128,148,0,73,151,9,12,64,208,128,158,0,128,147,0,64,152,64,208,
64,151,64,208,128,158,0,137,166,5,8,0,128,161,0,192,173,0,64,208,128,173,
0,72,151,129,64,208,73,158,13,84,64,208,64,166,64,208,128,156,0,73,147,
21,44,64,208,72,162,8,64,208,128,163,0,64,159,64,208,128,144,0,72,146,12,
64,208,64,166,64,208,128,156,0,64,144,64,208,64,154,64,208,128,161,0,72,
157,16,64,208,64,152,64,208,64,163,64,208,128,152,0,64,152,64,208,64,173,
64,208,128,159,0,73,161,9,21,64,208,128,156,0,136,160,4,0,192,159,0,64,
208,128,152,0,64,162,64,208,64,144,64,208,64,147,64,208,64,152,64,208,128,
161,0,64,150,64,208,128,148,0,64,154,64,208,72,161,8,64,208,128,158,0,64,
144,64,208,64,160,64,208,64,149,64,208,64,154,64,208,128,163,0,74,161,18,
1,39,64,208,137,156,5,8,0,128,147,0,128,159,0,73,158,33,110,64,208,73,159,
9,20,64,208,128,159,0,136,158,4,0,64,144,64,208,128,159,0,136,161,4,0,128,
160,0,72,157,36,64,208,137,159,5,24,0,72,156,8,64,208,128,151,0,64,147,
64,208,64,164,64,208,128,163,0,64,172,64,208,128,149,0,64,156,64,208,201,
152,10,25,0,64,208,128,147,0,136,151,4,0,64,144,64,208,64,159,64,208,128,
159,0,136,166,4,0,192,161,0,64,208,128,158,0,72,160,124,64,208,73,151,9,
92,64,208,128,161,0,73,147,69,72,64,208,64,144,64,208,64,157,64,208,72,
165,24,64,208,64,152,64,208,64,156,64,208,64,156,64,208,64,144,64,208,128,
168,0,64,156,64,208,64,144,64,208,64,168,64,208,64,151,64,208,64,144,64,
208,64,146,64,208,64,158,64,208,128,148,0,128,146,0,64,148,64,208,64,162,
64,208,128,162,0,72,161,20,64,208,64,154,64,208,64,147,64,208,64,162,64,
208,128,163,0,64,154,64,208,128,161,0,64,159,64,208,73,158,9,24,64,208,
128,161,0,137,151,5,12,0,64,144,64,208,128,159,0,128,154,0,137,164,5,8,
0,128,160,0,64,165,64,208,128,147,0,73,165,17,64,64,208,136,165,4,0,64,
158,64,208,128,156,0,72,163,16,64,208,72,162,8,64,208,128,173,0,128,157,
0,64,162,64,208,73,168,9,20,64,208,128,158,0,72,159,8,64,208,128,159,0,
128,146,0,64,173,64,208,128,159,0,192,173,0,64,208,73,156,9,20,64,208,128,
151,0,64,152,64,208,64,162,64,208,128,163,0,64,162,64,208,128,162,0,64,
165,64,208,73,156,9,32,64,208,128,162,0,137,148,5,12,0,136,145,4,0,128,
144,0,136,155,4,0,64,152,64,208,128,161,0,201,162,22,43,0,64,208,137,159,
5,12,0,136,152,4,0,128,146,0,128,163,0,200,159,13,0,64,208,136,161,4,0,
128,148,0,192,158,0,64,208,128,151,0,128,165,0,82,173,1,61,2,38,64,208,
73,156,37,179,64,208,73,159,13,24,64,208,64,163,64,208,128,161,0,136,154,
4,0,64,146,64,208,128,152,0,136,162,4,0,128,161,0,73,150,9,66,64,208,128,
152,0,73,146,13,45,64,208,64,157,64,208,128,156,0,72,145,8,64,208,128,164,
0,64,144,64,208,201,162,10,13,0,64,208,128,161,0,128,151,0,64,165,64,208,
128,148,0,136,148,4,0,192,147,0,64,208,128,152,0,201,154,30,65,0,64,208,
137,162,5,12,0,136,160,4,0,128,156,0,136,166,4,0,64,165,64,208,128,151,
0,72,152,24,64,208,137,158,5,16,0,136,156,4,0,64,152,64,208,128,158,0,128,
161,0,64,151,64,208,64,161,64,208,128,145,0,64,155,64,208,136,155,4,0,128,
151,0,73,162,13,99,64,208,64,158,64,208,128,160,0,73,159,13,29,64,208,136,
159,4,0,128,155,0,200,158,9,0,64,208,128,152,0,64,157,64,208,128,161,0,
200,161,21,0,64,208,137,155,5,8,0,128,154,0,64,159,64,208,128,144,0,64,
160,64,208,64,159,64,208,201,159,18,25,0,64,208,136,162,4,0,64,152,64,208,
128,162,0,64,152,64,208,128,162,0,128,162,0,137,167,5,24,0,72,166,12,64,
208,64,158,64,208,128,162,0,64,163,64,208,128,154,0,64,173,64,208,128,163,
0,73,168,87,213,64,208,201,159,14,66,0,64,208,136,161,4,0,128,148,0,201,
156,10,41,0,64,208,128,145,0,136,151,4,0,64,146,64,208,137,152,5,16,0,136,
149,4,0,64,146,64,208,128,156,0,64,161,64,208,128,156,0,64,158,64,208,64,
159,64,208,128,161,0,137,165,5,12,0,136,163,4,0,128,162,0,128,166,0,64,
167,64,208,201,161,18,85,0,64,208,72,161,8,64,208,128,156,0,128,156,0,73,
150,9,56,64,208,128,148,0,73,147,29,36,64,208,73,162,13,20,64,208,136,152,
4,0,128,144,0,64,159,64,208,128,163,0,128,163,0,64,144,64,208,128,158,0,
64,148,64,208,64,158,64,208,128,148,0,136,160,4,0,64,159,64,208,128,163,
0,137,164,5,25,0,200,163,9,0,64,208,128,161,0,64,162,64,208,136,152,4,0,
128,144,0,136,173,4,0,192,165,0,64,208,128,154,0,192,169,0,64,208,137,161,
5,12,0,136,160,4,0,128,145,0,128,164,0,72,175,24,64,208,137,162,5,16,0,
72,160,8,64,208,128,163,0,128,154,0,128,166,0,64,174,64,208,201,156,10,
41,0,64,208,128,159,0,137,148,5,28,0,72,146,16,64,208,64,152,64,208,64,
157,64,208,128,161,0,64,145,64,208,128,151,0,128,151,0,137,162,5,16,0,72,
161,8,64,208,128,159,0,128,159,0,128,164,0,82,152,36,83,49,195,64,208,82,
158,1,23,20,139,64,208,73,158,13,169,64,208,64,164,64,208,128,161,0,201,
151,15,88,0,64,208,192,161,0,64,208,128,157,0,73,147,38,58,64,208,137,159,
5,17,0,200,152,9,0,64,208,128,159,0,128,146,0,64,163,64,208,136,159,4,0,
64,157,64,208,128,145,0,72,146,8,64,208,128,148,0,192,144,0,64,208,64,152,
64,208,128,162,0,64,148,64,208,137,158,5,8,0,128,146,0,128,166,0,73,156,
17,45,64,208,137,156,5,8,0,128,151,0,128,161,0,200,154,13,0,64,208,136,
156,4,0,128,147,0,64,152,64,208,136,162,4,0,64,158,64,208,128,162,0,64,
157,64,208,73,159,13,16,64,208,64,159,64,208,128,159,0,128,145,0,128,165,
0,73,163,13,78,64,208,136,154,4,0,128,148,0,73,161,25,49,64,208,137,156,
5,12,0,136,148,4,0,128,146,0,136,160,4,0,128,158,0,72,160,12,64,208,64,
144,64,208,128,157,0,192,159,0,64,208,136,163,4,0,128,156,0,192,162,0,64,
208,136,161,4,0,64,158,64,208,128,148,0,137,166,5,17,0,192,165,0,64,208,
136,156,4,0,128,146,0,64,175,64,208,128,164,0,82,151,1,20,8,76,64,208,73,
156,25,120,64,208,72,152,16,64,208,64,160,64,208,64,144,64,208,128,157,
0,128,146,0,73,147,9,48,64,208,128,144,0,73,145,25,32,64,208,64,152,64,
208,64,160,64,208,64,154,64,208,64,158,64,208,128,156,0,64,144,64,208,128,
144,0,64,146,64,208,128,144,0,73,152,21,32,64,208,72,161,8,64,208,128,159,
0,64,148,64,208,128,158,0,64,148,64,208,136,158,4,0,128,156,0,64,154,64,
208,137,155,5,8,0,128,152,0,128,156,0,73,161,17,112,64,208,136,159,4,0,
64,150,64,208,128,145,0,73,159,13,84,64,208,64,152,64,208,128,164,0,64,
158,64,208,73,157,17,64,64,208,64,152,64,208,64,162,64,208,128,172,0,64,
148,64,208,64,149,64,208,64,175,64,208,64,162,64,208,64,149,64,208,64,155,
64,208,64,172,64,208,64,157,64,208,64,158,64,208,64,161,64,208,64,162,64,
208,128,172,0,128,161,0,64,160,64,208,64,156,64,208,128,146,0,201,163,10,
25,0,64,208,128,161,0,64,162,64,208,137,161,5,8,0,128,156,0,128,162,0,64,
173,64,208,64,156,64,208,128,152,0,82,147,2,42,5,197,64,208,74,157,31,1,
30,64,208,137,154,5,12,0,136,148,4,0,128,147,0,200,159,9,0,64,208,128,163,
0,128,155,0,73,149,9,131,64,208,128,156,0,73,146,9,85,64,208,128,164,0,
200,145,21,0,64,208,137,158,5,12,0,64,152,64,208,128,162,0,128,173,0,64,
144,64,208,137,157,5,28,0,137,146,5,12,0,64,145,64,208,128,156,0,64,152,
64,208,64,156,64,208,128,154,0,72,162,8,64,208,128,159,0,64,161,64,208,
137,157,5,8,0,128,144,0,128,163,0,200,148,21,0,64,208,136,161,4,0,64,147,
64,208,64,152,64,208,128,147,0,192,147,0,64,208,137,157,5,8,0,128,148,0,
128,163,0,73,155,13,97,64,208,136,163,4,0,128,161,0,72,154,20,64,208,73,
155,9,12,64,208,128,161,0,128,151,0,128,173,0,64,152,64,208,73,160,29,36,
64,208,72,157,16,64,208,64,152,64,208,64,147,64,208,128,156,0,64,147,64,
208,128,152,0,136,155,4,0,128,147,0,72,163,8,64,208,128,146,0,192,162,0,
64,208,137,156,5,8,0,128,152,0,128,158,0,64,156,64,208,137,160,5,16,0,137,
151,5,8,0,128,144,0,128,154,0,136,173,4,0,128,163,0,73,162,29,152,64,208,
73,161,9,20,64,208,128,154,0,72,160,8,64,208,128,154,0,128,144,0,128,163,
0,73,160,13,100,64,208,64,152,64,208,128,160,0,72,159,48,64,208,137,157,
5,28,0,137,152,5,20,0,72,151,8,64,208,128,161,0,64,144,64,208,128,157,0,
128,154,0,137,163,5,8,0,128,160,0,64,173,64,208,128,173,0,64,158,64,208,
73,160,9,24,64,208,128,160,0,136,158,4,0,64,148,64,208,64,154,64,208,128,
145,0,136,164,4,0,64,161,64,208,128,158,0,64,161,64,208,137,161,5,12,0,
136,158,4,0,128,157,0,136,163,4,0,128,162,0,73,165,21,96,64,208,136,163,
4,0,64,162,64,208,136,163,4,0,128,144,0,200,164,17,0,64,208,64,159,64,208,
64,156,64,208,128,159,0,192,163,0,64,208,73,159,25,45,64,208,136,161,4,
0,64,152,64,208,136,162,4,0,64,152,64,208,128,162,0,72,156,8,64,208,128,
158,0,192,152,0,64,208,64,161,64,208,128,152,0,192,160,0,64,208,128,173,
0,192,173,0,64,208,136,163,4,0,128,144,0,210,145,1,20,2,64,0,64,208,201,
159,30,158,0,64,208,137,161,5,16,0,136,156,4,0,64,152,64,208,128,162,0,
136,167,4,0,128,163,0,73,152,33,79,64,208,137,159,5,20,0,72,148,8,64,208,
128,144,0,64,146,64,208,128,156,0,136,173,4,0,128,164,0,201,147,10,30,0,
64,208,128,156,0,72,146,12,64,208,136,151,4,0,128,146,0,192,145,0,64,208,
128,161,0,192,148,0,64,208,137,148,5,8,0,128,144,0,128,163,0,201,156,22,
30,0,64,208,137,159,5,12,0,64,149,64,208,128,148,0,128,162,0,192,154,0,
64,208,128,161,0,64,158,64,208,137,160,5,12,0,64,157,64,208,128,165,0,128,
165,0,73,164,9,73,64,208,128,156,0,201,161,22,45,0,64,208,72,173,8,64,208,
128,152,0,64,163,64,208,128,159,0,64,160,64,208,73,152,9,16,64,208,128,
161,0,64,144,64,208,128,173,0,128,160,0,64,162,64,208,137,159,5,12,0,64,
154,64,208,128,161,0,128,161,0,201,166,10,13,0,64,208,128,161,0,128,165,
0,64,173,64,208,73,152,9,16,64,208,128,162,0,64,144,64,208,128,157,0,128,
159,0,64,144,64,208,73,159,29,162,64,208,137,160,5,16,0,137,158,5,8,0,128,
155,0,128,159,0,136,164,4,0,128,163,0,73,152,17,53,64,208,137,161,5,8,0,
128,148,0,128,173,0,73,148,13,33,64,208,136,156,4,0,128,146,0,200,145,13,
0,64,208,136,161,4,0,128,144,0,64,144,64,208,128,151,0,128,150,0,73,157,
33,73,64,208,137,159,5,20,0,72,156,12,64,208,64,161,64,208,128,159,0,128,
152,0,64,162,64,208,128,173,0,200,156,33,0,64,208,137,159,5,20,0,73,152,
9,12,64,208,128,145,0,128,144,0,128,158,0,136,166,4,0,128,162,0,64,154,
64,208,128,152,0,64,158,64,208,128,163,0,137,165,5,110,0,73,162,45,102,
64,208,137,157,5,24,0,73,152,9,16,64,208,128,162,0,64,146,64,208,128,162,
0,128,154,0,137,163,5,12,0,64,158,64,208,128,161,0,128,173,0,200,161,38,
0,64,208,201,163,14,29,0,64,208,136,173,4,0,128,158,0,72,161,12,64,208,
64,173,64,208,128,159,0,128,152,0,128,166,0,64,160,64,208,73,165,9,12,64,
208,128,152,0,128,162,0,128,173,0,128,163,0,201,173,18,21,0,64,208,137,
161,5,8,0,128,147,0,128,162,0,128,166,0,128,175,0,64,146,64,208,73,158,
13,198,64,208,136,163,4,0,128,146,0,73,152,17,133,64,208,72,173,8,64,208,
128,159,0,128,145,0,73,146,45,76,64,208,73,152,13,32,64,208,64,145,64,208,
128,148,0,136,151,4,0,64,144,64,208,64,152,64,208,136,163,4,0,128,152,0,
64,157,64,208,128,147,0,72,145,12,64,208,64,148,64,208,128,146,0,64,144,
64,208,72,162,8,64,208,128,163,0,64,152,64,208,128,152,0,72,148,8,64,208,
128,159,0,64,147,64,208,137,163,5,21,0,72,156,8,64,208,128,144,0,192,152,
0,64,208,128,147,0,64,173,64,208,128,163,0,73,156,25,44,64,208,73,152,13,
16,64,208,64,156,64,208,128,147,0,128,144,0,128,162,0,136,155,4,0,64,154,
64,208,137,164,5,8,0,128,144,0,128,173,0,192,157,0,64,208,128,148,0,73,
163,9,103,64,208,128,151,0,201,161,18,50,0,64,208,137,161,5,8,0,128,160,
0,128,162,0,72,160,12,64,208,64,144,64,208,128,157,0,192,159,0,64,208,137,
159,5,8,0,128,148,0,64,164,64,208,128,167,0,192,162,0,64,208,73,158,9,28,
64,208,128,145,0,73,145,9,16,64,208,128,161,0,64,144,64,208,128,157,0,128,
157,0,72,163,8,64,208,128,151,0,128,160,0,201,173,28,35,0,64,208,200,161,
13,0,64,208,64,173,64,208,128,159,0,192,159,0,64,208,128,162,0,136,166,
4,0,128,164,0,64,174,64,208,128,145,0,74,149,58,1,43,64,208,73,157,13,36,
64,208,64,152,64,208,128,173,0,73,152,13,20,64,208,64,147,64,208,128,157,
0,64,144,64,208,128,161,0,128,154,0,136,175,4,0,64,161,64,208,64,173,64,
208,128,157,0,64,148,64,208,201,157,18,135,0,64,208,137,158,5,8,0,128,154,
0,128,162,0,73,151,13,64,64,208,64,152,64,208,128,159,0,73,147,13,28,64,
208,64,154,64,208,128,145,0,72,146,8,64,208,128,162,0,64,144,64,208,128,
145,0,64,148,64,208,137,163,5,16,0,136,160,4,0,64,159,64,208,128,152,0,
128,166,0,201,154,19,34,0,64,208,64,173,64,208,192,155,0,64,208,128,161,
0,64,152,64,208,72,155,8,64,208,128,154,0,128,154,0,64,156,64,208,137,152,
5,8,0,128,147,0,64,160,64,208,128,160,0,73,162,13,75,64,208,64,159,64,208,
128,159,0,137,160,5,46,0,72,159,29,64,208,73,159,9,21,64,208,128,158,0,
200,158,9,0,64,208,128,152,0,128,152,0,128,161,0,64,158,64,208,192,159,
0,64,208,128,159,0,64,161,64,208,200,162,9,0,64,208,128,163,0,128,152,0,
73,166,13,20,64,208,136,156,4,0,128,154,0,64,163,64,208,128,154,0,64,174,
64,208,128,166,0,64,150,64,208,73,155,9,48,64,208,128,162,0,73,152,13,36,
64,208,64,155,64,208,128,162,0,136,148,4,0,64,147,64,208,72,162,8,64,208,
128,163,0,64,156,64,208,128,144,0,128,154,0,137,162,5,17,0,192,161,0,64,
208,136,154,4,0,128,144,0,128,163,0,74,155,153,3,240,64,208,201,159,10,
78,0,64,208,128,162,0,73,155,17,45,64,208,64,156,64,208,64,152,64,208,128,
154,0,72,154,16,64,208,64,152,64,208,64,160,64,208,128,155,0,64,152,64,
208,192,156,0,64,208,128,154,0,72,158,16,64,208,64,146,64,208,64,148,64,
208,128,162,0,64,156,64,208,128,154,0,73,165,9,33,64,208,128,158,0,72,164,
8,64,208,128,152,0,192,161,0,64,208,64,161,64,208,64,151,64,208,128,152,
0,72,173,16,64,208,72,156,8,64,208,128,158,0,128,154,0,64,166,64,208,64,
157,64,208,64,173,64,208,64,154,64,208,128,161,0,74,153,19,1,184,64,208,
192,147,0,64,208,64,144,64,208,128,161,0,192,152,0,64,208,201,157,38,188,
0,64,208,137,159,5,20,0,72,152,12,64,208,64,152,64,208,128,154,0,128,148,
0,136,165,4,0,64,162,64,208,128,145,0,73,149,17,81,64,208,136,162,4,0,64,
152,64,208,128,162,0,73,146,17,41,64,208,137,161,5,8,0,128,152,0,128,162,
0,200,145,13,0,64,208,136,160,4,0,128,148,0,64,144,64,208,136,173,4,0,128,
161,0,72,148,8,64,208,128,162,0,64,147,64,208,72,161,8,64,208,128,158,0,
128,158,0,73,154,21,41,64,208,137,152,5,12,0,136,150,4,0,128,147,0,128,
162,0,200,152,13,0,64,208,64,152,64,208,128,162,0,64,150,64,208,128,162,
0,64,156,64,208,201,156,18,21,0,64,208,64,148,64,208,64,145,64,208,128,
161,0,128,154,0,128,162,0,73,164,21,180,64,208,73,159,9,12,64,208,128,163,
0,128,154,0,128,164,0,73,161,49,97,64,208,73,159,13,28,64,208,64,159,64,
208,128,160,0,137,156,5,8,0,128,148,0,64,157,64,208,128,158,0,137,161,5,
12,0,64,160,64,208,128,160,0,128,163,0,72,160,8,64,208,128,162,0,192,159,
0,64,208,73,159,9,32,64,208,128,160,0,72,158,12,64,208,64,147,64,208,128,
156,0,64,154,64,208,64,160,64,208,128,158,0,128,162,0,72,163,17,64,208,
192,161,0,64,208,64,157,64,208,128,158,0,192,162,0,64,208,137,162,5,25,
0,73,152,9,12,64,208,128,154,0,128,145,0,192,158,0,64,208,128,157,0,72,
173,8,64,208,128,156,0,64,163,64,208,128,161,0,73,173,21,40,64,208,72,161,
12,64,208,64,152,64,208,128,161,0,128,160,0,72,166,12,64,208,64,158,64,
208,128,148,0,64,165,64,208,128,160,0,192,175,0,64,208,128,155,0,192,154,
0,64,208,73,158,17,217,64,208,136,161,4,0,64,159,64,208,128,160,0,201,150,
10,79,0,64,208,128,162,0,73,146,9,46,64,208,128,167,0,72,145,8,64,208,128,
158,0,64,144,64,208,201,160,10,17,0,64,208,128,159,0,136,159,4,0,128,156,
0,192,161,0,64,208,128,158,0,72,148,8,64,208,128,159,0,64,147,64,208,72,
161,8,64,208,128,157,0,128,159,0,73,155,9,77,64,208,128,158,0,72,154,12,
64,208,64,159,64,208,128,158,0,192,152,0,64,208,137,159,5,40,0,73,156,13,
32,64,208,64,161,64,208,128,158,0,72,147,12,64,208,64,152,64,208,128,161,
0,64,144,64,208,128,162,0,128,158,0,137,162,5,8,0,128,161,0,128,166,0,72,
157,12,64,208,64,159,64,208,128,162,0,192,156,0,64,208,73,152,13,20,64,
208,136,162,4,0,128,161,0,136,145,4,0,128,144,0,136,162,4,0,128,158,0,73,
164,9,144,64,208,128,155,0,73,161,59,95,64,208,137,158,5,29,0,201,152,10,
13,0,64,208,128,148,0,128,147,0,64,156,64,208,64,152,64,208,128,160,0,73,
162,13,21,64,208,64,149,64,208,128,154,0,192,160,0,64,208,128,164,0,128,
163,0,200,160,21,0,64,208,72,167,8,64,208,128,161,0,64,144,64,208,128,157,
0,64,159,64,208,137,162,5,8,0,128,161,0,128,163,0,72,163,8,64,208,128,160,
0,192,162,0,64,208,137,161,5,16,0,137,158,5,8,0,128,146,0,128,159,0,137,
166,5,8,0,128,162,0,128,174,0,137,168,5,22,0,200,167,9,0,64,208,128,160,
0,192,166,0,64,208,128,160,0,72,174,8,64,208,128,155,0,64,173,64,208,137,
161,5,12,0,136,159,4,0,128,156,0,128,162,0,80,157,4,205,64,208,202,157,
19,2,41,0,64,208,137,156,5,8,0,128,154,0,128,166,0,74,149,26,1,53,64,208,
136,163,4,0,64,161,64,208,64,157,64,208,64,173,64,208,128,154,0,73,146,
177,228,64,208,137,165,5,164,0,72,163,8,64,208,128,160,0,64,149,64,208,
64,161,64,208,64,162,64,208,73,160,33,92,64,208,64,144,64,208,64,161,64,
208,64,162,64,208,64,145,64,208,64,144,64,208,64,157,64,208,128,154,0,72,
159,28,64,208,64,160,64,208,64,158,64,208,64,149,64,208,64,154,64,208,64,
162,64,208,128,171,0,64,154,64,208,64,158,64,208,64,157,64,208,64,162,64,
208,64,160,64,208,64,144,64,208,64,154,64,208,128,162,0,72,164,16,64,208,
64,158,64,208,64,157,64,208,128,148,0,64,162,64,208,64,158,64,208,64,160,
64,208,64,147,64,208,64,145,64,208,64,144,64,208,64,157,64,208,128,154,
0,64,173,64,208,128,155,0,72,145,32,64,208,73,161,9,20,64,208,128,152,0,
64,152,64,208,64,158,64,208,128,156,0,64,174,64,208,128,156,0,64,144,64,
208,137,160,5,12,0,136,145,4,0,128,144,0,128,163,0,72,148,12,64,208,64,
149,64,208,128,156,0,64,147,64,208,137,154,5,16,0,72,152,8,64,208,128,147,
0,128,147,0,64,158,64,208,72,160,16,64,208,64,162,64,208,64,149,64,208,
128,165,0,128,154,0,73,154,57,190,64,208,73,158,25,40,64,208,64,156,64,
208,64,145,64,208,64,144,64,208,64,157,64,208,128,154,0,136,147,4,0,64,
144,64,208,64,160,64,208,128,162,0,136,163,4,0,64,160,64,208,128,163,0,
72,152,90,64,208,73,161,9,53,64,208,128,145,0,73,157,13,29,64,208,64,164,
64,208,128,158,0,200,152,13,0,64,208,64,161,64,208,128,165,0,128,147,0,
64,158,64,208,137,160,5,8,0,128,157,0,128,161,0,73,163,9,20,64,208,128,
161,0,64,162,64,208,64,149,64,208,128,155,0,192,166,0,64,208,64,146,64,
208,128,151,0,64,150,64,208,64,162,64,208,64,160,64,208,64,144,64,208,64,
157,64,208,64,161,64,208,64,161,64,208,64,162,64,208,64,160,64,208,64,158,
64,208,128,153,0,72,156,28,64,208,137,161,5,20,0,136,158,4,0,64,144,64,
208,64,161,64,208,128,162,0,128,173,0,64,155,64,208,128,161,0,74,163,42,
1,132,64,208,73,159,13,28,64,208,64,145,64,208,128,162,0,136,157,4,0,64,
156,64,208,64,152,64,208,128,162,0,136,162,4,0,128,161,0,73,160,13,108,
64,208,136,161,4,0,128,152,0,72,159,64,64,208,137,159,5,24,0,137,154,5,
16,0,72,152,8,64,208,128,152,0,128,144,0,128,158,0,137,164,5,32,0,64,160,
64,208,64,158,64,208,64,156,64,208,64,145,64,208,64,144,64,208,64,157,64,
208,128,154,0,128,167,0,64,158,64,208,137,162,5,24,0,136,159,4,0,64,145,
64,208,136,158,4,0,64,152,64,208,128,161,0,128,166,0,72,162,152,64,208,
73,152,25,112,64,208,64,156,64,208,64,164,64,208,64,158,64,208,64,162,64,
208,128,158,0,72,149,76,64,208,72,160,56,64,208,72,162,12,64,208,64,149,
64,208,128,165,0,64,157,64,208,64,149,64,208,64,162,64,208,64,156,64,208,
64,144,64,208,64,147,64,208,64,144,64,208,64,151,64,208,64,152,64,208,128,
157,0,64,155,64,208,64,162,64,208,64,149,64,208,128,165,0,64,144,64,208,
64,153,64,208,128,156,0,72,163,24,64,208,72,157,12,64,208,64,152,64,208,
128,147,0,64,152,64,208,128,162,0,64,154,64,208,64,158,64,208,128,156,0,
64,161,64,208,201,158,27,55,0,64,208,200,160,9,0,64,208,128,144,0,64,156,
64,208,64,144,64,208,128,160,0,72,152,25,64,208,192,161,0,64,208,64,162,
64,208,64,149,64,208,64,156,64,208,128,161,0,128,148,0,72,173,12,64,208,
136,160,4,0,128,152,0,64,162,64,208,72,173,8,64,208,128,145,0,128,158,0,
74,173,56,1,19,64,208,137,159,5,28,0,72,154,20,64,208,72,158,8,64,208,128,
156,0,64,145,64,208,128,152,0,128,152,0,200,163,13,0,64,208,136,159,4,0,
128,156,0,192,161,0,64,208,128,159,0,72,165,16,64,208,72,163,8,64,208,128,
154,0,128,161,0,64,164,64,208,73,158,165,192,64,208,73,159,37,96,64,208,
64,160,64,208,64,158,64,208,64,148,64,208,64,163,64,208,64,154,64,208,64,
162,64,208,64,158,64,208,128,146,0,72,155,40,64,208,64,158,64,208,64,147,
64,208,64,152,64,208,64,167,64,208,64,149,64,208,64,161,64,208,64,154,64,
208,64,158,64,208,128,153,0,64,154,64,208,64,152,64,208,64,158,64,208,64,
161,64,208,128,154,0,72,162,20,64,208,64,149,64,208,136,165,4,0,64,154,
64,208,128,161,0,64,160,64,208,64,156,64,208,64,144,64,208,64,147,64,208,
64,149,64,208,64,157,64,208,64,162,64,208,64,161,64,208,64,162,64,208,64,
146,64,208,128,144,0,73,152,9,20,64,208,128,161,0,64,144,64,208,64,160,
64,208,128,161,0,64,157,64,208,128,161,0,136,161,4,0,128,159,0,64,175,64,
208,128,151,0,64,156,64,208,138,157,6,1,11,0,73,149,21,148,64,208,136,165,
4,0,64,148,64,208,64,152,64,208,128,161,0,73,146,21,72,64,208,137,160,5,
12,0,136,154,4,0,128,146,0,128,161,0,72,145,36,64,208,137,158,5,24,0,73,
152,13,16,64,208,136,162,4,0,128,159,0,128,148,0,128,154,0,136,173,4,0,
128,159,0,64,144,64,208,136,164,4,0,64,159,64,208,128,162,0,72,148,28,64,
208,137,162,5,20,0,72,154,8,64,208,128,145,0,64,152,64,208,128,162,0,128,
166,0,64,147,64,208,72,160,8,64,208,128,173,0,64,152,64,208,72,157,8,64,
208,128,154,0,128,147,0,201,154,38,77,0,64,208,137,162,5,20,0,73,156,9,
12,64,208,128,159,0,128,144,0,128,157,0,72,173,8,64,208,128,161,0,128,166,
0,72,152,36,64,208,73,154,9,24,64,208,128,157,0,72,148,12,64,208,64,152,
64,208,128,161,0,128,145,0,136,164,4,0,128,160,0,128,151,0,72,156,24,64,
208,73,155,9,16,64,208,128,150,0,64,152,64,208,128,164,0,128,164,0,192,
155,0,64,208,136,152,4,0,128,150,0,137,163,5,235,0,73,160,17,165,64,208,
137,159,5,8,0,128,148,0,128,166,0,72,159,67,72,208,59,137,167,5,28,0,64,
152,64,208,73,161,9,16,64,208,128,160,0,64,159,64,208,128,159,0,128,173,
0,192,173,0,64,208,64,154,64,208,64,161,64,208,64,145,64,208,64,144,64,
208,64,157,64,208,128,154,0,64,83,128,84,0,192,158,0,64,208,73,161,13,65,
64,208,136,165,4,0,128,162,0,73,156,9,28,64,208,128,161,0,64,152,64,208,
72,161,12,64,208,64,159,64,208,128,157,0,128,159,0,192,159,0,64,208,136,
157,4,0,64,144,64,208,64,146,64,208,64,152,64,208,128,157,0,72,175,8,64,
208,128,154,0,128,166,0,200,162,33,0,64,208,137,161,5,16,0,136,159,4,0,
64,152,64,208,128,159,0,72,173,8,64,208,128,156,0,128,163,0,192,161,0,64,
208,137,158,5,16,0,136,154,4,0,64,147,64,208,128,161,0,136,165,4,0,64,159,
64,83,128,84,0,137,167,5,26,0,200,166,13,0,64,208,136,159,4,0,128,144,0,
192,164,0,64,208,128,152,0,72,173,80,64,208,137,158,5,38,0,137,154,5,21,
0,200,152,13,0,64,208,136,152,4,0,128,145,0,128,145,0,200,156,9,0,64,208,
128,158,0,128,155,0,137,162,5,34,0,200,161,9,0,64,208,128,165,0,192,159,
0,64,208,72,158,12,64,208,64,160,64,208,128,151,0,128,152,0,128,164,0,64,
168,64,208,128,160,0,74,165,145,12,178,64,208,73,159,9,56,64,208,128,156,
0,137,147,5,24,0,72,146,8,64,208,128,146,0,64,145,64,208,64,164,64,208,
128,156,0,72,156,8,64,208,128,151,0,64,154,64,208,72,152,8,64,208,128,147,
0,128,147,0,201,164,10,70,0,64,208,128,151,0,72,162,57,64,208,201,162,30,
49,0,64,208,137,156,5,12,0,64,152,64,208,128,156,0,64,159,64,208,64,156,
64,208,128,161,0,72,160,16,64,208,64,173,64,208,64,156,64,208,128,161,0,
128,152,0,128,163,0,128,160,0,192,165,0,64,208,64,156,64,208,128,159,0,
210,162,1,131,10,7,0,64,208,201,156,42,202,0,64,208,137,154,5,28,0,73,147,
9,12,64,208,128,158,0,128,145,0,64,152,64,208,64,146,64,208,128,162,0,136,
164,4,0,128,158,0,73,149,9,87,64,208,128,154,0,73,147,13,63,64,208,136,
159,4,0,128,158,0,72,145,16,64,208,137,154,5,8,0,128,152,0,128,161,0,64,
144,64,208,201,160,24,27,0,64,45,64,208,64,162,64,208,64,144,64,208,64,
161,64,208,128,161,0,128,152,0,128,173,0,64,148,64,208,136,162,4,0,64,158,
64,208,128,159,0,73,154,17,57,64,208,136,161,4,0,64,158,64,208,128,160,
0,72,152,32,64,208,137,148,5,12,0,136,147,4,0,128,145,0,72,160,12,64,208,
64,168,64,208,128,145,0,128,159,0,192,151,0,64,208,128,152,0,192,155,0,
64,208,137,159,5,8,0,128,146,0,128,162,0,73,162,17,100,64,208,136,164,4,
0,64,158,64,208,128,159,0,201,160,18,50,0,64,208,137,154,5,8,0,128,145,
0,128,159,0,200,159,25,0,64,208,137,156,5,12,0,136,152,4,0,128,148,0,136,
173,4,0,128,166,0,64,158,64,208,128,151,0,192,161,0,64,208,137,154,5,16,
0,72,152,8,64,208,128,148,0,128,145,0,136,159,4,0,192,158,0,64,208,128,
157,0,137,168,5,53,0,72,164,12,64,208,136,154,4,0,128,152,0,192,163,0,64,
208,137,160,5,20,0,137,152,5,12,0,64,144,64,208,128,154,0,128,157,0,72,
166,8,64,208,128,160,0,128,162,0,64,173,64,208,137,161,5,12,0,136,155,4,
0,128,145,0,136,164,4,0,128,162,0,82,160,1,240,5,121,64,208,202,157,23,
1,1,0,64,208,137,154,5,8,0,128,149,0,64,158,64,208,128,162,0,73,149,14,
121,64,208,192,144,0,64,208,128,157,0,73,146,25,48,64,208,137,160,5,16,
0,64,152,64,208,136,158,4,0,128,154,0,128,166,0,72,145,8,64,208,128,173,
0,64,144,64,208,137,156,5,8,0,128,146,0,128,161,0,200,148,18,0,64,208,200,
159,9,0,64,208,128,158,0,128,158,0,64,147,64,208,201,163,14,34,0,64,208,
64,159,64,208,128,161,0,72,162,8,64,208,128,163,0,192,158,0,64,208,64,156,
64,208,128,161,0,128,164,0,73,154,25,94,64,208,137,145,5,12,0,64,144,64,
208,128,151,0,64,161,64,208,128,146,0,200,152,66,0,64,208,73,161,9,37,64,
208,128,154,0,201,158,10,25,0,64,208,128,165,0,72,156,8,64,208,128,159,
0,64,144,64,208,128,161,0,128,159,0,137,165,5,16,0,64,162,64,208,64,158,
64,208,128,159,0,64,173,64,208,128,162,0,128,151,0,72,156,8,64,208,128,
158,0,64,155,64,208,136,175,4,0,128,152,0,73,164,25,157,64,208,137,160,
5,12,0,64,158,64,208,128,160,0,64,165,64,208,128,159,0,73,160,17,65,64,
208,72,161,8,64,208,128,158,0,128,159,0,72,159,24,64,208,137,158,5,12,0,
136,145,4,0,128,144,0,64,159,64,208,128,158,0,64,158,64,208,73,159,9,17,
64,208,128,151,0,192,158,0,64,208,128,158,0,128,164,0,72,162,37,64,208,
137,159,5,16,0,136,158,4,0,64,155,64,208,128,161,0,200,173,13,0,64,208,
64,152,64,208,128,162,0,128,161,0,192,161,0,64,208,201,158,10,18,0,64,208,
128,162,0,192,152,0,64,208,128,148,0,64,173,64,208,128,156,0,73,167,9,20,
64,208,128,159,0,136,166,4,0,64,165,64,208,128,155,0,200,175,9,0,64,208,
128,159,0,192,173,0,64,208,73,161,22,33,64,208,200,159,13,0,64,208,64,152,
64,208,128,159,0,128,148,0,72,156,8,64,208,128,163,0,128,152,0,136,163,
4,0,128,162,0,192,159,0,64,208,74,158,58,1,238,64,208,73,159,13,48,64,208,
64,144,64,208,128,162,0,72,151,28,64,208,64,149,64,208,64,156,64,208,64,
145,64,208,64,144,64,208,64,157,64,208,128,154,0,64,146,64,208,128,161,
0,128,161,0,73,151,9,160,64,208,128,167,0,201,147,18,124,0,64,208,136,158,
4,0,64,156,64,208,128,163,0,201,145,47,74,0,64,208,137,160,5,29,0,200,158,
13,0,64,208,64,174,64,208,128,155,0,64,144,64,208,64,173,64,208,128,161,
0,72,174,8,64,208,128,155,0,128,173,0,64,144,64,208,137,157,5,16,0,72,149,
8,64,208,128,152,0,128,147,0,136,160,4,0,128,159,0,192,146,0,64,208,73,
160,13,20,64,208,64,148,64,208,128,162,0,136,156,4,0,128,144,0,136,173,
4,0,128,162,0,72,149,8,64,208,128,156,0,64,148,64,208,137,158,5,12,0,136,
157,4,0,128,155,0,128,159,0,201,155,14,222,0,64,208,64,152,64,208,128,162,
0,200,154,97,0,64,208,73,158,9,68,64,208,128,157,0,73,152,33,48,64,208,
136,160,4,0,64,159,64,208,73,160,9,12,64,208,128,158,0,128,154,0,64,164,
64,208,128,161,0,64,147,64,208,64,161,64,208,64,151,64,208,128,163,0,64,
154,64,208,64,157,64,208,128,158,0,72,161,12,64,208,136,164,4,0,128,151,
0,64,160,64,208,136,158,4,0,128,154,0,64,152,64,208,73,159,17,58,64,208,
72,160,8,64,208,128,173,0,128,148,0,73,154,9,25,64,208,128,159,0,200,152,
9,0,64,208,128,156,0,64,144,64,208,128,157,0,200,158,9,0,64,208,128,165,
0,64,156,64,208,128,158,0,137,162,5,29,0,72,161,12,64,208,136,162,4,0,128,
151,0,192,160,0,64,208,64,144,64,208,128,157,0,200,164,17,0,64,208,72,161,
8,64,208,128,152,0,128,144,0,128,163,0,200,157,17,0,64,208,72,162,8,64,
208,128,161,0,128,147,0,192,156,0,64,208,137,158,5,25,0,137,154,5,12,0,
64,149,64,208,128,165,0,192,156,0,64,208,128,161,0,136,162,4,0,128,159,
0,74,164,35,1,72,64,208,137,156,5,12,0,136,147,4,0,128,144,0,200,160,13,
0,64,208,64,144,64,208,128,157,0,128,158,0,201,161,55,216,0,64,208,73,158,
9,24,64,208,128,159,0,137,156,5,12,0,136,152,4,0,128,144,0,128,157,0,73,
163,9,17,64,208,128,145,0,192,161,0,64,208,128,158,0,64,173,64,208,128,
162,0,200,160,79,0,64,208,201,158,38,61,0,64,208,72,156,28,64,208,64,144,
64,208,64,168,64,208,64,159,64,208,64,160,64,208,64,158,64,208,128,156,
0,128,147,0,73,152,13,20,64,208,136,157,4,0,128,156,0,64,144,64,208,128,
157,0,128,154,0,200,173,9,0,64,208,128,154,0,128,160,0,64,159,64,208,137,
156,5,38,0,201,152,10,21,0,64,208,128,159,0,136,147,4,0,64,146,64,208,128,
158,0,136,155,4,0,192,154,0,64,208,128,161,0,73,161,13,25,64,208,136,163,
4,0,128,162,0,200,159,9,0,64,208,128,154,0,128,158,0,72,173,12,64,208,136,
162,4,0,128,161,0,128,163,0,72,163,16,64,208,72,161,8,64,208,128,161,0,
128,160,0,64,162,64,208,201,159,10,38,0,64,208,128,167,0,73,156,9,25,64,
208,128,163,0,200,152,9,0,64,208,128,155,0,64,148,64,208,128,156,0,128,
158,0,137,163,5,12,0,136,162,4,0,128,161,0,64,173,64,208,128,160,0,73,167,
9,41,64,208,128,148,0,136,166,4,0,192,165,0,64,208,137,164,5,16,0,136,161,
4,0,64,152,64,208,128,154,0,64,173,64,208,128,162,0,136,175,4,0,64,173,
64,208,137,154,5,17,0,136,146,4,0,192,145,0,64,208,128,163,0,200,173,9,
0,64,208,128,164,0,128,161,0,64,161,64,208,202,158,57,1,117,0,64,208,137,
152,5,25,0,73,147,9,17,64,208,128,148,0,192,144,0,64,208,128,144,0,128,
150,0,137,162,5,8,0,128,156,0,192,163,0,64,208,64,154,64,208,64,152,64,
208,128,162,0,201,151,18,128,0,64,208,137,161,5,8,0,128,149,0,128,164,0,
73,146,9,77,64,208,128,162,0,72,145,16,64,208,137,160,5,8,0,128,156,0,128,
163,0,64,144,64,208,201,160,10,29,0,64,208,128,159,0,137,147,5,8,0,128,
144,0,64,157,64,208,136,162,4,0,128,161,0,72,162,8,64,208,128,160,0,64,
161,64,208,64,159,64,208,128,156,0,200,148,21,0,64,208,137,159,5,8,0,128,
156,0,64,163,64,208,128,158,0,192,147,0,64,208,136,151,4,0,128,148,0,73,
155,9,122,64,208,128,156,0,72,154,48,64,208,73,158,9,24,64,208,128,150,
0,73,152,9,12,64,208,128,157,0,128,151,0,128,156,0,73,160,13,16,64,208,
64,144,64,208,128,157,0,128,159,0,128,167,0,192,152,0,64,208,137,158,5,
20,0,73,147,9,12,64,208,128,151,0,128,144,0,128,148,0,73,163,13,29,64,208,
64,160,64,208,128,173,0,192,162,0,64,208,72,161,8,64,208,128,158,0,128,
158,0,64,173,64,208,136,151,4,0,128,150,0,72,157,20,64,208,73,151,9,12,
64,208,128,157,0,128,147,0,128,157,0,192,156,0,64,208,201,148,10,21,0,64,
208,128,159,0,72,146,8,64,208,128,161,0,128,144,0,136,173,4,0,192,154,0,
64,208,64,152,64,208,64,173,64,208,128,156,0,202,164,23,1,49,0,64,208,137,
159,5,8,0,128,156,0,64,162,64,208,128,162,0,201,161,36,157,0,64,208,73,
161,9,26,64,208,128,160,0,200,158,9,0,64,208,128,158,0,192,144,0,64,208,
128,158,0,128,165,0,72,160,32,64,208,73,158,9,20,64,208,128,158,0,136,145,
4,0,64,144,64,208,128,157,0,136,166,4,0,128,159,0,64,159,64,208,201,159,
22,62,0,64,208,137,160,5,12,0,136,157,4,0,128,149,0,128,163,0,201,152,14,
21,0,64,208,136,173,4,0,128,159,0,136,148,4,0,128,144,0,64,158,64,208,64,
155,64,208,64,154,64,208,64,158,64,208,128,156,0,137,161,5,20,0,64,160,
64,208,136,154,4,0,64,144,64,208,128,157,0,128,173,0,72,163,49,64,208,137,
160,5,25,0,201,152,10,17,0,64,208,128,145,0,64,145,64,208,128,148,0,128,
159,0,73,162,9,16,64,208,128,173,0,64,161,64,208,128,159,0,128,164,0,64,
162,64,208,73,158,13,40,64,208,64,152,64,208,128,160,0,137,154,5,16,0,136,
148,4,0,64,144,64,208,128,161,0,64,156,64,208,64,144,64,208,128,162,0,73,
164,13,25,64,208,64,144,64,208,128,154,0,200,163,9,0,64,208,128,161,0,128,
161,0,64,173,64,208,128,154,0,137,167,5,40,0,72,166,24,64,208,136,159,4,
0,64,144,64,208,64,163,64,208,64,151,64,208,128,160,0,64,165,64,208,64,
159,64,208,128,160,0,192,173,0,64,208,137,155,5,24,0,137,150,5,8,0,128,
145,0,64,152,64,208,136,161,4,0,128,159,0,137,160,5,25,0,192,159,0,64,208,
137,157,5,12,0,64,152,64,208,128,156,0,128,159,0,128,173,0,80,164,1,105,
64,208,73,156,26,162,64,208,136,154,4,0,192,152,0,64,208,136,159,4,0,64,
149,64,208,128,162,0,201,150,10,84,0,64,208,128,161,0,201,146,18,42,0,64,
208,137,162,5,8,0,128,148,0,128,173,0,72,145,8,64,208,128,162,0,192,144,
0,64,208,137,151,5,8,0,128,146,0,128,160,0,72,148,8,64,208,128,158,0,192,
147,0,64,208,72,162,16,64,208,64,163,64,208,64,157,64,208,128,147,0,128,
158,0,201,154,18,45,0,64,208,136,161,4,0,64,152,64,208,128,144,0,72,152,
24,64,208,137,162,5,12,0,136,159,4,0,128,150,0,64,175,64,208,128,154,0,
128,151,0,64,155,64,208,128,152,0,201,161,10,99,0,64,208,128,154,0,73,159,
13,57,64,208,136,156,4,0,128,154,0,200,158,21,0,64,208,73,160,9,12,64,208,
128,145,0,128,156,0,128,165,0,64,157,64,208,72,162,16,64,208,64,163,64,
208,64,157,64,208,128,147,0,128,161,0,192,160,0,64,208,73,157,9,24,64,208,
128,161,0,72,156,8,64,208,128,144,0,64,144,64,208,128,157,0,128,163,0,137,
166,5,54,0,72,165,24,64,208,137,156,5,16,0,136,155,4,0,64,144,64,208,128,
157,0,128,173,0,64,162,64,208,136,162,4,0,192,159,0,64,208,200,173,9,0,
64,208,128,161,0,128,161,0,64,173,64,208,137,156,5,25,0,200,152,17,0,64,
208,64,159,64,208,64,158,64,208,128,151,0,128,145,0,64,159,64,208,64,158,
64,208,128,151,0,64,163,64,208,201,159,19,119,0,64,208,136,163,4,0,192,
159,0,64,208,128,154,0,73,152,25,65,64,208,137,159,5,12,0,136,152,4,0,128,
145,0,136,173,4,0,128,162,0,73,146,13,33,64,208,136,161,4,0,128,160,0,192,
145,0,64,208,137,159,5,12,0,64,152,64,208,128,159,0,128,162,0,64,147,64,
208,128,152,0,73,156,17,20,64,208,137,159,5,8,0,128,154,0,128,166,0,128,
154,0,64,158,64,208,136,162,4,0,64,160,64,208,128,160,0,137,163,5,24,0,
137,161,5,12,0,64,160,64,208,128,151,0,64,162,64,208,128,163,0,200,173,
18,0,64,208,200,159,9,0,64,208,128,152,0,128,145,0,192,164,0,64,208,64,
152,64,208,128,161,0,82,173,1,143,2,165,64,208,73,157,9,182,64,208,128,
162,0,137,151,5,69,0,201,147,10,53,0,64,208,128,148,0,72,146,36,64,208,
73,161,17,28,64,208,64,152,64,208,64,148,64,208,128,146,0,72,159,8,64,208,
128,161,0,128,145,0,128,166,0,64,144,64,208,128,163,0,64,150,64,208,64,
154,64,208,128,165,0,73,155,9,77,64,208,128,160,0,192,152,0,64,208,73,158,
17,44,64,208,136,162,4,0,64,159,64,208,128,159,0,137,154,5,16,0,136,145,
4,0,64,144,64,208,128,163,0,72,157,8,64,208,128,162,0,128,156,0,137,163,
5,16,0,136,161,4,0,64,159,64,208,128,154,0,128,164,0,64,156,64,208,73,161,
9,16,64,208,128,161,0,136,159,4,0,128,151,0,64,173,64,208,128,150,0,201,
162,22,152,0,64,208,137,159,5,12,0,64,157,64,208,128,163,0,128,160,0,73,
160,25,103,64,208,137,159,5,16,0,72,152,8,64,208,128,150,0,128,150,0,128,
162,0,200,159,67,0,64,208,201,159,10,50,0,64,208,128,159,0,201,152,22,29,
0,64,208,72,163,8,64,208,128,160,0,64,149,64,208,128,161,0,64,149,64,208,
128,161,0,64,157,64,208,64,162,64,208,128,159,0,136,166,4,0,64,163,64,208,
128,160,0,64,158,64,208,64,159,64,208,128,159,0,64,161,64,208,137,157,5,
16,0,137,152,5,8,0,128,145,0,128,154,0,136,163,4,0,128,158,0,201,164,22,
54,0,64,208,73,152,9,12,64,208,128,145,0,128,145,0,128,159,0,192,163,0,
64,208,73,161,9,20,64,208,128,159,0,136,159,4,0,64,152,64,208,128,159,0,
64,162,64,208,128,161,0,128,167,0,73,167,67,255,64,208,73,161,9,28,64,208,
128,165,0,137,159,5,16,0,72,146,8,64,208,128,159,0,128,145,0,128,160,0,
201,164,10,30,0,64,208,128,148,0,64,163,64,208,192,159,0,64,208,72,162,
8,64,208,128,159,0,128,159,0,128,165,0,192,166,0,64,208,73,156,17,94,64,
208,136,161,4,0,64,152,64,208,128,151,0,201,148,10,34,0,64,208,128,161,
0,137,145,5,16,0,64,144,64,208,64,162,64,208,128,162,0,192,147,0,64,208,
128,152,0,73,152,13,28,64,208,136,154,4,0,128,147,0,64,151,64,208,136,161,
4,0,64,152,64,208,128,157,0,64,154,64,208,137,157,5,8,0,128,154,0,128,162,
0,73,164,9,62,64,208,128,148,0,201,159,34,42,0,64,208,137,163,5,16,0,72,
159,8,64,208,128,159,0,128,154,0,72,175,8,64,208,128,164,0,128,167,0,192,
157,0,64,208,128,162,0,64,160,64,208,64,161,64,208,128,158,0,137,168,5,
12,0,64,167,64,208,128,159,0,64,173,64,208,137,160,5,8,0,128,158,0,128,
163,0,64,168,64,208,73,159,9,16,64,208,128,159,0,64,145,64,208,128,144,
0,128,160,0,72,175,94,64,208,137,163,5,45,0,73,155,13,24,64,208,64,156,
64,208,128,154,0,136,152,4,0,64,147,64,208,128,157,0,72,162,8,64,208,128,
162,0,192,160,0,64,208,128,164,0,137,168,5,16,0,72,165,8,64,208,128,162,
0,128,164,0,192,173,0,64,208,137,161,5,16,0,64,152,64,208,64,162,64,208,
128,164,0,64,162,64,208,128,164,0,64,174,64,208,136,156,4,0,128,152,0,64,
151,64,208,74,158,235,7,203,64,208,73,159,13,113,64,208,136,159,4,0,128,
148,0,73,154,29,69,64,208,73,152,9,20,64,208,128,158,0,72,148,8,64,208,
128,145,0,128,145,0,128,161,0,137,150,5,28,0,72,148,12,64,208,64,164,64,
208,128,155,0,64,146,64,208,136,148,4,0,128,145,0,192,151,0,64,208,64,159,
64,208,128,159,0,73,156,13,20,64,208,136,159,4,0,128,151,0,64,155,64,208,
128,148,0,64,158,64,208,64,152,64,208,128,148,0,201,164,10,88,0,64,208,
128,160,0,73,162,18,54,64,208,200,161,9,0,64,208,128,161,0,128,152,0,200,
161,13,0,64,208,64,159,64,208,128,154,0,64,160,64,208,73,152,9,12,64,208,
128,151,0,128,148,0,64,161,64,208,128,144,0,64,163,64,208,200,158,13,0,
64,208,64,148,64,208,128,158,0,64,154,64,208,128,158,0,73,166,9,16,64,208,
128,156,0,64,165,64,208,128,159,0,64,173,64,208,64,152,64,208,128,147,0,
74,150,54,4,8,64,208,137,155,5,36,0,137,152,5,28,0,64,145,64,208,136,154,
4,0,64,152,64,208,136,154,4,0,64,152,64,208,128,154,0,128,154,0,72,160,
8,64,208,128,154,0,128,156,0,74,146,105,2,180,64,208,73,158,29,61,64,208,
73,160,13,20,64,208,64,144,64,208,128,158,0,64,146,64,208,128,161,0,128,
161,0,137,152,5,20,0,72,150,8,64,208,128,148,0,64,146,64,208,128,161,0,
192,154,0,64,208,136,161,4,0,128,158,0,73,163,13,30,64,208,136,162,4,0,
128,160,0,200,160,9,0,64,208,128,159,0,192,159,0,64,208,128,168,0,64,168,
64,208,128,158,0,82,144,1,218,2,3,64,208,74,156,26,1,1,64,208,137,162,5,
16,0,64,157,64,208,64,158,64,208,128,153,0,128,166,0,73,149,9,152,64,208,
128,161,0,73,146,17,92,64,208,64,154,64,208,64,158,64,208,128,156,0,64,
145,64,208,73,150,9,48,64,208,128,148,0,72,147,32,64,208,73,158,9,20,64,
208,128,154,0,64,147,64,208,64,159,64,208,128,163,0,64,159,64,208,128,163,
0,64,146,64,208,128,158,0,72,157,12,64,208,64,152,64,208,128,152,0,64,152,
64,208,64,150,64,208,128,162,0,64,147,64,208,137,161,5,40,0,64,160,64,208,
64,144,64,208,64,148,64,208,64,158,64,208,64,162,64,208,64,160,64,208,64,
175,64,208,64,148,64,208,128,171,0,64,173,64,208,128,161,0,73,152,13,20,
64,208,64,145,64,208,128,152,0,64,151,64,208,128,161,0,64,154,64,208,73,
148,9,24,64,208,128,163,0,72,147,8,64,208,128,163,0,64,146,64,208,128,158,
0,64,161,64,208,64,158,64,208,64,145,64,208,64,160,64,208,64,144,64,208,
64,157,64,208,64,152,64,208,128,175,0,73,161,30,182,64,208,64,160,64,208,
64,144,64,208,192,154,0,64,208,64,163,64,208,64,155,64,208,128,172,0,73,
159,125,133,64,208,72,167,40,64,208,72,149,8,64,208,128,155,0,64,144,64,
208,64,161,64,208,64,162,64,208,136,172,4,0,64,152,64,208,64,157,64,208,
128,152,0,64,161,64,208,137,158,5,72,0,64,152,64,208,64,145,64,208,72,157,
32,64,208,64,152,64,208,72,152,12,64,208,64,147,64,208,128,147,0,64,147,
64,208,64,157,64,208,128,152,0,64,154,64,208,64,158,64,208,64,156,64,208,
64,145,64,208,64,144,64,208,64,157,64,208,128,154,0,128,159,0,192,158,0,
64,208,128,160,0,64,160,64,208,64,163,64,208,64,155,64,208,64,129,64,208,
128,156,0,73,166,9,12,64,208,128,161,0,128,162,0,64,173,64,208,136,161,
4,0,64,146,64,208,128,161,0,64,134,64,208,201,151,14,29,0,64,208,64,158,
64,208,128,148,0,72,149,12,64,208,64,134,64,208,128,162,0,128,146,0,192,
154,0,64,208,128,159,0,64,145,64,208,137,162,5,45,0,137,157,5,29,0,200,
156,17,0,64,208,137,154,5,8,0,128,144,0,128,158,0,64,155,64,208,128,158,
0,72,161,8,64,208,128,154,0,128,160,0,137,167,5,16,0,72,166,8,64,208,128,
154,0,128,165,0,64,168,64,208,128,156,0,73,148,85,175,64,208,73,158,9,48,
64,208,128,152,0,73,148,13,28,64,208,64,164,64,208,128,155,0,72,146,8,64,
208,128,160,0,64,134,64,208,128,144,0,64,156,64,208,136,163,4,0,128,159,
0,137,162,5,24,0,72,161,12,64,208,136,162,4,0,128,161,0,64,159,64,208,128,
155,0,64,164,64,208,128,160,0,64,147,64,208,201,159,22,58,0,64,208,137,
159,5,12,0,136,157,4,0,128,152,0,128,163,0,137,151,5,20,0,72,148,12,64,
208,64,156,64,208,128,145,0,128,146,0,200,156,9,0,64,208,128,163,0,64,152,
64,208,128,144,0,137,163,5,17,0,200,162,9,0,64,208,128,163,0,128,161,0,
136,168,4,0,64,166,64,208,128,162,0,64,149,64,208,73,157,21,96,64,208,136,
168,4,0,64,144,64,208,136,159,4,0,128,148,0,72,156,44,64,208,72,161,24,
64,208,64,157,64,208,64,144,64,208,64,160,64,208,64,175,64,208,128,148,
0,64,145,64,208,64,144,64,208,64,157,64,208,128,154,0,64,155,64,208,73,
158,13,20,64,208,64,163,64,208,128,158,0,64,144,64,208,128,158,0,64,162,
64,208,128,144,0,72,164,8,64,208,128,161,0,128,161,0,74,155,38,1,214,64,
208,137,159,5,20,0,72,154,8,64,208,128,151,0,64,152,64,208,128,157,0,72,
162,8,64,208,128,145,0,128,161,0,74,152,175,1,12,64,208,201,161,10,109,
0,64,208,128,158,0,73,152,9,56,64,208,128,152,0,73,147,33,40,64,208,64,
156,64,208,136,163,4,0,64,144,64,208,64,168,64,208,64,152,64,208,64,157,
64,208,128,144,0,64,146,64,208,128,164,0,64,150,64,208,128,162,0,73,158,
13,16,64,208,64,158,64,208,128,159,0,128,155,0,64,159,64,208,73,158,13,
20,64,208,64,159,64,208,128,158,0,64,152,64,208,128,164,0,128,161,0,137,
166,5,28,0,73,163,9,16,64,208,128,159,0,64,162,64,208,128,166,0,64,164,
64,208,128,162,0,72,173,28,64,208,137,157,5,20,0,64,152,64,208,136,162,
4,0,64,152,64,208,128,162,0,128,164,0,128,168,0,64,151,64,208,201,158,14,
58,0,64,208,64,156,64,208,128,162,0,73,147,9,28,64,208,128,162,0,72,146,
12,64,208,136,158,4,0,128,144,0,64,145,64,208,128,157,0,200,156,9,0,64,
208,128,154,0,64,154,64,208,128,152,0,137,163,5,20,0,136,160,4,0,64,159,
64,208,136,163,4,0,128,159,0,72,166,8,64,208,128,161,0,128,164,0,64,154,
64,208,73,158,17,113,64,208,64,160,64,208,64,147,64,208,128,158,0,201,148,
10,57,0,64,208,128,161,0,73,146,17,28,64,208,137,160,5,8,0,128,154,0,128,
161,0,64,144,64,208,64,162,64,208,128,163,0,64,147,64,208,136,163,4,0,64,
157,64,208,64,147,64,208,128,163,0,73,155,9,28,64,208,128,151,0,64,152,
64,208,72,162,8,64,208,128,163,0,64,146,64,208,128,161,0,64,156,64,208,
136,159,4,0,128,154,0,137,163,5,28,0,137,161,5,16,0,64,159,64,208,136,148,
4,0,128,147,0,64,162,64,208,128,163,0,72,173,12,64,208,136,161,4,0,128,
156,0,64,166,64,208,128,144,0,72,157,143,64,208,137,159,5,93,0,73,154,13,
56,64,208,64,152,64,208,128,164,0,72,152,28,64,208,73,161,9,20,64,208,128,
158,0,64,152,64,208,64,173,64,208,128,159,0,128,162,0,64,146,64,208,64,
159,64,208,64,152,64,208,128,164,0,200,158,17,0,64,208,136,159,4,0,64,156,
64,208,128,159,0,64,156,64,208,136,161,4,0,64,159,64,208,128,154,0,201,
162,10,21,0,64,208,128,163,0,136,161,4,0,64,160,64,208,128,161,0,136,168,
4,0,192,163,0,64,208,72,162,12,64,208,64,173,64,208,128,154,0,128,152,0,
64,156,64,208,201,154,10,59,0,64,208,128,145,0,73,147,9,29,64,208,128,144,
0,137,144,5,13,0,192,134,0,64,208,128,159,0,64,146,64,208,128,154,0,201,
150,10,17,0,64,208,128,146,0,64,148,64,208,128,162,0,128,151,0,201,161,
14,37,0,64,208,64,156,64,208,128,154,0,73,157,9,16,64,208,128,161,0,64,
156,64,208,128,154,0,64,159,64,208,128,163,0,73,165,9,12,64,208,128,151,
0,128,163,0,128,168,0,74,166,58,4,189,64,208,73,160,13,40,64,208,64,165,
64,208,128,148,0,137,156,5,20,0,72,155,8,64,208,128,159,0,64,154,64,208,
128,161,0,64,158,64,208,128,157,0,137,162,5,8,0,128,161,0,128,163,0,74,
162,112,3,99,64,208,73,156,13,45,64,208,136,155,4,0,128,154,0,137,151,5,
25,0,201,146,10,17,0,64,208,128,158,0,64,145,64,208,128,148,0,128,147,0,
136,155,4,0,128,154,0,73,161,9,41,64,208,128,162,0,201,159,14,25,0,64,208,
136,159,4,0,128,152,0,64,157,64,208,136,161,4,0,128,159,0,64,160,64,208,
128,145,0,72,173,12,64,208,136,162,4,0,128,160,0,64,162,64,208,128,154,
0,74,160,174,1,131,64,208,73,157,13,92,64,208,64,146,64,208,128,162,0,73,
152,17,60,64,208,64,156,64,208,64,156,64,208,128,158,0,201,146,15,31,0,
64,208,192,162,0,64,208,128,152,0,72,145,8,64,208,128,160,0,192,144,0,64,
208,128,154,0,64,147,64,208,192,158,0,64,208,128,158,0,137,155,5,8,0,128,
154,0,64,156,64,208,136,158,4,0,128,151,0,73,162,13,44,64,208,136,161,4,
0,128,158,0,137,160,5,28,0,72,159,12,64,208,136,163,4,0,128,154,0,64,158,
64,208,64,154,64,208,128,154,0,128,161,0,73,166,17,20,64,208,64,157,64,
208,64,159,64,208,128,158,0,128,163,0,64,173,64,208,64,159,64,208,128,161,
0,192,159,0,64,208,201,160,18,145,0,64,208,137,156,5,8,0,128,154,0,128,
160,0,73,154,26,95,64,208,73,152,9,12,64,208,128,158,0,128,145,0,192,162,
0,64,208,128,145,0,201,151,10,33,0,64,208,128,148,0,72,150,12,64,208,64,
160,64,208,128,158,0,64,145,64,208,136,162,4,0,128,158,0,64,152,64,208,
200,164,29,0,64,208,73,161,9,20,64,208,128,152,0,136,157,4,0,64,146,64,
208,128,152,0,128,171,0,128,162,0,73,158,13,24,64,208,136,163,4,0,128,157,
0,64,156,64,208,136,160,4,0,128,154,0,192,159,0,64,208,128,159,0,73,164,
9,36,64,208,128,157,0,73,162,9,24,64,208,128,157,0,64,161,64,208,136,168,
4,0,64,159,64,208,128,163,0,128,163,0,73,173,9,16,64,208,128,161,0,64,167,
64,208,128,161,0,64,175,64,208,64,158,64,208,128,161,0,64,161,64,208,201,
158,42,191,0,64,208,137,158,5,24,0,136,156,4,0,64,152,64,208,64,160,64,
208,64,147,64,208,128,158,0,64,160,64,208,64,147,64,208,128,158,0,73,151,
13,67,64,208,64,156,64,208,128,154,0,201,147,18,38,0,64,208,137,158,5,8,
0,128,152,0,128,163,0,200,146,9,0,64,208,128,160,0,64,144,64,208,136,158,
4,0,128,154,0,200,150,13,0,64,208,136,148,4,0,128,145,0,128,148,0,201,155,
10,46,0,64,208,128,150,0,72,154,24,64,208,137,154,5,16,0,72,152,8,64,208,
128,148,0,128,145,0,128,158,0,64,152,64,208,192,164,0,64,208,128,159,0,
72,157,16,64,208,136,158,4,0,64,147,64,208,128,154,0,64,156,64,208,201,
152,10,13,0,64,208,128,154,0,128,144,0,128,154,0,73,164,13,142,64,208,64,
161,64,208,128,160,0,73,161,33,81,64,208,73,160,9,16,64,208,128,151,0,136,
158,4,0,128,156,0,72,163,8,64,208,128,162,0,128,161,0,72,160,20,64,208,
137,159,5,8,0,128,158,0,64,162,64,208,128,155,0,64,159,64,208,137,156,5,
17,0,200,154,9,0,64,208,128,152,0,128,148,0,136,166,4,0,128,163,0,72,163,
16,64,208,136,158,4,0,64,147,64,208,128,144,0,192,162,0,64,208,137,159,
5,16,0,137,156,5,8,0,128,144,0,128,158,0,136,163,4,0,64,161,64,208,128,
154,0,137,173,5,24,0,72,168,12,64,208,64,156,64,208,128,155,0,64,167,64,
208,128,158,0,64,175,64,208,128,158,0,74,164,78,1,13,64,208,137,159,5,36,
0,137,152,5,20,0,73,148,9,12,64,208,128,160,0,128,146,0,128,151,0,136,158,
4,0,64,156,64,208,128,168,0,73,162,9,24,64,208,128,168,0,136,161,4,0,64,
160,64,208,64,145,64,208,128,152,0,72,173,8,64,208,128,154,0,128,168,0,
64,163,64,208,201,159,22,130,0,64,208,137,146,5,12,0,64,145,64,208,128,
145,0,128,148,0,73,152,17,48,64,208,72,173,8,64,208,128,159,0,128,154,0,
73,146,17,24,64,208,136,154,4,0,64,148,64,208,128,162,0,64,145,64,208,128,
160,0,64,149,64,208,128,161,0,73,156,17,48,64,208,137,158,5,8,0,128,154,
0,128,166,0,64,154,64,208,137,156,5,16,0,72,154,8,64,208,128,161,0,128,
151,0,136,166,4,0,64,162,64,208,128,161,0,192,157,0,64,208,136,160,4,0,
128,154,0,73,165,9,37,64,208,128,158,0,137,161,5,13,0,192,160,0,64,208,
128,158,0,64,163,64,208,136,163,4,0,64,157,64,208,128,166,0,72,173,8,64,
208,128,161,0,192,166,0,64,208,64,173,64,208,128,152,0,64,165,64,208,137,
154,5,8,0,128,151,0,64,162,64,208,128,158,0,73,173,95,175,64,208,73,159,
9,49,64,208,128,154,0,73,152,13,20,64,208,136,159,4,0,128,156,0,136,151,
4,0,128,145,0,200,156,13,0,64,208,136,152,4,0,128,151,0,64,155,64,208,128,
162,0,137,163,5,37,0,72,162,20,64,208,137,158,5,12,0,136,154,4,0,128,144,
0,128,160,0,192,160,0,64,208,64,154,64,208,128,162,0,128,168,0,73,168,29,
73,64,208,73,159,9,16,64,208,128,148,0,136,154,4,0,128,146,0,64,161,64,
208,128,158,0,64,167,64,208,137,154,5,25,0,73,146,9,17,64,208,128,158,0,
192,144,0,64,208,128,148,0,128,151,0,137,161,5,12,0,64,156,64,208,128,162,
0,128,175,0,64,169,64,208,128,144,0,200,175,17,0,64,208,72,162,8,64,208,
128,166,0,128,145,0,64,174,64,208,201,152,18,21,0,64,208,136,161,4,0,64,
156,64,208,128,163,0,128,134,0,64,155,64,208,64,157,64,208,128,166,0,64,
153,64,208,73,158,29,44,64,208,73,161,9,16,64,208,128,162,0,64,153,64,208,
128,158,0,64,162,64,208,128,154,0,72,148,8,64,208,128,151,0,64,144,64,208,
128,160,0,64,161,64,208,128,159,0,82,156,70,175,89,254,80,208,70,162,210,
158,9,30,51,58,0,64,208,74,157,78,3,55,64,208,73,160,9,56,64,208,128,162,
0,73,152,33,44,64,208,72,154,8,64,208,128,152,0,64,152,64,208,72,159,8,
64,208,128,162,0,64,144,64,208,128,147,0,64,144,64,208,64,156,64,208,128,
152,0,128,159,0,136,164,4,0,64,162,64,208,64,158,64,208,128,161,0,74,150,
10,1,74,64,208,128,148,0,74,147,101,1,1,64,208,73,152,13,44,64,208,64,164,
64,208,128,154,0,73,146,9,24,64,208,128,146,0,136,145,4,0,64,144,64,208,
64,148,64,208,128,154,0,64,148,64,208,128,145,0,137,158,5,29,0,72,157,8,
64,208,128,145,0,192,154,0,64,208,64,163,64,208,64,173,64,208,128,159,0,
192,162,0,64,208,72,174,8,64,208,128,151,0,192,158,0,64,208,128,160,0,73,
145,77,113,64,208,73,152,13,52,64,208,64,145,64,208,128,144,0,73,147,13,
36,64,208,64,160,64,208,128,159,0,64,146,64,208,137,163,5,12,0,136,158,
4,0,128,155,0,64,165,64,208,128,158,0,128,148,0,73,162,9,16,64,208,128,
152,0,64,158,64,208,128,159,0,128,164,0,64,144,64,208,137,154,5,16,0,72,
152,8,64,208,128,161,0,128,151,0,72,161,8,64,208,128,163,0,192,159,0,64,
208,128,154,0,64,146,64,208,137,160,5,24,0,137,146,5,16,0,64,144,64,208,
64,147,64,208,128,158,0,128,158,0,72,163,12,64,208,64,154,64,208,128,152,
0,128,161,0,72,149,8,64,208,128,161,0,64,148,64,208,73,159,21,40,64,208,
72,157,8,64,208,128,145,0,64,152,64,208,128,154,0,72,158,12,64,208,64,165,
64,208,128,145,0,64,154,64,208,128,145,0,136,166,4,0,64,165,64,208,128,
145,0,202,154,99,1,30,0,64,208,73,157,9,59,64,208,128,156,0,73,146,9,21,
64,208,128,148,0,136,145,4,0,192,144,0,64,208,128,158,0,200,152,17,0,64,
208,64,162,64,208,64,173,64,208,128,163,0,64,148,64,208,192,166,0,64,208,
128,148,0,73,165,9,24,64,208,128,147,0,136,164,4,0,64,161,64,208,64,159,
64,208,128,157,0,192,166,0,64,208,128,145,0,73,152,100,164,64,208,201,159,
26,58,0,64,208,72,154,12,64,208,64,160,64,208,128,158,0,64,152,64,208,128,
154,0,73,148,13,25,64,208,136,160,4,0,128,155,0,192,144,0,64,208,64,152,
64,208,128,161,0,64,154,64,208,128,144,0,73,162,9,16,64,208,128,154,0,64,
161,64,208,128,154,0,192,163,0,64,208,137,159,5,12,0,64,152,64,208,128,
159,0,128,163,0,64,151,64,208,201,159,30,45,0,64,208,72,159,12,64,208,64,
156,64,208,128,161,0,64,147,64,208,64,159,64,208,128,152,0,137,150,5,12,
0,64,145,64,208,128,162,0,128,156,0,72,173,8,64,208,128,162,0,64,162,64,
208,128,151,0,64,153,64,208,64,148,64,208,64,158,64,208,64,148,64,208,64,
171,64,208,128,160,0,200,156,46,0,64,208,73,158,9,20,64,208,128,145,0,137,
148,5,8,0,128,146,0,128,154,0,200,160,13,0,64,208,64,162,64,208,128,168,
0,64,159,64,208,128,154,0,64,155,64,208,73,156,9,56,64,208,128,152,0,73,
151,29,40,64,208,64,144,64,208,64,146,64,208,64,158,64,208,64,148,64,208,
64,158,64,208,128,146,0,64,147,64,208,64,156,64,208,128,152,0,64,154,64,
208,128,144,0,73,164,13,20,64,208,64,148,64,208,128,154,0,64,160,64,208,
128,160,0,128,165,0,74,164,83,5,106,64,208,73,154,9,49,64,208,128,154,0,
73,148,9,25,64,208,128,151,0,200,146,9,0,64,208,128,159,0,64,145,64,208,
128,161,0,136,152,4,0,64,149,64,208,64,159,64,208,128,157,0,73,163,9,24,
64,208,128,150,0,136,162,4,0,64,158,64,208,64,156,64,208,128,161,0,128,
165,0,82,161,2,173,4,84,64,208,74,158,50,1,252,64,208,72,156,8,64,208,128,
154,0,64,145,64,208,64,155,64,208,72,161,12,64,208,64,163,64,208,128,148,
0,64,145,64,208,64,144,64,208,64,157,64,208,128,154,0,202,152,15,1,28,0,
64,208,64,146,64,208,128,152,0,82,147,1,3,1,10,64,208,73,158,245,248,64,
208,72,161,44,64,208,64,173,64,208,64,154,64,208,64,161,64,208,64,159,64,
208,64,149,64,208,64,160,64,208,64,162,64,208,64,152,64,208,64,151,64,208,
128,144,0,64,160,64,208,73,152,61,124,64,208,72,161,28,64,208,64,159,64,
208,64,158,64,208,64,155,64,208,64,154,64,208,64,158,64,208,128,156,0,64,
151,64,208,64,145,64,208,64,152,64,208,64,160,64,208,64,154,64,208,64,158,
64,208,128,156,0,73,148,17,48,64,208,64,163,64,208,64,156,64,208,128,171,
0,72,145,12,64,208,64,162,64,208,128,152,0,64,144,64,208,64,160,64,208,
64,165,64,208,64,152,64,208,128,146,0,64,149,64,208,64,152,64,208,64,144,
64,208,128,166,0,73,158,13,40,64,208,64,157,64,208,128,158,0,64,154,64,
208,64,158,64,208,64,156,64,208,64,161,64,208,64,162,64,208,64,144,64,208,
128,162,0,64,161,64,208,72,174,16,64,208,64,162,64,208,64,163,64,208,128,
160,0,64,163,64,208,128,148,0,128,152,0,128,163,0,136,146,4,0,128,144,0,
128,151,0,201,156,47,138,0,64,208,136,158,4,0,64,149,64,208,64,162,64,208,
64,160,64,208,192,158,0,64,208,64,161,64,208,64,162,64,208,64,160,64,208,
64,158,64,208,128,153,0,64,154,64,208,73,158,25,56,64,208,64,156,64,208,
64,145,64,208,64,144,64,208,64,157,64,208,128,154,0,72,152,20,64,208,64,
157,64,208,136,158,4,0,64,144,64,208,128,159,0,64,144,64,208,64,160,64,
208,128,151,0,64,163,64,208,64,155,64,208,64,172,64,208,64,162,64,208,64,
159,64,208,64,160,64,208,64,158,64,208,128,147,0,192,157,0,64,208,72,159,
8,64,208,128,158,0,64,144,64,208,64,160,64,208,64,145,64,208,64,144,64,
208,64,157,64,208,128,154,0,137,164,5,117,0,73,161,46,100,64,208,192,158,
0,64,208,64,166,64,208,64,147,64,208,64,144,64,208,64,160,64,208,64,144,
64,208,64,157,64,208,64,162,64,208,64,152,64,208,128,175,0,192,159,0,64,
208,201,158,26,42,0,64,208,64,167,64,208,64,162,64,208,64,144,64,208,64,
156,64,208,128,162,0,136,154,4,0,192,152,0,64,208,64,146,64,208,128,158,
0,136,161,4,0,128,159,0,192,163,0,64,208,64,164,64,208,128,154,0,73,167,
9,44,64,208,128,161,0,64,166,64,208,72,162,20,64,208,64,152,64,208,64,161,
64,208,64,152,64,208,128,151,0,64,147,64,208,64,156,64,208,128,161,0,192,
173,0,64,208,128,159,0,202,159,88,1,79,0,64,208,73,158,17,40,64,208,72,
161,8,64,208,128,161,0,128,147,0,137,152,5,16,0,136,145,4,0,64,144,64,208,
128,151,0,136,157,4,0,128,154,0,137,166,5,29,0,136,163,4,0,192,160,0,64,
208,72,175,8,64,208,128,155,0,64,158,64,208,128,159,0,72,173,8,64,208,128,
154,0,128,167,0,64,158,64,208,73,157,81,158,64,208,73,157,9,40,64,208,128,
147,0,73,148,13,28,64,208,64,160,64,208,128,154,0,72,146,8,64,208,128,161,
0,64,145,64,208,128,147,0,128,154,0,73,161,13,28,64,208,136,155,4,0,128,
147,0,64,159,64,208,136,160,4,0,64,146,64,208,128,162,0,64,173,64,208,128,
173,0,73,150,9,45,64,208,128,161,0,201,148,26,29,0,64,208,137,156,5,12,
0,64,152,64,208,128,156,0,64,163,64,208,128,144,0,128,144,0,64,149,64,208,
128,154,0,73,154,9,25,64,208,128,158,0,192,152,0,64,208,136,160,4,0,64,
157,64,208,128,145,0,64,156,64,208,128,159,0,201,161,18,66,0,64,208,136,
158,4,0,64,144,64,208,128,158,0,73,159,9,29,64,208,128,158,0,64,158,64,
208,72,164,8,64,208,128,152,0,192,159,0,64,208,128,152,0,64,160,64,208,
72,162,8,64,208,128,152,0,64,159,64,208,128,165,0,73,163,9,16,64,208,128,
157,0,64,162,64,208,128,147,0,128,164,0,64,160,64,208,73,158,9,60,64,208,
128,158,0,73,146,25,36,64,208,64,158,64,208,64,154,64,208,64,151,64,208,
64,144,64,208,128,155,0,64,145,64,208,64,158,64,208,128,162,0,64,149,64,
208,64,154,64,208,64,152,64,208,128,162,0,72,163,8,64,208,128,166,0,192,
159,0,64,208,64,158,64,208,64,160,64,208,128,162,0,200,163,79,0,64,208,
201,158,10,34,0,64,208,128,160,0,137,151,5,17,0,64,148,64,208,192,158,0,
64,208,128,148,0,64,154,64,208,128,154,0,73,161,29,32,64,208,72,161,8,64,
208,128,168,0,64,158,64,208,136,168,4,0,64,158,64,208,128,168,0,128,159,
0,64,162,64,208,128,157,0,192,162,0,64,208,73,163,17,96,64,208,64,158,64,
208,64,158,64,208,128,161,0,72,158,76,64,208,137,161,5,52,0,72,160,28,64,
208,64,162,64,208,64,149,64,208,64,161,64,208,64,162,64,208,64,149,64,208,
128,160,0,64,155,64,208,64,158,64,208,64,148,64,208,64,154,64,208,128,144,
0,64,162,64,208,64,160,64,208,64,152,64,208,64,144,64,208,128,155,0,128,
156,0,72,174,8,64,208,128,151,0,64,173,64,208,128,159,0,73,173,37,93,64,
208,137,154,5,12,0,136,151,4,0,128,147,0,72,162,12,64,208,64,151,64,208,
128,154,0,64,161,64,208,128,154,0,72,166,49,64,208,73,152,9,25,64,208,128,
159,0,72,146,8,64,208,128,161,0,192,144,0,64,208,128,158,0,72,165,8,64,
208,128,160,0,64,157,64,208,64,152,64,208,128,162,0,64,165,64,208,128,156,
0,72,175,12,64,208,64,158,64,208,128,160,0,64,174,64,208,136,155,4,0,128,
152,0,74,150,110,23,191,64,208,73,154,21,52,64,208,137,159,5,12,0,136,158,
4,0,128,147,0,128,165,0,137,148,5,20,0,73,145,9,12,64,208,128,154,0,128,
144,0,128,147,0,72,152,8,64,208,128,147,0,128,151,0,73,162,9,36,64,208,
128,159,0,137,159,5,16,0,64,156,64,208,136,159,4,0,128,151,0,64,161,64,
208,136,166,4,0,128,154,0,72,173,8,64,208,128,159,0,64,166,64,208,128,162,
0,82,146,2,7,10,7,64,208,202,157,15,1,25,0,64,208,136,154,4,0,128,148,0,
201,150,10,120,0,64,208,128,154,0,73,147,21,90,64,208,72,161,8,64,208,128,
158,0,64,154,64,208,128,154,0,201,145,10,33,0,64,208,128,168,0,64,144,64,
208,73,162,9,16,64,208,128,162,0,136,154,4,0,128,144,0,128,163,0,64,146,
64,208,73,159,13,29,64,208,64,158,64,208,128,163,0,200,154,9,0,64,208,128,
163,0,64,152,64,208,128,163,0,128,160,0,72,149,8,64,208,128,163,0,192,148,
0,64,208,136,166,4,0,128,146,0,201,154,54,131,0,64,208,137,151,5,24,0,137,
146,5,8,0,128,144,0,64,147,64,208,64,152,64,208,128,148,0,137,158,5,8,0,
128,154,0,64,163,64,208,64,148,64,208,64,152,64,208,128,146,0,200,152,69,
0,64,208,73,157,9,44,64,208,128,154,0,73,151,13,28,64,208,64,160,64,208,
128,163,0,72,148,12,64,208,64,149,64,208,128,158,0,128,144,0,64,156,64,
208,128,163,0,137,162,5,16,0,64,160,64,208,64,162,64,208,128,163,0,128,
164,0,192,151,0,64,208,128,152,0,72,156,12,64,208,136,163,4,0,128,161,0,
128,155,0,201,163,14,115,0,64,208,136,163,4,0,128,162,0,73,160,21,58,64,
208,137,155,5,12,0,136,154,4,0,128,147,0,128,163,0,72,159,21,64,208,137,
160,5,13,0,192,154,0,64,208,128,163,0,128,161,0,192,158,0,64,208,136,161,
4,0,64,154,64,208,128,163,0,72,162,20,64,208,137,163,5,8,0,128,159,0,64,
173,64,208,128,161,0,64,161,64,208,137,159,5,12,0,136,158,4,0,128,154,0,
64,162,64,208,128,159,0,137,166,5,34,0,72,165,12,64,208,64,159,64,208,128,
163,0,192,164,0,64,208,136,161,4,0,192,154,0,64,208,128,158,0,72,173,34,
64,208,137,160,5,8,0,128,154,0,192,161,0,64,208,200,162,9,0,64,208,128,
159,0,64,152,64,208,128,162,0,64,168,64,208,73,161,17,36,64,208,72,173,
8,64,208,128,157,0,128,157,0,73,152,13,16,64,208,64,145,64,208,128,144,
0,128,145,0,128,156,0,136,173,4,0,128,163,0,82,144,6,44,6,199,64,208,74,
158,39,3,31,64,208,73,157,9,21,64,208,128,157,0,136,154,4,0,192,146,0,64,
208,128,161,0,72,159,8,64,208,128,158,0,128,158,0,74,150,22,1,89,64,208,
137,154,5,12,0,64,149,64,208,128,164,0,128,159,0,74,147,87,1,11,64,208,
73,156,9,60,64,208,128,163,0,73,154,9,40,64,208,128,158,0,72,152,16,64,
208,64,159,64,208,64,144,64,208,128,173,0,64,144,64,208,64,162,64,208,136,
173,4,0,128,149,0,64,155,64,208,64,149,64,208,128,146,0,137,162,5,17,0,
200,160,9,0,64,208,128,156,0,128,159,0,128,173,0,201,145,80,141,0,64,208,
137,159,5,54,0,201,152,22,41,0,64,208,137,154,5,12,0,64,145,64,208,128,
148,0,128,163,0,72,145,8,64,208,128,148,0,64,134,64,208,136,162,4,0,128,
157,0,192,157,0,64,208,128,157,0,137,162,5,12,0,136,161,4,0,128,160,0,64,
173,64,208,128,161,0,64,144,64,208,137,158,5,37,0,137,149,5,20,0,72,148,
8,64,208,128,158,0,64,144,64,208,128,154,0,192,157,0,64,208,64,158,64,208,
128,152,0,73,164,9,17,64,208,128,160,0,192,159,0,64,208,128,152,0,128,168,
0,64,146,64,208,73,165,13,32,64,208,64,157,64,208,128,151,0,136,162,4,0,
64,152,64,208,64,144,64,208,136,162,4,0,128,155,0,128,173,0,72,149,8,64,
208,128,157,0,64,148,64,208,201,158,10,29,0,64,208,128,163,0,73,149,13,
16,64,208,64,157,64,208,128,156,0,128,145,0,128,152,0,137,161,5,12,0,64,
159,64,208,128,160,0,128,174,0,73,155,29,209,64,208,72,172,20,64,208,64,
162,64,208,64,152,64,208,64,159,64,208,128,163,0,128,161,0,201,152,100,
112,0,64,208,73,160,13,58,64,208,64,161,64,208,128,154,0,73,152,17,33,64,
208,64,154,64,208,64,160,64,208,128,157,0,201,145,10,13,0,64,208,128,164,
0,128,144,0,128,147,0,200,157,9,0,64,208,128,145,0,128,154,0,137,164,5,
24,0,72,162,8,64,208,128,151,0,64,161,64,208,136,162,4,0,128,161,0,136,
175,4,0,64,173,64,208,128,161,0,192,151,0,64,208,136,161,4,0,128,154,0,
64,154,64,208,137,163,5,45,0,73,152,13,25,64,208,136,167,4,0,128,148,0,
136,148,4,0,192,145,0,64,208,128,159,0,64,161,64,208,64,158,64,208,64,160,
64,208,128,144,0,137,168,5,16,0,64,165,64,208,64,152,64,208,128,161,0,128,
173,0,72,157,110,64,208,201,157,14,65,0,64,208,64,162,64,208,128,145,0,
73,152,13,44,64,208,64,159,64,208,128,162,0,72,149,8,64,208,128,145,0,64,
144,64,208,64,157,64,208,64,144,64,208,64,151,64,208,64,173,64,208,128,
156,0,64,154,64,208,128,144,0,137,165,5,24,0,72,159,8,64,208,128,158,0,
64,158,64,208,64,154,64,208,128,154,0,192,173,0,64,208,137,154,5,8,0,128,
145,0,128,159,0,64,156,64,208,73,158,13,68,64,208,64,160,64,208,128,161,
0,73,152,9,40,64,208,128,164,0,72,147,12,64,208,64,152,64,208,128,164,0,
64,144,64,208,64,160,64,208,64,156,64,208,64,149,64,208,128,157,0,72,157,
12,64,208,64,162,64,208,128,152,0,128,154,0,73,164,9,21,64,208,128,144,
0,200,161,9,0,64,208,128,158,0,128,160,0,128,174,0,74,165,31,2,120,64,208,
137,155,5,16,0,136,148,4,0,64,146,64,208,128,149,0,192,159,0,64,208,128,
159,0,74,162,194,2,14,64,208,73,159,21,100,64,208,64,155,64,208,64,144,
64,208,64,162,64,208,128,144,0,73,147,9,32,64,208,128,160,0,72,145,12,64,
208,64,158,64,208,128,153,0,64,144,64,208,64,157,64,208,128,144,0,72,156,
24,64,208,64,149,64,208,64,162,64,208,64,158,64,208,64,148,64,208,128,171,
0,64,155,64,208,64,158,64,208,64,147,64,208,64,152,64,208,64,154,64,208,
128,144,0,73,162,9,64,64,208,128,156,0,72,161,44,64,208,72,162,36,64,208,
64,144,64,208,64,162,64,208,64,152,64,208,64,161,64,208,64,162,64,208,64,
152,64,208,64,154,64,208,128,144,0,128,154,0,64,160,64,208,64,152,64,208,
128,151,0,72,173,8,64,208,128,159,0,64,163,64,208,136,161,4,0,64,147,64,
208,128,144,0,73,160,131,249,64,208,73,161,13,89,64,208,64,173,64,208,128,
151,0,137,151,5,28,0,72,147,16,64,208,136,163,4,0,64,162,64,208,128,163,
0,64,144,64,208,128,159,0,200,159,37,0,64,208,73,158,21,24,64,208,64,161,
64,208,136,162,4,0,64,144,64,208,128,148,0,128,152,0,64,163,64,208,128,
162,0,64,152,64,208,136,148,4,0,128,144,0,137,167,5,24,0,72,165,8,64,208,
128,152,0,64,162,64,208,64,152,64,208,128,162,0,192,173,0,64,208,136,161,
4,0,128,154,0,64,159,64,208,201,157,10,58,0,64,208,128,147,0,73,148,9,29,
64,208,128,158,0,200,147,13,0,64,208,64,173,64,208,128,162,0,64,146,64,
208,128,162,0,136,154,4,0,64,152,64,208,136,161,4,0,64,159,64,208,128,158,
0,73,161,13,37,64,208,136,164,4,0,128,160,0,72,160,12,64,208,64,175,64,
208,128,155,0,192,158,0,64,208,136,161,4,0,128,154,0,72,173,8,64,208,128,
152,0,64,162,64,208,136,161,4,0,128,158,0,64,161,64,208,137,158,5,34,0,
201,156,10,17,0,64,208,128,152,0,136,151,4,0,128,145,0,192,157,0,64,208,
64,154,64,208,128,158,0,73,161,17,30,64,208,136,160,4,0,64,152,64,208,128,
151,0,192,159,0,64,208,192,158,0,64,208,128,147,0,64,162,64,208,64,164,
64,208,64,158,64,208,128,160,0,200,164,53,0,64,208,73,157,9,28,64,208,128,
158,0,137,152,5,16,0,64,144,64,208,64,157,64,208,128,156,0,128,156,0,73,
161,9,12,64,208,128,152,0,128,159,0,64,163,64,208,128,157,0,192,163,0,64,
208,200,159,9,0,64,208,128,149,0,192,154,0,64,208,128,148,0,201,168,30,
53,0,64,208,64,151,64,208,64,144,64,208,64,146,64,208,64,158,64,208,64,
148,64,208,128,171,0,72,167,8,64,208,128,161,0,64,166,64,208,136,159,4,
0,64,154,64,208,128,145,0,72,174,12,64,208,136,157,4,0,128,148,0,64,173,
64,208,137,158,5,36,0,73,152,13,20,64,208,136,159,4,0,128,157,0,136,146,
4,0,128,145,0,136,157,4,0,64,155,64,208,128,161,0,137,163,5,33,0,200,161,
25,0,64,208,136,165,4,0,64,161,64,208,72,161,8,64,208,128,152,0,128,152,
0,128,159,0,128,173,0,64,134,64,208,73,161,29,148,64,208,64,172,64,208,
64,154,64,208,64,160,64,208,64,144,64,208,64,148,64,208,128,144,0,72,157,
112,64,208,73,159,61,96,64,208,64,160,64,208,72,158,40,64,208,64,156,64,
208,64,159,64,208,64,158,64,208,64,155,64,208,64,134,64,208,64,162,64,208,
64,152,64,208,64,154,64,208,128,152,0,64,144,64,208,64,166,64,208,128,134,
0,64,149,64,208,64,154,64,208,64,158,64,208,64,157,64,208,64,158,64,208,
64,156,64,208,64,134,64,208,64,154,64,208,128,152,0,64,164,64,208,64,134,
64,208,128,157,0,64,147,64,208,128,158,0,128,163,0,64,145,64,208,73,157,
9,138,64,208,128,154,0,73,149,9,72,64,208,128,161,0,73,145,13,36,64,208,
136,161,4,0,128,154,0,72,144,12,64,208,64,161,64,208,128,163,0,64,134,64,
208,64,144,64,208,128,166,0,72,148,8,64,208,128,144,0,64,146,64,208,137,
154,5,12,0,136,152,4,0,128,148,0,128,160,0,201,154,14,42,0,64,208,136,154,
4,0,128,147,0,200,152,25,0,64,208,137,154,5,12,0,64,144,64,208,128,166,
0,64,162,64,208,128,159,0,128,151,0,72,156,8,64,208,128,146,0,64,155,64,
208,128,151,0,73,163,9,114,64,208,128,151,0,201,160,26,66,0,64,208,137,
156,5,12,0,136,155,4,0,128,151,0,136,160,4,0,128,159,0,200,159,17,0,64,
208,137,167,5,8,0,128,165,0,128,173,0,64,158,64,208,137,160,5,12,0,136,
158,4,0,128,147,0,136,164,4,0,128,163,0,72,162,24,64,208,137,161,5,16,0,
72,152,8,64,208,128,161,0,128,147,0,128,164,0,64,161,64,208,136,159,4,0,
64,157,64,208,128,163,0,201,166,10,38,0,64,208,128,156,0,72,165,16,64,208,
72,165,8,64,208,128,161,0,128,164,0,192,164,0,64,208,64,159,64,208,128,
148,0,72,173,16,64,208,137,160,5,8,0,128,154,0,128,161,0,128,168,0,82,148,
1,131,8,11,64,208,73,157,17,224,64,208,136,164,4,0,64,162,64,208,128,159,
0,73,150,9,113,64,208,128,148,0,73,146,17,60,64,208,137,160,5,8,0,128,146,
0,128,163,0,72,145,8,64,208,128,161,0,64,144,64,208,137,148,5,20,0,72,145,
8,64,208,128,175,0,64,144,64,208,128,160,0,136,163,4,0,64,152,64,208,128,
161,0,72,148,16,64,208,136,159,4,0,64,152,64,208,128,156,0,192,147,0,64,
208,73,154,9,20,64,208,128,145,0,64,147,64,208,64,152,64,208,128,161,0,
128,163,0,73,154,41,61,64,208,73,162,9,28,64,208,128,154,0,137,152,5,12,
0,64,146,64,208,128,159,0,64,160,64,208,128,154,0,136,173,4,0,128,166,0,
200,152,13,0,64,208,64,158,64,208,128,160,0,64,151,64,208,128,159,0,200,
156,22,0,64,208,200,161,9,0,64,208,128,162,0,64,147,64,208,128,166,0,64,
155,64,208,64,146,64,208,128,162,0,137,163,5,110,0,73,160,17,69,64,208,
137,148,5,8,0,128,146,0,128,157,0,200,159,29,0,64,208,73,155,9,20,64,208,
128,144,0,136,154,4,0,64,145,64,208,128,144,0,128,157,0,64,158,64,208,137,
158,5,16,0,64,151,64,208,64,156,64,208,128,164,0,128,163,0,200,162,25,0,
64,208,137,162,5,16,0,136,161,4,0,64,151,64,208,128,154,0,128,173,0,64,
161,64,208,136,162,4,0,128,159,0,201,166,14,34,0,64,208,64,156,64,208,128,
159,0,200,165,9,0,64,208,128,147,0,64,164,64,208,136,152,4,0,128,150,0,
136,168,4,0,64,167,64,208,128,160,0,64,147,64,208,74,158,100,3,131,64,208,
73,158,17,53,64,208,136,161,4,0,64,152,64,208,128,160,0,201,154,10,21,0,
64,208,128,148,0,72,147,8,64,208,128,152,0,128,145,0,72,156,8,64,208,128,
151,0,64,155,64,208,128,161,0,201,163,14,37,0,64,208,64,157,64,208,128,
145,0,72,161,12,64,208,64,147,64,208,128,152,0,64,159,64,208,136,163,4,
0,128,152,0,128,164,0,74,150,14,1,184,64,208,64,158,64,208,128,151,0,202,
147,56,1,37,0,64,208,73,160,9,33,64,208,128,163,0,137,154,5,17,0,200,152,
9,0,64,208,128,152,0,128,144,0,64,156,64,208,128,144,0,73,162,9,12,64,208,
128,154,0,128,161,0,128,163,0,73,145,25,198,64,208,73,162,9,16,64,208,128,
173,0,136,159,4,0,128,152,0,128,173,0,64,144,64,208,137,157,5,86,0,137,
152,5,44,0,73,146,21,32,64,208,136,162,4,0,64,156,64,208,64,152,64,208,
128,145,0,64,144,64,208,64,162,64,208,128,156,0,64,148,64,208,128,144,0,
73,155,9,26,64,208,128,159,0,192,154,0,64,208,192,165,0,64,208,64,152,64,
208,128,161,0,64,156,64,208,64,152,64,208,128,148,0,201,162,18,54,0,64,
208,72,165,8,64,208,128,162,0,128,163,0,73,160,9,25,64,208,128,164,0,192,
159,0,64,208,137,152,5,8,0,128,145,0,128,159,0,64,161,64,208,136,158,4,
0,128,154,0,201,164,10,13,0,64,208,128,154,0,128,163,0,192,165,0,64,208,
137,156,5,8,0,128,152,0,128,163,0,64,146,64,208,137,159,5,24,0,137,151,
5,12,0,64,144,64,208,128,154,0,64,156,64,208,128,152,0,136,161,4,0,64,160,
64,208,128,154,0,72,149,24,64,208,136,160,4,0,64,158,64,208,64,160,64,208,
64,144,64,208,128,157,0,192,148,0,64,208,137,160,5,52,0,73,148,25,32,64,
208,137,156,5,12,0,64,152,64,208,128,156,0,64,174,64,208,128,162,0,136,
147,4,0,128,145,0,72,159,12,64,208,64,152,64,208,128,168,0,128,157,0,137,
163,5,45,0,200,162,37,0,64,208,73,160,9,24,64,208,128,154,0,64,148,64,208,
136,156,4,0,64,152,64,208,128,174,0,64,163,64,208,128,166,0,128,161,0,64,
173,64,208,128,161,0,202,155,23,1,55,0,64,208,137,163,5,8,0,128,152,0,64,
173,64,208,128,159,0,73,152,148,171,64,208,201,156,26,77,0,64,208,137,158,
5,16,0,64,152,64,208,136,159,4,0,128,146,0,128,162,0,73,148,17,28,64,208,
72,157,8,64,208,128,163,0,128,144,0,136,146,4,0,64,144,64,208,128,152,0,
136,155,4,0,64,152,64,208,136,162,4,0,64,156,64,208,64,144,64,208,128,162,
0,201,163,18,50,0,64,208,136,163,4,0,64,159,64,208,128,156,0,200,161,17,
0,64,208,136,161,4,0,64,152,64,208,128,161,0,64,160,64,208,72,173,8,64,
208,128,144,0,128,158,0,136,174,4,0,64,173,64,208,136,162,4,0,128,156,0,
64,151,64,208,72,159,8,64,208,128,152,0,64,152,64,208,64,159,64,208,128,
159,0,64,154,64,208,73,158,9,73,64,208,128,148,0,73,148,9,36,64,208,128,
166,0,72,145,24,64,208,72,161,12,64,208,64,156,64,208,128,159,0,64,152,
64,208,128,162,0,128,144,0,72,155,8,64,208,128,154,0,192,152,0,64,208,137,
162,5,8,0,128,159,0,64,173,64,208,128,162,0,73,173,13,33,64,208,64,152,
64,208,128,162,0,200,161,17,0,64,208,72,173,8,64,208,128,163,0,128,161,
0,128,160,0,64,174,64,208,128,144,0,72,157,33,64,208,201,159,10,21,0,64,
208,128,164,0,137,152,5,8,0,128,148,0,128,154,0,136,166,4,0,128,163,0,64,
156,64,208,72,161,8,64,208,128,163,0,128,155,0,74,165,22,2,90,64,208,72,
159,12,64,208,136,163,4,0,128,144,0,128,154,0,74,162,101,1,90,64,208,137,
158,5,33,0,137,154,5,17,0,200,152,9,0,64,208,128,159,0,128,144,0,64,156,
64,208,64,158,64,208,128,156,0,201,163,22,45,0,64,208,72,152,8,64,208,128,
147,0,64,147,64,208,128,144,0,72,162,20,64,208,72,173,8,64,208,128,159,
0,64,152,64,208,128,159,0,128,161,0,192,173,0,64,208,137,163,5,8,0,128,
161,0,128,166,0,73,160,58,160,64,208,137,162,5,25,0,137,158,5,12,0,136,
152,4,0,128,148,0,192,161,0,64,208,128,159,0,73,166,13,20,64,208,64,147,
64,208,128,158,0,64,163,64,208,128,154,0,64,173,64,208,128,161,0,192,159,
0,64,208,137,158,5,49,0,201,152,18,29,0,64,208,64,152,64,208,136,175,4,
0,128,157,0,136,151,4,0,64,148,64,208,128,152,0,136,156,4,0,64,155,64,208,
64,165,64,208,128,158,0,73,162,9,37,64,208,128,154,0,72,161,12,64,208,136,
168,4,0,128,161,0,192,159,0,64,208,137,154,5,8,0,128,152,0,128,163,0,72,
173,8,64,208,128,162,0,128,163,0,192,161,0,64,208,73,159,13,45,64,208,136,
161,4,0,128,152,0,137,148,5,20,0,137,146,5,8,0,128,144,0,64,147,64,208,
128,152,0,136,157,4,0,192,154,0,64,208,128,146,0,73,164,9,20,64,208,128,
158,0,136,163,4,0,64,162,64,208,128,154,0,72,174,8,64,208,128,157,0,64,
167,64,208,128,161,0,72,164,44,64,208,73,159,13,28,64,208,64,168,64,208,
128,154,0,72,158,12,64,208,64,156,64,208,128,161,0,128,156,0,136,166,4,
0,64,161,64,208,128,158,0,192,163,0,64,208,73,156,9,91,64,208,128,152,0,
73,152,17,52,64,208,136,173,4,0,64,156,64,208,128,155,0,73,147,17,20,64,
208,136,154,4,0,64,152,64,208,128,154,0,128,144,0,64,148,64,208,136,162,
4,0,64,152,64,208,128,162,0,200,155,17,0,64,208,64,149,64,208,64,161,64,
208,128,144,0,192,154,0,64,208,192,152,0,64,208,128,152,0,73,162,17,74,
64,208,136,163,4,0,64,152,64,208,128,163,0,201,159,47,54,0,64,208,201,152,
10,33,0,64,208,128,152,0,72,149,20,64,208,64,167,64,208,64,144,64,208,64,
162,64,208,128,152,0,128,145,0,136,161,4,0,128,159,0,64,157,64,208,128,
162,0,128,161,0,72,173,17,64,208,64,161,64,208,192,152,0,64,208,128,152,
0,128,163,0,201,168,34,110,0,64,208,73,157,9,20,64,208,128,148,0,64,156,
64,208,64,161,64,208,128,158,0,64,161,64,208,128,158,0,72,167,8,64,208,
128,160,0,64,166,64,208,73,151,17,36,64,208,136,157,4,0,64,152,64,208,128,
160,0,73,147,9,16,64,208,128,173,0,64,144,64,208,128,150,0,128,148,0,73,
160,9,21,64,208,128,161,0,192,157,0,64,208,64,162,64,208,128,152,0,64,162,
64,208,128,154,0,72,174,12,64,208,136,152,4,0,128,144,0,64,173,64,208,73,
159,13,29,64,208,64,162,64,208,128,154,0,137,154,5,13,0,192,152,0,64,208,
128,154,0,128,158,0,136,163,4,0,192,161,0,64,208,128,154,0,64,149,64,208,
74,156,22,3,183,64,208,137,161,5,12,0,136,158,4,0,128,151,0,128,163,0,74,
150,102,3,106,64,208,73,160,25,60,64,208,64,144,64,208,64,145,64,208,64,
159,64,208,64,158,64,208,128,156,0,72,159,32,64,208,64,160,64,208,64,158,
64,208,64,156,64,208,64,145,64,208,64,144,64,208,64,157,64,208,128,154,
0,128,154,0,64,162,64,208,64,160,64,208,64,144,64,208,64,161,64,208,64,
162,64,208,64,145,64,208,64,144,64,208,64,157,64,208,128,154,0,137,146,
5,16,0,64,144,64,208,64,164,64,208,128,144,0,64,148,64,208,74,160,34,1,
209,64,208,64,144,64,208,64,145,64,208,64,158,64,208,64,162,64,208,64,157,
64,208,64,152,64,208,128,154,0,73,154,53,220,64,208,72,158,28,64,208,64,
156,64,208,64,152,64,208,64,161,64,208,64,161,64,208,64,152,64,208,128,
175,0,64,157,64,208,64,152,64,208,64,150,64,208,64,154,64,208,128,144,0,
73,146,49,112,64,208,64,171,64,208,64,162,64,208,64,160,64,208,64,149,64,
208,64,151,64,208,64,146,64,208,64,152,64,208,64,162,64,208,64,149,64,208,
64,155,64,208,128,172,0,72,145,16,64,208,64,160,64,208,64,144,64,208,128,
162,0,64,144,64,208,72,154,28,64,208,64,144,64,208,64,148,64,208,64,149,
64,208,64,156,64,208,64,152,64,208,128,175,0,64,145,64,208,64,158,64,208,
64,160,64,208,128,162,0,64,152,64,208,64,157,64,208,64,161,64,208,64,162,
64,208,72,160,24,64,208,64,163,64,208,64,156,64,208,64,149,64,208,64,157,
64,208,128,162,0,64,152,64,208,64,162,64,208,64,163,64,208,128,162,0,73,
158,113,124,64,208,73,161,21,84,64,208,64,156,64,208,64,158,64,208,64,162,
64,208,128,160,0,72,148,20,64,208,64,149,64,208,64,150,64,208,64,148,64,
208,128,144,0,64,145,64,208,64,158,64,208,64,160,64,208,64,163,64,208,64,
148,64,208,64,158,64,208,64,146,64,208,64,144,64,208,64,157,64,208,64,152,
64,208,128,149,0,64,162,64,208,64,165,64,208,64,158,64,208,64,148,64,208,
64,158,64,208,128,146,0,64,156,64,208,64,144,64,208,128,147,0,64,159,64,
208,72,160,48,64,208,64,149,64,208,64,148,64,208,64,161,64,208,64,162,64,
208,64,144,64,208,64,146,64,208,64,152,64,208,64,162,64,208,64,149,64,208,
64,155,64,208,128,172,0,64,158,64,208,72,160,16,64,208,64,162,64,208,64,
144,64,208,128,155,0,64,156,64,208,64,158,64,208,64,169,64,208,128,172,
0,73,164,13,204,64,208,64,144,64,208,128,154,0,73,162,29,104,64,208,64,
149,64,208,64,165,64,208,64,157,64,208,64,152,64,208,64,154,64,208,128,
144,0,64,161,64,208,73,149,21,48,64,208,64,161,64,208,64,162,64,208,64,
160,64,208,128,144,0,64,144,64,208,64,157,64,208,64,167,64,208,64,144,64,
208,64,161,64,208,64,162,64,208,128,172,0,64,159,64,208,64,160,64,208,64,
144,64,208,64,146,64,208,64,154,64,208,128,152,0,64,163,64,208,73,161,21,
60,64,208,64,155,64,208,64,163,64,208,64,147,64,208,128,152,0,64,157,64,
208,64,152,64,208,64,146,64,208,64,149,64,208,64,160,64,208,64,161,64,208,
64,152,64,208,64,162,64,208,64,149,64,208,128,162,0,64,167,64,208,64,152,
64,208,64,155,64,208,64,152,64,208,64,169,64,208,128,149,0,73,166,21,44,
64,208,64,149,64,208,64,157,64,208,64,162,64,208,128,160,0,64,165,64,208,
64,144,64,208,64,155,64,208,64,144,64,208,64,162,64,208,128,171,0,64,173,
64,208,64,154,64,208,64,161,64,208,64,159,64,208,64,149,64,208,64,160,64,
208,64,162,64,208,64,152,64,208,64,151,64,208,128,144,0,73,154,25,44,64,
208,72,159,8,64,208,128,158,0,64,158,64,208,136,161,4,0,128,156,0,64,153,
64,208,64,157,64,208,64,154,64,208,64,163,64,208,128,157,0,64,155,64,208,
136,161,4,0,128,159,0,73,161,13,73,64,208,64,154,64,208,128,158,0,73,158,
13,32,64,208,136,166,4,0,128,156,0,64,157,64,208,64,144,64,208,64,162,64,
208,64,149,64,208,128,159,0,64,160,64,208,200,158,9,0,64,208,128,161,0,
64,154,64,208,64,144,64,208,64,145,64,208,128,144,0,73,163,9,252,64,208,
128,159,0,64,162,64,208,73,158,49,188,64,208,64,148,64,208,72,166,20,64,
208,64,149,64,208,64,157,64,208,64,162,64,208,128,160,0,64,161,64,208,64,
158,64,208,64,146,64,208,64,149,64,208,128,162,0,72,154,28,64,208,64,158,
64,208,64,156,64,208,64,145,64,208,64,144,64,208,64,157,64,208,128,154,
0,64,144,64,208,64,155,64,208,64,155,64,208,72,158,60,64,208,72,161,28,
64,208,64,144,64,208,64,153,64,208,64,148,64,208,64,152,64,208,64,157,64,
208,128,147,0,64,159,64,208,64,160,64,208,64,158,64,208,64,164,64,208,64,
152,64,208,64,155,64,208,128,172,0,64,152,64,208,64,157,64,208,64,146,64,
208,64,149,64,208,64,161,64,208,64,162,64,208,64,145,64,208,64,144,64,208,
64,157,64,208,128,154,0,72,163,16,64,208,64,159,64,208,64,144,64,208,128,
154,0,64,160,64,208,64,144,64,208,64,154,64,208,64,158,64,208,64,156,64,
208,64,145,64,208,64,144,64,208,64,157,64,208,128,154,0,64,165,64,208,72,
158,36,64,208,64,145,64,208,64,160,64,208,64,144,64,208,64,145,64,208,64,
158,64,208,64,162,64,208,64,154,64,208,128,144,0,64,154,64,208,64,158,64,
208,64,160,64,208,64,159,64,208,64,163,64,208,128,161,0,74,155,176,13,236,
64,208,201,159,35,122,0,64,208,137,159,5,16,0,72,156,8,64,208,128,163,0,
128,147,0,136,167,4,0,192,163,0,64,208,128,151,0,73,150,13,60,64,208,64,
156,64,208,128,161,0,73,146,13,28,64,208,136,154,4,0,128,151,0,72,145,8,
64,208,128,152,0,64,144,64,208,128,152,0,64,148,64,208,137,154,5,8,0,128,
148,0,64,158,64,208,128,154,0,73,154,9,20,64,208,128,159,0,64,151,64,208,
136,154,4,0,128,150,0,64,157,64,208,128,165,0,137,163,5,36,0,73,161,17,
24,64,208,137,158,5,8,0,128,146,0,128,159,0,64,160,64,208,128,151,0,64,
162,64,208,128,152,0,137,165,5,8,0,128,164,0,128,173,0,82,152,8,42,9,166,
80,208,8,29,74,158,30,5,181,64,208,137,158,5,16,0,136,157,4,0,64,156,64,
208,128,144,0,136,173,4,0,128,161,0,202,151,19,1,79,0,64,208,136,158,4,
0,64,152,64,208,128,162,0,73,147,103,243,64,208,201,159,10,69,0,64,208,
128,152,0,73,154,9,40,64,208,128,163,0,72,152,20,64,208,137,159,5,12,0,
64,154,64,208,128,163,0,128,161,0,64,144,64,208,64,152,64,208,128,154,0,
64,156,64,208,137,162,5,12,0,64,152,64,208,128,162,0,128,163,0,137,163,
5,25,0,72,162,12,64,208,64,152,64,208,128,154,0,192,161,0,64,208,128,163,
0,128,164,0,73,145,49,93,64,208,137,156,5,28,0,137,148,5,8,0,128,147,0,
64,152,64,208,136,164,4,0,64,154,64,208,128,162,0,137,161,5,8,0,128,159,
0,64,163,64,208,128,144,0,192,144,0,64,208,137,160,5,28,0,73,154,13,20,
64,208,64,160,64,208,128,158,0,64,152,64,208,128,161,0,128,157,0,136,166,
4,0,64,161,64,208,128,154,0,64,146,64,208,137,162,5,32,0,73,155,13,16,64,
208,64,147,64,208,128,163,0,128,151,0,64,158,64,208,64,155,64,208,128,161,
0,72,173,8,64,208,128,161,0,128,166,0,72,149,40,64,208,136,162,4,0,64,155,
64,208,64,158,64,208,64,155,64,208,64,149,64,208,64,153,64,208,64,154,64,
208,64,158,64,208,128,151,0,192,148,0,64,208,73,149,9,20,64,208,128,152,
0,64,144,64,208,64,163,64,208,128,161,0,192,154,0,64,208,128,166,0,73,155,
13,195,64,208,64,162,64,208,128,144,0,72,154,68,64,208,137,159,5,44,0,72,
149,36,64,208,64,155,64,208,64,144,64,208,64,157,64,208,64,148,64,208,64,
150,64,208,64,149,64,208,64,155,64,208,128,158,0,128,147,0,72,165,16,64,
208,136,161,4,0,64,152,64,208,128,161,0,128,162,0,64,152,64,208,73,157,
13,74,64,208,64,161,64,208,128,154,0,73,150,9,42,64,208,128,162,0,200,147,
22,0,64,208,136,161,4,0,192,144,0,64,208,64,152,64,208,128,154,0,64,146,
64,208,136,165,4,0,128,162,0,72,156,16,64,208,136,164,4,0,64,161,64,208,
128,165,0,128,151,0,137,162,5,33,0,200,161,17,0,64,208,136,159,4,0,64,156,
64,208,128,154,0,64,159,64,208,136,161,4,0,128,156,0,128,175,0,80,157,3,
62,64,208,74,158,88,1,104,64,208,64,145,64,208,72,160,58,64,208,72,157,
20,64,208,64,144,64,208,64,163,64,208,64,154,64,208,128,152,0,192,144,0,
64,208,192,151,0,64,208,64,158,64,208,64,146,64,208,64,144,64,208,64,157,
64,208,64,152,64,208,128,149,0,64,158,64,208,64,160,64,208,64,158,64,208,
64,157,64,208,128,171,0,73,151,21,176,64,208,64,148,64,208,64,160,64,208,
64,144,64,208,128,146,0,73,146,41,128,64,208,72,158,24,64,208,64,148,64,
208,136,171,4,0,64,165,64,208,64,158,64,208,128,151,0,64,144,64,208,64,
162,64,208,128,144,0,136,145,4,0,64,144,64,208,73,147,45,72,64,208,64,160,
64,208,64,158,64,208,64,159,64,208,64,158,64,208,64,155,64,208,64,152,64,
208,64,162,64,208,64,152,64,208,64,154,64,208,128,152,0,64,146,64,208,64,
162,64,208,64,158,64,208,64,159,64,208,64,160,64,208,64,158,64,208,128,
156,0,64,159,64,208,128,154,0,64,147,64,208,64,144,64,208,64,151,64,208,
64,159,64,208,64,160,64,208,64,158,64,208,128,156,0,73,156,29,77,64,208,
64,158,64,208,64,160,64,208,64,164,64,208,64,155,64,208,64,158,64,208,128,
162,0,72,154,33,64,208,64,163,64,208,64,155,64,208,64,172,64,208,64,162,
64,208,192,163,0,64,208,64,160,64,208,128,171,0,64,152,64,208,64,159,64,
208,64,152,64,208,128,147,0,64,157,64,208,64,144,64,208,64,163,64,208,64,
154,64,208,128,152,0,74,163,38,1,92,64,208,64,148,64,208,64,158,64,208,
64,145,64,208,64,160,64,208,64,149,64,208,64,157,64,208,64,152,64,208,128,
149,0,73,161,78,250,64,208,73,162,13,69,64,208,64,144,64,208,128,162,0,
72,149,41,64,208,64,155,64,208,64,172,64,208,64,165,64,208,64,158,64,208,
192,151,0,64,208,64,159,64,208,64,160,64,208,64,158,64,208,128,148,0,64,
146,64,208,64,175,64,208,64,151,64,208,128,152,0,128,173,0,72,160,60,64,
208,136,158,4,0,64,149,64,208,64,147,64,208,64,152,64,208,64,158,64,208,
64,157,64,208,64,160,64,208,64,144,64,208,64,151,64,208,64,146,64,208,64,
152,64,208,64,162,64,208,64,152,64,208,128,175,0,64,159,64,208,64,160,64,
208,72,158,57,64,208,192,156,0,64,208,72,162,16,64,208,64,158,64,208,64,
160,64,208,128,147,0,64,159,64,208,64,158,64,208,64,155,64,208,64,152,64,
208,64,162,64,208,64,152,64,208,64,154,64,208,128,152,0,64,152,64,208,64,
160,64,208,64,158,64,208,64,148,64,208,64,160,64,208,64,149,64,208,64,161,
64,208,64,163,64,208,64,160,64,208,64,161,64,208,64,158,64,208,128,146,
0,64,162,64,208,73,160,42,53,64,208,72,163,12,64,208,64,148,64,208,128,
144,0,64,144,64,208,64,157,64,208,192,161,0,64,208,64,154,64,208,64,158,
64,208,128,156,0,64,158,64,208,64,160,64,208,128,147,0,128,161,0,73,173,
61,105,64,208,72,157,36,64,208,64,149,64,208,64,160,64,208,64,147,64,208,
64,149,64,208,64,162,64,208,64,152,64,208,64,154,64,208,128,152,0,64,154,
64,208,64,158,64,208,64,157,64,208,64,158,64,208,128,156,0,200,165,33,0,
64,208,136,163,4,0,64,152,64,208,64,156,64,208,64,159,64,208,64,160,64,
208,64,158,64,208,128,156,0,64,164,64,208,64,152,64,208,128,157,0,64,174,
64,208,64,161,64,208,128,162,0,64,156,64,208,137,159,5,28,0,73,157,9,16,
64,208,128,161,0,136,155,4,0,128,145,0,64,158,64,208,128,159,0,137,166,
5,16,0,64,161,64,208,136,165,4,0,128,160,0,64,173,64,208,137,158,5,12,0,
64,156,64,208,128,158,0,64,161,64,208,128,165,0,74,165,10,1,164,64,208,
128,156,0,74,162,75,1,76,64,208,73,160,17,49,64,208,136,158,4,0,64,152,
64,208,128,161,0,73,158,18,25,64,208,200,156,9,0,64,208,128,148,0,128,155,
0,64,155,64,208,128,159,0,64,159,64,208,128,164,0,72,173,12,64,208,136,
159,4,0,128,158,0,64,161,64,208,128,158,0,73,160,61,184,64,208,73,161,13,
32,64,208,64,159,64,208,128,152,0,73,159,9,16,64,208,128,173,0,64,146,64,
208,128,167,0,128,160,0,72,173,12,64,208,136,161,4,0,128,144,0,64,162,64,
208,64,168,64,208,128,145,0,192,159,0,64,208,201,159,10,79,0,64,208,128,
161,0,201,154,23,62,0,64,208,72,160,8,64,208,128,158,0,192,152,0,64,208,
128,164,0,73,145,13,20,64,208,64,152,64,208,128,144,0,64,144,64,208,128,
158,0,64,152,64,208,137,159,5,12,0,64,148,64,208,128,152,0,128,173,0,136,
158,4,0,128,155,0,73,163,9,24,64,208,128,160,0,72,162,8,64,208,128,154,
0,64,161,64,208,128,144,0,136,173,4,0,64,164,64,208,64,146,64,208,128,162,
0,64,161,64,208,73,158,25,58,64,208,137,159,5,12,0,64,147,64,208,128,148,
0,64,163,64,208,128,154,0,201,152,18,21,0,64,208,136,162,4,0,64,159,64,
208,128,154,0,128,145,0,192,154,0,64,208,136,162,4,0,128,154,0,136,173,
4,0,64,161,64,208,128,158,0,72,164,54,64,208,201,155,10,38,0,64,208,128,
152,0,72,154,20,64,208,64,152,64,208,136,161,4,0,64,145,64,208,128,148,
0,192,152,0,64,208,128,161,0,136,166,4,0,64,163,64,208,128,145,0,192,163,
0,64,208,137,151,5,12,0,64,145,64,208,128,159,0,64,167,64,208,128,159,0,
73,168,17,106,64,208,64,156,64,208,64,152,64,208,128,154,0,72,167,20,64,
208,136,161,4,0,64,147,64,208,64,144,64,208,128,163,0,192,166,0,64,208,
201,157,10,45,0,64,208,128,162,0,73,152,13,20,64,208,64,158,64,208,128,
162,0,64,144,64,208,128,160,0,64,156,64,208,72,152,8,64,208,128,151,0,128,
151,0,72,173,8,64,208,128,148,0,64,163,64,208,64,164,64,208,128,152,0,136,
174,4,0,64,173,64,208,201,159,14,54,0,64,208,136,159,4,0,128,156,0,137,
154,5,12,0,136,152,4,0,128,144,0,200,156,25,0,64,208,73,152,13,16,64,208,
136,161,4,0,128,159,0,128,144,0,128,159,0,128,155,0,137,164,5,16,0,136,
162,4,0,64,161,64,208,128,152,0,192,173,0,64,208,128,162,0,64,72,64,208,
128,147,0,192,151,0,64,208,73,158,25,224,64,208,137,160,5,12,0,136,158,
4,0,128,154,0,64,166,64,208,128,156,0,201,148,14,86,0,64,208,136,165,4,
0,128,160,0,73,146,25,61,64,208,137,151,5,12,0,136,146,4,0,128,144,0,136,
162,4,0,128,158,0,200,145,9,0,64,208,128,157,0,64,144,64,208,137,157,5,
12,0,136,156,4,0,128,155,0,72,161,8,64,208,128,159,0,128,159,0,64,147,64,
208,136,161,4,0,128,156,0,201,154,42,90,0,64,208,73,160,9,24,64,208,128,
161,0,137,158,5,8,0,128,156,0,64,159,64,208,128,148,0,136,162,4,0,64,161,
64,208,128,156,0,72,152,28,64,208,137,158,5,16,0,72,156,8,64,208,128,159,
0,128,144,0,64,161,64,208,128,160,0,64,150,64,208,64,145,64,208,192,152,
0,64,208,64,152,64,208,128,162,0,64,156,64,208,137,151,5,12,0,136,146,4,
0,128,144,0,136,158,4,0,128,154,0,73,163,13,104,64,208,136,164,4,0,128,
144,0,73,161,21,76,64,208,137,160,5,8,0,128,144,0,64,161,64,208,128,161,
0,72,160,28,64,208,137,154,5,16,0,72,152,8,64,208,128,159,0,128,144,0,64,
162,64,208,128,144,0,64,159,64,208,137,161,5,16,0,137,146,5,8,0,128,144,
0,128,160,0,136,167,4,0,128,162,0,64,162,64,208,137,147,5,8,0,128,144,0,
128,156,0,73,168,13,24,64,208,136,160,4,0,128,146,0,64,165,64,208,136,167,
4,0,128,160,0,64,173,64,208,137,158,5,16,0,64,156,64,208,136,152,4,0,128,
144,0,128,159,0,192,154,0,64,208,74,158,42,2,42,64,208,137,159,5,20,0,136,
152,4,0,64,144,64,208,64,159,64,208,128,162,0,72,162,8,64,208,128,161,0,
64,161,64,208,128,160,0,73,150,21,251,64,208,137,161,5,12,0,136,148,4,0,
128,147,0,128,162,0,73,147,49,207,64,208,137,159,5,28,0,137,151,5,8,0,128,
148,0,64,152,64,208,72,173,8,64,208,128,159,0,128,154,0,72,175,8,64,208,
128,145,0,64,161,64,208,128,161,0,201,145,46,119,0,64,208,137,157,5,28,
0,73,145,9,20,64,208,128,147,0,64,144,64,208,64,175,64,208,128,162,0,128,
154,0,137,161,5,8,0,128,160,0,128,174,0,64,144,64,208,137,155,5,36,0,137,
148,5,16,0,136,145,4,0,64,144,64,208,128,148,0,64,152,64,208,72,161,8,64,
208,128,152,0,128,160,0,201,161,10,26,0,64,208,128,152,0,72,159,8,64,208,
128,159,0,192,156,0,64,208,128,161,0,64,173,64,208,128,157,0,64,146,64,
208,73,160,9,20,64,208,128,148,0,137,154,5,8,0,128,152,0,128,156,0,73,173,
9,12,64,208,128,161,0,128,166,0,128,175,0,72,149,8,64,208,128,161,0,64,
148,64,208,136,166,4,0,64,157,64,208,128,163,0,201,155,42,185,0,64,208,
73,160,9,28,64,208,128,148,0,137,154,5,12,0,64,150,64,208,128,148,0,64,
156,64,208,128,154,0,136,162,4,0,128,161,0,73,152,56,100,64,208,137,157,
5,25,0,137,152,5,17,0,200,148,9,0,64,208,128,161,0,128,144,0,128,156,0,
201,161,10,22,0,64,208,128,165,0,136,159,4,0,192,158,0,64,208,128,157,0,
128,164,0,64,151,64,208,137,157,5,21,0,137,154,5,13,0,192,145,0,64,208,
128,159,0,128,156,0,137,160,5,16,0,64,159,64,208,136,167,4,0,128,156,0,
128,161,0,64,154,64,208,137,157,5,24,0,137,154,5,16,0,136,152,4,0,64,151,
64,208,128,160,0,128,156,0,73,162,9,12,64,208,128,162,0,128,160,0,128,165,
0,72,157,24,64,208,137,162,5,16,0,136,160,4,0,64,147,64,208,128,163,0,128,
164,0,64,156,64,208,137,156,5,24,0,73,147,9,12,64,208,128,161,0,128,146,
0,64,150,64,208,128,148,0,136,162,4,0,192,159,0,64,208,72,158,8,64,208,
128,147,0,64,157,64,208,128,147,0,202,165,15,1,30,0,64,208,136,160,4,0,
128,144,0,73,162,37,224,64,208,137,159,5,16,0,137,145,5,8,0,128,144,0,128,
155,0,137,163,5,12,0,64,162,64,208,128,144,0,128,164,0,73,160,50,106,64,
208,137,161,5,25,0,137,155,5,12,0,136,154,4,0,128,151,0,192,159,0,64,208,
128,157,0,73,165,9,16,64,208,128,146,0,64,162,64,208,128,159,0,128,166,
0,64,159,64,208,137,161,5,37,0,201,158,10,21,0,64,208,128,161,0,136,157,
4,0,64,152,64,208,128,175,0,64,160,64,208,64,146,64,208,128,162,0,73,166,
9,12,64,208,128,157,0,128,163,0,128,167,0,192,161,0,64,208,73,157,13,40,
64,208,64,162,64,208,128,152,0,137,152,5,20,0,72,145,12,64,208,64,158,64,
208,128,156,0,128,144,0,136,156,4,0,128,154,0,73,162,9,25,64,208,128,155,
0,136,159,4,0,192,158,0,64,208,136,159,4,0,128,152,0,136,165,4,0,64,163,
64,208,128,148,0,72,164,8,64,208,128,161,0,64,163,64,208,73,152,17,32,64,
208,136,159,4,0,64,157,64,208,128,162,0,72,147,12,64,208,64,162,64,208,
128,161,0,128,145,0,128,159,0,73,168,13,37,64,208,136,167,4,0,128,146,0,
72,167,12,64,208,136,165,4,0,128,152,0,192,166,0,64,208,64,158,64,208,128,
148,0,136,174,4,0,192,173,0,64,208,73,161,13,20,64,208,64,152,64,208,128,
152,0,136,160,4,0,128,145,0,136,164,4,0,128,162,0,80,157,2,31,64,208,202,
158,35,1,45,0,64,208,73,158,13,24,64,208,64,157,64,208,128,162,0,136,145,
4,0,64,144,64,208,128,160,0,128,159,0,73,149,37,85,64,208,136,161,4,0,64,
156,64,208,64,158,64,208,64,161,64,208,64,165,64,208,64,149,64,208,64,156,
64,208,128,144,0,73,146,9,29,64,208,128,154,0,200,145,13,0,64,208,64,173,
64,208,128,162,0,64,144,64,208,128,162,0,72,148,8,64,208,128,162,0,64,147,
64,208,136,161,4,0,128,154,0,73,155,13,166,64,208,136,161,4,0,128,151,0,
72,154,28,64,208,137,154,5,16,0,64,144,64,208,136,162,4,0,128,144,0,64,
173,64,208,128,161,0,64,152,64,208,73,160,21,102,64,208,72,162,8,64,208,
128,152,0,64,160,64,208,128,152,0,73,158,9,74,64,208,128,152,0,192,152,
0,64,208,73,159,13,40,64,208,136,163,4,0,128,144,0,73,156,9,24,64,208,128,
173,0,72,155,8,64,208,128,165,0,64,154,64,208,128,144,0,128,158,0,137,161,
5,13,0,192,160,0,64,208,128,161,0,64,173,64,208,128,156,0,64,159,64,208,
128,152,0,72,162,12,64,208,136,161,4,0,128,152,0,64,161,64,208,128,167,
0,136,157,4,0,64,156,64,208,136,146,4,0,128,144,0,73,164,17,177,64,208,
64,159,64,208,64,156,64,208,128,159,0,201,161,22,108,0,64,208,72,160,12,
64,208,64,144,64,208,128,162,0,128,155,0,200,160,21,0,64,208,137,159,5,
8,0,128,144,0,64,165,64,208,128,163,0,192,159,0,64,208,137,163,5,24,0,137,
155,5,16,0,136,151,4,0,64,146,64,208,128,158,0,128,158,0,73,167,9,29,64,
208,128,159,0,200,166,17,0,64,208,72,161,8,64,208,128,156,0,128,158,0,128,
164,0,64,173,64,208,128,154,0,72,163,17,64,208,192,166,0,64,208,64,152,
64,208,128,145,0,64,162,64,208,137,162,5,24,0,72,158,16,64,208,136,161,
4,0,64,158,64,208,128,158,0,128,154,0,136,166,4,0,128,163,0,73,173,13,52,
64,208,64,159,64,208,128,163,0,72,166,28,64,208,137,161,5,16,0,136,160,
4,0,64,154,64,208,128,155,0,64,173,64,208,128,161,0,64,165,64,208,136,154,
4,0,128,145,0,64,174,64,208,128,152,0,64,156,64,208,74,157,22,1,69,64,208,
137,161,5,12,0,136,154,4,0,128,146,0,128,166,0,73,149,9,126,64,208,128,
157,0,73,146,29,80,64,208,137,151,5,12,0,136,145,4,0,128,144,0,72,168,8,
64,208,128,145,0,128,166,0,201,144,28,35,0,64,208,201,161,10,18,0,64,208,
128,161,0,192,147,0,64,208,128,161,0,128,173,0,64,134,64,208,128,164,0,
192,145,0,64,208,137,152,5,8,0,128,144,0,128,159,0,200,148,13,0,64,208,
136,166,4,0,128,156,0,192,147,0,64,208,137,157,5,8,0,128,155,0,64,164,64,
208,64,152,64,208,128,146,0,201,154,34,118,0,64,208,137,164,5,20,0,73,146,
9,12,64,208,128,175,0,128,145,0,128,163,0,136,175,4,0,128,168,0,201,151,
14,29,0,64,208,136,161,4,0,128,152,0,64,150,64,208,72,161,8,64,208,128,
154,0,128,148,0,64,152,64,208,137,158,5,24,0,73,146,13,16,64,208,64,173,
64,208,128,161,0,128,145,0,128,155,0,72,173,20,64,208,64,152,64,208,64,
164,64,208,64,152,64,208,128,159,0,64,162,64,208,128,173,0,72,156,32,64,
208,137,161,5,20,0,137,152,5,8,0,128,151,0,64,155,64,208,128,144,0,136,
166,4,0,128,164,0,64,155,64,208,73,159,9,16,64,208,128,163,0,136,154,4,
0,128,150,0,136,166,4,0,128,164,0,73,164,46,216,64,208,137,154,5,33,0,201,
145,10,17,0,64,208,128,168,0,64,144,64,208,128,154,0,64,148,64,208,64,160,
64,208,128,162,0,136,164,4,0,128,160,0,73,161,39,119,64,208,137,152,5,16,
0,137,147,5,8,0,128,145,0,128,151,0,200,159,9,0,64,208,128,161,0,192,154,
0,64,208,128,161,0,201,159,38,61,0,64,208,137,159,5,20,0,137,156,5,12,0,
64,154,64,208,128,165,0,128,158,0,136,166,4,0,64,163,64,208,128,162,0,64,
158,64,208,137,162,5,16,0,72,154,8,64,208,128,164,0,128,147,0,128,166,0,
64,160,64,208,137,161,5,12,0,136,159,4,0,128,154,0,128,166,0,72,163,20,
64,208,64,145,64,208,64,152,64,208,64,152,64,208,128,162,0,64,162,64,208,
137,161,5,12,0,136,159,4,0,128,154,0,136,166,4,0,64,162,64,208,64,155,64,
208,128,159,0,73,168,9,33,64,208,128,159,0,201,166,10,17,0,64,208,128,159,
0,64,165,64,208,128,161,0,64,167,64,208,128,161,0,136,175,4,0,192,173,0,
64,208,136,159,4,0,128,151,0,82,166,2,216,17,47,64,208,74,158,46,1,90,64,
208,73,154,9,24,64,208,128,158,0,137,151,5,12,0,136,148,4,0,128,146,0,128,
152,0,137,161,5,12,0,64,160,64,208,128,162,0,128,163,0,73,151,13,164,64,
208,136,163,4,0,128,161,0,73,147,30,114,64,208,201,152,10,13,0,64,208,128,
145,0,128,145,0,64,161,64,208,64,173,64,208,128,157,0,73,145,25,52,64,208,
137,157,5,12,0,136,154,4,0,128,152,0,64,173,64,208,128,159,0,64,144,64,
208,73,148,9,12,64,208,128,158,0,128,146,0,64,163,64,208,64,146,64,208,
128,148,0,192,146,0,64,208,137,158,5,16,0,136,156,4,0,64,134,64,208,128,
161,0,136,162,4,0,64,160,64,208,128,162,0,72,149,20,64,208,64,156,64,208,
64,161,64,208,64,144,64,208,128,156,0,192,148,0,64,208,200,161,9,0,64,208,
128,158,0,128,154,0,201,155,14,85,0,64,208,64,165,64,208,128,159,0,200,
154,29,0,64,208,137,156,5,16,0,136,152,4,0,64,148,64,208,128,161,0,136,
161,4,0,128,158,0,192,152,0,64,208,137,159,5,30,0,73,154,9,17,64,208,128,
150,0,192,152,0,64,208,128,162,0,192,158,0,64,208,128,156,0,136,175,4,0,
128,162,0,72,157,32,64,208,137,159,5,20,0,72,158,8,64,208,128,146,0,64,
156,64,208,128,158,0,64,162,64,208,128,152,0,64,156,64,208,136,161,4,0,
64,157,64,208,64,152,64,208,128,160,0,202,164,51,1,37,0,64,208,137,160,
5,24,0,137,158,5,16,0,72,149,8,64,208,128,160,0,128,145,0,128,159,0,73,
164,9,12,64,208,128,156,0,128,163,0,64,173,64,208,128,160,0,73,161,29,155,
64,208,137,161,5,16,0,72,159,8,64,208,128,159,0,128,151,0,64,173,64,208,
128,152,0,200,160,62,0,64,208,137,159,5,37,0,73,152,9,20,64,208,128,161,
0,136,148,4,0,64,145,64,208,128,163,0,192,156,0,64,208,64,161,64,208,128,
158,0,73,161,13,16,64,208,64,145,64,208,128,163,0,128,160,0,128,163,0,64,
159,64,208,73,154,17,45,64,208,64,152,64,208,64,159,64,208,128,161,0,137,
148,5,12,0,136,145,4,0,128,144,0,200,152,13,0,64,208,136,160,4,0,128,156,
0,128,150,0,137,163,5,12,0,136,161,4,0,128,157,0,128,167,0,72,163,40,64,
208,73,152,9,28,64,208,128,161,0,72,144,12,64,208,64,160,64,208,128,147,
0,64,134,64,208,128,154,0,64,173,64,208,128,160,0,64,162,64,208,73,161,
9,24,64,208,128,160,0,137,156,5,12,0,64,151,64,208,128,156,0,128,158,0,
73,163,9,16,64,208,128,160,0,64,162,64,208,128,161,0,128,164,0,137,167,
5,17,0,200,166,9,0,64,208,128,161,0,128,165,0,72,175,8,64,208,128,145,0,
64,173,64,208,73,157,9,41,64,208,128,162,0,137,152,5,25,0,192,145,0,64,
208,72,160,12,64,208,64,145,64,208,128,156,0,128,158,0,64,156,64,208,128,
147,0,72,161,8,64,208,128,152,0,128,158,0,82,162,1,221,9,251,64,208,202,
159,24,1,9,0,64,208,201,159,10,13,0,64,208,128,154,0,128,155,0,128,167,
0,201,152,54,159,0,64,208,73,156,17,36,64,208,136,159,4,0,64,156,64,208,
128,159,0,72,155,8,64,208,128,159,0,64,152,64,208,64,146,64,208,128,162,
0,136,161,4,0,64,159,64,208,128,159,0,73,146,25,81,64,208,137,161,5,12,
0,136,156,4,0,128,148,0,64,173,64,208,128,161,0,200,145,33,0,64,208,137,
161,5,20,0,136,149,4,0,64,144,64,208,64,157,64,208,128,154,0,136,174,4,
0,128,173,0,64,144,64,208,137,162,5,12,0,64,151,64,208,128,154,0,64,165,
64,208,128,161,0,200,151,13,0,64,208,136,163,4,0,128,154,0,64,150,64,208,
136,166,4,0,128,162,0,201,156,18,58,0,64,208,137,163,5,8,0,128,161,0,128,
166,0,72,155,12,64,208,136,163,4,0,128,145,0,192,154,0,64,208,137,159,5,
16,0,72,156,8,64,208,128,158,0,128,154,0,136,161,4,0,128,160,0,192,158,
0,64,208,137,154,5,16,0,64,152,64,208,64,151,64,208,128,152,0,128,165,0,
201,164,18,137,0,64,208,64,158,64,208,64,156,64,208,128,161,0,201,162,22,
102,0,64,208,137,163,5,12,0,136,159,4,0,128,156,0,128,164,0,200,161,52,
0,64,208,201,154,10,35,0,64,208,128,152,0,137,148,5,13,0,192,145,0,64,208,
128,163,0,64,151,64,208,192,157,0,64,208,128,144,0,137,160,5,8,0,128,157,
0,128,163,0,192,160,0,64,208,73,152,13,16,64,208,136,173,4,0,128,158,0,
128,151,0,64,161,64,208,128,159,0,192,163,0,64,208,64,161,64,208,192,152,
0,64,208,128,152,0,73,173,29,56,64,208,137,159,5,16,0,137,145,5,8,0,128,
144,0,128,158,0,136,163,4,0,128,162,0,72,166,16,64,208,136,160,4,0,64,151,
64,208,128,157,0,64,165,64,208,64,162,64,208,128,163,0,64,174,64,208,136,
151,4,0,128,144,0,82,160,1,232,4,131,64,208,73,157,17,217,64,208,137,159,
5,8,0,128,154,0,128,166,0,73,149,9,98,64,208,128,146,0,201,146,22,57,0,
64,208,137,158,5,12,0,136,154,4,0,128,145,0,128,161,0,136,145,4,0,64,144,
64,208,137,166,5,24,0,136,163,4,0,64,159,64,208,64,156,64,208,64,161,64,
208,128,145,0,128,168,0,72,148,12,64,208,64,158,64,208,128,159,0,192,147,
0,64,208,72,159,12,64,208,64,158,64,208,128,147,0,128,151,0,201,154,14,
66,0,64,208,136,161,4,0,128,145,0,72,152,41,64,208,73,146,21,28,64,208,
136,166,4,0,64,161,64,208,64,173,64,208,128,158,0,64,145,64,208,128,152,
0,192,158,0,64,208,128,166,0,64,151,64,208,136,161,4,0,128,159,0,72,156,
28,64,208,73,158,9,16,64,208,128,162,0,136,156,4,0,128,151,0,136,166,4,
0,128,162,0,192,155,0,64,208,128,161,0,73,163,29,182,64,208,137,166,5,16,
0,72,159,8,64,208,128,161,0,128,151,0,64,173,64,208,128,161,0,73,160,13,
85,64,208,136,161,4,0,128,145,0,72,159,49,64,208,73,161,9,28,64,208,128,
158,0,72,158,8,64,208,128,162,0,64,152,64,208,64,152,64,208,128,157,0,136,
166,4,0,192,162,0,64,208,64,165,64,208,128,146,0,64,158,64,208,137,156,
5,16,0,72,154,8,64,208,128,156,0,128,148,0,128,162,0,200,162,37,0,64,208,
73,156,9,20,64,208,128,161,0,137,152,5,8,0,128,151,0,128,154,0,72,163,8,
64,208,128,161,0,128,159,0,64,161,64,208,73,159,9,16,64,208,128,154,0,136,
156,4,0,128,154,0,72,173,8,64,208,128,152,0,128,163,0,73,173,25,74,64,208,
137,154,5,12,0,136,147,4,0,128,145,0,136,159,4,0,128,158,0,200,166,33,0,
64,208,73,159,9,20,64,208,128,154,0,72,152,8,64,208,128,158,0,128,145,0,
64,173,64,208,128,161,0,64,164,64,208,200,161,9,0,64,208,128,161,0,128,
158,0,64,175,64,208,128,163,0,64,159,64,208,74,158,35,1,50,64,208,73,158,
9,21,64,208,128,161,0,200,146,9,0,64,208,128,162,0,128,145,0,136,162,4,
0,128,161,0,201,151,14,171,0,64,208,136,159,4,0,128,154,0,73,147,29,89,
64,208,73,159,13,20,64,208,136,162,4,0,128,159,0,136,154,4,0,128,146,0,
128,163,0,201,145,22,41,0,64,208,137,158,5,12,0,136,154,4,0,128,145,0,128,
162,0,64,144,64,208,137,161,5,8,0,128,144,0,64,162,64,208,128,159,0,64,
146,64,208,73,162,9,12,64,208,128,152,0,128,158,0,128,173,0,72,150,28,64,
208,73,160,13,20,64,208,64,173,64,208,128,159,0,64,154,64,208,128,165,0,
128,165,0,192,148,0,64,208,73,159,9,32,64,208,128,156,0,72,158,12,64,208,
64,158,64,208,128,161,0,64,147,64,208,64,158,64,208,128,161,0,128,163,0,
73,155,21,65,64,208,64,144,64,208,64,162,64,208,64,160,64,208,128,154,0,
200,154,17,0,64,208,137,162,5,8,0,128,144,0,128,165,0,64,152,64,208,73,
162,9,20,64,208,128,154,0,136,158,4,0,64,154,64,208,128,161,0,128,175,0,
72,157,20,64,208,64,175,64,208,64,160,64,208,64,162,64,208,128,166,0,64,
156,64,208,137,152,5,8,0,128,151,0,128,158,0,74,165,10,1,41,64,208,128,
155,0,73,162,58,248,64,208,73,166,13,32,64,208,64,152,64,208,128,160,0,
137,161,5,12,0,136,159,4,0,128,152,0,64,162,64,208,128,154,0,201,173,14,
17,0,64,208,64,173,64,208,128,159,0,128,168,0,128,175,0,201,160,90,146,
0,64,208,201,158,14,47,0,64,208,64,158,64,208,128,161,0,137,154,5,26,0,
137,146,5,13,0,192,144,0,64,208,128,159,0,192,152,0,64,208,128,173,0,136,
156,4,0,128,155,0,137,167,5,29,0,200,161,13,0,64,208,64,158,64,208,128,
159,0,64,159,64,208,64,150,64,208,128,158,0,136,175,4,0,128,173,0,192,159,
0,64,208,137,152,5,28,0,137,146,5,16,0,64,144,64,208,64,159,64,208,128,
145,0,64,150,64,208,128,162,0,73,157,9,16,64,208,128,159,0,64,154,64,208,
128,165,0,64,161,64,208,128,161,0,64,161,64,208,137,152,5,20,0,137,148,
5,12,0,64,146,64,208,128,159,0,128,151,0,137,161,5,17,0,192,160,0,64,208,
64,144,64,208,128,162,0,128,163,0,72,164,16,64,208,137,157,5,8,0,128,147,
0,128,161,0,64,163,64,208,72,163,8,64,208,128,160,0,64,144,64,208,64,151,
64,208,128,158,0,73,168,9,20,64,208,128,158,0,136,167,4,0,64,166,64,208,
128,163,0,72,175,8,64,208,128,145,0,64,173,64,208,201,161,14,25,0,64,208,
64,154,64,208,128,159,0,72,159,8,64,208,128,152,0,128,154,0,128,162,0,64,
161,64,208,202,158,83,1,224,0,64,208,201,158,18,42,0,64,208,72,152,8,64,
208,128,167,0,128,148,0,137,155,5,17,0,200,154,9,0,64,208,128,158,0,128,
148,0,64,156,64,208,128,161,0,137,168,5,26,0,200,162,9,0,64,208,128,158,
0,192,159,0,64,208,136,162,4,0,128,146,0,64,173,64,208,128,161,0,73,150,
13,210,64,208,136,164,4,0,128,148,0,201,147,34,154,0,64,208,137,157,5,16,
0,137,147,5,8,0,128,144,0,128,152,0,72,159,8,64,208,128,159,0,128,158,0,
201,145,53,77,0,64,208,137,157,5,26,0,201,154,10,13,0,64,208,128,160,0,
128,152,0,192,156,0,64,208,128,163,0,137,162,5,17,0,192,158,0,64,208,64,
148,64,208,128,161,0,128,163,0,192,144,0,64,208,137,158,5,12,0,136,150,
4,0,128,147,0,136,162,4,0,128,159,0,64,146,64,208,137,161,5,20,0,137,159,
5,12,0,136,152,4,0,128,151,0,128,160,0,137,165,5,16,0,136,163,4,0,64,162,
64,208,128,161,0,128,175,0,72,149,24,64,208,137,150,5,16,0,64,145,64,208,
64,163,64,208,128,164,0,128,154,0,64,148,64,208,137,154,5,12,0,136,150,
4,0,128,144,0,128,162,0,73,155,13,132,64,208,136,157,4,0,128,156,0,73,152,
34,45,64,208,137,162,5,20,0,72,152,12,64,208,136,163,4,0,128,148,0,128,
151,0,192,164,0,64,208,128,157,0,64,151,64,208,136,157,4,0,128,152,0,192,
154,0,64,208,201,158,10,37,0,64,208,128,163,0,137,151,5,12,0,136,147,4,
0,128,145,0,72,157,8,64,208,128,161,0,64,155,64,208,128,161,0,137,164,5,
21,0,72,162,8,64,208,128,146,0,192,160,0,64,208,128,159,0,136,166,4,0,64,
165,64,208,128,158,0,72,157,36,64,208,73,162,9,24,64,208,128,152,0,73,160,
9,12,64,208,128,163,0,128,154,0,128,161,0,136,165,4,0,128,163,0,64,156,
64,208,137,157,5,12,0,136,154,4,0,128,146,0,128,161,0,202,165,32,1,93,0,
64,208,137,164,5,21,0,200,159,9,0,64,208,128,159,0,64,152,64,208,128,159,
0,128,168,0,73,162,25,236,64,208,73,159,9,16,64,208,128,165,0,136,158,4,
0,128,154,0,128,160,0,73,160,49,113,64,208,73,159,9,28,64,208,128,144,0,
73,156,13,16,64,208,64,146,64,208,128,160,0,128,146,0,128,157,0,137,161,
5,12,0,64,160,64,208,128,145,0,128,162,0,192,159,0,64,208,201,159,10,34,
0,64,208,128,157,0,137,157,5,12,0,136,152,4,0,128,144,0,192,158,0,64,208,
64,158,64,208,128,159,0,137,163,5,22,0,200,162,9,0,64,208,128,152,0,192,
161,0,64,208,128,161,0,128,166,0,192,161,0,64,208,73,159,17,58,64,208,136,
158,4,0,64,152,64,208,128,160,0,137,151,5,26,0,201,148,10,18,0,64,208,128,
159,0,192,145,0,64,208,128,144,0,128,150,0,136,158,4,0,64,156,64,208,136,
168,4,0,128,161,0,73,163,13,24,64,208,64,158,64,208,128,160,0,72,161,8,
64,208,128,148,0,128,160,0,72,168,8,64,208,128,156,0,128,165,0,72,164,45,
64,208,137,156,5,16,0,136,151,4,0,64,147,64,208,128,157,0,200,158,21,0,
64,208,72,158,8,64,208,128,161,0,64,147,64,208,128,161,0,128,157,0,192,
163,0,64,208,73,158,9,20,64,208,128,145,0,137,148,5,8,0,128,144,0,128,155,
0,136,166,4,0,64,160,64,208,128,147,0,201,173,43,75,0,64,208,137,156,5,
20,0,137,152,5,12,0,136,151,4,0,128,145,0,128,154,0,137,163,5,13,0,192,
161,0,64,208,128,161,0,128,164,0,201,167,18,21,0,64,208,72,159,8,64,208,
128,165,0,128,156,0,128,166,0,64,168,64,208,64,161,64,208,128,162,0,72,
175,8,64,208,128,161,0,64,174,64,208,128,152,0,82,164,1,228,3,225,64,208,
73,158,35,250,64,208,73,156,9,26,64,208,128,161,0,192,154,0,64,208,192,
154,0,64,208,64,154,64,208,128,159,0,128,158,0,201,150,10,111,0,64,208,
128,154,0,73,147,17,82,64,208,137,158,5,8,0,128,152,0,128,161,0,201,145,
27,62,0,64,208,136,150,4,0,192,144,0,64,208,136,163,4,0,64,157,64,208,128,
154,0,64,144,64,208,73,155,9,20,64,208,128,159,0,137,152,5,8,0,128,144,
0,128,154,0,136,164,4,0,64,161,64,208,128,156,0,128,146,0,72,149,12,64,
208,64,159,64,208,128,157,0,64,148,64,208,128,158,0,201,155,18,93,0,64,
208,137,148,5,8,0,128,147,0,128,161,0,201,152,39,51,0,64,208,201,161,10,
29,0,64,208,128,162,0,72,154,12,64,208,64,148,64,208,128,161,0,64,144,64,
208,128,145,0,128,162,0,192,151,0,64,208,64,158,64,208,128,161,0,192,154,
0,64,208,73,145,9,16,64,208,128,163,0,64,144,64,208,128,152,0,128,154,0,
136,157,4,0,64,156,64,208,128,154,0,137,165,5,186,0,73,162,29,137,64,208,
137,161,5,16,0,137,152,5,8,0,128,134,0,128,160,0,136,166,4,0,128,163,0,
201,160,27,76,0,64,208,137,164,5,17,0,200,161,9,0,64,208,128,165,0,128,
147,0,128,175,0,192,159,0,64,208,73,156,9,29,64,208,128,159,0,201,152,10,
17,0,64,208,128,162,0,136,147,4,0,128,144,0,128,154,0,137,164,5,12,0,136,
163,4,0,128,161,0,128,167,0,64,161,64,208,137,155,5,12,0,136,152,4,0,128,
144,0,136,162,4,0,192,160,0,64,208,64,147,64,208,128,161,0,72,164,36,64,
208,137,154,5,24,0,72,152,16,64,208,136,161,4,0,64,152,64,208,128,161,0,
128,145,0,136,168,4,0,128,158,0,192,163,0,64,208,128,161,0,73,173,13,29,
64,208,136,154,4,0,128,152,0,136,168,4,0,192,166,0,64,208,136,159,4,0,128,
152,0,136,175,4,0,64,174,64,208,128,144,0,64,163,64,208,74,157,30,1,40,
64,208,73,162,13,20,64,208,64,162,64,208,128,160,0,64,148,64,208,128,156,
0,128,166,0,73,150,50,190,64,208,73,160,13,29,64,208,64,173,64,208,128,
159,0,72,154,8,64,208,128,159,0,192,146,0,64,208,128,151,0,64,173,64,208,
72,160,8,64,208,128,159,0,128,159,0,73,146,33,92,64,208,137,156,5,20,0,
137,148,5,8,0,128,147,0,64,154,64,208,128,159,0,136,162,4,0,128,159,0,72,
145,44,64,208,73,157,9,32,64,208,128,162,0,136,154,4,0,64,152,64,208,137,
159,5,12,0,64,157,64,208,128,162,0,128,163,0,136,163,4,0,128,160,0,64,144,
64,208,72,162,8,64,208,128,159,0,128,160,0,72,148,25,64,208,72,160,12,64,
208,64,173,64,208,128,159,0,192,158,0,64,208,128,148,0,64,147,64,208,137,
163,5,16,0,64,152,64,208,64,161,64,208,128,158,0,128,165,0,73,154,17,52,
64,208,64,145,64,208,64,158,64,208,128,159,0,72,152,16,64,208,137,152,5,
8,0,128,145,0,128,166,0,64,151,64,208,64,158,64,208,64,145,64,208,64,158,
64,208,128,151,0,192,156,0,64,208,137,162,5,8,0,128,159,0,64,166,64,208,
64,164,64,208,128,156,0,73,163,13,161,64,208,136,160,4,0,128,158,0,201,
161,51,128,0,64,208,73,162,9,33,64,208,128,158,0,73,158,9,16,64,208,128,
154,0,64,151,64,208,128,157,0,192,159,0,64,208,128,159,0,136,173,4,0,64,
163,64,208,128,146,0,72,160,16,64,208,72,173,8,64,208,128,159,0,128,151,
0,192,159,0,64,208,73,158,9,37,64,208,128,157,0,201,154,10,25,0,64,208,
128,152,0,64,150,64,208,136,165,4,0,64,154,64,208,128,165,0,128,157,0,72,
173,8,64,208,128,159,0,64,162,64,208,136,152,4,0,128,146,0,64,162,64,208,
137,161,5,8,0,128,160,0,192,162,0,64,208,128,159,0,73,173,21,45,64,208,
137,161,5,12,0,136,154,4,0,128,147,0,128,162,0,72,166,8,64,208,128,144,
0,192,164,0,64,208,137,158,5,8,0,128,151,0,128,159,0,128,175,0,64,165,64,
208,201,155,14,50,0,64,208,64,152,64,208,128,147,0,201,147,10,25,0,64,208,
128,144,0,72,146,8,64,208,128,148,0,64,144,64,208,128,162,0,136,154,4,0,
64,148,64,208,128,161,0,73,163,13,54,64,208,64,159,64,208,128,152,0,200,
162,17,0,64,208,137,152,5,8,0,128,148,0,128,162,0,64,159,64,208,200,154,
17,0,64,208,64,162,64,208,64,152,64,208,128,148,0,128,152,0,136,167,4,0,
64,164,64,208,64,159,64,208,128,167,0,82,173,1,114,2,17,64,208,201,158,
18,211,0,64,208,137,160,5,8,0,128,154,0,128,164,0,201,150,10,71,0,64,208,
128,154,0,73,146,9,30,64,208,128,159,0,200,145,9,0,64,208,128,159,0,192,
144,0,64,208,64,156,64,208,128,151,0,72,148,16,64,208,136,158,4,0,64,152,
64,208,128,161,0,64,147,64,208,137,154,5,8,0,128,152,0,128,163,0,201,154,
14,50,0,64,208,64,158,64,208,128,156,0,200,152,33,0,64,208,137,161,5,20,
0,72,157,8,64,208,128,161,0,64,156,64,208,128,158,0,64,167,64,208,128,161,
0,128,151,0,72,156,49,64,208,201,160,10,25,0,64,208,128,151,0,137,158,5,
12,0,136,154,4,0,128,151,0,128,159,0,137,162,5,8,0,128,161,0,64,164,64,
208,64,152,64,208,128,161,0,64,155,64,208,73,158,9,16,64,208,128,160,0,
136,152,4,0,128,151,0,128,161,0,137,165,5,107,0,201,161,27,54,0,64,208,
137,156,5,17,0,136,155,4,0,192,152,0,64,208,128,162,0,128,161,0,72,160,
12,64,208,136,162,4,0,128,156,0,64,159,64,208,137,160,5,8,0,128,152,0,128,
163,0,200,164,9,0,64,208,128,152,0,64,162,64,208,137,156,5,24,0,136,154,
4,0,64,152,64,208,64,152,64,208,64,161,64,208,128,161,0,136,164,4,0,64,
163,64,208,128,154,0,73,173,13,37,64,208,136,163,4,0,128,154,0,200,168,
17,0,64,208,64,148,64,208,64,158,64,208,128,156,0,64,167,64,208,128,161,
0,64,174,64,208,128,151,0,73,168,96,140,64,208,201,159,14,54,0,64,208,136,
152,4,0,128,148,0,137,148,5,29,0,72,147,12,64,208,136,163,4,0,128,145,0,
192,145,0,64,208,64,164,64,208,128,144,0,72,156,8,64,208,128,158,0,128,
151,0,201,163,10,25,0,64,208,128,145,0,136,162,4,0,64,161,64,208,64,173,
64,208,128,157,0,136,173,4,0,64,165,64,208,128,160,0,192,167,0,64,208,137,
160,5,28,0,73,157,13,20,64,208,64,154,64,208,128,144,0,136,154,4,0,128,
144,0,128,159,0,137,166,5,8,0,128,161,0,128,173,0,64,169,64,208,73,154,
9,12,64,208,128,162,0,128,151,0,128,163,0,72,175,8,64,208,128,166,0,192,
174,0,64,208,137,158,5,16,0,137,151,5,8,0,128,148,0,128,152,0,136,166,4,
0,128,162,0,64,76,64,208,128,156,0,64,155,64,208,210,158,2,88,13,231,0,
64,208,74,158,42,1,95,64,208,73,156,9,20,64,208,128,159,0,72,152,8,64,208,
128,160,0,128,148,0,136,159,4,0,64,158,64,208,64,152,64,208,128,160,0,73,
152,58,178,64,208,201,159,14,37,0,64,208,64,159,64,208,128,158,0,137,152,
5,8,0,128,144,0,64,154,64,208,64,164,64,208,64,163,64,208,128,157,0,72,
173,8,64,208,128,164,0,64,160,64,208,128,158,0,73,148,21,109,64,208,73,
154,9,12,64,208,128,145,0,128,145,0,128,163,0,72,147,72,64,208,73,158,53,
64,64,208,72,160,28,64,208,64,152,64,208,64,162,64,208,64,156,64,208,64,
152,64,208,64,154,64,208,128,144,0,64,159,64,208,64,163,64,208,64,157,64,
208,64,154,64,208,128,162,0,136,147,4,0,64,144,64,208,128,146,0,128,163,
0,64,146,64,208,136,156,4,0,192,148,0,64,208,128,162,0,64,151,64,208,64,
157,64,208,128,144,0,73,156,21,108,64,208,73,155,9,12,64,208,128,161,0,
128,151,0,128,158,0,72,155,12,64,208,64,134,64,208,128,162,0,64,154,64,
208,73,152,9,36,64,208,128,161,0,73,146,13,24,64,208,64,163,64,208,128,
154,0,136,145,4,0,64,144,64,208,128,164,0,128,148,0,73,159,9,32,64,208,
128,159,0,72,158,12,64,208,136,161,4,0,128,148,0,64,154,64,208,64,152,64,
208,128,152,0,128,161,0,64,157,64,208,136,159,4,0,64,152,64,208,64,152,
64,208,136,161,4,0,128,160,0,73,163,53,184,64,208,73,157,9,32,64,208,128,
145,0,64,156,64,208,72,166,16,64,208,64,154,64,208,64,152,64,208,128,152,
0,128,159,0,64,173,64,208,72,161,8,64,208,128,154,0,128,154,0,73,161,69,
116,64,208,73,158,9,44,64,208,128,148,0,73,156,9,20,64,208,128,158,0,64,
148,64,208,64,157,64,208,128,158,0,64,157,64,208,72,162,8,64,208,128,158,
0,128,156,0,73,161,9,16,64,208,128,165,0,64,159,64,208,128,158,0,128,165,
0,72,160,20,64,208,73,158,9,12,64,208,128,157,0,128,154,0,128,159,0,64,
159,64,208,137,148,5,20,0,64,144,64,208,72,157,8,64,208,128,172,0,128,145,
0,128,167,0,64,162,64,208,72,159,8,64,208,128,159,0,128,154,0,201,166,18,
33,0,64,208,136,164,4,0,64,152,64,208,128,144,0,64,164,64,208,64,158,64,
208,64,156,64,208,128,161,0,64,173,64,208,73,161,9,12,64,208,128,154,0,
128,151,0,64,162,64,208,128,151,0,202,150,24,6,133,0,64,208,137,154,5,13,
0,192,146,0,64,208,128,161,0,128,161,0,74,146,232,3,73,64,208,201,158,10,
160,0,64,208,128,154,0,201,151,30,93,0,64,208,72,160,12,64,208,64,154,64,
208,128,163,0,64,144,64,208,64,154,64,208,128,163,0,137,149,5,60,0,72,146,
32,64,208,137,154,5,20,0,64,152,64,208,72,163,8,64,208,128,161,0,128,144,
0,64,159,64,208,128,163,0,64,144,64,208,73,162,9,16,64,208,128,163,0,64,
154,64,208,128,163,0,128,163,0,128,150,0,201,156,34,50,0,64,208,73,154,
9,16,64,208,128,148,0,136,152,4,0,128,145,0,136,163,4,0,64,159,64,208,128,
163,0,192,152,0,64,208,72,156,8,64,208,128,163,0,128,154,0,64,157,64,208,
128,148,0,73,162,9,54,64,208,128,144,0,73,160,9,37,64,208,128,151,0,192,
159,0,64,208,137,166,5,20,0,64,163,64,208,64,160,64,208,64,161,64,208,128,
162,0,128,168,0,192,161,0,64,208,128,173,0,137,167,5,8,0,128,163,0,128,
173,0,82,144,2,2,2,61,64,208,73,157,21,237,64,208,137,155,5,12,0,64,152,
64,208,128,162,0,128,158,0,73,149,9,76,64,208,128,161,0,73,145,25,40,64,
208,72,152,12,64,208,64,164,64,208,128,160,0,64,144,64,208,128,154,0,72,
144,12,64,208,136,161,4,0,128,152,0,128,134,0,136,147,4,0,64,146,64,208,
73,149,9,16,64,208,128,153,0,136,148,4,0,128,145,0,128,161,0,73,153,21,
93,64,208,64,162,64,208,64,154,64,208,64,158,64,208,128,156,0,72,152,20,
64,208,137,159,5,12,0,136,151,4,0,128,148,0,128,160,0,192,151,0,64,208,
72,156,8,64,208,128,144,0,64,149,64,208,64,160,64,208,64,158,64,208,64,
162,64,208,64,149,64,208,64,160,64,208,64,144,64,208,64,159,64,208,64,152,
64,208,128,175,0,72,156,20,64,208,136,161,4,0,64,144,64,208,64,157,64,208,
128,168,0,64,154,64,208,137,159,5,16,0,72,156,8,64,208,128,144,0,128,145,
0,64,160,64,208,128,152,0,73,164,21,230,64,208,72,167,8,64,208,128,165,
0,64,162,64,208,128,158,0,73,161,57,121,64,208,73,159,9,24,64,208,128,158,
0,72,156,12,64,208,64,149,64,208,128,162,0,128,151,0,72,163,8,64,208,128,
151,0,64,162,64,208,64,160,64,208,64,144,64,208,64,148,64,208,128,144,0,
72,160,29,64,208,137,158,5,21,0,200,157,9,0,64,208,128,147,0,64,147,64,
208,128,149,0,128,162,0,64,159,64,208,73,160,13,24,64,208,64,175,64,208,
128,155,0,136,159,4,0,64,152,64,208,128,154,0,64,173,64,208,128,154,0,72,
163,12,64,208,64,158,64,208,128,162,0,64,162,64,208,137,158,5,49,0,201,
147,34,37,0,64,208,64,158,64,208,64,161,64,208,64,152,64,208,64,151,64,
208,64,148,64,208,64,144,64,208,128,162,0,128,145,0,64,152,64,208,128,156,
0,72,163,20,64,208,72,151,8,64,208,128,144,0,64,147,64,208,128,144,0,128,
160,0,73,167,9,20,64,208,128,165,0,136,166,4,0,64,165,64,208,128,163,0,
72,173,8,64,208,128,161,0,64,168,64,208,64,158,64,208,128,160,0,64,134,
64,208,73,159,13,28,64,208,64,161,64,208,128,162,0,72,156,8,64,208,128,
158,0,64,149,64,208,128,162,0,64,161,64,208,72,158,8,64,208,128,148,0,64,
147,64,208,64,158,64,208,64,161,64,208,128,159,0,64,145,64,208,137,156,
5,21,0,137,147,5,13,0,192,146,0,64,208,128,163,0,128,151,0,72,165,8,64,
208,128,151,0,128,158,0,74,148,212,1,216,64,208,137,156,5,74,0,73,147,9,
49,64,208,128,145,0,201,144,18,29,0,64,208,136,163,4,0,64,152,64,208,128,
161,0,64,134,64,208,64,154,64,208,128,156,0,64,146,64,208,136,166,4,0,128,
159,0,73,152,9,12,64,208,128,161,0,128,150,0,192,154,0,64,208,128,144,0,
201,161,18,78,0,64,208,137,159,5,8,0,128,144,0,128,163,0,73,158,13,28,64,
208,64,173,64,208,128,163,0,64,157,64,208,136,169,4,0,64,162,64,208,128,
159,0,192,159,0,64,208,73,161,9,20,64,208,128,161,0,137,147,5,8,0,128,145,
0,128,160,0,136,175,4,0,128,163,0,201,164,14,45,0,64,208,136,152,4,0,128,
144,0,64,163,64,208,73,146,9,20,64,208,128,161,0,64,145,64,208,64,150,64,
208,128,148,0,64,164,64,208,128,154,0,192,166,0,64,208,128,145,0,192,147,
0,64,208,73,158,17,151,64,208,137,156,5,8,0,128,154,0,128,158,0,73,152,
51,82,64,208,73,157,13,30,64,208,64,162,64,208,128,163,0,200,154,9,0,64,
208,128,152,0,192,144,0,64,208,128,173,0,64,162,64,208,64,156,64,208,64,
152,64,208,128,154,0,73,150,9,28,64,208,128,162,0,136,148,4,0,64,144,64,
208,136,163,4,0,64,160,64,208,128,151,0,128,151,0,201,156,14,37,0,64,208,
136,163,4,0,128,152,0,64,154,64,208,137,161,5,12,0,136,159,4,0,128,154,
0,64,173,64,208,128,162,0,64,157,64,208,64,159,64,208,64,146,64,208,128,
154,0,73,164,13,77,64,208,136,159,4,0,128,152,0,73,162,21,44,64,208,137,
161,5,12,0,64,160,64,208,128,166,0,128,163,0,72,160,12,64,208,136,154,4,
0,128,147,0,64,159,64,208,136,163,4,0,128,154,0,192,163,0,64,208,72,164,
8,64,208,128,154,0,64,146,64,208,128,148,0,73,166,13,20,64,208,64,160,64,
208,128,162,0,64,165,64,208,128,154,0,64,173,64,208,128,154,0,64,149,64,
208,73,155,9,144,64,208,128,166,0,73,147,61,120,64,208,73,159,17,44,64,
208,64,160,64,208,64,158,64,208,128,156,0,64,154,64,208,64,158,64,208,64,
144,64,208,64,162,64,208,64,155,64,208,64,149,64,208,128,162,0,64,160,64,
208,64,144,64,208,128,157,0,72,146,28,64,208,64,145,64,208,64,149,64,208,
64,160,64,208,64,148,64,208,64,158,64,208,128,157,0,64,145,64,208,72,158,
8,64,208,128,157,0,64,149,64,208,64,160,64,208,64,148,64,208,64,158,64,
208,128,157,0,64,154,64,208,64,159,64,208,64,158,64,208,128,156,0,73,157,
154,181,64,208,73,154,13,60,64,208,64,158,64,208,128,156,0,73,147,21,36,
64,208,64,152,64,208,64,160,64,208,64,148,64,208,128,149,0,64,146,64,208,
136,158,4,0,64,156,64,208,128,145,0,64,151,64,208,64,158,64,208,128,161,
0,73,158,50,69,64,208,72,162,8,64,208,128,160,0,64,145,64,208,192,155,0,
64,208,72,161,12,64,208,64,163,64,208,128,148,0,64,144,64,208,64,161,64,
208,64,162,64,208,128,172,0,64,157,64,208,64,152,64,208,64,152,64,208,64,
155,64,208,128,165,0,64,162,64,208,64,152,64,208,64,161,64,208,64,152,64,
208,128,151,0,64,156,64,208,72,158,16,64,208,64,157,64,208,64,162,64,208,
128,152,0,64,144,64,208,128,151,0,128,164,0,202,155,51,3,197,0,64,208,73,
157,9,32,64,208,128,148,0,137,147,5,16,0,136,145,4,0,64,134,64,208,128,
156,0,64,156,64,208,128,151,0,137,166,5,8,0,128,160,0,128,167,0,82,152,
2,20,2,166,64,208,74,159,26,1,67,64,208,73,159,9,16,64,208,128,158,0,64,
144,64,208,128,157,0,128,173,0,201,152,58,121,0,64,208,73,154,9,36,64,208,
128,161,0,73,147,13,20,64,208,64,146,64,208,128,164,0,64,146,64,208,128,
162,0,64,150,64,208,128,162,0,72,159,8,64,208,128,161,0,64,156,64,208,128,
159,0,73,146,13,56,64,208,136,175,4,0,128,162,0,72,145,20,64,208,73,154,
9,12,64,208,128,158,0,128,147,0,128,157,0,64,144,64,208,137,159,5,12,0,
136,151,4,0,128,147,0,64,173,64,208,128,160,0,64,149,64,208,128,157,0,73,
157,73,161,64,208,137,161,5,44,0,73,152,17,24,64,208,72,160,8,64,208,128,
160,0,128,154,0,64,144,64,208,128,155,0,64,154,64,208,64,158,64,208,136,
161,4,0,128,160,0,72,173,12,64,208,64,154,64,208,128,161,0,64,162,64,208,
64,149,64,208,128,165,0,72,156,61,64,208,201,161,10,17,0,64,208,128,165,
0,136,154,4,0,128,152,0,72,164,32,64,208,64,158,64,208,64,163,64,208,64,
151,64,208,64,155,64,208,136,171,4,0,64,158,64,208,128,146,0,64,162,64,
208,128,163,0,64,154,64,208,72,158,12,64,208,64,157,64,208,128,164,0,64,
144,64,208,64,160,64,208,128,148,0,64,158,64,208,64,155,64,208,64,152,64,
208,128,166,0,73,165,9,157,64,208,128,159,0,73,162,102,125,64,208,73,155,
9,77,64,208,128,159,0,73,152,33,57,64,208,64,157,64,208,64,161,64,208,64,
162,64,208,64,152,64,208,64,162,64,208,64,163,64,208,128,162,0,192,147,
0,64,208,64,144,64,208,64,151,64,208,64,149,64,208,64,162,64,208,128,144,
0,64,154,64,208,64,158,64,208,128,156,0,72,161,12,64,208,64,161,64,208,
128,160,0,64,156,64,208,128,158,0,72,161,8,64,208,128,160,0,64,160,64,208,
137,156,5,8,0,128,154,0,128,162,0,64,163,64,208,137,161,5,16,0,64,146,64,
208,64,173,64,208,128,154,0,128,162,0,201,173,22,37,0,64,208,137,161,5,
12,0,136,156,4,0,128,152,0,128,162,0,64,166,64,208,64,152,64,208,64,156,
64,208,128,161,0,64,175,64,208,128,164,0,64,151,64,208,201,160,14,78,0,
64,208,136,156,4,0,128,154,0,73,156,9,41,64,208,128,158,0,73,152,9,20,64,
208,128,148,0,64,146,64,208,64,146,64,208,128,145,0,192,154,0,64,208,136,
152,4,0,128,146,0,73,158,9,12,64,208,128,161,0,128,157,0,64,159,64,208,
136,154,4,0,128,148,0,73,164,9,53,64,208,128,152,0,73,162,13,41,64,208,
64,173,64,208,128,156,0,192,161,0,64,208,137,156,5,12,0,136,154,4,0,128,
152,0,136,164,4,0,64,158,64,208,128,156,0,128,163,0,136,168,4,0,64,165,
64,208,128,161,0,64,154,64,208,137,157,5,82,0,73,151,13,44,64,208,64,161,
64,208,128,156,0,73,146,9,20,64,208,128,148,0,64,144,64,208,136,158,4,0,
128,146,0,64,150,64,208,64,152,64,208,128,173,0,73,154,9,25,64,208,128,
151,0,192,152,0,64,208,64,152,64,208,64,151,64,208,128,161,0,192,156,0,
64,208,128,151,0,73,162,9,130,64,208,128,148,0,73,160,30,49,64,208,201,
158,14,17,0,64,208,64,161,64,208,128,161,0,128,152,0,64,161,64,208,128,
156,0,64,159,64,208,73,166,9,12,64,208,128,157,0,128,157,0,128,167,0,64,
161,64,208,201,156,34,57,0,64,208,137,155,5,16,0,137,145,5,8,0,128,144,
0,128,154,0,137,163,5,8,0,128,156,0,128,173,0,137,148,5,20,0,64,144,64,
208,64,152,64,208,64,158,64,208,128,162,0,128,152,0,72,173,8,64,208,128,
166,0,128,161,0,73,166,9,12,64,208,128,159,0,128,165,0,192,168,0,64,208,
128,159,0,200,157,224,0,64,208,73,159,46,167,64,208,137,158,5,16,0,137,
147,5,8,0,128,144,0,128,151,0,201,163,18,21,0,64,208,64,152,64,208,64,162,
64,208,128,168,0,128,161,0,128,173,0,73,148,21,57,64,208,137,160,5,12,0,
136,159,4,0,128,146,0,128,163,0,73,146,13,29,64,208,64,156,64,208,128,163,
0,136,145,4,0,192,144,0,64,208,136,163,4,0,128,156,0,64,147,64,208,128,
161,0,73,156,17,61,64,208,137,158,5,8,0,128,144,0,128,163,0,200,154,9,0,
64,208,128,158,0,64,152,64,208,137,159,5,20,0,64,152,64,208,72,164,8,64,
208,128,154,0,128,159,0,64,161,64,208,64,156,64,208,128,161,0,128,158,0,
137,165,5,36,0,137,163,5,24,0,72,162,16,64,208,137,154,5,8,0,128,152,0,
128,163,0,128,160,0,64,164,64,208,128,156,0,137,168,5,8,0,128,167,0,64,
173,64,208,128,152,0,64,156,64,208,137,154,5,61,0,201,148,18,41,0,64,208,
136,164,4,0,64,161,64,208,128,162,0,72,146,16,64,208,64,146,64,208,64,152,
64,208,128,157,0,64,144,64,208,128,161,0,72,152,12,64,208,64,161,64,208,
128,152,0,128,151,0,73,161,13,25,64,208,64,157,64,208,128,161,0,200,156,
9,0,64,208,128,161,0,128,155,0,136,165,4,0,64,162,64,208,128,159,0,74,166,
76,4,30,64,208,73,159,21,40,64,208,72,167,12,64,208,64,173,64,208,128,152,
0,128,152,0,137,152,5,16,0,136,148,4,0,64,147,64,208,128,145,0,128,154,
0,201,161,18,26,0,64,208,72,156,8,64,208,128,173,0,128,152,0,192,160,0,
64,208,128,145,0,128,163,0,74,162,157,2,185,64,208,201,159,10,87,0,64,208,
128,161,0,137,151,5,28,0,73,149,9,16,64,208,128,154,0,64,148,64,208,128,
148,0,64,150,64,208,128,162,0,201,154,10,30,0,64,208,128,151,0,192,152,
0,64,208,72,165,8,64,208,128,159,0,64,159,64,208,128,159,0,64,158,64,208,
64,156,64,208,64,144,64,208,64,157,64,208,128,163,0,73,163,9,48,64,208,
128,164,0,73,161,17,28,64,208,137,158,5,8,0,128,151,0,128,162,0,64,160,
64,208,136,166,4,0,128,156,0,64,162,64,208,64,160,64,208,128,151,0,137,
166,5,8,0,128,165,0,64,173,64,208,128,152,0,74,160,101,1,80,64,208,137,
160,5,36,0,137,157,5,16,0,136,154,4,0,64,144,64,208,128,161,0,72,159,12,
64,208,136,163,4,0,128,151,0,128,158,0,73,163,13,42,64,208,64,144,64,208,
128,161,0,200,162,17,0,64,208,64,159,64,208,136,166,4,0,128,159,0,192,161,
0,64,208,64,151,64,208,128,166,0,192,166,0,64,208,64,158,64,208,64,175,
64,208,128,158,0,64,159,64,208,73,157,13,82,64,208,136,148,4,0,128,144,
0,201,148,14,41,0,64,208,136,161,4,0,128,159,0,73,146,13,24,64,208,136,
156,4,0,128,148,0,72,145,8,64,208,128,163,0,128,134,0,128,147,0,137,154,
5,17,0,136,152,4,0,192,151,0,64,208,128,159,0,64,156,64,208,136,155,4,0,
128,152,0,73,162,14,83,64,208,192,163,0,64,208,128,161,0,201,160,18,50,
0,64,208,72,158,8,64,208,128,157,0,128,157,0,200,159,13,0,64,208,136,155,
4,0,128,144,0,64,158,64,208,72,158,8,64,208,128,161,0,64,154,64,208,128,
152,0,64,161,64,208,137,155,5,8,0,128,145,0,64,156,64,208,128,158,0,201,
173,34,63,0,64,208,73,157,9,16,64,208,128,159,0,64,146,64,208,128,148,0,
64,163,64,208,64,162,64,208,128,161,0,200,165,9,0,64,208,128,159,0,192,
163,0,64,208,136,159,4,0,64,156,64,208,136,162,4,0,128,147,0,128,175,0,
192,161,0,64,208,73,157,9,95,64,208,128,146,0,137,150,5,58,0,201,147,18,
29,0,64,208,72,156,8,64,208,128,152,0,128,144,0,136,146,4,0,64,144,64,208,
128,162,0,64,148,64,208,73,160,9,17,64,208,128,159,0,192,159,0,64,208,128,
168,0,128,164,0,137,154,5,21,0,72,152,8,64,208,128,154,0,192,151,0,64,208,
128,166,0,64,156,64,208,128,154,0,73,162,17,81,64,208,72,162,8,64,208,128,
161,0,128,154,0,73,160,9,45,64,208,128,159,0,72,159,20,64,208,72,160,8,
64,208,128,154,0,64,157,64,208,128,163,0,192,158,0,64,208,137,159,5,8,0,
128,152,0,128,163,0,64,161,64,208,137,165,5,12,0,136,160,4,0,128,159,0,
128,166,0,137,165,5,20,0,72,164,8,64,208,128,155,0,64,163,64,208,128,154,
0,128,173,0,73,164,124,212,64,208,201,159,10,62,0,64,208,128,147,0,137,
152,5,29,0,73,146,9,21,64,208,128,173,0,200,145,9,0,64,208,128,161,0,128,
144,0,128,151,0,137,155,5,8,0,128,154,0,64,156,64,208,137,162,5,8,0,128,
152,0,128,168,0,201,167,10,33,0,64,208,128,165,0,137,163,5,20,0,72,162,
8,64,208,128,152,0,64,161,64,208,128,163,0,128,165,0,73,173,9,12,64,208,
128,152,0,128,168,0,64,175,64,208,64,161,64,208,128,162,0,64,163,64,208,
73,160,9,49,64,208,128,146,0,73,151,13,33,64,208,64,158,64,208,128,148,
0,72,146,13,64,208,192,148,0,64,208,128,162,0,64,144,64,208,128,151,0,64,
157,64,208,128,166,0,73,162,21,32,64,208,137,166,5,8,0,128,155,0,64,173,
64,208,128,154,0,64,161,64,208,64,173,64,208,128,147,0,128,173,0,64,165,
64,208,73,162,18,46,64,208,192,152,0,64,208,64,156,64,208,128,159,0,73,
152,9,20,64,208,128,162,0,136,147,4,0,64,146,64,208,128,161,0,192,155,0,
64,208,128,150,0,73,166,9,16,64,208,128,150,0,64,164,64,208,128,152,0,128,
173,0,74,173,217,1,39,64,208,201,159,10,97,0,64,208,128,158,0,73,152,17,
44,64,208,72,165,8,64,208,128,144,0,128,161,0,73,147,17,24,64,208,136,152,
4,0,64,146,64,208,128,161,0,64,146,64,208,128,161,0,128,151,0,73,156,25,
40,64,208,137,152,5,12,0,136,151,4,0,128,145,0,136,162,4,0,128,161,0,64,
154,64,208,72,161,8,64,208,128,164,0,128,160,0,128,158,0,201,163,10,98,
0,64,208,128,154,0,73,161,29,40,64,208,73,156,9,16,64,208,128,152,0,136,
154,4,0,128,152,0,136,159,4,0,128,158,0,64,160,64,208,136,163,4,0,128,156,
0,64,162,64,208,137,161,5,29,0,200,152,21,0,64,208,136,161,4,0,64,152,64,
208,64,161,64,208,128,161,0,128,151,0,64,163,64,208,64,144,64,208,64,155,
64,208,128,172,0,72,173,8,64,208,128,155,0,64,164,64,208,128,152,0,73,168,
41,70,64,208,137,161,5,24,0,137,156,5,12,0,64,152,64,208,128,159,0,64,159,
64,208,128,148,0,72,174,8,64,208,128,159,0,128,173,0,192,167,0,64,208,73,
159,9,21,64,208,128,164,0,192,156,0,64,208,136,162,4,0,128,147,0,128,165,
0,192,169,0,64,208,128,159,0,72,175,8,64,208,128,160,0,64,174,64,208,64,
145,64,208,64,173,64,208,64,154,64,208,64,158,64,208,128,159,0,64,157,64,
208,210,157,1,22,28,45,0,64,208,73,158,13,174,64,208,64,161,64,208,128,
157,0,73,152,65,110,64,208,137,158,5,44,0,72,154,12,64,208,64,146,64,208,
128,152,0,64,152,64,208,73,160,9,16,64,208,128,162,0,64,159,64,208,128,
154,0,64,162,64,208,128,158,0,136,168,4,0,64,160,64,208,64,166,64,208,128,
163,0,201,147,22,38,0,64,208,73,160,9,12,64,208,128,159,0,128,154,0,128,
173,0,72,146,8,64,208,128,154,0,192,145,0,64,208,128,145,0,64,150,64,208,
128,154,0,73,156,17,32,64,208,136,166,4,0,64,148,64,208,128,147,0,72,155,
8,64,208,128,158,0,64,154,64,208,128,166,0,64,157,64,208,137,159,5,12,0,
64,157,64,208,128,148,0,128,167,0,137,164,5,72,0,73,161,9,60,64,208,128,
159,0,72,160,12,64,208,64,162,64,208,128,154,0,64,159,64,208,137,164,5,
24,0,136,159,4,0,64,158,64,208,64,161,64,208,64,156,64,208,128,159,0,64,
166,64,208,64,162,64,208,128,158,0,64,163,64,208,128,173,0,73,166,9,16,
64,208,128,157,0,64,165,64,208,128,155,0,64,173,64,208,128,152,0,74,149,
238,11,184,64,208,73,157,9,112,64,208,128,166,0,73,150,13,48,64,208,64,
148,64,208,128,152,0,72,146,24,64,208,64,149,64,208,64,160,64,208,64,165,
64,208,64,163,64,208,128,148,0,64,145,64,208,64,148,64,208,128,162,0,72,
155,16,64,208,72,166,8,64,208,128,163,0,128,154,0,64,151,64,208,72,157,
20,64,208,64,144,64,208,64,149,64,208,64,168,64,208,128,172,0,64,144,64,
208,64,167,64,208,64,162,64,208,128,158,0,73,162,17,56,64,208,64,173,64,
208,64,173,64,208,128,155,0,72,161,32,64,208,73,159,9,24,64,208,128,152,
0,64,154,64,208,64,144,64,208,64,150,64,208,128,163,0,128,162,0,64,160,
64,208,128,161,0,72,166,8,64,208,128,163,0,64,164,64,208,73,160,13,24,64,
208,64,144,64,208,128,161,0,136,154,4,0,64,144,64,208,128,151,0,64,162,
64,208,64,149,64,208,64,151,64,208,64,144,64,208,64,146,64,208,64,158,64,
208,128,148,0,74,145,194,6,110,64,208,73,160,13,120,64,208,136,154,4,0,
128,145,0,73,152,9,59,64,208,128,154,0,73,146,9,42,64,208,128,154,0,72,
145,8,64,208,128,161,0,192,144,0,64,208,137,158,5,12,0,64,156,64,208,128,
160,0,192,160,0,64,208,128,161,0,192,150,0,64,208,128,161,0,73,157,9,32,
64,208,128,154,0,72,156,8,64,208,128,154,0,64,154,64,208,137,158,5,8,0,
128,152,0,128,160,0,192,159,0,64,208,64,157,64,208,64,159,64,208,128,147,
0,201,165,10,35,0,64,208,128,158,0,137,163,5,22,0,200,162,9,0,64,208,128,
145,0,192,161,0,64,208,128,154,0,128,164,0,137,168,5,24,0,72,167,8,64,208,
128,160,0,64,166,64,208,64,147,64,208,128,152,0,192,173,0,64,208,128,152,
0,73,134,42,49,64,208,73,161,21,28,64,208,72,173,12,64,208,64,159,64,208,
128,148,0,128,148,0,64,144,64,208,128,151,0,192,162,0,64,208,128,157,0,
64,129,64,208,128,165,0,64,144,64,208,202,158,60,1,252,0,64,208,137,159,
5,33,0,201,156,10,21,0,64,208,128,144,0,64,150,64,208,64,154,64,208,128,
154,0,64,157,64,208,128,152,0,137,161,5,16,0,64,160,64,208,64,148,64,208,
128,152,0,128,163,0,73,150,13,237,64,208,64,145,64,208,128,159,0,73,147,
25,141,64,208,72,157,12,64,208,64,161,64,208,128,163,0,64,154,64,208,128,
160,0,73,145,25,69,64,208,73,148,9,12,64,208,128,148,0,128,146,0,64,160,
64,208,128,164,0,192,144,0,64,208,137,162,5,24,0,137,159,5,16,0,72,152,
8,64,208,128,160,0,128,147,0,128,160,0,137,166,5,12,0,136,164,4,0,128,163,
0,128,168,0,64,146,64,208,73,161,9,24,64,208,128,163,0,72,152,8,64,208,
128,156,0,64,148,64,208,128,163,0,136,173,4,0,64,162,64,208,64,149,64,208,
64,154,64,208,128,161,0,72,149,28,64,208,72,159,8,64,208,128,161,0,64,145,
64,208,64,144,64,208,64,157,64,208,128,154,0,64,148,64,208,137,162,5,40,
0,137,157,5,24,0,72,152,12,64,208,64,154,64,208,128,161,0,64,150,64,208,
128,162,0,64,159,64,208,64,161,64,208,128,163,0,137,164,5,8,0,128,163,0,
128,166,0,201,154,23,92,0,64,208,72,164,8,64,208,128,164,0,192,161,0,64,
208,128,163,0,72,152,50,64,208,137,159,5,21,0,201,152,10,13,0,64,208,128,
144,0,128,151,0,128,154,0,136,161,4,0,192,160,0,64,208,72,162,8,64,208,
128,161,0,64,152,64,208,128,162,0,64,151,64,208,72,159,8,64,208,128,159,
0,64,152,64,208,128,159,0,72,157,64,64,208,73,160,9,36,64,208,128,152,0,
73,158,17,20,64,208,64,162,64,208,64,149,64,208,128,165,0,128,145,0,64,
159,64,208,128,145,0,137,163,5,20,0,64,161,64,208,64,156,64,208,64,152,
64,208,128,162,0,128,166,0,64,156,64,208,73,158,17,44,64,208,64,152,64,
208,64,154,64,208,128,161,0,72,152,12,64,208,64,154,64,208,128,161,0,64,
144,64,208,64,154,64,208,64,158,64,208,128,157,0,136,166,4,0,128,159,0,
74,165,14,2,77,64,208,64,158,64,208,128,154,0,74,162,66,1,233,64,208,73,
155,9,16,64,208,128,159,0,136,154,4,0,128,145,0,64,163,64,208,64,160,64,
208,64,164,64,208,64,152,64,208,64,155,64,208,64,158,64,208,64,161,64,208,
64,158,64,208,64,164,64,208,64,152,64,208,128,175,0,82,160,1,18,1,120,64,
208,201,159,14,231,0,64,208,64,152,64,208,128,162,0,201,152,34,41,0,64,
208,72,162,8,64,208,128,154,0,64,161,64,208,64,163,64,208,64,153,64,208,
64,154,64,208,128,144,0,136,151,4,0,128,145,0,72,156,12,64,208,64,161,64,
208,128,159,0,64,154,64,208,72,158,149,64,208,201,156,94,129,0,64,208,73,
159,21,44,64,208,64,160,64,208,64,158,64,208,136,161,4,0,128,148,0,72,157,
12,64,208,64,144,64,208,128,166,0,64,151,64,208,64,149,64,208,128,156,0,
72,162,28,64,208,64,175,64,208,64,150,64,208,64,159,64,208,64,160,64,208,
64,158,64,208,128,156,0,64,161,64,208,64,157,64,208,64,144,64,208,128,145,
0,64,148,64,208,64,152,64,208,64,161,64,208,64,159,64,208,64,144,64,208,
64,157,64,208,64,161,64,208,64,149,64,208,128,160,0,64,159,64,208,64,158,
64,208,64,161,64,208,128,162,0,64,154,64,208,64,152,64,208,128,152,0,73,
165,13,32,64,208,64,158,64,208,128,151,0,72,162,8,64,208,128,161,0,64,161,
64,208,64,163,64,208,128,148,0,128,173,0,64,159,64,208,201,159,10,63,0,
64,208,128,147,0,137,156,5,33,0,72,154,21,64,208,201,158,10,13,0,64,208,
128,156,0,128,144,0,128,161,0,64,144,64,208,128,154,0,200,158,17,0,64,208,
136,158,4,0,64,155,64,208,128,144,0,128,157,0,137,163,5,24,0,72,162,8,64,
208,128,158,0,64,161,64,208,64,147,64,208,128,159,0,72,166,8,64,208,128,
157,0,128,164,0,64,161,64,208,73,159,13,28,64,208,64,166,64,208,128,157,
0,137,154,5,8,0,128,152,0,64,158,64,208,128,144,0,137,164,5,8,0,128,161,
0,64,173,64,208,128,148,0,200,164,22,0,64,208,72,159,8,64,208,128,154,0,
192,152,0,64,208,128,149,0,192,163,0,64,208,73,160,13,40,64,208,64,173,
64,208,128,159,0,73,156,13,20,64,208,64,152,64,208,128,160,0,64,152,64,
208,128,160,0,64,158,64,208,128,144,0,72,173,8,64,208,128,162,0,64,164,
64,208,64,158,64,208,128,160,0,74,173,52,1,31,64,208,137,157,5,29,0,137,
152,5,12,0,64,146,64,208,128,152,0,192,154,0,64,208,64,158,64,208,128,160,
0,136,162,4,0,192,161,0,64,208,64,156,64,208,128,152,0,72,167,28,64,208,
72,154,12,64,208,64,144,64,208,128,160,0,64,148,64,208,64,152,64,208,128,
146,0,64,166,64,208,73,158,9,120,64,208,128,162,0,73,152,69,100,64,208,
72,161,12,64,208,64,162,64,208,128,171,0,64,157,64,208,64,146,64,208,64,
149,64,208,64,161,64,208,64,162,64,208,64,159,64,208,64,160,64,208,64,158,
64,208,64,156,64,208,64,145,64,208,64,144,64,208,64,157,64,208,128,154,
0,64,145,64,208,72,149,16,64,208,72,161,8,64,208,128,162,0,128,151,0,64,
144,64,208,64,157,64,208,128,154,0,64,156,64,208,64,149,64,208,128,157,
0,72,160,40,64,208,64,171,64,208,64,145,64,208,64,160,64,208,64,149,64,
208,64,161,64,208,64,163,64,208,64,160,64,208,64,161,64,208,128,171,0,64,
159,64,208,64,160,64,208,64,158,64,208,72,156,20,64,208,64,145,64,208,64,
144,64,208,64,157,64,208,128,154,0,64,149,64,208,64,154,64,208,128,162,
0,72,175,8,64,208,128,145,0,64,174,64,208,128,162,0,82,147,2,44,3,47,64,
208,202,158,44,1,78,0,64,208,73,157,9,24,64,208,128,145,0,72,156,8,64,208,
128,151,0,64,148,64,208,128,145,0,192,163,0,64,208,64,157,64,208,128,145,
0,137,151,5,160,0,73,146,13,86,64,208,136,159,4,0,128,154,0,136,145,4,0,
192,144,0,64,208,137,163,5,45,0,201,161,14,21,0,64,208,136,163,4,0,128,
144,0,64,146,64,208,128,162,0,64,162,64,208,64,158,64,208,72,152,8,64,208,
128,145,0,128,145,0,72,173,12,64,208,64,152,64,208,128,163,0,64,165,64,
208,128,144,0,200,148,17,0,64,208,137,162,5,8,0,128,160,0,128,163,0,64,
147,64,208,73,156,9,20,64,208,128,159,0,136,152,4,0,64,151,64,208,128,154,
0,200,163,17,0,64,208,64,152,64,208,64,159,64,208,128,156,0,64,162,64,208,
136,154,4,0,128,152,0,201,155,10,91,0,64,208,128,163,0,200,154,17,0,64,
208,137,156,5,8,0,128,152,0,128,166,0,192,152,0,64,208,73,156,13,40,64,
208,64,152,64,208,128,159,0,73,152,9,24,64,208,128,147,0,136,147,4,0,64,
144,64,208,64,156,64,208,128,151,0,128,154,0,137,166,5,12,0,64,159,64,208,
128,147,0,64,173,64,208,128,152,0,64,156,64,208,137,154,5,20,0,137,151,
5,12,0,136,148,4,0,128,144,0,128,152,0,137,161,5,12,0,64,159,64,208,128,
154,0,128,163,0,73,164,9,177,64,208,128,160,0,201,161,30,103,0,64,208,73,
159,9,20,64,208,128,144,0,72,147,8,64,208,128,154,0,128,144,0,128,160,0,
72,160,17,64,208,192,173,0,64,208,64,152,64,208,128,161,0,64,159,64,208,
137,158,5,24,0,137,154,5,16,0,136,152,4,0,64,147,64,208,128,154,0,128,155,
0,137,166,5,25,0,200,163,13,0,64,208,64,152,64,208,128,156,0,64,159,64,
208,128,154,0,128,173,0,200,163,37,0,64,208,137,163,5,16,0,136,154,4,0,
64,144,64,208,128,154,0,64,173,64,208,136,163,4,0,64,152,64,208,128,163,
0,64,162,64,208,73,162,9,21,64,208,128,152,0,200,159,9,0,64,208,128,159,
0,128,152,0,128,163,0,137,168,5,29,0,72,166,8,64,208,128,162,0,192,165,
0,64,208,137,156,5,8,0,128,154,0,128,163,0,192,173,0,64,208,128,144,0,64,
146,64,208,73,156,13,170,64,208,136,163,4,0,128,145,0,73,151,17,106,64,
208,136,154,4,0,64,148,64,208,128,144,0,201,146,55,82,0,64,208,73,159,17,
41,64,208,136,163,4,0,64,158,64,208,128,163,0,72,154,13,64,208,192,163,
0,64,208,128,161,0,64,152,64,208,64,154,64,208,128,163,0,64,163,64,208,
128,162,0,72,145,12,64,208,64,165,64,208,128,156,0,64,144,64,208,72,173,
8,64,208,128,161,0,128,145,0,64,148,64,208,128,159,0,73,154,9,44,64,208,
128,146,0,64,152,64,208,73,156,9,24,64,208,128,163,0,137,152,5,12,0,64,
146,64,208,128,146,0,128,154,0,136,173,4,0,128,161,0,64,155,64,208,128,
155,0,73,161,13,65,64,208,136,159,4,0,128,158,0,73,159,17,41,64,208,136,
162,4,0,64,149,64,208,128,162,0,192,158,0,64,208,73,157,9,16,64,208,128,
160,0,64,154,64,208,128,163,0,128,161,0,64,160,64,208,136,159,4,0,128,151,
0,137,166,5,17,0,192,164,0,64,208,136,161,4,0,128,145,0,128,167,0,64,148,
64,208,73,157,13,133,64,208,136,148,4,0,128,147,0,73,150,9,76,64,208,128,
148,0,73,147,9,40,64,208,128,159,0,72,146,8,64,208,128,168,0,64,134,64,
208,72,161,8,64,208,128,149,0,64,145,64,208,136,154,4,0,128,146,0,72,149,
16,64,208,72,154,8,64,208,128,166,0,128,134,0,64,148,64,208,136,162,4,0,
128,152,0,73,155,9,37,64,208,128,156,0,72,154,16,64,208,137,158,5,8,0,128,
145,0,128,162,0,192,152,0,64,208,64,156,64,208,128,158,0,64,156,64,208,
128,147,0,137,163,5,125,0,201,160,18,81,0,64,208,137,161,5,8,0,128,153,
0,128,173,0,72,159,36,64,208,73,154,9,20,64,208,128,160,0,137,147,5,8,0,
128,144,0,128,152,0,137,162,5,8,0,128,160,0,128,163,0,64,158,64,208,137,
161,5,16,0,136,155,4,0,64,154,64,208,128,156,0,136,164,4,0,128,163,0,72,
162,12,64,208,64,134,64,208,128,159,0,64,161,64,208,137,156,5,16,0,137,
148,5,8,0,128,146,0,128,150,0,136,165,4,0,128,162,0,73,168,9,28,64,208,
128,147,0,136,166,4,0,64,164,64,208,137,151,5,8,0,128,134,0,128,155,0,64,
173,64,208,64,144,64,208,128,156,0,74,153,14,11,119,64,208,64,164,64,208,
128,145,0,210,151,1,52,1,83,0,64,208,73,158,9,148,64,208,128,154,0,73,152,
17,76,64,208,72,162,8,64,208,128,158,0,128,146,0,73,147,13,40,64,208,136,
159,4,0,128,144,0,72,146,8,64,208,128,144,0,64,145,64,208,136,152,4,0,64,
144,64,208,64,157,64,208,128,154,0,72,150,12,64,208,64,145,64,208,128,152,
0,64,148,64,208,128,156,0,73,156,17,44,64,208,137,154,5,8,0,128,151,0,128,
159,0,72,155,8,64,208,128,154,0,64,154,64,208,137,152,5,8,0,128,148,0,64,
161,64,208,128,156,0,64,157,64,208,137,159,5,12,0,136,158,4,0,128,144,0,
128,162,0,201,165,14,112,0,64,208,136,161,4,0,128,154,0,73,161,25,57,64,
208,137,161,5,12,0,136,159,4,0,128,154,0,64,164,64,208,128,158,0,72,160,
16,64,208,72,156,8,64,208,128,154,0,128,144,0,192,159,0,64,208,137,159,
5,8,0,128,156,0,128,162,0,136,164,4,0,192,162,0,64,208,137,158,5,16,0,137,
152,5,8,0,128,144,0,128,156,0,200,162,9,0,64,208,128,156,0,64,161,64,208,
128,147,0,73,168,9,20,64,208,128,146,0,136,167,4,0,64,166,64,208,128,156,
0,64,173,64,208,72,162,8,64,208,128,144,0,64,156,64,208,128,156,0,64,150,
64,208,73,156,9,24,64,208,128,148,0,64,145,64,208,137,159,5,8,0,128,158,
0,128,164,0,128,164,0,64,152,64,208,74,157,50,6,196,64,208,137,154,5,36,
0,72,152,12,64,208,64,161,64,208,128,154,0,64,144,64,208,64,149,64,208,
64,161,64,208,64,162,64,208,128,172,0,136,165,4,0,128,158,0,73,150,17,158,
64,208,64,147,64,208,64,156,64,208,128,144,0,73,147,37,118,64,208,73,168,
9,20,64,208,128,152,0,72,162,8,64,208,128,166,0,128,154,0,64,173,64,208,
136,154,4,0,128,152,0,201,145,22,45,0,64,208,73,161,9,12,64,208,128,154,
0,128,152,0,128,166,0,64,144,64,208,137,159,5,12,0,136,147,4,0,128,145,
0,136,167,4,0,128,162,0,64,146,64,208,137,162,5,25,0,73,154,9,17,64,208,
128,160,0,192,152,0,64,208,128,162,0,128,161,0,136,166,4,0,128,164,0,72,
149,8,64,208,128,146,0,64,148,64,208,136,161,4,0,64,158,64,208,128,152,
0,74,154,98,5,93,64,208,73,158,13,64,64,208,64,161,64,208,128,144,0,73,
146,9,20,64,208,128,152,0,64,144,64,208,64,161,64,208,128,144,0,64,152,
64,208,73,160,13,20,64,208,64,173,64,208,128,162,0,64,156,64,208,128,162,
0,64,173,64,208,128,162,0,73,164,9,16,64,208,128,152,0,64,162,64,208,128,
152,0,64,166,64,208,64,152,64,208,128,156,0,208,152,4,232,0,64,208,74,158,
62,1,254,64,208,137,162,5,36,0,73,151,9,24,64,208,128,147,0,64,147,64,208,
136,160,4,0,64,144,64,208,128,151,0,64,161,64,208,128,159,0,136,165,4,0,
64,163,64,208,136,161,4,0,64,152,64,208,128,157,0,201,150,10,247,0,64,208,
128,162,0,73,147,80,205,64,208,73,152,13,41,64,208,64,160,64,208,128,159,
0,73,146,9,25,64,208,128,162,0,136,145,4,0,192,144,0,64,208,64,152,64,208,
128,154,0,128,148,0,201,162,10,26,0,64,208,128,159,0,136,160,4,0,192,159,
0,64,208,136,173,4,0,128,154,0,64,173,64,208,128,162,0,73,145,29,90,64,
208,137,159,5,20,0,72,150,8,64,208,128,148,0,64,148,64,208,128,148,0,128,
161,0,192,144,0,64,208,137,162,5,37,0,137,158,5,16,0,72,156,8,64,208,128,
161,0,128,144,0,136,160,4,0,192,159,0,64,208,136,165,4,0,128,159,0,73,173,
9,16,64,208,128,156,0,136,165,4,0,128,163,0,128,175,0,64,146,64,208,137,
158,5,20,0,137,154,5,12,0,64,146,64,208,128,161,0,128,157,0,137,162,5,8,
0,128,161,0,128,168,0,72,149,8,64,208,128,146,0,192,148,0,64,208,137,152,
5,16,0,136,147,4,0,64,144,64,208,128,160,0,128,159,0,73,155,41,137,64,208,
73,149,21,32,64,208,64,147,64,208,64,156,64,208,64,144,64,208,128,168,0,
64,147,64,208,64,152,64,208,128,161,0,128,164,0,73,152,21,48,64,208,137,
161,5,12,0,136,159,4,0,128,157,0,128,162,0,64,151,64,208,73,152,9,20,64,
208,128,151,0,64,144,64,208,64,144,64,208,128,156,0,128,156,0,64,154,64,
208,137,158,5,33,0,73,146,13,21,64,208,64,158,64,208,128,146,0,192,144,
0,64,208,128,156,0,64,152,64,208,128,159,0,136,165,4,0,64,161,64,208,128,
152,0,72,157,28,64,208,137,156,5,20,0,136,154,4,0,64,152,64,208,64,173,
64,208,128,162,0,128,173,0,64,156,64,208,73,161,9,20,64,208,128,154,0,137,
152,5,8,0,128,144,0,128,156,0,200,173,9,0,64,208,128,162,0,128,162,0,74,
165,66,2,68,64,208,73,161,17,56,64,208,136,156,4,0,64,151,64,208,128,160,
0,64,152,64,208,136,162,4,0,64,156,64,208,64,159,64,208,64,158,64,208,64,
155,64,208,64,152,64,208,64,156,64,208,64,149,64,208,128,160,0,128,162,
0,202,162,155,1,198,0,64,208,73,155,9,124,64,208,128,159,0,73,149,41,96,
64,208,64,159,64,208,64,155,64,208,64,158,64,208,64,159,64,208,64,160,64,
208,64,152,64,208,64,145,64,208,64,158,64,208,128,160,0,73,146,9,48,64,
208,128,167,0,64,144,64,208,137,147,5,32,0,64,146,64,208,64,162,64,208,
64,158,64,208,64,159,64,208,64,160,64,208,64,158,64,208,128,156,0,128,159,
0,64,148,64,208,128,165,0,72,152,12,64,208,64,152,64,208,128,158,0,64,151,
64,208,128,152,0,137,159,5,12,0,136,158,4,0,128,156,0,72,164,8,64,208,128,
144,0,128,162,0,201,160,39,154,0,64,208,201,159,14,25,0,64,208,136,158,
4,0,128,152,0,137,154,5,8,0,128,152,0,128,158,0,136,165,4,0,128,162,0,192,
159,0,64,208,201,156,14,63,0,64,208,136,173,4,0,128,156,0,73,151,9,29,64,
208,128,154,0,73,145,9,17,64,208,128,145,0,192,144,0,64,208,128,146,0,128,
147,0,72,154,8,64,208,128,152,0,192,152,0,64,208,136,162,4,0,128,157,0,
73,162,17,40,64,208,64,152,64,208,136,150,4,0,128,148,0,136,159,4,0,64,
158,64,208,64,145,64,208,64,158,64,208,64,161,64,208,128,155,0,136,173,
4,0,128,165,0,64,161,64,208,137,160,5,86,0,137,154,5,57,0,73,146,9,49,64,
208,128,162,0,192,144,0,64,208,136,163,4,0,64,157,64,208,64,162,64,208,
64,149,64,208,64,165,64,208,64,157,64,208,64,152,64,208,64,154,64,208,128,
144,0,128,152,0,73,157,13,21,64,208,64,148,64,208,128,146,0,192,156,0,64,
208,128,161,0,128,159,0,137,164,5,24,0,73,162,9,16,64,208,128,159,0,64,
161,64,208,128,163,0,128,163,0,73,167,25,28,64,208,64,149,64,208,64,162,
64,208,64,156,64,208,64,144,64,208,128,168,0,128,165,0,128,173,0,200,164,
33,0,64,208,137,159,5,16,0,72,158,8,64,208,128,165,0,128,152,0,64,165,64,
208,136,156,4,0,128,145,0,64,163,64,208,73,156,9,20,64,208,128,161,0,136,
154,4,0,64,146,64,208,128,156,0,128,159,0,73,168,9,57,64,208,128,159,0,
72,167,36,64,208,64,144,64,208,72,161,20,64,208,64,159,64,208,64,160,64,
208,64,158,64,208,128,156,0,64,146,64,208,128,158,0,192,166,0,64,208,64,
152,64,208,128,160,0,72,175,16,64,208,136,164,4,0,64,155,64,208,128,152,
0,192,173,0,64,208,201,159,10,54,0,64,208,128,173,0,201,147,14,29,0,64,
208,64,158,64,208,128,161,0,72,146,8,64,208,128,156,0,64,144,64,208,128,
159,0,72,156,8,64,208,128,152,0,64,152,64,208,128,160,0,137,162,5,16,0,
136,161,4,0,64,160,64,208,128,146,0,136,173,4,0,64,164,64,208,128,144,0,
64,151,64,208,64,152,64,208,64,161,64,208,64,157,64,208,128,159,0,72,156,
64,64,208,73,160,13,40,64,208,64,144,64,208,128,165,0,73,149,9,20,64,208,
128,155,0,136,145,4,0,64,144,64,208,128,159,0,64,152,64,208,128,145,0,137,
166,5,16,0,136,165,4,0,64,162,64,208,128,152,0,128,168,0,64,155,64,208,
73,154,21,56,64,208,72,173,8,64,208,128,161,0,64,165,64,208,128,158,0,137,
150,5,20,0,72,145,8,64,208,128,148,0,64,144,64,208,128,163,0,64,152,64,
208,137,156,5,8,0,128,155,0,128,166,0,73,161,9,16,64,208,128,173,0,64,158,
64,208,128,161,0,64,162,64,208,136,161,4,0,128,148,0,74,164,38,2,75,64,
208,137,155,5,16,0,137,152,5,8,0,128,144,0,128,154,0,72,165,8,64,208,128,
152,0,64,162,64,208,128,152,0,202,161,130,1,216,0,64,208,137,156,5,66,0,
137,151,5,16,0,136,148,4,0,64,144,64,208,128,147,0,72,154,32,64,208,137,
162,5,24,0,72,158,8,64,208,128,156,0,64,149,64,208,64,152,64,208,128,157,
0,128,163,0,192,152,0,64,208,192,159,0,64,208,128,159,0,137,162,5,33,0,
200,159,13,0,64,208,136,159,4,0,128,152,0,64,158,64,208,136,166,4,0,64,
157,64,208,128,147,0,72,173,20,64,208,72,161,8,64,208,128,162,0,64,159,
64,208,128,152,0,128,166,0,74,159,193,1,37,64,208,73,159,29,93,64,208,64,
158,64,208,64,159,64,208,64,162,64,208,64,152,64,208,64,152,64,208,128,
160,0,73,154,17,49,64,208,72,162,8,64,208,128,152,0,128,152,0,73,149,9,
16,64,208,128,154,0,64,147,64,208,128,161,0,192,152,0,64,208,72,173,8,64,
208,128,159,0,128,156,0,72,158,8,64,208,128,156,0,64,156,64,208,128,145,
0,73,162,26,73,64,208,200,152,17,0,64,208,137,161,5,8,0,128,150,0,128,165,
0,128,145,0,72,161,28,64,208,73,156,13,20,64,208,64,146,64,208,128,158,
0,64,146,64,208,128,158,0,128,159,0,64,160,64,208,64,158,64,208,64,156,
64,208,64,144,64,208,128,168,0,72,167,8,64,208,128,152,0,192,166,0,64,208,
64,147,64,208,128,159,0,64,158,64,208,73,160,9,68,64,208,128,154,0,73,157,
13,44,64,208,64,154,64,208,128,166,0,72,154,28,64,208,137,160,5,16,0,64,
152,64,208,64,162,64,208,128,160,0,64,162,64,208,128,160,0,128,145,0,64,
159,64,208,136,166,4,0,64,152,64,208,128,154,0,137,162,5,25,0,192,161,0,
64,208,136,162,4,0,64,159,64,208,64,158,64,208,128,152,0,128,165,0,192,
160,0,64,208,73,163,9,29,64,208,128,159,0,137,158,5,12,0,64,154,64,208,
128,161,0,192,161,0,64,208,128,152,0,137,166,5,12,0,64,164,64,208,128,152,
0,128,168,0,200,163,30,0,64,208,201,160,10,17,0,64,208,128,158,0,64,145,
64,208,128,159,0,64,162,64,208,128,154,0,64,162,64,208,137,159,5,36,0,72,
152,24,64,208,137,159,5,16,0,136,147,4,0,64,144,64,208,128,159,0,128,166,
0,64,149,64,208,128,155,0,136,161,4,0,128,160,0,137,167,5,186,0,200,166,
158,0,64,208,73,159,29,108,64,208,137,146,5,8,0,128,145,0,64,158,64,208,
64,159,64,208,64,157,64,208,128,147,0,73,154,17,68,64,208,72,160,8,64,208,
128,148,0,128,148,0,72,145,40,64,208,73,156,9,16,64,208,128,162,0,64,148,
64,208,128,148,0,64,171,64,208,64,162,64,208,64,165,64,208,64,152,64,208,
128,156,0,64,144,64,208,64,161,64,208,128,154,0,64,157,64,208,64,159,64,
208,128,173,0,201,164,10,25,0,64,208,128,162,0,72,162,8,64,208,128,148,
0,64,160,64,208,128,146,0,64,173,64,208,73,146,9,12,64,208,128,162,0,128,
145,0,128,160,0,64,165,64,208,73,162,9,12,64,208,128,152,0,128,152,0,64,
164,64,208,128,152,0,72,175,12,64,208,136,163,4,0,128,154,0,64,173,64,208,
73,159,17,42,64,208,136,159,4,0,64,152,64,208,128,159,0,201,156,10,22,0,
64,208,128,152,0,200,154,9,0,64,208,128,166,0,128,152,0,128,158,0,137,162,
5,8,0,128,160,0,64,163,64,208,128,159,0,74,155,167,2,194,64,208,201,159,
14,100,0,64,208,64,145,64,208,128,163,0,137,154,5,49,0,201,147,14,41,0,
64,208,136,161,4,0,128,159,0,72,146,16,64,208,137,151,5,8,0,128,148,0,128,
159,0,64,145,64,208,64,146,64,208,128,163,0,128,148,0,201,157,10,29,0,64,
208,128,148,0,64,156,64,208,137,154,5,8,0,128,151,0,64,159,64,208,128,148,
0,192,158,0,64,208,128,154,0,137,164,5,45,0,73,162,9,37,64,208,128,154,
0,200,161,25,0,64,208,73,152,9,12,64,208,128,145,0,128,144,0,64,158,64,
208,128,148,0,128,160,0,128,163,0,137,166,5,12,0,64,165,64,208,128,155,
0,128,175,0,64,154,64,208,202,159,65,1,32,0,64,208,201,160,10,37,0,64,208,
128,159,0,137,156,5,16,0,72,152,8,64,208,128,162,0,128,146,0,64,158,64,
208,136,152,4,0,128,148,0,137,163,5,17,0,192,161,0,64,208,136,161,4,0,128,
156,0,128,167,0,73,150,9,107,64,208,128,152,0,73,146,21,74,64,208,137,162,
5,8,0,128,148,0,64,173,64,208,128,160,0,200,145,17,0,64,208,72,164,8,64,
208,128,173,0,128,161,0,64,144,64,208,137,159,5,25,0,200,158,13,0,64,208,
64,154,64,208,128,158,0,64,154,64,208,128,162,0,136,163,4,0,128,162,0,200,
148,17,0,64,208,136,159,4,0,64,144,64,208,128,160,0,64,147,64,208,128,145,
0,73,155,13,72,64,208,64,164,64,208,128,144,0,72,154,40,64,208,73,159,9,
28,64,208,128,147,0,73,148,9,12,64,208,128,166,0,128,147,0,64,155,64,208,
128,161,0,136,166,4,0,128,160,0,64,152,64,208,137,148,5,12,0,64,144,64,
208,128,164,0,128,159,0,200,158,29,0,64,208,137,159,5,16,0,136,152,4,0,
64,148,64,208,128,165,0,136,174,4,0,128,163,0,64,156,64,208,137,151,5,8,
0,128,148,0,128,156,0,73,166,22,199,64,208,200,158,13,0,64,208,64,151,64,
208,128,168,0,128,145,0,201,162,34,166,0,64,208,137,157,5,16,0,137,146,
5,8,0,128,145,0,128,155,0,137,163,5,8,0,128,159,0,128,166,0,200,161,46,
0,64,208,137,158,5,25,0,137,147,5,13,0,192,144,0,64,208,128,161,0,64,156,
64,208,128,152,0,73,163,9,12,64,208,128,156,0,128,159,0,128,173,0,192,160,
0,64,208,137,162,5,49,0,137,159,5,29,0,201,151,10,13,0,64,208,128,163,0,
128,149,0,64,154,64,208,136,163,4,0,128,152,0,136,161,4,0,64,160,64,208,
64,154,64,208,128,163,0,73,166,9,16,64,208,128,145,0,136,164,4,0,128,163,
0,136,175,4,0,192,173,0,64,208,136,163,4,0,128,147,0,72,164,8,64,208,128,
160,0,128,163,0,73,173,30,45,64,208,137,160,5,16,0,136,159,4,0,64,152,64,
208,128,161,0,192,161,0,64,208,128,159,0,72,168,8,64,208,128,152,0,64,167,
64,208,128,161,0,128,174,0,64,156,64,208,73,156,9,155,64,208,128,151,0,
73,149,21,99,64,208,72,162,12,64,208,64,144,64,208,128,163,0,128,159,0,
73,146,9,54,64,208,128,155,0,72,145,29,64,208,137,155,5,12,0,136,154,4,
0,128,144,0,192,162,0,64,208,64,160,64,208,128,166,0,192,144,0,64,208,136,
163,4,0,64,159,64,208,128,158,0,72,148,8,64,208,128,147,0,192,147,0,64,
208,72,163,8,64,208,128,144,0,128,161,0,73,152,13,32,64,208,136,166,4,0,
128,159,0,72,151,12,64,208,136,161,4,0,128,154,0,64,150,64,208,128,154,
0,64,154,64,208,72,160,8,64,208,128,155,0,128,148,0,201,164,10,95,0,64,
208,128,144,0,73,161,13,64,64,208,136,161,4,0,128,154,0,72,160,20,64,208,
137,159,5,12,0,136,155,4,0,128,154,0,128,162,0,64,159,64,208,137,158,5,
16,0,137,150,5,8,0,128,146,0,128,157,0,137,162,5,8,0,128,161,0,128,163,
0,200,163,9,0,64,208,128,159,0,192,162,0,64,208,136,161,4,0,128,159,0,137,
168,5,33,0,200,166,21,0,64,208,72,159,8,64,208,128,159,0,64,156,64,208,
128,158,0,64,165,64,208,128,166,0,64,173,64,208,128,159,0,74,165,59,12,
252,64,208,73,161,9,33,64,208,128,161,0,73,156,9,21,64,208,128,159,0,200,
155,9,0,64,208,128,154,0,128,151,0,128,159,0,137,165,5,16,0,64,162,64,208,
136,154,4,0,128,152,0,128,166,0,82,161,2,61,8,200,64,208,202,157,43,1,46,
0,64,208,73,160,9,24,64,208,128,159,0,137,155,5,12,0,64,145,64,208,128,
160,0,128,159,0,137,162,5,8,0,128,161,0,128,163,0,73,150,13,139,64,208,
136,166,4,0,128,163,0,73,146,29,85,64,208,73,152,9,20,64,208,128,154,0,
136,148,4,0,64,146,64,208,128,157,0,128,163,0,72,145,20,64,208,137,158,
5,12,0,136,157,4,0,128,152,0,128,163,0,192,144,0,64,208,137,156,5,20,0,
137,148,5,12,0,136,146,4,0,128,144,0,128,150,0,137,163,5,8,0,128,160,0,
128,165,0,200,148,21,0,64,208,73,159,9,12,64,208,128,147,0,128,154,0,128,
162,0,192,147,0,64,208,137,154,5,8,0,128,152,0,64,160,64,208,128,159,0,
137,155,5,69,0,72,154,28,64,208,137,155,5,16,0,137,146,5,8,0,128,145,0,
128,148,0,136,163,4,0,128,161,0,192,152,0,64,208,73,164,9,24,64,208,128,
162,0,72,159,8,64,208,128,146,0,64,156,64,208,128,152,0,64,168,64,208,128,
148,0,64,156,64,208,73,158,13,28,64,208,136,161,4,0,128,144,0,137,151,5,
12,0,64,149,64,208,128,159,0,128,152,0,72,173,8,64,208,128,159,0,64,159,
64,208,64,145,64,208,128,152,0,201,163,10,211,0,64,208,128,160,0,73,160,
34,116,64,208,137,152,5,12,0,136,147,4,0,128,144,0,200,162,9,0,64,208,128,
146,0,64,159,64,208,128,147,0,200,159,54,0,64,208,73,155,9,37,64,208,128,
158,0,137,152,5,20,0,72,146,12,64,208,136,161,4,0,128,159,0,128,144,0,192,
154,0,64,208,128,145,0,137,160,5,8,0,128,159,0,128,161,0,192,158,0,64,208,
73,160,9,16,64,208,128,145,0,136,152,4,0,128,148,0,136,163,4,0,128,162,
0,200,162,26,0,64,208,73,159,9,12,64,208,128,160,0,128,155,0,192,161,0,
64,208,128,146,0,64,161,64,208,137,156,5,32,0,137,151,5,20,0,72,149,12,
64,208,64,148,64,208,128,146,0,128,145,0,136,154,4,0,128,152,0,137,163,
5,16,0,72,161,8,64,208,128,158,0,128,158,0,64,168,64,208,128,156,0,137,
168,5,29,0,72,166,12,64,208,136,165,4,0,128,152,0,192,165,0,64,208,136,
163,4,0,128,155,0,64,173,64,208,137,160,5,12,0,136,159,4,0,128,158,0,136,
166,4,0,128,162,0,210,159,2,83,5,88,0,64,208,73,157,21,252,64,208,73,154,
9,12,64,208,128,156,0,128,148,0,128,159,0,137,149,5,134,0,201,146,18,47,
0,64,208,137,159,5,8,0,128,158,0,128,161,0,200,145,9,0,64,208,128,151,0,
192,144,0,64,208,137,158,5,12,0,136,146,4,0,128,144,0,128,166,0,72,148,
45,64,208,73,148,9,28,64,208,128,159,0,72,147,12,64,208,64,158,64,208,128,
161,0,64,145,64,208,128,158,0,192,158,0,64,208,64,158,64,208,128,161,0,
192,147,0,64,208,137,158,5,16,0,137,148,5,8,0,128,145,0,128,154,0,136,163,
4,0,192,160,0,64,208,64,162,64,208,128,163,0,201,152,30,41,0,64,208,137,
151,5,16,0,136,147,4,0,64,144,64,208,128,166,0,64,161,64,208,128,161,0,
136,151,4,0,64,150,64,208,128,160,0,72,156,20,64,208,137,165,5,8,0,128,
161,0,64,173,64,208,128,161,0,192,154,0,64,208,137,148,5,16,0,137,145,5,
8,0,128,144,0,128,147,0,73,161,9,12,64,208,128,154,0,128,155,0,128,164,
0,201,163,26,213,0,64,208,73,154,9,16,64,208,128,161,0,64,152,64,208,128,
156,0,128,166,0,73,160,54,143,64,208,201,161,10,29,0,64,208,128,158,0,137,
156,5,16,0,72,152,8,64,208,128,165,0,128,145,0,128,158,0,137,166,5,16,0,
136,164,4,0,64,163,64,208,128,159,0,128,167,0,200,159,29,0,64,208,137,155,
5,16,0,72,146,8,64,208,128,148,0,128,145,0,136,163,4,0,128,156,0,192,158,
0,64,208,137,155,5,28,0,73,152,9,16,64,208,128,162,0,136,151,4,0,128,144,
0,64,154,64,208,128,166,0,73,159,17,24,64,208,136,156,4,0,64,144,64,208,
128,162,0,136,158,4,0,128,156,0,128,163,0,72,162,16,64,208,137,151,5,8,
0,128,145,0,128,152,0,192,161,0,64,208,137,156,5,12,0,136,154,4,0,128,148,
0,136,160,4,0,64,159,64,208,128,161,0,137,167,5,106,0,200,166,85,0,64,208,
73,159,17,44,64,208,64,156,64,208,64,152,64,208,128,158,0,73,156,9,16,64,
208,128,159,0,64,152,64,208,128,154,0,64,157,64,208,64,157,64,208,128,162,
0,73,162,9,20,64,208,128,158,0,64,160,64,208,64,152,64,208,128,151,0,64,
167,64,208,64,161,64,208,64,147,64,208,128,173,0,192,164,0,64,208,137,160,
5,8,0,128,155,0,128,173,0,64,173,64,208,137,160,5,8,0,128,154,0,128,164,
0,64,158,64,208,74,158,34,1,171,64,208,73,158,13,24,64,208,64,152,64,208,
128,160,0,64,155,64,208,136,161,4,0,128,160,0,128,161,0,73,151,29,191,64,
208,73,156,9,16,64,208,128,159,0,64,152,64,208,128,159,0,64,162,64,208,
128,158,0,73,146,62,130,64,208,73,158,29,44,64,208,72,162,12,64,208,64,
173,64,208,128,154,0,64,154,64,208,64,152,64,208,128,145,0,64,156,64,208,
64,152,64,208,64,158,64,208,128,157,0,64,173,64,208,192,151,0,64,208,128,
144,0,72,145,17,64,208,136,164,4,0,192,148,0,64,208,128,154,0,64,144,64,
208,137,158,5,36,0,73,152,17,28,64,208,136,154,4,0,64,150,64,208,128,154,
0,64,148,64,208,64,158,64,208,128,159,0,128,154,0,136,174,4,0,64,161,64,
208,128,157,0,200,148,25,0,64,208,73,154,9,12,64,208,128,145,0,128,144,
0,64,157,64,208,128,162,0,64,147,64,208,128,160,0,73,155,17,131,64,208,
72,160,8,64,208,128,158,0,128,148,0,72,154,82,64,208,137,156,5,45,0,73,
148,9,20,64,208,128,166,0,72,147,8,64,208,128,161,0,128,145,0,200,154,13,
0,64,208,64,152,64,208,128,152,0,64,151,64,208,128,160,0,73,161,17,29,64,
208,136,156,4,0,64,152,64,208,128,161,0,136,159,4,0,192,158,0,64,208,128,
161,0,128,163,0,64,152,64,208,73,159,13,25,64,208,64,159,64,208,128,158,
0,200,154,9,0,64,208,128,145,0,128,146,0,128,160,0,72,157,20,64,208,137,
160,5,12,0,64,156,64,208,128,162,0,128,166,0,64,156,64,208,73,158,13,36,
64,208,64,159,64,208,128,158,0,137,151,5,20,0,64,144,64,208,64,154,64,208,
64,158,64,208,128,157,0,128,152,0,72,163,8,64,208,128,161,0,128,159,0,73,
164,33,241,64,208,73,156,9,16,64,208,128,158,0,64,150,64,208,128,148,0,
64,159,64,208,64,156,64,208,128,159,0,73,161,29,167,64,208,72,159,12,64,
208,136,161,4,0,128,154,0,64,158,64,208,64,163,64,208,128,157,0,72,160,
81,64,208,137,159,5,57,0,73,156,9,24,64,208,128,148,0,136,150,4,0,64,148,
64,208,64,158,64,208,128,161,0,64,157,64,208,72,152,21,64,208,192,154,0,
64,208,64,149,64,208,64,155,64,208,128,172,0,128,144,0,73,166,9,12,64,208,
128,152,0,128,164,0,64,173,64,208,128,156,0,192,159,0,64,208,73,159,13,
36,64,208,64,159,64,208,128,163,0,137,145,5,16,0,64,144,64,208,64,175,64,
208,128,151,0,64,148,64,208,128,155,0,137,165,5,8,0,128,162,0,192,167,0,
64,208,128,163,0,200,163,21,0,64,208,73,159,9,12,64,208,128,154,0,128,147,
0,128,161,0,192,162,0,64,208,73,159,9,12,64,208,128,163,0,128,154,0,128,
161,0,73,168,29,69,64,208,73,159,9,16,64,208,128,144,0,136,154,4,0,128,
145,0,64,161,64,208,128,158,0,72,167,12,64,208,136,163,4,0,128,160,0,192,
166,0,64,208,73,158,9,16,64,208,128,162,0,64,152,64,208,128,162,0,64,160,
64,208,128,152,0,72,175,8,64,208,128,156,0,64,173,64,208,73,154,14,17,64,
208,192,161,0,64,208,128,152,0,128,151,0,128,159,0,64,160,64,208,201,159,
34,213,0,64,208,137,156,5,20,0,73,154,9,12,64,208,128,148,0,128,144,0,128,
155,0,136,160,4,0,128,158,0,201,152,10,81,0,64,208,128,164,0,201,147,14,
59,0,64,208,64,152,64,208,128,150,0,72,146,12,64,208,64,159,64,208,128,
158,0,192,145,0,64,208,73,158,14,25,64,208,192,158,0,64,208,128,152,0,64,
144,64,208,64,157,64,208,128,154,0,128,163,0,192,148,0,64,208,136,166,4,
0,128,160,0,73,156,33,65,64,208,137,155,5,12,0,136,154,4,0,128,144,0,136,
164,4,0,64,163,64,208,64,159,64,208,128,173,0,72,155,8,64,208,128,161,0,
192,154,0,64,208,137,160,5,12,0,136,158,4,0,128,144,0,136,167,4,0,128,163,
0,192,158,0,64,208,73,156,9,20,64,208,128,159,0,64,154,64,208,64,159,64,
208,128,158,0,192,158,0,64,208,128,152,0,137,165,5,53,0,73,162,22,45,64,
208,137,145,5,8,0,128,144,0,192,159,0,64,208,128,146,0,72,161,16,64,208,
72,174,8,64,208,128,157,0,128,161,0,64,160,64,208,128,151,0,128,163,0,201,
173,18,30,0,64,208,137,152,5,8,0,128,145,0,128,160,0,192,166,0,64,208,64,
160,64,208,128,158,0,64,174,64,208,128,153,0,82,163,1,118,2,236,64,208,
73,158,13,214,64,208,136,151,4,0,128,144,0,137,151,5,128,0,73,146,53,92,
64,208,73,154,9,20,64,208,128,152,0,136,148,4,0,64,147,64,208,128,159,0,
72,173,12,64,208,64,160,64,208,128,161,0,64,165,64,208,136,159,4,0,64,152,
64,208,128,159,0,72,145,36,64,208,73,152,9,24,64,208,128,159,0,72,148,8,
64,208,128,144,0,64,134,64,208,128,159,0,136,162,4,0,128,161,0,128,144,
0,72,148,8,64,208,128,158,0,64,147,64,208,72,157,12,64,208,64,161,64,208,
128,163,0,64,151,64,208,128,163,0,73,155,9,41,64,208,128,159,0,200,154,
21,0,64,208,72,152,12,64,208,64,144,64,208,128,156,0,128,146,0,64,152,64,
208,64,157,64,208,128,163,0,72,157,13,64,208,192,161,0,64,208,128,158,0,
64,156,64,208,73,154,9,12,64,208,128,147,0,128,147,0,128,166,0,73,166,21,
120,64,208,73,152,9,12,64,208,128,175,0,128,151,0,128,160,0,73,162,21,56,
64,208,137,166,5,8,0,128,158,0,64,173,64,208,128,159,0,72,160,16,64,208,
72,162,8,64,208,128,161,0,128,161,0,64,159,64,208,137,161,5,12,0,64,154,
64,208,128,166,0,128,162,0,72,165,8,64,208,128,162,0,64,164,64,208,72,146,
24,64,208,72,161,8,64,208,128,163,0,64,152,64,208,64,161,64,208,128,163,
0,64,144,64,208,128,161,0,201,173,14,25,0,64,208,136,161,4,0,128,154,0,
136,168,4,0,64,167,64,208,128,159,0,64,175,64,208,128,145,0,64,162,64,208,
73,157,9,159,64,208,128,161,0,201,150,10,66,0,64,208,128,162,0,73,147,26,
53,64,208,137,158,5,12,0,64,152,64,208,128,154,0,192,159,0,64,208,128,152,
0,72,146,8,64,208,128,166,0,64,145,64,208,72,166,12,64,208,64,159,64,208,
128,159,0,128,161,0,128,148,0,73,155,9,61,64,208,128,145,0,72,154,12,64,
208,136,163,4,0,128,161,0,192,152,0,64,208,73,159,9,28,64,208,128,145,0,
137,154,5,12,0,64,152,64,208,128,156,0,64,156,64,208,128,152,0,136,166,
4,0,128,161,0,64,156,64,208,137,154,5,16,0,72,152,8,64,208,128,151,0,128,
151,0,128,158,0,73,162,17,117,64,208,137,156,5,8,0,128,152,0,128,159,0,
137,160,5,61,0,200,159,33,0,64,208,137,159,5,20,0,72,152,12,64,208,64,147,
64,208,128,161,0,128,151,0,136,161,4,0,128,160,0,64,158,64,208,73,161,9,
12,64,208,128,165,0,128,145,0,64,173,64,208,128,159,0,64,161,64,208,73,
157,9,16,64,208,128,159,0,136,154,4,0,128,144,0,72,173,12,64,208,136,163,
4,0,128,161,0,64,159,64,208,128,147,0,73,173,21,87,64,208,73,161,9,12,64,
208,128,152,0,128,154,0,128,162,0,200,166,50,0,64,208,137,152,5,20,0,137,
146,5,8,0,128,145,0,64,148,64,208,128,162,0,201,161,14,21,0,64,208,136,
173,4,0,128,156,0,64,156,64,208,128,154,0,128,164,0,192,163,0,64,208,136,
163,4,0,64,162,64,208,128,166,0,64,174,64,208,128,166,0,192,164,0,64,208,
137,155,5,119,0,73,148,9,58,64,208,128,147,0,73,146,13,46,64,208,64,152,
64,208,128,163,0,200,145,21,0,64,208,137,157,5,12,0,136,154,4,0,128,152,
0,128,160,0,192,144,0,64,208,136,163,4,0,128,158,0,128,147,0,73,151,17,
24,64,208,136,160,4,0,64,159,64,208,128,156,0,64,150,64,208,128,160,0,192,
154,0,64,208,73,157,21,24,64,208,64,163,64,208,64,154,64,208,64,152,64,
208,128,152,0,128,144,0,128,160,0,201,160,14,94,0,64,208,136,154,4,0,128,
151,0,73,158,25,49,64,208,137,173,5,12,0,136,160,4,0,128,159,0,64,174,64,
208,128,146,0,72,157,16,64,208,136,160,4,0,64,159,64,208,128,158,0,192,
156,0,64,208,128,151,0,64,159,64,208,137,161,5,16,0,137,154,5,8,0,128,147,
0,128,159,0,137,163,5,8,0,128,162,0,128,164,0,73,162,21,48,64,208,137,155,
5,12,0,64,146,64,208,128,145,0,128,159,0,64,161,64,208,137,160,5,16,0,72,
158,8,64,208,128,152,0,128,144,0,64,162,64,208,128,161,0,128,168,0,74,169,
14,2,76,64,208,136,161,4,0,128,158,0,202,167,59,1,249,0,64,208,73,159,9,
32,64,208,128,152,0,137,155,5,16,0,72,152,8,64,208,128,164,0,128,151,0,
64,158,64,208,128,163,0,73,163,9,16,64,208,128,151,0,64,162,64,208,128,
159,0,128,164,0,64,166,64,208,73,157,29,241,64,208,137,158,5,20,0,136,152,
4,0,64,146,64,208,64,156,64,208,128,162,0,128,173,0,73,149,13,122,64,208,
64,159,64,208,128,152,0,73,146,25,82,64,208,137,158,5,12,0,64,156,64,208,
128,162,0,64,161,64,208,128,156,0,200,145,25,0,64,208,137,152,5,16,0,136,
151,4,0,64,148,64,208,128,148,0,128,154,0,192,144,0,64,208,137,157,5,16,
0,64,147,64,208,64,152,64,208,128,159,0,64,158,64,208,64,156,64,208,128,
163,0,136,148,4,0,64,147,64,208,137,154,5,8,0,128,145,0,64,161,64,208,64,
158,64,208,128,162,0,73,154,30,66,64,208,201,162,14,17,0,64,208,136,159,
4,0,128,145,0,128,152,0,64,173,64,208,128,156,0,72,152,20,64,208,137,161,
5,12,0,64,157,64,208,128,162,0,128,162,0,192,151,0,64,208,72,159,8,64,208,
128,145,0,128,148,0,192,156,0,64,208,137,161,5,16,0,64,152,64,208,64,154,
64,208,128,166,0,128,173,0,73,162,17,133,64,208,137,146,5,8,0,128,145,0,
128,148,0,73,160,26,93,64,208,136,162,4,0,192,156,0,64,208,64,161,64,208,
136,159,4,0,128,145,0,72,159,48,64,208,137,154,5,16,0,137,151,5,8,0,128,
146,0,128,152,0,73,161,9,12,64,208,128,158,0,128,160,0,64,164,64,208,64,
151,64,208,64,158,64,208,128,150,0,64,158,64,208,137,157,5,8,0,128,148,
0,64,158,64,208,128,151,0,64,161,64,208,73,161,9,16,64,208,128,165,0,136,
160,4,0,128,156,0,128,162,0,137,167,5,49,0,200,165,13,0,64,208,64,148,64,
208,128,159,0,64,163,64,208,73,154,9,20,64,208,128,161,0,64,152,64,208,
64,154,64,208,128,161,0,64,175,64,208,128,158,0,64,173,64,208,72,161,12,
64,208,64,156,64,208,128,159,0,128,152,0,192,168,0,64,208,201,154,10,41,
0,64,208,128,152,0,137,151,5,28,0,72,148,12,64,208,136,161,4,0,128,155,
0,64,146,64,208,136,152,4,0,128,148,0,128,152,0,137,164,5,16,0,136,161,
4,0,64,158,64,208,128,159,0,64,174,64,208,128,154,0,73,174,46,226,64,208,
73,162,9,37,64,208,128,151,0,72,145,8,64,208,128,155,0,192,144,0,64,208,
136,163,4,0,64,152,64,208,64,175,64,208,128,156,0,128,163,0,64,173,64,208,
201,159,18,96,0,64,208,137,161,5,8,0,128,152,0,128,162,0,201,152,30,50,
0,64,208,73,156,9,20,64,208,128,161,0,64,154,64,208,64,158,64,208,128,157,
0,128,161,0,73,146,9,17,64,208,128,151,0,192,144,0,64,208,128,159,0,128,
151,0,72,157,8,64,208,128,166,0,64,156,64,208,200,161,9,0,64,208,128,162,
0,64,145,64,208,128,166,0,201,164,14,53,0,64,208,136,166,4,0,128,159,0,
73,161,17,32,64,208,136,168,4,0,64,161,64,208,128,162,0,64,160,64,208,137,
151,5,8,0,128,144,0,128,154,0,64,162,64,208,128,152,0,72,166,16,64,208,
136,163,4,0,64,154,64,208,128,152,0,64,165,64,208,64,158,64,208,128,154,
0,64,175,64,208,137,158,5,16,0,72,156,8,64,208,128,161,0,128,154,0,128,
166,0,83,166,33,99,1,42,51,73,86,7,12,128,69,0,64,71,128,80,0,64,208,210,
159,2,17,23,178,0,64,208,74,158,34,1,49,64,208,137,154,5,20,0,137,150,5,
12,0,64,146,64,208,128,161,0,128,152,0,136,161,4,0,128,160,0,73,152,30,
164,64,208,137,164,5,21,0,200,162,13,0,64,208,64,151,64,208,128,161,0,128,
155,0,128,173,0,73,146,33,93,64,208,137,157,5,20,0,73,152,9,12,64,208,128,
161,0,128,145,0,128,155,0,136,161,4,0,128,160,0,72,145,24,64,208,72,173,
8,64,208,128,154,0,64,161,64,208,64,152,64,208,128,151,0,64,144,64,208,
137,159,5,16,0,137,154,5,8,0,128,151,0,128,155,0,137,162,5,13,0,192,161,
0,64,208,128,160,0,128,163,0,200,148,33,0,64,208,73,156,9,20,64,208,128,
152,0,137,152,5,8,0,128,148,0,128,154,0,136,163,4,0,128,159,0,192,147,0,
64,208,128,152,0,201,156,44,100,0,64,208,201,161,23,30,0,64,208,192,161,
0,64,208,64,148,64,208,64,152,64,208,128,159,0,136,159,4,0,128,152,0,136,
168,4,0,128,163,0,72,155,12,64,208,136,161,4,0,128,152,0,192,154,0,64,208,
137,160,5,24,0,73,152,9,16,64,208,128,158,0,136,146,4,0,128,145,0,128,158,
0,73,162,9,12,64,208,128,145,0,128,161,0,128,163,0,64,157,64,208,128,158,
0,73,164,9,191,64,208,128,161,0,201,161,38,150,0,64,208,137,161,5,28,0,
72,159,16,64,208,72,158,8,64,208,128,161,0,128,154,0,64,152,64,208,128,
160,0,128,169,0,72,160,32,64,208,137,158,5,20,0,73,152,9,12,64,208,128,
157,0,128,145,0,128,156,0,136,173,4,0,128,161,0,192,159,0,64,208,137,157,
5,26,0,201,154,10,13,0,64,208,128,159,0,128,148,0,192,156,0,64,208,128,
159,0,201,160,18,37,0,64,208,136,154,4,0,64,152,64,208,128,154,0,64,158,
64,208,72,158,8,64,208,128,159,0,64,152,64,208,128,147,0,192,161,0,64,208,
64,157,64,208,128,148,0,72,163,8,64,208,128,154,0,192,162,0,64,208,137,
152,5,12,0,136,145,4,0,128,144,0,136,161,4,0,128,158,0,201,173,10,17,0,
64,208,128,157,0,136,168,4,0,128,167,0,64,174,64,208,128,164,0,74,150,27,
9,163,64,208,201,154,10,17,0,64,208,128,163,0,136,152,4,0,128,144,0,128,
160,0,82,146,1,107,4,91,64,208,73,157,25,232,64,208,72,162,8,64,208,128,
160,0,64,152,64,208,64,144,64,208,128,147,0,201,151,10,73,0,64,208,128,
163,0,201,148,18,43,0,64,208,136,158,4,0,64,155,64,208,128,156,0,200,147,
13,0,64,208,64,156,64,208,128,158,0,192,146,0,64,208,136,156,4,0,128,154,
0,192,149,0,64,208,64,162,64,208,64,156,64,208,64,149,64,208,128,162,0,
201,155,22,86,0,64,208,137,154,5,8,0,128,148,0,64,173,64,208,128,154,0,
72,154,24,64,208,137,154,5,16,0,136,147,4,0,64,144,64,208,128,147,0,128,
161,0,64,152,64,208,201,157,10,29,0,64,208,128,159,0,72,156,8,64,208,128,
159,0,64,144,64,208,64,160,64,208,128,157,0,136,162,4,0,128,159,0,192,156,
0,64,208,137,156,5,28,0,73,152,9,16,64,208,128,160,0,136,145,4,0,128,144,
0,64,154,64,208,128,147,0,137,163,5,12,0,136,162,4,0,128,160,0,128,164,
0,73,162,13,99,64,208,136,158,4,0,128,152,0,201,160,18,50,0,64,208,72,158,
8,64,208,128,151,0,128,152,0,200,159,13,0,64,208,136,154,4,0,128,146,0,
64,158,64,208,72,161,8,64,208,128,159,0,64,155,64,208,128,162,0,64,161,
64,208,137,156,5,20,0,73,147,9,12,64,208,128,160,0,128,145,0,128,152,0,
136,161,4,0,192,157,0,64,208,128,159,0,73,165,9,17,64,208,128,156,0,192,
163,0,64,208,128,156,0,64,173,64,208,128,154,0,210,144,1,215,2,2,0,64,208,
201,157,27,204,0,64,208,201,162,14,17,0,64,208,64,148,64,208,128,156,0,
128,158,0,128,166,0,137,150,5,78,0,201,146,14,30,0,64,208,136,161,4,0,128,
146,0,200,145,13,0,64,208,136,161,4,0,128,160,0,128,144,0,72,148,24,64,
208,137,161,5,8,0,128,148,0,64,173,64,208,64,157,64,208,128,156,0,64,147,
64,208,137,152,5,12,0,64,147,64,208,128,152,0,128,156,0,201,155,22,66,0,
64,208,72,152,8,64,208,128,156,0,64,144,64,208,128,154,0,72,154,20,64,208,
137,145,5,8,0,128,144,0,64,154,64,208,128,146,0,64,152,64,208,137,160,5,
13,0,192,152,0,64,208,128,151,0,64,162,64,208,128,161,0,192,156,0,64,208,
201,158,14,21,0,64,208,64,160,64,208,128,164,0,136,155,4,0,128,154,0,64,
162,64,208,128,158,0,73,163,9,227,64,208,128,154,0,201,160,51,108,0,64,
208,137,157,5,24,0,73,152,13,16,64,208,64,154,64,208,128,166,0,128,151,
0,128,156,0,72,173,8,64,208,128,161,0,64,161,64,208,192,152,0,64,208,128,
152,0,200,159,13,0,64,208,136,167,4,0,128,146,0,192,158,0,64,208,73,159,
13,24,64,208,64,152,64,208,128,156,0,136,154,4,0,64,148,64,208,128,156,
0,72,162,12,64,208,64,163,64,208,128,161,0,128,160,0,200,162,55,0,64,208,
73,160,9,29,64,208,128,144,0,137,154,5,12,0,136,152,4,0,128,145,0,192,158,
0,64,208,128,148,0,137,163,5,13,0,192,161,0,64,208,128,144,0,64,173,64,
208,128,154,0,64,161,64,208,73,161,9,28,64,208,128,158,0,137,157,5,12,0,
136,147,4,0,128,145,0,64,158,64,208,128,162,0,137,164,5,16,0,72,163,8,64,
208,128,157,0,128,162,0,64,173,64,208,128,158,0,137,168,5,16,0,136,165,
4,0,64,164,64,208,128,154,0,64,173,64,208,136,161,4,0,64,155,64,208,128,
161,0,64,134,64,208,137,154,5,16,0,136,148,4,0,64,147,64,208,128,161,0,
72,162,12,64,208,64,162,64,208,128,151,0,64,159,64,208,64,159,64,208,128,
158,0,192,145,0,64,208,201,158,14,104,0,64,208,136,163,4,0,128,160,0,201,
152,10,53,0,64,208,128,154,0,137,149,5,40,0,72,148,28,64,208,73,154,9,12,
64,208,128,159,0,128,148,0,64,163,64,208,64,152,64,208,128,147,0,64,146,
64,208,128,154,0,128,151,0,73,156,9,21,64,208,128,161,0,192,154,0,64,208,
136,166,4,0,128,158,0,64,157,64,208,192,162,0,64,208,136,161,4,0,128,152,
0,201,162,26,84,0,64,208,137,156,5,8,0,128,152,0,64,173,64,208,136,164,
4,0,128,152,0,201,160,14,50,0,64,208,136,164,4,0,128,162,0,192,159,0,64,
208,73,159,17,28,64,208,136,160,4,0,64,152,64,208,128,148,0,136,158,4,0,
64,157,64,208,128,162,0,128,160,0,192,161,0,64,208,128,148,0,201,164,19,
22,0,64,208,64,160,64,208,192,162,0,64,208,128,158,0,128,163,0,64,173,64,
208,72,159,8,64,208,128,154,0,64,155,64,208,64,152,64,208,128,161,0,82,
148,2,65,3,237,64,208,202,158,68,1,102,0,64,208,137,159,5,49,0,73,154,9,
17,64,208,128,159,0,192,148,0,64,208,128,148,0,64,158,64,208,73,161,9,20,
64,208,128,158,0,64,159,64,208,64,152,64,208,128,148,0,128,168,0,137,163,
5,8,0,128,162,0,128,168,0,73,151,9,83,64,208,128,154,0,73,146,9,63,64,208,
128,160,0,201,144,39,46,0,64,208,73,152,9,24,64,208,128,154,0,72,151,8,
64,208,128,163,0,64,146,64,208,128,158,0,192,154,0,64,208,128,160,0,64,
134,64,208,128,144,0,192,145,0,64,208,128,161,0,136,150,4,0,64,148,64,208,
128,150,0,201,155,10,46,0,64,208,128,161,0,72,154,16,64,208,137,150,5,8,
0,128,144,0,128,161,0,192,152,0,64,208,72,174,8,64,208,128,162,0,64,173,
64,208,128,162,0,72,157,150,64,208,201,152,126,138,0,64,208,73,160,13,72,
64,208,136,158,4,0,128,144,0,73,152,9,32,64,208,128,158,0,73,145,9,16,64,
208,128,158,0,64,144,64,208,128,158,0,64,146,64,208,128,158,0,72,158,8,
64,208,128,158,0,64,154,64,208,137,154,5,12,0,64,145,64,208,128,160,0,128,
158,0,73,163,13,32,64,208,136,160,4,0,128,158,0,72,162,8,64,208,128,158,
0,64,161,64,208,136,158,4,0,128,154,0,72,175,8,64,208,128,158,0,64,167,
64,208,128,158,0,136,147,4,0,192,146,0,64,208,128,160,0,64,162,64,208,128,
144,0,64,156,64,208,136,168,4,0,128,158,0,73,164,9,109,64,208,128,173,0,
201,161,26,74,0,64,208,73,159,9,16,64,208,128,148,0,136,154,4,0,128,144,
0,128,163,0,72,160,28,64,208,137,156,5,16,0,137,146,5,8,0,128,144,0,128,
152,0,136,162,4,0,128,159,0,192,159,0,64,208,137,158,5,12,0,136,152,4,0,
128,147,0,128,159,0,200,163,18,0,64,208,200,156,9,0,64,208,128,160,0,128,
145,0,192,162,0,64,208,128,162,0,201,168,10,30,0,64,208,128,152,0,72,166,
8,64,208,128,145,0,192,165,0,64,208,64,146,64,208,128,148,0,72,174,57,64,
208,73,161,17,28,64,208,64,168,64,208,64,158,64,208,128,160,0,64,157,64,
208,64,162,64,208,128,162,0,192,162,0,64,208,137,162,5,16,0,64,152,64,208,
136,173,4,0,128,154,0,128,173,0,64,173,64,208,136,167,4,0,64,162,64,208,
128,161,0,64,147,64,208,74,156,14,1,71,64,208,136,164,4,0,128,161,0,73,
148,9,236,64,208,128,145,0,201,146,22,216,0,64,208,137,163,5,12,0,64,152,
64,208,128,144,0,128,173,0,200,145,21,0,64,208,73,156,9,12,64,208,128,166,
0,128,148,0,128,161,0,192,144,0,64,208,73,156,17,84,64,208,136,158,4,0,
64,155,64,208,128,152,0,73,152,13,36,64,208,64,159,64,208,128,148,0,73,
148,9,20,64,208,128,144,0,64,146,64,208,64,156,64,208,128,164,0,128,151,
0,72,155,8,64,208,128,152,0,64,154,64,208,73,145,9,12,64,208,128,160,0,
128,144,0,64,164,64,208,128,148,0,73,161,13,69,64,208,136,158,4,0,128,144,
0,73,158,30,45,64,208,201,158,14,21,0,64,208,64,167,64,208,128,160,0,64,
148,64,208,128,156,0,128,160,0,64,157,64,208,136,165,4,0,64,162,64,208,
128,148,0,64,160,64,208,136,165,4,0,128,148,0,72,167,8,64,208,128,160,0,
64,163,64,208,128,160,0,64,147,64,208,136,173,4,0,128,156,0,73,154,9,70,
64,208,128,145,0,200,152,54,0,64,208,73,160,9,41,64,208,128,148,0,72,159,
8,64,208,128,157,0,192,144,0,64,208,137,155,5,12,0,136,154,4,0,128,147,
0,136,163,4,0,128,156,0,136,173,4,0,128,161,0,64,151,64,208,128,154,0,64,
155,64,208,128,144,0,73,164,13,81,64,208,136,163,4,0,128,156,0,73,160,13,
41,64,208,136,159,4,0,128,156,0,72,159,20,64,208,137,147,5,8,0,128,145,
0,64,162,64,208,128,155,0,192,158,0,64,208,128,154,0,64,161,64,208,137,
160,5,16,0,72,159,8,64,208,128,159,0,128,157,0,64,173,64,208,128,157,0,
137,173,5,13,0,192,165,0,64,208,128,154,0,128,175,0,64,149,64,208,73,157,
89,208,64,208,72,162,72,64,208,72,160,60,64,208,72,162,28,64,208,64,149,
64,208,64,155,64,208,64,149,64,208,64,154,64,208,64,158,64,208,128,156,
0,64,154,64,208,64,158,64,208,64,156,64,208,64,145,64,208,64,144,64,208,
64,157,64,208,128,154,0,64,149,64,208,128,155,0,64,161,64,208,64,156,64,
208,128,152,0,73,148,9,44,64,208,128,158,0,73,145,13,28,64,208,64,152,64,
208,128,162,0,64,144,64,208,72,161,8,64,208,128,162,0,128,154,0,64,147,
64,208,128,165,0,73,154,37,40,64,208,72,163,12,64,208,64,145,64,208,128,
163,0,64,158,64,208,64,148,64,208,64,144,64,208,64,160,64,208,128,164,0,
128,152,0,64,156,64,208,72,151,20,64,208,64,144,64,208,64,146,64,208,64,
158,64,208,128,148,0,64,149,64,208,64,161,64,208,128,161,0,137,163,5,85,
0,73,161,21,52,64,208,136,162,4,0,64,161,64,208,136,162,4,0,128,152,0,64,
159,64,208,137,158,5,12,0,64,154,64,208,128,158,0,64,160,64,208,64,163,
64,208,64,161,64,208,128,161,0,64,162,64,208,200,152,9,0,64,208,128,161,
0,64,149,64,208,64,162,64,208,64,152,64,208,128,161,0,72,165,8,64,208,128,
145,0,64,164,64,208,136,154,4,0,64,152,64,208,128,160,0,74,155,145,5,114,
64,208,73,157,13,85,64,208,64,156,64,208,128,154,0,73,152,9,52,64,208,128,
162,0,73,146,9,20,64,208,128,161,0,64,144,64,208,64,162,64,208,128,152,
0,64,147,64,208,72,159,12,64,208,64,145,64,208,128,151,0,64,156,64,208,
128,152,0,72,156,12,64,208,64,157,64,208,128,154,0,192,154,0,64,208,128,
151,0,73,161,9,33,64,208,128,173,0,201,159,10,21,0,64,208,128,161,0,64,
158,64,208,136,161,4,0,128,159,0,128,160,0,72,173,12,64,208,136,156,4,0,
128,145,0,192,162,0,64,208,128,159,0,82,152,2,157,2,229,64,208,74,157,47,
1,7,64,208,73,162,9,33,64,208,128,152,0,200,158,17,0,64,208,64,162,64,208,
64,163,64,208,128,160,0,64,144,64,208,128,158,0,64,173,64,208,128,148,0,
73,149,9,106,64,208,128,154,0,73,146,30,70,64,208,137,158,5,12,0,136,155,
4,0,128,154,0,64,162,64,208,192,152,0,64,208,128,159,0,200,145,9,0,64,208,
128,158,0,64,144,64,208,137,157,5,20,0,73,154,9,12,64,208,128,160,0,128,
148,0,128,156,0,136,166,4,0,128,162,0,72,148,16,64,208,72,159,8,64,208,
128,167,0,128,156,0,64,147,64,208,136,152,4,0,128,149,0,201,154,34,87,0,
64,208,73,156,9,24,64,208,128,152,0,72,155,12,64,208,64,152,64,208,128,
156,0,128,146,0,128,162,0,72,152,37,64,208,73,162,9,25,64,208,128,158,0,
201,157,10,13,0,64,208,128,161,0,128,144,0,128,159,0,136,175,4,0,128,164,
0,192,150,0,64,208,136,152,4,0,64,146,64,208,128,175,0,64,156,64,208,73,
159,9,12,64,208,128,158,0,128,152,0,64,173,64,208,128,150,0,202,162,73,
1,50,0,64,208,201,159,10,33,0,64,208,128,158,0,73,152,13,20,64,208,64,156,
64,208,128,159,0,136,148,4,0,128,144,0,128,158,0,201,163,10,17,0,64,208,
128,158,0,136,162,4,0,128,161,0,64,173,64,208,136,158,4,0,64,152,64,208,
128,157,0,201,160,54,186,0,64,208,73,152,17,32,64,208,64,162,64,208,64,
144,64,208,128,161,0,137,146,5,12,0,64,144,64,208,128,156,0,128,149,0,136,
173,4,0,64,154,64,208,64,158,64,208,128,156,0,72,159,80,64,208,201,160,
18,68,0,64,208,136,162,4,0,64,144,64,208,128,157,0,201,154,26,33,0,64,208,
137,160,5,16,0,64,154,64,208,64,157,64,208,128,158,0,128,161,0,64,147,64,
208,128,158,0,192,159,0,64,208,192,158,0,64,208,64,144,64,208,128,163,0,
136,167,4,0,128,166,0,64,158,64,208,73,157,9,37,64,208,128,159,0,73,152,
9,16,64,208,128,175,0,64,151,64,208,128,159,0,192,156,0,64,208,64,161,64,
208,128,152,0,137,161,5,8,0,128,159,0,128,162,0,64,161,64,208,137,158,5,
24,0,137,152,5,16,0,72,145,8,64,208,128,163,0,128,144,0,128,157,0,73,161,
9,16,64,208,128,144,0,64,159,64,208,128,148,0,128,173,0,73,165,17,60,64,
208,64,161,64,208,64,159,64,208,128,148,0,72,164,20,64,208,136,162,4,0,
64,160,64,208,64,160,64,208,128,144,0,64,163,64,208,137,161,5,16,0,72,157,
8,64,208,128,148,0,128,146,0,128,163,0,192,173,0,64,208,137,156,5,16,0,
72,154,8,64,208,128,161,0,128,152,0,64,162,64,208,64,152,64,208,128,157,
0,192,151,0,64,208,137,156,5,36,0,73,152,13,28,64,208,64,161,64,208,128,
159,0,136,151,4,0,64,146,64,208,136,162,4,0,128,157,0,128,155,0,73,161,
13,28,64,208,64,161,64,208,128,161,0,72,159,12,64,208,136,163,4,0,128,159,
0,128,157,0,128,167,0,64,154,64,208,202,157,11,1,55,0,64,208,128,145,0,
73,149,13,176,64,208,64,156,64,208,128,152,0,201,146,34,148,0,64,208,73,
157,13,20,64,208,64,158,64,208,128,163,0,136,152,4,0,128,147,0,136,161,
4,0,128,159,0,200,145,107,0,64,208,137,157,5,50,0,73,147,9,29,64,208,128,
144,0,137,145,5,13,0,192,144,0,64,208,128,156,0,64,146,64,208,128,155,0,
200,156,9,0,64,208,128,156,0,64,152,64,208,128,162,0,137,164,5,40,0,73,
161,21,28,64,208,72,159,8,64,208,128,154,0,64,158,64,208,128,158,0,64,159,
64,208,128,159,0,64,162,64,208,128,156,0,72,173,8,64,208,128,156,0,128,
166,0,64,144,64,208,128,148,0,72,148,8,64,208,128,154,0,64,147,64,208,128,
164,0,73,154,75,121,64,208,137,158,5,38,0,201,152,18,25,0,64,208,64,161,
64,208,64,155,64,208,128,161,0,136,151,4,0,128,145,0,192,155,0,64,208,128,
161,0,73,162,13,16,64,208,64,160,64,208,128,163,0,128,159,0,64,164,64,208,
64,160,64,208,64,166,64,208,128,145,0,72,152,38,64,208,201,158,10,26,0,
64,208,128,156,0,200,148,13,0,64,208,64,155,64,208,128,161,0,128,145,0,
136,162,4,0,128,161,0,192,150,0,64,208,128,162,0,128,156,0,73,162,38,150,
64,208,137,155,5,20,0,137,146,5,8,0,128,145,0,64,152,64,208,128,144,0,136,
159,4,0,192,158,0,64,208,128,173,0,73,160,29,101,64,208,137,154,5,12,0,
136,152,4,0,128,148,0,64,158,64,208,64,152,64,208,128,160,0,72,159,49,64,
208,73,160,9,29,64,208,128,161,0,73,157,9,12,64,208,128,158,0,128,151,0,
192,159,0,64,208,128,157,0,72,163,12,64,208,64,154,64,208,128,147,0,128,
161,0,64,158,64,208,72,156,12,64,208,64,164,64,208,128,159,0,64,154,64,
208,128,158,0,64,161,64,208,136,161,4,0,128,160,0,137,168,5,36,0,72,164,
20,64,208,73,163,9,12,64,208,128,157,0,128,155,0,128,173,0,64,163,64,208,
64,145,64,208,128,163,0,64,173,64,208,128,160,0,82,157,3,27,4,122,64,208,
74,159,42,2,81,64,208,73,161,13,28,64,208,64,173,64,208,128,152,0,137,158,
5,8,0,128,154,0,64,160,64,208,128,145,0,136,173,4,0,128,162,0,74,154,18,
1,251,64,208,72,173,8,64,208,128,161,0,128,145,0,137,148,5,8,0,128,145,
0,64,152,64,208,138,156,6,1,140,0,73,148,9,42,64,208,128,152,0,137,145,
5,18,0,192,144,0,64,208,192,147,0,64,208,128,152,0,64,147,64,208,72,160,
8,64,208,128,152,0,128,155,0,74,154,14,1,43,64,208,64,146,64,208,128,152,
0,192,152,0,64,208,201,158,14,128,0,64,208,64,152,64,208,128,151,0,137,
148,5,61,0,73,146,9,20,64,208,128,162,0,136,145,4,0,64,144,64,208,128,147,
0,192,147,0,64,208,64,149,64,208,64,158,64,208,64,155,64,208,64,157,64,
208,64,149,64,208,64,160,64,208,64,163,64,208,128,148,0,73,155,13,41,64,
208,136,165,4,0,128,146,0,72,154,16,64,208,137,159,5,8,0,128,144,0,128,
161,0,192,152,0,64,208,136,161,4,0,128,144,0,192,156,0,64,208,64,158,64,
208,128,148,0,201,164,14,125,0,64,208,136,156,4,0,128,154,0,201,161,30,
61,0,64,208,137,163,5,20,0,72,162,12,64,208,64,158,64,208,128,156,0,128,
154,0,128,173,0,72,160,16,64,208,72,173,8,64,208,128,161,0,128,164,0,64,
159,64,208,137,159,5,8,0,128,158,0,128,161,0,192,162,0,64,208,137,159,5,
38,0,200,158,21,0,64,208,64,167,64,208,64,156,64,208,64,144,64,208,128,
168,0,192,156,0,64,208,64,144,64,208,128,168,0,136,163,4,0,128,161,0,73,
168,9,24,64,208,128,159,0,72,167,8,64,208,128,156,0,64,165,64,208,128,156,
0,128,173,0,192,155,0,64,208,201,159,18,33,0,64,208,64,154,64,208,64,152,
64,208,128,161,0,72,158,8,64,208,128,159,0,64,147,64,208,128,173,0,72,162,
8,64,208,128,160,0,128,161,0,137,161,5,49,0,73,159,9,21,64,208,128,161,
0,192,158,0,64,208,64,154,64,208,128,160,0,64,160,64,208,73,162,9,16,64,
208,128,152,0,64,160,64,208,128,152,0,128,165,0,72,173,12,64,208,136,161,
4,0,128,155,0,192,162,0,64,208,137,152,5,12,0,64,144,64,208,128,161,0,128,
158,0,73,156,25,32,64,208,137,158,5,16,0,72,146,8,64,208,128,155,0,128,
145,0,128,162,0,64,155,64,208,128,158,0,192,158,0,64,208,136,162,4,0,128,
155,0,137,164,5,166,0,201,161,43,62,0,64,208,137,160,5,29,0,73,156,9,17,
64,208,128,157,0,192,152,0,64,208,128,158,0,64,159,64,208,128,158,0,136,
173,4,0,128,162,0,64,160,64,208,137,158,5,8,0,128,156,0,64,159,64,208,128,
156,0,64,162,64,208,73,156,9,45,64,208,128,152,0,73,149,9,20,64,208,128,
134,0,137,145,5,8,0,128,134,0,128,148,0,136,155,4,0,192,152,0,64,208,136,
161,4,0,128,152,0,201,162,19,30,0,64,208,200,163,9,0,64,208,128,156,0,128,
156,0,72,160,8,64,208,128,161,0,128,159,0,72,173,12,64,208,136,173,4,0,
128,152,0,192,163,0,64,208,128,161,0,200,173,25,0,64,208,137,161,5,16,0,
136,158,4,0,64,144,64,208,128,162,0,128,162,0,128,165,0,64,156,64,208,73,
157,21,198,64,208,72,162,8,64,208,128,159,0,64,152,64,208,128,152,0,201,
148,10,88,0,64,208,128,158,0,73,146,17,71,64,208,136,161,4,0,64,158,64,
208,128,148,0,72,145,12,64,208,136,162,4,0,128,157,0,192,144,0,64,208,201,
154,10,25,0,64,208,128,159,0,136,152,4,0,64,148,64,208,64,161,64,208,128,
157,0,192,156,0,64,208,64,155,64,208,128,161,0,64,147,64,208,128,146,0,
73,154,37,81,64,208,137,152,5,24,0,137,145,5,8,0,128,144,0,64,146,64,208,
64,159,64,208,128,163,0,136,158,4,0,128,154,0,200,152,37,0,64,208,73,154,
9,20,64,208,128,152,0,136,148,4,0,64,144,64,208,128,160,0,64,160,64,208,
64,152,64,208,128,162,0,64,150,64,208,128,162,0,192,156,0,64,208,128,158,
0,201,162,22,102,0,64,208,137,163,5,12,0,136,158,4,0,128,149,0,128,167,
0,73,160,9,61,64,208,128,154,0,72,159,12,64,208,136,158,4,0,128,148,0,192,
158,0,64,208,137,159,5,28,0,73,154,13,20,64,208,64,159,64,208,128,145,0,
64,150,64,208,128,148,0,128,158,0,136,164,4,0,128,160,0,64,161,64,208,73,
159,9,12,64,208,128,144,0,128,144,0,128,167,0,137,168,5,40,0,72,165,8,64,
208,128,147,0,64,163,64,208,137,161,5,20,0,64,155,64,208,64,148,64,208,
64,149,64,208,128,160,0,128,162,0,64,173,64,208,128,152,0,64,158,64,208,
202,157,19,1,18,0,64,208,137,158,5,8,0,128,150,0,128,162,0,201,149,10,97,
0,64,208,128,151,0,73,147,9,54,64,208,128,151,0,200,146,25,0,64,208,137,
151,5,12,0,136,146,4,0,128,145,0,136,163,4,0,128,154,0,192,144,0,64,208,
73,164,9,12,64,208,128,154,0,128,161,0,128,175,0,192,148,0,64,208,137,161,
5,17,0,136,159,4,0,192,148,0,64,208,128,158,0,72,164,8,64,208,128,163,0,
128,162,0,201,155,34,131,0,64,208,72,162,8,64,208,128,168,0,64,152,64,208,
72,163,8,64,208,128,146,0,64,159,64,208,128,154,0,200,154,82,0,64,208,137,
160,5,65,0,201,151,18,57,0,64,208,64,168,64,208,64,146,64,208,128,161,0,
64,145,64,208,64,155,64,208,64,149,64,208,64,161,64,208,64,165,64,208,64,
158,64,208,64,151,64,208,64,156,64,208,64,144,64,208,128,168,0,128,158,
0,72,162,8,64,208,128,145,0,128,161,0,64,152,64,208,137,154,5,8,0,128,146,
0,128,175,0,64,156,64,208,73,158,13,20,64,208,64,164,64,208,128,146,0,136,
148,4,0,128,145,0,128,162,0,201,162,42,178,0,64,208,137,162,5,20,0,72,160,
12,64,208,64,173,64,208,128,145,0,128,151,0,72,173,8,64,208,128,157,0,64,
168,64,208,128,155,0,201,160,22,114,0,64,208,136,152,4,0,64,148,64,208,
64,146,64,208,128,158,0,72,159,53,64,208,137,160,5,33,0,137,157,5,16,0,
72,152,8,64,208,128,147,0,128,148,0,192,159,0,64,208,136,161,4,0,128,156,
0,137,168,5,12,0,136,164,4,0,128,163,0,128,173,0,64,158,64,208,73,158,9,
24,64,208,128,159,0,64,146,64,208,64,158,64,208,64,147,64,208,128,146,0,
64,159,64,208,136,157,4,0,128,152,0,192,161,0,64,208,200,162,9,0,64,208,
128,158,0,192,154,0,64,208,128,160,0,73,165,9,54,64,208,128,148,0,200,164,
17,0,64,208,136,154,4,0,64,152,64,208,128,146,0,192,163,0,64,208,137,158,
5,20,0,72,154,8,64,208,128,151,0,64,152,64,208,128,160,0,128,161,0,192,
173,0,64,208,73,156,9,12,64,208,128,159,0,128,154,0,128,158,0,74,167,26,
7,195,64,208,137,160,5,12,0,136,158,4,0,128,145,0,64,173,64,208,128,160,
0,82,163,1,70,6,140,64,208,201,157,18,175,0,64,208,72,165,8,64,208,128,
163,0,128,145,0,73,150,9,88,64,208,128,164,0,73,147,17,52,64,208,136,166,
4,0,64,144,64,208,128,151,0,72,146,28,64,208,137,159,5,20,0,136,148,4,0,
64,147,64,208,64,161,64,208,128,167,0,128,160,0,64,145,64,208,128,148,0,
72,149,16,64,208,64,147,64,208,64,156,64,208,128,161,0,64,148,64,208,136,
161,4,0,128,148,0,201,155,10,41,0,64,208,128,159,0,72,154,16,64,208,136,
161,4,0,64,158,64,208,128,161,0,64,152,64,208,72,158,8,64,208,128,157,0,
128,157,0,192,156,0,64,208,137,154,5,16,0,72,146,8,64,208,128,161,0,128,
144,0,136,162,4,0,128,160,0,201,162,14,103,0,64,208,64,164,64,208,128,158,
0,73,160,37,77,64,208,73,158,9,16,64,208,128,147,0,136,154,4,0,128,147,
0,72,173,8,64,208,128,157,0,64,162,64,208,128,147,0,200,159,29,0,64,208,
137,155,5,20,0,64,146,64,208,64,158,64,208,64,161,64,208,128,158,0,128,
157,0,64,158,64,208,64,159,64,208,128,159,0,192,161,0,64,208,136,161,4,
0,128,154,0,73,173,9,33,64,208,128,160,0,72,164,16,64,208,136,161,4,0,64,
159,64,208,128,161,0,192,163,0,64,208,128,159,0,64,175,64,208,128,158,0,
82,161,2,176,4,20,64,208,202,158,48,1,125,0,64,208,137,152,5,28,0,136,148,
4,0,64,147,64,208,64,159,64,208,64,146,64,208,64,152,64,208,128,152,0,200,
158,9,0,64,208,128,160,0,128,157,0,201,150,10,145,0,64,208,128,162,0,73,
147,33,96,64,208,73,157,13,20,64,208,64,173,64,208,128,158,0,136,148,4,
0,128,145,0,136,159,4,0,128,158,0,73,145,21,36,64,208,137,161,5,12,0,136,
159,4,0,128,158,0,128,162,0,64,144,64,208,137,156,5,8,0,128,146,0,128,158,
0,64,146,64,208,137,157,5,12,0,136,148,4,0,128,144,0,72,175,8,64,208,128,
159,0,128,173,0,72,149,8,64,208,128,147,0,64,148,64,208,137,159,5,16,0,
137,154,5,8,0,128,145,0,128,158,0,72,168,8,64,208,128,145,0,128,164,0,73,
155,17,154,64,208,136,154,4,0,64,152,64,208,128,154,0,73,152,70,81,64,208,
73,156,13,40,64,208,136,162,4,0,128,152,0,73,151,9,20,64,208,128,152,0,
136,147,4,0,64,144,64,208,128,154,0,64,154,64,208,128,151,0,137,161,5,16,
0,72,159,8,64,208,128,162,0,128,158,0,192,163,0,64,208,128,156,0,64,151,
64,208,136,157,4,0,128,156,0,192,154,0,64,208,73,156,9,40,64,208,128,163,
0,73,146,13,20,64,208,64,156,64,208,128,164,0,136,145,4,0,128,144,0,64,
154,64,208,64,155,64,208,128,161,0,137,159,5,8,0,128,158,0,128,160,0,200,
157,9,0,64,208,128,165,0,192,156,0,64,208,137,155,5,17,0,200,152,9,0,64,
208,128,161,0,128,151,0,128,161,0,73,165,9,251,64,208,128,152,0,73,162,
50,202,64,208,137,159,5,33,0,137,146,5,25,0,192,144,0,64,208,137,152,5,
12,0,64,148,64,208,128,161,0,128,156,0,128,152,0,136,173,4,0,64,161,64,
208,128,146,0,201,160,34,115,0,64,208,137,157,5,20,0,137,152,5,12,0,64,
148,64,208,128,152,0,128,154,0,136,162,4,0,128,159,0,192,159,0,64,208,137,
154,5,36,0,73,147,9,16,64,208,128,152,0,136,146,4,0,128,144,0,136,152,4,
0,64,151,64,208,64,152,64,208,128,147,0,137,160,5,17,0,200,159,9,0,64,208,
128,156,0,128,158,0,136,173,4,0,64,161,64,208,73,152,9,12,64,208,128,148,
0,128,148,0,128,173,0,64,161,64,208,73,161,13,30,64,208,64,148,64,208,128,
156,0,200,156,9,0,64,208,128,168,0,192,152,0,64,208,128,163,0,128,165,0,
72,164,20,64,208,137,159,5,8,0,128,154,0,64,160,64,208,128,154,0,192,163,
0,64,208,136,161,4,0,64,152,64,208,136,162,4,0,128,156,0,201,173,26,37,
0,64,208,137,159,5,12,0,136,157,4,0,128,152,0,136,173,4,0,128,161,0,136,
167,4,0,64,166,64,208,128,160,0,136,175,4,0,64,174,64,208,128,162,0,64,
160,64,208,137,158,5,181,0,73,152,13,99,64,208,136,162,4,0,128,154,0,201,
147,14,43,0,64,208,136,166,4,0,128,152,0,200,145,21,0,64,208,73,152,9,12,
64,208,128,159,0,128,149,0,128,161,0,192,144,0,64,208,128,159,0,72,151,
12,64,208,64,161,64,208,128,161,0,64,148,64,208,137,154,5,16,0,137,150,
5,8,0,128,145,0,128,151,0,137,159,5,8,0,128,158,0,128,161,0,201,156,38,
58,0,64,208,137,158,5,16,0,137,151,5,8,0,128,145,0,128,156,0,73,161,9,12,
64,208,128,145,0,128,159,0,128,166,0,200,155,9,0,64,208,128,161,0,64,154,
64,208,136,159,4,0,128,145,0,64,157,64,208,137,158,5,12,0,64,152,64,208,
128,161,0,128,161,0,201,163,19,152,0,64,208,192,145,0,64,208,64,158,64,
208,128,159,0,73,161,49,102,64,208,137,152,5,32,0,73,146,13,16,64,208,64,
173,64,208,128,148,0,128,144,0,64,148,64,208,64,158,64,208,128,148,0,137,
159,5,8,0,128,158,0,128,161,0,200,160,25,0,64,208,137,161,5,12,0,136,160,
4,0,128,155,0,136,175,4,0,128,162,0,192,159,0,64,208,137,158,5,16,0,136,
152,4,0,64,148,64,208,128,152,0,136,163,4,0,128,162,0,64,162,64,208,137,
155,5,24,0,136,154,4,0,64,148,64,208,136,174,4,0,64,152,64,208,128,174,
0,128,162,0,137,167,5,16,0,136,166,4,0,64,164,64,208,128,160,0,128,169,
0,192,162,0,64,208,73,157,13,138,64,208,136,159,4,0,128,154,0,73,150,9,
85,64,208,128,148,0,73,148,34,61,64,208,137,164,5,20,0,136,158,4,0,64,152,
64,208,136,174,4,0,128,156,0,192,174,0,64,208,128,147,0,136,146,4,0,64,
144,64,208,137,158,5,12,0,136,154,4,0,128,152,0,64,159,64,208,128,156,0,
64,149,64,208,64,161,64,208,64,151,64,208,128,155,0,201,152,22,29,0,64,
208,64,161,64,208,136,158,4,0,64,152,64,208,128,151,0,64,151,64,208,128,
145,0,64,154,64,208,136,145,4,0,128,144,0,201,162,19,142,0,64,208,200,163,
9,0,64,208,128,156,0,128,154,0,73,160,45,111,64,208,73,152,13,32,64,208,
64,147,64,208,128,158,0,73,145,9,12,64,208,128,152,0,128,144,0,64,147,64,
208,128,158,0,136,161,4,0,128,154,0,200,159,42,0,64,208,201,159,10,21,0,
64,208,128,152,0,137,156,5,8,0,128,154,0,128,158,0,136,163,4,0,64,162,64,
208,64,163,64,208,128,156,0,192,158,0,64,208,137,154,5,12,0,64,146,64,208,
128,161,0,64,161,64,208,128,148,0,192,161,0,64,208,136,146,4,0,128,144,
0,201,173,10,18,0,64,208,128,163,0,192,163,0,64,208,128,173,0,128,174,0,
73,165,138,253,64,208,201,155,10,88,0,64,208,128,161,0,201,148,14,47,0,
64,208,64,156,64,208,128,158,0,200,146,9,0,64,208,128,149,0,64,144,64,208,
200,164,13,0,64,208,64,144,64,208,128,154,0,64,161,64,208,128,148,0,64,
152,64,208,64,148,64,208,72,157,20,64,208,64,152,64,208,64,154,64,208,136,
158,4,0,128,154,0,128,154,0,137,159,5,24,0,72,158,16,64,208,72,175,8,64,
208,128,162,0,128,148,0,128,156,0,64,161,64,208,136,164,4,0,192,148,0,64,
208,64,156,64,208,128,158,0,64,164,64,208,73,159,9,79,64,208,128,158,0,
201,154,31,54,0,64,208,73,152,9,12,64,208,128,161,0,128,144,0,192,161,0,
64,208,64,152,64,208,128,151,0,137,145,5,12,0,64,134,64,208,128,159,0,64,
152,64,208,136,161,4,0,128,159,0,200,158,9,0,64,208,128,154,0,64,156,64,
208,128,159,0,137,163,5,25,0,137,161,5,8,0,128,160,0,192,162,0,64,208,136,
158,4,0,128,152,0,136,173,4,0,128,166,0,64,166,64,208,201,160,10,21,0,64,
208,128,158,0,64,159,64,208,64,160,64,208,128,160,0,64,173,64,208,128,152,
0,82,173,1,106,1,174,64,208,73,157,29,179,64,208,73,154,9,16,64,208,128,
152,0,64,152,64,208,128,152,0,64,173,64,208,128,164,0,137,150,5,75,0,201,
146,31,63,0,64,208,137,156,5,21,0,72,154,8,64,208,128,164,0,192,148,0,64,
208,128,156,0,128,161,0,72,145,20,64,208,72,155,12,64,208,64,152,64,208,
128,160,0,128,152,0,192,144,0,64,208,64,162,64,208,128,161,0,64,148,64,
208,128,159,0,201,154,31,51,0,64,208,137,154,5,17,0,136,151,4,0,192,145,
0,64,208,128,161,0,64,162,64,208,128,163,0,200,152,17,0,64,208,137,160,
5,8,0,128,159,0,128,161,0,128,151,0,64,156,64,208,137,159,5,17,0,136,156,
4,0,192,152,0,64,208,128,154,0,128,161,0,201,162,30,120,0,64,208,73,158,
9,20,64,208,128,156,0,136,155,4,0,64,152,64,208,128,161,0,128,161,0,201,
160,30,65,0,64,208,136,162,4,0,64,144,64,208,64,159,64,208,64,160,64,208,
64,158,64,208,128,164,0,72,159,28,64,208,137,159,5,16,0,137,154,5,8,0,128,
145,0,128,155,0,136,161,4,0,128,160,0,64,158,64,208,128,152,0,192,161,0,
64,208,137,156,5,17,0,136,152,4,0,192,144,0,64,208,128,162,0,128,159,0,
73,168,9,36,64,208,128,155,0,72,164,20,64,208,137,154,5,12,0,64,152,64,
208,128,160,0,128,162,0,64,163,64,208,128,159,0,64,173,64,208,72,156,8,
64,208,128,158,0,64,146,64,208,128,162,0,73,169,9,57,64,208,128,163,0,64,
168,64,208,137,158,5,25,0,137,152,5,17,0,64,146,64,208,192,161,0,64,208,
128,156,0,128,154,0,72,163,8,64,208,128,147,0,64,159,64,208,136,160,4,0,
128,148,0,64,171,64,208,64,161,64,208,128,152,0,72,175,12,64,208,136,159,
4,0,128,152,0,64,174,64,208,73,157,13,20,64,208,64,162,64,208,128,162,0,
64,146,64,208,128,149,0,64,159,64,208,128,151,0,82,162,32,99,183,129,80,
208,32,86,210,158,3,138,20,213,0,64,208,202,158,39,1,211,0,64,208,73,157,
9,24,64,208,128,161,0,136,146,4,0,64,134,64,208,64,159,64,208,128,159,0,
64,158,64,208,128,159,0,73,152,67,220,64,208,201,160,10,46,0,64,208,128,
158,0,201,152,10,21,0,64,208,128,173,0,64,144,64,208,64,155,64,208,128,
156,0,64,159,64,208,64,154,64,208,64,160,64,208,128,158,0,72,164,8,64,208,
128,146,0,64,163,64,208,128,163,0,73,148,37,117,64,208,137,155,5,16,0,136,
145,4,0,64,144,64,208,128,154,0,72,174,8,64,208,128,145,0,64,173,64,208,
128,159,0,73,145,13,37,64,208,64,156,64,208,128,154,0,64,144,64,208,201,
159,10,17,0,64,208,128,159,0,64,152,64,208,128,162,0,128,162,0,64,147,64,
208,73,159,9,28,64,208,128,152,0,72,152,16,64,208,64,160,64,208,64,160,
64,208,128,158,0,128,147,0,72,163,8,64,208,128,159,0,128,161,0,200,151,
25,0,64,208,72,157,16,64,208,64,152,64,208,64,145,64,208,128,158,0,128,
156,0,64,150,64,208,64,145,64,208,128,155,0,73,155,13,84,64,208,64,159,
64,208,128,152,0,72,154,44,64,208,73,154,9,28,64,208,128,152,0,136,147,
4,0,64,144,64,208,64,156,64,208,64,144,64,208,128,154,0,72,159,8,64,208,
128,145,0,128,156,0,64,153,64,208,64,162,64,208,64,149,64,208,64,160,64,
208,64,172,64,208,64,149,64,208,128,160,0,72,157,36,64,208,73,154,9,20,
64,208,128,156,0,136,145,4,0,64,144,64,208,128,159,0,72,160,8,64,208,128,
161,0,128,159,0,64,156,64,208,73,152,9,44,64,208,128,155,0,73,149,9,24,
64,208,128,151,0,64,147,64,208,136,163,4,0,64,148,64,208,128,154,0,64,151,
64,208,64,173,64,208,128,155,0,73,161,25,37,64,208,64,154,64,208,64,144,
64,208,64,146,64,208,64,152,64,208,128,144,0,192,154,0,64,208,64,152,64,
208,128,162,0,128,164,0,74,164,42,1,73,64,208,137,156,5,24,0,73,152,13,
16,64,208,64,150,64,208,128,154,0,128,144,0,128,154,0,136,164,4,0,64,162,
64,208,128,154,0,201,161,46,242,0,64,208,137,157,5,28,0,73,152,9,16,64,
208,128,154,0,64,151,64,208,128,157,0,64,156,64,208,128,161,0,72,173,8,
64,208,128,160,0,128,166,0,72,160,125,64,208,137,151,5,100,0,73,146,9,16,
64,208,128,151,0,64,144,64,208,128,162,0,64,147,64,208,73,159,17,64,64,
208,64,160,64,208,64,149,64,208,128,148,0,64,158,64,208,64,145,64,208,64,
158,64,208,64,160,64,208,64,163,64,208,64,148,64,208,64,158,64,208,64,146,
64,208,64,144,64,208,64,157,64,208,64,152,64,208,128,149,0,64,161,64,208,
64,152,64,208,128,157,0,72,161,12,64,208,64,144,64,208,128,165,0,192,158,
0,64,208,128,158,0,64,159,64,208,73,160,17,64,64,208,72,175,8,64,208,128,
155,0,128,161,0,72,158,44,64,208,72,161,24,64,208,64,170,64,208,64,149,
64,208,64,156,64,208,64,154,64,208,128,144,0,64,159,64,208,64,155,64,208,
64,144,64,208,128,157,0,128,151,0,128,162,0,200,163,17,0,64,208,72,157,
8,64,208,128,145,0,128,151,0,64,162,64,208,137,160,5,17,0,200,152,9,0,64,
208,128,164,0,128,145,0,136,173,4,0,128,168,0,73,167,29,85,64,208,72,155,
12,64,208,64,152,64,208,128,162,0,64,148,64,208,64,163,64,208,128,159,0,
200,166,29,0,64,208,72,159,12,64,208,64,161,64,208,128,159,0,64,157,64,
208,64,152,64,208,128,162,0,64,165,64,208,73,158,9,16,64,208,128,148,0,
136,156,4,0,128,155,0,136,164,4,0,128,162,0,200,173,13,0,64,208,136,173,
4,0,128,161,0,128,168,0,74,150,30,11,150,64,208,137,165,5,12,0,136,161,
4,0,128,148,0,64,173,64,208,64,160,64,208,128,163,0,210,146,1,174,4,205,
0,64,208,202,157,19,1,17,0,64,208,72,173,8,64,208,128,159,0,128,148,0,73,
149,25,183,64,208,64,160,64,208,64,145,64,208,64,163,64,208,64,155,64,208,
128,172,0,201,146,104,135,0,64,208,73,154,25,70,64,208,72,163,8,64,208,
128,161,0,64,152,64,208,64,161,64,208,128,163,0,137,148,5,34,0,64,144,64,
208,72,163,8,64,208,128,155,0,64,152,64,208,192,163,0,64,208,192,160,0,
64,208,128,173,0,64,152,64,208,64,154,64,208,128,163,0,73,161,13,24,64,
208,64,154,64,208,128,163,0,64,159,64,208,64,161,64,208,128,163,0,128,167,
0,72,145,12,64,208,64,147,64,208,128,163,0,64,144,64,208,136,162,4,0,64,
152,64,208,136,163,4,0,128,152,0,136,148,4,0,64,147,64,208,137,163,5,12,
0,64,162,64,208,128,163,0,128,168,0,73,154,17,52,64,208,137,156,5,8,0,128,
144,0,128,158,0,72,152,32,64,208,73,157,17,24,64,208,64,162,64,208,64,158,
64,208,128,161,0,64,156,64,208,128,161,0,128,166,0,128,151,0,64,156,64,
208,137,154,5,12,0,136,152,4,0,128,145,0,128,161,0,73,163,13,113,64,208,
64,151,64,208,128,152,0,73,160,9,48,64,208,128,151,0,136,159,4,0,64,158,
64,208,72,154,8,64,208,128,163,0,64,153,64,208,64,148,64,208,64,158,64,
208,64,148,64,208,64,171,64,208,128,160,0,72,162,36,64,208,137,160,5,16,
0,72,154,8,64,208,128,163,0,128,152,0,64,174,64,208,64,157,64,208,64,149,
64,208,128,160,0,192,161,0,64,208,136,158,4,0,64,146,64,208,128,163,0,73,
173,21,28,64,208,137,155,5,12,0,64,154,64,208,128,161,0,128,163,0,136,167,
4,0,128,166,0,64,174,64,208,128,151,0,82,144,2,109,2,136,64,208,74,156,
126,1,71,64,208,73,152,21,68,64,208,64,155,64,208,64,157,64,208,64,144,
64,208,128,148,0,73,148,13,40,64,208,64,158,64,208,128,154,0,64,145,64,
208,64,158,64,208,64,146,64,208,64,166,64,208,64,157,64,208,64,152,64,208,
128,162,0,64,149,64,208,128,154,0,73,159,37,44,64,208,136,162,4,0,64,158,
64,208,64,159,64,208,64,149,64,208,64,167,64,208,64,144,64,208,64,162,64,
208,128,172,0,64,155,64,208,128,144,0,64,161,64,208,128,158,0,73,150,9,
84,64,208,128,148,0,73,147,17,48,64,208,136,159,4,0,64,144,64,208,128,151,
0,72,146,24,64,208,73,154,9,16,64,208,128,160,0,64,152,64,208,128,144,0,
128,161,0,64,144,64,208,128,167,0,64,148,64,208,137,154,5,16,0,136,152,
4,0,64,144,64,208,128,151,0,64,155,64,208,128,146,0,73,154,58,93,64,208,
137,160,5,29,0,73,154,9,16,64,208,128,159,0,64,146,64,208,128,148,0,192,
159,0,64,208,128,158,0,136,164,4,0,64,162,64,208,64,152,64,208,64,146,64,
208,64,152,64,208,128,157,0,72,153,12,64,208,64,145,64,208,128,158,0,64,
152,64,208,73,161,9,16,64,208,128,159,0,136,152,4,0,128,151,0,128,164,0,
64,155,64,208,72,162,12,64,208,64,173,64,208,128,154,0,192,154,0,64,208,
128,158,0,73,161,26,191,64,208,201,161,10,13,0,64,208,128,160,0,128,152,
0,64,166,64,208,128,158,0,73,159,38,105,64,208,73,152,9,16,64,208,128,161,
0,136,146,4,0,128,145,0,200,158,13,0,64,208,64,152,64,208,128,167,0,128,
155,0,72,158,28,64,208,73,158,13,20,64,208,64,159,64,208,128,162,0,136,
157,4,0,128,152,0,128,164,0,64,157,64,208,137,165,5,20,0,72,162,8,64,208,
128,154,0,64,144,64,208,128,159,0,72,174,8,64,208,128,147,0,64,173,64,208,
128,145,0,64,160,64,208,201,152,14,37,0,64,208,64,173,64,208,128,155,0,
73,147,17,20,64,208,136,163,4,0,64,159,64,208,128,152,0,128,145,0,128,148,
0,136,159,4,0,64,154,64,208,136,160,4,0,64,158,64,208,128,156,0,73,168,
53,84,64,208,73,156,9,40,64,208,128,152,0,64,147,64,208,73,162,9,24,64,
208,128,163,0,72,152,8,64,208,128,146,0,64,144,64,208,128,163,0,128,163,
0,64,159,64,208,128,152,0,136,163,4,0,64,162,64,208,72,157,20,64,208,64,
152,64,208,64,152,64,208,64,161,64,208,128,165,0,128,148,0,64,173,64,208,
136,160,4,0,128,157,0,64,134,64,208,73,156,9,12,64,208,128,158,0,128,144,
0,64,161,64,208,64,134,64,208,128,162,0,192,145,0,64,208,201,157,14,74,
0,64,208,64,158,64,208,128,161,0,137,148,5,33,0,201,146,10,21,0,64,208,
128,154,0,64,144,64,208,136,159,4,0,128,148,0,64,147,64,208,128,156,0,73,
154,13,20,64,208,136,166,4,0,128,144,0,64,152,64,208,128,159,0,64,156,64,
208,128,159,0,73,161,29,56,64,208,137,158,5,16,0,136,156,4,0,64,146,64,
208,128,154,0,136,163,4,0,128,161,0,73,159,17,20,64,208,136,158,4,0,64,
152,64,208,128,146,0,128,158,0,64,160,64,208,128,163,0,137,165,5,13,0,192,
162,0,64,208,128,152,0,128,166,0,202,148,157,2,128,0,64,208,73,157,17,97,
64,208,136,164,4,0,64,152,64,208,128,162,0,73,151,9,44,64,208,128,148,0,
73,147,9,28,64,208,128,145,0,72,146,8,64,208,128,150,0,64,144,64,208,64,
162,64,208,128,163,0,64,149,64,208,128,151,0,201,154,18,29,0,64,208,137,
161,5,8,0,128,144,0,128,163,0,64,152,64,208,136,161,4,0,128,157,0,64,156,
64,208,128,144,0,137,163,5,36,0,73,161,9,24,64,208,128,154,0,72,160,8,64,
208,128,159,0,64,158,64,208,128,152,0,64,162,64,208,128,163,0,137,168,5,
13,0,192,164,0,64,208,128,154,0,128,175,0,64,147,64,208,74,158,14,1,31,
64,208,136,156,4,0,128,154,0,73,150,9,119,64,208,128,152,0,73,146,13,91,
64,208,64,157,64,208,128,154,0,72,145,8,64,208,128,151,0,64,144,64,208,
73,156,25,41,64,208,64,173,64,208,64,163,64,208,136,159,4,0,64,152,64,208,
128,159,0,72,154,13,64,208,192,152,0,64,208,128,152,0,128,152,0,200,162,
13,0,64,208,136,163,4,0,128,144,0,192,161,0,64,208,136,163,4,0,128,144,
0,136,149,4,0,64,147,64,208,72,159,8,64,208,128,163,0,128,152,0,137,155,
5,103,0,200,154,25,0,64,208,72,161,8,64,208,128,162,0,64,159,64,208,64,
159,64,208,128,162,0,64,152,64,208,201,152,18,37,0,64,208,136,154,4,0,64,
152,64,208,128,154,0,137,146,5,16,0,64,144,64,208,64,156,64,208,128,151,
0,128,147,0,137,161,5,29,0,192,156,0,64,208,64,173,64,208,64,163,64,208,
136,159,4,0,64,152,64,208,128,159,0,128,173,0,72,157,24,64,208,137,155,
5,16,0,136,152,4,0,64,147,64,208,128,163,0,128,163,0,64,156,64,208,73,159,
9,20,64,208,128,152,0,72,146,8,64,208,128,166,0,128,144,0,128,162,0,137,
164,5,145,0,73,161,45,94,64,208,137,157,5,16,0,137,146,5,8,0,128,144,0,
128,154,0,73,165,9,16,64,208,128,144,0,64,159,64,208,128,144,0,64,173,64,
208,128,156,0,72,160,12,64,208,136,163,4,0,128,154,0,192,159,0,64,208,137,
154,5,16,0,136,152,4,0,64,147,64,208,128,154,0,200,163,13,0,64,208,64,152,
64,208,128,155,0,128,158,0,200,163,21,0,64,208,72,161,12,64,208,64,163,
64,208,128,160,0,128,154,0,192,162,0,64,208,200,163,17,0,64,208,64,152,
64,208,64,152,64,208,128,159,0,128,155,0,73,173,13,36,64,208,136,163,4,
0,128,152,0,72,166,12,64,208,64,151,64,208,128,157,0,64,165,64,208,136,
163,4,0,128,146,0,64,174,64,208,136,154,4,0,128,152,0,64,149,64,208,74,
160,218,2,25,64,208,73,156,109,156,64,208,64,158,64,208,73,161,21,68,64,
208,64,156,64,208,64,149,64,208,64,161,64,208,128,172,0,64,159,64,208,72,
160,24,64,208,64,152,64,208,64,157,64,208,64,162,64,208,64,149,64,208,128,
160,0,64,155,64,208,64,149,64,208,64,157,64,208,64,154,64,208,128,144,0,
64,163,64,208,64,159,64,208,64,144,64,208,64,154,64,208,64,158,64,208,64,
146,64,208,64,154,64,208,128,144,0,73,149,21,32,64,208,64,146,64,208,64,
161,64,208,64,144,64,208,128,162,0,64,144,64,208,64,154,64,208,128,162,
0,64,154,64,208,64,161,64,208,64,158,64,208,128,159,0,72,163,40,64,208,
64,159,64,208,64,160,64,208,64,144,64,208,64,146,64,208,64,155,64,208,64,
149,64,208,64,157,64,208,64,152,64,208,128,149,0,64,160,64,208,64,144,64,
208,64,154,64,208,128,162,0,73,157,37,176,64,208,64,151,64,208,64,158,64,
208,64,148,64,208,64,144,64,208,64,162,64,208,64,167,64,208,64,152,64,208,
128,154,0,72,155,76,64,208,72,158,12,64,208,64,160,64,208,128,148,0,64,
149,64,208,72,164,20,64,208,64,152,64,208,64,155,64,208,64,172,64,208,128,
156,0,64,156,64,208,64,144,64,208,64,160,64,208,64,154,64,208,64,149,64,
208,64,162,64,208,64,152,64,208,64,157,64,208,128,147,0,64,154,64,208,72,
161,48,64,208,64,162,64,208,64,152,64,208,64,155,64,208,64,172,64,208,64,
155,64,208,64,149,64,208,64,147,64,208,64,159,64,208,64,160,64,208,64,158,
64,208,128,156,0,64,158,64,208,64,160,64,208,128,144,0,72,159,112,64,208,
64,155,64,208,64,158,64,208,73,157,25,80,64,208,64,144,64,208,64,161,64,
208,64,158,64,208,64,161,64,208,128,171,0,72,146,40,64,208,64,149,64,208,
64,157,64,208,64,162,64,208,64,152,64,208,64,155,64,208,64,175,64,208,64,
162,64,208,64,158,64,208,128,160,0,64,145,64,208,64,155,64,208,64,158,64,
208,128,154,0,64,159,64,208,64,163,64,208,64,168,64,208,64,154,64,208,128,
152,0,64,158,64,208,64,160,64,208,72,156,12,64,208,64,149,64,208,128,165,
0,64,146,64,208,64,149,64,208,128,160,0,82,165,1,243,2,11,64,208,73,157,
45,168,64,208,72,158,20,64,208,64,159,64,208,64,144,64,208,64,160,64,208,
128,154,0,64,144,64,208,64,148,64,208,64,151,64,208,64,158,64,208,128,160,
0,73,151,29,92,64,208,64,144,64,208,64,148,64,208,64,144,64,208,64,157,
64,208,64,152,64,208,128,149,0,73,147,13,36,64,208,64,144,64,208,128,151,
0,64,144,64,208,64,157,64,208,64,144,64,208,64,155,64,208,64,152,64,208,
128,151,0,64,148,64,208,64,152,64,208,64,151,64,208,64,144,64,208,64,153,
64,208,64,157,64,208,128,144,0,72,156,12,64,208,64,149,64,208,128,165,0,
64,154,64,208,64,144,64,208,64,160,64,208,64,162,64,208,128,171,0,73,161,
33,252,64,208,64,144,64,208,64,155,64,208,64,164,64,208,64,149,64,208,64,
162,64,208,64,154,64,208,128,144,0,73,159,101,184,64,208,73,158,21,72,64,
208,64,156,64,208,64,158,64,208,64,169,64,208,128,172,0,72,155,28,64,208,
64,144,64,208,64,161,64,208,64,162,64,208,64,152,64,208,64,157,64,208,128,
171,0,64,144,64,208,64,161,64,208,64,159,64,208,64,158,64,208,64,160,64,
208,128,162,0,64,160,64,208,64,158,64,208,64,166,64,208,64,149,64,208,64,
161,64,208,128,161,0,64,158,64,208,73,161,21,64,64,208,64,156,64,208,64,
158,64,208,64,162,64,208,128,160,0,64,145,64,208,64,161,64,208,64,155,64,
208,64,163,64,208,64,150,64,208,64,152,64,208,64,146,64,208,64,144,64,208,
64,157,64,208,64,152,64,208,128,149,0,64,162,64,208,64,167,64,208,64,149,
64,208,128,162,0,64,160,64,208,64,149,64,208,64,147,64,208,64,155,64,208,
64,144,64,208,64,156,64,208,64,149,64,208,64,157,64,208,128,162,0,72,166,
20,64,208,64,149,64,208,64,157,64,208,64,162,64,208,128,160,0,64,163,64,
208,72,161,24,64,208,64,155,64,208,64,158,64,208,64,146,64,208,64,152,64,
208,128,175,0,64,147,64,208,64,155,64,208,64,149,64,208,64,160,64,208,64,
158,64,208,128,148,0,200,164,13,0,64,208,136,158,4,0,128,144,0,64,161,64,
208,136,158,4,0,128,157,0,128,168,0,74,155,32,3,156,64,208,201,160,10,17,
0,64,208,128,161,0,64,159,64,208,128,165,0,192,173,0,64,208,128,166,0,82,
152,1,226,2,134,64,208,73,157,9,212,64,208,128,147,0,73,148,13,106,64,208,
64,158,64,208,128,162,0,73,146,17,62,64,208,72,160,8,64,208,128,158,0,128,
155,0,72,145,16,64,208,72,158,8,64,208,128,165,0,128,152,0,192,144,0,64,
208,137,166,5,17,0,192,161,0,64,208,64,163,64,208,128,160,0,64,173,64,208,
128,166,0,64,147,64,208,73,160,13,24,64,208,64,144,64,208,128,165,0,136,
159,4,0,64,147,64,208,128,157,0,128,165,0,201,154,22,50,0,64,208,136,166,
4,0,64,158,64,208,64,159,64,208,128,160,0,72,152,16,64,208,137,160,5,8,
0,128,156,0,128,166,0,192,150,0,64,208,136,162,4,0,128,154,0,64,156,64,
208,73,161,17,36,64,208,64,159,64,208,64,152,64,208,128,154,0,72,158,8,
64,208,128,156,0,64,144,64,208,64,165,64,208,128,156,0,64,164,64,208,128,
154,0,73,163,29,197,64,208,137,161,5,16,0,72,152,8,64,208,128,173,0,128,
145,0,136,173,4,0,128,163,0,73,161,54,129,64,208,73,161,13,41,64,208,136,
163,4,0,128,144,0,73,152,9,17,64,208,128,151,0,192,145,0,64,208,128,152,
0,64,157,64,208,64,163,64,208,128,156,0,136,173,4,0,128,163,0,72,160,36,
64,208,137,165,5,20,0,72,163,8,64,208,128,161,0,64,146,64,208,128,162,0,
72,173,8,64,208,128,161,0,128,166,0,64,159,64,208,73,161,9,24,64,208,128,
158,0,73,152,9,12,64,208,128,161,0,128,145,0,128,156,0,136,167,4,0,64,163,
64,208,128,159,0,64,162,64,208,73,155,9,24,64,208,128,159,0,64,145,64,208,
136,159,4,0,64,152,64,208,128,162,0,64,162,64,208,64,152,64,208,128,159,
0,73,168,13,37,64,208,64,160,64,208,128,148,0,200,166,13,0,64,208,64,173,
64,208,128,156,0,64,165,64,208,136,156,4,0,128,145,0,64,173,64,208,137,
159,5,17,0,136,156,4,0,192,152,0,64,208,128,156,0,136,164,4,0,128,162,0,
192,151,0,64,208,73,157,9,91,64,208,128,159,0,201,152,10,54,0,64,208,128,
144,0,201,147,18,37,0,64,208,64,158,64,208,64,152,64,208,128,144,0,72,146,
16,64,208,137,156,5,8,0,128,144,0,128,157,0,128,134,0,64,148,64,208,128,
146,0,73,155,9,16,64,208,128,159,0,64,154,64,208,128,152,0,192,156,0,64,
208,64,158,64,208,128,152,0,73,161,17,49,64,208,72,155,8,64,208,128,150,
0,128,154,0,73,159,17,24,64,208,137,156,5,8,0,128,154,0,128,159,0,64,158,
64,208,128,146,0,192,160,0,64,208,128,158,0,73,163,9,16,64,208,128,161,
0,64,162,64,208,128,134,0,128,167,0,192,154,0,64,208,73,156,13,121,64,208,
64,152,64,208,128,162,0,137,149,5,77,0,201,146,14,37,0,64,208,64,160,64,
208,128,148,0,72,145,12,64,208,136,156,4,0,128,152,0,64,144,64,208,64,159,
64,208,128,154,0,72,148,24,64,208,73,160,9,16,64,208,128,156,0,136,159,
4,0,128,144,0,128,161,0,64,147,64,208,64,159,64,208,128,163,0,137,154,5,
24,0,72,152,12,64,208,136,157,4,0,128,148,0,64,151,64,208,128,165,0,64,
155,64,208,128,160,0,201,163,19,80,0,64,208,136,156,4,0,192,152,0,64,208,
128,154,0,73,160,13,37,64,208,136,164,4,0,128,161,0,72,158,8,64,208,128,
159,0,192,157,0,64,208,72,159,8,64,208,128,151,0,128,154,0,72,162,8,64,
208,128,161,0,192,161,0,64,208,72,159,8,64,208,128,148,0,128,157,0,73,168,
13,29,64,208,136,152,4,0,128,151,0,200,165,9,0,64,208,128,159,0,64,164,
64,208,128,161,0,64,173,64,208,136,148,4,0,128,144,0,208,157,1,17,0,64,
208,73,157,13,155,64,208,136,166,4,0,128,148,0,73,149,9,40,64,208,128,163,
0,73,146,17,24,64,208,72,173,8,64,208,128,148,0,128,148,0,136,145,4,0,128,
144,0,64,147,64,208,128,163,0,201,154,18,77,0,64,208,137,162,5,8,0,128,
144,0,128,166,0,72,152,48,64,208,137,160,5,36,0,64,152,64,208,137,161,5,
16,0,64,154,64,208,64,152,64,208,128,159,0,64,175,64,208,64,155,64,208,
128,152,0,64,162,64,208,128,152,0,64,151,64,208,64,157,64,208,128,159,0,
192,156,0,64,208,192,154,0,64,208,64,158,64,208,64,157,64,208,64,147,64,
208,128,158,0,201,163,18,84,0,64,208,64,152,64,208,64,146,64,208,128,146,
0,73,161,9,51,64,208,128,159,0,200,160,13,0,64,208,64,146,64,208,128,148,
0,192,159,0,64,208,201,154,10,17,0,64,208,128,158,0,136,146,4,0,128,144,
0,136,163,4,0,128,159,0,64,162,64,208,137,156,5,8,0,128,148,0,128,160,0,
137,167,5,20,0,136,166,4,0,64,165,64,208,136,154,4,0,128,151,0,64,173,64,
208,128,163,0,192,156,0,64,208,201,156,10,138,0,64,208,128,160,0,73,148,
17,68,64,208,137,159,5,8,0,128,147,0,128,166,0,73,146,25,40,64,208,137,
148,5,8,0,128,145,0,64,154,64,208,64,165,64,208,128,161,0,72,145,8,64,208,
128,154,0,64,144,64,208,128,163,0,64,147,64,208,64,161,64,208,128,163,0,
73,152,37,48,64,208,137,152,5,16,0,137,147,5,8,0,128,145,0,128,150,0,137,
158,5,8,0,128,154,0,64,161,64,208,128,156,0,136,151,4,0,64,150,64,208,128,
159,0,192,154,0,64,208,136,159,4,0,128,145,0,73,162,14,85,64,208,192,159,
0,64,208,128,159,0,73,160,9,56,64,208,128,159,0,72,159,20,64,208,136,163,
4,0,64,162,64,208,136,166,4,0,128,163,0,64,158,64,208,73,158,9,20,64,208,
128,159,0,136,155,4,0,64,147,64,208,128,152,0,128,161,0,64,161,64,208,137,
156,5,8,0,128,152,0,128,160,0,73,164,13,24,64,208,136,154,4,0,128,146,0,
64,163,64,208,64,160,64,208,128,159,0,192,166,0,64,208,64,148,64,208,128,
158,0,202,166,220,9,110,0,64,208,73,159,17,125,64,208,137,146,5,8,0,128,
145,0,128,166,0,137,151,5,52,0,73,146,13,36,64,208,64,154,64,208,128,161,
0,72,145,12,64,208,136,154,4,0,128,151,0,64,144,64,208,64,146,64,208,128,
161,0,64,148,64,208,64,157,64,208,128,152,0,73,156,21,44,64,208,137,159,
5,12,0,136,154,4,0,128,146,0,128,161,0,64,154,64,208,137,162,5,16,0,136,
158,4,0,64,152,64,208,128,160,0,128,163,0,192,158,0,64,208,64,146,64,208,
128,158,0,73,163,13,60,64,208,64,156,64,208,128,161,0,73,161,33,40,64,208,
73,159,17,24,64,208,64,161,64,208,64,152,64,208,128,148,0,64,158,64,208,
128,157,0,128,160,0,64,160,64,208,128,159,0,64,162,64,208,128,160,0,73,
166,9,20,64,208,128,161,0,64,164,64,208,64,162,64,208,128,158,0,64,173,
64,208,128,161,0,74,162,195,5,150,64,208,73,156,21,99,64,208,72,158,8,64,
208,128,148,0,64,152,64,208,128,162,0,201,151,10,49,0,64,208,128,154,0,
137,148,5,28,0,72,147,16,64,208,137,165,5,8,0,128,160,0,128,166,0,64,144,
64,208,128,152,0,64,149,64,208,64,173,64,208,128,155,0,201,154,10,21,0,
64,208,128,145,0,64,152,64,208,64,168,64,208,128,145,0,192,155,0,64,208,
128,168,0,137,163,5,61,0,73,160,13,41,64,208,136,168,4,0,128,148,0,72,159,
16,64,208,137,154,5,8,0,128,147,0,128,159,0,192,157,0,64,208,136,159,4,
0,128,154,0,64,161,64,208,64,156,64,208,64,146,64,208,128,159,0,201,165,
10,25,0,64,208,128,146,0,64,164,64,208,64,158,64,208,64,156,64,208,128,
161,0,128,166,0,82,160,2,48,3,117,64,208,74,159,30,1,115,64,208,137,159,
5,20,0,136,158,4,0,64,154,64,208,64,161,64,208,128,157,0,128,164,0,137,
151,5,163,0,201,147,14,142,0,64,208,136,154,4,0,128,152,0,200,145,9,0,64,
208,128,155,0,64,144,64,208,73,157,73,104,64,208,64,161,64,208,72,159,24,
64,208,64,160,64,208,64,158,64,208,64,149,64,208,64,154,64,208,128,162,
0,64,152,64,208,64,157,64,208,64,146,64,208,64,149,64,208,64,161,64,208,
64,162,64,208,64,145,64,208,64,144,64,208,64,157,64,208,128,154,0,136,156,
4,0,64,146,64,208,64,156,64,208,64,159,64,208,64,163,64,208,64,157,64,208,
64,154,64,208,128,162,0,72,160,8,64,208,128,156,0,128,158,0,72,150,8,64,
208,128,154,0,192,148,0,64,208,128,148,0,73,155,9,111,64,208,128,154,0,
200,154,26,0,64,208,201,156,14,17,0,64,208,64,167,64,208,128,159,0,128,
152,0,128,159,0,64,152,64,208,73,156,13,53,64,208,64,173,64,208,128,160,
0,72,154,32,64,208,64,158,64,208,136,157,4,0,64,155,64,208,64,158,64,208,
64,160,64,208,64,162,64,208,128,146,0,192,151,0,64,208,128,144,0,136,166,
4,0,64,157,64,208,64,152,64,208,64,162,64,208,128,152,0,72,158,60,64,208,
73,158,17,44,64,208,64,152,64,208,64,146,64,208,128,144,0,72,155,12,64,
208,64,151,64,208,128,144,0,64,152,64,208,136,161,4,0,64,154,64,208,128,
144,0,72,173,8,64,208,128,151,0,128,166,0,64,157,64,208,128,154,0,201,166,
22,121,0,64,208,72,166,8,64,208,128,161,0,64,154,64,208,128,159,0,73,162,
21,52,64,208,137,160,5,12,0,136,155,4,0,128,152,0,128,163,0,72,161,20,64,
208,137,154,5,12,0,64,146,64,208,128,158,0,128,163,0,64,160,64,208,136,
161,4,0,128,155,0,72,164,12,64,208,64,161,64,208,128,151,0,64,163,64,208,
73,155,17,24,64,208,64,175,64,208,64,155,64,208,128,175,0,64,151,64,208,
128,152,0,64,156,64,208,128,157,0,73,173,21,53,64,208,72,154,12,64,208,
64,158,64,208,128,155,0,128,150,0,72,168,21,64,208,137,160,5,8,0,128,159,
0,192,161,0,64,208,128,160,0,64,167,64,208,136,161,4,0,128,159,0,64,175,
64,208,128,159,0,64,159,64,208,201,157,22,183,0,64,208,137,160,5,12,0,136,
159,4,0,128,154,0,128,162,0,73,148,9,74,64,208,128,157,0,201,146,14,45,
0,64,208,136,158,4,0,128,146,0,72,145,12,64,208,136,162,4,0,128,154,0,64,
144,64,208,64,158,64,208,64,147,64,208,64,144,64,208,128,165,0,192,147,
0,64,208,137,154,5,8,0,128,147,0,64,158,64,208,128,161,0,73,155,13,68,64,
208,136,161,4,0,128,146,0,72,154,40,64,208,73,161,9,16,64,208,128,157,0,
64,152,64,208,128,162,0,64,162,64,208,64,152,64,208,64,156,64,208,64,144,
64,208,128,168,0,64,152,64,208,136,160,4,0,64,159,64,208,128,159,0,64,156,
64,208,137,154,5,8,0,128,148,0,64,159,64,208,128,146,0,137,163,5,89,0,73,
161,37,69,64,208,137,163,5,20,0,72,159,12,64,208,64,144,64,208,128,161,
0,128,158,0,72,173,8,64,208,128,156,0,128,168,0,72,160,12,64,208,136,158,
4,0,128,148,0,192,159,0,64,208,137,161,5,12,0,136,156,4,0,128,147,0,128,
163,0,64,162,64,208,137,157,5,8,0,128,154,0,128,159,0,137,167,5,37,0,72,
165,12,64,208,136,161,4,0,128,146,0,64,164,64,208,137,155,5,8,0,128,154,
0,192,163,0,64,208,128,148,0,192,173,0,64,208,136,161,4,0,128,154,0,192,
161,0,64,208,201,157,22,152,0,64,208,137,145,5,12,0,64,144,64,208,128,163,
0,128,154,0,201,150,10,66,0,64,208,128,162,0,73,146,13,36,64,208,136,162,
4,0,128,160,0,72,145,12,64,208,136,159,4,0,128,145,0,64,144,64,208,136,
159,4,0,128,148,0,72,149,8,64,208,128,161,0,192,148,0,64,208,64,157,64,
208,128,173,0,201,154,26,45,0,64,208,137,162,5,16,0,136,159,4,0,64,145,
64,208,128,156,0,128,164,0,72,152,12,64,208,64,161,64,208,128,144,0,64,
151,64,208,128,159,0,72,156,12,64,208,136,159,4,0,128,155,0,64,155,64,208,
128,154,0,201,163,10,145,0,64,208,128,150,0,201,160,22,83,0,64,208,137,
151,5,12,0,64,148,64,208,128,148,0,128,175,0,72,159,25,64,208,201,160,10,
17,0,64,208,128,152,0,136,154,4,0,128,148,0,128,165,0,64,158,64,208,137,
154,5,20,0,137,151,5,12,0,64,148,64,208,128,148,0,128,152,0,136,163,4,0,
192,159,0,64,208,128,161,0,200,162,13,0,64,208,136,161,4,0,128,154,0,64,
161,64,208,137,159,5,20,0,137,152,5,12,0,136,150,4,0,128,144,0,128,157,
0,73,163,9,12,64,208,128,161,0,128,160,0,128,166,0,137,166,5,33,0,72,165,
17,64,208,136,160,4,0,192,144,0,64,208,128,154,0,64,164,64,208,136,151,
4,0,128,148,0,64,173,64,208,137,156,5,8,0,128,154,0,128,161,0,74,164,128,
2,191,64,208,201,154,10,50,0,64,208,128,159,0,201,148,10,33,0,64,208,128,
159,0,73,146,13,16,64,208,64,152,64,208,128,163,0,128,145,0,64,147,64,208,
128,152,0,136,152,4,0,128,151,0,137,160,5,52,0,73,158,13,32,64,208,64,156,
64,208,128,161,0,64,156,64,208,137,161,5,12,0,136,154,4,0,128,151,0,128,
163,0,64,159,64,208,72,154,8,64,208,128,159,0,128,147,0,72,162,12,64,208,
136,162,4,0,128,145,0,64,161,64,208,128,148,0,192,163,0,64,208,73,155,13,
148,64,208,64,147,64,208,128,163,0,73,147,33,104,64,208,72,173,8,64,208,
128,157,0,64,160,64,208,64,161,64,208,64,151,64,208,64,164,64,208,128,158,
0,73,145,45,60,64,208,136,160,4,0,64,148,64,208,64,152,64,208,64,161,64,
208,64,159,64,208,64,144,64,208,64,157,64,208,64,161,64,208,64,149,64,208,
128,160,0,64,144,64,208,137,152,5,8,0,128,148,0,128,154,0,64,146,64,208,
64,154,64,208,128,165,0,73,152,9,16,64,208,128,162,0,64,150,64,208,128,
148,0,64,154,64,208,137,154,5,8,0,128,151,0,128,161,0,82,160,1,115,1,146,
64,208,73,156,9,212,64,208,128,168,0,137,146,5,104,0,72,145,40,64,208,72,
152,24,64,208,64,151,64,208,64,157,64,208,64,149,64,208,64,161,64,208,128,
144,0,64,144,64,208,64,151,64,208,128,144,0,64,144,64,208,64,147,64,208,
64,149,64,208,64,157,64,208,72,162,28,64,208,72,161,16,64,208,64,162,64,
208,64,146,64,208,128,158,0,64,158,64,208,128,146,0,64,161,64,208,64,162,
64,208,64,146,64,208,128,144,0,72,155,12,64,208,64,158,64,208,128,156,0,
64,154,64,208,73,158,53,72,64,208,72,157,24,64,208,64,146,64,208,64,149,
64,208,64,160,64,208,64,162,64,208,128,171,0,64,156,64,208,64,159,64,208,
64,155,64,208,64,149,64,208,64,154,64,208,128,161,0,72,155,12,64,208,64,
163,64,208,128,145,0,64,146,64,208,128,158,0,64,161,64,208,64,152,64,208,
128,145,0,73,161,13,112,64,208,64,152,64,208,128,156,0,72,159,88,64,208,
72,160,28,64,208,64,158,64,208,64,148,64,208,64,163,64,208,64,154,64,208,
64,162,64,208,128,171,0,64,158,64,208,73,160,17,40,64,208,64,162,64,208,
64,144,64,208,128,155,0,136,156,4,0,64,149,64,208,64,151,64,208,64,148,
64,208,64,154,64,208,128,152,0,64,165,64,208,64,158,64,208,128,148,0,64,
157,64,208,64,152,64,208,128,164,0,72,164,20,64,208,64,152,64,208,64,160,
64,208,64,156,64,208,128,144,0,64,163,64,208,64,161,64,208,64,155,64,208,
64,163,64,208,128,147,0,73,158,13,20,64,208,64,158,64,208,128,161,0,64,
156,64,208,128,147,0,64,159,64,208,136,166,4,0,128,147,0,72,173,8,64,208,
128,161,0,64,161,64,208,192,163,0,64,208,128,160,0,64,165,64,208,201,158,
10,29,0,64,208,128,156,0,137,156,5,12,0,136,154,4,0,128,144,0,64,157,64,
208,128,147,0,73,162,13,21,64,208,136,163,4,0,128,152,0,192,159,0,64,208,
128,151,0,64,164,64,208,128,151,0,82,173,1,49,1,100,64,208,201,157,34,199,
0,64,208,137,159,5,20,0,72,154,12,64,208,64,158,64,208,128,156,0,128,152,
0,136,164,4,0,128,163,0,137,151,5,68,0,73,146,25,48,64,208,137,161,5,12,
0,136,157,4,0,128,148,0,64,162,64,208,128,161,0,136,145,4,0,64,144,64,208,
72,154,8,64,208,128,162,0,64,148,64,208,128,159,0,64,148,64,208,136,161,
4,0,64,152,64,208,128,154,0,73,155,21,74,64,208,137,151,5,12,0,64,144,64,
208,128,148,0,128,154,0,200,154,29,0,64,208,72,156,8,64,208,128,158,0,64,
154,64,208,64,152,64,208,64,158,64,208,128,161,0,64,152,64,208,201,159,
10,17,0,64,208,128,158,0,136,152,4,0,128,144,0,128,161,0,64,156,64,208,
137,151,5,12,0,64,147,64,208,128,163,0,64,159,64,208,128,161,0,73,162,21,
75,64,208,137,154,5,12,0,136,152,4,0,128,151,0,128,161,0,201,160,14,38,
0,64,208,136,156,4,0,128,151,0,72,159,8,64,208,128,154,0,192,158,0,64,208,
137,152,5,8,0,128,151,0,128,161,0,192,161,0,64,208,137,152,5,8,0,128,144,
0,128,166,0,137,167,5,16,0,136,166,4,0,64,165,64,208,128,163,0,64,174,64,
208,128,152,0,73,168,9,36,64,208,128,152,0,64,167,64,208,73,161,9,16,64,
208,128,150,0,64,156,64,208,128,162,0,64,163,64,208,128,159,0,64,171,64,
208,64,146,64,208,64,147,64,208,128,163,0,72,175,72,64,208,137,158,5,52,
0,136,154,4,0,64,150,64,208,64,156,64,208,72,149,28,64,208,64,165,64,208,
64,159,64,208,64,160,64,208,64,149,64,208,64,161,64,208,128,161,0,64,144,
64,208,128,168,0,72,173,8,64,208,128,161,0,64,160,64,208,128,148,0,64,174,
64,208,73,160,9,88,64,208,128,165,0,137,152,5,8,0,128,151,0,64,156,64,208,
73,147,45,56,64,208,73,157,13,36,64,208,64,147,64,208,128,163,0,72,156,
8,64,208,128,144,0,64,144,64,208,64,161,64,208,136,163,4,0,128,144,0,128,
163,0,64,145,64,208,64,152,64,208,128,162,0,64,152,64,208,64,161,64,208,
128,152,0,136,164,4,0,128,162,0,64,72,64,208,128,154,0,82,160,45,187,86,
121,64,208,82,158,6,37,30,29,64,208,74,157,50,1,153,64,208,73,154,13,32,
64,208,64,162,64,208,128,148,0,137,149,5,8,0,128,144,0,64,152,64,208,64,
152,64,208,128,156,0,137,161,5,8,0,128,158,0,128,166,0,73,150,13,157,64,
208,64,160,64,208,128,161,0,73,146,17,81,64,208,137,155,5,8,0,128,148,0,
128,161,0,72,145,24,64,208,137,162,5,16,0,72,158,8,64,208,128,159,0,128,
148,0,128,164,0,192,144,0,64,208,73,156,9,20,64,208,128,162,0,137,151,5,
8,0,128,147,0,128,152,0,137,162,5,8,0,128,158,0,64,173,64,208,128,161,0,
72,148,56,64,208,73,157,13,36,64,208,64,156,64,208,128,152,0,72,154,12,
64,208,64,159,64,208,128,149,0,64,148,64,208,64,158,64,208,128,156,0,72,
161,12,64,208,136,157,4,0,128,144,0,128,159,0,64,147,64,208,128,161,0,73,
154,66,139,64,208,201,154,14,25,0,64,208,64,146,64,208,128,148,0,136,145,
4,0,64,144,64,208,128,159,0,64,157,64,208,72,160,28,64,208,64,158,64,208,
64,155,64,208,64,172,64,208,64,169,64,208,64,152,64,208,128,154,0,128,148,
0,72,152,66,64,208,73,159,9,34,64,208,128,144,0,137,157,5,22,0,200,152,
9,0,64,208,128,159,0,192,144,0,64,208,128,161,0,128,158,0,73,164,9,16,64,
208,128,158,0,136,161,4,0,128,160,0,64,175,64,208,64,154,64,208,128,161,
0,64,151,64,208,128,156,0,72,156,52,64,208,73,152,21,40,64,208,137,159,
5,8,0,128,152,0,64,160,64,208,128,144,0,136,151,4,0,64,147,64,208,64,147,
64,208,64,152,64,208,128,164,0,136,166,4,0,128,161,0,64,155,64,208,136,
164,4,0,128,160,0,74,164,50,4,72,64,208,73,159,13,36,64,208,64,156,64,208,
128,159,0,72,158,12,64,208,64,156,64,208,128,161,0,64,152,64,208,64,146,
64,208,128,161,0,64,161,64,208,128,161,0,73,160,9,218,64,208,128,145,0,
72,159,68,64,208,137,159,5,36,0,73,152,17,24,64,208,137,159,5,8,0,128,154,
0,128,162,0,64,144,64,208,128,161,0,64,154,64,208,128,160,0,137,163,5,24,
0,64,160,64,208,72,175,8,64,208,128,155,0,64,173,64,208,128,165,0,128,166,
0,192,158,0,64,208,73,155,9,65,64,208,128,161,0,73,147,9,20,64,208,128,
164,0,72,146,8,64,208,128,150,0,128,144,0,192,152,0,64,208,137,148,5,28,
0,64,146,64,208,73,152,13,16,64,208,64,146,64,208,128,154,0,128,144,0,128,
161,0,128,160,0,73,159,29,36,64,208,137,152,5,8,0,128,144,0,64,161,64,208,
64,146,64,208,64,158,64,208,128,148,0,64,158,64,208,128,160,0,64,161,64,
208,73,159,9,20,64,208,128,156,0,64,151,64,208,64,159,64,208,128,152,0,
64,161,64,208,64,159,64,208,128,167,0,200,163,58,0,64,208,201,159,10,29,
0,64,208,128,152,0,72,158,8,64,208,128,160,0,64,154,64,208,64,148,64,208,
128,148,0,72,165,8,64,208,128,158,0,64,161,64,208,64,144,64,208,136,168,
4,0,128,159,0,64,161,64,208,74,157,76,1,154,64,208,73,152,37,61,64,208,
64,152,64,208,73,159,9,16,64,208,128,156,0,64,147,64,208,128,148,0,64,160,
64,208,64,158,64,208,128,161,0,64,144,64,208,64,157,64,208,192,158,0,64,
208,64,162,64,208,64,149,64,208,128,165,0,192,158,0,64,208,128,163,0,201,
148,46,182,0,64,208,136,159,4,0,64,158,64,208,64,160,64,208,72,157,12,64,
208,64,152,64,208,128,152,0,64,145,64,208,64,144,64,208,64,157,64,208,128,
154,0,73,146,25,72,64,208,64,149,64,208,64,160,64,208,64,162,64,208,64,
158,64,208,128,155,0,72,145,16,64,208,72,163,8,64,208,128,165,0,128,160,
0,64,144,64,208,73,159,9,24,64,208,128,158,0,72,157,12,64,208,64,158,64,
208,128,163,0,128,144,0,128,168,0,64,147,64,208,73,149,30,37,64,208,192,
158,0,64,208,64,155,64,208,64,164,64,208,64,158,64,208,64,157,64,208,128,
148,0,64,144,64,208,128,151,0,64,158,64,208,64,161,64,208,64,166,64,208,
64,152,64,208,64,160,64,208,128,154,0,73,152,33,92,64,208,72,157,20,64,
208,72,154,12,64,208,64,144,64,208,128,161,0,128,147,0,64,156,64,208,128,
151,0,72,151,20,64,208,64,152,64,208,64,162,64,208,64,155,64,208,128,159,
0,64,149,64,208,64,146,64,208,64,160,64,208,64,158,64,208,64,145,64,208,
64,144,64,208,64,157,64,208,64,154,64,208,64,158,64,208,128,156,0,192,156,
0,64,208,73,161,9,52,64,208,128,148,0,64,158,64,208,64,160,64,208,64,160,
64,208,64,149,64,208,64,167,64,208,64,145,64,208,64,163,64,208,64,157,64,
208,64,154,64,208,64,149,64,208,128,160,0,128,163,0,74,164,10,1,23,64,208,
128,154,0,73,161,77,190,64,208,73,157,13,32,64,208,64,144,64,208,128,144,
0,72,152,12,64,208,64,147,64,208,128,160,0,64,146,64,208,128,162,0,72,159,
12,64,208,64,173,64,208,128,157,0,64,158,64,208,64,174,64,208,64,151,64,
208,64,161,64,208,64,159,64,208,64,144,64,208,128,161,0,200,160,21,0,64,
208,136,158,4,0,64,152,64,208,64,144,64,208,128,166,0,192,159,0,64,208,
73,160,29,44,64,208,64,158,64,208,64,156,64,208,64,145,64,208,64,144,64,
208,64,157,64,208,128,154,0,73,152,9,12,64,208,128,154,0,128,148,0,128,
158,0,137,166,5,36,0,64,162,64,208,64,152,64,208,64,166,64,208,64,149,64,
208,64,161,64,208,64,158,64,208,64,174,64,208,128,151,0,64,173,64,208,128,
157,0,64,162,64,208,137,158,5,24,0,72,149,8,64,208,128,165,0,64,147,64,
208,64,156,64,208,128,163,0,64,160,64,208,64,144,64,208,64,157,64,208,64,
161,64,208,64,152,64,208,64,157,64,208,64,161,64,208,64,159,64,208,64,149,
64,208,64,154,64,208,64,166,64,208,64,152,64,208,128,175,0,73,168,21,37,
64,208,64,149,64,208,64,155,64,208,64,172,64,208,128,164,0,64,165,64,208,
64,146,64,208,192,149,0,64,208,128,159,0,192,173,0,64,208,64,154,64,208,
72,161,28,64,208,64,152,64,208,64,156,64,208,64,145,64,208,64,144,64,208,
64,157,64,208,128,154,0,128,158,0,73,168,17,40,64,208,64,163,64,208,64,
156,64,208,128,151,0,136,167,4,0,64,166,64,208,72,152,8,64,208,128,162,
0,64,150,64,208,128,161,0,192,173,0,64,208,137,165,5,12,0,64,159,64,208,
128,161,0,128,173,0,74,150,51,14,34,64,208,137,156,5,24,0,137,148,5,12,
0,136,146,4,0,128,145,0,64,152,64,208,128,166,0,137,165,5,17,0,192,161,
0,64,208,64,154,64,208,128,162,0,128,166,0,82,146,1,44,7,170,64,208,201,
159,30,196,0,64,208,137,154,5,16,0,72,152,8,64,208,128,161,0,128,151,0,
136,161,4,0,128,159,0,137,151,5,106,0,73,147,9,93,64,208,128,154,0,72,146,
77,64,208,137,151,5,40,0,72,148,24,64,208,64,154,64,208,136,163,4,0,64,
148,64,208,64,154,64,208,128,163,0,64,144,64,208,64,152,64,208,128,163,
0,72,159,12,64,208,64,154,64,208,128,163,0,192,154,0,64,208,72,163,8,64,
208,128,161,0,64,152,64,208,128,163,0,64,144,64,208,128,152,0,192,148,0,
64,208,128,159,0,73,156,9,37,64,208,128,144,0,200,154,9,0,64,208,128,161,
0,64,152,64,208,137,158,5,8,0,128,144,0,64,160,64,208,128,146,0,64,157,
64,208,136,161,4,0,64,159,64,208,64,157,64,208,64,148,64,208,128,148,0,
73,164,13,69,64,208,136,148,4,0,128,145,0,73,162,13,45,64,208,136,161,4,
0,128,160,0,200,161,25,0,64,208,73,159,9,16,64,208,128,154,0,136,157,4,
0,128,154,0,128,160,0,64,160,64,208,128,161,0,64,163,64,208,136,166,4,0,
128,156,0,73,168,13,20,64,208,64,158,64,208,128,156,0,64,166,64,208,128,
152,0,64,174,64,208,128,168,0,82,144,5,160,5,179,64,208,74,158,30,2,195,
64,208,73,158,17,20,64,208,136,159,4,0,64,156,64,208,128,159,0,128,146,
0,128,161,0,74,151,38,1,12,64,208,136,168,4,0,64,146,64,208,136,151,4,0,
64,149,64,208,64,148,64,208,64,163,64,208,64,159,64,208,128,160,0,73,147,
17,169,64,208,137,159,5,8,0,128,158,0,128,161,0,73,145,81,121,64,208,137,
158,5,44,0,73,152,13,16,64,208,136,161,4,0,128,159,0,128,147,0,64,154,64,
208,72,160,12,64,208,64,152,64,208,128,157,0,64,158,64,208,128,160,0,73,
161,17,20,64,208,64,162,64,208,64,158,64,208,128,155,0,128,159,0,64,164,
64,208,64,144,64,208,128,154,0,64,144,64,208,73,154,13,24,64,208,136,161,
4,0,128,152,0,137,150,5,8,0,128,147,0,128,151,0,200,161,9,0,64,208,128,
157,0,128,157,0,64,146,64,208,73,162,13,20,64,208,64,158,64,208,128,151,
0,136,152,4,0,128,146,0,64,168,64,208,128,163,0,201,149,10,38,0,64,208,
128,157,0,64,148,64,208,201,161,10,17,0,64,208,128,152,0,136,156,4,0,128,
148,0,136,166,4,0,128,164,0,64,150,64,208,136,161,4,0,64,146,64,208,72,
152,8,64,208,128,151,0,128,151,0,73,155,17,236,64,208,136,165,4,0,64,145,
64,208,128,145,0,73,153,114,188,64,208,73,158,13,36,64,208,64,157,64,208,
128,158,0,137,153,5,12,0,64,151,64,208,128,158,0,64,154,64,208,64,158,64,
208,128,156,0,73,161,25,65,64,208,72,163,8,64,208,128,148,0,64,145,64,208,
64,145,64,208,128,150,0,64,159,64,208,192,158,0,64,208,64,162,64,208,64,
160,64,208,64,149,64,208,64,145,64,208,64,161,64,208,64,158,64,208,64,174,
64,208,128,151,0,64,164,64,208,128,158,0,64,152,64,208,201,159,14,50,0,
64,208,64,156,64,208,128,146,0,73,156,9,24,64,208,128,154,0,136,152,4,0,
64,150,64,208,136,154,4,0,128,152,0,192,157,0,64,208,64,154,64,208,128,
158,0,73,161,9,12,64,208,128,162,0,128,160,0,192,162,0,64,208,128,154,0,
64,154,64,208,137,168,5,20,0,136,166,4,0,64,161,64,208,64,158,64,208,128,
146,0,64,173,64,208,128,148,0,200,157,77,0,64,208,73,160,9,52,64,208,128,
152,0,137,156,5,32,0,64,152,64,208,73,158,9,20,64,208,128,157,0,64,152,
64,208,64,158,64,208,128,157,0,128,161,0,64,158,64,208,64,159,64,208,128,
161,0,137,165,5,16,0,64,161,64,208,64,152,64,208,128,161,0,128,173,0,64,
156,64,208,73,161,17,44,64,208,136,158,4,0,64,152,64,208,128,160,0,137,
154,5,16,0,137,151,5,8,0,128,150,0,128,152,0,136,157,4,0,64,155,64,208,
128,148,0,73,165,9,36,64,208,128,144,0,137,163,5,24,0,64,162,64,208,73,
158,9,12,64,208,128,156,0,128,157,0,128,161,0,128,164,0,200,173,9,0,64,
208,128,154,0,128,166,0,202,165,19,2,78,0,64,208,137,157,5,8,0,128,152,
0,128,164,0,74,162,89,1,215,64,208,73,158,9,42,64,208,128,159,0,137,148,
5,17,0,136,145,4,0,192,144,0,64,208,128,163,0,136,156,4,0,192,152,0,64,
208,64,161,64,208,128,161,0,137,166,5,29,0,72,163,8,64,208,128,159,0,192,
161,0,64,208,137,152,5,8,0,128,150,0,128,159,0,64,173,64,208,64,159,64,
208,128,159,0,73,160,55,170,64,208,73,156,9,38,64,208,128,159,0,73,148,
13,21,64,208,64,173,64,208,128,161,0,192,144,0,64,208,128,157,0,192,152,
0,64,208,128,145,0,137,164,5,8,0,128,162,0,128,167,0,64,159,64,208,201,
159,18,80,0,64,208,137,159,5,8,0,128,144,0,128,161,0,201,156,22,50,0,64,
208,72,161,8,64,208,128,145,0,64,149,64,208,128,148,0,201,152,10,17,0,64,
208,128,162,0,64,146,64,208,128,162,0,64,154,64,208,64,144,64,208,128,162,
0,200,158,9,0,64,208,128,161,0,128,157,0,73,166,9,24,64,208,128,163,0,137,
163,5,12,0,64,161,64,208,128,152,0,128,165,0,136,173,4,0,128,168,0,64,161,
64,208,73,159,37,133,64,208,137,158,5,8,0,128,156,0,64,160,64,208,64,149,
64,208,64,148,64,208,64,146,64,208,64,144,64,208,128,155,0,73,154,9,44,
64,208,128,158,0,73,148,9,24,64,208,128,161,0,64,144,64,208,64,146,64,208,
64,162,64,208,128,158,0,64,152,64,208,64,159,64,208,128,158,0,137,157,5,
24,0,64,156,64,208,64,152,64,208,64,160,64,208,64,145,64,208,128,152,0,
192,158,0,64,208,73,158,9,16,64,208,128,157,0,64,146,64,208,128,162,0,64,
162,64,208,128,162,0,73,164,9,56,64,208,128,148,0,73,162,29,36,64,208,64,
144,64,208,136,156,4,0,64,145,64,208,64,144,64,208,64,153,64,208,128,154,
0,64,161,64,208,128,158,0,64,163,64,208,64,148,64,208,128,156,0,73,166,
9,16,64,208,128,158,0,64,165,64,208,128,152,0,128,173,0,72,164,33,64,208,
73,162,9,20,64,208,128,158,0,136,156,4,0,64,148,64,208,128,161,0,192,163,
0,64,208,128,150,0,64,163,64,208,73,157,9,28,64,208,128,166,0,137,151,5,
12,0,136,148,4,0,128,147,0,64,156,64,208,128,144,0,73,164,9,28,64,208,128,
160,0,72,161,8,64,208,128,161,0,64,160,64,208,64,156,64,208,128,159,0,64,
166,64,208,128,145,0,201,173,52,116,0,64,208,137,154,5,24,0,72,146,8,64,
208,128,162,0,64,145,64,208,64,163,64,208,128,160,0,200,161,13,0,64,208,
136,159,4,0,128,154,0,192,159,0,64,208,128,154,0,73,167,9,53,64,208,128,
151,0,64,166,64,208,73,160,9,32,64,208,128,152,0,72,156,8,64,208,128,152,
0,64,152,64,208,72,160,8,64,208,128,161,0,128,157,0,192,161,0,64,208,128,
156,0,64,168,64,208,64,145,64,208,128,152,0,72,175,12,64,208,64,157,64,
208,128,158,0,64,174,64,208,128,157,0,64,134,64,208,72,161,8,64,208,128,
163,0,64,157,64,208,128,160,0,192,145,0,64,208,73,157,9,98,64,208,128,151,
0,73,152,25,61,64,208,137,163,5,16,0,72,162,8,64,208,128,161,0,128,158,
0,128,166,0,201,148,10,33,0,64,208,128,161,0,72,146,20,64,208,137,155,5,
8,0,128,151,0,64,161,64,208,128,144,0,128,144,0,128,150,0,73,155,9,17,64,
208,128,152,0,192,154,0,64,208,128,152,0,64,156,64,208,136,161,4,0,128,
154,0,73,162,17,72,64,208,137,155,5,8,0,128,152,0,128,159,0,201,160,14,
44,0,64,208,136,162,4,0,128,160,0,200,159,13,0,64,208,136,173,4,0,128,164,
0,192,158,0,64,208,136,164,4,0,192,158,0,64,208,128,152,0,64,161,64,208,
64,156,64,208,128,173,0,73,164,17,25,64,208,64,157,64,208,64,144,64,208,
128,157,0,192,163,0,64,208,128,161,0,128,166,0,82,148,1,10,3,242,64,208,
73,158,17,153,64,208,137,159,5,8,0,128,158,0,128,166,0,73,150,9,91,64,208,
128,146,0,73,146,9,49,64,208,128,163,0,72,145,20,64,208,64,167,64,208,64,
156,64,208,64,160,64,208,128,156,0,192,144,0,64,208,72,155,8,64,208,128,
156,0,64,148,64,208,128,144,0,200,148,21,0,64,208,137,160,5,12,0,64,148,
64,208,128,158,0,128,162,0,192,147,0,64,208,136,163,4,0,128,162,0,73,156,
13,28,64,208,136,166,4,0,128,162,0,72,154,8,64,208,128,145,0,64,152,64,
208,128,173,0,192,157,0,64,208,200,161,9,0,64,208,128,154,0,128,154,0,201,
163,15,64,0,64,208,192,156,0,64,208,128,163,0,201,161,14,33,0,64,208,136,
154,4,0,128,146,0,136,160,4,0,64,159,64,208,137,154,5,8,0,128,144,0,128,
168,0,192,162,0,64,208,137,162,5,8,0,128,144,0,128,163,0,201,173,14,30,
0,64,208,64,145,64,208,128,166,0,136,166,4,0,192,164,0,64,208,64,173,64,
208,128,157,0,64,174,64,208,64,161,64,208,128,168,0,64,147,64,208,202,158,
23,1,162,0,64,208,73,158,9,12,64,208,128,165,0,128,154,0,128,163,0,73,150,
9,246,64,208,128,149,0,73,146,33,197,64,208,137,154,5,20,0,137,146,5,8,
0,128,144,0,64,152,64,208,128,144,0,136,163,4,0,128,159,0,200,145,17,0,
64,208,137,156,5,8,0,128,152,0,128,161,0,192,144,0,64,208,73,155,9,65,64,
208,128,152,0,73,148,9,37,64,208,128,144,0,137,145,5,17,0,64,144,64,208,
192,152,0,64,208,128,152,0,64,146,64,208,64,156,64,208,128,164,0,72,154,
12,64,208,64,164,64,208,128,148,0,64,151,64,208,128,163,0,201,163,22,66,
0,64,208,64,156,64,208,64,152,64,208,64,154,64,208,128,162,0,201,161,18,
33,0,64,208,72,159,8,64,208,128,152,0,128,156,0,64,157,64,208,72,162,8,
64,208,128,148,0,128,152,0,64,162,64,208,136,163,4,0,128,144,0,136,173,
4,0,64,164,64,208,128,154,0,72,148,8,64,208,128,145,0,64,147,64,208,201,
160,10,25,0,64,208,128,163,0,136,159,4,0,64,156,64,208,136,163,4,0,128,
152,0,128,163,0,73,154,41,86,64,208,73,158,17,28,64,208,64,162,64,208,64,
173,64,208,128,159,0,72,152,8,64,208,128,163,0,128,145,0,136,166,4,0,128,
159,0,72,152,37,64,208,73,158,9,29,64,208,128,158,0,72,152,8,64,208,128,
161,0,192,144,0,64,208,64,148,64,208,128,146,0,128,163,0,192,151,0,64,208,
128,156,0,72,157,20,64,208,136,164,4,0,64,162,64,208,136,161,4,0,128,144,
0,64,156,64,208,137,157,5,24,0,73,148,9,16,64,208,128,160,0,64,144,64,208,
128,144,0,128,152,0,137,163,5,8,0,128,162,0,64,173,64,208,128,154,0,202,
164,15,1,10,0,64,208,64,152,64,208,128,152,0,73,161,41,111,64,208,73,158,
9,24,64,208,128,154,0,73,148,9,12,64,208,128,155,0,128,144,0,128,152,0,
136,163,4,0,64,159,64,208,128,157,0,200,160,33,0,64,208,137,163,5,20,0,
72,162,12,64,208,136,163,4,0,128,144,0,128,154,0,64,173,64,208,128,161,
0,64,159,64,208,201,159,10,26,0,64,208,128,163,0,200,152,9,0,64,208,128,
145,0,64,144,64,208,128,163,0,136,167,4,0,128,163,0,200,163,101,0,64,208,
137,161,5,49,0,73,158,9,36,64,208,128,160,0,72,157,24,64,208,73,152,9,12,
64,208,128,147,0,128,147,0,64,154,64,208,128,144,0,128,152,0,192,159,0,
64,208,128,161,0,137,163,5,20,0,64,162,64,208,136,161,4,0,64,152,64,208,
128,161,0,192,164,0,64,208,192,154,0,64,208,192,161,0,64,208,136,162,4,
0,64,152,64,208,128,162,0,64,162,64,208,137,154,5,16,0,137,145,5,8,0,128,
144,0,128,152,0,137,163,5,8,0,128,156,0,64,173,64,208,136,163,4,0,128,161,
0,201,168,10,29,0,64,208,128,158,0,136,167,4,0,64,166,64,208,72,173,8,64,
208,128,155,0,128,145,0,72,174,8,64,208,128,145,0,64,173,64,208,137,163,
5,12,0,136,161,4,0,128,144,0,128,166,0,64,149,64,208,74,157,54,1,75,64,
208,64,162,64,208,72,147,40,64,208,64,149,64,208,64,157,64,208,64,144,64,
208,64,159,64,208,64,159,64,208,64,144,64,208,64,160,64,208,64,144,64,208,
128,162,0,128,146,0,73,148,9,144,64,208,128,146,0,73,146,73,88,64,208,73,
152,21,56,64,208,64,161,64,208,64,162,64,208,64,158,64,208,128,158,0,64,
146,64,208,64,158,64,208,64,149,64,208,64,157,64,208,64,161,64,208,64,158,
64,208,64,146,64,208,64,149,64,208,128,162,0,64,154,64,208,64,158,64,208,
128,156,0,72,145,8,64,208,128,161,0,64,134,64,208,128,163,0,64,147,64,208,
72,166,20,64,208,64,149,64,208,64,157,64,208,64,162,64,208,128,160,0,64,
159,64,208,64,144,64,208,64,155,64,208,64,144,64,208,64,162,64,208,128,
144,0,73,155,13,65,64,208,64,152,64,208,128,157,0,72,154,29,64,208,72,158,
8,64,208,128,155,0,192,157,0,64,208,136,160,4,0,64,156,64,208,128,163,0,
64,152,64,208,64,156,64,208,64,159,64,208,64,158,64,208,64,160,64,208,128,
162,0,64,156,64,208,73,154,33,61,64,208,64,158,64,208,64,156,64,208,64,
159,64,208,64,155,64,208,64,149,64,208,64,154,64,208,128,162,0,200,151,
21,0,64,208,64,144,64,208,64,146,64,208,64,158,64,208,128,148,0,64,146,
64,208,128,154,0,128,168,0,73,164,77,184,64,208,137,160,5,48,0,72,154,40,
64,208,64,158,64,208,64,157,64,208,64,162,64,208,64,149,64,208,64,153,64,
208,64,157,64,208,64,149,64,208,64,160,64,208,128,171,0,128,146,0,64,161,
64,208,64,161,64,208,64,171,64,208,64,155,64,208,64,154,64,208,128,144,
0,73,161,37,88,64,208,73,157,9,20,64,208,128,160,0,64,154,64,208,64,158,
64,208,128,156,0,64,162,64,208,64,160,64,208,128,144,0,72,159,20,64,208,
64,145,64,208,64,144,64,208,64,151,64,208,128,144,0,64,158,64,208,137,154,
5,24,0,72,152,8,64,208,128,161,0,64,145,64,208,64,152,64,208,128,161,0,
128,157,0,64,162,64,208,137,155,5,8,0,128,144,0,64,158,64,208,128,156,0,
73,167,37,48,64,208,72,164,16,64,208,64,155,64,208,64,158,64,208,128,162,
0,64,159,64,208,64,158,64,208,64,160,64,208,128,162,0,64,166,64,208,64,
173,64,208,128,159,0,192,173,0,64,208,64,154,64,208,64,161,64,208,64,159,
64,208,64,158,64,208,64,160,64,208,128,162,0,74,155,150,6,4,64,208,73,157,
9,89,64,208,128,148,0,201,152,14,49,0,64,208,64,162,64,208,128,166,0,73,
146,13,20,64,208,136,161,4,0,128,148,0,64,145,64,208,128,158,0,64,148,64,
208,136,157,4,0,64,146,64,208,128,161,0,73,155,9,24,64,208,128,161,0,64,
154,64,208,72,161,8,64,208,128,156,0,128,154,0,64,156,64,208,128,162,0,
73,165,9,47,64,208,128,155,0,201,161,23,31,0,64,208,137,161,5,13,0,192,
145,0,64,208,128,158,0,128,163,0,192,159,0,64,208,128,154,0,64,162,64,208,
128,154,0,136,173,4,0,128,166,0,82,152,2,227,3,119,64,208,74,157,74,1,108,
64,208,73,162,9,52,64,208,128,152,0,73,154,25,36,64,208,72,166,8,64,208,
128,173,0,64,158,64,208,64,146,64,208,128,134,0,64,144,64,208,64,154,64,
208,128,158,0,64,159,64,208,128,158,0,137,166,5,8,0,128,165,0,64,175,64,
208,128,151,0,73,150,13,166,64,208,136,154,4,0,128,148,0,73,146,45,113,
64,208,73,161,9,32,64,208,128,161,0,72,154,16,64,208,64,158,64,208,64,160,
64,208,128,144,0,64,148,64,208,128,146,0,136,168,4,0,128,166,0,72,145,20,
64,208,137,154,5,12,0,64,152,64,208,128,163,0,128,162,0,64,144,64,208,73,
162,13,32,64,208,136,158,4,0,128,156,0,136,161,4,0,64,156,64,208,137,151,
5,8,0,128,144,0,128,161,0,192,166,0,64,208,64,173,64,208,128,156,0,72,148,
20,64,208,72,162,8,64,208,128,173,0,64,158,64,208,128,159,0,64,147,64,208,
192,160,0,64,208,64,163,64,208,64,159,64,208,128,159,0,201,154,30,77,0,
64,208,137,160,5,8,0,128,151,0,64,163,64,208,136,158,4,0,64,152,64,208,
128,158,0,72,152,40,64,208,73,154,9,28,64,208,128,163,0,73,150,9,16,64,
208,128,162,0,64,147,64,208,128,144,0,128,152,0,136,166,4,0,128,161,0,64,
151,64,208,128,159,0,72,156,40,64,208,137,161,5,28,0,73,158,9,20,64,208,
128,146,0,64,152,64,208,64,158,64,208,128,161,0,128,160,0,136,166,4,0,128,
164,0,64,155,64,208,128,162,0,202,163,15,1,14,0,64,208,136,161,4,0,128,
159,0,201,160,31,158,0,64,208,201,158,10,21,0,64,208,128,158,0,72,152,8,
64,208,128,146,0,128,146,0,128,166,0,72,159,80,64,208,201,158,14,56,0,64,
208,64,148,64,208,128,158,0,201,152,14,30,0,64,208,64,147,64,208,128,157,
0,200,148,9,0,64,208,128,161,0,64,144,64,208,128,156,0,192,154,0,64,208,
64,160,64,208,128,158,0,73,162,13,16,64,208,64,152,64,208,128,145,0,128,
160,0,128,165,0,64,158,64,208,137,158,5,16,0,64,154,64,208,64,158,64,208,
128,151,0,64,159,64,208,64,158,64,208,72,154,8,64,208,128,161,0,64,152,
64,208,64,154,64,208,128,161,0,72,162,52,64,208,137,161,5,28,0,73,156,9,
16,64,208,128,156,0,64,152,64,208,128,160,0,64,158,64,208,128,150,0,72,
173,12,64,208,136,154,4,0,128,147,0,64,163,64,208,128,161,0,64,161,64,208,
73,162,9,25,64,208,128,156,0,137,152,5,8,0,128,150,0,192,158,0,64,208,128,
162,0,72,165,8,64,208,128,156,0,192,163,0,64,208,128,151,0,73,167,21,65,
64,208,64,162,64,208,64,160,64,208,64,144,64,208,128,154,0,200,166,13,0,
64,208,64,154,64,208,128,152,0,64,164,64,208,137,161,5,20,0,136,154,4,0,
64,152,64,208,64,154,64,208,128,162,0,64,162,64,208,128,152,0,64,173,64,
208,73,159,9,20,64,208,128,159,0,136,158,4,0,64,157,64,208,128,156,0,192,
161,0,64,208,128,154,0,64,151,64,208,73,156,13,83,64,208,64,154,64,208,
128,159,0,201,147,10,30,0,64,208,128,144,0,137,145,5,13,0,192,144,0,64,
208,128,154,0,64,146,64,208,128,144,0,72,154,8,64,208,128,152,0,192,152,
0,64,208,72,162,24,64,208,72,155,8,64,208,128,159,0,64,152,64,208,64,155,
64,208,128,159,0,128,144,0,73,162,9,45,64,208,128,144,0,73,158,13,20,64,
208,64,166,64,208,128,156,0,64,157,64,208,128,163,0,192,161,0,64,208,137,
156,5,8,0,128,152,0,128,161,0,72,173,8,64,208,128,156,0,192,166,0,64,208,
128,155,0,192,154,0,64,208,202,158,35,1,27,0,64,208,137,148,5,12,0,136,
145,4,0,128,144,0,64,158,64,208,64,157,64,208,64,152,64,208,128,154,0,73,
151,9,115,64,208,128,156,0,73,146,34,78,64,208,73,156,9,25,64,208,128,164,
0,136,148,4,0,192,146,0,64,208,64,146,64,208,128,161,0,128,159,0,200,145,
33,0,64,208,137,156,5,20,0,72,152,8,64,208,128,161,0,64,146,64,208,128,
155,0,136,162,4,0,128,158,0,64,144,64,208,136,156,4,0,128,144,0,72,148,
21,64,208,201,159,10,13,0,64,208,128,154,0,128,151,0,128,161,0,64,147,64,
208,128,154,0,73,156,29,106,64,208,137,164,5,16,0,136,157,4,0,64,156,64,
208,128,159,0,64,167,64,208,128,159,0,72,154,45,64,208,201,156,10,29,0,
64,208,128,145,0,73,146,13,16,64,208,136,164,4,0,128,148,0,128,144,0,128,
148,0,136,164,4,0,64,163,64,208,128,156,0,192,152,0,64,208,137,154,5,20,
0,72,152,12,64,208,64,147,64,208,128,144,0,128,145,0,136,166,4,0,128,156,
0,64,157,64,208,137,158,5,16,0,136,154,4,0,64,149,64,208,128,156,0,64,159,
64,208,128,154,0,201,164,10,150,0,64,208,128,156,0,201,161,35,104,0,64,
208,73,159,9,16,64,208,128,148,0,136,156,4,0,128,152,0,200,163,9,0,64,208,
128,146,0,128,161,0,72,160,24,64,208,137,154,5,12,0,136,151,4,0,128,147,
0,136,162,4,0,128,159,0,64,159,64,208,137,157,5,26,0,137,147,5,8,0,128,
145,0,192,156,0,64,208,192,158,0,64,208,128,158,0,137,159,5,8,0,128,158,
0,64,162,64,208,128,148,0,72,163,20,64,208,73,165,9,12,64,208,128,158,0,
128,159,0,128,166,0,192,162,0,64,208,137,155,5,8,0,128,145,0,128,156,0,
73,168,13,49,64,208,136,152,4,0,128,146,0,200,166,25,0,64,208,137,160,5,
8,0,128,155,0,64,162,64,208,64,173,64,208,128,161,0,64,165,64,208,136,159,
4,0,128,155,0,192,173,0,64,208,136,161,4,0,64,153,64,208,128,160,0,80,157,
2,101,64,208,74,156,22,1,74,64,208,73,158,9,12,64,208,128,162,0,128,145,
0,128,166,0,137,149,5,89,0,73,146,17,53,64,208,72,168,8,64,208,128,163,
0,128,148,0,72,145,25,64,208,137,162,5,17,0,200,158,9,0,64,208,128,163,
0,128,144,0,128,164,0,64,144,64,208,136,157,4,0,128,147,0,72,148,12,64,
208,136,161,4,0,128,156,0,64,147,64,208,137,159,5,12,0,136,156,4,0,128,
154,0,128,168,0,73,152,150,161,64,208,73,158,13,109,64,208,136,157,4,0,
128,152,0,73,147,9,20,64,208,128,156,0,72,146,8,64,208,128,166,0,128,145,
0,192,152,0,64,208,137,158,5,48,0,73,154,21,36,64,208,136,159,4,0,64,152,
64,208,64,159,64,208,128,157,0,72,152,8,64,208,128,161,0,64,144,64,208,
128,159,0,64,156,64,208,128,159,0,137,161,5,16,0,64,160,64,208,136,161,
4,0,128,159,0,64,162,64,208,128,158,0,137,164,5,24,0,72,161,16,64,208,64,
152,64,208,64,157,64,208,128,159,0,128,159,0,64,166,64,208,64,154,64,208,
128,148,0,72,151,8,64,208,128,144,0,128,150,0,200,155,9,0,64,208,128,161,
0,64,154,64,208,73,151,13,38,64,208,64,157,64,208,128,152,0,136,145,4,0,
192,144,0,64,208,200,162,13,0,64,208,64,157,64,208,128,158,0,128,144,0,
136,159,4,0,128,158,0,201,162,48,180,0,64,208,201,158,10,26,0,64,208,128,
173,0,137,148,5,8,0,128,145,0,192,152,0,64,208,128,154,0,73,161,9,12,64,
208,128,158,0,128,159,0,128,166,0,73,159,46,81,64,208,137,158,5,16,0,137,
151,5,8,0,128,145,0,128,154,0,137,164,5,8,0,128,160,0,192,166,0,64,208,
64,144,64,208,64,152,64,208,128,161,0,72,158,24,64,208,137,154,5,16,0,72,
152,8,64,208,128,154,0,128,148,0,128,166,0,64,157,64,208,136,154,4,0,128,
144,0,72,161,44,64,208,73,163,9,28,64,208,128,146,0,137,159,5,12,0,64,156,
64,208,128,144,0,64,160,64,208,128,159,0,72,173,8,64,208,128,145,0,128,
168,0,64,160,64,208,128,159,0,201,166,62,94,0,64,208,73,160,13,40,64,208,
64,165,64,208,128,162,0,72,147,12,64,208,64,156,64,208,128,163,0,64,146,
64,208,64,156,64,208,64,152,64,208,128,154,0,72,173,12,64,208,64,156,64,
208,128,159,0,128,165,0,72,164,29,64,208,73,154,9,12,64,208,128,154,0,128,
152,0,192,158,0,64,208,64,154,64,208,128,154,0,128,163,0,128,168,0,64,156,
64,208,73,157,13,184,64,208,64,162,64,208,128,154,0,137,150,5,91,0,201,
146,22,75,0,64,208,137,154,5,8,0,128,145,0,64,164,64,208,128,145,0,200,
145,30,0,64,208,137,156,5,12,0,64,152,64,208,128,166,0,192,162,0,64,208,
64,160,64,208,128,166,0,64,144,64,208,73,159,13,16,64,208,136,159,4,0,128,
158,0,128,152,0,128,162,0,64,148,64,208,136,161,4,0,128,160,0,73,154,13,
57,64,208,136,161,4,0,128,154,0,72,152,32,64,208,73,158,9,20,64,208,128,
157,0,136,148,4,0,64,144,64,208,128,166,0,64,173,64,208,128,163,0,192,151,
0,64,208,136,162,4,0,128,161,0,64,156,64,208,137,161,5,16,0,72,158,8,64,
208,128,162,0,128,151,0,128,166,0,73,162,21,104,64,208,137,158,5,12,0,136,
154,4,0,128,145,0,128,161,0,73,160,13,64,64,208,136,161,4,0,128,155,0,72,
159,24,64,208,73,162,9,16,64,208,128,161,0,136,152,4,0,128,148,0,128,163,
0,64,158,64,208,137,158,5,16,0,136,146,4,0,64,144,64,208,128,147,0,136,
163,4,0,128,162,0,64,161,64,208,72,154,8,64,208,128,159,0,64,145,64,208,
128,158,0,137,168,5,57,0,72,166,33,64,208,73,159,9,17,64,208,128,154,0,
192,154,0,64,208,128,159,0,64,162,64,208,64,160,64,208,128,152,0,64,163,
64,208,72,173,8,64,208,128,163,0,64,152,64,208,128,157,0,192,173,0,64,208,
137,151,5,8,0,128,147,0,128,161,0,82,166,2,236,13,89,64,208,202,157,40,
1,82,0,64,208,137,158,5,16,0,136,154,4,0,64,152,64,208,128,162,0,192,162,
0,64,208,136,173,4,0,64,162,64,208,128,163,0,73,151,9,144,64,208,128,157,
0,73,146,17,37,64,208,72,162,8,64,208,128,158,0,128,160,0,200,145,9,0,64,
208,128,161,0,64,144,64,208,136,163,4,0,128,162,0,72,148,58,64,208,73,159,
14,30,64,208,192,158,0,64,208,128,146,0,137,156,5,8,0,128,152,0,192,158,
0,64,208,128,148,0,73,166,9,12,64,208,128,145,0,128,162,0,64,174,64,208,
64,162,64,208,128,162,0,64,147,64,208,137,158,5,20,0,72,156,8,64,208,128,
161,0,64,152,64,208,128,173,0,192,173,0,64,208,64,152,64,208,64,158,64,
208,128,151,0,137,155,5,74,0,72,154,32,64,208,73,155,9,20,64,208,128,148,
0,72,152,8,64,208,128,162,0,128,146,0,136,161,4,0,128,158,0,192,152,0,64,
208,137,161,5,16,0,72,159,8,64,208,128,158,0,128,158,0,72,173,8,64,208,
128,164,0,192,162,0,64,208,128,162,0,64,156,64,208,137,158,5,61,0,73,152,
13,36,64,208,64,154,64,208,128,158,0,72,145,12,64,208,64,155,64,208,128,
161,0,64,144,64,208,64,148,64,208,128,161,0,72,157,12,64,208,64,154,64,
208,128,161,0,192,154,0,64,208,128,158,0,137,161,5,12,0,136,160,4,0,128,
159,0,128,162,0,202,163,44,1,71,0,64,208,137,157,5,17,0,200,154,9,0,64,
208,128,158,0,128,151,0,136,163,4,0,64,161,64,208,64,162,64,208,64,163,
64,208,128,151,0,73,160,25,172,64,208,137,158,5,16,0,72,154,8,64,208,128,
156,0,128,152,0,128,159,0,72,159,61,64,208,73,157,9,33,64,208,128,157,0,
137,152,5,16,0,136,151,4,0,64,145,64,208,128,161,0,192,154,0,64,208,128,
145,0,137,161,5,20,0,136,159,4,0,64,158,64,208,136,156,4,0,128,148,0,128,
164,0,64,158,64,208,137,159,5,47,0,201,152,10,17,0,64,208,128,162,0,136,
148,4,0,128,144,0,136,157,4,0,192,154,0,64,208,192,158,0,64,208,64,152,
64,208,64,152,64,208,128,162,0,73,164,9,28,64,208,128,154,0,136,162,4,0,
64,161,64,208,136,156,4,0,64,148,64,208,128,158,0,64,175,64,208,128,158,
0,72,162,25,64,208,201,162,10,17,0,64,208,128,163,0,136,154,4,0,128,152,
0,128,163,0,64,161,64,208,137,158,5,46,0,201,152,10,29,0,64,208,128,152,
0,72,148,8,64,208,128,164,0,64,146,64,208,64,173,64,208,128,148,0,200,156,
9,0,64,208,128,173,0,128,154,0,73,162,9,29,64,208,128,160,0,72,161,17,64,
208,192,161,0,64,208,64,148,64,208,128,156,0,128,159,0,136,173,4,0,128,
163,0,73,166,9,60,64,208,128,161,0,72,165,28,64,208,72,152,16,64,208,64,
148,64,208,64,157,64,208,128,152,0,64,146,64,208,128,149,0,64,164,64,208,
73,165,9,16,64,208,128,147,0,136,148,4,0,128,147,0,128,175,0,64,173,64,
208,136,160,4,0,64,152,64,208,128,151,0,210,162,1,63,6,63,0,64,208,73,158,
9,142,64,208,128,159,0,73,150,9,64,64,208,128,162,0,73,145,13,28,64,208,
136,160,4,0,128,148,0,72,144,8,64,208,128,159,0,64,134,64,208,128,166,0,
72,148,20,64,208,73,165,9,12,64,208,128,154,0,128,154,0,128,168,0,64,147,
64,208,128,146,0,201,155,10,30,0,64,208,128,161,0,200,152,13,0,64,208,136,
166,4,0,128,159,0,64,151,64,208,128,173,0,72,157,12,64,208,64,154,64,208,
128,144,0,64,156,64,208,137,158,5,16,0,136,155,4,0,64,154,64,208,128,161,
0,136,166,4,0,128,161,0,73,164,9,129,64,208,128,161,0,201,161,34,89,0,64,
208,137,157,5,20,0,73,147,9,12,64,208,128,163,0,128,145,0,128,156,0,136,
163,4,0,128,161,0,72,160,16,64,208,137,156,5,8,0,128,154,0,128,161,0,64,
159,64,208,137,160,5,24,0,137,145,5,16,0,136,144,4,0,64,134,64,208,128,
162,0,128,159,0,137,165,5,8,0,128,161,0,128,166,0,72,163,12,64,208,64,161,
64,208,128,158,0,64,162,64,208,73,155,9,12,64,208,128,159,0,128,151,0,128,
158,0,73,167,9,28,64,208,128,154,0,72,166,16,64,208,136,173,4,0,64,152,
64,208,128,161,0,128,165,0,64,173,64,208,136,163,4,0,128,145,0,74,160,194,
2,117,64,208,201,158,14,114,0,64,208,136,159,4,0,128,158,0,73,152,9,48,
64,208,128,154,0,137,145,5,32,0,64,144,64,208,72,159,20,64,208,136,159,
4,0,64,156,64,208,64,161,64,208,128,145,0,128,157,0,64,147,64,208,128,148,
0,201,155,14,25,0,64,208,136,166,4,0,128,161,0,64,154,64,208,136,166,4,
0,128,156,0,64,157,64,208,137,154,5,16,0,136,148,4,0,64,147,64,208,128,
163,0,136,163,4,0,128,159,0,73,165,9,33,64,208,128,161,0,201,161,10,13,
0,64,208,128,161,0,128,160,0,64,162,64,208,136,160,4,0,128,152,0,200,173,
21,0,64,208,137,166,5,12,0,136,161,4,0,128,156,0,128,173,0,64,166,64,208,
72,152,8,64,208,128,158,0,64,148,64,208,128,152,0,64,159,64,208,73,156,
17,198,64,208,72,159,8,64,208,128,154,0,128,154,0,201,150,14,91,0,64,208,
64,161,64,208,128,148,0,73,146,9,41,64,208,128,148,0,72,145,12,64,208,136,
163,4,0,128,161,0,192,144,0,64,208,137,163,5,12,0,64,152,64,208,128,154,
0,128,166,0,200,148,25,0,64,208,73,147,13,16,64,208,64,158,64,208,128,161,
0,128,144,0,128,163,0,64,147,64,208,64,156,64,208,128,163,0,201,154,30,
70,0,64,208,73,161,9,16,64,208,128,157,0,136,145,4,0,128,144,0,64,162,64,
208,128,152,0,72,152,24,64,208,137,158,5,12,0,64,144,64,208,128,166,0,64,
160,64,208,128,161,0,192,151,0,64,208,137,163,5,8,0,128,161,0,128,166,0,
192,155,0,64,208,72,161,8,64,208,128,157,0,64,145,64,208,128,150,0,73,161,
37,177,64,208,137,158,5,20,0,137,154,5,12,0,136,148,4,0,128,145,0,128,156,
0,137,164,5,8,0,128,162,0,128,166,0,201,159,34,85,0,64,208,137,155,5,12,
0,136,151,4,0,128,146,0,72,162,8,64,208,128,152,0,64,158,64,208,128,160,
0,72,158,24,64,208,73,165,9,16,64,208,128,146,0,136,158,4,0,128,152,0,128,
166,0,64,157,64,208,137,152,5,12,0,136,146,4,0,128,144,0,136,163,4,0,64,
161,64,208,128,148,0,64,160,64,208,73,160,9,40,64,208,128,159,0,137,147,
5,28,0,72,146,12,64,208,64,152,64,208,128,173,0,64,144,64,208,64,173,64,
208,128,159,0,128,151,0,137,162,5,8,0,128,161,0,128,164,0,201,166,10,41,
0,64,208,128,151,0,72,164,16,64,208,137,154,5,8,0,128,147,0,128,155,0,64,
162,64,208,137,152,5,8,0,128,148,0,128,161,0,64,173,64,208,72,161,8,64,
208,128,146,0,128,152,0,64,161,64,208,74,158,34,1,78,64,208,73,154,9,16,
64,208,128,158,0,136,152,4,0,128,144,0,72,173,8,64,208,128,161,0,128,168,
0,201,151,10,170,0,64,208,128,158,0,201,147,18,87,0,64,208,137,152,5,8,
0,128,151,0,128,161,0,73,145,29,45,64,208,137,156,5,16,0,137,151,5,8,0,
128,148,0,128,152,0,136,163,4,0,128,157,0,192,144,0,64,208,64,148,64,208,
64,159,64,208,128,151,0,192,146,0,64,208,73,157,9,16,64,208,128,158,0,136,
152,4,0,128,144,0,128,175,0,72,149,16,64,208,72,165,8,64,208,128,145,0,
128,163,0,64,148,64,208,201,161,10,42,0,64,208,128,156,0,73,157,9,20,64,
208,128,159,0,72,156,8,64,208,128,158,0,128,145,0,64,160,64,208,192,159,
0,64,208,128,145,0,137,164,5,8,0,128,163,0,128,166,0,73,155,17,65,64,208,
72,158,8,64,208,128,161,0,128,155,0,72,154,37,64,208,201,158,14,25,0,64,
208,64,164,64,208,128,154,0,137,148,5,8,0,128,145,0,128,157,0,136,161,4,
0,128,159,0,64,152,64,208,136,166,4,0,128,161,0,200,157,29,0,64,208,137,
158,5,12,0,136,157,4,0,128,146,0,72,173,8,64,208,128,156,0,128,159,0,192,
156,0,64,208,137,161,5,20,0,137,148,5,8,0,128,144,0,64,154,64,208,128,159,
0,136,166,4,0,64,165,64,208,128,148,0,74,165,31,1,9,64,208,137,148,5,16,
0,64,146,64,208,64,149,64,208,128,159,0,192,162,0,64,208,128,154,0,201,
162,34,177,0,64,208,137,161,5,20,0,137,154,5,8,0,128,146,0,64,159,64,208,
128,154,0,136,166,4,0,128,162,0,73,160,9,81,64,208,128,173,0,64,159,64,
208,137,155,5,36,0,73,150,9,20,64,208,128,162,0,137,146,5,8,0,128,145,0,
128,148,0,136,154,4,0,64,152,64,208,128,159,0,73,162,9,25,64,208,128,152,
0,137,159,5,13,0,192,156,0,64,208,128,158,0,128,161,0,136,166,4,0,128,164,
0,192,161,0,64,208,137,157,5,28,0,73,150,13,20,64,208,64,154,64,208,128,
163,0,136,147,4,0,128,144,0,128,156,0,137,161,5,26,0,200,160,9,0,64,208,
128,156,0,192,158,0,64,208,64,144,64,208,128,163,0,128,163,0,200,164,37,
0,64,208,137,158,5,16,0,72,150,8,64,208,128,162,0,128,144,0,72,161,8,64,
208,128,160,0,64,160,64,208,128,160,0,192,163,0,64,208,72,148,8,64,208,
128,161,0,64,145,64,208,128,148,0,73,173,25,36,64,208,137,161,5,12,0,136,
158,4,0,128,152,0,136,173,4,0,128,162,0,72,167,8,64,208,128,161,0,128,166,
0,136,175,4,0,192,174,0,64,208,128,162,0,210,164,1,63,3,180,0,64,208,73,
159,25,149,64,208,137,156,5,12,0,136,155,4,0,128,147,0,136,161,4,0,128,
160,0,73,154,25,69,64,208,137,158,5,16,0,136,155,4,0,64,151,64,208,128,
146,0,128,164,0,73,146,9,25,64,208,128,154,0,200,145,9,0,64,208,128,161,
0,64,144,64,208,128,164,0,72,152,12,64,208,64,146,64,208,128,144,0,64,148,
64,208,128,160,0,73,157,17,40,64,208,136,165,4,0,64,162,64,208,128,160,
0,72,156,16,64,208,137,154,5,8,0,128,151,0,128,168,0,64,155,64,208,128,
161,0,64,158,64,208,136,161,4,0,64,156,64,208,128,161,0,201,164,22,92,0,
64,208,137,152,5,12,0,136,151,4,0,128,148,0,128,155,0,73,162,9,62,64,208,
128,160,0,200,161,29,0,64,208,137,155,5,16,0,137,147,5,8,0,128,146,0,128,
154,0,136,161,4,0,128,160,0,192,160,0,64,208,73,154,9,16,64,208,128,158,
0,64,146,64,208,128,162,0,128,162,0,192,163,0,64,208,128,145,0,73,173,25,
62,64,208,137,154,5,12,0,136,152,4,0,128,145,0,136,162,4,0,128,161,0,200,
166,25,0,64,208,73,161,9,12,64,208,128,173,0,128,144,0,64,162,64,208,128,
160,0,192,165,0,64,208,136,158,4,0,128,148,0,64,175,64,208,128,166,0,64,
163,64,208,74,159,67,1,61,64,208,201,154,14,33,0,64,208,64,158,64,208,128,
160,0,137,151,5,12,0,136,148,4,0,128,146,0,64,152,64,208,128,161,0,73,162,
9,16,64,208,128,159,0,136,161,4,0,128,159,0,64,168,64,208,64,154,64,208,
128,144,0,201,154,44,149,0,64,208,73,158,18,25,64,208,192,156,0,64,208,
64,158,64,208,128,161,0,64,147,64,208,128,154,0,64,161,64,208,192,158,0,
64,208,128,146,0,73,148,22,69,64,208,200,157,9,0,64,208,128,144,0,64,145,
64,208,128,162,0,72,146,28,64,208,73,149,9,16,64,208,128,157,0,136,148,
4,0,128,146,0,136,166,4,0,128,157,0,64,145,64,208,137,159,5,12,0,64,158,
64,208,128,159,0,128,161,0,64,151,64,208,72,165,24,64,208,64,152,64,208,
64,156,64,208,64,156,64,208,64,144,64,208,128,168,0,192,154,0,64,208,128,
161,0,73,157,21,81,64,208,137,166,5,8,0,128,157,0,64,173,64,208,128,145,
0,72,156,49,64,208,73,152,9,28,64,208,128,160,0,73,148,9,12,64,208,128,
161,0,128,147,0,64,151,64,208,128,159,0,200,166,13,0,64,208,64,160,64,208,
128,175,0,128,157,0,64,155,64,208,64,158,64,208,128,154,0,192,158,0,64,
208,137,156,5,12,0,64,146,64,208,128,148,0,128,159,0,74,164,26,1,15,64,
208,72,161,12,64,208,64,154,64,208,128,157,0,64,159,64,208,128,161,0,73,
162,9,238,64,208,128,162,0,72,161,222,64,208,137,158,5,129,0,73,152,41,
60,64,208,64,157,64,208,64,146,64,208,64,149,64,208,64,161,64,208,64,162,
64,208,64,154,64,208,64,155,64,208,64,163,64,208,128,145,0,72,151,8,64,
208,128,157,0,64,144,64,208,136,160,4,0,128,155,0,200,157,29,0,64,208,64,
144,64,208,64,160,64,208,64,145,64,208,64,144,64,208,64,157,64,208,128,
154,0,64,156,64,208,73,158,17,24,64,208,64,155,64,208,64,154,64,208,128,
158,0,64,144,64,208,128,160,0,64,173,64,208,128,157,0,73,173,18,81,64,208,
192,155,0,64,208,64,154,64,208,128,158,0,136,165,4,0,64,161,64,208,73,155,
29,36,64,208,64,144,64,208,64,146,64,208,64,145,64,208,64,144,64,208,64,
157,64,208,128,154,0,64,148,64,208,128,158,0,64,158,64,208,64,145,64,208,
64,144,64,208,64,157,64,208,128,154,0,64,175,64,208,128,151,0,64,160,64,
208,128,161,0,64,163,64,208,128,154,0,73,173,14,34,64,208,192,161,0,64,
208,128,159,0,72,168,12,64,208,64,154,64,208,128,173,0,192,166,0,64,208,
128,159,0,128,174,0,192,165,0,64,208,73,156,9,61,64,208,128,161,0,73,152,
9,45,64,208,128,155,0,73,147,9,21,64,208,128,144,0,192,145,0,64,208,136,
157,4,0,128,151,0,64,148,64,208,137,159,5,8,0,128,148,0,128,161,0,136,155,
4,0,128,154,0,73,162,13,49,64,208,136,163,4,0,128,152,0,73,160,9,20,64,
208,128,166,0,64,159,64,208,64,159,64,208,128,161,0,192,161,0,64,208,137,
161,5,8,0,128,148,0,128,168,0,136,166,4,0,128,165,0,82,173,1,15,1,185,64,
208,73,157,29,119,64,208,73,158,9,20,64,208,128,154,0,136,156,4,0,64,147,
64,208,128,156,0,128,173,0,137,150,5,38,0,73,147,9,26,64,208,128,156,0,
200,145,9,0,64,208,128,166,0,192,144,0,64,208,128,157,0,64,148,64,208,128,
161,0,73,155,17,29,64,208,64,162,64,208,64,149,64,208,128,154,0,200,154,
9,0,64,208,128,154,0,128,151,0,64,156,64,208,137,158,5,16,0,72,154,8,64,
208,128,158,0,128,151,0,128,159,0,73,162,29,103,64,208,137,163,5,16,0,136,
158,4,0,64,144,64,208,128,157,0,64,173,64,208,128,156,0,73,160,9,36,64,
208,128,151,0,72,159,16,64,208,137,162,5,8,0,128,151,0,128,165,0,64,158,
64,208,136,159,4,0,128,154,0,192,161,0,64,208,72,163,8,64,208,128,161,0,
192,157,0,64,208,200,160,13,0,64,208,136,160,4,0,128,146,0,64,156,64,208,
128,158,0,201,166,14,34,0,64,208,64,166,64,208,128,144,0,200,164,17,0,64,
208,136,160,4,0,64,152,64,208,128,144,0,128,163,0,64,173,64,208,128,162,
0,73,168,97,149,64,208,73,157,9,52,64,208,128,157,0,137,147,5,32,0,73,145,
13,16,64,208,136,152,4,0,128,144,0,128,144,0,64,146,64,208,64,161,64,208,
128,156,0,137,152,5,8,0,128,149,0,128,156,0,137,164,5,24,0,137,160,5,16,
0,64,159,64,208,136,161,4,0,128,148,0,128,163,0,73,167,9,12,64,208,128,
159,0,128,165,0,128,173,0,64,167,64,208,137,158,5,33,0,137,146,5,12,0,136,
145,4,0,128,144,0,200,152,13,0,64,208,136,148,4,0,128,144,0,128,151,0,137,
162,5,12,0,136,160,4,0,128,159,0,128,166,0,192,169,0,64,208,201,159,10,
13,0,64,208,128,162,0,128,150,0,128,163,0,72,175,113,64,208,137,155,5,72,
0,73,151,49,60,64,208,137,160,5,16,0,64,147,64,208,64,156,64,208,128,163,
0,64,166,64,208,64,146,64,208,64,149,64,208,64,162,64,208,64,156,64,208,
64,149,64,208,128,162,0,72,148,8,64,208,128,161,0,128,146,0,64,154,64,208,
128,160,0,73,161,9,33,64,208,128,159,0,72,158,16,64,208,64,161,64,208,64,
162,64,208,128,152,0,192,157,0,64,208,128,168,0,128,168,0,64,174,64,208,
137,152,5,12,0,136,146,4,0,128,145,0,128,158,0,64,159,80,208,40,177,210,
159,2,119,25,254,0,64,208,74,157,18,1,44,64,208,137,163,5,8,0,128,160,0,
128,167,0,73,150,13,132,64,208,136,162,4,0,128,145,0,73,146,34,67,64,208,
201,161,10,21,0,64,208,128,158,0,136,156,4,0,64,146,64,208,128,159,0,64,
162,64,208,128,152,0,200,145,21,0,64,208,137,164,5,12,0,136,160,4,0,128,
159,0,128,166,0,192,144,0,64,208,64,152,64,208,128,154,0,200,148,29,0,64,
208,73,160,13,20,64,208,64,174,64,208,128,155,0,136,157,4,0,128,150,0,128,
166,0,64,147,64,208,137,160,5,12,0,136,151,4,0,128,147,0,64,165,64,208,
128,158,0,201,154,62,109,0,64,208,201,159,10,39,0,64,208,128,163,0,201,
154,10,13,0,64,208,128,160,0,128,148,0,64,158,64,208,192,159,0,64,208,136,
163,4,0,128,159,0,137,161,5,8,0,128,160,0,192,163,0,64,208,128,159,0,72,
152,24,64,208,73,161,9,16,64,208,128,151,0,136,158,4,0,128,146,0,128,166,
0,64,151,64,208,137,161,5,16,0,72,156,8,64,208,128,160,0,128,148,0,128,
163,0,72,156,33,64,208,137,160,5,12,0,136,158,4,0,128,157,0,72,173,8,64,
208,128,161,0,192,161,0,64,208,128,166,0,192,155,0,64,208,128,161,0,201,
163,10,227,0,64,208,128,148,0,201,160,54,110,0,64,208,137,154,5,32,0,73,
150,17,24,64,208,64,161,64,208,64,157,64,208,128,163,0,136,146,4,0,128,
145,0,128,151,0,137,164,5,12,0,64,159,64,208,128,159,0,128,167,0,200,159,
33,0,64,208,73,161,9,24,64,208,128,156,0,72,160,8,64,208,128,164,0,64,157,
64,208,128,148,0,128,163,0,64,158,64,208,137,158,5,12,0,136,152,4,0,128,
147,0,136,164,4,0,128,160,0,72,162,70,64,208,73,159,9,54,64,208,128,161,
0,137,157,5,37,0,200,154,13,0,64,208,64,149,64,208,128,161,0,64,147,64,
208,64,144,64,208,64,161,64,208,64,154,64,208,128,150,0,192,158,0,64,208,
128,160,0,137,164,5,8,0,128,161,0,128,174,0,192,161,0,64,208,137,160,5,
16,0,137,152,5,8,0,128,146,0,128,156,0,201,163,10,13,0,64,208,128,159,0,
128,161,0,128,173,0,73,166,25,53,64,208,73,156,9,12,64,208,128,162,0,128,
151,0,64,157,64,208,128,161,0,72,165,12,64,208,136,160,4,0,128,151,0,192,
164,0,64,208,137,154,5,8,0,128,147,0,128,159,0,200,173,34,0,64,208,137,
160,5,16,0,136,158,4,0,64,146,64,208,128,156,0,200,173,9,0,64,208,128,157,
0,128,162,0,192,168,0,64,208,128,160,0,74,150,123,10,155,64,208,73,157,
17,53,64,208,64,146,64,208,64,155,64,208,128,161,0,201,154,10,29,0,64,208,
128,165,0,72,146,12,64,208,64,155,64,208,128,161,0,64,145,64,208,128,152,
0,64,156,64,208,128,154,0,137,162,5,52,0,72,161,8,64,208,128,154,0,64,160,
64,208,137,162,5,12,0,136,158,4,0,128,154,0,72,173,20,64,208,137,162,5,
12,0,136,159,4,0,128,158,0,128,163,0,128,163,0,64,173,64,208,136,163,4,
0,128,162,0,82,146,1,50,4,208,64,208,73,159,9,175,64,208,128,157,0,73,152,
21,113,64,208,137,156,5,12,0,136,154,4,0,128,146,0,128,161,0,73,146,33,
60,64,208,73,154,13,24,64,208,64,163,64,208,128,161,0,64,152,64,208,64,
161,64,208,128,163,0,128,163,0,72,145,12,64,208,64,154,64,208,128,152,0,
64,144,64,208,72,162,8,64,208,128,163,0,128,152,0,72,151,20,64,208,64,160,
64,208,64,154,64,208,64,154,64,208,128,163,0,192,148,0,64,208,64,157,64,
208,128,159,0,73,156,17,46,64,208,137,160,5,8,0,128,152,0,128,161,0,200,
155,9,0,64,208,128,161,0,192,154,0,64,208,137,159,5,12,0,136,151,4,0,128,
148,0,128,161,0,136,158,4,0,128,157,0,201,165,18,84,0,64,208,72,160,8,64,
208,128,148,0,128,158,0,201,162,14,42,0,64,208,136,160,4,0,128,152,0,200,
161,17,0,64,208,72,162,8,64,208,128,163,0,128,161,0,64,160,64,208,136,154,
4,0,128,148,0,72,164,12,64,208,136,154,4,0,128,151,0,192,163,0,64,208,64,
161,64,208,128,159,0,73,168,9,28,64,208,128,163,0,72,167,12,64,208,64,159,
64,208,128,161,0,64,166,64,208,128,145,0,64,173,64,208,136,163,4,0,128,
161,0,82,144,2,99,2,130,64,208,73,157,17,234,64,208,137,158,5,8,0,128,152,
0,128,165,0,73,149,9,109,64,208,128,145,0,201,146,50,73,0,64,208,64,155,
64,208,64,158,64,208,64,159,64,208,64,158,64,208,64,161,64,208,64,144,64,
208,64,148,64,208,64,161,64,208,64,154,64,208,64,152,64,208,128,153,0,72,
145,12,64,208,64,161,64,208,128,152,0,64,144,64,208,136,160,4,0,128,151,
0,72,148,16,64,208,64,134,64,208,64,174,64,208,128,157,0,64,147,64,208,
136,161,4,0,128,151,0,73,154,41,84,64,208,73,160,13,20,64,208,64,163,64,
208,128,161,0,136,154,4,0,128,145,0,72,164,8,64,208,128,144,0,64,161,64,
208,128,148,0,72,152,36,64,208,137,152,5,24,0,72,150,8,64,208,128,154,0,
64,145,64,208,64,157,64,208,128,152,0,136,161,4,0,128,154,0,64,151,64,208,
128,161,0,72,156,17,64,208,200,161,9,0,64,208,128,145,0,128,157,0,64,155,
64,208,128,150,0,74,163,38,1,66,64,208,73,157,13,20,64,208,64,161,64,208,
128,162,0,64,154,64,208,128,161,0,64,164,64,208,64,158,64,208,128,160,0,
73,160,97,128,64,208,137,148,5,52,0,137,145,5,36,0,64,144,64,208,64,162,
64,208,64,147,64,208,64,158,64,208,64,160,64,208,64,156,64,208,64,158,64,
208,128,157,0,64,147,64,208,64,161,64,208,128,157,0,137,157,5,8,0,128,156,
0,64,162,64,208,137,148,5,12,0,64,144,64,208,128,148,0,64,161,64,208,64,
157,64,208,64,144,64,208,128,145,0,72,159,24,64,208,73,152,13,16,64,208,
136,162,4,0,128,160,0,128,148,0,128,158,0,64,158,64,208,128,151,0,72,162,
44,64,208,73,167,21,32,64,208,64,154,64,208,64,158,64,208,64,160,64,208,
128,148,0,72,160,8,64,208,128,144,0,128,159,0,64,173,64,208,128,161,0,64,
161,64,208,73,158,9,33,64,208,128,159,0,137,149,5,16,0,72,148,8,64,208,
128,149,0,128,146,0,192,151,0,64,208,128,160,0,137,163,5,72,0,72,161,64,
64,208,136,160,4,0,64,144,64,208,64,150,64,208,64,152,64,208,64,160,64,
208,64,158,64,208,64,159,64,208,64,149,64,208,64,160,64,208,64,149,64,208,
64,146,64,208,64,158,64,208,64,151,64,208,64,154,64,208,128,152,0,128,160,
0,128,167,0,73,167,13,32,64,208,64,173,64,208,128,161,0,72,165,8,64,208,
128,162,0,64,164,64,208,64,144,64,208,128,161,0,64,173,64,208,136,161,4,
0,64,152,64,208,128,161,0,64,134,64,208,73,161,17,24,64,208,64,163,64,208,
64,144,64,208,128,160,0,136,156,4,0,128,134,0,128,164,0,64,145,64,208,73,
156,9,139,64,208,128,154,0,73,149,14,78,64,208,192,149,0,64,208,128,161,
0,137,146,5,33,0,200,145,25,0,64,208,73,159,9,16,64,208,128,159,0,64,149,
64,208,128,155,0,128,161,0,128,144,0,72,148,24,64,208,137,161,5,12,0,136,
160,4,0,128,150,0,136,173,4,0,128,162,0,64,147,64,208,128,165,0,201,154,
14,37,0,64,208,64,158,64,208,128,145,0,72,152,16,64,208,72,158,8,64,208,
128,162,0,128,152,0,64,151,64,208,128,152,0,64,155,64,208,64,157,64,208,
64,159,64,208,128,147,0,73,162,25,113,64,208,73,160,13,16,64,208,136,156,
4,0,128,146,0,128,152,0,128,164,0,73,160,17,56,64,208,136,154,4,0,64,152,
64,208,128,159,0,72,158,24,64,208,137,163,5,12,0,64,160,64,208,128,164,
0,64,174,64,208,128,155,0,64,157,64,208,136,154,4,0,64,147,64,208,128,159,
0,64,161,64,208,73,162,13,25,64,208,64,152,64,208,128,157,0,136,159,4,0,
192,147,0,64,208,128,163,0,128,163,0,73,173,14,21,64,208,192,173,0,64,208,
128,159,0,136,166,4,0,128,163,0,64,174,64,208,128,155,0,82,148,1,137,3,
85,64,208,73,157,25,197,64,208,137,159,5,16,0,72,154,8,64,208,128,149,0,
128,146,0,128,162,0,73,149,13,103,64,208,64,161,64,208,128,159,0,201,146,
30,66,0,64,208,137,160,5,16,0,137,154,5,8,0,128,146,0,128,156,0,136,163,
4,0,128,161,0,200,145,9,0,64,208,128,156,0,64,144,64,208,137,154,5,16,0,
72,145,8,64,208,128,144,0,128,144,0,64,162,64,208,128,163,0,200,148,13,
0,64,208,136,157,4,0,128,149,0,64,147,64,208,64,157,64,208,128,146,0,201,
154,14,53,0,64,208,136,159,4,0,128,154,0,72,152,32,64,208,73,159,9,20,64,
208,128,152,0,136,158,4,0,64,151,64,208,128,159,0,64,162,64,208,128,160,
0,64,151,64,208,128,163,0,64,156,64,208,200,157,9,0,64,208,128,146,0,128,
156,0,201,163,14,156,0,64,208,64,148,64,208,128,158,0,73,160,21,61,64,208,
137,164,5,12,0,136,161,4,0,128,158,0,128,166,0,72,159,28,64,208,73,159,
9,16,64,208,128,154,0,136,152,4,0,128,144,0,136,163,4,0,128,161,0,64,158,
64,208,192,163,0,64,208,128,162,0,72,162,36,64,208,137,157,5,16,0,137,154,
5,8,0,128,150,0,128,155,0,73,161,9,12,64,208,128,160,0,128,158,0,128,163,
0,192,161,0,64,208,73,158,9,29,64,208,128,147,0,137,147,5,12,0,136,146,
4,0,128,144,0,192,156,0,64,208,128,159,0,137,162,5,8,0,128,161,0,128,163,
0,137,168,5,16,0,136,167,4,0,64,164,64,208,128,158,0,192,173,0,64,208,137,
157,5,8,0,128,154,0,128,161,0,64,147,64,208,201,158,22,220,0,64,208,137,
154,5,12,0,64,145,64,208,128,165,0,128,163,0,73,152,33,117,64,208,137,154,
5,20,0,64,152,64,208,136,154,4,0,64,152,64,208,128,154,0,64,160,64,208,
128,158,0,73,146,13,63,64,208,64,154,64,208,128,159,0,200,145,9,0,64,208,
128,166,0,64,144,64,208,73,161,18,21,64,208,200,152,9,0,64,208,128,144,
0,128,144,0,128,144,0,64,162,64,208,136,163,4,0,192,152,0,64,208,128,152,
0,200,151,9,0,64,208,128,163,0,192,148,0,64,208,136,159,4,0,128,144,0,73,
156,37,62,64,208,137,154,5,12,0,136,152,4,0,128,144,0,72,173,12,64,208,
136,161,4,0,128,147,0,64,161,64,208,128,154,0,72,155,8,64,208,128,163,0,
192,154,0,64,208,200,158,9,0,64,208,128,151,0,128,156,0,64,157,64,208,137,
154,5,12,0,64,152,64,208,128,147,0,128,163,0,73,163,57,192,64,208,73,159,
9,40,64,208,128,161,0,72,152,12,64,208,64,146,64,208,128,161,0,64,144,64,
208,137,154,5,12,0,64,152,64,208,128,161,0,128,161,0,72,162,8,64,208,128,
152,0,128,161,0,201,161,35,91,0,64,208,73,159,9,17,64,208,128,148,0,192,
147,0,64,208,128,144,0,64,165,64,208,64,163,64,208,128,156,0,72,160,16,
64,208,72,173,8,64,208,128,151,0,128,154,0,64,159,64,208,73,159,9,29,64,
208,128,154,0,201,152,14,17,0,64,208,64,152,64,208,128,175,0,128,145,0,
128,154,0,136,163,4,0,128,160,0,192,162,0,64,208,137,158,5,20,0,137,152,
5,12,0,136,148,4,0,128,144,0,128,154,0,137,163,5,16,0,72,162,8,64,208,128,
154,0,128,161,0,128,173,0,73,166,13,33,64,208,64,144,64,208,128,163,0,200,
165,13,0,64,208,136,158,4,0,128,147,0,64,164,64,208,128,144,0,64,173,64,
208,136,161,4,0,128,159,0,64,149,64,208,74,157,62,1,116,64,208,73,158,21,
48,64,208,64,145,64,208,64,155,64,208,64,158,64,208,128,154,0,64,151,64,
208,64,165,64,208,64,152,64,208,64,156,64,208,64,156,64,208,64,144,64,208,
128,168,0,64,164,64,208,128,144,0,82,148,1,28,1,39,64,208,201,159,54,157,
0,64,208,64,160,64,208,72,152,20,64,208,64,154,64,208,64,158,64,208,64,
160,64,208,128,156,0,64,144,64,208,64,154,64,208,64,162,64,208,64,152,64,
208,64,154,64,208,128,144,0,73,154,49,80,64,208,72,158,28,64,208,64,155,
64,208,64,155,64,208,64,149,64,208,64,148,64,208,64,150,64,208,128,144,
0,64,157,64,208,64,152,64,208,64,147,64,208,128,144,0,64,152,64,208,64,
157,64,208,64,161,64,208,64,162,64,208,64,152,64,208,64,162,64,208,64,163,
64,208,128,162,0,64,158,64,208,64,162,64,208,64,160,64,208,64,175,64,208,
64,148,64,208,128,144,0,73,163,69,108,64,208,72,167,24,64,208,64,152,64,
208,64,155,64,208,64,152,64,208,64,169,64,208,128,149,0,64,157,64,208,64,
152,64,208,64,146,64,208,64,149,64,208,64,160,64,208,64,161,64,208,64,152,
64,208,64,162,64,208,64,149,64,208,128,162,0,64,162,64,208,64,149,64,208,
64,165,64,208,64,157,64,208,64,158,64,208,64,155,64,208,64,158,64,208,64,
147,64,208,64,152,64,208,128,152,0,64,164,64,208,64,144,64,208,128,154,
0,72,146,8,64,208,128,159,0,128,144,0,72,156,8,64,208,128,159,0,64,154,
64,208,128,161,0,73,160,65,100,64,208,72,156,36,64,208,72,157,16,64,208,
64,152,64,208,64,163,64,208,128,152,0,64,147,64,208,136,163,4,0,64,162,
64,208,128,163,0,64,146,64,208,64,158,64,208,64,145,64,208,64,144,64,208,
64,157,64,208,128,154,0,72,159,20,64,208,64,161,64,208,64,152,64,208,64,
154,64,208,128,158,0,64,158,64,208,72,158,8,64,208,128,161,0,128,156,0,
72,162,24,64,208,72,173,8,64,208,128,154,0,64,160,64,208,64,147,64,208,
128,163,0,64,161,64,208,128,165,0,82,155,1,77,6,36,64,208,73,155,13,206,
64,208,64,144,64,208,128,161,0,73,148,9,141,64,208,128,159,0,73,146,21,
117,64,208,73,161,9,12,64,208,128,173,0,128,144,0,128,166,0,72,145,12,64,
208,64,144,64,208,128,166,0,64,144,64,208,73,160,9,44,64,208,128,145,0,
64,146,64,208,72,154,16,64,208,64,160,64,208,64,144,64,208,128,157,0,64,
148,64,208,64,144,64,208,64,167,64,208,128,152,0,192,161,0,64,208,72,162,
24,64,208,64,156,64,208,64,144,64,208,64,161,64,208,64,161,64,208,128,144,
0,64,152,64,208,128,160,0,64,147,64,208,72,162,8,64,208,128,158,0,128,157,
0,73,152,9,44,64,208,128,161,0,72,150,8,64,208,128,162,0,64,149,64,208,
64,156,64,208,64,151,64,208,64,144,64,208,64,146,64,208,64,158,64,208,128,
148,0,192,154,0,64,208,128,162,0,73,161,45,91,64,208,73,158,9,28,64,208,
128,160,0,137,147,5,8,0,128,145,0,64,148,64,208,64,160,64,208,128,158,0,
137,163,5,8,0,128,160,0,128,173,0,73,159,14,26,64,208,192,164,0,64,208,
128,158,0,136,157,4,0,192,156,0,64,208,128,154,0,192,160,0,64,208,137,164,
5,12,0,136,159,4,0,128,154,0,128,168,0,73,164,9,21,64,208,128,155,0,64,
163,64,208,192,160,0,64,208,128,158,0,64,165,64,208,128,158,0,82,152,1,
222,2,230,64,208,73,158,9,255,64,208,128,146,0,73,150,17,141,64,208,136,
162,4,0,64,146,64,208,128,175,0,73,146,57,89,64,208,137,162,5,44,0,73,151,
21,32,64,208,64,144,64,208,64,146,64,208,64,158,64,208,128,148,0,64,145,
64,208,64,144,64,208,128,160,0,64,160,64,208,128,173,0,136,173,4,0,128,
164,0,200,145,9,0,64,208,128,164,0,64,144,64,208,137,159,5,12,0,64,151,
64,208,128,147,0,64,165,64,208,128,162,0,72,149,8,64,208,128,144,0,64,147,
64,208,73,156,9,20,64,208,128,163,0,136,155,4,0,64,144,64,208,128,159,0,
128,163,0,73,155,17,45,64,208,64,144,64,208,64,160,64,208,128,157,0,72,
154,8,64,208,128,156,0,192,152,0,64,208,72,160,8,64,208,128,161,0,64,150,
64,208,128,162,0,200,157,45,0,64,208,73,158,9,24,64,208,128,160,0,72,151,
8,64,208,128,157,0,64,144,64,208,128,159,0,72,173,8,64,208,128,152,0,64,
160,64,208,128,158,0,64,156,64,208,136,163,4,0,64,144,64,208,128,168,0,
201,164,30,165,0,64,208,137,157,5,12,0,136,155,4,0,128,154,0,64,161,64,
208,64,152,64,208,128,157,0,73,161,25,76,64,208,72,163,12,64,208,64,144,
64,208,128,160,0,64,147,64,208,128,163,0,72,160,28,64,208,137,156,5,16,
0,136,147,4,0,64,144,64,208,128,158,0,64,175,64,208,128,155,0,64,159,64,
208,136,166,4,0,64,164,64,208,64,149,64,208,64,161,64,208,128,162,0,72,
163,12,64,208,136,150,4,0,128,146,0,64,162,64,208,73,160,9,40,64,208,128,
161,0,72,149,16,64,208,64,160,64,208,64,164,64,208,128,156,0,64,145,64,
208,64,163,64,208,64,155,64,208,128,172,0,128,161,0,201,174,14,43,0,64,
208,64,164,64,208,128,163,0,200,173,26,0,64,208,136,164,4,0,192,159,0,64,
208,136,161,4,0,64,158,64,208,128,156,0,128,165,0,64,175,64,208,128,164,
0,64,151,64,208,73,159,13,126,64,208,136,167,4,0,128,152,0,201,152,14,37,
0,64,208,136,158,4,0,128,151,0,73,147,9,20,64,208,128,158,0,72,145,8,64,
208,128,164,0,128,134,0,128,151,0,73,156,29,49,64,208,137,159,5,16,0,136,
154,4,0,64,152,64,208,128,160,0,136,161,4,0,128,160,0,72,155,8,64,208,128,
154,0,192,154,0,64,208,136,162,4,0,128,152,0,64,157,64,208,72,152,12,64,
208,64,146,64,208,128,152,0,64,146,64,208,64,152,64,208,128,164,0,137,164,
5,83,0,73,162,33,70,64,208,137,156,5,16,0,136,154,4,0,64,145,64,208,128,
158,0,72,161,8,64,208,128,154,0,128,159,0,200,161,21,0,64,208,137,159,5,
8,0,128,152,0,64,161,64,208,128,162,0,192,160,0,64,208,137,154,5,8,0,128,
144,0,128,158,0,192,163,0,64,208,128,161,0,73,168,9,36,64,208,128,144,0,
72,166,12,64,208,136,161,4,0,128,156,0,64,165,64,208,137,154,5,8,0,128,
151,0,128,158,0,64,173,64,208,136,158,4,0,64,156,64,208,128,152,0,192,154,
0,64,208,74,156,50,1,3,64,208,73,159,9,28,64,208,128,160,0,137,154,5,16,
0,64,152,64,208,64,144,64,208,128,166,0,128,158,0,72,162,8,64,208,128,159,
0,64,160,64,208,128,159,0,73,150,9,129,64,208,128,162,0,201,147,26,70,0,
64,208,137,158,5,12,0,136,156,4,0,128,148,0,136,173,4,0,128,165,0,72,146,
24,64,208,73,156,9,16,64,208,128,163,0,64,146,64,208,128,161,0,128,161,
0,192,145,0,64,208,137,161,5,12,0,136,156,4,0,128,146,0,128,163,0,72,149,
13,64,208,192,149,0,64,208,128,157,0,192,148,0,64,208,73,157,13,20,64,208,
64,154,64,208,128,158,0,136,154,4,0,128,152,0,136,166,4,0,192,161,0,64,
208,128,160,0,73,154,25,73,64,208,137,157,5,16,0,72,149,8,64,208,128,146,
0,128,145,0,128,162,0,200,152,41,0,64,208,137,158,5,20,0,72,156,8,64,208,
128,161,0,64,144,64,208,128,156,0,64,159,64,208,64,154,64,208,64,160,64,
208,128,158,0,64,151,64,208,128,157,0,64,155,64,208,128,151,0,201,162,48,
181,0,64,208,137,154,5,30,0,200,152,17,0,64,208,64,156,64,208,64,144,64,
208,128,168,0,192,145,0,64,208,128,144,0,72,160,8,64,208,128,158,0,128,
158,0,201,159,30,78,0,64,208,72,149,16,64,208,64,162,64,208,64,155,64,208,
128,144,0,64,144,64,208,128,160,0,200,158,29,0,64,208,72,162,12,64,208,
64,160,64,208,128,158,0,64,158,64,208,64,155,64,208,128,150,0,64,157,64,
208,137,158,5,8,0,128,156,0,64,164,64,208,128,144,0,72,161,32,64,208,137,
156,5,16,0,136,154,4,0,64,146,64,208,128,160,0,136,163,4,0,64,157,64,208,
128,162,0,64,160,64,208,137,156,5,12,0,136,154,4,0,128,148,0,136,166,4,
0,128,161,0,73,173,21,49,64,208,73,161,9,12,64,208,128,152,0,128,154,0,
128,163,0,200,164,21,0,64,208,72,158,12,64,208,64,156,64,208,128,161,0,
128,154,0,64,163,64,208,128,173,0,128,175,0,82,157,1,215,3,32,64,208,74,
157,14,1,6,64,208,136,173,4,0,128,144,0,73,150,13,139,64,208,136,154,4,
0,128,145,0,201,146,34,70,0,64,208,137,162,5,20,0,73,157,9,12,64,208,128,
146,0,128,155,0,128,161,0,136,165,4,0,128,163,0,72,145,12,64,208,136,161,
4,0,128,154,0,192,144,0,64,208,137,161,5,16,0,64,156,64,208,64,167,64,208,
128,162,0,128,173,0,72,149,44,64,208,137,154,5,36,0,64,146,64,208,64,156,
64,208,64,158,64,208,64,159,64,208,64,158,64,208,64,167,64,208,64,162,64,
208,128,144,0,128,160,0,192,147,0,64,208,136,159,4,0,128,149,0,73,154,13,
86,64,208,64,146,64,208,128,161,0,72,152,66,64,208,137,160,5,41,0,73,152,
13,20,64,208,64,144,64,208,128,151,0,64,144,64,208,128,155,0,192,155,0,
64,208,136,156,4,0,64,154,64,208,128,149,0,72,173,8,64,208,128,152,0,64,
162,64,208,192,152,0,64,208,128,144,0,64,151,64,208,128,156,0,72,156,12,
64,208,136,154,4,0,128,145,0,64,155,64,208,64,160,64,208,128,158,0,73,164,
17,145,64,208,72,149,8,64,208,128,144,0,128,144,0,201,160,18,87,0,64,208,
137,145,5,8,0,128,144,0,128,154,0,200,159,25,0,64,208,73,159,9,16,64,208,
128,154,0,136,158,4,0,128,147,0,128,164,0,192,158,0,64,208,137,157,5,16,
0,64,155,64,208,64,160,64,208,128,158,0,64,158,64,208,72,155,8,64,208,128,
160,0,64,152,64,208,64,155,64,208,128,160,0,200,162,34,0,64,208,201,163,
18,25,0,64,208,64,152,64,208,64,174,64,208,128,154,0,136,161,4,0,128,151,
0,128,166,0,64,161,64,208,128,158,0,137,168,5,20,0,136,167,4,0,64,165,64,
208,136,162,4,0,128,151,0,72,175,12,64,208,64,156,64,208,128,161,0,64,173,
64,208,200,161,13,0,64,208,64,154,64,208,128,158,0,64,160,64,208,128,163,
0,192,156,0,64,208,73,158,21,165,64,208,72,161,8,64,208,128,156,0,64,158,
64,208,128,161,0,201,150,14,79,0,64,208,136,146,4,0,128,144,0,201,146,10,
46,0,64,208,128,146,0,200,145,13,0,64,208,136,162,4,0,128,161,0,64,144,
64,208,73,157,9,16,64,208,128,156,0,64,148,64,208,128,154,0,128,159,0,136,
149,4,0,64,147,64,208,136,163,4,0,64,160,64,208,128,173,0,73,154,9,37,64,
208,128,163,0,200,152,17,0,64,208,137,152,5,8,0,128,147,0,128,154,0,64,
151,64,208,136,160,4,0,128,158,0,72,157,16,64,208,137,159,5,8,0,128,158,
0,128,161,0,192,156,0,64,208,136,165,4,0,128,155,0,73,164,13,119,64,208,
136,151,4,0,128,148,0,201,161,43,67,0,64,208,137,159,5,20,0,137,157,5,12,
0,136,156,4,0,128,146,0,128,158,0,137,165,5,13,0,192,161,0,64,208,128,160,
0,128,166,0,136,160,4,0,192,159,0,64,208,137,163,5,12,0,136,158,4,0,128,
154,0,128,166,0,72,163,8,64,208,128,159,0,64,162,64,208,137,159,5,16,0,
137,157,5,8,0,128,155,0,128,158,0,137,163,5,8,0,128,161,0,128,164,0,73,
167,9,21,64,208,128,151,0,200,166,9,0,64,208,128,151,0,128,165,0,72,174,
8,64,208,128,152,0,64,173,64,208,136,164,4,0,128,161,0,64,158,64,208,74,
157,14,2,20,64,208,64,160,64,208,128,159,0,74,150,66,1,11,64,208,73,157,
25,32,64,208,64,144,64,208,64,148,64,208,64,151,64,208,64,158,64,208,128,
160,0,64,154,64,208,128,165,0,64,162,64,208,64,149,64,208,64,165,64,208,
64,157,64,208,64,152,64,208,64,154,64,208,128,144,0,73,146,54,106,64,208,
73,148,9,21,64,208,128,159,0,200,147,9,0,64,208,128,151,0,128,146,0,72,
162,24,64,208,72,152,12,64,208,64,144,64,208,128,161,0,64,144,64,208,128,
161,0,128,154,0,72,145,33,64,208,201,158,10,21,0,64,208,128,161,0,72,155,
8,64,208,128,161,0,128,148,0,64,162,64,208,128,161,0,64,144,64,208,136,
161,4,0,64,146,64,208,64,167,64,208,128,159,0,72,148,44,64,208,137,148,
5,20,0,64,144,64,208,64,160,64,208,64,154,64,208,128,158,0,64,155,64,208,
64,158,64,208,64,148,64,208,64,154,64,208,128,144,0,64,147,64,208,72,163,
8,64,208,128,159,0,64,160,64,208,64,144,64,208,64,157,64,208,64,146,64,
208,64,158,64,208,64,153,64,208,64,161,64,208,64,154,64,208,136,158,4,0,
128,144,0,73,154,33,92,64,208,73,161,9,24,64,208,128,161,0,136,156,4,0,
64,154,64,208,136,159,4,0,128,144,0,128,164,0,72,152,48,64,208,73,160,9,
36,64,208,128,154,0,73,154,9,12,64,208,128,154,0,128,145,0,64,159,64,208,
64,154,64,208,64,160,64,208,128,158,0,136,164,4,0,128,162,0,64,151,64,208,
64,152,64,208,128,161,0,72,156,68,64,208,73,160,13,40,64,208,64,149,64,
208,128,150,0,73,147,13,24,64,208,64,158,64,208,128,155,0,64,145,64,208,
64,163,64,208,128,160,0,128,154,0,73,163,13,20,64,208,64,155,64,208,128,
165,0,64,162,64,208,128,163,0,128,166,0,64,155,64,208,137,173,5,68,0,72,
152,60,64,208,137,151,5,52,0,64,147,64,208,64,160,64,208,64,144,64,208,
64,164,64,208,64,154,64,208,64,158,64,208,64,156,64,208,64,145,64,208,64,
152,64,208,64,157,64,208,64,144,64,208,128,162,0,128,161,0,128,147,0,64,
175,64,208,64,160,64,208,64,173,64,208,64,154,64,208,128,161,0,74,163,43,
1,45,64,208,73,157,9,29,64,208,128,145,0,72,156,12,64,208,64,158,64,208,
128,148,0,192,147,0,64,208,128,161,0,64,159,64,208,128,161,0,73,160,69,
121,64,208,73,157,53,60,64,208,72,164,16,64,208,64,158,64,208,64,162,64,
208,128,158,0,64,158,64,208,72,162,8,64,208,128,146,0,64,157,64,208,64,
155,64,208,64,144,64,208,64,153,64,208,128,157,0,64,152,64,208,128,144,
0,128,159,0,72,159,16,64,208,136,148,4,0,64,144,64,208,128,162,0,64,158,
64,208,73,161,9,29,64,208,128,144,0,200,158,13,0,64,208,64,157,64,208,128,
161,0,64,148,64,208,128,158,0,128,174,0,200,162,57,0,64,208,73,160,37,48,
64,208,64,149,64,208,64,145,64,208,64,154,64,208,64,160,64,208,64,149,64,
208,64,148,64,208,64,152,64,208,128,162,0,72,148,8,64,208,128,158,0,128,
147,0,128,161,0,192,161,0,64,208,73,161,21,68,64,208,64,158,64,208,64,146,
64,208,64,149,64,208,128,162,0,73,154,13,20,64,208,64,158,64,208,128,162,
0,64,151,64,208,128,151,0,64,160,64,208,64,149,64,208,64,148,64,208,64,
161,64,208,64,162,64,208,64,146,64,208,128,158,0,136,173,4,0,128,166,0,
73,166,17,48,64,208,64,160,64,208,64,158,64,208,128,168,0,72,165,12,64,
208,64,145,64,208,128,146,0,64,164,64,208,136,161,4,0,64,158,64,208,64,
156,64,208,128,161,0,72,173,44,64,208,73,152,13,28,64,208,136,173,4,0,128,
161,0,136,151,4,0,64,147,64,208,64,160,64,208,128,161,0,136,161,4,0,64,
156,64,208,128,159,0,64,168,64,208,128,154,0,74,167,51,12,227,64,208,73,
160,9,29,64,208,128,145,0,201,151,10,13,0,64,208,128,162,0,128,147,0,64,
157,64,208,128,146,0,72,175,12,64,208,64,162,64,208,128,161,0,128,165,0,
82,163,1,150,10,253,64,208,73,158,17,212,64,208,72,160,8,64,208,128,160,
0,128,157,0,201,149,10,139,0,64,208,128,162,0,73,146,33,86,64,208,73,154,
9,24,64,208,128,165,0,72,152,8,64,208,128,147,0,64,148,64,208,128,162,0,
128,158,0,200,145,34,0,64,208,192,173,0,64,208,73,159,9,20,64,208,128,159,
0,136,155,4,0,64,147,64,208,128,154,0,128,173,0,64,144,64,208,137,154,5,
12,0,64,151,64,208,128,158,0,128,158,0,72,148,24,64,208,72,158,12,64,208,
64,158,64,208,128,161,0,64,157,64,208,128,163,0,64,147,64,208,72,154,8,
64,208,128,161,0,64,147,64,208,128,159,0,73,156,14,45,64,208,192,145,0,
64,208,128,144,0,72,155,20,64,208,136,173,4,0,64,144,64,208,136,160,4,0,
128,159,0,64,150,64,208,64,154,64,208,128,165,0,64,157,64,208,136,161,4,
0,128,160,0,73,165,13,134,64,208,64,162,64,208,128,158,0,73,161,9,86,64,
208,128,158,0,72,160,58,64,208,201,157,14,37,0,64,208,64,149,64,208,128,
161,0,137,147,5,12,0,64,146,64,208,128,158,0,64,154,64,208,64,154,64,208,
128,144,0,200,166,9,0,64,208,128,145,0,64,160,64,208,128,166,0,64,159,64,
208,137,160,5,12,0,64,154,64,208,128,163,0,128,167,0,72,164,16,64,208,64,
160,64,208,64,163,64,208,128,160,0,64,162,64,208,72,173,12,64,208,64,154,
64,208,128,161,0,128,147,0,73,169,13,36,64,208,64,147,64,208,128,163,0,
72,168,20,64,208,64,147,64,208,64,158,64,208,64,160,64,208,128,171,0,128,
166,0,192,173,0,64,208,137,160,5,8,0,128,148,0,128,173,0,82,161,2,22,7,
128,64,208,74,159,38,1,76,64,208,137,152,5,16,0,137,148,5,8,0,128,144,0,
128,150,0,73,159,9,12,64,208,128,148,0,128,158,0,128,163,0,73,151,22,117,
64,208,137,158,5,8,0,128,152,0,192,160,0,64,208,128,152,0,73,147,13,58,
64,208,136,158,4,0,128,144,0,201,145,14,21,0,64,208,136,163,4,0,128,158,
0,64,144,64,208,128,148,0,64,146,64,208,200,160,17,0,64,208,64,161,64,208,
64,152,64,208,128,164,0,128,159,0,200,150,17,0,64,208,136,154,4,0,64,146,
64,208,128,161,0,192,148,0,64,208,137,157,5,8,0,128,156,0,64,162,64,208,
128,163,0,73,156,13,149,64,208,136,158,4,0,128,148,0,72,154,21,64,208,201,
146,10,13,0,64,208,128,159,0,128,145,0,128,173,0,64,152,64,208,73,165,89,
96,64,208,73,158,41,72,64,208,64,154,64,208,64,158,64,208,64,160,64,208,
64,160,64,208,64,149,64,208,64,154,64,208,64,166,64,208,64,152,64,208,128,
175,0,64,145,64,208,64,158,64,208,64,155,64,208,64,172,64,208,64,157,64,
208,64,152,64,208,64,166,64,208,128,144,0,64,164,64,208,64,144,64,208,128,
154,0,64,158,64,208,128,159,0,64,173,64,208,64,161,64,208,64,162,64,208,
128,162,0,72,158,20,64,208,137,154,5,12,0,64,144,64,208,128,163,0,128,157,
0,192,157,0,64,208,128,148,0,73,165,9,138,64,208,128,173,0,73,162,37,98,
64,208,137,160,5,24,0,72,147,8,64,208,128,163,0,64,145,64,208,136,163,4,
0,128,152,0,64,162,64,208,128,161,0,72,161,49,64,208,137,159,5,33,0,73,
155,9,21,64,208,128,145,0,136,152,4,0,192,147,0,64,208,128,154,0,64,156,
64,208,128,154,0,137,163,5,8,0,128,160,0,128,164,0,192,160,0,64,208,136,
156,4,0,128,155,0,72,164,12,64,208,136,162,4,0,128,155,0,64,163,64,208,
137,155,5,12,0,64,151,64,208,128,146,0,128,157,0,73,168,9,24,64,208,128,
155,0,72,167,8,64,208,128,152,0,64,166,64,208,128,156,0,200,174,13,0,64,
208,64,146,64,208,128,149,0,64,173,64,208,137,159,5,12,0,136,155,4,0,128,
152,0,128,160,0,64,160,64,208,82,158,2,248,4,159,64,208,74,160,14,2,53,
64,208,64,144,64,208,128,145,0,82,156,1,177,2,24,64,208,74,159,54,1,6,64,
208,72,160,40,64,208,64,149,64,208,64,148,64,208,64,159,64,208,64,160,64,
208,64,152,64,208,64,175,64,208,64,162,64,208,64,152,64,208,128,153,0,64,
158,64,208,128,155,0,73,148,25,133,64,208,64,152,64,208,64,151,64,208,64,
144,64,208,64,153,64,208,128,157,0,73,144,54,93,64,208,64,155,64,208,64,
172,64,208,192,159,0,64,208,64,152,64,208,64,157,64,208,64,152,64,208,72,
161,16,64,208,64,162,64,208,64,158,64,208,128,146,0,64,151,64,208,128,156,
0,64,134,64,208,64,157,64,208,64,146,64,208,64,149,64,208,64,161,64,208,
64,162,64,208,64,145,64,208,64,144,64,208,64,157,64,208,128,154,0,64,145,
64,208,64,144,64,208,64,157,64,208,128,154,0,72,152,40,64,208,64,157,64,
208,64,146,64,208,64,149,64,208,64,161,64,208,64,162,64,208,64,145,64,208,
64,144,64,208,64,157,64,208,128,154,0,64,151,64,208,72,158,12,64,208,64,
157,64,208,128,144,0,64,148,64,208,64,144,64,208,64,157,64,208,64,152,64,
208,128,175,0,73,162,41,104,64,208,72,158,28,64,208,64,160,64,208,64,147,
64,208,64,145,64,208,64,144,64,208,64,157,64,208,128,154,0,64,149,64,208,
128,165,0,72,161,24,64,208,64,152,64,208,72,162,12,64,208,64,149,64,208,
128,165,0,128,151,0,64,160,64,208,64,149,64,208,64,147,64,208,64,152,64,
208,64,158,64,208,64,157,64,208,64,145,64,208,64,144,64,208,64,157,64,208,
128,154,0,72,173,40,64,208,64,157,64,208,64,149,64,208,64,160,64,208,64,
147,64,208,64,158,64,208,64,145,64,208,64,144,64,208,64,157,64,208,128,
154,0,64,166,64,208,64,149,64,208,64,157,64,208,64,162,64,208,128,160,0,
72,154,20,64,208,64,163,64,208,64,154,64,208,64,152,64,208,128,168,0,64,
148,64,208,73,158,21,40,64,208,64,162,64,208,64,160,64,208,64,175,64,208,
128,148,0,64,157,64,208,64,144,64,208,64,155,64,208,64,158,64,208,128,147,
0,64,160,64,208,64,144,64,208,64,151,64,208,64,146,64,208,64,149,64,208,
64,160,64,208,64,161,64,208,64,162,64,208,64,154,64,208,128,144,0,64,158,
64,208,72,158,8,64,208,128,157,0,128,157,0,73,163,9,20,64,208,128,157,0,
64,162,64,208,64,158,64,208,128,151,0,64,164,64,208,73,158,57,108,64,208,
72,162,16,64,208,64,145,64,208,64,158,64,208,128,160,0,64,160,64,208,64,
152,64,208,64,149,64,208,64,157,64,208,64,162,64,208,64,144,64,208,64,166,
64,208,64,152,64,208,128,175,0,72,155,16,64,208,64,152,64,208,64,161,64,
208,128,162,0,64,145,64,208,64,163,64,208,64,165,64,208,64,147,64,208,64,
144,64,208,64,155,64,208,64,162,64,208,64,149,64,208,128,160,0,64,159,64,
208,137,152,5,16,0,64,144,64,208,64,160,64,208,128,154,0,64,158,64,208,
64,148,64,208,64,147,64,208,64,158,64,208,64,162,64,208,64,158,64,208,64,
146,64,208,64,154,64,208,128,144,0,73,151,9,192,64,208,128,144,0,73,147,
13,76,64,208,136,168,4,0,128,160,0,73,145,9,48,64,208,128,162,0,64,144,
64,208,73,156,9,20,64,208,128,158,0,72,152,8,64,208,128,156,0,128,144,0,
72,159,8,64,208,128,152,0,64,158,64,208,128,146,0,64,146,64,208,137,162,
5,8,0,128,150,0,128,163,0,72,149,100,64,208,72,161,44,64,208,72,164,20,
64,208,64,158,64,208,64,160,64,208,64,156,64,208,128,144,0,64,161,64,208,
64,164,64,208,64,158,64,208,64,160,64,208,128,156,0,64,148,64,208,72,163,
36,64,208,64,161,64,208,64,152,64,208,64,155,64,208,64,152,64,208,64,162,
64,208,64,149,64,208,64,155,64,208,128,172,0,64,162,64,208,64,173,64,208,
128,158,0,64,148,64,208,128,161,0,73,155,9,184,64,208,128,160,0,72,154,
12,64,208,64,161,64,208,128,157,0,64,152,64,208,73,158,9,128,64,208,128,
160,0,73,146,77,108,64,208,72,158,64,64,208,64,155,64,208,64,150,64,208,
64,161,64,208,64,154,64,208,64,157,64,208,64,149,64,208,64,164,64,208,64,
162,64,208,64,149,64,208,64,159,64,208,64,160,64,208,64,158,64,208,64,146,
64,208,64,158,64,208,128,148,0,64,150,64,208,128,148,0,72,145,24,64,208,
72,158,12,64,208,64,146,64,208,128,158,0,64,146,64,208,128,158,0,64,144,
64,208,128,161,0,64,154,64,208,64,146,64,208,128,158,0,73,163,9,20,64,208,
128,160,0,64,159,64,208,64,152,64,208,128,162,0,64,164,64,208,136,158,4,
0,128,154,0,72,157,20,64,208,137,154,5,12,0,136,148,4,0,128,144,0,128,163,
0,64,156,64,208,73,159,9,16,64,208,128,152,0,136,151,4,0,128,147,0,64,162,
64,208,128,163,0,73,164,9,111,64,208,128,144,0,73,161,17,53,64,208,136,
154,4,0,64,146,64,208,128,144,0,200,160,9,0,64,208,128,148,0,64,159,64,
208,137,156,5,12,0,136,152,4,0,128,148,0,136,166,4,0,64,157,64,208,128,
154,0,200,163,30,0,64,208,73,156,9,16,64,208,128,159,0,64,146,64,208,128,
158,0,192,159,0,64,208,128,163,0,64,162,64,208,137,158,5,12,0,136,152,4,
0,128,146,0,128,161,0,73,169,9,56,64,208,128,150,0,72,166,32,64,208,73,
157,13,20,64,208,64,152,64,208,128,162,0,64,148,64,208,128,158,0,64,173,
64,208,128,158,0,64,165,64,208,137,157,5,8,0,128,148,0,128,160,0,72,174,
12,64,208,64,152,64,208,128,157,0,192,173,0,64,208,137,158,5,12,0,64,150,
64,208,128,158,0,128,159,0,64,162,64,208,73,157,41,234,64,208,73,152,9,
28,64,208,128,152,0,73,147,13,16,64,208,64,163,64,208,128,163,0,128,146,
0,128,151,0,136,163,4,0,128,159,0,201,150,14,133,0,64,208,136,165,4,0,128,
161,0,73,147,29,100,64,208,137,159,5,16,0,136,154,4,0,64,147,64,208,128,
161,0,136,165,4,0,128,160,0,201,145,27,56,0,64,208,137,158,5,8,0,128,154,
0,192,173,0,64,208,64,173,64,208,128,159,0,64,144,64,208,201,156,10,22,
0,64,208,128,145,0,136,152,4,0,192,145,0,64,208,128,160,0,128,162,0,64,
146,64,208,72,160,8,64,208,128,154,0,128,159,0,72,149,12,64,208,64,149,
64,208,128,161,0,64,148,64,208,128,157,0,73,154,17,36,64,208,136,161,4,
0,64,152,64,208,128,161,0,72,152,12,64,208,136,161,4,0,128,158,0,64,151,
64,208,128,152,0,200,156,17,0,64,208,72,152,8,64,208,128,158,0,128,151,
0,64,155,64,208,128,151,0,201,164,10,163,0,64,208,128,145,0,201,161,30,
91,0,64,208,137,159,5,16,0,136,157,4,0,64,148,64,208,128,156,0,136,162,
4,0,128,160,0,201,159,18,38,0,64,208,72,162,8,64,208,128,148,0,128,158,
0,192,158,0,64,208,137,159,5,12,0,136,158,4,0,128,155,0,128,160,0,64,160,
64,208,137,151,5,16,0,72,149,8,64,208,128,151,0,128,148,0,128,154,0,200,
163,46,0,64,208,201,160,10,21,0,64,208,128,161,0,72,156,8,64,208,128,161,
0,128,151,0,72,162,16,64,208,64,148,64,208,64,152,64,208,128,161,0,128,
161,0,192,162,0,64,208,137,154,5,8,0,128,147,0,128,159,0,137,168,5,28,0,
72,166,8,64,208,128,144,0,64,165,64,208,136,162,4,0,64,154,64,208,128,152,
0,136,175,4,0,192,173,0,64,208,137,161,5,16,0,136,148,4,0,64,146,64,208,
128,161,0,200,173,25,0,64,208,73,161,9,12,64,208,128,161,0,128,159,0,64,
163,64,208,128,159,0,192,162,0,64,208,128,173,0,74,165,107,1,48,64,208,
201,158,10,49,0,64,208,128,160,0,137,151,5,28,0,137,147,5,16,0,64,145,64,
208,136,164,4,0,128,154,0,64,148,64,208,128,155,0,72,156,8,64,208,128,151,
0,128,155,0,73,162,17,44,64,208,136,162,4,0,64,160,64,208,128,158,0,73,
160,13,24,64,208,136,158,4,0,128,146,0,64,159,64,208,136,159,4,0,128,155,
0,128,161,0,136,165,4,0,128,164,0,192,164,0,64,208,201,158,10,99,0,64,208,
128,161,0,201,154,22,57,0,64,208,137,159,5,8,0,128,148,0,64,161,64,208,
128,144,0,73,148,9,20,64,208,128,158,0,136,147,4,0,64,144,64,208,128,160,
0,64,152,64,208,72,152,8,64,208,128,160,0,128,147,0,73,156,9,17,64,208,
128,154,0,192,155,0,64,208,128,147,0,64,157,64,208,137,161,5,8,0,128,144,
0,128,165,0,73,164,13,73,64,208,136,159,4,0,128,154,0,73,161,17,49,64,208,
136,161,4,0,64,146,64,208,128,152,0,200,160,21,0,64,208,73,161,9,12,64,
208,128,152,0,128,160,0,128,164,0,64,159,64,208,136,155,4,0,128,147,0,64,
162,64,208,136,161,4,0,128,152,0,201,173,10,13,0,64,208,128,154,0,128,166,
0,64,175,64,208,128,146,0,64,166,64,208,137,157,5,44,0,137,151,5,28,0,73,
145,17,20,64,208,72,156,8,64,208,128,148,0,128,154,0,128,144,0,128,150,
0,137,154,5,8,0,128,152,0,128,156,0,201,161,10,55,0,64,208,128,156,0,73,
159,21,29,64,208,137,158,5,12,0,136,152,4,0,128,148,0,128,159,0,192,158,
0,64,208,128,161,0,192,160,0,64,208,137,154,5,8,0,128,148,0,128,159,0,72,
164,12,64,208,64,154,64,208,128,158,0,192,162,0,64,208,137,152,5,8,0,128,
146,0,128,161,0,73,172,41,140,64,208,64,149,64,208,64,151,64,208,64,158,
64,208,64,173,64,208,64,164,64,208,64,164,64,208,64,149,64,208,64,154,64,
208,128,162,0,73,169,17,80,64,208,137,161,5,8,0,128,150,0,128,164,0,64,
168,64,208,73,158,9,36,64,208,128,159,0,73,154,9,20,64,208,128,164,0,72,
151,8,64,208,128,156,0,128,144,0,64,157,64,208,128,145,0,73,161,9,16,64,
208,128,157,0,64,159,64,208,128,161,0,64,162,64,208,128,161,0,64,171,64,
208,64,162,64,208,64,172,64,208,64,175,64,208,128,165,0,74,174,18,1,24,
64,208,137,152,5,8,0,128,148,0,128,154,0,64,173,64,208,73,159,9,127,64,
208,128,144,0,201,154,14,66,0,64,208,64,158,64,208,128,159,0,137,150,5,
37,0,200,148,9,0,64,208,128,147,0,64,146,64,208,137,156,5,12,0,136,154,
4,0,128,148,0,136,159,4,0,128,157,0,64,152,64,208,136,161,4,0,64,159,64,
208,128,154,0,73,157,13,49,64,208,136,159,4,0,128,148,0,72,156,29,64,208,
201,152,14,21,0,64,208,136,161,4,0,128,157,0,136,147,4,0,128,146,0,128,
154,0,64,155,64,208,128,156,0,128,158,0,201,164,10,76,0,64,208,128,154,
0,201,162,18,45,0,64,208,72,173,8,64,208,128,154,0,128,156,0,72,161,12,
64,208,64,152,64,208,128,158,0,64,160,64,208,136,162,4,0,64,159,64,208,
128,146,0,192,163,0,64,208,72,162,8,64,208,128,161,0,192,154,0,64,208,128,
161,0,73,173,21,48,64,208,73,161,9,12,64,208,128,165,0,128,159,0,128,162,
0,72,167,20,64,208,64,163,64,208,64,167,64,208,64,147,64,208,128,154,0,
64,165,64,208,128,156,0,64,174,64,208,128,154,0,64,175,64,208,201,148,10,
17,0,64,208,128,161,0,64,146,64,208,128,163,0,64,162,64,208,136,166,4,0,
64,147,64,208,64,164,64,208,128,144,0,64,72,64,208,64,164,64,208,128,144,
0,64,161,73,73,11,16,64,78,64,73,128,67,0,64,70,128,65,0,64,208,82,158,
6,178,41,183,64,208,74,157,46,3,60,64,208,137,158,5,28,0,73,152,13,20,64,
208,64,152,64,208,128,160,0,64,144,64,208,128,151,0,128,154,0,72,173,8,
64,208,128,154,0,128,162,0,138,150,6,2,17,0,82,146,1,3,1,94,64,208,73,156,
13,132,64,208,64,152,64,208,128,157,0,73,147,25,52,64,208,64,144,64,208,
64,146,64,208,64,144,64,208,64,157,64,208,128,172,0,72,145,12,64,208,64,
149,64,208,128,151,0,64,144,64,208,136,162,4,0,64,161,64,208,128,154,0,
72,154,28,64,208,64,158,64,208,64,156,64,208,64,164,64,208,64,155,64,208,
64,158,64,208,128,162,0,64,152,64,208,64,157,64,208,64,164,64,208,64,158,
64,208,64,160,64,208,64,156,64,208,64,145,64,208,64,174,64,208,64,160,64,
208,128,158,0,73,162,13,104,64,208,64,149,64,208,128,165,0,72,161,40,64,
208,72,159,16,64,208,64,158,64,208,64,160,64,208,128,162,0,64,152,64,208,
64,145,64,208,64,152,64,208,64,160,64,208,128,172,0,64,157,64,208,72,158,
8,64,208,128,162,0,64,144,64,208,64,160,64,208,73,158,9,20,64,208,128,148,
0,64,154,64,208,64,158,64,208,128,156,0,64,165,64,208,64,158,64,208,128,
151,0,136,167,4,0,64,164,64,208,64,149,64,208,128,148,0,73,144,47,55,64,
208,201,161,22,38,0,64,208,72,161,8,64,208,128,160,0,64,158,64,208,128,
152,0,72,159,8,64,208,128,161,0,192,147,0,64,208,128,161,0,128,163,0,192,
134,0,64,208,128,146,0,64,145,64,208,73,156,9,25,64,208,128,154,0,137,147,
5,13,0,192,146,0,64,208,128,158,0,128,150,0,136,164,4,0,128,160,0,73,148,
73,153,64,208,137,154,5,36,0,137,150,5,20,0,72,147,8,64,208,128,159,0,64,
144,64,208,128,166,0,64,152,64,208,136,162,4,0,128,145,0,137,161,5,24,0,
72,160,8,64,208,128,152,0,64,158,64,208,64,155,64,208,128,161,0,64,173,
64,208,128,154,0,64,147,64,208,73,157,9,61,64,208,128,152,0,73,152,9,40,
64,208,128,157,0,136,147,4,0,64,144,64,208,72,161,12,64,208,64,159,64,208,
128,152,0,64,148,64,208,64,155,64,208,128,161,0,192,156,0,64,208,136,152,
4,0,128,144,0,137,161,5,12,0,64,159,64,208,128,152,0,128,163,0,64,149,64,
208,137,152,5,13,0,192,146,0,64,208,128,161,0,128,154,0,73,154,88,160,64,
208,201,154,10,37,0,64,208,128,148,0,73,146,9,24,64,208,128,148,0,136,145,
4,0,64,144,64,208,136,159,4,0,128,155,0,128,151,0,73,160,9,34,64,208,128,
161,0,200,158,13,0,64,208,136,161,4,0,128,148,0,192,156,0,64,208,136,158,
4,0,128,145,0,64,163,64,208,64,147,64,208,128,152,0,201,152,50,61,0,64,
208,73,156,9,36,64,208,128,148,0,73,147,13,16,64,208,64,161,64,208,128,
152,0,128,145,0,64,154,64,208,136,159,4,0,128,156,0,136,163,4,0,128,157,
0,64,151,64,208,136,160,4,0,128,146,0,64,153,64,208,64,154,64,208,128,173,
0,200,156,74,0,64,208,73,155,9,32,64,208,128,152,0,73,152,9,20,64,208,128,
151,0,136,145,4,0,64,144,64,208,128,160,0,128,154,0,137,162,5,21,0,192,
158,0,64,208,136,160,4,0,64,154,64,208,128,161,0,64,173,64,208,136,161,
4,0,64,159,64,208,128,154,0,64,155,64,208,72,154,12,64,208,136,152,4,0,
128,148,0,128,146,0,74,164,38,1,199,64,208,73,159,13,28,64,208,64,156,64,
208,128,159,0,72,156,8,64,208,128,168,0,64,150,64,208,128,152,0,128,173,
0,74,161,46,1,64,64,208,73,159,13,24,64,208,136,160,4,0,128,159,0,72,157,
8,64,208,128,147,0,128,145,0,72,173,8,64,208,128,162,0,64,162,64,208,128,
148,0,73,159,123,206,64,208,73,154,13,48,64,208,64,162,64,208,128,145,0,
73,147,9,24,64,208,128,159,0,136,146,4,0,64,144,64,208,136,163,4,0,128,
162,0,72,152,8,64,208,128,147,0,128,150,0,73,160,29,45,64,208,72,175,8,
64,208,128,155,0,64,158,64,208,64,156,64,208,64,144,64,208,128,162,0,200,
159,13,0,64,208,136,160,4,0,128,150,0,128,158,0,136,162,4,0,192,161,0,64,
208,136,158,4,0,64,152,64,208,64,173,64,208,128,161,0,64,158,64,208,73,
159,9,52,64,208,128,160,0,73,157,9,28,64,208,128,148,0,72,152,8,64,208,
128,154,0,64,145,64,208,64,167,64,208,128,144,0,64,158,64,208,64,147,64,
208,64,159,64,208,128,163,0,137,163,5,12,0,64,161,64,208,128,148,0,64,164,
64,208,64,151,64,208,64,159,64,208,128,159,0,64,160,64,208,201,159,18,49,
0,64,208,64,161,64,208,64,152,64,208,128,151,0,137,145,5,12,0,64,144,64,
208,128,157,0,64,158,64,208,72,161,8,64,208,128,161,0,64,152,64,208,128,
161,0,72,173,8,64,208,128,154,0,64,161,64,208,128,173,0,72,163,49,64,208,
73,157,9,32,64,208,128,145,0,73,148,9,12,64,208,128,154,0,128,144,0,64,
152,64,208,64,152,64,208,128,154,0,200,173,9,0,64,208,128,155,0,128,158,
0,64,162,64,208,201,152,22,37,0,64,208,72,161,12,64,208,64,161,64,208,128,
158,0,128,157,0,136,150,4,0,64,147,64,208,64,152,64,208,128,161,0,136,161,
4,0,128,154,0,202,168,15,1,73,0,64,208,64,158,64,208,128,162,0,82,166,1,
36,1,51,64,208,73,156,9,124,64,208,128,159,0,73,148,9,48,64,208,128,163,
0,72,147,28,64,208,64,158,64,208,64,160,64,208,64,145,64,208,64,144,64,
208,64,157,64,208,128,154,0,64,144,64,208,64,147,64,208,128,160,0,72,152,
44,64,208,73,158,17,36,64,208,64,162,64,208,64,152,64,208,128,159,0,64,
157,64,208,64,162,64,208,64,149,64,208,64,160,64,208,128,157,0,128,161,
0,64,151,64,208,64,144,64,208,64,169,64,208,64,152,64,208,64,162,64,208,
128,144,0,201,160,62,105,0,64,208,72,149,24,64,208,64,144,64,208,64,155,
64,208,64,152,64,208,64,151,64,208,128,156,0,64,144,64,208,64,145,64,208,
64,158,64,208,64,162,64,208,64,157,64,208,64,152,64,208,64,154,64,208,128,
152,0,72,159,24,64,208,136,160,4,0,64,144,64,208,64,154,64,208,64,149,64,
208,128,162,0,64,158,64,208,64,145,64,208,64,160,64,208,64,144,64,208,128,
151,0,72,164,12,64,208,64,144,64,208,128,154,0,64,161,64,208,73,158,13,
24,64,208,64,159,64,208,128,160,0,64,149,64,208,64,162,64,208,128,152,0,
64,162,64,208,64,160,64,208,64,144,64,208,128,165,0,64,165,64,208,136,156,
4,0,64,144,64,208,128,148,0,64,167,64,208,128,159,0,200,174,49,0,64,208,
72,151,40,64,208,72,148,24,64,208,64,158,64,208,64,160,64,208,64,157,64,
208,64,152,64,208,128,152,0,64,147,64,208,64,144,64,208,128,151,0,128,145,
0,192,173,0,64,208,201,154,10,25,0,64,208,128,144,0,136,152,4,0,64,146,
64,208,64,163,64,208,128,161,0,136,161,4,0,64,157,64,208,64,154,64,208,
128,152,0,74,150,63,17,69,64,208,137,158,5,37,0,137,148,5,20,0,72,145,8,
64,208,128,151,0,64,144,64,208,128,162,0,136,156,4,0,192,154,0,64,208,128,
162,0,137,162,5,16,0,72,161,8,64,208,128,154,0,128,160,0,128,166,0,82,146,
3,86,10,14,64,208,74,157,22,2,73,64,208,137,163,5,12,0,136,160,4,0,128,
149,0,128,166,0,74,149,94,1,114,64,208,73,162,29,80,64,208,64,158,64,208,
64,154,64,208,64,158,64,208,64,160,64,208,64,158,64,208,128,145,0,72,160,
44,64,208,64,148,64,208,64,157,64,208,64,152,64,208,64,152,64,208,64,165,
64,208,64,152,64,208,64,156,64,208,64,156,64,208,64,144,64,208,128,168,
0,64,156,64,208,128,144,0,64,167,64,208,128,146,0,73,146,120,219,64,208,
201,159,26,103,0,64,208,72,162,12,64,208,64,144,64,208,128,163,0,64,161,
64,208,128,163,0,73,152,21,54,64,208,64,163,64,208,72,165,8,64,208,128,
151,0,128,161,0,64,144,64,208,73,154,9,16,64,208,128,163,0,64,152,64,208,
128,163,0,192,163,0,64,208,192,155,0,64,208,128,168,0,64,156,64,208,73,
152,9,16,64,208,128,163,0,64,134,64,208,128,163,0,128,163,0,137,162,5,8,
0,128,160,0,128,163,0,73,144,77,88,64,208,137,158,5,36,0,73,154,25,28,64,
208,136,163,4,0,64,145,64,208,64,144,64,208,64,157,64,208,128,154,0,128,
147,0,128,156,0,73,161,13,20,64,208,136,167,4,0,128,158,0,64,160,64,208,
128,151,0,64,162,64,208,64,163,64,208,64,161,64,208,128,161,0,64,134,64,
208,64,167,64,208,128,144,0,64,145,64,208,136,163,4,0,128,160,0,200,148,
46,0,64,208,73,156,9,24,64,208,128,144,0,72,151,8,64,208,128,154,0,64,147,
64,208,128,158,0,136,161,4,0,192,159,0,64,208,136,160,4,0,128,147,0,64,
147,64,208,136,163,4,0,128,154,0,201,154,39,144,0,64,208,201,157,14,21,
0,64,208,64,152,64,208,128,152,0,136,152,4,0,128,151,0,72,164,8,64,208,
128,158,0,128,158,0,201,151,18,25,0,64,208,64,160,64,208,64,152,64,208,
128,163,0,64,150,64,208,128,148,0,64,152,64,208,73,160,21,49,64,208,72,
165,12,64,208,64,145,64,208,128,151,0,128,146,0,73,146,9,21,64,208,128,
162,0,192,145,0,64,208,64,165,64,208,128,145,0,64,156,64,208,128,151,0,
73,162,9,20,64,208,128,155,0,64,161,64,208,64,160,64,208,128,146,0,64,167,
64,208,128,144,0,72,156,34,64,208,201,148,10,17,0,64,208,128,144,0,136,
145,4,0,128,134,0,200,159,9,0,64,208,128,173,0,128,152,0,64,155,64,208,
136,158,4,0,64,152,64,208,128,146,0,73,164,9,201,64,208,128,163,0,73,161,
21,131,64,208,137,156,5,12,0,64,152,64,208,128,163,0,128,162,0,201,159,
46,65,0,64,208,73,159,9,28,64,208,128,145,0,73,147,9,16,64,208,128,158,
0,136,146,4,0,128,145,0,128,152,0,137,167,5,8,0,128,163,0,128,168,0,64,
158,64,208,137,160,5,8,0,128,147,0,64,163,64,208,128,158,0,192,160,0,64,
208,201,162,10,33,0,64,208,128,159,0,137,154,5,16,0,64,147,64,208,64,152,
64,208,128,159,0,64,159,64,208,128,163,0,136,166,4,0,128,163,0,200,163,
37,0,64,208,137,154,5,20,0,72,145,12,64,208,64,152,64,208,128,162,0,128,
144,0,136,166,4,0,64,156,64,208,128,164,0,192,162,0,64,208,137,152,5,16,
0,72,147,8,64,208,128,163,0,128,144,0,128,173,0,201,167,18,29,0,64,208,
64,152,64,208,64,154,64,208,128,160,0,72,166,8,64,208,128,154,0,128,165,
0,72,175,8,64,208,128,159,0,64,173,64,208,137,161,5,16,0,72,154,8,64,208,
128,158,0,128,145,0,128,166,0,82,144,5,75,5,122,64,208,74,156,132,1,165,
64,208,73,149,14,102,64,208,192,154,0,64,208,128,158,0,72,147,81,64,208,
73,162,9,56,64,208,128,163,0,73,156,9,40,64,208,128,163,0,64,144,64,208,
73,161,17,24,64,208,137,152,5,8,0,128,144,0,128,163,0,64,159,64,208,128,
161,0,128,163,0,64,159,64,208,128,163,0,72,173,8,64,208,128,163,0,192,163,
0,64,208,64,159,64,208,128,161,0,64,145,64,208,128,158,0,72,155,12,64,208,
64,152,64,208,128,162,0,64,151,64,208,64,144,64,208,128,161,0,73,148,29,
128,64,208,137,159,5,12,0,136,154,4,0,128,145,0,72,173,8,64,208,128,148,
0,128,160,0,73,145,9,52,64,208,128,159,0,72,144,36,64,208,137,159,5,16,
0,137,151,5,8,0,128,148,0,128,155,0,137,162,5,12,0,64,160,64,208,128,161,
0,128,168,0,64,134,64,208,128,162,0,72,147,28,64,208,72,163,12,64,208,64,
162,64,208,128,155,0,64,156,64,208,136,163,4,0,128,154,0,64,146,64,208,
72,162,12,64,208,64,158,64,208,128,161,0,128,161,0,73,153,17,78,64,208,
64,155,64,208,64,152,64,208,128,148,0,72,152,34,64,208,201,159,14,21,0,
64,208,136,161,4,0,128,152,0,64,150,64,208,128,154,0,192,163,0,64,208,128,
151,0,64,151,64,208,72,161,8,64,208,128,162,0,64,160,64,208,64,152,64,208,
64,163,64,208,128,161,0,72,155,40,64,208,136,148,4,0,64,144,64,208,64,148,
64,208,72,152,8,64,208,128,157,0,64,148,64,208,64,152,64,208,64,157,64,
208,128,144,0,64,154,64,208,73,158,13,24,64,208,64,157,64,208,128,145,0,
72,152,8,64,208,128,151,0,128,151,0,72,169,8,64,208,128,156,0,64,162,64,
208,128,159,0,74,162,18,2,205,64,208,64,158,64,208,64,152,64,208,128,145,
0,74,159,43,2,41,64,208,201,160,14,29,0,64,208,64,162,64,208,128,159,0,
72,158,8,64,208,128,148,0,64,152,64,208,128,160,0,64,173,64,208,128,163,
0,200,158,78,0,64,208,137,157,5,41,0,201,151,10,17,0,64,208,128,162,0,136,
147,4,0,128,146,0,72,156,8,64,208,128,152,0,64,154,64,208,64,158,64,208,
128,156,0,73,163,9,24,64,208,128,152,0,72,161,12,64,208,136,157,4,0,128,
148,0,128,160,0,64,173,64,208,128,152,0,64,157,64,208,73,158,41,204,64,
208,136,159,4,0,64,145,64,208,64,160,64,208,64,144,64,208,64,145,64,208,
64,158,64,208,64,162,64,208,64,154,64,208,128,144,0,73,149,13,52,64,208,
64,154,64,208,128,158,0,72,145,12,64,208,64,144,64,208,128,162,0,64,144,
64,208,64,146,64,208,64,152,64,208,64,144,64,208,64,166,64,208,64,152,64,
208,128,175,0,72,154,100,64,208,73,159,37,56,64,208,64,149,64,208,64,162,
64,208,64,149,64,208,64,160,64,208,64,145,64,208,64,163,64,208,64,160,64,
208,128,147,0,64,157,64,208,64,152,64,208,64,150,64,208,64,154,64,208,128,
144,0,64,162,64,208,64,159,64,208,64,149,64,208,64,162,64,208,64,149,64,
208,64,160,64,208,64,145,64,208,64,163,64,208,64,160,64,208,128,147,0,64,
152,64,208,64,152,64,208,128,168,0,73,161,29,56,64,208,64,162,64,208,64,
144,64,208,64,157,64,208,64,166,64,208,64,152,64,208,128,175,0,72,160,8,
64,208,128,175,0,64,159,64,208,72,152,8,64,208,128,157,0,64,134,64,208,
128,157,0,72,173,121,64,208,64,159,64,208,136,156,4,0,64,152,64,208,192,
148,0,64,208,73,151,41,76,64,208,64,144,64,208,64,154,64,208,64,155,64,
208,64,174,64,208,64,167,64,208,64,149,64,208,64,157,64,208,64,152,64,208,
128,149,0,64,149,64,208,64,156,64,208,64,161,64,208,64,162,64,208,64,144,
64,208,64,157,64,208,64,166,64,208,64,152,64,208,128,175,0,64,157,64,208,
64,144,64,208,64,148,64,208,64,151,64,208,64,158,64,208,128,160,0,64,162,
64,208,72,149,32,64,208,64,165,64,208,64,160,64,208,64,144,64,208,64,145,
64,208,64,158,64,208,64,162,64,208,128,171,0,64,144,64,208,64,164,64,208,
128,149,0,72,161,36,64,208,73,159,9,16,64,208,128,159,0,136,157,4,0,128,
146,0,136,168,4,0,64,163,64,208,64,159,64,208,128,159,0,192,160,0,64,208,
137,158,5,88,0,137,148,5,56,0,64,144,64,208,72,157,36,64,208,64,161,64,
208,64,154,64,208,64,154,64,208,64,144,64,208,64,145,64,208,64,149,64,208,
64,155,64,208,128,172,0,64,146,64,208,64,152,64,208,128,144,0,64,157,64,
208,64,152,64,208,64,152,64,208,72,162,8,64,208,128,158,0,64,161,64,208,
128,147,0,200,167,9,0,64,208,128,156,0,192,159,0,64,208,128,159,0,73,165,
118,190,64,208,73,154,17,72,64,208,64,157,64,208,64,152,64,208,128,152,
0,73,150,9,32,64,208,128,148,0,72,147,8,64,208,128,163,0,64,145,64,208,
64,144,64,208,64,161,64,208,128,163,0,64,151,64,208,64,144,64,208,64,146,
64,208,64,158,64,208,64,148,64,208,128,144,0,73,157,17,24,64,208,64,152,
64,208,64,160,64,208,128,158,0,64,156,64,208,128,159,0,192,158,0,64,208,
64,163,64,208,64,157,64,208,128,145,0,72,164,16,64,208,136,163,4,0,64,145,
64,208,128,148,0,192,163,0,64,208,73,156,9,36,64,208,128,154,0,73,152,9,
16,64,208,128,160,0,64,146,64,208,128,151,0,64,154,64,208,136,163,4,0,128,
155,0,137,166,5,8,0,128,158,0,64,173,64,208,128,154,0,64,173,64,208,137,
159,5,12,0,136,154,4,0,128,149,0,128,161,0,64,134,64,208,73,159,21,36,64,
208,72,157,8,64,208,128,162,0,64,146,64,208,128,159,0,64,151,64,208,136,
158,4,0,64,151,64,208,128,161,0,64,162,64,208,128,161,0,192,145,0,64,208,
201,157,26,174,0,64,208,73,158,9,16,64,208,128,157,0,64,152,64,208,128,
154,0,128,162,0,201,149,43,104,0,64,208,200,160,29,0,64,208,64,154,64,208,
64,157,64,208,64,152,64,208,64,150,64,208,64,154,64,208,128,144,0,64,144,
64,208,128,160,0,73,146,13,41,64,208,136,160,4,0,128,152,0,200,145,9,0,
64,208,128,150,0,64,144,64,208,137,162,5,12,0,136,160,4,0,128,154,0,128,
173,0,72,148,8,64,208,128,148,0,192,147,0,64,208,136,173,4,0,128,156,0,
73,154,9,36,64,208,128,154,0,72,152,20,64,208,73,160,9,12,64,208,128,162,
0,128,154,0,128,161,0,64,150,64,208,128,158,0,192,156,0,64,208,128,154,
0,201,163,22,97,0,64,208,136,166,4,0,64,154,64,208,64,154,64,208,128,161,
0,137,160,5,56,0,72,159,28,64,208,73,159,9,16,64,208,128,158,0,136,158,
4,0,128,146,0,136,167,4,0,128,162,0,64,158,64,208,73,151,9,12,64,208,128,
157,0,128,147,0,64,157,64,208,128,160,0,72,162,8,64,208,128,159,0,64,161,
64,208,136,160,4,0,128,149,0,137,167,5,30,0,200,166,18,0,64,208,64,159,
64,208,192,160,0,64,208,128,161,0,64,165,64,208,128,156,0,64,173,64,208,
192,159,0,64,208,128,162,0,82,148,1,216,4,247,64,208,201,158,10,177,0,64,
208,128,163,0,73,151,13,86,64,208,136,154,4,0,128,152,0,73,146,25,41,64,
208,137,161,5,12,0,136,158,4,0,128,147,0,64,162,64,208,128,147,0,200,145,
9,0,64,208,128,158,0,64,144,64,208,128,162,0,200,150,9,0,64,208,128,154,
0,64,148,64,208,73,161,9,12,64,208,128,159,0,128,159,0,64,174,64,208,128,
162,0,201,155,26,53,0,64,208,137,154,5,12,0,136,150,4,0,128,144,0,136,161,
4,0,128,159,0,72,154,20,64,208,136,163,4,0,64,159,64,208,64,152,64,208,
128,155,0,64,152,64,208,128,159,0,72,157,16,64,208,137,160,5,8,0,128,159,
0,128,164,0,192,156,0,64,208,136,151,4,0,128,145,0,73,165,9,207,64,208,
128,155,0,201,161,58,175,0,64,208,137,162,5,24,0,137,157,5,8,0,128,156,
0,64,159,64,208,64,157,64,208,128,154,0,72,173,8,64,208,128,156,0,64,163,
64,208,72,161,8,64,208,128,173,0,64,144,64,208,128,162,0,72,160,44,64,208,
73,159,17,28,64,208,137,155,5,8,0,128,144,0,128,168,0,72,154,8,64,208,128,
156,0,128,148,0,64,161,64,208,136,163,4,0,128,154,0,64,159,64,208,137,158,
5,32,0,137,148,5,16,0,137,146,5,8,0,128,144,0,128,147,0,137,155,5,8,0,128,
154,0,128,156,0,137,164,5,26,0,201,162,10,13,0,64,208,128,173,0,128,160,
0,192,163,0,64,208,128,158,0,137,173,5,8,0,128,168,0,128,175,0,72,163,8,
64,208,128,147,0,64,162,64,208,137,163,5,8,0,128,161,0,128,168,0,73,174,
58,73,64,208,73,162,9,40,64,208,128,173,0,64,161,64,208,73,162,9,16,64,
208,128,168,0,64,161,64,208,128,168,0,64,168,64,208,64,158,64,208,128,160,
0,192,168,0,64,208,64,158,64,208,128,160,0,72,173,12,64,208,136,163,4,0,
128,154,0,128,169,0,64,175,64,208,128,146,0,64,147,64,208,74,160,14,1,219,
64,208,136,166,4,0,128,145,0,74,154,18,1,11,64,208,64,145,64,208,64,152,
64,208,128,152,0,73,148,17,174,64,208,137,158,5,8,0,128,146,0,128,161,0,
201,145,18,142,0,64,208,136,156,4,0,64,148,64,208,128,162,0,192,144,0,64,
208,201,159,10,63,0,64,208,128,161,0,73,152,13,41,64,208,64,156,64,208,
128,154,0,72,148,8,64,208,128,144,0,64,146,64,208,192,156,0,64,208,72,152,
8,64,208,128,145,0,128,145,0,64,154,64,208,192,152,0,64,208,128,152,0,201,
163,14,33,0,64,208,64,152,64,208,128,157,0,72,162,8,64,208,128,152,0,64,
161,64,208,136,163,4,0,128,144,0,64,164,64,208,64,154,64,208,64,161,64,
208,136,162,4,0,64,152,64,208,128,162,0,64,147,64,208,137,152,5,8,0,128,
144,0,128,163,0,72,152,52,64,208,137,163,5,32,0,137,158,5,8,0,128,152,0,
64,159,64,208,136,162,4,0,64,152,64,208,64,161,64,208,128,160,0,72,173,
8,64,208,128,163,0,64,164,64,208,128,154,0,64,151,64,208,73,162,9,12,64,
208,128,163,0,128,159,0,64,167,64,208,128,161,0,73,157,13,81,64,208,136,
173,4,0,128,152,0,72,156,45,64,208,73,157,9,24,64,208,128,158,0,73,145,
9,12,64,208,128,161,0,128,144,0,128,154,0,200,163,9,0,64,208,128,159,0,
64,162,64,208,128,163,0,64,155,64,208,137,152,5,12,0,64,146,64,208,128,
161,0,64,158,64,208,128,161,0,72,159,70,64,208,201,159,10,38,0,64,208,128,
154,0,137,152,5,12,0,136,148,4,0,128,144,0,200,158,9,0,64,208,128,148,0,
64,156,64,208,128,144,0,137,163,5,16,0,72,162,8,64,208,128,163,0,128,160,
0,72,173,8,64,208,128,154,0,128,167,0,64,158,64,208,73,157,9,20,64,208,
128,162,0,137,152,5,8,0,128,151,0,128,154,0,72,163,8,64,208,128,157,0,64,
158,64,208,136,152,4,0,128,150,0,74,166,26,1,1,64,208,72,161,12,64,208,
64,151,64,208,128,160,0,64,151,64,208,128,157,0,201,163,103,183,0,64,208,
201,159,10,41,0,64,208,128,161,0,73,152,9,16,64,208,128,157,0,64,146,64,
208,128,154,0,64,154,64,208,64,152,64,208,136,162,4,0,128,152,0,73,162,
29,40,64,208,72,152,20,64,208,137,152,5,8,0,128,148,0,64,154,64,208,128,
148,0,128,148,0,64,161,64,208,64,152,64,208,128,173,0,64,173,64,208,136,
164,4,0,64,152,64,208,128,164,0,72,162,32,64,208,73,159,9,20,64,208,128,
159,0,137,152,5,8,0,128,144,0,128,158,0,136,163,4,0,128,161,0,64,161,64,
208,137,163,5,29,0,137,147,5,8,0,128,145,0,192,157,0,64,208,136,173,4,0,
64,152,64,208,128,173,0,72,173,8,64,208,128,163,0,64,165,64,208,128,144,
0,72,165,29,64,208,137,156,5,12,0,136,154,4,0,128,144,0,136,162,4,0,192,
159,0,64,208,128,144,0,64,164,64,208,72,162,8,64,208,128,144,0,64,161,64,
208,128,162,0,73,173,33,52,64,208,73,154,9,20,64,208,128,156,0,137,148,
5,8,0,128,144,0,128,152,0,136,163,4,0,128,161,0,72,168,12,64,208,136,168,
4,0,128,161,0,64,167,64,208,128,154,0,136,175,4,0,64,174,64,208,128,154,
0,64,149,64,208,74,156,38,1,154,64,208,73,161,9,16,64,208,128,144,0,136,
160,4,0,128,159,0,64,162,64,208,72,173,8,64,208,128,154,0,128,158,0,138,
147,6,1,33,0,73,145,9,24,64,208,128,155,0,64,144,64,208,137,151,5,8,0,128,
147,0,128,159,0,64,146,64,208,73,156,49,188,64,208,64,158,64,208,64,160,
64,208,72,159,16,64,208,64,163,64,208,64,162,64,208,128,152,0,64,151,64,
208,64,144,64,208,64,146,64,208,64,158,64,208,128,148,0,73,151,69,112,64,
208,64,144,64,208,64,159,64,208,64,152,64,208,64,157,64,208,64,146,64,208,
64,149,64,208,64,161,64,208,64,162,64,208,64,159,64,208,64,160,64,208,64,
158,64,208,64,156,64,208,64,145,64,208,64,144,64,208,64,157,64,208,128,
154,0,72,148,24,64,208,64,158,64,208,64,160,64,208,64,156,64,208,64,144,
64,208,128,168,0,64,147,64,208,72,162,8,64,208,128,163,0,64,158,64,208,
128,154,0,64,154,64,208,64,144,64,208,64,146,64,208,64,147,64,208,64,162,
64,208,136,163,4,0,128,152,0,73,162,13,56,64,208,64,173,64,208,128,154,
0,64,157,64,208,72,162,8,64,208,128,163,0,64,152,64,208,64,152,64,208,73,
155,9,20,64,208,128,165,0,64,147,64,208,64,152,64,208,128,156,0,128,159,
0,64,173,64,208,64,154,64,208,128,158,0,73,154,29,44,64,208,72,161,20,64,
208,72,168,8,64,208,128,158,0,64,158,64,208,128,162,0,128,149,0,64,152,
64,208,64,146,64,208,136,154,4,0,128,146,0,64,155,64,208,137,166,5,12,0,
64,159,64,208,128,163,0,64,172,64,208,72,165,12,64,208,64,158,64,208,128,
151,0,64,159,64,208,128,158,0,73,162,25,76,64,208,136,159,4,0,64,144,64,
208,64,146,64,208,64,162,64,208,128,158,0,73,158,9,24,64,208,128,163,0,
64,157,64,208,136,166,4,0,64,154,64,208,128,156,0,64,159,64,208,137,160,
5,16,0,72,151,8,64,208,128,145,0,128,147,0,64,166,64,208,128,163,0,72,174,
12,64,208,64,145,64,208,128,155,0,64,165,64,208,136,160,4,0,128,145,0,74,
155,226,13,94,64,208,73,159,9,151,64,208,128,147,0,73,155,17,83,64,208,
136,160,4,0,64,152,64,208,128,158,0,201,148,19,55,0,64,208,136,161,4,0,
192,154,0,64,208,128,161,0,72,146,24,64,208,137,154,5,8,0,128,151,0,64,
156,64,208,64,145,64,208,128,151,0,192,144,0,64,208,136,163,4,0,128,160,
0,64,154,64,208,136,159,4,0,128,144,0,73,157,17,24,64,208,64,168,64,208,
64,158,64,208,128,162,0,64,156,64,208,128,160,0,64,158,64,208,73,160,9,
28,64,208,128,164,0,64,159,64,208,64,155,64,208,64,144,64,208,64,161,64,
208,128,162,0,128,166,0,73,166,9,37,64,208,128,160,0,73,162,9,21,64,208,
128,161,0,200,161,9,0,64,208,128,173,0,128,160,0,64,163,64,208,128,156,
0,73,168,17,28,64,208,72,154,8,64,208,128,155,0,128,152,0,64,167,64,208,
64,152,64,208,128,161,0,128,173,0,82,152,5,196,8,219,64,208,74,157,111,
4,70,64,208,137,161,5,36,0,73,159,9,28,64,208,128,161,0,64,154,64,208,64,
160,64,208,64,158,64,208,64,161,64,208,128,161,0,128,160,0,73,164,9,24,
64,208,128,158,0,64,162,64,208,72,173,8,64,208,128,154,0,128,151,0,192,
165,0,64,208,64,160,64,208,64,158,64,208,64,159,64,208,64,149,64,208,64,
160,64,208,64,149,64,208,64,146,64,208,64,158,64,208,64,148,64,208,128,
144,0,202,151,24,3,79,0,64,208,137,154,5,8,0,128,147,0,192,158,0,64,208,
128,148,0,74,146,34,2,208,64,208,72,161,20,64,208,64,173,64,208,136,159,
4,0,64,152,64,208,128,159,0,64,144,64,208,128,156,0,80,145,2,127,64,208,
138,159,6,1,114,0,73,152,57,228,64,208,73,157,17,36,64,208,64,162,64,208,
64,149,64,208,128,154,0,137,148,5,8,0,128,144,0,64,152,64,208,136,162,4,
0,128,161,0,73,162,9,12,64,208,128,144,0,128,159,0,128,163,0,73,147,85,
160,64,208,73,156,9,52,64,208,128,163,0,73,147,13,36,64,208,64,156,64,208,
128,144,0,64,144,64,208,137,163,5,12,0,64,162,64,208,128,152,0,64,164,64,
208,128,154,0,64,152,64,208,128,163,0,72,163,20,64,208,72,162,8,64,208,
128,152,0,64,159,64,208,128,161,0,64,162,64,208,128,163,0,72,146,20,64,
208,136,158,4,0,64,149,64,208,64,155,64,208,128,151,0,64,144,64,208,73,
148,9,48,64,208,128,152,0,72,147,8,64,208,128,161,0,64,146,64,208,64,152,
64,208,64,144,64,208,64,162,64,208,64,160,64,208,64,144,64,208,64,157,64,
208,128,161,0,128,155,0,64,150,64,208,64,152,64,208,128,156,0,73,155,13,
40,64,208,64,158,64,208,128,157,0,64,154,64,208,64,163,64,208,64,159,64,
208,64,145,64,208,64,144,64,208,64,157,64,208,128,154,0,64,157,64,208,72,
152,85,64,208,72,152,77,64,208,73,157,9,36,64,208,128,159,0,137,154,5,20,
0,72,147,12,64,208,64,152,64,208,128,156,0,128,144,0,64,155,64,208,128,
159,0,73,166,9,33,64,208,128,154,0,72,161,17,64,208,192,165,0,64,208,64,
158,64,208,128,151,0,64,160,64,208,128,161,0,128,173,0,128,144,0,64,144,
64,208,128,166,0,73,163,34,183,64,208,73,155,13,20,64,208,64,158,64,208,
128,157,0,64,152,64,208,128,159,0,192,159,0,64,208,128,154,0,201,161,58,
102,0,64,208,73,158,25,36,64,208,64,166,64,208,64,145,64,208,64,144,64,
208,64,157,64,208,128,154,0,64,149,64,208,64,162,64,208,128,152,0,64,162,
64,208,64,160,64,208,64,152,64,208,128,157,0,192,160,0,64,208,73,163,13,
36,64,208,64,156,64,208,128,166,0,136,154,4,0,64,149,64,208,64,146,64,208,
64,154,64,208,64,158,64,208,128,156,0,128,166,0,64,162,64,208,72,175,20,
64,208,64,150,64,208,64,156,64,208,64,144,64,208,128,168,0,64,149,64,208,
64,155,64,208,64,149,64,208,64,154,64,208,64,158,64,208,128,156,0,73,166,
26,37,64,208,64,149,64,208,192,156,0,64,208,64,149,64,208,64,157,64,208,
128,162,0,64,164,64,208,136,163,4,0,128,158,0,64,173,64,208,72,157,12,64,
208,64,162,64,208,128,166,0,64,154,64,208,64,158,64,208,64,166,64,208,64,
149,64,208,64,157,64,208,64,162,64,208,128,160,0,64,144,64,208,73,158,9,
24,64,208,128,148,0,137,151,5,12,0,136,145,4,0,128,144,0,128,154,0,137,
160,5,12,0,64,159,64,208,128,159,0,64,161,64,208,128,154,0,72,148,72,64,
208,73,157,9,48,64,208,128,160,0,137,148,5,20,0,64,144,64,208,64,157,64,
208,64,154,64,208,128,158,0,64,152,64,208,64,154,64,208,64,158,64,208,64,
156,64,208,128,161,0,73,159,13,16,64,208,64,145,64,208,128,149,0,128,158,
0,128,161,0,64,147,64,208,73,159,9,12,64,208,128,160,0,128,145,0,64,173,
64,208,64,154,64,208,64,152,64,208,128,144,0,73,155,21,65,64,208,136,159,
4,0,64,156,64,208,64,144,64,208,128,168,0,72,154,29,64,208,201,157,10,21,
0,64,208,128,159,0,72,152,8,64,208,128,161,0,128,151,0,128,166,0,64,152,
64,208,136,175,4,0,64,162,64,208,128,158,0,64,156,64,208,73,158,17,44,64,
208,136,160,4,0,64,152,64,208,128,160,0,73,147,13,24,64,208,64,163,64,208,
128,159,0,64,145,64,208,64,152,64,208,128,159,0,128,157,0,137,166,5,16,
0,64,161,64,208,136,165,4,0,128,160,0,64,173,64,208,128,145,0,73,163,25,
240,64,208,137,158,5,16,0,72,152,8,64,208,128,159,0,128,145,0,128,160,0,
73,160,21,115,64,208,137,156,5,8,0,128,154,0,64,159,64,208,128,159,0,200,
159,29,0,64,208,72,173,16,64,208,136,163,4,0,64,152,64,208,128,163,0,64,
157,64,208,128,151,0,64,158,64,208,73,159,9,50,64,208,128,160,0,73,151,
26,29,64,208,200,161,17,0,64,208,136,157,4,0,64,152,64,208,128,157,0,128,
148,0,128,150,0,64,156,64,208,192,159,0,64,208,128,156,0,136,164,4,0,64,
162,64,208,128,158,0,200,162,37,0,64,208,137,160,5,24,0,72,158,8,64,208,
128,157,0,64,154,64,208,64,158,64,208,128,156,0,64,173,64,208,128,154,0,
64,161,64,208,73,162,13,44,64,208,64,173,64,208,128,154,0,137,157,5,24,
0,64,144,64,208,64,148,64,208,64,156,64,208,64,152,64,208,128,157,0,64,
158,64,208,128,159,0,72,165,12,64,208,64,152,64,208,128,156,0,128,163,0,
73,173,55,107,64,208,201,154,18,46,0,64,208,64,152,64,208,64,148,64,208,
128,144,0,72,152,16,64,208,136,162,4,0,64,152,64,208,128,162,0,192,151,
0,64,208,64,152,64,208,128,161,0,128,163,0,136,166,4,0,192,164,0,64,208,
137,154,5,32,0,137,151,5,12,0,64,145,64,208,128,148,0,64,152,64,208,64,
145,64,208,136,160,4,0,128,148,0,137,162,5,8,0,128,159,0,128,163,0,64,175,
64,208,137,159,5,8,0,128,146,0,64,173,64,208,136,159,4,0,64,152,64,208,
128,159,0,64,151,64,208,74,158,43,1,130,64,208,137,161,5,20,0,137,158,5,
12,0,64,156,64,208,128,166,0,128,159,0,72,163,8,64,208,128,158,0,192,162,
0,64,208,128,154,0,201,151,14,175,0,64,208,64,159,64,208,128,152,0,73,147,
46,134,64,208,137,156,5,20,0,72,151,12,64,208,64,162,64,208,128,163,0,128,
146,0,200,162,13,0,64,208,136,163,4,0,128,152,0,64,161,64,208,128,158,0,
73,145,17,61,64,208,72,154,8,64,208,128,152,0,128,144,0,64,144,64,208,137,
159,5,24,0,73,156,9,16,64,208,128,159,0,64,147,64,208,128,161,0,128,158,
0,200,162,13,0,64,208,136,159,4,0,128,154,0,128,161,0,64,146,64,208,137,
160,5,16,0,72,148,8,64,208,128,156,0,128,144,0,64,162,64,208,128,162,0,
72,150,8,64,208,128,160,0,64,148,64,208,72,161,12,64,208,64,160,64,208,
128,160,0,128,158,0,73,155,21,102,64,208,73,145,9,12,64,208,128,155,0,128,
144,0,128,154,0,72,154,28,64,208,73,161,9,16,64,208,128,154,0,136,158,4,
0,128,154,0,64,162,64,208,128,152,0,192,152,0,64,208,73,161,9,41,64,208,
128,154,0,72,160,24,64,208,72,152,12,64,208,64,144,64,208,128,163,0,64,
144,64,208,128,163,0,192,159,0,64,208,128,154,0,64,162,64,208,128,166,0,
72,157,25,64,208,137,154,5,12,0,136,148,4,0,128,147,0,192,159,0,64,208,
128,159,0,192,156,0,64,208,201,159,10,21,0,64,208,128,154,0,137,152,5,8,
0,128,147,0,128,157,0,137,161,5,8,0,128,160,0,64,162,64,208,128,163,0,74,
164,14,1,48,64,208,136,158,4,0,128,154,0,73,161,37,169,64,208,137,158,5,
20,0,137,152,5,12,0,136,148,4,0,128,144,0,128,154,0,137,162,5,8,0,128,161,
0,128,163,0,200,160,79,0,64,208,137,158,5,36,0,73,147,9,28,64,208,128,166,
0,72,146,8,64,208,128,162,0,64,144,64,208,64,161,64,208,128,158,0,128,152,
0,73,162,9,25,64,208,128,155,0,192,159,0,64,208,136,163,4,0,64,161,64,208,
128,158,0,192,166,0,64,208,64,144,64,208,128,152,0,64,159,64,208,201,158,
10,21,0,64,208,128,156,0,137,152,5,8,0,128,144,0,128,157,0,73,160,9,21,
64,208,128,154,0,192,159,0,64,208,136,154,4,0,128,152,0,64,173,64,208,128,
154,0,200,163,29,0,64,208,73,146,13,20,64,208,64,148,64,208,128,162,0,64,
144,64,208,128,159,0,128,154,0,192,162,0,64,208,137,158,5,64,0,73,149,25,
40,64,208,64,155,64,208,64,149,64,208,64,154,64,208,64,158,64,208,128,156,
0,73,147,9,12,64,208,128,163,0,128,144,0,128,148,0,72,155,8,64,208,128,
161,0,64,152,64,208,64,159,64,208,128,145,0,137,162,5,12,0,136,161,4,0,
128,159,0,72,173,8,64,208,128,166,0,128,163,0,201,167,14,54,0,64,208,64,
151,64,208,128,163,0,72,166,24,64,208,73,152,9,16,64,208,128,162,0,64,146,
64,208,128,152,0,128,173,0,192,165,0,64,208,72,157,8,64,208,128,158,0,128,
154,0,72,173,36,64,208,73,159,9,20,64,208,128,166,0,72,156,8,64,208,128,
158,0,128,154,0,72,163,8,64,208,128,154,0,128,160,0,64,168,64,208,128,160,
0,192,154,0,64,208,202,159,72,2,124,0,64,208,73,159,13,49,64,208,64,157,
64,208,128,148,0,201,154,18,33,0,64,208,136,156,4,0,64,145,64,208,128,158,
0,136,146,4,0,64,145,64,208,136,160,4,0,128,156,0,128,158,0,137,162,5,12,
0,64,160,64,208,128,164,0,128,163,0,74,151,42,1,50,64,208,137,156,5,12,
0,136,152,4,0,128,148,0,72,161,8,64,208,128,154,0,64,157,64,208,64,152,
64,208,64,146,64,208,128,152,0,73,147,46,215,64,208,137,163,5,33,0,73,156,
9,17,64,208,128,152,0,192,152,0,64,208,128,152,0,64,162,64,208,136,163,
4,0,128,152,0,136,173,4,0,128,168,0,73,145,50,106,64,208,73,159,9,28,64,
208,128,147,0,137,154,5,16,0,72,152,8,64,208,128,156,0,128,148,0,128,156,
0,201,161,10,13,0,64,208,128,156,0,128,160,0,128,162,0,192,144,0,64,208,
73,160,9,36,64,208,128,145,0,73,148,13,20,64,208,136,158,4,0,128,155,0,
64,147,64,208,128,161,0,64,159,64,208,128,158,0,72,173,8,64,208,128,161,
0,64,162,64,208,128,162,0,192,146,0,64,208,201,159,14,34,0,64,208,136,162,
4,0,128,159,0,73,154,9,17,64,208,128,152,0,192,146,0,64,208,128,159,0,128,
158,0,137,163,5,21,0,192,160,0,64,208,72,152,8,64,208,128,151,0,128,151,
0,128,166,0,72,150,8,64,208,128,148,0,192,148,0,64,208,137,156,5,29,0,201,
146,18,21,0,64,208,136,159,4,0,64,158,64,208,128,161,0,128,144,0,128,154,
0,136,168,4,0,128,163,0,201,156,55,165,0,64,208,137,159,5,29,0,201,152,
10,21,0,64,208,128,152,0,64,148,64,208,136,157,4,0,128,148,0,128,158,0,
73,162,9,16,64,208,128,160,0,64,160,64,208,128,164,0,128,174,0,201,154,
51,99,0,64,208,137,159,5,29,0,73,157,9,17,64,208,128,148,0,192,148,0,64,
208,128,166,0,64,158,64,208,128,148,0,137,162,5,8,0,128,160,0,64,163,64,
208,128,159,0,192,152,0,64,208,73,145,17,28,64,208,64,152,64,208,64,152,
64,208,128,162,0,64,144,64,208,64,159,64,208,128,159,0,64,158,64,208,64,
146,64,208,136,160,4,0,128,158,0,64,155,64,208,64,152,64,208,128,154,0,
72,158,33,64,208,73,157,9,20,64,208,128,154,0,64,146,64,208,136,161,4,0,
128,148,0,192,168,0,64,208,128,152,0,64,157,64,208,73,152,33,40,64,208,
64,152,64,208,73,161,17,20,64,208,64,161,64,208,64,152,64,208,128,161,0,
128,150,0,128,164,0,136,148,4,0,128,145,0,200,166,13,0,64,208,64,146,64,
208,128,168,0,128,164,0,201,166,14,214,0,64,208,64,152,64,208,128,162,0,
73,163,25,156,64,208,73,159,9,16,64,208,128,151,0,136,151,4,0,128,148,0,
128,164,0,201,161,68,99,0,64,208,137,158,5,33,0,73,152,9,20,64,208,128,
162,0,136,151,4,0,64,146,64,208,128,163,0,192,156,0,64,208,128,160,0,137,
162,5,17,0,192,161,0,64,208,64,144,64,208,128,144,0,64,173,64,208,64,152,
64,208,128,159,0,64,160,64,208,73,159,9,20,64,208,128,163,0,72,157,8,64,
208,128,161,0,128,154,0,136,163,4,0,128,162,0,64,162,64,208,137,163,5,21,
0,136,146,4,0,192,145,0,64,208,136,173,4,0,128,160,0,136,173,4,0,128,166,
0,72,165,8,64,208,128,160,0,64,164,64,208,201,158,14,25,0,64,208,64,156,
64,208,128,161,0,137,152,5,8,0,128,145,0,128,156,0,136,163,4,0,128,162,
0,73,173,22,58,64,208,201,160,10,13,0,64,208,128,154,0,128,154,0,128,161,
0,72,168,28,64,208,137,161,5,16,0,136,152,4,0,64,146,64,208,128,152,0,136,
163,4,0,128,162,0,192,167,0,64,208,128,164,0,72,175,8,64,208,128,156,0,
192,174,0,64,208,128,145,0,208,157,1,236,0,64,208,74,157,10,1,11,64,208,
128,161,0,73,149,9,108,64,208,128,163,0,201,146,22,63,0,64,208,137,162,
5,12,0,136,159,4,0,128,147,0,128,164,0,200,145,26,0,64,208,201,158,10,17,
0,64,208,128,163,0,136,145,4,0,128,144,0,128,161,0,64,144,64,208,136,163,
4,0,64,146,64,208,128,160,0,72,148,28,64,208,73,156,9,16,64,208,128,161,
0,64,154,64,208,128,158,0,64,162,64,208,128,158,0,192,147,0,64,208,128,
154,0,201,154,22,126,0,64,208,137,156,5,12,0,136,154,4,0,128,146,0,128,
166,0,72,152,97,64,208,137,158,5,81,0,73,154,17,68,64,208,64,152,64,208,
64,158,64,208,128,164,0,72,152,44,64,208,73,158,9,20,64,208,128,161,0,136,
156,4,0,64,155,64,208,128,159,0,72,166,12,64,208,64,156,64,208,128,162,
0,64,161,64,208,128,165,0,64,147,64,208,128,173,0,192,155,0,64,208,128,
161,0,137,161,5,8,0,128,159,0,128,162,0,64,150,64,208,128,163,0,72,156,
8,64,208,128,159,0,64,155,64,208,136,154,4,0,64,144,64,208,128,148,0,73,
163,33,182,64,208,73,159,9,12,64,208,128,159,0,128,156,0,64,175,64,208,
64,173,64,208,64,152,64,208,128,159,0,201,160,26,82,0,64,208,137,156,5,
12,0,136,154,4,0,128,152,0,64,159,64,208,128,156,0,72,159,28,64,208,137,
158,5,16,0,72,155,8,64,208,128,158,0,128,152,0,136,167,4,0,128,163,0,192,
158,0,64,208,137,148,5,8,0,128,144,0,64,151,64,208,64,159,64,208,64,159,
64,208,128,152,0,200,162,33,0,64,208,137,154,5,20,0,137,146,5,8,0,128,145,
0,64,148,64,208,128,158,0,136,163,4,0,128,158,0,192,161,0,64,208,137,151,
5,26,0,200,148,13,0,64,208,64,161,64,208,128,162,0,192,144,0,64,208,128,
148,0,128,160,0,137,167,5,25,0,200,165,9,0,64,208,128,151,0,64,164,64,208,
64,159,64,208,128,158,0,64,173,64,208,136,163,4,0,128,146,0,64,156,80,208,
2,111,74,157,38,1,79,64,208,73,159,9,24,64,208,128,158,0,72,156,8,64,208,
128,158,0,64,144,64,208,128,159,0,64,161,64,208,128,160,0,73,150,9,136,
64,208,128,155,0,73,146,17,92,64,208,137,148,5,8,0,128,145,0,128,173,0,
136,145,4,0,64,144,64,208,137,158,5,40,0,137,151,5,24,0,136,148,4,0,64,
147,64,208,64,152,64,208,64,160,64,208,128,161,0,72,156,8,64,208,128,158,
0,128,155,0,137,161,5,20,0,72,160,12,64,208,64,162,64,208,128,161,0,128,
159,0,64,163,64,208,128,161,0,72,148,12,64,208,136,153,4,0,128,144,0,64,
147,64,208,137,161,5,12,0,136,159,4,0,128,154,0,64,162,64,208,128,161,0,
201,154,34,116,0,64,208,73,152,9,16,64,208,128,163,0,136,148,4,0,128,145,
0,136,161,4,0,64,160,64,208,128,166,0,200,152,71,0,64,208,137,155,5,41,
0,73,151,9,21,64,208,128,158,0,136,148,4,0,192,145,0,64,208,128,161,0,136,
154,4,0,64,152,64,208,136,160,4,0,128,156,0,137,161,5,21,0,200,159,9,0,
64,208,128,155,0,64,157,64,208,128,167,0,128,163,0,64,151,64,208,136,165,
4,0,128,152,0,200,156,33,0,64,208,73,157,9,24,64,208,128,158,0,72,155,8,
64,208,128,166,0,64,152,64,208,128,155,0,128,161,0,192,155,0,64,208,64,
158,64,208,128,159,0,73,163,29,219,64,208,137,159,5,16,0,136,157,4,0,64,
152,64,208,128,161,0,64,173,64,208,128,154,0,201,160,39,119,0,64,208,201,
158,14,25,0,64,208,64,157,64,208,128,159,0,136,154,4,0,64,144,64,208,128,
159,0,136,163,4,0,128,159,0,72,159,36,64,208,137,159,5,24,0,137,154,5,16,
0,64,145,64,208,64,158,64,208,128,162,0,128,155,0,136,166,4,0,128,161,0,
192,158,0,64,208,73,156,17,32,64,208,72,159,8,64,208,128,154,0,128,157,
0,72,155,12,64,208,64,147,64,208,128,163,0,128,145,0,64,158,64,208,128,
161,0,72,162,28,64,208,137,161,5,16,0,136,154,4,0,64,149,64,208,128,155,
0,136,164,4,0,128,163,0,64,161,64,208,137,160,5,24,0,73,158,13,16,64,208,
64,144,64,208,128,163,0,128,144,0,128,159,0,73,164,9,12,64,208,128,158,
0,128,161,0,128,167,0,73,167,9,37,64,208,128,156,0,200,166,13,0,64,208,
64,160,64,208,128,152,0,64,165,64,208,136,154,4,0,64,148,64,208,128,159,
0,136,175,4,0,192,173,0,64,208,137,159,5,12,0,136,151,4,0,128,146,0,136,
163,4,0,128,160,0,64,89,128,66,0,210,166,1,65,20,21,0,64,208,73,157,9,152,
64,208,128,154,0,73,149,9,69,64,208,128,165,0,73,147,17,49,64,208,137,146,
5,8,0,128,134,0,128,161,0,72,146,20,64,208,137,156,5,12,0,136,149,4,0,128,
148,0,128,161,0,192,145,0,64,208,136,154,4,0,128,151,0,64,148,64,208,64,
157,64,208,128,152,0,73,154,34,62,64,208,137,154,5,21,0,200,152,9,0,64,
208,128,152,0,64,144,64,208,128,148,0,136,163,4,0,128,159,0,200,152,21,
0,64,208,136,162,4,0,64,160,64,208,64,154,64,208,128,161,0,64,151,64,208,
128,152,0,192,156,0,64,208,136,162,4,0,128,159,0,201,162,10,125,0,64,208,
128,161,0,73,160,13,76,64,208,136,159,4,0,128,156,0,72,159,56,64,208,73,
155,9,32,64,208,128,145,0,137,152,5,12,0,136,147,4,0,128,146,0,64,154,64,
208,64,162,64,208,128,145,0,73,160,9,16,64,208,128,161,0,64,158,64,208,
128,152,0,128,161,0,64,158,64,208,128,164,0,64,161,64,208,137,156,5,12,
0,136,155,4,0,128,154,0,72,162,16,64,208,136,152,4,0,64,148,64,208,128,
154,0,64,159,64,208,128,161,0,137,167,5,12,0,64,164,64,208,128,145,0,64,
173,64,208,137,154,5,12,0,64,144,64,208,128,163,0,64,156,64,208,128,159,
0,82,162,3,147,14,15,64,208,74,158,102,1,244,64,208,73,161,17,40,64,208,
137,156,5,8,0,128,152,0,128,157,0,73,152,9,16,64,208,128,160,0,136,148,
4,0,128,144,0,64,157,64,208,128,165,0,73,163,37,48,64,208,64,157,64,208,
64,162,64,208,64,149,64,208,64,160,64,208,64,144,64,208,64,159,64,208,64,
152,64,208,128,175,0,64,162,64,208,64,152,64,208,128,164,0,64,173,64,208,
128,152,0,138,151,6,1,66,0,74,147,42,1,49,64,208,137,157,5,20,0,72,156,
8,64,208,128,144,0,64,144,64,208,128,163,0,72,165,12,64,208,64,161,64,208,
128,162,0,128,159,0,72,145,8,64,208,128,160,0,64,144,64,208,73,157,33,128,
64,208,64,154,64,208,64,158,64,208,64,151,64,208,64,144,64,208,64,146,64,
208,64,158,64,208,128,148,0,73,147,17,80,64,208,64,148,64,208,64,158,64,
208,128,154,0,72,146,28,64,208,64,157,64,208,64,152,64,208,64,152,64,208,
64,147,64,208,64,152,64,208,128,156,0,64,145,64,208,73,164,17,24,64,208,
64,158,64,208,64,157,64,208,128,148,0,64,163,64,208,128,161,0,64,173,64,
208,128,154,0,64,155,64,208,64,148,64,208,64,158,64,208,128,156,0,73,162,
85,92,64,208,72,163,40,64,208,64,159,64,208,64,160,64,208,64,144,64,208,
64,146,64,208,64,155,64,208,64,149,64,208,64,157,64,208,64,152,64,208,128,
149,0,64,158,64,208,64,162,64,208,64,167,64,208,64,149,64,208,64,162,64,
208,64,157,64,208,64,158,64,208,64,161,64,208,64,162,64,208,128,172,0,64,
159,64,208,128,173,0,64,164,64,208,64,164,64,208,64,162,64,208,64,149,64,
208,64,160,64,208,64,172,64,208,64,149,64,208,128,160,0,72,150,8,64,208,
128,162,0,128,148,0,201,156,30,73,0,64,208,137,155,5,20,0,64,152,64,208,
136,161,4,0,64,152,64,208,128,162,0,128,158,0,72,155,12,64,208,136,159,
4,0,128,154,0,64,152,64,208,72,159,16,64,208,136,145,4,0,64,144,64,208,
128,173,0,64,156,64,208,64,156,64,208,128,159,0,128,157,0,202,163,172,1,
96,0,64,208,200,173,9,0,64,208,128,154,0,64,148,64,208,73,158,21,84,64,
208,64,162,64,208,64,160,64,208,64,175,64,208,128,148,0,73,147,29,48,64,
208,64,158,64,208,64,160,64,208,64,158,64,208,64,148,64,208,64,158,64,208,
128,154,0,64,146,64,208,64,149,64,208,64,161,64,208,64,157,64,208,128,144,
0,64,154,64,208,64,155,64,208,64,163,64,208,128,145,0,72,161,28,64,208,
64,158,64,208,72,174,8,64,208,128,151,0,64,146,64,208,64,149,64,208,128,
162,0,64,160,64,208,64,149,64,208,64,161,64,208,64,159,64,208,64,163,64,
208,64,145,64,208,64,155,64,208,64,152,64,208,64,154,64,208,128,144,0,73,
161,33,168,64,208,73,162,9,16,64,208,128,161,0,136,154,4,0,128,150,0,72,
165,8,64,208,128,154,0,128,163,0,72,160,108,64,208,73,158,45,96,64,208,
64,152,64,208,64,156,64,208,64,144,64,208,64,162,64,208,64,149,64,208,64,
160,64,208,64,152,64,208,64,144,64,208,64,155,64,208,128,171,0,136,154,
4,0,64,152,64,208,72,159,32,64,208,64,155,64,208,64,144,64,208,64,161,64,
208,64,162,64,208,64,152,64,208,64,154,64,208,128,144,0,64,156,64,208,64,
162,64,208,128,146,0,136,165,4,0,128,159,0,64,159,64,208,73,159,13,20,64,
208,64,159,64,208,128,154,0,136,150,4,0,128,147,0,128,162,0,192,162,0,64,
208,136,159,4,0,128,154,0,201,173,40,52,0,64,208,73,155,9,16,64,208,128,
155,0,136,148,4,0,128,146,0,136,162,4,0,192,156,0,64,208,192,152,0,64,208,
128,161,0,136,168,4,0,192,164,0,64,208,128,154,0,128,174,0,82,160,1,252,
7,227,64,208,201,158,34,242,0,64,208,73,158,13,24,64,208,136,160,4,0,128,
152,0,136,147,4,0,64,144,64,208,128,163,0,128,159,0,201,151,23,142,0,64,
208,72,154,8,64,208,128,154,0,192,144,0,64,208,128,152,0,73,148,25,88,64,
208,73,150,9,16,64,208,128,146,0,64,146,64,208,128,168,0,128,161,0,73,146,
17,28,64,208,137,160,5,8,0,128,154,0,128,161,0,64,145,64,208,136,161,4,
0,128,148,0,64,147,64,208,137,156,5,16,0,72,146,8,64,208,128,163,0,128,
145,0,72,162,12,64,208,64,160,64,208,128,154,0,128,161,0,72,150,12,64,208,
136,155,4,0,128,147,0,64,149,64,208,64,148,64,208,64,156,64,208,64,144,
64,208,128,168,0,201,155,10,34,0,64,208,128,175,0,200,154,17,0,64,208,72,
158,8,64,208,128,156,0,128,151,0,64,152,64,208,128,148,0,200,157,17,0,64,
208,137,154,5,8,0,128,147,0,128,161,0,64,156,64,208,136,163,4,0,64,144,
64,208,128,162,0,73,164,17,168,64,208,137,158,5,8,0,128,148,0,128,159,0,
201,161,22,111,0,64,208,137,160,5,12,0,136,159,4,0,128,158,0,128,162,0,
72,160,49,64,208,201,162,10,33,0,64,208,128,158,0,137,150,5,16,0,64,148,
64,208,64,160,64,208,128,148,0,64,159,64,208,128,150,0,136,173,4,0,64,168,
64,208,128,157,0,192,159,0,64,208,73,159,9,20,64,208,128,151,0,136,156,
4,0,64,145,64,208,128,151,0,72,163,8,64,208,128,160,0,64,161,64,208,128,
158,0,72,163,12,64,208,136,159,4,0,128,157,0,64,162,64,208,137,161,5,12,
0,136,158,4,0,128,156,0,136,163,4,0,192,162,0,64,208,128,166,0,201,168,
10,67,0,64,208,128,145,0,200,166,49,0,64,208,73,158,13,24,64,208,64,154,
64,208,128,158,0,136,157,4,0,64,148,64,208,128,157,0,72,166,8,64,208,128,
161,0,64,161,64,208,64,162,64,208,128,146,0,192,165,0,64,208,128,161,0,
136,174,4,0,64,173,64,208,64,146,64,208,64,161,64,208,64,152,64,208,128,
162,0,192,159,0,64,208,74,157,55,3,51,64,208,201,160,10,33,0,64,208,128,
146,0,137,152,5,16,0,136,148,4,0,64,147,64,208,128,158,0,64,158,64,208,
128,160,0,137,168,5,8,0,128,163,0,64,173,64,208,128,166,0,202,150,19,1,
230,0,64,208,137,148,5,8,0,128,144,0,128,163,0,202,147,162,1,86,0,64,208,
73,156,9,61,64,208,128,163,0,137,152,5,41,0,200,147,13,0,64,208,136,161,
4,0,128,152,0,64,144,64,208,73,162,9,16,64,208,128,152,0,64,146,64,208,
128,156,0,128,163,0,72,155,8,64,208,128,159,0,128,154,0,73,163,54,66,64,
208,73,161,9,25,64,208,128,173,0,200,159,9,0,64,208,128,161,0,64,146,64,
208,128,154,0,72,173,16,64,208,136,164,4,0,64,152,64,208,128,164,0,64,162,
64,208,128,148,0,200,162,9,0,64,208,128,163,0,128,161,0,72,173,16,64,208,
72,162,8,64,208,128,163,0,128,161,0,64,165,64,208,64,159,64,208,128,144,
0,73,145,41,133,64,208,137,159,5,20,0,73,147,9,12,64,208,128,159,0,128,
146,0,128,157,0,137,162,5,12,0,64,160,64,208,128,160,0,128,167,0,64,144,
64,208,73,160,9,33,64,208,128,154,0,137,158,5,16,0,72,156,8,64,208,128,
164,0,128,146,0,192,159,0,64,208,128,159,0,73,162,9,44,64,208,128,154,0,
64,161,64,208,137,154,5,24,0,64,150,64,208,64,152,64,208,64,155,64,208,
64,149,64,208,128,162,0,64,158,64,208,128,159,0,64,163,64,208,64,152,64,
208,128,173,0,64,146,64,208,137,154,5,28,0,73,146,17,20,64,208,64,152,64,
208,64,163,64,208,128,161,0,128,145,0,128,147,0,72,160,8,64,208,128,148,
0,64,156,64,208,128,152,0,72,149,52,64,208,64,166,64,208,64,148,64,208,
64,149,64,208,64,159,64,208,64,158,64,208,64,151,64,208,64,152,64,208,64,
162,64,208,64,144,64,208,64,160,64,208,64,152,64,208,128,153,0,64,148,64,
208,73,158,9,32,64,208,128,159,0,73,154,9,16,64,208,128,162,0,136,147,4,
0,128,144,0,64,157,64,208,128,156,0,201,163,10,30,0,64,208,128,155,0,200,
161,13,0,64,208,64,158,64,208,128,147,0,64,159,64,208,128,158,0,64,164,
64,208,128,155,0,73,154,67,207,64,208,201,160,10,42,0,64,208,128,159,0,
137,154,5,24,0,72,152,8,64,208,128,160,0,64,146,64,208,64,162,64,208,128,
154,0,192,159,0,64,208,128,161,0,73,162,9,16,64,208,128,145,0,64,161,64,
208,128,159,0,128,175,0,72,152,116,64,208,73,155,9,60,64,208,128,161,0,
137,148,5,12,0,136,147,4,0,128,144,0,72,154,24,64,208,137,160,5,16,0,64,
152,64,208,136,162,4,0,128,159,0,128,162,0,64,152,64,208,64,160,64,208,
64,144,64,208,128,157,0,73,168,9,32,64,208,128,173,0,72,164,8,64,208,128,
154,0,64,163,64,208,136,159,4,0,64,152,64,208,128,159,0,64,173,64,208,137,
163,5,12,0,136,145,4,0,128,144,0,128,164,0,192,151,0,64,208,73,159,13,16,
64,208,136,161,4,0,128,145,0,128,152,0,128,160,0,72,156,52,64,208,137,155,
5,24,0,137,148,5,16,0,136,147,4,0,64,145,64,208,128,156,0,128,154,0,73,
162,9,20,64,208,128,152,0,64,160,64,208,64,165,64,208,128,146,0,128,168,
0,64,155,64,208,137,163,5,8,0,128,151,0,64,173,64,208,128,157,0,74,163,
22,2,37,64,208,137,151,5,12,0,64,145,64,208,128,158,0,128,157,0,74,160,
46,1,187,64,208,137,164,5,20,0,73,156,9,12,64,208,128,151,0,128,146,0,128,
157,0,72,175,8,64,208,128,163,0,64,173,64,208,64,148,64,208,128,158,0,72,
159,121,64,208,73,154,9,52,64,208,128,154,0,73,147,9,28,64,208,128,163,
0,73,145,9,12,64,208,128,144,0,128,144,0,64,146,64,208,128,148,0,73,151,
9,12,64,208,128,163,0,128,148,0,128,152,0,201,160,10,41,0,64,208,128,159,
0,73,158,17,24,64,208,72,161,8,64,208,128,161,0,128,156,0,64,155,64,208,
128,158,0,64,159,64,208,128,154,0,73,163,13,20,64,208,64,157,64,208,128,
158,0,64,162,64,208,128,160,0,128,164,0,64,158,64,208,73,155,9,57,64,208,
128,158,0,137,151,5,33,0,73,146,9,16,64,208,128,157,0,64,144,64,208,128,
158,0,192,148,0,64,208,136,163,4,0,128,144,0,72,154,12,64,208,64,144,64,
208,128,148,0,128,152,0,73,160,161,196,64,208,72,162,152,64,208,73,159,
13,104,64,208,64,152,64,208,128,162,0,73,152,37,48,64,208,64,157,64,208,
64,146,64,208,64,149,64,208,64,157,64,208,64,162,64,208,64,144,64,208,64,
160,64,208,128,172,0,64,151,64,208,64,144,64,208,128,155,0,64,154,64,208,
72,158,28,64,208,64,156,64,208,64,159,64,208,64,155,64,208,64,149,64,208,
64,154,64,208,128,161,0,64,155,64,208,64,163,64,208,128,145,0,72,168,20,
64,208,64,154,64,208,64,158,64,208,64,155,64,208,128,144,0,64,162,64,208,
64,158,64,208,64,146,64,208,64,144,64,208,64,160,64,208,128,171,0,128,158,
0,73,158,13,24,64,208,136,160,4,0,128,159,0,64,156,64,208,136,161,4,0,128,
160,0,64,159,64,208,64,144,64,208,128,162,0,72,173,8,64,208,128,148,0,64,
167,64,208,64,144,64,208,128,157,0,72,162,36,64,208,137,151,5,20,0,137,
148,5,8,0,128,144,0,64,150,64,208,128,162,0,72,164,8,64,208,128,145,0,128,
158,0,192,161,0,64,208,137,156,5,24,0,73,148,13,16,64,208,64,162,64,208,
128,163,0,128,147,0,128,151,0,72,163,12,64,208,64,157,64,208,128,158,0,
64,161,64,208,128,161,0,201,166,22,77,0,64,208,137,148,5,8,0,128,144,0,
64,163,64,208,128,154,0,72,165,20,64,208,137,163,5,8,0,128,147,0,64,164,
64,208,128,144,0,64,164,64,208,137,156,5,20,0,137,152,5,8,0,128,145,0,64,
154,64,208,128,161,0,72,161,8,64,208,128,159,0,128,158,0,200,173,54,0,64,
208,73,156,9,29,64,208,128,152,0,201,154,10,17,0,64,208,128,161,0,136,148,
4,0,128,147,0,128,155,0,137,173,5,16,0,136,164,4,0,64,159,64,208,128,161,
0,128,175,0,64,167,64,208,128,160,0,64,161,64,208,202,159,65,1,148,0,64,
208,137,155,5,37,0,137,152,5,25,0,72,151,8,64,208,128,148,0,192,145,0,64,
208,64,158,64,208,128,173,0,64,154,64,208,128,151,0,73,158,9,17,64,208,
128,152,0,192,156,0,64,208,128,146,0,128,161,0,201,151,14,168,0,64,208,
136,146,4,0,128,145,0,73,147,25,114,64,208,73,158,9,12,64,208,128,154,0,
128,146,0,64,159,64,208,128,158,0,201,145,18,41,0,64,208,137,159,5,8,0,
128,157,0,128,162,0,64,144,64,208,136,154,4,0,64,147,64,208,72,159,8,64,
208,128,151,0,128,151,0,192,146,0,64,208,137,162,5,20,0,137,158,5,12,0,
136,151,4,0,128,148,0,128,160,0,73,166,13,16,64,208,64,146,64,208,128,149,
0,128,165,0,64,175,64,208,128,159,0,72,150,20,64,208,73,154,9,12,64,208,
128,163,0,128,148,0,128,162,0,192,148,0,64,208,137,146,5,8,0,128,144,0,
64,162,64,208,128,163,0,73,156,29,104,64,208,137,163,5,16,0,137,154,5,8,
0,128,151,0,128,159,0,136,174,4,0,128,168,0,72,154,40,64,208,73,159,9,20,
64,208,128,158,0,137,154,5,8,0,128,148,0,128,156,0,137,165,5,12,0,64,163,
64,208,128,148,0,128,166,0,64,152,64,208,73,157,13,28,64,208,64,156,64,
208,128,159,0,136,151,4,0,64,145,64,208,64,152,64,208,128,148,0,128,162,
0,72,158,44,64,208,137,152,5,28,0,137,148,5,12,0,64,145,64,208,128,152,
0,64,151,64,208,136,161,4,0,128,152,0,137,159,5,8,0,128,158,0,128,162,0,
64,157,64,208,137,156,5,16,0,64,155,64,208,64,159,64,208,128,161,0,128,
163,0,73,165,13,201,64,208,64,166,64,208,128,145,0,201,162,30,152,0,64,
208,73,161,9,20,64,208,128,148,0,72,157,8,64,208,128,174,0,128,145,0,128,
173,0,200,161,66,0,64,208,137,161,5,45,0,73,159,17,28,64,208,137,154,5,
8,0,128,151,0,128,158,0,72,148,8,64,208,128,156,0,128,147,0,192,160,0,64,
208,64,149,64,208,128,144,0,137,165,5,12,0,136,163,4,0,128,162,0,128,166,
0,64,160,64,208,73,157,13,41,64,208,136,161,4,0,128,152,0,73,155,9,16,64,
208,128,175,0,64,152,64,208,128,162,0,192,156,0,64,208,64,148,64,208,128,
152,0,137,164,5,8,0,128,162,0,128,175,0,72,164,16,64,208,136,158,4,0,64,
150,64,208,128,162,0,64,163,64,208,72,158,8,64,208,128,160,0,192,151,0,
64,208,128,144,0,73,168,13,28,64,208,136,156,4,0,128,152,0,72,167,8,64,
208,128,159,0,64,166,64,208,128,160,0,72,174,8,64,208,128,160,0,64,173,
64,208,200,162,13,0,64,208,136,173,4,0,128,158,0,128,151,0,82,164,1,3,4,
31,64,208,73,157,13,130,64,208,136,159,4,0,128,158,0,201,151,14,62,0,64,
208,64,158,64,208,128,150,0,73,146,13,32,64,208,64,144,64,208,128,163,0,
72,145,8,64,208,128,156,0,64,144,64,208,64,145,64,208,128,152,0,72,148,
8,64,208,128,151,0,192,147,0,64,208,128,144,0,73,155,9,32,64,208,128,161,
0,72,154,16,64,208,72,160,8,64,208,128,173,0,128,156,0,64,152,64,208,128,
152,0,64,156,64,208,72,173,8,64,208,128,152,0,64,147,64,208,64,159,64,208,
128,163,0,73,162,17,76,64,208,137,152,5,8,0,128,148,0,128,158,0,201,160,
19,52,0,64,208,136,174,4,0,192,156,0,64,208,128,145,0,200,159,30,0,64,208,
201,154,14,21,0,64,208,64,161,64,208,128,161,0,64,146,64,208,128,162,0,
128,160,0,128,158,0,64,161,64,208,128,144,0,73,166,13,34,64,208,64,158,
64,208,128,159,0,200,164,9,0,64,208,128,162,0,192,163,0,64,208,64,155,64,
208,128,158,0,64,173,64,208,136,163,4,0,128,152,0,64,163,64,208,74,157,
30,1,179,64,208,73,164,9,20,64,208,128,156,0,72,161,8,64,208,128,146,0,
128,145,0,128,166,0,73,149,9,248,64,208,128,156,0,73,146,30,86,64,208,137,
162,5,12,0,64,146,64,208,128,159,0,192,163,0,64,208,64,151,64,208,128,162,
0,201,144,18,25,0,64,208,137,155,5,8,0,128,154,0,128,160,0,64,134,64,208,
128,145,0,64,145,64,208,137,156,5,16,0,137,151,5,8,0,128,148,0,128,154,
0,137,160,5,8,0,128,159,0,128,162,0,72,148,112,64,208,73,158,29,100,64,
208,136,161,4,0,64,146,64,208,64,149,64,208,64,160,64,208,64,164,64,208,
128,172,0,137,154,5,16,0,64,150,64,208,64,158,64,208,128,154,0,64,156,64,
208,136,161,4,0,64,149,64,208,64,148,64,208,64,173,64,208,64,154,64,208,
64,161,64,208,64,159,64,208,64,149,64,208,64,160,64,208,64,162,64,208,64,
152,64,208,64,151,64,208,128,144,0,136,164,4,0,128,161,0,192,147,0,64,208,
201,158,14,29,0,64,208,64,159,64,208,128,162,0,136,156,4,0,64,144,64,208,
64,148,64,208,128,157,0,64,162,64,208,128,152,0,73,154,17,54,64,208,136,
159,4,0,64,158,64,208,128,161,0,72,152,34,72,208,26,137,161,5,12,0,136,
151,4,0,128,145,0,136,175,4,0,64,162,64,208,128,160,0,64,81,128,84,0,128,
151,0,72,156,56,64,208,137,154,5,28,0,73,148,9,20,64,208,128,163,0,64,147,
64,208,136,164,4,0,128,163,0,128,151,0,137,160,5,8,0,128,157,0,64,162,64,
208,136,158,4,0,64,149,64,208,128,155,0,64,155,64,208,72,172,40,64,208,
64,164,64,208,64,158,64,208,64,154,64,208,64,152,64,208,64,161,64,208,64,
155,64,208,64,158,64,208,64,162,64,208,128,144,0,128,156,0,74,163,26,1,
29,64,208,73,156,9,16,64,208,128,147,0,64,149,64,208,128,156,0,128,159,
0,73,160,57,204,64,208,73,156,9,36,64,208,128,161,0,137,146,5,12,0,64,145,
64,208,128,148,0,64,147,64,208,136,163,4,0,64,159,64,208,128,163,0,73,161,
9,12,64,208,128,162,0,128,159,0,128,166,0,72,159,97,64,208,73,159,9,45,
64,208,128,160,0,73,155,13,29,64,208,64,144,64,208,128,146,0,136,154,4,
0,192,145,0,64,208,64,158,64,208,128,162,0,64,157,64,208,128,160,0,73,162,
9,32,64,208,128,160,0,64,160,64,208,72,152,8,64,208,128,156,0,64,149,64,
208,64,156,64,208,128,144,0,64,173,64,208,64,145,64,208,64,158,64,208,128,
162,0,192,158,0,64,208,73,158,9,24,64,208,128,161,0,137,151,5,12,0,136,
148,4,0,128,145,0,128,152,0,201,161,10,18,0,64,208,128,158,0,192,159,0,
64,208,128,147,0,128,162,0,72,162,24,64,208,137,162,5,12,0,136,161,4,0,
128,159,0,64,173,64,208,128,154,0,64,161,64,208,137,154,5,20,0,72,152,8,
64,208,128,145,0,64,146,64,208,128,162,0,64,162,64,208,128,144,0,73,167,
9,28,64,208,128,159,0,72,166,12,64,208,64,160,64,208,128,164,0,64,164,64,
208,128,148,0,136,175,4,0,64,173,64,208,73,157,17,24,64,208,136,160,4,0,
64,154,64,208,128,158,0,136,154,4,0,128,148,0,192,160,0,64,208,136,161,
4,0,128,150,0,64,165,64,208,73,157,9,88,64,208,128,154,0,137,149,5,46,0,
73,146,18,29,64,208,136,160,4,0,192,149,0,64,208,128,159,0,64,144,64,208,
64,161,64,208,128,148,0,192,148,0,64,208,136,160,4,0,128,158,0,201,154,
19,26,0,64,208,200,159,9,0,64,208,128,161,0,128,145,0,64,151,64,208,128,
160,0,64,156,64,208,128,162,0,73,162,17,58,64,208,137,156,5,8,0,128,145,
0,128,162,0,201,159,22,33,0,64,208,72,173,8,64,208,128,173,0,64,159,64,
208,128,147,0,64,158,64,208,64,175,64,208,128,162,0,192,160,0,64,208,128,
163,0,201,166,10,13,0,64,208,128,145,0,128,163,0,128,168,0,82,173,1,157,
2,83,64,208,73,156,21,181,64,208,72,163,12,64,208,64,160,64,208,128,163,
0,128,151,0,73,150,9,103,64,208,128,157,0,73,147,29,78,64,208,137,152,5,
16,0,136,151,4,0,64,145,64,208,128,144,0,136,156,4,0,128,154,0,200,146,
33,0,64,208,137,156,5,20,0,64,148,64,208,64,158,64,208,64,158,64,208,128,
157,0,64,158,64,208,128,155,0,192,145,0,64,208,136,157,4,0,64,152,64,208,
128,160,0,192,148,0,64,208,137,158,5,8,0,128,148,0,128,162,0,73,154,29,
50,64,208,73,154,9,16,64,208,128,144,0,64,147,64,208,128,165,0,64,158,64,
208,128,159,0,200,152,13,0,64,208,136,159,4,0,128,154,0,192,151,0,64,208,
128,161,0,64,155,64,208,128,151,0,73,162,17,164,64,208,136,154,4,0,64,146,
64,208,128,157,0,73,160,34,110,64,208,201,161,14,21,0,64,208,64,163,64,
208,128,145,0,136,156,4,0,128,145,0,64,164,64,208,128,158,0,200,159,57,
0,64,208,137,158,5,32,0,73,152,9,20,64,208,128,157,0,136,145,4,0,64,144,
64,208,128,154,0,64,154,64,208,128,158,0,137,162,5,16,0,72,161,8,64,208,
128,161,0,128,159,0,128,168,0,64,158,64,208,137,152,5,12,0,136,148,4,0,
128,145,0,128,159,0,192,161,0,64,208,137,156,5,20,0,72,155,8,64,208,128,
144,0,64,152,64,208,128,175,0,200,160,9,0,64,208,128,167,0,128,159,0,73,
166,9,45,64,208,128,159,0,72,164,16,64,208,136,160,4,0,64,158,64,208,128,
160,0,192,163,0,64,208,137,154,5,12,0,136,148,4,0,128,144,0,128,158,0,64,
173,64,208,137,161,5,8,0,128,151,0,128,163,0,73,168,75,163,64,208,201,157,
10,46,0,64,208,128,163,0,137,149,5,25,0,200,147,17,0,64,208,72,173,8,64,
208,128,161,0,128,159,0,128,144,0,64,156,64,208,64,157,64,208,128,163,0,
73,162,9,20,64,208,128,160,0,72,161,8,64,208,128,144,0,128,158,0,128,173,
0,64,167,64,208,201,156,14,33,0,64,208,136,162,4,0,128,161,0,73,151,9,16,
64,208,128,159,0,136,145,4,0,128,144,0,128,154,0,73,161,9,32,64,208,128,
148,0,72,159,12,64,208,136,163,4,0,128,151,0,64,157,64,208,64,159,64,208,
128,157,0,64,163,64,208,72,157,12,64,208,64,160,64,208,128,159,0,128,155,
0,64,171,64,208,64,154,64,208,64,162,64,208,64,147,64,208,128,163,0,72,
175,45,64,208,137,161,5,25,0,137,146,5,13,0,192,145,0,64,208,128,152,0,
64,160,64,208,128,159,0,137,163,5,8,0,128,162,0,64,173,64,208,128,163,0,
64,174,64,208,73,160,21,37,64,208,64,160,64,208,64,150,64,208,64,152,64,
208,128,154,0,137,157,5,13,0,192,152,0,64,208,128,144,0,128,159,0,72,164,
16,64,208,64,145,64,208,64,147,64,208,128,163,0,192,162,0,64,208,64,163,
64,208,128,160,0,82,164,29,241,68,240,64,208,82,158,1,93,16,236,64,208,
137,154,5,133,0,73,148,9,80,64,208,128,158,0,73,145,13,28,64,208,64,152,
64,208,128,161,0,72,144,12,64,208,136,168,4,0,128,158,0,128,134,0,72,147,
40,64,208,73,160,13,24,64,208,64,144,64,208,128,148,0,72,159,8,64,208,128,
163,0,128,146,0,136,164,4,0,64,162,64,208,128,158,0,128,146,0,73,151,13,
24,64,208,136,158,4,0,128,152,0,136,150,4,0,64,149,64,208,128,155,0,192,
152,0,64,208,137,157,5,12,0,136,147,4,0,128,146,0,64,161,64,208,128,162,
0,73,161,57,172,64,208,73,162,21,44,64,208,72,173,8,64,208,128,157,0,64,
154,64,208,128,158,0,137,159,5,8,0,128,146,0,64,161,64,208,64,162,64,208,
64,152,64,208,128,161,0,136,165,4,0,128,163,0,73,158,9,39,64,208,128,155,
0,72,157,13,64,208,192,159,0,64,208,128,161,0,192,156,0,64,208,136,173,
4,0,192,161,0,64,208,128,146,0,72,160,40,64,208,137,159,5,20,0,136,147,
4,0,64,144,64,208,64,147,64,208,128,161,0,72,173,8,64,208,128,156,0,64,
160,64,208,128,144,0,64,159,64,208,73,161,26,29,64,208,72,162,12,64,208,
64,152,64,208,128,151,0,192,152,0,64,208,128,152,0,128,152,0,128,164,0,
137,168,5,28,0,136,166,4,0,64,162,64,208,73,157,9,12,64,208,128,151,0,128,
134,0,128,159,0,192,173,0,64,208,128,162,0,74,150,55,6,223,64,208,73,159,
9,28,64,208,128,159,0,73,149,9,16,64,208,128,155,0,64,144,64,208,128,162,
0,128,152,0,137,162,5,17,0,192,161,0,64,208,64,157,64,208,128,158,0,128,
165,0,74,146,232,4,174,64,208,137,158,5,149,0,73,152,33,92,64,208,72,173,
24,64,208,64,147,64,208,64,157,64,208,64,163,64,208,64,152,64,208,128,159,
0,128,161,0,73,149,9,48,64,208,128,148,0,136,148,4,0,64,147,64,208,72,163,
16,64,208,64,173,64,208,64,152,64,208,128,161,0,64,144,64,208,64,154,64,
208,64,152,64,208,128,152,0,64,151,64,208,64,164,64,208,128,152,0,201,156,
14,45,0,64,208,136,161,4,0,128,154,0,72,155,12,64,208,136,168,4,0,128,150,
0,64,154,64,208,72,161,8,64,208,128,160,0,64,159,64,208,128,154,0,64,157,
64,208,128,148,0,137,163,5,61,0,201,161,18,45,0,64,208,137,158,5,8,0,128,
156,0,128,160,0,72,160,16,64,208,137,155,5,8,0,128,144,0,128,158,0,64,159,
64,208,136,160,4,0,128,158,0,64,162,64,208,136,156,4,0,128,152,0,73,173,
9,12,64,208,128,151,0,128,167,0,128,175,0,82,144,2,250,3,25,64,208,74,156,
34,1,25,64,208,73,160,9,20,64,208,128,162,0,64,152,64,208,64,160,64,208,
128,162,0,64,161,64,208,128,163,0,73,150,9,116,64,208,128,162,0,73,146,
21,60,64,208,137,160,5,12,0,64,156,64,208,128,159,0,128,162,0,72,145,8,
64,208,128,158,0,64,144,64,208,137,160,5,20,0,73,156,9,12,64,208,128,158,
0,128,149,0,128,159,0,136,173,4,0,128,164,0,72,148,16,64,208,136,156,4,
0,64,154,64,208,128,161,0,64,147,64,208,137,156,5,16,0,137,148,5,8,0,128,
145,0,128,154,0,136,161,4,0,64,159,64,208,128,152,0,73,153,33,88,64,208,
64,155,64,208,64,161,64,208,64,149,64,208,64,160,64,208,64,146,64,208,64,
149,64,208,128,160,0,72,152,44,64,208,137,154,5,28,0,73,150,9,20,64,208,
128,154,0,72,146,8,64,208,128,162,0,128,145,0,128,152,0,137,159,5,8,0,128,
158,0,128,162,0,64,151,64,208,64,161,64,208,128,160,0,72,155,12,64,208,
136,165,4,0,128,162,0,64,154,64,208,73,158,9,16,64,208,128,157,0,136,154,
4,0,128,152,0,64,161,64,208,64,159,64,208,128,161,0,74,162,46,1,133,64,
208,137,159,5,20,0,136,154,4,0,64,152,64,208,64,161,64,208,128,158,0,136,
161,4,0,64,160,64,208,136,156,4,0,64,152,64,208,128,156,0,201,159,38,82,
0,64,208,73,156,9,20,64,208,128,154,0,72,152,8,64,208,128,163,0,128,146,
0,136,167,4,0,64,161,64,208,128,152,0,200,158,17,0,64,208,137,157,5,8,0,
128,156,0,128,158,0,64,157,64,208,73,154,17,20,64,208,64,160,64,208,64,
175,64,208,128,150,0,128,152,0,128,161,0,200,161,45,0,64,208,137,159,5,
28,0,137,155,5,16,0,64,150,64,208,64,154,64,208,128,165,0,64,156,64,208,
128,158,0,72,166,8,64,208,128,158,0,128,160,0,64,160,64,208,201,159,10,
197,0,64,208,128,160,0,72,156,176,64,208,73,152,21,80,64,208,64,156,64,
208,64,173,64,208,64,154,64,208,128,161,0,72,146,28,64,208,64,149,64,208,
64,161,64,208,64,162,64,208,64,157,64,208,64,152,64,208,128,154,0,64,144,
64,208,64,154,64,208,64,144,64,208,64,148,64,208,64,149,64,208,64,156,64,
208,64,152,64,208,128,175,0,72,164,28,64,208,64,144,64,208,64,145,64,208,
64,160,64,208,64,152,64,208,64,154,64,208,128,144,0,64,159,64,208,64,160,
64,208,64,158,64,208,72,152,36,64,208,64,151,64,208,64,146,64,208,64,158,
64,208,64,148,64,208,64,161,64,208,64,162,64,208,64,146,64,208,128,158,
0,64,149,64,208,64,154,64,208,64,162,64,208,128,171,0,64,144,64,208,64,
156,64,208,128,152,0,64,173,64,208,64,161,64,208,64,152,64,208,128,162,
0,73,167,9,73,64,208,128,161,0,72,164,33,64,208,137,158,5,21,0,72,154,13,
64,208,192,161,0,64,208,128,162,0,128,152,0,64,161,64,208,128,162,0,64,
163,64,208,73,158,13,20,64,208,64,173,64,208,128,151,0,64,147,64,208,128,
152,0,64,164,64,208,128,152,0,64,173,64,208,136,163,4,0,128,156,0,64,134,
64,208,73,156,13,20,64,208,64,155,64,208,128,134,0,64,154,64,208,128,161,
0,64,158,64,208,128,162,0,64,145,64,208,201,159,10,108,0,64,208,128,159,
0,201,154,10,59,0,64,208,128,152,0,201,148,10,38,0,64,208,128,148,0,72,
147,21,64,208,192,163,0,64,208,64,173,64,208,64,152,64,208,128,159,0,64,
146,64,208,128,162,0,64,152,64,208,136,160,4,0,128,147,0,73,156,13,24,64,
208,64,161,64,208,128,173,0,64,155,64,208,64,159,64,208,128,163,0,64,158,
64,208,72,161,8,64,208,128,147,0,128,157,0,73,163,14,38,64,208,192,159,
0,64,208,128,154,0,201,161,10,13,0,64,208,128,159,0,128,160,0,64,162,64,
208,136,158,4,0,128,151,0,137,166,5,16,0,64,164,64,208,136,160,4,0,128,
158,0,64,173,64,208,128,156,0,74,148,154,1,171,64,208,73,158,21,89,64,208,
73,158,9,12,64,208,128,166,0,128,154,0,128,162,0,73,148,9,44,64,208,128,
158,0,73,146,9,12,64,208,128,160,0,128,144,0,64,147,64,208,72,163,12,64,
208,64,159,64,208,128,161,0,64,159,64,208,128,163,0,73,154,9,17,64,208,
128,162,0,192,152,0,64,208,128,148,0,64,156,64,208,128,163,0,137,162,5,
43,0,201,160,10,27,0,64,208,128,162,0,192,159,0,64,208,136,159,4,0,192,
158,0,64,208,128,159,0,64,161,64,208,136,163,4,0,128,158,0,72,173,12,64,
208,64,145,64,208,128,166,0,128,166,0,64,147,64,208,73,157,9,98,64,208,
128,163,0,201,152,22,70,0,64,208,137,163,5,12,0,136,161,4,0,128,154,0,128,
166,0,201,146,18,41,0,64,208,64,164,64,208,136,158,4,0,128,155,0,72,145,
16,64,208,137,157,5,8,0,128,154,0,128,163,0,64,144,64,208,128,156,0,64,
148,64,208,128,161,0,73,155,13,16,64,208,64,159,64,208,128,163,0,128,154,
0,128,156,0,137,162,5,62,0,137,160,5,29,0,64,158,64,208,137,162,5,17,0,
200,161,9,0,64,208,128,162,0,128,156,0,128,163,0,64,161,64,208,137,160,
5,16,0,72,151,8,64,208,128,157,0,128,146,0,192,161,0,64,208,128,160,0,73,
164,13,106,64,208,64,173,64,208,128,152,0,192,163,0,64,208,201,157,14,57,
0,64,208,64,159,64,208,128,159,0,137,151,5,28,0,73,147,9,16,64,208,128,
159,0,64,144,64,208,128,159,0,64,148,64,208,128,159,0,136,154,4,0,64,152,
64,208,64,159,64,208,128,159,0,73,162,9,20,64,208,128,163,0,72,161,8,64,
208,128,159,0,128,159,0,72,173,8,64,208,128,159,0,128,163,0,128,166,0,64,
149,64,208,73,158,13,56,64,208,136,163,4,0,128,160,0,137,155,5,20,0,72,
145,8,64,208,128,158,0,64,144,64,208,128,156,0,64,157,64,208,73,159,9,16,
64,208,128,160,0,64,154,64,208,128,144,0,128,160,0,137,160,5,12,0,64,159,
64,208,128,157,0,64,166,64,208,128,144,0,74,155,172,6,58,64,208,73,156,
9,121,64,208,128,154,0,73,149,41,80,64,208,64,154,64,208,64,161,64,208,
64,158,64,208,64,156,64,208,64,144,64,208,64,168,64,208,64,152,64,208,64,
157,64,208,128,171,0,73,147,17,28,64,208,137,160,5,8,0,128,156,0,128,162,
0,64,144,64,208,136,163,4,0,128,156,0,64,148,64,208,136,154,4,0,128,150,
0,201,154,10,25,0,64,208,128,166,0,64,152,64,208,64,156,64,208,136,161,
4,0,128,154,0,64,155,64,208,128,155,0,137,165,5,29,0,137,159,5,16,0,64,
157,64,208,64,154,64,208,128,144,0,192,161,0,64,208,128,156,0,72,173,12,
64,208,64,146,64,208,128,161,0,128,166,0,82,152,3,178,4,54,64,208,202,158,
19,2,161,0,64,208,137,156,5,8,0,128,149,0,128,158,0,74,151,234,1,71,64,
208,73,159,41,156,64,208,64,158,64,208,64,148,64,208,64,147,64,208,64,158,
64,208,64,162,64,208,64,158,64,208,64,146,64,208,64,154,64,208,128,144,
0,73,155,13,84,64,208,64,152,64,208,128,166,0,72,154,32,64,208,64,163,64,
208,64,155,64,208,64,172,64,208,64,162,64,208,64,163,64,208,64,160,64,208,
128,144,0,64,146,64,208,64,158,64,208,64,161,64,208,64,159,64,208,64,152,
64,208,64,162,64,208,64,144,64,208,64,157,64,208,64,152,64,208,128,149,
0,64,156,64,208,72,149,8,64,208,128,165,0,64,144,64,208,64,162,64,208,64,
155,64,208,64,152,64,208,128,162,0,73,164,13,52,64,208,64,144,64,208,128,
154,0,72,162,12,64,208,64,149,64,208,128,165,0,64,160,64,208,64,144,64,
208,64,161,64,208,64,162,64,208,64,146,64,208,64,158,64,208,128,160,0,64,
165,64,208,64,152,64,208,64,156,64,208,64,152,64,208,128,152,0,73,146,26,
58,64,208,136,162,4,0,192,161,0,64,208,64,173,64,208,64,152,64,208,128,
159,0,72,145,8,64,208,128,165,0,64,144,64,208,137,166,5,17,0,200,160,9,
0,64,208,128,154,0,128,157,0,128,173,0,72,148,12,64,208,64,173,64,208,128,
156,0,64,147,64,208,72,163,12,64,208,64,159,64,208,128,161,0,64,162,64,
208,128,163,0,73,156,17,100,64,208,64,158,64,208,64,161,64,208,128,162,
0,72,155,68,64,208,73,164,13,16,64,208,64,144,64,208,128,154,0,128,159,
0,64,172,64,208,64,162,64,208,64,160,64,208,64,158,64,208,64,173,64,208,
64,155,64,208,64,149,64,208,64,156,64,208,64,149,64,208,64,157,64,208,64,
162,64,208,128,171,0,64,152,64,208,72,166,8,64,208,128,156,0,128,160,0,
64,157,64,208,73,158,21,140,64,208,64,162,64,208,64,148,64,208,64,149,64,
208,128,155,0,73,148,33,72,64,208,64,152,64,208,64,160,64,208,64,149,64,
208,64,154,64,208,64,162,64,208,64,158,64,208,128,160,0,72,147,8,64,208,
128,158,0,64,144,64,208,64,154,64,208,64,144,64,208,64,148,64,208,64,149,
64,208,64,156,64,208,64,152,64,208,128,175,0,72,156,40,64,208,64,158,64,
208,64,157,64,208,64,152,64,208,64,162,64,208,64,158,64,208,64,160,64,208,
64,152,64,208,64,157,64,208,128,147,0,64,154,64,208,128,151,0,73,163,41,
72,64,208,64,159,64,208,64,160,64,208,64,144,64,208,64,146,64,208,64,155,
64,208,64,149,64,208,64,157,64,208,64,152,64,208,128,149,0,72,162,12,64,
208,64,149,64,208,128,165,0,64,161,64,208,64,162,64,208,64,160,64,208,64,
152,64,208,128,159,0,72,173,8,64,208,128,154,0,128,164,0,73,163,25,201,
64,208,72,152,8,64,208,128,173,0,64,145,64,208,64,152,64,208,128,159,0,
73,161,53,128,64,208,137,161,5,36,0,73,156,9,28,64,208,128,158,0,64,152,
64,208,137,162,5,12,0,136,161,4,0,128,152,0,128,173,0,128,159,0,72,173,
8,64,208,128,163,0,128,163,0,72,160,36,64,208,137,158,5,12,0,64,154,64,
208,128,158,0,64,161,64,208,64,162,64,208,64,152,64,208,64,155,64,208,128,
172,0,64,159,64,208,73,166,13,24,64,208,64,162,64,208,128,158,0,137,159,
5,8,0,128,152,0,128,163,0,72,173,8,64,208,128,160,0,128,167,0,64,162,64,
208,201,159,10,33,0,64,208,128,159,0,137,145,5,12,0,64,144,64,208,128,163,
0,64,152,64,208,136,156,4,0,128,145,0,137,163,5,8,0,128,160,0,128,166,0,
73,173,37,52,64,208,72,163,12,64,208,64,152,64,208,128,159,0,64,152,64,
208,72,161,12,64,208,64,161,64,208,128,158,0,128,159,0,136,166,4,0,64,165,
64,208,64,164,64,208,128,154,0,192,175,0,64,208,136,164,4,0,128,160,0,192,
151,0,64,208,201,159,10,79,0,64,208,128,155,0,137,147,5,33,0,73,145,9,21,
64,208,128,162,0,192,144,0,64,208,136,158,4,0,128,145,0,64,146,64,208,128,
158,0,200,158,25,0,64,208,64,161,64,208,64,174,64,208,64,152,64,208,64,
156,64,208,128,160,0,64,156,64,208,136,162,4,0,128,154,0,73,164,13,33,64,
208,64,162,64,208,128,168,0,201,161,14,17,0,64,208,136,161,4,0,128,159,
0,128,160,0,128,163,0,72,167,8,64,208,128,161,0,64,166,64,208,128,158,0,
192,154,0,64,208,73,158,17,169,64,208,136,160,4,0,64,158,64,208,128,160,
0,137,151,5,66,0,73,147,30,41,64,208,137,163,5,21,0,72,162,8,64,208,128,
152,0,192,144,0,64,208,128,144,0,128,164,0,72,146,8,64,208,128,149,0,128,
144,0,200,150,9,0,64,208,128,154,0,64,148,64,208,64,152,64,208,128,160,
0,73,155,9,62,64,208,128,156,0,200,154,13,0,64,208,136,158,4,0,128,156,
0,64,152,64,208,73,162,9,21,64,208,128,144,0,200,161,9,0,64,208,128,158,
0,128,144,0,64,173,64,208,64,163,64,208,64,152,64,208,128,159,0,192,157,
0,64,208,137,158,5,16,0,64,152,64,208,64,158,64,208,128,157,0,128,162,0,
73,165,9,134,64,208,128,162,0,73,161,57,93,64,208,137,158,5,36,0,73,152,
13,24,64,208,136,162,4,0,128,161,0,136,148,4,0,64,146,64,208,128,148,0,
64,156,64,208,128,158,0,73,161,9,12,64,208,128,144,0,128,160,0,128,174,
0,72,160,12,64,208,64,166,64,208,128,145,0,192,159,0,64,208,137,152,5,8,
0,128,146,0,64,160,64,208,64,154,64,208,128,161,0,136,163,4,0,64,162,64,
208,137,164,5,21,0,200,152,9,0,64,208,128,163,0,64,144,64,208,128,161,0,
128,173,0,73,168,9,29,64,208,128,160,0,72,167,12,64,208,136,173,4,0,128,
152,0,192,166,0,64,208,128,145,0,64,173,64,208,128,144,0,72,157,248,64,
208,201,158,34,149,0,64,208,73,158,9,16,64,208,128,157,0,136,157,4,0,128,
156,0,136,173,4,0,64,164,64,208,128,156,0,201,149,10,58,0,64,208,128,144,
0,73,147,25,41,64,208,137,159,5,12,0,64,152,64,208,128,173,0,64,162,64,
208,128,156,0,136,145,4,0,192,144,0,64,208,64,146,64,208,128,162,0,64,148,
64,208,128,166,0,73,154,26,41,64,208,136,166,4,0,192,144,0,64,208,72,163,
8,64,208,128,160,0,128,162,0,64,152,64,208,72,156,8,64,208,128,145,0,128,
144,0,192,156,0,64,208,137,162,5,8,0,128,161,0,128,166,0,73,162,17,75,64,
208,137,160,5,8,0,128,152,0,128,166,0,201,160,14,50,0,64,208,136,174,4,
0,128,148,0,192,159,0,64,208,137,160,5,16,0,137,154,5,8,0,128,151,0,128,
158,0,137,162,5,12,0,64,161,64,208,128,158,0,128,166,0,192,161,0,64,208,
128,158,0,137,167,5,12,0,64,163,64,208,128,159,0,64,173,64,208,128,145,
0,64,156,64,208,201,158,22,220,0,64,208,137,156,5,8,0,128,154,0,64,161,
64,208,128,163,0,73,152,22,173,64,208,192,154,0,64,208,64,165,64,208,64,
152,64,208,128,161,0,73,146,9,68,64,208,128,152,0,72,145,24,64,208,137,
164,5,16,0,72,148,8,64,208,128,144,0,128,144,0,128,166,0,64,144,64,208,
73,162,17,20,64,208,64,152,64,208,64,147,64,208,128,145,0,128,159,0,64,
173,64,208,64,152,64,208,128,159,0,64,147,64,208,73,158,17,40,64,208,136,
163,4,0,64,159,64,208,128,163,0,73,147,9,16,64,208,128,144,0,64,144,64,
208,128,152,0,64,152,64,208,128,163,0,72,163,32,64,208,137,161,5,16,0,64,
154,64,208,64,152,64,208,128,152,0,64,162,64,208,64,152,64,208,128,163,
0,64,161,64,208,128,163,0,201,155,10,13,0,64,208,128,163,0,128,154,0,64,
156,64,208,192,159,0,64,208,128,163,0,73,163,25,113,64,208,73,156,9,12,
64,208,128,160,0,128,154,0,64,159,64,208,128,154,0,201,161,10,69,0,64,208,
128,160,0,72,160,8,64,208,128,162,0,64,159,64,208,73,158,13,28,64,208,64,
158,64,208,128,157,0,137,152,5,12,0,64,147,64,208,128,163,0,128,154,0,73,
161,9,16,64,208,128,163,0,64,159,64,208,128,161,0,128,163,0,64,162,64,208,
64,163,64,208,64,161,64,208,64,152,64,208,128,152,0,73,165,17,25,64,208,
136,164,4,0,64,162,64,208,128,148,0,192,164,0,64,208,128,144,0,64,173,64,
208,136,173,4,0,192,161,0,64,208,136,160,4,0,128,144,0,74,165,117,10,108,
64,208,73,158,13,58,64,208,64,162,64,208,128,156,0,201,156,22,34,0,64,208,
137,158,5,12,0,136,156,4,0,128,144,0,128,160,0,136,150,4,0,192,148,0,64,
208,128,156,0,64,157,64,208,64,161,64,208,128,154,0,73,162,25,49,64,208,
137,162,5,16,0,136,160,4,0,64,152,64,208,128,173,0,128,173,0,200,160,9,
0,64,208,128,145,0,64,159,64,208,64,163,64,208,64,156,64,208,128,150,0,
128,163,0,82,162,1,28,7,227,64,208,73,158,21,161,64,208,137,161,5,12,0,
136,156,4,0,128,146,0,128,162,0,201,152,40,112,0,64,208,201,159,10,26,0,
64,208,128,155,0,72,157,8,64,208,128,162,0,192,156,0,64,208,128,161,0,64,
161,64,208,128,145,0,73,145,9,29,64,208,128,160,0,200,144,17,0,64,208,137,
152,5,8,0,128,148,0,128,160,0,128,134,0,64,147,64,208,73,160,9,24,64,208,
128,163,0,72,157,8,64,208,128,163,0,64,144,64,208,128,163,0,72,173,8,64,
208,128,163,0,64,162,64,208,128,163,0,73,156,13,20,64,208,64,152,64,208,
128,162,0,136,155,4,0,128,154,0,192,157,0,64,208,128,147,0,201,163,14,100,
0,64,208,136,160,4,0,128,147,0,201,161,50,74,0,64,208,137,160,5,28,0,73,
156,9,16,64,208,128,158,0,64,151,64,208,128,158,0,64,159,64,208,128,154,
0,73,162,9,12,64,208,128,158,0,128,161,0,128,163,0,200,160,9,0,64,208,128,
160,0,64,159,64,208,72,159,8,64,208,128,160,0,128,152,0,192,162,0,64,208,
64,159,64,208,128,159,0,137,168,5,12,0,136,166,4,0,128,164,0,128,173,0,
210,160,1,185,3,103,0,64,208,73,156,33,210,64,208,137,159,5,16,0,136,154,
4,0,64,144,64,208,128,162,0,72,164,8,64,208,128,160,0,128,163,0,201,148,
10,108,0,64,208,128,152,0,201,145,27,42,0,64,208,201,152,10,17,0,64,208,
128,163,0,136,146,4,0,128,144,0,128,156,0,72,144,12,64,208,64,173,64,208,
128,161,0,128,134,0,200,147,53,0,64,208,73,163,13,28,64,208,64,159,64,208,
128,161,0,137,152,5,12,0,64,147,64,208,128,163,0,128,157,0,73,173,13,16,
64,208,136,163,4,0,128,144,0,128,164,0,128,175,0,128,146,0,73,152,30,62,
64,208,73,161,9,16,64,208,128,159,0,136,159,4,0,128,158,0,192,162,0,64,
208,128,161,0,72,151,24,64,208,64,152,64,208,64,162,64,208,64,152,64,208,
64,155,64,208,128,159,0,192,150,0,64,208,128,161,0,64,155,64,208,128,160,
0,73,163,13,159,64,208,64,148,64,208,128,157,0,201,160,30,78,0,64,208,137,
163,5,20,0,72,156,8,64,208,128,164,0,64,152,64,208,128,158,0,128,164,0,
72,159,40,64,208,137,159,5,24,0,73,157,9,12,64,208,128,162,0,128,147,0,
64,158,64,208,128,157,0,137,163,5,8,0,128,160,0,128,166,0,192,157,0,64,
208,128,161,0,72,162,16,64,208,137,159,5,8,0,128,154,0,128,163,0,192,161,
0,64,208,137,160,5,32,0,73,158,9,20,64,208,128,158,0,72,154,8,64,208,128,
154,0,128,152,0,64,159,64,208,128,145,0,137,163,5,8,0,128,162,0,64,165,
64,208,128,158,0,73,173,33,52,64,208,73,156,9,20,64,208,128,162,0,72,155,
8,64,208,128,144,0,128,144,0,136,161,4,0,128,159,0,72,166,8,64,208,128,
160,0,64,164,64,208,64,161,64,208,128,162,0,64,175,64,208,64,152,64,208,
128,155,0,64,159,64,208,73,157,13,216,64,208,64,159,64,208,128,154,0,73,
151,9,88,64,208,128,152,0,73,146,9,46,64,208,128,160,0,72,145,29,64,208,
201,160,10,17,0,64,208,128,145,0,64,144,64,208,128,163,0,64,173,64,208,
128,152,0,192,144,0,64,208,128,158,0,200,148,9,0,64,208,128,158,0,192,147,
0,64,208,73,155,9,12,64,208,128,163,0,128,154,0,64,162,64,208,128,163,0,
73,155,13,79,64,208,64,167,64,208,128,161,0,200,154,38,0,64,208,73,156,
9,16,64,208,128,160,0,136,146,4,0,128,145,0,200,159,13,0,64,208,136,161,
4,0,128,158,0,128,158,0,192,152,0,64,208,137,162,5,16,0,72,150,8,64,208,
128,161,0,128,144,0,136,175,4,0,128,173,0,64,156,64,208,137,156,5,25,0,
201,152,10,17,0,64,208,128,158,0,64,146,64,208,128,162,0,128,154,0,136,
162,4,0,128,159,0,73,162,17,182,64,208,136,155,4,0,64,152,64,208,128,162,
0,73,160,45,116,64,208,137,159,5,24,0,137,151,5,12,0,136,148,4,0,128,145,
0,136,158,4,0,128,154,0,137,163,5,12,0,136,162,4,0,128,161,0,128,173,0,
72,159,42,64,208,201,158,14,25,0,64,208,136,159,4,0,128,146,0,137,148,5,
8,0,128,147,0,128,154,0,200,160,9,0,64,208,128,160,0,128,159,0,64,158,64,
208,201,157,10,22,0,64,208,128,159,0,136,154,4,0,192,152,0,64,208,128,162,
0,128,160,0,192,161,0,64,208,73,159,13,37,64,208,64,148,64,208,128,163,
0,73,146,9,16,64,208,128,158,0,64,144,64,208,128,148,0,192,158,0,64,208,
128,160,0,136,163,4,0,128,160,0,201,165,10,21,0,64,208,128,159,0,72,164,
8,64,208,128,173,0,128,163,0,64,173,64,208,128,162,0,64,161,64,208,74,156,
26,1,216,64,208,137,151,5,12,0,64,150,64,208,128,161,0,64,159,64,208,128,
159,0,74,149,14,1,38,64,208,64,156,64,208,128,161,0,73,146,38,100,64,208,
201,162,10,25,0,64,208,128,161,0,136,160,4,0,64,158,64,208,136,161,4,0,
128,154,0,64,164,64,208,128,157,0,200,145,34,0,64,208,201,161,10,21,0,64,
208,128,154,0,136,160,4,0,64,152,64,208,128,158,0,136,163,4,0,128,162,0,
192,144,0,64,208,137,160,5,12,0,136,157,4,0,128,148,0,64,161,64,208,64,
152,64,208,128,173,0,72,148,12,64,208,136,157,4,0,128,146,0,192,147,0,64,
208,137,159,5,78,0,73,151,13,62,64,208,64,162,64,208,128,163,0,72,147,8,
64,208,128,144,0,192,144,0,64,208,73,161,13,21,64,208,64,152,64,208,128,
173,0,192,159,0,64,208,128,161,0,64,164,64,208,64,154,64,208,64,152,64,
208,128,159,0,64,152,64,208,136,157,4,0,128,154,0,73,163,57,78,64,208,137,
159,5,28,0,72,154,16,64,208,64,152,64,208,136,162,4,0,128,152,0,64,146,
64,208,128,154,0,72,173,12,64,208,64,152,64,208,128,164,0,64,162,64,208,
64,152,64,208,128,148,0,200,161,9,0,64,208,128,163,0,192,160,0,64,208,64,
154,64,208,128,154,0,64,166,64,208,128,160,0,73,152,69,108,64,208,73,159,
17,44,64,208,64,173,64,208,64,152,64,208,128,163,0,137,157,5,20,0,72,145,
12,64,208,64,152,64,208,128,159,0,128,144,0,64,158,64,208,128,160,0,73,
163,13,16,64,208,64,152,64,208,128,173,0,128,161,0,128,175,0,72,151,16,
64,208,137,157,5,8,0,128,154,0,128,159,0,64,150,64,208,137,160,5,16,0,72,
148,8,64,208,128,146,0,128,146,0,128,161,0,72,155,8,64,208,128,165,0,192,
154,0,64,208,137,157,5,20,0,137,154,5,8,0,128,152,0,64,156,64,208,128,145,
0,136,159,4,0,64,158,64,208,128,157,0,202,162,43,1,57,0,64,208,137,157,
5,20,0,137,151,5,12,0,64,148,64,208,128,158,0,128,152,0,137,161,5,8,0,128,
160,0,64,173,64,208,128,154,0,73,159,21,149,64,208,137,159,5,12,0,136,158,
4,0,128,148,0,128,160,0,200,158,41,0,64,208,137,154,5,20,0,137,151,5,12,
0,64,148,64,208,128,148,0,128,152,0,72,173,8,64,208,128,161,0,64,159,64,
208,128,158,0,64,157,64,208,137,157,5,32,0,137,149,5,16,0,72,146,8,64,208,
128,162,0,128,145,0,64,151,64,208,64,161,64,208,128,160,0,73,161,37,48,
64,208,137,159,5,24,0,72,158,8,64,208,128,157,0,64,151,64,208,64,161,64,
208,128,160,0,136,162,4,0,128,161,0,136,159,4,0,64,158,64,208,128,157,0,
128,162,0,200,161,81,0,64,208,201,158,10,56,0,64,208,128,145,0,201,146,
22,29,0,64,208,72,163,8,64,208,128,162,0,64,159,64,208,128,162,0,64,145,
64,208,128,158,0,192,157,0,64,208,200,161,9,0,64,208,128,159,0,128,146,
0,73,161,13,16,64,208,64,160,64,208,128,151,0,128,159,0,128,166,0,192,160,
0,64,208,137,159,5,28,0,73,146,9,16,64,208,128,152,0,64,144,64,208,128,
160,0,64,150,64,208,128,161,0,136,175,4,0,128,160,0,137,169,5,44,0,72,164,
32,64,208,137,158,5,20,0,137,154,5,12,0,64,145,64,208,128,157,0,128,156,
0,136,160,4,0,128,159,0,64,163,64,208,128,157,0,64,173,64,208,137,160,5,
16,0,72,157,8,64,208,128,159,0,128,147,0,64,162,64,208,64,144,64,208,128,
157,0,72,164,235,64,208,201,157,10,109,0,64,208,128,160,0,73,152,13,46,
64,208,136,160,4,0,128,150,0,73,148,9,30,64,208,128,158,0,200,147,13,0,
64,208,64,163,64,208,128,151,0,192,144,0,64,208,128,160,0,128,150,0,73,
155,13,45,64,208,64,159,64,208,128,148,0,192,154,0,64,208,137,160,5,20,
0,72,154,8,64,208,128,160,0,64,152,64,208,128,161,0,136,173,4,0,128,161,
0,192,156,0,64,208,128,158,0,137,163,5,93,0,73,160,21,64,64,208,137,159,
5,12,0,136,156,4,0,128,145,0,128,160,0,72,159,28,64,208,137,159,5,20,0,
72,156,12,64,208,136,159,4,0,128,158,0,128,152,0,128,160,0,64,158,64,208,
136,164,4,0,64,156,64,208,128,161,0,192,161,0,64,208,73,160,13,16,64,208,
64,150,64,208,128,161,0,128,157,0,128,161,0,73,165,9,21,64,208,128,145,
0,64,164,64,208,192,159,0,64,208,128,160,0,64,173,64,208,128,144,0,64,163,
64,208,201,156,26,194,0,64,208,137,162,5,16,0,64,145,64,208,64,173,64,208,
128,159,0,128,166,0,73,148,21,133,64,208,72,164,12,64,208,64,145,64,208,
128,154,0,128,157,0,201,146,10,69,0,64,208,128,161,0,72,145,36,64,208,137,
160,5,16,0,64,152,64,208,64,159,64,208,128,160,0,64,165,64,208,64,163,64,
208,64,165,64,208,128,158,0,64,144,64,208,137,148,5,12,0,64,147,64,208,
128,161,0,64,157,64,208,128,161,0,64,147,64,208,73,157,13,36,64,208,64,
162,64,208,128,163,0,72,155,8,64,208,128,163,0,64,144,64,208,72,162,8,64,
208,128,163,0,128,144,0,128,159,0,137,153,5,20,0,64,152,64,208,137,156,
5,8,0,128,152,0,128,162,0,64,154,64,208,136,147,4,0,64,144,64,208,128,163,
0,73,161,9,72,64,208,128,161,0,73,159,13,48,64,208,136,159,4,0,128,156,
0,72,158,8,64,208,128,151,0,64,157,64,208,73,154,13,20,64,208,64,144,64,
208,128,157,0,64,152,64,208,128,161,0,128,166,0,64,160,64,208,136,173,4,
0,64,144,64,208,128,158,0,73,166,9,16,64,208,128,167,0,64,164,64,208,128,
152,0,64,173,64,208,136,161,4,0,128,159,0,74,173,243,2,65,64,208,201,159,
10,143,0,64,208,128,158,0,137,154,5,77,0,137,148,5,40,0,136,147,4,0,64,
146,64,208,73,161,13,24,64,208,64,154,64,208,128,158,0,136,159,4,0,64,154,
64,208,128,158,0,128,162,0,200,152,29,0,64,208,137,159,5,20,0,136,156,4,
0,64,146,64,208,136,162,4,0,128,161,0,128,163,0,128,151,0,73,157,13,49,
64,208,64,152,64,208,128,158,0,72,156,33,64,208,137,159,5,25,0,200,152,
17,0,64,208,136,162,4,0,64,152,64,208,128,162,0,128,144,0,128,164,0,128,
155,0,64,158,64,208,128,159,0,137,164,5,70,0,73,162,17,53,64,208,64,152,
64,208,136,159,4,0,128,145,0,200,161,29,0,64,208,73,163,9,16,64,208,128,
160,0,136,160,4,0,128,157,0,64,164,64,208,128,160,0,64,160,64,208,128,161,
0,192,163,0,64,208,136,162,4,0,128,145,0,137,168,5,16,0,136,167,4,0,64,
165,64,208,128,162,0,64,173,64,208,128,154,0,74,167,14,1,42,64,208,136,
165,4,0,128,150,0,64,166,64,208,137,155,5,106,0,73,148,9,57,64,208,128,
162,0,73,146,17,40,64,208,136,162,4,0,64,156,64,208,128,162,0,72,145,12,
64,208,64,158,64,208,128,158,0,64,144,64,208,136,162,4,0,128,158,0,192,
147,0,64,208,128,161,0,201,152,14,33,0,64,208,64,158,64,208,128,160,0,136,
151,4,0,64,149,64,208,64,157,64,208,64,162,64,208,128,160,0,64,154,64,208,
64,145,64,208,128,164,0,73,160,9,86,64,208,128,162,0,73,158,21,61,64,208,
73,152,9,12,64,208,128,162,0,128,148,0,128,156,0,72,157,20,64,208,72,162,
8,64,208,128,159,0,64,146,64,208,128,162,0,64,156,64,208,136,156,4,0,192,
145,0,64,208,64,155,64,208,128,161,0,192,159,0,64,208,136,164,4,0,64,160,
64,208,128,158,0,73,173,17,77,64,208,136,162,4,0,64,160,64,208,128,152,
0,200,162,33,0,64,208,73,160,9,20,64,208,128,145,0,64,159,64,208,64,152,
64,208,128,148,0,64,162,64,208,128,163,0,64,161,64,208,73,161,9,20,64,208,
128,165,0,136,160,4,0,64,154,64,208,128,173,0,128,173,0,64,175,64,208,64,
160,64,208,128,145,0,64,168,64,208,201,156,10,25,0,64,208,128,150,0,72,
155,8,64,208,128,163,0,64,145,64,208,128,152,0,64,162,64,208,128,160,0,
72,175,24,64,208,73,164,13,16,64,208,64,152,64,208,128,154,0,128,157,0,
128,166,0,64,174,64,208,73,152,9,33,64,208,128,156,0,72,147,16,64,208,72,
162,8,64,208,128,163,0,128,152,0,192,144,0,64,208,128,162,0,72,163,16,64,
208,64,173,64,208,64,152,64,208,128,161,0,128,154,0,64,163,64,208,82,158,
1,70,24,42,64,208,73,157,17,150,64,208,137,156,5,8,0,128,145,0,128,158,
0,201,151,10,74,0,64,208,128,160,0,201,147,14,37,0,64,208,64,159,64,208,
128,159,0,72,146,8,64,208,128,148,0,64,145,64,208,136,158,4,0,64,144,64,
208,128,158,0,64,148,64,208,73,156,9,12,64,208,128,161,0,128,148,0,64,163,
64,208,64,163,64,208,128,156,0,73,155,21,48,64,208,137,149,5,8,0,128,144,
0,64,160,64,208,128,160,0,72,154,16,64,208,72,152,8,64,208,128,161,0,128,
145,0,64,152,64,208,64,147,64,208,128,156,0,64,156,64,208,136,151,4,0,128,
148,0,73,162,21,133,64,208,137,156,5,8,0,128,154,0,64,159,64,208,128,156,
0,201,160,22,92,0,64,208,137,152,5,8,0,128,147,0,64,160,64,208,128,161,
0,72,159,29,64,208,201,159,10,21,0,64,208,128,160,0,72,154,8,64,208,128,
159,0,128,148,0,128,162,0,64,158,64,208,137,160,5,34,0,200,159,13,0,64,
208,64,152,64,208,128,154,0,192,157,0,64,208,136,165,4,0,64,157,64,208,
128,159,0,128,161,0,64,161,64,208,201,157,10,13,0,64,208,128,165,0,128,
154,0,128,158,0,73,168,13,32,64,208,64,165,64,208,128,167,0,72,166,12,64,
208,64,166,64,208,128,144,0,64,164,64,208,128,144,0,128,169,0,74,150,85,
10,23,64,208,137,162,5,54,0,73,157,9,42,64,208,128,163,0,200,154,26,0,64,
208,137,161,5,8,0,128,147,0,192,165,0,64,208,64,152,64,208,128,145,0,64,
148,64,208,128,165,0,64,161,64,208,128,154,0,201,165,14,17,0,64,208,64,
152,64,208,128,145,0,128,164,0,64,173,64,208,128,154,0,82,146,1,168,5,15,
64,208,202,158,40,1,29,0,64,208,201,161,10,25,0,64,208,128,158,0,72,151,
12,64,208,64,152,64,208,128,146,0,128,146,0,64,173,64,208,128,167,0,73,
152,17,156,64,208,136,159,4,0,64,146,64,208,128,145,0,73,146,74,110,64,
208,137,160,5,52,0,73,152,13,36,64,208,64,163,64,208,128,161,0,136,146,
4,0,64,144,64,208,72,163,8,64,208,128,155,0,64,154,64,208,128,163,0,64,
154,64,208,64,163,64,208,128,161,0,201,162,10,13,0,64,208,128,163,0,128,
161,0,128,164,0,136,145,4,0,64,144,64,208,201,163,14,21,0,64,208,64,147,
64,208,128,144,0,64,162,64,208,128,161,0,64,168,64,208,128,159,0,200,148,
13,0,64,208,136,162,4,0,128,156,0,192,147,0,64,208,72,161,8,64,208,128,
167,0,128,152,0,73,156,29,82,64,208,137,161,5,16,0,72,154,8,64,208,128,
154,0,128,144,0,64,163,64,208,128,151,0,72,155,12,64,208,64,151,64,208,
128,160,0,192,154,0,64,208,201,159,10,25,0,64,208,128,167,0,73,148,9,12,
64,208,128,145,0,128,145,0,128,158,0,137,162,5,8,0,128,161,0,128,165,0,
64,157,64,208,128,163,0,137,165,5,78,0,73,161,25,53,64,208,136,159,4,0,
64,152,64,208,72,157,8,64,208,128,147,0,128,151,0,200,160,9,0,64,208,128,
144,0,64,159,64,208,137,160,5,12,0,136,156,4,0,128,148,0,128,163,0,72,163,
8,64,208,128,151,0,192,162,0,64,208,136,161,4,0,128,154,0,73,168,9,25,64,
208,128,145,0,136,167,4,0,192,166,0,64,208,64,147,64,208,128,144,0,192,
173,0,64,208,137,159,5,12,0,136,153,4,0,128,148,0,72,175,8,64,208,128,158,
0,128,161,0,82,144,1,214,2,13,64,208,73,157,17,255,64,208,72,157,8,64,208,
128,159,0,128,156,0,73,151,13,146,64,208,136,162,4,0,128,151,0,73,146,54,
101,64,208,137,159,5,20,0,72,152,12,64,208,64,144,64,208,128,154,0,128,
144,0,200,162,25,0,64,208,64,158,64,208,64,160,64,208,64,156,64,208,64,
149,64,208,128,162,0,128,160,0,72,145,20,64,208,137,160,5,12,0,136,152,
4,0,128,148,0,128,161,0,64,144,64,208,73,159,9,16,64,208,128,164,0,136,
157,4,0,128,152,0,64,161,64,208,128,159,0,72,148,16,64,208,136,156,4,0,
64,152,64,208,128,145,0,192,147,0,64,208,137,161,5,8,0,128,159,0,128,163,
0,137,155,5,65,0,72,154,16,64,208,137,157,5,8,0,128,156,0,128,163,0,192,
152,0,64,208,73,159,9,28,64,208,128,159,0,137,147,5,16,0,72,146,8,64,208,
128,162,0,128,145,0,128,154,0,137,161,5,8,0,128,160,0,128,173,0,64,156,
64,208,137,154,5,12,0,136,151,4,0,128,144,0,136,162,4,0,64,160,64,208,128,
146,0,73,163,9,163,64,208,128,159,0,73,161,34,127,64,208,73,161,9,25,64,
208,128,160,0,200,154,9,0,64,208,128,146,0,64,145,64,208,128,144,0,128,
163,0,72,160,36,64,208,73,156,13,24,64,208,64,145,64,208,128,158,0,72,152,
8,64,208,128,145,0,128,151,0,136,161,4,0,128,159,0,64,159,64,208,137,158,
5,29,0,73,152,9,16,64,208,128,162,0,136,147,4,0,128,146,0,192,154,0,64,
208,128,162,0,73,160,13,21,64,208,64,175,64,208,128,155,0,192,159,0,64,
208,128,158,0,128,166,0,64,162,64,208,73,159,9,16,64,208,128,159,0,136,
154,4,0,128,152,0,136,165,4,0,128,161,0,201,166,14,37,0,64,208,64,159,64,
208,128,145,0,72,165,8,64,208,128,154,0,64,164,64,208,136,158,4,0,64,134,
64,208,128,162,0,64,173,64,208,128,146,0,64,134,64,208,73,160,13,36,64,
208,64,164,64,208,128,160,0,137,150,5,16,0,64,134,64,208,64,162,64,208,
128,158,0,64,157,64,208,128,159,0,72,167,8,64,208,128,160,0,64,161,64,208,
128,148,0,64,145,64,208,73,157,29,146,64,208,137,159,5,20,0,72,158,8,64,
208,128,157,0,64,148,64,208,128,160,0,128,173,0,73,151,9,56,64,208,128,
152,0,73,148,13,24,64,208,136,157,4,0,128,148,0,136,146,4,0,64,144,64,208,
128,148,0,72,150,8,64,208,128,148,0,64,149,64,208,72,154,8,64,208,128,158,
0,128,151,0,137,155,5,53,0,72,154,33,64,208,137,159,5,21,0,136,154,4,0,
192,152,0,64,208,64,173,64,208,128,159,0,64,163,64,208,128,144,0,64,152,
64,208,136,161,4,0,64,151,64,208,128,152,0,192,156,0,64,208,128,162,0,201,
162,14,153,0,64,208,64,159,64,208,128,173,0,201,160,27,124,0,64,208,137,
159,5,17,0,64,152,64,208,192,160,0,64,208,128,144,0,128,160,0,200,159,65,
0,64,208,73,158,17,32,64,208,64,158,64,208,64,158,64,208,128,161,0,137,
148,5,12,0,64,146,64,208,128,148,0,128,154,0,72,162,8,64,208,128,155,0,
64,161,64,208,72,162,8,64,208,128,155,0,64,146,64,208,128,162,0,64,158,
64,208,137,157,5,12,0,136,151,4,0,128,148,0,192,159,0,64,208,136,161,4,
0,64,152,64,208,128,154,0,64,161,64,208,72,162,8,64,208,128,159,0,128,160,
0,137,168,5,24,0,72,165,12,64,208,64,161,64,208,128,161,0,64,164,64,208,
128,159,0,64,173,64,208,136,159,4,0,64,152,64,208,64,163,64,208,128,162,
0,82,148,1,94,4,127,64,208,201,159,18,202,0,64,208,72,157,8,64,208,128,
152,0,128,154,0,73,150,9,53,64,208,128,159,0,201,147,14,33,0,64,208,136,
163,4,0,128,156,0,72,145,8,64,208,128,158,0,64,144,64,208,136,163,4,0,128,
144,0,136,149,4,0,64,148,64,208,128,163,0,201,156,58,94,0,64,208,73,154,
17,32,64,208,64,164,64,208,64,152,64,208,128,161,0,137,151,5,8,0,128,145,
0,64,152,64,208,128,161,0,72,162,8,64,208,128,163,0,64,161,64,208,64,152,
64,208,128,145,0,200,154,9,0,64,208,128,161,0,64,152,64,208,73,157,9,16,
64,208,128,160,0,64,148,64,208,128,144,0,64,159,64,208,128,154,0,200,158,
25,0,64,208,73,154,13,16,64,208,64,156,64,208,128,161,0,128,148,0,128,155,
0,192,157,0,64,208,136,159,4,0,128,147,0,73,165,17,113,64,208,136,159,4,
0,64,152,64,208,128,145,0,73,162,17,57,64,208,137,154,5,8,0,128,147,0,128,
162,0,200,161,33,0,64,208,73,151,9,20,64,208,128,157,0,64,145,64,208,64,
149,64,208,128,151,0,64,161,64,208,128,154,0,64,160,64,208,128,173,0,72,
164,8,64,208,128,160,0,64,163,64,208,73,164,13,20,64,208,64,156,64,208,
128,162,0,64,159,64,208,128,161,0,64,165,64,208,128,162,0,73,173,9,16,64,
208,128,163,0,136,168,4,0,128,166,0,64,174,64,208,64,156,64,208,128,154,
0,192,147,0,64,208,74,158,43,2,4,64,208,137,161,5,25,0,200,160,17,0,64,
208,72,159,8,64,208,128,159,0,128,147,0,128,154,0,72,167,8,64,208,128,161,
0,128,163,0,73,151,21,214,64,208,137,156,5,12,0,64,145,64,208,128,156,0,
128,163,0,73,145,13,133,64,208,136,158,4,0,128,144,0,72,144,105,64,208,
73,159,9,41,64,208,128,161,0,201,152,10,25,0,64,208,128,154,0,72,148,8,
64,208,128,157,0,64,146,64,208,128,156,0,136,157,4,0,128,154,0,73,164,9,
32,64,208,128,154,0,72,162,8,64,208,128,163,0,64,161,64,208,137,157,5,8,
0,128,154,0,128,158,0,72,173,16,64,208,136,161,4,0,64,152,64,208,128,161,
0,64,165,64,208,136,154,4,0,128,144,0,64,134,64,208,64,160,64,208,64,164,
64,208,128,158,0,72,147,24,64,208,137,160,5,16,0,72,147,8,64,208,128,144,
0,128,144,0,128,163,0,192,146,0,64,208,73,162,13,20,64,208,64,154,64,208,
128,163,0,136,161,4,0,128,160,0,136,173,4,0,64,164,64,208,128,148,0,73,
155,57,157,64,208,73,158,17,40,64,208,64,159,64,208,64,152,64,208,128,155,
0,64,149,64,208,64,162,64,208,64,154,64,208,64,144,64,208,64,157,64,208,
128,172,0,64,162,64,208,136,163,4,0,128,144,0,72,154,28,64,208,137,161,
5,20,0,136,160,4,0,64,158,64,208,64,152,64,208,128,159,0,128,166,0,64,152,
64,208,137,156,5,49,0,73,152,17,36,64,208,64,173,64,208,64,152,64,208,128,
159,0,72,146,8,64,208,128,156,0,64,145,64,208,64,148,64,208,128,148,0,192,
154,0,64,208,128,161,0,73,159,9,16,64,208,128,157,0,64,158,64,208,128,159,
0,128,161,0,72,157,45,64,208,73,158,9,25,64,208,128,166,0,137,154,5,13,
0,192,145,0,64,208,128,159,0,128,155,0,72,162,8,64,208,128,163,0,64,161,
64,208,128,152,0,64,156,64,208,137,161,5,29,0,137,154,5,17,0,192,144,0,
64,208,64,148,64,208,128,158,0,64,160,64,208,128,157,0,137,163,5,13,0,192,
162,0,64,208,128,163,0,64,166,64,208,64,156,64,208,128,161,0,73,164,37,
218,64,208,73,160,17,28,64,208,64,159,64,208,64,156,64,208,128,159,0,64,
159,64,208,64,156,64,208,128,159,0,128,161,0,201,161,58,130,0,64,208,73,
159,9,32,64,208,128,155,0,73,151,9,20,64,208,128,157,0,72,146,8,64,208,
128,163,0,128,144,0,128,158,0,73,165,9,12,64,208,128,144,0,128,162,0,64,
173,64,208,128,157,0,72,160,21,64,208,137,158,5,13,0,192,154,0,64,208,128,
173,0,128,163,0,64,159,64,208,137,160,5,28,0,137,157,5,8,0,128,152,0,64,
159,64,208,137,161,5,8,0,128,154,0,128,163,0,73,162,9,12,64,208,128,152,
0,128,161,0,64,173,64,208,128,161,0,72,163,40,64,208,73,159,13,24,64,208,
136,162,4,0,128,161,0,64,146,64,208,64,165,64,208,128,159,0,64,164,64,208,
64,156,64,208,128,162,0,64,162,64,208,136,163,4,0,128,161,0,201,173,18,
55,0,64,208,137,161,5,8,0,128,157,0,128,163,0,72,166,21,64,208,72,162,8,
64,208,128,161,0,192,160,0,64,208,128,167,0,192,165,0,64,208,136,163,4,
0,64,162,64,208,128,163,0,64,174,64,208,128,144,0,64,149,64,208,137,154,
5,37,0,200,151,25,0,64,208,72,162,8,64,208,128,163,0,64,150,64,208,64,154,
64,208,128,163,0,64,147,64,208,128,147,0,136,162,4,0,64,161,64,208,128,
145,0,74,155,248,8,143,64,208,201,160,26,141,0,64,208,73,159,13,16,64,208,
64,160,64,208,128,163,0,128,151,0,128,160,0,73,154,9,80,64,208,128,162,
0,73,147,29,48,64,208,73,162,13,20,64,208,136,163,4,0,128,161,0,64,159,
64,208,128,163,0,128,163,0,72,146,12,64,208,136,163,4,0,128,160,0,64,145,
64,208,128,154,0,64,152,64,208,73,162,9,16,64,208,128,163,0,136,160,4,0,
128,155,0,128,163,0,73,157,9,24,64,208,128,144,0,136,156,4,0,64,155,64,
208,136,161,4,0,128,159,0,64,159,64,208,136,152,4,0,128,144,0,201,165,10,
61,0,64,208,128,155,0,73,163,17,48,64,208,72,163,8,64,208,128,173,0,128,
157,0,72,162,12,64,208,136,154,4,0,128,152,0,64,161,64,208,72,159,12,64,
208,64,167,64,208,128,156,0,128,154,0,128,164,0,73,168,13,24,64,208,64,
152,64,208,128,162,0,72,167,8,64,208,128,158,0,128,166,0,64,172,64,208,
64,147,64,208,64,173,64,208,128,161,0,82,152,1,110,3,112,64,208,73,158,
17,172,64,208,137,159,5,8,0,128,148,0,128,161,0,73,151,9,61,64,208,128,
160,0,73,147,13,41,64,208,64,156,64,208,128,148,0,200,145,17,0,64,208,72,
158,8,64,208,128,157,0,128,154,0,64,144,64,208,64,145,64,208,128,160,0,
64,148,64,208,136,161,4,0,128,151,0,73,155,9,82,64,208,128,156,0,200,154,
21,0,64,208,72,157,8,64,208,128,158,0,64,152,64,208,128,159,0,192,152,0,
64,208,73,158,9,32,64,208,128,161,0,73,146,9,20,64,208,128,165,0,64,144,
64,208,64,145,64,208,128,160,0,128,154,0,136,162,4,0,64,161,64,208,64,146,
64,208,128,145,0,192,157,0,64,208,136,159,4,0,128,144,0,73,163,21,143,64,
208,136,146,4,0,64,144,64,208,64,147,64,208,128,161,0,201,161,14,82,0,64,
208,136,154,4,0,128,152,0,72,160,37,64,208,201,158,10,21,0,64,208,128,161,
0,72,152,8,64,208,128,161,0,128,151,0,72,164,8,64,208,128,160,0,128,161,
0,64,159,64,208,137,146,5,8,0,128,144,0,64,159,64,208,64,154,64,208,64,
154,64,208,64,155,64,208,128,154,0,64,162,64,208,73,156,9,25,64,208,128,
158,0,137,154,5,8,0,128,146,0,192,155,0,64,208,128,154,0,137,161,5,8,0,
128,158,0,128,163,0,73,166,9,20,64,208,128,154,0,64,164,64,208,136,160,
4,0,128,154,0,64,173,64,208,72,163,16,64,208,136,159,4,0,64,152,64,208,
128,159,0,128,154,0,192,151,0,64,208,74,157,10,1,22,64,208,128,154,0,73,
150,9,131,64,208,128,156,0,201,146,10,67,0,64,208,128,162,0,72,145,33,64,
208,137,162,5,25,0,192,161,0,64,208,64,152,64,208,64,154,64,208,64,160,
64,208,128,161,0,128,167,0,192,144,0,64,208,73,159,9,12,64,208,128,152,
0,128,156,0,64,161,64,208,128,152,0,72,148,16,64,208,136,161,4,0,64,156,
64,208,128,161,0,64,147,64,208,137,162,5,20,0,73,152,9,12,64,208,128,144,
0,128,144,0,128,159,0,136,166,4,0,64,163,64,208,64,156,64,208,128,175,0,
73,155,9,66,64,208,128,151,0,72,154,49,64,208,137,156,5,28,0,137,151,5,
20,0,64,145,64,208,64,157,64,208,64,152,64,208,128,152,0,128,155,0,200,
162,13,0,64,208,64,150,64,208,128,156,0,128,161,0,192,152,0,64,208,128,
159,0,64,156,64,208,137,154,5,52,0,137,147,5,8,0,128,146,0,64,149,64,208,
64,162,64,208,64,154,64,208,64,158,64,208,64,156,64,208,64,145,64,208,64,
152,64,208,64,157,64,208,64,144,64,208,128,162,0,73,159,9,12,64,208,128,
152,0,128,156,0,128,161,0,201,162,47,179,0,64,208,137,157,5,20,0,137,152,
5,12,0,136,147,4,0,128,145,0,128,156,0,201,161,14,17,0,64,208,136,158,4,
0,128,156,0,128,158,0,128,162,0,201,160,39,92,0,64,208,137,161,5,17,0,136,
154,4,0,192,147,0,64,208,128,156,0,64,162,64,208,72,161,8,64,208,128,145,
0,128,152,0,200,159,29,0,64,208,137,159,5,16,0,137,154,5,8,0,128,152,0,
128,158,0,136,162,4,0,128,161,0,192,158,0,64,208,137,164,5,16,0,136,162,
4,0,64,148,64,208,128,159,0,128,168,0,64,161,64,208,201,156,10,17,0,64,
208,128,154,0,136,154,4,0,128,145,0,72,161,8,64,208,128,160,0,64,159,64,
208,64,162,64,208,128,161,0,137,167,5,20,0,72,165,8,64,208,128,160,0,64,
163,64,208,128,159,0,192,173,0,64,208,137,159,5,20,0,72,156,12,64,208,64,
152,64,208,128,154,0,128,152,0,64,162,64,208,128,158,0,64,154,64,208,73,
157,17,219,64,208,136,161,4,0,64,159,64,208,128,159,0,73,150,13,133,64,
208,64,154,64,208,128,165,0,201,146,14,61,0,64,208,136,160,4,0,128,151,
0,72,145,36,64,208,137,159,5,16,0,137,147,5,8,0,128,146,0,128,156,0,137,
161,5,8,0,128,160,0,64,162,64,208,128,156,0,64,144,64,208,136,163,4,0,128,
145,0,72,148,28,64,208,137,166,5,20,0,72,163,12,64,208,64,158,64,208,128,
161,0,128,155,0,128,173,0,64,147,64,208,137,148,5,20,0,72,146,12,64,208,
64,159,64,208,128,161,0,128,145,0,136,166,4,0,128,164,0,201,154,30,66,0,
64,208,73,158,9,16,64,208,128,146,0,136,151,4,0,128,144,0,64,160,64,208,
128,156,0,72,152,24,64,208,73,151,9,16,64,208,128,146,0,136,148,4,0,128,
145,0,128,166,0,192,151,0,64,208,136,148,4,0,128,146,0,128,156,0,74,162,
50,2,236,64,208,73,151,9,28,64,208,128,156,0,73,146,13,16,64,208,64,173,
64,208,128,148,0,128,145,0,128,148,0,73,156,9,12,64,208,128,154,0,128,154,
0,128,161,0,82,160,2,57,2,130,64,208,74,157,86,1,174,64,208,73,152,45,68,
64,208,64,152,64,208,73,156,13,24,64,208,64,158,64,208,128,148,0,136,146,
4,0,64,144,64,208,128,162,0,72,173,8,64,208,128,159,0,128,158,0,64,148,
64,208,64,134,64,208,72,159,8,64,208,128,145,0,64,149,64,208,128,159,0,
64,166,64,208,64,173,64,208,128,156,0,74,152,50,1,33,64,208,136,161,4,0,
64,157,64,208,72,162,20,64,208,72,173,8,64,208,128,152,0,64,149,64,208,
128,152,0,64,145,64,208,64,144,64,208,64,157,64,208,128,154,0,73,144,133,
152,64,208,73,159,29,92,64,208,64,167,64,208,64,149,64,208,64,160,64,208,
64,156,64,208,64,149,64,208,128,162,0,72,147,24,64,208,64,160,64,208,64,
158,64,208,64,155,64,208,64,152,64,208,128,151,0,64,146,64,208,64,162,64,
208,64,158,64,208,64,165,64,208,64,158,64,208,64,155,64,208,64,148,64,208,
64,152,64,208,64,157,64,208,128,147,0,64,162,64,208,64,158,64,208,64,156,
64,208,64,159,64,208,64,160,64,208,64,152,64,208,64,145,64,208,64,158,64,
208,128,160,0,64,134,64,208,64,157,64,208,64,162,64,208,64,149,64,208,128,
134,0,64,147,64,208,72,152,72,64,208,72,159,24,64,208,64,160,64,208,64,
158,64,208,64,156,64,208,64,149,64,208,128,151,0,64,148,64,208,64,160,64,
208,64,158,64,208,64,156,64,208,64,149,64,208,64,162,64,208,64,166,64,208,
64,149,64,208,64,157,64,208,64,162,64,208,128,160,0,64,144,64,208,64,150,
64,208,128,162,0,136,156,4,0,64,154,64,208,72,158,36,64,208,64,156,64,208,
64,156,64,208,64,163,64,208,64,157,64,208,64,145,64,208,64,144,64,208,64,
157,64,208,128,154,0,64,144,64,208,64,160,64,208,128,162,0,137,164,5,88,
0,73,159,69,80,64,208,72,160,56,64,208,64,158,64,208,72,164,20,64,208,64,
145,64,208,64,144,64,208,64,157,64,208,128,154,0,64,156,64,208,64,152,64,
208,64,157,64,208,64,146,64,208,64,149,64,208,64,161,64,208,128,162,0,64,
158,64,208,128,156,0,64,158,64,208,64,161,64,208,128,158,0,128,161,0,72,
175,8,64,208,128,158,0,64,166,64,208,72,152,16,64,208,64,159,64,208,64,
152,64,208,128,163,0,64,134,64,208,64,159,64,208,64,134,64,208,128,159,
0,72,159,38,64,208,201,157,10,21,0,64,208,128,147,0,137,152,5,8,0,128,147,
0,128,155,0,200,162,9,0,64,208,128,156,0,128,159,0,64,158,64,208,73,159,
9,24,64,208,128,159,0,72,157,12,64,208,64,159,64,208,128,173,0,128,152,
0,64,161,64,208,128,149,0,192,161,0,64,208,73,159,9,40,64,208,128,161,0,
73,152,13,28,64,208,64,146,64,208,128,162,0,72,148,8,64,208,128,152,0,64,
144,64,208,128,159,0,128,154,0,137,161,5,8,0,128,160,0,128,165,0,201,166,
26,77,0,64,208,72,152,12,64,208,136,162,4,0,128,151,0,64,146,64,208,128,
151,0,72,165,16,64,208,136,162,4,0,64,152,64,208,128,145,0,64,163,64,208,
73,152,9,16,64,208,128,161,0,136,151,4,0,128,148,0,72,164,12,64,208,64,
144,64,208,128,161,0,128,162,0,64,173,64,208,72,161,8,64,208,128,156,0,
128,160,0,80,157,2,12,80,208,2,1,202,157,19,1,77,0,64,208,72,158,8,64,208,
128,157,0,128,154,0,73,148,49,102,64,208,137,158,5,40,0,64,134,64,208,73,
146,13,24,64,208,64,149,64,208,128,159,0,64,144,64,208,64,161,64,208,128,
148,0,64,149,64,208,128,159,0,128,162,0,201,145,10,38,0,64,208,128,159,
0,72,144,8,64,208,128,173,0,64,134,64,208,201,147,10,13,0,64,208,128,163,
0,128,144,0,128,154,0,64,146,64,208,72,173,8,64,208,128,161,0,128,164,0,
201,155,14,205,0,64,208,64,162,64,208,128,173,0,72,154,44,64,208,73,156,
9,32,64,208,128,158,0,73,147,9,16,64,208,128,145,0,64,146,64,208,128,148,
0,64,152,64,208,128,162,0,136,161,4,0,128,158,0,64,152,64,208,73,152,58,
98,64,208,73,160,9,33,64,208,128,162,0,137,156,5,12,0,64,154,64,208,128,
156,0,192,159,0,64,208,136,159,4,0,128,144,0,137,164,5,8,0,128,161,0,64,
173,64,208,136,159,4,0,128,146,0,73,147,9,29,64,208,128,154,0,72,145,12,
64,208,64,158,64,208,128,161,0,192,144,0,64,208,128,157,0,64,151,64,208,
64,148,64,208,128,158,0,201,164,14,42,0,64,208,64,152,64,208,128,157,0,
200,161,21,0,64,208,72,162,8,64,208,128,158,0,64,152,64,208,128,145,0,64,
160,64,208,128,161,0,128,166,0,64,156,64,208,128,166,0,73,162,17,124,64,
208,137,158,5,8,0,128,148,0,128,166,0,201,160,10,79,0,64,208,128,161,0,
200,159,42,0,64,208,137,158,5,20,0,73,152,9,12,64,208,128,161,0,128,151,
0,128,154,0,136,167,4,0,192,166,0,64,208,64,160,64,208,128,156,0,64,158,
64,208,72,157,12,64,208,64,149,64,208,128,162,0,64,146,64,208,64,152,64,
208,128,161,0,64,161,64,208,201,158,10,21,0,64,208,128,164,0,136,154,4,
0,64,149,64,208,128,150,0,128,160,0,201,166,34,49,0,64,208,73,159,13,24,
64,208,136,152,4,0,128,148,0,72,154,8,64,208,128,159,0,128,146,0,128,161,
0,72,165,8,64,208,128,163,0,64,163,64,208,128,161,0,128,167,0,64,73,64,
208,128,144,0,192,156,0,64,208,202,157,43,1,29,0,64,208,73,152,13,24,64,
208,136,166,4,0,128,154,0,136,147,4,0,64,134,64,208,128,166,0,136,167,4,
0,64,155,64,208,128,152,0,137,150,5,147,0,201,147,18,107,0,64,208,72,168,
8,64,208,128,158,0,128,145,0,201,145,42,49,0,64,208,72,159,16,64,208,64,
161,64,208,64,159,64,208,128,160,0,64,152,64,208,64,166,64,208,64,149,64,
208,64,157,64,208,128,162,0,64,134,64,208,128,166,0,64,146,64,208,137,160,
5,25,0,201,148,10,13,0,64,208,128,163,0,128,145,0,64,149,64,208,128,148,
0,72,173,8,64,208,128,161,0,128,167,0,72,149,16,64,208,64,154,64,208,64,
158,64,208,128,157,0,64,148,64,208,64,160,64,208,64,147,64,208,64,168,64,
208,128,158,0,201,154,18,67,0,64,208,137,154,5,8,0,128,148,0,128,161,0,
72,152,41,64,208,137,151,5,21,0,200,147,9,0,64,208,128,144,0,64,144,64,
208,128,157,0,64,162,64,208,136,166,4,0,64,144,64,208,128,162,0,192,151,
0,64,208,128,167,0,72,156,16,64,208,136,154,4,0,64,144,64,208,128,157,0,
192,155,0,64,208,64,144,64,208,128,148,0,137,165,5,211,0,73,161,34,120,
64,208,137,160,5,21,0,137,158,5,8,0,128,144,0,192,159,0,64,208,128,162,
0,136,166,4,0,128,165,0,73,159,38,75,64,208,201,158,10,29,0,64,208,128,
162,0,72,150,16,64,208,136,165,4,0,64,154,64,208,128,165,0,128,148,0,128,
159,0,192,158,0,64,208,201,160,10,25,0,64,208,128,151,0,72,159,12,64,208,
64,152,64,208,128,162,0,128,158,0,136,166,4,0,128,161,0,64,160,64,208,64,
164,64,208,128,159,0,72,164,20,64,208,72,159,12,64,208,64,156,64,208,128,
159,0,128,145,0,64,162,64,208,201,161,14,47,0,64,208,64,152,64,208,128,
154,0,137,154,5,25,0,72,152,12,64,208,64,165,64,208,128,158,0,192,145,0,
64,208,128,161,0,192,158,0,64,208,128,159,0,137,163,5,8,0,128,162,0,64,
173,64,208,128,159,0,73,168,9,38,64,208,128,157,0,72,167,8,64,208,128,161,
0,192,166,0,64,208,72,163,8,64,208,128,154,0,192,160,0,64,208,128,158,0,
136,174,4,0,64,173,64,208,137,159,5,12,0,136,158,4,0,128,148,0,128,166,
0,210,166,1,12,13,63,0,64,208,73,156,17,122,64,208,136,152,4,0,64,151,64,
208,128,160,0,73,148,17,60,64,208,136,158,4,0,64,157,64,208,128,147,0,73,
146,13,28,64,208,136,162,4,0,128,161,0,136,145,4,0,64,134,64,208,64,156,
64,208,128,156,0,64,147,64,208,64,158,64,208,64,160,64,208,128,152,0,201,
154,18,34,0,64,208,137,159,5,8,0,128,156,0,128,162,0,192,152,0,64,208,136,
162,4,0,64,158,64,208,128,156,0,64,155,64,208,64,159,64,208,128,158,0,201,
160,10,69,0,64,208,128,145,0,73,158,25,36,64,208,72,175,12,64,208,136,158,
4,0,128,151,0,64,154,64,208,128,158,0,64,157,64,208,64,156,64,208,128,159,
0,64,159,64,208,137,156,5,12,0,136,154,4,0,128,145,0,64,159,64,208,128,
154,0,73,162,29,53,64,208,137,161,5,12,0,136,158,4,0,128,156,0,64,173,64,
208,64,165,64,208,128,144,0,64,161,64,208,201,156,10,17,0,64,208,128,162,
0,136,145,4,0,128,144,0,128,159,0,64,173,64,208,136,173,4,0,64,159,64,208,
128,152,0,82,162,1,62,9,166,64,208,73,158,29,167,64,208,72,154,8,64,208,
128,155,0,64,146,64,208,64,152,64,208,64,173,64,208,128,154,0,201,151,14,
70,0,64,208,64,159,64,208,128,159,0,201,147,14,45,0,64,208,136,163,4,0,
128,154,0,72,146,12,64,208,64,152,64,208,128,161,0,64,144,64,208,73,147,
9,12,64,208,128,144,0,128,145,0,128,161,0,64,150,64,208,136,163,4,0,128,
162,0,73,156,9,45,64,208,128,160,0,72,154,12,64,208,136,156,4,0,128,151,
0,64,152,64,208,200,161,13,0,64,208,64,151,64,208,128,157,0,64,159,64,208,
128,145,0,64,157,64,208,137,160,5,12,0,64,152,64,208,128,152,0,64,162,64,
208,128,160,0,137,163,5,87,0,201,161,22,62,0,64,208,73,151,9,12,64,208,
128,157,0,128,144,0,128,160,0,72,160,20,64,208,137,159,5,12,0,136,151,4,
0,128,148,0,128,164,0,192,159,0,64,208,137,159,5,12,0,136,154,4,0,128,151,
0,128,161,0,192,162,0,64,208,136,154,4,0,64,152,64,208,64,161,64,208,128,
162,0,73,168,9,32,64,208,128,154,0,136,166,4,0,64,164,64,208,72,158,12,
64,208,64,156,64,208,128,161,0,128,155,0,64,173,64,208,137,162,5,17,0,200,
159,9,0,64,208,128,158,0,128,157,0,128,165,0,210,160,3,103,5,243,0,64,208,
74,157,38,2,85,64,208,137,154,5,28,0,72,152,16,64,208,136,157,4,0,64,146,
64,208,128,152,0,64,147,64,208,128,156,0,128,161,0,74,150,10,1,215,64,208,
128,159,0,202,146,19,1,101,0,64,208,137,146,5,8,0,128,145,0,128,158,0,72,
145,12,64,208,136,158,4,0,128,148,0,64,144,64,208,82,155,1,32,1,47,64,208,
73,157,61,144,64,208,64,152,64,208,72,162,8,64,208,128,152,0,64,152,64,
208,73,161,17,32,64,208,64,165,64,208,64,158,64,208,128,151,0,72,155,8,
64,208,128,159,0,64,144,64,208,128,161,0,64,167,64,208,128,156,0,73,147,
37,64,64,208,72,163,12,64,208,64,164,64,208,128,154,0,64,144,64,208,72,
165,8,64,208,128,144,0,64,164,64,208,128,154,0,72,146,12,64,208,64,173,
64,208,128,161,0,64,144,64,208,72,162,8,64,208,128,152,0,128,151,0,64,152,
64,208,64,157,64,208,64,159,64,208,64,173,64,208,128,154,0,73,162,58,113,
64,208,72,160,33,64,208,64,144,64,208,64,157,64,208,192,161,0,64,208,64,
145,64,208,64,144,64,208,64,157,64,208,128,154,0,64,149,64,208,64,165,64,
208,64,147,64,208,64,144,64,208,128,151,0,72,161,12,64,208,64,152,64,208,
128,145,0,64,159,64,208,64,160,64,208,64,158,64,208,64,156,64,208,72,154,
12,64,208,64,158,64,208,128,156,0,64,145,64,208,64,144,64,208,64,157,64,
208,128,154,0,64,165,64,208,64,152,64,208,64,156,64,208,64,156,64,208,64,
144,64,208,128,168,0,73,147,9,12,64,208,128,161,0,128,146,0,128,150,0,73,
159,13,16,64,208,64,144,64,208,128,145,0,128,158,0,128,164,0,72,148,12,
64,208,64,159,64,208,128,162,0,64,147,64,208,73,159,17,60,64,208,136,163,
4,0,64,159,64,208,128,163,0,137,152,5,36,0,72,147,12,64,208,136,163,4,0,
128,144,0,64,144,64,208,72,165,8,64,208,128,144,0,64,159,64,208,128,161,
0,64,156,64,208,128,144,0,73,173,9,21,64,208,128,163,0,192,163,0,64,208,
64,159,64,208,128,161,0,64,174,64,208,128,144,0,73,154,21,53,64,208,137,
156,5,8,0,128,144,0,64,162,64,208,128,161,0,72,152,29,64,208,73,160,13,
16,64,208,64,163,64,208,128,158,0,128,145,0,192,164,0,64,208,128,160,0,
128,151,0,72,156,24,64,208,137,148,5,16,0,64,147,64,208,64,152,64,208,128,
163,0,128,154,0,64,155,64,208,136,161,4,0,128,151,0,73,164,21,167,64,208,
137,163,5,8,0,128,158,0,64,174,64,208,128,152,0,73,160,17,90,64,208,72,
162,8,64,208,128,152,0,128,154,0,72,159,41,64,208,137,154,5,21,0,136,152,
4,0,192,148,0,64,208,64,159,64,208,128,158,0,136,166,4,0,64,161,64,208,
64,146,64,208,128,162,0,192,158,0,64,208,73,159,9,16,64,208,128,148,0,136,
146,4,0,128,145,0,64,160,64,208,64,144,64,208,128,157,0,72,162,20,64,208,
136,161,4,0,64,152,64,208,64,161,64,208,128,152,0,192,161,0,64,208,137,
158,5,16,0,72,152,8,64,208,128,159,0,128,151,0,72,173,8,64,208,128,152,
0,64,159,64,208,128,154,0,73,173,13,91,64,208,64,152,64,208,128,154,0,200,
167,9,0,64,208,128,159,0,192,166,0,64,208,201,161,14,33,0,64,208,136,173,
4,0,128,144,0,137,156,5,8,0,128,144,0,64,158,64,208,64,162,64,208,128,173,
0,73,163,9,16,64,208,128,159,0,64,162,64,208,128,162,0,64,173,64,208,136,
173,4,0,64,166,64,208,128,161,0,64,174,64,208,128,152,0,64,159,64,208,202,
157,47,1,46,0,64,208,137,156,5,16,0,72,155,8,64,208,128,161,0,128,154,0,
136,160,4,0,64,159,64,208,64,152,64,208,64,154,64,208,64,160,64,208,128,
161,0,137,150,5,180,0,201,147,22,131,0,64,208,137,154,5,12,0,64,147,64,
208,128,154,0,128,162,0,73,145,22,51,64,208,192,161,0,64,208,64,146,64,
208,136,162,4,0,128,160,0,192,144,0,64,208,201,162,10,21,0,64,208,128,161,
0,72,161,8,64,208,128,160,0,128,151,0,128,173,0,192,146,0,64,208,201,158,
14,29,0,64,208,64,161,64,208,128,158,0,137,155,5,12,0,136,154,4,0,128,152,
0,128,156,0,201,161,10,21,0,64,208,128,157,0,136,160,4,0,64,159,64,208,
128,158,0,128,163,0,72,149,8,64,208,128,159,0,64,148,64,208,137,159,5,17,
0,200,156,9,0,64,208,128,156,0,128,154,0,72,164,8,64,208,128,160,0,64,162,
64,208,128,161,0,201,154,43,59,0,64,208,73,160,9,24,64,208,128,161,0,73,
156,9,12,64,208,128,163,0,128,145,0,128,158,0,136,162,4,0,192,161,0,64,
208,128,151,0,200,152,13,0,64,208,136,160,4,0,128,154,0,128,151,0,200,156,
13,0,64,208,136,164,4,0,128,146,0,128,155,0,202,164,15,1,25,0,64,208,136,
163,4,0,128,160,0,73,161,51,217,64,208,137,154,5,30,0,73,151,9,17,64,208,
128,157,0,192,146,0,64,208,128,147,0,192,152,0,64,208,128,159,0,73,158,
9,12,64,208,128,161,0,128,156,0,128,161,0,201,159,55,127,0,64,208,201,157,
14,33,0,64,208,64,152,64,208,128,160,0,137,152,5,16,0,136,147,4,0,64,146,
64,208,128,173,0,128,155,0,137,164,5,12,0,136,160,4,0,128,158,0,128,167,
0,64,158,64,208,73,151,17,41,64,208,72,156,8,64,208,128,161,0,128,148,0,
201,146,10,21,0,64,208,128,161,0,64,144,64,208,64,156,64,208,128,160,0,
128,147,0,72,163,16,64,208,64,162,64,208,64,158,64,208,128,161,0,64,159,
64,208,64,158,64,208,128,162,0,64,160,64,208,137,162,5,24,0,73,152,9,16,
64,208,128,163,0,64,151,64,208,128,144,0,128,160,0,72,175,8,64,208,128,
155,0,128,163,0,72,163,12,64,208,136,163,4,0,128,159,0,192,162,0,64,208,
201,154,14,21,0,64,208,64,158,64,208,128,158,0,136,150,4,0,128,147,0,72,
159,8,64,208,128,147,0,128,156,0,201,167,14,34,0,64,208,136,152,4,0,128,
151,0,200,166,9,0,64,208,128,154,0,64,165,64,208,136,147,4,0,128,146,0,
72,175,8,64,208,128,156,0,64,173,64,208,137,162,5,16,0,72,155,8,64,208,
128,154,0,128,154,0,128,166,0,64,161,64,208,202,157,23,1,97,0,64,208,137,
158,5,12,0,136,154,4,0,128,147,0,128,173,0,73,149,21,202,64,208,72,165,
8,64,208,128,145,0,64,145,64,208,128,175,0,73,146,78,110,64,208,137,157,
5,53,0,137,151,5,16,0,72,150,8,64,208,128,157,0,128,144,0,64,152,64,208,
72,162,13,64,208,192,155,0,64,208,128,144,0,64,159,64,208,64,152,64,208,
64,154,64,208,128,156,0,137,160,5,16,0,64,159,64,208,64,159,64,208,128,
159,0,128,163,0,72,145,16,64,208,137,158,5,8,0,128,144,0,128,162,0,192,
144,0,64,208,136,166,4,0,64,159,64,208,128,159,0,200,148,46,0,64,208,73,
160,9,28,64,208,128,159,0,137,156,5,16,0,64,147,64,208,64,159,64,208,128,
162,0,128,159,0,136,163,4,0,192,161,0,64,208,128,158,0,192,147,0,64,208,
73,156,9,12,64,208,128,154,0,128,148,0,192,158,0,64,208,128,146,0,73,154,
45,88,64,208,73,154,9,24,64,208,128,161,0,137,148,5,8,0,128,145,0,64,152,
64,208,128,161,0,136,168,4,0,64,158,64,208,64,160,64,208,128,160,0,72,152,
20,64,208,73,162,9,12,64,208,128,158,0,128,145,0,128,166,0,64,151,64,208,
137,157,5,16,0,72,156,8,64,208,128,157,0,128,154,0,128,158,0,200,156,21,
0,64,208,137,159,5,12,0,136,157,4,0,128,148,0,128,160,0,64,155,64,208,72,
159,8,64,208,128,154,0,64,158,64,208,128,157,0,73,164,9,207,64,208,128,
160,0,73,160,9,126,64,208,128,151,0,72,159,90,64,208,73,161,9,57,64,208,
128,156,0,137,157,5,16,0,72,152,8,64,208,128,163,0,128,148,0,136,160,4,
0,192,159,0,64,208,73,159,9,20,64,208,128,163,0,72,158,8,64,208,128,158,
0,128,156,0,128,160,0,137,165,5,25,0,200,163,9,0,64,208,128,148,0,64,162,
64,208,136,154,4,0,128,145,0,128,168,0,64,158,64,208,73,160,9,16,64,208,
128,148,0,136,158,4,0,128,154,0,136,166,4,0,128,162,0,72,162,28,64,208,
137,156,5,20,0,136,154,4,0,64,144,64,208,64,162,64,208,128,162,0,128,166,
0,64,161,64,208,137,159,5,16,0,137,146,5,8,0,128,145,0,128,156,0,201,162,
14,17,0,64,208,64,152,64,208,128,144,0,128,160,0,64,163,64,208,128,151,
0,73,168,9,44,64,208,128,157,0,72,166,20,64,208,73,158,9,12,64,208,128,
159,0,128,148,0,128,162,0,64,165,64,208,136,154,4,0,64,145,64,208,128,148,
0,192,173,0,64,208,72,159,13,64,208,192,159,0,64,208,128,144,0,128,154,
0,82,164,1,165,2,74,64,208,73,156,13,196,64,208,136,161,4,0,128,147,0,137,
148,5,98,0,201,145,10,49,0,64,208,128,168,0,72,144,32,64,208,137,159,5,
20,0,136,157,4,0,64,154,64,208,64,158,64,208,128,157,0,136,164,4,0,128,
161,0,64,134,64,208,128,145,0,200,147,17,0,64,208,64,161,64,208,64,151,
64,208,128,157,0,64,146,64,208,137,146,5,16,0,64,144,64,208,64,162,64,208,
128,162,0,64,163,64,208,128,161,0,137,153,5,52,0,72,152,40,64,208,73,154,
9,24,64,208,128,162,0,136,145,4,0,64,144,64,208,64,161,64,208,128,159,0,
136,164,4,0,64,156,64,208,128,145,0,64,149,64,208,128,134,0,136,155,4,0,
192,154,0,64,208,73,152,9,12,64,208,128,161,0,128,145,0,192,161,0,64,208,
64,152,64,208,128,162,0,201,162,22,170,0,64,208,137,152,5,12,0,136,148,
4,0,128,134,0,128,161,0,73,159,29,49,64,208,73,156,9,16,64,208,128,159,
0,136,155,4,0,128,154,0,136,162,4,0,128,161,0,136,158,4,0,192,157,0,64,
208,137,161,5,8,0,128,148,0,128,173,0,72,161,65,64,208,73,154,17,41,64,
208,72,158,8,64,208,128,157,0,128,157,0,73,151,9,16,64,208,128,157,0,136,
145,4,0,128,134,0,192,152,0,64,208,128,157,0,137,159,5,12,0,64,157,64,208,
128,159,0,64,161,64,208,128,159,0,192,160,0,64,208,201,158,10,26,0,64,208,
128,151,0,200,157,13,0,64,208,64,161,64,208,128,145,0,128,144,0,128,161,
0,73,173,21,40,64,208,137,152,5,12,0,64,145,64,208,128,161,0,128,154,0,
72,166,12,64,208,64,158,64,208,128,159,0,64,165,64,208,128,148,0,64,174,
64,208,128,152,0,64,163,64,208,73,159,9,79,64,208,128,152,0,137,148,5,33,
0,73,145,13,20,64,208,136,160,4,0,128,144,0,64,144,64,208,128,151,0,192,
147,0,64,208,128,146,0,201,154,14,25,0,64,208,136,173,4,0,128,156,0,64,
152,64,208,64,161,64,208,128,157,0,192,156,0,64,208,136,160,4,0,128,158,
0,73,163,17,66,64,208,64,154,64,208,64,162,64,208,128,161,0,201,161,26,
42,0,64,208,137,161,5,12,0,136,158,4,0,128,156,0,64,162,64,208,128,164,
0,192,160,0,64,208,72,162,8,64,208,128,173,0,128,147,0,64,162,64,208,128,
173,0,72,173,8,64,208,128,154,0,192,166,0,64,208,128,161,0,64,165,64,208,
73,155,9,28,64,208,128,163,0,137,151,5,16,0,136,150,4,0,64,149,64,208,128,
166,0,128,153,0,73,162,13,28,64,208,136,162,4,0,128,154,0,72,161,12,64,
208,64,159,64,208,128,167,0,128,156,0,64,165,64,208,128,144,0,74,173,218,
1,99,64,208,73,157,17,122,64,208,136,159,4,0,64,154,64,208,128,158,0,73,
152,9,53,64,208,128,162,0,73,147,13,37,64,208,136,165,4,0,128,161,0,200,
145,17,0,64,208,64,152,64,208,136,160,4,0,128,159,0,64,144,64,208,128,151,
0,64,148,64,208,128,157,0,201,155,18,33,0,64,208,136,151,4,0,64,145,64,
208,128,163,0,64,154,64,208,64,158,64,208,64,161,64,208,128,158,0,64,156,
64,208,72,152,12,64,208,64,152,64,208,128,162,0,128,151,0,73,161,29,65,
64,208,73,158,9,16,64,208,128,156,0,136,154,4,0,128,152,0,64,173,64,208,
128,158,0,73,159,9,20,64,208,128,160,0,64,158,64,208,64,158,64,208,128,
161,0,64,160,64,208,200,156,9,0,64,208,128,151,0,128,145,0,73,165,9,17,
64,208,128,154,0,192,163,0,64,208,128,154,0,64,166,64,208,128,157,0,73,
168,58,122,64,208,73,158,9,24,64,208,128,161,0,137,151,5,12,0,64,147,64,
208,128,157,0,128,156,0,137,160,5,20,0,64,159,64,208,137,160,5,8,0,128,
148,0,128,161,0,192,161,0,64,208,128,157,0,64,167,64,208,201,159,14,53,
0,64,208,136,163,4,0,128,158,0,72,157,28,64,208,72,159,8,64,208,128,160,
0,64,157,64,208,72,161,8,64,208,128,160,0,128,160,0,64,154,64,208,64,158,
64,208,128,156,0,136,173,4,0,128,160,0,64,169,64,208,137,159,5,8,0,128,
145,0,128,160,0,72,175,24,64,208,73,160,9,16,64,208,128,145,0,64,152,64,
208,128,164,0,128,166,0,64,174,64,208,73,160,9,12,64,208,128,159,0,128,
152,0,64,165,64,208,128,155,0,64,165,64,208,82,158,1,71,9,46,64,208,137,
158,5,216,0,73,153,13,136,64,208,64,144,64,208,128,157,0,73,147,13,64,64,
208,136,164,4,0,128,144,0,72,145,36,64,208,137,155,5,20,0,64,145,64,208,
64,152,64,208,64,162,64,208,128,171,0,64,158,64,208,64,148,64,208,128,161,
0,64,134,64,208,64,159,64,208,64,159,64,208,128,158,0,64,151,64,208,137,
155,5,32,0,72,145,16,64,208,64,155,64,208,64,158,64,208,128,154,0,64,144,
64,208,64,157,64,208,128,154,0,64,160,64,208,64,144,64,208,64,161,64,208,
64,167,64,208,64,149,64,208,128,162,0,73,155,21,36,64,208,64,152,64,208,
64,161,64,208,64,144,64,208,128,155,0,64,154,64,208,64,166,64,208,64,163,
64,208,128,157,0,64,157,64,208,64,156,64,208,72,152,20,64,208,72,157,8,
64,208,128,158,0,64,145,64,208,128,158,0,64,134,64,208,64,145,64,208,128,
158,0,73,164,37,80,64,208,73,157,13,28,64,208,64,159,64,208,128,144,0,72,
156,8,64,208,128,151,0,64,152,64,208,128,164,0,128,164,0,73,161,17,28,64,
208,72,161,8,64,208,128,156,0,128,155,0,64,159,64,208,136,161,4,0,128,151,
0,64,163,64,208,64,159,64,208,64,144,64,208,128,154,0,73,166,9,16,64,208,
128,151,0,64,165,64,208,128,155,0,64,175,64,208,128,162,0,202,150,28,3,
201,0,64,208,201,154,10,13,0,64,208,128,148,0,128,148,0,64,160,64,208,128,
158,0,210,147,1,42,3,26,0,64,208,73,159,30,200,64,208,137,152,5,8,0,128,
144,0,192,163,0,64,208,64,152,64,208,64,147,64,208,128,161,0,73,156,13,
142,64,208,136,163,4,0,128,152,0,73,151,17,98,64,208,72,146,8,64,208,128,
144,0,128,144,0,192,144,0,64,208,73,162,13,49,64,208,64,158,64,208,128,
159,0,137,154,5,28,0,72,148,16,64,208,72,162,8,64,208,128,163,0,128,152,
0,64,147,64,208,128,165,0,192,159,0,64,208,128,159,0,73,164,9,12,64,208,
128,154,0,128,163,0,64,173,64,208,136,159,4,0,64,152,64,208,128,159,0,64,
152,64,208,137,154,5,20,0,64,152,64,208,136,154,4,0,64,152,64,208,128,154,
0,64,164,64,208,128,154,0,136,158,4,0,192,157,0,64,208,72,162,8,64,208,
128,163,0,64,152,64,208,64,152,64,208,128,156,0,137,164,5,78,0,73,162,22,
37,64,208,192,163,0,64,208,64,161,64,208,136,165,4,0,128,144,0,64,161,64,
208,136,158,4,0,64,146,64,208,128,144,0,64,163,64,208,73,159,17,25,64,208,
136,162,4,0,64,152,64,208,128,162,0,192,152,0,64,208,128,157,0,64,162,64,
208,128,159,0,72,173,8,64,208,128,163,0,128,167,0,74,145,52,1,37,64,208,
201,159,14,25,0,64,208,64,162,64,208,128,164,0,137,154,5,8,0,128,147,0,
128,156,0,201,161,10,17,0,64,208,128,146,0,64,160,64,208,128,151,0,128,
164,0,64,144,64,208,73,155,9,101,64,208,128,147,0,73,149,9,40,64,208,128,
161,0,73,145,21,24,64,208,64,152,64,208,64,152,64,208,64,150,64,208,128,
162,0,128,134,0,64,148,64,208,128,162,0,201,152,10,13,0,64,208,128,162,
0,128,151,0,64,154,64,208,73,152,9,12,64,208,128,145,0,128,145,0,64,157,
64,208,64,152,64,208,64,152,64,208,64,175,64,208,64,155,64,208,128,152,
0,73,161,17,96,64,208,137,158,5,8,0,128,148,0,128,159,0,73,157,53,72,64,
208,72,162,40,64,208,64,171,64,208,64,156,64,208,64,144,64,208,64,157,64,
208,64,161,64,208,64,152,64,208,64,153,64,208,64,161,64,208,128,154,0,64,
157,64,208,128,154,0,64,156,64,208,136,155,4,0,64,144,64,208,64,161,64,
208,128,162,0,64,159,64,208,128,148,0,72,173,20,64,208,137,161,5,12,0,136,
154,4,0,128,151,0,128,173,0,64,162,64,208,137,159,5,13,0,192,158,0,64,208,
128,145,0,128,162,0,64,146,64,208,201,151,38,167,0,64,208,137,154,5,16,
0,64,146,64,208,64,159,64,208,128,158,0,64,158,64,208,136,162,4,0,64,156,
64,208,128,162,0,201,147,10,113,0,64,208,128,151,0,73,145,9,32,64,208,128,
157,0,64,144,64,208,72,154,8,64,208,128,163,0,64,152,64,208,64,146,64,208,
128,163,0,64,146,64,208,73,161,9,60,64,208,128,163,0,72,154,8,64,208,128,
163,0,64,144,64,208,73,154,13,20,64,208,64,163,64,208,128,161,0,64,152,
64,208,128,163,0,64,163,64,208,73,160,9,12,64,208,128,173,0,128,155,0,128,
161,0,64,163,64,208,128,162,0,200,149,9,0,64,208,128,159,0,64,148,64,208,
128,159,0,73,160,9,25,64,208,128,151,0,137,158,5,8,0,128,157,0,192,159,
0,64,208,128,163,0,136,163,4,0,128,161,0,72,149,12,64,208,64,147,64,208,
128,145,0,64,148,64,208,201,159,14,71,0,64,208,136,168,4,0,128,155,0,137,
155,5,36,0,72,151,8,64,208,128,159,0,64,144,64,208,73,148,9,16,64,208,128,
156,0,64,146,64,208,128,159,0,128,154,0,200,157,9,0,64,208,128,159,0,192,
156,0,64,208,136,163,4,0,128,134,0,73,162,25,49,64,208,64,163,64,208,72,
161,8,64,208,128,147,0,64,145,64,208,128,144,0,200,161,17,0,64,208,137,
156,5,8,0,128,144,0,128,160,0,64,160,64,208,128,148,0,64,163,64,208,64,
165,64,208,128,162,0,74,155,87,2,173,64,208,201,157,10,61,0,64,208,128,
159,0,73,149,29,44,64,208,64,145,64,208,64,158,64,208,64,145,64,208,64,
144,64,208,64,157,64,208,128,154,0,72,146,12,64,208,136,159,4,0,128,151,
0,128,145,0,64,150,64,208,128,154,0,137,161,5,16,0,64,159,64,208,136,163,
4,0,128,154,0,128,168,0,82,152,1,44,1,176,64,208,73,159,9,208,64,208,128,
166,0,73,152,25,72,64,208,73,154,9,16,64,208,128,161,0,64,147,64,208,128,
165,0,128,162,0,73,147,9,44,64,208,128,156,0,72,145,28,64,208,73,158,9,
20,64,208,128,159,0,136,156,4,0,64,152,64,208,128,156,0,128,161,0,64,144,
64,208,128,156,0,128,150,0,73,157,13,108,64,208,136,165,4,0,128,154,0,64,
156,64,208,73,164,13,56,64,208,64,144,64,208,128,154,0,72,160,32,64,208,
64,149,64,208,64,144,64,208,64,154,64,208,64,162,64,208,64,152,64,208,64,
146,64,208,128,171,0,64,149,64,208,64,161,64,208,128,165,0,72,173,12,64,
208,64,161,64,208,128,165,0,64,167,64,208,64,152,64,208,64,161,64,208,64,
162,64,208,64,154,64,208,128,144,0,64,158,64,208,136,159,4,0,64,148,64,
208,64,144,64,208,128,162,0,137,163,5,33,0,201,161,14,21,0,64,208,136,159,
4,0,128,152,0,64,160,64,208,128,173,0,64,162,64,208,128,146,0,73,165,17,
20,64,208,64,156,64,208,64,152,64,208,128,148,0,128,164,0,64,173,64,208,
73,160,17,20,64,208,64,158,64,208,64,152,64,208,128,156,0,128,152,0,64,
161,64,208,128,151,0,192,151,0,64,208,73,158,9,64,64,208,128,158,0,73,148,
9,28,64,208,128,159,0,137,145,5,12,0,64,144,64,208,128,161,0,64,146,64,
208,128,152,0,73,152,13,20,64,208,64,144,64,208,128,156,0,64,151,64,208,
128,160,0,64,154,64,208,128,146,0,137,164,5,44,0,73,161,17,20,64,208,136,
161,4,0,64,144,64,208,128,154,0,128,159,0,64,162,64,208,137,156,5,8,0,128,
148,0,64,161,64,208,128,168,0,72,173,12,64,208,136,162,4,0,128,144,0,64,
168,64,208,128,146,0,192,154,0,64,208,73,158,22,98,64,208,200,159,9,0,64,
208,128,159,0,64,152,64,208,128,161,0,73,152,17,48,64,208,72,157,8,64,208,
128,154,0,128,144,0,73,148,9,28,64,208,128,168,0,72,147,12,64,208,64,163,
64,208,128,159,0,64,145,64,208,128,156,0,128,151,0,201,156,18,21,0,64,208,
72,158,8,64,208,128,148,0,128,151,0,128,154,0,64,157,64,208,128,156,0,73,
164,9,28,64,208,128,145,0,137,162,5,16,0,64,161,64,208,64,144,64,208,128,
148,0,128,163,0,73,166,17,24,64,208,64,157,64,208,64,152,64,208,128,162,
0,64,165,64,208,128,155,0,64,173,64,208,64,159,64,208,128,154,0,72,157,
220,64,208,73,156,9,120,64,208,128,163,0,73,151,9,72,64,208,128,155,0,73,
148,9,56,64,208,128,159,0,64,144,64,208,73,156,9,32,64,208,128,147,0,72,
148,16,64,208,136,163,4,0,64,162,64,208,128,163,0,64,147,64,208,128,165,
0,136,163,4,0,64,162,64,208,128,163,0,64,149,64,208,128,163,0,136,154,4,
0,64,152,64,208,73,152,13,20,64,208,64,173,64,208,128,156,0,136,151,4,0,
128,145,0,64,165,64,208,64,164,64,208,128,152,0,73,162,22,50,64,208,192,
163,0,64,208,64,161,64,208,136,165,4,0,128,147,0,201,159,14,17,0,64,208,
136,163,4,0,128,151,0,128,158,0,64,161,64,208,136,160,4,0,128,154,0,72,
173,8,64,208,128,163,0,192,163,0,64,208,73,152,13,24,64,208,64,146,64,208,
128,154,0,64,146,64,208,136,161,4,0,128,148,0,192,160,0,64,208,128,173,
0,64,156,64,208,73,156,13,69,64,208,136,160,4,0,128,152,0,137,150,5,40,
0,137,145,5,24,0,64,144,64,208,73,159,9,12,64,208,128,158,0,128,158,0,128,
164,0,64,147,64,208,64,156,64,208,128,152,0,201,154,10,13,0,64,208,128,
154,0,128,151,0,128,155,0,73,161,13,40,64,208,136,163,4,0,128,154,0,73,
159,17,24,64,208,72,158,8,64,208,128,159,0,128,157,0,64,157,64,208,128,
154,0,128,160,0,201,163,14,29,0,64,208,64,160,64,208,128,159,0,64,162,64,
208,72,173,8,64,208,128,175,0,128,159,0,64,173,64,208,128,147,0,202,165,
27,2,131,0,64,208,137,161,5,16,0,72,159,8,64,208,128,152,0,128,157,0,128,
166,0,74,162,244,2,0,64,208,73,157,25,127,64,208,137,147,5,8,0,128,146,
0,64,160,64,208,64,154,64,208,128,156,0,201,152,22,62,0,64,208,137,162,
5,12,0,64,152,64,208,128,173,0,128,173,0,73,147,13,37,64,208,136,152,4,
0,128,151,0,72,146,13,64,208,192,156,0,64,208,128,161,0,64,145,64,208,64,
144,64,208,128,161,0,128,151,0,137,155,5,17,0,192,154,0,64,208,64,173,64,
208,128,156,0,64,156,64,208,137,156,5,16,0,64,152,64,208,64,173,64,208,
128,162,0,128,158,0,73,162,18,87,64,208,200,163,9,0,64,208,128,156,0,128,
156,0,73,160,13,61,64,208,136,173,4,0,128,158,0,200,159,17,0,64,208,136,
173,4,0,64,157,64,208,128,147,0,64,158,64,208,73,159,9,20,64,208,128,159,
0,72,158,8,64,208,128,161,0,128,146,0,64,161,64,208,128,144,0,192,161,0,
64,208,128,154,0,137,164,5,16,0,64,163,64,208,64,160,64,208,128,173,0,64,
173,64,208,128,175,0,73,160,113,211,64,208,73,158,9,56,64,208,128,155,0,
73,146,9,24,64,208,128,154,0,72,145,8,64,208,128,161,0,64,144,64,208,128,
161,0,136,155,4,0,64,154,64,208,72,166,12,64,208,64,161,64,208,128,161,
0,128,156,0,73,162,13,32,64,208,136,162,4,0,128,147,0,72,161,8,64,208,128,
163,0,64,159,64,208,136,155,4,0,128,151,0,72,166,16,64,208,64,158,64,208,
64,154,64,208,128,158,0,128,164,0,64,159,64,208,137,157,5,38,0,137,151,
5,17,0,136,149,4,0,192,146,0,64,208,128,165,0,200,154,13,0,64,208,136,163,
4,0,128,154,0,128,152,0,73,167,17,49,64,208,64,157,64,208,64,165,64,208,
128,156,0,72,161,16,64,208,136,168,4,0,64,160,64,208,128,158,0,192,158,
0,64,208,64,159,64,208,64,144,64,208,128,162,0,64,173,64,208,128,162,0,
64,161,64,208,201,157,10,38,0,64,208,128,159,0,201,151,10,17,0,64,208,128,
160,0,64,149,64,208,128,134,0,64,156,64,208,136,157,4,0,128,155,0,137,161,
5,8,0,128,160,0,64,173,64,208,128,152,0,72,164,40,64,208,73,162,17,28,64,
208,72,163,8,64,208,128,162,0,128,152,0,72,159,8,64,208,128,157,0,128,155,
0,64,173,64,208,128,152,0,64,163,64,208,73,159,9,40,64,208,128,161,0,72,
148,16,64,208,64,160,64,208,64,163,64,208,128,154,0,64,146,64,208,136,161,
4,0,64,146,64,208,128,161,0,72,175,13,64,208,192,154,0,64,208,128,144,0,
64,163,64,208,128,159,0,201,173,74,155,0,64,208,73,161,9,52,64,208,128,
160,0,73,156,9,32,64,208,128,151,0,72,155,16,64,208,72,154,8,64,208,128,
158,0,128,151,0,64,147,64,208,128,161,0,64,159,64,208,136,163,4,0,128,152,
0,137,163,5,12,0,64,162,64,208,128,152,0,128,166,0,201,167,10,66,0,64,208,
128,164,0,192,166,0,64,208,137,156,5,32,0,73,147,13,20,64,208,136,152,4,
0,128,145,0,64,145,64,208,128,154,0,64,154,64,208,128,145,0,72,161,12,64,
208,136,159,4,0,128,156,0,64,158,64,208,128,154,0,64,168,64,208,72,168,
8,64,208,128,166,0,128,158,0,72,175,8,64,208,128,161,0,64,174,64,208,128,
151,0,82,173,13,130,31,53,80,208,13,121,74,158,91,7,254,64,208,201,160,
10,39,0,64,208,128,158,0,73,156,9,21,64,208,128,151,0,200,154,9,0,64,208,
128,161,0,128,148,0,192,159,0,64,208,128,160,0,73,164,9,42,64,208,128,164,
0,200,163,18,0,64,208,200,161,9,0,64,208,128,157,0,128,160,0,64,161,64,
208,72,159,8,64,208,128,160,0,128,154,0,128,166,0,74,150,30,2,39,64,208,
137,160,5,20,0,72,152,12,64,208,64,154,64,208,128,165,0,128,148,0,128,161,
0,74,147,122,1,149,64,208,73,160,9,74,64,208,128,148,0,73,156,9,32,64,208,
128,154,0,72,152,12,64,208,136,160,4,0,128,154,0,64,148,64,208,136,161,
4,0,128,144,0,200,159,18,0,64,208,200,159,9,0,64,208,128,154,0,128,144,
0,64,158,64,208,136,161,4,0,64,157,64,208,128,162,0,201,164,10,38,0,64,
208,128,152,0,72,162,8,64,208,128,148,0,192,161,0,64,208,72,161,12,64,208,
64,168,64,208,128,158,0,128,160,0,128,165,0,73,145,86,191,64,208,137,157,
5,44,0,73,154,13,28,64,208,136,154,4,0,128,146,0,136,150,4,0,64,148,64,
208,64,159,64,208,128,152,0,64,156,64,208,136,159,4,0,128,154,0,201,163,
10,33,0,64,208,128,148,0,72,162,8,64,208,128,160,0,64,160,64,208,72,156,
8,64,208,128,159,0,128,154,0,128,166,0,64,144,64,208,137,160,5,57,0,137,
157,5,28,0,73,146,17,20,64,208,72,160,8,64,208,128,158,0,128,156,0,128,
144,0,128,152,0,72,159,21,64,208,200,166,13,0,64,208,64,154,64,208,128,
159,0,128,163,0,128,158,0,73,163,9,24,64,208,128,161,0,72,162,8,64,208,
128,161,0,64,161,64,208,128,158,0,72,166,12,64,208,64,147,64,208,128,159,
0,192,164,0,64,208,128,163,0,64,146,64,208,137,156,5,65,0,73,147,13,49,
64,208,64,162,64,208,128,148,0,200,146,13,0,64,208,136,163,4,0,128,154,
0,64,144,64,208,137,162,5,12,0,64,150,64,208,128,148,0,64,163,64,208,128,
155,0,136,151,4,0,64,150,64,208,128,148,0,137,162,5,16,0,136,161,4,0,64,
160,64,208,128,151,0,64,166,64,208,128,156,0,72,149,12,64,208,64,155,64,
208,128,166,0,64,148,64,208,137,158,5,56,0,73,152,17,28,64,208,64,164,64,
208,64,144,64,208,128,160,0,72,151,8,64,208,128,148,0,128,148,0,72,156,
12,64,208,136,168,4,0,128,159,0,64,154,64,208,136,148,4,0,128,146,0,73,
163,17,41,64,208,136,156,4,0,64,146,64,208,128,162,0,200,161,17,0,64,208,
137,163,5,8,0,128,160,0,128,164,0,64,159,64,208,128,157,0,128,164,0,82,
155,1,24,3,202,64,208,73,158,13,200,64,208,136,163,4,0,128,154,0,73,149,
149,168,64,208,72,159,8,64,208,128,161,0,64,154,64,208,72,162,124,64,208,
64,160,64,208,64,158,64,208,72,158,28,64,208,64,168,64,208,64,149,64,208,
64,153,64,208,64,157,64,208,64,152,64,208,128,154,0,64,154,64,208,73,157,
17,32,64,208,64,152,64,208,64,147,64,208,128,152,0,64,144,64,208,64,156,
64,208,64,152,64,208,128,157,0,64,158,64,208,72,162,12,64,208,64,149,64,
208,128,155,0,64,157,64,208,64,146,64,208,64,149,64,208,64,154,64,208,64,
162,64,208,64,158,64,208,64,160,64,208,128,171,0,64,158,64,208,128,156,
0,137,146,5,16,0,64,144,64,208,136,160,4,0,128,151,0,128,148,0,72,155,12,
64,208,64,145,64,208,128,160,0,64,154,64,208,128,162,0,201,162,18,57,0,
64,208,64,149,64,208,64,151,64,208,128,144,0,72,161,32,64,208,64,152,64,
208,73,156,13,16,64,208,64,149,64,208,128,160,0,128,145,0,64,173,64,208,
128,155,0,64,159,64,208,128,156,0,72,175,8,64,208,128,163,0,64,173,64,208,
128,154,0,73,152,108,203,64,208,137,156,5,53,0,73,146,9,24,64,208,128,161,
0,136,145,4,0,64,144,64,208,64,164,64,208,128,163,0,72,154,16,64,208,137,
159,5,8,0,128,144,0,128,162,0,192,152,0,64,208,128,156,0,201,161,18,37,
0,64,208,72,157,8,64,208,128,151,0,128,154,0,72,158,8,64,208,128,159,0,
64,157,64,208,136,162,4,0,128,150,0,200,163,9,0,64,208,128,159,0,128,162,
0,64,151,64,208,137,159,5,52,0,73,154,9,24,64,208,128,161,0,72,148,8,64,
208,128,159,0,64,147,64,208,128,145,0,72,158,16,64,208,136,154,4,0,64,152,
64,208,128,161,0,64,157,64,208,128,159,0,137,164,5,32,0,72,162,20,64,208,
137,156,5,12,0,64,144,64,208,128,145,0,128,164,0,64,161,64,208,128,158,
0,64,165,64,208,128,156,0,64,154,64,208,201,156,10,109,0,64,208,128,159,
0,73,151,9,52,64,208,128,155,0,73,146,9,36,64,208,128,156,0,72,145,12,64,
208,136,154,4,0,128,147,0,64,144,64,208,136,158,4,0,64,148,64,208,128,146,
0,64,148,64,208,128,161,0,73,154,13,32,64,208,136,160,4,0,128,144,0,64,
152,64,208,137,161,5,12,0,64,148,64,208,128,144,0,128,162,0,64,155,64,208,
136,151,4,0,64,144,64,208,128,154,0,74,161,86,1,98,64,208,73,154,17,40,
64,208,64,158,64,208,64,157,64,208,128,162,0,64,152,64,208,64,156,64,208,
64,145,64,208,64,144,64,208,64,157,64,208,128,154,0,64,159,64,208,72,158,
28,64,208,64,154,64,208,64,144,64,208,64,156,64,208,64,149,64,208,64,160,
64,208,128,144,0,64,157,64,208,128,145,0,73,158,242,253,64,208,73,159,53,
156,64,208,64,144,64,208,72,161,20,64,208,64,159,64,208,64,158,64,208,64,
160,64,208,128,162,0,64,160,64,208,64,154,64,208,64,158,64,208,64,146,64,
208,64,158,64,208,128,154,0,73,156,49,80,64,208,72,158,36,64,208,64,157,
64,208,64,152,64,208,64,162,64,208,64,158,64,208,64,160,64,208,64,152,64,
208,64,157,64,208,128,147,0,64,149,64,208,128,157,0,72,152,12,64,208,64,
159,64,208,128,173,0,64,144,64,208,64,163,64,208,64,148,64,208,64,152,64,
208,128,162,0,64,157,64,208,64,158,64,208,64,156,64,208,64,164,64,208,64,
144,64,208,128,154,0,73,162,49,65,64,208,73,160,17,24,64,208,64,158,64,
208,64,159,64,208,128,171,0,64,158,64,208,128,159,0,64,163,64,208,64,160,
64,208,64,152,64,208,64,151,64,208,128,156,0,64,161,64,208,192,158,0,64,
208,136,161,4,0,128,154,0,64,164,64,208,64,158,64,208,64,157,64,208,128,
148,0,64,157,64,208,64,152,64,208,128,161,0,64,160,64,208,137,156,5,8,0,
128,145,0,128,162,0,137,165,5,17,0,192,164,0,64,208,64,144,64,208,128,154,
0,128,166,0,72,157,228,64,208,73,156,13,160,64,208,136,164,4,0,128,162,
0,73,148,53,100,64,208,64,158,64,208,72,163,12,64,208,64,151,64,208,128,
152,0,64,146,64,208,64,144,64,208,64,154,64,208,64,158,64,208,64,162,64,
208,64,160,64,208,64,158,64,208,128,157,0,73,146,13,40,64,208,136,157,4,
0,128,152,0,72,145,8,64,208,128,161,0,64,144,64,208,73,160,9,12,64,208,
128,162,0,128,154,0,128,161,0,64,147,64,208,128,155,0,73,154,25,44,64,208,
137,147,5,12,0,64,146,64,208,128,148,0,64,158,64,208,128,147,0,64,152,64,
208,137,157,5,12,0,64,156,64,208,128,161,0,128,166,0,128,155,0,73,162,9,
48,64,208,128,166,0,73,159,25,32,64,208,73,161,9,16,64,208,128,158,0,136,
159,4,0,128,152,0,128,164,0,64,158,64,208,128,145,0,64,160,64,208,128,173,
0,137,167,5,8,0,128,166,0,64,174,64,208,128,154,0,64,156,64,208,201,159,
22,113,0,64,208,72,160,8,64,208,128,144,0,64,152,64,208,128,175,0,201,152,
14,47,0,64,208,64,160,64,208,128,161,0,201,146,14,26,0,64,208,64,158,64,
208,128,161,0,192,144,0,64,208,136,159,4,0,128,144,0,64,151,64,208,128,
163,0,73,156,17,33,64,208,136,166,4,0,64,152,64,208,128,156,0,192,154,0,
64,208,136,164,4,0,64,144,64,208,128,160,0,64,158,64,208,64,155,64,208,
128,162,0,73,164,9,66,64,208,128,144,0,73,162,25,41,64,208,137,159,5,12,
0,136,158,4,0,128,152,0,64,173,64,208,128,155,0,192,161,0,64,208,136,165,
4,0,64,163,64,208,128,148,0,64,163,64,208,200,160,9,0,64,208,128,163,0,
128,159,0,137,168,5,12,0,64,165,64,208,128,158,0,64,175,64,208,136,164,
4,0,128,147,0,74,165,50,4,129,64,208,137,151,5,24,0,137,147,5,12,0,64,146,
64,208,128,167,0,64,148,64,208,128,151,0,72,160,8,64,208,128,146,0,64,156,
64,208,136,158,4,0,128,151,0,74,162,138,3,118,64,208,201,159,18,71,0,64,
208,137,159,5,8,0,128,154,0,128,162,0,137,155,5,33,0,201,151,10,17,0,64,
208,128,159,0,64,145,64,208,128,173,0,64,154,64,208,136,161,4,0,128,159,
0,200,157,9,0,64,208,128,173,0,64,156,64,208,136,158,4,0,128,146,0,73,162,
17,45,64,208,136,159,4,0,64,158,64,208,128,159,0,200,161,13,0,64,208,64,
158,64,208,128,148,0,64,160,64,208,136,146,4,0,64,144,64,208,128,157,0,
72,173,8,64,208,128,154,0,64,163,64,208,128,161,0,74,160,224,1,175,64,208,
73,158,69,146,64,208,73,156,25,48,64,208,64,144,64,208,64,161,64,208,64,
161,64,208,64,144,64,208,128,150,0,72,154,20,64,208,64,155,64,208,64,152,
64,208,64,159,64,208,128,171,0,128,144,0,64,164,64,208,64,158,64,208,64,
162,64,208,128,158,0,201,148,10,61,0,64,208,128,163,0,73,146,25,44,64,208,
137,156,5,16,0,136,154,4,0,64,152,64,208,128,161,0,128,163,0,64,144,64,
208,64,154,64,208,64,158,64,208,64,157,64,208,128,148,0,64,147,64,208,128,
157,0,200,156,9,0,64,208,128,151,0,64,154,64,208,128,158,0,73,162,13,60,
64,208,64,158,64,208,128,161,0,72,161,32,64,208,73,159,9,24,64,208,128,
158,0,72,156,8,64,208,128,158,0,64,147,64,208,128,160,0,128,162,0,64,159,
64,208,136,159,4,0,64,144,64,208,128,161,0,136,173,4,0,64,163,64,208,128,
147,0,64,159,64,208,201,160,18,147,0,64,208,72,158,8,64,208,128,157,0,128,
144,0,73,152,57,93,64,208,73,159,9,20,64,208,128,148,0,136,156,4,0,64,147,
64,208,128,157,0,136,163,4,0,64,161,64,208,64,152,64,208,64,157,64,208,
64,148,64,208,64,160,64,208,64,158,64,208,128,156,0,137,146,5,28,0,136,
145,4,0,64,144,64,208,137,156,5,12,0,136,146,4,0,128,145,0,128,161,0,192,
148,0,64,208,128,156,0,73,156,13,21,64,208,136,154,4,0,128,151,0,192,154,
0,64,208,128,145,0,64,159,64,208,136,167,4,0,64,151,64,208,128,163,0,73,
165,9,33,64,208,128,165,0,137,163,5,21,0,72,162,8,64,208,128,154,0,192,
161,0,64,208,128,152,0,128,164,0,137,168,5,16,0,64,166,64,208,64,156,64,
208,128,159,0,64,173,64,208,128,158,0,64,161,64,208,201,158,26,155,0,64,
208,137,148,5,16,0,64,145,64,208,64,149,64,208,128,155,0,128,157,0,73,154,
57,84,64,208,137,158,5,32,0,137,145,5,24,0,64,144,64,208,72,162,8,64,208,
128,158,0,64,148,64,208,128,158,0,128,148,0,73,160,13,16,64,208,64,152,
64,208,128,157,0,128,159,0,128,173,0,73,149,9,16,64,208,128,152,0,64,146,
64,208,128,162,0,64,152,64,208,136,159,4,0,128,148,0,73,156,18,21,64,208,
192,162,0,64,208,136,161,4,0,128,154,0,128,155,0,192,157,0,64,208,72,162,
8,64,208,128,152,0,64,160,64,208,64,159,64,208,128,166,0,201,162,22,102,
0,64,208,72,156,8,64,208,128,144,0,64,144,64,208,128,160,0,201,160,18,53,
0,64,208,137,157,5,8,0,128,146,0,128,175,0,64,159,64,208,73,159,9,20,64,
208,128,160,0,136,154,4,0,64,151,64,208,128,163,0,136,166,4,0,64,160,64,
208,128,152,0,64,161,64,208,137,159,5,16,0,136,155,4,0,64,146,64,208,128,
158,0,136,175,4,0,128,160,0,73,165,13,49,64,208,136,148,4,0,128,144,0,64,
163,64,208,137,155,5,20,0,137,151,5,8,0,128,148,0,64,154,64,208,128,148,
0,200,159,9,0,64,208,128,159,0,128,157,0,64,173,64,208,128,163,0,72,164,
98,64,208,73,159,13,53,64,208,64,159,64,208,128,163,0,73,156,9,21,64,208,
128,147,0,136,154,4,0,192,151,0,64,208,128,154,0,72,158,12,64,208,64,145,
64,208,128,152,0,64,157,64,208,128,158,0,73,166,13,29,64,208,64,149,64,
208,128,162,0,200,163,13,0,64,208,64,152,64,208,128,163,0,128,161,0,64,
173,64,208,64,161,64,208,128,154,0,64,163,64,208,137,157,5,66,0,137,152,
5,32,0,73,148,9,20,64,208,128,165,0,64,146,64,208,136,162,4,0,128,155,0,
64,151,64,208,128,152,0,200,156,26,0,64,208,137,160,5,17,0,136,159,4,0,
192,154,0,64,208,128,148,0,128,161,0,128,154,0,137,161,5,38,0,201,159,14,
25,0,64,208,136,161,4,0,128,159,0,64,158,64,208,64,157,64,208,128,152,0,
192,160,0,64,208,128,163,0,136,163,4,0,64,162,64,208,128,160,0,73,168,45,
178,64,208,137,159,5,28,0,73,154,9,20,64,208,128,155,0,64,146,64,208,64,
161,64,208,128,156,0,128,158,0,137,162,5,8,0,128,161,0,128,163,0,72,167,
50,64,208,201,161,10,25,0,64,208,128,160,0,137,151,5,12,0,64,144,64,208,
128,175,0,128,159,0,72,163,12,64,208,64,162,64,208,128,158,0,192,162,0,
64,208,128,154,0,192,166,0,64,208,201,157,19,55,0,64,208,200,156,9,0,64,
208,128,154,0,128,148,0,201,148,18,29,0,64,208,64,174,64,208,64,162,64,
208,128,173,0,136,147,4,0,64,146,64,208,128,156,0,64,154,64,208,128,167,
0,73,161,9,16,64,208,128,159,0,136,160,4,0,128,159,0,64,163,64,208,128,
156,0,72,174,8,64,208,128,154,0,64,173,64,208,137,158,5,32,0,73,146,9,16,
64,208,128,160,0,64,144,64,208,128,162,0,64,156,64,208,64,156,64,208,128,
152,0,137,161,5,16,0,64,159,64,208,64,160,64,208,128,165,0,192,162,0,64,
208,128,161,0,128,84,0,82,168,6,127,16,195,64,208,74,158,42,3,242,64,208,
73,159,9,28,64,208,128,154,0,137,149,5,12,0,64,146,64,208,128,161,0,64,
151,64,208,128,150,0,136,162,4,0,128,161,0,74,151,67,1,250,64,208,73,160,
9,36,64,208,128,168,0,73,158,17,20,64,208,136,154,4,0,64,152,64,208,128,
154,0,128,147,0,64,159,64,208,128,152,0,73,165,9,21,64,208,128,160,0,192,
161,0,64,208,136,156,4,0,128,144,0,128,168,0,74,146,116,1,69,64,208,201,
159,10,62,0,64,208,128,161,0,73,146,9,24,64,208,128,156,0,72,145,8,64,208,
128,161,0,64,144,64,208,128,154,0,200,155,9,0,64,208,128,159,0,64,149,64,
208,64,153,64,208,64,156,64,208,64,144,64,208,128,168,0,73,162,9,24,64,
208,128,161,0,72,161,8,64,208,128,156,0,64,160,64,208,128,161,0,72,173,
12,64,208,64,157,64,208,128,161,0,64,163,64,208,64,147,64,208,128,159,0,
73,144,145,156,64,208,73,160,57,92,64,208,136,161,4,0,64,152,64,208,64,
154,64,208,64,158,64,208,64,159,64,208,64,158,64,208,64,148,64,208,64,168,
64,208,64,152,64,208,64,159,64,208,64,157,64,208,64,152,64,208,128,154,
0,137,155,5,20,0,72,146,8,64,208,128,160,0,64,144,64,208,128,151,0,72,158,
8,64,208,128,157,0,64,156,64,208,128,162,0,73,164,9,24,64,208,128,164,0,
72,163,8,64,208,128,151,0,64,161,64,208,128,161,0,64,165,64,208,64,160,
64,208,64,163,64,208,64,154,64,208,64,165,64,208,128,144,0,64,134,64,208,
64,151,64,208,128,158,0,64,145,64,208,201,158,10,30,0,64,208,128,163,0,
137,155,5,17,0,136,150,4,0,192,148,0,64,208,128,156,0,128,156,0,137,162,
5,12,0,64,159,64,208,128,152,0,64,164,64,208,128,160,0,200,148,70,0,64,
208,137,159,5,33,0,137,152,5,12,0,136,147,4,0,128,144,0,136,156,4,0,192,
154,0,64,208,64,160,64,208,128,152,0,73,163,9,24,64,208,128,159,0,136,161,
4,0,64,160,64,208,64,165,64,208,128,165,0,64,165,64,208,128,165,0,64,147,
64,208,73,159,13,29,64,208,136,163,4,0,128,152,0,200,157,9,0,64,208,128,
163,0,64,154,64,208,128,156,0,136,162,4,0,64,161,64,208,128,159,0,74,155,
114,1,45,64,208,73,157,9,80,64,208,128,158,0,72,152,68,64,208,64,164,64,
208,72,156,24,64,208,64,144,64,208,64,168,64,208,64,152,64,208,64,157,64,
208,128,144,0,64,155,64,208,72,152,16,64,208,64,161,64,208,64,162,64,208,
128,171,0,64,149,64,208,64,157,64,208,64,162,64,208,128,171,0,128,151,0,
64,174,64,208,64,159,64,208,64,145,64,208,64,144,64,208,64,155,64,208,64,
154,64,208,128,144,0,72,154,62,64,208,73,152,9,33,64,208,128,148,0,201,
147,10,17,0,64,208,128,159,0,64,146,64,208,128,161,0,64,148,64,208,128,
159,0,201,156,18,21,0,64,208,72,162,8,64,208,128,160,0,128,147,0,128,155,
0,128,158,0,64,152,64,208,73,158,9,40,64,208,128,148,0,73,152,9,24,64,208,
128,154,0,72,151,8,64,208,128,158,0,64,145,64,208,128,159,0,136,156,4,0,
128,154,0,73,162,13,58,64,208,64,166,64,208,128,163,0,200,161,18,0,64,208,
136,159,4,0,192,145,0,64,208,128,160,0,64,160,64,208,64,159,64,208,64,158,
64,208,64,162,64,208,64,160,64,208,64,149,64,208,128,145,0,64,165,64,208,
64,163,64,208,64,144,64,208,64,157,64,208,64,148,64,208,128,152,0,72,157,
37,64,208,73,158,9,24,64,208,128,163,0,72,152,12,64,208,64,146,64,208,128,
144,0,128,145,0,192,159,0,64,208,128,151,0,64,156,64,208,73,154,9,72,64,
208,128,154,0,73,149,21,44,64,208,64,156,64,208,64,144,64,208,64,157,64,
208,128,144,0,73,145,9,16,64,208,128,145,0,64,144,64,208,128,161,0,64,146,
64,208,128,160,0,72,152,16,64,208,136,159,4,0,64,144,64,208,128,154,0,128,
150,0,137,164,5,25,0,137,158,5,8,0,128,155,0,192,159,0,64,208,64,154,64,
208,128,165,0,72,173,16,64,208,137,152,5,8,0,128,151,0,128,156,0,64,165,
64,208,128,165,0,74,164,64,2,58,64,208,73,159,9,34,64,208,128,158,0,201,
156,10,22,0,64,208,128,156,0,200,155,9,0,64,208,128,163,0,128,144,0,128,
157,0,73,162,9,16,64,208,128,163,0,64,161,64,208,128,158,0,64,173,64,208,
128,154,0,73,161,45,232,64,208,73,157,9,20,64,208,128,163,0,72,156,8,64,
208,128,163,0,128,148,0,72,162,8,64,208,128,156,0,64,158,64,208,64,154,
64,208,128,158,0,72,160,81,64,208,137,160,5,49,0,201,156,10,33,0,64,208,
128,151,0,72,154,16,64,208,136,166,4,0,64,162,64,208,128,173,0,64,144,64,
208,128,159,0,72,159,8,64,208,128,155,0,128,157,0,137,167,5,24,0,72,163,
16,64,208,137,161,5,8,0,128,148,0,128,173,0,128,161,0,128,175,0,64,159,
64,208,73,155,9,61,64,208,128,161,0,201,148,10,37,0,64,208,128,152,0,137,
145,5,24,0,64,144,64,208,64,160,64,208,64,167,64,208,64,144,64,208,128,
157,0,128,147,0,72,152,12,64,208,64,160,64,208,128,173,0,128,151,0,73,160,
9,30,64,208,128,156,0,200,159,9,0,64,208,128,154,0,192,156,0,64,208,64,
159,64,208,128,154,0,136,163,4,0,64,161,64,208,128,163,0,72,163,90,64,208,
73,158,9,45,64,208,128,162,0,73,156,9,28,64,208,128,156,0,72,154,8,64,208,
128,161,0,64,146,64,208,64,159,64,208,128,157,0,192,157,0,64,208,128,158,
0,73,163,13,33,64,208,64,160,64,208,128,147,0,200,160,9,0,64,208,128,161,
0,64,159,64,208,136,162,4,0,128,157,0,64,168,64,208,128,163,0,64,162,64,
208,73,160,98,157,64,208,73,152,54,89,64,208,64,165,64,208,64,154,64,208,
64,158,64,208,192,148,0,64,208,64,152,64,208,64,160,64,208,64,158,64,208,
64,146,64,208,64,144,64,208,64,157,64,208,64,152,64,208,128,149,0,64,144,
64,208,64,164,64,208,64,161,64,208,64,162,64,208,64,158,64,208,64,175,64,
208,64,157,64,208,64,154,64,208,128,152,0,128,160,0,73,152,13,52,64,208,
64,145,64,208,128,158,0,72,146,8,64,208,128,158,0,64,144,64,208,64,157,
64,208,64,166,64,208,64,164,64,208,64,158,64,208,64,160,64,208,64,156,64,
208,128,171,0,64,158,64,208,128,148,0,73,163,9,12,64,208,128,160,0,128,
161,0,64,173,64,208,136,158,4,0,128,156,0,73,169,9,40,64,208,128,166,0,
72,168,8,64,208,128,154,0,64,166,64,208,72,162,8,64,208,128,158,0,64,161,
64,208,64,152,64,208,128,158,0,72,174,20,64,208,137,162,5,12,0,136,154,
4,0,128,150,0,128,164,0,64,173,64,208,137,155,5,8,0,128,151,0,128,168,0,
64,167,64,208,74,158,187,6,191,64,208,73,154,17,117,64,208,137,147,5,8,
0,128,145,0,128,166,0,137,147,5,64,0,73,144,25,40,64,208,72,157,12,64,208,
64,160,64,208,128,152,0,64,154,64,208,128,145,0,64,134,64,208,64,159,64,
208,64,159,64,208,128,158,0,64,146,64,208,64,161,64,208,64,152,64,208,64,
161,64,208,128,161,0,73,151,13,25,64,208,64,152,64,208,128,159,0,192,148,
0,64,208,64,154,64,208,128,145,0,64,152,64,208,64,148,64,208,128,160,0,
137,159,5,28,0,73,156,9,20,64,208,128,151,0,64,155,64,208,64,148,64,208,
128,159,0,128,158,0,73,164,17,28,64,208,64,158,64,208,64,156,64,208,128,
161,0,64,163,64,208,64,157,64,208,128,145,0,64,174,64,208,128,145,0,74,
150,10,3,132,64,208,128,161,0,82,147,1,5,2,113,64,208,201,159,35,188,0,
64,208,137,154,5,16,0,136,152,4,0,64,147,64,208,128,162,0,192,163,0,64,
208,64,152,64,208,128,162,0,73,154,9,118,64,208,128,158,0,73,147,9,42,64,
208,128,154,0,192,144,0,64,208,73,154,14,25,64,208,192,152,0,64,208,128,
152,0,72,152,8,64,208,128,163,0,128,144,0,128,163,0,192,152,0,64,208,137,
156,5,30,0,201,152,10,17,0,64,208,128,154,0,64,147,64,208,128,157,0,192,
154,0,64,208,128,152,0,72,173,16,64,208,136,163,4,0,64,152,64,208,128,163,
0,64,164,64,208,192,154,0,64,208,64,152,64,208,128,161,0,72,157,16,64,208,
64,161,64,208,64,159,64,208,128,158,0,64,156,64,208,137,154,5,12,0,136,
152,4,0,128,144,0,128,158,0,73,162,9,45,64,208,128,163,0,72,161,24,64,208,
137,161,5,12,0,136,148,4,0,128,144,0,64,165,64,208,128,144,0,192,160,0,
64,208,64,162,64,208,128,161,0,72,165,8,64,208,128,156,0,192,163,0,64,208,
64,173,64,208,128,161,0,201,145,43,195,0,64,208,73,161,13,25,64,208,136,
165,4,0,128,159,0,200,160,9,0,64,208,128,160,0,128,148,0,136,168,4,0,64,
162,64,208,128,160,0,64,144,64,208,73,156,9,81,64,208,128,151,0,73,149,
9,48,64,208,128,161,0,73,146,9,24,64,208,128,158,0,64,145,64,208,64,144,
64,208,64,157,64,208,128,172,0,64,148,64,208,136,173,4,0,64,155,64,208,
128,146,0,72,154,8,64,208,128,164,0,192,151,0,64,208,72,162,8,64,208,128,
158,0,128,157,0,73,161,25,48,64,208,72,161,8,64,208,128,160,0,64,154,64,
208,64,158,64,208,128,160,0,72,159,20,64,208,72,163,12,64,208,64,145,64,
208,128,158,0,128,146,0,128,158,0,72,173,8,64,208,128,161,0,64,162,64,208,
136,162,4,0,128,151,0,64,146,64,208,73,156,13,130,64,208,136,163,4,0,128,
147,0,73,152,18,114,64,208,64,152,64,208,192,160,0,64,208,128,173,0,72,
146,88,64,208,73,154,13,76,64,208,64,163,64,208,128,161,0,72,152,16,64,
208,64,163,64,208,64,160,64,208,128,173,0,64,144,64,208,73,154,21,32,64,
208,72,163,8,64,208,128,168,0,64,152,64,208,128,163,0,64,152,64,208,136,
168,4,0,128,163,0,64,163,64,208,136,168,4,0,128,155,0,64,156,64,208,128,
163,0,192,144,0,64,208,128,152,0,128,154,0,73,161,17,24,64,208,64,158,64,
208,64,158,64,208,128,157,0,136,159,4,0,128,157,0,64,162,64,208,64,154,
64,208,128,163,0,72,149,168,64,208,73,151,21,60,64,208,64,144,64,208,64,
160,64,208,64,158,64,208,128,156,0,72,148,8,64,208,128,160,0,64,147,64,
208,72,173,8,64,208,128,161,0,64,149,64,208,64,146,64,208,64,144,64,208,
64,160,64,208,128,144,0,72,160,28,64,208,64,156,64,208,137,154,5,16,0,64,
149,64,208,64,162,64,208,128,144,0,128,158,0,64,155,64,208,73,147,17,24,
64,208,136,163,4,0,64,156,64,208,128,144,0,64,144,64,208,128,154,0,64,175,
64,208,64,145,64,208,64,154,64,208,64,158,64,208,64,156,64,208,64,151,64,
208,64,149,64,208,64,156,64,208,64,145,64,208,64,144,64,208,64,157,64,208,
128,154,0,64,148,64,208,73,156,13,57,64,208,64,162,64,208,128,158,0,201,
145,10,33,0,64,208,128,160,0,136,144,4,0,64,134,64,208,64,149,64,208,136,
163,4,0,64,134,64,208,128,163,0,72,154,8,64,208,128,151,0,128,148,0,201,
161,10,29,0,64,208,128,162,0,72,159,8,64,208,128,162,0,64,158,64,208,136,
159,4,0,128,148,0,64,162,64,208,128,163,0,74,155,31,1,215,64,208,137,161,
5,16,0,136,158,4,0,64,156,64,208,128,151,0,192,165,0,64,208,128,162,0,74,
152,175,1,95,64,208,73,159,29,96,64,208,137,160,5,20,0,72,154,12,64,208,
64,160,64,208,128,158,0,128,145,0,128,161,0,73,154,9,44,64,208,128,161,
0,137,145,5,24,0,64,144,64,208,72,161,12,64,208,64,161,64,208,128,160,0,
128,144,0,64,147,64,208,64,159,64,208,128,152,0,72,156,16,64,208,64,173,
64,208,64,161,64,208,128,165,0,64,155,64,208,128,152,0,201,164,14,57,0,
64,208,64,152,64,208,128,161,0,73,162,17,28,64,208,136,148,4,0,64,147,64,
208,128,163,0,64,160,64,208,64,159,64,208,128,158,0,64,163,64,208,136,159,
4,0,64,152,64,208,128,159,0,72,173,12,64,208,136,159,4,0,128,156,0,128,
168,0,64,151,64,208,73,156,21,84,64,208,137,161,5,8,0,128,154,0,64,173,
64,208,128,154,0,73,148,9,36,64,208,128,156,0,137,146,5,20,0,64,144,64,
208,136,159,4,0,64,154,64,208,128,145,0,64,147,64,208,128,144,0,73,152,
9,20,64,208,128,159,0,64,150,64,208,64,145,64,208,128,168,0,64,154,64,208,
128,156,0,73,162,25,72,64,208,137,158,5,12,0,136,152,4,0,128,144,0,136,
162,4,0,128,161,0,73,159,17,20,64,208,136,162,4,0,64,161,64,208,128,157,
0,128,158,0,64,161,64,208,137,154,5,16,0,72,148,8,64,208,128,156,0,128,
144,0,136,173,4,0,128,163,0,72,173,13,64,208,192,156,0,64,208,128,152,0,
128,167,0,64,154,64,208,73,155,9,50,64,208,128,145,0,73,149,13,20,64,208,
64,159,64,208,128,154,0,136,148,4,0,128,146,0,200,152,13,0,64,208,64,165,
64,208,128,152,0,192,151,0,64,208,128,167,0,73,159,9,24,64,208,128,151,
0,72,158,8,64,208,128,158,0,64,157,64,208,128,161,0,136,165,4,0,64,162,
64,208,128,161,0,72,157,89,64,208,201,159,19,56,0,64,208,200,159,9,0,64,
208,128,159,0,128,152,0,201,152,18,25,0,64,208,64,152,64,208,64,161,64,
208,128,165,0,136,148,4,0,128,146,0,136,157,4,0,192,154,0,64,208,128,159,
0,201,163,14,25,0,64,208,64,152,64,208,128,174,0,72,161,8,64,208,128,154,
0,128,160,0,128,166,0,192,156,0,64,208,137,154,5,46,0,137,147,5,25,0,200,
146,9,0,64,208,128,155,0,64,145,64,208,64,161,64,208,128,155,0,136,152,
4,0,192,151,0,64,208,64,144,64,208,128,159,0,201,162,10,22,0,64,208,128,
162,0,136,161,4,0,192,159,0,64,208,128,151,0,64,175,64,208,128,154,0,74,
165,56,2,228,64,208,201,159,10,25,0,64,208,128,158,0,137,147,5,8,0,128,
146,0,64,156,64,208,128,162,0,137,163,5,17,0,192,162,0,64,208,136,155,4,
0,128,154,0,64,164,64,208,128,151,0,74,162,141,2,30,64,208,73,158,17,45,
64,208,64,162,64,208,64,152,64,208,128,145,0,137,151,5,16,0,72,150,8,64,
208,128,162,0,128,148,0,136,156,4,0,192,154,0,64,208,128,144,0,73,162,29,
74,64,208,137,163,5,16,0,136,161,4,0,64,155,64,208,128,159,0,64,165,64,
208,128,159,0,200,161,17,0,64,208,136,148,4,0,64,147,64,208,128,165,0,192,
159,0,64,208,73,162,13,16,64,208,64,152,64,208,128,163,0,128,151,0,64,163,
64,208,128,159,0,72,173,8,64,208,128,159,0,64,163,64,208,128,159,0,202,
160,132,1,14,0,64,208,73,157,17,62,64,208,72,157,8,64,208,128,161,0,128,
148,0,73,148,17,28,64,208,136,163,4,0,64,157,64,208,128,162,0,72,147,8,
64,208,128,161,0,128,146,0,200,154,9,0,64,208,128,164,0,192,152,0,64,208,
128,158,0,73,160,9,38,64,208,128,154,0,136,159,4,0,192,158,0,64,208,136,
160,4,0,192,158,0,64,208,72,154,8,64,208,128,144,0,128,145,0,72,164,12,
64,208,136,164,4,0,128,158,0,192,162,0,64,208,64,159,64,208,128,159,0,192,
159,0,64,208,73,154,21,85,64,208,73,162,9,12,64,208,128,152,0,128,156,0,
128,164,0,73,147,9,49,64,208,128,154,0,201,145,22,33,0,64,208,136,159,4,
0,64,158,64,208,64,174,64,208,128,155,0,64,144,64,208,136,159,4,0,128,151,
0,64,146,64,208,128,160,0,136,152,4,0,64,148,64,208,136,161,4,0,128,159,
0,201,163,10,41,0,64,208,128,159,0,73,159,13,24,64,208,136,159,4,0,128,
154,0,64,158,64,208,64,160,64,208,128,159,0,64,162,64,208,128,164,0,136,
166,4,0,128,164,0,192,161,0,64,208,73,159,13,70,64,208,136,159,4,0,128,
151,0,73,152,9,42,64,208,128,160,0,201,148,18,30,0,64,208,137,159,5,8,0,
128,156,0,128,166,0,192,146,0,64,208,136,166,4,0,128,157,0,128,150,0,72,
158,8,64,208,128,165,0,64,157,64,208,128,154,0,73,162,9,41,64,208,128,165,
0,200,161,25,0,64,208,137,160,5,12,0,136,159,4,0,128,151,0,64,162,64,208,
128,159,0,64,160,64,208,128,175,0,72,164,8,64,208,128,160,0,64,163,64,208,
128,160,0,200,164,86,0,64,208,73,159,9,61,64,208,128,154,0,137,152,5,29,
0,200,148,9,0,64,208,128,159,0,64,147,64,208,64,152,64,208,64,173,64,208,
128,163,0,64,156,64,208,136,154,4,0,64,147,64,208,64,144,64,208,64,146,
64,208,128,162,0,73,161,9,16,64,208,128,154,0,64,160,64,208,128,164,0,128,
163,0,64,163,64,208,201,159,10,29,0,64,208,128,162,0,72,154,8,64,208,128,
160,0,64,146,64,208,64,144,64,208,128,151,0,72,162,16,64,208,72,173,8,64,
208,128,159,0,128,159,0,64,160,64,208,128,161,0,201,173,74,133,0,64,208,
73,157,13,36,64,208,64,152,64,208,128,161,0,137,151,5,16,0,136,147,4,0,
64,144,64,208,128,151,0,64,156,64,208,128,154,0,73,162,13,24,64,208,136,
161,4,0,128,154,0,136,161,4,0,64,160,64,208,128,151,0,64,166,64,208,128,
151,0,73,167,29,44,64,208,73,152,13,20,64,208,64,151,64,208,128,156,0,136,
151,4,0,128,146,0,128,165,0,64,166,64,208,137,159,5,8,0,128,151,0,128,173,
0,64,168,64,208,137,154,5,8,0,128,147,0,128,156,0,136,175,4,0,192,174,0,
64,208,137,162,5,12,0,136,154,4,0,128,152,0,128,166,0,64,169,64,208,73,
156,26,117,64,208,137,158,5,17,0,136,151,4,0,192,144,0,64,208,128,161,0,
128,159,0,137,150,5,56,0,73,146,13,40,64,208,136,160,4,0,128,151,0,64,144,
64,208,137,159,5,16,0,136,158,4,0,64,146,64,208,128,160,0,136,163,4,0,128,
160,0,64,147,64,208,136,159,4,0,128,154,0,73,154,13,24,64,208,136,151,4,
0,128,144,0,64,151,64,208,136,159,4,0,128,145,0,64,155,64,208,136,151,4,
0,128,148,0,73,161,21,80,64,208,73,159,9,12,64,208,128,154,0,128,157,0,
128,163,0,73,159,21,28,64,208,137,162,5,8,0,128,161,0,64,166,64,208,128,
161,0,64,157,64,208,128,158,0,64,160,64,208,137,157,5,12,0,136,151,4,0,
128,146,0,72,163,8,64,208,128,146,0,64,161,64,208,128,159,0,137,164,5,36,
0,64,163,64,208,137,157,5,12,0,136,151,4,0,128,146,0,136,161,4,0,64,160,
64,208,136,157,4,0,128,146,0,128,173,0,80,175,5,1,64,208,74,157,82,2,213,
64,208,73,158,33,64,64,208,64,152,64,208,72,163,8,64,208,128,163,0,64,159,
64,208,64,154,64,208,64,160,64,208,128,158,0,72,152,24,64,208,72,152,12,
64,208,64,161,64,208,128,165,0,64,147,64,208,128,159,0,64,144,64,208,128,
158,0,136,166,4,0,64,162,64,208,128,154,0,74,150,18,1,128,64,208,137,154,
5,8,0,128,148,0,128,162,0,74,147,179,1,67,64,208,73,159,9,109,64,208,128,
163,0,201,155,14,65,0,64,208,64,159,64,208,128,151,0,73,148,29,40,64,208,
64,162,64,208,64,149,64,208,64,160,64,208,64,172,64,208,64,149,64,208,128,
160,0,64,144,64,208,64,161,64,208,128,158,0,64,152,64,208,64,162,64,208,
128,152,0,73,157,9,28,64,208,128,147,0,64,156,64,208,137,152,5,12,0,136,
151,4,0,128,144,0,128,154,0,64,158,64,208,128,154,0,137,163,5,40,0,73,161,
9,24,64,208,128,144,0,64,160,64,208,72,173,8,64,208,128,161,0,128,154,0,
64,162,64,208,136,163,4,0,128,152,0,73,165,9,16,64,208,128,154,0,64,164,
64,208,128,156,0,64,173,64,208,128,161,0,73,145,57,93,64,208,73,161,9,40,
64,208,128,157,0,137,150,5,20,0,64,148,64,208,72,159,8,64,208,128,154,0,
128,154,0,64,156,64,208,136,161,4,0,128,154,0,136,167,4,0,64,165,64,208,
128,152,0,64,144,64,208,201,161,14,29,0,64,208,64,161,64,208,128,160,0,
72,156,8,64,208,128,162,0,64,146,64,208,128,160,0,128,173,0,64,146,64,208,
73,160,9,28,64,208,128,151,0,64,146,64,208,64,164,64,208,72,173,8,64,208,
128,144,0,128,163,0,64,164,64,208,72,173,12,64,208,136,152,4,0,128,144,
0,128,163,0,72,149,8,64,208,128,161,0,64,148,64,208,73,159,9,28,64,208,
128,154,0,72,156,12,64,208,64,162,64,208,128,158,0,64,150,64,208,128,148,
0,128,166,0,73,154,63,183,64,208,73,161,21,41,64,208,64,156,64,208,136,
154,4,0,64,152,64,208,128,154,0,201,156,10,17,0,64,208,128,159,0,64,152,
64,208,128,162,0,128,160,0,72,165,8,64,208,128,151,0,192,162,0,64,208,128,
152,0,72,152,41,64,208,137,151,5,28,0,72,148,8,64,208,128,158,0,64,144,
64,208,136,158,4,0,64,156,64,208,128,151,0,192,156,0,64,208,128,167,0,64,
151,64,208,73,159,13,48,64,208,136,156,4,0,128,154,0,73,156,9,24,64,208,
128,154,0,72,154,8,64,208,128,156,0,64,148,64,208,128,144,0,64,157,64,208,
136,162,4,0,128,158,0,73,161,9,16,64,208,128,154,0,64,160,64,208,128,152,
0,64,162,64,208,136,158,4,0,128,144,0,72,156,57,64,208,201,160,14,29,0,
64,208,136,162,4,0,128,144,0,137,151,5,12,0,64,144,64,208,128,158,0,128,
154,0,73,162,9,16,64,208,128,159,0,64,161,64,208,128,151,0,64,163,64,208,
128,156,0,64,155,64,208,72,162,8,64,208,128,148,0,64,146,64,208,128,151,
0,202,163,27,1,165,0,64,208,137,158,5,12,0,136,156,4,0,128,154,0,64,159,
64,208,128,159,0,74,160,162,1,30,64,208,73,156,41,108,64,208,72,158,24,
64,208,64,155,64,208,64,159,64,208,64,160,64,208,64,158,64,208,128,148,
0,64,152,64,208,64,144,64,208,128,166,0,137,151,5,28,0,72,147,20,64,208,
136,163,4,0,64,159,64,208,136,163,4,0,128,160,0,128,145,0,72,154,20,64,
208,72,173,8,64,208,128,161,0,64,161,64,208,128,152,0,64,152,64,208,72,
160,8,64,208,128,158,0,64,159,64,208,128,154,0,73,162,9,24,64,208,128,154,
0,72,158,8,64,208,128,158,0,64,157,64,208,128,148,0,72,173,12,64,208,64,
156,64,208,128,159,0,64,166,64,208,64,158,64,208,128,154,0,72,159,68,64,
208,73,159,17,44,64,208,137,146,5,8,0,128,145,0,128,163,0,73,154,9,20,64,
208,128,159,0,136,151,4,0,64,146,64,208,128,163,0,64,157,64,208,128,167,
0,73,162,9,16,64,208,128,144,0,64,161,64,208,128,159,0,128,164,0,64,158,
64,208,137,158,5,33,0,201,154,10,13,0,64,208,128,145,0,128,148,0,64,156,
64,208,72,152,8,64,208,128,166,0,128,144,0,72,161,16,64,208,72,159,8,64,
208,128,161,0,128,157,0,128,160,0,72,162,45,64,208,73,155,9,29,64,208,128,
159,0,72,154,12,64,208,64,158,64,208,128,159,0,192,150,0,64,208,128,162,
0,72,173,8,64,208,128,162,0,128,166,0,64,161,64,208,73,159,13,36,64,208,
136,163,4,0,128,145,0,73,152,9,20,64,208,128,144,0,136,151,4,0,64,146,64,
208,128,159,0,128,154,0,73,165,9,20,64,208,128,162,0,64,162,64,208,64,162,
64,208,128,161,0,128,166,0,73,166,53,85,64,208,73,159,17,24,64,208,64,161,
64,208,64,173,64,208,128,160,0,64,152,64,208,128,154,0,64,173,64,208,136,
161,4,0,64,157,64,208,64,162,64,208,64,163,64,208,128,156,0,72,165,17,64,
208,136,163,4,0,192,156,0,64,208,128,162,0,64,164,64,208,72,173,8,64,208,
128,154,0,128,166,0,72,173,37,64,208,137,158,5,16,0,136,154,4,0,64,148,
64,208,128,163,0,200,163,9,0,64,208,128,161,0,64,159,64,208,128,152,0,64,
168,64,208,128,151,0,64,174,64,208,74,157,88,3,227,64,208,73,157,13,62,
64,208,64,144,64,208,128,162,0,73,152,21,32,64,208,64,152,64,208,136,162,
4,0,64,152,64,208,128,162,0,72,147,8,64,208,128,154,0,128,144,0,192,154,
0,64,208,192,158,0,64,208,136,160,4,0,128,156,0,137,166,5,12,0,64,159,64,
208,128,151,0,64,173,64,208,128,154,0,74,149,14,1,203,64,208,136,161,4,
0,128,147,0,74,146,152,1,57,64,208,201,158,27,76,0,64,208,200,163,9,0,64,
208,128,158,0,64,154,64,208,64,154,64,208,128,163,0,201,148,10,34,0,64,
208,128,162,0,73,145,9,17,64,208,128,154,0,192,144,0,64,208,128,158,0,64,
147,64,208,128,154,0,72,154,8,64,208,128,154,0,64,150,64,208,128,148,0,
73,162,13,54,64,208,136,158,4,0,128,144,0,201,160,18,33,0,64,208,136,163,
4,0,64,159,64,208,128,163,0,64,159,64,208,72,173,8,64,208,128,161,0,128,
168,0,192,161,0,64,208,128,147,0,72,173,8,64,208,128,161,0,64,163,64,208,
128,160,0,73,144,102,109,64,208,137,160,5,60,0,73,154,9,40,64,208,128,159,
0,137,151,5,16,0,64,144,64,208,64,160,64,208,128,161,0,64,152,64,208,136,
151,4,0,64,150,64,208,128,154,0,72,159,12,64,208,64,154,64,208,128,158,
0,128,158,0,73,164,9,25,64,208,128,144,0,72,162,8,64,208,128,161,0,192,
161,0,64,208,128,164,0,136,173,4,0,64,165,64,208,128,155,0,64,134,64,208,
128,160,0,64,145,64,208,201,164,10,37,0,64,208,128,151,0,136,154,4,0,64,
152,64,208,64,147,64,208,64,160,64,208,64,163,64,208,64,159,64,208,128,
159,0,72,174,8,64,208,128,146,0,128,166,0,72,148,36,64,208,73,158,9,16,
64,208,128,164,0,136,156,4,0,128,147,0,72,161,8,64,208,128,144,0,64,159,
64,208,128,148,0,64,147,64,208,73,159,9,48,64,208,128,163,0,137,154,5,32,
0,136,146,4,0,64,145,64,208,64,144,64,208,64,157,64,208,64,154,64,208,64,
158,64,208,128,156,0,64,158,64,208,128,154,0,201,163,22,37,0,64,208,64,
173,64,208,136,161,4,0,64,152,64,208,128,161,0,72,161,8,64,208,128,154,
0,64,160,64,208,128,158,0,64,165,64,208,128,154,0,74,154,112,1,80,64,208,
137,158,5,64,0,73,150,9,40,64,208,128,148,0,137,146,5,16,0,64,144,64,208,
64,160,64,208,128,162,0,64,147,64,208,136,163,4,0,64,156,64,208,128,144,
0,72,156,8,64,208,128,151,0,64,152,64,208,64,158,64,208,128,160,0,201,162,
14,30,0,64,208,136,159,4,0,128,154,0,72,160,8,64,208,128,173,0,192,159,
0,64,208,128,152,0,72,173,8,64,208,128,161,0,128,168,0,73,151,124,175,64,
208,73,156,13,66,64,208,64,158,64,208,128,160,0,73,147,9,38,64,208,128,
163,0,73,145,13,21,64,208,64,161,64,208,128,145,0,192,144,0,64,208,128,
158,0,192,146,0,64,208,128,161,0,72,150,8,64,208,128,148,0,64,148,64,208,
128,158,0,201,162,14,37,0,64,208,136,158,4,0,128,144,0,72,159,8,64,208,
128,167,0,64,158,64,208,72,163,8,64,208,128,158,0,128,161,0,72,173,12,64,
208,136,161,4,0,128,159,0,128,164,0,64,150,64,208,73,156,21,24,64,208,72,
173,8,64,208,128,161,0,64,144,64,208,128,168,0,128,148,0,64,157,64,208,
64,152,64,208,64,152,64,208,64,147,64,208,64,152,64,208,128,156,0,192,152,
0,64,208,137,156,5,29,0,201,148,10,13,0,64,208,128,148,0,128,144,0,64,154,
64,208,64,161,64,208,128,163,0,72,166,8,64,208,128,173,0,64,159,64,208,
128,144,0,72,156,84,64,208,73,158,13,48,64,208,136,161,4,0,128,154,0,73,
148,9,24,64,208,128,144,0,136,146,4,0,64,144,64,208,136,161,4,0,128,145,
0,136,151,4,0,64,150,64,208,128,148,0,73,164,9,24,64,208,128,148,0,72,162,
12,64,208,136,163,4,0,128,159,0,128,160,0,136,168,4,0,128,166,0,64,155,
64,208,136,165,4,0,192,154,0,64,208,72,159,8,64,208,128,158,0,64,158,64,
208,128,156,0,74,164,38,3,251,64,208,73,156,13,24,64,208,136,168,4,0,128,
155,0,136,151,4,0,64,144,64,208,128,161,0,136,163,4,0,128,158,0,74,161,
87,2,60,64,208,73,154,9,45,64,208,128,154,0,72,152,25,64,208,72,173,17,
64,208,64,159,64,208,192,152,0,64,208,128,152,0,128,161,0,64,147,64,208,
64,159,64,208,128,152,0,72,161,8,64,208,128,161,0,64,159,64,208,137,166,
5,16,0,72,161,8,64,208,128,159,0,128,154,0,64,173,64,208,128,162,0,73,159,
29,106,64,208,137,162,5,16,0,136,158,4,0,64,156,64,208,128,155,0,136,168,
4,0,128,166,0,192,158,0,64,208,73,156,9,40,64,208,128,166,0,137,152,5,28,
0,72,147,16,64,208,136,163,4,0,64,159,64,208,128,152,0,64,144,64,208,128,
158,0,128,154,0,137,162,5,24,0,64,161,64,208,72,157,8,64,208,128,165,0,
64,148,64,208,128,160,0,192,163,0,64,208,128,158,0,64,160,64,208,73,158,
33,242,64,208,72,162,24,64,208,72,148,12,64,208,64,149,64,208,128,155,0,
64,144,64,208,128,162,0,128,154,0,73,148,17,134,64,208,136,166,4,0,64,156,
64,208,128,158,0,201,146,14,78,0,64,208,64,163,64,208,128,151,0,72,145,
20,64,208,72,174,12,64,208,64,160,64,208,128,158,0,128,166,0,64,144,64,
208,73,154,9,29,64,208,128,161,0,64,148,64,208,64,160,64,208,64,149,64,
208,192,161,0,64,208,128,144,0,64,161,64,208,64,159,64,208,128,158,0,64,
147,64,208,73,163,21,32,64,208,64,173,64,208,136,161,4,0,64,152,64,208,
128,161,0,72,162,8,64,208,128,163,0,128,152,0,128,166,0,73,155,37,64,64,
208,64,152,64,208,192,166,0,64,208,200,158,9,0,64,208,128,156,0,192,144,
0,64,208,192,156,0,64,208,128,152,0,72,154,8,64,208,128,166,0,64,152,64,
208,72,156,8,64,208,128,158,0,64,154,64,208,128,161,0,64,156,64,208,136,
151,4,0,128,147,0,73,164,29,73,64,208,72,158,16,64,208,64,160,64,208,64,
163,64,208,128,156,0,64,144,64,208,128,154,0,73,161,9,37,64,208,128,154,
0,72,160,8,64,208,128,166,0,192,159,0,64,208,137,152,5,8,0,128,144,0,64,
161,64,208,128,158,0,64,162,64,208,128,154,0,73,168,13,53,64,208,64,152,
64,208,128,145,0,192,166,0,64,208,73,161,9,28,64,208,128,173,0,72,148,12,
64,208,64,159,64,208,128,158,0,64,144,64,208,128,156,0,64,163,64,208,128,
159,0,64,174,64,208,128,161,0,80,163,1,47,64,208,73,157,25,156,64,208,136,
154,4,0,64,152,64,208,64,159,64,208,64,158,64,208,128,154,0,73,150,9,80,
64,208,128,148,0,73,145,9,48,64,208,128,160,0,64,144,64,208,137,159,5,28,
0,72,158,12,64,208,64,158,64,208,128,161,0,64,152,64,208,64,150,64,208,
128,154,0,64,173,64,208,128,161,0,64,147,64,208,73,159,13,16,64,208,136,
154,4,0,128,151,0,128,154,0,128,163,0,73,154,29,44,64,208,137,151,5,20,
0,72,150,12,64,208,64,161,64,208,128,152,0,128,144,0,128,152,0,64,152,64,
208,64,163,64,208,64,152,64,208,128,173,0,64,156,64,208,128,151,0,73,162,
38,98,64,208,201,159,10,25,0,64,208,128,159,0,136,154,4,0,64,152,64,208,
64,159,64,208,128,145,0,64,173,64,208,128,159,0,73,160,41,52,64,208,137,
159,5,24,0,72,148,12,64,208,64,150,64,208,128,146,0,64,147,64,208,128,163,
0,64,166,64,208,64,152,64,208,128,158,0,64,159,64,208,136,154,4,0,128,152,
0,192,161,0,64,208,128,162,0,72,166,36,64,208,73,156,13,24,64,208,64,161,
64,208,128,158,0,64,148,64,208,64,152,64,208,128,152,0,64,173,64,208,128,
158,0,64,164,64,208,128,145,0,64,162,64,208,73,157,9,49,64,208,128,154,
0,201,152,10,33,0,64,208,128,161,0,137,145,5,16,0,64,144,64,208,64,154,
64,208,128,173,0,64,146,64,208,128,161,0,136,156,4,0,128,154,0,201,163,
14,42,0,64,208,64,173,64,208,128,161,0,73,160,9,17,64,208,128,154,0,192,
159,0,64,208,128,159,0,64,162,64,208,64,159,64,208,128,154,0,72,173,8,64,
208,128,154,0,128,164,0,73,168,13,64,64,208,64,173,64,208,128,159,0,73,
166,17,24,64,208,136,165,4,0,64,159,64,208,128,154,0,64,165,64,208,128,
144,0,64,167,64,208,137,159,5,20,0,72,157,12,64,208,64,154,64,208,128,159,
0,128,151,0,128,160,0,72,175,36,64,208,73,163,9,24,64,208,128,154,0,72,
154,8,64,208,128,173,0,64,147,64,208,128,154,0,64,173,64,208,128,161,0,
64,173,64,208,136,162,4,0,192,161,0,64,208,128,154,0,64,90,74,77,28,1,17,
137,73,5,10,0,64,67,128,80,0,64,79,64,68,64,69,64,76,64,69,128,82,0,73,
69,25,156,73,83,7,18,128,65,0,72,82,6,128,84,0,64,66,128,76,0,128,86,0,
73,67,57,116,73,77,7,26,128,76,0,137,73,5,14,0,136,69,4,0,64,67,128,77,
0,64,76,128,86,0,73,83,7,14,128,69,0,136,82,4,0,128,81,0,64,84,137,83,5,
8,0,128,65,0,128,85,0,72,66,14,137,68,5,8,0,128,66,0,128,73,0,64,65,73,
78,13,34,136,85,4,0,64,76,128,65,0,73,70,7,12,128,84,0,64,65,128,80,0,64,
77,136,83,4,0,128,73,0,136,82,4,0,64,80,128,85,0,64,68,136,70,4,0,64,65,
136,89,4,0,128,70,0,73,73,39,78,73,78,7,22,128,75,0,73,73,7,10,128,80,0,
128,70,0,64,77,128,83,0,72,82,6,128,80,0,64,80,64,82,128,65,0,72,72,8,64,
67,128,80,0,64,70,137,83,5,18,0,73,73,7,10,128,83,0,128,67,0,128,78,0,72,
87,6,128,71,0,64,86,128,83,0,64,76,136,80,4,0,64,72,128,82,0,73,83,15,102,
72,89,8,64,78,128,67,0,128,72,0,73,80,39,72,73,79,9,22,64,82,128,82,0,137,
69,5,8,0,128,68,0,64,76,128,76,0,136,83,4,0,64,80,64,65,64,85,128,80,0,
72,79,28,72,80,14,72,70,8,64,65,128,78,0,128,69,0,64,70,64,69,64,77,64,
65,128,84,0,64,78,128,82,0,64,82,137,77,5,10,0,64,69,128,79,0,128,80,0,
73,87,45,76,73,78,7,32,128,74,0,64,69,64,82,64,71,64,83,64,67,64,72,64,
78,64,65,64,85,64,90,64,69,128,82,0,64,83,64,79,64,70,128,84,0,72,86,6,
128,83,0,64,84,73,73,7,16,128,67,0,136,68,4,0,64,65,128,84,0,136,83,4,0,
128,76,0,64,89,64,77,128,86,0
};

TAbbrevContainer::TAbbrevContainer() {
}

TAbbrevContainer::~TAbbrevContainer() {
}

void TAbbrevContainer::LoadFromStream(IInputStream& in) {
    try {
        AbbrevWords.Reset(new TTrieSet(TBlob::FromStream(in)));
    } catch (...) {
        Cerr << "Could not load abbreviations from InputStream" << Endl;
    }
}

void TAbbrevContainer::LoadDefault() {
    TMemoryInput in(AbbrevContainerDefault, Y_ARRAY_SIZE(AbbrevContainerDefault));
    LoadFromStream(in);
}

void TAbbrevContainer::LoadFromFile(const TString& fileName) {
    TUnbufferedFileInput in(fileName);
    LoadFromStream(in);
}

bool TAbbrevContainer::Contains(const TString& s) const {
    return AbbrevWords->Has(s.data());
}

bool TAbbrevContainer::Contains(const TUtf16String& w) const {
    return Contains(WideToUTF8(w));
}
struct TDefaultGetter {
    TAbbrevContainer Value;
    TDefaultGetter()
    {
        Value.LoadDefault();
    }
};

const TAbbrevContainer& TAbbrevContainer::GetDefault() {
    return Default<TDefaultGetter>().Value;
}
