#include "pornodict.h"

#include <library/cpp/containers/comptrie/comptrie.h>

#include <util/memory/blob.h>
#include <util/generic/singleton.h>

namespace NSnippets {
/*
Something like this:
cat arcadia/yweb/pornofilter/porno_config.dat | grep -v ":-" | grep -v "^b=" | iconv -f cp1251 -t utf8 | awk -F ":" '{print $1 "\t" int($2 * 100)}' | triecompiler -i /dev/stdin -m -w /dev/stdout | file2c
 */
    const unsigned char PornoBlob[] = {
80,4,69,88,74,59,171,27,12,64,4,73,53,108,133,64,4,64,65,64,4,64,49,64,
4,72,86,35,64,4,72,79,18,64,4,64,61,64,4,72,65,51,64,4,64,76,1,33,64,57,
64,4,64,65,64,4,64,76,1,47,192,56,192,117,48,64,4,72,79,32,64,4,64,61,64,
4,72,65,14,64,4,64,58,64,4,64,56,2,29,215,64,58,64,4,128,48,192,118,100,
64,57,64,4,64,65,64,4,64,58,64,4,64,56,64,4,128,57,158,4,64,48,64,4,64,
57,64,4,64,61,64,4,64,62,64,4,64,50,64,4,64,56,2,11,158,64,62,64,4,72,59,
16,64,4,72,86,6,2,57,109,64,56,2,57,104,64,49,64,4,64,62,64,4,2,52,77,82,
50,2,106,6,222,64,4,74,62,32,1,166,64,4,64,59,64,4,64,62,64,4,64,65,64,
4,64,48,64,4,64,66,64,4,64,75,2,24,145,74,56,99,1,72,64,4,73,57,35,76,64,
4,64,62,64,4,64,49,64,4,64,67,64,4,64,50,64,4,64,48,64,4,64,66,64,4,128,
56,192,66,200,72,52,14,64,4,64,53,64,4,64,62,2,64,23,64,49,64,4,64,59,64,
4,64,79,64,4,64,52,64,4,72,62,6,2,1,132,64,56,2,1,119,72,87,5,1,4,64,84,
64,4,64,49,64,4,2,1,75,72,55,72,64,4,72,74,34,64,4,64,53,64,4,64,49,64,
4,64,75,64,4,64,50,64,4,64,48,64,4,64,66,64,4,128,76,192,104,44,64,57,64,
4,64,62,64,4,64,49,64,4,64,67,64,4,64,50,64,4,64,48,64,4,64,66,64,4,128,
56,192,104,44,64,48,64,4,73,58,51,136,64,4,64,67,64,4,64,67,64,4,64,60,
64,4,64,61,64,4,64,75,64,4,64,57,64,0,64,32,64,4,64,63,64,4,64,62,64,4,
64,60,64,4,64,63,2,63,145,64,51,64,4,72,86,42,64,4,192,61,186,155,64,4,
192,48,186,155,64,4,64,59,64,4,64,76,64,4,64,61,64,4,136,62,5,191,222,64,
56,64,4,128,57,191,222,64,56,64,4,64,61,64,4,192,48,186,155,64,4,64,59,
64,4,64,76,64,4,64,61,64,4,72,75,9,64,4,128,57,191,222,128,62,191,222,64,
63,64,4,64,72,64,4,64,71,64,4,128,77,192,77,140,72,59,30,64,4,64,48,64,
4,64,51,64,4,64,48,64,4,64,59,64,4,64,56,64,4,64,73,2,44,188,64,57,64,4,
64,62,64,4,64,49,64,4,64,67,64,4,64,50,64,4,64,48,64,4,64,66,64,4,128,56,
165,253,73,75,79,132,64,4,72,53,40,64,4,64,49,64,4,72,75,22,64,4,64,50,
64,4,64,48,64,4,64,66,64,4,128,76,192,66,200,64,62,64,4,128,61,192,88,205,
64,49,64,4,64,59,64,4,64,79,64,4,64,52,64,4,72,75,9,64,4,128,72,167,180,
64,62,64,4,128,58,173,211,72,74,33,64,4,64,53,64,4,64,49,64,4,64,75,64,
4,64,50,64,4,64,48,64,4,64,66,64,4,128,76,165,253,64,67,64,4,64,59,64,4,
64,76,64,4,64,50,64,4,128,48,147,119,64,86,64,4,64,52,64,4,80,66,27,108,
64,4,64,64,64,4,64,48,64,4,64,69,64,4,64,48,64,4,72,66,13,64,4,192,56,192,
117,48,2,66,60,64,61,64,4,64,56,64,4,128,57,192,117,48,73,33,64,223,64,
4,72,77,38,64,4,64,58,64,4,64,65,64,4,64,67,64,4,64,48,64,4,64,59,64,4,
64,76,64,4,64,61,64,4,128,75,192,132,233,64,48,64,4,64,52,64,4,64,62,64,
4,64,60,64,4,128,48,165,254,73,29,22,116,64,4,64,48,64,4,64,65,64,4,64,
48,64,4,128,94,146,224,72,28,42,64,4,64,48,64,4,64,65,64,4,64,66,64,4,64,
67,64,4,64,64,64,4,64,49,64,4,64,48,64,4,64,70,64,4,64,75,2,39,88,64,17,
64,4,64,86,64,4,64,65,64,4,64,77,64,4,64,58,64,4,64,65,64,4,64,67,64,4,
64,48,64,4,64,59,64,4,64,76,64,4,64,61,64,4,64,48,64,4,128,79,145,32,64,
31,64,4,72,86,26,64,4,64,55,64,4,64,76,64,4,64,52,64,4,64,55,64,4,64,53,
2,49,24,64,77,64,4,64,52,64,4,64,64,2,44,29,82,48,1,30,1,89,64,4,73,63,
28,246,64,4,64,65,64,4,64,58,64,4,72,86,5,1,4,64,56,64,4,64,64,2,27,141,
72,61,63,64,4,73,66,25,51,64,4,64,56,64,4,64,65,64,4,64,53,64,4,64,58,64,
4,128,65,4,64,48,64,4,192,59,182,93,64,4,64,76,64,4,64,61,64,4,64,75,64,
4,128,57,169,88,64,67,64,4,128,65,2,64,51,64,4,64,62,64,4,64,59,64,4,64,
53,64,4,64,61,64,4,64,75,64,0,64,32,64,4,73,61,15,104,64,4,64,48,64,4,64,
71,2,17,17,73,50,7,70,2,16,249,73,26,7,42,2,16,172,72,22,6,2,31,5,64,19,
64,4,64,48,64,4,64,61,64,4,64,61,64,4,64,48,64,0,64,32,64,4,64,65,2,16,
14,72,49,16,64,4,72,64,6,2,15,217,64,59,2,15,174,64,48,2,16,45,73,55,7,
14,2,17,22,80,52,26,218,2,16,141,64,60,2,16,219,74,68,8,17,234,2,32,67,
82,65,17,116,17,181,64,4,80,63,17,64,2,17,53,72,69,21,64,4,64,67,64,4,64,
53,64,4,64,66,64,4,128,76,143,146,64,64,64,4,64,51,64,4,2,33,173,64,45,
64,4,64,64,64,4,72,77,18,64,4,64,58,64,4,64,70,64,4,64,75,2,62,56,64,48,
64,4,136,65,5,188,254,64,51,64,4,64,53,64,4,64,61,64,4,64,61,64,4,64,75,
64,4,128,79,132,103,64,49,64,4,82,59,1,34,1,124,64,4,73,67,29,94,64,4,64,
52,64,4,64,56,64,4,64,59,64,4,64,56,64,4,64,73,64,4,128,53,8,64,53,64,4,
64,50,64,4,64,62,64,4,64,66,64,4,72,61,36,64,4,137,75,7,26,192,142,226,
72,56,14,64,4,64,66,64,4,128,76,192,142,226,128,53,192,142,226,128,79,192,
142,226,64,53,64,4,64,61,64,4,128,76,192,142,226,192,79,192,176,254,64,
4,200,52,124,129,199,64,4,73,67,26,90,64,4,136,61,5,174,251,64,50,64,4,
64,48,64,4,64,66,64,4,128,56,7,73,62,21,48,64,4,64,50,64,4,64,48,64,4,64,
66,64,4,128,76,7,72,58,10,64,4,128,56,192,113,20,64,56,64,4,72,73,9,64,
4,128,48,162,4,128,61,136,43,64,65,64,4,64,66,64,4,64,50,64,4,128,62,170,
66,73,78,14,19,64,4,64,51,64,4,128,48,130,249,128,76,192,96,192,64,86,64,
4,128,50,129,199,64,49,64,4,72,75,27,64,4,72,66,5,1,12,64,50,64,4,64,48,
64,4,64,66,64,4,128,76,192,134,97,64,67,64,4,72,66,5,1,12,64,50,64,4,64,
48,64,4,64,66,64,4,128,56,192,134,97,73,55,17,30,64,4,64,52,64,4,64,67,
64,4,128,61,7,64,52,64,4,64,65,64,4,128,60,192,156,64,64,56,64,4,64,65,
64,4,72,65,5,1,62,64,53,64,4,64,58,64,4,192,65,150,43,64,4,64,67,64,4,64,
48,64,4,192,59,170,249,64,4,80,76,56,232,64,4,64,61,64,4,72,75,5,1,99,64,
62,1,83,72,86,147,64,4,64,65,64,4,73,65,31,90,64,4,64,53,64,4,64,58,64,
4,64,65,64,4,64,67,64,4,64,48,64,4,128,59,192,235,247,64,53,64,4,64,58,
64,4,192,65,150,43,64,4,64,67,64,4,64,48,64,4,192,59,170,249,64,4,80,76,
56,145,64,4,64,61,64,4,72,86,13,64,4,64,65,64,4,64,66,1,52,64,56,64,4,128,
57,145,32,64,77,64,4,64,58,64,4,64,65,64,4,64,67,64,4,64,48,64,4,64,59,
64,4,64,76,64,4,64,61,64,4,64,48,64,4,64,65,64,4,64,70,64,4,128,76,139,
105,64,62,64,4,64,59,64,4,64,76,64,4,64,72,64,4,64,62,64,4,64,57,64,0,64,
32,64,4,64,65,64,4,64,62,64,4,64,65,2,29,24,82,55,2,251,17,229,64,4,74,
64,44,2,166,64,4,64,53,64,4,64,59,64,4,64,75,64,4,64,57,64,0,64,32,64,4,
64,54,64,4,64,53,64,4,64,61,64,4,64,73,2,10,125,74,51,74,2,53,64,4,73,62,
6,43,1,41,64,50,64,4,64,48,64,4,64,59,64,4,64,66,64,4,64,48,64,4,64,50,
64,4,64,48,64,4,64,61,64,4,64,61,2,18,36,64,86,64,4,64,50,64,4,64,61,64,
4,64,79,64,4,64,66,64,4,128,56,147,136,64,48,64,4,74,63,18,1,27,64,4,72,
86,6,2,51,244,64,56,2,51,160,73,56,23,153,64,4,64,49,64,4,64,48,64,4,64,
66,64,4,64,76,2,1,136,72,53,89,64,4,64,49,64,4,73,56,28,67,64,4,72,55,6,
2,1,76,64,54,64,4,64,48,64,4,64,66,64,4,128,76,152,226,192,48,5,64,4,72,
66,22,64,4,64,53,64,4,64,59,64,4,64,76,64,4,64,65,2,1,100,64,61,64,4,64,
53,64,4,128,70,148,40,64,75,64,4,64,50,64,4,64,48,2,29,208,64,52,64,4,64,
61,64,4,72,86,14,64,4,64,70,64,4,128,67,192,111,70,64,56,64,4,64,70,64,
4,136,79,6,192,111,70,128,48,192,111,70,72,59,83,64,4,64,67,64,4,64,63,
64,4,72,59,43,64,4,72,79,18,64,4,64,66,64,4,136,76,5,167,16,128,56,167,
16,64,78,64,4,64,50,64,4,64,48,64,4,64,66,64,4,128,56,167,16,192,48,192,
71,196,64,4,64,66,64,4,72,76,5,1,4,64,56,64,4,64,65,64,4,128,79,0,64,57,
64,4,64,62,64,4,64,49,64,4,72,67,14,64,4,64,50,64,4,64,48,2,21,94,128,48,
5,73,84,6,92,1,90,72,69,58,64,4,64,67,64,4,64,79,64,4,64,71,64,4,72,67,
22,64,4,64,50,64,4,64,48,64,4,64,66,64,4,128,56,192,80,23,64,56,64,4,64,
66,64,4,136,76,6,192,80,23,128,56,192,80,23,64,65,64,4,64,64,64,4,64,48,
64,4,64,61,64,4,64,53,64,4,192,70,1,64,4,128,76,1,64,87,64,4,64,49,64,4,
72,86,35,64,4,72,55,14,64,4,136,79,5,152,226,128,76,152,226,64,54,64,4,
64,48,64,4,64,66,64,4,128,56,152,226,64,48,64,4,72,66,49,64,4,72,56,13,
64,4,64,65,64,4,128,79,137,126,64,53,64,4,64,59,64,4,64,76,64,4,64,65,64,
4,64,76,64,4,64,58,64,4,64,56,64,4,128,57,6,64,61,64,4,64,53,64,4,64,70,
64,4,128,76,148,40,64,62,64,4,72,62,24,64,4,72,68,6,2,27,62,64,63,64,4,
64,62,64,4,64,64,2,44,154,64,59,64,4,64,62,64,4,64,66,64,4,64,62,64,4,64,
57,64,0,64,32,64,4,64,52,64,4,64,62,64,4,64,54,64,4,64,52,2,36,27,72,145,
44,64,4,64,50,64,4,64,48,64,4,64,59,64,4,64,66,64,4,64,67,64,4,64,50,64,
4,64,48,64,4,64,61,64,4,64,61,64,4,128,79,2,64,76,64,4,64,60,64,4,64,53,
64,4,64,61,64,4,64,86,64,4,64,70,64,4,64,70,64,4,128,48,192,149,5,82,53,
1,92,14,114,64,4,74,64,105,1,55,64,4,72,62,81,64,4,72,66,52,64,4,72,62,
17,64,4,64,60,64,4,64,48,64,4,128,61,171,159,64,56,64,4,72,71,17,64,4,64,
61,64,4,64,56,64,4,128,57,163,110,64,58,64,4,128,48,192,197,94,64,51,64,
4,64,53,64,4,64,61,64,4,64,61,64,4,64,56,64,4,128,57,132,103,64,53,64,4,
64,58,64,4,64,70,64,4,64,86,2,56,111,64,49,64,4,74,61,36,58,83,64,4,136,
79,6,192,142,44,64,67,64,4,64,66,64,4,192,76,192,142,44,64,4,64,65,64,4,
128,79,164,78,72,59,85,64,4,137,62,7,75,192,129,242,72,56,27,64,4,72,73,
10,64,4,128,53,192,89,215,64,50,64,4,64,75,64,4,128,57,177,183,64,48,64,
4,192,61,158,189,64,4,137,62,6,23,158,189,64,61,64,4,72,75,9,64,4,128,57,
158,189,128,48,158,189,64,75,64,4,128,57,158,189,128,79,192,129,242,64,
48,64,4,73,64,7,34,2,14,46,81,59,57,153,8,2,57,123,64,61,64,4,72,75,6,2,
14,41,64,67,64,4,64,66,2,39,137,136,70,6,192,203,107,64,66,64,4,200,76,
17,192,129,242,64,4,64,65,64,4,128,79,192,117,48,64,62,64,4,64,64,64,4,
64,56,64,4,128,57,150,113,64,79,64,4,64,58,64,4,64,67,64,4,64,59,64,4,64,
79,64,4,64,70,64,4,64,86,2,55,104,80,52,1,185,64,4,74,62,36,1,54,64,4,64,
59,64,4,64,49,64,4,64,62,64,4,72,57,9,64,4,64,62,1,4,64,53,64,4,128,49,
142,189,72,53,205,64,4,73,64,30,163,64,4,64,76,64,4,64,60,64,4,64,62,64,
4,64,50,64,4,64,75,64,4,128,57,155,13,64,50,64,4,72,67,76,64,4,64,72,64,
4,64,58,64,4,64,48,64,0,64,32,64,4,73,63,15,34,64,4,64,56,64,4,64,65,2,
33,245,80,52,43,213,64,4,64,53,64,4,64,72,64,4,64,53,2,22,193,64,66,64,
4,64,64,64,4,64,48,64,4,64,61,64,4,128,65,192,156,64,64,65,64,4,64,66,64,
4,64,50,64,4,64,53,64,4,64,61,64,4,64,61,64,4,73,62,7,24,2,27,69,64,56,
64,4,64,70,64,4,64,48,64,0,64,32,2,48,252,64,75,2,50,116,64,68,64,4,64,
59,64,4,64,62,64,4,64,64,64,4,64,48,64,4,64,70,64,4,72,86,5,1,4,64,56,64,
4,128,79,131,104,64,50,64,4,64,62,64,4,64,57,64,4,64,61,64,4,64,62,64,4,
64,57,64,0,64,32,64,4,64,63,64,4,64,64,64,4,64,62,64,4,64,61,64,4,64,56,
64,4,64,58,64,4,64,61,64,4,64,62,64,4,64,50,64,4,64,53,2,11,85,72,67,14,
64,4,64,63,64,4,128,48,192,111,70,64,64,64,4,72,62,45,64,4,64,71,64,4,72,
58,6,2,52,9,64,56,64,4,72,66,14,64,4,136,76,5,191,239,128,56,191,239,64,
59,64,4,64,58,64,4,128,48,134,155,64,56,64,4,64,65,64,4,72,66,31,64,4,72,
67,9,64,4,128,61,134,70,64,48,64,4,64,66,64,4,136,76,5,188,245,128,56,188,
245,64,61,64,4,64,56,64,4,64,66,64,4,136,76,6,192,71,243,128,56,192,71,
243,64,51,64,4,82,62,10,158,11,8,64,4,82,59,9,165,9,223,64,4,82,56,1,17,
1,40,64,4,64,57,64,0,64,32,64,4,73,61,13,138,64,4,80,53,16,242,2,6,107,
73,52,7,90,2,17,8,74,50,28,17,216,64,4,81,56,17,111,8,2,17,69,64,71,64,
4,64,56,64,4,64,66,2,17,78,72,49,6,2,17,111,64,48,64,4,82,61,17,161,20,
238,64,4,72,68,6,2,17,120,64,61,64,4,64,48,64,0,64,32,64,4,64,65,64,4,72,
84,6,2,17,123,64,53,64,4,64,60,2,20,98,74,58,8,18,18,2,17,141,80,55,17,
229,64,4,81,64,17,190,16,64,4,64,86,64,4,64,59,2,42,67,64,86,2,18,203,74,
66,8,18,179,2,18,11,73,64,7,72,2,18,63,72,63,6,2,18,87,64,62,64,4,72,68,
6,2,18,102,64,59,64,4,64,53,64,4,64,61,64,4,64,48,64,0,64,32,64,4,64,50,
64,4,64,62,64,4,64,52,64,4,64,62,64,4,64,61,64,4,64,48,64,4,64,84,2,20,
74,64,65,64,4,81,63,18,71,8,2,22,45,64,66,64,4,72,67,14,64,4,64,52,64,4,
64,53,2,22,13,64,48,64,4,64,64,2,35,226,64,53,64,4,64,61,64,4,64,76,64,
4,64,58,64,4,64,56,64,4,128,57,2,64,75,80,4,5,75,72,72,14,64,4,64,62,64,
4,64,60,2,35,167,64,57,64,0,64,32,64,4,74,62,64,3,77,64,4,73,68,7,36,2,
21,179,64,52,64,4,64,61,64,4,64,62,64,4,64,58,64,4,64,59,64,4,64,48,64,
4,64,65,2,47,172,64,71,64,4,64,48,64,4,64,64,64,4,64,62,64,4,64,50,2,14,
54,74,55,56,1,160,64,4,74,61,38,41,178,64,4,64,48,64,4,64,60,64,4,64,53,
64,4,64,61,64,4,64,56,64,4,64,66,64,4,80,75,20,37,2,41,157,80,56,20,39,
64,4,64,60,2,49,221,74,51,46,1,7,64,4,73,64,23,30,64,4,64,56,64,4,64,68,
64,4,64,68,64,4,64,56,2,44,226,80,62,19,119,2,16,23,64,67,64,4,64,65,2,
19,70,73,49,61,122,64,4,74,59,8,18,151,2,18,94,72,53,24,64,4,64,64,64,4,
72,58,6,2,18,247,64,53,64,4,64,60,2,40,81,64,48,64,4,72,59,14,64,4,64,53,
64,4,64,64,2,2,107,64,49,2,15,26,64,48,64,4,73,61,7,40,2,18,109,74,58,20,
5,11,64,4,64,66,64,4,64,64,64,4,64,56,2,3,67,64,55,64,4,64,56,64,4,64,48,
2,2,181,74,66,8,18,229,2,49,46,64,64,64,4,64,60,2,4,52,64,50,64,4,73,64,
19,70,64,4,64,48,64,4,64,71,64,4,64,56,2,39,42,72,62,32,64,4,72,65,6,2,
17,170,64,59,64,4,64,62,64,4,64,65,64,4,64,48,64,4,64,66,2,40,175,64,56,
64,4,72,52,6,2,37,191,64,48,64,4,64,51,2,19,136,64,75,64,4,64,63,64,4,64,
67,64,4,64,65,64,4,64,58,2,46,88,72,54,22,64,4,80,53,19,37,64,4,64,61,64,
4,80,73,48,198,2,1,180,64,52,64,4,73,62,7,62,2,17,17,64,53,64,4,73,52,7,
30,2,34,4,64,50,64,4,81,67,3,97,8,2,33,252,64,71,64,4,80,62,20,55,2,38,
184,64,64,64,4,64,53,64,4,64,50,64,4,64,53,64,4,64,61,2,19,179,64,75,64,
4,64,64,2,34,3,73,59,45,182,64,4,72,78,18,64,4,64,49,64,4,64,56,64,4,64,
60,2,40,14,64,56,64,4,64,59,64,4,64,56,64,4,64,63,64,4,64,67,2,48,64,72,
58,124,64,4,73,64,27,84,64,4,64,48,64,4,64,65,64,4,74,56,8,12,10,2,18,16,
64,48,2,1,222,73,56,17,36,64,4,80,66,45,129,64,4,64,48,2,3,22,64,48,64,
4,72,64,10,64,4,64,66,2,16,210,64,55,2,12,37,64,62,64,4,64,59,64,4,64,69,
64,4,64,62,64,4,64,55,2,45,113,80,67,17,214,64,4,64,59,64,4,64,76,64,4,
64,66,64,4,64,67,64,4,64,64,64,4,64,56,64,4,64,65,2,14,43,64,56,64,4,64,
65,64,4,64,63,2,17,111,72,61,92,64,4,73,53,51,74,64,4,73,51,7,24,2,2,160,
64,50,64,4,64,53,64,4,64,65,64,4,64,66,2,47,156,64,68,64,4,64,62,64,4,64,
64,64,4,64,60,64,4,64,48,2,1,132,64,48,64,4,72,71,6,2,15,200,64,52,64,4,
64,53,64,4,64,54,2,17,188,64,56,64,4,64,60,64,4,64,68,2,47,87,64,60,64,
4,73,62,25,64,64,4,72,59,6,2,18,26,64,52,64,4,64,53,64,4,64,59,2,28,82,
72,53,6,2,17,200,64,48,64,4,74,60,8,17,225,2,47,52,64,59,64,4,81,75,47,
27,8,2,32,134,64,76,64,4,64,71,2,12,167,64,67,64,4,72,59,6,2,37,6,64,54,
64,4,64,71,64,4,64,56,2,13,26,74,68,18,1,126,64,4,72,56,6,2,18,223,64,53,
2,21,51,74,65,141,1,2,64,4,73,62,35,50,64,4,64,64,64,4,64,62,64,4,64,58,
64,4,64,62,64,4,64,59,64,4,64,53,64,4,64,66,2,38,7,80,59,18,110,64,4,64,
67,64,4,64,54,2,16,109,72,66,48,64,4,73,64,11,22,64,4,64,53,2,43,172,64,
48,64,4,64,64,64,4,2,27,79,64,67,64,4,64,52,64,4,64,53,64,4,64,61,64,4,
64,66,2,1,73,64,63,64,4,64,62,64,4,64,64,64,4,64,66,64,4,64,65,64,4,64,
60,64,4,64,53,64,4,192,61,192,156,64,2,46,101,72,64,6,2,17,144,64,63,64,
4,73,59,15,52,64,4,64,79,64,4,128,54,192,156,64,72,53,10,64,4,64,50,2,43,
204,64,48,64,4,72,70,10,64,4,64,48,2,41,91,64,64,64,4,64,53,64,4,64,61,
2,27,55,72,64,44,64,4,64,56,64,4,72,61,22,64,4,64,70,64,4,64,53,64,4,64,
65,64,4,64,65,2,46,12,64,58,64,4,64,62,64,4,128,59,192,156,64,64,62,64,
4,80,63,17,65,2,22,201,72,67,35,64,4,64,71,64,4,64,56,64,4,80,66,42,229,
64,4,64,53,64,4,64,59,64,4,192,76,192,156,64,2,43,83,64,66,64,4,73,62,7,
56,2,16,165,72,53,24,64,4,74,61,8,45,184,2,16,174,64,59,64,4,80,62,16,194,
2,43,77,64,48,64,4,64,61,64,4,64,70,64,4,64,62,64,4,64,50,64,4,64,73,2,
43,27,64,81,64,4,80,66,42,143,2,19,199,73,72,17,52,64,4,80,62,17,77,64,
4,64,66,2,17,23,72,71,18,64,4,64,67,64,4,64,64,64,4,64,49,2,15,23,64,69,
64,4,64,62,64,4,64,69,64,4,64,59,2,30,176,72,79,24,64,4,64,63,64,4,64,62,
64,4,64,61,64,4,80,62,45,64,2,42,221,64,77,64,4,72,64,10,64,4,64,56,2,45,
44,64,60,64,4,192,62,192,156,64,2,42,195,64,0,64,32,64,4,74,61,60,1,235,
64,4,72,53,26,64,4,64,51,64,4,64,64,64,4,64,56,64,4,64,66,64,4,64,79,2,
35,34,64,48,64,4,72,71,6,2,1,64,64,65,64,4,64,66,64,4,64,48,64,4,64,94,
2,2,122,73,49,55,248,64,4,73,59,27,40,64,4,64,48,64,4,64,61,64,4,64,52,
64,4,64,55,64,4,64,86,2,34,230,64,48,64,4,64,49,64,4,64,67,2,10,173,64,
64,64,4,64,67,2,13,162,73,22,7,84,2,14,249,72,19,68,64,4,64,48,64,4,64,
61,64,4,64,61,64,4,64,48,64,0,64,32,64,4,72,65,10,64,4,64,53,2,10,209,64,
33,64,4,64,53,64,4,64,60,64,4,64,79,64,4,64,61,64,4,64,62,64,4,64,50,64,
4,64,86,2,13,180,64,16,64,4,64,59,2,13,198,72,48,72,64,4,81,61,34,58,44,
64,4,64,68,64,4,64,56,64,4,64,65,64,4,64,48,64,0,64,32,64,4,64,39,64,4,
64,77,64,4,64,69,64,4,64,48,2,13,193,64,68,64,4,80,86,13,197,64,4,64,70,
64,4,64,75,64,4,64,79,2,15,139,64,26,64,4,64,65,64,4,64,53,64,4,64,61,64,
4,64,86,64,4,64,79,64,0,64,32,64,4,64,33,64,4,64,48,2,13,242,73,52,27,84,
64,4,64,55,64,4,64,79,64,4,64,94,64,4,64,71,64,4,64,75,2,9,115,72,51,6,
2,10,49,64,50,64,4,72,75,22,64,4,64,69,64,4,64,48,64,4,64,50,64,4,64,48,
2,1,63,64,62,64,4,64,65,64,4,64,63,64,4,64,56,64,4,64,66,64,4,64,48,2,40,
149,72,60,48,64,4,72,53,20,64,4,64,52,64,4,80,65,14,65,64,4,64,79,2,14,
18,64,48,64,4,72,66,6,2,14,29,64,59,64,4,64,48,64,4,64,52,2,34,213,64,55,
64,4,72,62,6,2,11,40,64,61,64,4,64,48,64,4,64,58,64,4,64,48,64,4,64,60,
64,4,64,86,64,4,64,66,64,4,64,48,64,4,64,65,64,4,64,70,2,24,63,73,68,7,
178,2,15,12,73,65,61,126,64,4,73,63,11,28,64,4,64,48,2,14,169,64,48,64,
4,64,58,64,4,64,64,64,4,64,48,2,10,183,64,66,64,4,72,67,14,64,4,64,52,64,
4,64,77,2,14,116,64,48,64,4,64,59,2,34,94,72,64,18,64,4,64,67,64,4,64,65,
64,4,64,58,2,11,199,64,63,64,4,72,64,22,64,4,64,75,64,4,64,51,64,4,64,62,
64,4,64,54,2,34,50,64,48,64,4,64,52,64,4,64,59,64,4,64,53,64,4,64,66,2,
12,190,72,67,6,2,14,157,64,66,64,4,73,53,9,14,64,4,2,13,167,64,48,2,13,
117,64,77,64,4,64,61,64,4,64,86,64,4,64,65,64,4,64,86,2,13,134,74,72,50,
14,126,64,4,72,58,26,64,4,64,62,64,4,64,59,64,4,64,76,64,4,64,61,64,4,64,
86,2,39,234,64,48,64,4,64,63,64,4,64,86,64,4,64,58,2,4,103,72,70,22,64,
4,64,79,64,4,64,54,64,4,64,48,64,4,64,64,2,11,31,64,69,64,4,64,48,64,4,
64,66,64,4,64,61,64,4,64,79,64,4,64,79,64,0,64,32,64,4,64,51,64,4,64,48,
64,4,64,65,64,4,64,63,64,4,64,48,64,4,64,52,64,4,64,75,64,4,64,61,2,16,
57,64,50,64,4,72,61,30,64,4,72,79,14,64,4,64,66,64,4,128,76,192,88,192,
192,62,189,16,64,4,64,53,2,1,95,64,53,64,4,64,61,64,4,64,61,64,4,72,75,
5,1,4,64,56,64,4,128,57,5,64,60,64,4,73,62,121,171,64,4,73,65,42,70,64,
4,64,53,64,4,64,58,64,4,64,65,64,4,64,67,64,4,64,48,64,4,192,59,192,151,
50,64,4,72,86,5,1,118,64,56,1,114,64,53,64,4,64,64,64,4,64,62,64,4,64,66,
64,4,64,56,64,4,64,71,64,4,64,61,1,36,64,77,64,4,64,64,64,4,64,62,64,4,
64,66,64,4,64,56,64,4,64,71,64,4,64,53,64,4,64,65,64,4,64,58,64,4,64,56,
64,4,128,57,192,94,103,72,56,5,1,49,64,48,64,4,64,65,64,4,64,77,64,4,64,
58,64,4,64,65,64,4,64,67,64,4,64,48,64,4,64,59,64,4,64,86,64,4,64,55,64,
4,128,60,192,127,224,64,86,64,4,128,58,157,150,72,59,62,64,4,64,67,64,4,
64,49,64,4,64,62,64,4,64,58,64,4,64,56,64,4,64,57,64,0,64,32,64,4,64,51,
64,4,64,59,64,4,64,62,64,4,64,66,64,4,64,48,64,4,64,61,64,4,64,56,2,24,
68,64,48,64,4,73,59,19,24,64,4,64,86,64,4,64,55,64,4,64,61,2,16,26,64,50,
2,30,19,64,61,64,4,64,52,64,4,64,62,64,4,128,61,135,51,72,86,42,64,4,64,
50,64,4,64,61,64,4,72,79,14,64,4,64,66,64,4,128,56,192,88,192,192,62,189,
16,64,4,64,87,64,4,128,52,192,87,19,64,64,64,4,64,67,64,4,64,63,64,4,72,
63,7,64,4,1,2,64,62,64,4,64,50,64,4,64,67,64,4,64,69,64,4,128,48,131,10,
64,54,64,4,72,62,57,64,4,64,63,64,4,73,61,10,28,64,4,128,79,147,20,72,53,
13,64,4,64,61,64,4,128,76,147,20,128,48,192,76,226,64,62,64,4,64,72,64,
4,64,61,64,4,64,56,64,4,128,58,154,72,64,53,64,4,72,65,28,64,4,64,66,64,
4,64,58,64,4,64,56,64,4,64,57,64,0,64,32,64,4,2,2,5,64,61,64,4,64,65,64,
4,64,58,64,4,64,56,64,4,64,57,64,0,64,32,64,4,2,37,50,73,57,102,212,64,
4,64,62,64,4,64,49,64,4,73,59,34,64,64,4,64,48,64,4,192,61,158,189,64,4,
73,56,10,14,64,4,128,57,158,189,128,48,158,189,128,62,158,189,64,48,64,
4,200,64,13,192,93,50,64,4,128,76,192,93,50,64,61,64,4,64,56,64,4,128,57,
192,129,242,64,61,64,4,64,67,64,4,64,66,64,4,64,56,64,4,64,65,64,4,128,
79,164,78,64,56,64,4,73,61,13,89,64,4,64,66,64,4,2,42,87,64,55,64,4,72,
61,44,64,4,64,48,64,4,64,65,64,4,64,56,64,4,64,59,64,4,64,62,64,4,64,50,
64,4,64,48,64,4,64,61,64,4,64,56,64,4,128,53,2,64,51,64,4,64,62,64,4,64,
50,64,4,64,61,64,4,64,79,64,4,64,66,64,4,128,76,147,136,64,63,64,4,64,48,
64,4,64,66,64,4,64,76,2,43,2,64,58,64,4,73,62,11,64,64,4,64,63,2,27,119,
73,56,11,28,64,4,64,70,2,4,231,64,48,64,4,64,60,64,4,64,72,64,4,64,62,2,
5,56,64,59,64,4,72,86,5,1,4,64,56,64,4,64,66,64,4,64,62,64,4,128,64,157,
133,72,67,113,64,4,72,64,17,64,4,64,50,64,4,64,56,64,4,128,61,161,39,64,
61,64,4,73,61,47,59,64,4,72,86,13,64,4,64,59,64,4,64,86,1,12,64,56,64,4,
64,59,64,4,64,56,64,4,64,61,64,4,64,51,64,4,64,67,64,4,128,65,144,172,64,
56,64,4,64,59,64,4,64,56,1,12,64,86,64,4,64,59,64,4,64,86,64,4,64,61,64,
4,64,51,64,4,64,67,64,4,128,65,128,203,64,64,64,4,64,53,64,4,64,60,64,4,
64,63,64,4,64,48,2,29,239,82,68,1,20,35,97,64,4,73,62,82,191,64,4,64,66,
64,4,64,62,72,4,23,64,63,64,4,64,62,64,4,64,64,64,4,64,61,64,4,128,62,146,
145,64,0,64,32,64,4,73,60,7,24,2,37,230,64,55,64,4,64,62,64,4,64,62,64,
4,64,68,2,9,234,64,66,64,4,64,64,64,4,64,48,64,4,128,69,192,156,64,73,56,
16,55,64,4,64,65,64,4,64,66,64,4,1,113,64,53,64,4,64,66,64,4,64,56,64,4,
64,72,64,0,64,32,64,4,72,62,6,2,27,228,64,61,64,4,64,62,64,4,64,54,2,37,
165,64,59,64,4,64,48,64,4,64,51,64,4,64,53,64,4,64,59,64,4,72,79,13,64,
4,64,70,64,4,64,86,1,16,64,59,64,4,64,79,64,4,64,70,64,4,64,56,64,4,128,
79,192,187,145,72,86,27,64,4,64,65,64,4,64,66,64,4,72,86,5,1,4,64,56,64,
4,64,61,2,26,153,64,64,64,4,64,56,64,4,64,51,64,4,72,86,17,64,4,64,52,64,
4,64,61,64,4,64,56,1,16,64,56,64,4,64,52,64,4,64,61,64,4,64,75,64,4,128,
57,192,107,129,82,64,1,133,25,119,64,4,72,62,101,64,4,72,65,61,64,4,64,
63,64,4,72,86,19,64,4,64,55,64,4,64,52,64,4,72,86,35,2,21,249,64,56,64,
4,64,55,64,4,64,52,64,4,72,86,17,64,4,64,66,64,4,192,56,192,157,78,2,10,
2,64,79,1,65,64,55,64,4,64,63,64,4,72,86,103,64,4,64,55,64,4,64,52,64,4,
72,86,102,64,4,64,66,64,4,64,56,2,9,219,64,48,64,4,72,65,61,64,4,64,63,
64,4,64,56,64,4,64,55,64,4,64,52,64,4,72,79,27,64,4,192,57,192,78,32,64,
4,64,65,64,4,64,66,64,4,64,50,64,4,2,1,115,64,53,64,4,64,66,64,4,64,76,
2,9,154,64,55,72,4,195,73,63,23,184,64,4,64,56,64,4,64,55,64,4,64,52,64,
4,64,79,2,1,67,72,52,54,64,4,64,62,64,4,64,59,64,4,64,49,64,4,64,48,64,
4,64,61,64,4,64,75,64,4,64,57,64,0,64,32,64,4,64,63,64,4,64,56,64,4,64,
59,64,4,64,62,2,36,30,64,50,64,4,64,64,64,4,64,48,64,4,64,66,64,4,64,61,
64,4,64,75,64,4,64,57,64,0,64,32,64,4,73,65,9,64,64,4,2,7,162,73,63,15,
34,64,4,64,62,64,4,64,55,2,35,238,64,60,64,4,80,62,35,205,64,4,64,61,64,
4,64,48,2,21,57,64,64,64,4,64,75,64,4,64,54,64,4,64,53,64,4,64,61,2,3,41,
80,77,32,40,64,4,64,60,2,32,42,64,74,64,4,64,53,1,10,64,0,64,39,64,4,64,
87,64,4,64,49,64,4,64,48,1,135,82,62,9,198,14,0,64,4,74,63,157,8,86,64,
4,72,86,25,64,4,64,55,64,4,64,52,64,4,64,56,64,4,64,61,64,4,64,86,1,26,
64,56,64,4,64,55,64,4,64,52,64,4,72,56,93,64,4,64,61,64,4,72,86,45,64,4,
64,66,64,4,136,56,5,167,221,64,53,64,4,64,59,64,4,64,76,64,4,64,61,64,4,
136,62,6,192,78,32,64,56,64,4,128,57,192,78,32,64,56,64,4,64,66,64,4,64,
53,64,4,64,59,64,4,64,76,64,4,64,61,64,4,72,75,10,64,4,128,57,192,78,32,
128,62,192,78,32,64,53,64,4,64,61,64,4,64,53,64,4,64,66,64,4,128,76,167,
221,74,52,66,7,156,64,4,64,63,64,4,72,86,5,1,4,64,56,64,4,64,55,64,4,64,
52,64,4,72,79,22,64,4,64,71,64,4,64,56,64,4,64,66,64,4,128,56,192,66,5,
64,56,64,4,64,66,64,4,192,56,192,78,32,2,7,220,80,51,2,149,64,4,64,62,64,
4,64,59,64,4,64,53,64,4,64,61,64,4,64,56,64,4,64,57,64,0,64,32,64,4,74,
61,36,1,165,64,4,64,48,64,4,64,71,64,4,64,48,64,4,64,59,64,4,64,76,64,4,
64,61,64,4,64,56,2,5,211,73,52,71,224,64,4,72,86,28,64,4,64,50,64,4,64,
71,64,4,64,56,64,4,64,61,64,4,80,58,34,88,2,34,82,64,62,64,4,64,60,64,4,
64,62,64,4,64,51,64,4,64,62,64,4,64,65,64,4,64,63,64,4,64,62,64,4,64,52,
2,1,222,73,50,67,144,64,4,72,56,40,64,4,64,69,64,4,64,62,64,4,64,50,64,
4,64,48,64,4,80,66,31,16,64,4,64,53,64,4,64,59,64,4,64,76,2,33,251,64,48,
64,4,64,51,64,4,64,86,64,4,64,66,64,4,64,61,2,33,234,72,49,16,64,4,72,64,
6,2,2,210,64,59,2,2,151,64,48,64,4,74,61,40,3,117,64,4,72,68,10,64,4,64,
86,2,2,212,64,61,64,4,64,48,64,0,64,32,64,4,64,65,64,4,64,84,64,4,2,3,9,
64,55,64,4,64,86,64,4,64,48,64,4,128,66,192,156,64,64,51,64,4,64,86,2,3,
81,73,58,51,132,64,4,73,65,19,40,64,4,64,53,64,4,64,61,64,4,64,86,2,3,115,
64,64,64,4,64,48,64,4,64,65,64,4,64,56,64,4,64,50,2,24,165,64,86,2,30,193,
72,55,44,64,4,72,86,6,2,1,34,64,61,64,4,64,48,64,4,64,60,64,4,64,53,64,
4,64,61,64,4,64,56,64,4,64,66,64,4,64,86,2,3,112,64,54,64,4,64,48,64,4,
64,61,64,4,64,61,64,4,64,48,64,0,64,32,64,4,64,68,64,4,64,64,64,4,64,86,
2,3,133,64,60,64,4,81,53,3,173,8,2,3,140,64,62,64,4,64,59,64,4,64,62,64,
4,64,52,2,24,50,73,66,59,167,64,4,72,62,10,64,4,64,50,2,3,198,64,53,64,
4,72,61,10,64,4,64,86,2,3,210,64,59,64,4,64,53,64,4,64,50,64,4,64,53,64,
4,64,52,64,4,64,67,64,4,64,71,2,23,247,73,64,31,74,64,4,64,62,64,4,64,65,
64,4,64,86,64,4,64,57,64,4,64,65,64,4,64,76,2,3,210,72,63,22,64,4,64,86,
64,4,64,52,64,4,64,59,64,4,64,86,2,3,218,64,62,64,4,64,68,64,4,64,86,64,
4,64,70,64,4,64,86,2,3,230,64,65,64,4,72,63,6,2,3,238,64,53,64,4,64,58,
64,4,64,64,64,4,64,53,64,4,64,66,64,4,64,48,1,23,74,72,28,4,73,64,4,64,
58,64,4,64,62,64,4,64,59,64,4,64,79,64,4,64,64,2,32,44,80,68,4,32,64,4,
64,86,2,4,9,64,49,64,4,74,62,52,4,114,64,4,64,65,64,4,72,70,17,64,4,64,
48,64,4,64,66,64,4,128,76,134,137,64,65,64,4,64,48,64,4,64,66,64,4,64,76,
64,4,64,65,64,4,128,79,178,252,80,61,4,0,64,4,64,48,64,4,64,54,64,4,64,
53,64,4,64,61,64,4,80,61,3,225,64,4,64,75,64,4,64,57,64,0,64,32,64,4,74,
61,20,2,152,64,4,64,48,64,4,64,71,64,4,64,48,2,3,131,74,52,56,1,122,64,
4,72,62,34,64,4,64,60,64,4,64,62,64,4,64,69,64,4,64,62,64,4,64,55,64,4,
64,79,64,4,64,57,2,31,132,64,53,64,4,64,50,64,4,80,67,17,13,2,16,215,74,
50,42,1,45,64,4,64,62,64,4,64,65,64,4,64,63,64,4,64,56,64,4,64,66,64,4,
64,48,64,4,80,66,28,88,64,4,64,53,2,3,33,72,49,74,64,4,73,59,23,56,64,4,
64,62,64,4,64,61,64,4,64,52,64,4,64,56,2,21,88,64,53,64,4,64,64,64,4,64,
53,64,4,64,60,64,4,64,53,64,4,64,61,64,4,64,61,64,4,64,48,2,5,79,64,64,
64,4,64,78,64,4,64,61,2,30,249,64,48,64,4,73,61,105,160,64,4,72,68,33,64,
4,64,56,64,4,64,65,64,4,64,48,64,0,64,32,64,4,64,71,64,4,64,53,64,4,64,
69,1,62,64,61,64,4,64,48,64,0,64,32,64,4,64,65,64,4,64,53,64,4,72,60,30,
64,4,64,53,64,4,64,61,64,4,64,62,64,4,64,50,64,4,64,56,64,4,128,71,192,
156,64,64,52,64,4,64,48,64,4,64,58,64,4,64,62,1,50,80,59,20,128,64,4,64,
53,64,4,64,61,64,4,64,48,64,0,64,32,64,4,64,50,64,4,64,62,64,4,64,52,64,
4,64,62,64,4,64,61,64,4,64,48,64,4,64,53,64,4,64,50,2,30,97,64,68,64,4,
64,64,64,4,64,56,64,4,64,58,64,4,64,48,2,20,113,64,51,64,4,64,56,64,4,64,
60,64,4,64,61,64,4,64,48,2,1,60,73,58,75,180,64,4,81,64,27,140,24,64,4,
64,48,64,4,64,65,64,4,64,56,64,4,64,50,2,21,202,64,65,64,4,64,53,64,4,64,
61,64,4,64,56,64,4,64,79,64,0,64,32,64,4,64,65,64,4,64,62,64,4,64,49,64,
4,64,71,64,4,64,48,2,1,75,72,55,60,64,4,72,61,38,64,4,64,48,64,4,64,60,
64,4,64,53,64,4,64,61,64,4,64,56,64,4,64,66,64,4,64,62,64,4,64,65,2,10,
201,64,50,64,4,64,53,64,4,64,55,64,4,64,52,2,29,176,64,54,64,4,64,48,64,
4,64,61,64,4,64,61,64,4,64,48,64,0,64,32,64,4,64,68,64,4,64,64,64,4,64,
56,64,4,64,65,64,4,64,58,2,12,250,64,60,64,4,73,53,32,61,64,4,64,52,64,
4,72,65,46,64,4,64,53,64,4,64,65,64,4,64,66,64,4,64,64,2,29,95,64,48,64,
4,64,66,64,4,64,53,64,4,64,60,64,4,64,48,64,4,64,66,64,4,64,56,2,26,225,
64,62,64,4,64,59,64,4,64,62,64,4,64,52,64,4,64,62,2,20,226,73,66,83,240,
64,4,72,62,18,64,4,64,59,64,4,64,65,64,4,64,66,2,14,111,64,53,64,4,72,61,
26,64,4,64,61,64,4,64,56,64,4,64,65,64,4,64,56,64,4,64,65,2,28,239,64,59,
64,4,64,53,64,4,64,50,64,4,64,53,64,4,64,52,64,4,64,67,64,4,64,73,2,20,
25,73,64,23,90,64,4,64,67,64,4,64,65,64,4,64,65,64,4,64,58,2,20,2,72,63,
38,64,4,64,62,64,4,64,52,64,4,64,64,64,4,64,62,64,4,64,65,64,4,64,66,64,
4,64,62,64,4,128,58,192,156,64,64,62,64,4,64,68,64,4,64,56,64,4,64,70,64,
4,64,56,64,4,64,48,64,4,64,61,2,28,120,64,65,64,4,72,63,30,64,4,64,62,64,
4,64,64,64,4,64,66,64,4,64,65,64,4,64,60,64,4,64,53,2,18,131,64,53,64,4,
64,58,64,4,64,64,64,4,64,53,64,4,64,66,64,4,64,48,64,4,64,64,64,4,64,72,
2,28,61,73,72,23,58,64,4,64,58,64,4,64,62,64,4,64,59,64,4,64,76,2,25,168,
72,68,22,64,4,64,56,64,4,64,55,64,4,64,64,64,4,64,67,2,25,175,64,67,64,
4,64,71,64,4,64,56,2,25,2,64,79,64,4,64,63,64,4,64,62,2,18,27,64,58,64,
4,128,48,192,117,48,64,52,64,4,64,64,64,4,64,56,64,4,64,65,64,4,64,66,64,
4,64,48,64,4,72,66,24,64,4,200,76,7,131,222,1,4,64,56,64,4,64,65,64,4,128,
79,131,222,192,61,131,222,64,4,64,56,64,4,128,57,131,222,72,86,38,64,4,
64,65,64,4,64,70,64,4,64,79,64,4,64,66,64,4,136,76,5,134,137,64,56,64,4,
64,65,64,4,128,79,178,252,64,65,64,4,64,56,64,4,64,64,64,4,64,48,64,4,64,
66,64,4,200,76,7,182,94,1,6,192,56,182,94,64,4,64,65,64,4,128,79,182,94,
64,61,64,4,64,48,64,4,64,61,64,4,72,86,5,1,4,64,56,64,4,64,55,64,4,128,
60,142,163,73,66,171,206,64,4,73,66,40,132,64,4,64,64,64,4,64,48,64,4,64,
69,64,4,64,48,64,4,72,66,13,64,4,192,76,192,117,48,2,31,24,128,61,192,117,
48,72,63,59,64,4,64,56,64,4,64,55,64,4,64,52,64,4,72,79,22,64,4,64,71,64,
4,64,56,64,4,64,66,64,4,128,76,192,66,5,64,56,64,4,64,66,64,4,192,76,192,
78,32,64,4,64,65,2,7,11,64,57,64,4,64,62,64,4,64,49,64,4,64,67,64,4,64,
50,64,4,64,48,64,4,64,66,64,4,128,56,192,117,48,64,74,64,4,64,53,64,4,64,
49,64,4,64,75,64,4,64,50,64,4,64,48,64,4,64,66,64,4,128,76,192,117,48,64,
64,64,4,64,51,64,4,73,56,6,18,1,16,64,48,64,4,64,55,64,4,128,60,158,122,
64,86,64,4,128,79,192,65,64,64,69,64,4,64,67,64,4,73,84,19,86,64,4,72,61,
90,64,4,64,61,64,4,64,56,1,46,72,56,29,64,4,64,66,64,4,64,53,64,4,64,59,
64,4,64,76,64,4,64,61,64,4,64,75,1,93,64,53,64,4,72,61,17,64,4,64,61,64,
4,64,75,64,4,128,57,139,6,64,50,64,4,64,48,64,4,64,66,64,4,128,76,192,123,
219,72,87,27,64,4,72,66,5,1,25,64,50,64,4,64,48,64,4,64,66,64,4,128,56,
192,123,219,64,86,64,4,64,66,64,4,64,53,64,4,64,59,64,4,64,76,64,4,64,61,
64,4,64,56,64,4,128,57,192,87,155,80,61,2,37,64,4,74,56,22,2,14,64,4,80,
69,2,11,64,4,64,67,64,4,128,79,192,156,64,72,53,159,64,4,73,57,33,125,64,
4,64,62,64,4,64,49,64,4,64,67,64,4,64,50,64,4,64,48,64,4,64,66,64,4,128,
56,11,73,53,30,63,64,4,64,49,64,4,72,75,91,64,4,64,50,64,4,64,48,64,4,64,
66,64,4,128,76,11,64,50,64,4,64,56,64,4,64,61,64,4,64,61,64,4,72,86,41,
64,4,64,65,64,4,64,66,64,4,128,76,139,252,64,55,64,4,64,48,64,4,64,57,64,
4,64,60,64,4,64,48,64,4,64,61,64,4,64,56,2,23,29,72,84,20,64,4,64,49,64,
4,64,48,64,4,64,59,64,4,128,62,11,64,69,64,4,64,67,2,16,213,64,48,64,4,
73,65,65,217,64,4,73,65,18,43,64,4,64,48,64,4,64,66,64,4,128,76,146,224,
64,64,64,4,64,48,64,4,72,66,9,64,4,128,76,163,18,64,59,64,4,128,86,163,
18,64,70,64,4,64,79,64,4,64,66,64,4,128,56,146,224,73,53,47,119,64,4,64,
49,64,4,72,75,21,64,4,64,50,64,4,64,48,64,4,64,66,64,4,128,76,164,163,64,
61,64,4,64,67,64,4,64,66,64,4,64,76,1,220,72,51,28,64,4,72,62,14,64,4,72,
66,13,64,4,128,48,142,159,64,56,64,4,128,57,192,70,201,64,49,64,4,64,55,
64,4,64,52,64,4,73,84,6,19,1,4,64,53,64,4,64,66,64,4,128,76,192,80,91,64,
86,64,4,64,66,64,4,128,56,192,80,91,72,64,25,64,4,64,62,64,4,64,52,64,4,
64,58,64,4,64,48,64,4,128,94,148,226,64,57,64,4,64,62,1,11,73,84,6,91,1,
89,72,79,29,64,4,64,49,64,4,64,67,64,4,64,50,64,4,64,48,64,4,64,66,64,4,
128,56,164,163,64,69,64,4,64,67,64,4,72,79,28,64,4,64,64,64,4,64,56,64,
4,64,66,64,4,136,76,6,192,77,96,128,56,192,77,96,192,57,192,156,64,64,4,
64,61,64,4,64,56,64,4,128,58,192,95,210,64,87,64,4,64,49,64,4,64,61,64,
4,64,67,64,4,64,66,64,4,64,56,64,4,64,65,64,4,128,79,192,74,120,64,86,64,
4,64,51,64,4,64,53,64,4,128,64,192,87,63,64,60,64,4,74,62,95,1,112,64,4,
73,59,21,68,64,4,64,62,64,4,64,52,64,4,80,62,14,183,2,14,66,64,58,64,4,
64,64,64,4,64,62,64,4,64,73,64,4,72,62,13,64,4,64,59,64,4,64,58,1,14,64,
53,64,4,64,59,64,4,192,58,132,101,64,4,128,48,132,101,64,72,64,4,64,62,
64,4,64,61,64,4,64,58,64,4,128,48,139,228,72,56,72,64,4,64,61,64,4,72,76,
34,64,4,64,53,64,4,192,66,192,136,184,64,4,64,71,64,4,64,56,64,4,80,70,
1,27,64,4,128,48,167,16,64,53,64,4,192,66,192,149,5,64,4,64,71,64,4,64,
56,64,4,80,70,1,34,64,4,128,48,159,44,64,48,64,4,73,61,61,106,64,4,64,52,
64,4,72,62,26,64,4,64,50,64,4,64,62,64,4,64,72,64,4,64,58,64,4,128,48,192,
70,182,64,48,64,4,64,50,64,4,64,62,64,4,64,72,64,4,64,58,64,4,128,48,192,
77,53,64,59,64,4,72,62,32,64,4,64,59,64,4,64,53,64,4,64,66,64,4,64,58,64,
4,64,48,64,0,64,32,64,4,2,12,210,64,48,64,4,64,52,2,13,236,64,65,64,4,64,
66,64,4,64,67,64,4,64,64,64,4,64,49,64,4,73,56,30,51,64,4,64,64,64,4,64,
62,64,4,64,50,64,4,64,48,64,4,64,66,64,4,128,76,187,72,64,48,64,4,64,70,
64,4,72,86,5,1,4,64,56,64,4,128,79,146,99,64,67,64,4,64,50,64,4,64,48,64,
4,64,66,64,4,128,56,187,72,72,86,83,64,4,64,61,64,4,73,76,38,42,64,4,64,
84,64,4,192,66,192,136,184,64,4,64,71,64,4,64,56,64,4,72,70,9,64,4,128,
79,167,16,128,58,186,152,64,53,1,4,64,84,64,4,192,66,192,149,5,64,4,64,
71,64,4,64,56,64,4,72,70,9,64,4,128,79,159,44,128,58,185,158,64,67,64,4,
64,52,64,4,137,76,6,56,145,35,72,53,22,64,4,72,66,9,64,4,128,76,145,35,
64,59,64,4,128,76,145,35,192,48,156,213,64,4,136,58,5,183,213,64,55,64,
4,64,50,64,4,64,62,64,4,128,61,192,179,249,192,84,156,213,64,4,64,59,64,
4,128,76,145,35,64,63,64,4,82,62,3,168,7,3,64,4,82,64,2,84,3,13,64,4,82,
61,2,66,2,71,64,4,210,62,1,199,2,37,192,148,13,64,4,74,60,74,1,41,64,4,
200,67,46,192,148,13,64,4,64,59,64,4,64,76,64,4,64,66,64,4,64,68,64,4,72,
86,5,1,4,64,56,64,4,64,59,64,4,64,76,64,4,128,60,192,78,32,64,62,64,4,64,
52,64,4,64,53,64,4,64,59,64,4,128,76,192,123,80,73,54,27,109,64,4,64,67,
64,4,64,64,64,4,64,61,64,4,64,48,64,4,128,59,192,99,212,72,51,34,64,4,72,
64,24,64,4,64,48,64,4,64,68,64,4,72,86,6,2,4,145,64,56,2,4,140,128,62,192,
148,13,64,48,64,4,72,64,23,64,4,64,69,64,4,72,86,5,1,4,64,56,64,4,128,50,
192,156,64,64,58,64,4,64,66,64,4,64,64,64,4,64,56,64,4,64,65,2,1,74,72,
58,77,64,4,73,59,19,47,64,4,72,86,5,1,4,64,56,64,4,128,63,129,74,64,48,
64,4,64,65,64,4,72,65,7,64,4,1,2,64,53,64,4,64,66,64,4,128,48,192,168,4,
64,62,64,4,64,60,64,4,72,86,5,1,4,64,56,64,4,64,58,64,4,128,65,175,219,
64,55,64,4,72,86,13,64,4,64,64,64,4,64,58,1,16,64,50,64,4,64,53,64,4,64,
55,64,4,64,52,64,4,128,48,143,165,73,68,15,134,64,4,72,86,5,1,217,64,56,
1,213,72,64,78,64,4,73,53,23,44,64,4,64,65,64,4,64,67,64,4,64,64,64,4,128,
65,192,78,32,64,48,64,4,64,65,64,4,64,65,64,4,64,58,64,4,64,48,2,15,73,
64,62,64,4,64,55,64,4,64,63,64,4,64,62,64,4,64,50,64,4,64,86,64,4,64,52,
2,5,207,64,62,64,4,64,63,64,4,64,62,64,4,64,50,64,4,64,86,64,4,64,52,64,
4,64,48,64,4,64,61,64,4,64,61,64,4,128,79,192,78,32,64,71,64,4,64,48,64,
4,128,66,192,98,107,72,56,5,1,94,64,48,64,4,73,64,35,64,64,4,64,77,64,4,
64,65,64,4,64,67,64,4,64,64,64,4,64,65,64,4,64,48,64,4,128,94,192,78,32,
64,48,64,4,64,58,64,4,64,66,64,4,64,62,64,4,64,64,64,4,64,58,64,4,128,48,
192,74,127,64,68,64,4,64,86,64,4,64,59,64,4,64,76,64,4,128,60,192,137,229,
72,75,10,64,4,128,57,192,148,13,64,67,64,4,80,72,9,93,2,19,71,64,53,2,11,
178,64,84,2,11,173,73,53,7,113,2,1,28,72,52,93,72,4,71,64,64,64,4,72,62,
13,64,4,64,71,64,4,64,67,1,13,64,48,64,4,64,71,64,4,72,67,22,64,4,64,50,
64,4,64,48,64,4,64,66,64,4,128,56,192,156,64,64,56,64,4,64,50,64,4,64,48,
64,4,64,66,64,4,128,76,192,156,64,64,0,64,32,64,4,64,78,64,4,64,49,64,4,
64,58,2,2,202,64,50,64,4,64,86,64,4,128,79,192,181,244,64,63,64,4,72,86,
24,64,4,64,55,64,4,64,52,64,4,72,86,5,1,23,64,53,64,4,1,37,64,56,64,4,64,
55,64,4,64,52,64,4,72,86,14,64,4,64,66,64,4,128,56,192,105,123,64,53,64,
4,72,66,5,1,4,64,61,64,4,128,76,192,105,123,201,69,74,101,142,67,64,4,73,
62,42,51,64,4,72,66,17,64,4,64,61,64,4,64,56,64,4,128,58,137,154,64,50,
64,4,64,48,64,4,64,66,64,4,136,76,4,37,128,56,37,64,50,64,4,128,53,192,
94,27,64,67,64,4,136,78,6,192,156,64,128,57,192,156,64,64,65,64,4,64,64,
64,4,64,48,64,4,64,66,64,4,136,76,6,192,64,44,128,56,192,64,44,64,84,64,
4,64,49,64,4,72,62,25,64,4,64,66,64,4,64,56,64,4,192,61,192,192,163,64,
4,128,48,192,192,163,64,53,64,4,64,61,64,4,128,76,192,78,12,82,53,1,83,
1,229,64,4,73,61,19,204,64,4,72,86,5,1,4,64,56,64,4,128,65,164,60,72,55,
33,64,4,64,52,64,4,192,48,192,156,64,64,4,64,66,64,4,72,75,5,1,4,64,56,
64,4,128,57,150,90,64,52,64,4,73,62,23,49,64,4,64,68,64,4,72,86,5,1,4,64,
56,64,4,128,59,166,159,72,56,5,1,26,64,53,64,4,64,64,64,4,64,48,64,4,64,
65,64,4,128,66,192,221,232,72,86,9,64,4,128,58,167,11,64,64,64,4,73,76,
18,56,64,4,64,62,64,4,64,61,64,4,64,56,1,34,72,56,18,64,4,72,59,5,1,37,
64,50,64,4,64,48,1,37,64,53,64,4,64,61,64,4,64,61,64,4,64,75,64,4,128,57,
137,148,72,86,13,64,4,64,59,64,4,128,48,137,148,64,79,64,4,64,66,64,4,136,
76,5,137,148,128,56,137,148,72,66,26,64,4,64,66,64,4,72,86,5,1,4,64,56,
64,4,64,61,64,4,128,51,138,252,64,64,64,4,64,52,64,4,73,56,26,76,64,4,64,
59,64,4,64,76,64,4,64,61,64,4,64,56,64,4,128,58,135,8,72,53,11,64,4,64,
66,64,4,1,54,64,48,64,4,64,61,64,4,64,67,64,4,192,66,192,197,25,64,4,73,
75,6,15,1,4,64,56,64,4,128,57,192,197,25,128,76,192,197,25,72,86,13,64,
4,64,66,64,4,128,56,189,149,128,76,189,149,64,48,64,4,72,64,90,64,4,73,
61,49,61,64,4,72,67,14,64,4,64,65,64,4,128,53,192,156,64,64,48,64,4,64,
51,64,4,64,64,64,4,64,48,64,4,64,68,64,4,64,86,64,4,128,79,192,163,99,64,
48,64,4,64,72,64,4,128,48,158,11,64,67,64,4,64,72,64,4,64,75,64,4,64,61,
64,4,64,58,64,4,128,67,178,116,64,52,72,4,12,64,59,64,4,128,48,192,92,155,
64,0,64,32,64,4,64,65,64,4,64,63,64,4,64,48,64,4,64,52,64,4,64,61,64,4,
64,86,64,4,64,70,64,4,128,48,186,152,64,56,64,4,74,63,12,1,47,64,4,64,56,
2,2,166,80,55,1,0,64,4,64,52,64,4,73,67,7,176,2,3,107,73,56,27,100,64,4,
72,73,6,2,3,17,64,66,64,4,136,76,6,192,157,78,128,56,192,157,78,72,53,29,
64,4,81,66,2,161,12,64,4,128,76,192,157,78,192,70,192,86,19,64,4,128,76,
192,86,19,192,48,192,156,64,64,4,81,61,3,13,26,64,4,64,67,64,4,64,66,64,
4,80,76,2,232,64,4,64,65,2,2,234,64,66,64,4,80,75,3,0,2,2,254,64,62,64,
4,72,64,34,64,4,64,50,64,4,64,48,64,4,64,61,64,4,72,58,6,2,2,100,64,53,
64,4,192,70,148,80,2,2,101,64,49,64,4,80,64,2,104,64,4,64,48,64,4,64,66,
64,4,72,86,5,1,4,64,56,64,4,128,79,143,168,73,79,27,61,64,4,64,71,64,4,
64,56,64,4,64,66,64,4,136,76,5,152,220,128,56,152,220,72,78,29,64,4,81,
59,2,213,131,64,4,200,86,9,192,78,32,2,2,189,192,56,192,78,32,2,2,181,64,
76,2,1,216,64,86,64,4,64,66,2,2,28,64,52,64,4,74,53,8,2,252,2,2,189,64,
48,64,4,64,64,64,4,82,58,2,213,2,227,64,4,80,62,2,200,2,2,189,64,65,64,
4,73,76,14,59,64,4,64,58,64,4,128,48,154,76,64,48,64,4,64,78,64,4,64,73,
64,4,64,56,64,4,64,57,64,0,64,32,64,4,64,52,64,4,64,53,64,4,64,50,64,4,
64,67,64,4,64,72,2,14,154,128,79,159,16,74,75,44,1,48,64,4,64,72,64,4,64,
61,64,4,64,75,64,4,64,57,64,0,64,32,64,4,64,52,64,4,64,53,64,4,64,50,64,
4,64,62,2,12,13,64,64,64,4,73,62,146,220,64,4,73,63,67,128,64,4,72,86,25,
64,4,64,55,64,4,64,52,64,4,72,86,6,2,17,247,64,53,64,4,1,29,64,56,64,4,
64,55,64,4,64,52,64,4,72,86,6,2,17,223,64,53,64,4,72,66,5,1,4,64,61,64,
4,128,76,192,78,32,72,57,33,64,4,64,62,64,4,64,49,64,4,64,67,64,4,64,50,
64,4,64,48,64,4,64,66,64,4,128,56,147,220,64,53,64,4,64,49,64,4,64,75,64,
4,64,50,64,4,64,48,64,4,64,66,64,4,128,76,147,220,64,65,64,4,64,66,64,4,
64,56,1,53,72,53,37,64,4,64,55,64,4,64,53,64,4,64,64,64,4,64,50,64,4,64,
48,64,4,64,66,64,4,64,56,64,4,128,50,187,196,64,48,64,4,64,65,64,4,64,66,
64,4,64,75,64,4,64,66,64,4,64,67,64,4,64,66,64,4,64,58,64,4,128,48,192,
181,244,64,77,64,4,64,55,64,4,64,53,64,4,64,64,64,4,64,50,64,4,64,48,64,
4,64,66,64,4,64,75,64,4,128,94,187,196,64,86,64,4,74,63,37,1,148,64,4,64,
86,64,4,64,65,64,4,72,76,13,64,4,64,58,64,4,128,48,138,149,64,58,64,4,128,
48,192,103,52,72,55,254,64,4,64,52,64,4,73,76,15,184,64,4,64,62,64,4,128,
54,192,93,95,73,62,57,160,64,4,72,64,38,64,4,64,50,64,4,64,48,64,4,64,61,
64,4,72,58,9,64,4,128,48,139,88,64,53,64,4,64,70,64,4,128,76,148,80,64,
49,64,4,64,62,64,4,128,59,192,127,46,72,56,34,64,4,73,66,11,20,64,4,128,
56,192,157,78,64,59,64,4,128,62,192,157,78,64,73,64,4,128,48,192,78,32,
192,48,192,156,64,64,4,73,61,36,49,64,4,64,67,64,4,64,66,64,4,192,56,192,
157,78,64,4,72,65,10,64,4,128,79,192,120,63,128,57,192,157,78,64,49,64,
4,64,62,64,4,128,59,192,78,32,64,66,64,4,64,56,64,4,128,57,192,66,61,64,
67,64,4,128,61,192,78,32,73,79,22,52,64,4,64,71,64,4,64,56,64,4,64,66,64,
4,128,56,152,220,64,78,64,4,72,59,21,64,4,192,86,192,78,32,64,4,64,61,64,
4,128,48,192,153,102,128,58,192,78,32,64,84,64,4,128,70,192,86,19,64,52,
72,4,73,73,53,10,62,64,4,128,64,179,79,64,48,64,4,64,64,64,4,73,58,21,35,
64,4,72,86,10,64,4,128,50,192,138,24,128,48,192,138,24,64,48,64,4,136,65,
6,192,128,31,128,55,163,183,64,62,64,4,128,58,192,138,24,64,62,64,4,128,
64,174,142,64,0,64,32,64,4,64,65,64,4,64,63,64,4,64,86,64,4,64,52,64,4,
64,61,64,4,64,56,64,4,64,70,64,4,128,79,186,152,72,69,14,64,4,64,50,64,
4,128,48,192,94,27,64,65,64,4,136,79,5,159,16,64,76,64,4,64,58,64,4,128,
48,154,76,82,66,3,104,7,207,64,4,82,64,2,3,3,26,64,4,74,67,49,1,221,64,
4,64,65,64,4,72,75,26,64,0,64,32,64,4,64,50,64,4,64,56,64,4,64,49,64,4,
64,64,2,7,233,64,56,64,4,64,58,64,4,128,56,187,219,72,56,6,2,1,171,64,48,
64,4,73,65,51,202,64,4,64,50,64,4,64,53,64,4,64,65,64,4,64,66,64,4,64,56,
64,4,64,66,64,0,64,32,64,4,64,50,64,4,64,56,64,4,64,52,64,4,64,53,2,7,160,
64,61,64,4,64,65,72,4,76,72,65,49,64,4,64,53,64,4,64,58,64,4,64,65,64,4,
64,67,64,4,64,48,64,4,192,59,192,180,128,64,4,72,86,5,1,4,64,56,64,4,64,
55,64,4,128,60,174,122,64,50,64,4,64,53,64,4,64,65,64,4,64,66,64,4,64,56,
64,4,128,66,167,16,64,0,64,32,64,4,74,55,8,1,2,2,3,33,72,52,22,64,4,64,
62,64,4,64,65,64,4,64,67,64,4,128,51,192,156,64,64,49,64,4,64,53,64,4,64,
65,64,4,64,63,64,4,64,59,64,4,64,48,64,4,64,66,64,4,64,61,2,7,9,64,69,72,
4,89,72,61,20,64,4,64,67,64,4,64,66,64,4,80,76,13,247,2,14,127,64,48,64,
4,72,66,45,64,4,72,76,27,72,4,5,1,25,64,0,64,32,64,4,64,63,64,4,64,76,64,
4,64,79,2,1,104,64,56,64,4,64,65,64,4,128,79,192,110,162,64,53,64,4,64,
70,64,4,64,70,64,4,128,48,192,110,162,64,0,64,32,64,4,73,61,23,46,64,4,
64,53,64,4,64,62,64,4,64,63,64,4,64,75,2,1,41,72,55,6,2,1,193,64,48,64,
4,64,55,64,4,64,56,64,4,64,48,2,10,3,72,65,52,64,4,72,66,22,64,4,64,48,
64,4,64,64,64,4,64,67,64,4,64,69,2,9,240,64,53,64,4,64,65,64,4,64,66,64,
4,64,64,64,4,64,81,64,4,64,61,2,9,211,64,62,64,4,64,61,64,4,64,59,64,4,
64,48,64,4,64,57,2,4,229,64,86,64,4,64,63,64,4,72,63,14,64,4,64,53,64,4,
128,64,192,98,113,64,53,64,4,128,64,156,143,73,56,17,56,64,4,64,66,64,4,
80,76,1,22,2,7,240,64,53,64,4,64,65,64,4,64,66,64,4,64,56,64,4,64,58,64,
4,64,67,64,4,64,59,64,4,136,75,6,192,96,76,128,56,192,96,76,64,62,64,4,
73,59,118,170,64,4,64,65,64,4,64,66,64,4,72,75,41,64,4,64,57,64,0,64,32,
64,4,64,62,64,4,64,49,64,4,64,61,64,4,64,48,64,4,64,54,64,4,64,53,64,4,
64,61,1,59,64,67,64,4,72,72,25,64,4,64,58,64,4,64,48,64,0,64,32,64,4,64,
51,64,4,64,62,1,192,64,69,64,4,64,48,64,0,64,32,64,4,80,71,5,106,64,4,64,
48,64,4,64,65,64,4,64,66,64,4,64,61,1,162,64,50,64,4,64,65,64,4,64,66,64,
4,64,56,64,4,64,57,64,0,64,32,64,4,64,62,64,4,64,51,64,4,64,62,64,4,64,
59,64,4,64,53,64,4,64,61,64,4,64,56,1,114,64,94,64,4,64,65,64,4,64,66,64,
4,64,75,64,0,64,32,64,4,64,48,64,4,64,51,64,4,64,62,64,4,64,59,64,4,64,
53,64,4,64,61,64,4,128,75,192,156,64,72,86,25,64,4,64,66,64,4,64,53,64,
4,64,71,64,4,64,58,64,4,128,62,166,216,64,81,64,4,64,59,64,4,64,58,64,4,
64,48,64,0,64,32,64,4,64,55,64,4,64,64,64,4,64,53,64,4,64,59,64,4,64,75,
64,4,128,57,192,156,64,64,65,64,4,74,64,29,3,21,64,4,64,48,64,4,64,61,64,
4,72,75,5,1,4,64,56,64,4,128,57,192,71,178,74,56,43,2,9,64,4,64,65,64,4,
80,79,3,245,64,4,64,65,64,4,192,66,192,73,237,64,4,72,75,10,64,4,128,57,
192,73,237,128,62,192,73,237,73,50,107,175,64,4,72,86,31,64,4,64,61,64,
4,64,51,64,4,64,53,64,4,192,64,163,33,64,4,64,48,64,4,128,94,163,33,64,
56,64,4,64,61,64,4,64,51,72,4,11,64,53,64,4,128,64,163,33,64,0,64,32,64,
4,72,68,6,2,4,28,64,55,64,4,64,61,64,4,64,48,64,4,64,58,64,4,64,62,64,4,
64,60,64,4,64,65,64,4,64,66,64,4,64,50,2,3,255,64,48,64,4,64,52,64,4,201,
62,30,48,192,64,89,64,0,64,45,64,4,64,60,64,4,64,48,64,4,64,55,64,4,128,
62,192,64,89,64,56,64,4,72,65,5,1,17,64,55,64,4,128,60,192,129,108,64,75,
64,4,64,65,64,4,128,66,131,62,64,53,64,4,72,66,14,64,4,64,48,64,4,64,58,
2,2,87,64,58,64,4,208,65,1,13,192,147,28,64,4,73,62,23,145,64,4,64,52,64,
4,64,64,64,4,64,62,64,4,128,60,192,93,178,201,56,36,97,142,33,64,4,64,61,
64,4,64,52,64,4,64,67,64,4,64,65,64,4,64,66,64,4,64,64,64,4,64,56,1,196,
64,48,64,4,64,63,64,4,72,86,21,64,4,64,59,64,4,64,76,64,4,64,61,64,4,64,
86,1,20,64,56,64,4,64,59,64,4,64,76,64,4,64,61,64,4,64,62,64,4,64,65,64,
4,64,66,64,4,128,76,154,91,64,60,64,4,64,48,64,4,64,72,64,4,64,56,64,4,
64,61,64,4,128,48,192,86,235,73,72,15,76,64,4,64,62,64,4,128,63,192,117,
48,64,67,64,4,64,48,64,4,192,59,192,64,209,64,4,64,76,64,4,64,61,64,4,73,
62,6,15,1,14,72,56,5,1,22,64,48,1,18,72,86,14,64,4,64,65,64,4,64,66,2,2,
118,64,75,64,4,128,57,192,132,233,192,86,142,33,64,4,64,61,64,4,64,52,64,
4,64,67,64,4,64,65,64,4,64,66,64,4,64,64,64,4,64,86,64,4,128,79,192,207,
178,64,53,64,4,64,59,64,4,128,76,154,221,73,62,44,137,64,4,64,52,64,4,64,
62,64,4,64,60,64,4,72,86,9,64,4,128,79,165,254,64,56,64,4,136,79,5,165,
254,192,66,7,64,4,128,56,7,64,58,64,4,64,67,64,4,64,64,64,4,64,50,64,4,
72,56,68,64,4,73,59,11,32,64,4,128,62,192,88,39,64,50,64,4,64,48,64,4,64,
66,64,4,72,76,5,1,26,64,56,1,22,192,66,192,88,39,64,4,200,76,8,192,88,39,
1,7,192,56,192,88,39,64,4,64,65,64,4,128,79,192,88,39,64,53,64,4,128,57,
192,88,39,64,63,64,4,73,56,33,81,64,4,64,55,64,4,64,52,64,4,64,56,64,4,
64,66,64,4,136,76,6,192,78,32,128,56,192,78,32,64,53,64,4,64,64,64,4,64,
60,64,4,192,48,192,118,163,64,4,64,66,64,4,64,62,64,4,64,55,64,4,64,62,
64,4,72,87,5,1,4,64,56,64,4,128,52,148,226,64,86,64,4,64,55,64,4,64,52,
64,4,64,56,2,8,218,73,70,33,249,64,4,72,79,15,64,4,72,66,113,64,4,128,56,
192,124,169,64,48,64,4,64,66,64,4,128,76,152,9,73,66,73,106,64,4,64,64,
64,4,73,56,18,42,64,4,64,63,64,4,64,66,64,4,64,56,1,40,64,48,64,4,64,63,
64,4,72,63,7,64,4,1,2,64,62,64,4,128,61,192,156,64,64,75,64,4,64,63,64,
4,64,66,64,4,64,75,64,4,128,55,192,78,32,64,65,64,4,64,48,64,4,72,66,10,
64,4,128,76,192,124,169,64,58,64,4,136,56,6,192,114,161,128,48,192,114,
161,64,67,64,4,73,69,35,67,64,4,64,62,64,4,64,52,64,4,64,64,64,4,64,62,
64,4,64,71,64,4,64,58,64,4,128,48,192,83,237,64,63,64,4,64,53,64,4,64,64,
64,4,64,63,64,4,64,62,64,4,64,64,64,4,64,61,64,4,128,62,173,0,64,71,64,
4,72,62,9,64,4,128,58,178,116,64,58,64,4,73,62,10,14,64,4,128,94,178,116,
128,48,178,116,64,86,64,4,128,50,178,116,72,86,28,64,4,64,65,64,4,72,79,
6,2,2,77,64,76,64,4,64,58,64,4,128,48,192,77,140,64,77,64,4,64,58,64,4,
192,65,189,208,64,4,64,67,64,4,64,48,64,4,64,59,64,4,64,76,64,4,64,61,64,
4,192,48,192,132,233,64,4,64,65,64,4,64,76,64,4,64,70,64,4,128,76,190,155,
64,67,64,4,73,58,79,209,64,4,64,64,64,4,64,48,64,4,64,52,64,4,64,53,64,
4,64,61,64,4,64,61,64,4,64,75,64,4,64,57,64,0,64,32,64,4,64,56,64,4,64,
61,64,4,64,66,64,4,64,56,64,4,64,60,64,4,64,68,64,4,64,62,64,4,64,66,64,
4,128,62,192,156,64,72,57,56,64,4,64,62,64,4,64,49,64,4,73,62,13,22,64,
4,192,58,192,199,146,1,48,72,58,70,64,4,64,86,1,51,64,67,64,4,64,50,64,
4,64,48,64,4,64,66,64,4,128,56,192,109,74,64,53,64,4,64,49,64,4,73,62,12,
45,64,4,64,58,64,4,1,17,72,58,20,64,4,72,62,10,64,4,128,50,192,199,146,
128,48,192,199,146,64,56,64,4,64,73,64,4,128,53,192,104,52,64,75,64,4,64,
50,64,4,64,48,64,4,64,66,64,4,128,76,192,109,74,72,71,14,64,4,64,86,64,
4,64,59,2,2,249,64,65,64,4,64,56,64,4,64,64,64,4,64,48,64,4,64,66,64,4,
72,76,5,1,4,64,56,64,4,64,65,64,4,128,79,4,74,78,124,5,180,64,4,64,61,64,
4,64,75,64,4,64,57,64,0,64,32,64,4,73,60,7,38,2,2,159,72,59,18,64,4,64,
62,64,4,64,59,64,4,64,56,2,2,161,64,58,64,4,64,56,64,4,64,65,2,2,152,72,
64,42,64,4,64,48,64,4,64,55,64,4,64,50,64,4,64,64,64,4,64,48,64,4,64,66,
64,4,64,61,64,4,64,56,64,4,64,70,2,2,114,64,63,64,4,64,56,64,4,64,65,64,
4,64,53,64,4,64,71,2,2,89,74,72,68,4,51,64,4,72,59,32,64,4,64,78,64,4,72,
72,14,64,4,64,58,64,4,128,48,192,100,236,64,69,64,4,128,48,192,94,44,64,
48,64,4,64,59,64,4,64,48,64,4,64,50,64,4,72,56,9,64,4,128,57,150,78,128,
48,150,78,72,70,124,64,4,73,61,34,100,64,4,64,48,64,4,64,66,64,4,64,59,
64,4,64,86,64,4,64,50,64,4,64,75,64,4,128,69,150,78,72,56,50,64,4,64,70,
64,4,64,76,64,4,64,58,64,4,192,48,192,77,140,64,4,64,65,64,4,192,66,192,
73,237,64,4,136,62,6,192,73,237,64,56,64,4,128,57,192,73,237,64,53,64,4,
64,59,64,4,64,58,64,4,128,48,169,75,64,86,64,4,64,70,64,4,64,76,64,4,64,
58,64,4,128,48,0,64,69,64,4,74,56,118,1,157,64,4,64,66,64,4,64,64,64,4,
64,62,64,4,72,54,26,64,4,64,62,64,4,64,63,64,4,72,75,5,1,4,64,56,64,4,128,
57,191,59,64,50,64,4,72,75,33,64,4,64,53,64,4,64,49,64,4,64,75,64,4,64,
50,64,4,64,48,64,4,64,66,64,4,128,76,170,253,64,56,64,4,64,57,64,4,64,62,
64,4,64,49,64,4,64,67,64,4,64,50,64,4,64,48,64,4,64,66,64,4,128,56,170,
253,72,53,226,64,4,73,61,25,178,64,4,64,66,64,4,64,48,64,4,136,87,6,192,
117,48,128,57,192,117,48,192,55,192,86,126,64,4,73,61,50,119,64,4,73,67,
108,39,64,4,72,66,16,64,4,136,76,6,192,86,126,128,56,192,86,126,64,50,64,
4,64,72,64,4,64,56,64,4,128,57,192,86,126,128,86,192,86,126,73,53,11,48,
64,4,128,60,192,86,126,64,48,64,4,137,59,7,18,192,86,126,136,57,6,192,86,
126,128,50,192,86,126,72,66,10,64,4,128,76,192,86,126,128,61,192,86,126,
64,56,64,4,64,50,64,4,64,48,64,4,64,66,64,4,128,56,192,86,126,136,76,6,
192,86,126,64,75,64,4,64,50,64,4,64,48,64,4,64,66,64,4,128,76,192,86,126,
192,64,137,15,64,4,72,62,163,64,4,72,66,19,64,4,73,61,6,10,1,126,64,53,
1,110,64,84,1,106,64,50,64,4,72,75,5,1,122,64,56,1,118,64,48,64,4,64,59,
64,4,64,79,64,4,64,50,64,4,64,61,64,4,64,75,64,4,64,57,64,0,64,32,64,4,
64,60,64,4,64,48,64,4,64,59,64,4,64,62,64,4,64,59,64,4,64,53,64,4,64,66,
64,4,64,58,64,4,128,48,192,156,64,72,84,65,64,4,64,64,64,4,72,62,48,64,
4,72,66,26,64,4,72,84,13,64,4,64,61,64,4,128,76,173,135,64,61,64,4,128,
79,173,135,64,50,64,4,72,75,9,64,4,128,57,137,15,128,62,137,15,64,61,64,
4,128,79,158,240,64,67,64,4,74,79,115,1,65,64,4,73,64,25,48,64,4,64,56,
64,4,64,66,64,4,136,76,6,192,93,199,128,56,192,93,199,192,58,179,168,64,
4,64,48,64,4,64,66,64,4,136,76,5,190,232,128,56,190,232,64,71,64,4,72,56,
20,64,4,64,66,64,4,136,76,6,192,215,215,128,56,192,215,215,64,53,64,4,64,
71,64,4,72,61,19,64,4,72,75,5,1,4,64,56,64,4,128,57,192,97,126,64,53,64,
4,128,61,192,97,126,200,57,109,192,153,239,64,4,73,61,25,39,64,4,136,79,
6,192,137,200,64,67,64,4,64,66,64,4,128,56,192,137,200,64,59,64,4,136,62,
6,192,87,180,128,56,179,92,64,62,64,4,137,58,6,34,147,65,64,50,64,4,136,
62,6,192,153,239,64,56,64,4,72,61,9,64,4,128,48,184,1,128,57,192,153,239,
64,63,64,4,64,67,64,4,64,50,64,4,64,48,64,4,64,66,64,4,128,56,170,244,64,
53,64,4,73,63,53,84,64,4,73,59,10,27,64,4,64,53,1,124,136,56,5,170,244,
64,48,64,4,64,66,64,4,128,76,170,244,64,75,64,4,64,50,64,4,64,48,64,4,64,
66,64,4,128,76,170,244,136,58,5,147,65,64,50,64,4,72,75,10,64,4,128,57,
192,153,239,64,56,64,4,64,61,64,4,128,48,184,1,72,66,5,1,75,64,65,1,21,
72,87,11,64,4,64,63,64,4,1,42,64,84,64,4,73,65,14,52,64,4,64,62,64,4,128,
65,142,237,64,63,64,4,73,59,18,30,64,4,64,76,64,4,64,62,64,4,128,66,170,
244,64,48,64,4,64,66,64,4,128,56,170,244,128,86,170,244,64,66,64,4,128,
48,192,122,203,64,77,64,4,72,79,44,64,4,64,58,64,4,64,67,64,4,64,59,64,
4,64,79,64,4,64,70,64,4,72,75,10,64,4,128,86,192,175,191,64,56,64,4,128,
79,192,175,191,64,64,64,4,73,53,36,85,64,4,64,58,64,4,72,70,14,64,4,64,
56,64,4,128,79,192,69,220,64,66,64,4,64,62,64,4,128,64,159,68,64,48,64,
4,64,66,64,4,72,75,21,64,4,64,71,64,4,64,61,64,4,64,75,64,4,128,60,163,
110,64,48,64,4,64,60,64,4,64,48,64,4,64,61,64,4,128,48,171,159,192,62,192,
78,32,64,4,137,65,6,30,188,254,64,51,64,4,64,53,64,4,64,61,64,4,64,61,64,
4,64,75,64,4,128,57,132,103,64,66,64,4,73,62,18,70,64,4,64,60,64,4,64,48,
64,4,128,61,171,159,64,56,64,4,72,71,39,64,4,72,61,13,64,4,64,75,64,4,128,
57,163,110,64,53,64,4,64,65,64,4,64,58,64,4,64,56,64,4,128,57,192,120,178,
64,58,64,4,128,48,192,197,94,64,75,64,4,64,58,64,4,128,48,192,197,94,73,
86,33,131,64,4,72,63,5,1,129,64,61,64,4,64,66,64,4,72,75,5,1,4,64,56,64,
4,128,60,192,126,78,64,84,64,4,64,49,64,4,74,61,7,1,2,1,114,72,59,57,64,
4,137,79,7,26,192,129,242,136,62,6,192,129,242,64,56,64,4,64,73,64,4,128,
53,192,89,215,64,86,64,4,72,73,10,64,4,128,53,192,89,215,64,50,64,4,64,
56,64,4,128,57,177,183,64,48,64,4,73,66,6,15,1,151,72,61,5,1,84,64,59,1,
98,192,70,192,203,107,1,126,64,87,64,4,72,63,17,64,4,64,48,64,4,64,66,64,
4,64,56,1,138,64,49,64,4,73,61,11,143,64,4,128,79,192,142,44,72,59,27,64,
4,136,62,6,192,129,242,64,56,64,4,64,50,64,4,64,56,64,4,128,57,177,183,
64,48,64,4,73,61,19,51,64,4,64,67,64,4,64,66,64,4,128,56,192,78,32,72,59,
28,64,4,72,76,18,64,4,64,61,64,4,64,56,64,4,128,58,192,142,24,128,62,192,
129,242,128,58,170,189,200,70,13,192,203,107,64,4,128,76,192,203,107,64,
66,64,4,72,62,17,64,4,64,64,64,4,64,86,64,4,128,57,150,113,192,56,192,129,
242,64,4,64,65,64,4,128,79,192,117,48,64,67,64,4,128,61,133,40,64,0,74,
110,36,2,118,64,0,72,117,14,64,0,64,100,64,0,128,101,192,113,136,64,97,
64,0,64,107,64,0,64,101,64,0,128,100,2,74,101,34,1,92,64,0,64,114,64,0,
64,111,64,0,64,116,64,0,64,105,64,0,192,99,192,96,156,64,0,128,97,151,175,
73,98,133,188,64,0,73,108,27,81,64,0,64,111,64,0,64,119,64,0,64,106,64,
0,64,111,64,0,128,98,192,117,48,72,101,41,64,0,64,97,64,0,64,115,64,0,64,
116,64,0,64,105,64,0,64,97,64,0,64,108,64,0,64,105,64,0,64,116,64,0,128,
121,180,253,64,100,64,0,64,115,64,0,128,109,192,220,136,72,117,22,64,0,
64,107,64,0,64,107,64,0,64,97,64,0,64,107,2,3,100,64,111,64,0,64,110,64,
0,64,100,64,0,64,97,64,0,64,103,64,0,128,101,168,163,72,97,17,64,0,64,110,
64,0,64,97,64,0,128,108,139,8,64,33,64,4,64,66,64,4,64,64,64,4,64,48,64,
4,64,69,64,4,64,48,64,4,72,78,5,1,4,64,53,64,4,128,66,192,117,48,64,99,
64,0,73,117,65,93,64,0,72,110,38,64,0,136,116,5,138,210,64,105,64,0,64,
108,64,0,64,105,64,0,64,110,64,0,64,103,64,0,64,117,64,0,128,115,161,6,
64,109,64,0,64,115,64,0,64,104,64,0,64,111,64,0,128,116,192,156,64,64,108,
64,0,64,105,64,0,64,116,64,0,64,111,64,0,64,114,64,0,64,105,64,0,128,115,
148,210,64,121,64,0,64,98,64,0,64,101,64,0,64,114,64,0,64,115,64,0,64,101,
64,0,128,120,192,73,75,73,108,109,230,64,0,72,111,14,64,0,64,108,64,0,64,
105,2,1,90,64,101,64,0,72,122,46,64,0,64,98,64,0,200,111,19,136,24,64,0,
64,105,64,0,64,110,64,0,128,103,136,24,192,105,130,255,64,0,64,105,64,0,
64,110,64,0,128,103,130,255,64,115,64,0,64,98,64,0,200,111,19,137,135,64,
0,64,105,64,0,64,110,64,0,128,103,137,135,64,105,64,0,64,97,64,0,128,110,
153,39,72,104,56,64,0,73,101,23,36,64,0,64,110,64,0,64,116,64,0,64,97,64,
0,128,105,192,71,150,64,97,64,0,64,110,64,0,64,100,2,1,57,64,111,64,0,64,
114,64,0,64,110,64,0,128,121,2,64,102,64,0,73,105,27,48,64,0,64,115,64,
0,64,116,64,0,64,105,64,0,64,110,64,0,128,103,192,138,45,64,101,64,0,64,
116,64,0,64,105,64,0,64,115,64,0,128,104,192,69,175,64,117,64,0,64,99,64,
0,128,107,192,156,64,64,109,64,0,64,105,64,0,64,108,64,0,128,102,167,16,
74,117,60,1,177,64,0,72,112,25,64,0,64,115,64,0,64,107,64,0,64,105,64,0,
64,114,64,0,128,116,167,16,64,110,64,0,64,99,64,0,64,101,64,0,64,110,64,
0,64,115,64,0,64,111,64,0,128,114,140,57,74,115,143,1,58,64,0,73,108,34,
111,64,0,64,117,64,0,192,116,192,71,202,64,0,64,116,64,0,64,105,64,0,64,
110,64,0,128,103,192,71,202,72,104,39,64,0,72,111,17,64,0,64,116,64,0,64,
97,64,0,64,99,1,71,64,101,64,0,64,109,64,0,64,97,64,0,64,108,2,1,56,64,
101,64,0,192,120,192,160,222,64,0,136,121,5,171,100,64,117,64,0,64,97,64,
0,192,108,155,170,64,0,64,108,64,0,128,121,169,136,64,116,64,0,64,114,64,
0,64,97,64,0,64,112,64,0,64,111,64,0,128,110,192,156,64,72,114,26,64,0,
64,105,64,0,64,109,64,0,64,106,64,0,64,111,64,0,128,98,192,156,64,64,112,
64,0,73,114,65,128,64,0,72,111,42,64,0,64,115,64,0,64,116,64,0,64,105,64,
0,64,116,64,0,64,117,64,0,64,116,64,0,72,105,183,64,0,64,111,64,0,128,110,
131,69,64,101,64,0,64,103,64,0,64,103,64,0,128,111,192,117,48,72,111,38,
64,0,64,114,64,0,192,110,192,156,64,64,0,72,115,17,64,0,64,116,64,0,64,
97,64,0,128,114,154,30,128,111,192,156,64,64,101,64,0,64,100,64,0,64,111,
64,0,64,102,64,0,64,105,64,0,128,108,192,69,157,64,116,64,0,64,104,64,0,
128,99,192,156,64,64,116,64,0,73,105,10,43,64,0,128,116,134,90,64,104,64,
0,64,114,64,0,64,101,64,0,64,101,64,0,64,115,64,0,64,111,64,0,64,109,64,
0,128,101,192,156,64,64,119,64,0,64,97,64,0,128,116,133,102,73,119,22,43,
64,0,64,104,64,0,64,111,64,0,64,114,64,0,128,101,167,16,64,118,64,0,64,
117,64,0,64,108,64,0,64,118,64,0,128,97,192,74,48,64,120,64,0,72,120,9,
64,0,128,120,167,178,64,114,64,0,64,97,64,0,64,116,64,0,72,105,13,64,0,
64,110,64,0,128,103,128,168,128,101,128,168
    };
    struct TPornodict::TImpl {
        TCompactTrie<wchar16, ui64> Dict;

        TImpl(const TBlob& blob)
          : Dict(blob)
        {
        }
    };
    TPornodict::TPornodict()
      : Impl(new TImpl(TBlob::NoCopy(PornoBlob, Y_ARRAY_SIZE(PornoBlob))))
    {
    }
    TPornodict::~TPornodict() {
    }
    double TPornodict::GetWeight(const TUtf16String& w) const {
        ui64 res = 0;
        if (!Impl->Dict.Find(w.data(), w.size(), &res))
            return 0.0;
        return res * 0.01;
    }
    const TPornodict& TPornodict::GetDefault() {
        return Default<TPornodict>();
    }
}
