#include "factors.h"

#include <kernel/generated_factors_info/simple_factors_info.h>

#include <util/generic/vector.h>

// autogenerated code
#include <kernel/snippets/factors/factors_gen.cpp>
#include <kernel/snippets/factors/factors_gen_web.cpp>
#include <kernel/snippets/factors/factors_gen_web_v1.cpp>
#include <kernel/snippets/factors/factors_gen_web_noclick.cpp>

namespace NSnippets {

TAutoPtr<IFactorsInfo> GetFactorsInfoIf(size_t begin, size_t end)
{
    Y_ASSERT(begin <= end);
    Y_ASSERT(end <= FI_FACTOR_COUNT);
    return new TSimpleSearchFactorsInfo<NSnippets::TFactorInfo>(end - begin, NSnippets::GetFactorsInfo());
}

}

namespace NSnippetsWeb {

TAutoPtr<IFactorsInfo> GetFactorsInfoIf(size_t begin, size_t end)
{
    Y_ASSERT(begin <= end);
    Y_ASSERT(end <= FI_FACTOR_COUNT);
    return new TSimpleSearchFactorsInfo<NSnippetsWeb::TFactorInfo>(end - begin, NSnippetsWeb::GetFactorsInfo());
}

}

namespace NSnippetsWebV1 {

TAutoPtr<IFactorsInfo> GetFactorsInfoIf(size_t begin, size_t end)
{
    Y_ASSERT(begin <= end);
    Y_ASSERT(end <= FI_FACTOR_COUNT);
    return new TSimpleSearchFactorsInfo<NSnippetsWebV1::TFactorInfo>(end - begin, NSnippetsWebV1::GetFactorsInfo());
}

}

namespace NSnippetsWebNoclick {

TAutoPtr<IFactorsInfo> GetFactorsInfoIf(size_t begin, size_t end)
{
    Y_ASSERT(begin <= end);
    Y_ASSERT(end <= FI_FACTOR_COUNT);
    return new TSimpleSearchFactorsInfo<NSnippetsWebNoclick::TFactorInfo>(end - begin, NSnippetsWebNoclick::GetFactorsInfo());
}

}

// note: these declarations should be in the same translation unit as all initializers for NSnippetsXxx::InitFactorSlices()
// (i.e. after #include <.../factors_gen_xxx.cpp> and should come after them
namespace NSnippets {

const TFactorDomain algo2Domain(NFactorSlices::EFactorSlice::SNIPPETS_MAIN);
const TFactorDomain algo2PlusWebDomain(NFactorSlices::EFactorSlice::SNIPPETS_MAIN, NFactorSlices::EFactorSlice::SNIPPETS_WEBRANKING);
const TFactorDomain algo2PlusWebNoClickDomain(NFactorSlices::EFactorSlice::SNIPPETS_MAIN, NFactorSlices::EFactorSlice::SNIPPETS_WEBRANKING_NOCLICK);
const TFactorDomain algo2PlusWebV1Domain(NFactorSlices::EFactorSlice::SNIPPETS_MAIN, NFactorSlices::EFactorSlice::SNIPPETS_WEBRANKING_V1);

}
