#include "stream_constants.h"

namespace NLingBoost {
    namespace NPrivate {
        void FillBaseIndexByStreamMap(TCompactEnumMap<TStream, EBaseIndexType>& map)
        {
            map.Insert({
                {TStream::Url, TBaseIndex::Text},
                {TStream::Title, TBaseIndex::Text},
                {TStream::Body, TBaseIndex::Text},
                {TStream::FullText, TBaseIndex::Text},
                {TStream::CatalogueYandex, TBaseIndex::Link},
                {TStream::CatalogueDmoz, TBaseIndex::Link},
                {TStream::LinksInternal, TBaseIndex::Link},
                {TStream::LinksExternalDpr, TBaseIndex::Link},
                {TStream::LinksExternalTic, TBaseIndex::Link},
                {TStream::CorrectedCtr, TBaseIndex::Ann},
                {TStream::WikiTitle, TBaseIndex::Ann},
                {TStream::SameQueryReturnFrcBrowser, TBaseIndex::FactorAnn},
                {TStream::SamplePeriodDayFrc, TBaseIndex::FactorAnn},
                {TStream::OneClick, TBaseIndex::FactorAnn},
                {TStream::LongClick, TBaseIndex::FactorAnn},
                {TStream::SplitDwellTime, TBaseIndex::FactorAnn},
                {TStream::BrowserPageRank, TBaseIndex::FactorAnn},
                {TStream::YabarVisits, TBaseIndex::FactorAnn},
                {TStream::YabarTime, TBaseIndex::FactorAnn},
                {TStream::SimpleClick, TBaseIndex::FactorAnn},
                {TStream::RandomLogDBM35,TBaseIndex::FactorAnn},
                {TStream::CorrectedCtrXFactor, TBaseIndex::FactorAnn},
                {TStream::PopularSeFrcBrowser, TBaseIndex::FactorAnn},
                {TStream::LongClickSP, TBaseIndex::FactorAnn},
                {TStream::UrlQuery, TBaseIndex::Ann},
                {TStream::NHopTotal, TBaseIndex::Ann},
                {TStream::NHopIsFinal, TBaseIndex::Ann},
                {TStream::BeastQ, TBaseIndex::Ann},
                {TStream::DoubleFrc, TBaseIndex::FactorAnn},
                {TStream::BQPRSample, TBaseIndex::FactorAnn},
                {TStream::OneClickFrcXfSp, TBaseIndex::FactorAnn},
                {TStream::QueryDwellTime, TBaseIndex::FactorAnn},
                {TStream::Onotole, TBaseIndex::FactorAnn},
                {TStream::CorrectedCtrLongPeriod, TBaseIndex::FactorAnn},
                {TStream::NHopSumDwellTime, TBaseIndex::FactorAnn},
                {TStream::FirstClickDtXf, TBaseIndex::FactorAnn},
                {TStream::MetaPolyGen8, TBaseIndex::FactorAnn},
                {TStream::LongClickMobile, TBaseIndex::FactorAnn},
                {TStream::LinksExternal, TBaseIndex::Link},
                {TStream::FirstLastClickMobile, TBaseIndex::FactorAnn},
                {TStream::AvgDTWeightedByRankMobile, TBaseIndex::FactorAnn},
                {TStream::VpcgCorrectedClicksSlowLongPeriod, TBaseIndex::FactorAnn},
                {TStream::WebVideoPCtrNew, TBaseIndex::FactorAnn},
                {TStream::AliceMusicTrackTitle, TBaseIndex::FactorAnn},
                {TStream::AliceMusicArtistName, TBaseIndex::FactorAnn},
                {TStream::AliceMusicAlbumTitle, TBaseIndex::FactorAnn},
                {TStream::AliceMusicTrackArtistNames, TBaseIndex::FactorAnn},
                {TStream::AliceMusicTrackAlbumTitle, TBaseIndex::FactorAnn},
                {TStream::AliceMusicTrackLyrics, TBaseIndex::FactorAnn},

                //
                // Images
                //
                {TStream::ImagesCVTags, TBaseIndex::FactorAnn},
                {TStream::ImagesGoXFRC, TBaseIndex::FactorAnn},
                {TStream::ImagesOCR, TBaseIndex::FactorAnn},
                {TStream::ImagesRightXFRC, TBaseIndex::FactorAnn},
                {TStream::ImagesGoClicks, TBaseIndex::FactorAnn},
                {TStream::ImagesYaClicks, TBaseIndex::FactorAnn},
                {TStream::ImagesTolokaOk, TBaseIndex::FactorAnn},
                {TStream::ImagesTolokaBad, TBaseIndex::FactorAnn},
                {TStream::ImagesTitle, TBaseIndex::FactorAnn},
                {TStream::ImagesClickSimilarity, TBaseIndex::FactorAnn},
                {TStream::ImagesOCRv2, TBaseIndex::FactorAnn},
                {TStream::ImagesRTClicks, TBaseIndex::FactorAnn},

                //
                // Video
                //
                {TStream::VideoQusm, TBaseIndex::FactorAnn},
                {TStream::VideoMaxClicksPercent, TBaseIndex::FactorAnn},
                {TStream::VideoPctrNew, TBaseIndex::FactorAnn},
                {TStream::VideoNHop, TBaseIndex::Ann},
                {TStream::VideoCorrectedClicksFrc, TBaseIndex::Ann},
                {TStream::VideoCorrectedClicksUFrc, TBaseIndex::Ann},
                {TStream::VideoUnitedFactorAnn, TBaseIndex::FactorAnn},
                {TStream::VideoSpeechToText, TBaseIndex::FactorAnn},
                {TStream::VideoOcr, TBaseIndex::FactorAnn},
                //
                // AdvMachine
                //
               {TStream::AdvBannerCommQueriesBid, TBaseIndex::FactorAnn},
               {TStream::AdvBannerCommQueriesCtr, TBaseIndex::FactorAnn},
               {TStream::AdvBannerCommQueriesFrc, TBaseIndex::FactorAnn},
               {TStream::AdvBannerCommQueriesHistoryCpc, TBaseIndex::FactorAnn},
               {TStream::AdvBannerCommQueriesXfCtr, TBaseIndex::FactorAnn},
               {TStream::AdvBannerPhraseBid, TBaseIndex::FactorAnn},
               {TStream::AdvBannerPhraseCtr, TBaseIndex::FactorAnn},
               {TStream::AdvBannerPhraseHistoryCpc, TBaseIndex::FactorAnn},
               {TStream::AdvBannerPhraseHistoryCpm, TBaseIndex::FactorAnn},
               {TStream::AdvBannerPhraseRsyaCtr, TBaseIndex::FactorAnn},
               {TStream::AdvBannerPhraseRsyaFrc, TBaseIndex::FactorAnn},
               {TStream::AdvBannerPhraseRsyaHistoryCpc, TBaseIndex::FactorAnn},
               {TStream::AdvBannerRsyaPhraseBid, TBaseIndex::FactorAnn},
               {TStream::AdvBannerRsyaQueryBid, TBaseIndex::FactorAnn},
               {TStream::AdvBannerRsyaQueryCtr, TBaseIndex::FactorAnn},
               {TStream::AdvBannerRsyaQueryFrc, TBaseIndex::FactorAnn},
               {TStream::AdvBannerRsyaQueryHistoryCpc, TBaseIndex::FactorAnn},
               {TStream::AdvBannerSpyLogTitle, TBaseIndex::FactorAnn},
               {TStream::AdvBannerText, TBaseIndex::FactorAnn},
               {TStream::AdvBannerTitle, TBaseIndex::FactorAnn},
               {TStream::AdvBannerOriginalPhrase, TBaseIndex::FactorAnn},
               {TStream::AdvBannerOriginalPhraseBid, TBaseIndex::FactorAnn},
               {TStream::AdvBannerOriginalPhraseBidToMaxBid, TBaseIndex::FactorAnn},
               {TStream::AdvBannerQueryCostFr, TBaseIndex::FactorAnn},
               {TStream::AdvLandingPageText, TBaseIndex::FactorAnn},
               {TStream::AdvLandingPageTitle, TBaseIndex::FactorAnn},
               {TStream::BQPR, TBaseIndex::FactorAnn},
               {TStream::AdvMachine1, TBaseIndex::FactorAnn},
               {TStream::AdvMachine2, TBaseIndex::FactorAnn},
               {TStream::AdvMachine3, TBaseIndex::FactorAnn},
               {TStream::AdvMachine4, TBaseIndex::FactorAnn},
               {TStream::AdvMachine5, TBaseIndex::FactorAnn},
               {TStream::AdvMachine6, TBaseIndex::FactorAnn},
               {TStream::AdvMachine7, TBaseIndex::FactorAnn},
               {TStream::AdvMachine8, TBaseIndex::FactorAnn},

               {TStream::MapsShowQFRC, TBaseIndex::FactorAnn},
               {TStream::MapsClickQFRC, TBaseIndex::FactorAnn},
               {TStream::MapsOrgAddress, TBaseIndex::FactorAnn},
               {TStream::MapsOrgName, TBaseIndex::FactorAnn},
               {TStream::MapsOrgChainName, TBaseIndex::FactorAnn},
               {TStream::MobileMapsClickQFRC, TBaseIndex::FactorAnn},
               {TStream::MobileMapsClickSQFRC, TBaseIndex::FactorAnn},
               {TStream::MobileMapsClickCTR, TBaseIndex::FactorAnn},
               {TStream::SerpMapsClickQFRC, TBaseIndex::FactorAnn},
               {TStream::SerpMapsClickSOFRC, TBaseIndex::FactorAnn},
               {TStream::SerpMapsClickSQFRC, TBaseIndex::FactorAnn},
               {TStream::LocatedAtOrgName, TBaseIndex::FactorAnn},
               {TStream::FacultyName, TBaseIndex::FactorAnn},
               {TStream::HospitalName, TBaseIndex::FactorAnn},
               {TStream::OrgSummary, TBaseIndex::FactorAnn},

                //
                // Market
                //
                {TStream::MarketModelAlias, TBaseIndex::FactorAnn},
                {TStream::MarketImageLinkData, TBaseIndex::FactorAnn},
                {TStream::MarketImageAltData, TBaseIndex::FactorAnn},
                {TStream::MarketImageShowsTime, TBaseIndex::FactorAnn},
                {TStream::MarketImageQueryShowsTime, TBaseIndex::FactorAnn},
                {TStream::MarketImageDwellTime, TBaseIndex::FactorAnn},
                {TStream::MarketImageQueryDwellTime, TBaseIndex::FactorAnn},
                {TStream::MarketImageDocDwellTime, TBaseIndex::FactorAnn},
                {TStream::MarketImageShows, TBaseIndex::FactorAnn},
                {TStream::MarketImageClicks, TBaseIndex::FactorAnn},
                {TStream::MarketImageQueryClicks, TBaseIndex::FactorAnn},
                {TStream::MarketDescription, TBaseIndex::FactorAnn},
                {TStream::MarketWasOrdered, TBaseIndex::FactorAnn},
                {TStream::MarketKNN_5000_9600, TBaseIndex::FactorAnn},
                {TStream::MarketKNN_9600_10000, TBaseIndex::FactorAnn},
                {TStream::MarketKNN_10000_11000, TBaseIndex::FactorAnn},
                {TStream::MarketKNN_11000_20000, TBaseIndex::FactorAnn},

                // Yandex.Market.AdvMachine
                {TStream::YaMarketManufacturer, TBaseIndex::FactorAnn},
                {TStream::YaMarketContents, TBaseIndex::FactorAnn},
                {TStream::YaMarketAliases, TBaseIndex::FactorAnn},
                {TStream::YaMarketBarcode, TBaseIndex::FactorAnn},
                {TStream::YaMarketBookPublisher, TBaseIndex::FactorAnn},
                {TStream::YaMarketBookUisbn, TBaseIndex::FactorAnn},
                {TStream::YaMarketUrl, TBaseIndex::FactorAnn},
                {TStream::YaMarketBookAuthor, TBaseIndex::FactorAnn},
                {TStream::YaMarketMobileManufacturer, TBaseIndex::FactorAnn},
                {TStream::YaMarketOfferDescription, TBaseIndex::FactorAnn},
                {TStream::YaMarketOfferSalesNotes, TBaseIndex::FactorAnn},
                {TStream::YaMarketOfferTitle, TBaseIndex::FactorAnn},
                {TStream::YaMarketOfferUrl, TBaseIndex::FactorAnn},
                {TStream::YaMarketCategoryName, TBaseIndex::FactorAnn},

                // Yandex.Market.ClickMachine
                {TStream::YaMarketSplitDwellTime, TBaseIndex::FactorAnn},
                {TStream::YaMarketOneClick, TBaseIndex::FactorAnn},
                {TStream::YaMarketLongClick, TBaseIndex::FactorAnn},
                {TStream::YaMarketLongClick120Sqrt, TBaseIndex::FactorAnn},
                {TStream::YaMarketSimpleClick, TBaseIndex::FactorAnn},
                {TStream::YaMarketLongClickMobile, TBaseIndex::FactorAnn},
                {TStream::YaMarketFirstLastClickMobile, TBaseIndex::FactorAnn},

                {TStream::MarketBlueAliasOfWhiteModel, TBaseIndex::FactorAnn},
                {TStream::MarketBlueTitleOfWhiteModel, TBaseIndex::FactorAnn},
                {TStream::MarketBlueDescriptionOfWhiteOffer, TBaseIndex::FactorAnn},
                {TStream::MarketBlueTitleOfWhiteOffer, TBaseIndex::FactorAnn},

                {TStream::MarketTitle, TBaseIndex::FactorAnn},

                {TStream::MarketingDescription, TBaseIndex::FactorAnn},
                {TStream::BlueMarketingDescriptionOfModel, TBaseIndex::FactorAnn},
                {TStream::BlueMicroDescriptionOfModel, TBaseIndex::FactorAnn},

                {TStream::MarketCPAQuery, TBaseIndex::FactorAnn},

                // Music
                {TStream::MusicFirstClick, TBaseIndex::FactorAnn},
                {TStream::MusicLastClick, TBaseIndex::FactorAnn},
                {TStream::MusicSingleClick, TBaseIndex::FactorAnn},
                {TStream::MusicLongClick, TBaseIndex::Ann},

                {TStream::MskuOfferSearchText, TBaseIndex::FactorAnn},
                {TStream::MskuOfferTitle, TBaseIndex::FactorAnn},

                {TStream::MetadocBQRP, TBaseIndex::FactorAnn},
                {TStream::MetadocFirstClickDTXF, TBaseIndex::FactorAnn},
                {TStream::MetadocLongClick, TBaseIndex::FactorAnn},
                {TStream::MetadocLongClickSP, TBaseIndex::FactorAnn},
                {TStream::MetadocOneClick, TBaseIndex::FactorAnn},
                {TStream::MetadocSimpleClick, TBaseIndex::FactorAnn},
                {TStream::MetadocSplitDT, TBaseIndex::FactorAnn},
                {TStream::MetadocBQPRSample, TBaseIndex::FactorAnn},
                {TStream::MetadocNHOP, TBaseIndex::FactorAnn},

                {TStream::VendorName, TBaseIndex::FactorAnn},
                {TStream::ShopName, TBaseIndex::FactorAnn},
                {TStream::ShopCategories, TBaseIndex::FactorAnn},
                {TStream::NidNames, TBaseIndex::FactorAnn},
            });
        }
    } // NPrivate
}
