#define UNIT_ANNOTATION_STREAM_LIST(UnitNamePrefix, ...) \
    MACHINE_PARTS(Tracker) { \
        using UnitNamePrefix##Group = TAnnotationGroup<__VA_ARGS__>; \
        using UnitNamePrefix##Family =  UnitNamePrefix##Group::TAnnotationFamily; \
        template <typename Accumulator> \
        using UnitNamePrefix##Stub = UnitNamePrefix##Group::TAnnotationStub<Accumulator>; \
        \
        UNIT_FAMILY_REGISTER( \
            Tracker, \
            UnitNamePrefix ## Family, \
            TAnnotationFamilyInfo, \
            std::initializer_list<int>{__VA_ARGS__}); \
    }

namespace NTextMachine {
namespace NCore {
    UNIT_ANNOTATION_STREAM_LIST(TUrlAnnotation, TStream::Url)
    UNIT_ANNOTATION_STREAM_LIST(TTitleAnnotation, TStream::Title)
    UNIT_ANNOTATION_STREAM_LIST(TBodyAnnotation, TStream::Body)
    UNIT_ANNOTATION_STREAM_LIST(TFullTextAnnotation, TStream::FullText)
    UNIT_ANNOTATION_STREAM_LIST(TTextAnnotation, TStream::Title, TStream::Body)
    UNIT_ANNOTATION_STREAM_LIST(TInternalLinksAnnotation, TStream::LinksInternal)
    UNIT_ANNOTATION_STREAM_LIST(TDprLinksAnnotation, TStream::LinksExternalDpr)
    UNIT_ANNOTATION_STREAM_LIST(TTicLinksAnnotation, TStream::LinksExternalTic)
    UNIT_ANNOTATION_STREAM_LIST(TExternalLinksAnnotation, TStream::LinksExternal)
    UNIT_ANNOTATION_STREAM_LIST(TAllLinksAnnotation, TStream::LinksInternal, TStream::LinksExternal)
    UNIT_ANNOTATION_STREAM_LIST(TCorrectedCtrAnnotation, TStream::CorrectedCtr)
    UNIT_ANNOTATION_STREAM_LIST(TLongClickAnnotation, TStream::LongClick)
    UNIT_ANNOTATION_STREAM_LIST(TOneClickAnnotation, TStream::OneClick)
    UNIT_ANNOTATION_STREAM_LIST(TBrowserPageRankAnnotation, TStream::BrowserPageRank)
    UNIT_ANNOTATION_STREAM_LIST(TSplitDwellTimeAnnotation, TStream::SplitDwellTime)
    UNIT_ANNOTATION_STREAM_LIST(TSimpleClickAnnotation, TStream::SimpleClick)
    UNIT_ANNOTATION_STREAM_LIST(TRandomLogDBM35Annotation, TStream::RandomLogDBM35)
    UNIT_ANNOTATION_STREAM_LIST(TSamplePeriodDayFrcAnnotation, TStream::SamplePeriodDayFrc)
    UNIT_ANNOTATION_STREAM_LIST(TYabarVisitsAnnotation, TStream::YabarVisits)
    UNIT_ANNOTATION_STREAM_LIST(TYabarTimeAnnotation, TStream::YabarTime)
    UNIT_ANNOTATION_STREAM_LIST(TCorrectedCtrXFactorAnnotation, TStream::CorrectedCtrXFactor)
    UNIT_ANNOTATION_STREAM_LIST(TPopularSeFrcBrowserAnnotation, TStream::PopularSeFrcBrowser)
    UNIT_ANNOTATION_STREAM_LIST(TLongClickSPAnnotation, TStream::LongClickSP)
    UNIT_ANNOTATION_STREAM_LIST(TDoubleFrcAnnotation, TStream::DoubleFrc)
    UNIT_ANNOTATION_STREAM_LIST(TBQPRSampleAnnotation, TStream::BQPRSample)
    UNIT_ANNOTATION_STREAM_LIST(TOneClickFrcXfSpAnnotation, TStream::OneClickFrcXfSp)
    UNIT_ANNOTATION_STREAM_LIST(TQueryDwellTimeAnnotation, TStream::QueryDwellTime)
    UNIT_ANNOTATION_STREAM_LIST(TOnotoleAnnotation, TStream::Onotole)
    UNIT_ANNOTATION_STREAM_LIST(TCorrectedCtrLongPeriodAnnotation, TStream::CorrectedCtrLongPeriod)
    UNIT_ANNOTATION_STREAM_LIST(TVideoQusmAnnotation, TStream::VideoQusm)
    UNIT_ANNOTATION_STREAM_LIST(TVideoMaxClicksPercentAnnotation, TStream::VideoMaxClicksPercent)
    UNIT_ANNOTATION_STREAM_LIST(TVideoPctrNewAnnotation, TStream::VideoPctrNew)
    UNIT_ANNOTATION_STREAM_LIST(TVideoNHopAnnotation, TStream::VideoNHop)
    UNIT_ANNOTATION_STREAM_LIST(TVideoCorrectedClicksFrcAnnotation, TStream::VideoCorrectedClicksFrc)
    UNIT_ANNOTATION_STREAM_LIST(TVideoCorrectedClicksUFrcAnnotation, TStream::VideoCorrectedClicksUFrc)
    UNIT_ANNOTATION_STREAM_LIST(TVideoUnitedFactorAnnAnnotation, TStream::VideoUnitedFactorAnn)
    UNIT_ANNOTATION_STREAM_LIST(TVideoSpeechToTextAnnotation, TStream::VideoSpeechToText)
    UNIT_ANNOTATION_STREAM_LIST(TVideoOcrAnnotation, TStream::VideoOcr)
    UNIT_ANNOTATION_STREAM_LIST(TNHopSumDwellTimeAnnotation, TStream::NHopSumDwellTime)
    UNIT_ANNOTATION_STREAM_LIST(TNHopIsFinalAnnotation, TStream::NHopIsFinal)
    UNIT_ANNOTATION_STREAM_LIST(TFirstClickDtXfAnnotation, TStream::FirstClickDtXf)
    UNIT_ANNOTATION_STREAM_LIST(TLinkAnnIndicatorAnnotation, TStream::LinkAnnIndicator)
    UNIT_ANNOTATION_STREAM_LIST(TLinkAnnFloatMultiplicityAnnotation, TStream::LinkAnnFloatMultiplicity)
    UNIT_ANNOTATION_STREAM_LIST(TLinkAnnLinkExternalAnnotation, TStream::LinkAnnLinkExternal)

    UNIT_ANNOTATION_STREAM_LIST(TImagesGoXFRCAnnotation, TStream::ImagesGoXFRC)
    UNIT_ANNOTATION_STREAM_LIST(TImagesOCRAnnotation, TStream::ImagesOCR)
    UNIT_ANNOTATION_STREAM_LIST(TImagesRightXFRCAnnotation, TStream::ImagesRightXFRC)
    UNIT_ANNOTATION_STREAM_LIST(TImagesCVTagsAnnotation, TStream::ImagesCVTags)
    UNIT_ANNOTATION_STREAM_LIST(TImagesGoClicksAnnotation, TStream::ImagesGoClicks)
    UNIT_ANNOTATION_STREAM_LIST(TImagesYaClicksAnnotation, TStream::ImagesYaClicks)
    UNIT_ANNOTATION_STREAM_LIST(TImagesTolokaOkAnnotation, TStream::ImagesTolokaOk)
    UNIT_ANNOTATION_STREAM_LIST(TImagesTolokaBadAnnotation, TStream::ImagesTolokaBad)
    UNIT_ANNOTATION_STREAM_LIST(TImagesTitleAnnotation, TStream::ImagesTitle)
    UNIT_ANNOTATION_STREAM_LIST(TImagesClickSimilarityAnnotation, TStream::ImagesClickSimilarity)
    UNIT_ANNOTATION_STREAM_LIST(TImagesRTClicksAnnotation, TStream::ImagesRTClicks)

    UNIT_ANNOTATION_STREAM_LIST(TMetaPolyGen8Annotation, TStream::MetaPolyGen8)

    UNIT_ANNOTATION_STREAM_LIST(TLongClickMobileAnnotation, TStream::LongClickMobile)

    UNIT_ANNOTATION_STREAM_LIST(TAdvBannerCommQueriesCtrAnnotation, TStream::AdvBannerCommQueriesCtr)
    UNIT_ANNOTATION_STREAM_LIST(TAdvBannerCommQueriesFrcAnnotation, TStream::AdvBannerCommQueriesFrc)
    UNIT_ANNOTATION_STREAM_LIST(TAdvBannerCommQueriesXfCtrAnnotation, TStream::AdvBannerCommQueriesXfCtr)
    UNIT_ANNOTATION_STREAM_LIST(TAdvBannerPhraseCtrAnnotation, TStream::AdvBannerPhraseCtr)
    UNIT_ANNOTATION_STREAM_LIST(TAdvBannerPhraseHistoryCpcAnnotation, TStream::AdvBannerPhraseHistoryCpc)
    UNIT_ANNOTATION_STREAM_LIST(TAdvBannerPhraseHistoryCpmAnnotation, TStream::AdvBannerPhraseHistoryCpm)
    UNIT_ANNOTATION_STREAM_LIST(TAdvBannerPhraseRsyaCtrAnnotation, TStream::AdvBannerPhraseRsyaCtr)
    UNIT_ANNOTATION_STREAM_LIST(TAdvBannerPhraseRsyaFrcAnnotation, TStream::AdvBannerPhraseRsyaFrc)
    UNIT_ANNOTATION_STREAM_LIST(TAdvBannerPhraseRsyaHistoryCpcAnnotation, TStream::AdvBannerPhraseRsyaHistoryCpc)
    UNIT_ANNOTATION_STREAM_LIST(TAdvBannerRsyaPhraseBidAnnotation, TStream::AdvBannerRsyaPhraseBid)
    UNIT_ANNOTATION_STREAM_LIST(TAdvBannerRsyaQueryBidAnnotation, TStream::AdvBannerRsyaQueryBid)
    UNIT_ANNOTATION_STREAM_LIST(TAdvBannerRsyaQueryCtrAnnotation, TStream::AdvBannerRsyaQueryCtr)
    UNIT_ANNOTATION_STREAM_LIST(TAdvBannerRsyaQueryFrcAnnotation, TStream::AdvBannerRsyaQueryFrc)
    UNIT_ANNOTATION_STREAM_LIST(TAdvBannerRsyaQueryHistoryCpcAnnotation, TStream::AdvBannerRsyaQueryHistoryCpc)
    UNIT_ANNOTATION_STREAM_LIST(TAdvBannerSpyLogTitleAnnotation, TStream::AdvBannerSpyLogTitle)
    UNIT_ANNOTATION_STREAM_LIST(TAdvBannerTitleAnnotation, TStream::AdvBannerTitle)
    UNIT_ANNOTATION_STREAM_LIST(TBQPRAnnotation, TStream::BQPR)
    UNIT_ANNOTATION_STREAM_LIST(TAdvLandingPageTextAnnotation, TStream::AdvLandingPageText)
    UNIT_ANNOTATION_STREAM_LIST(TAdvBannerTextAnnotation, TStream::AdvBannerText)
    UNIT_ANNOTATION_STREAM_LIST(TAdvBannerCommQueriesBidAnnotation, TStream::AdvBannerCommQueriesBid)
    UNIT_ANNOTATION_STREAM_LIST(TAdvBannerCommQueriesHistoryCpcAnnotation, TStream::AdvBannerCommQueriesHistoryCpc)
    UNIT_ANNOTATION_STREAM_LIST(TAdvBannerPhraseBidAnnotation, TStream::AdvBannerPhraseBid)
    UNIT_ANNOTATION_STREAM_LIST(TAdvLandingPageTitleAnnotation, TStream::AdvLandingPageTitle)
    UNIT_ANNOTATION_STREAM_LIST(TSearchAdvLandingPageTitleAnnotation, TStream::AdvLandingPageTitle)
    UNIT_ANNOTATION_STREAM_LIST(TAdvBannerQueryCostFrAnnotation, TStream::AdvBannerQueryCostFr)
    UNIT_ANNOTATION_STREAM_LIST(TAdvBannerOriginalPhraseAnnotation, TStream::AdvBannerOriginalPhrase)
    UNIT_ANNOTATION_STREAM_LIST(TAdvBannerOriginalPhraseBidAnnotation, TStream::AdvBannerOriginalPhraseBid)
    UNIT_ANNOTATION_STREAM_LIST(TAdvBannerOriginalPhraseBidToMaxBidAnnotation, TStream::AdvBannerOriginalPhraseBidToMaxBid)
    UNIT_ANNOTATION_STREAM_LIST(TUserQueryAnnotation, TStream::UserQuery)

    UNIT_ANNOTATION_STREAM_LIST(TFirstLastClickMobileAnnotation, TStream::FirstLastClickMobile)
    UNIT_ANNOTATION_STREAM_LIST(TAvgDTWeightedByRankMobileAnnotation, TStream::AvgDTWeightedByRankMobile)

    UNIT_ANNOTATION_STREAM_LIST(TMapsShowQFRCAnnotation, TStream::MapsShowQFRC)
    UNIT_ANNOTATION_STREAM_LIST(TMapsClickQFRCAnnotation, TStream::MapsClickQFRC)
    UNIT_ANNOTATION_STREAM_LIST(TMapsOrgAddressAnnotation, TStream::MapsOrgAddress)
    UNIT_ANNOTATION_STREAM_LIST(TMapsOrgNameAnnotation, TStream::MapsOrgName)
    UNIT_ANNOTATION_STREAM_LIST(TMapsOrgChainNameAnnotation, TStream::MapsOrgChainName)
    UNIT_ANNOTATION_STREAM_LIST(TMobileMapsClickQFRCAnnotation, TStream::MobileMapsClickQFRC)
    UNIT_ANNOTATION_STREAM_LIST(TMobileMapsClickSQFRCAnnotation, TStream::MobileMapsClickSQFRC)
    UNIT_ANNOTATION_STREAM_LIST(TMobileMapsClickCTRAnnotation, TStream::MobileMapsClickCTR)
    UNIT_ANNOTATION_STREAM_LIST(TSerpMapsClickQFRCAnnotation, TStream::SerpMapsClickQFRC)
    UNIT_ANNOTATION_STREAM_LIST(TSerpMapsClickSOFRCAnnotation, TStream::SerpMapsClickSOFRC)
    UNIT_ANNOTATION_STREAM_LIST(TSerpMapsClickSQFRCAnnotation, TStream::SerpMapsClickSQFRC)
    UNIT_ANNOTATION_STREAM_LIST(TLocatedAtOrgNameAnnotation, TStream::LocatedAtOrgName)
    UNIT_ANNOTATION_STREAM_LIST(TFacultyNameAnnotation, TStream::FacultyName)
    UNIT_ANNOTATION_STREAM_LIST(THospitalNameAnnotation, TStream::HospitalName)
    UNIT_ANNOTATION_STREAM_LIST(TOrgSummaryAnnotation, TStream::OrgSummary)

    UNIT_ANNOTATION_STREAM_LIST(TVpcgCorrectedClicksSlowLongPeriodAnnotation, TStream::VpcgCorrectedClicksSlowLongPeriod)

    UNIT_ANNOTATION_STREAM_LIST(TMarketModelAliasAnnotation, TStream::MarketModelAlias)
    UNIT_ANNOTATION_STREAM_LIST(TMarketImageLinkDataAnnotation, TStream::MarketImageLinkData)
    UNIT_ANNOTATION_STREAM_LIST(TMarketImageAltDataAnnotation, TStream::MarketImageAltData)
    UNIT_ANNOTATION_STREAM_LIST(TMarketImageShowsTimeAnnotation, TStream::MarketImageShowsTime)
    UNIT_ANNOTATION_STREAM_LIST(TMarketImageQueryShowsTimeAnnotation, TStream::MarketImageQueryShowsTime)
    UNIT_ANNOTATION_STREAM_LIST(TMarketImageDwellTimeAnnotation, TStream::MarketImageDwellTime)
    UNIT_ANNOTATION_STREAM_LIST(TMarketImageQueryDwellTimeAnnotation, TStream::MarketImageQueryDwellTime)
    UNIT_ANNOTATION_STREAM_LIST(TMarketImageDocDwellTimeAnnotation, TStream::MarketImageDocDwellTime)
    UNIT_ANNOTATION_STREAM_LIST(TMarketImageShowsAnnotation, TStream::MarketImageShows)
    UNIT_ANNOTATION_STREAM_LIST(TMarketImageClicksAnnotation, TStream::MarketImageClicks)
    UNIT_ANNOTATION_STREAM_LIST(TMarketImageQueryClicksAnnotation, TStream::MarketImageQueryClicks)
    UNIT_ANNOTATION_STREAM_LIST(TMarketDescriptionAnnotation, TStream::MarketDescription)
    UNIT_ANNOTATION_STREAM_LIST(TMarketWasOrderedAnnotation, TStream::MarketWasOrdered)
    UNIT_ANNOTATION_STREAM_LIST(TMarketKNN_5000_9600Annotation, TStream::MarketKNN_5000_9600)
    UNIT_ANNOTATION_STREAM_LIST(TMarketKNN_9600_10000Annotation, TStream::MarketKNN_9600_10000)
    UNIT_ANNOTATION_STREAM_LIST(TMarketKNN_10000_11000Annotation, TStream::MarketKNN_10000_11000)
    UNIT_ANNOTATION_STREAM_LIST(TMarketKNN_11000_20000Annotation, TStream::MarketKNN_11000_20000)
    UNIT_ANNOTATION_STREAM_LIST(TYaMarketManufacturerAnnotation, TStream::YaMarketManufacturer)
    UNIT_ANNOTATION_STREAM_LIST(TYaMarketCategoryNameAnnotation, TStream::YaMarketCategoryName)
    UNIT_ANNOTATION_STREAM_LIST(TYaMarketAliasesAnnotation, TStream::YaMarketAliases)
    UNIT_ANNOTATION_STREAM_LIST(TYaMarketUrlAnnotation, TStream::YaMarketUrl)
    UNIT_ANNOTATION_STREAM_LIST(TYaMarketOfferDescriptionAnnotation, TStream::YaMarketOfferDescription)
    UNIT_ANNOTATION_STREAM_LIST(TYaMarketOfferSalesNotesAnnotation, TStream::YaMarketOfferSalesNotes)
    UNIT_ANNOTATION_STREAM_LIST(TYaMarketOfferTitleAnnotation, TStream::YaMarketOfferTitle)
    UNIT_ANNOTATION_STREAM_LIST(TYaMarketOfferUrlAnnotation, TStream::YaMarketOfferUrl)
    UNIT_ANNOTATION_STREAM_LIST(TYaMarketSimpleClickAnnotation, TStream::YaMarketSimpleClick)

    UNIT_ANNOTATION_STREAM_LIST(TYaMarketSplitDwellTimeAnnotation, TStream::YaMarketSplitDwellTime)
    UNIT_ANNOTATION_STREAM_LIST(TYaMarketOneClickAnnotation, TStream::YaMarketOneClick)
    UNIT_ANNOTATION_STREAM_LIST(TYaMarketLongClickAnnotation, TStream::YaMarketLongClick)
    UNIT_ANNOTATION_STREAM_LIST(TYaMarketLongClick120SqrtAnnotation, TStream::YaMarketLongClick120Sqrt)
    UNIT_ANNOTATION_STREAM_LIST(TYaMarketFirstLastClickMobileAnnotation, TStream::YaMarketFirstLastClickMobile)

    UNIT_ANNOTATION_STREAM_LIST(TWebVideoPCtrNewAnnotation, TStream::WebVideoPCtrNew)

    UNIT_ANNOTATION_STREAM_LIST(TMarketBlueAliasOfWhiteModelAnnotation, TStream::MarketBlueAliasOfWhiteModel)
    UNIT_ANNOTATION_STREAM_LIST(TMarketBlueTitleOfWhiteModelAnnotation, TStream::MarketBlueTitleOfWhiteModel)
    UNIT_ANNOTATION_STREAM_LIST(TMarketBlueDescriptionOfWhiteOfferAnnotation, TStream::MarketBlueDescriptionOfWhiteOffer)
    UNIT_ANNOTATION_STREAM_LIST(TMarketBlueTitleOfWhiteOfferAnnotation, TStream::MarketBlueTitleOfWhiteOffer)

    UNIT_ANNOTATION_STREAM_LIST(TMarketTitleAnnotation, TStream::MarketTitle)

    UNIT_ANNOTATION_STREAM_LIST(TMarketingDescriptionAnnotation, TStream::MarketingDescription)
    UNIT_ANNOTATION_STREAM_LIST(TBlueMarketingDescriptionOfModelAnnotation, TStream::BlueMarketingDescriptionOfModel)
    UNIT_ANNOTATION_STREAM_LIST(TBlueMicroDescriptionOfModelAnnotation, TStream::BlueMicroDescriptionOfModel)
    UNIT_ANNOTATION_STREAM_LIST(TMarketCPAQueryAnnotation, TStream::MarketCPAQuery)

    UNIT_ANNOTATION_STREAM_LIST(TAliceMusicTrackTitleAnnotation, TStream::AliceMusicTrackTitle)
    UNIT_ANNOTATION_STREAM_LIST(TAliceMusicArtistNameAnnotation, TStream::AliceMusicArtistName)
    UNIT_ANNOTATION_STREAM_LIST(TAliceMusicAlbumTitleAnnotation, TStream::AliceMusicAlbumTitle)
    UNIT_ANNOTATION_STREAM_LIST(TAliceMusicTrackArtistNamesAnnotation, TStream::AliceMusicTrackArtistNames)
    UNIT_ANNOTATION_STREAM_LIST(TAliceMusicTrackAlbumTitleAnnotation, TStream::AliceMusicTrackAlbumTitle)
    UNIT_ANNOTATION_STREAM_LIST(TAliceMusicTrackLyricsAnnotation, TStream::AliceMusicTrackLyrics)

    UNIT_ANNOTATION_STREAM_LIST(TMusicFirstClickAnnotation, TStream::MusicFirstClick)
    UNIT_ANNOTATION_STREAM_LIST(TMusicLastClickAnnotation, TStream::MusicLastClick)
    UNIT_ANNOTATION_STREAM_LIST(TMusicLongClickAnnotation, TStream::MusicLongClick)
    UNIT_ANNOTATION_STREAM_LIST(TMusicSingleClickAnnotation, TStream::MusicSingleClick)

    UNIT_ANNOTATION_STREAM_LIST(TMskuOfferSearchTextAnnotation, TStream::MskuOfferSearchText)
    UNIT_ANNOTATION_STREAM_LIST(TMskuOfferTitleAnnotation, TStream::MskuOfferTitle)

    UNIT_ANNOTATION_STREAM_LIST(TMetadocBQRPAnnotation, TStream::MetadocBQRP)
    UNIT_ANNOTATION_STREAM_LIST(TMetadocFirstClickDTXFAnnotation, TStream::MetadocFirstClickDTXF)
    UNIT_ANNOTATION_STREAM_LIST(TMetadocLongClickAnnotation, TStream::MetadocLongClick)
    UNIT_ANNOTATION_STREAM_LIST(TMetadocLongClickSPAnnotation, TStream::MetadocLongClickSP)
    UNIT_ANNOTATION_STREAM_LIST(TMetadocOneClickAnnotation, TStream::MetadocOneClick)
    UNIT_ANNOTATION_STREAM_LIST(TMetadocSimpleClickAnnotation, TStream::MetadocSimpleClick)
    UNIT_ANNOTATION_STREAM_LIST(TMetadocSplitDTAnnotation, TStream::MetadocSplitDT)
    UNIT_ANNOTATION_STREAM_LIST(TMetadocBQPRSampleAnnotation, TStream::MetadocBQPRSample)
    UNIT_ANNOTATION_STREAM_LIST(TMetadocNHOPAnnotation, TStream::MetadocNHOP)

    UNIT_ANNOTATION_STREAM_LIST(TVendorNameAnnotation, TStream::VendorName)
    UNIT_ANNOTATION_STREAM_LIST(TShopNameAnnotation, TStream::ShopName)
    UNIT_ANNOTATION_STREAM_LIST(TShopCategoriesAnnotation, TStream::ShopCategories)

    UNIT_ANNOTATION_STREAM_LIST(TNidNamesAnnotation, TStream::NidNames)

} // NCore
} // NTextMachine

#undef UNIT_ANNOTATION_STREAM_LIST
