#include <kernel/vector_machine/ut/sim_aggr.h>

#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

#include <util/generic/vector.h>


using namespace NVectorMachine;

class TCalcerTest : public TTestBase {
private:
    UNIT_TEST_SUITE(TCalcerTest);
        UNIT_TEST(TestSimAggr);
        UNIT_TEST(TestSimAggr2);
    UNIT_TEST_SUITE_END();

public:
    void TestSimAggr() {
        TSimAggrTestCalcer calcer;

        TEmbed query = {0.f, 0.f, 1.f};

        TEmbed ann1 = {0.f, 1.f, 3.f};
        TEmbed ann2 = {0.1f, 0.f, 1.f};
        TVector<TEmbed> anns = {ann1, ann2};

        TWeights weights = {0.7f, 0.3f};
        TVector<float> expected = {0.997519, 0.98593, 0.997519, 0.997519, 0.997519, 0.98593,
                                    0.682039, 0.490647, 0.682039, 0.682039, 0.682039, 0.490647,
                                    0.997519, 0.974342, 0.997519, 0.997519, 0.997519, 0.974342,
                                    0.682039, 0.299256, 0.682039, 0.682039, 0.682039, 0.299256,
                                    0.7, 0.5, 1, 0.166667, 0.5, 0.7, 0.5, 1, 0.166667, 0.5,
                                    0.997519, 0.997519, 0.981295, 0.981295, 0.974342, 0.997519};

        TVector<float> features(expected.size());
        calcer.CalcFeatures(query, anns, {weights}, TArrayRef<float>(features.data(), features.size()));

        CompareResults(expected, features);
    }

    void TestSimAggr2() {
        TSimAggrAnotherTestCalcer calcer;

        TEmbed query = {0.104791, 0.483404, 0.467462, 0.236114, 0.415697, 0.356886, 0.353371, 0.236699};

        TVector<TEmbed> anns = {
            {0.429341, 0.325032, 0.0228862, 0.178217, 0.483163, 0.0609367, 0.478061, 0.460471},
            {0.3865, 0.469499, 0.321078, 0.120062, 0.512556, 0.420506, 0.269868, 0.0177493},
            {0.079213, 0.194963, 0.415518, 0.231241, 0.532118, 0.404399, 0.516863, 0.125506},
            {0.440462, 0.535951, 0.466707, 0.453224, 0.225365, 0.050136, 0.0567288, 0.197487},
            {0.00562296, 0.476415, 0.470109, 0.196305, 0.0320141, 0.50269, 0.267773, 0.43363},
            {0.207545, 0.571109, 0.0679299, 0.584818, 0.338747, 0.0953064, 0.322629, 0.237088},
            {0.00949804, 0.340009, 0.326495, 0.479278, 0.504206, 0.313545, 0.334042, 0.289619},
            {0.0967614, 0.660272, 0.358062, 0.192758, 0.366287, 0.361302, 0.10372, 0.337419},
            {0.535371, 0.00786321, 0.584542, 0.360672, 0.254828, 0.0793123, 0.110168, 0.397716},
            {0.267915, 0.0697173, 0.476146, 0.0293617, 0.220363, 0.311057, 0.634372, 0.384759},
            {0.32901, 0.662512, 0.252777, 0.125566, 0.479924, 0.0962818, 0.273698, 0.242196},
            {0.385524, 0.497797, 0.410632, 0.258236, 0.228508, 0.155497, 0.382188, 0.381841},
            {0.448842, 0.161469, 0.167845, 0.497464, 0.376169, 0.471613, 0.136096, 0.338203},
            {0.603892, 0.143526, 0.288916, 0.210272, 0.260185, 0.321797, 0.557322, 0.0719153},
            {0.144952, 0.14414, 0.0392417, 0.587264, 0.344137, 0.254444, 0.55366, 0.349401},
            {0.0570302, 0.452886, 0.140365, 0.385193, 0.470824, 0.0607889, 0.353701, 0.522581},
            {0.21749, 0.0305834, 0.372417, 0.360477, 0.658767, 0.435022, 0.0957368, 0.225257},
            {0.12671, 0.260495, 0.0964671, 0.077007, 0.405051, 0.609836, 0.465509, 0.38495},
            {0.176593, 0.209658, 0.561143, 0.526335, 0.179747, 0.0101572, 0.515837, 0.185602},
        };

        TVector<TWeights> weights = {
            {9.04749, 8.32507, 4.37797, 4.7488, 5.74752, 2.05271, 9.81116, 6.18529, 6.39856, 0.749833, 1.04863, 6.40664, 4.01874, 4.30951, 2.44877, 8.40334, 9.0452, 5.21539, 4.08569},
            {},
            {1.36247, 9.29014, 6.64368, 7.28651, 3.13813, 2.57839, 7.1685, 3.64821, 9.66302, 9.71407, 6.26884, 4.5839, 0.655299, 0.388737, 4.6823, 7.25566, 0.27983, 4.64232, 8.9774},
        };
        TVector<float> thresholdValues = {
            0.06343, 0.129184, 0.48175, 0.628923, 0.728073, 0.844045, 1.49944, 1.70553, 1.93554,
            2.19923, 3.37819, 3.78125, 4.89869, 4.95236, 6.99682, 7.25552, 8.41975, 8.47536, 9.61181};
        TVector<float> expected = {
            0.469969, 0.46479, 0.469969, 0.469793, 0.462692,
            0.421575, 4.60749, 3.68039, 4.60749, 4.1948, 3.52569,
            2.22214, 0.469969, 0.454942, 0.469969, 0.469618,
            0.454302, 0.34281, 3.64034, 1.76543, 3.64034, 3.64034,
            3.07482, 0.113755, 8.9774, 3.84022, 1, 0.411765, 0.964134,
            8.9774, 5.2888, 0.727273, 0.285714, 0.954864, 0.423782,
            0.423782, 0.422728, 0.407486, 0.423109};

        TVector<float> features(expected.size());
        calcer.CalcFeatures(query, anns, weights, TArrayRef<float>(features.data(), features.size()), thresholdValues);

        CompareResults(expected, features);
    }

    void CompareResults(const TVector<float>& expected, const TVector<float>& features) {
        UNIT_ASSERT_VALUES_EQUAL(features.size(), expected.size());

        for (size_t i = 0; i < features.size(); ++i) {
            UNIT_ASSERT_DOUBLES_EQUAL(features[i], expected[i], 1e-5);
        }
    }
};

UNIT_TEST_SUITE_REGISTRATION(TCalcerTest);
