#include "factor_names.h"

#include <util/generic/singleton.h>
#include <util/generic/hash.h>

// autogenerated code
#include <kernel/web_factors_info/factors_gen.cpp>

class TGlobalWebFactorsInfo : public TWebFactorsInfo<TFactorInfo> {
public:
    TGlobalWebFactorsInfo()
        : TWebFactorsInfo<TFactorInfo>(N_FACTOR_COUNT, GetFactorsInfo())
    {
    }
};

inline const TWebFactorsInfo<TFactorInfo>* GetWebFactorsInfoImpl() {
    return Singleton<TGlobalWebFactorsInfo>();
}

const IFactorsInfo* GetWebFactorsInfo() {
    return GetWebFactorsInfoImpl();
}

TAutoPtr<IFactorsInfo> GetFactorsInfoIf(size_t begin, size_t end) {
    Y_ASSERT(begin <= end);
    Y_ASSERT(end <= N_FACTOR_COUNT);
    return new TWebFactorsInfo<TFactorInfo>(begin, end, GetFactorsInfo());
}

size_t GetFactorCount() {
    return GetWebFactorsInfo()->GetFactorCount();
}

EFactorId GetFactorIndex(const char* name) {
    size_t index = -1;

    if (GetWebFactorsInfo()->GetFactorIndex(name, &index))
        return (EFactorId)index;
    else
        return (EFactorId)(GetWebFactorsInfo()->GetFactorCount() + 1);
}

bool GetFactorIndex(const char* name, EFactorId* result) {
    size_t index = -1;
    if (GetWebFactorsInfo()->GetFactorIndex(name, &index)) {
        *result = (EFactorId)index;
        return true;
    } else
        return false;
}

bool GetFactorIndex(const TString& name, EFactorId* result) {
    return GetFactorIndex(name.c_str(), result);
}

const char* GetFactorName(size_t i) {
    return GetWebFactorsInfo()->GetFactorName(i);
}

const char* GetFactorInternalName(size_t i) {
    return pszFacNames[i].InternalName;
}

const char* const* GetFactorNames() {
    return GetWebFactorsInfo()->GetFactorNames();
}

bool FactorHasTag(size_t index, TFactorInfo::ETag tag) {
    return GetWebFactorsInfoImpl()->HasTag(index, tag);
}

bool IsOftenZero(size_t index) {
    return GetWebFactorsInfo()->IsOftenZero(index);
}

bool IsBinary(size_t index) {
    return GetWebFactorsInfo()->IsBinary(index);
}

bool IsStaticFactor(size_t index) {
    return GetWebFactorsInfo()->IsStaticFactor(index);
}

bool IsTextFactor(size_t index) {
    return GetWebFactorsInfo()->IsTextFactor(index);
}

bool IsLinkFactor(size_t index) {
    return GetWebFactorsInfo()->IsLinkFactor(index);
}

bool IsQueryFactor(size_t index) {
    return GetWebFactorsInfo()->IsQueryFactor(index);
}

bool IsBrowserFactor(size_t index) {
    return GetWebFactorsInfo()->IsBrowserFactor(index);
}

bool IsUserFactor(size_t index) {
    return GetWebFactorsInfo()->IsUserFactor(index);
}

bool IsUnusedFactor(size_t index) {
    return GetWebFactorsInfo()->IsUnusedFactor(index);
}

bool IsUnimplementedFactor(size_t index) {
    return GetWebFactorsInfo()->IsUnimplementedFactor(index);
}

bool IsDeprecatedFactor(size_t index) {
    return GetWebFactorsInfo()->IsDeprecatedFactor(index);
}

bool IsRemovedFactor(size_t index) {
    return GetWebFactorsInfo()->IsRemovedFactor(index);
}

bool IsNot01Factor(size_t index) {
    return GetWebFactorsInfo()->IsNot01Factor(index);
}

bool IsMetaFactor(size_t index) {
    return GetWebFactorsInfo()->IsMetaFactor(index);
}

bool IsTransFactor(size_t index) {
    return GetWebFactorsInfo()->IsTransFactor(index);
}

bool IsFastrankFactor(size_t index) {
    return GetWebFactorsInfo()->IsFastrankFactor(index);
}

bool IsLocalizedFactor(size_t index) {
    return GetWebFactorsInfo()->IsLocalizedFactor(index);
}

bool IsStaticReginfoFactor(size_t index) {
    return GetWebFactorsInfo()->IsStaticReginfoFactor(index);
}

const size_t AntiSEOsize = sizeof(AntiSEOFactors)/sizeof(AntiSEOFactors[0]);
const size_t NeedToCut = 11;

void CutSeoFactors(TFactorView& factors) {
    for (size_t i = 0; i < NeedToCut; i++) {
        const TAntiSEOFactorInfo& aseoFactor = AntiSEOFactors[i];
        factors[aseoFactor.FactorID] = Min(aseoFactor.UpperBound, factors[ aseoFactor.FactorID ]);
    }
}

void CopyOnlySEOFactors(const TConstFactorView& source, TFactorView& dest) {
    for (size_t i = 0; i < AntiSEOsize; ++i) {
        const TAntiSEOFactorInfo& aseoFactor = AntiSEOFactors[i];
        dest[aseoFactor.FactorID] = Min(aseoFactor.UpperBound, source[ aseoFactor.FactorID ]);
    }
}

void CopyOnlySEOFactors(const float* source, float* dest) {
    for (size_t i = 0; i < AntiSEOsize; ++i) {
        const TAntiSEOFactorInfo& aseoFactor = AntiSEOFactors[i];
        dest[aseoFactor.FactorID] = Min(aseoFactor.UpperBound, source[ aseoFactor.FactorID ]);
    }
}
