#include "factor_names.h"

// autogenerated code
#include <kernel/generated_factors_info/simple_factors_info.h>

namespace NWebMetaItdItp {

class TWebMetaItdItpFactorsInfo: public TSimpleSearchFactorsInfo<NWebMetaItdItp::TFactorInfo> {
public:
    TWebMetaItdItpFactorsInfo()
        : TSimpleSearchFactorsInfo<NWebMetaItdItp::TFactorInfo>(FI_FACTOR_COUNT, GetFactorsInfo())
    {
    }

    TWebMetaItdItpFactorsInfo(size_t begin, size_t end, const NWebMetaItdItp::TFactorInfo* factors)
        : TSimpleSearchFactorsInfo<NWebMetaItdItp::TFactorInfo>(end - begin, factors + begin)
    {
    }
};

const IFactorsInfo* GetWebMetaItdItpFactorsInfo() {
    return Singleton<TWebMetaItdItpFactorsInfo>();
}

// This function is declared in code-generated header factors_gen.h
TAutoPtr<IFactorsInfo> GetFactorsInfoIf(size_t begin, size_t end) {
    Y_ASSERT(begin <= end);
    Y_ASSERT(end <= N_FACTOR_COUNT);
    return new TWebMetaItdItpFactorsInfo(begin, end, GetFactorsInfo());
}

}  // namespace NWebMetaItdItp
