#include "factor_names.h"

// autogenerated code
#include <kernel/generated_factors_info/simple_factors_info.h>

namespace NWebRtModels {

class TWebRtModelsFactorsInfo: public TSimpleSearchFactorsInfo<NWebRtModels::TFactorInfo> {
public:
    TWebRtModelsFactorsInfo()
        : TSimpleSearchFactorsInfo<NWebRtModels::TFactorInfo>(FI_FACTOR_COUNT, GetFactorsInfo())
    {
    }

    TWebRtModelsFactorsInfo(size_t begin, size_t end, const NWebRtModels::TFactorInfo* factors)
        : TSimpleSearchFactorsInfo<NWebRtModels::TFactorInfo>(end - begin, factors + begin)
    {
    }
};

const IFactorsInfo* GetWebRtModelsFactorsInfo() {
    return Singleton<TWebRtModelsFactorsInfo>();
}

// This function is declared in code-generated header factors_gen.h
TAutoPtr<IFactorsInfo> GetFactorsInfoIf(size_t begin, size_t end) {
    Y_ASSERT(begin <= end);
    Y_ASSERT(end <= N_FACTOR_COUNT);
    return new TWebRtModelsFactorsInfo(begin, end, GetFactorsInfo());
}

}  // namespace NWebRtModels
