#include <cmath>

#include <library/cpp/packedtypes/packedfloat.h>

#include <util/generic/string.h>

#include "xmap.h"

// autogenerated code
#include <kernel/xref/xmap_gen.cpp>

template<class X, size_t SIZE>
class TLookupTable {
    float Table[SIZE];
public:
    TLookupTable() {
        for (size_t i = 0; i < SIZE; ++i) {
            Table[i] = X::Value(i);
        }
    }
    float operator[](size_t i) {
        return i < SIZE ? Table[i] : X::Value(i);
    }
};

struct TTic {
    static float Value(size_t i) {
        if (i > 100) {
            // Учитываем ТИЦ, только в случае, когда он достаточно высокий
            return 2.0f + 0.2f * log((double)i);
        } else {
            return 1.0f;
        }
    }
};

struct TExp {
    static float Value(size_t i) {
        return exp(-0.1f * i);
    }
};

TLookupTable<TTic, 512> ticTable;
TLookupTable<TExp, 1 << XMapLinkBits> expTable;

float CalcAbsoluteWeight(const TAbsoluteWeightFeatures& params) {
    float linkWeight = ticTable[params.OwnerFromTIC];
    if (params.IsInternal) {
        linkWeight *= 0.3f; // Внутренняя ссылка
    }
    if (params.OwnersMatchedCategoryCount > 0) {
        linkWeight *= 1.2f; // Учли совпадение категорий источника и цели ссылки
    }
    return linkWeight;
}

float CalcRelativeWeight(const TXMapLinkInfo& linkInfo, const TXMapTextInfo& textInfo) {
    const float freqWeight = expTable[linkInfo.OrderNumberWithThisText];
    return CalcAbsoluteWeight(linkInfo, textInfo) * freqWeight;
}

TXMapInfo Str2XMap(const TString& str) {
    size_t strLen = str.size();
    if (strLen < sizeof(TXMapInfo)) {
        TXMapInfo xMapInfoBuf;
        memcpy(&xMapInfoBuf, str.data(), strLen);
        memset((char *)&xMapInfoBuf + strLen, 0, sizeof(TXMapInfo) - strLen);
        return xMapInfoBuf;
    }
    return *(TXMapInfo*)str.data();
}

const float TPackedGroupSizeHelpers::ScaleFactor = 1024.0f; //maximum possible factor doesn't lead to accuracy loss with value=1

ui8 TPackedGroupSizeHelpers::Pack(ui32 value) {
    return uf8d::New(value / ScaleFactor).val;
}

ui32 TPackedGroupSizeHelpers::Unpack(ui8 packedValue) {
    uf8d tmp;
    tmp.val = packedValue;
    return static_cast<float>(tmp) * ScaleFactor + 0.5;
}
