#pragma once

#include <kernel/xref/enums/bits.h>

static const size_t OwnersMatchedCategoryBits = 8; // Количество бит, отводимых для хранения количества совпадающих категорий

// autogenerated structures
#include <kernel/xref/xmap_gen.h>

#include <util/generic/fwd.h>

// Информация о предложении из каталога, сохраняемая в xmap
struct TXMapCatalogInfo { // 12 байт
    enum TCatalogName {
        CN_YANDEX,
        CN_APORT,
        CN_DMOZ,
        CN_MAILRU,
        CN_WIKIPEDIA_TITLES,
        CN_ADDRESSES,
        CN_GOOD_LINKS,
        CN_MARKET_MODEL_DOC,
        CN_VIDEOXML,
        CN_MARKET_REVIEW,
        CN_MARKET_MODEL_OPINION,
        CN_MARKET_SHOP_OPINION,
        CN_AUTO_VITAL,
        CN_IMG2LINK,
        CN_TIMETABLES_TRAINS,
        CN_AUTO_LIST_PAGES,
        CN_YANDEX_SERVICES,
        CN_TIMETABLES,
        CN_WIKIPEDIA_EXTERNAL,
    };

    enum TFieldType {
        FT_TITLE, // Заголовок
        FT_DESCRIPTION, // Описание
        FT_OFFICIAL, // Официальная информация
        FT_MAX = FT_OFFICIAL
    };

    // 12 байт
    ui32 EntryType:1; // Должно быть первым полем, тип источника ссылки (ET_CATALOG)
    TCatalogName Name;
    TFieldType FieldType;
};

// Информация, хранимая в xmap-файле


// старое

struct TXMapInfo { // 36 байт
    //версия для записи в файл index.refxmap
    enum EXMapVersion {
        Version = 1,
    };
    // Типы источников предложений в ссылочном индексе (в порядке уменьшения важности)
    enum TEntryType {
        ET_CATALOG,
        ET_LINK
    };

    // 24 байтa
    union {
        ui32 EntryType:1; // 4 байта
        TXMapLinkInfo LinkInfo; // 24 байтa
        TXMapCatalogInfo CatalogInfo; // 12 байт
    };
    static_assert(sizeof(TXMapLinkInfo) == 24 && sizeof(TXMapCatalogInfo) == 12, "expect sizeof(TXMapLinkInfo) == 24 && sizeof(TXMapCatalogInfo) == 12");

    // 12 байт
    // hack: if you want extend TXMapLinkInfo put new fields here.
    TXMapTextInfo TextInfo;
};


// новое

class TXMapEnums {
public:
    // Типы источников предложений в ссылочном индексе (в порядке уменьшения важности)
    enum EEntryType {
        ET_LINK = 0,
        ET_CATALOG = 1,
        ET_MANGO = 2
    };
};

static_assert(sizeof(TXMapLinkInfo) == 24 && sizeof(TXMapCatalogInfo) == 12, "expect sizeof(TXMapLinkInfo) == 24 && sizeof(TXMapCatalogInfo) == 12");

struct TLinkXMap {
    static const TXMapEnums::EEntryType TypeId = TXMapEnums::ET_LINK;

    TXMapLinkInfo LinkInfo; // 24 байтa
    TXMapTextInfo TextInfo; // 12 байт
};

struct TCatalogXMap {
    static const TXMapEnums::EEntryType TypeId = TXMapEnums::ET_CATALOG;

    union {
        TXMapLinkInfo DeprecatedLinkInfo; // 24 байтa
        TXMapCatalogInfo CatalogInfo; // 12 байт
    };
    TXMapTextInfo TextInfo;
};


struct TAbsoluteWeightFeatures {
    ui32 OwnerFromTIC;
    ui32 IsInternal;
    ui32 OwnersMatchedCategoryCount;

    TAbsoluteWeightFeatures(const TXMapLinkInfo& linkInfo, const TXMapTextInfo& /*textInfo*/)
        : OwnerFromTIC(linkInfo.OwnerFromTIC)
        , IsInternal(linkInfo.IsInternal)
        , OwnersMatchedCategoryCount(linkInfo.OwnersMatchedCategoryCount)
    {
    }

    TAbsoluteWeightFeatures(ui32 ownerFromTIC, ui32 isInternal, ui32 ownersMatchedCategoryCount)
        : OwnerFromTIC(ownerFromTIC)
        , IsInternal(isInternal)
        , OwnersMatchedCategoryCount(ownersMatchedCategoryCount)
    {
    }
};

// Вычислить абсолютный вес ссылки, не зависящий от запроса
float CalcAbsoluteWeight(const TAbsoluteWeightFeatures& params);
inline float CalcAbsoluteWeight(const TXMapLinkInfo& linkInfo, const TXMapTextInfo& textInfo) {
    return CalcAbsoluteWeight(TAbsoluteWeightFeatures(linkInfo, textInfo));
}

// Вычислить вес ссылки, зависящий от порядка ссылки с таким текстом на данный документ по абсолютному весу
// (менне весомые ссылки получают больший штраф)
float CalcRelativeWeight(const TXMapLinkInfo& linkInfo, const TXMapTextInfo& textInfo);

// интерпретировать строку как TXMapInfo, если она достаточно большого размера. Если нет - дополнить нулями.
TXMapInfo Str2XMap(const TString& str);

// методы запаковки/распаковки размера группы ссылок TXMapTextInfo::PackedGroupSize
class TPackedGroupSizeHelpers {
    static const float ScaleFactor;
public:
    static ui8 Pack(ui32 value);
    static ui32 Unpack(ui8 packedValue);
};

//#pragma pack(pop)

//static_assert(sizeof(TXMapInfo) == 36, "expect sizeof(TXMapInfo) == 36");
