#include <library/cpp/auth_client_parser/oauth_token.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NAuthClientParser;

Y_UNIT_TEST_SUITE(OAuthTest) {
    Y_UNIT_TEST(EmbeddedV2) {
        const TString t = "AQAAAADue-GoAAAI2wSUpddcm0BIk-r70vL1O_A";

        TOAuthToken token;
        UNIT_ASSERT(token.Parse(t));
        UNIT_ASSERT_VALUES_EQUAL(4001096104, token.Uid());

        UNIT_ASSERT(!token.Parse(t + "="));
        UNIT_ASSERT(!token.Parse(t.substr(1)));
        UNIT_ASSERT(!token.Parse(t.substr(0, t.size() - 1)));

        UNIT_ASSERT(!token.Parse("AQAAAADue+GoAAAI2wSUpddcm0BIk+r70vL1O_A"));
        UNIT_ASSERT(!token.Parse("AQAAAADue-GoAAAI2wSUpddcm0BIk r70vL1O_A"));
    }

    Y_UNIT_TEST(EmbeddedV3) {
        const TString t = "y0_AQAAAAAAAYiUAAAAgQAAAAA63mixeHh4eHh4eHh4eHh4eHh4eMmOnSA";

        TOAuthToken token;
        UNIT_ASSERT(token.Parse(t));
        UNIT_ASSERT_VALUES_EQUAL(100500, token.Uid());

        UNIT_ASSERT(!token.Parse(t + "="));
        UNIT_ASSERT(!token.Parse(t.substr(1)));
        UNIT_ASSERT(!token.Parse(t.substr(0, t.size() - 1)));

        UNIT_ASSERT(!token.Parse("y0_AQAAAAAAAYiUAAAAgQAAAAA63mix+Hh4eHh4eHh4eHh4eHh4eMmOnSA"));
        UNIT_ASSERT(!token.Parse("g0_AQAAAAAAAYiUAAAAgQAAAAA63mixeHh4eHh4eHh4eHh4eHh4eMmOnSA"));
        UNIT_ASSERT(!token.Parse("y7_AQAAAAAAAYiUAAAAgQAAAAA63mixeHh4eHh4eHh4eHh4eHh4eMmOnSA"));
        UNIT_ASSERT(!token.Parse("y0_AQAAAAAAAYiUAAAAgQAAAAA63mixeHh4eHh4eHh4eHh4eHh4eMmOnSE"));
    }

    Y_UNIT_TEST(Stateless) {
        const TString t = "1.4001096104.2210.1512479857.1512476257123.13154.oFwc1_eJDBrNNs_E.cdBTeV99NFpOnkmr1AtnN7fgXqEUBYd-N3ZNLf3yubmdrBIYAczU88dBNxuyShPJ4TqXwi4d8WBmrZJ98_ZIAXynPHecLG_lIFPl135KQBidRiXpf7ubL8hS9MgtFD92ZVLk8WlJzzvU37ypuHNwTPsmgSNP93MkSiFjideKk9HRz9-2NQ17Jpc8hINJMu7hrzvLYPEQhDpOqoqY4d4yyjezoXDYeLcMyETSDAhBWQ.NHQXrOQyjiIFxjdxViza-Q";

        TOAuthToken token;
        UNIT_ASSERT(token.Parse(t));
        UNIT_ASSERT_VALUES_EQUAL(4001096104, token.Uid());
    }

    Y_UNIT_TEST(StatelessBadVersion) {
        UNIT_ASSERT(!TOAuthToken().Parse("2.4001096104.2210.1512479857.1512476257123.13154.oFwc1_eJDBrNNs_E.cdBTeV99NFpOnkmr1AtnN7fgXqEUBYd-N3ZNLf3yubmdrBIYAczU88dBNxuyShPJ4TqXwi4d8WBmrZJ98_ZIAXynPHecLG_lIFPl135KQBidRiXpf7ubL8hS9MgtFD92ZVLk8WlJzzvU37ypuHNwTPsmgSNP93MkSiFjideKk9HRz9-2NQ17Jpc8hINJMu7hrzvLYPEQhDpOqoqY4d4yyjezoXDYeLcMyETSDAhBWQ.NHQXrOQyjiIFxjdxViza-Q"));
        UNIT_ASSERT(!TOAuthToken().Parse(".4001096104.2210.1512479857.1512476257123.13154.oFwc1_eJDBrNNs_E.cdBTeV99NFpOnkmr1AtnN7fgXqEUBYd-N3ZNLf3yubmdrBIYAczU88dBNxuyShPJ4TqXwi4d8WBmrZJ98_ZIAXynPHecLG_lIFPl135KQBidRiXpf7ubL8hS9MgtFD92ZVLk8WlJzzvU37ypuHNwTPsmgSNP93MkSiFjideKk9HRz9-2NQ17Jpc8hINJMu7hrzvLYPEQhDpOqoqY4d4yyjezoXDYeLcMyETSDAhBWQ.NHQXrOQyjiIFxjdxViza-Q"));
        UNIT_ASSERT(!TOAuthToken().Parse("0.4001096104.2210.1512479857.1512476257123.13154.oFwc1_eJDBrNNs_E.cdBTeV99NFpOnkmr1AtnN7fgXqEUBYd-N3ZNLf3yubmdrBIYAczU88dBNxuyShPJ4TqXwi4d8WBmrZJ98_ZIAXynPHecLG_lIFPl135KQBidRiXpf7ubL8hS9MgtFD92ZVLk8WlJzzvU37ypuHNwTPsmgSNP93MkSiFjideKk9HRz9-2NQ17Jpc8hINJMu7hrzvLYPEQhDpOqoqY4d4yyjezoXDYeLcMyETSDAhBWQ.NHQXrOQyjiIFxjdxViza-Q"));
    }

    Y_UNIT_TEST(StatelessBadNums) {
        UNIT_ASSERT(!TOAuthToken().Parse("1.*4001096104.2210.1512479857.1512476257123.13154.oFwc1_eJDBrNNs_E.cdBTeV99NFpOnkmr1AtnN7fgXqEUBYd-N3ZNLf3yubmdrBIYAczU88dBNxuyShPJ4TqXwi4d8WBmrZJ98_ZIAXynPHecLG_lIFPl135KQBidRiXpf7ubL8hS9MgtFD92ZVLk8WlJzzvU37ypuHNwTPsmgSNP93MkSiFjideKk9HRz9-2NQ17Jpc8hINJMu7hrzvLYPEQhDpOqoqY4d4yyjezoXDYeLcMyETSDAhBWQ.NHQXrOQyjiIFxjdxViza-Q"));
        UNIT_ASSERT(!TOAuthToken().Parse("1.400109 6104.2210.1512479857.1512476257123.13154.oFwc1_eJDBrNNs_E.cdBTeV99NFpOnkmr1AtnN7fgXqEUBYd-N3ZNLf3yubmdrBIYAczU88dBNxuyShPJ4TqXwi4d8WBmrZJ98_ZIAXynPHecLG_lIFPl135KQBidRiXpf7ubL8hS9MgtFD92ZVLk8WlJzzvU37ypuHNwTPsmgSNP93MkSiFjideKk9HRz9-2NQ17Jpc8hINJMu7hrzvLYPEQhDpOqoqY4d4yyjezoXDYeLcMyETSDAhBWQ.NHQXrOQyjiIFxjdxViza-Q"));
        UNIT_ASSERT(!TOAuthToken().Parse("1.4001096104.2a210.1512479857.1512476257123.13154.oFwc1_eJDBrNNs_E.cdBTeV99NFpOnkmr1AtnN7fgXqEUBYd-N3ZNLf3yubmdrBIYAczU88dBNxuyShPJ4TqXwi4d8WBmrZJ98_ZIAXynPHecLG_lIFPl135KQBidRiXpf7ubL8hS9MgtFD92ZVLk8WlJzzvU37ypuHNwTPsmgSNP93MkSiFjideKk9HRz9-2NQ17Jpc8hINJMu7hrzvLYPEQhDpOqoqY4d4yyjezoXDYeLcMyETSDAhBWQ.NHQXrOQyjiIFxjdxViza-Q"));
        UNIT_ASSERT(!TOAuthToken().Parse("1.4001096104.2210.151247985`7.1512476257123.13154.oFwc1_eJDBrNNs_E.cdBTeV99NFpOnkmr1AtnN7fgXqEUBYd-N3ZNLf3yubmdrBIYAczU88dBNxuyShPJ4TqXwi4d8WBmrZJ98_ZIAXynPHecLG_lIFPl135KQBidRiXpf7ubL8hS9MgtFD92ZVLk8WlJzzvU37ypuHNwTPsmgSNP93MkSiFjideKk9HRz9-2NQ17Jpc8hINJMu7hrzvLYPEQhDpOqoqY4d4yyjezoXDYeLcMyETSDAhBWQ.NHQXrOQyjiIFxjdxViza-Q"));
        UNIT_ASSERT(!TOAuthToken().Parse("1.4001096104.2210.1512479857.15124762-57123.13154.oFwc1_eJDBrNNs_E.cdBTeV99NFpOnkmr1AtnN7fgXqEUBYd-N3ZNLf3yubmdrBIYAczU88dBNxuyShPJ4TqXwi4d8WBmrZJ98_ZIAXynPHecLG_lIFPl135KQBidRiXpf7ubL8hS9MgtFD92ZVLk8WlJzzvU37ypuHNwTPsmgSNP93MkSiFjideKk9HRz9-2NQ17Jpc8hINJMu7hrzvLYPEQhDpOqoqY4d4yyjezoXDYeLcMyETSDAhBWQ.NHQXrOQyjiIFxjdxViza-Q"));
        UNIT_ASSERT(!TOAuthToken().Parse("1.4001096104.2210.1512479857.1512476257123.-13154.oFwc1_eJDBrNNs_E.cdBTeV99NFpOnkmr1AtnN7fgXqEUBYd-N3ZNLf3yubmdrBIYAczU88dBNxuyShPJ4TqXwi4d8WBmrZJ98_ZIAXynPHecLG_lIFPl135KQBidRiXpf7ubL8hS9MgtFD92ZVLk8WlJzzvU37ypuHNwTPsmgSNP93MkSiFjideKk9HRz9-2NQ17Jpc8hINJMu7hrzvLYPEQhDpOqoqY4d4yyjezoXDYeLcMyETSDAhBWQ.NHQXrOQyjiIFxjdxViza-Q"));
    }

    Y_UNIT_TEST(StatelessBadCrypto) {
        UNIT_ASSERT(!TOAuthToken().Parse("1.4001096104.2210.1512479857.1512476257123.13154.oFwc1_eJDBrNNs E.cdBTeV99NFpOnkmr1AtnN7fgXqEUBYd-N3ZNLf3yubmdrBIYAczU88dBNxuyShPJ4TqXwi4d8WBmrZJ98_ZIAXynPHecLG_lIFPl135KQBidRiXpf7ubL8hS9MgtFD92ZVLk8WlJzzvU37ypuHNwTPsmgSNP93MkSiFjideKk9HRz9-2NQ17Jpc8hINJMu7hrzvLYPEQhDpOqoqY4d4yyjezoXDYeLcMyETSDAhBWQ.NHQXrOQyjiIFxjdxViza-Q"));
        UNIT_ASSERT(!TOAuthToken().Parse("1.*4001096104.2210.1512479857.1512476257123.13154.oFwc1_eJDBrNNs_E.cdBTeV99NFpOnkmr1AtnN7fgXqEUBYd-N3ZNLf3yubmdrBIYAczU88dBNxuyShPJ4TqXwi4d8WBmrZJ98_ZIAXynPHecLG_lIFPl135KQBidRiXpf7ubL8hS9MgtFD92ZVLk8WlJzzvU37ypuHNwTPsmgSNP93MkSiFjideKk9HRz9+2NQ17Jpc8hINJMu7hrzvLYPEQhDpOqoqY4d4yyjezoXDYeLcMyETSDAhBWQ.NHQXrOQyjiIFxjdxViza-Q"));
        UNIT_ASSERT(!TOAuthToken().Parse("1.*4001096104.2210.1512479857.1512476257123.13154.oFwc1_eJDBrNNs_E.cdBTeV99NFpOnkmr1AtnN7fgXqEUBYd-N3ZNLf3yubmdrBIYAczU88dBNxuyShPJ4TqXwi4d8WBmrZJ98_ZIAXynPHecLG_lIFPl135KQBidRiXpf7ubL8hS9MgtFD92ZVLk8WlJzzvU37ypuHNwTPsmgSNP93MkSiFjideKk9HRz9-2NQ17Jpc8hINJMu7hrzvLYPEQhDpOqoqY4d4yyjezoXDYeLcMyETSDAhBWQ.NHQXrOQyjiIFxjdxViza/Q"));
    }
}
