#include <contrib/libs/clang14/tools/extra/clang-tidy/ClangTidy.h>
#include <contrib/libs/clang14/tools/extra/clang-tidy/ClangTidyModule.h>
#include <contrib/libs/clang14/tools/extra/clang-tidy/ClangTidyModuleRegistry.h>

#include "taxi_coroutine_unsafe_check.h"
#include "taxi_dangling_config_ref_check.h"
#include "taxi_mt_unsafe_check.h"

#include "usage_restriction_checks.h"

using namespace clang::ast_matchers;

namespace clang::tidy::arcadia {
    class ArcadiaModule: public ClangTidyModule {
    public:
        void addCheckFactories(ClangTidyCheckFactories& CheckFactories) override {
            CheckFactories.registerCheck<misc::TaxiCoroutineUnsafeCheck>(
                "arcadia-taxi-coroutine-unsafe");
            CheckFactories.registerCheck<misc::TaxiDanglingConfigRefCheck>(
                "arcadia-taxi-dangling-config-ref");
            CheckFactories.registerCheck<misc::TaxiMtUnsafeCheck>(
                "arcadia-taxi-mt-unsafe");

            // https://st.yandex-team.ru/IGNIETFERRO-1863
            CheckFactories.registerCheck<TypeidNameRestrictionCheck>(
                "arcadia-typeid-name-restriction");
        }
    };

    // Register the ArcadiaTidyModule using this statically initialized variable.
    static ClangTidyModuleRegistry::Add<ArcadiaModule>
        X("arcadia-module", "Adds Arcadia specific lint checks.");

}
