#!/usr/bin/env python

import sys
import os
import optparse
import random


def GenerateCppCode(js_lines, namespace_name, src_basename):
    res = list()
    res.append('#pragma once')
    res.append('')
    res.append('')
    res.append('/*')
    res.append(' * This file was generated by scheme_to_cpp.py script')
    res.append(' *')
    res.append(' * JSON source scheme file: {}'.format(src_basename))
    res.append(' *')
    res.append(' * This file is supposed to be kept in arcadia svn')
    res.append(' * Use cpp embedding method for more convenient production deployment')
    res.append(' */')
    res.append('')
    res.append('')
    res.append('#include <library/cpp/deprecated/omni/all.h>')
    res.append('')
    res.append('namespace N%s {' %namespace_name)
    res.append('')
    res.append('NOmni::TCppEmbeddedScheme GetEmbeddedScheme() {')
    res.append('    const char* jsScheme =')
    for line in js_lines:
        escaped = line.rstrip()
        escaped = escaped.replace('"', '\\"')
        res.append('    "{}\\n"'.format(escaped))
    res.append('    ;')
    res.append('    return NOmni::TCppEmbeddedScheme(jsScheme);')
    res.append('}')
    res.append('')
    res.append('')
    res.append('} // namespace %s' % namespace_name)

    return res;



class CustomParser(optparse.OptionParser):
    def format_epilog(self, formatter):
        return self.epilog


var_usage = """
Additional Description:
    Use this script for more convenient index generation in production settings:
    no need to deploy json index scheme, it can be embedded in the program source code.

    scheme_path    - path to json index scheme
    namespace_name - name of cpp namespace, which would contain embedded scheme
    dst_path       - name of resulting cpp header .h file, which would contain embedded code. You can commit this header to svn

"""

def main():
    parser = CustomParser("%prog [options] scheme_path namespace_name dst_path", epilog = var_usage)
    (options, args) = parser.parse_args()
    assert(len(args) == 3)
    scheme_path = args[0]
    namespace_name = args[1]
    dst_path = args[2]

    js_lines = open(scheme_path).readlines()
    cpp_lines = GenerateCppCode(js_lines, namespace_name, os.path.basename(scheme_path))
    with open(dst_path, 'w') as f:
        f.write('\n'.join(cpp_lines) + '\n')

if __name__ == '__main__':
    main()
