#pragma once

#include "event_field_output.h"

#include <google/protobuf/message.h>

// NB: For historical reasons print code for all primitive types/repeated fields/etc generated by https://a.yandex-team.ru/arc/trunk/arcadia/tools/event2cpp

enum class EProtobufMessageFieldPrintMode {
    // Use <TEventProtobufMessageFieldType>::Print method for fields that has it
    // Print json for other fields
    DEFAULT = 0,

    JSON = 1,
};

class TEventProtobufMessageFieldPrinter {
public:
    explicit TEventProtobufMessageFieldPrinter(EProtobufMessageFieldPrintMode mode);

    template <typename TEventProtobufMessageFieldType, bool HasPrintFunction>
    void PrintProtobufMessageFieldToOutput(const TEventProtobufMessageFieldType& field, TEventFieldOutput& output) {
        if constexpr (HasPrintFunction) {
            if (Mode == EProtobufMessageFieldPrintMode::DEFAULT) {
                field.Print(output.GetOutputStream(), output.GetFlags());
                return;
            }
        }

        PrintProtobufMessageFieldToOutput<google::protobuf::Message, false>(field, output);
    }

    template <>
    void PrintProtobufMessageFieldToOutput<google::protobuf::Message, false>(const google::protobuf::Message& field, TEventFieldOutput& output);

private:
    EProtobufMessageFieldPrintMode Mode;
};
