#include <library/cpp/testing/unittest/registar.h>

#include <library/cpp/int128/int128.h>

#include <type_traits>

Y_UNIT_TEST_SUITE(TypeTraitsSuite) {
    Y_UNIT_TEST(Uint128TypeTraits) {
        // checks that all type traits of ui128 are the same as of ui64
        // https://en.cppreference.com/w/cpp/header/type_traits
        UNIT_ASSERT_EQUAL(
            std::is_void<ui128>::value,
            std::is_void<ui64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_null_pointer<ui128>::value,
            std::is_null_pointer<ui64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_integral<ui128>::value,
            std::is_integral<ui64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_floating_point<ui128>::value,
            std::is_floating_point<ui64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_array<ui128>::value,
            std::is_array<ui64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_enum<ui128>::value,
            std::is_enum<ui64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_union<ui128>::value,
            std::is_union<ui64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_class<ui128>::value,
            std::is_class<ui64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_function<ui128>::value,
            std::is_function<ui64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_pointer<ui128>::value,
            std::is_pointer<ui64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_lvalue_reference<ui128>::value,
            std::is_lvalue_reference<ui64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_rvalue_reference<ui128>::value,
            std::is_rvalue_reference<ui64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_member_object_pointer<ui128>::value,
            std::is_member_object_pointer<ui64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_member_function_pointer<ui128>::value,
            std::is_member_function_pointer<ui64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_fundamental<ui128>::value,
            std::is_fundamental<ui64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_arithmetic<ui128>::value,
            std::is_arithmetic<ui64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_scalar<ui128>::value,
            std::is_scalar<ui64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_object<ui128>::value,
            std::is_object<ui64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_compound<ui128>::value,
            std::is_compound<ui64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_reference<ui128>::value,
            std::is_reference<ui64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_member_pointer<ui128>::value,
            std::is_member_pointer<ui64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_const<ui128>::value,
            std::is_const<ui64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_volatile<ui128>::value,
            std::is_volatile<ui64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_trivial<ui128>::value,
            std::is_trivial<ui64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_standard_layout<ui128>::value,
            std::is_standard_layout<ui64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_pod<ui128>::value,
            std::is_pod<ui64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_literal_type<ui128>::value,
            std::is_literal_type<ui64>::value
        );
#ifndef _MSC_VER
        UNIT_ASSERT_EQUAL(
            std::has_unique_object_representations<ui128>::value,
            std::has_unique_object_representations<ui64>::value
        );
#endif
        UNIT_ASSERT_EQUAL(
            std::is_empty<ui128>::value,
            std::is_empty<ui64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_polymorphic<ui128>::value,
            std::is_polymorphic<ui64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_abstract<ui128>::value,
            std::is_abstract<ui64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_final<ui128>::value,
            std::is_final<ui64>::value
        );
#ifndef _MSC_VER
        UNIT_ASSERT_EQUAL(
            std::is_aggregate<ui128>::value,
            std::is_aggregate<ui64>::value
        );
#endif
        UNIT_ASSERT_EQUAL(
            std::is_signed<ui128>::value,
            std::is_signed<ui64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_unsigned<ui128>::value,
            std::is_unsigned<ui64>::value
        );
    }

    Y_UNIT_TEST(Int128TypeTraits) {
        // checks that all type traits of i128 are the same as of i64
        // https://en.cppreference.com/w/cpp/header/type_traits
        UNIT_ASSERT_EQUAL(
            std::is_void<i128>::value,
            std::is_void<i64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_null_pointer<i128>::value,
            std::is_null_pointer<i64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_integral<i128>::value,
            std::is_integral<i64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_floating_point<i128>::value,
            std::is_floating_point<i64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_array<i128>::value,
            std::is_array<i64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_enum<i128>::value,
            std::is_enum<i64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_union<i128>::value,
            std::is_union<i64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_class<i128>::value,
            std::is_class<i64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_function<i128>::value,
            std::is_function<i64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_pointer<i128>::value,
            std::is_pointer<i64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_lvalue_reference<i128>::value,
            std::is_lvalue_reference<i64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_rvalue_reference<i128>::value,
            std::is_rvalue_reference<i64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_member_object_pointer<i128>::value,
            std::is_member_object_pointer<i64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_member_function_pointer<i128>::value,
            std::is_member_function_pointer<i64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_fundamental<i128>::value,
            std::is_fundamental<i64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_arithmetic<i128>::value,
            std::is_arithmetic<i64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_scalar<i128>::value,
            std::is_scalar<i64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_object<i128>::value,
            std::is_object<i64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_compound<i128>::value,
            std::is_compound<i64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_reference<i128>::value,
            std::is_reference<i64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_member_pointer<i128>::value,
            std::is_member_pointer<i64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_const<i128>::value,
            std::is_const<i64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_volatile<i128>::value,
            std::is_volatile<i64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_trivial<i128>::value,
            std::is_trivial<i64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_standard_layout<i128>::value,
            std::is_standard_layout<i64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_pod<i128>::value,
            std::is_pod<i64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_literal_type<i128>::value,
            std::is_literal_type<i64>::value
        );
#ifndef _MSC_VER
        UNIT_ASSERT_EQUAL(
            std::has_unique_object_representations<i128>::value,
            std::has_unique_object_representations<i64>::value
        );
#endif
        UNIT_ASSERT_EQUAL(
            std::is_empty<i128>::value,
            std::is_empty<i64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_polymorphic<i128>::value,
            std::is_polymorphic<i64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_abstract<i128>::value,
            std::is_abstract<i64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_final<i128>::value,
            std::is_final<i64>::value
        );
#ifndef _MSC_VER
        UNIT_ASSERT_EQUAL(
            std::is_aggregate<i128>::value,
            std::is_aggregate<i64>::value
        );
#endif
        UNIT_ASSERT_EQUAL(
            std::is_signed<i128>::value,
            std::is_signed<i64>::value
        );
        UNIT_ASSERT_EQUAL(
            std::is_unsigned<i128>::value,
            std::is_unsigned<i64>::value
        );
    }
}

