#include "index_digest.h"

namespace NMetatrie {
    ui64 GetPrimeBase(ui64 n) {
        static const ui64 table[] = {
            1ULL, 2ULL, 3ULL, 5ULL, 7ULL, 11ULL,
            13ULL, 17ULL, 19ULL, 23ULL, 29ULL,
            31ULL, 37ULL, 41ULL, 43ULL, 47ULL,
            53ULL, 59ULL, 61ULL, 67ULL, 71ULL,
            79ULL, 97ULL, 107ULL, 131ULL, 157ULL,
            181ULL, 223ULL, 257ULL, 307ULL, 367ULL,
            431ULL, 521ULL, 613ULL, 727ULL, 863ULL,
            1031ULL, 1217ULL, 1451ULL, 1723ULL, 2053ULL,
            2437ULL, 2897ULL, 3449ULL, 4099ULL, 4871ULL,
            5801ULL, 6899ULL, 8209ULL, 9743ULL, 11587ULL,
            13781ULL, 16411ULL, 19483ULL, 23173ULL, 27581ULL,
            32771ULL, 38971ULL, 46349ULL, 55109ULL, 65537ULL,
            77951ULL, 92681ULL, 110221ULL, 131101ULL, 155887ULL,
            185363ULL, 220447ULL, 262147ULL, 311743ULL, 370759ULL,
            440893ULL, 524309ULL, 623521ULL, 741457ULL, 881743ULL,
            1048583ULL, 1246997ULL, 1482919ULL, 1763491ULL, 2097169ULL,
            2493949ULL, 2965847ULL, 3526987ULL, 4194319ULL, 4987901ULL,
            5931641ULL, 7053971ULL, 8388617ULL, 9975803ULL, 11863289ULL,
            14107921ULL, 16777259ULL, 19951597ULL, 23726569ULL, 28215809ULL,
            33554467ULL, 39903197ULL, 47453149ULL, 56431657ULL, 67108879ULL,
            79806341ULL, 94906297ULL, 112863217ULL, 134217757ULL, 159612679ULL,
            189812533ULL, 225726419ULL, 268435459ULL, 319225391ULL, 379625083ULL,
            451452839ULL, 536870923ULL, 638450719ULL, 759250133ULL, 902905657ULL,
            1073741827ULL, 1276901429ULL, 1518500279ULL, 1805811341ULL, 2147483659ULL,
            2553802871ULL, 3037000507ULL, 3611622607ULL, 4294967311ULL, 5107605691ULL,
            6074001001ULL, 7223245229ULL, 8589934609ULL, 10215211387ULL, 12148002047ULL,
            14446490449ULL, 17179869209ULL, 20430422699ULL, 24296004011ULL, 28892980877ULL,
            34359738421ULL, 40860845437ULL, 48592008053ULL, 57785961671ULL, 68719476767ULL,
            81721690807ULL, 97184016049ULL, 115571923303ULL, 137438953481ULL, 163443381347ULL,
            194368032011ULL, 231143846587ULL, 274877906951ULL, 326886762733ULL, 388736063999ULL,
            462287693167ULL, 549755813911ULL, 653773525393ULL, 777472128049ULL, 924575386373ULL,
            1099511627791ULL, 1307547050819ULL, 1554944255989ULL, 1849150772699ULL, 2199023255579ULL,
            2615094101561ULL, 3109888512037ULL, 3698301545321ULL, 4398046511119ULL, 5230188203153ULL,
            6219777023959ULL, 7396603090651ULL, 8796093022237ULL, 10460376406273ULL, 12439554047911ULL,
            14793206181251ULL, 17592186044423ULL, 20920752812471ULL, 24879108095833ULL, 29586412362491ULL,
            35184372088891ULL, 41841505624973ULL, 49758216191633ULL, 59172824724919ULL, 70368744177679ULL,
            83683011249917ULL, 99516432383281ULL, 118345649449813ULL, 140737488355333ULL, 167366022499847ULL,
            199032864766447ULL, 236691298899683ULL, 281474976710677ULL, 334732044999557ULL, 398065729532981ULL,
            473382597799229ULL, 562949953421381ULL, 669464089999087ULL, 796131459065743ULL, 946765195598473ULL,
            1125899906842679ULL, 1338928179998197ULL, 1592262918131449ULL, 1893530391196921ULL, 2251799813685269ULL,
            2677856359996339ULL, 3184525836262943ULL, 3787060782393821ULL, 4503599627370517ULL, 5355712719992603ULL,
            6369051672525833ULL, 7574121564787633ULL};

        const ui64* ub = LowerBound(table, table + Y_ARRAY_SIZE(table), n);
        return ub == (const ui64*)table + Y_ARRAY_SIZE(table) ? n : *ub;
    }

}
