#include "stopwords.h"

#include <util/charset/wide.h>
#include <util/generic/hash_set.h>
#include <util/generic/singleton.h>

namespace {
    const char* const StopWordsRaw[] = {
        "a",
        "an",
        "the",
        "to",
        "of",
        "in",
        "for",
        "that",
        "if",
        "on",
        "with",
        "from",
        "by",
        "at",
        "about",
        "if",
        "but",
        "no",
        "not",
        "all",
        "any",
        "my",
        "your",
        "so",
        "as",
        "what",
        "which",
        "can",
        "will",
        "would",
        "is",
        "me",
        "him",
        "and",
        "or",
        "it",
        "that",
        "you",
        "this",
        "be",
        "have",
        "are",
        "was",
        "do",
        "there",
        "one",
        "we",
        "they",
        "в",
        "во",
        "не",
        "на",
        "что",
        "чего",
        "чему",
        "чем",
        "чём",
        "с",
        "а",
        "как",
        "к",
        "ко",
        "но",
        "по",
        "за",
        "у",
        "из",
        "свой",
        "своего",
        "своему",
        "своим",
        "своем",
        "своём",
        "свое",
        "своё",
        "своя",
        "своей",
        "свою",
        "своею",
        "свои",
        "своих",
        "своими",
        "так",
        "о",
        "об",
        "который",
        "которого",
        "которому",
        "которым",
        "котором",
        "которое",
        "которая",
        "которой",
        "которую",
        "которою",
        "которые",
        "которых",
        "которыми",
        "от",
        "один",
        "одного",
        "одному",
        "одним",
        "одном",
        "одно",
        "одна",
        "одной",
        "одну",
        "одною",
        "одни",
        "одних",
        "одними",
        "для",
        "такой",
        "такого",
        "такому",
        "таким",
        "таком",
        "такое",
        "такая",
        "такую",
        "такою",
        "такие",
        "таких",
        "такими",
        "вот",
        "только",
        "еще",
        "ещё",
        "наш",
        "нашего",
        "нашему",
        "нашем",
        "наше",
        "наша",
        "нашей",
        "нашу",
        "нашею",
        "наши",
        "наших",
        "нашими",
        "нашим",
        "да",
        "нет",
        "до",
        "при",
        "уже",
        "если",
        "мой",
        "моего",
        "моему",
        "моим",
        "моем",
        "моём",
        "мое",
        "моё",
        "моя",
        "моей",
        "мою",
        "моею",
        "мои",
        "моих",
        "моими",
        "чтобы",
        "когда",
        "кто",
        "кого",
        "кому",
        "кем",
        "ком",
        "могу",
        "можешь",
        "может",
        "можем",
        "можете",
        "могут",
        "мог",
        "могла",
        "могло",
        "могли",
        "весь",
        "всего",
        "всему",
        "всем",
        "все",
        "всё",
        "вся",
        "всей",
        "всю",
        "всею",
        "всех",
        "всеми",
        "ну",
        "без",
        "над",
        "про",
        "б",
        "бы",
        "же",
        "ж",
        "сам",
        "себя",
        "себе",
        "собой",
        "собою",
        "тот",
        "того",
        "тому",
        "то",
        "та",
        "той",
        "ту",
        "те",
        "тех",
        "теми",
        "тем",
        "том",
        "я",
        "меня",
        "мне",
        "мной",
        "мною",
        "этот",
        "этого",
        "этому",
        "этим",
        "этом",
        "это",
        "эта",
        "этой",
        "эту",
        "эти",
        "этих",
        "этими",
        "вы",
        "вас",
        "вам",
        "вами",
        "ты",
        "тебя",
        "тебе",
        "тобой",
        "тобою",
        "он",
        "его",
        "него",
        "ему",
        "нему",
        "им",
        "ним",
        "нем",
        "нём",
        "оно",
        "она",
        "ее",
        "её",
        "нее",
        "неё",
        "ей",
        "ней",
        "ею",
        "нею",
        "они",
        "их",
        "них",
        "ими",
        "ними",
        "мы",
        "нас",
        "нам",
        "нами",
        "быть",
        "буду",
        "будешь",
        "будет",
        "будем",
        "будут",
        "был",
        "было",
        "были",
        "была",
        "будь",
        "будьте",
        "и",
        "или",
        "ні",
        "але",
        "ну",
        "з",
        "із",
        "зі",
        "від",
        "під",
        "між",
        "без",
        "од",
        "над",
        "про",
        "це",
        "оце",
        "як",
        "де",
        "щоб",
        "аж",
        "хоч",
        "дуже",
        "хай",
        "поки",
        "таки",
        "якщо",
        "чи",
        "бо",
        "вже",
        "ще",
        "тільки",
        "лише",
        "лиш",
        "саме",
        "навіть",
        "мій",
        "мої",
        "моє",
        "мого",
        "моїх",
        "моєї",
        "моїй",
        "моїм",
        "моєму",
        "моєю",
        "моїми",
        "твій",
        "твоя",
        "твої",
        "твоє",
        "твою",
        "твого",
        "твоїх",
        "твоєї",
        "твоїм",
        "твоїй",
        "твоєму",
        "твоєю",
        "твоїми",
        "свій",
        "свого",
        "своїх",
        "свої",
        "своє",
        "своїм",
        "своєї",
        "своїми",
        "своєю",
        "своїй",
        "своєму",
        "наші",
        "нашого",
        "нашої",
        "нашій",
        "нашому",
        "нашою",
        "нашім",
        "ваш",
        "ваша",
        "ваші",
        "ваше",
        "вашу",
        "ваших",
        "вашого",
        "вашої",
        "вашій",
        "вашим",
        "вашому",
        "вашою",
        "вашими",
        "вашім",
        "їхній",
        "їхні",
        "їхніх",
        "їхня",
        "їхнього",
        "їхню",
        "їхнє",
        "їхньої",
        "їхньому",
        "їхнім",
        "їхніми",
        "їхньою",
        "чий",
        "чия",
        "чиє",
        "чиї",
        "чийого",
        "чиєї",
        "чиїх",
        "чийому",
        "чиєму",
        "чиїй",
        "чиїм",
        "чию",
        "чиєю",
        "чиїми",
        "цей",
        "цього",
        "ці",
        "цю",
        "цьому",
        "ця",
        "цих",
        "цієї",
        "цим",
        "цій",
        "цими",
        "цією",
        "цім",
        "ції",
        "цеє",
        "цюю",
        "цяя",
        "оцей",
        "оцього",
        "оці",
        "оцю",
        "оцьому",
        "оця",
        "оцих",
        "оцієї",
        "оцим",
        "оцій",
        "оцими",
        "оцією",
        "оцім",
        "оції",
        "оцеє",
        "оцюю",
        "оцяя",
        "тим",
        "ті",
        "тих",
        "тій",
        "тієї",
        "тім",
        "тої",
        "тими",
        "тією",
        "тії",
        "тою",
        "тая",
        "тую",
        "теє",
        "сей",
        "се",
        "сього",
        "сім",
        "ся",
        "сих",
        "сю",
        "сі",
        "сьому",
        "сій",
        "сієї",
        "сими",
        "сією",
        "що",
        "чого",
        "чому",
        "чим",
        "чім",
        "щось",
        "щось",
        "чогось",
        "чомусь",
        "чимось",
        "чимсь",
        "чімсь",
        "хто",
        "кім",
        "хтось",
        "когось",
        "комусь",
        "кимось",
        "ніщо",
        "нічого",
        "нічим",
        "нічого",
        "нічому",
        "ніхто",
        "ніхто",
        "нікого",
        "нікому",
        "ніким",
        "нікім",
        "всі",
        "всіх",
        "всього",
        "всім",
        "всьому",
        "всій",
        "всіма",
        "всієї",
        "всією",
        "всієї",
        "всією",
        "ввесь",
        "усе",
        "усі",
        "усіх",
        "усім",
        "увесь",
        "усього",
        "усю",
        "усіма",
        "уся",
        "усьому",
        "усієї",
        "усією",
        "усій",
        "який",
        "які",
        "яка",
        "якого",
        "яку",
        "яких",
        "яке",
        "яким",
        "якої",
        "якому",
        "якій",
        "якою",
        "якими",
        "якім",
        "ніякий",
        "ніяка",
        "ніяке",
        "ніякі",
        "ніякого",
        "ніякому",
        "ніяким",
        "ніякої",
        "ніякій",
        "ніякою",
        "ніяких",
        "іякими",
        "самий",
        "сама",
        "самі",
        "самого",
        "само",
        "самому",
        "самим",
        "самої",
        "самих",
        "саму",
        "самій",
        "самою",
        "самими",
        "самім",
        "такий",
        "таке",
        "така",
        "такі",
        "таку",
        "такої",
        "такій",
        "такім",
        "якийсь",
        "якусь",
        "якась",
        "якісь",
        "якогось",
        "якесь",
        "якоїсь",
        "якоюсь",
        "якимсь",
        "якихось",
        "якомусь",
        "якимось",
        "якійсь",
        "якимись",
        "якімсь",
        "якімось",
        "бути",
        "є",
        "був",
        "була",
        "було",
        "були",
        "бути",
        "будеш",
        "буде",
        "будемо",
        "будете",
        "будуть",
        "будьмо",
        "ото",
        "якраз",
        "ледве",
        "майже",
        "нехай",
        "отак",
        "еге",
        "авжеж",
        "атож",
        "невже",
        "хіба",
        "мовби",
        "немов",
        "наче",
        "неначе",
        "начебто",
        "ніби",
        "нібито",
        "ж",
        "же",
        "би",
        "б",
        "і",
        "й",
        "або",
        "мене",
        "мені",
        "ти",
        "тобі",
        "він",
        "його",
        "нього",
        "йому",
        "ньому",
        "нім",
        "її",
        "неї",
        "їй",
        "ній",
        "воно",
        "ви",
        "їх",
        "їм",
        "собі"};

    struct TStopWords {
        TStopWords() {
            for (auto i : StopWordsRaw) {
                StopWordsUTF8.insert(i);
                StopWordsWide.insert(UTF8ToWide(i));
            }
        }

        static const TStopWords* Instance() {
            return Singleton<TStopWords>();
        }

        THashSet<TString> StopWordsUTF8;
        THashSet<TUtf16String> StopWordsWide;
    };

}

bool IsStopWord(const TString& word) {
    return TStopWords::Instance()->StopWordsUTF8.contains(word);
}

bool IsStopWord(const TUtf16String& word) {
    return TStopWords::Instance()->StopWordsWide.contains(word);
}
