#pragma once

#include "string.h"

#include <library/cpp/yt/misc/enum.h>

#include <optional>

namespace NYT {

////////////////////////////////////////////////////////////////////////////////

TString DecodeEnumValue(TStringBuf value);
TString EncodeEnumValue(TStringBuf value);

template <class T>
T ParseEnum(TStringBuf value);

template <class T>
void FormatEnum(TStringBuilderBase* builder, T value, bool lowerCase);

template <class T>
TString FormatEnum(T value, typename TEnumTraits<T>::TType* = nullptr);

////////////////////////////////////////////////////////////////////////////////

} // namespace NYT

#define ENUM_INL_H_
#include "enum-inl.h"
#undef ENUM_INL_H_
