package main

import (
	"bytes"
	"testing"

	"github.com/stretchr/testify/require"
)

const result = `// Code generated by a.yandex-team.ru/library/go/core/resource/cc DO NOT EDIT.
package main

import "a.yandex-team.ru/library/go/core/resource"

func init() {
	blob := []byte("foo")
	resource.InternalRegister("/foo", blob)
}

func init() {
	blob := []byte("")
	resource.InternalRegister("/empty", blob)
}

func init() {
	blob := []byte("\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01")
	resource.InternalRegister("15", blob)
}

func init() {
	blob := []byte("\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01")
	resource.InternalRegister("16", blob)
}

func init() {
	blob := []byte("\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01")
	resource.InternalRegister("17", blob)
}
`

func TestGenerate(t *testing.T) {
	var b bytes.Buffer

	blobs := [][]byte{
		[]byte("foo"),
		[]byte(""),
		bytes.Repeat([]byte{0x01}, 15),
		bytes.Repeat([]byte{0x01}, 16),
		bytes.Repeat([]byte{0x01}, 17),
	}

	generate(&b, "main", blobs, []string{"/foo", "/empty", "15", "16", "17"})

	require.Equal(t, result, b.String())
}
